<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'no', version '5.1'.
 *
 * @package     theme_essential
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alert1'] = 'Første varsel';
$string['alert2'] = 'Andre varsel';
$string['alert3'] = 'Tredje varsel';
$string['alert_general'] = 'Kunngjøring';
$string['alert_info'] = 'Informasjon';
$string['alert_warning'] = 'Advarsel';
$string['alertinfodesc'] = 'Gjør dine innstillinger for varslet';
$string['alertsdesc'] = 'Dette vil vise et varsel (eller flere) i tre forskjellige stiler for dine brukere på Moodles forside. Vennligst husk å deaktivere dette når du ikke trenger varselet lenger.';
$string['alertsheading'] = 'Brukervarsler';
$string['alertsheadingsub'] = 'Viser viktige meldinger på forsiden til brukerne dine';
$string['alerttext'] = 'Varselstekst';
$string['alerttextdesc'] = 'Dette er teksten som vises i varslet.';
$string['alerttitle'] = 'Tittel';
$string['alerttitledesc'] = 'Hovedtittel/overskrift for varslet ditt.';
$string['alerttype'] = 'Nivå';
$string['alerttypedesc'] = 'Angi et passende varselsnivå/type for å gi best mulig informasjon om viktighet til brukerne dine.';
$string['allclasses'] = 'Alle klasser';
$string['allcourses'] = 'Alle kurs';
$string['allmodules'] = 'Alle moduler';
$string['allunits'] = 'Alle enheter';
$string['alternativecolors'] = 'Alternative farger {$a}';
$string['alternativethemecolor'] = 'Alternative designfarger {$a}';
$string['alternativethemecolordesc'] = 'Hvilken farge skal designet ditt ha ved alternative designfarger {$a}.';
$string['alternativethemecolorname'] = 'Navn på alternativt fargeskjema {$a}';
$string['alternativethemecolornamedesc'] = 'Legg inn et forklarende navn for dette alternative fargeskjemaet';
$string['alternativethemecolors'] = 'Alternative designfarger';
$string['alternativethemecolorsdesc'] = 'Definér alternative designfarger som brukerne kan velge blant.';
$string['alternativethemehovercolor'] = 'Alternativ design hover farge {$a}';
$string['alternativethemehovercolordesc'] = 'Hvilken hoverfarge bør dine design ha for de alternative designfargene {$a}';
$string['alternativethemename'] = 'Navn på fargeskjema';
$string['alternativethemenamedesc'] = 'Angi et navn for ditt alternative fargeskjema';
$string['alternativethemetextcolor'] = 'Alternativ tekstfarge {$a}';
$string['alternativethemetextcolordesc'] = 'Angi alternativ tekstfarge {$a}';
$string['alternativethemeurlcolor'] = 'Alternativ lenkefarge {$a}';
$string['alternativethemeurlcolordesc'] = 'Angi alternativ lenkefarge {$a}';
$string['alwaysdisplay'] = 'Vis alltid';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'Angi en URL til mobil App på Google Play Store. Hvis du ikke har en av dine egne kanskje vurdere å linke til den offisielle Moodle Mobile app. (Https://play.google.com/store/apps/details?id=com.moodle.moodlemobile)';
$string['backtotop'] = 'Tilbake til toppen';
$string['badgepreferences'] = 'Innstillinger for utmerkelser';
$string['breadcrumbsimple'] = 'Enkelt';
$string['breadcrumbstyle'] = 'Brødsmulestil';
$string['breadcrumbstyled'] = 'Fancy';
$string['breadcrumbstyledesc'] = 'Her kan du endre utseendet til brødsmulestien';
$string['breadcrumbstylednocollapse'] = 'Fancy uten ekspanderende brødsmulesti';
$string['breadcrumbthin'] = 'Tynn';
$string['cachesused'] = 'Bufring aktivert';
$string['categoryiconcategory'] = 'Ikonet for kategorien: {$a->category}';
$string['categoryicondesc'] = 'Dersom aktivert vil dette la deg angi egne ikoner for hver kurskategori.';
$string['categoryiconheading'] = 'Kategori-ikoner';
$string['categoryiconheadingsub'] = 'Bruk ikoner for å representere dine kurskategorier';
$string['categoryiconinfo'] = 'Angi egendefinerte kurskategori-ikoner';
$string['categoryiconinfodesc'] = 'Skriv inn navnet på ikonet du ønsker å bruke.  Du finner en komplett liste over <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">Font-Awesome ikoner</a>. Bare skriv inn ikonnavnet etter "fa-".';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Essential</h2>
<p><img class="img-polaroid" src="essential/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>About Essential</h3>
<p>Essential er basert på Bootstrapdesignet, som ble laget for Moodle 2.5, med hjelp fra:<br>
Bas Brands, Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p>
<h3>Krediteringer for design</h3>
<p>Original forfatter: Julian Ridden<br>
Arbeid overtatt i juli 2014 av:<br>
Gareth J. Barnard<br>
David Bezemer<br>
Arbeid overtatt den 9. oktober 2014 av:<br>
Gareth J. Barnard<br>
</p>
<h3>Donasjoner</h3>
<p>Du får tilgang til dette designet gratis, og hvis du ønsker å vise en take for broken av designet, kan du vurdere en donjon gjennom:
<h4>PayPal</h4>
<p>Vennligst contact meg via min<a href="http://moodle.org/user/profile.php?id=442195" target="_blank">\'Moodle profile\'</a> for detailer side jeg er et individ og deemed ikke kan ha en "donasjon" / "Kjøp meg nå" - knapp under deres retningslinjer.</p>
<h4>Flattr</h4>
<a href="https://flattr.com/profile/gjb2048" target="_blank">
klikk her for donasjon.
</a>
<br>Donasjoner kan gi meg muligheten til å gi deg fler og bedre funksjoner på kortere tid.</p>
</div></div>';
$string['colordesc'] = 'Her kan du finne diverse innstilinger for å endre fargene som er brukt i dette designet.';
$string['colorheading'] = 'Farge';
$string['colorheadingsub'] = 'Angi farger benyttet i dette designet';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = 'Kontaktinformasjon';
$string['contactinfodesc'] = 'Skriv inn din kontaktinformasjon';
$string['copyright'] = 'Copyright';
$string['copyrightdesc'] = 'Navnet på din organisasjon';
$string['coursegrades'] = 'Kurskarakterer';
$string['courselistteachericon'] = 'Ikon for læreroversikten';
$string['courselistteachericondesc'] = 'Navnet på ikonet du ønsker å benytte, eller la feltet være tomt om du ikke ønsker et ikon. Listen over ikoner finnes <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">her</a>. Skriv inn det som står etter "fa-", f.eks. "star".';
$string['customcss'] = 'Egendefinert CSS';
$string['customcssdesc'] = 'All CSS-kode du legger til her vil bli lastet på alle sider og gjør det enklere for deg å tilpasse dette designet.';
$string['dbqueries'] = 'DB Lese/Skrive';
$string['dbtime'] = 'DB spørringstidspunkt';
$string['defaultcategoryicon'] = 'Standard kurskategori-ikoner';
$string['defaultcategoryicondesc'] = 'Angi et standard kurskategori-ikon';
$string['defaultcolors'] = 'Standardfarger';
$string['displayafterlogin'] = 'Vis bare etter innlogging';
$string['displaybeforelogin'] = 'Vis bare før innlogging';
$string['displaymycourses'] = 'Vis kurs brukeren er påmeldt';
$string['displaymycoursesdesc'] = 'Vis brukernes påmeldte kurs i den egendefinerte menyen';
$string['dontdisplay'] = 'Aldri vis';
$string['enablealert'] = 'Aktiver advarsler';
$string['enablealertdesc'] = 'Aktiver eller deaktiver varsler';
$string['enablealternativethemecolors'] = 'Aktiver alternative designfarger {$a}';
$string['enablealternativethemecolorsdesc'] = 'Dersom aktivert, vil brukerne kunne velge mellom alternative designfarger {$a}';
$string['enablecategoryicon'] = 'Aktiver kurskategori-ikoner';
$string['enablecategoryicondesc'] = 'Når aktivert vil du være i stand til å velge kategoriikoner etter å ha klikket på "Lagre endringer"';
$string['enablecustomcategoryicon'] = 'Aktiver egendefinerte kategoriikoner';
$string['extperfinfoheading'] = 'Utvidet prestasjonsinformasjon';
$string['facebook'] = 'Facebook URL';
$string['facebookdesc'] = 'Legg inn URL\'en til Facebooksiden din. (F.eks. https://www.facebook.com/mycollege)';
$string['fitvids'] = 'Bruk FitVids';
$string['fitvidsdesc'] = 'Aktiver FitVids (fitvidsja.com) to make your embedded videos responsive. Hvis FitVids er på og du ønsker å ekskludere en video, legg til class="fitvidsignore i iframe-koden som vises i HTML-modusen i teksteditoren.
For eksempel: \'<iframe class="fitvidsignore" width="420" height="315" src="//www.youtube.com/embed/enmEmym85xc" frameborder="0" allowfullscreen=""></iframe>\'.';
$string['fixedwidthnarrow'] = 'Fast bredde - Smal';
$string['fixedwidthnormal'] = 'Fast bredde - Normal';
$string['fixedwidthwide'] = 'Fast bredde - Vid';
$string['flickr'] = 'Flickr URL';
$string['flickrdesc'] = 'Legg inn URL\'en til Flickrsiden din. (F.eks http://www.flickr.com/photos/mycollege)';
$string['fontcharacterset'] = 'Ekstra tegnsett';
$string['fontcharactersetcyrillic'] = 'Kyrillisk';
$string['fontcharactersetcyrillicext'] = 'Kyrillisk utvidet';
$string['fontcharactersetdesc'] = 'Velg ekstra tegnsett for ulike språk.

Bruk av mange tegnsett kan føre til at Moodleportalen blir tregere, så velg kun de tegnsettene du faktisk behøver.';
$string['fontcharactersetgreek'] = 'Gresk';
$string['fontcharactersetgreekext'] = 'Gresk utvidet';
$string['fontcharactersetlatinext'] = 'Latinsk utvidet';
$string['fontcharactersetvietnamese'] = 'Vietnamesisk';
$string['fontfiles'] = 'Fontfiler';
$string['fontfilesdesc'] = 'Last opp fontfilene dine her';
$string['fontheadingdesc'] = 'Velg og skriv inn skrifttypene du øsnker å bruke på Moodleportalen.';
$string['fontheadingsub'] = 'Skrifttypeinnstillinger';
$string['fontnamebody'] = 'Tekstfont';
$string['fontnamebodydesc'] = 'Skriv inn det eksakte navnet på skrifttypen som skal brukes på all annen tekst';
$string['fontnameheading'] = 'Overskriftsfont';
$string['fontnameheadingdesc'] = 'Skriv inn det eksakte navnet på skrifttypen som skal brukes i overskriften.';
$string['fontselect'] = 'Skrifttypevelger';
$string['fontselectdesc'] = 'Velg fra listen over tilgjengelige skrifttyper. Vennligst lagre for å se innstillingene for ditt valg.';
$string['fontsettings'] = 'Skrifttype';
$string['fonttypecustom'] = 'Egendefinert skrifttype';
$string['fonttypegoogle'] = 'Google web skrifttyper';
$string['footercolor'] = 'Bakgrunnsfarge i bunntekst';
$string['footercolordesc'] = 'Bestem hvilken bakgrunnsfarge det skal være i bunntekstboksen.';
$string['footercolors'] = 'Farger i bunntekst';
$string['footercolorsdesc'] = 'Endre farger i bunnteksten';
$string['footerheading'] = 'Bunntekst';
$string['footerheadingcolor'] = 'Overskriftsfarge i bunntekst';
$string['footerheadingcolordesc'] = 'Sett fargen for blokkoverskrifter i bunnteksten.';
$string['footerhovercolor'] = 'Lenkefarge ved mouseover i bunnteksten.';
$string['footerhovercolordesc'] = 'Sett fargen for lenket tekst ved mouseover i bunnteksten.';
$string['footersepcolor'] = 'Skillefarge i bunnteksten';
$string['footersepcolordesc'] = 'Skilletegn er linjer som brukes til å separere innhold. Sett fargen her.';
$string['footertextcolor'] = 'Tekstfarge i bunntekst';
$string['footertextcolordesc'] = 'Sett fargen du ønsker at teksten i bunnteksten skal ha.';
$string['footerurlcolor'] = 'Lenkefarge i bunntekst';
$string['footerurlcolordesc'] = 'Sett fargen du ønsker at lenket tekst i bunnteksten skal ha.';
$string['footnote'] = 'Fotnote';
$string['footnotedesc'] = 'Det som skrives i dette tekstområdet vil vises i bunnteksten overalt på Moodleportalen.';
$string['frontcontent'] = 'Aktiver innholdsområde på forsiden';
$string['frontcontentarea'] = 'Innhold i innholdsområdet på forsiden';
$string['frontcontentareadesc'] = 'Det som skrives inn i denne boksen vil bli vist i full bredde mellom slideshowet og annonseringsplassene.';
$string['frontcontentdesc'] = 'Når aktivert, vil det være et område for egendefinert innhold mellom slideshowet og annonseringsplassene.';
$string['frontcontentheading'] = 'Innholdsområde på forsiden.';
$string['frontpageblocks'] = 'Plassering av forsideblokker';
$string['frontpageblocksdesc'] = 'Her kan du bestemme om Moodles standard forsideblokker skal vises til venstre eller høyre.';
$string['frontpageblocksheading'] = 'Forsideblokker';
$string['frontpageheading'] = 'Forside';
$string['frontpageheadingdesc'] = 'Konfigurer de ekstra elementene du ønsker å vise på forsiden.';
$string['frontpagemiddleblocks'] = 'Aktiver ekstra blokker midt på forsiden.';
$string['frontpagemiddleblocksdesc'] = 'Når aktivert vil det bli vist 3 ekstra blokker rett under annonseringsplassene.';
$string['fullname'] = 'Nettstedets fulle navn';
$string['fullnamesummary'] = 'Fullt navn og beskrivelse';
$string['generalheadingdesc'] = 'Konfigurer de generelle designinnstillinger her.';
$string['generalheadingsub'] = 'Generelle innstillinger';
$string['genericsettings'] = 'Generelt';
$string['googleplus'] = 'Google+ URL';
$string['googleplusdesc'] = 'Skriv inn URL\'en til din Google+ profil.';
$string['gotobottom'] = 'Gå til bunnen av siden';
$string['headerheading'] = 'Header';
$string['headertitle'] = 'Tittel på headeren';
$string['headertitledesc'] = 'Konfigurer hvilken tittel som skal vises i headeren.';
$string['helplink'] = 'Hjelpelenke';
$string['helplinkdesc'] = 'Hvis du velger en URL i feltet ovenfor, fyll inn den fullstendige URL\'en til hjelpesiden (må inneholde http:// eller https://), hvis du velger en epostadresse skriver du inn den.';
$string['helplinktype'] = 'Aktiver hjelpelenke i menyen';
$string['helplinktypedesc'] = 'Velg om du ønsker å inkludere et valg for hjelp i brukermenyen. Du kan velge mellom å oppgi en URL til en nettsiden eller en epostadresse.';
$string['hideonphone'] = 'Skjul slideshow på mobil';
$string['hideonphonedesc'] = 'Velg om du ønsker å deaktivere slideshow på mobil.';
$string['hideontablet'] = 'Skjul slideshow på nettbrett';
$string['hideontabletdesc'] = 'Velg om du ønsker å deaktivere slideshow på nettbrett.';
$string['included'] = 'Inkluderte filer';
$string['instagram'] = 'Instagram URL';
$string['instagramdesc'] = 'Skriv inn URL\'en til instagramsiden din.';
$string['ios'] = 'iPhone/iPAd (App store)';
$string['iosdesc'] = 'Oppgi en URL til appen din i APP Store. Hvis du ikke har en egen app, kan du vurdere å lenke til den offisielle Moodle Mobile appen (https://itunes.apple.com/en/app/moodle-mobile/id633359593).';
$string['iosicon'] = 'iOS hjem ikon';
$string['iosicondesc'] = 'Designet har stanard hjem-ikoner og iOS og Android brukere. Du kan laste opp egne ikoner om du ønsker.';
$string['ipadicon'] = 'iPad-ikon (Ikke retina)';
$string['ipadicondesc'] = 'Ikoner skal være png-filer med størrelse 72x72 piksler.';
$string['ipadretinaicon'] = 'iPad-icon (Retina)';
$string['ipadretinaicondesc'] = 'Ikoner skal være png-filer med størrelse 144x144 piksler.';
$string['iphoneicon'] = 'iPhone/iPod Touch ikon (Ikke Retina)';
$string['iphoneicondesc'] = 'Ikoner skal være png-filer med størrelse 57x57 piksler.';
$string['iphoneretinaicon'] = 'iPhone/iPod Touch ikon (Retina)';
$string['iphoneretinaicondesc'] = 'Ikoner skal være png-filer med størrelse 114x114 piksler.';
$string['layout'] = 'Bruk standard kursutseende';
$string['layoutdesc'] = 'Dette designet er laget for å vise begge blokkkolonnene på samme side. Hvis du foretrekker det vanlige kursutseendet, kan du krysse av i denne boksen for å returnere til den vanlige og kjedelige visningen med tre kolonner.';
$string['left'] = 'Venstre';
$string['linkedin'] = 'Linkedin URL';
$string['linkedindesc'] = 'Skriv inn URL\'en til din Linkedin profil.';
$string['loadtime'] = 'Lastetid';
$string['loggedinas'] = 'logget inn som';
$string['loggedinfrom'] = 'Logget inn fra';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Vennligst last opp din egen logo her om du ønsker å legge den til i headeren.
<br>Logoen bar være 65px høy og ha en fornuftig og passende bredde.
                       <br>Hvis du laster opp en logo vil den erstatte standardikonet og navnet som ble vist som standard.';
$string['marketing1'] = 'Annonseringsplass 1';
$string['marketing2'] = 'Annonseringsplass 2';
$string['marketing3'] = 'Annonseringsplass 3';
$string['marketingbuttontext'] = 'Lenketekst';
$string['marketingbuttontextdesc'] = 'Tekst for visning på knappen.';
$string['marketingbuttonurl'] = 'LenkeURL';
$string['marketingbuttonurldesc'] = 'URL\'en knappen vil peke på.';
$string['marketingcontent'] = 'Innhold';
$string['marketingcontentdesc'] = 'Innhold i annonseringsboksen. Hold den kort og fin.';
$string['marketingdesc'] = 'Dette designet tilbyr muligheten til å vise 3 annonseringsplasser rett under slideshowet på forsiden. Dette gir deg muligheten til å vise brukerne den viktigste informasjonen på en god måte.';
$string['marketingheading'] = 'Annonseringsplasser';
$string['marketingheadingsub'] = 'Tre steder på forsiden for å legge til informasjon og lenker';
$string['marketingheight'] = 'Høyde på annonseringsbilder';
$string['marketingheightdesc'] = 'Hvis du ønsker å vise bilder i annonseringsplassene, kan du spesifisere bildehøyden her.';
$string['marketingicon'] = 'Ikon';
$string['marketingicondesc'] = 'Navnet på ikonet du ønsker å bruke. Listen over tilgjengelige ikoner er <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">her</a>. Skriv inn det som står etter "fa-".';
$string['marketingimage'] = 'Bilde';
$string['marketingimagedesc'] = 'Dette gir en mulighet til å vise et bilde over teksten i annonseringsplassene.';
$string['marketinginfodesc'] = 'Innstillinger for annonseringsplassene.';
$string['marketingtitle'] = 'Tittel';
$string['marketingtitledesc'] = 'Tittelen som skal vise på denne annonseringsplassen.';
$string['marketingurltarget'] = 'Lenkens mål';
$string['marketingurltargetdesc'] = 'Velg hvordan lenken skal åpnes';
$string['marketingurltargetnew'] = 'Nytt vindu';
$string['marketingurltargetparent'] = 'Ny fane';
$string['marketingurltargetself'] = 'Denne siden';
$string['memused'] = 'Brukt minne';
$string['mobileappsdesc'] = 'Har du en app i App Store eller Google Play Store? Oppgi en lenke så brukerne kan få tak i appen din.';
$string['mobileappsheading'] = 'Apper';
$string['myclasses'] = 'Mine klasser';
$string['mycourses'] = 'Mine kurs';
$string['mycoursesinfo'] = 'Meny for påmeldte kurs';
$string['mycoursetitle'] = 'Terminologi';
$string['mygrades'] = 'Mine karakterer';
$string['mymodules'] = 'Mine moduler';
$string['myunits'] = 'Mine enheter';
$string['nextsection'] = 'Neste seksjon';
$string['nobreadcrumb'] = 'Skjul';
$string['noenrolments'] = 'Du er for tiden ikke påmeldt noen kurs';
$string['numberofslides'] = 'Antall slides';
$string['numberofslides_desc'] = 'Antallet slides i slideshowet.';
$string['pagebackground'] = 'Sidens bakgrunnsbilde';
$string['pagebackgrounddesc'] = 'Last opp ditt eget bakgrunnsbilde. Velg bildestil nedenfor.';
$string['pagebackgroundstyle'] = 'Bakgrunnsbildestil';
$string['pagebackgroundstyledesc'] = 'Velg stil for opplastet bilde.';
$string['pagewidth'] = 'Sett sidebredden';
$string['pagewidthdesc'] = 'Velg fra listen over tilgjengelige sidebredder for nettstedet ditt.';
$string['paypal_click'] = 'Moodleprofil';
$string['perf_max'] = 'Detaljert';
$string['perf_min'] = 'Minimal';
$string['perfinfo'] = 'Prestasjonsinformasjonsmodus';
$string['perfinfoheading'] = 'Prestasjonsinformasjon';
$string['pinterestdesc'] = 'Skriv inn URL\'en til Pinterestsiden din.';
$string['pluginname'] = 'Essential';
$string['previoussection'] = 'Forrige seksjon';
$string['readme_click'] = 'klikk for README.txt';
$string['readme_desc'] = 'Vennligst gå til {$a->url} for mer informasjon om Essentialdesignet.';
$string['readme_title'] = 'Readme for Essential-designet';
$string['readmore'] = 'Les mer';
$string['region-footer-left'] = 'Bunntekst (Venstre)';
$string['region-footer-middle'] = 'Bunntekst (Midten)';
$string['region-footer-right'] = 'Bunntekst (Høyre)';
$string['region-hidden-dock'] = 'Skjult for brukere';
$string['region-side-post'] = 'Høyre';
$string['region-side-pre'] = 'Venstre';
$string['right'] = 'Høyre';
$string['serverload'] = 'Server load';
$string['sessionsize'] = 'Sesjonslengde';
$string['shortname'] = 'Nettstedets kortnavn';
$string['shortnamesummary'] = 'Kortnavn og beskrivelse';
$string['siteicon'] = 'Nettstedsikon';
$string['siteicondesc'] = 'Har du ikke en logo? Skriv inn navnet på ikonet du ønsker å bruke. Listen over tilgjengelige ikoner er <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">her</a>. Skriv inn det som står etter "fa-".';
$string['skype'] = 'Skypekonto';
$string['skypedesc'] = 'Skriv inn brukernavnet organisasjonen din har på Skype.';
$string['slidebuttoncolor'] = 'Farge på slidekanpp';
$string['slidebuttoncolordesc'] = 'Hvilken farge slideknappen skal ha.';
$string['slidebuttonhovercolor'] = 'Farge på slideknapp ved mouseover';
$string['slidebuttonhovercolordesc'] = 'Hvilken farge slideknappen skal ha ved mouseover.';
$string['slidecaption'] = 'Bildetekst på slide';
$string['slidecaptionbelow'] = 'Bildetekst for slide under bildet';
$string['slidecaptionbelowdesc'] = 'Om bildeteksten for sliden skal vises under bildet';
$string['slidecaptionbeside'] = 'Ved siden av';
$string['slidecaptioncentred'] = 'Midtstill slidens bildetekst';
$string['slidecaptioncentreddesc'] = 'Hvis bildeteksten skal midtstilles';
$string['slidecaptiondesc'] = 'Skriv inn bildetekst for denne sliden';
$string['slidecaptionontop'] = 'På toppen';
$string['slidecaptionoptions'] = 'Innstillinger for slidens bildetekst';
$string['slidecaptionoptionsdesc'] = 'Hovr bildeteksten skal vises i forhold til bildet.';
$string['slidecaptionunderneath'] = 'Nedenfor';
$string['slidecolor'] = 'Bildetekstfarge';
$string['slidecolordesc'] = 'Hvilke farge bildeteksten ska ha.';
$string['slideimage'] = 'Bilde på slide';
$string['slideimagedesc'] = 'Transparente bilder fungerer best.';
$string['slideinterval'] = 'Intervall for slides';
$string['slideintervaldesc'] = 'Tidsintervall for slides i millisekunder';
$string['slideno'] = 'Slide {$a->slide}';
$string['slidenodesc'] = 'Legg til innstillinger for sliden {$a->slide}.';
$string['slideshowdesc'] = 'Dette lager et dynamisk slideshow på opptil 16 slides, som du kan bruke til å promotere viktige elementer for nettstedet ditt. Slideshowet er responsivt, og bildehøyde settes i forhold til skjermstørrelsen. Anbefalt høyde er 300px. Bredden settes til 100%, og derfor vil den faktiske høyden bli mindre når bredden på bildet er større enn skjermstørrelsen. På mindre skjermer blir høyden redusert dynamisk uten at det er behov for å legge til flere bilder.

Referansetabell

Skjermbredde <767px = høyde på 165px,
Skjermbredde >767px og <979px = høyde på 225px,
skjermbredde <979px = høyde på 300px.

Dersom ingen bilder er valgt for slideshowet, vil default_slide bildet i bildemappen bli brukt.';
$string['slideshowheading'] = 'Slideshow';
$string['slideshowheadingsub'] = 'Dynamisk slideshow for forsiden';
$string['slidetitle'] = 'Slidetittel';
$string['slidetitledesc'] = 'Skriv inn en beskrivende tittel for sliden';
$string['slideurl'] = 'Slidelenke';
$string['slideurldesc'] = 'Legg inn målet for slidens bildelenke';
$string['slideurltarget'] = 'Lenkemål';
$string['slideurltargetdesc'] = 'Velg hvordan lenken skal åpnes';
$string['slideurltargetnew'] = 'Ny side';
$string['slideurltargetparent'] = 'Ny fane';
$string['slideurltargetself'] = 'Denne siden';
$string['socialdesc'] = 'Oppgi direkte lenker til de viktigste sosiale nettverkene som promoterer merket ditt. Disse vil vises i headeren på hver side.';
$string['socialheading'] = 'Sosiale nettverk';
$string['socialheadingsub'] = 'Engasjer dine brukere med sosiale nettverk';
$string['socialnetworks'] = 'Sosiale nettverk';
$string['themecolor'] = 'Designfarge';
$string['themecolordesc'] = 'Hvilken farge det skal være på designet. Dette være endre på flere komponenter slik at du kan bruke de fargene du ønsker over hele Moodlesiden.';
$string['themecolors'] = 'DEsignfarger';
$string['themehovercolor'] = 'Designet farge for mouseover';
$string['themehovercolordesc'] = 'Hvilken farge det skal være for mouseover. Dette brukes i forbindelse med lenker, menyer osv.';
$string['themeiconcolor'] = 'Ikonfarge';
$string['themeiconcolordesc'] = 'Bestem fargen for alle ikoner';
$string['themenavcolor'] = 'Navigasjonsfarge';
$string['themenavcolordesc'] = 'Bestem fargen for navigasjon. Brukes i brødsmuleteksten og navigasjonsbaren.';
$string['themetextcolor'] = 'Tekstfarge';
$string['themetextcolordesc'] = 'Sett fargen for tekst.';
$string['themeurlcolor'] = 'Lenkefarge';
$string['themeurlcolordesc'] = 'Sett fargen for lenket tekst.';
$string['togglemarketing'] = 'Aktiver visning av annonseringsplasser';
$string['togglemarketingdesc'] = 'Velg om du ønsker å vise eller skjule de tre annonseringsplassene.';
$string['toggleslideshow'] = 'Aktiver visning av slideshow';
$string['toggleslideshowdesc'] = 'Velg om du ønsker å vise eller skjule slideshowet.';
$string['twitter'] = 'Twitter URL';
$string['twitterdesc'] = 'Skriv inn URL\'en for Twitterfeeden din.';
$string['variablewidth'] = 'Variabel bredde';
$string['visibleadminonly'] = 'Blokker som flyttes til dette området er bare synlig for administratorer';
$string['vk'] = 'VKontakte URL';
$string['vkdesc'] = 'Skriv inn URL\'en til din VKontakte-side.';
$string['website'] = 'Hjemmeside URL';
$string['websitedesc'] = 'Skriv inn URL\'en til din egen hjemmeside.';
$string['youtube'] = 'Yourtube URL';
$string['youtubedesc'] = 'Skriv inn URL\'en for Youtubekanalen din.';
