<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'cachestore_memcached', language 'no', version '5.1'.
 *
 * @package     cachestore_memcached
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['bufferwrites'] = 'Buffer writes';
$string['bufferwrites_help'] = 'Aktiverer eller deaktiverer bufret I / O. Aktivering av bufret I / O fører lagring kommandoer til "buffer" i stedet for å bli sendt. Enhver handling som henter data medfører at bufferen som sendes til den eksterne tilkoblingen. Avslutning av tilkoblingen eller stengning av forbindelsen vil også føre til at bufrede data  blir sendt  til den eksterne tilkoblingen.';
$string['clustered'] = 'Aktiver clustrede servere';
$string['clustered_help'] = 'Dette er brukes til å angi funksjonalitet for å tillate les-en-gang, angi multi.

Hensikten er å opprette et forbedret filområde for lastbalanserte konfigurasjoner.  Filområdet vil fetche fra en server (vanligvis localhost),  men hvis satt til mange (alle servere i lastbalansererpoolen). For mellomlagre med meget høye les-ratios, kan dette gi signifikant besparelse i netverk overhead.

Når denne innstillingen er aktivert vil serven angitt over bli brukt som kilde til fetchingen.';
$string['clusteredheader'] = 'Splitt servere';
$string['hash'] = 'Hash-metode';
$string['hash_crc'] = 'CRC';
$string['hash_default'] = 'Standard (en om gangen)';
$string['hash_fnv1_32'] = 'FNV1_32';
$string['hash_fnv1_64'] = 'FNV1_64';
$string['hash_fnv1a_32'] = 'FNV1A_32';
$string['hash_fnv1a_64'] = 'FNV1A_64';
$string['hash_help'] = 'Angir hash-algoritmen for elementnøkler. Hver hash-algoritme har sine fordeler og ulemper. Bruk standardvalget om du ikke vet hvordan de virker.';
$string['hash_hsieh'] = 'Hsieh';
$string['hash_md5'] = 'MD5';
$string['hash_murmur'] = 'Murmur';
$string['isshared'] = 'Delt mellomlager';
$string['isshared_help'] = 'Brukes din memcached server også av andre applikasjoner?

Hvis mellomlageret er delt mellom flere applikasjoner, vil hver nøkkel bli slettet individuelt for å sikre at kun data som eies av applikasjonen blir tømt. (Data fra andre applikasjoner forblir uendret). Dette kan resultere i dårligere ytelse mens tømmingen foregår - avhengig av serverkonfigurasjonen.

Hvis du kjører en dedikert cache for denne applikasjonen kan du trygt tømme den uten risiko for å ødelegge andre applikasjoners mellomlagrede data. Dette bør resultere i økt ytelse under tømmingen av mellomlageret.';
$string['pluginname'] = 'Memcached';
$string['prefix'] = 'Prefix key';
$string['prefix_help'] = 'Dette kan brukes til å lage en "domene" for dine elementnøkler, og dette lar deg opprette multiple memcache lagringer på en enkelt memcache installasjon. Den kan ikke være lenger enn 16 tegn for å sikre at du ikke får problemer med nøkkellengden.';
$string['prefixinvalid'] = 'Ugyldig prefiks. Du kan bare bruke  a-z A-Z 0-9-_.';
$string['privacy:metadata:memcached'] = 'Modulen "Memcache cachestore" lagrer data i kort tid som en del av sin mellomlagringsfunksjonalitet. Dataene lagres på en Memcacheserver der data regelmessig blir fjernet.';
$string['privacy:metadata:memcached:data'] = 'De ulike dataene lagret i cachen.';
$string['serialiser_igbinary'] = 'Igbinary serialisatortillegg';
$string['serialiser_json'] = 'JSON serialisatortillegg';
$string['serialiser_php'] = 'Standard PHP serialisatortillegg';
$string['servers'] = 'Servere';
$string['servers_help'] = 'Dette angir de serverne som skal tilpasses med dette memcached adapteret.
Serverne må angis linje for linje og bestå av serveradresse og du kan også angi port og vekting.
Hvis du ikke oppgir portnummer brukes standardporten (11211).

F.eks:
<pre>
server.url.com
ipaddress:port
servername:port:weight
</pre>

Dersom *Aktiver clustrede servere" er aktivert under, må bare EN server angis her. Dette vil vanligvis være navnet som alltid peker til lokal maskin, som 127.0.0.1 eller localhost.';
$string['serversclusterinvalid'] = 'Eksakt en server er obligatorisk når cluster er aktivert.';
$string['sessionhandlerconflict'] = 'Advarsel: En memcache ({$a}) er konfigurert til å bruke samme memcached server til sesjonshåndtering. Hvis du tømmer mellomlageret vil derfor alle brukersesjonene blir slettet og brukerne må logge inn på nytt.';
$string['setservers'] = 'Angi servere';
$string['setservers_help'] = 'Dette er listen med servere som vil oppdateres når data i mellomlageret endres. Generally the fully qualified name of each server in the pool.
Listen **MÅ** inneholde serveren oppgitt under *Servere* ovenfor, selv om den har er annet vertsnavn,
Servere bør defineres en per linje og består av en server adresse og eventuelt en port og vekt.
Hvis ingen port er gitt så skal standard port (11211) brukes.

For eksempel:
<pre>
server.url.com
ipaddress:port
servername:port:weight
</pre>';
$string['testservers'] = 'Testservere';
$string['testservers_desc'] = 'En eller flere tilkoblingsstrenger for memcache servere å teste mot. Hvis en testserver er angitt, kan memcache-ytelsen testes ved å bruke mellomlager-ytelsessiden i Administrator-blokka.
Som et eksempel: 127.0.0.1:11211';
$string['upgrade200recommended'] = 'Vi anbefaler at du oppgraderer Memcached PHP-tillegget til versjon 2.0.0 eller høyere. Versjonen du bruker har ikke den funksjonaliteten som trengs for sandboxing av mellomlageret. Inntil du oppgraderer anbefaler vi å ikke konfigurere noen andre applikasjoner til å bruke samme Memcached server.';
$string['usecompression'] = 'Bruk kompresjon';
$string['usecompression_help'] = 'Aktiverer eller deaktiverer nyttelast-komprimering. Når aktivert, vil elementverdier lenger enn en viss terskel (for tiden 100 bytes) transparent komprimeres under lagring og dekomprimert under henting.';
$string['useserialiser'] = 'Bruk serialiser';
$string['useserialiser_help'] = 'Angir serialisatortillegg å bruke for serieomkoding av ikke-skalerbare verdier.
De gyldige serializers er memcached :: SERIALIZER_PHP eller memcached :: SERIALIZER_IGBINARY.
Sistnevnte støttes kun når memcached er konfigurert med - enable-memcached-igbinary-alternativet og igbinary-utvidelsen er lastet.';
