<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'no', version '5.1'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Ingen tilgang';
$string['accountlocked'] = 'Kontoen din er låst. En opplåsingslenke er sendt til e-postadressen knyttet til kontoen din.';
$string['accounts'] = 'Kontoer';
$string['accountunlocked'] = 'Kontoen din har blitt låst opp. Du kan nå logge på nedenfor.';
$string['addcategory'] = 'Legg til en kategori';
$string['additionalhtml'] = 'Ekstra HTML';
$string['additionalhtml_desc'] = 'Disse innstillingene lar deg skrive HTML-kode du vil legge til på alle sider. Du kan legge inn HTML innenfor HEAD-taggen for siden, straks etter at BODY taggen er åpnet, eller straks før BODY-taggen lukkes.<br />Dette åpner for egendefinert topp- og bunntekst på alle sider eller legge til støtte for f.eks. Google Analytics samme hvilket design som brukes.';
$string['additionalhtml_heading'] = 'Ekstra HTML som skal legges til å alle sider.';
$string['additionalhtmlfooter'] = 'Før BODY-taggen lukkes';
$string['additionalhtmlfooter_desc'] = 'Innhold plassert her vil bli lagt til på alle sider rett før BODY-taggen lukkes.';
$string['additionalhtmlhead'] = 'Innenfor HEAD';
$string['additionalhtmlhead_desc'] = 'Innhold plassert her vil bli lagt til i bunnen av HEAD-taggen på alle sider.';
$string['additionalhtmltopofbody'] = 'Når BODY-taggen åpnes';
$string['additionalhtmltopofbody_desc'] = 'Innhold plassert her blir lagt til på alle sider rett etter innledende BODY-tagg.';
$string['admincategory'] = 'Kategori: {$a}';
$string['adminseesall'] = 'Administratorer ser alt';
$string['adminseesallevents'] = 'Administratorer ser alle hendelser';
$string['adminseesownevents'] = 'Administratorer er som alle andre brukere';
$string['advancedfeatures'] = 'Avanserte funksjoner';
$string['agedigitalconsentverification'] = 'Bekreftelse av alder for samtykke';
$string['agedigitalconsentverification_desc'] = 'Aktiverer bekreftelse av alder for samtykke før visningen av registreringssiden for egenregistrerte brukere. Dette beskytter portalen din fra mindreårige som registrerer seg uten foresattes samtykke. <a target="_blank" href="{$a}">Kontakt support</a> mer informasjon for mindreårige for mer assistanse.';
$string['ageofdigitalconsentmap'] = 'Alder for samtykke';
$string['ageofdigitalconsentmap_desc'] = 'Standard alder for samtykke og alder for samtykke i land som ikke benytter standardalderen kan spesifiseres her. Skriv inn hver alder på egen linje med følgende format: landkode, alder (separert med komma). Standardalderenindikeres med * i stedet for landkoden. Landkoder er de samme som i ISO 3166-2.';
$string['allcountrycodes'] = 'Alle landskoder';
$string['allowattachments'] = 'Tillat vedlegg';
$string['allowbeforeblock'] = 'Tillatte lister vil bli prosessert først';
$string['allowbeforeblockdesc'] = 'Som standard vil oppføringer i IP-sperrelista bli sjekket først. Dersom dette valget er aktivt, vil oppføringer i lista over godkjente IP-adresser bli prosessert før sperrelista.';
$string['allowcategorythemes'] = 'Tillat katagoridesign';
$string['allowcohortthemes'] = 'Tillat kohortdesign';
$string['allowcoursethemes'] = 'Tillat egne kursdesign';
$string['allowedemaildomains'] = 'Tillatte epostdomener';
$string['allowediplist'] = 'Liste over godkjente IP-adr.';
$string['allowemailaddresses'] = 'Tillatte epost domener';
$string['allowemojipicker'] = 'Emoji-velger';
$string['allowframembedding'] = 'Tillat innebygging av rammer';
$string['allowframembedding_help'] = 'Tillat at denne portalen bygges inn i rammer på eksterne portalen, noe som anbefales når en publiseres via LTI. Utenom dette er aktivering av denne funksjonen ikke anbefalt av sikkerhetsgrunnner.

Merk at denne innstillingen ikke påvirker Moodle Mobile siden innbygging i rammer alltid er tillatt der.';
$string['allowguestmymoodle'] = 'Tillat gjestetilgang til Dashbord';
$string['allowindexing'] = 'Tillat indeksering av søkemotorer';
$string['allowindexing_desc'] = 'Dette bestemmer om søkemotorer skal få tilgang til å indeksere portalen.. "Overalt vil tillate at søkemotorene søker overalt inkludert innlogging- og registreringssidene, noe som betyr at portalen med "Tving innlogging" likevel blir indeksert.

For å unngå risikioen med spam som kommer av at registreringssiden er inkludert i indeksering bruk "Over alt unntatt innlogging- og registreringssidene". "Ingen steder" vil be søkemotorene om å ikke indeksere, men dette er bare en tag i headeren og det er opp til søkemotoren å respektere dette.';
$string['allowindexingeverywhere'] = 'Overalt';
$string['allowindexingexceptlogin'] = 'Overalt unntatt innloggings- og registreringssiden';
$string['allowindexingnowhere'] = 'Ingen steder';
$string['allowobjectembed'] = 'Tillat EMBED og OBJECT tagger';
$string['allowthemechangeonurl'] = 'Tillat design-skifte via URL';
$string['allowuserblockhiding'] = 'Tillat brukerne å skjule blokker';
$string['allowusermailcharset'] = 'Tillat brukerne å velge eget tegnsett';
$string['allowuserswitchrolestheycantassign'] = 'Tillat at brukere med begrensede rettigheter kan bytte roller';
$string['allowuserthemes'] = 'Tillat brukeren å velge design';
$string['alternativefullnameformat'] = 'Alternativt fullt navn format';
$string['alternativefullnameformat_desc'] = 'Dette definerer hvordan navn blir vist for brukere med viewfullnames rettigheten (som standard er dette rollene leder, lærer og gjestelærer) Plassholdere som kan brukes er de samme som for "Fullt navneformat"-innstillingen.';
$string['always'] = 'Alltid';
$string['appearance'] = 'Visning';
$string['aspellpath'] = 'Sti til Aspell stavekontroll';
$string['asyncbackupdisabled'] = 'Denne portalen er satt opp til å benytte synkronisert sikkerhetskopiering. Asynkron sikkerhetskopiering gir en bedre brukeropplevelse.
Asynkron sikkerhetskopiering vil aktiveres for alle portaler fra Moodle LMS 4.5 LTS.
Synkron sikkerhetskopiering vil fjerne for alle portaler etter Moodle LMS 4.5 LTS.';
$string['authentication'] = 'Autentisering';
$string['authpreventaccountcreation'] = 'Forhindre opprettelse av konto mens autentisering pågår';
$string['authpreventaccountcreation_help'] = 'Når en bruker autentiseres lages det automatisk en brukerkonto hvis den ikke finnes fra før. Dersom det brukes en ekstern database, som f.eks. LDAP, og du ønsker å begrense tilgangen til brukere som bare finnes i denne databasen, må du aktivere dette valget. Nye brukerkontoer må da lages manuelt eller via opplasting fra fil. Merk at denne innstillingen ikke har noen effekt på MNET-autentiseringen.';
$string['authsettings'] = 'Administrer autentisering';
$string['autolang'] = 'Autodetekter språk';
$string['autolangusercreation'] = 'Bruk det språket som automatisk oppdages fra brukerens nettleser under oppretting av brukere';
$string['autologinguests'] = 'Logg inn gjester automatisk';
$string['availableto'] = 'Tilgjengelig til';
$string['availabletoanyone'] = 'Tilgjengelig for alle som besøker portalen';
$string['availabletoauthenticated'] = 'Begrens til autentiserte brukere';
$string['backgroundcolour'] = 'Gjennomsiktig farge';
$string['backup_shortname'] = 'Bruk kursnavnet i sikkerhetskopifilnavnet';
$string['backup_shortnamehelp'] = 'Bruk kursnavnet som en del av sikkerhetskopifilnavnet';
$string['backups'] = 'Sikkerhetskopier';
$string['badwordsconfig'] = 'Legg inn liste over fyord adskilt med komma';
$string['badwordsdefault'] = 'Hvis spesialtilpasset pakke er tom, vil en standardpakke fra språkpakken brukes.';
$string['badwordslist'] = 'Spesialtilpasset pakke for fyord';
$string['blockediplist'] = 'IP sperreliste';
$string['blockinstances'] = 'Hendelser';
$string['blockmultiple'] = 'Flere';
$string['blockprotect'] = 'Beskytt instanser';
$string['blockprotect_help'] = 'Dersom du låser en bestemt blokk vil ingen kunne legge til eller slette instanser av denne blokken. (Du kan selvsagt låse opp igjen for å redigere blokken)

Denne funksjonen har til hensikt å beskytte blokker som navigasjon og innstillinger som kan være veldig vanskelig å gjenopprette om de blir slettet ved et uhell.';
$string['blockprotectblock'] = 'Beskytt instanser av {$a}';
$string['blockprotected'] = 'Instanser av blokken {$a} er nå beskyttet';
$string['blocksettings'] = 'Administrer blokker';
$string['blockunprotectblock'] = 'Fjern beskyttelsen for instanser av {$a}';
$string['blockunprotected'] = 'Instanser av blokken {$a} er ikke lenger beskyttet';
$string['bloglevel'] = 'Synlighet av blogg';
$string['bookmarkadded'] = 'Bokmerke er lagt til';
$string['bookmarkalreadyexists'] = 'Du har allerede bokmerket denne siden';
$string['bookmarkdeleted'] = 'Bokmerket er slettet';
$string['bookmarkthispage'] = 'Bokmerk denne siden';
$string['cacheapplication'] = 'Programmellomlager';
$string['cacheapplicationhelp'] = 'Mellomlagrede elementer er delt mellom alle brukere og utløper etter en bestemt tid.';
$string['cachejs'] = 'Cache Javascript';
$string['cachejs_help'] = 'Javaskript mellomlagring og komprimering gir bedre brukeropplevelse siden sider lastes raskere. Vi anbefaler sterkt dette for produksjonsportaler. Utviklere vil derimot ofte slå av funksjonen.';
$string['cacherequest'] = 'Mellomlager for forespørsler';
$string['cacherequesthelp'] = 'Brukerspesifikk mellomlager som slettes når forespørselen er fullført. Designet for å erstatte områder hvor vi bruker statisk lagring.';
$string['cachesession'] = 'Sesjons-mellomlager';
$string['cachesessionhelp'] = 'Brukerspesifkk mellomlager som slettes når brukerens sesjon avsluttes. Designet for å unngå overbelastning.';
$string['cachesettings'] = 'Innstillinger for mellomlager';
$string['cachetemplates'] = 'Mellomlagre maler';
$string['cachetemplates_help'] = 'Mellomlagring av maler vil forbedre sidelastingsytelsen og anbefales på det sterkeste for produksjonsportaler. Utviklere vil sannsynligvis ønske å deaktivere denne';
$string['caching'] = 'Mellomlagring';
$string['calendar_weekend'] = 'Helgedager';
$string['calendarexportsalt'] = 'Krypteringsfrase for kalendereksport (SALT)';
$string['calendarsettings'] = 'Kalender';
$string['calendartype'] = 'Kalendertype';
$string['calendartype_desc'] = 'Velg en standard kalendertype for kursportalen. Denne innstillingen kan overstyres i kursinnstillingene eller av brukerne i deres egen profil.';
$string['campaign'] = 'Kampanje';
$string['cannotdeletemodfilter'] = 'Du kan ikke avinstallere \'{$a->filter}\' fordi den er en del av \'{$a->module}\'  modulen. ';
$string['cannotuninstall'] = '{$a} kan ikke avinstalleres.';
$string['categoryemail'] = 'Epost';
$string['cfgwwwrootslashwarning'] = '$CFG->wwwroot er feil angitt i config.php fila. Du har inkluder et \'/\' tegn på slutten. Vær vennlig å fjern det tegnet, ellers kan du oppleve merkelige feil som f.eks. <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'Du har definert $CFG->wwwroot feil i config.php fila. Den stemmer ikke med URL\'en du bruker for å nå siden.';
$string['change'] = 'endre';
$string['checkboxno'] = 'Nei';
$string['checkboxyes'] = 'Ja';
$string['checkupgradepending'] = 'Oppgrader';
$string['choosefiletoedit'] = 'Velg filen du skal endre';
$string['cleanup'] = 'Rydd opp';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliexitgraceful'] = 'Avslutter, vennligst vent...';
$string['cliexitnow'] = 'Avslutter nå';
$string['cliincorrectvalueerror'] = 'Feil, ugyldig verdi angitt for  "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Feil verdi, vennligst prøv igjen';
$string['clistatusdisabled'] = 'Status: deaktivert';
$string['clistatusenabled'] = 'Status: aktivert';
$string['clistatusenabledlater'] = 'status: CLI vedlikeholdsmodus vil bli aktivert på {$a}';
$string['clitypevalue'] = 'verditype';
$string['clitypevaluedefault'] = 'verditype, tast Enter for å bruke standardverdien {$a}';
$string['cliunknowoption'] = 'Ugyldige valg:
{$a}
Vennligst bruk Hjelp.';
$string['cliupgradecompletenomaintenanceupgrade'] = 'Slik tømmer du gjenværende cacher etter at brukertrafikk er overskredet til ny kode:

   php admin/cli/purge_caches.php --muc
   php admin/cli/purge_caches.php --js
   php admin/cli/purge_caches.php --filter
   php admin/cli/purge_caches.php --other

Du bør utføre disse tømmingene isolert, med et gap mellom kommandoene, for å redusere belastningstoppene på webserveren.';
$string['cliupgradedefault'] = 'Ny innstilling: {$a}';
$string['cliupgradedefaultheading'] = 'Setter nye standardverdier';
$string['cliupgradedefaultverbose'] = 'Ny innstilling: {$a->name}, Standardverdi: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Oppgradering via kommandolinje fra {$a->oldversion} til {$a->newversion} var vellykket.';
$string['cliupgrademaintenancenotrequired'] = 'Denne oppgraderingen vil ikke sette portalen i vedlikeholdsmodus.';
$string['cliupgrademaintenancerequired'] = 'Denne oppgraderingen vil sette portalen i vedlikeholdsmodus.';
$string['cliupgradenoneed'] = 'Det trengs ingen oppgraderinger for den installerte versjonen {$a}. Takk likevel for at du sjekker!';
$string['cliupgradepending'] = 'En oppgradering er satt på vent';
$string['cliupgradesetlock'] = 'Oppgradering har blitt låst til å kun utføres via CLI.';
$string['cliupgradeunsetlock'] = 'Eksisterende låsing av oppgradering via CLI har blitt ophhevet.';
$string['cliyesnoprompt'] = 'Tast j (betyr JA) eller n (betyr NEI)';
$string['close'] = 'Lukk';
$string['cohort_customfield'] = 'Egendefinerte kohortfelt';
$string['commentsperpage'] = 'Antall kommentarer pr. side';
$string['commonactivitysettings'] = 'Vanlige innstillinger';
$string['commonfiltersettings'] = 'Felles filterinnstillinger';
$string['commonsettings'] = 'Vanlige innstillinger';
$string['componentinstalled'] = 'Komponent er installert';
$string['composerdeveloperdependenciesinstalled'] = 'Avhengigheter for Composer Developer er installert. Sørg for at kommandoen "composer install --no-dev --classmap-authoritative" er kjørt i Moodles rotkatalog.';
$string['composernotfound'] = 'Fant ingen avhengigheter i Composer. Sørg for at kommandoen "composer install --no-dev --classmap-authoritative" er kjørt i rotkatalogen til Moodle. Hvis du ikke bruker Composer, sørg for at leverandørkatalogen finnes og inneholder de nødvendige filene.';
$string['composernotoptimised'] = 'Moodle kjører i produksjonsmodus mens Composer-autolasteren ikke er optimalisert. Du kan kjøre «composer install --no-dev --classmap-authoritative» for å optimalisere autolasteren.';
$string['composeroptimisedindevmode'] = 'Composer-autolasteren kjører for øyeblikket optimalisert mens Moodle er i utviklermodus. Dette kan forårsake problemer i noen tilfeller. Du kan ønske å kjøre «composer install» uten ytterligere argumenter.';
$string['computedfromlogs'] = 'Beregnet fra logger siden {$a}.';
$string['condifmodeditdefaults'] = 'Verdiene du angir her blir standardinnstillinger for hver ny aktivitet som opprettes.';
$string['confeditorhidebuttons'] = 'Velg de knappene som skal skjules i html-editoren.';
$string['configallcountrycodes'] = 'Dette er landoversikten som det kan velges fra mange steder, f.eks. i brukerens profil.  Dersom tom (standard) vil den engelske versjonen av landoversikten vises - ISO 3166-1. Ellers kan du angi en kommaseparert liste med landkoder, som f.eks. \'GB,FR,ES\'. Dersom du legger til nye ikke-standard koder her må du også legge dem til i filen \'countries.php\' i \'EN\' og din språkpakke.';
$string['configallowassign'] = 'For hver rolle i venstre kolonne, velg hvilke roller de kan tildele til andre.';
$string['configallowattachments'] = 'Aktivering av denne innstillingen vil tillate filvedlegg å bli sendt med epost-genererte meldinger av ulike funksjoner på hele portalen, sånn som blogger, forum og utmerkelser.';
$string['configallowcategorythemes'] = 'Hvis du slår på denne kan design velges på kategorinivå. Dette vil påvirke alle underkategorier og -kurs såfremt de ikke har satt et eget design. ADVARSEL: Ved å slå på kategoridesign kan ytelsen påvirkes noe.';
$string['configallowcohortthemes'] = 'Dersom du aktiverer dette kan designsettes på kohortnivå. Dette vil påvirke alle brukere med bare en kohort eller flere kohorter som alle har det samme designet.';
$string['configallowcoursethemes'] = 'Hvis aktivert, vil kurs få lov til å sette sine egne design. Kursdesign overstyrer alle andre designvalg (portal, bruker, kategori, kohort eller URL-definerte design).';
$string['configallowedemaildomains'] = 'Vis e-postdomener som tillates å bli inkludert i "Fra"-seksjonen i utgående e-post. Standard er "Tom" og vil da benytte Ikke-svar adressen for all utgående e-post. Det er tillatt å bruke asterix, som f.eks. *.eksempel.com, noe som vil medføre at alle subdomener av eksempel.com tillates, men ikke eksempel.com i seg selv. Det vil kreve en egen oppføring.';
$string['configallowemailaddresses'] = 'For å begrense epostadresser til spesifikke domener kan du liste dem opp her separert med mellomrom. Alle andre domener vil avvises. For å tillate underdomener, legg til domenet med et \'.\' foran. For å tillate rotdomenet sammen med dets underdomener, legg til domenet to ganger - en gang med \'.\' foran og en gang uten. F.eks. \'.ourcollege.edu.au\' og \'ourcollege.edu.au\'.';
$string['configallowemojipicker'] = 'Emoji-velgeren lar brukerne velge emojier som kan legges til i meldinger og andre teksfelt via en emojivelgerknapp i Attos verktøylinje.';
$string['configallowemojipickerincompatible'] = 'Databasekonfigurasjonen støtter ikke emojier. For å aktivere emoji-velgeren må du <a href="https://docs.moodle.org/en/MySQL_full_unicode_support">oppgradere databasen til full unikodestøtte</a>.';
$string['configallowguestmymoodle'] = 'Dersom aktivert, vil gjester få vist Dashbord. Ellers vil de bli omdirigert til kursportalens forside.';
$string['configallowobjectembed'] = 'Som en standard sikkerhetsinnstilling vil ikke vanlige brukere få lov til å legge multimedieobjekt (som f.eks. Flash) inn i tekst ved hjelp av html-tagger som EMBED og OBJECT. Multimedieobjekter kan likevel trygt legges inn ved hjelp av media-filter. Hvis du vil tillate bruk av disse html-taggene, slår du på denne muligheten her.';
$string['configallowoverride'] = 'Tillat at rollene på venstre side overstyrer rollene i hver kolonne';
$string['configallowoverride2'] = 'Velg hvilke rolle(r) som kan bli overstyrt av hver rolle i venstre kolonne.<br />NB! Disse innstillingene har bare betydning for brukere som har fått tillatelsene: moodle/role:override eller moodle/role:safeoverride.';
$string['configallowswitch'] = 'For hver rolle i venstre kolonne, velg hvilke roller de kan bytte til.<br />Brukere må også ha rettigheten moodle/rolle:switchroles.';
$string['configallowthemechangeonurl'] = 'Dersom aktivert kan en bytte design ved å legge til theme={themename} til Moodle URL. F.eks. mymoodlesite.com/?theme=afterburner';
$string['configallowuserblockhiding'] = 'Vil du at brukerne skal kunne skjule/vise blokker på hele portalen? Denne egenskap bruker javascript og informasjonskapsler for å huske tilstanden til hver blokk, og påvirker kun brukerens eget skjermbilde.';
$string['configallowusermailcharset'] = 'Hvis du tillater dette, vil alle brukere på portalen kunne spesifisere sitt eget karaktersett for bruk i epost.';
$string['configallowuserswitchrolestheycantassign'] = 'Som standard kreves det moodle/role:assign for at brukere skal få bytte roller i et kurs. Aktiverer du denne fravikes dette kravet og listemenyen for bytte av rolle vises. Vi anbefaler at "Tillat å tildele roller" ikke settes slik at en bruker kan skifte til en overordnet rolle med flere rettigheter enn de allerede har.';
$string['configallowuserthemes'] = 'Hvis du tillater dette, kan brukerne velge sitt eget design (utseende). Brukerdesign overstyrer portaldesign (men ikke kursdesign).';
$string['configallowview'] = 'Velg rollene en bruker skal kunne se, filtrere på osv. basert på brukerens egne roller.';
$string['configallusersaresitestudents'] = 'For aktiviteter på portalens forside, bør ALLE brukere betraktes som studenter? Hvis ja, vil alle med gyldig brukerkonto få delta som student i disse aktivitetene. Hvis nei, vil kun brukere som allerede er deltaker på minst ett kurs kunne delta i disse aktivitetene. Bare administratorer og spesialtilordnede lærere kan fungere som lærere for aktiviteter på portalens forside.';
$string['configauthenticationplugins'] = 'Vennligst velg autentiseringsmetoder du vil bruke i stigende rekkefølge. Egenregistrering vil skje via metoden valgt under "Registering" (vanligvis e-post).';
$string['configautolang'] = 'Detekter standardspråk fra nettleseren, hvis standardspråk for portalen er deaktivert.';
$string['configautolangusercreation'] = 'Hvis aktivert, når brukerens konto opprettes automatisk ved første innlogging (f.eks. Ved bruk av LDAP- eller OAuth 2-godkjenning), blir brukerens portalspråk angitt som foretrukket språk. Ellers er standardspråket for portalen angitt som brukerens foretrukne språk.';
$string['configautologinguests'] = 'Skal besøkende automatisk logges inn som gjester når de går til et kurs med gjestetilgang?';
$string['configbloglevel'] = 'Denne innstillingen tillater deg å begrense på hvilket nivå brukerblogger kan leses på denne portalen. Merk at de spesifiserer maksimum nivå til den som leser - ikke den som skriver eller typene bloggmeldinger. Blogger kan også kobles ut for hele portalen.';
$string['configcalendarcustomexport'] = 'Aktiver egendefinert tidsperiode ved eksport av kalender';
$string['configcalendarexportsalt'] = 'Denne tilfeldige teksten brukes for å forbedre sikkerheten av autentiseringen ved eksportering av kalendere. Merk at alle nåværende godkjennelser blir ugyldige hvis du forandrer denne krypteringsfrasen.';
$string['configcookiesecure'] = 'Hvis serveren bare aksepterer https-forbindelser er det anbefalt å slå på at du kan sende sikre cookies. Hvis dette er aktivert så pass på at webserveren ikke aksepterer http://, eller sett opp permanent viderekopling til en https:// adresse. Når <em>wwwroot<em> adressen ikke starter med https:// blir denne innstillingen automatisk slått av.';
$string['configcountry'] = 'Hvis du velger et land her, vil dette landet brukes som standard for nye brukerkonti. For å tvinge brukere til å velge land, lar du denne stå usatt.';
$string['configcoursegraceperiodafter'] = 'La tidligere kurs vises som nåværende i så mange dager etter kursets sluttdato';
$string['configcoursegraceperiodbefore'] = 'La fremtidige kurs vises som nåværende i så mange dager før kursets startdato.';
$string['configcourseoverviewfilesext'] = 'Kommaseparert liste over tillatte filtyper for kursbilder.';
$string['configcourseoverviewfileslimit'] = 'Maksimalt antall filer som kan vises ved siden av kursoppsummeringen på listen over kurs. Den første bildefilen som legges til brukes som kursbilde i kursoversikten på brukernes dashboards; tilleggsfiler vises bare på listen over kurs.';
$string['configcourserequestnotify'] = 'Skriv brukernavnet til brukeren som skal få varsel hvis noen ønsker å opprette nytt kurs.';
$string['configcourserequestnotify2'] = 'Brukere som vil bli varsles når et nytt kurs ønskes opprettet. Bare brukere som kan gi godkjennelse til å opprette nytt kurs skal listes opp her.';
$string['configcoursesperpage'] = 'Skriv inn antall kurs som skal vises på hver side i en kursoversikt.';
$string['configcourseswithsummarieslimit'] = 'Maksimum antall kurs som skal vises på hver side før Moodle skifter til forenklet kurslisting.';
$string['configcronclionly'] = 'Å kjøre cron fra adressefeltet i nettleseren kan eksponere sensitiv informasjon til anonyme brukere. Det er derfor anbefalt å kun kjøre cron fra kommandolinjen eller sette et passord for fjerntilgang';
$string['configcronremotepassword'] = 'Dette betyr at cron.php ikke kan kjøres rett fra nettleseren uten at passordet skrives inn på følgende form:
<pre>
http://site.example.com/admin/cron.php?password=opensesame
</pre> Dersom deaktivert, kan passordet utelates.';
$string['configcurlcache'] = 'Sesjonslengde for cURL cache, angitt i sekunder';
$string['configcustommenuitems'] = 'Du kan her sette opp en tilpasset meny som skal vises sammen med designet.  Hver linje består av tekst og en URL (valgfritt), et pekertips (valgfritt) og atskilles med pipe-tegnet. Du kan angi en struktur med bindestrek ved hjelp av ###. Det siste menyvalget viser kodetillegget som trengs for å åpne i et nytt vindu.
Eksempel:
<pre>
Moodle community|http://moodle.org
-Moodle free support|http://moodle.org/support
-###
-Moodle development|http://moodle.org/development
--Moodle Tracker|http://tracker.moodle.org
--Moodle Docs|http://docs.moodle.org|Dokumentasjon på engelsk
-Moodle News|http://moodle.org/news
Moodle company|Nyheter fra Moodle
-Moodle commercial hosting|http://moodle.com/hosting
-Moodle commercial support|http://moodle.com/support" target="new"
</pre>';
$string['configcustomusermenuitems'] = 'Du kan endre innholdet i brukermenyen, unntatt utloggingslenken som er der automatisk). Hver linje er separert med |-tegn og består av 1) en streng på formen "langstringname, componentname" eller som ren tekst, 2) en URL og 3) et ikon enten som et pix ikon eller en URL. Du kan legge til skilletegn ved å legge til en linje eller flere # tegn hvor ønskelig.';
$string['configdbsessions'] = 'Hvis den er aktivert, vil denne innstillingen bruke databasen til å lagre informasjon om gjeldende økter. Merk at hvis du endrer denne innstillingen nå, logges alle nåværende brukere av (inkludert deg). Hvis du bruker MySQL, sørg for at \'max_allowed_packet\' i my.cnf (eller my.ini) er minst 4M. Andre øktdrivere kan konfigureres direkte i config.php, se config-dist.php for mer informasjon. Dette alternativet forsvinner hvis du spesifiserer sesjonsdriver i filen config.php.';
$string['configdebug'] = 'Hvis du slår på denne, vil PHPs error_reporting økes slik at flere advarsler kan lagres. Dette er kun nyttig for utviklere.';
$string['configdebugdisplay'] = 'Dersom aktivert, vil feilmeldingene vise på html-siden. Dette er kanskje praktisk, men herper XHTML, JS, COOKIES og HTTP. Slår du den av vil du i stedet få feilmeldingene i serverloggen. Det gir oftest best debugging informasjon. Det er PHP innstillingen for error_log som avgjør hvilken logg det skrives til.';
$string['configdebugpageinfo'] = 'Aktiveres dersom du ønsker at sideinformasjon skal vises i footer.';
$string['configdebugvalidators'] = 'Aktiver denne hvis du har lenker til eksterne valideringsservere i sidens bunntekst. Du kan f.eks. lage en bruker med brukernavnet <em>w3cvalidator</em>,  og aktivere gjestetilgang. Disse endringene kan medføre uønsket tilgang til serveren og må ikke aktiveres på produksjonsportaler!';
$string['configdefaulthomepage'] = 'Hvilken side skal brukere omdirigeres til etter å ha logget inn på siden? Innstillingen bestemmer også den første lenken i navigasjonen for brukere av klassiske temaer.';
$string['configdefaultrequestcategory'] = 'Kursønsker fra brukere vil automatisk bli plassert i denne kategorien med mindre brukerne kan velge en annen kategori.';
$string['configdefaultrequestedcategory'] = 'Standard kategori forespurte kurs skal legges i hvis de godkjennes.';
$string['configdefaultuserroleid'] = 'Alle innloggede brukere vil få tildelt rettighetene til den rollen du setter opp her, på portalnivå, i tillegg til de andre roller de har blitt tildelt. Standard er Godkjent bruker. Merk at dette ikke vil være i strid med andre roller en bruker har med mindre du forbyr rettigheter, den bare sikrer at alle brukere har rettigheter som ikke kan tildeles på kursnivå (f.eks. lese i forum, ressurser osv)';
$string['configdeleteincompleteusers'] = 'Etter denne perioden vil kontoer uten fornavn, etternavn eller epostadresse bli slettet.';
$string['configdeleteunconfirmed'] = 'For enkelte autentiseringsmetoder, som f.eks. epostbasert selvregistrering, må brukerne bekrefte kontoen innen en viss tid. Dersom kontoen ikke bekreftes tidsnok vil den slettes.';
$string['configdenyemailaddresses'] = 'For å avvise adresser fra spesielle domener, lister du dem på samme måte her. Alle andre domener vil godkjennes. Eks. <strong>hotmail.com yahoo.co.uk</strong>';
$string['configdisableuserimages'] = 'Slå av muligheten for at brukerne selv kan laste opp bilde av seg selv.';
$string['configdisplayloginfailures'] = 'Dette vil vise informasjon om tidligere mislykkede innlogginger.';
$string['configdndallowtextandlinks'] = 'Aktiver eller deaktiver "dra og slipp" av tekst og lenker på en kursside, i tillegg til "dra og slipp" av filer. Merk at "dra og slipp" av tekst i Firefox eller mellom forskjellige nettlesere ikke er mulig og kan resultere i at ingen data blir lastet opp eller at teksten blir ødelagt.';
$string['configdoclang'] = 'Dette språket vil bli benyttet til lenker til dokumentasjonssider.';
$string['configdocroot'] = 'Definerer stien til Moodle Docs for å levere kontekstspesifikk dokumentasjon via lenker i bunnteksten på hver side. Hvis feltet er tomt, vil ikke lenker vises.';
$string['configdoctonewwindow'] = 'Hvis du slår denne på, så vil lenker til Moodle dokumentasjon vises i et nytt vindu.';
$string['configduration_high'] = 'Denne verdien er for høy. Maksimumsverdien er {$a}.';
$string['configduration_low'] = 'Denne verdien er for lav. Minimumsverdien er {$a}.';
$string['configeditordictionary'] = 'Denne verdien blir benyttet hvis aspell ikke har noen ordliste for brukerens valgte språk.';
$string['configeditorfontlist'] = 'Velg de fontene som skal være tilgjengelige i html-editoren.';
$string['configemailchangeconfirmation'] = 'Krev bekreftelse via lenke i tilsendt epost når epostadressen endres';
$string['configemaildkimselector'] = 'DKIM-velgeren er vilkårlig, og DNS-postene dine må samsvare med dette.';
$string['configemailfromvia'] = 'Legg til via informasjon i "Fra-"-delen av den utgående eposten. Dette informerer mottakeren om hvor denne eposten ble sendt fra, og hjelper også til å forhindre at motakerne svarer til ikke-svar adresser.';
$string['configemailheaders'] = 'Rå headere som skal legges ordrett til all utgående e-post.';
$string['configemailsubjectprefix'] = 'Prefiks som skal brukes i emnefeltet på all utgående epost.';
$string['configenableanalytics'] = 'Analysemodeller, som f.eks. \'Studenter i faresonen for å falle fra\' eller \'kommende aktivitetsfrister\' kan generere prediksjoner, sende insiktsvarslinger og andre handlinger som å sende meldinger ti';
$string['configenableblogs'] = 'Denne knappen gir alle brukerne på portalen egen blogg.';
$string['configenablecalendarexport'] = 'Slå på eksportering/abonnering på kalendre.';
$string['configenablecomments'] = 'Aktiver kommentarer';
$string['configenablecourserequests'] = 'Dette vil tillate at alle brukere med tillatelsen (moodle/course:request) kan be om at et kurs skal opprettes. Som standard har ingen roler denne tillatelsen. Den kan legges til på portal- eller kategorinivå.';
$string['configenablemobilewebservice'] = 'Mobile webtjenester er nødvendige for Moodle-appen. Hvis nettstedet ditt bruker HTTPS, er mobile webtjenester aktivert som standard. For mer informasjon, se {$a}.';
$string['configenablerssfeeds'] = 'Hvis aktivert, vil RSS genereres av diverse aktiviteter over hele portalen, f.eks. blogger, forum, databaser og ordbøker. Vær oppmerksom på at RSS også må aktiveres i innstillingene til hver enkelt aktivitetsmodul.';
$string['configenablerssfeedsdisabled'] = 'Denne er ikke tilgjengelig siden RSS er inaktiv på denne portalen. For å aktivisere RSS må du gå til Admin; Variabler.';
$string['configenablerssfeedsdisabled2'] = 'RSS-agenter er slått av på portalnivå. Du må slå dem på under "Avanserte funksjoner" på portalnivå.';
$string['configenablestats'] = 'Hvis du velger \'ja\' her, vil Moodles cronjobb prosessere loggene og samle statistikk. Avhengig av mengden trafikk på portalen, kan dette ta litt tid. Hvis du tillater det, vil du kunne se interessante grafer og statistikk om hvert av kursene dine eller på basis av hele portalen.';
$string['configenabletrusttext'] = 'Som standard vil Moodle alltid renske tekst fra brukere for potensielt skadelig kode, media eller annet som kan være en sikkerhetsrisiko. "Godkjent Innhold" systemet er en måte å gi bestemte brukere adgang til å inkludere avanserte funksjoner i publisert innhold uten at Moodle fjerner noe. <br />For å aktivisere denne funksjonen må du først aktivisere denne innstillingen og deretter tildele "Godkjent Innhold"-tillatelse til en bestemt Moodle-rolle. Tekst som blir produsert eller lastet opp av slike brukere vil bli merket som Godkjent og ikke rensket før den vises.';
$string['configenablewebservices'] = 'Webtjenester gjør det mulig for andre systemer, for eksempel Moodle-appen, å logge seg på portalen og utføre operasjoner. For ekstra sikkerhet, bør innstillingen deaktiveres hvis du ikke bruker appen, eller et eksternt verktøy / tjeneste som krever integrering via webtjenester.';
$string['configenablewsdocumentation'] = 'Aktiver autogenerering av webtjeneste - dokumentasjon. En bruker kan via webtjenester få tilgang til egen dokumentasjon på sin side for sikkerhetsnøkkel {$a}. Denne funksjonen viser bare dokumentasjonen for aktivert protokoll.';
$string['configerrorlevel'] = 'Velg hvor mye PHP-advarsler du ønsker skal vises. Normal er vanligvis det beste valg.';
$string['configexportlookahead'] = 'Antall dager å se framover under eksport';
$string['configexportlookback'] = 'Antall dager å se tilbake i tid under eksport';
$string['configextendedusernamechars'] = 'Hvis aktivert vil brukere kunne bruke alle alfanumeriske tegn i brukernavnet sitt, med unntak av store bokstaver. Ellers vil kun små bokstaver, tall, understrek(_), bindestrek (-), punktum (.) og alfakrøll (@) være tillatt.';
$string['configextramemorylimit'] = 'Noen scripts, som Søk, Backup/Restore eller cron, krever mer minne. Angi derfor en høyere verdi på store portaler.';
$string['configfilterall'] = 'Filtrer alle tekststrenger, inkludert overskrifter, titler, navigasjonslinjer osv. Dette er nyttigst når du bruker filter for flere språk, ellers vil den kun skape ekstra belasting på portalen uten at du tjener på det.';
$string['configfiltermatchoneperpage'] = 'Auto-lenking filtre vil bare generere en lenke for første treff på en side. Alle andre blir ignorert.';
$string['configfiltermatchonepertext'] = 'Auto-lenking filtre vil bare generere en lenke for første treff i hver tekstblokk (i en ressurs, blokk osv). Alle andre blir ignorert. Denne innstillingen overstyres hvis du har aktivisert bare ett auto-lenke treff pr. side.';
$string['configfilternavigationwithsystemcontext'] = 'Normal bruk av filtreringen er knyttet til konteksten den brukes i (f.eks. kurskontekst), men for portalnavigering kan det å eksplisitt filtrere alt med portalkontekst gi ytelsesforbedringer ved bruk av "innhold og overskrifter"-filtrering.';
$string['configfilteruploadedfiles'] = 'Alle opplastetede html- og tekstfiler vil filtreres før de vises, bare html-filer eller ingen i det hele  tatt.';
$string['configforcelogin'] = 'Normalt kan portalens forside og kursoversiktene (men ikke kurs) leses av folk uten å logge inn på siden. Hvis du vil tvinge folk til å logge på før de gjør NOE på siden, bør du aktivere denne innstillingen.';
$string['configforceloginforprofiles'] = 'Slå på denne innstillingen for å tvinge folk til å logge på med en virkelige konto (ikke gjester) før de kan se sider med brukerprofiler. Som standard er dette deaktivert slik at potensielle studenter kan lese om lærerne på hvert kurs, men dette betyr også at søkemaskiner på nettet kan se dem.';
$string['configfrontpage'] = 'Elementene over vil vises på forsiden.';
$string['configfrontpagecourselimit'] = 'Maksimum antall kurs';
$string['configfrontpagecourselimithelp'] = 'Maksimum antall kurs som skal vises på portalens forside i kursoversikten';
$string['configfrontpageloggedin'] = 'Elementene over vil vises på forsiden etter innlogging.';
$string['configfullnamedisplay'] = 'Dette definerer hvordan navn vises når de vises i sin helhet. Standardverdien, "språk", overlater til strengen "fullnamedisplay" i gjeldende språkpakke å bestemme. Noen språk har forskjellige navnevisningskonvensjoner.

For de fleste enspråklige portaler er den mest effektive innstillingen "fornavn etternavn", men du kan velge å skjule etternavn helt.
Plassholdere som kan brukes er:  firstname, lastname, firstnamephonetic, lastnamephonetic, middlename, and alternatename.';
$string['configgeoipfile'] = 'Plassering av GeoIP2 City binærdatafil. Denne filen er ikke en del av Moodledistribusjonen og må hentes fra <a href="http://www.maxmind.com/">MaxMind</a>.  Du kan enten kjøpe en kommersiell versjon eller bruke gratisversjonen. Du må registrere deg for å laste ned City-databasefilen, noe du kan gjøre på  <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a>. Etter at du har registrert deg og lastet ned filen kan du pakke ut til "{$a}"-mappen på serveren.';
$string['configgetremoteaddrconf'] = 'Dersom serveren er bak en proxy, kan du bruke denne innstillingen til å sette opp hvilke http-headere som skal tillates å inneholde innkommende IP-adresser. Headerne blir lest i oppgitt rekkefølge og bruker første treff.';
$string['configgradebookroles'] = 'Innstillingen lar deg styre hvem som skal fremkomme i vurderingsboka. En bruker må ha minst EN av disse rollene for å vises i vurderingsboka for et kurs.';
$string['configgradeexport'] = 'Velg hvilket format som skal være førstevalg for å eksportere karakterer. Valgt modul vil settes og bruke "siste eksporterte" felt for alle karakterer. Hvis foreksempel, dette resulterer i at eksporterte poster blir identifisert som "new" eller "updated". Hvis du ikke er sikker på hva dette er, la alt stå ukrysset.';
$string['configgradeexportdefault'] = 'Velg standard eksportformat for karakterboka';
$string['confighiddenuserfields'] = 'Velg hvilke felt med brukerinformasjon du vil skal skjules for andre brukere enn kursets lærere og administratorer. Dette vil øke studentens personvern. Hold CTRL-knappen nede for å velge flere felt.';
$string['configidnumber'] = 'Ette valget spesifiserer hvorvidt (a) Brukere spørres ikke om ID-nummer i det hele tatt, (b) Brukere spørres om et ID-nummer, men kan la det stå blankt eller (c) Brukere spørres om et ID-nummer og kan ikke velge å la det stå tomt. Hvis det er gitt, vil brukers ID-nummer vises i deres profil.';
$string['configintro'] = 'På denne siden kan du spesifisere et antall konfigurasjonsvariable som hjelper til å få Moodle til å fungere skikkelig på tjeneren din. Ikke bekymr  deg for mye om det - standardverdiene vil normalt fungere fintog du kan alltids komme tilbake til denne siden senere for å forandre disse innstillingene.';
$string['configintroadmin'] = 'På denne siden skal du konfigurere hovedadministratorkontoen. Denne vil ha fullstendig kontroll over portalen. Forsikre deg om at det er et sikkert brukernavn og passord i tillegg til en gyldig epostadresse. Du kan opprette flere administratorkontoer senere.';
$string['configintrosite'] = 'Denne siden lar deg konfigurere forsiden og navnet på portalen. Du kan komme tilbake hit senere for å forandre disse innstillingene når som helst ved å bruke lenken \'Innstillinger for portalen\' på forsiden.';
$string['configiplookup'] = 'Når du klikker på en IP-adresse (som f.eks. 81.191.105.103), vil du få opp et kart med visning av hvor denne adressen er registrert/kommer fra. Det finnes flere moduler for dette du kan velge mellom. Hver av dem har fordeler og ulemper.';
$string['configkeeptagnamecase'] = 'Slå på denne hvis du vil at taggnavn skal beholde store/små bokstaver slik som brukerne laget dem.';
$string['configlang'] = 'Velg et standardspråk for hele portalen. Brukere kan overstyre denne innstillingen senere via språkmenyen eller innstillingene i egen profil.';
$string['configlanglist'] = 'Hvis tom vil alle installerte språk vises i språkmenyen. Alternativt kan menyen forkortes ved å skrive inn en komaaseparert liste med språkkoder som f.eks. en,de,fr. Det er også mulig å legge inn et annet navn for språk enn språkpakkenavnet ved å bruke formatet språkkode|språknavn, f.eks. en_kids|English,de_kids|Deutsch.';
$string['configlangmenu'] = 'Bestem om språkmenyen skal vises på forsiden, login-siden etc. Brukeren vil likevel kunne angi ønsket språk i sin egen profil.';
$string['configlangstringcache'] = 'Mellomlagrer alle språkstrenger i kompilerte filer i datamappen. Dersom du oversetter Moodle eller endrer strenger i Moodles kildekode, vil du nok deaktivere denne. Ellers bør du la denne være på for å øke ytelsen på systemet.';
$string['configlatinexcelexport'] = 'Velg kodesett for Excel-eksporter';
$string['configlocale'] = 'Angi datoformat for hele portalen. Dette vil overstyre både format og språk for alle installerte språkpakker. (Kalenderdatoer påvirkes ikke) Du må ha  disse lokale datoinnstillingene installert i operativsystemet. I de fleste tilfeller anbefaler vi  at du lar feltet stå blankt.';
$string['configlockrequestcategory'] = 'Hvis aktivert vil brukere med tillatelse til å be om ny kurs på portalnivå ikke kunne velge en kategori når de ber om et nytt kurs. En alternativ måte å begrense brukere fra å be om nye kurs i kun en kategori er å legge til tillatelsen for å be om nye kurs på kategorinivå.';
$string['configloglifetime'] = 'Dette spesifiserer hvor lang tid du ønsker å bevare logger om brukeraktivitet. Logger som er eldre enn dette blir automatisk slettet. Det er best å beholde logger så lenge som mulig, i tilfelle du trenger dem, men hvis du har en veldig travel tjener og opplever problemer med ytelsen, bør du vurdere å senke levetiden til loggene.';
$string['configlookahead'] = 'Dager inn i fremtiden';
$string['configmailnewline'] = 'Tegn for ny linje i mailbeskjeder. CRLF skal brukes ifølge RFC 822bis, noen epostservere bruker automatisk konvertering fra LF til CRLF, andre gjør feil konvertering fra CRLF til CRCRLF, andre igjen avviser epost med bare LF (qmail foreksempel). Prøv å endre denne innstillingen hvis du opplever problemer med epost som ikke blir levert eller doble blanke linjer.';
$string['configmaxbytes'] = 'Denne innstillingen bestemmer største tillate filstørrelse (ved opplasting) for hele portalen. Innstillingen er begrenset av PHP-innstillingen "post_max_size" og "upload_max_filesize", og Apaches "LimitRequestBody". Her settes største tillatte filstørrelse som kan velges på kurs eller modulnivå.';
$string['configmaxconsecutiveidentchars'] = 'Passord må ikke ha mer enn dette antallet påfølgende identiske tegn. bruk verdien 0 for å koble ut denne sjekken.';
$string['configmaxeditingtime'] = 'Dette spesifiserer hvor lang tid folk har til å endre på innlegg til forum, kommentarer til glossar osv. Vanligvis vil 30 min være en god verdi.';
$string['configmaxevents'] = 'Begivenheter inn i fremtiden';
$string['configmaxusersperpage'] = 'Maks antall brukere vist i brukervelger i kurs, gruppe, kohort, webservice, osv.';
$string['configmessaging'] = 'Dersom aktivert kan brukere sende meldinger til andre brukere på portalen.';
$string['configmessagingallowemailoverride'] = 'Tillater brukere å få tilsendt meldinger fra kursportalen til en annen e-postadresse enn den som er oppgitt i brukerprofilen.';
$string['configmessagingallusers'] = 'Hvis aktivert kan brukere se alle portalens brukere når de velger hvem de skal sende en melding til ogmeldingspreferansene vil inkludere et valg om å motta meldinger fra alle på portalen. Dersom deaktivert kan brukere bare se brukere som er medlem av samme kurs og de har kun to valg i meldingspreferansene - akseptere medinger fra kontakter eller kontakter og brukre i deres kurs.';
$string['configmessagingdefaultpressenter'] = 'Om "Bruk enter for å sende" skal være aktivert som standard i brukernes meldingsinnstillinger.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Leste og uleste varsler kan slette for å lspare plass. Når skal varslinger slettes?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Leste varsler kan slettes for å spare diskplass. Hvor lang tid etter at varselet er lest kan det gå før den slettes?';
$string['configminpassworddigits'] = 'Passordene må ha minst så mange tall.';
$string['configminpasswordlength'] = 'Passordene må være minst så mange tegn lang.';
$string['configminpasswordlower'] = 'Passordene må ha minst så mange små bokstaver.';
$string['configminpasswordnonalphanum'] = 'Passordene må minst så mange spesialtegn.';
$string['configminpasswordupper'] = 'Passordene må ha minst så mange store bokstaver.';
$string['configmypagelocked'] = 'Denne innstillngen hindrer standardsiden fra å bli endret av andre enn administratorer.';
$string['confignavcourselimit'] = 'Begrenser antall viste kurs i navigasjonsmenyen.';
$string['confignavshowallcourses'] = 'Dette innstillingen bestemmer om brukere som er påmeldt i kurs kan se "Kurskatalog" i blokken Navigasjon (som viser alle kurs), i tillegg til "Mine kurs" (kun kurs som de er påmeldt).';
$string['confignavshowcategories'] = 'Vis kurskategorier i navigasjonsfeltet og navigasjonsblokkene. Dette skjer ikke med kurs brukeren for øyeblikket er påmeldt; de vil fremdeles være oppført under Mine kurs uten kategorier.';
$string['confignoreplyaddress'] = 'E-post blir noen ganger sent på vegne av en bruker (ved forum-innlegg etc). E-postadressen du oppgir her vil bli benyttet som FRA-adresse i de tilfeller hvor mottakerne IKKE skal svare på e-posten. Denne FRA-adressen brukes også på de brukerne som har reservert seg mot visning av egen e-postadresse.';
$string['confignotifyloginfailures'] = 'Dersom mislykkede login er logget, kan et e-postvarsel sendes ut. Dette krever at en intern lagring av logger (standard logger) aktiveres.';
$string['confignotifyloginthreshold'] = 'Dersom varsling om mislykkede login er aktivisert, hvor mange mislykkede forsøk fra en bruker eller IP-adresse er det bryet verdt å varsle om?';
$string['confignotloggedinroleid'] = 'Brukere som ikke er innlogget vil bli behandlet som om de hadde denne rollen. Gjesterollen er vel den du ønsker her? (Du kan opprette mer eller mindre restriktive roller.) Skal en bruker skrive et forum-innlegg kreves innlogging uansett.';
$string['configopentowebcrawlers'] = 'Hvis du slår på denne instillingen, vil Google kunne  inspisere portalen som gjest. I tillegg vil folk som kommer til portalen via Google automatisk bli logget inn som en gjest. Merk at dette kun gir en transparent aksess til kurs som allerede tillater tilgang for gjester.';
$string['configoverride'] = 'Definert i config.php';
$string['configpasswordpolicy'] = 'Hvis dette er aktivert, vil brukerpassord sjekkes mot passordpolicy som spesifisert i innstillingene nedenfor. Aktivering av passordpolicy vil ikke påvirke eksisterende brukere før de bestemmer seg for, eller er pålagt å endre passordet sitt, eller innstillingen \'Kontroller passord ved innlogging\' er aktivert.';
$string['configpasswordpolicycheckonlogin'] = 'Hvis dette er aktivert, vil brukerpassord sjekkes mot passordpolicyen hver gang brukere logger seg på. Hvis sjekken mislykkes, blir brukeren pålagt å endre passordet før de fortsetter.
Det er nyttig å aktivere denne innstillingen etter oppdatering av passordpolicy.';
$string['configpasswordresettime'] = 'Denne innstillingen bestemmer hvor lang tid brukeren har for å bekrefte ett nytt passord før det utløper. 30 minutter er vanligvis en bra tid.';
$string['configpathtodu'] = 'Sti til du (disc usage). Antagelig noe sånt som /usr/bin/du. Hvis du skriver inn dette, vil sider som viser innhold i en mappe kjøre mye raskere for mapper med mange filer.';
$string['configpathtophp'] = 'Stien til PHP CLI. Sannsynligvis noe sånt som /usr/bin/php. Dersom du skriver inne dette vil cronskriptene bli utført fra adminwebpanelet.';
$string['configperfdebug'] = 'Hvis du setter på denne innstillingen, vil informasjon om ytelse skrives i bunnteksten på standardtema.';
$string['configprofileroles'] = 'Viser en liste over roller som skal være synlig på brukerprofilen og deltakernes sider,';
$string['configprofilesforenrolledusersonly'] = 'For å hindre misbruk fra spammere, skjules beskrivelsesfeltet for brukere som ennå ikke er påmeldt kurs. Nye brukere må melde seg på minst ett kurs før de kan redigere beskrivelsesfeltet i egen profil.';
$string['configprotectusernames'] = 'Som standard viser ikke "Glemt passord"-skjemaet noen hint for å hjelpe til å gjette på brukernavn eller epost-adresser.';
$string['configproxybypass'] = 'Kommaseparert liste over verter eller IP-adresser som ikke skal bruke Proxy. (eks: 192.168., *.mydomain.com). Separer hvert element med komma, uten bruk av mellomrom.';
$string['configproxyfixunsafe_help'] = 'Dette forsøker å fikse interne anrop som ikke går gjennom proxyen ved å legge til MoodleBot User Agent og bruke proxyen.';
$string['configproxyhost'] = 'Dersom denne <b>serveren</b> må kobles via en proxy/brannmur mot internett, må du oppgi proxy-navn og portnummer her. Ellers kan feltet stå tomt.';
$string['configproxylogunsafe_help'] = 'Dette forsøker å logge interne anrop som ikke går gjennom proxyen men bør.';
$string['configproxypassword'] = 'Passord som trengs for å få tilgang til Internett gjennom proxy hvis du har dette, la den stå tom hvis du ikke har det (PHP cURL-tillegg nødvendig.)';
$string['configproxyport'] = 'Dersom serveren kobles via proxy oppgir du portnummeret her.';
$string['configproxytype'] = 'Type webproxy (PHP5 og cURL-tillegg er nødvendig for SOCKS5-støtte).';
$string['configproxyuser'] = 'Brukernavn nødvendig for å få tilgang på Internett gjennom proxyserver, la den stå tom hvis du ikke trenger det (PHP cURL-tillegg er nødvendig.)';
$string['configrecaptchaprivatekey'] = 'Privat nøkkel som brukes for å kommunisere mellom Moodleserveren din og recapthca.net-serveren. Du kan få en privat nøkkel for denne nettsiden fra  <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Offentlig nøkkel som brukes for å vise reCAPTCHA-elementet i påmeldingsskjemaet.
Du kan skaffe en nøkkel for denne nettsiden fra <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestedstudentname'] = 'Ord brukt for student i forespurte kurs';
$string['configrequestedstudentsname'] = 'Ord brukt for studenter i forespurte kurs';
$string['configrequestedteachername'] = 'Ord brukt for lærer i forespurte kurs';
$string['configrequestedteachersname'] = 'Ord brukt for lærere i forespurte kurs';
$string['configreverseproxyignore'] = 'Hvis serveren er bak flere omvendt fullmakter som legges til X-Forwarded-For header, og angi en kommaseparert liste over IP-adresser eller subnett av omvendt fullmakter til å bli ignorert for å finne brukerens riktig IP-adresse.';
$string['configsectioninterface'] = 'Grensesnitt';
$string['configsectionmail'] = 'E-post';
$string['configsectionmaintenance'] = 'Vedlikehold';
$string['configsectionmisc'] = 'Diverse';
$string['configsectionoperatingsystem'] = 'Operativsystem';
$string['configsectionpermissions'] = 'Tillatelser';
$string['configsectionrequestedcourse'] = 'Klassesøknader';
$string['configsectionsecurity'] = 'Sikkerhet';
$string['configsectionstats'] = 'Statistikk';
$string['configsectionuser'] = 'Buker';
$string['configsecureforms'] = 'Moodle kan bruke et ekstra sikkerhetsnivå når det aksepteres data fra nettskjema. Hvis dette er slått på, vil nettleserens HTTP_REFERER variabel sjekkes opp mot det aktuelle skjemaets adresse. I noen få tilfeller kan dette medføre problemer hvis brukeren bruker en brannmur (f.eks. Zonealarm) som er konfigurert for å fjerne HTTP_REFERER fra sin nettrafikk. Symptomer er at en sitter \'fast\' i et skjema. Hvis dine brukere f.eks. har problemer med innloggingssiden, bør du vurdere å slå av denne innstillingen, selv om det kan gjøre portalen ditt mer åpent for direkte angrep på passord. Hvis du er i tvil, la det stå \'ja\' her.';
$string['configservicespage'] = 'Skriv inn URL-en til en tjeneste- og støtteside eller la stå tomt for å koble til Moodle-tjenester på moodle.com. Linken vises kun for portaladministratorer.';
$string['configsessioncookie'] = 'Denne innstillingen tilpasser navn på cookien som brukes for Moodle-innstillinger. Den er valgfri, og er bare nyttig for å unngå at cookies blir forvirret når det er flere enn en versjon av Moodle som kjører på den samme nettjeneren.';
$string['configsessioncookiedomain'] = 'Denne innstillingen tillater deg å endre domene som Moodle-cookies er tilgjengelige fra. Dette er nyttig for tilpassede Moodle-installasjoner (f.eks autentiserings eller påmeldingstillegg) som trenger å dele sesjonsdata fra Moodle til en webapplikasjon eller et annet underdomene. <strong>ADVARSEL: det er sterkt å anbefale at man lar denne står på standardinnstilling (tom) - en feil verdi her vil forhindre all innlogging til portalen.</strong>';
$string['configsessioncookiepath'] = 'Hvis du har behov for å endre hvor nettlesere sender sine Moodle-cookies, kan du forandre denne innstillingen for å spesifiere en underkatalog på nettserveren. Hvis ikke, er standardinnstillingen \'/\' helt fin.';
$string['configsessiontimeout'] = 'Hvis folk som er logget inn på denne portalen er passive i lang tid (uten å laste sider) vil de automatisk logges ut (sesjonene deres vil termineres). Denne variabelen spesifiserer hvor lang tid som skal gå før dette skjer.';
$string['configsessiontimeoutwarning'] = 'Hvis folk som er logget på denne portalen er inaktive i lang tid (uten å laste inn sider), blir de advart om at økten deres er i ferd med å avsluttes. Denne variabelen spesifiserer hvor lang denne tiden skal være.';
$string['configsessiontimeoutwarningcheck'] = 'Advarsel om tidsavbrudd for økt må være mindre enn tidsavbrudd for økt';
$string['configshowcommentscount'] = 'Vis antall kommentarerer. Vil medføre en ekstra spørring før siden vises.';
$string['configshowicalsource'] = 'Vis kildeinformasjon om iCal-hendelser';
$string['configshowsiteparticipantslist'] = 'Alle disse studenter og lærere på portalen vil bli listet opp på portalens deltakerliste. Hvem skal få lov til å se deltakerlisten for denne portalen?';
$string['configsitedefaultlicense'] = 'Standard portallisens';
$string['configsitedefaultlicensehelp'] = 'Standardlisensen vil benyttes for publisering av innhold på denne portalen';
$string['configsitemailcharset'] = 'All epost som genereres på din portal vil sendes i det spesifiserte karaktersett. Men hver enkelt bruker har lov til å tilpasse den hvis denne innstillingen er slått på.';
$string['configsitemaxcategorydepth'] = 'Maksimal kategoridybde';
$string['configsitemaxcategorydepthhelp'] = 'Denne angir maksimalt antall dybde av underkategorier som vises. Dypere nivåer av underkategorier vil da vises som lenker.';
$string['configslasharguments'] = '"Slash-arguments" (som bruker <em>PATH_INFO</em>) kreves for SCORM-pakker og multiple filressurser for å vises korrekt. Dersom webserveren ikke støtter "Slash-arguments", og du ikke får konfigurert det, kan du la denne innstillingen være deaktivert, men vil medføre at ting ikke vil fungere. <br />Støtte for "slash-arguments" er påkrevd i framtidige Moodle-versjoner.';
$string['configsmtpauthtype'] = 'Dette setter autentiseringstypen som skal brukes på smtp-server.';
$string['configsmtphosts'] = 'Oppgi fullt navn for en eller flere lokale SMTP-servere som Moodle skal bruke til epost-utsending  (f.eks. \'mail.a.com\' eller \'mail.a.com;mail.b.com\'). For å spesifisere en port som ikke er standard (altså en annen enn port 25) kan du bruke syntaksen [server]:[port] (f.eks. \'mail.a.com:587\'). For sikker tilkobling brukes port 465 vanligvis med SSL, port 587 vanligvis med TLS. Angi sikkerhetsprotokoll under hvis det kreves. Dersom du lar feltet stå tomt, vil Moodle bruke PHP\'s standardmetode for å sende epost.';
$string['configsmtpmaxbulk'] = 'Antall beskjeder sent per SMTP-sesjon. Å gruppere beskjeder kan gi økt hastigheten på epostsending. Verdier på mindre enn to tvinger at en ny SMTP-sesjon blir startet for hver epost som sendes.';
$string['configsmtpoauthservice'] = 'Velg OAuth 2-tjenesten som er konfigurert til å snakke med smtp-serveren. Hvis tjenesten ikke eksisterer ennå, må du opprette den. Merk: Denne innstillingen kjører bare hvis SMTP Auth Type er satt til XOAUTH2';
$string['configsmtpsecure'] = 'Hvis SMTP-serveren krever sikker tilkobling, vennligst angi riktig protokolltype.';
$string['configsmtpuser'] = 'Dersom du har oppgitt en SMTP-server over, og serveren krever godkjenning, må du skrive inn brukernavn og passord her.';
$string['configstartwday'] = 'Uken starter på';
$string['configstatsfirstrun'] = 'Dette setter hvor langt tilbake i tid loggene skal bearbeides <b>første gangen</b> cron kjører statistikk-rutinene. Hvis du har mye trafikk og leier et webhotell (som ofte deler maskinvare med mange andre) er det neppe en god ide å sette for langt tilbake i tid.';
$string['configstatsmaxruntime'] = 'Statistikk-kjøringen kan være svært prosessorintensiv, så bruk en kombinasjon av dette feltet og det neste for å spesifisere hvor lenge en skal holde på.';
$string['configstatsmaxruntime2'] = 'Statistikkbehandling kan være ganske intensiv, oppgi maxtid en kan bruke for å samle en dags statistikk. Max. antall dager som kan behandles i en cronkjøring er 31.';
$string['configstatsmaxruntime3'] = 'Dette angir makstiden serveren får bruke på statistikkgenerering hver dag. Dette sikrer at ikke serveren bruker så mye prosessorkraft på statistikken at ytelsen går ned. Maks antall dager som skal gjennomgås ved hver cron-kjøring settes under.';
$string['configstatsruntimedays'] = 'Dette angir maks antall dager som skal gjennomgås i hver statistikkjøring. Når statistikken er oppdatert, vil bare en dag bli gjennomgått, så sett denne verdien avhengig av serverbelastningen på din installasjon. Reduser verdien hvis du trenger kortere cronkjøringer.';
$string['configstatsruntimestart'] = 'Når skal cronjobben som kjører statestikkgjennomgangen starte? Det anbefales å angi forskjellige tidpunkter hvis det er flere Moodleportaler på en server.';
$string['configstatsuserthreshold'] = 'Denne innstillingen spesifiserer minimum antall påmeldte brukere for et kurs som skal inkluderes i statistikkberegninger.';
$string['configstrictformsrequired'] = 'Hvis aktivert, vil brukere bli forhindret i å bruke kun mellomrom eller linjeskift i obligatoriske skjemafelt.';
$string['configstripalltitletags'] = 'Fjern haken her hvis du vil tillate HTML-tagger i aktivitets- og ressursnavn.';
$string['configsupportavailability'] = 'Bestemmer hvem som har tilgang til å kontakte portalens support fra bunnteksten.';
$string['configsupportemail'] = 'Hvis SMTP er konfigurert på denne portalen og en brukerstøtteside ikke er konfigurert, vil denne e-postadressen bli sendt til generelle hjelpeforespørsler sendt via brukerstøtteskjemaet (for eksempel når nye brukere oppretter sine egne kontoer). Hvis sending mislykkes, vil denne e-postadressen vises for påloggede brukere.';
$string['configsupportname'] = 'Dette er navnet på en person eller enhet som tilbyr generell hjelp via supportepost eller hjemmeside.';
$string['configsupportpage'] = 'Skriv inn URL-en til en støtteside eller la stå tomt for å koble til et kontaktskjema. Linken vises i bunnteksten på portalen.';
$string['configtempdatafoldercleanup'] = 'Fjern midlertidige file som er  elder enn valgt alder fra data-mappen.';
$string['configthemedesignermode'] = 'Normalt vil all grafikk i designet og stilark bli mellomlagret i nettleserne og på serveren i ganske lang tid for å gi best mulig ytelse. Dersom du er designutvikler eller skriver kode vil du kanskje aktivere denne for å unngå server-mellomlagrede visninger. Advarsel: Dette vil gjøre portalen tregere for samtlige brukere! Alternativt kan du iblant resette servermellomlageret manuelt - det gjøres fra Designgalleriet.';
$string['configthemelist'] = 'La denne stå tom dersom du ønsker at alle gyldige design skal kunne velges: Hvis du vil korte ned listen over design, kan du spesifisere en kommaseparert liste med navn her (Ikke bruk mellomrom!).
Eksempelvis: standard,orangewhite';
$string['configtimezone'] = 'Dette er standard tidssone for visning av datoer - hver bruker kan overstyre denne innstillingen i profilen sin. Cron-oppgaver og andre serverinnstillinger er spesifisert i denne tidssonen. Du bør endre innstillingen hvis den vises som "Ugyldig tidssone"';
$string['configuseblogassociations'] = 'Skal brukere få anledning til å organisere egen blogg ved å assossiere innlegg med kurs og kursmoduler?';
$string['configusesitenameforsitepages'] = 'Hvis aktivert, vil kursportalens kortnavn bli brukt på navigasjonsnoder for portalsider i stedet for teksten "Forsideressurser"';
$string['configusetags'] = 'Skal taggfunksjonalitet på hele portalen slås på?';
$string['configvariables'] = 'Innstillinger';
$string['configverifychangedemail'] = 'Aktiverer verifisering av e-postadressen når den endres - og sjekker mot innstillingene for tillate/sperrede e-postdomener. Hvis deaktivert vil domenesjekken bare bli utført for nye brukere.';
$string['configvisiblecourses'] = 'Vis kurs fra skjulte kategorier';
$string['configwarning'] = 'Vær forsiktig med disse innstillingene. Feil valg kan skape problemer.';
$string['configyuicomboloading'] = 'Dette valget aktiverer kombinert fillastingsoptimering for YUI-biblioteker. Dette valget bør aktiveres på produksjonsportaler for best mulig ytelse.';
$string['confirmation'] = 'Bekreftelse';
$string['confirmationpending'] = 'Bekreftelse venter';
$string['confirmcontextlock'] = '{$a->contextname} er åpent. Låsing vil gjøre at den kun kan leses og forhindre brukere i å gjøre endringer. Ønsker du å fortsette?';
$string['confirmcontextunlock'] = '{$a->contextname} er låst. Åpning vil tillate at brukere kan gjøre endringer. Ønsker du å fortsette?';
$string['confirmdeletecomments'] = 'Er du sikker på at du vil slette de valgte kommentarene?';
$string['confirmed'] = 'Bekreftet';
$string['contactsitesupport'] = 'Kontakt Support for portalen';
$string['contenttypeuninstalling'] = 'Det er {$a->count} innholdselementer støttet av {$a->type}. Disse vil bli slettet. Ønsker du å fortsette?';
$string['contextlockappliestoadmin'] = 'Kontekstslåsing gjelder kun administratorier';
$string['contextlockappliestoadmin_desc'] = 'Dersom deaktivert vil administratorer ha skrivetilgang i låste kontekster.';
$string['contextlocking'] = 'Kontekstlåsing';
$string['contextlocking_desc'] = 'Denne innstillinge aktiverer kun les tilgang for valgte kategorier, kurs, aktiviteter og blokker.';
$string['cookiesecure'] = 'Bare sikre cookies';
$string['country'] = 'Standard land';
$string['course_customfield'] = 'Egendefinerte kursfelter';
$string['coursecolor'] = 'Farge {$a}';
$string['coursecolorheading_desc'] = 'Alle kurs uten angitt kursbilde vil vises med et farget mønster i stedet på Dashbordet. Fargene som skal brukes ved genereringen av mønsteret angis under.';
$string['coursecolorsettings'] = 'Farger på genererte kursbilder';
$string['coursecontact'] = 'Kursansvarlige';
$string['coursecontact_desc'] = 'Denne innstillingen lar deg bestemme hvilke(n) roller som skal vises i kursbeskrivelsen. Du må MINST velge EN rolle.';
$string['coursecontactduplicates'] = 'Vis alle kurskontaktroller';
$string['coursecontactduplicates_desc'] = 'Dersom aktivert vil brukere med mer enn en av de valgte kurskontaktrollene bli vist i kursbeskrivelsen sammen med hver av rollene sine. Ellers vil de bare bli vist med en rolle. Rollen som vises er den som ligger øverst i listen på siden "Definer roller".';
$string['coursecreationguide'] = 'URL for oppretting av Moodle-kurs';
$string['coursecreationguide_help'] = 'Definerer stien til en hurtigstartguide med korte videoer og generelle tips for å lage kurs. En lenke til veiledningen vises på Mine kurs-siden når det ikke er noen kurs å vise. Kun brukere med mulighet til å lage kurs vil se koblingen.';
$string['coursegraceperiodafter'] = 'Venteperiode for tidligere kurs';
$string['coursegraceperiodbefore'] = 'Venteperiode for fremtidige kurs';
$string['courselistshortnames'] = 'Vis utvidede kursnavn';
$string['courselistshortnames_desc'] = 'Når man viser kurslister, eller referer til kurs på administrasjonsskjermer, vises både kursets kortnavn og hele navnet. Når du slår på denne innstillingen, bruker visningen språkstrengen \'courseextendednamedisplay\' slik at du kan endre det som vises ved hjelp av Språk-tilpasning.';
$string['coursemgmt'] = 'Legg til/Endre kurs og kategorier';
$string['courseoverview'] = 'Kursoversikt';
$string['courserequestnotify'] = 'Anmodning om å opprette nytt kurs';
$string['courserequestnotifyemail'] = '<p>Bruker: {$a->user} ber om et nytt kurs.</p>
<p>Du kan behandle forespørselen på <a href="{$a->link}">{$a->link}</a>.</p>

<p>Forespørselsdetaljer:</p>
<ul>
<li>Kursnavn: {$a->fullname}</li>
<li>Kursets kortnavn : {$a->shortname}</li>
<li>Kategori: {$a->category}</li>
<li>Begrunnelse for forespørsel: {$a->reason}</li>
</ul>';
$string['courserequests'] = 'Kursønsker';
$string['courserequestspending'] = 'Kursforespørsler under behandling';
$string['courses'] = 'Kurs';
$string['coursesperpage'] = 'Kurs pr.side';
$string['courseswithsummarieslimit'] = 'Kurs med begrenset sammendrag';
$string['creatornewroleid'] = 'Kursoppretters rolle i nye kurs';
$string['creatornewroleid_help'] = 'Dersom brukeren ikke allerede har rett til å administrere det nye kurset, vil brukeren bli automatisk tildelt denne rollen ved påmelding.';
$string['cron'] = 'Cron';
$string['cron_enabled'] = 'Aktivér cron';
$string['cron_enabled_desc'] = 'Hvis deaktivert forhindrer systemet å starte nye bakgrunnsoppgaver. Dette alternativet er kun ment for midlertidig bruk, f.eks. før omstart. Hvis du lar den være av i lang tid, vil viktig funksjonalitet ikke fungere.';
$string['cron_help'] = 'Cron.php er et skript som kjører flere ulike oppgaver til bestemte tider, som f.eks. sende ut e-post fra foruminnlegg. Skriptet bør kjøres med jevne mellomrom - ideelt hvert minutt.';
$string['cron_keepalive'] = 'Holde i live';
$string['cron_keepalive_desc'] = 'Hvor lang tid det tar å fortsette å spørre etter flere oppgaver. Denne innstillingen er for å sikre at cron alltid kjører. Hvis du bruker dedikerte oppgaveløpere, sett den til 0. Ellers sett den til en verdi som ligner på samtidighetsgrensen for adhoc-oppgaver. Unngå lengre tid. Maksimal tid er 15 minutter.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Tillat kun Cron fra kommandolinja';
$string['cronerrorclionly'] = 'Beklager, internett-tilgangen til denne siden er sperret av administrator.';
$string['cronerrorpassword'] = 'Beklager, du har ikke gyldig passord for tilgang til denne siden.';
$string['croninfrequent'] = 'Tiden mellom de to siste kjøringene av cron vedlikeholdsskript var {$a->actual} sekunder. Vi anbefaler å konfigurere den til å kjøre oftere';
$string['cronremotepassword'] = 'Cron passord for fjerntilgang';
$string['cronwarning'] = '<a href="{$a->url}">admin/cron.php skriptet </a> har ikke blitt kjørt siden {$a->actual} og er forventet å kjøre hver {$a->expected}.';
$string['cronwarningcli'] = '<code> admin/cli/cron.php </code> skriptet har ikke blitt kjørt siden {$a->actual} og skal kjøre hvert {$a->expected}.';
$string['cronwarningnever'] = '<code>admin/cli/cron.php</code> skriptet har aldri kjørt og bør kjøre hver {$a->expected}.';
$string['cronwarningneverweb'] = 'Cron-jobben <a href="{$a->url}">admin/cron.php script</a> har aldri blitt kjørt og forventes å kjøre hvert {$a->expected}.';
$string['ctyperequired'] = 'PHP-tillegget ctype er nå påkrevd av Moodle for å forbedre portalytelse og å støtte kompatibilitet med en del andre språk.';
$string['curlcache'] = 'cURL mellomlager TTL';
$string['curlrequired'] = 'PHP-tillegget cURL kreves nå av Moodle for å kommunisere med Moodles fillagre.';
$string['curlsecurityallowedport'] = 'Liste over tillatte porter for cURL';
$string['curlsecurityallowedportsyntax'] = 'Liste med portnumre som cURL kan koble til. Kun oppføringer som består av heltall er gyldige. Skriv hver oppføring på en egen linje. Dersom feltet holdes tomt er alle porter tilgjengelige. Dersom det skrives noe ifeltet bør både 80 og 443 være med slik at cURL kan koble til standarportene for HTTP og HTTPS.';
$string['curlsecurityblockedhosts'] = 'Liste over blokkerte cURL-verter';
$string['curlsecurityblockedhostssyntax'] = 'Skriv inn nye oppføringer atskilt med linjeskift. Gyldige verdier er enten fullstendige IPv4- eller IPv6-adresser (slik som 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::) som samsvarer med en enkelt vert; eller CIDR-notasjon (slik som 231.54.211.0/20 eller fe80::/64); eller en blokk med IP-adresser (slik som 231.3.56.10-20 eller fe80::1111-bbbb) hvor blokken samsvarer med siste gruppe av adresser; eller domenenavn (slik som localhost eller example.com); eller asterix-domenenavn (slik som *.example.com eller *.sub.example.com). Tomme linjer er ikke tillatt.';
$string['curlsecurityurlblocked'] = 'Denne URLen er blokkert.';
$string['curltimeoutkbitrate'] = 'Bitrate som skal brukes når det beregnes cURL timeout (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Denne innstillingen brukes til å beregne en fornuftig timeout ved store cURL-forespørsler. Som en del av denne beregningen gjøres det en HTTP HEAD-forespørsel for å bestemme størrelsen på innholdet. Hvis denne settes til 0, blir denne forespørselen deaktivert.';
$string['currenttheme'] = 'Gjeldende design';
$string['customcheck'] = 'Andre kontroller';
$string['custommenu'] = 'Egendefinert meny';
$string['custommenuitems'] = 'Egendefinerte menyelementer';
$string['customusermenuitems'] = 'Brukermenyelementer';
$string['datarootsecurityerror'] = '<p><strong>SIKKERHETSADVARSEL!</strong></p><p>Rotkatalogen for dine Moodledata er plassert feil og er fritt tilgjengelig fra web. Dette betyr at alle dine private filer er tilgjengelige for hvem som helst, og du må regne med at hackere vil bruke informasjonen her til å finne svakheter i brukernavn/passord og skaffe seg uautorisert tilgang til din installasjon!</p>
<p>Du <em>må</em> flytte moodledata-katalogen ({$a}) til et annet sted UTENFOR webområdet og oppdatere <code>$CFG->dataroot</code> innstillingen i config.php tilsvarende.</p>';
$string['datarootsecuritywarning'] = 'Site-oppsettet ditt er kanskje ikke sikkert nok. Vennligst sjekk at dataroot katalogen ({$a}) ikke er direkte tilgjengelig via web.';
$string['dbprefixtoolong'] = 'Nettstedets databaseprefiks ($CFG->prefix) er for langt ({$a->current} tegn). Maksimalt antall tegn tillatt er {$a->maximum}.';
$string['dbsessions'] = 'Bruk databasen til sesjonsinformasjon';
$string['debug'] = 'Debug meldinger';
$string['debugall'] = 'ALL: Vis alle fornuftige PHP debug-meldinger';
$string['debugdeveloper'] = 'Utvikler: Utvidede Moodle-debug meldinger for utviklere.';
$string['debugdisplay'] = 'Vis debug meldinger';
$string['debugging'] = 'Debugging';
$string['debugminimal'] = 'MINIMAL: Vis bare de verste feilmeldingene';
$string['debugnone'] = 'INGEN: Ikke vis noen feil eller advarsler';
$string['debugnormal'] = 'NORMAL: Vis feilmeldinger, advarsler og notiser';
$string['debugpageinfo'] = 'Vise sideinformasjon';
$string['debugsqltrace'] = 'Vis opprinnelsen til SQL-kall';
$string['debugsqltrace1'] = 'Vis bare en enkelt linje med kall';
$string['debugsqltrace100'] = 'Vis full kildesporing';
$string['debugsqltrace2'] = 'Vis to linjer av kildesporing';
$string['debugsqltrace_desc'] = 'Hvis aktivert, legges en delvis eller full PHP-stakksporing til SQL som en kommentar.';
$string['debugstringids'] = 'Vis opphavet til språkstrengene';
$string['debugstringids_desc'] = 'Denne valgmuligheten er designet for å hjelpe oversettere. Når denne funksjonen er aktivert, vises språkfilen og streng-IDen ved siden av hver resultatstreng hvis du legger til parameteren "?strings=1" eller "&strings=1" i slutten av URL-en.';
$string['debugtemplateinfo'] = 'Vis malinformasjon';
$string['debugtemplateinfo_desc'] = 'Hvis aktivert, vises maler som brukes for gjengivelse som kommentarer i HTML-siden på siden. Bruk kun for midlertidig feilsøking, da det produserer HTML-valideringsfeil og kan ødelegge enkelte sideskript. Det kan også ødelegge kjernefunksjonalitet';
$string['debugvalidators'] = 'Vis valideringslenker';
$string['defaultcity'] = 'Standard sted';
$string['defaultcity_help'] = 'Dette blir standard stedsnavn når det opprettes nye brukere.';
$string['defaultformatnotset'] = 'Kunne ikke fastslå standard kursformat. Vennligst sjekk portalinnstillingene.';
$string['defaulthomepage'] = 'Standard startside for brukere';
$string['defaultrequestcategory'] = 'Standard kategori for kursønsker';
$string['defaultsettinginfo'] = 'Standard: {$a}';
$string['defaultuserroleid'] = 'Standard rolle for alle brukere';
$string['deletedplugintypesdetected'] = 'Det ble oppdaget en slettet modul, \'{$a}\'. Denne skulle blitt migrert/avinstallert under avviklingsvinduet. Dette er nå en modul som ikke støttes, og installasjon/oppgradering kan ikke fortsette før denne modulen er avinstallert.';
$string['deleteduserx'] = 'Slettet bruker {$a}';
$string['deleteincompleteusers'] = 'Slett ufullstendige brukere etter';
$string['deleteunconfirmed'] = 'Slett ubekreftede brukere etter';
$string['deleteuser'] = 'Slett bruker';
$string['density'] = 'Tetthet';
$string['denyemailaddresses'] = 'Ikke tillatte domener';
$string['development'] = 'Utvikling';
$string['devicetype'] = 'Enhetstype';
$string['devlibdirpresent'] = 'Mapper med utviklingsbiblioteker, spesielt <em>/vendor</em> og <em>/node_modules</em>, bør aldri tas med på portaler i produksjon. Se på<a href="{$a->moreinfourl}">Sikkerhetsoversikt</a> for flere detaljer.';
$string['disabled'] = 'Deaktivert';
$string['disableplugin'] = 'Deaktiver {$a}';
$string['disableuserimages'] = 'Slå av Brukerprofil-bilder';
$string['displayerrorswarning'] = 'Aktivering av PHP-innstillingen <em>display_errors</em> frarådes på portaler i produksjon siden noen av feilmeldingene kan inneholde sensitiv informasjon om serveren din.';
$string['displayloginfailures'] = 'Vis mislykkede innloggsforsøk';
$string['divertallemails'] = 'Viderekobling av e-post';
$string['divertallemailsdetail'] = 'Brukes som et beskyttelsesmiddel i utviklingsmiljøer når du tester e-post og bør ikke brukes i produksjonen.';
$string['divertallemailsexcept'] = 'Unntak for viderekobling på e-post';
$string['divertallemailsexcept_desc'] = 'En liste over unntaksregler for e-post atskilt med komma eller nye linjer. Hver regel tolkes som et vanlig uttrykk, f.eks. <pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Viderekoble alle e-poster';
$string['divertallemailsto_desc'] = 'Hvis angitt, blir alle e-postmeldinger viderekoblet til denne e-postadressen i stedet.';
$string['dndallowtextandlinks'] = 'Dra- og slipp opplasting av tekst/lenker';
$string['doclang'] = 'Språkvalg for dokumentasjon';
$string['docroot'] = 'Moodle Docs rotkatalog';
$string['doctonewwindow'] = 'Åpne i nytt vindu';
$string['doesnotfit'] = 'Visningsinnstillinger for e-post';
$string['doesnotfitdetail'] = 'Visningsinnstillinger for epost som sendes fra Moodle';
$string['download'] = 'Nedlasting';
$string['downloadcoursecontentallowed'] = 'Funksjonen for nedlasting av kursinnhold tilgjengelig';
$string['downloadcoursecontentallowed_desc'] = 'Om nedlastingsfunksjonen for kursinnhold er tilgjengelig for kurs. Når det er tilgjengelig, kan nedlastning av kursinnhold aktiveres / deaktiveres ved hjelp av innstillingen "Aktiver nedlasting av kursinnhold" i kursredigeringsmenyen (standard for dette kan angis i <a href={$a} target="_blank"> Kurs standardinnstillinger </a>).';
$string['durationunits'] = 'Varighetsenheter';
$string['edithelpdocs'] = 'Rediger hjelpedokumenter';
$string['editlang'] = '<b>Rediger</b>';
$string['editorbackgroundcolor'] = 'Bakgrunnsfarge';
$string['editordictionary'] = 'Editor ordliste';
$string['editorfontfamily'] = 'Fontfamilie';
$string['editorfontlist'] = 'Fontliste';
$string['editorfontsize'] = 'Standard fontstørrelse';
$string['editorhidebuttons'] = 'Skjulte knapper';
$string['editorkillword'] = 'Word-filter';
$string['editorspelling'] = 'Stavekontroll';
$string['editorspellinghelp'] = 'Kobler til/fra stavekontroll. Dersom aktivert må <strong>aspell</strong> være installert på serveren.';
$string['editstrings'] = 'Rediger strenger';
$string['emailchangeconfirmation'] = 'E-postbekreftelse';
$string['emaildkim'] = 'DKIM e-signering';
$string['emaildkiminfo'] = 'Hvis både DKIM-velgeren er angitt og en privat sertifikatfil blir funnet som samsvarer med e-postadressen "Fra" -adressedomene i $ CFG->dataroot/dkim/[domain]/[selector] .private, vil e-posten bli signert. I de fleste tilfeller (f.eks. Hvis tillatte e-postdomener er tomme), trengs bare et enkelt sertifikat i: <code>{$a->path}</code>. For mer informasjon om oppsett, se  <a href="{$a->docs}">E-postkonfigurering</a>.';
$string['emaildkimselector'] = 'DKIM-velger';
$string['emailfromvia'] = 'Epost via informasjon';
$string['emailheaders'] = 'E-post headere';
$string['emailsubjectprefix'] = 'Epostemne prefikstekst';
$string['emoticonalt'] = 'Alternativ tekst';
$string['emoticoncomponent'] = 'Bildefragment';
$string['emoticonimagename'] = 'Navn på bildet';
$string['emoticons'] = 'Emoticons';
$string['emoticons_desc'] = 'Dette skjemaet definerer hvilke emosjoner (smilefjes) som skal brukes på din portal. For å fjerne en rad fra tabellen, kan du lagre med tomme felt i en av de obligatoriske feltene. For å legge inn enn ny emosjon fyller du ut den siste tomme raden. For å tilbakestille til standardverdier følger du  lenken over.

* Tekst (Obligatorisk) - Denne teksten blir erstattet med bildet av emosjonen. Teksten må være minst to tegn lang.
* Bildenavn (Obligatorisk) - Bildefil-navnet uten filtype (ikke med .jpg, .gif osv). Filnavnet oppgis relativt til fragment-pix mappen.
* Bildefragment (Obligatorisk) - Fragmentmappen som inneholder ikonet.
* En alternativ tekst (valgfritt) - Streng ID og en alternativ tekst som vises hvis ikke bildefilen kan vises.';
$string['emoticonsreset'] = 'TIlbakestill emosjoner til standard oppsett';
$string['emoticontext'] = 'Tekst';
$string['emptysettingvalue'] = 'Tom';
$string['enableanalytics'] = 'Analyse';
$string['enableblogs'] = 'Aktiver blogger';
$string['enablecalendarexport'] = 'Slå på kalendereksport';
$string['enablecomments'] = 'Aktiver kommentarer';
$string['enablecommunicationsubsystem'] = 'Aktiver kommunikasjonsundersystemet';
$string['enablecommunicationsubsystem_desc'] = 'Tillat integrasjon med kommunikasjonsleverandører som Matrix slik at lærere og elever kan kommunisere lettere. Du kan administrere disse integrasjonene i <a href="settings.php?section=managecommunicationproviders">Plugins</a>.';
$string['enablecourserelativedates'] = 'Aktivér relative datoer';
$string['enablecourserelativedates_desc'] = 'Tillater kurs å settes opp til å vise datoer relativt til brukerens startdato i kurset.';
$string['enablecourserequests'] = 'Aktiviser kursønsker';
$string['enabled'] = 'Aktivert';
$string['enabledashboard'] = 'Aktivér Dashbord';
$string['enabledashboard_help'] = 'Dashbord kan vise tidslinje, kalender og nylig brukte elementer. Du kan angi en annen standard Min startside for alle og la brukere tilpasse sitt eget Dashbord.';
$string['enableglobalsearch'] = 'Aktiver globalt søk';
$string['enableglobalsearch_desc'] = 'Hvis aktivert, vil alle data bli indeksert og synkronisert via en cron-jobb.';
$string['enablegravatar'] = 'Aktiver Gravatar';
$string['enablegravatar_help'] = 'Hvis Gravatar er aktivert vil Moodle hente et profilbilde herfra når brukeren ikke har lastet opp noe bilde.';
$string['enablemobilewebservice'] = 'Aktiver webservice for mobile enheter';
$string['enablepdfexportfont'] = 'Aktiver PDF-fonter';
$string['enablepdfexportfont_desc'] = 'Hvis portalen din har kurs på forskjellige språk som trenger andre fonter i genererte PDF-filer, kan du velge å angi skrifttypen i kursinnstillingene. Du må spesifisere tilgjengelige fonter i $CFG->pdfexportfont i config.php.';
$string['enableplugin'] = 'Aktiver {$a}';
$string['enablerecordcache'] = 'Aktiviser hurtiglagring';
$string['enablerssfeeds'] = 'Aktiviser RSS';
$string['enablesearchareas'] = 'Aktivér søkeområder';
$string['enablesharingtomoodlenet'] = 'Aktiver deling til MoodleNet (utgående)';
$string['enablesharingtomoodlenet_desc'] = 'Tillat brukere å dele kursinnhold til en konfigurert MoodleNet-instanse hvis de har de rette tillatelsene.';
$string['enablestats'] = 'Aktiviser statistikk';
$string['enabletrusttext'] = 'Aktiviser Godkjent Innhold';
$string['enableuserfeedback'] = 'Aktivér tilbakemelding om Moodle';
$string['enableuserfeedback_desc'] = 'Hvis dette er aktivert, vises en kobling "Gi tilbakemelding om denne programvaren" i bunnteksten for brukere å gi tilbakemelding om Moodle-programvaren til Moodle HQ. Hvis alternativet \'Neste påminnelse om tilbakemelding\' er angitt, vises brukeren også en påminnelse på dashbordet med det angitte intervallet. Innstilling av \'Neste påminnelse om påminnelse\' til \'Aldri\' deaktiverer påminnelsen om dashbordet, mens du legger igjen koblingen \'Gi tilbakemelding om denne programvaren\' i bunnteksten.';
$string['enablewebservices'] = 'Aktiver webtjenester';
$string['enablewsdocumentation'] = 'Webtjenester dokumentasjon';
$string['encryptedpassword_edit'] = 'Legg til ny verdi';
$string['encryptedpassword_set'] = '(Satt og kryptert)';
$string['enroladminnewcourse'] = 'Automatisk innemelding av administrator i nye kurs';
$string['enroladminnewcourse_help'] = 'Når en administrator legger til et nytt kurs, bør de automatisk registreres og tildeles lærerrollen i nye kurs?';
$string['enrolinstancedefaults'] = 'Standardverdier for påmeldinger';
$string['enrolinstancedefaults_desc'] = 'Standard påmeldingsinnstillinger for nye kurs';
$string['enrolmultipleusers'] = 'Meld inn brukerne';
$string['ensureauroraversion'] = 'Nettstedet ditt kjører på Amazon Aurora-databasemotoren. Sørg for at MySQL-versjonen i Amazon Aurora er kompatibel med Moodle-versjonen du installerer eller oppgraderer til. Du kan sjekke kompatibiliteten i <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraMySQLReleaseNotes/AuroraMySQL.Updates.30Updates.html" target="_blank">oppdateringer av databasemotoren for Amazon Aurora MySQL versjon 3</a>.';
$string['entitytasklog'] = 'Oppgavelogg';
$string['environment'] = 'Miljø';
$string['environmenterrortodo'] = 'Du må løse de ovennevnte miljøproblemene (feilmeldingene) som ble oppdaget før du fortsetter å installere denne Moodle-versjonen!';
$string['environmenterrorupgrade'] = 'Advarsel: du bør løse de ovennevnte miljøproblemene (feilmeldingene) som ble oppdaget før du fortsetter å installere denne versjonen av Moodle! Oppgradering uten å løse disse kravene kan forårsake problemer som datatap. Er du helt sikker på at du ønsker å fortsette med oppgraderingen?';
$string['environmentmariadbwrongdbtype'] = 'Feil $CFG->dbtype. Du må endre den i config.php-filen fra \'mysqli\' til \'mariadb\'.';
$string['environmentmustfixsetting'] = 'PHP-innstillingene må endres.';
$string['environmentok'] = 'Servermiljøet ditt tilfredsstiller alle minstekrav.';
$string['environmentrecommendcustomcheck'] = 'Hvis denne testen feiler, kan det bety et mulig problem.';
$string['environmentrecommendinstall'] = 'er anbefalt at du installerer/tillater';
$string['environmentrecommendversion'] = 'versjon {$a->needed} er anbefalt og du kjører {$a->current}';
$string['environmentrequirecustomcheck'] = 'denne testen må godkjennes';
$string['environmentrequireinstall'] = 'er påkrevd at du installerer/tillater';
$string['environmentrequireversion'] = 'Du må ha versjon {$a->needed}. Du kjører {$a->current}';
$string['environmentsettingok'] = 'anbefalt innstilling oppdaget';
$string['environmentshouldfixcustomcheck'] = 'bør aktiveres for best resultat';
$string['environmentshouldfixsetting'] = 'PHP-innstillingen bør endres.';
$string['environmentxmlerror'] = 'Feil oppstod under innlesing av miljødata ({$a->error_code})';
$string['errordeletingconfig'] = 'Det oppstod en feil under sletting av innstillingene for modulen \'{$a}\'.';
$string['errorsetting'] = 'Kunne ikke lagre innstillingene';
$string['errorwithsettings'] = 'Noen innstillinger kunne ikke lagres pga en feil';
$string['eventshandlersinuse'] = 'Følgende moduler på systemet benytter Events 1 API håndtering:  \'{$a}\'. Vennligst oppdater dem til å benytte Events 2 API. Se https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers for mer informasjon.';
$string['everyonewhocan'] = 'Alle som kan \'{$a}\'';
$string['exceptions'] = 'unntak';
$string['execpathnotallowed'] = 'Muligheten for å angi kjørbare og lokale programstier er deaktivert i config.php';
$string['experimental'] = 'Eksperimentell';
$string['experimentalsettings'] = 'Eksperimentelle innstillinger';
$string['extendedusernamechars'] = 'Tillat utvidet tegnsett i brukernavn';
$string['extramemorylimit'] = 'Utvidet minnegrense for PHP';
$string['fatalsessionautostart'] = '<p>Alvorlig konfigurasjonsfeil oppdaget, vennligst varsle administrator.</p><p>For å fungere normalt krever Moodle at administrator endrer PHP-innstillingene.</p><p><code>session.auto_start</code> må endres til <code>off</code>.</p><p>Denne endringen gjøres i <code>php.ini</code>, Apache/IIS <br />oppsettet eller <code>.htaccess</code> filen på serveren.</p>';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'Favorittikonet vises ved siden av sidetittelen i nettleserfanen. Et Moodle-favicon vises hvis et tilpasset favorittikon ikke er oppgitt.';
$string['feedbacksettings'] = 'Innstillinger for tilbakemelding';
$string['fileconversioncleanuptask'] = 'Rydder opp i midlertidige filer etter filkonverteringer';
$string['filecreated'] = 'Ny fil opprettet';
$string['filescleanupperiod'] = 'Rydd opp i filer fra slettede kontekster';
$string['filescleanupperiod_help'] = 'Hvor ofte blir papirkurvfiler slettet. Dette er filer som er assosiert med en kontekst som ikke lenger eksisterer, for eksempel når et kurs blir slettet. Merk: Denne innstillingen kan resultere i manglende filer i et kurs som er sikkerhetskopiert, slettet og deretter gjenopprettet hvis innstillingen \'Inkluder filer\' (backup_auto_files) i \'Automated backup settings\' er deaktivert.';
$string['filesizeunits'] = 'filstørrelseenheter';
$string['filestoredin'] = 'Lagre fil i mappen:';
$string['filestoredinhelp'] = 'Hvor filen vil bli lagret';
$string['filterall'] = 'Filtrer alle strenger';
$string['filtermatchoneperpage'] = 'Filtrer ett treff per side';
$string['filtermatchonepertext'] = 'Filtrer ett treff per tekst';
$string['filternavigationwithsystemcontext'] = 'Filternavigasjon med systemkontekst';
$string['filters'] = 'Filtere';
$string['filtersettings'] = 'Filterinnstillinger';
$string['filtersettingsgeneral'] = 'Generelle filterinnstillinger';
$string['filteruploadedfiles'] = 'Filtrer opplastede filer';
$string['forceclean'] = 'Rensk innhold over alt.';
$string['forceclean_desc'] = 'Innhold som legges til portalen renses normalt før det vises, for å fjerne alt som kan være en sikkerhetstrussel. Innhold blir imidlertid ikke renset på visse steder som aktivitetsbeskrivelser, sideressurser eller HTML-blokker for å tillate skript, media, innebygde rammer osv. som kan legges til. Hvis denne innstillingen er aktivert, vil ALT innhold bli renset. Dette kan føre til at eksisterende innhold ikke lenger vises riktig.';
$string['forcelogin'] = 'Krev at brukere logger inn';
$string['forceloginforprofileimage'] = 'Tving brukere til å logge inn før de får se profilbilder';
$string['forceloginforprofileimage_help'] = 'Hvis aktivert må brukere logge inn før de får se profilbilder. Standard profilbilde vil bli brukt i alle meldinger som sendes ut via e-post.';
$string['forceloginforprofiles'] = 'Krev at brukere logger inn før de får se profiler.';
$string['forcetimezone'] = 'Overstyr tidssone';
$string['formatuninstallwithcourses'] = '{$a->count} kurs bruker {$a->format}. Disse kursenes format vil bli endret til {$a->defaultformat} (standardformat for denne portalen). Noen data knyttet til det gamle formatet kan gå tapt. Er du sikker på at du vil fortsette?';
$string['frontpage'] = 'Forside';
$string['frontpagebackup'] = 'Forside backup';
$string['frontpagedefaultrole'] = 'Standard forsiderolle';
$string['frontpagefilters'] = 'Filtere for Forsiden';
$string['frontpageloggedin'] = 'Forsidens elementer når innlogget';
$string['frontpageoverrides'] = 'Overstyringer for Forsiden';
$string['frontpagequestions'] = 'Global spørsmålsbank';
$string['frontpagerestore'] = 'Forside gjenoppretting';
$string['frontpageroles'] = 'Forside roller';
$string['frontpagesettings'] = 'Forside innstillinger';
$string['fullnamedisplay'] = 'Format på fullt navn';
$string['fullnamedisplayprivate'] = 'Fullt navneformat - privat';
$string['gdrequired'] = 'GD-filtypen er nå påkrevd av Moodle for bildekonvertering.';
$string['generalsettings'] = 'Generelle innstillinger';
$string['geoipdbedition'] = 'GeoIP database-versjon';
$string['geoipdbedition_desc'] = 'Velg versjonen av GeoIP-databasen som skal lastes ned. Vær oppmerksom på at GeoIP2-City databasen krever en gyldig, betalt lisens';
$string['geoipfile'] = 'GeoIP City DB';
$string['geoipmaxmindaccid'] = 'MaxMind kontoID';
$string['geoipmaxmindaccid_desc'] = 'MaxMind kontoID';
$string['geoipmaxmindlicensekey'] = 'MaxMind lisensnøkkel';
$string['geoipmaxmindlicensekey_desc'] = 'MaxMind lisensnøkkel';
$string['geopluginapikey'] = 'GeoPlugin API-nøkkel';
$string['geopluginapikey_desc'] = 'API-nøkkelen brukt for tilgang til GeoPlugin tjenesten. Skaff deg egen nøkkel på <a href="https://www.geoplugin.com/" target="_blank">geoplugin.com</a>.';
$string['getremoteaddrconf'] = 'Logget IP-adressekilde';
$string['globalsearch'] = 'Globalt søk';
$string['globalsearchmanage'] = 'Administrere globalt søk';
$string['googlemapkey3'] = 'Google Maps API V3 nøkkel';
$string['googlemapkey3_help'] = 'Du må skrive en spesiell kode for å bruke Google Maps for IP adress lookup vizualization. Du kan få gratis kode på <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Gå til første manglende streng';
$string['gradebook'] = 'Karakterbok';
$string['gradebookroles'] = 'Roller i karakterboka';
$string['gradeexport'] = 'Primære eksportmetode for karakterer';
$string['gradeexportdefault'] = 'Standard eksportformat for karakterboka';
$string['gravatardefaulturl'] = 'Standard bilde-URL for Gravatar';
$string['gravatardefaulturl_help'] = 'Gravatar trenger et standardbilde som skal vises hvis den ikke finner et bilde for en gitt bruker. Oppgi en fullstendig URL for et bilde. Koder for å generere standardbilder er tilgjengelige fra <a href="https://docs.gravatar.com/api/avatars/images/">Gravatar for Developers - Avatar Requests</a>.';
$string['group_customfield'] = 'Gruppér egendefinerte felter';
$string['groupenrolmentkeypolicy'] = 'Nøkkel-regler for gruppepåmelding';
$string['groupenrolmentkeypolicy_desc'] = 'Hvis denne aktiveres vil Moodle sjekke påmeldingsnøkler for grupper mot gjeldende passord-regler.';
$string['grouping_customfield'] = 'Grupperer egendefinerte felter';
$string['guestroleid'] = 'Gjesterolle';
$string['guestroleid_help'] = 'Denne rollen er automatisk lagt til gjestebrukeren. Den er også midlertid satt til ikke å ta imot påmeldinger fra brukere som kommer inn på kurset via modulen for gjestepåmelding.';
$string['h5pgetcontenttypestask'] = 'Last ned tilgjengelige innholdstyper fra h5p.org';
$string['helpadminseesall'] = 'Ser administratorer alle hendelser i kalenderen eller kun fra kurs de selv de meldt inn i? Uavhenig av dette valget vil administratorer alltid administrere hendelser for hvert kurs ved å først gå til kurset og så gå inn i kalenderen derfra.';
$string['helpcalendarcustomexport'] = 'Aktiver egentilpasset eksportvalg med datoutvalg i kalendereksport. Kalendereksport må aktiveres før denne innstillingen trer i kraft.';
$string['helpexportlookahead'] = 'Hvor mange dager framover i tid skal kalenderen se etter hendelser under eksporten i det egentilpassede eksportvalget?';
$string['helpexportlookback'] = 'Hvor mange dager tilbake i tid skal kalenderen se etter hendelser under eksporten i det egentilpassede eksportvalget?';
$string['helpforcetimezone'] = 'Du kan la brukere velge tidssone individuelt, eller du kan tvinge en tidssone på alle.';
$string['helpshowicalsource'] = 'Hvis aktivert, vil abonnementnavnet og lenken for iCal-importerte hendelser vises.';
$string['helpsitemaintenance'] = 'For oppgraderinger og vedlikehold';
$string['helpstartofweek'] = 'Hvilken dag starter uken på i kalenderen?';
$string['helpupcominglookahead'] = 'Hvor mange dager (som standard) inn i fremtiden skal kalenderen se etter begivenheter?';
$string['helpupcomingmaxevents'] = 'Hvor mange (maksimum) forestående hendelser vises til brukere som en standard';
$string['helpweekenddays'] = 'Hvilke ukerdager betraktes som "weekend" og skal vises med en annen farge?';
$string['hiddenuserfields'] = 'Skjul brukerfelt';
$string['hidefromall'] = 'Skjul fra alle brukere';
$string['hidefromnone'] = 'Ikke skjul for noen';
$string['hidefromstudents'] = 'Skjul for studenter';
$string['hookcallbacknotcallable'] = 'Dette tilbakekallet fungerer ikke. Dette kan være fordi klassen eller metoden ikke eksisterer, eller fordi metoden ikke er offentlig.';
$string['hookcallbacks'] = 'Tilbakekall';
$string['hookcallbacks_help'] = 'Listen over tilbakekall som vil bli kalt når hooken sendes.

Rekkefølgen som vises er rekkefølgen tilbakekall blir sendt.

Et tilbakekall med høyere prioritet vil bli sendt før et med lavere prioritet.';
$string['hookclassmissing'] = 'Hook-klassen ble ikke funnet';
$string['hookclassmissing_desc'] = 'Hook Discovery-agenten har returnert en klasse som ikke eksisterer.';
$string['hookconfigoverride'] = 'Overstyrt';
$string['hookconfigoverride_help'] = 'Definisjonen av dette tilbakekallet har blitt overstyrt i portalens konfigurasjonsfil, config.php';
$string['hookdeprecates'] = 'Deprecated callbacks';
$string['hookdescription'] = 'Beskrivelse';
$string['hookdescriptionmissing'] = 'Hook har ikke en beskrivelsesmetode';
$string['hookname'] = 'Hook';
$string['hooksoverview'] = 'Hook-oversikt';
$string['hookunknown'] = 'Hook ikke funnet';
$string['hookunknown_desc'] = 'Objektet som dette tilbakekallet lytter til er ikke tilgjengelig. Den kan ha blitt fjernet eller omdøpt, eller den er kanskje ikke tilgjengelig i denne versjonen av Moodle.';
$string['hostname'] = 'Vertsnavn';
$string['htmleditor'] = 'HTML-Editor';
$string['htmleditorsettings'] = 'HTML-editor innstillinger';
$string['htmlsettings'] = 'HTML-innstillinger';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP sikkerhet';
$string['iconvrequired'] = 'Et nødvendig PHP-tillegg: ICONV mangler.';
$string['igbinary322buggyversion'] = 'Utvidelsen php-igbinary installert på portalen kan føre til problemer når du kjører med PHP 7.2. Du anbefales enten å oppgradere til php-igbinary 3.2.5 eller nyere, eller alternativt å oppgradere til PHP 7.3 eller nyere.';
$string['ignore'] = 'Ignorér';
$string['importantupdates_content'] = '<p>Fra og med Moodle 5.0 vil modulene chat og undersøkelse ikke lenger være en del av Moodles kjerne. Modulene vil være tilgjengelige som tilleggsmoduler i
<a href="https://moodle.org/plugins/">Moodle plugins directory</a>.</p>
<p>Om du ønsker å fortsette bruken av disse modulene må de installeres før oppgradering til Moodle 5.0</p>';
$string['importantupdates_title'] = 'Viktig oppdatering om modulene nettprat og undersøkelse';
$string['includemoduleuserdata'] = 'Ta med modulens brukerdata';
$string['incompatibleblocks'] = 'Inkompatible blokker';
$string['incompleteunicodesupport'] = 'Det nåværende oppsettet av MySQL eller MariaDB bruker \'utf8\'. Dette tegnsettet støtter ikke 4 bytes tegn noe som inkluderer enkelte emojier. Dersom du bruker et av disse tegnene vil det føre til en feil og informasjonen som sendes til databasen vil bli tapt. Vennligst vurder å bytte tegnsett til \'utf8mb4\' i innstillingene. Se dokumentasjonen for alle detaljer.';
$string['indexdata'] = 'Indeksdata';
$string['indexinginfo'] = 'Den anbefalte måten å indeksere innholdet på din portale, er å bruke cron-jobben "Globalt søk indeksering"';
$string['installhijacked'] = 'Installasjonen må fullføres fra IP-adressen den ble startet fra, beklager.';
$string['installsessionerror'] = 'Kan ikke initialisere PHP-sesjonen, vennligst sjekk at nettleseren din tillater informasjonskapsler (cookies).';
$string['intlrecommended'] = 'Intl-tillegget brukes for å forbedre landspesifikke innstillinger, f.eks. sortering baset på lokale regler.';
$string['intlrequired'] = 'INTL-tillegget er påkrevd for å forbedre flerspråkstøtte og gir mulighet for lokal sorteringsrekkefølge og lokale varianter av internett domenenavn.';
$string['invalidagedigitalconsent'] = 'Ugyldig alder for samtykke: {$a}';
$string['invalidforgottenpasswordurl'] = 'Glemt passord-URL\'en er ikke en gyldig URL.';
$string['invalidsection'] = 'Ugyldig seksjon';
$string['invalidthemepreset'] = 'Den valgte forhåndsinnstilte filen er ikke kompatibel med dette designet. SCSS-kompilasjonsfeilen var: "{$a}"';
$string['invaliduserchangeme'] = 'Brukernavn "changeme" er reservert -- du kan ikke opprette en konto med det.';
$string['ipblocked'] = 'Denne portalen er ikke tilgjengelig akkurat nå.';
$string['ipblocker'] = 'IP-blokkerer';
$string['ipblockersyntax'] = 'Skriv inn en oppføring pr. linje. Gyldige oppføringer er enten full IP-addresse (som <b>192.168.10.1</b>) peker til en bestemt vert; eller del av en adresse (som <b>192.168</b>) samsvarer med alle adresser som begynner med siffrene; eller CIDR notasjon som <b>231.54.211.0/20</b>); eller et IP-addresseområde (som <b>231.3.56.10-20</b>) hvor området  skal samsvare med siste del av adressen. Testdomener (som example.com) er ikke støttet. Blanke linjer og tekst bak et "#"-tegn blir ignorert.';
$string['iplookup'] = 'IP-adresseoppslag';
$string['iplookupgeoplugin'] = 'En <a href="http://www.geoplugin.com">geoPlugin</a> brukes for å vise geografisk informasjon. For mer presise resultater anbefaler vi at det installeres en lokal kopi av MaxMind GeoIP City -databasen.';
$string['iplookupinfo'] = 'Den gratis nettbaserte NetGeo-serveren brukes til å slå opp IP-adresseplasseringer. Databasen vedlikeholdes imidlertid ikke lenger, og kan returnere feil data. Det anbefales å installere en lokal kopi av den gratis GeoIP-databasen fra MaxMind.<br />
Hvis en Google Maps API V3-nøkkel er lagt inn, vises IP-adresseplasseringen ved hjelp av Google Maps. Du trenger en Google-konto og søke om en Google Maps API-nøkkel. Hvis ingen Google Maps API V3-nøkkel er oppgitt, vises IP-adresseplasseringen ved hjelp av OpenStreetMap.';
$string['iplookupmaxmindnote'] = 'Dette produktet inkluderer GeoIP City data laget av MaxMind, tilgjengelig for nedlasting fra <a href="http://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['iscustomadminwarnings'] = 'Det har blitt oppdaget at portalen ditt bruker en tilpasset admin-mappe. Denne funksjonen støttes ikke lenger og vil bli fjernet etter Moodle 4.2.';
$string['ishttpswarning'] = 'Portalen din er ikke sikret med HTTPS. For økt sikkerhet og forbedrede integrasjoner med andre systemer anbefales det sterkt å migrere portalen til HTTPS.';
$string['keeptagnamecase'] = 'Behold store/små bokstaver i taggene';
$string['lang'] = 'Standard språk';
$string['langcache'] = 'Mellomlagre språkmenyen';
$string['langcache_desc'] = 'Mellomlagre språkmenyen. Hvis aktivert, vil listen over tilgjengelige oversettelser også bli mellomlagret. Mellomlageret blir automatisk oppdatert hver gang du installerer eller sletter en språkpakke via det innebygde språkpakkeverktøyet. Dersom du installerer en språkpakke manuelt må du tømme alle mellomlagre for å oppdatere språkmenyen.';
$string['langlist'] = 'Språk på språkmenyen';
$string['langmenu'] = 'Vis språkmenyen';
$string['langmenuinsecurelayout'] = 'Vis språkmeny i sikker visning';
$string['langmenuinsecurelayout_desc'] = 'Hvis det er aktivert, vil en bruker kunne endre språket sitt når du prøver en quiz eller annen aktivitet ved å bruke sikker layout.';
$string['langpackwillbeupdated'] = 'MERK: I løpet av oppgraderingen vil Moodle prøve å oppdatere alle installerte språkpakker.';
$string['langstringcache'] = 'Mellomlagre alle språkstrenger';
$string['languagesettings'] = 'Innstillinger for språk';
$string['latinexcelexport'] = 'Excel tegnsett';
$string['legacyfilesaddallowed'] = 'Tillat å legge til kursfiler (fra Moodle 1.9)';
$string['legacyfilesaddallowed_help'] = 'Dersom et kurs har et filområde fra Moodle 1.9.x - kan du tillate at nye filer og mapper kan legges til dette filområdet.';
$string['legacyfilesinnewcourses'] = 'Arvede kursfiler i nye kurs';
$string['legacyfilesinnewcourses_help'] = 'Som standard er arvede kursfiler bare tilgjengelig i kurs på portaler oppgradert fra Moodle 1.9. Vennligst merk at enkelte gjøremål som sikkerhetskopiering/gjenoppretting ikke er kompatible med å aktvere kursfiler.';
$string['libcurlwarning'] = 'Det er detektert at libcurl ikke har støtte for CURLOPT_PROTOCOL. Av sikkerhetsgrunner anbefaler vi at du oppdaterer libcurl-installasjonen.';
$string['licensesettings'] = 'Lisensinnstillinger';
$string['linkadmincategories'] = 'Lenk adminkategorier';
$string['linkadmincategories_help'] = 'Hvis aktivert, vil adminkategorier vises som lenker i navigasjonen og lede til administrasjonssider.';
$string['loading'] = 'Laster';
$string['localetext'] = 'Datoformat for portalen';
$string['localstringcustomization'] = 'Lokale språk filer';
$string['location'] = 'Sted';
$string['locationsettings'] = 'Innstillinger for sted';
$string['locked'] = 'Låst';
$string['lockoutduration'] = 'Varighet på sperring.';
$string['lockoutduration_desc'] = 'Sperret brukerkonto blir låst opp igjen etter denne perioden.';
$string['lockoutemailbody'] = 'Hei {$a->firstname},

Din brukerkonto med brukernavn {$a->username} på serveren \'{$a->sitename}\'
ble sperret etter en rekke ugyldige forsøk på å logge inn.

For å låse opp brukerkontoen øyeblikkelig, gå til følgende adresse

{$a->link}

I de fleste epostprogrammer vises dette som en blå lenke som du bare kan klikke på. Hvis det ikke virker, kan du kopiere nettadressen og lime den inn i adressefeltet på toppen av nettleservinduet ditt.

Hvis du trenger hjelp, vennligst ta kontakt med portaladministrator, {$a->admin}';
$string['lockoutemailsubject'] = 'Din brukerkonto på {$a} har blitt sperret.';
$string['lockouterrorunlock'] = 'Ugyldig opplåsingsinformasjon oppgitt.';
$string['lockoutthreshold'] = 'Terskel for å sperre brukerkonti';
$string['lockoutthreshold_desc'] = 'Angi grensen for når en brukerkonto skal sperres ved mislykkede innloggingsforsøk. Denne funksjonen bidrar til å blokkere ondsinnede DDOS-angrep.';
$string['lockoutwindow'] = 'Observasjonsvindu for sperring av brukerkonti';
$string['lockoutwindow_desc'] = 'Observasjonstid for terskel for å sperre brukerkonti. Hvis det ikke er noen mislykkede forsøk på å logge inn, blir terskeltelleren nullstilt etter denne tiden.';
$string['lockrequestcategory'] = 'Forhindre kategorivalg';
$string['log'] = 'Logger';
$string['logguests'] = 'Logg gjestetilgang';
$string['logguests_help'] = 'Denne innstillingen aktiverer logging av handlinger fra gjestebrukere og brukere som ikke er innlogget.Portaler med mye trafikk vil nok kanskje deaktivere denne loggefunksjonen for å spare systemressurser. Det er anbefalt å la logging være aktivert på portaler i produksjon.';
$string['logininfoinsecurelayout'] = 'Vis innlogget bruker i sikker visning';
$string['logininfoinsecurelayout_desc'] = 'Hvis dette er aktivert, vil den påloggede brukerens fulle navn vises i navigasjonslinjen når du prøver en quiz eller annen aktivitet ved å bruke sikker layout.';
$string['loginpageautofocus'] = 'Autofokus innloggingsskjema';
$string['loginpageautofocus_help'] = 'Hvis du aktiverer denne funksjonen, øker brukervennligheten av innloggingssiden for brukere med spesielle behov.';
$string['loglifetime'] = 'Behold loggene i';
$string['logo'] = 'Logo';
$string['logo_desc'] = 'En stor logo som kan brukes som dekorasjon i enkelte design. Dette bildet bør ha ganske høy oppløsning fordi det vil bli skalert ned ved bruk. Logoer som har større bredde enn høyde vil vanligvis se best ut.';
$string['logocompact'] = 'Bedriftslogo';
$string['logocompact_desc'] = 'En kompakt versjon av logoen. Dette bildet må vises klart og tydelig selv i små størrelser.';
$string['logossettings'] = 'Logoer';
$string['logstorenotrequired'] = 'Loggarkiv ikke påkrevd';
$string['logstoressupported'] = 'Loggarkiver som støtter denne rapporten';
$string['longtimewarning'] = '<b>Vær tålmodig, denne prosessen kan ta noe tid.</b>';
$string['mailnewline'] = 'Nylinje tegn i epost';
$string['maintenancemode'] = 'I vedlikeholdsmodus';
$string['maintenancemodeisscheduled'] = 'Portalen går over til vedlikeholdsmodus om {$a->min} minutter og {$a->sec} sekunder.';
$string['maintenancemodeisscheduledlong'] = 'Denne portalen vil gå over til vedlikeholdsmodus om {$a->hours} timer, {$a->min} minutter og {$a->sec} sekunder.';
$string['maintfileopenerror'] = 'Feil ved åpning av vedlikeholdsfiler!';
$string['maintinprogress'] = 'Vedlikehold pågår ...';
$string['managecontextlock'] = 'Lås denne konteksten';
$string['managecontextlocklocked'] = '{$a->contextname} og alle underornede kontekster er nå låst.';
$string['managecontextlockunlocked'] = '{$a->contextname} og alle underordnede kontekster er nå åpnet.';
$string['managecontextunlock'] = 'Åpne denne konteksten';
$string['managecustomfields'] = 'Administrer egendefinerte kursfelter';
$string['manageformats'] = 'Administrer kursformater';
$string['manageformatsgotosettings'] = 'Standardformatet kan endres i {$a}';
$string['managelang'] = '<b>Administrer</b>';
$string['manageqbanks'] = 'Administrer spørsmålbank-moduler';
$string['manageqbehaviours'] = 'Administrer spørsmålsatferd';
$string['manageqtypes'] = 'Administrer spørsmålstyper';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Klargjøres for lansering';
$string['maturity200'] = 'Stabil versjon';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Hint: Du vil kanskje kjøre dette skriptet med -allow-unstable valget';
$string['maturitycoreinfo'] = 'Kursportalen din kjører for øyeblikket den ustabile "{$a}" utviklerversjonen.';
$string['maturitycorewarning'] = 'Du er i ferd med å installere eller oppgradere Moodle til en versjon merket som "{$a}". En slik versjon regnes ikke som produksjonsklar ennå. Hvis dette ikke er ønsket, forsikre deg om at du bruker korrekt utsjekk fra Moodles kildekode. See Moodle Docs for mer informasjon.';
$string['maxbytes'] = 'Max filstørrelse for opplasting';
$string['maxcharacter'] = '{$a} er maksimalt antall tegn';
$string['maxconsecutiveidentchars'] = 'Fortløpende identiske tegn';
$string['maxeditingtime'] = 'Max tid for endring av innlegg';
$string['maxsizeperdownloadcoursefile'] = 'Maksimum størrelse pr. fil';
$string['maxsizeperdownloadcoursefile_desc'] = 'Maksimal størrelse på hver fil når du laster ned kursinnhold. Filer som overstiger denne størrelsen vil bli utelatt fra nedlastingen.';
$string['maxtimelimit'] = 'Maks tidsgrense';
$string['maxtimelimit_desc'] = 'For å begrense maksimum PHP-kjøretid for skript i Moodle, uten at noe resultat kommer ut av det, kan du skrive inn en verdi i sekunder her. "0" betyr at Moodles standard begrensning blir benyttet. Hvis du har en front-end server med sin egen tidsgrense, kan du angi denne verdien lavere for å få med PHP-feil i loggene. Dette gjelder ikke skript som kjøres via CLI.';
$string['maxusersperpage'] = 'Maks antall brukere per side';
$string['mbstringrecommended'] = 'Installering av det valgfrie bibliotek MBSTRING er  anbefalt for at du skal forbedre ytelsen til portalen, spesielt hvis portalen støtter ikke-latinske språk.';
$string['mbstringrequired'] = 'Installere mbstring bibliotek er nødvendig for å forbedre ytelsen til portalen, spesielt hvis portalen støtter ikke-latinske språk.';
$string['mediapluginavi'] = 'Skru på filter for .avi-filer';
$string['mediapluginflv'] = 'Skru på filter for .flv-filer';
$string['mediapluginimg'] = 'Aktiver automatisk innebygging av lenkede bilder';
$string['mediapluginmov'] = 'Skru på filter for .mov-filer';
$string['mediapluginmp3'] = 'Skru på filter for .mp3-filer';
$string['mediapluginmpg'] = 'Skru på filter for .mpg-filer';
$string['mediapluginogg'] = 'Aktiviser .ogg-filteret';
$string['mediapluginogv'] = 'Aktiviser .ogv-filteret';
$string['mediapluginram'] = 'Skru på filter for .ram-filer';
$string['mediapluginrm'] = 'Skru på filter for .rm-filer';
$string['mediapluginrpm'] = 'Skru på filter for .rpm-filer';
$string['mediapluginwmv'] = 'Skru på filter for . wmv-filer';
$string['mediapluginyoutube'] = 'Aktivér YouTube-filter';
$string['messaging'] = 'Aktiviser meldingssystemet';
$string['messagingallowemailoverride'] = 'Overstyring av varsling via e-post';
$string['messagingallusers'] = 'Tillat meldinger fra alle på denne portalen';
$string['messagingcategory'] = 'Meldinger';
$string['messagingdefaultpressenter'] = 'La "Bruk enter for å sende" være aktivert som standard';
$string['messagingdeleteallnotificationsdelay'] = 'Slett alle varsler';
$string['messagingdeletereadnotificationsdelay'] = 'Slett leste varsler';
$string['messagingssettings'] = 'Meldingsinnstillinger';
$string['minpassworddigits'] = 'Tall';
$string['minpasswordlength'] = 'Passordlengde';
$string['minpasswordlower'] = 'Små bokstaver';
$string['minpasswordnonalphanum'] = 'Spesialtegn';
$string['minpasswordupper'] = 'Store bokstaver';
$string['misc'] = 'Forskjellig';
$string['mlbackendsettings'] = 'Maskinlæring backend innstillinger';
$string['mnetrestore_extusers'] = '<strong>OBS:</strong> Denne sikkerhetskopien inneholder brukere fra andre Moodle Network-installasjoner som vil bli tilbakeført som en del av gjenopprettingsprosessen.';
$string['mnetrestore_extusers_admin'] = '<strong>Merk:</strong>Denne sikkerhetskopien ser ut som den kommer fra en annen Moodleinstallasjon og inneholder brukerkonti fra et annet Moodlenettverk. Gjenopprettingsprosessen vil prøve å matche Moodlenettverksverter for alle opprettede brukere. De som ikke har match vil bli satt over på intern autentisering (istedet for mnet). Opprettingsloggen vil gi deg all informasjon om dette.';
$string['mnetrestore_extusers_mismatch'] = '<strong>OBS:</strong> Denne sikkerhetskopien ser ut til å komme fra en annen Moodle-installasjon og inneholder brukerkontoer fra Moodle Network. Dette kan føre til feil, og funksjonen er ikke støttet. Er du sikker på at denne sikkerhetskopien er opprettet her, eller at nødvendige Moodle Network Host er satt opp, kan du jo forsøke en gjenoppretting.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Merk:</strong>Denne sikkerhetskopien ser ut som den kommer fra en annen Moodleinstallasjon og inneholder brukerkonti fra et annet Moodlenettverk.
Du har ikke tillatelse til å kjøre en slik gjenoppretting. Kontakt ansvarlig for portalen eller, alternativt, gjenopprett dette kurset uten brukerinformasjon (moduler,filer...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Moodle Network Fjernbruker {$a->username} (som kommer fra {$a->mnethosturl}) byttes til lokal {$a->auth} autentisert bruker.';
$string['mobilenotconfiguredwarning'] = 'Moodleappen er ikke aktivert';
$string['modassignmentinuse'] = 'Portalen ditt bruker fortsatt Assignment 2.2-modulen. Før du oppgraderer må du 1) ta sikkerhetskopi av alle Assignment 2.2-aktiviteter du ønsker å beholde og gjenopprette dem som Assignment-aktiviteter, og 2) slette alle Assignment 2.2-data fra databasen.';
$string['modassignmentsubpluginsexist'] = 'Assignment 2.2. undermoduler kan være installert. Mod/assignment-mappen og alle undermoduler må fjernes før oppgradering.';
$string['modeditdefaults'] = 'Standardverdier for aktivitetsinnstillinger';
$string['modsettings'] = 'Administrer aktiviteter';
$string['modulesecurity'] = 'Sikkerhet for moduler';
$string['moodlebrandedapp'] = 'Tilpasset Moodleapp';
$string['moodlebrandedappreference'] = 'Alternativt kan du skaffe deg den <a href="https://moodle.com/branded-app">tilpassede Moodleappen</a> med dine egne designmessige tilpasninger.';
$string['mustenablestats'] = 'Statistikk har ikke blitt aktivisert ennå på denne portalen.';
$string['mycourses'] = 'Mine kurs';
$string['mydashboard'] = 'Kontrollpanel for systemets standardinnstillinger';
$string['mymoodle'] = 'Dashbord';
$string['mypage'] = 'Standard Dashbord';
$string['mypagelocked'] = 'Lås standard side';
$string['myprofile'] = 'Standard profilside';
$string['navadduserpostslinks'] = 'Legg til lenker for å se brukerinnlegg';
$string['navadduserpostslinks_help'] = 'Hvis aktivert, vil det legges til to lenker på hver bruker i navigasjonen for å vise diskusjoner brukeren har startet og innlegg brukeren har bidratt med i forum på kursportalen eller i bestemte kurs.';
$string['navcourselimit'] = 'Kursgrense';
$string['navfilter'] = 'Filtrer egendefinert meny';
$string['navfilter_desc'] = 'Behandle den egendefinerte menyen gjennom Moodle-filtre som er satt til å gjelde <strong>Innhold og overskrifter</strong>. Nyttig for å aktivere dynamiske egendefinerte menyelementer.';
$string['navigationupgrade'] = 'Denne oppgraderingen vil introdusere to nye navigasjonsblokker som vil erstatte disse blokkene: Administrasjon, Kurs, Aktiviteter og Deltakere. Dersom du hadde satt bestemte tilganger på disse blokkene bør du sjekke om alt fortsatt oppførerer seg som du ønsker.';
$string['navshowallcourses'] = 'Vis alle kurs';
$string['navshowcategories'] = 'Vis kurskategorier';
$string['navshowfrontpagemods'] = 'Vis forsidens aktiviteter i navigasjonen';
$string['navshowfrontpagemods_help'] = 'Hvis aktivert, vil forsidens aktiviteter og ressurser vises i navigasjonen under forsideressurser.';
$string['navshowfullcoursenames'] = 'Vis kursenes fulle navn';
$string['navshowfullcoursenames_help'] = 'Hvis aktivert, blir kursene vist med sine fulle navn i navigasjonen i stedet for kortnavnene.';
$string['navshowmycoursecategories'] = 'Vis mine kurskategorier';
$string['navshowmycoursecategories_help'] = 'Hvis aktivert, vil kurs under Mine kurs vises sortert i de kategoriene de hører til under.';
$string['navsortmycourseshiddenlast'] = 'Vis skjulte kurs sist';
$string['navsortmycourseshiddenlast_help'] = 'Hvis aktivert vil skjulte kurs vises til slutt i listen for brukere som har tillatelse til å se skjulte kurs. Ellers vil alle kurs uavhengig av synlighet sorteres etter innstillingen "Sorter mine kurs".';
$string['navsortmycoursessort'] = 'Rekkefølge av kurs i navigasjonsblokk';
$string['navsortmycoursessort_help'] = 'Skal emner være oppført i sorteringsrekkefølgen angitt i Portaladministrasjon > Kurs > Administrer emner og kategorier, eller alfabetisk etter emneinnstilling? Denne innstillingen gjelder bare for temaer basert på Classic.';
$string['never'] = 'Aldri';
$string['neverdeleteruns'] = 'Slett aldri kjørende jobber';
$string['newestdocindexed'] = 'Nyeste dokument indeksert';
$string['nobookmarksforuser'] = 'Du har ingen bokmerker';
$string['nodatabase'] = 'Ingen database';
$string['noemaileverwarning'] = '<strong>Merk:</strong> Alle utgående e-poster er deaktivert';
$string['nohttpsformobilewarning'] = 'Det anbefales å aktivere HTTPS med et gyldig sertifikat. Moodleappen vil alltid prøve den sikre forbindelsen først.';
$string['nomissingstrings'] = 'Ingen manglende strenger';
$string['none'] = 'Ingen';
$string['nonewsettings'] = 'Det er ikke lagt til noen nye innstillinger i denne oppgraderingen.';
$string['nonexistentbookmark'] = 'Bokmerket du ba om eksisterer ikke';
$string['noreplyaddress'] = 'No-reply adresse';
$string['noreplydomain'] = 'Ikke-svar og domene';
$string['noreplydomaindetail'] = 'Innstillinger for ikke-svar og konfigurerte domener';
$string['noresults'] = 'Ingen resultater';
$string['noroles'] = 'Ingen roller';
$string['nosupportedlogstore'] = 'Fant ingen støttede loggarkiver';
$string['noteunneededblocks'] = 'Merk: Blokker som er satt til å vises, vil ikke bli oppført i \'Legg til en blokk\'-menyen i et kurs hvis de er spesifisert i designinnstillingen \'Unødvendige blokker\'.';
$string['notifications'] = 'Varslinger';
$string['notifyloginfailures'] = 'Mislykkede login sendes på e-post til';
$string['notifyloginthreshold'] = 'Ventetid før e-post sendes';
$string['notloggedinroleid'] = 'Rolle for besøkende';
$string['numberofmissingstrings'] = 'Antall manglende strenger: {$a}';
$string['numberofstrings'] = 'Totalt antall strenger: {$a->strings}<br/>Mangler: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'Oppdateringstokenet for en av OAuth-tjenestene {$a->issuer} på din portal: {$a->siteurl}  er utløpt. Dette vil begrense funksjonaliteten for alle moduler som benytter denne tjenesten. For å fikse dette må du gå til OAuth 2-tjenestenes innstillinger og klikke på "Koble til systemkonto"-ikonet i tabellraden for denne tjenesten. Vær sikker på at du er innlogget med samme tjenestekonto for OAuth-tjenesten hver gang.';
$string['oauthrefreshtokenexpiredshort'] = 'OAuth-oppdateringstoken er utløpt for  {$a->issuer} på din portal: {$a->siteurl}.';
$string['onlynoreply'] = 'Kun ved sending fra en ikke-svar adresse';
$string['opcacherecommended'] = 'PHP opcode mellomlagring forbedrer ytelsen og reduserer minnebehovet. OPcache-tillegget anbefales og støttes fullt ut.';
$string['opensslrecommended'] = 'Vi anbefaler sterkt at openssl-biblioteket installeres. Du må ha det for å aktivisere Moodle Network funksjonaliteten.';
$string['opensslrequired'] = 'OpenSSL PHP-utvidlesen kreves nå av Moodle for å tilby sterkere krypteringstjenester.';
$string['opentowebcrawlers'] = 'Åpen for Google';
$string['optionalmaintenancemessage'] = 'Ekstra vedlikeholdsmelding';
$string['order1'] = 'Første';
$string['order2'] = 'Andre';
$string['order3'] = 'Tredje';
$string['order4'] = 'Fjerde';
$string['outgoingmailconfig'] = 'Konfigurasjon av utgående epost';
$string['overridetossl'] = 'HTTPS for innlogginger er foreldet. Denne instansen er nå tvunget til SSL. For å fjerne denne advarselen må du endre wwwroot i config.php til HTTPS://';
$string['pageinfodebugsummary'] = 'Denne siden er: {$a}';
$string['passwordchangelogout'] = 'Logg ut etter passordbytte';
$string['passwordchangelogout_desc'] = 'Når aktivert vil alle andre enn den aktive fanen lukkes automatisk. (Innstillingen påvirker ikke passordbytte fra masseopplasting av brukere.';
$string['passwordchangetokendeletion'] = 'Fjern tilgangangstokener til webtjenester etter passordbytte';
$string['passwordchangetokendeletion_desc'] = 'Hvis aktivert, vil alle tilgangstokener for webtjenester bli slettet når et passord endres.';
$string['passwordpolicy'] = 'Passordregler';
$string['passwordpolicycheckonlogin'] = 'Sjekk passord ved innlogging';
$string['passwordresettime'] = 'Maksimal tid for å bekrefte nytt passord';
$string['passwordreuselimit'] = 'Rotasjonsgrense på passord';
$string['passwordreuselimit_desc'] = 'Antall ganger en bruker må endre passordet sitt, før brukeren kan gjenbruke et gammelt passord. Tidligere passord lagres i en lokal databasetabell. Denne innstillingen fungerer ikke nødvendigvis mot ved bruk av eksterne autentifiseringsmoduler.';
$string['pathtodot'] = 'Sti til dot';
$string['pathtodot_help'] = 'Sti til dot. For Linux er det noe slikt som /usr/bin/dot. På Windows er det noe slikt som C:\\Program Files(x86)\\Graphviz2.38\\bin\\dot.exe. På Mac er det noe slikt som /op/local/bin/dot. For å kunne generere grafikk fra dot-filer må du ha dot installert og peke til programmet her.';
$string['pathtodu'] = 'Sti til "du"';
$string['pathtogs'] = 'Sti til ghostscript';
$string['pathtogs_help'] = 'I de fleste Linuxinstallasjoner kan dette feltet settes til \'/ust/bin/gs\'. For Windows vil det være noe sånt som \'c:\\gs\\bin\\gswin32c.exe\' (forsikre deg om at det ikke er langt inn noen mellomrom i stein - om nødvending kpoier filene \'gswin32.exe\' og \'gsdll32.dll\' til en ny mappe uten mellomrom i stien.';
$string['pathtopdftoppm'] = 'Sti til pdftoppm';
$string['pathtopdftoppm_help'] = '\'pdftoppm\' er et verktøy som konverterer PDF-sider til PNG minst like raskt som \'gs\' gjør. Imidlertid vil du sannsynligvis ha bedre ytelse når du konverterer store dokumenter. Hvis det er installert, vil \'pdftoppm\' brukes i stedet for Ghostscript for denne oppgaven. På de fleste Linux-installasjoner kan dette stå som /usr/bin/pdftoppm. Hvis den ikke er installert, installerer du poppler-utils eller poppler-pakken, avhengig av Linux-distribusjon. På Windows vil det bli levert av Cygwin installasjoner. Se <a href="https://poppler.freedesktop.org/" target="_blank"> Poppler-prosjekt </a> for mer informasjon.';
$string['pathtopgdump'] = 'Sti til pg_dump';
$string['pathtopgdumpdesc'] = 'Dette trenger du kun spesifisere dersom du har mer enn en pg_dump på ditt system (for eksempel hvis du har installert mer enn en versjon av postgresql)';
$string['pathtopgdumpinvalid'] = 'Ugyldig sti til pg_dump - enten gal sti eller ikke eksekverbar';
$string['pathtophp'] = 'Sti til PHP CLI';
$string['pathtopsql'] = 'Sti til psql';
$string['pathtopsqldesc'] = 'Dette trenger du kun spesifisere dersom du har mer enn en psql på systemet (for eksempel hvis du har installert mer enn en versjon av postgresql)';
$string['pathtopsqlinvalid'] = 'Ugyldig sti til psql - enten gal sti eller ikke eksekverbar';
$string['pathtopython'] = 'Sti til Python';
$string['pathtopythondesc'] = 'Sti til din kjørbare Python binærfil (både Python 2 og Python 3 aksepteres)';
$string['pathtosassc'] = 'Sti til SassC';
$string['pathtosassc_help'] = 'Spesifisering av plasseringen av SassC binær-fil vil bytt SASS kompilerer fra Moodle PHP implementering til SassC. Se http://github.com/sass/sassc for mer informasjon.';
$string['pcreunicodewarning'] = 'Det anbefales på det sterkeste å bruke PCRE PHP-tillegget som er kompatibelt med Unicode-tegnsettet.';
$string['perfdebug'] = 'Info om ytelse';
$string['perfdebugdeferred'] = 'Venter til skriptet slutter for å vise ytelsesfeilsøkingen ...';
$string['performance'] = 'Ytelse';
$string['pgcluster'] = 'PostgreSQL klynge';
$string['pgclusterdescription'] = 'PostgreSQL versjons/cluster parametre for bruk ved kommandolinjen. Dersom du har bare en PostgreSQL på systemet ditt, eller ikke er helt sikker på hva dette er, la feltet stå tomt.';
$string['phpfloatproblem'] = 'Oppdaget uventet problem i behandlingen av PHP flytnummer - {$a}';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'Portalregistreringen din er oppdatert og ble sist oppdatert {$a}. <br /> Den planlagte oppgaven \'Portalregistrering\' sørger for å holde registreringen din oppdatert. Du kan når som helst oppdatere registreringen manuelt.';
$string['pleaserefreshregistrationnewdata'] = 'Registreringsinformasjonen er endret. Vennligst bekreft den ved å bruke "Oppdater registrering"-knappen.';
$string['pleaserefreshregistrationunknown'] = 'Portalen din er registrert, men registreringsdatoen er ukjent. Vennligst oppdater registreringen ved å bruke "Oppdater registrering"s-knappen eller forsikre deg om at cron-jobben "Portalregistrering" er aktivert slik at dette skjer automatisk.';
$string['plugin'] = 'Modul';
$string['plugin_disabled'] = '{$a} deaktivert.';
$string['plugin_enabled'] = '{$a} aktivert';
$string['plugins'] = 'Moduler';
$string['pluginscheck'] = 'Sjekk av modulavhengigheter';
$string['pluginscheckfailed'] = 'Sjekk av modulavhengigheter ga feilmeldinger for {$a->pluginslist}';
$string['pluginschecktodo'] = 'Du må løse alle modulkravene før du installerer denne Moodle-versjonen!';
$string['pluginsoverview'] = 'Moduloversikt';
$string['pluginsoverviewsee'] = 'Se <a href="{$a->url}">moduloversikt</a>siden for mer informasjon.';
$string['policysettings'] = 'Regelinnstillinger';
$string['privacy:metadata'] = 'Modulen "Administrasjon" lagrer ikke noen persondata.';
$string['privacyandpolicies'] = 'Personvern og regler';
$string['privacysettings'] = 'Personverninnstillinger';
$string['profilecategory'] = 'Kategori';
$string['profilecategoryname'] = 'Kategorinavn (må være unikt)';
$string['profilecategorynamenotunique'] = 'Dette kategorinavnet er allerede i bruk';
$string['profilecommonsettings'] = 'Vanlige innstillinger';
$string['profileconfirmcategorydeletion'] = 'Det er {$a} felter i denne kategorien som vil bli flyttet til kategorien over.<br/>Ønsker du fortsatt å slette denne kategorien?';
$string['profileconfirmfielddeletion'] = 'Det er {$a} brukerdata for dette feltet som vil bli slettet. <br/>Ønsker du fortsatt å slette dette feltet?';
$string['profilecreatecategory'] = 'Opprett ny kategoriprofil';
$string['profilecreatefield'] = 'Opprett et nytt profilfelt';
$string['profilecreatenewcategory'] = 'Oppretter en ny kategori';
$string['profilecreatenewfield'] = 'Oppretter et nytt \'{$a}\' profilfelt';
$string['profiledefaultcategory'] = 'Andre felt';
$string['profiledefaultchecked'] = 'Merket av som standard';
$string['profiledefaultdata'] = 'Standardverdi';
$string['profiledeletecategory'] = 'Sletter en kategori';
$string['profiledeletefield'] = 'Sletter felt \'{$a}\'';
$string['profiledescription'] = 'Feltbeskrivelse';
$string['profiledscript'] = 'Dette skriptet er nå profilert.';
$string['profiledscriptview'] = 'Vis profileringsinformasjon for dette skriptet';
$string['profileeditcategory'] = 'Redigerer kategorien: {$a}';
$string['profileeditfield'] = 'Redigerer profilfeltet: {$a}';
$string['profilefield'] = 'Profilfelt';
$string['profilefieldcolumns'] = 'Kolonner';
$string['profilefieldispassword'] = 'Er dette et passordfelt';
$string['profilefieldlink'] = 'Lenke';
$string['profilefieldlink_help'] = 'For å konvertere en tekst til en lenke, kan du legge inn en URL som inneholder $$, hvor $$ vil bli erstattet med teksten. For eksempel: Ønsker du å konvertere en Twitter ID til en lenke skriver du inn http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Lenkemål';
$string['profilefieldmaxlength'] = 'Maks antall tegn';
$string['profilefieldmaxlength_help'] = 'For å bruke dette feltet i innstillingen \'Vis brukeridentitet\', må grensen være på 255 tegn eller mindre.';
$string['profilefieldrows'] = 'Rader';
$string['profilefields'] = 'Bruker profilfelt';
$string['profilefieldsize'] = 'Vises i størrelse';
$string['profileforceunique'] = 'Skal data være unike?';
$string['profileinvaliddata'] = 'Ugyldig verdi';
$string['profilelocked'] = 'Er dette feltet låst?';
$string['profilemenudefaultnotinoptions'] = 'Standardverdien er ikke en av valgene.';
$string['profilemenunooptions'] = 'Ingen menyvalg støttet';
$string['profilemenuoptions'] = 'Menyvalg (ett pr.linje)';
$string['profilemenutoofewoptions'] = 'Du må angi minst to valg';
$string['profilename'] = 'Navn';
$string['profilenofieldsdefined'] = 'Ingen felter er definert';
$string['profilerequired'] = 'Er dette feltet obligatorisk?';
$string['profileroles'] = 'Synlige rolleprofiler';
$string['profilesforenrolledusersonly'] = 'Profiler kun for påmeldte brukere';
$string['profileshortname'] = 'Kort-navn (unikt)';
$string['profileshortnameinvalid'] = 'Kortnavnet kan bare inneholde alfanumeriske tegn (bokstaver og tall) eller understrek (_).';
$string['profileshortnamenotunique'] = 'Dette kort-navnet er allerede i bruk';
$string['profilesignup'] = 'Vis på side for brukerregistrering?';
$string['profilespecificsettings'] = 'Spesielle innstillinger';
$string['profilevisible'] = 'Hvem er dette feltet synlig for?';
$string['profilevisible_help'] = '* Ikke synlig - For private data kan bare administratorer se
* Synlig for brukeren - For private data som bare kan vises av brukeren og administratorer
* Synlig for bruker, lærere og administratorer - For private data kun synlig for brukeren, administratorer og lærere (på kursprofil)
* Synlig for alle';
$string['profilevisibleall'] = 'Synlig for alle';
$string['profilevisiblenone'] = 'Ikke synlig';
$string['profilevisibleprivate'] = 'Synlig for brukeren';
$string['profilevisibleteachers'] = 'Synlig for bruker, lærere og administratorer';
$string['profiling'] = 'Profilering';
$string['profilingallowall'] = 'Kontinuerlig profilering';
$string['profilingallowall_help'] = 'Dersom du aktiverer denne innstillingen kan du når som helst bruke parameteren PROFILEALL hvor som helst for å aktivere profilering for alle kjørte skript i Moodle-sesjonen. Tilsvarende kan du bruke parameteren PROFILEALLSTOP for å stoppe den.';
$string['profilingallowme'] = 'Selektiv profilering';
$string['profilingallowme_help'] = 'Dersom du aktiverer denne innstillingen kan du selektivt bruke parameteren PROFILEME hvor som helst og dette skriptet blir profilert. Tilsvarende kan du bruke parameteren DONTPROFILEME for å forhindre profilering.';
$string['profilingautofrec'] = 'Automatisk profilering';
$string['profilingautofrec_help'] = 'Ved å konfigurerere denne innstillingen, kan noen forespørsler ( tilfeldige, basert på angitt frekvens - 1  av  XXX) bli fanget opp og automatisk profilert og lagret for fremtidig analyser. Merk at denne måten å profilere på er avhengig av inkluder/eksluder-innstillingene. Sett verdien -0- for å deaktivere automatisk profilering.';
$string['profilingenabled'] = 'Aktiver profilering';
$string['profilingenabled_help'] = 'Dersom du aktiverer denne innstillingen vil profilering bli tilgjengelig på denne portalen og kan bestemme oppførselen ved å sette oppp de neste valgene.';
$string['profilingexcluded'] = 'Ekskluder profilering';
$string['profilingexcluded_help'] = 'Liste over (komma eller linjeskift separert, absolutt skipping av wwwroot, virksomme) URL-er som vil bli ekskludert fra å bli profilert fra de som er definert av \'Profilér disse\' innstillingen.';
$string['profilingimportprefix'] = 'Prefix for importprofiling';
$string['profilingimportprefix_desc'] = 'For lettere å finne igjen importen vil alle importerte profier får prefiksen du angir her.';
$string['profilingincluded'] = 'Profiler disse';
$string['profilingincluded_help'] = 'Liste over (kommaseparerte, absolutte uten www-mappen, aktive) URL-er som vil bli automatisk profilert. Eks:  /index.php, /course/view.php. Godtar også stjernetegn *  i alle posisjoner. Eks: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Behold profileringskjøringer';
$string['profilinglifetime_help'] = 'Angi hvor lang tid du vil ta vare på informasjon fra eldre profileringskjøringer. Mer at dette utelater alle profileringskjøringer merket som "referansekjøring".';
$string['profilingslow'] = 'Treg side profilering';
$string['profilingslow_help'] = 'Ved å sette en minste tid i sekunder vil alle treger sider bli profilert. Kun profiler som er tregere en en eksisterende profil for det samme skriptet vil bli beholdt. Sett til 0 for å deaktivere. Merk at dette observerer ekskluderingsinnstillingene.';
$string['protectusernames'] = 'Skjul brukernavnene';
$string['proxybypass'] = 'Mellomlagringsservere';
$string['proxyfixunsafe'] = 'Rett opp anrop uten proxy';
$string['proxyhost'] = 'Proxyserver';
$string['proxylogunsafe'] = 'Logg anrop uten proxy';
$string['proxypassword'] = 'Proxypassord';
$string['proxyport'] = 'Proxy port';
$string['proxytype'] = 'Proxytype';
$string['proxyuser'] = 'Proxybrukernavn';
$string['purgecaches'] = 'Oppdater alle mellomlagre';
$string['purgecachesconfirm'] = 'Moodle kan mellomlagre design, javascript, språkstrenger, filtrert tekst, rss og mange andre typer data. Tømming av disse mellomlagrene vil slette data fra serveren og tvinge nettleserne til å lese inn dataene en gang til så du blir sikker på at du ser de siste dataene produsert av gjeldende kode. Det er ikke farlig å tømme mellomlagrene, men portalen kan oppleves som treg inntil serveren og brukerne har lastet ned ny informasjon og mellomlagret det igjen.';
$string['purgecachesfinished'] = 'Alle mellomlagre ble oppdatert';
$string['purgecachesnoneselected'] = 'Velg et eller flere mellomlagre å tømme';
$string['purgecachespage'] = 'Tøm mellomlagre';
$string['purgecoursecache'] = 'Kurs';
$string['purgefiltercache'] = 'Tekstfiltre';
$string['purgejscache'] = 'JavScript';
$string['purgelangcache'] = 'Språkstrenger';
$string['purgemuc'] = 'Alle MUC mellomlagre';
$string['purgeothercaches'] = 'Alle fil og diverse mellomlagre';
$string['purgeselectedcaches'] = 'Tøm valgte mellomlagre';
$string['purgeselectedcachesfinished'] = 'Valgte mellomlagre ble tømt.';
$string['purgetemplates'] = 'Maler';
$string['purgethemecache'] = 'Design';
$string['query'] = 'Spørring';
$string['question'] = 'Spørsmål';
$string['questionbehaviours'] = 'Spørsmålsatferd';
$string['questioncwqpfscheck'] = 'En eller flere \'tilfeldige\' spørsmål i quizmodulen er satt opp til å velge spørsmål fra en blanding av delte og udelte spørsmålskategorier. Det finnes en mer detaljert rapport <a href="{$a->reporturl}">her</a> og se Moodle Docs side <a href="{$a->docsurl}">her</a>.';
$string['questioncwqpfsok'] = 'Bra. Det er ingen \'tilfeldige\' spørsmål i quizene som er satt opp til å velge spørsmål fra en blanding av delte og udelte kategorier.';
$string['questiontype'] = 'Spørsmålstype';
$string['questiontypes'] = 'Spørsmålstyper';
$string['quizattemptsupgradedmessage'] = 'I Moodle 2.1 kom det en stor oppgradering av spørsmål. Det ble mulig å utsette en del av databaseoppgraderingen til senere. Før du oppgraderer til Moodle 2.7 må denne oppgraderingen være fullført.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA privat nøkkel';
$string['recaptchapublickey'] = 'ReCAPTCHA offentlig nøkkel';
$string['referrernone'] = 'Standard nettleserinnstillinger';
$string['referrerpolicy'] = 'Henvisningsretningslinjer';
$string['referrerpolicydesc'] = 'Sett henvisningsretningslinjens overskrift som skal inkluderes i svarene fra portalen ditt.';
$string['register'] = 'Registrér kursportalen din';
$string['registration'] = 'Registrering';
$string['registration_help'] = 'Ved registrering:

* Du vil motta sikkerhetsvarsler
* Du kan aktivere mobil-appen og push-meldinger fra portalen din
* Du bidrar til vår statistikk over global utbredelse av Moodle';
$string['registrationwarning'] = 'Gå ikke glipp av viktige oppdatering og sikkerhetsvarslinger';
$string['registrationwarningcontactadmin'] = 'Denne portalen er ikke registrert. Vennligst kontakt portaladministratoren.';
$string['releasenoteslink'] = 'For mer informasjon om denne versjonen av Moodle, sjekk online via  <a target="_new" href="{$a}">Release Notes</a>';
$string['rememberuserlicensepref'] = 'Husk brukers lisenspreferanse';
$string['rememberuserlicensepref_help'] = 'Når aktivert vil brukerens sist valgte lisens bli forhåndsvalg ved nest opplasting i filvelgeren. Ellers vil portalens standardlisens være forhåndsvalget.';
$string['rememberusername'] = 'Husk brukernavn';
$string['rememberusername_desc'] = 'Aktiver hvis du ønsker at det skal permanent skal lagres en cookie med brukernavn. Permanente cookies kan være en risiko hvis det brukes uten samtykke.';
$string['replacefrontsearch'] = 'Brukes til forside kurssøk';
$string['reportsmanage'] = 'Administrere rapporter';
$string['required'] = 'Påkrevd';
$string['requiredentrieschanged'] = 'Merk: Etter oppgradering er innstillingen \'Krev utfylling før visning\' nå tvungen for følgende databaseaktiviteter::<br/>{$a->text}<br/>';
$string['requiremodintro'] = 'Krever aktivitetsbeskrivelse';
$string['requiremodintro_desc'] = 'Når aktivert vil denne innstillingen tvinge alle brukere til å fylle ut beskrivelsesfeltet i alle aktiviteter';
$string['requires'] = 'Krever';
$string['resetindentation'] = 'Tilbakestill innrykk på hele portalen';
$string['resetindentation_help'] = 'Dette vil fjerne alle innrykk for kurs med {$a->format}.';
$string['resetindentation_title'] = 'Vil du tilbakestille innrykk på hele portalen?';
$string['resetindentationsuccess'] = 'Innrykk tilbakestilt.';
$string['restorecourse'] = 'Gjenopprett kurs';
$string['restorernewroleid'] = 'Gjenoppretters rolle i kurs';
$string['restorernewroleid_help'] = 'Hvis brukeren ikke allerede har tillatelse til å administrere nylig gjenopprettede kurs, blir brukeren automatisk tildelt denne rollen og om nødvendig påmeldt. Velg "Ingen" hvis du ikke ønsker at gjenopprettere skal være i stand til å administrere hvert gjenopprettede kurs.';
$string['resultfilter'] = 'Filtrer resultater';
$string['reverseproxy'] = 'Revers proxy';
$string['reverseproxyignore'] = 'Ignorer reverse proxies';
$string['riskconfig'] = 'Brukeren kan endre portaloppsettet og hvordan det oppfører seg!';
$string['riskconfigshort'] = 'Risiko ved innstillingene';
$string['riskdataloss'] = 'Brukere kan ødelegge store mengder innhold eller informasjon';
$string['riskdatalossshort'] = 'Risiko for tap av data';
$string['riskmanagetrust'] = 'Brukere kan endre sikkerhetsinnstillinger på andre brukere';
$string['riskmanagetrustshort'] = 'Administrere sikre siter';
$string['riskpersonal'] = 'Brukere kan få tilgang til privat informasjon hos andre brukere.';
$string['riskpersonalshort'] = 'Risiko for privat info';
$string['riskspam'] = 'Brukere kan sende spam til site-brukere eller andre';
$string['riskspamshort'] = 'Risiko for spam';
$string['riskxss'] = 'Brukere kan legge til filer og tekst som tillater skripting mellom siter.';
$string['riskxssshort'] = 'XSS risiko';
$string['roleswithexceptions'] = '{$a->roles}, med {$a->exceptions}';
$string['rssglobaldisabled'] = 'Slå av på portalnivå';
$string['save'] = 'Lagre';
$string['savechanges'] = 'Lagre endringer';
$string['scssinvalid'] = 'Ugyldig SCSS-kode, feilet med {$a}';
$string['search'] = 'Søk';
$string['searchablecourses'] = 'Søkbare kurs';
$string['searchallavailablecourses'] = 'Søkbare kurs';
$string['searchallavailablecourses_desc'] = 'I noen situasjoner kan det hende at søkemotoren ikke fungerer mens den søker gjennom mange kurs. Be den om å kun søke gjennom påmeldte kurs for å begrense søket.';
$string['searchallavailablecourses_off'] = 'Søk kun innen påmeldte kurs';
$string['searchallavailablecourses_on'] = 'Søk innen alle tilgjengelige kurs';
$string['searchallavailablecoursesdesc'] = 'Dersom innstillingen settes til søk innen påmeldte kurs, vil kursinformasjon og kursinnhold bare være søkbart for kursene en bruker er meldt inn i. Ellers vil kursinformasjon og kursinnhold være søkbart for alle kurs brukeren har tilgang til, f.eks. i kurs med gjestetilgang.';
$string['searchalldeleted'] = 'Alt indeksert innhold har blitt slettet';
$string['searchalternatesettings'] = 'Alternative innstillinger for rene spørringer';
$string['searchalternatesettings_desc'] = 'Hvis du fullfører disse innstillingene, kan du velge "alternative innstillinger" for denne søkemotoren i alternativet for søkemotoren bare på siden "Administrer globalt søk". Dette er bare nyttig når du flytter mellom to søkemotorer av samme type.';
$string['searchareadisabled'] = 'Søkeområde er deaktivert';
$string['searchareaenabled'] = 'Søkeområde er aktivert';
$string['searchareas'] = 'Søkeområder';
$string['searchbanner'] = 'Søkeinformasjon';
$string['searchbannerenable'] = 'Vis søkeinformasjon';
$string['searchbannerenable_desc'] = 'Hvis aktivert, vil teksten nedenfor vises øverst på søkeskjermen for alle brukere. Dette kan brukes til å informere brukerne når vedlikehold av søkemotoren utføres.';
$string['searchdefaultcategory'] = 'Standard søkekategori';
$string['searchdefaultcategory_desc'] = 'Resultatene fra de valgte søkeområdene vil bli vist som standard';
$string['searchdeleteindex'] = 'Slett alt indeksert innhold';
$string['searchdisplay'] = 'Visningsvalg for søkeresultater';
$string['searchenablecategories'] = 'Vis resultater i separate kategorier';
$string['searchenablecategories_desc'] = 'Hvis aktivert vil søkeresultater vises i separate kategorier.';
$string['searchengine'] = 'Søkemotor';
$string['searchenginealternatesettings'] = '{$a} (alternative innstillinger)';
$string['searchenginequeryonly'] = 'Bare søkemotor';
$string['searchenginequeryonly_desc'] = 'Denne søkemotoren vil kun bli brukt for å lage spørringer, ikke indeksere. Ved å bruke denne funksjonen kan du indeksere på nytt i en annen søkemotor, mens brukerspørringer fortsetter å jobbe fra denne.';
$string['searchenginequeryonly_none'] = 'Ingen (bruk hovedsøkemotoren for spørringer)';
$string['searchenginequeryonlysame'] = 'Søkemotoren for spørringer og hoved-søkemotor kan ikke settes til samme verdi.';
$string['searchhideallcategory'] = 'Skjul kategorier for alle resultater';
$string['searchhideallcategory_desc'] = 'Hvis aktivert vil kategorien med alle resultater skjules på søkeresulatatsiden.';
$string['searchincludeallcourses'] = 'Inkluder alle synlige kurs';
$string['searchincludeallcourses_desc'] = 'Dersom aktivert vil søkeresultatene inkludere kursinformasjon (navn og beskrivelse) for kurs som er synlige for brukeren, selv om de ikke har tilgang til kursinnholdet.';
$string['searchindexactions'] = 'Indekseringshandlinger';
$string['searchindexdeleted'] = 'Indeks slettet';
$string['searchindextime'] = 'Tidsgrense for indeksering';
$string['searchindextime_desc'] = 'Ved indeksering av store mengder nytt innhold vil cronjobben for indeksering stopper etter at tidsgrensen er nådd og deretter fortsette neste gang cronjobben kjøres';
$string['searchindexupdated'] = 'Søkemotorinnhold har blitt oppdatert';
$string['searchindexwhendisabled'] = 'Indekser når deaktivert';
$string['searchindexwhendisabled_desc'] = 'Tillater at cronjobben indekserer selv om søkefunksjonen er deaktivert. Dette kan være nyttig om du ønsker å bygge opp søkebiblioteket før brukerne får tilgang til søkefunksjonen';
$string['searchinsettings'] = 'Søk i innstillingene';
$string['searchlastrun'] = 'Siste kjørt (tidspunkt, # dokumenter, # oppføringer, # ignoreringer)';
$string['searchmanagement'] = 'Søk-administrasjon';
$string['searchmanagement_desc'] = 'Disse alternativene er nyttige når du gjør endringer på portaler med veldig store søkeindekser som det tar lang tid å gjenoppbygge.';
$string['searchmaxtopresults'] = 'Maks antall høyest rangerte resultater';
$string['searchmaxtopresults_desc'] = 'Maksimalt antall høyest rangerte resultater som skal vises over søkeresultatene for kursinnhold, kurs og brukere.';
$string['searchnotavailable'] = 'Søk er ikke tilgjengelig';
$string['searchoptions'] = 'Søkevalg';
$string['searchpartial'] = '(ennå ikke ferdigsindeksert)';
$string['searchreindexed'] = 'Alt innhold på portalen har blitt reindeksert.';
$string['searchreindexindex'] = 'Reindekser alt innhold på portalen';
$string['searchresults'] = 'Søkeresultater';
$string['searchsetupinfo'] = 'Søkeinnstillinger';
$string['searchteacherroles'] = 'Lærerroller';
$string['searchteacherroles_desc'] = 'Velg alle roller som gjør brukere med denne rollen en høyere rangering i søkeresultatene.';
$string['searchtopresults'] = 'Høyest rangerte resultater';
$string['searchupdateindex'] = 'Oppdater indeksert innhold';
$string['sectionerror'] = 'Seksjonsfeil!';
$string['secureforms'] = 'Bruk sikkert skjema';
$string['security'] = 'Sikkerhet';
$string['selectsearchengine'] = 'Velg søkemotor';
$string['server'] = 'Server';
$string['serverchecks'] = 'Serversjekker';
$string['serverlimit'] = 'Serverbegrensning';
$string['servicespage'] = 'Link til \'Tjenester og støtte\'';
$string['sessionautostartwarning'] = '<p>Alvorlig konfigurasjonsfeil oppdaget, vennligst varsle administrator.</p><p>For å fungere normalt krever Moodle at administrator endrer PHP-innstillingene.</p><p><code>session.auto_start</code> må endres til <code>off</code>.</p><p>Denne innstillingen endres i <code>php.ini</code>, Apache/IIS <br />oppsettet eller <code>.htaccess</code> fila på serveren.</p>';
$string['sessioncookie'] = 'Cookie prefix';
$string['sessioncookiedomain'] = 'Cookiedomene';
$string['sessioncookiepath'] = 'Cookie sti';
$string['sessionhandling'] = 'Sesjonshåndtering';
$string['sessiontimeout'] = 'Tiden utløper';
$string['sessiontimeoutwarning'] = 'Advarsel om tidsavbrudd';
$string['settingdependenton'] = 'Denne innstillingen kan skjules basert på verdien av <strong>{$a}</strong>';
$string['settingfileuploads'] = 'Filopplasting kreves for normal bruk, vennligst aktiver dette i PHP-oppsettet.';
$string['settingmaxinputvars'] = 'PHP-innstilling max_input_vars anbefales å være minst 5000.';
$string['settingmaxinputvarsrequired'] = 'PHP-innstilling max_input_vars må være minst 5000.';
$string['settingmemorylimit'] = 'Minnegrensen er satt for lavt, vennligst angi en høyere minnegrense i PHP-innstillingene.';
$string['settingsafemode'] = 'Moodle er ikke fullt kompatibel med "safe mode", vennligst be administrator om å slå dette av. Kjøring av Moodle i "safe mode" støttes ikke og du må regne med en rekke problemer hvis du prøver.';
$string['settingzendexceptionignoreargs'] = 'Det anbefales på det sterkeste av php-innstillingen zend.exception_ignore_args aktiveres som et sikkerhetstiltakt';
$string['setupsearchengine'] = 'Innstillinger for søkemotor';
$string['showcommentscount'] = 'Vis kommentarantall';
$string['showdetails'] = 'Vis detaljer';
$string['showuseridentity'] = 'Vis brukeridentitet';
$string['showuseridentity_desc'] = 'Når du velger eller søker etter brukere, og når du viser brukerlister, kan disse feltene vises i tillegg til deres fulle navn. Feltene vises bare til brukere som har moodle/site:viewuseridentity tillatelsen, som standard er dette lærere og administratorer. (Dette alternativet gir mest mening hvis du velger ett eller to felt som er obligatoriske ved din institusjon.)

Felter merket * er egendefinerte brukerprofilfelt. Du kan velge disse feltene, men det er for øyeblikket noen skjermbilder der de ikke vises.';
$string['simplexmlrequired'] = 'Moodle krever nå PHP-tillegget "SimpleXML".';
$string['sitemailcharset'] = 'Karaktersett';
$string['sitemaintenance'] = 'Portalen er midlertidig nede p.g.a. vedlikehold';
$string['sitemaintenancemode'] = 'Vedlikeholdsmodus';
$string['sitemaintenanceoff'] = 'Vedlikeholdsmodus er slått av, og portalen fungerer normalt igjen';
$string['sitemaintenanceon'] = 'Portalen er i vedlikeholdsmodus(bare administratorer kan logge inn eller bruke portalen)';
$string['sitemaintenanceoncli'] = 'Portalen er i CLI-vedlikeholdsmodus. Ingen nettilgang er tillatt.';
$string['sitemaintenancetitle'] = '{$a} under vedlikehold';
$string['sitemaintenancewarning'] = 'Denne portalen er i vedlikeholdsmodus for øyeblikket (kun administratorer kan logge inn). For å kunne returnere til normal operasjon, må du <a href="maintenance.php">slå av vedlikeholdsmodus</a>.';
$string['sitemaintenancewarning2'] = 'Portalen din er i vedlikeholdsmodus og bare administratorer kan logge inn. For å skifte tilbake til vanlig drift, gå til <a href="{$a}">slå av vedlikeholdsmodus</a>.';
$string['sitemenubar'] = 'Navigasjon';
$string['sitenameintitle'] = 'Inkluder portalnavn i sidetittelen';
$string['sitenameintitle_help'] = 'Denne innstillingen vil legge til portalnavnet på slutten av sidetittelen. Det oppfordres til å inkludere portalnavnet i sidetittelen, da det vil forbedre portalens tilgjengelighet ved å la brukere raskt identifisere siden de befinner seg på.';
$string['sitepolicies'] = 'Portalens sikkerhetsinnstillinger';
$string['sitepolicy'] = 'Site regler URL';
$string['sitepolicy_help'] = 'Nettadressen til portalretningslinjene som alle registrerte brukere må se og godkjenne før de får tilgang til portalen. Vær oppmerksom på at denne innstillingen bare har effekt hvis håndtereren for portalretningslinjer er satt til standard (core).';
$string['sitepolicyguest'] = 'URL for oversikt over regler for gjester';
$string['sitepolicyguest_help'] = 'URL-en til retningslinjer som alle gjester må se og akseptere før de får tilgang til portalen. Merk at denne innstillingen bare har effekt hvis velgeren for portal-retningslinjer er satt til standard (core).';
$string['sitepolicyhandler'] = 'Behandler for portalpolicy';
$string['sitepolicyhandler_desc'] = 'Dette valget bestemmer hvordan retningslinjer og brukeraksept håndteres. Standard (core)-valget aktiverer et dokument med retningslinjer for standard brukere, og et annet for gjester. Valget for håndtering av utvidede retningslinjer som';
$string['sitepolicyhandlercore'] = 'Standard (core)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Legg til en emneseksjon øverst på siden der du kan legge til innhold';
$string['sixtyfourbitsrequired'] = 'Det har blitt oppdaget at portalen ikke bruker en 64-bits PHP-versjon. Du må oppgradere systemet ditt (OS, PHP...) før du installerer denne Moodle-versjonen.';
$string['sixtyfourbitswarning'] = 'Portalen din benytter seg ikke av en 64 bits PHP-versjon. Det anbefales at du oppgraderer for å sikre fremtidig kompatibilitet.';
$string['slasharguments'] = 'Bruk slash argumenter';
$string['slashargumentswarning'] = 'Det anbefales at bruk av slash argumenter er aktivert. I fremtiden vil det være nødvendig. For flere detaljer, se dokumentasjonen <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Bruke slash argumenter</a> .';
$string['smallscreensonly'] = 'Kun små skjermer';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP Auth Type';
$string['smtpdetail'] = 'Simple Mail Transfer Protocol (SMTP) innstillinger for sending av epost.';
$string['smtphosts'] = 'SMTP-server';
$string['smtpmaxbulk'] = 'SMTP sesjongrense';
$string['smtppass'] = 'SMTP passord';
$string['smtpsecure'] = 'SMTP-sikkerhet';
$string['smtpuser'] = 'SMTP  brukernavn';
$string['soaprecommended'] = 'SOAP-tillegget anbefales installert siden dette er nyttig for webtjenester og noen tilleggsmoduler.';
$string['sort_fullname'] = 'Fullt navn på kurset';
$string['sort_idnumber'] = 'Kursets ID-nummer';
$string['sort_shortname'] = 'Kursets kortnavn';
$string['sort_sortorder'] = 'Sorteringsrekkefølge';
$string['spellengine'] = 'Stavemotor';
$string['spelllanguagelist'] = 'Stavekontroll språkliste';
$string['splrequired'] = 'PHP-tillegget "SPL" kreves nå av Moodle.';
$string['stats'] = 'Statistikk';
$string['statsfirstrun'] = 'Hvor langt tilbake skal statistikk-kjøringen starte?';
$string['statsmaxruntime'] = 'Maks tid for daglig statistikkbearbeiding';
$string['statsmoodleorg'] = 'statistikk';
$string['statsruntimedays'] = 'Dager som skal prosesseres';
$string['statsruntimestart'] = 'Kjør statistikk kl:';
$string['statsuserthreshold'] = 'Utelat kurs med færre brukere enn';
$string['stickyblocks'] = 'Tvungne blokker';
$string['stickyblockscourseview'] = 'Kursside';
$string['stickyblocksduplicatenotice'] = 'Hvis blokken du legger til her allerede finnes på en bestemt side, vil den dupliseres. <br/>Bare blokken du legger til vil være fast, duplikaten kan fremdeles endres på.';
$string['stickyblocksmymoodle'] = 'Min Moodle';
$string['stickyblockspagetype'] = 'Sidetype som skal konfigureres';
$string['storedprogressbarcleanuptask'] = 'Lagret oppryddingsoppgave for fremdriftslinje';
$string['strictformsrequired'] = 'Streng validering av obligatoriske felt';
$string['stripalltitletags'] = 'Fjern HTML-tagger fra alle aktivitetsnavn';
$string['supportandservices'] = 'Support og tjenester';
$string['supportavailability'] = 'Support-tilgjengelighet';
$string['supportcontact'] = 'Brukerstøtte';
$string['supportemail'] = 'Support epost';
$string['supportemailsubject'] = 'Portalbrukerstøtteforespørsel - {$a}';
$string['supportname'] = 'Support kontaktnavn';
$string['supportpage'] = 'Kontakt support';
$string['suspenduser'] = 'Deaktiver brukerkonto';
$string['swaggerui'] = 'Moodle REST API UI (SwaggerUI)';
$string['switchlang'] = 'Bytt språkmappe';
$string['systempaths'] = 'Systemstier';
$string['tablenosave'] = 'Endringer i tabellen over lagres automatisk.';
$string['tablesnosave'] = 'Endringer i tabellen over lagres automatisk.';
$string['tabselectedtofront'] = 'I tabeller med tabber, skal raden med gjeldende tab plasseres først';
$string['tabselectedtofronttext'] = 'Bring valgte tab-rekke til forgrunnen';
$string['task_adhoc_concurrency_limit'] = 'Grense for samtidige adhoc-oppgaver';
$string['task_adhoc_concurrency_limit_desc'] = 'Antallet adhoc-oppgaver som kan kjøre samtidig. Dersom grensen settes høyt vil cron-jobbene muligens ikke kjøre regelmessig dersom det er mange oppgave. Om den settes til 0 vil det deaktivere behandlingen av adhoc-oppgaver fullstendig.';
$string['task_adhoc_failed_retention'] = 'Mislykket oppbevaringsperiode for ad hoc-oppgaver';
$string['task_adhoc_failed_retention_desc'] = 'Maksimumsperioden som mislykkede ad hoc-oppgaver skal forbli i køen når de har nådd grensen for gjenforsøk.';
$string['task_adhoc_max_runtime'] = 'Adhoc-oppgaves maksimale kjøretid';
$string['task_adhoc_max_runtime_desc'] = 'Levetiden en adhoc-oppgave kan kjøre før den er frigjort. Kort varighet anbefales siden det er ingen grense på antallet adhoc-oppgaver i køen. Dersom denne settes for høyt og du har en stor kø med adhoc-oppgaver vil muligens ikke cronjobbene kjøre regelmessig.';
$string['task_dbreads'] = 'Database lesninger';
$string['task_dbstats'] = 'Database';
$string['task_dbwrites'] = 'Database skrivinger';
$string['task_duration'] = 'Varighet';
$string['task_endtime'] = 'Sluttid';
$string['task_logmode'] = 'Når skal det logges';
$string['task_logmode_all'] = 'Lagre loggene for alle jobber';
$string['task_logmode_desc'] = 'Du kan velge når oppgavelogging skal skje. Som standard blir alltid logger opprettet. Du kan deaktivere logging totalt eller endre til å kun logge mislykkede oppgaver.';
$string['task_logmode_failonly'] = 'Lagre logger kun for jobber som mislykkes';
$string['task_logmode_none'] = 'Ikke logg noe';
$string['task_logoutput'] = 'Oppgaveresultat';
$string['task_logretainruns'] = 'Behold kjøringer';
$string['task_logretainruns_desc'] = 'Antallet kjøringer hver oppgave som skal beholdes. Dette innstillingen virker sammen med \'Oppbevaringsperiode\'-innstillingen: Den som nås først vil gjelde.';
$string['task_logretention'] = 'Oppbevaringsperiode';
$string['task_logretention_desc'] = 'Maksperioden som logger beholdes. Dette innstillingen virker sammen med \'Oppbevaringsperiode\'-innstillingen: Den som nås først vil gjelde.';
$string['task_logtostdout'] = 'Vis logg utdata';
$string['task_logtostdout_desc'] = 'Når jobber kjører og utdataene fanges opp, om den genererte utskriften også skal vises mens oppgaven kjøres.';
$string['task_result'] = 'Resultat';
$string['task_result:failed'] = 'Feilet';
$string['task_scheduled_concurrency_limit'] = 'Samtidigshetsgrense for cron-jobber';
$string['task_scheduled_concurrency_limit_desc'] = 'Antallet cron-jobber som kan kjøre samtidig. Dersom grensen settes høyt kan serverbelastning bli høy og det vil påvirke ytelsen . Om den settes til 0 vil det deaktivere behandlingen av cron-jobber fullstendig.';
$string['task_scheduled_max_runtime'] = 'Cron-jobbenes levetid.';
$string['task_scheduled_max_runtime_desc'] = 'Varigheten for en cron-jobb-kjøring før den blir frigjort.';
$string['task_starttime'] = 'Starttid';
$string['task_stats:dbreads'] = '{$a} visninger';
$string['task_stats:dbwrites'] = '{$a} skrivinger';
$string['task_status'] = 'Oppgavestatus';
$string['task_status_desc'] = 'Oppgaven \'{$a->name}\' er {$a->status}. For detaljer, se {$a->class}{$a->extradescription} i <a href="{$a->gotourl}">Planlagte oppgaver</a>.';
$string['task_type:adhoc'] = 'Ad hoc';
$string['task_type:scheduled'] = 'Planlagt';
$string['taskadmintitle'] = 'Oppgaver';
$string['taskanalyticscleanup'] = 'Analytics opprydding';
$string['taskautomatedbackup'] = 'Automatiske sikkerhetskopier';
$string['taskautomatedbackup_report'] = 'Rapport om automatisk sikkerhetskopiering';
$string['taskbackupcleanup'] = 'Slett sikkerhetskopitabeller og logger';
$string['taskbadgesadhoc'] = 'Tildel utmerkelse';
$string['taskbadgescron'] = 'Tildel utmerkelser';
$string['taskbadgesmessagecron'] = 'Bakgrunnsbehandling for sending av utmerkelsesvarsler';
$string['taskblogcron'] = 'Synkroniser eksterne blogger';
$string['taskcachecleanup'] = 'Slett utløpte mellomlagrede data';
$string['taskcachecron'] = 'Bakgrunnsprosessering for mellomlagrede data';
$string['taskcalendarcron'] = 'Send kalendervarsler';
$string['taskcheckforupdates'] = 'Se etter oppdateringer';
$string['taskcompletiondaily'] = 'Registrere at kurset er påbegynt';
$string['taskcompletionregular'] = 'Beregn vanlig fullførtdata';
$string['taskcontextcleanup'] = 'Rydd i kontekster';
$string['taskcreatecontexts'] = 'Opprett manglende kontekster';
$string['taskdeleteincompleteusers'] = 'Slett ufullstendige brukerkontoer';
$string['taskdeleteunconfirmedusers'] = 'Slett ubekreftede brukerkontoer';
$string['taskeventscron'] = 'Bakgrunnsprosessering for handlinger';
$string['taskfiletrashcleanup'] = 'Rydd opp i søppelbøtta';
$string['taskglobalsearchindex'] = 'Globalt søk-indeksering';
$string['taskglobalsearchoptimize'] = 'Globalt søk indeksoptimalisering';
$string['taskgradecron'] = 'Bakgrunnsprosessering av karakterbok';
$string['taskgradehistorycleanup'] = 'Bakgrunnsbehandling for tømming av karakterhistorietabeller';
$string['taskh5pcleanup'] = 'Fjerning av ubrukte H5P-filer';
$string['tasklegacycron'] = 'Arvede cron-prosesser for moduler';
$string['tasklockcleanuptask'] = 'Rydd opp ad hoc-oppgavemetadata';
$string['tasklogcleanup'] = 'Opprydding av oppgavelogger';
$string['tasklogging'] = 'Oppgaveloggkonfigurasjon';
$string['tasklogs'] = 'Oppgavelogger';
$string['taskmessagingcleanup'] = 'Bakgrunnsprosesser for meldinger';
$string['taskpasswordresetcleanup'] = 'Rydd i forsøk på å resette passord';
$string['taskplagiarismcron'] = 'Bakgrunnsprosessering (bakoverkompatibel) av plagiatmoduler';
$string['taskportfoliocron'] = 'Bakgrunnsprosessering av porteføljemoduler';
$string['taskprocessing'] = 'Oppgavebehandling';
$string['taskquestioncron'] = 'Bakgrunnsprosessering for opprydding av spørsmålsforhåndsvisninger';
$string['taskquestionstatscleanupcron'] = 'Bakgrunnsbehandling for tømming av mellomlagre for spørsmålsstatistikk';
$string['taskrefreshsystemtokens'] = 'Forny OAuth-token for tjenestekontoer';
$string['taskregistrationcron'] = 'Registrering av kursportalen';
$string['tasksendfailedloginnotifications'] = 'Send oversikt over mislykkede innlogginger';
$string['tasksendnewuserpasswords'] = 'Send nye brukerpassord';
$string['tasksessioncleanup'] = 'Slett gamle sesjoner';
$string['taskstatscron'] = 'Bakgrunnsprosesser for statistikker';
$string['tasktagcron'] = 'Bakgrunnsprosesser for tagger';
$string['tasktempfilecleanup'] = 'Slett foreldede temp filer';
$string['tasktype'] = 'Type';
$string['taskupdategeoip2file'] = 'Oppdater GeoIP-fil';
$string['tempdatafoldercleanup'] = 'Rydd opp i midlertidige filer som er eldre enn';
$string['templates'] = 'Maler';
$string['testoutgoingmailconf'] = 'Test konfigurasjon for utgående epost';
$string['testoutgoingmailconf_errorcommunications'] = 'Portalen kunne ikke kommunisere med din mailserver. Sjekk innstillingene for utgående epost.';
$string['testoutgoingmailconf_fromemail'] = 'Fra brukernavn eller e-postadresse';
$string['testoutgoingmailconf_fromemail_help'] = 'Dette feltet emulerer sending av meldingen fra den brukeren, men Fra -overskriften som brukes i den virkelige e -posten som sendes, vil avhenge av andre innstillinger, for eksempel tillatte e -postdomener';
$string['testoutgoingmailconf_fromemail_invalid'] = 'Ugyldig Fra-brukernavn eller e -post. Må være et gyldig e -postformat eller et eksisterende brukernavn i Moodle.';
$string['testoutgoingmailconf_message'] = 'Dette er en testmelding for å bekrefte at du har konfigurert portalens utgående e-post. Sendt: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'Send en testmelding';
$string['testoutgoingmailconf_sentmail'] = 'Vellykket sending av testmelding til epostserveren. <br /> Fra {$a->fromemail}<br />Til: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}:Testmelding. {$a->additional} Sendt: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'Ekstra emne';
$string['testoutgoingmailconf_toemail'] = 'Til epostadresse';
$string['testoutgoingmaildetail'] = 'Før testing må du lagre konfigurasjonen. <br />{$a}';
$string['testsiteupgradewarning'] = 'Du bruker nå {$} testportal, for å oppgradere denne korrekt bør du bruke kommandolinjeverktøyet.';
$string['themedefinedinconfigphp'] = 'Temaet kan ikke endres fordi det er satt til {$a} i config.php.';
$string['themedesignermode'] = 'Modus for å arbeide med design';
$string['themedesignermodewarning'] = 'Designermodus er aktivert. Dette bør ikke være aktivert på produksjonsportalen siden det medfører en signifikant reduksjon i ytelsen.';
$string['themeeditsettingsname'] = 'Rediger temainnstillinger «{$a}»';
$string['themelist'] = 'Designoversikt';
$string['themeresetcaches'] = 'Slett mellomlagre av design';
$string['themeselect'] = 'Endre design';
$string['themeselector'] = 'Designgalleri';
$string['themesettingsadvanced'] = 'Avanserte design-innstillinger';
$string['themesettingscustom'] = 'Tilpassede designinnstillinger';
$string['themesettingsname'] = 'Designinnstillinger \'{$a}\'';
$string['themeusagereportname'] = 'Designbrukrapport \'{$a}\'';
$string['therewereerrors'] = 'Det var feil i dine data';
$string['thirdpartylibrary'] = 'Bibliotek';
$string['thirdpartylibrarylocation'] = 'Sted';
$string['thirdpartylibs'] = 'Tredjeparts biblioteker';
$string['timezone'] = 'Standard tidssone';
$string['timezoneforced'] = 'Dette er påtvunget av portalens administrator';
$string['timezoneinvalid'] = 'Ugyldig tidssone "{$a}"';
$string['timezoneisforcedto'] = 'Tving alle brukere til å benytte';
$string['timezonenotforced'] = 'Brukere kan velge sin egen tidssone';
$string['timezonephpdefault'] = 'Standard PHP tidssone ({$a})';
$string['timezoneserver'] = 'Serverens tidssone ({$a})';
$string['tlswarning'] = 'Fant ingen PHP/cURL-tillegg med støtte for TLS v1.2. Noen tjenester vil da muligens ikke fungere. Vi anbefaler sterkt at du oppdaterer TLS-bibliotekene.';
$string['tokenduration'] = 'Varighet for brukertoken.';
$string['tokenduration_desc'] = 'Hvor lenge en webservicetoken opprettet av en bruker (f.eks. via mobilappen) skal være gyldig.';
$string['tokenizerrecommended'] = 'Vi anbefaler sterkt at PHP Tokenizer biblioteket installeres - det forbedrer Moodle Networking funksjonaliteten.';
$string['tools'] = 'Administratorverktøy';
$string['toolsmanage'] = 'Administrer administrasjonsverktøy';
$string['unattendedoperation'] = 'Automatisk installasjon';
$string['unbookmarkthispage'] = 'Fjern bokmerket for denne siden';
$string['unicoderequired'] = 'Det er påkrevd at du lagrer alle data i Unicode format(UTF-8). Nye installasjoner må gjøres til Unicode-databaser. Dersom du oppgraderer må etterpå du kjøre UTF-8 migrasjonsrutinen i admin-menyen.';
$string['uninstallplugin'] = 'Fjern';
$string['unlockaccount'] = 'Lås opp brukerkonto';
$string['unoconvwarning'] = 'Den installerte versjonen av unoconv støttes ikke';
$string['unsupported'] = 'Ikke støttet';
$string['unsupporteddbfileformat'] = 'Databasen din bruker Antilope som filformat i enkelte tabeller. Full UTF8-støtte i MySQL og MariaDB krever at du benytter Barracuda-filformatet. Vennligst konverter tabellene til Barracuda filformatet. Se dokumentasjon for dette her: <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">MySQL full unicode support</a> for mer informasjon.';
$string['unsupporteddbfilepertable'] = 'For full støtte av UTF-8 fra både MySQL og MariaDB må du endre MySQL-innstillingen \'innodb_file_per_table\' til \'ON\'. Les dokumentasjonen for flere detaljer.';
$string['unsupporteddblargeprefix'] = 'For full støtte av UTF-8 fra både MySQL og MariaDB må du endre MySQL-innstillingen \'innodb_file_per_table\' til \'ON\'. Les dokumentasjonen for flere detaljer.';
$string['unsupporteddbstorageengine'] = 'Databaselagringsmotoren som brukes er ikke lenger støttet.';
$string['unsupporteddbtablerowformat'] = 'Databasen har tabeller ved hjelp Antelope som filformat . Du anbefales å konvertere tabellene til Barracuda filformat. Se dokumentasjonen <a href="https://docs.moodle.org/en/cli"> Administrasjon via kommandolinjen </a> for detaljer om et verktøy for å konvertere InnoDB tabeller til Barracuda .';
$string['unsupportedphpversion7'] = 'PHP versjon 7 og høyere støttes ikke.';
$string['unsupportedphpversion71'] = 'PHP verjon 7.1 og høyere støttes ikke';
$string['unsupportedphpversion72'] = 'PHP 7.2 og høyere støttes ikke';
$string['unsupportedphpversion73'] = 'PHP versjon 7.3 og høyere støttes ikke.';
$string['unsupportedphpversion74'] = 'PHP versjon 7.4 og høyere støttes ikke.';
$string['unsupportedphpversion80'] = 'PHP versjon 8.0 og høyere støttes ikke.';
$string['unsupportedphpversion81'] = 'PHP versjon 8.1 og høyere støttes ikke.';
$string['unsupportedphpversion82'] = 'PHP versjon 8.2 og høyere støttes ikke';
$string['unsupportedphpversion83'] = 'PHP versjon 8.3 eller høyere støttes ikke';
$string['unsupportedphpversion84'] = 'PHP versjon 8.4 og høyere støttes ikke';
$string['unsuspenduser'] = 'Aktiver brukerkonto';
$string['updateaccounts'] = 'Oppdater eksisterende konti';
$string['updateautocheck'] = 'Sjekk automatisk for tilgjengelige oppdateringer';
$string['updateautocheck_desc'] = 'Dersom aktivert, vil kursportalen automatisk sjekke om det finnes tilgjengelige oppdateringer for både Moodlekode og alle tilleggsmoduler. Hvis det finnes oppgraderinger, vil det sendes en varslingsepost til portaladministrator.';
$string['updateavailable'] = 'En nyere versjon av Moodle er tilgjengelig!';
$string['updateavailable_moreinfo'] = 'Mer informasjon...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Versjon {$a}';
$string['updateavailabledetailslink'] = 'Se {$a->url} for mer informasjon';
$string['updateavailableforplugin'] = 'En nyere versjon av noen av dine tilleggsmoduler er tilgjengelig!';
$string['updateavailableinstall'] = 'Installer denne oppdateringen';
$string['updateavailableinstallall'] = 'Installer tilgjengelige oppdateringer ({$a})';
$string['updateavailableinstallallhead'] = 'Installerer tilgjengelige oppdateringer';
$string['updateavailablenot'] = 'Moodleinstallasjonen din er oppdatert!';
$string['updateavailablerecommendation'] = 'Det anbefales på det sterkeste at du oppdaterer portalen til siste versjon for å få tilgang til alle nylige sikkerhetsoppdateringer og opprettede feil.';
$string['updatecomponent'] = 'Oppdater komponent';
$string['updateminmaturity'] = 'Nødvendig kodemodenhet';
$string['updateminmaturity_desc'] = 'Melding om tilgjengelig oppdatering gis bare når koden er moden nok. Oppdateringer for tilleggsmoduler som ikke oppgir kodemodenhet blir alltid meldt uavhengig av denne innstillingen.';
$string['updatenotificationfooter'] = 'Din Moodleportal {$a->siteurl} er konfigurert til å automatisk sjekke for oppdateringer. Du mottar denne meldingen som administrator for kursportalen. Du kan deaktivere automatisk oppgraderingssjekk ved å gå til Portalen / Server / Oppdateringsvarlser. Om du ønsker å motta denne meldingen på en annen måte kan du gjøre det under dine meldingspreferanser.';
$string['updatenotifications'] = 'Melding om oppdateringer';
$string['updatenotificationsubject'] = 'Det finnes en tilgjengelig oppdatering for din Moodleportal ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Gi melding om nye distribusjoner';
$string['updatenotifybuilds_desc'] = 'Dersom aktivert, blir tilgjengelige oppdateringer av Moodlekoden også varslet om når en ny distribusjon til den gjeldende Moodle-versjonen er gjort tilgjengelig. Distribusjoner er pågående forbedringer i en bestemt Moodleversjon. De blir vanligvis sluppet en gang i uken. Hvis deaktivert, vil tilgjengelige oppdateringer bare bli meldt om det kommer en høyere versjon av Moodle. Modulsjekken påvirkes ikke av denne innstillingen.';
$string['upgradeerror'] = 'Ukjent feil under oppgradering av {$a->plugin} til versjon {$a->version}. Kan ikke fortsette.';
$string['upgradeforumread'] = 'En ny egenskap har blitt lagt til i Moodle 1.5 for å spore leste/uleste foruminnlegg.<br />For å bruke denne funksjonaliteten må du <a href="{$a}">oppdatere tabellene dine</a>.';
$string['upgradeforumreadinfo'] = 'En ny funksjon for sporing av leste/uleste foruminnlegg ble lagt til i Moodle 1.5. For å ta i bruk denne funksjonen må du oppdatere tabellene med all sporingsinfo fra eksisterende innlegg. Avhengig av størrelsen på din portal kan dette ta lang tid (timer) og belaste databasen kraftig, så det er best du gjør dette i en stille periode. Likevel; Portalen vil fungere som normalt og brukerne blir ikke berørt. Når du starter prosessen må du la den gå ferdig.(Ikke lukk nettleservinduet). Dersom du likevel skulle lukke nettleseren din, ikke bekymre deg - du kan starte på nytt. <br /><br />Ønsker du å starte oppgraderingen nå?';
$string['upgradekeyreq'] = 'Oppgraderingsnøkkel påkrevd';
$string['upgradekeyset'] = 'Oppgraderingsnøkkel (la være tom for å kreve noen)';
$string['upgradelogs'] = 'For full funksjonalitet må de gamle loggene oppgraderes. <a href="{$a}">Mer informasjon</a>';
$string['upgradelogsinfo'] = 'Det er nylige endringer i måten loggene lagres. For å kunne se alle gamle logger sortert etter aktivitet må de gamle loggene oppgraderes. Dette kan ta lang tid avhengig av din side (flere timer) og det kan kreve store ressurser fra databasen for større portaler. Når du har startet denne prosessen bør du la den fullføre (med å ha nettleservinduet åpent). Og - siden vil fungere fint for andre brukere mens loggene oppgraderes.<br /><br />Vil du oppgradere loggene nå?';
$string['upgradepluginsfirst'] = 'Du må laste ned og installere tilgjengelige oppdateringer først.';
$string['upgradepluginsinfo'] = 'Oppdaterer moduler';
$string['upgradepluginsinfo_help'] = 'Det finnes tilgjengelige oppdateringer for noen av dine tilleggsmoduler. Du bør installere dem før du oppgraderer Moodle-databasen. Hvis portalen din ikke støtter automatiske oppdateringer må du laste ned og installere de nye modulversjonene manuelt.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Nye innstillinger';
$string['upgradesettingsintro'] = 'Innstillingene under ble lagt til i løpet av din siste Moodle-oppgradering. Utfør de endringene du trenger og klikk \'Lagre endringer\' nederst på denne siden.';
$string['upgradestalefiles'] = 'Sammenblandede Moodleversjoner oppdaget. Oppgraderingen kan ikke fortsette.';
$string['upgradestalefilesinfo'] = 'Moodle-oppdateringen har blitt stanset fordi PHP-skript fra minst to hovedversjoner av Moodleer oppdaget i Moodle-katalogen.

Dette kan føre til betydelige problemer senere, så for å fortsette må du sørge for at Moodle-katalogen inneholder kun filer for en enkelt versjon av Moodle.

Den anbefalte måten å rydde i Moodle-katalogen på er som følger:

* Endre gjeldende Moodle-katalog til "moodle_old"
* Lage en ny Moodle-katalog som kun inneholder filer fra enten en standard Moodle-pakke eller GIT.

* Flytt den opprinnelige config.php filen og eventuelle ikke-standardiserte moduler fra "moodle_old"-katalogen til den nye Moodle-katalogen

Når du har en ren Moodle-katalog, gjenopptar du oppdateringsprosessen i Moodle.

Denne advarselen er ofte forårsaket av en har unzippet en standard Moodle-pakke over en tidligere versjon av Moodle. Selv om dette er OK for mindre oppgraderinger, er det sterkt å fraråde for større Moodle-oppgraderinger.

Denne advarselen kan også være forårsaket av en ufullstendig oppdatering via  GIT, og da må du bare vente på at operasjon går ferdig, eller kanskje kjøre den aktuelle prosessen på nytt.

Du kan finne mer informasjon i oppgraderingsinformasjonen på <a href="{$a}">{$a}</a>';
$string['upgradestart'] = 'Oppgrader Moodledatabasen nå';
$string['upgradesure'] = '<p>Dine Moodle-filer har blitt endret, og du er i ferd med automatisk å oppgradere installasjonen til denne versjonen: <br /> <br />
<strong>{$a}</strong> </p>
<p>Når du starter på dette kan du ikke gå tilbake igjen. Vennligst vær klar over at oppgraderingsprosessen kan ta lang tid.</p>
<p>
Er du sikker på at du ønsker å oppgradere denne tjeneren til denne versjonen?</p>';
$string['upgradetimedout'] = 'Oppgraderingen tok for lang tid, vennligst prøv på nytt.';
$string['upgradingdata'] = 'Oppgraderer data';
$string['upgradinglogs'] = 'Oppgraderer logger';
$string['upgradingversion'] = 'Oppgraderer til ny versjon';
$string['upwards'] = 'oppover';
$string['useblogassociations'] = 'Aktiver asossieringer';
$string['user'] = 'Bruker';
$string['userbulk'] = 'Massehandlinger med brukere';
$string['userbulkdownload'] = 'Eksportér brukere som';
$string['userdefaultpreferences'] = 'Standard brukerpreferanser';
$string['userfeedbackafterupgrade'] = 'Etter hver hovedoppgradering';
$string['userfeedbackencouragement'] = '<P> Moodle 3.9 har en funksjon som gir brukere muligheten til å gi tilbakemelding om Moodle-programvaren til Moodle HQ. Ingen brukeridentifiserende informasjon blir videresendt til tredjeparter. </p>
<p> Moodle HQ prøver å være åpen og transparent når det gjelder datainnsamlingspraksis. Dermed vil vi sørge for at du er klar over og har kontroll over denne funksjonaliteten. </p>
<p> Tilbakemeldinger fra brukere vil i stor grad hjelpe Moodle HQ med å forbedre Moodle-programvaren. For å aktivere denne funksjonen, kan du gå til <a href="{$a}"> Tilbakemeldingsinnstillinger </a>. </p>';
$string['userfeedbacknextreminder'] = 'Neste påminnelse om tilbakemelding';
$string['userfeedbacknextreminder_desc'] = 'Når vi skal spørre brukeren igjen om en tilbakemelding?';
$string['userfeedbackperiodically'] = 'Jevnlig';
$string['userfeedbackremindafter'] = 'Vis påminnelse etter';
$string['userfeedbackremindafter_desc'] = 'Påminn brukerne igjen om å gi tilbakemelding etter det gitte antall dager.';
$string['userfiltersdefault'] = 'Standard brukerfiltere';
$string['userfiltersdefault_desc'] = 'Velg filtrene du vil vise på siden "Massebrukerhandlinger". For å velge flere filtre, hold nede Ctrl-tasten. Filtre som ikke er valgt, vil fortsatt være tilgjengelige via lenken "Vis mer".';
$string['userimagesdisabled'] = 'Brukerprofilbilder er deaktivert';
$string['userlist'] = 'Vis brukeroversikt';
$string['usermanagement'] = 'Brukeradministrasjon';
$string['userpolicies'] = 'Brukerprofiler';
$string['userpreference'] = 'Brukerinnstillinger';
$string['userquota'] = 'Kvoter for private filer';
$string['userquota_desc'] = 'Den maksimale mengden data hver bruker kan lagre på sitt private filområde.';
$string['users'] = 'Brukere';
$string['usesitenameforsitepages'] = 'Bruk portalnavn på Forsideressurser';
$string['usetags'] = 'Slå på taggfunksjonalitet';
$string['validateemptylineerror'] = 'Tomme linjer er ugyldige';
$string['validateerror'] = 'Denne verdien er ikke gyldig';
$string['validateerrorlist'] = 'Disse oppføringene er ugyldige: {$a}';
$string['validateiperror'] = 'Disse IP-dressene er ugyldige: {$a}';
$string['verifychangedemail'] = 'Begrens tillatte domener ved endring av e-postadresse';
$string['warningcurrentsetting'] = 'Feil nåværende verdi: {$a}';
$string['warningiconvbuggy'] = 'Din versjon av iconv-tillegget støtter ikke //IGNORE modifier. Du må derfor installere mbstring-tillegget, (siden det kan brukes i stedet) for å  rense strenger som inneholder ugyldige UTF-8 tegn.';
$string['webproxy'] = 'Webproxy';
$string['webproxyinfo'] = 'Fyll inn følgende valg hvis ikke Moodle-serveren din har tilgang til internett direkte. Internett-tilgang er nødvendig for å laste ned informasjon, språkpakker, RSS-agenter, tidssoner osv.<br/><em>PHP cURL-tillegg er svært anbefalt.</em>';
$string['xmlrpcwebserviceenabled'] = 'Det har blitt oppdaget at XML-RPC Web Service-protokollen er aktivert på portalen din. Denne funksjonen er avhengig av PHP XML-RPC-utvidelsen som ikke lenger vedlikeholdes av PHP.';
$string['yuicomboloading'] = 'kombinert lasting av YUI';
$string['ziprequired'] = 'ZIP PHP-tillegget kreves nå av Moodle. Info-ZIP eller PclZIP biblioteket er ikke lenger i bruk.';
