<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_deepseek', language 'nl', version '5.1'.
 *
 * @package     aiprovider_deepseek
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:explain_text:endpoint'] = 'API-eindpunt';
$string['action:explain_text:model'] = 'Tekstuitlegmodel';
$string['action:explain_text:model_help'] = 'Het model dat gebruikt wordt om de verstrekte tekst uit te leggen.';
$string['action:explain_text:systeminstruction'] = 'Systeeminstructie';
$string['action:explain_text:systeminstruction_help'] = 'Deze instructie wordt samen met de prompt van de gebruiker naar het AI-model gestuurd. Het bewerken van deze instructie wordt afgeraden, tenzij dit absoluut noodzakelijk is.';
$string['action:generate_text:endpoint'] = 'API-eindpunt';
$string['action:generate_text:model'] = 'AI-model';
$string['action:generate_text:model_help'] = 'Het model dat gebruikt wordt om het tekstantwoord te genereren.';
$string['action:generate_text:systeminstruction'] = 'Systeeminstructie';
$string['action:generate_text:systeminstruction_help'] = 'Deze instructie wordt samen met de prompt van de gebruiker naar het AI-model gestuurd. Het bewerken van deze instructie wordt afgeraden, tenzij dit absoluut noodzakelijk is.';
$string['action:summarise_text:endpoint'] = 'API-eindpunt';
$string['action:summarise_text:model'] = 'AI-model';
$string['action:summarise_text:model_help'] = 'Het model dat gebruikt wordt om de verstrekte tekst samen te vatten.';
$string['action:summarise_text:systeminstruction'] = 'Systeeminstructie';
$string['action:summarise_text:systeminstruction_help'] = 'Deze instructie wordt samen met de prompt van de gebruiker naar het AI-model gestuurd. Het bewerken van deze instructie wordt afgeraden, tenzij dit absoluut noodzakelijk is.';
$string['apikey'] = 'DeepSeek API-sleutel';
$string['apikey_help'] = 'Haal een sleutel op uit uw <a href="https://platform.deepseek.com/api_keys" target="_blank">DeepSeek API-sleutels</a>.';
$string['custom_model_name'] = 'Aangepaste modelnaam';
$string['extraparams'] = 'Extra parameters';
$string['extraparams_help'] = 'Extra parameters kunnen hier worden geconfigureerd. We ondersteunen het JSON-formaat. Bijvoorbeeld:
<pre>
{
"temperature": 0.5,
"max_tokens": 100
}
</pre>';
$string['invalidjson'] = 'Ongeldige JSON-tekenreeks';
$string['pluginname'] = 'DeepSeek API-provider';
$string['privacy:metadata'] = 'De DeepSeek API-providerplug-in slaat geen persoonlijke gegevens op.';
$string['privacy:metadata:aiprovider_deepseek:externalpurpose'] = 'Deze informatie wordt naar de DeepSeek API gestuurd om een respons te genereren. De instellingen van uw DeepSeek-account kunnen bepalen hoe DeepSeek deze gegevens opslaat en bewaart. Er worden door deze plugin geen gebruikersgegevens expliciet naar DeepSeek verzonden of opgeslagen in Moodle LMS.';
$string['privacy:metadata:aiprovider_deepseek:model'] = 'Het model dat gebruikt is om de respons te genereren.';
$string['privacy:metadata:aiprovider_deepseek:prompttext'] = 'De gebruiker heeft de tekstprompt ingevoerd die gebruikt werd om het antwoord te genereren.';
$string['settings'] = 'Instellingen';
$string['settings_frequency_penalty'] = 'frequentiestraf';
$string['settings_frequency_penalty_help'] = 'Getallen tussen -2,0 en 2,0. Positieve waarden bestraffen nieuwe tokens op basis van hun huidige frequentie in de tekst, waardoor de kans kleiner wordt dat het model dezelfde regel letterlijk herhaalt.';
$string['settings_help'] = 'Pas de onderstaande instellingen aan om aan te passen hoe verzoeken naar DeepSeek worden verzonden.';
$string['settings_logprobs'] = 'logprobs';
$string['settings_logprobs_help'] = 'Of de log-waarschijnlijkheden van de uitvoertokens al dan niet moeten worden geretourneerd. Indien true, worden de log-waarschijnlijkheden van elk uitvoertoken dat in de inhoud van het bericht wordt geretourneerd, geretourneerd.';
$string['settings_logprobs_label'] = 'Inschakelen';
$string['settings_max_tokens'] = 'max_tokens';
$string['settings_max_tokens_help'] = 'Geheel getal tussen 1 en 8192. Het maximale aantal tokens dat kan worden gegenereerd tijdens de chatvoltooiing. De totale lengte van invoertokens en gegenereerde tokens wordt beperkt door de contextlengte van het model. Als max_tokens niet is opgegeven, wordt de standaardwaarde 4096 gebruikt.';
$string['settings_presence_penalty'] = 'aanwezigheidsstraf';
$string['settings_presence_penalty_help'] = 'Een getal tussen -2,0 en 2,0. Positieve waarden bestraffen nieuwe tokens op basis van of ze al dan niet in de tekst voorkomen, waardoor de kans groter wordt dat het model over nieuwe onderwerpen praat.';
$string['settings_temperature'] = 'temperatuur';
$string['settings_temperature_help'] = 'Welke bemonsteringstemperatuur moet u gebruiken, tussen 0 en 2? Hogere waarden zoals 0,8 maken de uitvoer willekeuriger, terwijl lagere waarden zoals 0,2 de uitvoer gerichter en deterministischer maken. We raden over het algemeen aan om dit of top_p aan te passen, maar niet beide.';
$string['settings_top_logprobs'] = 'top_logprobs';
$string['settings_top_logprobs_help'] = 'Een geheel getal tussen 0 en 20 dat het aantal meest waarschijnlijke tokens aangeeft dat op elke tokenpositie wordt geretourneerd, elk met een bijbehorende logkans. logprobs moet worden ingesteld op true als deze parameter wordt gebruikt.';
$string['settings_top_p'] = 'top_p';
$string['settings_top_p_help'] = 'Een alternatief voor bemonstering met temperatuur, genaamd nucleus sampling, waarbij het model rekening houdt met de resultaten van de tokens met de hoogste waarschijnlijkheidsmassa. 0,1 betekent dus dat alleen de tokens met de hoogste waarschijnlijkheidsmassa van 10% in aanmerking worden genomen. We raden over het algemeen aan om dit of de temperatuur aan te passen, maar niet beide.';
