<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'et', version '5.1'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Juurdepääs keelatud';
$string['accounts'] = 'Kontod';
$string['addcategory'] = 'Lisa kategooria';
$string['additionalhtml'] = 'Täiendav HTML';
$string['additionalhtml_desc'] = 'Nende sätete kaudu saate määrata HTML-i, mis lisatakse igale lehele. Saate määrata HTML-i, mis lisatakse lehe jaotisse HEAD kohe pärast jaotise BODY avamist või vahetult enne jaotise BODY sulgemist.<br />Nende sätete abil saate igale lehele lisada kohandatud päiseid või jaluseid ning lisaks saab hõlpsasti ja kujundusest sõltumata lisada veebiteenuseid, nt Google Analytics.';
$string['additionalhtml_heading'] = 'Täiendav HTML, mis lisatakse kõigile lehtedele.';
$string['additionalhtmlfooter'] = 'Enne jaotise BODY lõpusilti';
$string['additionalhtmlfooter_desc'] = 'Sellel väljal olev sisu lisatakse igale lehele enne jaotise BODY lõpusilti.';
$string['additionalhtmlhead'] = 'Jaotisse HEAD';
$string['additionalhtmlhead_desc'] = 'Sellel väljal olev sisu lisatakse igale lehele jaotise HEAD lõppu.';
$string['additionalhtmltopofbody'] = 'Pärast jaotise BODY algussilti';
$string['additionalhtmltopofbody_desc'] = 'Sellel väljal olev sisu lisatakse kõigile lehtedele kohe pärast jaotise BODY algussilti.';
$string['admincategory'] = 'Kategooria: {$a}';
$string['adminseesall'] = 'Administraatorid näevad kõike';
$string['adminseesallevents'] = 'Administraator näeb kõiki sündmusi';
$string['adminseesownevents'] = 'Administraatorid on nagu kõik teised kasutajad';
$string['advancedfeatures'] = 'Täpsemad funktsioonid';
$string['agedigitalconsentverification'] = 'Lapse vanuse alampiiri kontroll infoühiskonna teenuse pakkumiseks';
$string['agedigitalconsentverification_desc'] = 'Lubab vanuse alampiiri kontrollimist enne iseregistreeruvate kasutajate registreerumislehe kuvamist. See kaitseb sinu saiti alaealiste registreerimise eest ilma vanemate / hooldajate nõusolekuta. Alaealistele antakse täiendava abi saamiseks <a target="_blank" href="{$a}"> tugikontakti </a> üksikasjad.';
$string['ageofdigitalconsentmap'] = 'Vanuse alampiir lapsele infoühiskonna teenuse pakkumiseks';
$string['ageofdigitalconsentmap_desc'] = 'Siin võib täpsustada vanuse alampiiri infoühiskonna teenuste pakkumiseks kui see erineb vaikeseadest. Sisesta iga vanus uuele reale vorminguga: riigikood, vanus (eraldatud komaga). Vaikimisi vanust tähistatakse riigikoodi asemel tähega *. Riigikoodid on täpsustatud standardis ISO 3166-2.';
$string['allcountrycodes'] = 'Kõik riigikoodid';
$string['allowattachments'] = 'Luba manused';
$string['allowbeforeblock'] = 'Lubatud loend töödeldakse enne';
$string['allowbeforeblockdesc'] = 'Vaikimisi vastendatakse blokeeritud IP-de loendi kirjeid kõige esimesena. Kui see valik on lubatud, siis töödeldakse lubatud IP-de loendi kirjed enne blokeeritud IP-de loendi kirjeid.';
$string['allowcategorythemes'] = 'Luba kategooriakujundused';
$string['allowcohortthemes'] = 'Luba kohordi teemad';
$string['allowcoursethemes'] = 'Luba kursusekujundused';
$string['allowedemaildomains'] = 'Lubatud meilidomeenid';
$string['allowediplist'] = 'Lubatud IP-de loend';
$string['allowemailaddresses'] = 'Lubatud meilidomeenid';
$string['allowemojipicker'] = 'Emotikonide valija';
$string['allowframembedding'] = 'Luba raami sisse manustamine';
$string['allowframembedding_help'] = 'Kui see säte on lubatud, saab selle õpikeskkonna kaugsüsteemis raamis manustada, nagu on soovitatav kursusele registreerumise lisandmooduli „Publish as LTI tool“ kasutamise korral. Muul juhul on soovitatav jätta raamis manustamise võimalus keelatuks.';
$string['allowguestmymoodle'] = 'Luba külaliskasutajale juurdepääs töölauale';
$string['allowindexing'] = 'Luba indekseerimine otsimootorite poolt';
$string['allowindexing_desc'] = 'See määrab, kas lubada otsimootoritel teie saiti indekseerida. "Kõikjal" võimaldab otsimootoritel otsida kõikjal, sealhulgas sisselogimis- ja registreerumislehtedel, mis tähendab, et saidid, kus Force Login on sisse lülitatud, on endiselt indekseeritud. Registreerimislehe otsimisega seotud rämpsposti ohu vältimiseks kasutage jaotist "Kõikjal, välja arvatud sisselogimis- ja registreerumislehed". "Kusagil" käsib otsimootoritel mitte ühtegi lehte indekseerida.';
$string['allowindexingeverywhere'] = 'Kõikjal';
$string['allowindexingexceptlogin'] = 'Kõikjal väljaarvatud sisselogimis- ja registreerumislehed';
$string['allowindexingnowhere'] = 'Mitte kuskil';
$string['allowobjectembed'] = 'Luba sildid EMBED ja OBJECT';
$string['allowthemechangeonurl'] = 'Luba kujundusmuudatusi URL-is';
$string['allowuserblockhiding'] = 'Luba kasutajatel plokke peita';
$string['allowusermailcharset'] = 'Luba kasutajatel valida tähemärgi kodeeringut';
$string['allowuserswitchrolestheycantassign'] = 'Luba rolle vahetada kasutajatel, kes pole rollimääramisõigust.';
$string['allowuserthemes'] = 'Luba kasutaja kujundused';
$string['alternativefullnameformat'] = 'Alternatiivne täisnimevorming';
$string['alternativefullnameformat_desc'] = 'See määratleb, kuidas kuvatakse nimesid kasutajatele, kel on tegevusluba viewfullnames (vaikimisi on nendeks kasutajad, kel on halduri, õpetaja või muutmisõiguseta õpetaja roll). Kohatäited, mida saab kasutada, on samasugused nagu sätte „Täisnime formaat“ puhul.';
$string['always'] = 'Alati';
$string['appearance'] = 'Välimus';
$string['aspellpath'] = 'Aspelli tee';
$string['authentication'] = 'Autentimine';
$string['authpreventaccountcreation'] = 'Keela autentimise käigus kontode loomine';
$string['authpreventaccountcreation_help'] = 'Kui kasutaja autentib, siis luuakse automaatselt konto, kui seda pole. Kui kasutatakse välist autentimis meetodit nagu LDAP, aga soovite anda ligipääsu ainult nendele kasutajatele kellel on juba LDAPis konto olemas, siis peaksite lubama selle meetodi. Uusi kontosid saab käsitsi luua või laadi üles kasutajad failist võimaluse abil. Märkus: See seade ei kehti MNet autentimise puhul.';
$string['authsettings'] = 'Autentimise haldus';
$string['autolang'] = 'Automaatne keeletuvastus';
$string['autolangusercreation'] = 'Kasuta keelt, mis kasutaja loomisel brauserist automaatselt tuvastatakse';
$string['autologinguests'] = 'Külaliste automaatne sisselogimine';
$string['availableto'] = 'Saadaval kuni';
$string['backgroundcolour'] = 'Läbipaistev värv';
$string['backup_shortname'] = 'Kasuta varukoopia failinimes kursuse nime';
$string['backup_shortnamehelp'] = 'Varukoopia failinime osana saab kasutada kursuse nime.';
$string['backups'] = 'Varukoopiad';
$string['badwordsconfig'] = 'Sisestage oma halbade sõnade komaeraldusega loend.';
$string['badwordsdefault'] = 'Kui kohandatud loend on tühi, siis kasutatakse keelepakis olevat loendit.';
$string['badwordslist'] = 'Kohandatud halbade sõnade loend';
$string['blockediplist'] = 'Blokeeritud IP-aadresside loend';
$string['blockinstances'] = 'Plokid';
$string['blockmultiple'] = 'Mitmekordne';
$string['blockprotect'] = 'Kaitse kustutamise eest';
$string['blockprotect_help'] = 'Kui teatud ploki lukustate, ei saa keegi selle eksemplare lisada ega kustutada. (Ploki saab avada kohe, kui mõnda selle eksemplari on vaja muuta).

See valik on mõeldud selleks, et kaitsta näiteks navigatsiooni- ja sätete plokki, mida on kogemata kustutamise järel keeruline taastada.';
$string['blocksettings'] = 'Halda plokke';
$string['bloglevel'] = 'Blogi nähtavus';
$string['bookmarkadded'] = 'Järjehoidja lisatud.';
$string['bookmarkalreadyexists'] = 'Selle lehe järjehoidja on juba olemas.';
$string['bookmarkdeleted'] = 'Järjehoidja on kustutatud.';
$string['bookmarkthispage'] = 'Lisa see leht järjehoidjate hulka';
$string['cacheapplication'] = 'Rakenduse vahemälu';
$string['cacheapplicationhelp'] = 'Puhverdatud elemendid on antud kõigile kasutajatele ühiskasutusse ja nende aegumine on määratletud aegumissätetes.';
$string['cachejs'] = 'Puhverda JavaScript';
$string['cachejs_help'] = 'JavaScripti puhverdamine ja tihendamine kiirendab lehe laadimist. Valmistussaitide puhul on see tungivalt soovitatav. Arendajad tõenäoliselt soovivad selle funktsiooni keelata.';
$string['cacherequest'] = 'Päringute vahemälu';
$string['cacherequesthelp'] = 'Kasutajapäringuga seotud vahemälu, mis aegub päringu lõpuleviimisel. Loodud asendama staatilist sisu.';
$string['cachesession'] = 'Seansi vahemälu';
$string['cachesessionhelp'] = 'Kasutajaga seotud vahemälu, mis aegub seansi lõppedes. Mõeldud seansi ülekoormuse vältimiseks.';
$string['cachesettings'] = 'Vahemälu sätted';
$string['cachetemplates'] = 'Vahemälu mallid';
$string['cachetemplates_help'] = 'Mallide vahemällu salvestamine parandab lehe laadimise jõudlust ja on tungivalt soovitatav tootekeskkonalle. Arendajad soovivad  selle funktsiooni tõenäoliselt keelata.';
$string['caching'] = 'Puhverdamine';
$string['calendar_weekend'] = 'Nädalavahetuse päevad';
$string['calendarexportsalt'] = 'Kalendri ekspordi sool';
$string['calendarsettings'] = 'Kalender';
$string['calendartype'] = 'Kalendri tüüp';
$string['calendartype_desc'] = 'Kogu saidi jaoks saab valida vaikekalendri. Selle sätte saab tühistada kursusesätete jaotises või kasutajad oma isikliku profiili kaudu.';
$string['cannotdeletemodfilter'] = 'Filtrit \'{$a->filter}\' ei saa desinstallida, sest see on mooduli \'{$a->module}\' osa.';
$string['cannotuninstall'] = '{$a} ei saa desinstallida';
$string['categoryemail'] = 'Meiliaadress';
$string['cfgwwwrootslashwarning'] = 'Oled kirjeldanud $CFG->wwwroot vigaselt oma config.php failis. Oled lisanud aadressi lõppu \'/\' märgi. Palun eemalda see, et vältida selliseid vigu:<a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'Oled kirjeldanud $CFG->wwwroot vigaselt oma config.php failis. See ei kattu lingiga, mida kasutad leheni jõudmiseks. Palun paranda see viga et välitad selliseid vigu:<a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'muuda';
$string['checkboxno'] = 'Ei';
$string['checkboxyes'] = 'Jah';
$string['checkupgradepending'] = 'Uuendus';
$string['choosefiletoedit'] = 'Vali fail keeleliseks toimetamiseks ülemisest kastikesest';
$string['cleanup'] = 'Puhastamine';
$string['clianswerno'] = 'ei';
$string['cliansweryes'] = 'jah';
$string['cliexitgraceful'] = 'Väljun graatsiliselt, palun oodake...';
$string['cliexitnow'] = 'Väljun KOHE';
$string['cliincorrectvalueerror'] = 'Tõrge, „{$a->option}“ sobimatu väärtus „{$a->value}“';
$string['cliincorrectvalueretry'] = 'Sobimatu väärtus, proovige uuesti';
$string['clistatusdisabled'] = 'Olek: keelatud';
$string['clistatusenabled'] = 'Olek: lubatud';
$string['clistatusenabledlater'] = 'olek: CLI hooldusrežiim lubatakse {$a}';
$string['clitypevalue'] = 'tüübi väärtus';
$string['clitypevaluedefault'] = 'tüübi väärtus, vaikeväärtuse kasutamiseks vajutage sisestusklahvi ({$a})';
$string['cliunknowoption'] = 'Tundmatud valikud:
  {$a}
Kasutage spikrivalikut.';
$string['cliupgradedefault'] = 'Uus seadistus: {$a}';
$string['cliupgradedefaultheading'] = 'Uute vaikeväärtuste seadistamine';
$string['cliupgradedefaultverbose'] = 'Uus seadistus: {$a->name}, Vaikeväärtus: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Käsurea põhine uuendus {$a->oldversion} {$a->newversion}  toimus edukalt.';
$string['cliupgradenoneed'] = 'Installitud versiooni {$a} puhul pole versiooniuuendust vaja. Täname külastamast!';
$string['cliupgradepending'] = 'Uuendus on ootel';
$string['cliyesnoprompt'] = 'tippige y (jah) või n (ei)';
$string['commentsperpage'] = 'Kommentaare lehe kohta';
$string['commonactivitysettings'] = 'Üldised tegevussätted';
$string['commonfiltersettings'] = 'Üldised filtreerimissätted';
$string['commonsettings'] = 'Üldsätted';
$string['componentinstalled'] = 'Komponent on installitud';
$string['computedfromlogs'] = 'Arvutatud logidest alates {$a}.';
$string['condifmodeditdefaults'] = 'Uue Tegevuse või Vahendi loomisel kasutatakse sätete vormil vaikeväärtusi.';
$string['confeditorhidebuttons'] = 'Vali nupud, mis peaksid olema peidetud HTML-toimetis.';
$string['configallcountrycodes'] = 'Siin on loend riikidest, mida saab valida eri kohtades (nt kasutajaprofiilis). Kui see väli on tühi, siis kasutatakse vaikimisi standardses inglise keele paketi failis countries.php olevat riigiloendit. See on loend, mis vastab ISO 3166-1 standardile. Võite ka ise määrata riigikoodide komaeraldusega loendi (nt \'GB,FR,ES\'). Kui soovite lisada uued, mittestandardsed koodid, peate selle lisama faili countries.php, mis asub kataloogis \'en\', ja enda valitud keelepaketti.';
$string['configallowassign'] = 'Saate lubada kasutajatel, kellel on vasakus veerus rolle, määrata mõne rolli teistele kasutajatele.';
$string['configallowattachments'] = 'Kui lubada antud säte, siis võivad antud õpikeskkonnast saadetud meilid sisaldada manuseid, nagu näiteks õpimärke.';
$string['configallowcategorythemes'] = 'Kui vastava sätte lubate, saab kujundusi määrata kategooria tasemel. See mõjutab kõiki alamkategooriaid ja kursusi, juhul kui neile pole oma kujundust määratud. HOIATUS. Kategooria tasemel kujunduste määramine võib mõjutada jõudlust.';
$string['configallowcohortthemes'] = 'Kui lubad selle, saab teemasid määrata kohordi tasemel. See mõjutab kõiki kasutajaid, kellel on ainult üks või mitu kohorti, kuid sama teema.';
$string['configallowcoursethemes'] = 'Kui selle sätte lubate, saavad kursused määrata oma kujundusi. Kursuste kujundused on kõigi muude kujundusvalikute (õpikeskkond, kasutaja, seanss) suhtes ülimuslikud.';
$string['configallowedemaildomains'] = 'Loetlege meilidomeenid, mille avaldamine saadetavate meilisõnumite saatja aadressina on lubatud. Vaikeväärtuse „Tühi“ korral kasutatakse saadetavate meilisõnumite jaoks mittevastavat aadressi. Saate kasutada metamärke, nt *.example.com lubab iga example.com-i alamdomeenilt saadetud meilisõnumi, aga mitte example.com-ilt saadetud meilisõnumi. Viimase jaoks on nõutav eraldi sissekanne.';
$string['configallowemailaddresses'] = 'Kui soovite seada piirangu, et kõik uued meiliaadressid kuuluksid mõnda kindlasse domeeni, sisestage need domeeninimed üksteisest tühikutega eraldades siia. Kõigist muudest domeenidest keeldutakse. Alamdomeenide lubamiseks lisage domeeninime ette punkt (.), nt <strong>meiekool.edu.au .gov.au</strong>';
$string['configallowemojipicker'] = 'Emotikonide valija võimaldab valida emotikone, nagu smailid, et neid lisada sõnumitele ja muudele tekstiväljadele. Vali Atto tööriistarial emotikoni valija nupp.';
$string['configallowemojipickerincompatible'] = 'Sinu praegune andmebaasi konfiguratsioon ei toeta emotikone õigesti. Emotikonide valija lubamiseks pead <a href="https://docs.moodle.org/en/MySQL_full_unicode_support"> oma andmebaasi täielikuks unikoodi toeks täiendama </a>.';
$string['configallowguestmymoodle'] = 'Kui see säte on lubatud, pääsevad külalised töölauale juurde. Muul juhul suunatakse külalised õpikeskkonna esilehele.';
$string['configallowobjectembed'] = 'Vaikimisi on kasutusel turbemeede, et tavakasutajad ei saa manustada multimeediumi (nt Flashi objekte) teksti, kasutades oma HTML-koodis silte EMBED ja OBJECT (selle toimingu saab teha meediumilisandmoodulite filtri abil). Kui soovite need sildid lubada, siis aktiveerige see valik.';
$string['configallowoverride'] = 'Saad lubada vasakul pool toodud rollides kasutajtel muuta osasid veerus toodud rolle';
$string['configallowoverride2'] = 'Valige, mis rolle saavad tühistada vasakus veerus olevad rollid.<br />Arvestage, et neid sätteid saavad kasutada üksnes need kasutajad, kellel on tegevusluba moodle/role:override või moodle/role:safeoverride.';
$string['configallowswitch'] = 'Valige, millised rollid saab kasutaja endale ise valida vastavalt sellele, mis rollid tal juba on. Lisaks selles tabelis olevale kirjele peab kasutajal rolli vahetamiseks olema tegevusluba moodle/role:switchroles.<br />Arvestage, et valida saab üksnes neid rolle, millel on õigus moodle/course:view ja millel pole tegevusluba moodle/site:doanything, seega on selles tabelis mõni veerg keelatud.';
$string['configallowthemechangeonurl'] = 'Kui see säte on lubatud, saab kujunduse muutmiseks lisada mis tahes Moodle’i URL-ile teksti ?theme=kujundusenimi (nt: mymoodlesite.com/?theme=afterburner ) või mis tahes sisemisele Moodle’i URL-ile teksti &amp;theme=kujundusenimi (nt: mymoodlesite.com/course/view.php?id=2&amp;theme=afterburner).';
$string['configallowuserblockhiding'] = 'Kas soovite, et kasutajad saaksid peita ja nähtavaks teha küljeplokke kogu õpikeskkonna ulatuses? See funktsioon kasutab iga ahendatava ploki oleku meelespidamiseks JavaScripti ja küpsisefaile ning mõjutab ainult kasutaja enda vaadet.';
$string['configallowusermailcharset'] = 'Võimaldades selle, siis iga kasutaja saab õpikeskkonnas määrata oma e-mailide tähtede märgistiku (charset).';
$string['configallowuserswitchrolestheycantassign'] = 'Vaikimisi moodle/role:assign on vajalik, et kõrgemad kasutajad saaksid Moodlet näha madlamate kasutajate rollis. Selle seade võimaldamisel see nõue kaob ja kõik kasutajad saavad Moodles osaleda mistahes rollis, mis on kirjeldatud tabelis "Rollide lubamine".
Selle seade lubamisel on soovitav "Rollide lubamise" tabelis kirjeldada õigudsed nii, et kasutajale ei antakst kõrgemasse rolli lülitumise õigust, kui on tema enda roll.';
$string['configallowuserthemes'] = 'Kui selle lubate, saavad kasutajad kujundused ise määrata. Kasutaja kujundused on ülimuslikud õpikeskkonna kujunduste suhtes (aga mitte kursuse kujunduste suhtes).';
$string['configallowview'] = 'Valige, milliseid rolle kasutaja näeb, saab filtreerida jne, arvestades mis rollid neil juba on.';
$string['configallusersaresitestudents'] = 'Kas õpikeskkonna esilehel olevate tegevuste jaoks loetakse kõiki kasutajaid õpilasteks? Kui sa vastad "Jah", siis iga kinnitatud kontot lubatakse neil tegevustel õpilasena osaleda. Kui sa vastad "Ei", siis ainult kasutajad, kes juba osalevad vähemalt ühel kursusel, võivad osa võtta esilehe tegevustest. Ainult administraatorid ja spetsiaalselt määratud õpetajad saavad osaleda esilehe tegevustes õpetajatena.';
$string['configauthenticationplugins'] = 'Valige autentimislisandmoodulid, mida soovite kasutada, ja järjestage need olulisuse järgi.';
$string['configautolang'] = 'Tuvastab brauserisätetest vaikekeele. Kui see säte on keelatud, kasutatakse saidi vaikekeelt.';
$string['configautolangusercreation'] = 'Kasuta kasutajate loomise ajal kasutajate brauseri keelt';
$string['configautologinguests'] = 'Kas tundmatud kasutajad tuleks automaatselt sisse logida külalisena, kui nad kursusele sisenevad?';
$string['configbloglevel'] = 'Selle sättega saab määrata, millisel tasemel kasutajablogisid kuvatakse. Arvestage, et see kehtib ainult VAATAJA kohta, mitte postitaja või blogipostituse tüübi kohta. Kui te blogisid ei soovi, saab need täielikult keelata.';
$string['configcalendarcustomexport'] = 'Luba kalendri eksportimisel kuupäevavahemiku valimine';
$string['configcalendarexportsalt'] = 'See juhuslik tekst on mõeldud kalendrite eksportimisel kasutatavate autentimistõendite turvalisuse suurendamiseks. Võtke arvesse, et kui muudate räsi soola, muutuvad kõik praegu kasutusel olevad tõendid kehtetuks.';
$string['configcookiesecure'] = 'Kui server aktsepteerib ainult https-ühendusi, on soovitatav lubada turvaliste küpsisefailide saatmine. Selle sätte lubamise korral veenduge, et veebiserver ei aktsepteeriks http://-aadresse, või seadistage püsiümbersuunamine https://-aadressile. Ideaaljuhul peaks saadetama ka HSTS-päised. Kui aadress <em>wwwroot</em> ei alga protokolliga https://, eiratakse seda sätet.';
$string['configcountry'] = 'Kui määrate siin riigi, siis valitakse see riik vaikimisi kõigi uute kasutajakontode puhul. Et kasutajat sundida riiki valima, jätke siin riiki valimata.';
$string['configcoursegraceperiodafter'] = 'Klassifitseeri möödunud kursused käimasolevateks niimitu päeva pärast kursuse lõppkuupäeva.';
$string['configcoursegraceperiodbefore'] = 'Klassifitseerige tuleviku kursused käimasolevateks päevadeks niimitu päeva enne kursuse alguskuupäeva.';
$string['configcourseoverviewfilesext'] = 'Kursusekokkuvõtte failide puhul lubatud laiendite komaeraldusega loend.';
$string['configcourseoverviewfileslimit'] = 'Kursuse kokkuvõttele manustatavate failide maksimumarv.';
$string['configcourserequestnotify'] = 'Sisesta kasutajanimi, keda teavitatakse uue kursuse tellimisel.';
$string['configcourserequestnotify2'] = 'Kasutajad, keda kursusetaotluse esitamise korral teavitatakse. Siin kuvatakse ainult need kasutajad, kes saavad kursusetaotlusi kinnitada.';
$string['configcoursesperpage'] = 'Sisestage arv, mitu kursust kuvatakse ühel kursuste loendi lehel';
$string['configcourseswithsummarieslimit'] = 'Kursuste maksimumarv, mis kuvatakse kursuste loendis koos kokkuvõtetega enne lihtsustatud loendisse naasmist.';
$string['configcronclionly'] = 'Kui käivitate cron-käsu veebibrauseris, võib privileegteave saada teatavaks anonüümsetele kasutajatele. Seetõttu on soovitatav käivitada cron-käsk ainult käsurea kaudu või määrata kaugpääsu jaoks cron-protsessi parool.';
$string['configcronremotepassword'] = 'See tähendab, et cron.php skripti ei saa käivitada veebibrauserist ilma järgmise URL-i kaudu esitatud paroolita:<pre>
    http://site.example.com/admin/cron.php?password=minuparool
</pre>Kui see väli on jäetud tühjaks, siis parooli ei nõuta.';
$string['configcurlcache'] = 'cURL-i puhvri eluiga sekundites.';
$string['configcustommenuitems'] = 'Saate konfigureerida kohandatud menüü, mis kuvatakse koos kujundusega. Iga rida sisaldab mõnd menüüteksti, lingi URL-i (valikuline), kohtspikri pealkirja (valikuline), keelekoodi või komaeraldusega koodiloendit (valikuline, rea kuvamiseks üksnes vastava keele kasutajatele), mis on eraldatud püstkriipsudega. Sidekriipsuga algavad read kuvatakse eelmise ülatasememenüü elementidena ning eraldajate kasutamiseks lisage #-märk või #-märkide rida. Näiteks: <pre>
Moodle’i kasutajaskond|http://moodle.org
-Moodle’i tasuta tugi|http://moodle.org/support
-Moodle’i juhendid|http://docs.moodle.org|Moodle Docs
-Moodle’i saksakeelsed juhendid|http://docs.moodle.org/de|Documentation in German|de
-### -Moodle’i arendus|https://moodle.org/development Moodle.com|http://moodle.com/
</pre>';
$string['configcustomusermenuitems'] = 'Saate konfigureerida kasutajamenüü sisu (v.a lingi „Logi välja“, mis lisatakse automaatselt). Iga rida on eraldatud püstkriipsudega ja koosneb: 1) string kujul „langstringname, componentname“ või lihttekstina; 2) URL ja 3) ikoon kas piksliikooni (kaustas pix/t, või kui ikoon on mõnes muus kaustas, siis eesliide ja ikooni nimi koos kaldkriipsuga ../) või URL-ina. Eraldajatena võib soovi korral kasutada ühte või mitu järjestikust trellimärki (#).';
$string['configdbsessions'] = 'Kui see säte on lubatud, siis hakatakse aktiivsete seansside teavet hoidma andmebaasis. Arvestage, et selle sätte muutmisel logitakse kõik sisselogitud kasutajad välja (teie kaasa arvatud). Kui kasutate MySQL-andmebaasi, siis veenduge, et parameetri \'max_allowed_packet\' failis my.cnf (või my.ini) väärtus oleks vähemalt 4M. Muid seansidraivereid saab konfigureerida otse failis config.php. Lisateavet leiate failist config-dist.php See säte kaob, kui määratlete failis config.php seansidraiveri.';
$string['configdebug'] = 'Kui selle sätte aktiveerite, siis PHP tõrketeadete hulk suureneb ja kuvatakse rohkem hoiatusi. See on vajalik üksnes tarkvaraarendajatele.';
$string['configdebugdisplay'] = 'Lubage see säte, kui soovite, et tõrketeated väljastataks HTML-lehele. See on mõistlik, kuid lõhub XHTML-i, JS-i, küpsisefailid ja HTTP-päised. Kui selle sätte keelate, siis saadetakse väljund parema silumise tagamiseks teie serverilogisse. PHP setting error_log kontrollib, mis logisse see kantakse.';
$string['configdebugpageinfo'] = 'Lubage see säte, kui soovite, et lehe teave kuvataks jaluses.';
$string['configdebugvalidators'] = 'Lubage see säte, kui soovite, et lehe jaluses kuvataks väliste valideerimisserverite lingid. Võimalik, et teil on vaja luua uus kasutaja kasutajanimega <em>w3cvalidator</em> ja lubada külalispääs. Need muudatused võimaldavad serverile autentimata juurdepääsu, ärge seda sätet valmistussaitide korral lubage.';
$string['configdefaulthomepage'] = 'Määrab sisseloginud kasutajate jaoks avalehe.';
$string['configdefaultrequestcategory'] = 'Kasutajate kursusetaotlused pannakse automaatselt sellesse kategooriasse.';
$string['configdefaultrequestedcategory'] = 'Vaikimisi kategooria uute kursuste taotlemisel.';
$string['configdefaultuserroleid'] = 'Kõigile sisseloginud kasutajatele määratakse vastav roll, mille määrate siin, keskkonna tasemel, LISAKS muudele rollidele, mis neil juba on. Vaikimisi roll on „Sisenenud kasutajad“. Arvestage, et see ei tekita konflikte muude rollidega juhul, kui mingeid õigusi ära ei keelata, see tagab, et kõigil kasutajatel on vaikeõigused, mida ei saa kursuse tasemel määrata (näiteks blogisissekannete vaatamine, kalendri haldamine jne).';
$string['configdeleteincompleteusers'] = 'Selle aja möödumisel pooleldi häälestatud kontod kustutatakse.';
$string['configdeleteunconfirmed'] = 'Kui kasutusel on e-posti kaudu autentimine, siis siin määratud ajavahemiku jooksul aktsepteeritakse kasutajate vastuseid. Selle aja möödumisel kinnitamata kontod kustutatakse.';
$string['configdenyemailaddresses'] = 'Et keelata e-posti aadressid kindlatelt domeenidelt, loetlege need siin samal moel. Kõik muud domeenid on lubatud. Alamdomeenide keelamiseks lisage domeeninime ette \'.\'. (näiteks <strong>hotmail.com yahoo.co.uk .live.com</strong>).';
$string['configdisableuserimages'] = 'Keelab kasutajatel profiilipildi muutmise.';
$string['configdisplayloginfailures'] = 'See kuvab kasutajatele varasemate nurjunud sisselogimiste teabe.';
$string['configdndallowtextandlinks'] = 'Luba või keela tekstide ja linkide lohistamine ja asetamine kursuse lehele lisaks failidele. Pane tähele, et teksti lohistamine Firefox veebilehitseja aknasse või erinevate veebilehitsejate vahel võib viia üleslaadimise katkemiseni või muuta üleslaaditava teksti kõlbmatuks.';
$string['configdoclang'] = 'Seda keelt kasutatakse dokumentatsioonilehtede linkides.';
$string['configdocroot'] = 'Määratleb Moodle Docsi tee linkide „Moodle Docs for this page“ kaudu kontekstispetsiifilise dokumentatsiooni kuvamiseks iga lehe jaluses. Kui see väli on tühi, siis linke ei kuvata.';
$string['configdoctonewwindow'] = 'Kui selle sätte lubate, siis kuvatakse Moodle Docsi lingid uues aknas.';
$string['configeditordictionary'] = 'Seda väärtust kasutatakse, kui tõlkes puudub sõnastik kasutaja keele jaoks.';
$string['configeditorfontlist'] = 'Vali milliseid fonte kuvatakse tekstiredaktori fondi nimekirjas';
$string['configemailchangeconfirmation'] = 'Nõua meili teel kinnitamist, kui kasutaja muudab oma profiilis meiliaadressi.';
$string['configemaildkimselector'] = 'DKIM-valija on meelevaldne ja sinu DNS-kirjed peavad vastama sellele.';
$string['configemailfromvia'] = 'Lisage saadetavate meilisõnumite saatja aadressi väljale teave selle kohta, millise teenuse kaudu meilisõnum saadeti. Adressaadile kuvatakse, kust meilisõnum pärineb. See vähendab tõenäosust, et adressaat vastab tahtmatult mittevastavale meiliaadressile.';
$string['configemailheaders'] = 'E-posti päised, mis lisatakse sõna-sõnalt kõigile väljaminevatele meilidele.';
$string['configemailsubjectprefix'] = 'Kõigile väljaminevatele e-kirjade teemareale lisatav tekst.';
$string['configenableanalytics'] = 'Analüüsimudelid, nagu „Väljalangemise ohus õpilased” või „Tulevased Tegevused”, võivad luua ennustusi, saata siseinfoga teateid ja pakkuda edasisi toiminguid, näiteks sõnumside kasutajaid.';
$string['configenableblogs'] = 'See lüliti tekitab igale saidi kasutajale oma blogi.';
$string['configenablecalendarexport'] = 'Lubab kalendrite eksportimise või jälgimise.';
$string['configenablecomments'] = 'Luba kommentaarid';
$string['configenablecourserequests'] = 'Võimaldab igal kasutajal taotleda kursuse loomist.';
$string['configenablemobilewebservice'] = 'Saate lubada mobiilsideteenuse ametliku Moodle’i rakenduse või muude rakenduste jaoks, mis seda nõuavad. Lisateave: {$a}';
$string['configenablerssfeeds'] = 'Kui see säte on lubatud, siis genereerivad õpikeskkonna erinevad funktsioonid (blogid, foorumid, andmebaasitegevused ja sõnastikud) RSS-kanaleid. Arvestage, et RSS-kanalid tuleb lubada ka konkreetse tegevusmooduli jaoks.';
$string['configenablerssfeedsdisabled'] = 'See ei ole kättesaadaval, kuna RSS toide on välja lülitatud kogu keskkonnast. Sisse lülitamiseks mine muutujate seadistusse, mis asub administraatori konfiguratsiooni all.';
$string['configenablerssfeedsdisabled2'] = 'RSS-kanalid on serveri tasemel keelatud. Peate need esmalt lubama asukohas Server/RSS.';
$string['configenablestats'] = 'Kui valite siin valiku Jah, siis töötleb Moodle cronjob logid ja kogub statistikat. Olenevalt lehe veebiliiklusest võib selle genereerimine aega võtta. Kui selle sätte lubate, siis kuvatakse huvitavaid graafikuid ja statistikat iga kursuse või terve keskkonna kohta.';
$string['configenabletrusttext'] = 'Vaikimisi puhastab Moodle alati teksti, mida kasutajad sisestavad, ja eemaldab kõik kahtlased/ohtlikud skriptid, meediumid jms, mis võivad põhjustada turberiske. Süsteem Usaldusväärne sisu võimaldab teatud usaldusväärsetele kasutajatele anda võimaluse lisada neid funktsioone oma sisusse ilma vahelesegamiseta. Selle süsteemi lubamiseks tuleb esmalt lubada see säte ja seejärel anda kindlale Moodle’i rollile õigus Usaldusväärne sisu. Selles rollis olevate kasutajate loodavaid või üleslaaditavaid tekste ei puhastata.';
$string['configenablewebservices'] = 'Veebiteenused võimaldavad muudel süsteemidel Moodle’isse siseneda ja teha teatud tegevusi. Parema turvalisuse huvides tuleks see funktsioon keelata, kui te seda kasutada ei plaani.';
$string['configenablewsdocumentation'] = 'Luba veebiteenuste dokumentatsiooni automaatne genereerimine. Kasutaja saab juurdepääsu oma turbevõtmete lehel {$a} olevale dokumentatsioonile. Dokumentatsioon kuvatakse üksnes lubatud protokollide kohta.';
$string['configerrorlevel'] = 'Vali PHP hoiatuste hulk, mida soovid kuvada. Parim valik on enamasti Normal.';
$string['configexportlookahead'] = 'Eksportimisel ettepoole arvestatavate päevade arv';
$string['configexportlookback'] = 'Eksportimisel tagasi arvestatavate päevade arv';
$string['configextendedusernamechars'] = 'Kui see on lubatud, võivad kasutajanimed sisaldada mis tahes märke, välja arvatud suurtähed. Muul juhul on lubatud ainult väiketähtede, alakriipsuga (_), sidekriipsu (-), punkti (.) ja sümboliga (@) tähtnumbrilised tähemärgid.';
$string['configextramemorylimit'] = 'Mõned skriptid, nagu otsing, varukoopia/taastus ja cron, vajavad rohkem mälu. Suuremate saitide jaoks saate määrata suuremad väärtused.';
$string['configfilterall'] = 'Filtreeri kõiki stringe, kaasa arvatud päiseid, pealkirju, navigatsiooniribasid jne. See omab mõtet, kui kasutad mitmekeelsuse filtrit, vastasel juhul tekitab ainult lisakoormust veebilehele.';
$string['configfiltermatchoneperpage'] = 'Automaatne lingi filtreerimine genereerib ühe lingi ainult kogu lehel esimese tekstivaste leidmisel, kõiki muid ignoreeritakse.';
$string['configfiltermatchonepertext'] = 'Automaatne lingi filtreerimine genereerib ühe lingi lehel igas tekstiüksuses (nt vahend, plokk) esimese tekstivaste leidmisel. Kõiki muid ignoreeritakse. Seda sätet eiratakse, kui sätte „Üks lehe kohta“ väärtus on <i>Jah</i>';
$string['configfilteruploadedfiles'] = 'Selle seade lubamisel laseb Moodle enne näitamist kõik üleslaaditud HTML- ja tekstifailid läbi filtrite.';
$string['configforcelogin'] = 'Tavaliselt on avaleht ja kursuste loendid (mitte kursused ise) nähtavad ka sisenemata. Kui soovite, et kasutajad peavad enne sisse logima, kui nad vastaval saidil MIDAGI teha saavad, siis lubage see säte.';
$string['configforceloginforprofiles'] = 'Selle sättega saab inimesi sundida sisenema reaalse kontoga (mitte külalisena), muidu nad ei saa kasutajaprofiile vaadata. Kui selle sätte keelate, võib juhtuda, et mõni kasutaja postitab oma profiilile reklaam- või muud sobimatut sisu ja see kuvatakse ka otsingumootorites.';
$string['configfrontpage'] = 'Ülalpool valitud komponendid kuvatakse õpikeskkonna esilehel.';
$string['configfrontpagecourselimit'] = 'Kursuste maksimumarv';
$string['configfrontpagecourselimithelp'] = 'Suurim kursuste arv, mis kuvatakse saidi avalehel kursuste loendis.';
$string['configfrontpageloggedin'] = 'Ülalpool valitud komponendid kuvatakse õpikeskkonna esilehel pärast seda, kui kasutaja on sisse loginud.';
$string['configfullnamedisplay'] = 'Sellega määratletakse ka täisnimede kuvamine. Vaikeväärtuse „language“ korral määrab selle aktiivne keelepaketi string „fullnamedisplay“. Mõnes keeles on teistsugused nimekuvamisreeglid.

Enamiku ükskeelsete saitide puhul on mõttekaim valida säte „firstname lastname“, kuid võib ka üldse perekonnanimedest loobuda. Kasutada võib järgmisi kohatäiteid: firstname, lastname, firstnamephonetic, lastnamephonetic, middlename ja alternatename.';
$string['configgeoipfile'] = 'GeoLite2 City binaarandmete faili asukoht. See fail ei kuulu Moodle’i levituskomplekti ja peab olema hangitud eraldi saidilt <a href="http://www.maxmind.com/">MaxMind</a>. Saate osta kommertsversiooni või kasutada tasuta versiooni. Selleks laadige alla <a href="http://geolite.maxmind.com/download/geoip/database/GeoLite2-City.mmdb.gz" >http://geolite.maxmind.com/download/geoip/database/GeoLite2-City.mmdb.gz</a> ja pakkige see oma serveris lahti kataloogi „{$a}“.';
$string['configgetremoteaddrconf'] = 'Kui teie server asub pöördpuhverserveri taga, siis saate selle sätte abil määrata, millised HTTP- päised võivad sisaldad kaug-IP-aadressi. Päiseid loetakse järjekorras, kasutades esimest saadaolevat.';
$string['configgradebookroles'] = 'Selle sättega saab määrata, kes hinnetelehel kuvatakse. Kursuse hinnetelehel kuvamiseks peab kasutajal olema vähemalt üks selle kursuse rollidest.';
$string['configgradeexport'] = 'Valige hinnetelehe ekspordi jaoks peamised ekspordivormingud. Valitud lisandmoodulid määravad iga hinde jaoks välja „Viimati eksporditud“ ja kasutavad seda. Näiteks saab selle abil kindlaks teha, kas kirjed on uued või värskendatud. Kui te pole nende valikute suhtes kindel, jätke märkeruudud tühjaks.';
$string['confighiddenuserfields'] = 'Siin saab valida, millised kasutajateabe väljad teiste kasutajate (v.a kursuse õppejõud ja administraatorid) eest peita. Selle abil saab suurendada õppijate privaatsust. Mitme välja valimiseks hoidke all juhtklahvi (CTRL).';
$string['configidnumber'] = 'See seade määrab, kas (a) Kasutajatelt ei küsita ID numbrit üldse,(b) Kasutajatelt küsitakse ID numbrit, kuid nad saavad selle välja tühjaks jätta või (c) Kasutajatelt küsitakse ID numbrit ja välja ei saa tühjaks jätta. Kasutajate ID numbrit näidatakse tema profiilis, kui nii on seadistatud.';
$string['configintro'] = 'Sellel lehel saate määrata konfiguratsioonimuutujate arvu, mis võimaldavad Moodle’il teie serveris korralikult töötada. Ärge muretsege, vaikesätted toimivad enamasti hästi ja võite alati sellele lehele naasta ning sätteid muuta.';
$string['configintroadmin'] = 'Sellel lehel sa peaksid konfigureerima peamise administraatori konto, mis kontrollib kogu õpikeskkonda. Veendu, et kasutajanimi ja parool on turvalised ning e-posti aadress kehtib. Hiljem võid administraatori kontosid veel juurde luua.';
$string['configintrosite'] = 'Sellel lehel saate konfigureerida uue õpikeskkonna esilehe ja nime. Saate hiljem siia igal ajal tagasi tulla ja haldusmenüüde kaudu sätteid muuta.';
$string['configiplookup'] = 'Kui vajutad IP-aadressil (nt. 34.12.222.93), näiteks logides, siis kuvatakse kaart, kus antud IP-aadress arvatavasti peaks asuma. Kasutada on võimalik erinevaid pluginaid, millel igaühel on oma plussid ja miinused.';
$string['configkeeptagnamecase'] = 'Märkige see ruut, kui soovite sildinimede puhul säilitada algse suurtähestuse (nagu kasutajad sildinimed sisestanud on)';
$string['configlang'] = 'Valige kogu õpikeskkonna jaoks vaikekeel. Kasutajad võivad seda sätete hiljem oma äranägemise järgi muuta, valides vastava keele keelemenüüst või oma isikliku profiili sätetest.';
$string['configlanglist'] = 'Kui soovite, et kasutajad saaksid valida kõigi teie Moodle’i eksemplaris saadaolevate keelte hulgast, jätke see väli tühjaks. Keeltemenüü lühendamiseks saate sisestada soovitud keelte komaeraldusega loendi. Näiteks: en,es_es,fr,it';
$string['configlangmenu'] = 'Valige, kas üldine keeltemenüü avalehel, sisselogimislehel jm kuvatakse või mitte. See säte ei mõjuta kasutaja võimalust valida eelistatud keel tema oma profiilis.';
$string['configlangstringcache'] = 'Puhverdab kõik keelestringid andmekataloogis olevatesse kompileeritud failidesse. Kui parasjagu tõlgite Moodle’it või muudate tõlkeid Moodle’i lähtekoodis, siis tasuks see säte välja lülitada. Muul juhul tuleks see säte sisselülitatuna hoida, kuna see suurendab jõudlust.';
$string['configlatinexcelexport'] = 'Valige Exceli eksportide jaoks kodeering.';
$string['configlocale'] = 'Valige kogu õpikeskkonna lokaat – see alistab kõigi keelepakettide kuupäevavormingu ja -keele (kuid ei mõjuta kalendri nädalapäevade nimesid). Lokaadi andmed peavad olema operatsioonisüsteemi installitud (nt Linuxi korral en_US.UTF-8 või es_ES.UTF-8). Enamikul juhtudel tuleb see väli tühjaks jätta.';
$string['configlockrequestcategory'] = 'Kui see on lubatud, ei saa kasutajad, kes saavad süsteemi kontekstis taotleda uusi kursusi, uut kursusevormi taotlemise kategooriat valida. Alternatiivne viis piirata kasutajaid uue kategooria taotlemisega ainult ühes kategoorias on rakendada võimalust taotleda uusi kursusi kategooria kontekstis.';
$string['configloglifetime'] = 'Sellega määratakse ajavahemik, mille jooksul kasutajate tegevuse logifailid säilitatakse. Logid, mis on sellest vanemad, kustutatakse automaatselt. Parim lahendus on hoida logifaile võimalikult kaua (sest neid võib vaja minna), ent väga koormatud serveri ja toimimisprobleemide korral võiks logifailide eluiga lühendada. Soovitatav väärtus on 30 ja rohkem, muidu ei pruugi statistikaarvutused õigesti toimida.';
$string['configlookahead'] = 'Ettepoole arvestatavad päevad';
$string['configmailnewline'] = 'E-mailides kasutatav uue rea märk. CRLF on nõutav, et olla vastavuses RFC 822bis-ga, mõned e-mailiserverid automaatselt konverteerivad LF lõpu CRLF lõpuks, muud e-mailiserverid teevad vigast konvertimist CRLF-st CRCRLF-sse, veel mõned lükkavad tagasi e-mailid ainult LF-ga (näiteks qmail ). Proovi muuta neid seadeid, kui tekib probleeme kohale mitte jõudnud e-mailidega või topelt uute ridadega.';
$string['configmaxbytes'] = 'Selle sättega määratakse üleslaaditavate failide maht kogu õpikeskkonnas. Selle sätte väärtus määratakse PHP sätetega post_max_size ja upload_max_filesize ning Apache’i sättega LimitRequestBody. Säte „maxbytes“ omakorda määratleb ka kursuse ja mooduli tasemel valitava suurusevahemiku. Kui valitud on „Server Limit“, kasutatakse serveri lubatud maksimumväärtust.';
$string['configmaxconsecutiveidentchars'] = 'Paroolides ei tohiks esineda enam kui märgitud arv identseid sümboleid järjest. Sisesta siia 0, et seda kontrolli mitte rakendada.';
$string['configmaxeditingtime'] = 'Selle sättega määratakse aeg, mille jooksul saab muuta foorumipostitusi, sõnastiku kommentaare jms. Üldjuhul on sobiv aeg 30 minutit.';
$string['configmaxevents'] = 'Tulevased sündmused';
$string['configmaxusersperpage'] = 'Kursuse, rühma, õpperühma, veebiteenuse jms kasutajaselektoris kuvatav maksimaalne kasutajate arv.';
$string['configmessaging'] = 'Kas õpikeskkonna kasutajate jaoks peaks olema lubatud sõnumsidesüsteem?';
$string['configmessagingallowemailoverride'] = 'Luba kasutajatel saada meiliteatisi kasutaja profiilis olevast meiliaadressist erinevale aadressile';
$string['configmessagingallusers'] = 'Kui see on lubatud, saavad kasutajad sõnumi saatmiseks vaadata kõigi saidi kasutajate loendit. Samuti võimaldab see seadistus võtta vastu sõnumeid saidi kõigilt kasutajatelt. Kui see on keelatud, saavad kasutajad vaadata ainult oma kursuse kasutajaloendilt ja neil on sõnumieelistustes vaid kaks võimalust - võtta vastu sõnumeid ainult oma kontaktidelt või nende kontaktidelt ja kõigilt nende kursuse
kasutajatelt.';
$string['configmessagingdefaultpressenter'] = 'Kas kasutajate sõnumside seadetes on vaikimisi sisselülitatud valik „Kasuta saatmiseks Enter klahvi”.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Ruumi säästmiseks saab loetud ja lugemata teatised kustutada. Kui kaua pärast teatise loomist võib selle kustutada?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Lugemisteatised saab ruumi kokkuhoidmiseks kustutada. Millal teatis pärast läbilugemist kustutatakse?';
$string['configminpassworddigits'] = 'Paroolid peavad sisaldama vähemalt nii palju numbreid.';
$string['configminpasswordlength'] = 'Paroolid peavad sisaldama vähemalt nii tähemärki pikad.';
$string['configminpasswordlower'] = 'Paroolid peavad sisaldama vähemalt nii palju väiketähti.';
$string['configminpasswordnonalphanum'] = 'Paroolid peavad sisaldama vähemalt nii palju mitte numbreid ja tähti.';
$string['configminpasswordupper'] = 'Paroolid peavad sisaldama vähemalt nii palju suurtähti.';
$string['configmypagelocked'] = 'Need seaded piiravad vaikimisi lehe muutmist mitte-administraatorite poolt.';
$string['confignavcourselimit'] = 'Piirab kasutajatele navigeerimisel kuvatavate kursuste arvu.';
$string['confignavshowallcourses'] = 'Selle sättega saate määrata, kas kursustele registreerunud kasutajatele kuvatakse navigeerimisribal üksnes loend „Minu kursused“ (nende kursuste loend, kuhu kasutaja on registreerunud) või ka loend „Kursused“ (kõigi kursuste loend).';
$string['confignavshowcategories'] = 'Kuva kursuste kategooriad navigeerimisribal ja -plokkides. See ei kehti nende kursuste kohta, kuhu kasutaja on registreerunud, need kursused kuvatakse endiselt jaotises „Minu kursused“ ilma kategooriateta.';
$string['confignoreplyaddress'] = 'E-kirjad saadetakse vahepeal välja foorumi postitaja poolt. E-posti aadress, mille täpsustad siin, läheb kasutusse "Saatja" vormi neil juhtudel, kui kirja saajatel ei tohi olla võimalust otse kasutajale vastata (nt. kui kasutaja on seadnud oma aadressi privaatseks).';
$string['confignotifyloginfailures'] = 'Saate sisselogimistõrgetest teavitavad sõnumid saata nendele valitud kasutajatele. Selleks peab olema lubatud sisemine logisalv (nt tavalogisalv).';
$string['confignotifyloginthreshold'] = 'Kui sisselogimise nurjumise teated on aktiveeritud, siis kui palju sisselogimiskatseid peaks ühelt kasutajalt või IP-aadressilt tulema, enne kui teade saadetakse?';
$string['confignotloggedinroleid'] = 'Õpikeskkonda sisselogimata kasutajaid koheldakse nii, nagu oleks neil see roll õpikeskkonna kontekstis. Üldjuhul on külalise roll siin kõige otstarbekam, aga võimalik, et soovite luua lisarolle, millel on rohkem või vähem õigusi. Teatud toimingute puhul (nt postituste loomine) on endiselt vaja kasutaja sisselogimist.';
$string['configopentowebcrawlers'] = 'Selle seadistuse sisse lülitamisel lubatakse Google\'il õpikeskkonda külalisena siseneda. Lisaks kõik Google otsingu kaudu õpikeskkonnani jõudnud inimesed logitakse automaatselt sisse külalistena. See pakub vaid nähtamatut ligipääsu kursustele, kus külaliste juurdepääs on juba lubatud.';
$string['configoverride'] = 'Määratletud failis config.php';
$string['configpasswordpolicy'] = 'Selle sätte lubamisel hakkab Moodle kasutajate paroole võrdlema kehtivate paroolipõhimõtetega. Allolevate sätete kaudu saate määrata paroolipõhimõtted (kui selle sätte väärtus on Ei, siis paroolipõhimõtteid eiratakse)';
$string['configpasswordpolicycheckonlogin'] = 'Kui see on lubatud, kontrollitakse kasutajate paroole iga kord, kui kasutajad sisse logivad, paroolipoliitikaga. Kui kontroll ebaõnnestub, peab kasutaja enne jätkamist oma parooli muutma.
Pärast paroolipoliitika värskendamist on kasulik see nii seadistada.';
$string['configpasswordresettime'] = 'Sellega sättega määratakse aeg, mille jooksul tuleb paroolilähtestustaotlus enne aegumist valideerida. Harilikult on 30 min piisav aeg.';
$string['configpathtodu'] = 'du failitee. Tõenäoliselt /usr/bin/du. Kui selle sisestate, siis failirohkete kaustade korral töötavad kaustade sisu kuvavad lehed palju kiiremini.';
$string['configpathtophp'] = 'Tee PHP CLI-le. Ilmselt midagi sellist nagu / usr / bin / php. Selle sisestamisel saab croni skripte käivitada administraatori veebiliideselt.';
$string['configperfdebug'] = 'Kui see säte on sisse lülitatud, siis kuvatakse jaluses jõudlusteave';
$string['configprofileroles'] = 'Rolliloend, mis kuvatakse kasutajaprofiilis ja osalejate lehel.';
$string['configprofilesforenrolledusersonly'] = 'Rämpspostitajate eest kaitsmiseks on nende kasutajate profiilikirjeldused peidetud, kes pole ühelegi kursusele registreerunud. Uued kasutajad peavad registreeruma vähemalt ühele kursusele, et nad saaksid muuta oma profiilikirjeldust.';
$string['configprotectusernames'] = 'Vaikimisi ei kuva forget_password.php mingeid vihjeid, mis võiks hõlbustada kasutajatunnuste või meiliaadresside äraarvamist.';
$string['configproxybypass'] = 'Selliste teatud (osaliste) hostinimede või IP-aadresside komaeraldusega loend, mille liiklus peab puhverserverist mööda minema (nt 192.168., .minudomeen.ee)';
$string['configproxyhost'] = 'Kui sellel <b>serveril</b> on Interneti-pääsuks vaja kasutada puhverarvutit (nt tulemüüri), sisestage siia puhvri hostinimi. Muul juhul jätke see väli tühjaks.';
$string['configproxypassword'] = 'Parooli on vaja puhverserveri kaudu Internetile juurdepääsuks. Kui parooli pole, jätke see väli tühjaks (PHP cURL laiendus on vajalik).';
$string['configproxyport'] = 'Kui see server vajab puhverserverit, siis määrake siin puhverserveri port.';
$string['configproxytype'] = 'Veebipuhverserveri tüüp (SOCKS5 toe jaoks on vaja PHP5 ja cURL-i laiendust).';
$string['configproxyuser'] = 'Kasutajanime on vaja puhverserveri kaudu Internetile juurdepääsuks. Jätke see väli tühjaks, kui puudub (vajalik on laiendus PHP cURL).';
$string['configrecaptchaprivatekey'] = 'Märgistring (privaatvõti), mida kasutatakse Moodle’i serveri ja reCAPTCHA-serveri vahelises sides. ReCAPTCHA võtmeid saab hankida lehelt <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Märgistring (privaatvõti), mis kasutatakse reCAPTCHA-elemendi kuvamiseks registreerumisvormil. ReCAPTCHA võtmeid saab hankida lehelt <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestedstudentname'] = 'Õpilase nimetus tellitud kursusel';
$string['configrequestedstudentsname'] = 'Õpilaste nimetus tellitud kursusel';
$string['configrequestedteachername'] = 'Õpetaja nimetus tellitud kursusel';
$string['configrequestedteachersname'] = 'Õpetaja nimetus tellitud kursusel';
$string['configreverseproxyignore'] = 'Kui sinu server on mitme vastupidise puhverserveri taga, mis lisatakse päisele X-Forwarded-For, määra kasutaja õige IP-aadressi leidmiseks komadega eraldatud IP-aadresside või vastupidiste puhverserverite alamvõrkude loend, mida ignoreeritakse.';
$string['configsectioninterface'] = 'Kasutajaliides';
$string['configsectionmail'] = 'Mail';
$string['configsectionmaintenance'] = 'Andmete säilitamine';
$string['configsectionmisc'] = 'Varia';
$string['configsectionoperatingsystem'] = 'Operatsioonisüsteem';
$string['configsectionpermissions'] = 'Õigused';
$string['configsectionrequestedcourse'] = 'Kursuste taotlused';
$string['configsectionsecurity'] = 'Turvalisus';
$string['configsectionstats'] = 'Statistika';
$string['configsectionuser'] = 'Kasutajad';
$string['configsecureforms'] = 'Moodle saab kasutada lisaturvatasandit veebivormidelt andmete vastuvõtmisel. Kui see on lubatud, siis kontrollitakse, et brauseri HTTP_REFERER muutuja ühtib antud vormi aadressiga. Mõnel üksikul juhul võib see põhjustada probleeme, kui kasutaja kasutab tulemüüri (näiteks Zonealarm), mis on konfigureeritud HTTP_REFERER muutuja oma võrguliiklusest maha võtma.  Sümptomiteks on vormi "kinni kiilumine". Kui sinu kasutajatel on selliseid probleeme (näiteks) sisselogimise lehel, siis võid sa tahta seda seadistust ilmselt keelata, ehkki see võib jätta sinu õpikeskkonna kaitsetuks jõurünnetele (brute-force attacks). Kui kahtled, jäta siia seadeks "Jah".';
$string['configsessioncookie'] = 'Selle sättega saab kohandada Moodle’i seansside küpsisefaili nime. Valikuline ja mõttekas üksnes siis, kui ühel veebilehel töötab mitu Moodle’i eksemplari ja küpsisefailid võivad segamini minna.';
$string['configsessioncookiedomain'] = 'See võimaldab muuta domeeni, kust Moodle’i küpsisefailid pärinevad. See on vajalik Moodle’i kohandamiseks (nt autentimise või registreerimise lisandmoodulid), mille puhul on vaja Moodle’i seansside teabe jagamist muudes alamdomeenides asuvate veebirakendustega. <strong>HOIATUS. Soovitame tungivalt jätta vaikseväärtuse (tühi) – vale väärtus keelab kõik saidile sisselogimised.</strong>';
$string['configsessioncookiepath'] = 'Kui teil on vaja määrata, kuhu brauser Moodle’i küpsisefailid saadab, saate selle sättega määrata oma veebisaidi alamkataloogi. Muul juhul peaks vaikimisi \'/\' sobima.';
$string['configsessiontimeout'] = 'Kui õpikeskkonda sisse loginud inimesed on pikemat aega passiivsed (lehti ei laadi), siis nad logitakse automaatselt välja (nende seanss lõpetatakse). Selle muutujaga saab määrata, kui pikk peaks passiivsusaeg olema.';
$string['configshowcommentscount'] = 'Kuva kommentaaride arv – kommentaaride lingi kuvamisel tehakse üks või mitu andmebaasipäringut.';
$string['configshowicalsource'] = 'Kuva iCal sündmuste lähteteave';
$string['configshowsiteparticipantslist'] = 'Kõik õpikeskkonna õppijad ja õpetajad kuvatakse õpikeskkonnas osalejate listis. Kellel on õigust näha seda osalejate listi?';
$string['configsitedefaultlicense'] = 'Õpikeskkonna vaikelitsents';
$string['configsitedefaultlicensehelp'] = 'Õpikeskkonnas sisu avaldamise vaikelitsents';
$string['configsitemailcharset'] = 'Kõik saidi poolt genereeritud e-mailid saadetakse selle märgistikuga (charset). Iga üksikkasutaja saab ise kohandada, kui järgnev seadistus on sisse lülitatud.';
$string['configsitemaxcategorydepth'] = 'Kategooria maksimumsügavus';
$string['configsitemaxcategorydepthhelp'] = 'Selle sättega määratakse kategooriate või liitloendi kuvamisel laiendatud alamkategooriate maksimumsügavus. Sügavamad kategooriad kuvatakse linkide kujul ja kasutajad saavad neid AJAX-päringute kaudu avada (laiendada).';
$string['configslasharguments'] = 'SCORM-pakettide ja mitut faili sisaldavate Vahendite õigeks kuvamiseks on vaja meetodit „slash arguments“ (<em>PATH_INFO</em> abil) Kui teie veebiserver ei toeta meetodit \'slash arguments\' (kaldkriipsargumendid) ja te ei saa seda konfigureerida, saab selle sätte keelata, kuigi keelamine tekitab toimivusprobleeme. Märkus. Moodle’i tulevastes versioonides on vaja kasutada \'slash arguments\'';
$string['configsmtpauthtype'] = 'Määrab STMP-serveris kasutatava autentimistüübi.';
$string['configsmtphosts'] = 'Anna ühe või mitme kohaliku SMTP serveri täielik nimi, mida Moodle peaks kasutama, et saata e-kirju (näit. \'mail.a.com\' või \'mail.a.com;mail.b.com\'). Kui jätad selle lahtri tühjaks, kasutab Moodle PHP vaikeseadet e-kirjade saatmiseks.';
$string['configsmtpmaxbulk'] = 'Maksimaalselt sõnumeid SMTP seansi kohta. Sõnumite grupeerimine üldiselt suurendab e-mailide saatmise kiirust. Väiksemad väärtused kui 2 sunnivad looma iga e-maili kohta uue SMTP seansi.';
$string['configsmtpsecure'] = 'Kui SMTP-server nõuab turvalist ühendust, määrake sobiva protokolli tüüp.';
$string['configsmtpuser'] = 'Kui oled täpsustanud ülalnimetatud SMPT serveri ja server nõuab autentimist, siis sisesta siia kasutajanimi ja parool.';
$string['configstartwday'] = 'Nädala algus';
$string['configstatsfirstrun'] = 'Sellega määratakse, kui kaugele ajas tagasi cronjobi <b>esmakordsel</b> statistikatöötlemisel minnakse. Kui saidil on palju liiklust ja see kasutab jagatud majutust, siis pole tõenäoliselt hea mõte minna ajas liialt kaugele, sest see võib võtta kaua aega ja olla üpris ressursimahukas. (Arvestage, et selle sätte korral 1 kuu = 28 päeva.) Graafikutel ja genereeritud aruannetele 1 kuu = 1 kalendrikuu.)';
$string['configstatsmaxruntime'] = 'Statistika töötlemine võib olla üsna mahukas, nii et kasutage selle välja ja järgmise kombinatsiooni, et täpsustada, millal see töötab ja kui kaua.';
$string['configstatsmaxruntime2'] = 'Statistika töötlemine võib olla üsna ressursimahukas tegevus. Seadista maksimaalne aeg, mis võib kuluda ühe päeva jagu statistika töötlemiseks. Ühe korraga on cron\'ga lubatud töödelda kuni 31 päeva jagu statistikat.';
$string['configstatsmaxruntime3'] = 'Sellega määratakse maksimumaeg, mis on lubatud ühe päeva statistika korraga genereerimiseks, arvestades, et statistika genereerimine koormab suuresti serverit. Ühes cronis töödeldavate päevade piirarvu saab määrata allpool.';
$string['configstatsruntimedays'] = 'Selle sättega määratakse maksimaalne päevade arv, mida iga statistika kogumise ajal töödeldakse. Kui statistika on ajakohane, siis töödeldakse korraga vaid ühe päeva andmed – seega määrake see väärtus vastavalt oma serveri jõudlusele ja vajaduse korral vähendage seda, kui croni käivitusaeg peaks olema lühem.';
$string['configstatsruntimestart'] = 'Mis kell peab statistikat genereeriv cronjob käivituma? Määrake erinevad ajad, kui ühes serveris töötab mitu Moodle’\\i keskkonda.';
$string['configstatsuserthreshold'] = 'Selle sättega määratakse kursuste jaoks minimaalne kasutajate arv, mida arvestatakse statistika genereerimisel.';
$string['configstrictformsrequired'] = 'Kui see säte on lubatud, siis kasutajad ei saa vormide kohustuslikele väljadele sisestada tühikuid või reavahetusi.';
$string['configstripalltitletags'] = 'Kui soovite, et Tegevuse- ja Vahendinimedes oleks lubatud HTML-sildid, siis tühjendage see ruut.';
$string['configsupportemail'] = 'See meiliaadress kuvatakse saidi kasutajatele ja see on mõeldud üldise abi saamiseks (nt kui uued kasutajad jäävad kontode loomisel hätta). Kui see väli tühjaks jätta, siis seda meiliaadressi ei kuvata.';
$string['configsupportname'] = 'Selle isiku või asutuse nimi, kes osutab tugiteenust meili teel või vastava veebilehe kaudu.';
$string['configsupportpage'] = 'See veebiaadress kuvatakse saidi kasutajatele ja on mõeldud üldise abi saamiseks (nt kui uued kasutajad jäävad kontode loomisel hätta). Kui see väli tühjaks jätta, siis seda veebiaadressi ei kuvata.';
$string['configtempdatafoldercleanup'] = 'Eemaldage andmete kaustast ajutised andmefailid, mis on valitud ajast vanemad.';
$string['configthemedesignermode'] = 'Tavaliselt puhverdatakse kõik kujundused ja laadilehed jõudluse parandamiseks pikaks ajaks brauserite ja serverite vahemällu. Kui loote uut kujundust või programmeerite koodi, siis tasuks see välja lülitada, et keskkond ei kuvataks puhverdatud kujul. Hoiatus. See teeb lehe kõigi kasutajate jaoks aeglasemaks. Kujunduse valiku lehel saab vahemälu tühjendamise ka käsitsi aktiveerida.';
$string['configthemelist'] = 'Kui soovite, et kasutada saaks kõiki kujundusi, jätke see väli tühjaks.  Kui soovite, et kujundusemenüü oleks lühike, saate siin määrata kujunduste komaeraldusega loendi (ärge kasutage tühikuid).
Näide: standard,orangewhite.';
$string['configtimezone'] = 'See on kuupäevade kuvamise vaikeajavöönd – iga kasutaja saab selle väärtuse oma profiilis üle kirjutada. Croni toimingud ja serveri sätted määratakse selles ajavööndis. Kui kuvatakse tekst „Sobimatu ajavöönd“, peaksite seda väärtust muutma.';
$string['configuseblogassociations'] = 'Kas kasutajad peaksid saama oma blogisissekanded siduda kursuste ja kursusemoodulitega?';
$string['configusesitenameforsitepages'] = 'Kui see säte on lubatud, kasutatakse õpikeskkonna lehtede sõlme jaoks navigeerimispaanil õpikeskkonna lühinime, mitte stringi „Õpikeskkonna lehed“.';
$string['configusetags'] = 'Kas siltidega seotud funktsioonid peaks olema lubatud kogu keskkonnas?';
$string['configvariables'] = 'Konfigureeri muutujad';
$string['configverifychangedemail'] = 'Saate lubada kasutajate meiliaadressi kinnituse vastavalt lubatud või keelatud meilidomeenide sätetele. Kui see säte on keelatud, siis kontrollitakse domeene ainult uute kasutajate loomisel.';
$string['configvisiblecourses'] = 'Näita kursuseid peidetud kategooriates';
$string['configwarning'] = 'Olge nende sätete muutmisel ettevaatlik – valed väärtused võivad tekitada probleeme.';
$string['configyuicomboloading'] = 'See valik võimaldab kombineeritud moel failide laadimise optimeerimist YUI teekidega. See säte peaks valmistussaitidel olema jõudluse tagamiseks lubatud.';
$string['confirmation'] = 'Kinnitus';
$string['confirmcontextlock'] = '{$a-> contextname} on praegu külmutamata. Selle külmutamine muudab selle kirjutuskaitstuks ja takistab kasutajatel muudatusi tegemast. Kas soovid kindlasti jätkata?';
$string['confirmcontextunlock'] = '{$a-> contextname} on praegu külmutatud. Selle avamine võimaldab kasutajatel muudatusi teha. Kas soovid kindlasti jätkata?';
$string['confirmdeletecomments'] = 'Kas soovite kommentaarid kindlasti kustutada?';
$string['confirmed'] = 'Kinnitatud';
$string['contactsitesupport'] = 'Võta kasutajatoega ühendust';
$string['contenttypeuninstalling'] = 'Seal on {$a-> count} sisu, mida toetab {$a-> type}. Need kustutatakse. Kas soovid kindlasti jätkata?';
$string['contextlockappliestoadmin'] = 'Konteksti külmutamine kehtib administraatoritele';
$string['contextlockappliestoadmin_desc'] = 'Kui see on keealtud, jääb administraatoritele ligipääs külmutatud kontekstile.';
$string['contextlocking'] = 'Konteksti külmutamine';
$string['contextlocking_desc'] = 'See seade võimaldab valitud kategooriatele, kursustele, tegevustele või plokkidele seada kirjutuskaitstud juurdepääsu.';
$string['cookiesecure'] = 'Ainult turvalised küpsisefailid';
$string['country'] = 'Vaikeriik';
$string['course_customfield'] = 'Kursuse kohandatud väljad';
$string['coursecolor'] = 'Värv {$a}';
$string['coursecolorheading_desc'] = 'Kõik kursused, millel pole kursuse sätetes seatud kursuse pilti, kuvatakse armatuurlaual mustrilise kursusekaardiga. Mustris kasutatavaid värve võib täpsustada allpool.';
$string['coursecolorsettings'] = 'Kursuse kaartide värvid';
$string['coursecontact'] = 'Kursuse haldajad';
$string['coursecontact_desc'] = 'Selle sättega saab määrata, kes kuvatakse kursuse kirjelduses. Et kasutaja nimi kuvataks vastava kursuse kirjelduses, peab sel kasutajal olema vähemalt üks neist rollidest.';
$string['coursecontactduplicates'] = 'Kuva kõik kursuse kontaktrollid';
$string['coursecontactduplicates_desc'] = 'Kui see on lubatud, kuvatakse kursuse kirjelduses koos kõigi nende rollidega kasutajad, kellel on rohkem kui üks valitud kursuse kontaktroll. Vastasel juhul kuvatakse neid ainult ühe rolliga (olenevalt sellest, kumb on saidi administreerimise jaotises „Määra rollid” kõrgeim).';
$string['coursegraceperiodafter'] = 'Ajapikendus möödunud kursuste jaoks';
$string['coursegraceperiodbefore'] = 'Ajapikendus tuleviku kursuste jaoks';
$string['courselistshortnames'] = 'Kuva laiendatud kursuse nimed';
$string['courselistshortnames_desc'] = 'Kui see säte on lubatud, kuvatakse kursuste loendis lisaks kursuste täisnimedele ka nende lühinimed. Vajaduse korral saab laiendatud kursuse nimesid kohandada, muutes keelestringi „courseextendednamedisplay“ keelesätete kohandamise funktsiooni abil.';
$string['coursemgmt'] = 'Halda kursusi ja kategooriaid';
$string['courseoverview'] = 'Kursuse ülevaade';
$string['courserequestnotify'] = 'Kursuse taotlemise teavitus';
$string['courserequestnotifyemail'] = 'Kasutaja {$a->user} taotles uut kursust ({$a->link})';
$string['courserequests'] = 'Kursustetaotlused';
$string['courserequestspending'] = 'Kursuse taotlus on ootel';
$string['courses'] = 'Kursused';
$string['coursesperpage'] = 'Kursusi lehel';
$string['courseswithsummarieslimit'] = 'Kursused koos lühikokkuvõttega';
$string['creatornewroleid'] = 'Loojate roll uutes kursustes';
$string['creatornewroleid_help'] = 'Kui kasutajal pole veel uue kursuse haldamise õigust, registreeritakse kasutaja kursusele automaatselt sellesse rolli.';
$string['cron'] = 'Cron';
$string['cron_enabled'] = 'Luba cron';
$string['cron_enabled_desc'] = 'Kui see on keelatud, ei lasta süsteemil uusi taustaülesandeid alustada. See valik on mõeldud ainult ajutiseks kasutamiseks, nt. enne taaskäivitamist. Pikka aega väljalülitamine hoiab ära olulise funktsionaalsuse töötamise.';
$string['cron_help'] = 'Skript cron.php käitab eri intervallidega mitmeid toiminguid, näiteks foorumipostituste kohta meiliteatiste saatmist. Skript tuleks käivitada regulaarselt: ideaaljuhul kord minutis.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Croni käivitamine ainult käsurealt';
$string['cronerrorclionly'] = 'Kahjuks on administraator keelanud juurdepääsu sellele veebilehele.';
$string['cronerrorpassword'] = 'Vabandust, kuid sa ei sisestanud sellele veebilehele ligipääsemiseks õiget parooli';
$string['croninfrequent'] = 'Croni hooldusskripti kahe viimase käigu vahel oli {$a->actual} ja see peaks käima iga {$a->expected}. Soovitame konfigureerida selle sagedamaks käitamiseks.';
$string['cronremotepassword'] = 'Cron parool kaugligipääsuks';
$string['cronwarning'] = 'Skripti <a href="{$a->url} "> skripti admin / cron.php </a> pole {$a->actual} käitatud ja see peaks käima iga {$a->expected}.';
$string['cronwarningcli'] = 'Skripti <code> admin / cli / cron.php </code> pole {$a->actual} käitatud ja see peaks käima iga {$a->expected} tagant.';
$string['cronwarningnever'] = 'Skripti <code> admin / cli / cron.php </code> pole kunagi käitatud ja see peaks käima iga {$a->expected} tagant.';
$string['cronwarningneverweb'] = 'Skripti<a href="{$a->url} ">admin / cron.php</a>pole kunagi käivitatud ja see peaks käima iga {$a->expected}.';
$string['ctyperequired'] = 'Laiendus ctype PHP on Moodle’is vajalik selleks keskkonna jõudluse parandamiseks ja mitmekeelsusfunktsioonide pakkumiseks.';
$string['curlcache'] = 'cURL-i vahemälu keshtivusaeg';
$string['curlrequired'] = 'Laiendus cURL PHP on Moodle’is vajalik Moodle’i muude hoidlatega suhtlemiseks.';
$string['curlsecurityallowedport'] = 'cURL-i lubatud portide loend';
$string['curlsecurityallowedportsyntax'] = 'Loend, mis sisaldab nende portide numbreid, millega cURL saab luua ühenduse. Lubatud on ainult täisarvud. Sisestage iga sissekanne uuele reale. Kui jätate loendi tühjaks, siis on lubatud kõik pordid. Kui loendisse sissekandeid lisate, peate peaaegu alati määrama pordid 443 ja 80, et cURL looks ühenduse HTTPS-i ja HTTP-i standardportidega.';
$string['curlsecurityblockedhosts'] = 'cURL-i blokeeritud hostide loend';
$string['curlsecurityblockedhostssyntax'] = 'Sisestage iga sissekanne uuele reale. Sobivad sissekanded on kas täielikud IPv4- või IPv6-aadressid (nt 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::), mis vastavad ühele hostile, CIDR-esitused (nt 231.54.211.0/20 või fe80::/64), IP-aadresside vahemik (nt 231.3.56.10-20 või fe80::1111-bbbb), milles vahemik rakendub aadressi viimasele rühmale, domeeninimed (nt localhost või example.com) või metamärkidega domeeninimed (nt *.example.com või *.sub.example.com). Tühjad read pole lubatud.';
$string['curlsecurityurlblocked'] = 'URL on blokeeritud.';
$string['curltimeoutkbitrate'] = 'Bitisagedus, mida kasutada cURL-i ajalõpu arvutamisel (kbit/s)';
$string['curltimeoutkbitrate_help'] = 'Seda sätet kasutatakse suurte cURL-päringute aegumise arvutamiseks. Sisu mahu määratlemiseks tehakse selle arvutuse käigus HTTP HEAD-päring. Kui selle sätte väärtus on 0, siis selle päringu tegemine keelatakse.';
$string['currenttheme'] = 'Praegune kujundus';
$string['customcheck'] = 'Muud kontrollid';
$string['custommenu'] = 'Kohandatav menüü';
$string['custommenuitems'] = 'Kohandatava menüü elemendid';
$string['customusermenuitems'] = 'Kasutajamenüü käsud';
$string['datarootsecurityerror'] = '<p><strong>TURBEHOIATUS!</strong></p><p>Andmete juurkataloog on vales asukohas ja veebis saadaval. See tähendab, et kõik privaatfailid on kõigile kättesaadavad ja mõnda neist võib kasutada pahatahtlik häkker teie saidile juurdepääsuks.</p>
<p><em>Peate</em> andmete juurkataloogi ({$a}) teisaldama uude asukohta, mis poleks avalikus veebikataloogis, ja värskendama failis config.php sätet <code>$CFG->dataroot</code>.</p>';
$string['datarootsecuritywarning'] = 'Teie õpikeskkonna konfiguratsioon ei pruugi olla turvaline. Andmete juurkataloog ({$a}) ei tohi olla kataloogis, millele pääseb veebist juurde.';
$string['dbsessions'] = 'Kasuta seansiteabe hoidmiseks andmebaasi';
$string['debug'] = 'Silumisteated';
$string['debugall'] = 'KÕIK: Kuva kõik põhjendatud PHP silumisteated';
$string['debugdeveloper'] = 'ARENDAJA: Moodle’i täiendavad silumisteated arendajatele';
$string['debugdisplay'] = 'Kuva silumisteated';
$string['debugging'] = 'Silumine';
$string['debugminimal'] = 'MINIMAALNE: Kuva üksnes pöördumatud tõrked';
$string['debugnone'] = 'POLE: Ära tõrkeid ega hoiatusi kuva';
$string['debugnormal'] = 'TAVALINE: Kuva tõrked, hoiatused ja märguanded';
$string['debugpageinfo'] = 'Kuva lehe teave';
$string['debugsqltrace'] = 'Kuva SQL-kõnede päritolu';
$string['debugsqltrace1'] = 'Kuva ainult üks helistamisliin';
$string['debugsqltrace100'] = 'Kuva kogu virna jälg';
$string['debugsqltrace2'] = 'Kuva kogu pinu jälg';
$string['debugsqltrace_desc'] = 'Kui see on lubatud, lisatakse SQL-i kommentaarina osaline või täielik PHP-i pinu jälg.';
$string['debugstringids'] = 'Kuva keelestringide allikas';
$string['debugstringids_desc'] = 'Kui see on lubatud, kuvatakse keelestringi komponendid ja identifikaatorid, kui lehe URLle on lisatud Stringid = 1 või & stringid = 1..';
$string['debugvalidators'] = 'Kuva validaatori lingid';
$string['defaultcity'] = 'Vaikelinn';
$string['defaultcity_help'] = 'Sisestatud linnanime kasutatakse vaikimisi uute kasutajakontode loomisel.';
$string['defaultformatnotset'] = 'Tõrge kursuse vaikevormingu tuvastamisel. Kontrollige saidi sätteid.';
$string['defaulthomepage'] = 'Koduleht kasutajatele';
$string['defaultrequestcategory'] = 'Kursusetaotluste vaikekategooria';
$string['defaultsettinginfo'] = 'Vaikimisi: {$a}';
$string['defaultuserroleid'] = 'Kõigi kasutajate vaikeroll';
$string['deleteincompleteusers'] = 'Kustuta mittetäielikult registreerunud kasutajad pärast';
$string['deleteunconfirmed'] = 'Kustuta täielikult seadistamata kasutajad pärast';
$string['deleteuser'] = 'Kustuta kasutaja';
$string['density'] = 'Tihedus';
$string['denyemailaddresses'] = 'Keelatud meilidomeenid';
$string['development'] = 'Arendus';
$string['devicetype'] = 'Seadme tüüp';
$string['devlibdirpresent'] = 'Arendusteekidega kataloogid, eriti <em> vendor</em> ja <em> /node_modules</em>, ei tohiks avalikel saitidel olla. Lisateabe saamiseks vaadta <a href="{$a->moreinfourl}"> turvaülevaate aruannet</a>.';
$string['disabled'] = 'Keelatud';
$string['disableuserimages'] = 'Keela kasutajate profiilipildid';
$string['displayerrorswarning'] = 'PHP sätte <em>display_errors</em> lubamine pole valmistussaitidel soovitatav, sest tõrketeadetes võidakse teie serveri kohta kuvada tundlikku teavet.';
$string['displayloginfailures'] = 'Kuva sisselogimistõrked';
$string['divertallemails'] = 'E-posti suunamine';
$string['divertallemailsdetail'] = 'Kasutatakse e-kirjade testimisel kaitsekeskkonnana arengukeskkondades ja seda ei tohiks kasutada tootmises.';
$string['divertallemailsexcept'] = 'E-posti ümbersuunamise erandid';
$string['divertallemailsexcept_desc'] = 'Koma või uute ridadega eraldatud e-posti erandireeglite loend. Iga reeglit tõlgendatakse regulaaravaldisena, nt<pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Suuna kõik meilid';
$string['divertallemailsto_desc'] = 'Kui see on määratud, suunatakse kõik meilid hoopis sellele ühele e-posti aadressile.';
$string['dndallowtextandlinks'] = 'Teksti/linkide üleslaadimine lohistamise teel';
$string['doclang'] = 'Dokumentide keel';
$string['docroot'] = 'Moodle Docsi dokumentide juurasukoht';
$string['doctonewwindow'] = 'Ava uues aknas';
$string['doesnotfit'] = 'Meilisõnumi kuvamissätted';
$string['doesnotfitdetail'] = 'Moodle’ist väljuvate meilisõnumite kuvamissätted';
$string['download'] = 'Laadi alla';
$string['downloadcoursecontentallowed'] = 'Kursuse sisu allalaadimise funktsioon on saadaval';
$string['downloadcoursecontentallowed_desc'] = 'Kas kursuse sisu allalaadimise funktsioon on kursustele saadaval. Kui see on saadaval, saab kursuse sisu allalaadimist lubada / keelata, kasutades kursuse redigeerimise menüü sätet "Luba kursuse sisu allalaadimine" (selle vaikeväärtuse saab määrata jaotises <a href={$a} target="_blank"> Kursuse vaikeseaded</a>).';
$string['durationunits'] = 'kestuse ühikud';
$string['edithelpdocs'] = 'Muuda abidokumente';
$string['editlang'] = '<b>Redigeeri</b>';
$string['editorbackgroundcolor'] = 'Taustavärv';
$string['editordictionary'] = 'Redaktori sõnastik';
$string['editorfontfamily'] = 'Fondipere';
$string['editorfontlist'] = 'Fondiloend';
$string['editorfontsize'] = 'Fondi suurus';
$string['editorhidebuttons'] = 'Peidetud nupud';
$string['editorkillword'] = 'Wordi vormingufilter';
$string['editorspelling'] = 'Redaktori õigekirjakontroll';
$string['editorspellinghelp'] = 'Luba või keela õigekirjakontrolli. Kui lubatud, peab serveris olema paigaldatud <strong>aspell</strong>.';
$string['editstrings'] = 'Muuda sõnu või fraase';
$string['emailchangeconfirmation'] = 'Meiliaadressi muutmise kinnitus';
$string['emaildkim'] = 'DKIM emaili allkirjastamine';
$string['emaildkimselector'] = 'DKIM valija';
$string['emailfromvia'] = 'Teave selle kohta, millise teenuse kaudu meilisõnum saadeti.';
$string['emailheaders'] = 'E-posti päised';
$string['emailsubjectprefix'] = 'E-kirja teema prefiksi tekst';
$string['emoticonalt'] = 'Alternatiivtekst';
$string['emoticoncomponent'] = 'Pildi komponent';
$string['emoticonimagename'] = 'Pildi nimi';
$string['emoticons'] = 'Emotikonid';
$string['emoticons_desc'] = 'See vorm määratleb teie saidil kasutatavad emotikonid. Tabelist rea eemaldamiseks salvestage vorm nii, et soovitud väljad on tühjad. Uue emotikoni registreerimiseks täitke viimase tühja rea väljad. Kõigi väljade vaikeväärtuste lähtestamiseks klõpsake ülalolevate linki.

* Tekst (nõutav) – See tekst asendatakse emotikoni pildiga. Peab olema vähemalt kaks märki pikk.
* Pildi nimi (nõutav) – Emotikoni pildi failinimi ilma laiendita, relatiivne komponendi pix kaustaga.
* Pildi komponent (nõutav) – Komponent, kust ikoon pärit on.
* Alternatiivne tekst (valikuline) – Stringi identifikaator ja emotikoni alternatiivse teksti komponent.';
$string['emoticonsreset'] = 'Lähtesta emotikonide säte vaikeväärtusele';
$string['emoticontext'] = 'Tekst';
$string['emptysettingvalue'] = 'Tühi';
$string['enableanalytics'] = 'Analüütika';
$string['enableblogs'] = 'Luba blogid';
$string['enablecalendarexport'] = 'Luba kalendri eksport';
$string['enablecomments'] = 'Luba kommentaarid';
$string['enablecourserelativedates'] = 'Luba kursuse suhtelised kuupäevad';
$string['enablecourserelativedates_desc'] = 'Luba kursustel seadistada kuupäevade kuvamine vastavalt kursuse kasutaja alguskuupäevale.';
$string['enablecourserequests'] = 'Luba kursusetaotlused';
$string['enabled'] = 'Lubatud';
$string['enableglobalsearch'] = 'Luba üldotsing';
$string['enableglobalsearch_desc'] = 'Kui see on lubatud, indekseerib ja sünkroonib ajastatud toiming andmed.';
$string['enablegravatar'] = 'Luba Gravatar';
$string['enablegravatar_help'] = 'Kui see säte on lubatud, üritab Moodle tuua Gravatarist kasutaja profiilipildi, kui kasutaja pole pilti üles laadinud.';
$string['enablemobilewebservice'] = 'Luba mobiilseadmete jaoks veebiteenused';
$string['enablerecordcache'] = 'Võimalda vahemällu salvetamine';
$string['enablerssfeeds'] = 'Luba RSS-kanalid';
$string['enablesearchareas'] = 'Luba otsingu valdkonnad';
$string['enablestats'] = 'Luba statistika';
$string['enabletrusttext'] = 'Luba usaldusväärne sisu';
$string['enableuserfeedback'] = 'Luba tagasiside andmine selle tarkvara kohta';
$string['enableuserfeedback_desc'] = 'Kui see on sisse lülitatud, kuvatakse jaluses kasutajatele link „Anna selle tarkvara kohta tagasisidet“, ning nad saavad Moodle\'i kohta Moodle\'i peakorterile tagasisidet anda. Kui on seatud  "Järgmine tagasiside meeldetuletus", kuvatakse kasutajale määratud intervalliga armatuurlaual ka meeldetuletus. Seadistades valiku „Järgmine tagasiside meeldetuletus” väärtuseks „Mitte kunagi”, keelatakse armatuurlaua meeldetuletus, jättes samal ajal jalusesse lingi „Anna selle tarkvara kohta tagasisidet”.';
$string['enablewebservices'] = 'Luba veebiteenused';
$string['enablewsdocumentation'] = 'Veebiteenuste dokumentatsioon';
$string['enrolinstancedefaults'] = 'Registreerumise vaikesätted';
$string['enrolinstancedefaults_desc'] = 'Uute kursuste vaikimisi registreerumise sätted.';
$string['enrolmultipleusers'] = 'Registreeri kasutajad';
$string['environment'] = 'Keskkond';
$string['environmenterrortodo'] = 'Enneselle Moodle’i versiooni installimise jätkamist peate lahendama kõik ülalolevad keskkonnaprobleemid (tõrked).';
$string['environmenterrorupgrade'] = 'Hoiatus: enne selle Moodle\'i versioonuuendust peaksite lahendama kõik ülaltoodud keskkonnaprobleemid (vead)! Uuendamine ilma neid nõudeid fikseerimata võib põhjustada selliseid probleeme nagu andmete kadu. Kas soovite kindlasti uuendamist jätkata?';
$string['environmentmariadbwrongdbtype'] = 'Vale <code>$CFG->dbtype</code>: pead selle muutma <code>config.php</code> file, sellest \'<code>mysql</code>\' selleks \'<code>mariadb</code>\'.';
$string['environmentmustfixsetting'] = 'Peate muutma PHP sätet.';
$string['environmentok'] = 'Teie server vastab kõigile miinimumnõuetele.';
$string['environmentrecommendcustomcheck'] = 'testi nurjumine viitab võimalikule probleemile';
$string['environmentrecommendinstall'] = 'on soovitatav, et oleks installitud ja lubatud';
$string['environmentrecommendversion'] = 'soovitatav on versioon {$a->needed}, teil töötab versioon {$a->current}';
$string['environmentrequirecustomcheck'] = 'see test peab olema edukalt läbitud';
$string['environmentrequireinstall'] = 'peab olema installitud ja lubatud';
$string['environmentrequireversion'] = 'nõutav on versioon {$a->needed}, teil töötab versioon {$a->current}';
$string['environmentsettingok'] = 'soovituslik säte on olemas';
$string['environmentshouldfixsetting'] = 'Peate muutma PHP sätet.';
$string['environmentxmlerror'] = 'Tõrge keskkonnaandmete lugemisel ({$a->error_code})';
$string['errordeletingconfig'] = 'Lisandmooduli \'{$a}\' sätete kustutamisel ilmnes tõrge.';
$string['errorsetting'] = 'Ei saa salvestada sätet:';
$string['errorwithsettings'] = 'Tõrke tõttu jäi mõni säte muutmata.';
$string['eventshandlersinuse'] = 'Järgmised teie süsteemi lisandmoodulid kasutavad aegunud Events 1 API ohjureid: \'{$a}\'. Värskendage neid kasutama Events 2 API-t. Vt https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Igaüks, kes saab \'{$a}\\';
$string['exceptions'] = 'erandid';
$string['execpathnotallowed'] = 'Täitmisteede ja kohalike teede määramine on failis „config.php“ keelatud';
$string['experimental'] = 'Katsetamisel';
$string['experimentalsettings'] = 'Katsetatavad sätted';
$string['extendedusernamechars'] = 'Luba laiendatud tähemärke kasutajanimedes';
$string['extramemorylimit'] = 'Täiendav PHP mälulimiit';
$string['fatalsessionautostart'] = '<p>Esines tõsine konfiguratsiooni viga, palun teavitage administraatorit.</p><p> Moodle´is on vaja, et administraator muudaks seadeid.</p><p><code>session.auto_start</code> peab olema määratud <code>off</code>.</p><p>Seda seadet saab muuta <code>php.ini</code> failis, Apache/IIS <br />konfiguratsioonis või <code>.htaccess</code> failis serveris.</p>';
$string['feedbacksettings'] = 'Tagasiside seaded';
$string['fileconversioncleanuptask'] = 'Ajutiste kirjete puhastamine failiteisenduste jaoks.';
$string['filecreated'] = 'Uus fail loodud';
$string['filescleanupperiod'] = 'Puhasta prügikasti failid';
$string['filescleanupperiod_help'] = 'Kui tihti prügikasti faile kustutatakse. Need on failid, mis on seotud kontekstiga, mida enam pole, näiteks kui kursus kustutatakse. Pane tähele: see seade võib põhjustada puuduvaid faile kursusel, mis varundatakse, kustutatakse ja seejärel taastatakse, kui seade „Kaasa failid” (varukoopia_failid) jaotises „Automaatse varundamise seaded” on keelatud.';
$string['filesizeunits'] = 'Faili suurusühikud';
$string['filestoredin'] = 'Salvesta fail kausta:';
$string['filestoredinhelp'] = 'Kus faili hoitakse';
$string['filterall'] = 'Filtreeri kõik stringid';
$string['filtermatchoneperpage'] = 'Filtreeri esimene lehel olev vaste';
$string['filtermatchonepertext'] = 'Filtreeri esimene tekstis olev vaste';
$string['filters'] = 'Filtrid';
$string['filtersettings'] = 'Halda filtreid';
$string['filtersettingsgeneral'] = 'Üldised filtrite seaded';
$string['filteruploadedfiles'] = 'Filtreeri üleslaaditavad failid';
$string['forceclean'] = 'Sisu puhastamine kõikjal';
$string['forceclean_desc'] = 'Tavaliselt puhastatakse saidile lisatud sisu enne kuvamist, et eemaldada kõik, mis võib olla turvalisuse oht. Kuid sisu ei puhastata teatud kohtades, näiteks Tegevuse kirjeldused, lehe Vahendid või HTML-plokid, et oleks võimalik lisada skripte, meediume, sisemisi raame jne. Kui see säte on lubatud, puhastatakse KÕIK sisu. Selle tulemusel ei kuvata olemasolevat sisu enam õigesti.';
$string['forcelogin'] = 'Kasutajate sundsisselogimine';
$string['forceloginforprofileimage'] = 'Kasutajapiltide nägemiseks sunni kasutajaid sisse logima';
$string['forceloginforprofileimage_help'] = 'Kui see säte on lubatud, peavad kasutajad profiilipiltide vaatamiseks sisse logima ja kõigis teavitusmeilides kasutatakse kasutaja vaikepilti.';
$string['forceloginforprofiles'] = 'Sundsisselogimine profiili vaatamiseks';
$string['forcetimezone'] = 'Sunni ajavööndit määrama';
$string['formatuninstallwithcourses'] = '{$a->count} kursust kasutab vormingut {$a->format}. Nende vorminguks seatakse {$a->defaultformat} (selle õpikeskkonna vaikevorming). Osad vorminguspetsiifilised andmed võivad kaotsi minna. Kas soovite kindlasti jätkata?';
$string['frontpage'] = 'Esileht';
$string['frontpagebackup'] = 'Esilehe varundus';
$string['frontpagedefaultrole'] = 'Esilehe vaikeroll';
$string['frontpagefilters'] = 'Esilehe filtrid';
$string['frontpageloggedin'] = 'Esilehe kujundus pärast sisselogimist';
$string['frontpageoverrides'] = 'Esilehe õigused kirjutavad üle';
$string['frontpagequestions'] = 'Esilehe küsimused';
$string['frontpagerestore'] = 'Esilehe taaste';
$string['frontpageroles'] = 'Esilehe rollid';
$string['frontpagesettings'] = 'Esilehe sätted';
$string['fullnamedisplay'] = 'Täisnime vorming';
$string['fullnamedisplayprivate'] = 'Täisnime vorming – privaatne';
$string['gdrequired'] = 'Moodle nõuab nüüd pilditeisenduseks GD laiendust.';
$string['generalsettings'] = 'Üldsätted';
$string['geoipfile'] = 'GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'Logitud IP-aadressi allikas';
$string['globalsearch'] = 'Üldotsing';
$string['globalsearchmanage'] = 'Halda üldotsingut';
$string['googlemapkey3'] = 'Google Maps API V3 võti';
$string['googlemapkey3_help'] = 'Peate sisestama erivõtme, et kasutada Google Mapsi IP-aadressi otsingu visualiseerimiseks. Võtme saate tasuta hankida aadressilt <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Mine esimese puuduva stringi juurde';
$string['gradebook'] = 'Hinneteleht';
$string['gradebookroles'] = 'Hinnatavad rollid';
$string['gradeexport'] = 'Peamised hindeekspordi meetodid';
$string['gravatardefaulturl'] = 'Gravatari vaikepildi URL';
$string['gravatardefaulturl_help'] = 'Gravatar vajab vaikepilti, mida kuvada, kui see ei leia määratud kasutaja pilti. Sisestage pildi täielik URL. Kui jätate selle sätte tühjaks, üritab Moodle kasutada vaadatava lehe kõige sobivamat vaikepilti. Võtke ka arvesse, et Gravataril on mitu koodi, mida saab kasutada <a href="https://en.gravatar.com/site/implement/images/#default-image">vaikepiltide loomiseks</a>.';
$string['groupenrolmentkeypolicy'] = 'Rühmapõhise registreerimise võtme tingimused';
$string['groupenrolmentkeypolicy_desc'] = 'Selle sätte lubamisel hakkab Moodle rühma võtmete määramisel kontrollima vastavust kehtivatele paroolipõhimõtetele.';
$string['guestroleid'] = 'Külalise roll';
$string['guestroleid_help'] = 'See roll määratakse külalisele automaatselt. See määratakse ajutiselt ka neile kasutajatele, kes pole registreerunud ja sisenevad kursuselehele külaliste registreerimise lisandmooduli kaudu.';
$string['h5pgetcontenttypestask'] = 'Laadige alla saadaolevad H5P sisutüübid saidilt h5p.org';
$string['helpadminseesall'] = 'Kas administraatorid näevad kõiki kalendrisündmusi või ainult enda sündmusi?';
$string['helpcalendarcustomexport'] = 'Saate lubada kalendrite eksportimisel kohandatud kuupäevavahemiku ekspordivaliku. Selle jõustumiseks peab kalendrite eksportimine olema lubatud.';
$string['helpexportlookahead'] = 'Mitmest tulevasest päevast kalender kohandatud ekspordivaliku puhul sündmusi otsib?';
$string['helpexportlookback'] = 'Mitmest viimasest päevast kalender kohandatud ekspordivaliku puhul sündmusi otsib?';
$string['helpforcetimezone'] = 'Saate lubada kasutajatel ajavööndi ise määrata või määrate ise kõigi jaoks kindla ajavööndi.';
$string['helpshowicalsource'] = 'Kui see säte on lubatud, kuvatakse iCal-ist imporditud sündmuste puhul tellimuse nimi ja link.';
$string['helpsitemaintenance'] = 'Versiooniuuenduste ja muu töö jaoks';
$string['helpstartofweek'] = 'Mis päevaga algab kalendrinädal?';
$string['helpupcominglookahead'] = 'Mitu päeva ette peaks kalender sündmusi vaikimisi otsima?';
$string['helpupcomingmaxevents'] = 'Vaikimisi kuvatav eelseisvate sündmuste maksimumarv';
$string['helpweekenddays'] = 'Millised päevad nädalas on nädalavahetus ja kuvatakse punase värviga?';
$string['hiddenuserfields'] = 'Peida kasutajate väljad';
$string['hidefromall'] = 'Peida kõikide kasutajate eest';
$string['hidefromnone'] = 'Ära varja kellegi eest';
$string['hidefromstudents'] = 'Peida õpilaste eest';
$string['htmleditor'] = 'HTML-i redaktor';
$string['htmleditorsettings'] = 'HTML-redaktori seaded';
$string['htmlsettings'] = 'HTML-i sätted';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP turve';
$string['iconvrequired'] = 'Vajalik on ICONV laienduse installimine.';
$string['ignore'] = 'Eira';
$string['includemoduleuserdata'] = 'Kaasa mooduli kasutajaandmed';
$string['incompatibleblocks'] = 'Mitteühilduvad plokid';
$string['incompleteunicodesupport'] = 'MySQL-i või MariaDB praeguses häälestuses on määratud väärtus „utf8“. See märgistik ei võimalda neljabaidiseid märke, mis sisaldavad mõnda emodžit. Kui proovite neid märke kasutada, põhjustab see sissekande värskendamisel vea ja andmebaasi saadetavad andmed lähevad kaotsi. Kaaluge sättele väärtuse „utf8mb4“ määramist. Täpsemat teavet leiate dokumentatsioonist.';
$string['indexdata'] = 'Indekseerimise andmed';
$string['indexinginfo'] = 'Saidi sisu indekseerimise soovitatav viis on ajastatud toimingu „Üldotsingu indekseerimine“ kasutamine.';
$string['installhijacked'] = 'Installimine tuleb lõpule viia algselt IP-aadressilt';
$string['installsessionerror'] = 'PHP-seanssi ei saa alustada, kontrollige, kas teie brauseris on küpsisefailid lubatud.';
$string['intlrecommended'] = 'Laiendust Intl kasutatakse internatsionaliseerimistoe parandamiseks, nagu näiteks keelepõhiseks sortimiseks.';
$string['intlrequired'] = 'Laiendus Intl on nõutav internatsionaliseerimistoe parandamiseks, nagu näiteks keelepõhiseks sortimiseks ja rahvusvaheliste domeeninimede jaoks.';
$string['invalidagedigitalconsent'] = 'Vanuse alampiir lapsele infoühiskonna teenuse pakkumiseks ei ole kehtiv {$a}';
$string['invalidforgottenpasswordurl'] = 'Unustatud parooli URL pole kehtiv URL.';
$string['invalidsection'] = 'Sobimatu jaotis.';
$string['invalidthemepreset'] = 'Valitud eelseadistatud fail ei ühildu selle teemaga. SCSS-i koostamisviga oli: "{$a}"';
$string['invaliduserchangeme'] = 'Kasutajanimi "changeme" on reserveeritud -- sa ei saa luua sellenimelist kontot.';
$string['ipblocked'] = 'See sait pole praegu saadaval.';
$string['ipblocker'] = 'IP-blokeerija';
$string['ipblockersyntax'] = 'Paigutage iga kirje ühele reale. Korrektsed kirjed on kas täielik IP-aadress (nt <b>192.168.10.1</b>) mis vastab ühele hostile; või osaline aadress (nagu <b>192.168</b>) mis vastab igale aadressile, mis algab nende numbritega; või CIDR-esitus (nt <b>231.54.211.0/20</b>); või IP-aadresside vahemik (nt <b>231.3.56.10-20</b>), kus vahemik rakendub viimasele aadressiosale. Mittenumbrilisi domeeninimesid (nagu „naide.ee“) ei toetata. Tühje ridu eiratakse.';
$string['iplookup'] = 'IP-aadressi otsing';
$string['iplookupgeoplugin'] = 'Praegu kasutatakse geograafilise teabe otsimiseks teenust <a href="http://www.geoplugin.com">geoPlugin</a>. Täpsemate tulemite saamiseks soovitame installida MaxMind GeoLite andmebaasi kohaliku koopia.';
$string['iplookupinfo'] = 'Vaikimisi kasutab Moodle IP-aadresside asukoha otsimiseks NetGeo tasuta veebiandmebaasi, paraku seda andmebaasi enam ei hallata ja võib esineda väga <em>ebatäpseid tulemusi</em>.
Soovitatav on installida ettevõtte MaxMind pakutav GeoLite2 City tasuta andmebaasieksemplar.<br />
IP-aadressi asukoht kuvatakse lihtsal kaardil või Google Mapsis. Interaktiivsete kaartide lubamiseks peab teil olema Google’i konto ja Google Mapsi tasuta API võti.';
$string['iplookupmaxmindnote'] = 'See tarkvara sisaldab ettevõtte MaxMind loodud GeoLite2 andmeid, mis on saadaval veebilehel <a href="http://www.maxmind.com">http://www.maxmind.com</a>.';
$string['ishttpswarning'] = 'Tuvastati, et teie saiti ei turva HTTPS. Soovitame teil tungivalt migreerida oma sait HTTPS-protokollile, et suurendada turvalisust ja parandada integreeritust muude süsteemidega.';
$string['keeptagnamecase'] = 'Säilita sildinime suurtähestus';
$string['lang'] = 'Vaikekeel';
$string['langcache'] = 'Salvesta keelemenüü vahemällu';
$string['langcache_desc'] = 'Saate keelemenüü vahemällu salvestada. Kui see säte on lubatud, siis salvestatakse kõik tõlked vahemällu. Vahemälu värskendatakse automaatselt, kui sisseehitatud keelepaketihaldusriista kaudu keelepakette installite või kustutate. Kui installite keelepaketi käsitsi, siis peate vahemälus olevate üksuste värskendamiseks valima valiku „Puhasta kõik vahemälud“.';
$string['langlist'] = 'Keeltemenüü keeled';
$string['langmenu'] = 'Kuva keeltemenüü';
$string['langmenuinsecurelayout'] = 'Keelemenüü kuvamine turvalises paigutuses';
$string['langmenuinsecurelayout_desc'] = 'Kui see on lubatud, saab kasutaja testi või toimingu tegemisel turvalise paigutuse abil oma keelt muuta.';
$string['langpackwillbeupdated'] = 'MÄRKUS. Versiooniuuenduse käigus proovib Moodle alla laadida keelepakettide värskendusi.';
$string['langstringcache'] = 'Salvesta kõik keelestringid vahemällu';
$string['languagesettings'] = 'Keelesätted';
$string['latinexcelexport'] = 'Exceli kodeering';
$string['legacyfilesaddallowed'] = 'Luba pärandkursusefailidesse lisamine';
$string['legacyfilesaddallowed_help'] = 'Kui kursus sisaldab pärandkursusefaile, lubatakse nendesse uute failide ja kaustade lisamine.';
$string['legacyfilesinnewcourses'] = 'Kursuste pärandfailid uutes kursustes';
$string['legacyfilesinnewcourses_help'] = 'Vaikimisi on pärandkursusefailide alad saadaval ainult uuendatud kursustes. Võtke arvesse, et mõni funktsioon (nt Tegevuste varundus ja taaste) ei ühildu selle sättega.';
$string['libcurlwarning'] = 'Tuvastati, et libcurl ei toeta protokolli CURLOPT_PROTOCOL. Turbekaalutlustel soovitame installida ajakohane libcurl.';
$string['licensesettings'] = 'Litsentsisätted';
$string['linkadmincategories'] = 'Lingi administraatori kategooriad';
$string['linkadmincategories_help'] = 'Kui see säte on lubatud, kuvatakse administraatorisätete kategooriad navigeerimispaanil linkidena ja need viivad administraatori kategooriate lehtedeni.';
$string['loading'] = 'Laadib';
$string['localetext'] = 'Saidiülene lokaat';
$string['localstringcustomization'] = 'Kohalikud keelekohandused';
$string['location'] = 'Asukoht';
$string['locationsettings'] = 'Asukohasätted';
$string['locked'] = 'Lukus';
$string['lockoutduration'] = 'Konto lukustamise kestus';
$string['lockoutduration_desc'] = 'Lukus konto avatakse märgitud aja möödumisel automaatselt.';
$string['lockoutemailbody'] = 'Teie konto, mille kasutajanimi on {$a->username} (serveris \'{$a->sitename}\')
 lukustati peale mitut nurjunud sisselogimiskatset.

Oma konto viivitamatuks avamiseks minge järgmisele veebilehele:

{$a->link}

Enamikus meiliprogrammides peaks see veebiaadress kuvatama
sinise lingina, mida saab klõpsata. Kui see ei toimi, siis kopeerige ja
kleepige see aadress oma brauseri aadressiribale.

Kui vajate abi, siis pöörduge administraatori poole,
{$a->admin}';
$string['lockoutemailsubject'] = 'Teie konto, mis asub {$a}, on lukus';
$string['lockouterrorunlock'] = 'Sisestatud on sobimatu konto lukust avamise teave.';
$string['lockoutthreshold'] = 'Konto lukustamise lävi';
$string['lockoutthreshold_desc'] = 'Valige nurjunud sisselogimiskatsete arv, mille järel konto lukustatakse. Seda funktsiooni võidakse teenuse tõkestamise rünnete ajal kuritarvitada.';
$string['lockoutwindow'] = 'Konto lukustamise jälgimise aken';
$string['lockoutwindow_desc'] = 'Lukustamise läve jälgimise aeg – kui selle aja jooksul nurjunud katseid ei esine, lähtestatakse läve loendur.';
$string['lockrequestcategory'] = 'Takista kategooria valik';
$string['log'] = 'Logid';
$string['logguests'] = 'Logi külalisjuurdepääs';
$string['logguests_help'] = 'Selle sättega saab aktiveerida külaliskontode ja sisselogimata kasutajate tegevuste logimise. Suure koormusega saitide puhul võiksite logimise parema jõudluse tagamiseks keelata. Valmistussaitide puhul on soovitatav see säte aktiivsena hoida.';
$string['logininfoinsecurelayout'] = 'Kuva sisselogitud kasutaja turvalises paigutuses';
$string['logininfoinsecurelayout_desc'] = 'Kui see on lubatud, kuvatakse sisselogitud kasutaja täisnimi navigeerimisribal, kui proovid testi või muud Tegevust teha kasutades turvalist paigutust.';
$string['loginpageautofocus'] = 'Automaatselt fookuses kuvatav vorm sisselogimislehel';
$string['loginpageautofocus_help'] = 'Selle sätte lubamine parandab sisselogimislehe kasutatavust, aga automaatne väljade fokuseerimine loetakse hõlbustusprobleemiks.';
$string['loglifetime'] = 'Logide säilitamise aeg';
$string['logo'] = 'Logo';
$string['logo_desc'] = 'Täielik logo, mida kasutatakse mõnes kujunduses (nt tuumikkujundustes) dekoratsioonina. Pildi resolutsioon võib olla üsna kõrge, sest seda vähendatakse kasutuse jaoks ja talletatakse jõudluse huvides vahemälus. Tavaliselt toimivad paremini logod, mille laius on suurem kui pikkus. Sobivad vormingud: PNG ja JPG.';
$string['logocompact'] = 'Kompaktne logo';
$string['logocompact_desc'] = 'Ülaltoodud logo kompaktne versioon, nt embleem, kilp või ikoon. Pilt peaks olema selge ka väikses suuruses. Sobivad vormingud: PNG ja JPG.';
$string['logossettings'] = 'Logod';
$string['logstorenotrequired'] = 'Logisalv pole nõutav';
$string['logstoressupported'] = 'Logisalved, mis toetavad seda aruannet';
$string['longtimewarning'] = '<b>Tähelepanu, see toimingu teostamiseks võib kuluda palju aega.</b>';
$string['mailnewline'] = 'Uue rea märk e-mailis';
$string['maintenancemode'] = 'Hooldusrežiimis';
$string['maintenancemodeisscheduled'] = 'Selles õpikeskkonnas aktiveeritakse {$a->min} minuti ja {$a->sec} sekundi pärast hooldusrežiim';
$string['maintenancemodeisscheduledlong'] = 'Saidil aktiveeritakse {$a->hour} tunni {$a->min} minuti ja {$a->sec} sekundi pärast hooldusrežiim';
$string['maintfileopenerror'] = 'Viga hooldusrežiimi failide avamisel!';
$string['maintinprogress'] = 'Toimub süsteemi hooldus...';
$string['managecontextlock'] = 'Külmuta see kontekst';
$string['managecontextlocklocked'] = '{$a->contextname} ja kõik madalamad kontekstid on nüüd külmutatud.';
$string['managecontextlockunlocked'] = '{$a->contextname} ja kõik madalamad kontekstid on nüüd külmutamata.';
$string['managecontextunlock'] = 'Mittekülmuta kontsekst';
$string['managecustomfields'] = 'Halda kohandatud välja tüüpe';
$string['manageformats'] = 'Halda kursusevorminguid';
$string['manageformatsgotosettings'] = 'Vaikevormingut saab muuta asukohas {$a}';
$string['managelang'] = 'Halda';
$string['manageqbehaviours'] = 'Halda küsimuste toimimist';
$string['manageqtypes'] = 'Halda küsimuste tüüpe';
$string['maturity100'] = 'Beeta';
$string['maturity150'] = 'Testversioon';
$string['maturity200'] = 'Stabiilne versioon';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Vihje. Võiksite selle skripti käivitada „allow-unstable“ valikuga';
$string['maturitycoreinfo'] = 'Õpikeskkond kasutab praegu ebastabiilset „{$a}“ arenduskoodi.';
$string['maturitycorewarning'] = 'Moodle’i versioon, mida soovite installida või millele üle minna, sisaldab ebastabiilset „{$a}“ arenduskoodi, mida ei saa enamiku valmistussaitide korral kasutada. Kui te ei soovinud seda installida, siis veenduge, et kasutaksite Moodle\'i koodirepositooriumist stabiilseks märgitud versiooni. Lisateavet leiate Moodle\'i dokumentatsioonist.';
$string['maxbytes'] = 'Üleslaaditava faili maksimummaht';
$string['maxconsecutiveidentchars'] = 'Järjestikuseid identseid märke';
$string['maxeditingtime'] = 'Postituste muutmise maksimumaeg';
$string['maxsizeperdownloadcoursefile'] = 'Maksimaalne suurus faili kohta';
$string['maxsizeperdownloadcoursefile_desc'] = 'Iga faili maksimaalne suurus kursuse sisu allalaadimisel. Seda suurust ületavad failid jäetakse allalaadimisest välja.';
$string['maxtimelimit'] = 'Maksimaalne ajapiirang';
$string['maxtimelimit_desc'] = 'Selleks et piirata maksimaalset PHP täitmisaega, mida Moodle ilma ühegi väljundi kuvamiseta lubab, sisestage siia väärtus sekundites. 0 tähendab, et kasutatakse Moodle’i vaikepiiranguid. Kui teil on eesserver, millel on oma ajalimiit, määrake see väärtus madalamaks, et saada PHP-tõrkeid logides. Ei kehti CLI-skriptide puhul.';
$string['maxusersperpage'] = 'Kasutajate maksimumarv ühel lehel';
$string['mbstringrecommended'] = 'Õpikeskkonna jõudluse parandamiseks on tungivalt soovitatav installida valikuline MBSTRING- teek, eriti just sel juhul, kui teie õpikeskkonda toetab ka mitteladina tähestikuga keeli (eesti keel ei kasuta ainult ladina tähestikku, seega soovitatav eesti keele toe jaoks)';
$string['mbstringrequired'] = 'MBSTRING-teegi installimine on vajalik saidi toimivuse parandamiseks, eriti kui teie sait toetab mitte-ladina keeli.';
$string['mediapluginavi'] = 'Luba .avi filter';
$string['mediapluginflv'] = 'Luba .flv filter';
$string['mediapluginimg'] = 'Luba lingitud piltide automaatne manustamine';
$string['mediapluginmov'] = 'Luba .mov filter';
$string['mediapluginmp3'] = 'Luba .mp3 filter';
$string['mediapluginmpg'] = 'Luba .mpg filter';
$string['mediapluginogg'] = 'Luba .ogg filter';
$string['mediapluginogv'] = 'Luba .ogv filter';
$string['mediapluginram'] = 'Luba .ram filter';
$string['mediapluginrm'] = 'Luba .rm filter';
$string['mediapluginrpm'] = 'Luba .rpm filter';
$string['mediapluginwmv'] = 'Luba .wmv filter';
$string['mediapluginyoutube'] = 'Luba YouTube’i linkide filter';
$string['messaging'] = 'Luba teavitussüsteem';
$string['messagingallowemailoverride'] = 'Meiliteatiste ülekirjutamine';
$string['messagingallusers'] = 'Luba saidiülene sõnumite saatmine';
$string['messagingcategory'] = 'Sõnumite saatmine';
$string['messagingdefaultpressenter'] = '';
$string['messagingdeleteallnotificationsdelay'] = 'Kustuta kõik märguanded';
$string['messagingdeletereadnotificationsdelay'] = 'Kustuta loetud teatised';
$string['messagingssettings'] = 'Sõnumite seadistused';
$string['minpassworddigits'] = 'Numbrid';
$string['minpasswordlength'] = 'Parooli pikkus';
$string['minpasswordlower'] = 'Väiketähed';
$string['minpasswordnonalphanum'] = 'Pole tähed ega numbrid';
$string['minpasswordupper'] = 'Suurtähed';
$string['misc'] = 'Varia';
$string['mlbackendsettings'] = 'Masiõppe backend seaded';
$string['mnetrestore_extusers'] = '<strong> Märkus: </strong> see varufail sisaldab Moodle\'i võrgu kasutajakontosid, mis taastatakse protsessi osana.';
$string['mnetrestore_extusers_admin'] = '<strong>Märkus.</strong> See varufail paistab olevat pärit mõnest muust Moodle’i installist ja sisaldab Moodle Networki kaugkasutajakontosid. Taastamisprotsess püüab Moodle Networki hoste vastendada kõikide loodavate kasutajatega. Neile, mida ei saa vastendada, määratakse automaatselt sisemine autentimisviis (MNeti asemel). Sellest teavitab teid taastetoimingulogi.';
$string['mnetrestore_extusers_mismatch'] = '<strong> Märkus: </strong> see varufail pärineb ilmselt teisest Moodle\'i installist ja sisaldab Moodle\'i võrgu kasutajakontosid, mille taastamine võib ebaõnnestuda. Seda toimingut ei toetata. Kui oled kindel, et see loodi sellel Moodle\'i installimisel, või oled veendunud, et kõik vajalikud Moodle\'i võrgu hostid on konfigureeritud, võiksid  ikkagi proovida taastamist.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Märkus.</strong> See varufail paistab olevat pärit mõnest muust Moodle’i installist ja sisaldab Moodle Networki kaugkasutajakontosid. Teil pole seda tüüpi taastetoimingu käivitamise õigust. Pöörduge administraatori poole või proovige taastada see kursus ilma kasutajaandmeteta (moodulid, failid).';
$string['mnetrestore_extusers_switchuserauth'] = 'Moodle\'i võrgu kaugkasutaja {$a-> username} (pärit {$a- mnethosturl}) vahetas kohaliku autentitud {$a->auth} kasutaja.';
$string['mobilenotconfiguredwarning'] = 'Moodle\'i äpp ei ole lubatud';
$string['modeditdefaults'] = 'Tegevusesätete vaikeväärtused';
$string['modsettings'] = 'Halda Tegevusi';
$string['modulesecurity'] = 'Mooduli turve';
$string['moodlebrandedapp'] = 'Moodle\'i kaubamärgiga äpp';
$string['moodlebrandedappreference'] = 'Teise võimalusena hangi oma kohandatud kaubamärgiga <a href="https://moodle.com/branded-app/">kaubamärgiga Moodle\'i rakendus</a>.';
$string['mustenablestats'] = 'Statistika pole sellel saidil veel lubatud.';
$string['mydashboard'] = 'Süsteemi vaikimis töölaud';
$string['mymoodle'] = 'Töölaud';
$string['mypage'] = 'Vaike-töölaualeht';
$string['mypagelocked'] = 'Lukusta vaikeleht';
$string['myprofile'] = 'Vaike-profiilileht';
$string['navadduserpostslinks'] = 'Lisa lingid kasutaja postituste vaatamiseks';
$string['navadduserpostslinks_help'] = 'Kui see säte on lubatud, lisatakse iga kasutaja jaoks navigeerimispaanile kaks linki, mille abil saab vaadata arutelusid, mida kasutaja on algatanud, ning postitusi, mida kasutaja on teinud kogu õpikeskkonnas või kindlate kursuste foorumites.';
$string['navcourselimit'] = 'Kursuste limiit';
$string['navigationupgrade'] = 'See uuendus sisaldab kahte uut navigeerimisplokki, mis vahetavad välja järgmised plokid: Haldus, Kursused, Tegevused ja Osalejad. Kui teil olid määratud nende plokkidega seotud teatud õigused, peaksite kontrollima, kas kõik toimib nii, nagu vaja.';
$string['navshowallcourses'] = 'Kuva kõik kursused';
$string['navshowcategories'] = 'Kuva kursuste kategooriad';
$string['navshowfrontpagemods'] = 'Kuva esilehe tegevused navigatsioonimenüüs';
$string['navshowfrontpagemods_help'] = 'Kui see säte on lubatud, kuvatakse esilehe tegevused õpikeskkonna lehtede all asuval navigeerimispaanil.';
$string['navshowfullcoursenames'] = 'Kuva kursuste täisnimed';
$string['navshowfullcoursenames_help'] = 'Kui see säte on lubatud, kasutatakse navigeerimispaanil kursuste täisnimesid, mitte lühinimesid.';
$string['navshowmycoursecategories'] = 'Kuva minu kursuste kategooriad';
$string['navshowmycoursecategories_help'] = 'Kui see säte on lubatud, kuvatakse kasutajate Minu kursuste haru kursused kategooriates.';
$string['navsortmycourseshiddenlast'] = 'Sorteeri minu varjatud kursused viimaseks';
$string['navsortmycourseshiddenlast_help'] = 'Kui see on lubatud, loetletakse kõik peidetud kursused pärast nähtavaid kursusi (kasutajatele, kes saavad varjatud kursusi vaadata). Vastasel korral loetletakse kõik kursused, olenemata nende nähtavusest, vastavalt sättele \'Sorteeri mu kursused\'.';
$string['navsortmycoursessort'] = 'Sordi minu kursused';
$string['navsortmycoursessort_help'] = 'See määrab, kas kursused loetletakse harus Minu kursused sortimisjärjestuses (s.t järjestuses, mis on määratud kohas Õpikeskkonna haldus > Kursused > Kursuste ja kategooriate haldamine) või kursuse sätte põhjal tähestikulises järjestuses.';
$string['never'] = 'Mitte kunagi';
$string['neverdeleteruns'] = 'Ära käitusi kunagi kustuta';
$string['newestdocindexed'] = 'Uusim indekseeritud dokument';
$string['nobookmarksforuser'] = 'Teil pole järjehoidjaid.';
$string['nodatabase'] = 'Andmebaasi pole';
$string['nohttpsformobilewarning'] = 'Soovitatav on lubada kehtiva serdiga HTTPS-protokoll. Moodle’i rakendus proovib alati esmalt kasutada turvalist ühendust.';
$string['nomissingstrings'] = 'Pole puuduvaid sõnesid';
$string['none'] = 'Pole';
$string['nonewsettings'] = 'Uusi seadeid ei ole lisatud selle täienduse käigus.';
$string['nonexistentbookmark'] = 'Küsitud järjehoidjat pole olemas.';
$string['noreplyaddress'] = 'No-reply aadress';
$string['noreplydomain'] = 'Mitte vastamiseks ja domeen';
$string['noreplydomaindetail'] = 'Funktsiooni Mitte vastamiseks ja konfigureeritud domeenide sätted';
$string['noresults'] = 'Tulemeid ei leitud.';
$string['noroles'] = 'Rolle pole';
$string['nosupportedlogstore'] = 'Toetatud logisalvesid ei leitud';
$string['notifications'] = 'Teavitused';
$string['notifyloginfailures'] = 'Sisselogimiste nurjumise meiliteatise adressaat';
$string['notifyloginthreshold'] = 'Meiliteatiste lävi';
$string['notloggedinroleid'] = 'Külaliskasutajate roll';
$string['numberofmissingstrings'] = 'Puudu olevaid sõnesid: {$a}';
$string['numberofstrings'] = 'Sõnesid kokku: {$a->strings}<br />Puudu: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'OAuth-teenuse {$a->issuer} värskendustõend teie saidil {$a->siteurl} on aegunud. See mõjutab seda teenust kasutavate lisandmoodulite tööd. Avage probleemi lahendamiseks teenuste OAuth 2 Services konfigureerimise leht ja klõpsake vastava teenuse tabelireas ikooni „Ühenda süsteemikonto“. Kasutage sisselogimisel OAuth-süsteemi jaoks iga kord sama teenusekontot.';
$string['oauthrefreshtokenexpiredshort'] = 'Teenuse {$a->issuer} OAuth-värskendustõend teie saidil {$a->siteurl} on aegunud.';
$string['onlynoreply'] = 'Ainult siis, kui pärineb mittevastavalt aadressilt';
$string['opcacherecommended'] = 'PHP toimingukoodi vahemällu salvestamine suurendab jõudlust ja langetab mälunõudeid, OPcache-laiend on soovitatav ning täielikult toetatud.';
$string['opensslrecommended'] = 'Valikulise OpenSSL-teegi installimine on tungivalt soovitatav – see võimaldab Moodle’i võrgufunktsiooni.';
$string['opensslrequired'] = 'Moodle nõuab nüüd tugevamate krüptograafiateenuste pakkumiseks lisandmooduli OpenSSL PHP kasutamist.';
$string['opentowebcrawlers'] = 'Ava Google’is';
$string['optionalmaintenancemessage'] = 'Valikuline hooldusteade';
$string['order1'] = 'Esimene';
$string['order2'] = 'Teine';
$string['order3'] = 'Kolmas';
$string['order4'] = 'Neljas';
$string['outgoingmailconfig'] = 'Väljamineva meili konfiguratsioon';
$string['overridetossl'] = 'Logi sisse HTTPS on nüüd aegunud. See eksemplar on nüüd sunnitud SSL-i kasutama. Selle hoiatuse parandamiseks muuda oma wwwroot konfig.php-s aadressiks https://';
$string['pageinfodebugsummary'] = 'See leht on: {$a}';
$string['passwordchangelogout'] = 'Logi parooli muutmise järel välja';
$string['passwordchangelogout_desc'] = 'Kui see säte on lubatud, lõpetatakse parooli muutmise järel kõik brauseriseansid, v.a seanss, kus uus parool määrati. (See säte ei mõjuta kasutajate hulgiüleslaadimise kaudu muudetud paroole.)';
$string['passwordchangetokendeletion'] = 'Eemalda pärast parooli muutmist veebiteenuste juurdepääsutõendid';
$string['passwordchangetokendeletion_desc'] = 'Kui see on lubatud ja parool muudetakse, kustutatakse kõik kasutaja veebiteenuste juurdepääsutõendid.';
$string['passwordpolicy'] = 'Parooli tingimused';
$string['passwordpolicycheckonlogin'] = 'Kontrolli salasõna sisselogimisel';
$string['passwordresettime'] = 'Maksimaalne aeg, mille jooksul peab parooli lähtestamise valideerima';
$string['passwordreuselimit'] = 'Parooli vaheldumise limiit';
$string['passwordreuselimit_desc'] = 'See näitab, mitu korda peab kasutaja oma parooli muutma enne, kui tal on lubatud parooli uuesti kasutada. Varem kasutatud paroolide räsiväärtused talletatakse kohaliku andmebaasi tabelis. See funktsioon ei pruugi ühilduda mõnede välise autentimise lisandmoodulitega.';
$string['pathtodot'] = 'Doti failitee';
$string['pathtodot_help'] = 'Doti failitee. Tõenäoliselt midagi sellist: /usr/bin/dot. DOT-failidest graafikafailide genereerimiseks peab teil olema installitud dot-käituskomponent ja siin peate näitama, milline on doti failitee. Arvestage, et praegu kasutavad seda üksnes Moodle’isse sisse ehitatud profiilimisfunktsioonid (Arendus->Profiilimine).';
$string['pathtodu'] = 'Du failitee';
$string['pathtogs'] = 'Ghostscripti tee';
$string['pathtogs_help'] = 'Enamiku Linuxi installide puhul võib selleks jääda „/usr/bin/gs“. Windowsis näeb see umbes välja järgmine: „c:gsbingswin32c.exe“ (veenduge, et tee ei sisaldaks tühikuid, vajaduse korral kopeerige failid „gswin32c.exe“ ja „gsdll32.dll“ uude kausta nii, et tee ei sisaldaks tühikut)';
$string['pathtopgdump'] = 'pg_dump rada';
$string['pathtopgdumpdesc'] = 'See on vajalik ainult siis sisestada, kui süsteemis on mitu pg_dump installeerimist (näiteks, kui Sa oled installeerinud mitu erinevat postgresql versiooni)';
$string['pathtopgdumpinvalid'] = 'Vigane pg_dump rada - kas vigane rada või ei ole käivitatav';
$string['pathtophp'] = 'Tee PHP CLI-le';
$string['pathtopsql'] = 'psql rada';
$string['pathtopsqldesc'] = 'See on vajalik ainult siis sisestada, kui süsteemis on mitu psql installeerimist (näiteks, kui Sa oled installeerinud mitu erinevat postgresql versiooni)';
$string['pathtopsqlinvalid'] = 'Vigane psql rada - kas vigane rada või ei ole käivitatav';
$string['pathtopython'] = 'Tee Pythonini';
$string['pathtopythondesc'] = 'Tee sinu käivitatava Pythoni kahendkoodi juurde (nii Python 2 kui ka Python 3 on vastuvõetavad).';
$string['pathtosassc'] = 'Tee SassC-ini';
$string['pathtosassc_help'] = 'SassC-kahendkoodi asukoha määramine lülitab SASS-kompilaatori Moodle\'i PHP-juurutusest SassC-i. Lisateavet leiad aadressilt https://github.com/sass/sassc.';
$string['pcreunicodewarning'] = 'Tungivalt soovitatav on kasutada PCRE PHP laiendit, mis ühildub Unicode’i märkidega.';
$string['perfdebug'] = 'Jõudlusteave';
$string['performance'] = 'Jõudlus';
$string['pgcluster'] = 'PostgreSQL klaster';
$string['pgclusterdescription'] = 'PostgreSQL versioon/klaster parameeter for käsurea operatsioonideks. Kui Sul on süsteemis ainult üks postgresql või Sa ei ole kindel, mis see on, siis jäta tühjaks.';
$string['phpfloatproblem'] = 'PHP ujukomaga arvude käsitsemisel ilmnes ootamatu probleem – {$a}';
$string['pleaserefreshregistration'] = 'Sinu sait on registreeritud. Registreeringut uuendati viimati {$a}.<br /> Ajastatud ülesanne \'Saidi registreerimine\' hoiab sinu registreeringut värskena. Sa võid alati registreeringut ka käsitsi uuendada.';
$string['pleaserefreshregistrationnewdata'] = 'Registreerimisteavet on muudetud. Kinnitage see nupuga \'Värskenda registreerimist\'.';
$string['pleaserefreshregistrationunknown'] = 'Teie sait on registreeritud, kuid registreerimise kuupäeva pole. Värskendage oma registreeringut, kasutades nuppu \'Värskenda registreerimist\' või veenduge, et lubatud on ajastatud toiming \'Saidi registreerimine\', mis värskendab saidi registreeringut automaatselt.';
$string['plugin'] = 'Lisandmoodul';
$string['plugins'] = 'Lisandmoodulid';
$string['pluginscheck'] = 'Moodulite sõltuvuste kontroll';
$string['pluginscheckfailed'] = 'Järgmiste moodulite sõltuvuste kontroll nurjus: {$a->pluginslist}';
$string['pluginschecktodo'] = 'Enne selle Moodle’i versiooni installimist peate lahendama kõik lisandmoodulitega seotud probleemid.';
$string['pluginsoverview'] = 'Lisandmoodulite ülevaade';
$string['pluginsoverviewsee'] = 'Lisateavet leiate veebilehelt <a href="{$a->url}">Lisandmoodulite ülevaade</a>';
$string['policysettings'] = 'Poliitika sätted';
$string['privacy:metadata'] = 'Administraatori plugin ei salvesta isikuandmeid.';
$string['privacyandpolicies'] = 'Privaatsus ja poliitika';
$string['privacysettings'] = 'Privaatussätted';
$string['profilecategory'] = 'Kategooria';
$string['profilecategoryname'] = 'Kategooria nimi (nimi peab olema kordumatu)';
$string['profilecategorynamenotunique'] = 'See kategoorianimi on juba kasutusel';
$string['profilecommonsettings'] = 'Üldsätted';
$string['profileconfirmcategorydeletion'] = 'Selles kategoorias on  väli/väljad {$a}, mis teisaldatakse ülaltoodud kategooriasse (või alla, kui kuuluvad ülemkategooriasse).<br />Kas soovid siiski selle kategooria kustutada?';
$string['profileconfirmfielddeletion'] = 'Selle välja kohta on {$a} kasutajakirjet, mis kustutatakse.<br />Kas soovite selle välja kindlasti kustutada?';
$string['profilecreatecategory'] = 'Loo uus profiilikategooria';
$string['profilecreatefield'] = 'Loo uus profiiliväli:';
$string['profilecreatenewcategory'] = 'Uue kategooria loomine';
$string['profilecreatenewfield'] = 'Uue profiilivälja „{$a}“ loomine';
$string['profiledefaultcategory'] = 'Muud väljad';
$string['profiledefaultchecked'] = 'Vaikimisi märgitud';
$string['profiledefaultdata'] = 'Vaikeväärtus';
$string['profiledeletecategory'] = 'Kategooria kustutamine';
$string['profiledeletefield'] = 'Välja „{$a}“ kustutamine';
$string['profiledescription'] = 'Välja kirjeldus';
$string['profiledscript'] = 'See skript on profiilitud';
$string['profiledscriptview'] = 'Vaata selle skripti profiilimisteavet';
$string['profileeditcategory'] = 'Kategooria muutmine: {$a}';
$string['profileeditfield'] = 'Profiilivälja muutmine: {$a}';
$string['profilefield'] = 'Profiiliväli';
$string['profilefieldcolumns'] = 'Veerud';
$string['profilefieldispassword'] = 'Kas see on parooliväli?';
$string['profilefieldlink'] = 'Link';
$string['profilefieldlink_help'] = 'Kui soovite teksti lingiks teisendada, sisestage $$ sisaldav URL ($$ asendatakse tekstiga). Näiteks kui soovite Twitteri ID lingiks teisendada, sisestage http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Lingi sihtkoht';
$string['profilefieldmaxlength'] = 'Maksimumpikkus';
$string['profilefieldrows'] = 'Read';
$string['profilefields'] = 'Kasutajaprofiili väljad';
$string['profilefieldsize'] = 'Välja suurus';
$string['profileforceunique'] = 'Kas andmed peavad olema kordumatud?';
$string['profileinvaliddata'] = 'Vigane väärtus';
$string['profilelocked'] = 'Kas väli on lukus?';
$string['profilemenudefaultnotinoptions'] = 'Vaikeväärtus pole üks valikutest';
$string['profilemenunooptions'] = 'Etteantud menüükäske pole';
$string['profilemenuoptions'] = 'Menüükäsud (igal real üks)';
$string['profilemenutoofewoptions'] = 'Peate sisestama vähemalt kaks valikut';
$string['profilename'] = 'Nimi';
$string['profilenofieldsdefined'] = 'Väljad on määratlemata';
$string['profilerequired'] = 'Kas see väli on kohustuslik?';
$string['profileroles'] = 'Profiili nähtavad rollid';
$string['profilesforenrolledusersonly'] = 'Ainult registreerunud kasutajate profiilid';
$string['profileshortname'] = 'Lühinimi (peab olema kordumatu)';
$string['profileshortnameinvalid'] = 'See lühinimi võib sisaldada ainult tähtnumbrilisi tähti (tähti ja numbreid) või alakriipsu (_).';
$string['profileshortnamenotunique'] = 'See lühinimi on juba kasutusel';
$string['profilesignup'] = 'Kas kuvada registreerumislehel?';
$string['profilespecificsettings'] = 'Erisätted';
$string['profilevisible'] = 'Kellele see väli kuvatakse?';
$string['profilevisible_help'] = '* Pole nähtav – privaatsed andmed, mida näeb ainult administraator
* Nähtav kasutajale – privaatsed andmed, mida näevad kasutaja ise ja administraator
* Nähtav kõigile – avalikult nähtav';
$string['profilevisibleall'] = 'Nähtav kõigile';
$string['profilevisiblenone'] = 'Pole nähtav';
$string['profilevisibleprivate'] = 'Nähtav kasutajale';
$string['profiling'] = 'Profiilimine';
$string['profilingallowall'] = 'Jätkuv profiilimine';
$string['profilingallowall_help'] = 'Selle sätte lubamisel saate igal ajal kõikjal (PGC) kasutada parameetrit PROFILEALL, et lubada kõikide Moodle’i seansi eluea jooksul käivitatud skriptide profiilimine. Samamoodi saab selle peatamiseks kasutada parameetrit PROFILEALLSTOP.';
$string['profilingallowme'] = 'Valikuline profiilimine';
$string['profilingallowme_help'] = 'Selle sätte lubamisel saate valikuliselt kasutada parameetrit PROFILEME kõikjal (PGC) ja profiilida, mis skriptiga juhtub. Samamoodi saab selle profiilimise tõkestamiseks kasutada parameetrit DONTPROFILEME.';
$string['profilingautofrec'] = 'Automaatne profiilimine';
$string['profilingautofrec_help'] = 'Selle sätte konfigureerimise korral valitakse välja mõni päring (juhuslikult, määratud sageduse põhjal: 1/n) ja profiilitakse automaatselt, salvestades tulemused edasiseks analüüsimiseks. Selline profiilimisviis võtab arvesse kaasamise/välistamise sätteid. Automaatse profiilimise keelamiseks määrake selle sätte väärtuseks 0.';
$string['profilingenabled'] = 'Luba profiilimine';
$string['profilingenabled_help'] = 'Selle sätte lubamisel on profiilimine saadaval sellel saidil ja järgmiste valikute konfigureerimisega saate määratleda profiilimise toimimise.';
$string['profilingexcluded'] = 'Välista profiilimisest';
$string['profilingexcluded_help'] = 'Loend (komaga eraldatult, absoluutaadress jäetakse vahele wwwroot, kutsutav) URL-idest, mis välistatakse sättega \'Profile these\' määratletud ja profiilitavate URL-ide hulgast.';
$string['profilingimportprefix'] = 'Profiilimise importimise eesliide';
$string['profilingimportprefix_desc'] = 'Tuvastamise hõlbustamiseks lisatakse kõigi imporditud profiilimiste eesliiteks siin määratud väärtus.';
$string['profilingincluded'] = 'Profiili neid';
$string['profilingincluded_help'] = 'Selliste URL-aadresside loend (komaeraldusega, absoluutaadress wwwroot jäetakse vahele, kutsutav), mis profiilitakse automaatselt. Näiteks: /index.php, /course/view.php. Samuti saab lisada ka metamärgi „*“. Näiteks: /mod/forum/*, /mod/*/view.php';
$string['profilinglifetime'] = 'Säilita profiilimiskäitused';
$string['profilinglifetime_help'] = 'Määrake aeg, mille jooksul tuleb säilitada vanade profiilimiskäituste teavet. Vanemaid kärbitakse regulaarselt. Arvestage, et siit välistatakse sellised profiilimiskäitused, mis on märgitud referentskäitusteks';
$string['profilingslow'] = 'Kirjelda aeglased lehed';
$string['profilingslow_help'] = 'Minimaalse aja sekundites määramise abil kuvatakse kõik aeglasemad lehed. Säilitatakse ainult profiilid, mis on sama skripti olemasolevast profiilist aeglasemad. Keelamiseks vali väärtus 0. Pane tähele, et see järgib välistamissätteid.';
$string['protectusernames'] = 'Kaitse kasutajanimesid';
$string['proxybypass'] = 'Puhverserveri möödaminek hostidest';
$string['proxyhost'] = 'Puhverserveri host';
$string['proxypassword'] = 'Proksi parool';
$string['proxyport'] = 'Puhverserveri port';
$string['proxytype'] = 'Puhverserveri tüüp';
$string['proxyuser'] = 'Puhverserveri kasutajanimi';
$string['purgecaches'] = 'Puhasta kõik vahemälud';
$string['purgecachesconfirm'] = 'Moodle võimaldab puhverdada kujundusi, JavaScripti, keelefaile, filtreeritud tekste, RSS-kanaleid ja paljusid muid andmeid. Nende vahemälude puhastamisel kustutatakse kõik andmed ja kõik brauserid peavad andmed uuesti alla laadima (et kuvataks praeguse koodi loodud kõige ajakohasemad väärtused). Vahemälu puhastamisega ei kaasne mingit ohtu, aga leht võib laadida aeglasemalt, kuni server ja kasutajate veebibrauserid uut teavet vahemälusse puhverdavad.';
$string['purgecachesfinished'] = 'Kõik vahemälud on puhastatud.';
$string['purgecachesnoneselected'] = 'Vali üks või mitu vahemälu, mida soovite puhastada';
$string['purgecachespage'] = 'Tühjenda vahemälu';
$string['purgefiltercache'] = 'Tekstifiltrid';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Keelestringid';
$string['purgemuc'] = 'Kõik MUCi vahemälud';
$string['purgeothercaches'] = 'Kõik failide ja muud vahemälud';
$string['purgeselectedcaches'] = 'Puhasta valitud vahemälud';
$string['purgeselectedcachesfinished'] = 'Valitud vahemälud puhastati';
$string['purgetemplates'] = 'Mallid';
$string['purgethemecache'] = 'Teemad';
$string['query'] = 'Päring';
$string['question'] = 'Küsimus';
$string['questionbehaviours'] = 'Küsimuste toimimised';
$string['questioncwqpfscheck'] = 'Küsitluses moodustatakse üks või mitu juhuslikku küsimust, et valida küsimused jagatud ja jagamata küsimuste kategooria hulgast. Siin on täpsem aruanne <a href="{$a->reporturl} "> siin </a> ja vaata Moodle Docs\'i lehte <a href="{$a->docsurl}"> siin </a>.';
$string['questioncwqpfsok'] = 'Hea. Teie testides, mis on häälestatud küsimusi valima jagatavate ja mittejagatavate küsimuste kategooriatest, pole juhujärjestusega küsimusi.';
$string['questiontype'] = 'Küsimuse tüüp';
$string['questiontypes'] = 'Küsimuste tüübid';
$string['quizattemptsupgradedmessage'] = 'Moodle’i versioonis 2.1 täiendati olulisel määral küsimusi. Andmebaasi mõnede osade täiendamist oli võimalik hilisemaks lükata. Enne Moodle’i versioonile 2.7 üleminekut peab see versioonitäiendus olema lõpule viidud.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA salavõti';
$string['recaptchapublickey'] = 'ReCAPTCHA saidivõti';
$string['referrernone'] = 'Brauseri vaikeseade';
$string['referrerpolicy'] = 'Viitajate eeskirjad';
$string['referrerpolicydesc'] = 'Määra viitaja poliitika päis, mis lisatakse sinu saidi vastustele.';
$string['register'] = 'Registreeri oma sait';
$string['registration'] = 'Registreerimine';
$string['registration_help'] = 'Registreerides:

* Saadetakse sulle turvahoiatusi
* Saad aktiveerida oma saidilt mobiilirakenduse tõuketeatised
* Oled osa kogu maailma kogukonna Moodle\'i statistikast';
$string['registrationwarning'] = 'Teie sait pole veel registreeritud.';
$string['registrationwarningcontactadmin'] = 'Teie sait pole veel registreeritud. Teavitage oma administraatorit.';
$string['releasenoteslink'] = 'Selle Moodle’i versiooni kohta leiate lisateavet <a target="_new" href="{$a}">versioonimärkmete</a> lehelt.';
$string['rememberuserlicensepref'] = 'Ppea meeles kasutaja litsentsi eelistust';
$string['rememberuserlicensepref_help'] = 'Kui see on lubatud, valitakse faili valijas faili üleslaadimisel kasutaja poolt valitud viimane litsents. Vastasel juhul on vaikimisi saidilitsents eelnevalt valitud.';
$string['rememberusername'] = 'Jäta kasutajanimi meelde';
$string['rememberusername_desc'] = 'Lubage see säte, kui soovite kasutaja sisselogimise ajal talletada püsiküpsisefaile koos kasutajanimedega. Püsiküpsisefailid võivad ohustada privaatsust, kui neid kasutatakse ilma nõusolekuta.';
$string['reportsmanage'] = 'Halda aruandeid';
$string['required'] = 'Kohustuslik';
$string['requiredentrieschanged'] = 'Märkus. Pärast täiendamist rakendatakse säte „Nõutavad sissekanded enne vaatamist” järgmistes andmebaasi tegevustes: <br/>{$a-> text}<br/>';
$string['requiremodintro'] = 'Nõua Tegevuse kirjeldust';
$string['requiremodintro_desc'] = 'Kui see säte on lubatud, peavad kasutajad sisestama iga Tegevuse jaoks kirjelduse.';
$string['requires'] = 'Nõutav';
$string['restorecourse'] = 'Taasta kursus';
$string['restorernewroleid'] = 'Taastajate roll kursustes';
$string['restorernewroleid_help'] = 'Kui kasutajal pole veel äsja taastatud kursuse haldamise õigust, määratakse kasutajale automaatselt see roll ja vajaduse korral ta registreeritakse. Valige väärtus „Puudub“, kui te ei soovi, et taastajad saaksid iga taastatud kursust hallata.';
$string['resultfilter'] = 'Filtreeri tulemuse järgi';
$string['reverseproxy'] = 'Pöördpuhverserver';
$string['reverseproxyignore'] = 'Eirake vastupidiseid proksisid';
$string['riskconfig'] = 'Kasutajad saaksid muuta keskkonna konfiguratsiooni ja toimimist';
$string['riskconfigshort'] = 'Konfiguratsiooni risk';
$string['riskdataloss'] = 'Kasutajad saaksid kustutada suurtes kogustes sisu või teavet';
$string['riskdatalossshort'] = 'Andmekao oht';
$string['riskmanagetrust'] = 'Kasutajad saaksid muuta teiste kasutajate usaldusväärsuse sätteid';
$string['riskmanagetrustshort'] = 'Usalduste haldamine';
$string['riskpersonal'] = 'Kasutajad võivad saada juurdepääsu teiste kasutajate privaatteabele';
$string['riskpersonalshort'] = 'Privaatsusrisk';
$string['riskspam'] = 'Kasutajad võivad saata rämpsposti õpikeskkonna kasutajatele või teistele';
$string['riskspamshort'] = 'Spämmirisk';
$string['riskxss'] = 'Kasutajad võivad lisada faile ja tekste, mis võimaldab skriptisüste (XSS)';
$string['riskxssshort'] = 'XSS risk';
$string['roleswithexceptions'] = '{$a->roles}, {$a->exceptions}';
$string['rssglobaldisabled'] = 'Saidi tasemel mittevõimaldatud';
$string['save'] = 'Salvesta';
$string['savechanges'] = 'Salvesta muudatused';
$string['scssinvalid'] = 'SCSS-kood ei sobi, nurjub järgmisega: {$a}';
$string['search'] = 'Otsing';
$string['searchablecourses'] = 'Otsitavad kursused';
$string['searchallavailablecourses'] = 'Otsitavad kursused';
$string['searchallavailablecourses_desc'] = 'Mõnes olukorras ei pruugi otsimootor suurel hulgal kursustel otsimisel töötada. Vali otsitud kursuste arvu piiramiseks ainult registreerunud kursuste otsimine.';
$string['searchallavailablecourses_off'] = 'Otsi ainult kursusi millele oled registreerunud';
$string['searchallavailablecourses_on'] = 'Otsi kõigi kursuste seast kuhu kasutaja ligi pääseb';
$string['searchallavailablecoursesdesc'] = 'Kui seadete järgi on otsida ainult registreerunud kursustel, otsitakse kursuse teavet (nime ja kokkuvõtet) ning kursuse sisu ainult kursuste seat, kuhu kasutaja on registreerunud. Muidu otsitakse kursuse teavet ja kursuse sisu kõigilt kursustelt, millele kasutaja juurde pääseb. Näiteks kursused, kus külaliste juurdepääs on lubatud.';
$string['searchalldeleted'] = 'Kogu indekseeritud sisu on kustutatud';
$string['searchalternatesettings'] = 'Ainult päringutega alternatiivsed seaded';
$string['searchalternatesettings_desc'] = 'Kui oledneed seaded lõpule viinud, saad selle otsingumootori jaoks valida lehel „Üldise otsingu haldamine” ainult päringutega otsingumootori suvandis alternatiivsed seaded. See on kasulik ainult siis, kui liigud kahe sama tüüpi otsingumootori vahel.';
$string['searchareadisabled'] = 'Otsingu valdkond on keelatud';
$string['searchareaenabled'] = 'Otsingu valdkond on lubatud';
$string['searchareas'] = 'Otsingu valdkonnad';
$string['searchbanner'] = 'Otsingu teave';
$string['searchbannerenable'] = 'Kuva otsingu teave';
$string['searchbannerenable_desc'] = 'Kui see on lubatud, kuvatakse allpool olev tekst kõigi kasutajate jaoks otsingukuva ülaosas. Seda saab kasutada kasutajate teavitamiseks, kui otsingumootorit hooldatakse.';
$string['searchdefaultcategory'] = 'Vaikimisi otsimise kategooria';
$string['searchdefaultcategory_desc'] = 'Vaikimisi kuvatakse valitud otsingupiirkonna kategooria tulemused.';
$string['searchdeleteindex'] = 'Kustuta kogu indekseeritud sisu';
$string['searchdisplay'] = 'Otsingutulemite kuvamise valikud';
$string['searchenablecategories'] = 'Kuva tulemused eraldi kategooriates';
$string['searchenablecategories_desc'] = 'Kui see on lubatud, kuvatakse otsingutulemid eraldi kategooriates.';
$string['searchengine'] = 'Otsimootor';
$string['searchenginealternatesettings'] = '{$a} (alternatiivsed seaded)';
$string['searchenginequeryonly'] = 'Ainult päringutega otsingumootor';
$string['searchenginequeryonly_desc'] = 'Seda otsingumootorit kasutatakse ainult päringute tegemiseks, mitte indekseerimiseks. Selle funktsiooni abil saad uuesti indekseerida mõnes teises otsingumootoris, samal ajal kui kasutaja päringud töötavad selles otsingus edasi.';
$string['searchenginequeryonly_none'] = 'Puudub (kasuta päringuteks peamist otsingumootorit)';
$string['searchenginequeryonlysame'] = 'Ainult päringutega otsingumootorit ja peamist otsingumootorit ei saa seadistada samale väärtusele.';
$string['searchhideallcategory'] = 'Peida kategooria Kõik tulemused';
$string['searchhideallcategory_desc'] = 'Kui see on märgitud, peidetakse kõigi tulemustega kategooria otsingutulemite ekraanil.';
$string['searchincludeallcourses'] = 'Kaasa kõik nähtavad kursused';
$string['searchincludeallcourses_desc'] = 'Kui see on lubatud, sisaldavad otsingutulemused kasutajale nähtavat kursuste teavet (nimi ja kokkuvõte), isegi kui neil pole kursuse sisule juurdepääsu.';
$string['searchindexactions'] = 'Indekseerimise tegevused';
$string['searchindexdeleted'] = 'Indeks on kustutatud';
$string['searchindextime'] = 'Indekseerimise ajalimiit';
$string['searchindextime_desc'] = 'Suure hulga uue sisu indekseerimisel peatub ajastatud toiming pärast selle tähtaja saabumist. See jätkub järgmisel korral, kui ülesanne käivitatakse.';
$string['searchindexupdated'] = 'Otsimootori sisu on värskendatud';
$string['searchindexwhendisabled'] = 'Indeks, kui see on keelatud';
$string['searchindexwhendisabled_desc'] = 'Võimaldab plaanitud ülesandel luua otsinguindeksi ka siis, kui otsing on keelatud. See on kasulik, kui soovite luua indeksi enne, kui õpilastele otsinguvõimalus ilmub.';
$string['searchinsettings'] = 'Otsi sätetest';
$string['searchlastrun'] = 'Viimane käitus (aeg, dokumentide arv, kirjete arv, eiramiste arv)';
$string['searchmanagement'] = 'Otsingu haldamine';
$string['searchmanagement_desc'] = 'Need seaded on kasulikud muudatuste tegemisel saitidel, millel on väga suured otsinguindeksid ja mille ülesehitamine võtab kaua aega.';
$string['searchnotavailable'] = 'Otsing pole saadaval';
$string['searchoptions'] = 'Otsingu valikud';
$string['searchpartial'] = '(ei ole veel täielikult indekseeritud)';
$string['searchreindexed'] = 'Kogu saidi sisu on uuesti indekseeritud.';
$string['searchreindexindex'] = 'Indekseeri uuesti kogu saidi sisu';
$string['searchresults'] = 'Otsingutulemid';
$string['searchsetupinfo'] = 'Otsingu häälestus';
$string['searchupdateindex'] = 'Värskenda indekseeritud sisu';
$string['sectionerror'] = 'Jaotisetõrge!';
$string['secureforms'] = 'Kasuta täiendavat vormiturvet';
$string['security'] = 'Turve';
$string['selectsearchengine'] = 'Vali otsimootor';
$string['server'] = 'Server';
$string['serverchecks'] = 'Serverikontrollid';
$string['serverlimit'] = 'Serverilimiit';
$string['sessionautostartwarning'] = '<p>Ilmnes raske konfiguratsioonitõrge, teavitage administraatorit.</p><p> Moodle’i õigeks toimimiseks on vaja, et administraator muudaks PHP sätteid.</p><p><code>session.auto_start</code> peab olema <code>välja lülitatud</code>.</p><p>Seda sätet saab muuta failis <code>php.ini</code>, Apache/IIS <br />konfiguratsioon või serveris fail <code>.htaccess</code>.</p>';
$string['sessioncookie'] = 'Küpsisefaili prefiks';
$string['sessioncookiedomain'] = 'Küpsisefaili domeen';
$string['sessioncookiepath'] = 'Küpsisefaili tee';
$string['sessionhandling'] = 'Seansikäitlus';
$string['sessiontimeout'] = 'Ajalõpp';
$string['settingdependenton'] = 'See säte võib <strong> {$a} </strong> väärtuse põhjal olla peidetud.';
$string['settingfileuploads'] = 'Failide üleslaadimine peab olema lubatud PHP-konfiguratsioonis.';
$string['settingmemorylimit'] = 'Mälu pole piisavalt, suurendage PHP mälulimiidi sätete väärtusi.';
$string['settingsafemode'] = 'Moodle ei ühildu turvarežiimiga täielikult, paluge serveriadministraatoril turberežiim välja lülitada. Moodle’i toimimist turvarežiimis ei toetata, võib esineda mitmesuguseid probleeme.';
$string['setupsearchengine'] = 'Häälesta otsimootor';
$string['showcommentscount'] = 'Kuva kommentaaride arv';
$string['showdetails'] = 'Kuva üksikasjad';
$string['showuseridentity'] = 'Kuva kasutaja identiteet';
$string['showuseridentity_desc'] = 'Kasutajate valimisel või otsimisel ja kasutajate loendite kuvamisel võidakse lisaks kasutaja täisnimele kuvada need väljad. Väljad kuvatakse ainult kasutajatele, kel on tegevusluba moodle/site:viewuseridentity; vaikimisi on nendeks õpetajad ja haldurid. (See valik on kõige kasulikum siis, kui valite üks või kaks välja, mis on teie asutuses kohustuslikud.)';
$string['simplexmlrequired'] = 'Moodle nõuab nüüd SimpleXML PHP laiendust.';
$string['sitemailcharset'] = 'Märgistik';
$string['sitemaintenance'] = 'Õpikeskkond pole praegu hooldustööde tõttu saadaval';
$string['sitemaintenancemode'] = 'Hooldusrežiim';
$string['sitemaintenanceoff'] = 'Hooldusrežiim on keelatud ja õpikeskkond töötab jälle tavapäraselt';
$string['sitemaintenanceon'] = 'Teie õpikeskkond on praegu hooldusrežiimis (ainult administraatorid saavad õpikeskkonda sisse logida ja seda kasutada)';
$string['sitemaintenanceoncli'] = 'Sinu keskkond on praegu käsurealiidese hooldusrežiimis, veebijuurdepääs on keelatud';
$string['sitemaintenancetitle'] = '{$a} hoolduse all';
$string['sitemaintenancewarning'] = 'Sinu õpikeskkond on hetkel hooldusrežiimis(ainult administraatorid saavad siseneda). Et pöörduda tagasi normaalsesse olekusse, <a href="maintenance.php">lülita hooldusrežiim välja</a>.';
$string['sitemaintenancewarning2'] = 'Keskkond on praegu hooldusrežiimis(ainult administraatorid saavad sisse logida). Selleks, et keskkond töötaks jälle tavapäraselt, <a href="{$a}">keelake hooldusrežiim</a>.';
$string['sitemenubar'] = 'Saidi navigeerimine';
$string['sitepolicies'] = 'Õpikeskkonna kasutuspõhimõtted';
$string['sitepolicy'] = 'Õpikeskkonna kasutuspõhimõtete URL';
$string['sitepolicy_help'] = 'Saidipoliitika URL, mida kõik registreeritud kasutajad peavad enne saidile pääsemist nägema ja sellega nõustuma. Pane tähele, et see säte avaldab mõju ainult siis, kui saidipoliitika käitleja on vaikimisi (tuum).';
$string['sitepolicyguest'] = 'Külalistele mõeldud õpikeskkonnapõhimõtete URL';
$string['sitepolicyguest_help'] = 'Kui teie õpikeskkonnas on kindlaks määratud põhimõtted, millega kõik külaliskasutajad peavad enne tutvuma ja nõustuma, siis sisestage siin vastav veebiaadress, muudel juhtudel jätke see väli tühjaks. See väli võib sisaldada mis tahes avalikku veebiaadressi. Märkus. Sisselogimata kasutajate juurdepääsu saab keelata sundsisselogimise sättega.';
$string['sitepolicyhandler'] = 'Saidipoliitika käitleja';
$string['sitepolicyhandler_desc'] = 'See määrab kindlaks, kuidas reegleid ja kasutaja nõusolekuid hallatakse. Vaikimisi (tuum) töötleja lubab külalistele saidi poliitika URL-i ja saidi poliitika URL-i täpsustada. Poliitikareeglid võimaldavad seadistada saidi, privaatsuse ja muid põhimõtteid. Samuti võimaldab see vaadata kasutajate nõusolekuid ja vajadusel anda alaealiste nimel nõusoleku.';
$string['sitepolicyhandlercore'] = 'Vaikimise (tuum)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Kui see ruut on märgitud, siis kuvatakse teemajaotis õpikeskkonna esilehel';
$string['sixtyfourbitswarning'] = 'On tuvastatud, et sinu sait ei kasuta 64-bitist PHP-versiooni. Tulevase ühilduvuse tagamiseks on soovitatav oma saiti täiendada.';
$string['slasharguments'] = 'Kasuta kaldkriipsargumente';
$string['slashargumentswarning'] = 'Soovitame, et kaldkriipsargumentide kasutamine oleks lubatud. Tulevikus on see kohustuslik. Lisateabe saamiseks lugege dokumentatsiooni <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Kaldkriipsargumentide kasutamine</a>.';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP autentimistüüp';
$string['smtpdetail'] = 'Lihtsa meiliedastusprotokolli (SMTP) meilisõnumite saatmise sätted.';
$string['smtphosts'] = 'SMTP hostid';
$string['smtpmaxbulk'] = 'SMTP seansi limiit';
$string['smtppass'] = 'SMTP parool';
$string['smtpsecure'] = 'SMTP turve';
$string['smtpuser'] = 'SMTP konto';
$string['soaprecommended'] = 'Valikulise SOAP-laienduse installimine toob kasu veebiteenustele ja mõnele lisandmoodulile.';
$string['sort_fullname'] = 'Kursuse täisnimi';
$string['sort_idnumber'] = 'Kursuse ID';
$string['sort_shortname'] = 'Kursuse lühinimi';
$string['sort_sortorder'] = 'Sortimisjärjestus';
$string['spellengine'] = 'Õigekirjamootor';
$string['spelllanguagelist'] = 'Kontrolli keelte loendi õigekirja';
$string['splrequired'] = 'Moodle nõuab nüüd SPL PHP laiendust.';
$string['stats'] = 'Statistika';
$string['statsfirstrun'] = 'Maksimaalne töötlusintervall';
$string['statsmaxruntime'] = 'Maksimaalne käitusaeg';
$string['statsmoodleorg'] = 'statistika';
$string['statsruntimedays'] = 'Töötluspäevade arv';
$string['statsruntimestart'] = 'Alustamise kellaaeg';
$string['statsuserthreshold'] = 'Kasutajate lävi';
$string['stickyblocks'] = 'Kleepplokid';
$string['stickyblockscourseview'] = 'Kursuse leht';
$string['stickyblocksduplicatenotice'] = 'Kui mõni siia lisatud plokk on konkreetsel lehel juba olemas, on tulemuseks duplikaat. <br /> Ainult kinnitatud plokki ei saa redigeerida, duplikaati saab siiski redigeerida.';
$string['stickyblocksmymoodle'] = 'Minu Moodle';
$string['stickyblockspagetype'] = 'Seadistava lehe tüüp';
$string['strictformsrequired'] = 'Nõutavate väljade range valideerimine';
$string['stripalltitletags'] = 'Eemalda HTML-sildid kõigist tegevusenimedest';
$string['supportcontact'] = 'Kasutajatoe kontakt';
$string['supportemail'] = 'Kasutajatoe e-posti aadress';
$string['supportemailsubject'] = 'Kasutajatugi - {$a}';
$string['supportname'] = 'Kasutajatoe nimi';
$string['supportpage'] = 'Kasutajatoe veebileht';
$string['suspenduser'] = 'Peata kasutajakonto';
$string['switchlang'] = 'Vaheta keelekausta';
$string['systempaths'] = 'Süsteemiteed';
$string['tablenosave'] = 'Ülalolevas tabelis tehtud muudatused salvestatakse automaatselt.';
$string['tablesnosave'] = 'Ülaltoodud tabelite muudatused salvestatakse automaatselt.';
$string['tabselectedtofront'] = 'Kas sakkidega tabelite puhul peaks hetkel valitud sakiga rida paigutuma esiplaanile?';
$string['tabselectedtofronttext'] = 'Too valitud sakirida ette';
$string['task_adhoc_concurrency_limit'] = 'Ad hoc ülesannete samaegsuse limiit';
$string['task_adhoc_concurrency_limit_desc'] = 'Ad hoc ülesannete täitjate arv, kes saavad samaaegselt toimetada. Kui limiit on kõrge, ei pruugi plaanilised toimingud regulaarselt kulgeda, kui ad hoc ülesandeid on palju. Seade 0 keelab ajutiste toimingute töötlemise täielikult.';
$string['task_adhoc_max_runtime'] = 'Ad hoc ülesannete jooksutamise eluaeg';
$string['task_adhoc_max_runtime_desc'] = 'Ad hoc ülesande täitja pikkus enne selle vabanemist. Soovitatav on väike kestus, kuna järjekorda pandud ajutiste ülesannete arv pole piiratud. Kui see arv on liiga suur ja sul on suur ajutiste ülesannete järjekord, ei pruugi plaanitud toiminguid regulaarselt käivitada.';
$string['task_dbstats'] = 'Andmebaas';
$string['task_duration'] = 'Kestus';
$string['task_logmode'] = 'Millal logida';
$string['task_logmode_all'] = 'Salvesta  kõigi tööde logiväljund';
$string['task_logmode_desc'] = 'Saad valida, millal soovid toimingute logimist. Vaikimisi püütakse logisid alati salvestada. Logimise saate täielikult keelata või muuta nii, et salvestatakse ainult ebaõnnestunud logiülesanded.';
$string['task_logmode_failonly'] = 'Salvesta logisid ainult ebaõnnestunud tööde kohta';
$string['task_logmode_none'] = 'Ära logi midagi';
$string['task_logretainruns'] = 'Säilita jooksutamises';
$string['task_logretainruns_desc'] = 'Iga säilitatava ülesande jookstamiste arv. See säte suhtleb seadega „Säilitamisperiood”: rakendub see, kumb saavutatakse varem.';
$string['task_logretention'] = 'Säilitamise aeg';
$string['task_logretention_desc'] = 'Maksimaalne periood, mille jooksul logisid tuleks säilitada. See seade on seotud sättega „Jätka jooksutamist”: see, kumb jõuab lõppu esimesena, kehtib';
$string['task_logtostdout'] = 'Näita logisid';
$string['task_logtostdout_desc'] = 'Kui tööd käivad ja väljund on hõivatud, kas ülesande käivitamisel peaks ka jäädvustatud väljundit kuvama.';
$string['task_result'] = 'Tulemus';
$string['task_result:failed'] = 'Nurjunud';
$string['task_scheduled_concurrency_limit'] = 'Planeeritud ülesande samaaegsuse limiit';
$string['task_scheduled_concurrency_limit_desc'] = 'Planeeritud ülesannete täitjate arv, kes saavad samaaegselt toimetada. Kui limiit on kõrge, võib server kogeda suurt koormust, mis mõjutab jõudlust. Seade 0 keelab ajastatud toimingute töötlemise täielikult.';
$string['task_scheduled_max_runtime'] = 'Planeeritud ülesande jooksutaja eluiga';
$string['task_scheduled_max_runtime_desc'] = 'Kavandatud jooksutaja vanus enne vabastamist.';
$string['task_starttime'] = 'Algusaeg';
$string['task_stats:dbreads'] = '{$a} lugemist';
$string['task_stats:dbwrites'] = '{$a} kirjutamist';
$string['task_type:adhoc'] = 'ad hoc';
$string['task_type:scheduled'] = 'Ajastatud';
$string['taskadmintitle'] = 'Tegevused';
$string['taskanalyticscleanup'] = 'Analüütika puhastamine';
$string['taskautomatedbackup'] = 'Automaatsed varukoopiad';
$string['taskbackupcleanup'] = 'Puhasta varundustabelid ja -logid';
$string['taskbadgescron'] = 'Anna õpimärgid välja';
$string['taskbadgesmessagecron'] = 'Tausttöötlus märkide teatiste saatmiseks';
$string['taskblogcron'] = 'Sünkrooni välised blogid';
$string['taskcachecleanup'] = 'Eemalda aegunud vahemälukirjed';
$string['taskcachecron'] = 'Vahemälude tausttöötlus';
$string['taskcalendarcron'] = 'Saada kalendriteatised';
$string['taskcheckforupdates'] = 'Otsi värskendusi';
$string['taskcompletiondaily'] = 'Märgi ülesanne alustatuks';
$string['taskcompletionregular'] = 'Arvuta tavalised lõpuleviimisandmed';
$string['taskcontextcleanup'] = 'Puhasta kontekstid';
$string['taskcreatecontexts'] = 'Loo puuduvad kontekstid';
$string['taskdeleteincompleteusers'] = 'Kustuta mittetäielikult registreerunud kasutajad';
$string['taskdeleteunconfirmedusers'] = 'Kustuta kinnitamata kasutajad';
$string['taskeventscron'] = 'Sündmuste tausttöötlus';
$string['taskfiletrashcleanup'] = 'Eemalda prügikastis olevad failid';
$string['taskglobalsearchindex'] = 'Üldotsingu indekseerimine';
$string['taskglobalsearchoptimize'] = 'Üldotsingu indeksi optimeerimine';
$string['taskgradecron'] = 'Hinnetelehe tausttöötlus';
$string['taskgradehistorycleanup'] = 'Tausttöötlus hinnete ajalootabelite puhastamiseks';
$string['tasklegacycron'] = 'Lisandmoodulite pärandcron-funktsiooni töötlus';
$string['tasklogcleanup'] = 'Puhasta tegevuste logimised';
$string['tasklogging'] = 'Tegevuste logimiste sätted';
$string['tasklogs'] = 'Tegevuste logid';
$string['taskmessagingcleanup'] = 'Sõnumside tausttöötlus';
$string['taskpasswordresetcleanup'] = 'Eemalda parooli lähtestamise katsed';
$string['taskplagiarismcron'] = 'Pärandcron-funktsiooni tausttöötlus plagiaatlusvastastes lisandmoodulites';
$string['taskportfoliocron'] = 'Mapilisandmoodulite tausttöötlus';
$string['taskprocessing'] = 'Tegevuste protsessimine';
$string['taskquestioncron'] = 'Tausttöötlus küsimuste eelvaadete puhastamiseks';
$string['taskquestionstatscleanupcron'] = 'Tausttöötlus küsimuste statistika vahemälu puhastamiseks';
$string['taskrefreshsystemtokens'] = 'Värskenda teenusekontode OAuth-tõendid';
$string['taskregistrationcron'] = 'Saidi registreerimine';
$string['tasksendfailedloginnotifications'] = 'Saada nurjunud sisselogimiste teatised';
$string['tasksendnewuserpasswords'] = 'Saada uued kasutaja paroolid';
$string['tasksessioncleanup'] = 'Eemalda vanad seansid';
$string['taskstatscron'] = 'Statistika tausttöötlus';
$string['tasktagcron'] = 'Siltide tausttöötlus';
$string['tasktempfilecleanup'] = 'Kustuta vananenud ajutised failid';
$string['tasktype'] = 'Tüüp';
$string['tempdatafoldercleanup'] = 'Eemalda ajutised andmefailid, mis on vanemad kui';
$string['templates'] = 'Mallid';
$string['testoutgoingmailconf'] = 'Testi väljaminevate mailide seadeid';
$string['testoutgoingmailconf_errorcommunications'] = 'Sinu sait ei saanud sinu e-posti serveriga ühendust. Kontrolli oma väljamineva e-posti konfiguratsiooni.';
$string['testoutgoingmailconf_message'] = 'See on kontrollsõnum, mis kinnitab, et oled oma saidi väljaminevad kirjad edukalt konfigureerinud.';
$string['testoutgoingmailconf_sendtest'] = 'Saada test sõnum';
$string['testoutgoingmailconf_sentmail'] = 'See sait on meiliserverile saatnud edukalt kontrollsõnumi. <br /> Saatja: {$a-> fromemail} <br /> Adressaat: {$a-> toemail}';
$string['testoutgoingmailconf_subject'] = '{$a}: test sõnum';
$string['testoutgoingmailconf_toemail'] = 'E-maili aadressile';
$string['testoutgoingmaildetail'] = 'Märkus. Enne testimist palun salvesta oma konfiguratsioon. <br /> {$a}';
$string['testsiteupgradewarning'] = 'Kasutate hetkel testõpikeskkonda {$a}, selle versiooni täiendamiseks kasutage käsurea liidese tööriista';
$string['themedesignermode'] = 'Kujundusrežiim';
$string['themedesignermodewarning'] = 'Kujundusrežiim on lubatud. Töösaitidel ei tohiks kujundusrežiimi lubada, sest see võib märgatavalt vähendada jõudlust.';
$string['themelist'] = 'Kujunduste loend';
$string['themeresetcaches'] = 'Puhasta kujunduste vahemälu';
$string['themeselect'] = 'Muuda kujundust';
$string['themeselector'] = 'Kujunduseselektor';
$string['therewereerrors'] = 'Sinu andmetes ei olnud vigu';
$string['thirdpartylibrary'] = 'Teek';
$string['thirdpartylibrarylocation'] = 'Asukoht';
$string['thirdpartylibs'] = 'Kolmanda osapoole teegid';
$string['timezone'] = 'Vaikeajavöönd';
$string['timezoneforced'] = 'See on sunnitud õpikeskkonna administraatori poolt';
$string['timezoneinvalid'] = 'Sobimatu ajavöönd „{$a}“';
$string['timezoneisforcedto'] = 'Sunni kõiki kasutajaid kasutama';
$string['timezonenotforced'] = 'Kasutajad saavad oma ajavööndi ise valida';
$string['timezonephpdefault'] = 'PHP vaikeajavöönd ({$a})';
$string['timezoneserver'] = 'Serveri ajavöönd ({$a})';
$string['tlswarning'] = 'Ei tuvastatud ühtegi TLSv1.2-toega PHP/cURL-i lisandmoodulit. Mõni teenus ei pruugi töötada. Soovitatav on värskendada TLS-i teeke.';
$string['tokenduration'] = 'Kasutaja loodud tokeni kestvus';
$string['tokenduration_desc'] = 'Ajavahemik, mille jooksul kasutaja loodud veebiteenuste tunnus (näiteks mobiilirakenduse kaudu) kehtib.';
$string['tokenizerrecommended'] = 'Valikulise PHP Tokenizeri laienduse installimine on soovitatav – sellega parandatakse Moodle’i võrgufunktsiooni.';
$string['tools'] = 'Administraatori tööriistad';
$string['toolsmanage'] = 'Halda administraatori tööriistu';
$string['unattendedoperation'] = 'Ära kuva tegevusi';
$string['unbookmarkthispage'] = 'Eemalda see leht järjehoidjate hulgast';
$string['unicoderequired'] = 'Kõik andmed peate talletama Unicode’i vormingus (UTF-8) . Uued installid peavad olema tehtud andmebaasi, mille vaikevorming on Unicode. Moodle’i versiooniuuenduse korral peaksite tegema UTF-8 migreerimisprotsessi (vt administraatori lehte).';
$string['uninstallplugin'] = 'Desinstalli';
$string['unlockaccount'] = 'Ava konto';
$string['unoconvwarning'] = 'Installitud unoconv-i versioon pole toetatud.';
$string['unsupported'] = 'Ei toetata';
$string['unsupporteddbfileformat'] = 'Teie andmebaasis on tabeleid, mille failivorminguks on Antelope. MySQL-is ja MariaDB-s nõuab täielik UTF-8-tugi failivormingut Barracuda. Teisendage tabelid failivormingusse Barracuda. Lisateavet tööriista kohta, mis võimaldab InnoDB-tabelid teisendada failivormingusse Barracuda, leiate dokumentatsioonist <a href="https://docs.moodle.org/en/cli">Haldamine käsurea kaudu</a>.';
$string['unsupporteddbfilepertable'] = 'Kui soovite UTF-8 täielikku tuge peate nii MySQL-i kui ka MariaDB jaoks määrama oma MySQL-i sätte „innodb_file_per_table“ väärtuseks „ON“ (Sees). Täpsemat teavet leiate dokumentatsioonist.';
$string['unsupporteddblargeprefix'] = 'Kui soovite UTF-8 täielikku tuge peate nii MySQL-i kui ka MariaDB jaoks määrama oma MySQL-i sätte „innodb_large_prefix“ väärtuseks „ON“ (Sees). Täpsemat teavet leiate dokumentatsioonist.';
$string['unsupporteddbstorageengine'] = 'Kasutatavat andmebaasi salvestusruumi mootorit enam ei toetata.';
$string['unsupporteddbtablerowformat'] = 'Teie andmebaasis on tabeleid, mille failivorminguks on Antelope. Soovitatav on tabelid teisendada failivormingusse Barracuda. Lisateavet tööriista kohta, mis võimaldab InnoDB-tabelid teisendada failivormingusse Barracuda, leiate dokumentatsioonist <a href="https://docs.moodle.org/en/cli">Haldamine käsurea kaudu</a>.';
$string['unsupportedphpversion7'] = 'PHP versioon 7 pole toetatud.';
$string['unsupportedphpversion71'] = 'PHP versioon 7.1 pole toetatud.';
$string['unsupportedphpversion72'] = 'PHP versioon 7.2 pole toetatud';
$string['unsupportedphpversion73'] = 'PHP versioon 7.3 pole toetatud';
$string['unsupportedphpversion74'] = 'PHP versioon 7.4 pole toetatud';
$string['unsuspenduser'] = 'Aktiveeri kasutajakonto';
$string['updateaccounts'] = 'Uuenda olemas olevaid kontosid';
$string['updateautocheck'] = 'Otsi saadaolevaid värskendusi automaatselt';
$string['updateautocheck_desc'] = 'Kui see säte on lubatud, otsib teie õpikeskkond automaatselt nii Moodle’i koodi kui ka kõikide täiendavate lisandmoodulite jaoks saadaolevaid värskendusi. Kui uus värskendus on saadaval, saadetakse vastav teatis õpikeskkonna administraatoritele.';
$string['updateavailable'] = 'Saadaval on Moodle’i uus versioon!';
$string['updateavailable_moreinfo'] = 'Rohkem teavet...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Versioon {$a}';
$string['updateavailabledetailslink'] = 'Üksikasjalikumat teavet leiate veebilehelt {$a->url}';
$string['updateavailableforplugin'] = 'Saadaval on mõne teie kasutatava lisandmooduli uus versioon.';
$string['updateavailableinstall'] = 'Installi see värskendus';
$string['updateavailableinstallall'] = 'Installi saadaolevad värskendused ({$a})';
$string['updateavailableinstallallhead'] = 'Saadaolevate värskenduste installimine';
$string['updateavailablenot'] = 'Teie Moodle’i kood on ajakohane.';
$string['updateavailablerecommendation'] = 'Õpikeskkonna uusimale versioonile üleminek on tungivalt soovitatav ning võimaldab hankida kõik viimatised turbe- ja veaparandused.';
$string['updatecomponent'] = 'Värskenda komponenti';
$string['updateminmaturity'] = 'Nõutava koodi küpsus';
$string['updateminmaturity_desc'] = 'Saadaolevate värskenduste kohta saadetakse teatis ainult siis, kui saadaoleval koodil on vähemalt valitud küpsustase. Koodi küpsustaset mittedeklareerivate lisandmoodulite värskendustest antakse hoolimata sellest sättest alati teada.';
$string['updatenotificationfooter'] = 'Teie Moodle’i õpikeskkond {$a->siteurl} on konfigureeritud saadaolevaid värskendusi automaatselt otsima. Saite selle teate kui õpikeskkonna administraator. Saate saadaolevate värskenduste automaatse otsimise keelata ploki Haldus jaotises Õpikeskkonna haldamine. Saate selle sõnumi kohaletoimetamist kohandada eelistuste lehe kaudu.';
$string['updatenotifications'] = 'Värskenduste teavitused';
$string['updatenotificationsubject'] = 'Moodle’i värskendused on saadaval veebilehel ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Teavita uutest järkudest';
$string['updatenotifybuilds_desc'] = 'Kui see säte on lubatud, antakse Moodle’i koodi jaoks saadaolevast värskendusest teada ka siis, kui saadaval on praeguse versiooni uus järk. Järgud on kindla Moodle’i versiooni pidevad täiustused. Neid antakse tavaliselt välja iga nädal. Kui see on keelatud, antakse saadaolevast värskendusest teada ainult siis, kui Moodle’i uuem versioon on välja antud. See säte ei mõjuta lisandmoodulite värskenduste kontrollimist.';
$string['upgradeerror'] = 'Lisandmooduli {$a->plugin} versiooni uuendamisel versiooniks {$a->version} ilmnes tundmatu tõrge, ei saa jätkata.';
$string['upgradeforumread'] = 'Moodle 1.5-le on lisatud võimalus jälgida loetud/lugemata foorumipostitusi.<br />Selle võimaluse kasutamiseks pead a href="{$a}">uuendama oma tabeleid</a>.';
$string['upgradeforumreadinfo'] = 'Moodle 1.5-le on lisatud võimalus jälgida loetud/lugemata foorumipostitusi. Selle võimaluse kasutamiseks pead uuendama oma tabeleid kogu olemasolevate postituste jälgimisinfoga. Sõltuvalt sinu veebilehe suurusest võib see võtta kaua aega (tunde) ja võib olla küllaltki koormav andmebaasile, nii et uuendust on soovitatav teha rahulikul perioodil. Sinu veebileht jätkab uuenduste tegemise ajal töötamist ja kasutajaid see ei mõjuta. Kui uuenduse protsess on käivitatud, peaks laskma tal lõpetada (hoides veebilehitseja akna lahti). Aga kui sa ka peatad protsessi, sulgedes akna, siis ära muretse, sa saad algusest peale hakata.<br /><br />Kas soovid nüüd alustada uuendamisega?';
$string['upgradekeyreq'] = 'Versioonitäienduse võti on nõutav';
$string['upgradekeyset'] = 'Versioonitäienduse võti (jätke tühjaks, kui te ei soovi seda määrata)';
$string['upgradelogs'] = 'Täisfunktsionaalsuse saavutamiseks pead vanad logid uuendama. <a href="{$a}">Rohkem informatsiooni</a>';
$string['upgradelogsinfo'] = 'Logide säilitamise seadetesse on tehtud muudatusi. Et vaadata kõiki vanu logisid tegevuste põhjal, peab  vanu logisid uuendama. Olenevalt leheküljest võib see kaua aega võtta (isegi tunde) ja võib olla suhteliselt koormav suurte andmebaasidega lehtedele. Kui see protsess on käivitatud, peaks laskma tal lõpetada (hoides veebilehitseja akna lahti). Ära muretse - veebileht töötab korralikult teistele inimestele, kui logisid uuendatakse.<br /><br />Kas soovid logisid uuendada?';
$string['upgradepluginsfirst'] = 'Soovitatav on esmalt installida kõik saadaolevad värskendused';
$string['upgradepluginsinfo'] = 'Lisandmoodulite värskendamine';
$string['upgradepluginsinfo_help'] = 'Osade teie lisandmoodulite jaoks on saadaval värskendused. Peaksite kõik need installima enne Moodle’i andmebaasi versiooni täiendamist. Kui teie õpikeskkond ei toeta automaatsete värskenduste juurutamist, peate uued lisandmoodulite versioonid serverisse käsitsi alla laadima ja installima.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Uued sätted';
$string['upgradesettingsintro'] = 'Allpool kuvatud sätted lisati Moodle’i viimase versiooniuuenduse käigus. Muutke vaikesätteid vastavalt soovile ja klõpsake seejärel lehe allservas nuppu Salvesta muudatused.';
$string['upgradestalefiles'] = 'Tuvastati erinevad Moodle’i versioonid, versiooniuuendust ei saa jätkata';
$string['upgradestalefilesinfo'] = 'Moodle’i värskendamine on peatatud, sest Moodle’i kataloogis tuvastati vähemalt kahest Moodle’i põhiversioonist pärit PHP-skriptid.

See võib hiljem põhjustada tõsiseid probleeme, mistõttu peate jätkamiseks veenduma, et Moodle’i kataloog sisaldaks ainult ühe Moodle’i versiooni faile.

Soovitatav viis Moodle’i kataloogi puhastamiseks on järgmine.

* Pange praegusele Moodle’i kataloogile nimeks „moodle_old“
* Looge uus Moodle’i kataloog, mis sisaldab ainult standardse Moodle’i paketi allalaadimisest või Moodle’i Giti hoidlast pärit faile
* Teisaldage algne „config.php“ fail ja kõik ebastandardsed lisandmoodulid kataloogist „moodle_old“ uude Moodle’i kataloogi.

Kui Moodle’i kataloog on puhastatud, värskendage seda lehte, et jätkata Moodle’i värskendamist.

Sageli on selle hoiatuse põhjuseks standardse Moodle’i paketi lahtipakkimine eelmise Moodle’i versiooni asemele. Kuigi seda võib teha väiksemate versioonitäienduste puhul, on see suurte Moodle’i versioonitäienduste puhul tungivalt ebasoovitatav.

Selle hoiatuse põhjuseks võib olla ka lõpetamata väljaregistreerimine või värskendamine Giti hoidla kaudu. Sellisel juhul peate võib-olla lihtsalt ootama, kuni toiming lõpule viiakse, või käivitama sobiva puhastuskäsu ja proovima toimingut uuesti sooritada.

Lisateavet leiate versioonitäienduse dokumentatsioonist aadressil <a href="{$a}">{$a}</a>.';
$string['upgradestart'] = 'Uuenda Moodle’i andmebaasi versiooni kohe';
$string['upgradesure'] = '<p>Teie Moodle’i faile on muudetud ja soovite oma serveri versiooni automaatset uuendamist sellele versioonile:</p>
<p><strong>{$a}</strong></p>
<p>Kui olete uuendamist alustanud, ei saa enam tagasi minna. Arvestage, et see protsess võib võtta kaua aega.</p>
<p>Kas soovite kindlasti uuele serveriversioonile üle minna?</p>';
$string['upgradetimedout'] = 'Versiooniuuendus nurjus, proovige uuesti';
$string['upgradingdata'] = 'Andmete uuendamine';
$string['upgradinglogs'] = 'Logide uuendamine';
$string['upgradingversion'] = 'Uuendamine uuele versioonile';
$string['upwards'] = 'ülespoole';
$string['useblogassociations'] = 'Luba seosed';
$string['user'] = 'Kasutaja';
$string['userbulk'] = 'Kasutajatega seotud hulgitoimingud';
$string['userbulkdownload'] = 'Ekspordi kasutajaid kui';
$string['userdefaultpreferences'] = 'Kasutaja vaike-eelistused';
$string['userfeedbackafterupgrade'] = 'Pärast iga suuremat täiendamist';
$string['userfeedbackencouragement'] = '<p> Moodle 3.9 sisaldab uut funktsiooni, mis annab kasutajatele võimaluse anda Moodle\'i peakorterile tagasisidet Moodle\'i tarkvara kohta. Seda tehakse Moodle\'i peakorteri poolt hallatud välise uuringusaidi kaudu. Uuringu saidile ei edastata kasutajat tuvastavat teavet. </p>
<p> Moodle\'i peakorter püüab oma andmete kogumise reeglitega olla avatud ja läbipaistev. Seega soovime olla kindlad, et oled sellest funktsioonist teadlik ja omad selle üle kontrolli. </p>
<p> Kasutajate tagasiside aitab Moodle\'i peakorterit oluliselt kaasa Moodle\'i tarkvara täiustamisel. Selle funktsiooni lubamiseks ava <a href="{$a}"> Tagasiside seaded </a>.</p>';
$string['userfeedbacknextreminder'] = 'Järgmine tagasiside meeldetuletus';
$string['userfeedbacknextreminder_desc'] = 'Millal peaksime paluma kasutajal uuesti tagasisidet anda?';
$string['userfeedbackperiodically'] = 'Perioodiliselt';
$string['userfeedbackremindafter'] = 'Näita meeldetuletust peale';
$string['userfeedbackremindafter_desc'] = 'Tuleta kasutajatele uuesti meelde, et nad annaksid pärast sättes määratud päevade arvu tagasisidet.';
$string['userfiltersdefault'] = 'Vaike kasutajafiltrid';
$string['userfiltersdefault_desc'] = 'Vali filtrid, mida tuleks kuvada lehel \'Sirvi kasutajate loendit\' ja \'Lehe hulgitoimingud\'. Mitme üksuse valimiseks hoia all Ctrl-klahvi. Kõik filtrid, mida pole valitud, on saadaval, klõpsates lingil Kuva rohkem.';
$string['userimagesdisabled'] = 'Profiili kasutajapildid on keelatud';
$string['userlist'] = 'Sirvi kasutajate loendit';
$string['usermanagement'] = 'Kasutajate haldus';
$string['userpolicies'] = 'Kasutajaõigused';
$string['userpreference'] = 'Kasutajaeelistused';
$string['userquota'] = 'Privaatsete failide ruum';
$string['userquota_desc'] = 'Maksimaalne andmemaht, mida iga kasutaja saab oma privaatsete failide ala salvestada.';
$string['users'] = 'Kasutajad';
$string['usesitenameforsitepages'] = 'Kasuta õpikeskkonna nimi õpikeskkonna lehtede jaoks';
$string['usetags'] = 'Luba siltide funktsionaalsus';
$string['validateemptylineerror'] = 'Tühjad read pole sobivad';
$string['validateerror'] = 'See väärtus ei sobi';
$string['validateerrorlist'] = 'Järgmised sissekanded on sobimatud: {$a}';
$string['validateiperror'] = 'Järgmised IP-aadressid on sobimatud: {$a}';
$string['verifychangedemail'] = 'Keela meilivahetuse korral domeenid';
$string['warningcurrentsetting'] = 'Praegune väärtus ei sobi: {$a}';
$string['warningiconvbuggy'] = 'Teie iconv-teegi versioon ei toeta muutjat //IGNORE. Peaksite installima mbstring-laiendi, mida saab hoopis kasutada selliste stringide eemaldamiseks, mis sisaldavad sobimatuid UTF-8 märke.';
$string['webproxy'] = 'Veebipuhverserver';
$string['webproxyinfo'] = 'Täitke järgmised valikud, kui Moodle’i server ei saa Interneti-ühendust luua. Interneti-ühendust on vaja uute andmete, keelepakettide, RSS-kanalite, ajavööndite jm allalaadimiseks.<br /><em>Laiendus PHP cURL on tungivalt soovitatav.</em>';
$string['yuicomboloading'] = 'YUI laadimine';
$string['ziprequired'] = 'Moodle nõuab nüüd ZIP PHP laiendust. Info-ZIP binaarvormingut või PclZip-teeke enam ei kasutata.';
