<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'factor_sms', language 'no', version '5.1'.
 *
 * @package     factor_sms
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:manage'] = 'Administrer mobilnummer';
$string['action:revoke'] = 'Fjern mobilnummer';
$string['addnumber'] = 'Mobilnummer';
$string['clientnotfound'] = 'AWS-tjenesteklienten ble ikke funnet. Klienten må være et fullstendig kvalifisert klassenavn, f.eks. \\Aws\\S3\\S3Client.';
$string['editphonenumber'] = 'Rediger mobilnummer';
$string['editphonenumberinfo'] = 'Hvis du ikke mottok koden eller skrev inn feil telefonnumer, vennligst endre telefonnummer og prøv på nytt.';
$string['error:emptyverification'] = 'Tom kode. Prøv på nytt';
$string['error:wrongphonenumber'] = 'Telefonnummer har ikke et gyldig format';
$string['error:wrongverification'] = 'Feil kode. Prøv på nytt';
$string['errorawsconection'] = 'Feil ved tilkobling til AWS-server: {$a}';
$string['errorsmssent'] = 'Feil ved sending av SMS med verifikasjonskode.';
$string['event:smssent'] = 'SMS sendt';
$string['event:smssentdescription'] = 'Brukeren med ID {$a->userid} fikk tilsendt en verifikasjonskode via SMS. Informasjon: {$a->debuginfo}';
$string['info'] = 'Motta en verifikasjonskode til valgt mobilnummer';
$string['logindesc'] = 'SMS med 6-sifret kode sent til mobilnummer {$a}';
$string['loginoption'] = 'Motta en kode på din mobil';
$string['loginskip'] = 'Jeg mottok ikke koden';
$string['loginsubmit'] = 'Fortsett';
$string['logintitle'] = 'Skriv inn koden du har mottatt på mobil';
$string['managefactor'] = 'Administrer SMS';
$string['managefactorbutton'] = 'Administrer';
$string['manageinfo'] = 'Du bruker \'{$a}\' for å autentisere';
$string['notification:smsgatewaymigration'] = 'SMS-innstillinger er flyttet';
$string['notification:smsgatewaymigrationinfo'] = 'Et nytt SMS-undersystem er nå tilgjengelig for administrasjon og konfigurering av alle SMS-relaterte funksjoner. Dine eksisterende SMS-konfigurasjoner er migrert til siden <a href="{$a}">SMS-gatewayer</a>.';
$string['phonehelp'] = 'Legg inn mobilnummeret ditt (inkludert landkode) for å motta en verifikasjonskode.';
$string['pluginname'] = 'SMS';
$string['privacy:metadata'] = 'Modulen SMS-faktor lagrer ikke persondata';
$string['revokefactorconfirmation'] = 'Fjern \'{$a}\' SMS?';
$string['settings:aws'] = 'AWS SNS';
$string['settings:aws:key'] = 'Nøkkel';
$string['settings:aws:key_help'] = 'Amazon API-nøkkellegitimasjon.';
$string['settings:aws:region'] = 'Område';
$string['settings:aws:region_help'] = 'Amazon API-gateway-region.';
$string['settings:aws:secret'] = 'Secret';
$string['settings:aws:secret_help'] = 'Amazon API secret legitimasjon';
$string['settings:aws:usecredchain'] = 'Finn AWS-legitimasjon ved hjelp av standard kjede for legitimasjonsleverandører';
$string['settings:countrycode'] = 'Landkode';
$string['settings:countrycode_help'] = 'Landskoden uten + som innledende tegn som standard hvis brukere ikke oppgir et internasjonalt nummer med + prefiks.

Se denne lenken for en liste over landskoder: {$a}';
$string['settings:duration'] = 'Gyldighetsvarighet';
$string['settings:duration_help'] = 'Perioden koden er gyldig';
$string['settings:gateway'] = 'SMS Gateway';
$string['settings:gateway_help'] = 'SMS-tilbyderen du vil sende meldinger via';
$string['settings:heading'] = 'Brukere vil motta en 6-sifret bekreftelseskode via SMS, som de må skrive inn for å fullføre innloggingsprosessen. Brukere må først registrere mobilnummeret sitt.';
$string['settings:setupdesc'] = 'For å bruke SMS som autentiseringsfaktor må du først <a href="{$a}">konfigurere en SMS-gateway</a>.';
$string['settings:shortdescription'] = 'Krever at brukerne må oppgi en kode mottatt på SMS for innlogging.';
$string['settings:smsgateway'] = 'SMS Gateway';
$string['settings:smsgateway_help'] = 'Velg en gateway fra listen eller <a href="{$a}">opprett ny gateway</a>.';
$string['setupfactor'] = 'Konfigurer SMS';
$string['setupfactorbutton'] = 'Konfigurer';
$string['setupsubmitcode'] = 'Lagre';
$string['setupsubmitphone'] = 'Send kode';
$string['smsstring'] = '{$a->code} er din {$a->fullname} engangs sikkerhetskode.

@{$a->url} #{$a->code}';
$string['summarycondition'] = 'Bruk av en engangs sikkerhetskode på SMS';
