<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'facetoface', language 'no', version '5.1'.
 *
 * @package     facetoface
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addingsession'] = 'Legg til ny økt i {$a}';
$string['addmanageremailaddress'] = 'Legg til leders e-mail adresse';
$string['addmanageremailinstruction'] = 'Du har ikke lagt til leders e-post adresse. Vennligst legg til  adressen under for å registrere deg for denne økten.';
$string['addnewfield'] = 'Legg til et nytt tilpasset felt';
$string['addnewfieldlink'] = 'Opprett et nytt tilpasset felt';
$string['addnewnotice'] = 'Legg til ny melding på siden';
$string['addnewnoticelink'] = 'Lag ny melding på siden';
$string['addremoveattendees'] = 'Legg til/fjern deltakere';
$string['addsession'] = 'Legg til ny økt';
$string['addstudent'] = 'Legg til student';
$string['alllocations'] = 'Alle lokasjoner';
$string['allowcancellations'] = 'Tillat avbestilling';
$string['allowcancellations_help'] = 'Hvis merket av, vil deltakere på økten kunne avbestille';
$string['allowcancellationsdefault'] = 'Tillat avbestilling som standard';
$string['allowcancellationsdefault_help'] = 'Hvis merket av vil standardinnstillingen, når du oppretter nye økter for denne aktiviteten, være å tillate avbestilling';
$string['allowoverbook'] = 'Tillat overbooking (Venteliste)';
$string['allowoverbook_help'] = 'Når «Tillat overbooking» er merket av, vil deltakere kunne registrere seg for en økt selv om den allerede er full.<br /> Når en elev registrerer seg for en økt som allerede er full, vil de motta en e-post som informerer om at de er på venteliste og vil bli varslet når en bestilling blir tilgjengelig.';
$string['allsessionsin'] = 'Alle økter i {$a}';
$string['alreadysignedup'] = 'Du har allerede registrert deg for denneFacetoface-aktiviteten.';
$string['answer'] = 'Logg inn';
$string['answercancel'] = 'Logg ut';
$string['approvalreqd'] = 'Godkjenning kreves';
$string['approvalreqd_help'] = 'Når "Godkjenning kreves" er merket av, vil en deltaker trenge godkjenning fra sin leder for å få tillatelse til å delta på en økt.';
$string['approve'] = 'Godkjenne';
$string['assessmentyour'] = 'Dine vurderinger';
$string['attendance'] = 'Deltakelse';
$string['attendanceinstructions'] = 'Velg brukere som deltok på økten:';
$string['attendedsession'] = 'Deltatt i økt';
$string['attendees'] = 'Deltakere';
$string['attendeesexporttofileheading'] = '';
$string['booked'] = 'Bestilt';
$string['bookingcancelled'] = 'Bestillingen din er kansellert.';
$string['bookingcompleted'] = 'Bestillingen din er fullført.';
$string['bookingfull'] = 'Bestilling full';
$string['bookingopen'] = 'Bestillingen er åpen';
$string['bookingstatus'] = 'Du er booket til følgende økt';
$string['calendareventdescriptionbooking'] = 'Du er booket for denne <a href="{$a}">økten</a>.';
$string['calendareventdescriptionsession'] = 'Du har laget denne <a href="{$a}">økten</a>.';
$string['calendaroptions'] = 'Kalenderalternativer';
$string['cancelbooking'] = 'Kanseller bestillingen';
$string['cancelbookingfor'] = 'Kanseller bestillingen for {$a}';
$string['cancellation'] = 'Avbestilling';
$string['cancellationconfirm'] = 'Er du sikker på at du vil kansellere bestillingen din for denne økten?';
$string['cancellationinstrmngr'] = '# Melding til leder';
$string['cancellationinstrmngr_help'] = 'Når **Melding til leder** er merket av, sendes teksten i feltet **Melding til leder** til deltakers leder med beskjed om at bestillingen er kansellert.';
$string['cancellationmessage'] = 'Avbestillingsmelding';
$string['cancellationmessage_help'] = 'Denne meldingen sendes ut når brukere kansellerer bestillingen for en økt.';
$string['cancellations'] = 'Avbestillinger';
$string['cancellationsent'] = 'En bekreftelse på avbestilling sendes på mail til deg umiddelbart.';
$string['cancellationsentmgr'] = 'En bekreftelse på avbestilling sendes på mail, til deg og din leder, umiddelbart.';
$string['cancellationstablesummary'] = 'Liste over personer som har kansellert øktregistreringene sine.';
$string['cancelreason'] = 'Årsak';
$string['cannotapproveatcapacity'] = 'Du kan ikke godkjenne flere deltakere da denne økten er full.';
$string['cannotsignupsessioninprogress'] = 'Du kan ikke registrere deg, siden denne økten pågår';
$string['cannotsignupsessionover'] = 'Du kan ikke melde deg på, siden økten er over.';
$string['capacity'] = 'Kapasitet';
$string['capacity_help'] = '**Kapasitet** er antall ledige plasser i en økt. Når en økt når maks kapasitet, vises ikke øktdetaljene på kurssiden. Detaljene vises nedtonet på \'Se alle økter\'-siden, og eleven kan ikke melde seg på økten. &nbsp;';
$string['changemanageremailaddress'] = 'Endre e-postadressen til leder';
$string['changemanageremailinstruction'] = 'Vennligst skriv inn e-postadressen til din nåværende leder nedenfor.';
$string['clearall'] = 'Fjern alt';
$string['closed'] = 'Lukket';
$string['conditions'] = 'Forutsetninger';
$string['conditionsexplanation'] = 'Alle disse kriteriene må være oppfylt for at varselet skal vises på læringskalenderen:';
$string['confirm'] = 'Bekreft';
$string['confirmanager'] = 'Bekreft leders e-postadresse';
$string['confirmation'] = 'Bekreftelse';
$string['confirmationinstrmngr'] = '# Melding til leder';
$string['confirmationinstrmngr_help'] = 'Når "Send melding til leder" er merket av, sendes teksten i "Merknad til leder"-feltet til en leder som informerer om at en medarbeider har meldt seg på en økt.';
$string['confirmationmessage'] = 'Bekreftelsesmelding';
$string['confirmationmessage_help'] = 'Denne meldingen sendes ut når brukere registrerer seg for en økt.';
$string['confirmationsent'] = 'En bekreftelse sendes på mail til deg';
$string['confirmationsentmgr'] = 'En bekreftelse sendes på mail til deg og din leder';
$string['confirmmanageremailaddress'] = 'Bekreft leders e-postadresse';
$string['confirmmanageremailaddressquestion'] = 'Er <b>{$a}</b> fortsatt din leders e-post adresse?';
$string['confirmmanageremailinstruction1'] = 'Du har tidligere oppgitt følgende som e-postadressen til lederen din:';
$string['confirmmanageremailinstruction2'] = 'Er dette fortsatt din leders e-post adresse?';
$string['continuetologin'] = 'Klikk fortsett for å logge på';
$string['copy'] = 'Kopier';
$string['copyingsession'] = 'Kopier som en ny økt {$a}';
$string['copysession'] = 'Kopier økt';
$string['cost'] = 'Kostnad';
$string['costheading'] = 'Kostnad for økt';
$string['crontask'] = 'Face-to-Face vedlikeholdsjobb';
$string['currentstatus'] = 'Nåværende status';
$string['customfieldsheading'] = 'Egendefinerte øktfelt';
$string['date'] = 'Dato';
$string['dateadd'] = 'Legg til ny dato';
$string['dateremove'] = 'Fjern denne datoen';
$string['datesignedup'] = 'Dato påmeldt';
$string['datetext'] = 'Du er pålogget for dato';
$string['decidelater'] = 'Bestem senere';
$string['decline'] = 'Avslå';
$string['delete'] = 'Slett';
$string['deleteall'] = 'Slett alt';
$string['deletesession'] = 'Slett økt';
$string['deletesessionconfirm'] = 'Er du helt sikker på at du vil slette denne økten og alle påmeldinger for denne økten?';
$string['deletingsession'] = 'Slette økt i {$a}';
$string['description'] = 'Introduksjonstekst';
$string['description_help'] = '**Beskrivelse** er kursbeskrivelsen som vises når en deltaker melder seg på en Facetoface-økt. **Beskrivelsen** vises også i læringskalenderen.';
$string['details'] = 'Detaljer';
$string['details_help'] = 'Detaljer spores per økt. Hvis tekst er fylt ut i detaljfeltet, vil detaljteksten vises på brukerregistreringssiden. Som standard vises detaljteksten også i e-postmeldingene for bekreftelse, påminnelse, venteliste og avbestilling.';
$string['discountcode'] = 'Rabattkode';
$string['discountcode_help'] = 'Rabattkode er koden som kreves for at rabattkostnaden skal spores for opplæring av en medarbeider. Dersom den ansatte ikke oppgir rabattkoden, fremkommer normalkostnaden i treningsprotokollen.';
$string['discountcodelearner'] = 'Rabattkode';
$string['discountcodelearner_help'] = 'Hvis du kjenner rabattkoden, skriv den inn her. Hvis du lar dette feltet stå tomt, vil du bli belastet den normale kostnaden for dette arrangementet';
$string['discountcost'] = 'Rabattkostnad';
$string['discountcost_help'] = 'Rabattkostnaden er beløpet som belastes ansatte som har en medlems-ID. Dersom en medarbeider oppgir medlems-ID ved påmelding til en økt, vil rabattkostnaden vises i kostnadskolonnen i kursets karakterbok.';
$string['discountcosthinttext'] = '';
$string['due'] = 'forfaller';
$string['duration'] = 'Varighet';
$string['duration_help'] = '**Varighet** er den totale lengden på opplæringen i timer. For eksempel: * "2 timer" angis som **2** eller **2:00** * "1 time og 30 minutter" angis som **1:30** * "45 minutter" angis som **0:45** * "20 minutter" angis som **0:20**. Hvis treningen foregår over to eller flere tidsperioder, er varigheten den samlede summen.';
$string['early'] = '{$a} tidlig';
$string['edit'] = 'Rediger';
$string['editingsession'] = 'Rediger økt i {$a}';
$string['editsession'] = 'Rediger økt';
$string['email:instrmngr'] = 'Melding til leder';
$string['email:message'] = 'Melding';
$string['email:subject'] = 'Emne';
$string['emailmanager'] = 'Send melding til leder';
$string['emailmanagercancellation'] = '# Send melding til leder';
$string['emailmanagercancellation_help'] = 'Når "Send melding til leder" er merket av, vil en e-post bli sendt til elevens leder som informerer dem om at økt-bestillingen er kansellert.';
$string['emailmanagerconfirmation'] = '# Send melding til leder';
$string['emailmanagerconfirmation_help'] = 'Når "Send melding til leder" er merket av, vil en bekreftelses-e-post bli sendt til elevens leder når eleven melder seg på en økt.';
$string['emailmanagerreminder'] = '# Send melding til leder';
$string['emailmanagerreminder_help'] = 'Når "Send melding til leder" er merket av, vil en påminnelse sendes til elevens leder noen dager før startdatoen for ansikt-til-ansikt-økten.';
$string['emptylocation'] = 'Plasseringen var tom';
$string['enrolled'] = 'påmeldt';
$string['error:addalreadysignedupattendee'] = '{$a} er allerede registrert for denne aktiviteten.';
$string['error:addattendee'] = 'Kunne ikke legge til {$a} i økten.';
$string['error:cancelbooking'] = 'Det oppsto et problem med å kansellere bestillingen';
$string['error:cancellationsnotallowed'] = 'Du har ikke lov til å kansellere denne registreringen.';
$string['error:cannotemailmanager'] = 'Påminnelse for innsendings-id {$a->submissionid} er sendt til brukeren {$a->userid}, men kunne ikke sende meldingen til leders e-postadresse ({$a->manageremail}).';
$string['error:cannotemailuser'] = 'Kunne ikke sende ut e-post for innsendings-ID {$a->submissionid} til brukeren {$a->userid} ({$a->useremail}).';
$string['error:cannotsendconfirmationmanager'] = 'En bekreftelsesmelding ble sendt til e-postadressen din, men det oppsto et problem med å sende bekreftelsesmeldingen til leders e-postadresse.';
$string['error:cannotsendconfirmationthirdparty'] = 'En bekreftelsesmelding ble sendt til din og leders e-postadresse, men det oppstod et problem med å sende bekreftelsesmeldingen til tredjepartens e-postadresse.';
$string['error:cannotsendconfirmationuser'] = 'Det oppsto et problem med å sende bekreftelsesmeldingen til e-postadressen din.';
$string['error:cannotsendconfirmationusermanager'] = 'En bekreftelsesmelding kunne ikke sendes til e-postadressen din og til leders e-postadresse.';
$string['error:cannotsendrequestmanager'] = 'Det oppsto et problem med å sende meldingen om registreringsforespørsel til leders e-postkonto.';
$string['error:cannotsendrequestuser'] = 'Det oppsto et problem med å sende meldingen om registreringsforespørsel til e-postadressen din.';
$string['error:canttakeattendanceforunstartedsession'] = 'Kan ikke ta oppmøte for en økt som ennå ikke har startet.';
$string['error:couldnotaddfield'] = 'Kunne ikke legge til egendefinert øktfelt.';
$string['error:couldnotaddnotice'] = 'Kunne ikke legge til nettstedsvarsel.';
$string['error:couldnotaddsession'] = 'Kunne ikke legge til økt';
$string['error:couldnotaddtrainer'] = 'Kunne ikke lagre den nye instruktøren';
$string['error:couldnotcopysession'] = 'Kunne ikke kopiere økten';
$string['error:couldnotdeletefield'] = 'Kunne ikke slette egendefinert øktfelt';
$string['error:couldnotdeletenotice'] = 'Kunne ikke slette nettstedsvarsel';
$string['error:couldnotdeletesession'] = 'Kunne ikke slette økten';
$string['error:couldnotdeletetrainer'] = 'Kunne ikke slette instruktør';
$string['error:couldnotfindsession'] = 'Kunne ikke finne den nylig innsatte økten';
$string['error:couldnotsavecustomfield'] = 'Kunne ikke lagre det egendefinerte feltet';
$string['error:couldnotupdatecalendar'] = 'Kunne ikke oppdatere økthendelsen i kalenderen.';
$string['error:couldnotupdatef2frecord'] = 'Kunne ikke oppdatere registreringsposten i databasen';
$string['error:couldnotupdatefield'] = 'Kunne ikke oppdatere tilpasset øktfelt.';
$string['error:couldnotupdatemanageremail'] = 'Kunne ikke oppdatere leders e-postadresse.';
$string['error:couldnotupdatenotice'] = 'Kunne ikke oppdatere nettstedvarsel.';
$string['error:couldnotupdatesession'] = 'Kunne ikke oppdatere økten';
$string['error:coursemisconfigured'] = 'Kurset er feilkonfigurert';
$string['error:cronprefix'] = 'Feil: Face-to-Face cron:';
$string['error:emptylocation'] = 'Plasseringen er tom.';
$string['error:emptymanageremail'] = 'Leders e-postadresse er tom.';
$string['error:emptyvenue'] = 'Møtetested var tomt.';
$string['error:enrolmentfailed'] = 'Kunne ikke melde {$a} på kurset.';
$string['error:eventoccurred'] = 'Du kan ikke avbryte en hendelse som allerede har blitt gjennomført';
$string['error:f2ffailedupdatestatus'] = 'Facetoface klarte ikke å oppdatere brukerens status';
$string['error:fieldidincorrect'] = 'Felt-ID er feil: {$a}';
$string['error:incorrectcoursemodule'] = 'Kursmodulen er feil';
$string['error:incorrectcoursemoduleid'] = 'Kursmodulen var feil';
$string['error:incorrectcoursemodulesession'] = 'Facetoface-økt var feil';
$string['error:incorrectfacetofaceid'] = 'Facetoface ID er feil';
$string['error:incorrectnotificationtype'] = 'Feil varslingstype oppgitt';
$string['error:invaliduserid'] = 'Ugyldig brukerID';
$string['error:manageremailaddressmissing'] = 'Du er for øyeblikket ikke tilordnet en leder i systemet. Ta kontakt med nettstedadministratoren.';
$string['error:mustspecifycoursemodulefacetoface'] = 'En kursmodul eller Facetoface ID må spesifiseres';
$string['error:nomanageremail'] = 'Du har ikke oppgitt en e-postadresse til lederen din';
$string['error:nomanagersemailset'] = 'Ingen e-postadresse for elder er angitt';
$string['error:nopermissiontosignup'] = 'Du har ikke tillatelse til å registrere deg for denne Facetoface-økten';
$string['error:noticeidincorrect'] = 'Merknads-ID er feil: {$a}';
$string['error:problemsigningup'] = 'Det oppsto et problem med å registrere deg.';
$string['error:removeattendee'] = 'Kunne ikke fjerne {$a} fra økten.';
$string['error:sessionstartafterend'] = 'Øktens startdato/tidspunkt er etter sluttdato';
$string['error:shortnametaken'] = 'Egendefinert felt med dette korte navnet finnes allerede.';
$string['error:signedupinothersession'] = 'Du er allerede registrert i en annen økt for denne aktiviteten. Du kan bare registrere deg for én økt per Facetoface-aktivitet.';
$string['error:unknownbuttonclicked'] = 'Ingen handling knyttet til knappen det ble klikket på';
$string['eventaddsession'] = 'Økt lagt til';
$string['eventaddsessionfailed'] = 'Legge til økt (Mislykket)';
$string['eventapproverequests'] = 'Forespørsler om øktgodkjenning';
$string['eventattendancetaken'] = 'Øktdeltakelse registrert';
$string['eventattendeesviewed'] = 'Øktdeltakere sett';
$string['eventcancelbooking'] = 'Økt avbestilling';
$string['eventcancelbookingfailed'] = 'Økt-avbestilling (mislykket)';
$string['eventcoursef2fviewed'] = 'Facetoface instanser i kurs, sett';
$string['eventcoursemoduleviewed'] = 'Facetoface modul, sett';
$string['eventdeletesession'] = 'Økt slettet';
$string['eventdeletesessionfailed'] = 'Slette økt (FEILET)';
$string['eventsignup'] = 'Øktregistrering';
$string['eventsignupfailed'] = 'Øktpåmelding (Mislykket)';
$string['eventtakeattendancefailed'] = 'Føre tilstedeværelse i økt  (Mislykket)';
$string['eventupdatemanageremailfailed'] = 'Oppdatere e-mail til leder (Mislykket)';
$string['eventupdatesession'] = 'Økt oppdatert';
$string['eventupdatesessionfailed'] = 'Oppdatere økt (Mislykket)';
$string['excelformat'] = 'Excel';
$string['export'] = 'Eksport';
$string['exportattendance'] = 'Eksporter oppmøte';
$string['exporttofile'] = 'Eksporter til fil';
$string['facetoface:addattendees'] = 'Legg til deltakere i Facetoface-økt';
$string['facetoface:configurecancellation'] = 'Tillat konfigurasjon av avbestillinger ved å legge til/redigere en Facetoface-aktivitet.';
$string['facetoface:editsessions'] = 'Legg til, endre, kopier og slett Facetoface økter';
$string['facetoface:overbook'] = 'Påmelding til hele økten';
$string['facetoface:removeattendees'] = 'Fjern deltakere i en facetoface økt';
$string['facetoface:signup'] = 'Påmelding for økt';
$string['facetoface:takeattendance'] = 'Registrer oppmøte';
$string['facetoface:view'] = 'Se Facetoface-aktiviteter og økter';
$string['facetoface:viewattendees'] = 'Se deltakerliste og deltakere';
$string['facetoface:viewcancellations'] = 'Se avbestillinger';
$string['facetoface:viewemptyactivities'] = 'Se tomme Facetoface-aktiviteter';
$string['facetofacebooking'] = 'Facetoface-påmelding';
$string['facetofacename'] = 'Navn på Facetoface-aktivitet';
$string['facetofacesession'] = 'Facetoface-økt';
$string['feedback'] = 'Tilbakemelding';
$string['feedbackupdated'] = 'Tilbakemelding oppdatert for \\{$a} personer';
$string['field:multiselect'] = 'Flervalg';
$string['field:select'] = 'Valgmeny';
$string['field:text'] = 'Tekst';
$string['fielddeleteconfirm'] = 'Vil du slette feltet \'{$a}\' og all øktdata knyttet til det?';
$string['full'] = 'Datoen er full';
$string['goback'] = 'Gå tilbake';
$string['guestsno'] = 'Beklager, gjester har ikke lov til å melde seg på økter.';
$string['icalendarheading'] = 'iCalendar-vedlegg';
$string['info'] = 'Informasjon';
$string['late'] = '\\{$a} sent';
$string['location'] = 'Sted';
$string['location_help'] = '**Sted** beskriver øktens lokasjon (by, fylke, region osv.).

**Plassering** vises på kurssiden, "Registreringsside", "Se alle økter"-siden og i alle e-postvarsler.

På "Se alle økter"-siden kan de oppførte øktene filtreres etter sted.';
$string['lookfor'] = 'Søk';
$string['manageradded'] = 'E-postadressen til lederen din er godtatt.';
$string['managerchanged'] = 'E-postadressen til lederen din er endret.';
$string['manageremail'] = 'Leders e-post';
$string['manageremailaddress'] = 'Leders e-postadresse';
$string['manageremailformat'] = 'E-postadressen må ha formatet \'{$a}\' for å bli akseptert.';
$string['manageremailheading'] = 'Lederes e-postadresser';
$string['manageremailinstruction'] = 'For å melde deg på en økt, må en bekreftelses-e-post sendes til e-postadressen din og kopieres til e-postadressen til lederen din.';
$string['manageremailinstructionconfirm'] = 'Vennligst bekreft at dette er lederens e-postadresse:';
$string['managername'] = 'Leders navn';
$string['managerupdated'] = 'E-postadressen til lederen din er oppdatert.';
$string['maximumpoints'] = 'Maksimalt antall poeng';
$string['message'] = 'Endring i bestilling i kurset {$a->kursnavn}!

Det har dukket opp en ledig plass i økten på {$a->duedate} ({$a->name}) i kurset {$a->coursename}.
Du har blitt registrert. Hvis datoen ikke passer deg lenger, vennligst avregistrer deg på <a href=\'{$a->url}\'>{$a->url}</a>.';
$string['mods_help'] = 'Facetoface-aktiviteter brukes til å holde styr på personlig trening som krever forhåndsbestilling.

Hver aktivitet tilbys i en eller flere like økter. Disse øktene kan gis over flere dager.

Påminnelsesmeldinger sendes til brukere og deres ledere noen dager før økten skal starte. Bekreftelsesmeldinger sendes når brukere registrerer seg for en økt, eller avbryter.';
$string['modulename_help'] = 'Facetoface-aktiviteten gjør det mulig for en lærer å sette opp et frivillig bestillingssystem for én eller flere personlige/klasserombaserte økter.

Hver økt i en Facetoface-aktivitet kan ha tilpassede innstillinger rundt sted, sted, starttid, sluttid, kostnad, kapasitet osv. Disse kan settes til å gå over flere dager eller for å tillate uplanlagte økter, samt venteliste i økter.

En aktivitet kan settes til å kreve ledergodkjenning, og lærere kan konfigurere automatiserte varsler og øktpåminnelser for deltakere.

Studenter kan se og registrere seg for økter med deres oppmøte sporet og registrert i karakterer-området.';
$string['moreinfo'] = 'Mer informasjon';
$string['multidate'] = '(flerdatoer)';
$string['newmanageremailaddress'] = 'Leders e-postadresse';
$string['noactionableunapprovedrequests'] = 'Ingen ikke-godkjente forespørsler';
$string['nocustomfields'] = '<p>Ingen egendefinerte felt er definert.</p>';
$string['nofacetofaces'] = 'Det finnes ingen Facetoface-aktiviteter';
$string['none'] = 'ingen';
$string['noremindersneedtobesent'] = 'Ingen påminnelser må sendes.';
$string['normalcost'] = 'Normal kostnad';
$string['normalcost_help'] = 'Normalkostnad er beløpet som belastes ansatte som ikke har medlemsnummer.

Normalkostnaden vil fremkomme i kostnadskolonnen i kursets karakterbok for hver medarbeider som deltar på økten (med mindre det er lagt inn en rabattkostnad og den ansatte oppgir medlemsnummer ved signering av økten).';
$string['normalcosthinttext'] = '';
$string['nosignedupusers'] = 'Ingen brukere har registrert seg for denne økten.';
$string['nositenotices'] = '<p>Ingen nettstedsmeldinger er definert.</p>';
$string['note'] = 'Merknad';
$string['notefull'] = 'Selv om økten er fullbooket kan du fortsatt registrere deg. Du vil stå i kø (merket med rødt). Dersom noen melder seg ut, vil den første i køen bli flyttet inn blant registrerte studenter og en bekreftelsesmelding vil bli sendt per post.';
$string['noticedeleteconfirm'] = 'Vil du slette nettstedets varsel \'{$a->name}\'?<br/><blockquote>{$a->text}</blockquote>';
$string['noticetext'] = 'Merknadstekst';
$string['notificationboth'] = 'E-postvarsling og iCalendar-avtale';
$string['notificationemail'] = 'Kun e-postvarsling';
$string['notificationical'] = 'Kun iCalendar-avtale';
$string['notificationtype'] = 'Varslingstype';
$string['notificationtype_help'] = 'Varslingstype lar deltakerne velge hvordan de vil bli varslet vedrørende bestillingen sin.

* Kun iCalendar-avtale
* Kun e-postvarsling
* E-postvarsling og iCalendar-avtale';
$string['notsignedup'] = 'Du er ikke påmeldt denne økten.';
$string['notsubmittedyet'] = 'Ikke evaluert ennå';
$string['noupcoming'] = '<p><i>Ingen kommende økter</i></p>';
$string['odsformat'] = 'Åpne dokument';
$string['onehour'] = '1 time';
$string['oneminute'] = '1 minutt';
$string['options'] = 'Alternativer';
$string['or'] = 'eller';
$string['order'] = 'bestilling';
$string['place'] = 'Rom';
$string['pluginadministration'] = 'Facetoface-administrasjon';
$string['pointsplural'] = 'Poeng';
$string['potentialattendees'] = 'Potensielle deltakere';
$string['previoussessions'] = 'Tidligere økter';
$string['printversionid'] = 'Utskriftsversjon: Uten navn';
$string['printversionname'] = 'Utskriftsversjon: Med navn';
$string['privacy:metadata:facetoface_session_roles'] = 'Viser brukere med en lederrolle i en økt';
$string['privacy:metadata:facetoface_signups'] = 'Brukerregistreringer til økter';
$string['privacy:metadata:facetoface_signups:discountcode'] = 'Rabattkoden oppgitt av brukeren';
$string['privacy:metadata:facetoface_signups:id'] = 'ID-en til registreringen';
$string['privacy:metadata:facetoface_signups:mailedreminder'] = 'Tidspunktet en påminnelse sist ble sendt';
$string['privacy:metadata:facetoface_signups:notificationtype'] = 'Hvordan brukeren ønsker å bli varslet.';
$string['privacy:metadata:facetoface_signups:sessionid'] = 'Økt-id';
$string['privacy:metadata:facetoface_signups_status'] = 'Statusen for en brukerregistrering til en økt';
$string['privacy:metadata:facetoface_signups_status:grade'] = 'Tildelt karakter på økten';
$string['privacy:metadata:facetoface_signups_status:note'] = 'Lagrer årsaken til en avlyst økt';
$string['privacy:metadata:facetoface_signups_status:signupid'] = 'ID-en til registreringen';
$string['privacy:metadata:facetoface_signups_status:statuscode'] = 'Registreringsstatus, f.eks. kansellert, avslått, deltatt';
$string['privacy:metadata:facetoface_signups_status:timecreated'] = 'Tidspunktet registreringen ble opprettet.';
$string['privacy:metadata:roleid'] = 'Brukers rolle-ID';
$string['privacy:metadata:userid'] = 'Brukers rolle-ID';
$string['really'] = 'ID-en til brukeren som fikk tilgang til Facetoface-aktiviteten';
$string['registeredon'] = 'Registrert på';
$string['registrations'] = 'Påmeldinger';
$string['reminder'] = 'Påminnelse';
$string['reminderinstrmngr'] = '# Merknad for leder';
$string['remindermessage'] = 'Påminnelsesmelding';
$string['remindermessage_help'] = 'Denne meldingen sendes ut noen dager før økten starter';
$string['reminderperiod'] = 'Dager før meldingen sendes';
$string['reminderperiod_help'] = 'Påminnelsesmeldingen sendes så mange dager før økten starter.';
$string['requestmessage'] = 'Be om melding';
$string['saveallfeedback'] = 'Lagre alle svar';
$string['saveattendance'] = 'Lagre oppmøte';
$string['scheduledsession'] = 'Planlagt økt';
$string['scheduledsessions'] = 'Planlagte økter';
$string['search:activity'] = 'Facetoface-aktiviteter';
$string['seatsavailable'] = 'Ledige plasser';
$string['seeattendees'] = 'Se deltakere';
$string['sentreminderuser'] = 'Sendt påminnelse til bruker';
$string['sessiondate'] = 'Øktdato er datoen økten finner sted.';
$string['sessiondatetime'] = 'Dato/klokkeslett for økten';
$string['sessiondatetimeknown'] = 'Er øktens dato/klokkeslett kjent?';
$string['sessiondatetimeknown_help'] = '**Hvis dato/klokkeslett for en økt er kjent**

Hvis "Ja" angis for denne innstillingen, vises dato og klokkeslett for økten på kurssiden (hvis økten er kommende og tilgjengelig), siden "Se alle økter" ", påmeldingssiden for økten, samt alle e-postvarsler knyttet til økten.

Når en medarbeider registrerer seg for en økt med kjent dato og klokkeslett:

* Medarbeideren og medarbeiderens leder vil få tilsendt en bekreftelses-e-post (dvs. den som er formatert i henhold til "Bekreftelsesmelding"-delen av ansikt-til- Ansiktsforekomstens innstillinger).
* Medarbeideren vil få tilsendt en e-postpåminnelse (dvs. den som er formatert i henhold til "Påminnelsesmelding"-delen av ansikt-til-ansikt-forekomstens innstillinger). Påminnelsen vil bli sendt et antall dager før økten, i henhold til «Dager før melding sendes»-innstillingen som også finnes i «Påminnelsesmelding»-delen av ansikt-til-ansikt-forekomstens innstillinger.

**Hvis dato/klokkeslett for en økt ikke er kjent (eller venteliste)

** Hvis "Nei" angis for denne innstillingen, vil teksten "venteliste" vises på kurssiden, siden "Vis alle økter" ", påmeldingssiden for økten, samt alle e-postvarsler knyttet til økten. Når en medarbeider registrerer seg for en ventelisteøkt:

* Medarbeideren vil få tilsendt en bekreftelses-e-post (dvs. den som er formatert i henhold til delen "Ventelistet melding" i ansikt-til-ansikt-forekomstens innstillinger).
* Medarbeideren vil ikke få tilsendt en påminnelse på e-post.
* Ansattes leder vil ikke få tilsendt bekreftelses- og avbestillings-e-post.';
$string['sessionfinishtime'] = 'Sluttid for økt';
$string['sessioninprogress'] = 'Økt pågår';
$string['sessionisfull'] = 'Denne økten er fullbooket. Du må velge et annet tidspunkt eller snakke med instruktøren.';
$string['sessionover'] = 'Økten er ferdig';
$string['sessionrequiresmanagerapproval'] = 'Denne økten krever påmeldingsgodkjenning fra leder';
$string['sessionroles'] = 'Øktroller';
$string['sessions'] = 'Økter';
$string['sessionsoncoursepage'] = 'Økter vises på kurssiden';
$string['sessionsoncoursepage_help'] = 'Dette er antall økter for hver Facetoface-aktivitet som vises på hovedkurssiden.';
$string['sessionstartdate'] = 'Økt startdato';
$string['sessionstarttime'] = 'Starttid for økt';
$string['sessionvenue'] = 'Sted';
$string['setting:addchangemanageremail'] = 'Spør brukerne om e-postadressen til lederen deres.';
$string['setting:addchangemanageremail_caption'] = 'Lederens e-post:';
$string['setting:addchangemanageremaildefault'] = 'Spør brukerne om e-postadressen til lederen deres.';
$string['setting:attendeesexportfields'] = 'Velg feltene som skal inkluderes i øktens eksporterte liste over deltakere. Dette kommer i tillegg til deltakerens for- og etternavn.';
$string['setting:defaultcancellationmessagedefault'] = 'Det bekreftes med dette at bestillingen din på følgende kurs er kansellert: ***BOOKING AVBESTILT*** Deltaker: [firstname] [lastname] Kurs: [facetofacename] Varighet: [duration] Dato(er): [alldates] Sted : [session:location] Sted: [session:venue] Rom: [session:room]';
$string['setting:defaultcancellationsubject_caption'] = 'Avbestilling, Emne';
$string['setting:defaultcancellationsubjectdefault'] = 'Avbestilling';
$string['setting:defaultconfirmationinstrmngr'] = 'Standard bekreftelsesmelding sendt til ledere.';
$string['setting:defaultconfirmationinstrmngr_caption'] = 'Bekreftelsesmelding (ledere)';
$string['setting:defaultconfirmationinstrmngrdefault'] = '*** Til informasjon ****

Dette er for å informere om at [firstname] [lastname] har blitt booket for følgende kurs og oppført deg som deres teamleder/leder.

Hvis du ikke er teamlederen/sjefen deres og tror du har mottatt denne e-posten ved en feiltakelse, vennligst svar på denne e-posten. Hvis du er bekymret for at din medarbeider tar dette kurset, vennligst diskuter dette med dem direkte.

*** [firstname] [lastname] sin bestillingsbekreftelsen er lagt ved under ****';
$string['setting:defaultconfirmationmessage'] = 'Standard bekreftelsesmelding sendt til brukere.';
$string['setting:defaultconfirmationmessage_caption'] = 'Bekreftelsesmelding';
$string['setting:defaultconfirmationmessagedefault'] = 'Det bekreftes med dette at du er påmeldt følgende kurs: Deltaker: [firstname] [lastname] Kurs: [facetofacename] Kostnad: [cost] Varighet: [duration] Dato(er): [alldates] Sted: [session:location] Sted: [session:venue] Rom: [session:room] ***Vennligst kom ti minutter før kurset starter*** For å endre eller kansellere bestillingen din må du kansellere denne bestillingen og deretter bestille en ny økt. For å kansellere bestillingen din, gå tilbake til nettstedet, deretter til siden for dette kurset, og velg deretter "avbryt" fra bestillingsinformasjonsskjermen. [details] Du vil motta en påminnelse [reminderperiod] virkedager før dette kurset.';
$string['setting:defaultconfirmationsubject'] = 'Standard emnelinje for bekreftelses-e-poster.';
$string['setting:defaultconfirmationsubject_caption'] = 'Bekreftelse, emne';
$string['setting:defaultconfirmationsubjectdefault'] = 'Bekreftelse på kursbestilling: [facetofacename], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultreminderinstrmngr'] = 'Standard påminnelsesmelding sendt til ledere.';
$string['setting:defaultreminderinstrmngr_caption'] = 'Påminnelsesmelding (ledere)';
$string['setting:defaultreminderinstrmngrdefault'] = '*** Til informasjon ****
Din medarbeider [firstname] [lastname] er påmeldt ovennevnte kurs, og har også mottatt denne påminnelsesmailen.

Hvis du ikke er leder for vedkommende og tror du har mottatt denne e-posten ved en feiltakelse, vennligst svar på denne e-posten.

*** [firstname] [lastname] sin påminnelsesmail fiunner du under****';
$string['setting:defaultremindermessage'] = 'Standard påminnelsesmelding sendt til brukere.';
$string['setting:defaultremindermessage_caption'] = 'Påminnelsesmelding';
$string['setting:defaultremindermessagedefault'] = 'Dette er en påminnelse om påmelding til følgende kurs:

Deltaker:   [firstname] [lastname]
Kurs:   [facetofacename]
Kostnad:   [cost]

Varighet:   [duration]
Dato(er): [alldates]

Lokasjon:   [session:location]
Sted:   [session:venue]
Rom:   [session:room]


[details]';
$string['setting:defaultremindersubject'] = 'Standard emnelinje for e-postpåminnelser.';
$string['setting:defaultremindersubject_caption'] = 'Påminnelsesemne';
$string['setting:defaultremindersubjectdefault'] = 'Påminnelse om kursbestilling: [facetofacename], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultrequestinstrmngrdefault'] = 'Dette er for å informere om at [firstname] [lastname] har bedt om å bli booket inn på følgende kurs, og du er oppført som teamleder/leder.
Deltaker:   [firstname] [lastname]
Kurs:   [facetofacename]
Kostnad:   [cost]

Varighet:   [duration]
Dato(er): [alldates]

Lokasjon:   [session:location]
Sted:   [session:venue]
Rom:   [session:room]

Vennligst følg lenken nedenfor for å godkjenne forespørselen:
[attendeeslink]#unapproved

*** [firstname] [lastname] sin påmelding finner du under****';
$string['setting:defaultrequestmessagedefault'] = 'Din forespørsel om å booke deg på følgende kurs er sendt til din leder: Deltaker: [firstname] [lastname] Kurs: [facetofacename] Kostnad: [cost]
Varighet: [duration] Dato(er): [alldates] Sted: [session:location] Sted: [session:venue] Rom: [session:room]';
$string['setting:defaultrequestsubjectdefault'] = 'Påmeldingsforespørsel: [facetofacename], [starttime]-[finishtime]';
$string['setting:defaultvalue'] = 'Standardverdi';
$string['setting:defaultwaitlistedmessage'] = 'Standard ventelistemelding sendt til brukere.';
$string['setting:defaultwaitlistedmessage_caption'] = 'Venteliste-melding';
$string['setting:defaultwaitlistedmessagedefault'] = 'Dette er en bekreftelse på at du er lagt til ventelisten for: Kurs: [facetofacename] Sted: [session:location] Deltaker: [firstname] [lastname] ***Vær oppmerksom på at dette ikke er en bekreftele på ledig plass*** Ved å melde deg på venteliste har du meldt din interesse for dette kurset og vil bli kontaktet direkte hvis øktene blir ledige. For å fjerne deg selv fra denne ventelisten, gå tilbake til dette kurset og klikk på Avbryt bestilling. Vær oppmerksom på at det ikke finnes noen bekreftelses-e-post for fjerning av venteliste.';
$string['setting:defaultwaitlistedsubject'] = 'Standard emnelinje for e-poster på venteliste.';
$string['setting:defaultwaitlistedsubject_caption'] = 'Emne venteliste';
$string['setting:defaultwaitlistedsubjectdefault'] = 'Ventelisteråd for [facetofacename]';
$string['setting:disableicalcancel'] = 'Deaktiver avbestillings-e-poster med et iCalendar-vedlegg.';
$string['setting:disableicalcancel_caption'] = 'Deaktiver iCalendar-avbestilling:';
$string['setting:fromaddress'] = 'Hva vil vises i fra-feltet for e-postpåminnelser sendt av denne modulen';
$string['setting:fromaddress_caption'] = 'Avsenderadresse';
$string['setting:hidecost'] = 'Skjul kostnads- og rabattkodefeltene.';
$string['setting:hidecost_caption'] = 'Skjul pris og rabatt:';
$string['setting:hidediscount'] = 'Skjul kun rabattkodefeltet.';
$string['setting:hidediscount_caption'] = 'Skjul rabatt:';
$string['setting:isfilter'] = 'Vis som filter';
$string['setting:manageraddressformat'] = 'Suffiks som må være til stede i e-postadressen til lederen for å anses som gyldig.';
$string['setting:manageraddressformat_caption'] = 'Påkrevd suffiks:';
$string['setting:manageraddressformatreadable'] = 'Kort beskrivelse av begrensningene på en leders e-postadresse. Denne innstillingen har ingen effekt hvis den forrige ikke er angitt.';
$string['setting:manageraddressformatreadable_caption'] = 'Formateksempel:';
$string['setting:oneemailperday_caption'] = 'En melding pr. dag';
$string['setting:possiblevalues'] = 'Liste over mulige verdier';
$string['setting:sessionroles_caption'] = 'økt-roller';
$string['setting:showinsummary'] = 'Vis i eksporter og lister';
$string['setting:type'] = 'Felttype';
$string['shortname'] = '# Kortnavn';
$string['shortname_help'] = '**Kortnavn** er beskrivelsen av økten som vises på kalenderen når **Vis i kalenderen** er aktivert.';
$string['showbylocation'] = 'Vis etter sted';
$string['showoncalendar'] = 'Innstillinger for kalendervisning';
$string['sign-ups'] = 'Påmeldinger';
$string['signup'] = 'Påmelding';
$string['signupfor'] = 'Påmelding for {$a}';
$string['signupforsession'] = 'Registrer deg for en tilgjengelig kommende økt';
$string['signupforthissession'] = 'Påmelding for denne Facetoface-økten';
$string['signups'] = 'Påmeldinger';
$string['status_approved'] = 'Godkjent';
$string['status_booked'] = 'Bestilt';
$string['status_declined'] = 'Avslått';
$string['status_fully_attended'] = 'Fullt oppmøte';
$string['status_no_show'] = 'Ikke møtt';
$string['status_partially_attended'] = 'Delvis oppmøte';
$string['status_requested'] = 'Forespurt';
$string['status_session_cancelled'] = 'Økt avbrutt';
$string['status_user_cancelled'] = 'Bruker kansellert';
$string['status_waitlisted'] = 'På venteliste';
$string['subject'] = 'Endring i bestilling i kurset {$a->kursnavn} ({$a->forfallsdato})';
$string['submissions'] = 'Innsendinger';
$string['submit'] = 'Send inn';
$string['submitted'] = 'Sendt inn';
$string['summary'] = 'Sammendrag';
$string['suppressemail_help'] = 'Bruk dette alternativet hvis du vil legge til/fjerne brukere fra en Facetoface-økt uten å varsle brukerne.';
$string['takeattendance'] = 'Registrer oppmøte';
$string['thirdpartyemailaddress'] = 'Tredjeparts e-postadresse(r)';
$string['thirdpartyemailaddress_help'] = '**Tredjeparts e-postadresse(r)** er et valgfritt felt som brukes til å spesifisere e-postadressen til en tredjepart (som en ekstern instruktør) som deretter vil motta bekreftelsesmeldinger hver gang en bruker registrerer seg for en økt.
Når du skriver inn **flere e-postadresser**, må du skille hver adresse med et komma. For eksempel: bob@example.com,joe@example.com';
$string['thirdpartywaitlist'] = 'Varsle tredjepart om økter på venteliste';
$string['thirdpartywaitlist_help'] = 'Når **Varsle tredjepart om økter på venteliste** er valgt, vil tredjeparten(e) bli varslet når en elev registrerer seg for en økt på venteliste. Når

**Varsle tredjepart om økter på venteliste** er ikke aktivert Tredjepart(er) vil bare bli varslet når en bruker registrerer seg (eller avbryter) for en planlagt økt.';
$string['time'] = 'Tid';
$string['timecancelled'] = 'Tid avbrutt';
$string['timedue'] = '
Påmeldingsfrist';
$string['timefinish'] = 'Sluttid';
$string['timefinish_help'] = 'Slutttid er tidspunktet da økten avsluttes.';
$string['timerequested'] = 'Tid forespurt';
$string['timesignedup'] = 'Tid påmeldt';
$string['timestart'] = 'Starttid';
$string['timestart_help'] = 'Starttid er tidspunktet da økten begynner.';
$string['unapprovedrequests'] = 'Ikke-godkjente forespørsler';
$string['unknowndate'] = '(ukjent dato)';
$string['unknowntime'] = '(ukjent tidspunkt)';
$string['upcomingsessions'] = 'Kommende økter';
$string['upcomingsessionslist'] = 'Liste over alle kommende økter for denne aktiviteten';
$string['updaterequests'] = 'Oppdateringsforespørsler';
$string['upgradeprocessinggrades'] = 'Behandler Facetoface-karakterer, dette kan ta litt tid hvis det er mange økter...';
$string['usercalentry'] = 'Vis oppføring i brukerens kalender';
$string['usercalentry_help'] = 'Når aktivert, legger denne innstillingen til en brukerhendelsesoppføring i kalenderen til en deltaker i en facetoface-økt. Når den er slått av, forhindrer dette at en duplikathendelse vises i en sesjonsdeltakers kalender, der du har innstillinger for kalendervisning satt til Kurs eller Nettsted.';
$string['usercancelledon'] = 'Bruker kansellerte {$a}';
$string['userdeletedcancel'] = 'Brukeren er slettet';
$string['usernotsignedup'] = 'Status: ikke påmeldt';
$string['usersignedup'] = 'Status: påmeldt';
$string['usersignedupon'] = 'Bruker registrerte seg {$a}';
$string['userwillbewaitlisted'] = 'Denne økten er for øyeblikket full. Ved å klikke på "Registrer deg"-knappen vil du bli plassert på øktens venteliste.';
$string['validation:needatleastonedate'] = 'Du må oppgi minst én dato eller merke økten som ventelistet.';
$string['venue'] = 'Sted';
$string['venue_help'] = '**Sted** er bygningen sesjonen skal holdes i.

**Sted** vises på \'Registrering\'-siden, \'Se alle økter\'-siden og i alle e-postvarsler.';
$string['viewallsessions'] = 'Se alle øktene';
$string['viewsubmissions'] = 'Se påmeldinger';
$string['wait-list'] = 'Venteliste';
$string['wait-listed'] = 'Ventelistet';
$string['waitlistedmessage'] = 'Melding på venteliste';
$string['waitlistedmessage_help'] = 'Denne meldingen sendes ut hver gang brukere registrerer seg for en ventelisteøkt.';
$string['waitliststatus'] = 'Du har en plass på ventelisten for kommende økt';
$string['xhours'] = '{$a} timer';
$string['xminutes'] = '{$a} minutter';
$string['youarebooked'] = 'Du er registrert på følgende økt';
$string['youremailaddress'] = 'Din e-postadresse';
