<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'facetoface', language 'nl', version '5.1'.
 *
 * @package     facetoface
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addingsession'] = 'Voeg een nieuwe sessie toe in {$a}';
$string['addmanageremailaddress'] = 'Voeg emailadres manager toe';
$string['addmanageremailinstruction'] = 'U heeft nog geen emailadres voor een manager ingevoerd. Voer dat hier inom voor de sessie in te tekenen.';
$string['addnewfield'] = 'Nieuw aangepast veld toevoegen';
$string['addnewfieldlink'] = 'Nieuw aangepast veld aanmaken';
$string['addnewnotice'] = 'Nieuwe sitemelding toevoegen';
$string['addnewnoticelink'] = 'Nieuwe sitemelding aanmaken';
$string['addremoveattendees'] = 'Aanwezigen toevoegen/verwijderen';
$string['addsession'] = 'Voeg een nieuwe sessie toe';
$string['addstudent'] = 'Voeg een leerling toe';
$string['alllocations'] = 'Alle locaties';
$string['allowcancellations'] = 'Annuleren van inschrijvingen toestaan';
$string['allowcancellations_help'] = 'Wanneer dit is aangevinkt, kunnen deelnemers aan de sessie hun inschrijvingen annuleren';
$string['allowcancellationsdefault'] = 'Standaardwaarde voor annuleren van inschrijvingen';
$string['allowcancellationsdefault_help'] = 'Wanneer dit is aangevinkt, is de standaardinstelling bij het aanmaken van nieuwe sessies voor deze activiteit, dat annuleren van inschrijvingen is toegestaan';
$string['allowoverbook'] = 'Overboeken toestaan';
$string['allsessionsin'] = 'Alle sessies in {$a}';
$string['alreadysignedup'] = 'Je hebt je al ingeschreven voor deze Afspraak.';
$string['answer'] = 'Schrijf in';
$string['answercancel'] = 'Schrijf uit';
$string['approvalreqd'] = 'Goedkeuring vereist';
$string['approve'] = 'Goedkeuren';
$string['assessmentyour'] = 'Uw assessment';
$string['attendance'] = 'Aanwezigheid';
$string['attendanceinstructions'] = 'Selecteer gebruikers die de sessie bijwoonden';
$string['attendedsession'] = 'Bijgewoonde sessie';
$string['attendees'] = 'Aanwezigen';
$string['booked'] = 'Geboekt';
$string['bookingcancelled'] = 'Uw inschrijving is verwijderd';
$string['bookingcompleted'] = 'Uw inschrijving is compleet';
$string['bookingfull'] = 'Inschrijving vol';
$string['bookingopen'] = 'Inschrijving geopend';
$string['bookingstatus'] = 'U bent geboekt voor de volgende sessie';
$string['calendareventdescriptionbooking'] = 'Je bent ingeschreven voor deze <a href="{$a}">Afspraak</a>.';
$string['calendareventdescriptionsession'] = 'Je hebt deze <a href="{$a}">Afspraak</a>  aangemaakt.';
$string['calendaroptions'] = 'Kalenderopties';
$string['cancelbooking'] = 'Verwijder boeking';
$string['cancelbookingfor'] = 'Verwijder boeking voor {$a}';
$string['cancellation'] = 'Verwijdering';
$string['cancellationconfirm'] = 'Weet u zeker dat u uw reservering voor deze sessie wilt verwijderen?';
$string['cancellationinstrmngr'] = '# Melding voor beheerder';
$string['cancellationmessage'] = 'Bericht van verwijderen boeking';
$string['cancellationmessage_help'] = 'Dit bericht wordt verstuurd wanneer gebruikers hun boeking voor een sessie annuleren.';
$string['cancellations'] = 'Opzeggingen';
$string['cancellationsent'] = 'U zou een bevestigingsbericht van uw opzegging moeten ontvangen in uW mailbox';
$string['cancellationsentmgr'] = 'U en de sessieleider zouden een bevestigingsbericht van uw opzegging moeten ontvangen via de mail';
$string['cancellationstablesummary'] = 'Lijst van mensen die hun inschrijvingen voor de sessie hebben geannuleerd.';
$string['cancelreason'] = 'Reden';
$string['cannotapproveatcapacity'] = 'Je kunt geen deelnemers meer goedkeuren omdat deze sessie vol is.';
$string['cannotsignupsessioninprogress'] = 'Je kunt je niet inschrijven, omdat deze sessie al bezig is';
$string['cannotsignupsessionover'] = 'Je kunt je niet inschrijven, deze sessie is afgelopen.';
$string['capacity'] = 'Aantal plaatsen';
$string['capacity_help'] = '**Aantal plaatsen** is het aantal beschikbare plaatsen in een sessie.

Als een Afspraak-sessie vol is, worden de details ervan niet meer getoond op de cursuspagina. De details worden grijs weergegeven op de pagina \'Bekijk alle sessies\' en de deelnemer kan zich niet inschrijven voor de sessie.
&nbsp;';
$string['changemanageremailaddress'] = 'Wijzig emailadres sessieleider';
$string['changemanageremailinstruction'] = 'Vul hier het emailadres van de sessieleider in';
$string['clearall'] = 'Maak alle velden leeg';
$string['closed'] = 'Gesloten';
$string['conditions'] = 'Voorwaarden';
$string['confirm'] = 'Bevestig';
$string['confirmanager'] = 'Bevestig het emailadres van de sessieleider';
$string['confirmation'] = 'Bevestiging';
$string['confirmationinstrmngr'] = '# Melding voor beheerder';
$string['confirmationmessage'] = 'Bevestigingsmelding';
$string['confirmationmessage_help'] = 'Dit bericht wordt verstuurd wanneer gebruikers zich inschrijven voor een sessie.';
$string['confirmationsent'] = 'U krijgt een bevestigingsbericht per email';
$string['confirmationsentmgr'] = 'U en de sessieleider ontvangen een bevestiging per email';
$string['confirmmanageremailaddress'] = 'Bevestig emailadres van de sessieleider';
$string['confirmmanageremailaddressquestion'] = 'is <b>{$a}</b> inderdaad het emailadres van de sessieleider?';
$string['confirmmanageremailinstruction1'] = 'U heeft het volgende emailadres ingevoerd:';
$string['confirmmanageremailinstruction2'] = 'Is dit inderdaad het emailadres van de sessieleider?';
$string['continuetologin'] = 'Klik op doorgaan om in te loggen';
$string['copy'] = 'Kopiëren';
$string['copyingsession'] = 'Kopieren als nieuwe sessie in {$a}';
$string['copysession'] = 'Kopieer';
$string['cost'] = 'Kosten';
$string['costheading'] = 'Kosten van sessie';
$string['crontask'] = 'Onderhoudstaken voor Afspraak';
$string['currentstatus'] = 'Huidige status';
$string['customfieldsheading'] = 'Aangepaste velden voor sessies';
$string['date'] = 'Datum';
$string['dateadd'] = 'Voeg een nieuwe datum toe';
$string['dateremove'] = 'Verwijder deze datum';
$string['datesignedup'] = 'Datum ingeschreven';
$string['datetext'] = 'U heeft zich ingeschreven voor deze datum';
$string['decidelater'] = 'Later beslissen';
$string['decline'] = 'Afwijzen';
$string['delete'] = 'Verwijderen';
$string['deleteall'] = 'Verwijder alle';
$string['deletesession'] = 'Verwijder sessie';
$string['deletesessionconfirm'] = 'Wet u zeker dat u deze sessie en alle intekeningen daarvoor wilt verwijderen?';
$string['deletingsession'] = 'Verwijderen van sessie in {$a}';
$string['description'] = 'Introductietekst';
$string['details'] = 'Details';
$string['discountcode'] = 'Kortingscode';
$string['discountcodelearner'] = 'Kortingscode';
$string['discountcost'] = 'Kortingsprijs';
$string['due'] = 'te voldoen';
$string['duration'] = 'Duur';
$string['early'] = '{$a} vroeg';
$string['edit'] = 'Bewerken';
$string['editingsession'] = 'Bewerken van sessie in {$a}';
$string['editsession'] = 'Bewerk sessie';
$string['email:instrmngr'] = 'Bericht voor afspraakleider';
$string['email:message'] = 'Bericht';
$string['email:subject'] = 'Onderwerp';
$string['emailmanager'] = 'Stuur bericht naar afspraakleider';
$string['emailmanagercancellation'] = '# Melding aan beheerder versturen';
$string['emailmanagerconfirmation'] = '# Melding aan beheerder versturen';
$string['emailmanagerreminder'] = '# Verstuur melding aan manager';
$string['emptylocation'] = 'Plaats is leeg';
$string['enrolled'] = 'aangemeld';
$string['error:addalreadysignedupattendee'] = '{$a} is al aangemeld voor deze Afspraak.';
$string['error:addattendee'] = 'Kon {$a} niet aan de sessie toevoegen.';
$string['error:cancelbooking'] = 'Er was een probleem bij het opzeggen van uw reservering';
$string['error:cancellationsnotallowed'] = 'Je mag deze inschrijving te annuleren.';
$string['error:cannotemailmanager'] = 'Herinneringsmail voor inschrijving id {$a->submissionid} aan gebruiker $->userid is verstuurd, maar het bericht kon niet worden afgeleverd bij de afspraakleider ({$a->manageremail}).';
$string['error:cannotemailuser'] = 'Kon het bericht van intekening niet versturen naar {$a->submissionid} aan gebruiker {$a->userid} ({$a->useremail}).';
$string['error:cannotsendconfirmationmanager'] = 'Een bevestigingsbericht is verstuurd naar u emailadres, maar er was een probleem met het verzenden van een kopie van het bericht naar de afspraakmanager';
$string['error:cannotsendconfirmationthirdparty'] = 'Een bevestigingsbericht is verstuurd naar u emailadres en dat van de afspraakmanager, maar er was een probleem met het verzenden van een kopie van het bericht naar de andere emailadres(sen)';
$string['error:cannotsendconfirmationuser'] = 'Er was een probleem om het bevestigingsbericht naar u emailadres te versturen';
$string['error:cannotsendconfirmationusermanager'] = 'Bevestigingsbericht kon niet per mail verzonden worden';
$string['error:cannotsendrequestmanager'] = 'Er was een probleem bij het verzenden van het inschrijfverzoek naar het e-mailaccount van je manager.';
$string['error:cannotsendrequestuser'] = 'Er was een probleem bij het verzenden van het inschrijfverzoek naar je e-mailaccount.';
$string['error:canttakeattendanceforunstartedsession'] = 'Kan geen aanwezigheid opnemen voor een sessie die nog moet beginnen.';
$string['error:couldnotaddfield'] = 'Kon aangepast veld niet toevoegen.';
$string['error:couldnotaddnotice'] = 'Kon geen sitemelding toevoegen.';
$string['error:couldnotaddsession'] = 'Kon geen sessie toevoegen';
$string['error:couldnotaddtrainer'] = 'Kon trainer voor Afspraak-sessie niet bewaren.';
$string['error:couldnotcopysession'] = 'Kon geen sessie kopiëren';
$string['error:couldnotdeletefield'] = 'Kon aangepast veld niet verwijderen.';
$string['error:couldnotdeletenotice'] = 'Kon sitemelding niet verwijderen.';
$string['error:couldnotdeletesession'] = 'Kon sessie niet verwijderen';
$string['error:couldnotdeletetrainer'] = 'Kon trainer voor Afspraak-sessie niet verwijderen';
$string['error:couldnotfindsession'] = 'Kon nieuw ingevoegde sessie niet vinden';
$string['error:couldnotsavecustomfield'] = 'Kon aangepast veld niet bewaren';
$string['error:couldnotupdatecalendar'] = 'Kon sessiegebeurtenis niet bijwerken in kalender';
$string['error:couldnotupdatef2frecord'] = 'Kon inschrijfrecord voor Afspraak niet bijwerken in de database';
$string['error:couldnotupdatefield'] = 'Kon aangepast veld niet bijwerken.';
$string['error:couldnotupdatemanageremail'] = 'Kon emailadres niet bijwerken';
$string['error:couldnotupdatenotice'] = 'Kon sitemelding niet bijwerken.';
$string['error:couldnotupdatesession'] = 'Kon sessie niet bijwerken';
$string['error:coursemisconfigured'] = 'Afspraak is niet goed geconfigureerd';
$string['error:cronprefix'] = 'Fout;  Afspraak cron:';
$string['error:emptylocation'] = 'Locatie was leeg';
$string['error:emptymanageremail'] = 'Managers emailadres is leeg';
$string['error:emptyvenue'] = 'Ruimte/lokaal was leeg';
$string['error:enrolmentfailed'] = 'Kon {$a} niet bij de cursus inschrijven.';
$string['error:eventoccurred'] = 'Je kunt geen gebeurtenis annuleren die al heeft plaatsgevonden.';
$string['error:f2ffailedupdatestatus'] = 'Bijwerken status van gebruiker door Afspraak is mislukt';
$string['error:fieldidincorrect'] = 'Veld ID is onjuist {$a}';
$string['error:incorrectcoursemodule'] = 'Cursusmodule is onjuist';
$string['error:incorrectcoursemoduleid'] = 'Cursus ID is onjuist';
$string['error:incorrectcoursemodulesession'] = 'Cursusactiviteit Afspraak sessie was onjuist';
$string['error:incorrectfacetofaceid'] = 'Afspraak ID was onjuist';
$string['error:incorrectnotificationtype'] = 'Onjuist notificatie-type ingevoerd';
$string['error:invaliduserid'] = 'GebruikersID onbekend';
$string['error:manageremailaddressmissing'] = 'Je bent op dit moment nog niet toegewezen aan een manager in het systeem. Neem contact op met je sitebeheerder.';
$string['error:mustspecifycoursemodulefacetoface'] = 'Je moet een cursusmodule of Afspraak ID opgeven';
$string['error:nomanageremail'] = 'U heeft geen emailadres voor de afspraakmanager ingevoegd';
$string['error:nomanagersemailset'] = 'Er is geen e-mailadres voor de manager ingesteld';
$string['error:nopermissiontosignup'] = 'Je hebt geen permissie je voor deze Afspraak-sessie in te schrijven.';
$string['error:noticeidincorrect'] = 'Melding ID is injuist: {$a}';
$string['error:problemsigningup'] = 'Er was een probleem met uw aanmelding';
$string['error:removeattendee'] = 'Kon {$a} niet uit de sessie verwijderen.';
$string['error:sessionstartafterend'] = 'Startdatum / -tijd van sessie is na het einde.';
$string['error:shortnametaken'] = 'Aangepast veld met deze korte naam bestaat al.';
$string['error:signedupinothersession'] = 'Je hebt je al aangemeld in een andere sessie voor deze activiteit. Je kunt je slechts voor één sessie per Afspraak-activiteit aanmelden.';
$string['error:unknownbuttonclicked'] = 'Er is geen actie geassocieerd met de knop waarop werd geklikt';
$string['eventaddsession'] = 'Sessie toegevoegd';
$string['eventaddsessionfailed'] = 'Sessie toevoegen (MISLUKT)';
$string['eventapproverequests'] = 'Verzoeken goedkeuring sessie';
$string['eventattendancetaken'] = 'Aanwezigheid sessie opgenomen';
$string['eventattendeesviewed'] = 'Sessiedeelnemers bekeken';
$string['eventcancelbooking'] = 'Sessieboeking annuleren';
$string['eventcancelbookingfailed'] = 'Sessieboeking annuleren (MISLUKT)';
$string['eventcoursef2fviewed'] = 'Afspraak-instanties in cursus bekeken';
$string['eventcoursemoduleviewed'] = 'Afspraak-instantie bekeken';
$string['eventdeletesession'] = 'Sessie verwijderd';
$string['eventdeletesessionfailed'] = 'Sessie verwijderen (MISLUKT)';
$string['eventsignup'] = 'Aanmelden voor sessie';
$string['eventsignupfailed'] = 'Aanmelden voor sessie (MISLUKT)';
$string['eventtakeattendancefailed'] = 'Aanwezigheid sessie opnemen (MISLUKT)';
$string['eventupdatemanageremailfailed'] = 'E-mail beheerder bijwerken (MISLUKT)';
$string['eventupdatesession'] = 'Sessie bijgewerkt';
$string['eventupdatesessionfailed'] = 'Sessie bijwerken (MISLUKT)';
$string['excelformat'] = 'Excel';
$string['export'] = 'Exporteer';
$string['exportattendance'] = 'Aanwezigheid exporteren';
$string['exporttofile'] = 'Exporteren naar bestand';
$string['facetoface'] = 'Afspraak';
$string['facetoface:addattendees'] = 'Aanwezigen toevoegen aan Afspraak-sessie';
$string['facetoface:addinstance'] = 'Instantie toevoegen';
$string['facetoface:editsessions'] = 'Afspraak-sessies toevoegen, bewerken, kopiëren en verwijderen';
$string['facetoface:overbook'] = 'Aanmelden voor volle sessies.';
$string['facetoface:removeattendees'] = 'Deelnemers verwijderen uit een Afspraak-sessie';
$string['facetoface:signup'] = 'Teken in voor een afspraak';
$string['facetoface:takeattendance'] = 'Neem aanwezigheid op';
$string['facetoface:view'] = 'Bekijk Afspraken en sessies';
$string['facetoface:viewattendees'] = 'Bekijk de lijst van aanwezigen';
$string['facetoface:viewcancellations'] = 'Bekijk opzeggingen';
$string['facetoface:viewemptyactivities'] = 'Bekijk lege Afspraken';
$string['facetofacebooking'] = 'Boeking voor Afspraak';
$string['facetofacename'] = 'Naam van de Afspraak';
$string['facetofacesession'] = 'Afspraak-sessie';
$string['feedback'] = 'Feedback';
$string['feedbackupdated'] = 'Feedback bijgewerkt voor \\{$a} personen';
$string['field:multiselect'] = 'Meervoudige selectie';
$string['field:select'] = 'Keuzemenu';
$string['field:text'] = 'Tekst';
$string['fielddeleteconfirm'] = 'Veld \'{$a}\' en alle daarmee geassocieerde sessie-data verwijderen?';
$string['floor'] = 'Verdieping';
$string['format'] = 'Format';
$string['full'] = 'Datum is bezet';
$string['goback'] = 'Ga terug';
$string['guestsno'] = 'Helaas kunnen gasten zich niet aanmelden voor sessies.';
$string['icalendarheading'] = 'iCalendar bijlagen';
$string['import'] = 'Importeer';
$string['info'] = 'Info';
$string['late'] = '\\{$a} te laat';
$string['location'] = 'Locatie';
$string['lookfor'] = 'Zoek';
$string['manageradded'] = 'Het emailadres is geaccepteerd';
$string['managerchanged'] = 'Het emailadres is gewijzigd';
$string['manageremail'] = 'emailadres afspraakleider';
$string['manageremailaddress'] = 'emailadres afspraakleider';
$string['manageremailformat'] = 'Het emailadres moet zijn als {$a} om geaccepteerd te worden';
$string['manageremailheading'] = 'E-mailadressen manager(s)';
$string['manageremailinstruction'] = 'Om in te tekenen moet er een bevestigingsmail naar uw adres en dat van de afspraakleider gestuurd worden';
$string['manageremailinstructionconfirm'] = 'Bevestig het emailadres van de afspraakleider';
$string['managername'] = 'Naam afspraakleider';
$string['managerupdated'] = 'Het emailadres van de afspraakleider is bijgewerkt';
$string['maximumpoints'] = 'Maximum punten';
$string['maximumsize'] = 'Maximum aantal deelnemers';
$string['message'] = 'Verandering in de boeking van {$a->coursename}!

Er is een plaats vrijgekomen voor {$a->duedate} ({$a->name}) voor de afspraak {$a->coursename}.

U bent voor deze datum ingeschreven. Als u dan verhindert bent, kunt u zich uitschrijven bij <a href=\'{$a->url}\'>{$a->url}</a>';
$string['modulename'] = 'Afspraak';
$string['modulenameplural'] = 'Afspraken';
$string['moreinfo'] = 'Meer info';
$string['multidate'] = '(multi-date)';
$string['newmanageremailaddress'] = 'emaildres afspraakleider';
$string['nocustomfields'] = '<p>Er zijn geen aangepaste velden gedefinieerd.</p>';
$string['nofacetofaces'] = 'Er zijn geen activiteiten van het type Afspraak';
$string['none'] = 'Geen';
$string['noremindersneedtobesent'] = 'Er hoeven geen herinneringen verstuurd te worden';
$string['normalcost'] = 'Normale kosten';
$string['nosignedupusers'] = 'Geen deelnemers hebben zich ingeschreven';
$string['nositenotices'] = '<p>Er zijn geen sitemeldingen gedefinieerd.</p>';
$string['note'] = 'Notitie';
$string['notefull'] = 'Zelfs als de afspraak volgeboekt is, kunt u zich wel aanmelden. U komt dan op de wachtlijst (in het rood weergegeven). Als er een plaats vrijkomt wordt die automatisch uit de wachtlijst opgevuld. Als u geplaatst wordt, krijgt u daar bericht van.';
$string['noticedeleteconfirm'] = 'Sitemelding \'{$a->name}\'?<br/><blockquote>{$a->text}</blockquote> verwijderen';
$string['noticetext'] = 'Tekst van melding';
$string['notificationboth'] = 'Email bericht en iCalendar Gebeurtenis';
$string['notificationemail'] = 'Alleen Email bericht';
$string['notificationical'] = 'Alleen iCalendar gebeurtenis';
$string['notificationtype'] = 'Type bericht';
$string['notsignedup'] = 'Je bent niet ingeschreven voor deze sessie.';
$string['notsubmittedyet'] = 'Nog niet ge-evalueerd';
$string['noupcoming'] = 'Geen geplande sessies';
$string['odsformat'] = 'OpenDocument';
$string['onehour'] = '1 uur';
$string['oneminute'] = '1 minuut';
$string['options'] = 'Opties';
$string['or'] = 'of';
$string['order'] = 'Bestel';
$string['place'] = 'Kamer';
$string['placeholder:alldates'] = '[alldates]';
$string['placeholder:attendeeslink'] = '[attendeeslink]';
$string['placeholder:cost'] = '[cost]';
$string['placeholder:details'] = '[details]';
$string['placeholder:duration'] = '[duration]';
$string['placeholder:facetofacename'] = '[facetofacename]';
$string['placeholder:finishtime'] = '[finishtime]';
$string['placeholder:firstname'] = '[firstname]';
$string['placeholder:lastname'] = '[lastname]';
$string['placeholder:reminderperiod'] = '[reminderperiod]';
$string['placeholder:sessiondate'] = '[sessiondate]';
$string['placeholder:starttime'] = '[starttime]';
$string['pluginname'] = 'Afspraak';
$string['points'] = 'Punten';
$string['pointsplural'] = 'Punten';
$string['potentialattendees'] = 'Mogelijke deelnemers';
$string['previoussessions'] = 'Eerdere afspraken';
$string['printversionid'] = 'Printversie zonder naam';
$string['printversionname'] = 'Printversie met naam';
$string['privacy:metadata:facetoface_signups:id'] = 'Het ID van de inschrijving';
$string['privacy:metadata:facetoface_signups:mailedreminder'] = 'Het tijdstip van versturen van de laatste reminder';
$string['privacy:metadata:facetoface_signups:notificationtype'] = 'Hoe de gebruiker op de hoogte wil worden gehouden.';
$string['privacy:metadata:facetoface_signups:sessionid'] = 'Het sessie ID';
$string['privacy:metadata:facetoface_signups_status'] = 'De inschrijvingsstatus van een gebruiker voor een sessie';
$string['privacy:metadata:facetoface_signups_status:grade'] = 'Het toegekende cijfer voor het bijwonen van de sessie';
$string['privacy:metadata:facetoface_signups_status:note'] = 'Bewaart de reden voor een geannuleerde sessie';
$string['privacy:metadata:facetoface_signups_status:signupid'] = 'Het ID van de inschrijving';
$string['privacy:metadata:facetoface_signups_status:statuscode'] = 'De status van de inschrijving, bijv. geannuleerd, afgewezen, volledig bijgewoond';
$string['privacy:metadata:facetoface_signups_status:timecreated'] = 'Het tijdstip waarop de inschrijving werd aangemaakt.';
$string['privacy:metadata:roleid'] = 'Het rol ID van de gebruiker.';
$string['really'] = 'Weet je zeker dat je alle resultaten voor deze Afspraak wilt verwijderen?';
$string['registeredon'] = 'Geregistreerd op';
$string['registrations'] = 'Registraties';
$string['reminder'] = 'Herinnering';
$string['reminderinstrmngr'] = '# Melding voor beheerder';
$string['remindermessage'] = 'Herinneringsboodschap';
$string['reminderperiod'] = 'Aantal dagen voordat een boodschap wordt verstuurd';
$string['room'] = 'Kamer';
$string['saveallfeedback'] = 'Bewaar alle antwoorden';
$string['saveattendance'] = 'Bewaar aanwezigheid';
$string['scheduledsession'] = 'Ingeroosterde afspraak';
$string['scheduledsessions'] = 'Ingeroosterde afspraken';
$string['search:activity'] = 'Afspraak-activiteiten';
$string['seatsavailable'] = 'Open plaatsen';
$string['seeattendees'] = 'Bekijk intekeningen';
$string['sentremindermanager'] = 'Stuur herinneringsmail naar beheerder';
$string['sentreminderuser'] = 'Stuur herinneringsmail naar gebruiker';
$string['sessiondate'] = 'Sessie datum';
$string['sessiondatetime'] = 'Sessie datum/tijd';
$string['sessiondatetimeknown'] = 'Sessie datum/tijd bekend';
$string['sessionfinishtime'] = 'Eindtijd sessie';
$string['sessioninprogress'] = 'sessie is bezig';
$string['sessionisfull'] = 'Deze sessie is nu vol. Je zult een ander tijdstip moeten kiezen of contact moeten opnemen met de instructeur.';
$string['sessionover'] = 'Sessie over';
$string['sessionrequiresmanagerapproval'] = 'Voor deze sessie is goedkeuring van een beheerder nodig om in te schrijven.';
$string['sessionroles'] = 'Sessierollen';
$string['sessions'] = 'Sessies';
$string['sessionsoncoursepage'] = 'Sessie getoond op cursuspagina';
$string['sessionstartdate'] = 'Startdatum sessie';
$string['sessionstartdateandtimewithouttimezone'] = '{$a->startdate}, {$a->starttime} - {$a->endtime}';
$string['sessionstarttime'] = 'Begintijd sessie';
$string['sessionvenue'] = 'Ruimte/lokaal sessie';
$string['setting:addchangemanageremail'] = 'Vraag gebruikers om het emailadres van de afspraakmanager';
$string['setting:addchangemanageremail_caption'] = 'E-mailadres manager';
$string['setting:addchangemanageremaildefault'] = 'Vraag gebruikers om het e-mailadres van hun manager.';
$string['setting:defaultcancellationinstrmngr'] = 'Standaard kennisgeving van afzegging naar de afspraakleider gestuurd.';
$string['setting:defaultcancellationinstrmngr_caption'] = 'Bericht van verwijderen boeking (afspraakleider)';
$string['setting:defaultcancellationinstrmngrdefault'] = '***Ter kennisname***

Dit is een bevestiging dat [firstname][lastname] de volgende cursus heeft afgemeld en u heeft opgegeven als hun teamleider.

***[firstname][lastname]\'s opzegging is hieronder weergegeven ***';
$string['setting:defaultcancellationmessage'] = 'Standaard kennisgeving van afzegging naar de deelnemer gestuurd.';
$string['setting:defaultcancellationmessage_caption'] = 'Bericht van verwijderen boeking';
$string['setting:defaultcancellationmessagedefault'] = 'Dit is een kennisgeving van het opzeggen van de boeking voor de volgende afspraak:

***BOEKING GEANNULEERD***

Deelnemer: [firstname][lastname]
Afspraak: [facetofacename]

Tijdsduur: [duration]
Data: [alldates]

Locatie: [session:location]
Ruimte/lokaal: [session:venue]
Kamer: [session:room]';
$string['setting:defaultcancellationsubject'] = 'Standaard onderwerp voor afzeggingsemails.';
$string['setting:defaultcancellationsubject_caption'] = 'Onderwerp afzegging';
$string['setting:defaultcancellationsubjectdefault'] = 'Opzegging';
$string['setting:defaultconfirmationinstrmngr'] = 'Standaard bevestigingsbericht gestuurd naar afspraakleiders.';
$string['setting:defaultconfirmationinstrmngr_caption'] = 'Bevestigingsmelding (afspraakleider)';
$string['setting:defaultconfirmationinstrmngrdefault'] = '*** Kennisgeving***

Dit is een kennisgeving dat [firstname][lastname] zich heeft ingeschreven voor de volgende afspraak en u als teamleider heeft geselecteerd.

Als u dit bericht ten onrechte ontvangt, stuur dit bericht dan terug.

*** [fistname] [lastname]\'s inschrijving wordt hieronder weergegeven ***';
$string['setting:defaultconfirmationmessage'] = 'Standaard bevestigingsbericht gestuurd naar deelnemers.';
$string['setting:defaultconfirmationmessage_caption'] = 'Bevestigingsmelding';
$string['setting:defaultconfirmationmessagedefault'] = 'Dit is een kennisgeving van het bevestigen van de boeking voor de volgende afspraak:

Deelnemer: [firstname][lastname]
Afspraak: [facetofacename]
kosten: [cost]

Tijdsduur: [duration]
Data: [alldates]

Locatie: [session:location]
Ruimte/lokaal: [session:venue]
Kamer: [session:room]

*** probeer ervoor te zorgen op tijd aanwezig te zijn***

[details]

U zult een herinnering van deze afspraak [reminderperiod] ontvangen voor aanvang van de afspraak.';
$string['setting:defaultconfirmationsubject'] = 'Standaard onderwerp voor bevestigingsberichten.';
$string['setting:defaultconfirmationsubject_caption'] = 'Onderwerp van bevestiging';
$string['setting:defaultconfirmationsubjectdefault'] = 'Boekingsbevestiging: [facetofacename],[starttime]-[finishtime][sessiondate]';
$string['setting:defaultreminderinstrmngr'] = 'Standaard herinneringsboodschap gestuurd naar afspraakleiders.';
$string['setting:defaultreminderinstrmngr_caption'] = 'Herinneringsboodschap (afspraakleider)';
$string['setting:defaultreminderinstrmngrdefault'] = '***Herinnering***

Uw collega [firstname] [lastname] is bij de volgende afspraak geplaatst en heeft een herinneringsmail ontvangen.

Als u dit bericht ten onrechte heeft ontvangen, stuur deze mail dan terug.

***[firstname] [lastname]\'s herinnering is hieronder weergegeven***';
$string['setting:defaultremindermessage'] = 'Standaard herinneringsboodschap gestuurd naar deelnemers.';
$string['setting:defaultremindermessage_caption'] = 'Herinneringsboodschap';
$string['setting:defaultremindermessagedefault'] = 'Dit is een herinnering dat u geboekt bent voor de volgende afspraak:

Deelnemer: [firstname] [lastname]
Afspraak: [facetofacename]
Kosten:  [cost]

Duur: [duration]
Data:
[alldates]

Locatie: [session:location]
Ruimte/lokaal: [session:venue]
Locatie: [session:room]

*** Zorg er altublieft voor op tijd aanwezig te zijn***

[details';
$string['setting:defaultremindersubject'] = 'Standaard onderwerp voor herinneringsboodschappen.';
$string['setting:defaultremindersubject_caption'] = 'Onderwerp herinneringsboodschap';
$string['setting:defaultremindersubjectdefault'] = 'Afspraakbevestiging-herinnering: [facetofacename],[starttime]-[finishtime],[sessiondate]';
$string['setting:defaultvalue'] = 'Standaardwaarde';
$string['setting:defaultwaitlistedmessage'] = 'Standaard wachtlijst-boodschap gestuurd naar deelnemers.';
$string['setting:defaultwaitlistedmessage_caption'] = 'Wachtlijst boodschap';
$string['setting:defaultwaitlistedmessagedefault'] = 'U bent op de wachtlijst geplaatst voor:

Afspraak: [facetofacename]
Plaats: [session:location]
Deelnemer: [firstname][lastname]

***Dit is geen bevestiging van inschrijving!***

Als deze afspraak beschikbaar komt, zult u er van op de hoogte worden gesteld.';
$string['setting:defaultwaitlistedsubject'] = 'Standaard onderwerp voor wachtlijst-boodschappen.';
$string['setting:defaultwaitlistedsubject_caption'] = 'Onderwerp wachtlijst';
$string['setting:defaultwaitlistedsubjectdefault'] = 'Wachtlijst voor [facetofacename]';
$string['setting:disableicalcancel'] = 'Schakel Opzeggingsberichten met iCalendar bijlages uit.';
$string['setting:disableicalcancel_caption'] = 'Schakel iCalendar opzeggingen uit:';
$string['setting:fromaddress'] = 'Wat zal zichtbaar zijn in het afzenderveld van emails die door deze module wordt verstuurd?';
$string['setting:fromaddress_caption'] = 'Adres afzender:';
$string['setting:fromaddressdefault'] = 'moodle@example.com';
$string['setting:hidecost'] = 'Verberg de velden voor kosten en kortingscode.';
$string['setting:hidecost_caption'] = 'Verberg kosten en korting:';
$string['setting:hidediscount'] = 'Verberg alleen het veld voor kortingscode.';
$string['setting:hidediscount_caption'] = 'Verberg korting:';
$string['setting:isfilter'] = 'Weergeven als een filter';
$string['setting:manageraddressformat'] = 'Element dat in het emailadres van de afspraakmanager moet voorkomen, voor het adres geaccepteerd wordt';
$string['setting:manageraddressformat_caption'] = 'Vereist voorvoegsel:';
$string['setting:manageraddressformatdefault'] = 'Email afspraakleider';
$string['setting:manageraddressformatreadable'] = 'Korte beschrijving van de beperkingen van het emailadres van de afspraakmanager';
$string['setting:manageraddressformatreadable_caption'] = 'Voorbeeld van format:';
$string['setting:manageraddressformatreadabledefault'] = 'firstname.lastname@company.com';
$string['setting:oneemailperday'] = 'Stuur meerdere bevestigingsberichten voor meerdaagse gebeurtenissen.';
$string['setting:oneemailperday_caption'] = 'Één bericht per dag:';
$string['setting:possiblevalues'] = 'Lijst van mogelijke waardes';
$string['setting:sessionroles_caption'] = 'Rollen in sessie:';
$string['setting:showinsummary'] = 'Weergeven in exports en lijsten';
$string['setting:type'] = 'Veldtype';
$string['shortname'] = '# Korte naam';
$string['showbylocation'] = 'Sorteer op locatie';
$string['showoncalendar'] = 'Instellingen kalenderweergave';
$string['sign-ups'] = 'Intekeningen';
$string['signup'] = 'Intekening';
$string['signupfor'] = 'Teken in voor {$a}';
$string['signupforsession'] = 'Teken in voor een beschikbare sessie';
$string['signupforthissession'] = 'Schrijf je in voor deze Afspraak';
$string['signups'] = 'Inschrijvingen';
$string['sitenoticesheading'] = 'Sitemeldingen';
$string['status'] = 'Status';
$string['status_approved'] = 'Goedgekeurd';
$string['status_booked'] = 'Geboekt';
$string['status_declined'] = 'Afgewezen';
$string['status_fully_attended'] = 'Volledig bijgewoond';
$string['status_no_show'] = 'Niet gekomen';
$string['status_partially_attended'] = 'Gedeeltelijk bijgewoond';
$string['status_requested'] = 'Verzocht';
$string['status_session_cancelled'] = 'Sessie geannuleerd';
$string['status_user_cancelled'] = 'Gebruiker heeft geannuleerd';
$string['status_waitlisted'] = 'Op wachtlijst geplaatst';
$string['subject'] = 'Verandering in intekening van {$a->coursename} ({$a->duedate})';
$string['submissions'] = 'Intekeningen';
$string['submit'] = 'Intekenen';
$string['submitted'] = 'Ingetekend';
$string['summary'] = 'Samenvatting';
$string['suppressemail'] = 'Onderdruk bevestigingen per email';
$string['takeattendance'] = 'Neem aanwezigheid op';
$string['thirdpartyemailaddress'] = 'Alternatief emailadres';
$string['thirdpartywaitlist'] = 'Stuur een bericht over sessies op de wachtlijst aan derden';
$string['time'] = 'Tijd';
$string['timecancelled'] = 'Tijd opzegging';
$string['timedue'] = 'Einde registratie';
$string['timefinish'] = 'Eindtijd';
$string['timesignedup'] = 'Tijd van intekening';
$string['timestart'] = 'Begintijd';
$string['timestart_help'] = 'Starttijd is de tijd wanneer de sessie begint.';
$string['unapprovedrequests'] = 'Niet goedgekeurde verzoeken';
$string['unknowndate'] = '(datum onbekend)';
$string['unknowntime'] = '(tijd onbekend)';
$string['upcomingsessions'] = 'Aankomende sessies';
$string['updaterequests'] = 'Verzoeken bijwerken';
$string['usercancelledon'] = 'Gebruiker heeft afgezegd op {$a}';
$string['userdeletedcancel'] = 'Gebruiker is verwijderd';
$string['usernotsignedup'] = 'Status: niet ingetekend';
$string['usersignedup'] = 'Status: ingetekend';
$string['usersignedupon'] = 'Gebruiker heeft ingetekend op {$a}';
$string['venue'] = 'Ruimte/lokaal';
$string['viewallsessions'] = 'Bekijk alle sessies';
$string['viewsubmissions'] = 'Bekijk intekeningen';
$string['wait-list'] = 'Wachtlijst';
$string['wait-listed'] = 'Op wachtlijst geplaatst';
$string['waitlistedmessage'] = 'Wachtlijst boodschap';
$string['xhours'] = '{$a} uren';
$string['xminutes'] = '{$a} minuten';
$string['youarebooked'] = 'U bent geboekt voor de volgende sessie';
$string['youremailaddress'] = 'Uw emailadres';
