<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_pioneer', language 'af', version '5.1'.
 *
 * @package     theme_pioneer
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitybackground'] = 'In Kursus Aktiwiteit-agtergrondkleur';
$string['activitybackground_desc'] = 'Dit is die agtergrondkleur van die boks wanneer aktiwiteite soos les, opdrag, ens. besigtig word.';
$string['allclasses'] = 'Alle Klasse';
$string['allcourses'] = 'Alle Kursusse';
$string['allmodules'] = 'Alle Modules';
$string['allunits'] = 'Alle Eenhede';
$string['alwaysdisplay'] = 'Vertoon Altyd';
$string['analyticscleanurl'] = 'Skoon URL\'e';
$string['analyticscleanurldesc'] = 'Genereer skoon URL vir gevorderde volging';
$string['analyticsenabled'] = 'Ontsper';
$string['analyticsenableddesc'] = 'Ontsper Analytics vir Moodle';
$string['analyticsheading'] = 'Google Analytics';
$string['analyticssiteid'] = 'Werf-ID';
$string['analyticssiteiddesc'] = 'Voer jou Werf-ID in';
$string['analyticstrackadmin'] = 'Volg Admins';
$string['analyticstrackadmindesc'] = 'Ontsper volging van Admingebruikers (nie aanbeveel nie)';
$string['analyticstrackingid'] = 'Werf-ID';
$string['analyticstrackingiddesc'] = 'Voer jou Volging-ID van Google in';
$string['backgroundfixed'] = 'Agtergrond vasgeheg';
$string['backgroundfixed_desc'] = 'Gebruik hierdie verstelling om die agtergrondprent aan die bladsy vas te heg.';
$string['backgroundimage'] = 'Agtergrondprent';
$string['backgroundimage_desc'] = 'Die prent om as agtergrond van die werf te vertoon.';
$string['backgroundimageinfo'] = 'Agtergrondprent';
$string['backgroundimageinfodesc'] = 'Omdat die hoofinhoud volbreedte is, sal jy slegs \'n klein gedeelte van agtergrondkleur heel onder op die bladsy kan sien. Jy kan \'n prent oplaai, indien so verkies.';
$string['backgroundposition'] = 'Agtergrondposisie';
$string['backgroundposition_desc'] = 'Die posisie van die agtergrondprent.';
$string['backgroundpositioncenterbottom'] = 'Middel Onder';
$string['backgroundpositioncentercenter'] = 'Middel Middel';
$string['backgroundpositioncentertop'] = 'Middel Bo';
$string['backgroundpositionleftbottom'] = 'Links Onder';
$string['backgroundpositionleftcenter'] = 'Links Middel';
$string['backgroundpositionlefttop'] = 'Links Bo';
$string['backgroundpositionrightbottom'] = 'Regs Onder';
$string['backgroundpositionrightcenter'] = 'Regs Middel';
$string['backgroundpositionrighttop'] = 'Regs Bo';
$string['backgroundrepeat'] = 'Agtergrond herhaling';
$string['backgroundrepeat_desc'] = 'Definieer hoe die agtergrondprent herhaal sal word.';
$string['backgroundrepeatnorepeat'] = 'Geen herhaling';
$string['backgroundrepeatrepeat'] = 'Herhaal';
$string['backgroundrepeatrepeatx'] = 'Herhaal horisontaal';
$string['backgroundrepeatrepeaty'] = 'Herhaal vertikaal';
$string['blockbordercolor'] = 'Blokrantkleur';
$string['blockbordercolor_desc'] = 'Dit is die kursus se blokrantkleur. Dit is die agtergrondkleur van die titelarea.';
$string['blockcolor'] = 'Blokkleur';
$string['blockcolor_desc'] = 'Dit is die kursus se blokagtergrondkleurarea.';
$string['blockheadercolor'] = 'Blokhofiekleur';
$string['blockheadercolor_desc'] = 'Dit is die agtergrondkleur van die opskrif in elke blok. Gebruik hierdie verstelling as jy een agtergrondhofiekleur vir alle blokke wil hê.';
$string['blockposition'] = 'Belyn Blokke';
$string['blockposition_desc'] = 'Plaas die blokke links of regs van die inhoud.';
$string['blocksdesc'] = 'Belyn blokke links of regs van die bladsy.';
$string['blocksinfo'] = 'Blokposisie';
$string['blocksleft'] = 'Belyn blokke op linkerhand';
$string['blocksright'] = 'Belyn blokke op regterhand';
$string['blocktitlecolor'] = 'Bloktiteltekskleur';
$string['blocktitlecolor_desc'] = 'Dit dis die bloktiteltekskleur.';
$string['bodybackground'] = 'Agtergrondkleur';
$string['bodybackground_desc'] = 'Die hoofkleur om vir die agtergrond te gebruik.';
$string['bodyfont'] = 'Liggaamfont';
$string['bodyfontdesc'] = 'LIGGAAM STAP 2: Kopieer en plak die Google-fontkode wat met fontfamilie begin (integreer die fonte in jou CSS)';
$string['bodysize'] = 'Liggaamteksgrootte';
$string['bodysizedesc'] = 'Gebruik \'n getal, soos 14 px';
$string['bodyweight'] = 'Liggaamsgewig';
$string['bodyweightdesc'] = 'Google Fonts sal gewoonlik \'n getal hê, soos 100, 200, 300, ens. Gebruik dit hier.';
$string['bothpositions'] = 'Beide Posisies';
$string['breadcrumbcolor'] = 'Breadcrumb-kleur';
$string['breadcrumbcolor_desc'] = 'Kies \'n agtergrondkleur vir die breadcrumb-stafie. Dit is net onder die hoof hofieprent op die bladsy.';
$string['breadcrumbcolorhover'] = 'Breadcrumb-sweefkleur';
$string['breadcrumbcolorhover_desc'] = 'Kies \'n agtergrondprent vir die breadcrumb-stafie wanneer daar oor \'n item gesweef word. Dit is net onder die hoof hofieprent op die bladsy.';
$string['breadcrumbtext'] = 'Breadcrumb-tekskleur';
$string['breadcrumbtext_desc'] = 'Kies \'n kleur vir die breadcrumb-teks.';
$string['choosereadme'] = '<p>Pioneer is \'n pragtige, responsiewe tema, belaai met wonderlike funksies, van doelgemaakte oortjies en \'n kursuspunteboekglyer, tot die moontlikheid dat onderwysers hul eie hofieprent in die kursusopsommingsdokumente kan oplaai. Elk van die hoofelemente in die tema kan vanuit die temaverstellingsblad doelgemaak word. Pioneer is in Michigan gemaak, by Dearborn Openbare Skole.</p><p>Ons is \'n K-12-skooldistrik in Dearborn, Michigan. Pioneer is Dearborn Hoërskool se gelukbringer.</p>';
$string['colorheading'] = 'Kleuropsies';
$string['configtitle'] = 'Pioneer';
$string['contentbackground'] = 'Hoofinhoudagtergrondkleur';
$string['contentbackground_desc'] = 'Die agtergrondkleur van die hoofinhoud van die werf, laat leeg vir geen.';
$string['contentbackgroundcolor'] = 'Inhoudagtergrondkleur';
$string['contentbackgroundcolor_desc'] = 'Dit is die agtergrondkleur van die hoofkursusinhoudarea. As jy die kleur hier uitwis, sal dit per verstek terugkeer na die Liggaamagtergrond hieronder, asook na die agtergrondprentverstellings.';
$string['copyrighttext'] = 'Kopieregkennisgewing';
$string['copyrighttext_desc'] = 'Voeg \'n kopieregkennisgewing vir die werf by. Dit sal in die onderskrif verskyn.';
$string['coursecomplete'] = 'Radiale Kursusvoltooiingsvertoon';
$string['coursecomplete_desc'] = 'As \'n kursus van kursusvoltooiing gebruik maak en dit aangeskakel is, sal Pioneer \'n radiale voltooiingstatus vir die student linksbo op die bladsy vertoon.';
$string['coursegradebutton'] = 'Kursuspunte';
$string['coursegradeinfo'] = 'Kursushofiearea (Voorbladoortjies & Kursuspunte)';
$string['coursegradeinfodesc'] = 'Hierdie verstellings beheer die glyerknoppie wat op die tuisblad en hoof-kursusblad voorkom. Die kursuspunte toon \'n lys van alle puntitems en die gepaardgaande punt van die student. Die voorbladoortjies vereis dat jy inhoud by die oortjies op die Voorbladoortjies-verstellingsblad voeg. Die kursusverstellings onder Voorkoms moet op JA gestel wees vir Vertoon Punteboek aan Studente, vir kursuspunte om te kan verskyn.';
$string['coursegradestext'] = 'Kursuspunte-knoppieteks';
$string['coursegradestextdesc'] = 'Voer die teks wat jy op die tokkelknoppie wil hê, in.';
$string['coursegradetoggle'] = 'Vertoon/Versteek Kursuspuntglyer';
$string['coursegradetoggle_desc'] = 'Dit sal studente toelaat om vinnig \'n lys van alle aktiwiteite en hul punt reg in die boonstie hofie, bokant die breadcrumbs en onder die kursustitel, te sien.';
$string['coursetitlebkg'] = 'Kursustitel-agtergrondkleur';
$string['coursetitlebkg_desc'] = 'Dit is die kleur van die boks wat agter die Kursustitel verskyn. Dit word ook gebruik as die agtergrondkleur vir die Kursus-Skyfievertoning en Beskikbare Kursusse-titels, om \'n konsekwente voorkoms te skep.';
$string['coursetitletxt'] = 'Kurustitel-tekskleur';
$string['coursetitletxt_desc'] = 'Dit is die kleur van die kursustitel.';
$string['createusertoggle'] = 'Skep Gebruikerskakel';
$string['createusertoggle_desc'] = 'Vertoon of versteek die Skep Gebruikerskakel in die doelgemaakte intekenvorm op die voorblad.';
$string['customcss'] = 'Doelgemaakte CSS';
$string['customcssdesc'] = 'Watter CSS-reëls jy ook al by hierdie teksarea voeg, sal op elke bladsy weerspieël word, wat die doelmaak van hierdie tema vergemaklik.';
$string['customlogindesc'] = 'Doelgemaakte Intekenopsies';
$string['customlogininfo'] = 'Doelgemaakte Intekening';
$string['custommenudesc'] = 'Verstellings hier sal jou toelaat om nuwe, dinamiese funksionaliteit by die doelgemaakte kieslys (ook bekend as Aftrekkieslys) te voeg.';
$string['custommenuheadingsub'] = 'Voeg addisionele funksionaliteit by jou doelgemaakte kieslys.';
$string['displayafterlogin'] = 'Vertoon slegs ná intekening';
$string['displaybeforelogin'] = 'Vertoon slegs voor intekening';
$string['displaymycourses'] = 'Vertoon ingeskrewe kursusse';
$string['displaymycoursesdesc'] = 'Vertoon ingeskrewe kursusse vir gebruikers in die Doelgemaakte Kieslys';
$string['displaymydashboard'] = 'Vertoon Paneelbord';
$string['displaymydashboarddesc'] = 'Vertoon Paneelbord van gebruikerskakels in die Doelgemaakte Kieslys';
$string['dontdisplay'] = 'Vertoon Nooit';
$string['editoff'] = 'Wysig Af';
$string['editon'] = 'Wysig Aan';
$string['enablethiscourse'] = 'Kursusaktiwiteitkieslys';
$string['enablethiscoursedesc'] = 'Vertoon \'n aftrekkieslys van kursusaktiwiteite';
$string['footertext1'] = 'Onderskrifteksboks Een';
$string['footertext2'] = 'Onderskrifteksboks Twee';
$string['footertext3'] = 'Onderskrifteksboks Drie';
$string['footertext4'] = 'Onderskrifteksboks Vier';
$string['footertext_desc'] = 'Voer HTML-teks in en dit sal onderaan elke bladsy verskyn. Vier kolomme word met Bootstrap gebruik <span3>.';
$string['footertextboxes'] = 'Doelgemaakte Onderskrif';
$string['forgotpasstoggle'] = 'Wagwoord Vergeet-skakel';
$string['forgotpasstoggle_desc'] = 'Vertoon of versteek die Wagwoord Vergeet-skakel in die doelgemaakte intekenvorm op die voorblad.';
$string['fpcreatortextbox'] = 'Voorblad Kursusskepper-gebruikerrolteksboks';
$string['fpcreatortextbox_desc'] = 'Voeg inhoud by wat slegs sigbaar is vir gebruikers met die Kursusskepperrol.';
$string['fpdashboard'] = 'Voorbladpaneelbord';
$string['fpheaderimagepadding'] = 'Voorbladhofieprentopvulling';
$string['fpheaderimagepadding_desc'] = 'Beheer die opvulling en hoogte van die hofieprent van die voorblad. Hierdie verstelling word bo en onder die intekenvorm vir uitgetekende gebruikers toegepas.';
$string['fpsearch'] = 'Deursoek kursusse';
$string['fpsearchboxmain'] = 'Vertoon Kursus-soekboks in Hoofinhoudarea';
$string['fpsearchboxmain_desc'] = 'Vertoon \'n kursus-soekboks in die voorblad-teksboksarea. Hierdie opsie is afhanklik van die ikoonnavigasieverstellings en sal slegs vertoon word as ikoonnavigasie gestel is om in die hoofinhoudarea te vertoon.';
$string['fpsearchboxtop'] = 'Vertoon Kursus-soekboks in Boonste Navigasie';
$string['fpsearchboxtop_desc'] = 'Vertoon \'n kursus-soekboks in die boonste navigasiestafie. Dit sal regs van die ikoonnavigasie, boaan die bladsy, verskyn en kan vertoon word selfs as die ikoonnavigasie versteek is. Die soekboks is nie afhanklik van ikoonnavigasieverstellings nie.';
$string['fpsearchbutton'] = 'Soek';
$string['fptextbox'] = 'Voorbladteksboks';
$string['fptextboxdesc'] = 'Hierdie teksboks verskyn op die voorblad en is ideaal vir \'n welkomboodskap.';
$string['fptextboxinfo'] = 'Voorblad-Welkomboks';
$string['fptextboxinfodesc'] = 'Voeg \'n verwelkomingsboodskap vir gebruikers by.';
$string['fptoppromotedpadding'] = 'Hoogte van Kursus-skyfievertoning';
$string['fptoppromotedpadding_desc'] = 'Dit sal die hoogte van die kursusprent-skyfievertoning beheer.';
$string['frontpagecoursesettings'] = 'Voorbladkursusse';
$string['frontpagedesc'] = 'Konfigureer hoe die kursusbokse op die voorblad uitgebeeld word.';
$string['frontpageheading'] = 'Voorbladopsies';
$string['frontpagerenderer'] = 'Voorbladkursusbokse';
$string['frontpagerendererdefaultimage'] = 'Verstek kursusprent';
$string['frontpagerendererdefaultimagedesc'] = 'Die verstek prent om te gebruik wanneer geen kursusprent gevind word nie (slegs van toepassing op Teëls met oorlegging)';
$string['frontpagerendererdesc'] = 'Beheer hoe die kursusbokse op die voorblad uitgebeeld word.';
$string['frontpagerendereroption1'] = 'Teëls';
$string['frontpagerendereroption2'] = 'Teëls met oorlegging';
$string['frontpagesettingsheading'] = 'Voorbladuitbeelding';
$string['fullfootertext'] = 'Volbreedte Onderskrifteksboks';
$string['fullfootertext_desc'] = 'Dit is \'n volbreedte teksboks wat in die onderskrif, bo die 4 kolomteksbokse verskyn. Dit is ideaal as jy nie die 4 kolomteksbokse hieronder wil gebruik nie.';
$string['gbodyimporturl'] = 'Liggaaminvoer-URL';
$string['gbodyimporturldesc'] = 'LIGGAAM STAP 1: Vind \'n voorblad op google.com/fonts. Kliek die quick use-ikoon. Vind die stap wat sê "Add this code to your website". Kopieer en plak dit hier. Maak seker dat jy LIGGAAM STAP 2 voltooi. <a href="https://www.google.com/fonts"> Find a Google Font</a>';
$string['geneicsettings'] = 'Algemene Verstellings';
$string['generalalert'] = 'Algemene Waarskuwing';
$string['generalalertdesc'] = 'Wat jy ook al by hierdie teksarea voeg, sal in die Algemene Waarskuwing-area op die voorblad vertoon word.';
$string['gheadingimporturl'] = 'Opskrifinvoer-URL';
$string['gheadingimporturldesc'] = 'OPSKRIF STAP 1: Vind \'n font op google.com/fonts. Kliek die quick use-ikoon. Vind die stap wat sê "Add this code to your website". Kopieer en plak dit hier. Maak seker dat jy OPSKRIF STAP 2 voltooi. <a href="https://www.google.com/fonts"> Find a Google Font</a>';
$string['googleheading'] = 'Google Fonte';
$string['gradecomplete'] = 'Radiale Kursuspunttotaal';
$string['gradecomplete_desc'] = 'As \'n kursus gestel is om studentpunte te vertoon en hierdie aangeskakel is, sal Pioneer \'n kursustotaalpunt in \'n geanimeerde radiaal vir die student linksbo op die bladsy vertoon.';
$string['grades'] = 'My Punte';
$string['headerbackgroundimage'] = 'Verstek Hofieprent';
$string['headerbackgroundimage_desc'] = 'Dit is die verstek hofieprent.';
$string['headerbackgroundtoggle'] = 'Laat onderwysers toe om hofieprent op te laai';
$string['headerbackgroundtoggle_desc'] = 'Indien aangeskakel, kan \'n onderwyser \'n prent oplaai na <a href="https://docs.moodle.org/29/en/Course_settings#Course_summary_files" target="_new">Kursusopsommingdokumente</a>. Hierdie prent behoort klein te wees, om laaityd te verminder. Aanbevole grootte is 1024 breed en minder as 500 kb in grootte. Andersins sal alle kursusse die foto wat jy oplaai as hofieprent gebruik.';
$string['headerimageinfo'] = 'Hofieprenthoogte';
$string['headerimageinfodesc'] = 'Hierdie verstellings beheer die hoogte van die hofieprent op die werf en in-kursusaktiwiteite.';
$string['headerimagepadding'] = 'Hofieprentopvulling';
$string['headerimagepadding_desc'] = 'Beheer die opvulling en hoogte van die hofieprent van kursusse. \'n Minimum van 120 px behoort gekies te word as die Radiale Voltooiing- en Kursuspunt-vertoon gebruik word.';
$string['headerimagepage'] = 'Hofieprentverstellings';
$string['headerincourseimagepadding'] = 'Hofieprentopvulling in Kursusaktiwiteite (in-kursus)';
$string['headerincourseimagepadding_desc'] = 'Ná die kursustuisblad sal dit die opvullinghoogte van die hofieprent wees. Om dit korter te maak, sal toelaat dat meer inhoud vertoon word.';
$string['headingfont'] = 'Opskriffontfamilie';
$string['headingfontdesc'] = 'OPSKRIF STAP 2: Kopieer en plak die Google fontfamilie-inligting hier.';
$string['iconnavbackgroundcolor'] = 'Hoofinhoud-ikoon en Soekboks-navigasieagtergrond';
$string['iconnavbackgroundcolor_desc'] = 'Dit is die agtergrondkleur van die ikoonnavigasie en soekboksarea in die hoofinhoudarea.';
$string['iconnavbackgroundcolortop'] = 'Boonste Ikoon- en Soekboks-navigasieagtergrond';
$string['iconnavbackgroundcolortop_desc'] = 'Dit is die agtergrondkleur van die ikoonnavigasie en soekboksarea heel bo op die bladsy.';
$string['iconnavheading'] = 'Ikoonnavigasie';
$string['inmaincontent'] = 'Slegs Hoofinhoud';
$string['intopnav'] = 'Slegs Boonste Navstafie';
$string['invert'] = 'Ruil navstafie om';
$string['invertdesc'] = 'Ruil teks en agtergrond van die navstafie boaan die bladsy tussen swart en wit.';
$string['lginforgot'] = 'vergeet?';
$string['lginlogin'] = 'Teken In';
$string['lginpass'] = 'wagwoord';
$string['lginuser'] = 'gebruikersnaam';
$string['linkcolor'] = 'Skakelkleur';
$string['linkcolor_desc'] = 'Die kleur van die skakels.';
$string['loginbuttoncolor'] = 'Kleur van Intekenknoppie';
$string['loginbuttoncolor_desc'] = 'Dit is die kleur van die knoppie in die doelgemaakte intekenvorm.';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Die logo behoort 140 px by 40 px te wees. Die logo word in die linker-boonste en regter-onderste kant van die tema vertoon.';
$string['marketboxbuttoncolor'] = 'Kleur van Bemarkingsboksknoppie';
$string['marketboxbuttoncolor_desc'] = 'Die kleur van die knoppieagtergrond van die bemarkingsboks.';
$string['marketboxcolor'] = 'Agtergrondkleur van Bemarkingsboks';
$string['marketboxcolor_desc'] = 'Die kleur van die Bemarkingsboks se agtergrond.';
$string['marketboxcontentcolor'] = 'Agtergrondkleur van Bemarkingsboks se Inhoud.';
$string['marketboxcontentcolor_desc'] = 'Die agtergrondkleur van die bemarkingsboks se inhoud. Dit is waar die teks in die bemarkingsplek verskyn en kan anders wees as die boksagtergrondkleur, om die aandag na die teks te trek.';
$string['marketing1'] = 'Bemarkingsplek Een';
$string['marketing2'] = 'Bemarkingsplek Twee';
$string['marketing3'] = 'Bemarkingsplek Drie';
$string['marketing4'] = 'Bemarkingsplek Vier';
$string['marketing5'] = 'Bemarkingsplek Vyf';
$string['marketing6'] = 'Bemarkingsplek Ses';
$string['marketingbuttontext'] = 'Skakelteks';
$string['marketingbuttontextdesc'] = 'Teks wat op die knoppie moet verskyn.';
$string['marketingbuttonurl'] = 'Skakel-URL';
$string['marketingbuttonurldesc'] = 'URL waarna die knoppie sal wys.';
$string['marketingcontent'] = 'Inhoud';
$string['marketingcontentdesc'] = 'Inhoud om in die bemarkingsboks te vertoon. Hou dit kort en kragtig.';
$string['marketingdesc'] = 'Hierdie tema bied die opsie om drie "bemarking-" of "advertensie"-plekke net onder die skyfievertoning te ontsper. Dit sal jou toelaat om maklik kerninligting aan jou gebruikers te identifiseer en direkte skakels te verskaf.';
$string['marketingheading'] = 'Bemarkingsplekke Onder';
$string['marketingheadingsub'] = 'Drie plekke op die voorblad om inligting en skakels te voeg.';
$string['marketingheadingtextbox'] = 'Bemarkingsplekke Boonste Teksboks';
$string['marketingheadingtop'] = 'Bemarkingsplekke Bo';
$string['marketingheight'] = 'Hoogte van Bemarkingsprente';
$string['marketingheightdesc'] = 'As jy prente in die Bemarkingsbokse wil vertoon, kan jy die hoogte hier spesifiseer.';
$string['marketingicon'] = 'Skakelikoon';
$string['marketingicondesc'] = 'Naam van die ikoon wat jy in die bemarking-URL-knoppie wil gebruik. Die lys is <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">hier</a>. Voer net in wat ná "fa-" is, bv. "star".';
$string['marketingimage'] = 'Prent';
$string['marketingimage_desc'] = 'Dit verskaf die opsie om \'n prent in die bemarkingsplek te vertoon.';
$string['marketinginfodesc'] = 'Voer die verstellings van jou bemarkingsplek in.';
$string['marketingtitle'] = 'Titel';
$string['marketingtitledesc'] = 'Titel om in hierdie bemarkingsplek te vertoon.';
$string['marketingurltarget'] = 'Skakelteiken';
$string['marketingurltargetdesc'] = 'Kies hoe die skakel oopgemaak moet word.';
$string['marketingurltargetnew'] = 'Nuwe Bladsy';
$string['marketingurltargetparent'] = 'Moederraam';
$string['marketingurltargetself'] = 'Huidige Bladsy';
$string['mybkg'] = 'My Kursusse-glyeragtergrond';
$string['mybkg_desc'] = 'Kies \'n kleur vir die My Kursusse-glyeragtergrond.';
$string['myclasses'] = 'My Klasse';
$string['mycorusesinfo'] = 'Navigasiekieslysopsies';
$string['mycorusesinfodesc'] = 'Hierdie verstellings beheer die boonste navigasiestafie. Dit sluit in die My Kursusse-aftreklys en Hierdie Kursus-aftreklys.';
$string['mycourses'] = 'My Kursusse';
$string['mycoursesheading'] = 'My Kursusse-glyer';
$string['mycoursesheadingdesc'] = 'Dit sal kursusse waarvoor \'n gebruiker ingeskryf is of in onderrig, vertoon. Dit word in \'n pragtige, responsiewe glyer vertoon. Beste geskik vir werkskermpresentering.';
$string['mycoursesinfo'] = 'Dinamiese Ingeskrewe Kursusse-lys';
$string['mycoursesinfodesc'] = 'Vertoon \'n dinamiese lys van ingeskrewe kursusse aan die gebruiker.';
$string['mycoursetitle'] = 'Terminologie.';
$string['mycoursetitledesc'] = 'Verander die terminologie van die "My Kursusse"-skakel in die aftrekkieslys.';
$string['mydashboardinfo'] = 'Doelgemaakte Gebruikerpaneelbord';
$string['mydashboardinfodesc'] = 'Vertoon \'n lys algemene funksies wat deur gebruikers gebruik word.';
$string['mymodules'] = 'My Modules';
$string['myunits'] = 'My Eenhede';
$string['navbkgcolor'] = 'Hoof navigasieagtergrond';
$string['navbkgcolor_desc'] = 'Dit is die agtergrondkleur van die hoof navigasiestafie.';
$string['navcolor'] = 'Navstafie-aftrekkleur';
$string['navcolor_desc'] = 'Die kleur van die aftrekkieslys in die navigasiestafie.';
$string['navcolorhover'] = 'Navstafie-aftrekkleur tydens Sweef';
$string['navcolorhover_desc'] = 'Die kleur van die aftrekkieslys in die navigasiestafie met oorrol.';
$string['navicon'] = 'Ikoon';
$string['navicon1'] = 'Doelgemaakte Voorbladikoon Een';
$string['navicon2'] = 'Doelgemaakte Voorbladikoon Twee';
$string['navicon3'] = 'Doelgemaakte Voorbladikoon Drie';
$string['navicon4'] = 'Doelgemaakte Voorbladikoon Vier';
$string['navicon5'] = 'Doelgemaakte Voorbladikoon Vyf';
$string['navicon6'] = 'Doelgemaakte Voorbladikoon Ses';
$string['navicon7'] = 'Doelgemaakte Voorbladikoon Sewe';
$string['navicon8'] = 'Doelgemaakte Voorbladikoon Agt';
$string['naviconbuttontext'] = 'Nutswenkteks';
$string['naviconbuttontextdesc'] = 'Teks wat in die nutswenk van die ikoon moet vertoon wanneer die muis daaroor sweef.';
$string['naviconbuttonurl'] = 'Skakel-URL';
$string['naviconbuttonurldesc'] = 'URL waarna die knoppie sal wys. Jy kan na enige plek skakel, insluitende eksterne webwerwe; voer net die korrekte URL in. As jou Moodle-werf in \'n subgids is, sal die verstek URL nie werk nie. Verander asseblief die URL om die subgids te weerspieël. Byvoorbeeld: as "moodle" jou subgidslêer is, sal die URL na /moodle/my/ moet verander.';
$string['navicondesc'] = 'Naam van die ikoon wat jy wil gebruik. Die lys is <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">hier</a>. Voer net in wat ná "fa-" is, bv. "star".';
$string['naviconoff'] = 'Skakel doelgemaakte navigasie-ikone af';
$string['naviconon'] = 'Skakel doelgemaakte navigasie-ikone aan';
$string['navigation'] = 'Navigasie-opsies';
$string['noenrolments'] = 'Jy het tans geen inskrywings nie.';
$string['pcourseenable'] = 'Ontsper Hoofkursusse';
$string['pcourses'] = 'Onderste Hoofkursusse';
$string['pcoursesdesc'] = 'Verskaf asseblief die kursusse wat aangedui word; moet deur komma geskei word.';
$string['people'] = 'Klasmaats';
$string['pluginname'] = 'Pioneer';
$string['promotedcoursesheading'] = 'Onderste Hoofkursusse-glyer';
$string['promotedlink'] = 'Hoof-Besigtig Meer Kursusse-URL';
$string['promotedlink_desc'] = 'Voer \'n URL na een van jou kursuskategorieë in. Dit word langs die hoofkursusse-titel vertoon.';
$string['promotedlinktext'] = 'Hoof-Besigtig Meer Kursusse-Teks';
$string['promotedlinktext_desc'] = 'Dit bied die opsie om na \'n kursuskategorie te skakel om meer kursusse in die onderste hoof-glyer te vertoon. Voer \'n URL hieronder in.';
$string['promotedmylink'] = 'My Kursusse-glyer Besigtig Meer Kursusse-URL';
$string['promotedmylink_desc'] = 'Voeg \'n URL na een van jou kursuskategorieë in. Dit word langs die My Kursusse-glyertitel vertoon.';
$string['promotedmylinktext'] = 'My Kursusse-glyer Besigtig Meer Kursusse-teks';
$string['promotedmylinktext_desc'] = 'Dit bied die opsie om na \'n kursuskategorie te skakel om meer kursusse te vertoon. Voer \'n URL hieronder in.';
$string['promotedmytextbox'] = 'My Kursusse-Glyer Beskrywingteksboks';
$string['promotedmytextbox_desc'] = '\'n Teksboks wat met die My Kursusse-glyerblok verskyn.';
$string['promotedmytitle'] = 'My Kursusse-glyertitel';
$string['promotedmytitledesc'] = 'Verskaf asseblief \'n titel vir die My Kursusse-glyerblok.';
$string['promotedtaglink'] = 'Aanbevole Besigtig Meer Kursusse-URL';
$string['promotedtaglink_desc'] = 'Voer \'n URL na een van jou kursuskategorieë in. Dit word langs die hoof-kursussetitel vertoon.';
$string['promotedtaglinktext'] = 'Aanbevole Besigtig Meer Kursusse-teks';
$string['promotedtaglinktext_desc'] = 'Dit bied \'n opsie om na \'n kursuskategorie te skakel om meer kursusse te vertoon. Voer \'n URL hieronder in.';
$string['promotedtagtextbox'] = 'Gepersonaliseerde Beskrywing-teksboks';
$string['promotedtagtextbox_desc'] = 'Gebruik dit om aan die gebruiker te verduidelik hoe om profielmerkers en kursusmerkers by te voeg, sodat aanbevole kursusse vir die gebruiker sal verskyn.';
$string['promotedtagtitle'] = 'Gepersonaliseerde Aanbevole Kursusse-titel';
$string['promotedtagtitledesc'] = 'Verskaf asseblief aan die Gepersonaliseerde Aanbevole Kursusse-blok \'n titel.';
$string['promotedtitledefault'] = 'Hoofkursusse';
$string['promotedtitledesc'] = 'Verskaf asseblief \'n titel aan die Gepromoveerde kursusse-blok.';
$string['radialboxbackground'] = 'Radiale Kursuspunt en Voltooiing Agtergrond';
$string['radialboxbackground_desc'] = 'Dit is die agtergrondkleur van die boks wat die Kursuspunttotaal en Kursusvoltooiingradiaal-elemente links bo op die kursusbladsye vertoon.';
$string['radialcolor'] = 'Radiale Sirkelkleur';
$string['radialcolor_desc'] = 'Stel die kleur van die radiale sirkel.';
$string['recommendedbkg'] = 'Kleur van Veelvuldige Glyeragtergrond';
$string['recommendedbkg_desc'] = 'Hierdie kleur sal op Hoofkursusse-, Gepersonaliseerde Aanbevole Kursusse-, en My Kursusse-glyers toegepas word. Dit kom op die voorblad voor.';
$string['recommendedcoursesheading'] = 'Gepersonaliseerde Aanbevole Kursusse-glyer';
$string['recommendedcoursesheadingdesc'] = 'Gepersonaliseerde Aanbevole Kursusse-glyer sal gebruikermerkers (belangstellings) met kursusmerkers ooreen laat stem. Wanneer \'n pasmaat gevind word, sal die gevolglike kursuslys vertoon word in \'n pragtige, resonsiewe glyer op die voorblad. Hierdie verstelling is outomaties en geen interaksie word vereis behalwe die verskaf van merkers vir kursusse en gebruikerprofiele nie.';
$string['region-side-post'] = 'Regs';
$string['region-side-pre'] = 'Links';
$string['rendereroverlaycolor'] = 'Oorleggingkleur';
$string['rendereroverlaycolordesc'] = 'Die kleur van die oorlegging, wanneer die "Teëls met oorlegging"-uitbeelder gekies is.';
$string['rendereroverlayfontcolor'] = 'Kleur van Oorleggingfont';
$string['rendereroverlayfontcolordesc'] = 'Die kleur van die font wanneer oor \'n kursusboks, met "Teëls met oorlegging"-uitbeelder ontsper, gesweef word.';
$string['secondarybackground'] = 'Sekondêre agtergrondkleur';
$string['secondarybackground_desc'] = 'Die agtergrondkleur van enige sekondêre inhoud, soos blokke.';
$string['sectionheadericon'] = 'Afdelingtitel-ikoon';
$string['sectionheadericondesc'] = 'Hierdie ikoon verskyn voor die titel van elke onderwerp vir weeklikse en onderwerp-gebaseerde kursusformate. Gebruik die unicode-verstelling van Font Awesome. Die lys is <a href="https://fortawesome.github.io/Font-Awesome/icons/" target="_new">hier</a>. Die \\f02d (verstek) ikoon is \'n boek.';
$string['settingfeaturedmyslider'] = 'My Ingeskrewe Kursusse';
$string['settingfeaturedslider'] = 'Hoofkursusse';
$string['settingfeaturedtagslider'] = 'Gepersonaliseerde Aanbevole Kursusse';
$string['settinggradebutton'] = 'Besigtig Kursuspunte';
$string['settingpromotedlink'] = 'voorbeeld: http://mymoodlesite/course/';
$string['settingpromotedlinktext'] = 'Hoof-Besigtig Meer Kursusse';
$string['settingpromotedmylink'] = 'voorbeeld: http://mymoodlesite/course/';
$string['settingpromotedmylinktext'] = 'My Kursusse-glyer Besigtig Meer Kursusse';
$string['settingpromotedtaglink'] = 'voorbeeld: http://mymoodlesite/course/';
$string['settingpromotedtaglinktext'] = 'Aanbevole Besigtig meer Kursusse';
$string['settingshowtagline'] = 'Skryf Nou In';
$string['settingtabbutton'] = 'Kom Aan Die Gang met Moodle';
$string['showlogintoggle'] = 'Vertoon Intekenvorm';
$string['showlogintoggle_desc'] = 'Vertoon of versteek die doelgemaakte intekenvorm op die voorblad.';
$string['showmycourses'] = 'Vertoon/Versteek My Kursusse-glyer';
$string['showmycourses_desc'] = 'Ontmerk dit as jy nie die My Kursusse-glyer wil vertoon nie.';
$string['showrecommendedcourses'] = 'Vertoon/Versteek Gepersonaliseerde Aanbevole Kursusse';
$string['showrecommendedcourses_desc'] = 'Ontmerk dit as jy nie gepersonaliseerde aanbevole kursusse wil vertoon nie.';
$string['signuplogin'] = 'Skep Nuwe';
$string['socialicon1'] = 'Facebook-URL';
$string['socialicon2'] = 'Twitter-URL';
$string['socialicon3'] = 'Pinterest-URL';
$string['socialicon4'] = 'Flickr-URL';
$string['socialicon5'] = 'LinkedIn-URL';
$string['socialicon6'] = 'YouTube-URL';
$string['socialicon7'] = 'Vimeo-URL';
$string['socialicon8'] = 'Google Plus-URL';
$string['socialiconheading'] = 'Sosiale Ikoon-navigasie';
$string['socialwallheaddesc'] = 'Socialwall-kursusformaat is \'n stel kursusformaatinvoegtoepassings vir Moodle wat aan onderwysers \'n maklik bruikbare kursus verskaf, wat soortgelyk aan Facebook funksioneer. Jy kan die Socialwall-kursusformaat by Moodle.org aflaai <a href="https://moodle.org/plugins/browse.php?list=set&id=74">https://moodle.org/plugins/browse.php?list=set&id=74</a>. Die verstellings hieronder laat toe dat jy die kleure van die socialwall doelmaak.';
$string['socialwallheading'] = 'Socialwall-kursusformaatopsies';
$string['stylinginfo'] = 'Stilering en Waarskuwings';
$string['stylinginfodesc'] = 'Addisionele doelmaakopsies en waarskuwingsverstellings';
$string['swaddpost'] = 'Socialwall-kursusformaat Voeg Plasing By-agtergrond';
$string['swaddpost_desc'] = 'As jy die Socialwall-kursusformaat gebruik, sal hierdie verstelling die agtergrondkleur van die Voeg Plasings By-area in die muurvoer verander.';
$string['swattach'] = 'Socialwall-kursusformaat Aanhegsel-agtergrond';
$string['swattach_desc'] = 'As jy die Socialwall-kursusformaat gebruik, sal hierdie verstelling die agtergrondkleur van die aanhegselarea in die muurvoer verander.';
$string['swcomment'] = 'Socialwall-kursusformaat Kommentaaragtergrond';
$string['swcomment_desc'] = 'As jy die Socialwall-kursusformaat gebruik, sal hierdie verstelling die agtergrondkleur van die kommentaararea in die muurvoer verander.';
$string['swicontext'] = 'Socialwall-kursusformaat Ikoon- en Tekskleure';
$string['swicontext_desc'] = 'As jy die Socialwall-kursusformaat gebruik, sal hierdie verstelling die kleur van die ikone en woorde, aanhegsels, plasings, boodskappe en kommentaar in die muurvoer verander.';
$string['swlabelattachment'] = 'Aanhegsel-CSS-Etiket';
$string['swlabelattachment_desc'] = 'Wanneer daar aanhegsels by \'n plasing is, sal hierdie etiket die aanhegsels identifiseer.';
$string['swlabelcomment'] = 'Kommentaar-CSS-Etiket';
$string['swlabelcomment_desc'] = 'Hierdie etiket identifiseer die kommentaarafdeling van elke plasing in die tydlyn.';
$string['swlabelmessage'] = 'Boodskap-CSS-Etiket';
$string['swlabelmessage_desc'] = 'Hierdie boodskapetiket verskyn bokant die inhoud van \'n plasing in die tydlyn.';
$string['swlabelpost'] = 'Plasing-CSS-Etiket';
$string['swlabelpost_desc'] = 'Hierdie etiket verskyn bokant elke plasing in die tydlyn.';
$string['swmessage'] = 'Socialwall-kursusformaat Boodskapagtergrond';
$string['swmessage_desc'] = 'As jy die Socialwall-kursusformaat gebruik, sal hierdie verstelling die agtergrondkleur van die boodskapteksarea in die muurvoer verander.';
$string['swmultilangcss'] = 'Vertaal Socialwall-etikette';
$string['swmultilangcss_desc'] = 'As jy \'n veeltalige werf het, kan jy die verskafde voorbeeld gebruik om die Socialwall-etikette na die tale wat jy ondersteun, te lokaliseer.';
$string['swpost'] = 'Socialwall-kursusformaat Plasingagtergrond';
$string['swpost_desc'] = 'As jy die Socialwall-kursusformaat gebruik, sal hierdie verstelling die agtergrondkleur van plasings in die muurvoer verander.';
$string['tab1'] = 'Oortjie Een';
$string['tab2'] = 'Oortjie Twee';
$string['tab3'] = 'Oortjie Drie';
$string['tab4'] = 'Oortjie Vier';
$string['tab5'] = 'Oortjie Vyf';
$string['tab6'] = 'Oortjie Ses';
$string['tabbutton'] = 'Kom aan die gang';
$string['tabbuttoncolor'] = 'Oortjie-knoppiekleur';
$string['tabbuttoncolor_desc'] = 'Die kleur van die knoppie wat gebruik word om die voorblad se oortjies en kursuspuntglyer te tokkel. Dit verskyn net onder die titel van die bladsy wanneer dit geaktiveer is.';
$string['tabbuttonhovercolor'] = 'Oortjie-knoppiekleur-oorrol';
$string['tabbuttonhovercolor_desc'] = 'Die kleur van die knoppie tydens sweef, wat gebruik word om die voorblad se oortjies en kursuspuntglyer te tokkel. Dit verskyn net onder die titel van die bladsy wanneer dit geaktiveer is.';
$string['tabbuttontext'] = 'Oortjie-knoppieteks';
$string['tabbuttontextdesc'] = 'Hierdie teks word gebruik in die vertoon/versteek knoppie om die oortjies te vertoon.';
$string['tabcontent'] = 'Oortjie-inhoud';
$string['tabcontentdesc'] = 'Die teks en HTML wat jy hier invoer, sal in die oortjie vertoon word.';
$string['tabheading'] = 'Voorbladoortjies';
$string['tabinfodesc'] = 'Voeg \'n titel en beskrywing hieronder in. Dit sal slegs as \'n glyer op die voorblad verskyn. Die knoppie waarmee die glyer geaktiveer word, kan in die boonste hofie gevind word.';
$string['tabtitle'] = 'Oortjie-titel';
$string['tabtitledesc'] = 'Dit is die oortjie-titel wat boaan die oortjie-inhoud verskyn.';
$string['tabtoggle'] = 'Oortjie-tokkel';
$string['tabtoggle_desc'] = 'Vertoon of versteek die tuisbladoortjies.';
$string['textcolor'] = 'Tekskleur';
$string['textcolor_desc'] = 'Die kleur van die teks.';
$string['themecolorsettings'] = 'Temakleure';
$string['thiscourse'] = 'Hierdie Kursus';
$string['title'] = 'Titel';
$string['togglefptextbox'] = 'Vertoon/Versteek Teksboksvertoon';
$string['togglefptextboxdesc'] = 'Kies as jy die Voorbladteksboks op die voorblad aan gebruikers, wat uitgeteken is, wil versteek of vertoon.';
$string['toggleiconnav'] = 'Ikoonnavigasieplek';
$string['toggleiconnav_desc'] = 'Bepaal waar jy die ikone en kursussoekboks wil laat vertoon.';
$string['togglemarketing'] = 'Tokkel Bemarkingsplek-vertoon';
$string['togglemarketingdesc'] = 'Kies of jy die drie Bemarkingsplekke wil versteek of vertoon.';
$string['togglenavicons'] = 'Skakel Doelgemaakte Ikone aan';
$string['togglenaviconsdesc'] = 'Kies om doelgemaakte navigasie-ikone, gebaseer op FontAwesome, in te sluit.';
$string['toolsmenu'] = 'Hulpmiddelkieslys';
$string['toolsmenudesc'] = 'Jy kan skakels om onder \'n hulpmiddelkieslys te vertoon, konfigureer. Elke lyn bestaan uit kieslysteks, \'n skakel-URL (opsioneel), \'n nutswenktitel (opsioneel) en \'n taalkode of komma-geskeide lys kodes (opsioneel, om die lyn slegs aan gebruikers van die gespesifiseerde taal te vertoon), geskei met pypkarakters. Byvoorbeeld:
<pre>
Moodle community|https://moodle.org
-Moodle free support|https://moodle.org/support
-Moodle development|https://moodle.org/development
--Moodle Docs|http://docs.moodle.org|Moodle Docs
--German Moodle Docs|http://docs.moodle.org/de|Documentation in German|de
Moodle.com|http://moodle.com/
</pre>';
$string['toolsmenulabel'] = 'Hulpmiddels';
$string['topclosefeatured'] = 'Sluit Skakel vir Kursuslyste';
$string['topclosefeatureddesc'] = 'Hierdie teks verskyn bokant die hoofkursuslys en sal die lys van hoofkursusse sluit. "Close Course Listing" is die aanbevole teks.';
$string['topclosefeaturedtext'] = 'Close Course Listing';
$string['topichighlight'] = 'Onderwerpbeligtingkleur';
$string['topichighlight_desc'] = 'Kleur wanneer \'n onderwerp of week in \'n kursus belig word.';
$string['topicweekcolor'] = 'Agtergrond van Onderwerp- en Week-afdeling';
$string['topicweekcolor_desc'] = 'In Onderwerp- en Weeklikse kursusformate is hierdie die agtergrondkleur van elke onderwerp of week in die kursus.';
$string['toppcourseenable'] = 'Ontsper Hoofkursusse-skyfievertoning';
$string['toppcourses'] = 'Hoofkursusse-skyfievertoning';
$string['toppcoursesdesc'] = 'BEPERKING=10 Jy kan nie meer as 10 kursus-id\'s invoer nie. Verskaf asseblief die hoofkursus-id\'s met kommas geskei.';
$string['toppromotedcoursesheading'] = 'Hoofkursus-skyfievertoning';
$string['toppromotedtitledefault'] = 'Hoofkursusse';
$string['toppromotedtitledesc'] = 'Hierdie teks verskyn onder die Kursustitel in die glyer. "Skryf Nou In" is \'n ideale merkerlyn.';
$string['topsearch'] = 'Soek Kursusse';
$string['topsearchbutton'] = 'Vind';
$string['topshowfeatured'] = 'Vertoon Alle Kursusse-lysskakel';
$string['topshowfeatureddesc'] = 'Hierdie teks verskyn in die skyfievertoning en sal \'n lys van alle hoofkursusse vertoon. "Besigtig Alle Kursusse" is die aanbevole teks.';
$string['topshowfeaturedtext'] = 'Besigtig Alle Hoofkursusse';
$string['toptitle'] = 'Merkerlyn';
