<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'af', version '5.1'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'word binnekort geïnstalleer';
$string['accept'] = 'Aanvaar';
$string['action'] = 'Aksie';
$string['actionchoice'] = 'Wat wil jy met die lêer \'{$a}\' doen?';
$string['actions'] = 'Aksies';
$string['actionsfor'] = 'Aksies vir {$a}';
$string['actionsmenu'] = 'Aksiekieslys';
$string['active'] = 'Aktief';
$string['activeusers'] = 'Aktiewe gebruikers';
$string['activities'] = 'Aktiwiteite';
$string['activities_help'] = 'Aktiwiteite, soos forums, vasvrae en wiki\'s, maak dit moontlik om interaktiewe inhoud by kursusse te voeg.';
$string['activity'] = 'Aktiwiteit';
$string['activityclipboard'] = 'Besig om hierdie aktwiteit te verskuif: {$a}';
$string['activityheader'] = 'Aktiwiteitskieslys';
$string['activityicon'] = '{$a} ikoon';
$string['activityiscurrentlyhidden'] = 'Jammer, hierdie aktiwiteit is tans verskuil';
$string['activitymodule'] = 'Aktiwiteitmodule';
$string['activitymodules'] = 'Aktiwiteitmodules';
$string['activitynotready'] = 'Aktiwiteit is nog nie beskikbaar nie';
$string['activityorresource'] = 'Aktiwiteit of hulpbron';
$string['activityreport'] = 'Aktiwiteitverslag';
$string['activityreports'] = 'Aktiwiteitverslae';
$string['activityselect'] = 'Kies hierdie aktiwiteit om na elders verskuif te word';
$string['activitysince'] = 'Aktiwiteit sedert {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Aktiwiteit per gebruiker';
$string['add'] = 'Voeg by';
$string['addactivity'] = 'Voeg tans \'n aktiwiteit by...';
$string['addactivitytosection'] = 'Voeg \'n aktiwiteit by afdeling \'{$a}\' by';
$string['addadmin'] = 'Voeg admin by';
$string['addblock'] = 'Voeg \'n blok by';
$string['addcomment'] = 'Voeg tans \'n opmerking by...';
$string['addcondition'] = 'Voeg voorwaarde by';
$string['addcontent'] = 'Voeg inhoud by';
$string['addcountertousername'] = 'Skep gebruiker deur nommer by gebruikernaam te voeg';
$string['addcreator'] = 'Voeg skepper van kursus by';
$string['adddots'] = 'Voeg tans by...';
$string['added'] = '{$a} bygevoeg';
$string['addedtogroup'] = 'Bygevoeg by groep "{$a}"';
$string['addedtogroupnot'] = 'Nie by groep "{$a}" bygevoeg nie';
$string['addedtogroupnotenrolled'] = 'Nie by groep "{$a}" bygevoeg nie omdat nie vir kursus ingeskryf is nie';
$string['addfilehere'] = 'Los lêer(s) hier en voeg dit aan die onderkant van hierdie afdeling by';
$string['addfilesdrop'] = 'Jy kan jou lêers hier sleep en los om op te laai of klik om te kies.';
$string['addinganew'] = 'Nuut {$a}';
$string['addingdatatoexisting'] = 'Byvoeging van data by bestaande';
$string['additionalcustomnav'] = 'Addisionele pasgemaakte navigasie';
$string['additionalnames'] = 'Addisionele name';
$string['addlinkhere'] = 'Voeg webskakel hier by';
$string['addnew'] = 'Voeg \'n nuwe {$a} by';
$string['addnewcategory'] = 'Voeg \'n nuwe kategorie by';
$string['addnewcourse'] = 'Voeg \'n nuwe kursus by';
$string['addnewuser'] = 'Voeg \'n nuwe gebruiker by';
$string['addnousersrecip'] = 'Voeg gebruikers wat nog nie toegang tot {$a} verkry het nie by lys van ontvangers';
$string['addpagehere'] = 'Voeg teks hier by';
$string['addresource'] = 'Voeg tans \'n hulpbron by...';
$string['addresourceoractivity'] = 'Voeg ’n aktiwiteit of hulpbron by';
$string['addresourcetosection'] = 'Voeg \'n hulpbron by afdeling \'{$a}\' by';
$string['address'] = 'Adres';
$string['addsections'] = 'Voeg afdelings by';
$string['addstudent'] = 'Voeg student by';
$string['addsubcategory'] = 'Voeg \'n sub-kategorie by';
$string['addteacher'] = 'Voeg onderwyser by';
$string['admin'] = 'Admin';
$string['adminhelpaddnewuser'] = 'Skep \'n nuwe gebruikerrekening handmatig';
$string['adminhelpassignadmins'] = 'Administrateurs kan enigiets doen en na enige plek op die webwerf gaan';
$string['adminhelpassigncreators'] = 'Kursusskeppers kan nuwe kursusse skep';
$string['adminhelpassignsiteroles'] = 'Wys gedefinieerde webwerfrolle toe aan spesifieke gebruikers';
$string['adminhelpassignstudents'] = 'Maak \'n kursus oop en voeg studente by vanuit die adminkieslys';
$string['adminhelpauthentication'] = 'Jy kan interne gebruikerrekeninge of eksterne databasisse gebruik';
$string['adminhelpbackup'] = 'Konfigureer outomatiese rugsteun en hul skedules';
$string['adminhelpconfiguration'] = 'Konfigureer hoe die webwerf lyk en werk';
$string['adminhelpconfigvariables'] = 'Konfigureer veranderlikes wat die algemene werking van die webwerf  beïnvloed';
$string['adminhelpcourses'] = 'Omskryf kursusse en kategorieë en ken mense aan hulle toe, redigeer hangende kursusse';
$string['adminhelpeditorsettings'] = 'Omskryf basiese instellings vir HTML-redigeerder';
$string['adminhelpedituser'] = 'Blaai deur die lys van gebruikersprofiele en redigeer lukraak';
$string['adminhelpenvironment'] = 'Kontroleer of jou bediener aan huidige en toekomstige installasievereistes voldoen';
$string['adminhelpfailurelogs'] = 'Blaai deur logs van mislukte aanmeldings';
$string['adminhelplanguage'] = 'Vir kontrolering en redigering van die huidige taalpakket';
$string['adminhelplogs'] = 'Blaai deur logs van alle aktiwiteite op hierdie webwerf';
$string['adminhelpmanageblocks'] = 'Beheer geïnstalleerde blokke en hul instellings';
$string['adminhelpmanagedatabase'] = 'Verkry direkte toegang tot die databasis (wees versigtig!)';
$string['adminhelpmanagefilters'] = 'Kies teksfilters en verwante instellings';
$string['adminhelpmanagemodules'] = 'Beheer geïnstalleerde modules en hul instellings';
$string['adminhelpmanageroles'] = 'Skep en definieer rolle wat op gebruikers toegepas kan word';
$string['adminhelpmymoodle'] = 'Konfigureer die My Moodle-blokke vir gebruikers';
$string['adminhelpreports'] = 'Verslae op webwerfvlak';
$string['adminhelpsitefiles'] = 'Vir publikasie van algemene lêers of oplaai van eksterne rugsteun';
$string['adminhelpsitesettings'] = 'Omskryf hoe die tuisblad lyk';
$string['adminhelpstickyblocks'] = 'Konfigureer Moodle-wye plakblokke';
$string['adminhelpthemes'] = 'Kies hoe die webwerf lyk (kleure, lettertipes, ens.)';
$string['adminhelpuploadusers'] = 'Voer nuwe gebruikerrekeninge in vanuit \'n tekslêer';
$string['adminhelpusers'] = 'Omskryf jou gebruikers en stel geldigheidsvasstelling op';
$string['adminhelpxmldbeditor'] = 'Koppelvlak om die XMLDB-lêers te redigeer. Slegs vir ontwikkelaars.';
$string['administration'] = 'Administrasie';
$string['administrationsite'] = 'Webwerfadministrasie';
$string['administrator'] = 'Administrateur';
$string['administratordescription'] = 'Administrateurs kan in die reël enigiets doen op die webwerf, in alle kursusse.';
$string['administrators'] = 'Administrateurs';
$string['administratorsall'] = 'Alle administrateurs';
$string['administratorsandteachers'] = 'Administrateurs en onderwysers';
$string['advanced'] = 'Gevorderd';
$string['advancedfilter'] = 'Gevorderde soek';
$string['advancedsettings'] = 'Gevorderde instellings';
$string['afterresource'] = 'Ná hulpbron "{$a}"';
$string['aftersection'] = 'Ná afdeling "{$a}"';
$string['again'] = 'weer';
$string['agelocationverification'] = 'Verifiëring van ouderdom en ligging';
$string['ajaxuse'] = 'AJAX en Javascript';
$string['all'] = 'Alle';
$string['allactions'] = 'Alle dade';
$string['allactivities'] = 'Alle aktiwiteite';
$string['allcategories'] = 'Alle kategorieë';
$string['allchanges'] = 'Alle veranderinge';
$string['alldays'] = 'Alle dae';
$string['allfiles'] = 'Alle lêers';
$string['allgroups'] = 'Alle groepe';
$string['alllogs'] = 'Alle aantekeninge';
$string['allmods'] = 'Alle {$a}';
$string['allow'] = 'Stel in staat';
$string['allowinternal'] = 'Laat interne metodes ook toe';
$string['allownone'] = 'Geen toegang';
$string['allownot'] = 'Moet nie toelaat nie';
$string['allowstealthmodules'] = 'Laat geheime aktiwiteite toe';
$string['allowstealthmodules_help'] = 'Indien geaktiveer kan aktiwiteite beskibaar gemaak word, maar nie gewys word in sigbare afdelings op die kursus blad nie. Indien so moet verwysings na die geheime aktiwiteite verskaf word van elders - soos van \'n blad hulpbron. Geheime aktiwiteite word steeds gelys in die grade boek en ander verslae.';
$string['allparticipants'] = 'Alle deelnemers';
$string['allteachers'] = 'Alle onderwysers';
$string['alphanumerical'] = 'Kan slegs alfanumeriese karakters, streep (-) of punt (.) bevat';
$string['alreadyconfirmed'] = 'Registrasie is reeds bevestig';
$string['alternatename'] = 'Alternatiewe naam';
$string['always'] = 'Altyd';
$string['and'] = '{$a->one} en {$a->two}';
$string['answer'] = 'Antwoord';
$string['any'] = 'Enige';
$string['appearance'] = 'Voorkoms';
$string['apply'] = 'Pas toe';
$string['applyfilters'] = 'Pas filters toe';
$string['approve'] = 'Goedkeur';
$string['areyousure'] = 'Is jy seker?';
$string['areyousuretorestorethis'] = 'Wil jy voortgaan?';
$string['areyousuretorestorethisinfo'] = 'Later hierdie proses sal \'n keuse hë om hierdie rugsteun tot \'n bestaande kursus te voeg. Jy kan ook \'n nuwe kursus skep.';
$string['asc'] = 'Stygend';
$string['assessment'] = 'Assessering';
$string['assignadmins'] = 'Wys admins toe';
$string['assigncreators'] = 'Wys skeppers toe';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Ken werfwye rolle toe';
$string['authenticateduser'] = 'Geverifieerde gebruiker';
$string['authenticateduserdescription'] = 'Alle ingetekende gebruikers.';
$string['authentication'] = 'Verifikasie';
$string['authenticationplugins'] = 'Verifikasie plugins';
$string['autosubscribe'] = 'Outomatiese Forum subskripsie';
$string['autosubscribeno'] = 'Nee: moenie my outomaties inteken op forumbesprekings nie';
$string['autosubscribeyes'] = 'Ja: skryf my op vir forums waar ek \'n boodskap skryf';
$string['availability'] = 'Beskikbaarheid';
$string['availablecourses'] = 'Beskikbare kursusse';
$string['back'] = 'Terug';
$string['backto'] = 'Terug na {$a}';
$string['backtocourselisting'] = 'Terug na kursus lys';
$string['backtohome'] = 'Terug na tuisblad';
$string['backtopageyouwereon'] = 'Terug na die bladsy waar jy was';
$string['backup'] = 'Rugsteun';
$string['backupactivehelp'] = 'Kies of om outomatiese rugsteun te doen.';
$string['backupadhocpending'] = 'Kursus rugsteun vir die doel van taak afwagtend';
$string['backupcancelled'] = 'Rugsteun gekanselleer';
$string['backupcoursefileshelp'] = 'Indien geaktiveer dan sal kursus lêers ingesluit word in die outomatiese rugsteun';
$string['backupdate'] = 'Rugsteun datum';
$string['backupdatenew'] = '{$a->TAG} is nou {$a->weekday}, {$a->mday} {$a->month} {$a->year} <br />';
$string['backupdateold'] = '{$a->TAG} was {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br /> {$a->recordtype} - {$a->recordname} <br />';
$string['backupdetails'] = 'Backup besonderhede';
$string['backuperrorinvaliddestination'] = 'Die bestemde rugsteun lêergids bestaan nie of is nie skryfbaar nie.';
$string['backupexecuteathelp'] = 'Kies watter tyd outomatiese rugsteun moet loop.';
$string['backupfailed'] = 'Sommige van jou kursusse is nie gestoor nie.';
$string['backupfilename'] = 'rugsteun';
$string['backupfinished'] = 'Rugsteun suksesvol voltooi';
$string['backupfromthissite'] = 'Rugsteun was op hierdie webwerf gemaak?';
$string['backupgradebookhistoryhelp'] = 'As dit aangeskakel is, sal punteboek geskiedenis ingesluit word in outomatiese rugsteun. Let daarop dat puntegeskiedenis nie moet afgeskakel wees in bediener instellings (disablegradehistory) ten einde hierdie te laat werk';
$string['backupincludemoduleshelp'] = 'Kies of jy kursus modules wil insluit, met of sonder die gebruikers data in outomatiese rugsteun';
$string['backupincludemoduleuserdatahelp'] = 'Kies of jy module gebruikers data wil insluit in outomatiese rugsteun.';
$string['backupinfo'] = 'Maak \'n kopie van hierdie kursus, insluitend al die inhoud en aktiwiteit tot op hede. Jy kan hierdie rugsteun lêer gebruik om die kursus te herstel.';
$string['backuplogdetailed'] = 'Gedetailleerde uitvoerings raport';
$string['backuploglaststatus'] = 'Laaste uitvoerings raport';
$string['backupmissinguserinfoperms'] = 'Let wel: Hierdie rugsteun bevat geen gebruikerdata nie. Oefeninge en werkswinkel aktiwiteite sal nie in die rugsteun ingesluit word nie, want hierdie modules is nie versoenbaar met hierdie tipe rugsteun nie.';
$string['backupnext'] = 'Volgende rugsteun';
$string['backupnonisowarning'] = 'Waarskuwing: hierdie rugsteun is van \'n nie-Unicode weergawe van Moodle (voor 1.6). As hierdie rugsteun enige nie-ISO-8859-1 teks bevat, kan dit KORRUP word as jy probeer om dit na hierdie Unicode weergawe van Moodle te herstel. Sien die <a href="https://docs.moodle.org/en/Backup_FAQ">Rugsteun FAQ</a> vir meer inligting oor hoe om hierdie rugsteun korrek te herstel.';
$string['backupnotyetrun'] = 'Outomatiese rugsteun hangend';
$string['backuporiginalname'] = 'Rugsteun naam';
$string['backuproleassignments'] = 'Maak \'n rugsteun van rol toewyssings vir hierdie rolle';
$string['backupsavetohelp'] = 'Die volledige roete na die area waar jy wil hê dat die rugsteun-lêers gestoor moet word';
$string['backupsitefileshelp'] = 'As dit aangeskakel is, word site lêers wat gebruik word in kursusse ingesluit in die outomatiese rugsteun';
$string['backuptakealook'] = 'Kyk asseblief vir \'n oomblik na jou rugsteun verslag in: {$a}';
$string['backupuserfileshelp'] = 'Kies of gebruiker lêers (bv. profiel prente) moet ingesluit word in die outomatiese rugsteun';
$string['backupversion'] = 'Rugsteun weergawe';
$string['badges'] = 'Kentekens';
$string['between'] = 'Tussen';
$string['block'] = 'Blok';
$string['blockconfiga'] = 'Die instel van \'n {$a} blok';
$string['blockconfigbad'] = 'Hierdie blok is nie korrek geïmplementeer nie en kan dus nie \'n instellings koppelvlak bied nie.';
$string['blocks'] = 'Blokke';
$string['blocks_main'] = 'Hoofinhoudblokkies';
$string['blocksaddedit'] = 'Voeg by / Redigeer blokke';
$string['blockseditoff'] = 'Blokke redigering af';
$string['blocksediton'] = 'Blokke redigering aan';
$string['blocksetup'] = 'Besign om blok tabelle op te stel';
$string['blocksuccess'] = '{$a} tabelle is korrek opgestel';
$string['brief'] = 'Kort';
$string['bulkactions'] = 'Grootmaat handelinge';
$string['bulkactionselect'] = '{$a} grootmaat aksie seleksie';
$string['bulkcancel'] = 'Maak grootmaatredigering toe';
$string['bulkmovecoursessuccess'] = 'Die {$a->courses} kursusse in {$a->category} is suksesvol geskuif';
$string['bulkselection'] = '{$a} gekies';
$string['bycourseorder'] = 'In kursus volgorde';
$string['byname'] = 'deur {$a}';
$string['bypassed'] = 'Uitgeskakel';
$string['cachecontrols'] = 'Kas beheer';
$string['calltofeedback'] = 'Die skeppers van hierdie sagteware wil graag jou terugvoer hê.';
$string['calltofeedback_give'] = 'Gee terugvoering oor hierdie sagteware';
$string['calltofeedback_remind'] = 'Herinner my later';
$string['cancel'] = 'Kanselleer';
$string['cancelled'] = 'Gekanselleer';
$string['categories'] = 'Kursus kategorieë';
$string['categoriesandcourses'] = 'Kursus kategorieë en kursusse';
$string['category'] = 'Kategorie';
$string['categoryadded'] = 'Die kategorie \'{$a}\' is bygevoeg';
$string['categorybulkaction'] = 'Grootmaat aksies vir die geselekteerde kategorieë';
$string['categorycontents'] = 'Subkategoriee en kursusse';
$string['categorycurrentcontents'] = 'Inhoud van {$a}';
$string['categorydeleted'] = 'Die kategorie \'{$a}\' is verwyder';
$string['categoryduplicate'] = '\'n Kategorie genaamd \'{$a}\' bestaan alreeds!';
$string['categoryheader'] = 'Kategorie spyskaart';
$string['categoryhidden'] = '(versteek)';
$string['categorymodifiedcancel'] = 'Kategorie is verander! Kanselleer asseblief en probeer weer.';
$string['categoryname'] = 'Kategorie Naam';
$string['categorypath'] = 'kategorie pad';
$string['categorysubcategoryof'] = '{$a->category} - subcategory van {$a->parentcategory}';
$string['categoryupdated'] = 'Die kategorie \'{$a}\' is opgedateer';
$string['changedpassword'] = 'Veranderde wagwoord';
$string['changepassword'] = 'Verander wagwoord';
$string['changesmade'] = 'Veranderinge aangebring';
$string['changesmadereallygoaway'] = 'Veranderings het plaasgevind. Is jy seker jy wil weg navigeer en jou veranderinge verloor?';
$string['changessaved'] = 'Wysigings gestoor';
$string['check'] = 'Keur';
$string['checkactual'] = 'Eintlike';
$string['checkall'] = 'Keur alles';
$string['checkerror'] = 'Fout om die resultate van kontrole \'{$a}\' te verkry. Kyk na die blaaierkonsole vir meer inligting.';
$string['checkexpected'] = 'Verwag';
$string['checkingbackup'] = 'Besig om rugsteun na te gaan';
$string['checkingcourse'] = 'Besig om kursus na te gaan';
$string['checkingforbbexport'] = 'Besig om na te gaan vir BlackBoard uitvoer';
$string['checkinginstances'] = 'Besig om eksemplare na te gaan';
$string['checkingsections'] = 'Besig om afdelings na te gaan';
$string['checklanguage'] = 'Gaan taal na';
$string['checkloading'] = 'Verkry resultate van kontrole \'{$a}\'';
$string['checknone'] = 'Kontroleer niks';
$string['checks'] = 'Kontroles';
$string['checksok'] = 'Alle \'{$a}\' kontroles reg';
$string['childcoursenotfound'] = 'Kinderkursus nie gevind nie!';
$string['childcourses'] = 'Kinderkursusse';
$string['choose'] = 'Kies';
$string['choosecourse'] = 'Kies \'n kursus';
$string['choosedots'] = 'Kies...';
$string['chooselivelogs'] = 'Of kyk na die huidige aktiwiteit';
$string['chooselogs'] = 'Kies watter raport wat jy wil sien';
$string['choosereportfilter'] = 'Kies \'n filter vir die verslag';
$string['choosetheme'] = 'Kies tema';
$string['chooseuser'] = 'Kies \'n gebruiker';
$string['city'] = 'Stad/dorp';
$string['cleaningtempdata'] = 'Tydelike data word skoongemaak';
$string['clear'] = 'Skoon';
$string['clearall'] = 'Vee alles uit';
$string['clearfilterrow'] = 'Verwyder filterry';
$string['clearfilters'] = 'Maak filters skoon';
$string['clearsearch'] = 'Maak soek invoer skoon';
$string['clickhelpiconformoreinfo'] = '... gaan voort ... Klik op die help-ikoon om die volle artikel te lees';
$string['clickhere'] = 'Klik hier ...';
$string['clicktohideshow'] = 'Kliek om te uit te brei of te vou';
$string['closeblockdrawer'] = 'Maak die blok laai toe';
$string['closebuttontitle'] = 'Sluit';
$string['closecourseindex'] = 'Maak die kursus indeks toe';
$string['closedrawer'] = 'Maak die laai toe';
$string['closewindow'] = 'Sluit hierdie venster';
$string['collapse'] = 'Ineenstorting';
$string['collapseall'] = 'Vou almal';
$string['collapsecategory'] = 'Vou {$a}';
$string['comebacklater'] = 'Kom asseblief later terug.';
$string['commentincontext'] = 'Vind hierdie kommentaar in konteks';
$string['comments'] = 'Kommentaar';
$string['commentscount'] = 'Kommentaar {{$a}}';
$string['commentsnotenabled'] = 'Kommentaar funksie is nie geaktiveer nie';
$string['commentsrequirelogin'] = 'Jy moet inteken om die kommentaar te sien.';
$string['comparelanguage'] = 'Vergelyk en redigeer huidige taal';
$string['complete'] = 'Voltooi';
$string['completed'] = 'Voltooi';
$string['completereport'] = 'Volledige verslag';
$string['configuration'] = 'Konfigurasie';
$string['confirm'] = 'Bevestig';
$string['confirmaccount'] = 'Bevestig rekening';
$string['confirmcheckfull'] = 'Is jy heeltemal seker dat jy {$a} wil bevestig?';
$string['confirmcoursemove'] = 'Is jy seker dat jy hierdie kursus ({$a->course}) in hierdie kategorie ({$a->category}) wil beweeg?';
$string['confirmdeletesection'] = 'Is jy absoluut seker jy wil "{$a}" heeltemal verwyder en al die aktiwiteite daarin?';
$string['confirmed'] = 'Jou registrasie is bevestig';
$string['confirmednot'] = 'Jou registrasie is nog nie bevestig nie. Kontroleer asseblief u posbus vir \'n bevestigings-e-pos.';
$string['considereddigitalminor'] = 'Jy is te jonk om \'n profiel op hierdie webwerf te skep.';
$string['content'] = 'Inhoud';
$string['contentbank'] = 'Inhoudsbank';
$string['contentexport_aboutthiscourse'] = 'Kursus opsomming';
$string['contentexport_coursesummary'] = 'Hierdie lêer is deel van die inhoud wat vanaf <a href="{$a->courselink}">{$a->coursename}</a> afgelaai is.';
$string['contentexport_footersummary'] = 'Hierdie lêer is deel van die inhoud wat vanaf <a href="{$a->courselink}">{$a->coursename}</a> deur {$a->userfullname} op {$a->date} afgelaai is.';
$string['contentexport_modulesummary'] = 'Hierdie lêer is deel van die inhoud wat vanaf <a href="{$a->modulelink}">{$a->modulename}</a> op {$a->date} afegelaai is. Let daarop dat sommige inhoud en enigel lêers groter as {$a->maxfilesize} nie afgelaai is nie.';
$string['contentexport_viewfilename'] = 'Besigtig die lêer {$a}';
$string['context'] = 'Konteks';
$string['contextlevel'] = 'Konteksvlak';
$string['contextname'] = 'Konteksnaam';
$string['contextparent'] = 'Ouer';
$string['contexturl'] = 'Konteks URL';
$string['continue'] = 'Gaan voort';
$string['continuetocourse'] = 'Kliek hier om jou kursus binne te gaan';
$string['convertingwikitomarkdown'] = 'Mesig om wiki na Markdown om te skakel';
$string['cookiesenabled'] = '"Cookies" moet aangesit wees in jou webblaaier';
$string['cookiesenabled_help'] = 'Twee koekies word op hierdie webwerf gebruik:

Die noodsaaklike een is die sessiekoekie, gewoonlik MoodleSession genoem. Jy moet hierdie koekie in jou blaaier toelaat om kontinuïteit te verskaf en om ingeteken te bly wanneer jy op die webwerf blaai. Wanneer jy uitteken of die blaaier toemaak word hierdie koekie vernietig (in jou blaaier en op die bediener).

Die ander koekie is bloot vir gerief, gewoonlik MOODLEID of soortgelyk. Dit onthou net jou gebruikersnaam in die webblaaier. Dit beteken dat wanneer jy na hierdie webwerf terugkeer, die gebruikersnaam op die aantekenbladsy reeds ingevul is. Dit is veilig om hierdie koekie te weier - jy moet net jou gebruikersnaam herhaal elke keer as jy inteken.';
$string['cookiesenabled_help_html'] = 'Twee koekie word gebruik op hierdie webblad:<br/><br/>

Die noodsaaklike een is die sessie koekie, met die naam MoodleSession. Jy moet hierdie koekie toelaat in jou blaaier om kontinuïteit te verskaf en om ingeteken te bly terwyl jy op die webblad is. Sodra jy uit teken of die blaaier toe maak, word die koekie vernietig (op die blaaier en die bediener).<br/><br/>

Die ander koekie is net vir gerief en dit word MOODLEID genoem. Dit onthou jou gebruikers naam en wagwoord. Dit beteken dat jou gebruikers naam en wagwoord outomaties ingevul sal wees sodra jy weer terug kom na die webblad. Dit is veilig om hierdie koekie te weier. Jy sal net jou gebruiker naam en wagwoord moet intik elke keer wat jy wil inteken.';
$string['cookiesenabledonlysession'] = 'Cookies moet aangesit wees in jou webleser';
$string['cookiesenabledonlysession_help'] = 'Hierdie webwerf gebuik een sessie-koekie, gewoonlik genaamd MoodleSession. Jy moet hierdie koekie in jou blaaier toelaat om kontinuïteit te verskaf en ingeteken te bly wanneer daar deur die webwerf geblaai word. Wanneer jy uitteken of die blaaier toemaak word die koekie vernietig (in jou blaaier en op die bediener).';
$string['cookiesnotenabled'] = 'Ongelukkig is tans koekies nie aangeskakel in jou webleser';
$string['cookiesnotice'] = 'Koekies kennisgewing';
$string['copy'] = 'kopieer';
$string['copyasnoun'] = 'kopieer';
$string['copycourse'] = 'Kopieer kursus';
$string['copyingcoursefiles'] = 'Besig om kursuslêers te kopieer';
$string['copyingsitefiles'] = 'Besig om webwerflêers wat in die kursus gebruik word te kopieer';
$string['copyinguserfiles'] = 'Besig om gebruikerlêers te kopieer';
$string['copyingzipfile'] = 'Besig om ziplêer te kopieer';
$string['copyrightnotice'] = 'Kopiereg kennisgewing';
$string['copytoclipboard'] = 'Kopieer na knipbord';
$string['coresystem'] = 'Systeem';
$string['cost'] = 'Koste';
$string['costdefault'] = 'Verstek koste';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Land';
$string['course'] = 'Kursus';
$string['courseadministration'] = 'Kursusadministrasie';
$string['courseapprovedemail'] = 'Die kursus wat jy aangevra het, {$a->name}, is goedgekeur en jy is nou \'n {$a->teacher}.  Om toegang tot jou nuwe kursus te verkry, gaan na {$a->url}.';
$string['courseapprovedemail2'] = 'Jou versoekte kursus, {$a->name}, is goedgekeur. Om jou nuwe kursus te bekom, gaan na {$a->url}';
$string['courseapprovedfailed'] = 'Kon nie die kursus stoor as goedgekeur nie!';
$string['courseapprovedsubject'] = 'Jou kursus is goedgekeur!';
$string['courseavailable'] = 'Hierdie kursus is beskikbaar aan studente';
$string['courseavailablenot'] = 'Hierdie kursus is nie beskikbaar aan studente nie';
$string['coursebackup'] = 'Kursus rugsteun';
$string['coursebulkaction'] = 'Grootmaat aksies vir geselekteerde kursusse';
$string['coursecategories'] = 'Kursus kategoriee';
$string['coursecategory'] = 'Kursus kategorie';
$string['coursecategory_help'] = '<p>Jou Moodle administrateur mag dalk \'n paar kursus kategorieë
opgestel het.</p>
<p>Byvoorbeeld: "Wetenskap", "Wiskunde", "Ekonomie", ens.</p>
<p>Kies die kategorie wat by jou kursus pas. Die keuse sal bepaal
waar jou kursus in die kursus lys vertoon sal word, dit kan jou
studente help om makliker jou kursus te kry.</p>';
$string['coursecategorydeleted'] = 'Verwyder kursus kategorie {$a}';
$string['coursecatmanagement'] = 'Kursus en kategorie bestuur';
$string['coursecompletion'] = 'Kursus afhandeling';
$string['coursecompletions'] = 'Kursus afhandelings';
$string['coursecreators'] = 'Kursus skepper';
$string['coursecreatorsdescription'] = 'Kursus skeppers kan nuwe kursusse skep.';
$string['coursedeleted'] = 'Verwyder due kursus {$a}';
$string['coursedetails'] = 'Kursus besonderhede';
$string['coursedisplay'] = 'Kursus uitleg';
$string['coursedisplay_help'] = 'Hierdie afdelings kan op een bladsy vertoon of verdeel oor verskeie bladsye.';
$string['coursedisplay_multi'] = 'Toon een afdeling per bladsy';
$string['coursedisplay_single'] = 'Toon alle afdelings op een bladsy';
$string['courseduration'] = 'Duur van kursus';
$string['courseduration_desc'] = 'Die duur van die kursus word gebruik om die kursus se einddatum te bepaal. Die einddatum van die kursus word gebruik om te bepaal of \'n kursus ingesluit moet word in die gebruik se lys van kursusse. Dit mag ook gebruik word in persoonlike verslae. Die gebruikers kan nog steeds in die kursus ingaan na die einddatum van die kursus.';
$string['courseenddateenabled'] = 'Kursus einddatum by verstek geaktiveer';
$string['courseenddateenabled_desc'] = 'Hierdie instelling bepaal of die einddatum van die kursus by verstek geaktiveer is vir nuwe kursusse en gestel word op die berekening met die kursus se duur.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Nalatens kursus lêers';
$string['coursefilesedit'] = 'Wysig nalatens kursus lêers';
$string['coursefileswarning'] = 'Kursus lêers is gedepresieer';
$string['coursefileswarning_help'] = 'Kursus lêers word afgekeur sedert Moodle 2.0, gebruik asseblief eksterne bronne instede so veel as moontlik.';
$string['courseformatdata'] = 'Kursus formaat data';
$string['courseformatoptions'] = 'Formatering opsies vir {$a}';
$string['courseformats'] = 'Kursus formate';
$string['courseformatudpate'] = 'Opdateerings formaat';
$string['coursegrades'] = 'Kursus punte';
$string['courseheader'] = 'Kursus kieslys';
$string['coursehelpcategory'] = 'Deur die kursus op die kursuslys te plaas, sal studente dit makliker kan vind.';
$string['coursehelpforce'] = 'Forseer kursus groep mode in elke aktiwiteit in die kursus.';
$string['coursehelpformat'] = 'Die kursus hoofblad sal vertoon word in hierdie formaat.';
$string['coursehelphiddensections'] = 'Hoe die verborge dele in die kursus aan die studente vertoon word.';
$string['coursehelpmaximumupload'] = 'Definieer die grootste grootte van die lêer wat in hierdie kursus kan gelaai word, beperk deur die site-wye verstelling.';
$string['coursehelpnewsitemsnumber'] = 'Aantal onlangse items wat op die voorblad van die kursus verskyn in \'n nuus blokkie op die kursus bladsy. Indien dit op nul gestel is gaan die nuus forum nie geskep word nie.';
$string['coursehelpnumberweeks'] = 'Aantal weke / onderwerpe wat op die kursus hoofblad vertoon.';
$string['coursehelpshowgrades'] = 'Aktiveer die vertoning van die punteboek. Dit beteken nie dat die punte nie vertoon in die individuele aktiwiteite nie.';
$string['coursehidden'] = 'Hierdie kursus is tans nie beskikbaar aan studente';
$string['courseinfo'] = 'Kursusinligting';
$string['courselegacyfiles'] = 'Nalatens kursus lêers';
$string['courselegacyfiles_help'] = 'Die kursus lêers area bied \'n mate van terugverenigbaarheid met Moodle 1.9 en vroeër. Alle lêers in hierdie area is altyd toeganklik vir alle deelnemers in die kursus (of jy \'n skakel het na hulle of nie) en daar is geen manier om te weet waar enige van hierdie lêers gebruik word in Moodle nie.

As jy hierdie area gebruik om lêers te stoor, kan jy jouself blootstel aan \'n menigte van privaatheid en veiligheid kwessies, asook die ervaaring van vermiste lêers in rugsteun, kursus invoere en enige tyd inhoud gedeel word of weer gebruik word. Dit word dus aanbeveel dat jy nie hierdie gebied gebruik nie, tensy jy regtig weet wat jy doen.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Nalatens kursus lêers: {$a}';
$string['coursenotaccessible'] = 'Hierdie kursus laat nie publieke toegang toe nie';
$string['courseoverview'] = 'Kursus oorsig';
$string['courseoverviewfiles'] = 'Kursus foto';
$string['courseoverviewfiles_help'] = 'Die kursusfoto word vertoon in My kursusse en die lys van beskikbare kursusse op die Tuisblad. Die webwerfadministrateurs kan bykomende lêertipes en die gebruik van verskeie lêers aktiveer. Indien jy verskeie lêers gebruik, sal almal in die beskikbare kursus op die Tuisblad vertoon.';
$string['courseoverviewfilesext'] = 'Kursus foto lêer uitbreidings';
$string['courseoverviewfileslimit'] = 'Kursus foto lêers limiet';
$string['courseoverviewgraph'] = 'Kursus oorsig grafiek';
$string['courseprofiles'] = 'Kursus profiele';
$string['coursereasonforrejecting'] = 'Jou redes vir die verwerping van die versoek';
$string['coursereasonforrejectingemail'] = 'Dit sal per e-pos gestuur word aan die versoeker';
$string['coursereject'] = 'Keur \'n kursus navraag af';
$string['courserejected'] = 'Kursus is verwerp en die versoeker in kennis gestel is.';
$string['courserejectemail'] = 'Jammer, maar die kursus wat u versoek het, is verwerp. Hier is die rede verskaf: {$a}';
$string['courserejectreason'] = 'Beskryf kortliks die redes waarom jy hierdie kursus afgekeur het <br />(hierdie sal na die persoon wat die navraag gemaak het, gestuur word)';
$string['courserejectsubject'] = 'Jou kursus is verwerp';
$string['coursereport'] = 'Kursus verslag';
$string['coursereports'] = 'Kursus verslae';
$string['courserequest'] = 'Kursus versoek';
$string['courserequestdetails'] = 'Besonderhede van die kursus wat jy aanvra';
$string['courserequestfailed'] = 'Vir een of ander rede kon jou kursus navraag nie gestoor word nie';
$string['courserequestintro'] = 'Gebruik hierdie vorm om aan te vra dat \'n kursus vir jou geskep word.<br />Probeer om soveel as moontlik inligting in te vul<br /> sodat die administrateurs kan verstaan waarom jy hierdie kursus wil hê.';
$string['courserequestreason'] = 'Redes vir die versoek van hierdie kursus';
$string['courserequestroleerror'] = 'Die skepper se rol in nuwe kursuskonfigurasie is ongeldig. Sien asseblief <a href="{$a}">user policies</a>.';
$string['courserequestsuccess'] = 'Kursusversoek is suksesvol ingedien.';
$string['courserequestsupport'] = 'Ondersteunende inligting om die administrateur te help om hierdie versoek te evalueer';
$string['courserequestwarning'] = 'Die gebruiker wat hierdie kursus versoek gaan outomaties ingeskryf word met die rol van {$a}.';
$string['courserestore'] = 'Kursus herstel';
$string['coursereuse'] = 'kursus hergebruik';
$string['coursereusenavigationmenu'] = 'Navigasiekieslys vir kursushergebruik';
$string['courses'] = 'Kursusse';
$string['coursesectionsummaries'] = 'Kursus afdeling opsommings';
$string['coursesectiontitle'] = '{$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitlebulkediting'] = 'Wysig op grootmaat {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Wysig {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'Standaard kursus verstellings';
$string['coursesmovedout'] = 'Kursusse verskuif vanaf {$a}';
$string['coursespending'] = 'Kursusse hangende goedkeuring';
$string['coursestart'] = 'Kursus begin';
$string['coursesummary'] = 'Kursus opsomming';
$string['coursesummary_help'] = '’n Kort beskrywing van jou kursus. Die inhoud wat jy hier byvoeg is soekbaar.';
$string['coursetitle'] = 'Kursus: {$a->course}';
$string['coursetitlebulkediting'] = 'Wysig kursus op grootmaat: {$a->course}';
$string['coursetitleediting'] = 'Wysig kursus: {$a->course}';
$string['courseupdates'] = 'Kursus bywerkings';
$string['coursevisibility'] = 'Sigbaarheid van die kursus';
$string['coursevisibility_help'] = '* Wys: Die kursus verskyn op die kursuslys en studente het toegang daartoe.
* Versteek: Toegang is beperk tot dosente en ander gebruikers met die vermoë om die versteekte kursus te besigtig.';
$string['create'] = 'Skep';
$string['createaccount'] = 'Skep nuwe rekening';
$string['createcategory'] = 'Skep kategorie';
$string['createfolder'] = 'Skep \'n lêergids in {$a}';
$string['createnew'] = 'Skep nuwe';
$string['createnewcategory'] = 'Skep nuwe kategorie';
$string['createnewcourse'] = 'Skep nuwe kursus';
$string['createnewsubcategory'] = 'Skep nuwe sub-kategorie';
$string['createsubcategoryof'] = 'Skep sub-kategorie van {$a}';
$string['createuser'] = 'Skep \'n gebruiker';
$string['createziparchive'] = 'Skep zip argief';
$string['creatingblocks'] = 'Besig om blokke te skep';
$string['creatingblocksroles'] = 'Besig om blokvlak rol-aanwysings en oorskrywings te skep';
$string['creatingblogsinfo'] = 'Besig om webjoernaal inligting te skep';
$string['creatingcategoriesandquestions'] = 'Besig om kategorieer en vrae te skep';
$string['creatingcoursemodules'] = 'Besig om kursus modules te skep';
$string['creatingcourseroles'] = 'Besig om kursusvlak rol-aanwysings en oorskrywings te skep';
$string['creatingevents'] = 'Skep gebeure';
$string['creatinggradebook'] = 'Besig om punteboek te skep';
$string['creatinggroupings'] = 'Besig om groeperings te skep';
$string['creatinggroupingsgroups'] = 'Besig om groepe in groeperings by te voeg';
$string['creatinggroups'] = 'Besig om groepe te skep';
$string['creatinglogentries'] = 'Skep aantekenings inskrywings';
$string['creatingmessagesinfo'] = 'Besig om boodkappe inligting te skep';
$string['creatingmodroles'] = 'Besig om modulevlak rol-aanwysings en oorskrywings te skep';
$string['creatingnewcourse'] = 'Besig om nuwe kursus te skep';
$string['creatingrolesdefinitions'] = 'Besig om rolle definisies te skep';
$string['creatingscales'] = 'Besig om skale te skep';
$string['creatingsections'] = 'Besig om afdelings te skep';
$string['creatingtemporarystructures'] = 'Besig om tydelike strukture te skep';
$string['creatinguserroles'] = 'Besig om gebruikersvlak rol-aanwysings en oorskrywings te skep';
$string['creatingusers'] = 'Besig om gebruikers te skep';
$string['creatingxmlfile'] = 'Besig om XML lêer te skep';
$string['currency'] = 'Geldeenheid';
$string['currentcourse'] = 'Huidige kursus';
$string['currentcourseadding'] = 'Huidige kursus, besig om data daarby te voeg';
$string['currentcoursedeleting'] = 'Huidige kursus, besig om dit eers uit te wis';
$string['currentlanguage'] = 'Huidige taal';
$string['currentlocaltime'] = 'jou huidige plaaslike tyd';
$string['currentpicture'] = 'Huidige foto';
$string['currentrelease'] = 'Huidige vrylatings inligting';
$string['currenttheme'] = 'Huidige tema';
$string['currentversion'] = 'Huidige weergawe';
$string['databasechecking'] = 'Opgradering van Moodle databasis vanaf weergawe {$a->oldversion} te {$a->newversion}';
$string['databaseperformance'] = 'Databasis prestasie';
$string['databasesetup'] = 'Opstel van databasis';
$string['databasesuccess'] = 'Databasis is suksesvol opgegradeer';
$string['databaseupgradebackups'] = 'Rugsteun weergawe is nou {$a}';
$string['databaseupgradeblocks'] = 'Blokke weergawe is nou {$a}';
$string['databaseupgradegroups'] = 'Groepe weergawe is nou {$a}';
$string['databaseupgradelocal'] = 'Plaaslike databasis aanpassings weergawe is nou {$a}';
$string['databaseupgrades'] = 'Besig om databasis op te gradeer';
$string['dataformats'] = 'Data formaat';
$string['date'] = 'Datum';
$string['datechanged'] = 'Datum is verander';
$string['datemostrecentfirst'] = 'Datum - mees onlangse eerste';
$string['datemostrecentlast'] = 'Datum - mees onlangse laaste';
$string['datetimefilterafter'] = '{$a->title} na';
$string['datetimefilterbefore'] = '{$a->title} voor';
$string['day'] = 'dag';
$string['days'] = 'dae';
$string['decodinginternallinks'] = 'Besig om interne skakel te dekodeer';
$string['default'] = 'Standaard';
$string['defaultcategoryname'] = 'Kategorie 1';
$string['defaultcompetencescale'] = 'Standaard bevoegdheidskaal';
$string['defaultcompetencescaledesc'] = '\'n Binêre graderingskaal wat geen verdere inligting verskaf behalwe of \'n persoon bekwaam is of nie.';
$string['defaultcompetencescalenotproficient'] = 'Nog nie bekwaam nie';
$string['defaultcompetencescaleproficient'] = 'Bekwaam';
$string['defaultcoursestudent'] = 'Student';
$string['defaultcoursestudentdescription'] = 'Studente het oor die algemeen minder voorregte binne \'n kursus.';
$string['defaultcoursestudents'] = 'Studente';
$string['defaultcoursesummary'] = 'Skryf hier \'n bondige en interessante paragraaf wat verduidelik waaroor die kursus gaan';
$string['defaultcourseteacher'] = 'Onderwyser';
$string['defaultcourseteacherdescription'] = 'Onderwysers kan enige iets binne \'n kursus doen, insluitend die verandering van die aktiwiteite en gradering van studente.';
$string['defaultcourseteachers'] = 'Onderwysers';
$string['defaulteditor'] = 'Standaard teksverwerker';
$string['defaulthomepageuser'] = 'Beginblad';
$string['defaulthomepageuser_help'] = 'Na watse blad wil jy geneem word na jy in teken?';
$string['delete'] = 'Verwyder';
$string['deleteablock'] = 'Verwyder \'n blok';
$string['deleteall'] = 'Verwyder alles';
$string['deleteallcannotundo'] = 'Verwyder alles - kan nie ongedaan word nie';
$string['deleteallcomments'] = 'Alle kommentaar';
$string['deleteallratings'] = 'Alle graderings';
$string['deletecategory'] = 'Verwyder kategorie: {$a}';
$string['deletecategorycheck'] = 'Is jy doodseker dat jy hierdie kategorie heeltemal wil uitwis<b>\'{$a}\'</b>?<br /> Hierdie sal alle kursusse in die ouer kategorie inskuif as daar een is, of na Allerlei.';
$string['deletecategorycheck2'] = 'As jy hierdie kategorie uitwis moet jy kies wat met die kursusse en subkategoriee wat dit bevat, gedoen moet wor.';
$string['deletecategoryempty'] = 'Hierdie kategorie is leeg.';
$string['deletecheck'] = 'Verwyder {$a}?';
$string['deletecheckfiles'] = 'Is jy doodseker jy wil hierdie lêers uitwis?';
$string['deletecheckfull'] = 'Is jy seker jy wil gebruiker {$a} skrap, insluitend data soos profielbesonderhede, inskrywing, groep- en
and kohortlidmaatskappe en sommige gebruikeraktiwiteitsdata?';
$string['deletechecktype'] = 'Is jy seker dat jy hierdie {$a->type} wil verwyder?';
$string['deletechecktypename'] = 'Is jy seker dat jy dat die {$a->type} "{$a->name}" wil verwyder?';
$string['deletecheckwarning'] = 'Jy is op die punt om hierdie lêers uit te wis';
$string['deletecommentbyon'] = 'Verwyder die kommentaar wat deur {$a->user} op {$a->time} gemaak is';
$string['deletecompletely'] = 'Wis heeltemal uit';
$string['deletecourse'] = 'Verwyder \'n kursus';
$string['deletecoursecheck'] = 'Is jy heeltemal seker dat jy hierdie kursus en al die data wat dit bevat heeltemal wil verwyder?';
$string['deleted'] = 'Geskrap';
$string['deletedactivity'] = '{$a} is geskrap';
$string['deletedcourse'] = '{$a} is heeltemal geskrap';
$string['deletednot'] = 'Kon nie {$a} verwyder nie!';
$string['deletepicture'] = 'Verwyder';
$string['deletesection'] = 'Verwyder';
$string['deleteselected'] = 'Verwyder die geselekteerde';
$string['deleteselectedkey'] = 'Verwyder geselekteerde sleutel';
$string['deletingcourse'] = 'Verwydering van {$a}';
$string['deletingexistingcoursedata'] = 'Besig om bestaande kursus data uit te wis';
$string['deletingolddata'] = 'Besig om ou data uit te wis';
$string['department'] = 'Departement';
$string['deprecatedeventname'] = '{$a} (word nie lange gebruik nie)';
$string['desc'] = 'Aflopend';
$string['description'] = 'Beskrywing';
$string['deselectall'] = 'Deselekteer alles';
$string['deselectnos'] = 'Onselekteer alle \'Nee\'';
$string['detailedless'] = 'Minder besonderhede';
$string['detailedmore'] = 'Meer besonderhede';
$string['details'] = 'Besonderhede';
$string['digitalminor'] = 'Digitale minderjarige';
$string['digitalminor_desc'] = 'Vra asseblief u ouer / voog om te kontak:';
$string['directory'] = 'Gids';
$string['disable'] = 'Afgeskakel';
$string['disabledcomments'] = 'Kommentaar is afgeskakel';
$string['dismissnotification'] = 'Wys hierdie kennisgewing af';
$string['displayingfirst'] = 'Slegs die eerste {$a->count} {$a->things} word vertoon';
$string['displayingrecords'] = '{$a} rekords word vertoon';
$string['displayingusers'] = 'Vertoon gebruikers {$a->start} na {$a->end}';
$string['displayonpage'] = 'Vertoon op bladsy';
$string['dndcourse'] = 'Jy kan hierdie kursus se sortering verander en of dit skuif na \'n ander kategorie deur dit te sleep en neersit waar verlang.';
$string['dndenabled_inbox'] = 'Jy kan die lêers hier sleep en laat val om hulle by te voeg.';
$string['dndnotsupported'] = 'Sleep en laat val oplaai word nie ondersteun nie';
$string['dndnotsupported_help'] = 'Jou webblaaier ondersteun nie sleep en los oplaai nie. <br /> Hierdie funksie is beskikbaar in al die onlangse weergawes van Chrome, Firefox en Safari, sowel as Internet Explorer v10 en hoër.';
$string['dndnotsupported_insentence'] = 'sleep en laat val word nie ondersteun nie';
$string['dnduploadwithoutcontent'] = 'Hierdie oplaai het nie enige inhoud nie';
$string['dndworkingfile'] = 'Sleep en laat val lêers op kursus afdelings om hulle op te laai';
$string['dndworkingfilelink'] = 'Sleep en laat val lêers of skakels op kursus afdelings om hulle op te laai';
$string['dndworkingfiletext'] = 'Sleep en laat val lêers of teks op kursus afdelings om hulle op te laai';
$string['dndworkingfiletextlink'] = 'Sleep en laat val lêers, teks of skakels na kursus afdelings om hulle op te laai';
$string['dndworkinglink'] = 'Sleep en laat val skakels op kursus afdelings om hulle te laai';
$string['dndworkingtext'] = 'Sleep en laat val teks op kursus afdelings om dit te laai';
$string['dndworkingtextlink'] = 'Sleep en laat val teks of skakels op kursus afdelings om hulle te laai';
$string['documentation'] = 'Moodle dokumentasie';
$string['dontsortcategories'] = 'Moenie kategorieë sorteer nie';
$string['dontsortcourses'] = 'Moenie kursusse sorteer nie';
$string['down'] = 'Af';
$string['download'] = 'Aflaai';
$string['downloadall'] = 'Laai alles af';
$string['downloadexcel'] = 'Laai af in Excel formaat';
$string['downloadfile'] = 'Laai hierdie lêer af';
$string['downloadods'] = 'Laai af in ODS formaat';
$string['downloadtext'] = 'Laai af in teks formaat';
$string['doyouagree'] = 'Het jy hierdie toestande gelees en dit verstaan?';
$string['droptoupload'] = 'Laat val lêers hier om dit op te laai';
$string['duplicate'] = 'Dupliseer';
$string['duplicatedmodule'] = '{$a} (copy)';
$string['duplicatedsection'] = '{$a} (kopieer)';
$string['edhelpaspellpath'] = 'Om die spellingskontrole te gebruik binne die redakteur, moet jy <strong>aspell 0,50</strong> of later geïnstalleer het op jou bediener, en jy moet die regte roete spesifiseer na die aspell binêre om toegang te verkry. Op Unix / Linux stelsels, is hierdie roete gewoonlik <strong>/ usr / bin / aspell,</strong> maar dit kan iets anders wees.';
$string['edhelpbgcolor'] = 'Definieer die redigeringsarea se agtergrondkleur.<br />Geldige waardes is, byvoorbeeld: #FFFFFF or wit';
$string['edhelpcleanword'] = 'Hierdie instelling versper of ontsper Word-spesifiek formaat filtering.';
$string['edhelpenablespelling'] = 'Versper of ontsper speltoetsing. Wanneer ontsper, moet <strong>aspell</strong> op die bediener geïnstalleer wees. Die tweede waarde is die <strong>verstek woordeboek</strong>. Hierdie waarde gaan gebruik word as aspell nie \'n woordeboek vir die gebruikers se eie taal het nie.';
$string['edhelpfontfamily'] = 'Die karakterfont-familie eiendom is \'n lys van karakterfont familiename en / of generiese familiename. Familiename moet met \'n komma geskei word.';
$string['edhelpfontlist'] = 'Wis die karakterfonte wat op die redigeerder se aftrek kieslys gebruik word, uit.';
$string['edhelpfontsize'] = 'Die verstek karakterfont-grootte stel die grootte van \'n karakterfont in.  <br />Geldige waardes is  byvoorbeeld: medium, groot, kleiner, groter, 10pt, 11px.';
$string['edit'] = 'Wysig';
$string['edita'] = 'Wysig {$a}';
$string['editcategorysettings'] = 'Wysig kategorie instellings';
$string['editcategorythis'] = 'Wysig hierdie kategorie';
$string['editcoursesettings'] = 'Wysig kursus instellings';
$string['editfiles'] = 'Redigeer lêers';
$string['editgroupprofile'] = 'Wysig groep profiel';
$string['editingteachershort'] = 'Redigeerder';
$string['editlock'] = 'Hierdie waarde kan nie gewysig word nie!';
$string['editmode'] = 'Wysig';
$string['editmyprofile'] = 'Wysig profiel';
$string['editorbgcolor'] = 'Agtergrondkleur';
$string['editorcleanonpaste'] = 'Skoon Word HTML op plak';
$string['editorcommonsettings'] = 'Algemene instellings';
$string['editordefaultfont'] = 'Verstek karakterfont';
$string['editorenablespelling'] = 'Ontsper speltoetsing';
$string['editorfontlist'] = 'Skrif lys';
$string['editorfontsize'] = 'Standaard skrif grootte';
$string['editorpreferences'] = 'Redigeerdervoorkeure';
$string['editorresettodefaults'] = 'Herstel na verstek waardes';
$string['editorsettings'] = 'Teksverwerking instellings';
$string['editorshortcutkeys'] = 'Teksverwerking kortpad sleutels';
$string['editsection'] = 'Wysig verstellings';
$string['editsectionname'] = 'Wysig afdeling naam';
$string['editsectionsettings'] = 'Wysig afdelingverstellings';
$string['editsectiontitle'] = 'Wysig afdeling: {$a}';
$string['editsettings'] = 'Wysig instellings';
$string['editthisactivity'] = 'Redigeer hierdie aktiwiteit';
$string['editthiscategory'] = 'Wysig hierdie kategorie';
$string['edittitle'] = 'Wysig titel';
$string['edittitleinstructions'] = 'Druk \'Escape\' om te kanselleer, druk \'Enter\' wanneer jy klaar is';
$string['edituser'] = 'Wysig gebruiker rekeninge';
$string['edulevel'] = 'All gebeure';
$string['edulevel_help'] = '* Onderrig - aksies wat deur \'n onderwyser uitgevoer word, bv. die bywerk van \'n hulpbron
* Deelnemer - aksies wat deur \'n student uitgevoer word, bv. om inskrywings te maak in \'n forum
* Ander - aksies wat uitgevoer word deur gebruikers met \'n ander rol wat nie \'n onderwyser of student is nie';
$string['edulevelother'] = 'Ander';
$string['edulevelparticipating'] = 'Deelnemende';
$string['edulevelteacher'] = 'Onderrig';
$string['email'] = 'E-pos adres';
$string['emailactive'] = 'E-pos geaktiveer';
$string['emailagain'] = 'E-pos (weer)';
$string['emailalreadysent'] = '\'n Herstel van die wagwoord is reeds gestuur. Gaan asseblief u e-pos na.';
$string['emailcharset'] = 'E-pos charset';
$string['emailconfirm'] = 'Bevestig jou rekening';
$string['emailconfirmation'] = 'Hi,

\'n nuwe rekening is versoek op \'{$a->sitename}\' met jou e-posadres.

Om jou nuwe rekening te bevestig, gaan asseblief na hierdie webwerf:
{$a->link}

In die meeste e-pos programme sal hierdie verskyn as \'n blou skakel waarop jy kan kliek.
As dit nie werk nie, dan sny en plak die adres in die adres lyn aan die bokant van jou webleser.

As jy hulp nodig het, kontak die blad administrateur, {$a->admin}';
$string['emailconfirmationresend'] = 'Stuur bevestiging e-pos weer';
$string['emailconfirmationsubject'] = '{$a}: rekening bevestiging';
$string['emailconfirmsent'] = '<p> \'n E-pos moes gestuur gewees het na jou adres by <b>{$a}</b> </p><p> Dit bevat maklike instruksies om jou registrasie te voltooi. </p><p> As jy nog steeds probleme het, kontak die moderator van hierdie site. </p>';
$string['emailconfirmsentfailure'] = 'Bevestiging e-pos het nie gestuur nie';
$string['emailconfirmsentsuccess'] = 'Bevestiging e-pos is suksesvol gestuur';
$string['emaildigest'] = 'E-pos opsomming tipe';
$string['emaildigest_help'] = 'Hierdie is die daaglikse opsomming opstel wat forums sal gebruik volgens standaard.

* Geen opsomming nie - jy sal een e-pos ontvang per forum boodskap;

* Opsomming - volledige boodskappe - jy sal een opsommings e-pos ontvang per dag met die volledige inhoud van elke forum boodskap;

* Opsommings - net onderwerpe - jy sal die een opsommings e-pos ontvang per dag met net die onderwerp van elke forum boodskap.

Jy kan ook kies om ander instellings te hê vir elke forum as jy so wou.';
$string['emaildigestcomplete'] = 'Volledige (daaglikse e-pos met die volledige poste)';
$string['emaildigestoff'] = 'Geen opsomming (enkele e-pos per forum post)';
$string['emaildigestsubjects'] = 'Onderwerpe (daaglikse e-pos met net die onderwerpe)';
$string['emaildisable'] = 'Hierdie e-posadres is gedeaktiveer';
$string['emaildisableclick'] = 'Kliek hier om alle e-pos af te skakel van wat gestuur word na hierdie adres';
$string['emaildisplay'] = 'Sigbaarheid van e-pos';
$string['emaildisplay_help'] = '* Versteek – Net gebruikers wat die toepaslike toestemming, soos dosent het kan jou e-posadres besigtig.
* Sigbaar aan almal – Alle gebruikers kan jou e-posadres besigtig.
* Sigbaar aan kursusdeelnemers – Slegs deelnemers van die kursus waarvoor jy ingeskryf is, kan jou e-posadresbesigtig.';
$string['emaildisplaycourse'] = 'Sigbaar vir kursusdeelnemers';
$string['emaildisplaycoursemembersonly'] = '(Sigbaar aan ande kursuslede)';
$string['emaildisplayeveryone'] = '(Sigbaar aan almal)';
$string['emaildisplayhide'] = '(Versteek van almal behalwe nie-gemagtigde gebruikers)';
$string['emaildisplayno'] = 'Versteek';
$string['emaildisplayyes'] = 'Sigbaar vir almal';
$string['emailenable'] = 'Hierdie e-pos adres is geaktiveer';
$string['emailenableclick'] = 'Kliek hier om weer al die e-pos wat gestuur word aan hierdie adres te kan ontvang';
$string['emailexists'] = 'Hierdie e-pos adres is reeds geregistreer.';
$string['emailexistshintlink'] = 'Herstel jou vergete gebruikersnaam en wagwoord';
$string['emailexistssignuphint'] = 'Het jy nie dalk \'n profiel in die verlede geskep nie? {$a}';
$string['emailformat'] = 'E-pos formaat';
$string['emailmustbereal'] = 'Let wel: jou e-posadres moet \'n werklike een wees';
$string['emailnotallowed'] = 'E-pos adresse in hierdie domien is nie toegelaat nie ({$a})';
$string['emailnotfound'] = 'Die e-pos adres kan nie in die databasis gevind word nie';
$string['emailonlyallowed'] = 'Hierdie e-pos is nie een van diegene wat toegelaat word nie ({$a})';
$string['emailpasswordchangeinfo'] = 'Hi {$a->firstname},

Iemand (waarskynlik jy) het \'n nuwe wagwoord versoek vir jou rekening \'{$a->username}\' op \'{$a->sitename}.

Om jou wagwoord te verander, gaan jy na die volgende web adres:

{$a->link}

In die meeste e-pos programme, moet dit lyk soos \'n blou skakel waarop jy net kan kliek. As dit nie werk nie, dan kan jy die adres sny en plak in die adres lyn aan die bokant van jou webleser.

As jy hulp nodig het, kontak die blad administrateur, {$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Hi {$a->firstname},

Iemand (waarskynlik jy) het \'n nuwe wagwoord versoek vir jou rekening op \'{$a->sitename}.

Ongelukkig is jou rekening op hierdie webtuiste ge-deaktiveer en kan nie herstel word nie, kontak die blad administrateur, {$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Hi {$a->firstname},

Iemand (waarskynlik jy) het \'n nuwe wagwoord versoek vir jou rekening op \'{$a->sitename}.

Ongelukkig wagwoorde kan nie herstel word op hierdie webwerf nie, kontak die blad administrateur, {$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Verandering van wagwoord inligting';
$string['emailpasswordconfirmation'] = 'Hi {$a->firstname},

Iemand (waarskynlik jy) het \'n nuwe wagwoord versoek vir jou rekening op \'{$a->sitename}.

Om dit te bevestig en het \'n nuwe wagwoord aan u gestuur word via e-pos, gaan jy na die volgende web adres:
{$a->link}

In die meeste e-pos programme, moet dit lyk soos \'n blou skakel waarop jy net kan kliek. As dit nie werk nie, dan kan jy die adres sny en plak in die adres lyn aan die bokant van jou blaaier.

As jy hulp nodig het, kontak die blad administrateur, {$a->admin}';
$string['emailpasswordconfirmationsubject'] = '$a}: Wagwoord verandering bevestiging';
$string['emailpasswordconfirmmaybesent'] = '<p>As jy \'n korrekte gebruikersnaam of unieke e-posadres verskaf het, sou \'n e-pos na jou gestuur gewees het. </p>
<p> Dit bevat maklike instruksies om hierdie wagwoord verandering te voltooi en bevestig.
As jy steeds probleme ervaar, kontak asseblief die webwerf administrateur. </p>';
$string['emailpasswordconfirmnoemail'] = '<p> Die gebruiker\'s rekening wat u verskaf het besit nie \'n aangetekenings e-pos adres nie. </p>
<p> Kontak die webtuiste se administrateur. </p>';
$string['emailpasswordconfirmnotsent'] = '<p> Die gebruikers besonderhede wat jy verskaf het identifiseer nie met enige bestaande gebruikers rekening nie. </p><p> Gaan asseblief die inligting wat u verskaf het, en probeer dan weer. As jy enige probleme ondervind, kontak die webtuiste se administrateur. </p>';
$string['emailpasswordconfirmsent'] = '\'n E-pos moes na jou adres gestuur geword het by <b>{$a}.</b> <br /> Dit bevat maklike instruksies te bevestig en voltooiing van hierdie wagwoord verandering. As jy nog steeds probleme het, kontak die moderator van hierdie site.';
$string['emailresetconfirmation'] = 'Hi {$a->firstname},

’n Wagwoordherstellingsversoek vir jou rekening \'{$a->username}\' by {$a->sitename} is aangevra.

Om hierdie versoek te bevestig en ’n nuwe wagwoord vir jou rekening op te stel, gaan asseblief na die volgende webadres:

{$a->link}

(Hierdie skakel is geldig vir {$a->resetminutes} minute vanaf die tyd wat hierdie herstelling vir die eerste keer versoek is.)

As hierdie wagwoordherstelling nie deur jou versoek is nie, is geen aksie nodig nie.

As jy hulp nodig het, kontak die webtuiste se administrateur, {$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: wagwoordterugstellings versoek';
$string['emailresetconfirmsent'] = '\'n E-pos is aan jou gestuur by <b>{$a}.</b> <br /> Dit bevat maklike instruksies om die versoek te bevestig en die wagwoord verandering uit te oefen.

As jy probleme ondervind, kontak die webtuiste se administrateur.';
$string['emailstop'] = 'Deaktiveer kennisgewings';
$string['emailtoprivatefiles'] = 'Jy kan ook lêers e-pos as aanhegsels direk na jou privaat dokumente spasie. Heg eenvoudig jou lêers aan \'n e-pos en stuur dit na {$a}';
$string['emailtoprivatefilesdenied'] = 'Die administrateur het die opsie afgestel wat jou toelaat om jou eie privaat lêers op te laai.';
$string['emailvia'] = '{$a->name} (via {$a->siteshortname})';
$string['emojicategoryactivities'] = 'Aktiwiteite';
$string['emojicategoryanimalsnature'] = 'Diere & natuur';
$string['emojicategoryflags'] = 'Vlae';
$string['emojicategoryfooddrink'] = 'Kos & Drank';
$string['emojicategoryobjects'] = 'Objekte';
$string['emojicategorypeoplebody'] = 'Mense & liggaam';
$string['emojicategoryrecent'] = 'Onlangs';
$string['emojicategorysmileysemotion'] = 'Glimlaggies en emosie';
$string['emojicategorysymbols'] = 'Simbole';
$string['emojicategorytravelplaces'] = 'Reis & Plekke';
$string['emptycmids'] = 'die kursus module IDs is leeg';
$string['emptydragdropregion'] = 'leë area';
$string['emptysectionids'] = 'die kursus afdeling IDs is leeg';
$string['enable'] = 'Aktiveer';
$string['encryptedcode'] = 'Geïnkripteerde kode';
$string['enddate'] = 'Kursus einddatum';
$string['enddate_help'] = 'Die einddatum beperk nie studente se toegang tot die kursus nie. Dit bepaal of a kursus gelys is as Verby in My kursusse.';
$string['enddatewithtaskenabled'] = 'Kursuseinddatum';
$string['enddatewithtaskenabled_help'] = 'Die datum waarop die kursus versteek word vir studente en hulle het nie meer toegang daartoe nie.';
$string['english'] = 'Engels';
$string['enrolmentmethods'] = 'Inskrywings metodes';
$string['entercourse'] = 'Klik om hierdie kursus in te tree';
$string['enteremail'] = 'Voer jou e-posadres in';
$string['enteremailaddress'] = 'Voer jou e-posadres in om jou wagwoord te herstel
 en sodat die nuwe wagwoord na jou via e-pos gestuur word.';
$string['enterusername'] = 'Voer jou gebruikersnaam in';
$string['entries'] = 'Inskrywings';
$string['error'] = 'Fout';
$string['errorcreatingactivity'] = 'Kan nie \'n geval van die aktiwiteit \'{$a}\' skep nie';
$string['errorfiletoobig'] = 'Die lêer is groter as die limiet van {$a} bytes';
$string['errornouploadrepo'] = 'Daar is geen oplaai bewarings plek opgestel vir hierdie webwerf nie.';
$string['errorwhenconfirming'] = 'Jy is nog nie bevestig nie omdat \'n fout plaasgevind het. As jy ge-kliek het op \'n skakel in \'n e-pos hier te kom, maak seker dat die lyn in jou e-pos is nie gebreek of oorgevloei het nie. Jy mad dalk sny en plak moet gebruik om die skakel behoorlik te herbou.';
$string['eventcommentcreated'] = 'Kommentaar geskep';
$string['eventcommentdeleted'] = 'Kommentaar verwyder';
$string['eventcommentsviewed'] = 'Kommentaar beskou';
$string['eventconfiglogcreated'] = '\'Config log\' is geskep';
$string['eventcontentviewed'] = 'Inhoud wat beskou was';
$string['eventcoursebackupcreated'] = 'Rugsteun van die kursus geskep';
$string['eventcoursecategorycreated'] = 'Kategorie geskep';
$string['eventcoursecategorydeleted'] = 'Kategorie geskrap';
$string['eventcoursecategoryupdated'] = 'Kategorie opgedateer';
$string['eventcoursecategoryviewed'] = 'Kategorie besigtig';
$string['eventcoursecontentdeleted'] = 'Kursus inhoud verwyder';
$string['eventcoursecreated'] = 'Kursus geskep';
$string['eventcoursedeleted'] = 'Kursus geskrap';
$string['eventcourseended'] = 'Kursus eindig';
$string['eventcourseinformationviewed'] = 'Kursus oorsig besigtig';
$string['eventcoursemodulecreated'] = 'Kursus module geskep';
$string['eventcoursemoduledeleted'] = 'Kursus module geskrap';
$string['eventcoursemoduleinstancelistviewed'] = 'Kursus module lys beskou';
$string['eventcoursemoduleupdated'] = 'Kursus module opgedateer';
$string['eventcoursemoduleviewed'] = 'Kursus module beskou';
$string['eventcourseresetended'] = 'Kursus herstelling geëindig';
$string['eventcourseresetstarted'] = 'Kursus herstel begin';
$string['eventcourserestored'] = 'Kursus herstel';
$string['eventcoursesectioncreated'] = 'Kursus afdeling geskep';
$string['eventcoursesectiondeleted'] = 'Kursus afdeling verwyder';
$string['eventcoursesectionupdated'] = 'Kursus afdeling opgedateer';
$string['eventcoursessearched'] = 'Kursusse deursoek';
$string['eventcoursestarted'] = 'Kursus begin';
$string['eventcourseupdated'] = 'Kursus opgedateer';
$string['eventcourseuserreportviewed'] = 'Kursus gebruikers verslag beskou';
$string['eventcourseviewed'] = 'Kursus beskou';
$string['eventdashboardreset'] = 'Herstel paneelbord';
$string['eventdashboardsreset'] = 'Herstel paneelborde';
$string['eventdashboardviewed'] = 'Paneelbord besigtig';
$string['eventdatabasetextfieldcontentreplaced'] = 'Databais globale soek en vervang';
$string['eventemailfailed'] = 'E-pos het misluk om te stuur';
$string['eventmycoursesviewed'] = 'my gesiende kursuse';
$string['eventname'] = 'Aktiwiteit naam';
$string['eventrecentactivityviewed'] = 'Onlangse aktiwiteit beskou';
$string['eventsearchindexed'] = 'Soekdata geïndekseer';
$string['eventsearchresultsviewed'] = 'Soek resultate besigtig';
$string['eventsectionviewed'] = 'Het afdeling beskou';
$string['eventunknownlogged'] = 'Onbekende aktiwiteit';
$string['eventurlblocked'] = 'Die URL is geblok';
$string['eventusercreated'] = 'Gebruiker geskep';
$string['eventuserdeleted'] = 'Gebruiker geskrap';
$string['eventuserfeedbackgiven'] = 'Terugvoer skakel geklik';
$string['eventuserfeedbackremind'] = 'Herinner my later teruvoer skakel geklik';
$string['eventuserinfocategorycreated'] = 'Gebruiker profiel veld kategorie geskep';
$string['eventuserinfocategorydeleted'] = 'Gebruiker profiel veld kategorie verwyder';
$string['eventuserinfocategoryupdated'] = 'Gebruiker profiel veld kategorie bygewerk';
$string['eventuserinfofieldcreated'] = 'Gebruiker profiel veld geskep';
$string['eventuserinfofielddeleted'] = 'Gebruiker profiel veld verwyder';
$string['eventuserinfofieldupdated'] = 'Gebruiker profiel veld bygewerk';
$string['eventuserlistviewed'] = 'Gebruikers lys wat besigtig was';
$string['eventuserloggedout'] = 'Gebruiker uitgeteken';
$string['eventuserpasswordpolicyfailed'] = 'Gebruiker wagwoord misluk wagwoord beleid';
$string['eventuserpasswordupdated'] = 'Gebruiker wagwoord opgedateer';
$string['eventuserprofileviewed'] = 'Gebruikers profiel beskou';
$string['eventuserupdated'] = 'Gebruiker opgedateer';
$string['everybody'] = 'Almal';
$string['executeat'] = 'Voer uit op';
$string['existing'] = 'Bestaande';
$string['existingadmins'] = 'Bestaande Administrateurs';
$string['existingcourse'] = 'Bestaande kursus';
$string['existingcourseadding'] = 'Bestaande kursus, besig om data by te voeg';
$string['existingcoursedeleting'] = 'Bestaande kursus, besig om dit eers uit te wis';
$string['existingcreators'] = 'Bestaande kursus skeppers';
$string['existingstudents'] = 'Geregistreerde studente';
$string['existingteachers'] = 'Bestaande onderwysers';
$string['expand'] = 'Brei uit';
$string['expandall'] = 'Brei alles uit';
$string['expandcategory'] = 'Brei {$a} uit';
$string['explanation'] = 'Verduideliking';
$string['explanationdigitalminor'] = 'Hierdie inligting word vereis om te bepaal of jy ouer is as die toegelate digitale ouderdom. Dit is die ouderdom waarna \'n individu toestemming mag gee tot bepalings en voorwaardes asook om hul data wettig te stoor en te verwerk.';
$string['extendperiod'] = 'Verlengde tydperk';
$string['extendsession'] = 'Verleng sessie';
$string['failedloginattempts'] = '{$a->attempts} mislukte intekenings sedert jy laas ingeteken het';
$string['failedtaskbody'] = '<p>Hallo {$a->firstname},</p>
<p>Die taak <b>{$a->taskname}</b> het verskeie kere misluk en het aandag nodig.</p>
<p><a href="{$a->link}">Sien taak</a></p>';
$string['failedtaskcontexturlname'] = 'Statusverslag';
$string['failedtasksubject'] = 'Mislukte taak: {$a}';
$string['favourites'] = 'Met \'n ster gemerk';
$string['feedback'] = 'Terugvoering';
$string['file'] = 'Lêer';
$string['fileexists'] = 'Daar is reeds \'n lêer met die naam {$a}';
$string['filemissing'] = '{$a} ontbreek';
$string['filereaderror'] = 'Nie in staat op die lêer \'{$a}\' te lees nie. Bevestig asseblief dat dit \'n dokument is en nie \'n gids nie.';
$string['files'] = 'Lêers';
$string['filesanduploads'] = 'Lêers en opgelaaide inhoud';
$string['filesfolders'] = 'Lêers/lêergidse';
$string['fileuploadwithcontent'] = 'Lêers vir oplaai moet nie die inhoud parameter insluit nie';
$string['filloutallfields'] = 'Vul asseblief al die velde in hierdie vorm in';
$string['filter'] = 'Filter';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = 'Filter {$a}';
$string['filters'] = 'Filters';
$string['filtersetmatchdescription'] = 'Hoe veelvuldige filters gekombineer moet word';
$string['filtertype'] = 'Filtertipe';
$string['findmorecourses'] = 'Vind meer kursusse...';
$string['first'] = 'Eerste';
$string['firstaccess'] = 'Eerste toegang';
$string['firstname'] = 'Voornaam';
$string['firstnamephonetic'] = 'Voornaam - foneties';
$string['firstpage'] = 'Eerste bladsy';
$string['firstsiteaccess'] = 'Eerste toegang na die blad';
$string['firsttime'] = 'Is dit jou eerste keer hier?';
$string['folder'] = 'Lêergids';
$string['folderclosed'] = 'Toegemaakte lêer';
$string['folderopened'] = 'Oopgemaakte lêer';
$string['followingoptional'] = 'Die volgende items is opsioneel';
$string['followingrequired'] = 'Die volgende items word vereis';
$string['for'] = 'Vir';
$string['force'] = 'Forseer';
$string['forcelanguage'] = 'Forseer taal';
$string['forceno'] = 'Moet nie forseer nie';
$string['forcepasswordchange'] = 'Forseer verandering van wagwoord';
$string['forcepasswordchange_help'] = 'As die boks is gemerk, sal die gebruiker gevra word om hul wagwoord op hul volgende aantekening te verander';
$string['forcepasswordchangecheckfull'] = 'Is jy seker jy wil \'n wagwoord verandering te {$a} te forseer?';
$string['forcepasswordchangenot'] = 'Kon nie forseer om \'n wagwoord verandering te {$a}';
$string['forcepasswordchangenotice'] = 'Jy moet jou wagwoord verander om voort te gaan.';
$string['forcepasswordresetfailurenotice'] = 'Jou huidige wagwoord kom nie meer die ingestelde wagwoord-beleid na nie. Kontak asseblief jou Moodle administrateur vir hulp.
{$a}';
$string['forcepasswordresetnotice'] = 'Jou huidige wagwoord kom nie meer die ingestelde wagwoord-beleid na nie. Jy moet jou wagwoord herstel om weer in te teken.
{$a}';
$string['forcetheme'] = 'Forseer tema';
$string['forgotaccount'] = 'Verlore wagwoord?';
$string['forgotten'] = 'Het jy jou gebruikersnaam en wagwoord vergeet?';
$string['forgottenduplicate'] = 'Die e-posadres word gedeel deur verskeie rekeninge, verskaf asseblief liewer gebruikersnaam instede';
$string['forgotteninvalidurl'] = 'Ongeldige wagwoord herstellings bronadres';
$string['format'] = 'Formaat';
$string['formathtml'] = 'HTML formaat';
$string['formatmarkdown'] = 'Afgemerkte formaat';
$string['formatplain'] = 'Teks formaat';
$string['formattext'] = 'Moodle outo-formaat';
$string['forumpreferences'] = 'Forum voorkeure';
$string['framesetinfo'] = 'Hierdie raamstel dokument bevat:';
$string['fromdate'] = 'Van';
$string['fromsender'] = 'Van';
$string['frontpagecategorycombo'] = 'Kombinasie lys';
$string['frontpagecategorynames'] = 'Lys van kategorieë';
$string['frontpagecourselist'] = 'Lys van kursusse';
$string['frontpagecoursesearch'] = 'Kursus soek boks';
$string['frontpagedescription'] = 'Tuisbladsamevatting';
$string['frontpagedescriptionhelp'] = 'Hierdie opsomming kan op die voorblad met behulp van die kursus / site opsomming blok vertoon word.';
$string['frontpageenrolledcourselist'] = 'Ingeskrewe kursusse';
$string['frontpageformat'] = 'Tuisbladformaat';
$string['frontpageformatloggedin'] = 'Tuisbladformaat wanneer ingeteken is';
$string['frontpagenews'] = 'Aankondigings';
$string['frontpagesettings'] = 'Tuisbladinstellings';
$string['fulllistofcourses'] = 'Alle kursusse';
$string['fullname'] = 'Volle naam';
$string['fullnamecourse'] = 'Kursus volle naam';
$string['fullnamecourse_help'] = 'Die naam wat vertoon word in My kursusse en in die lys van beskikbare kursusse op die tuisblad.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Gebruikers volle naam';
$string['fullprofile'] = 'Volledige profiel';
$string['fullsitename'] = 'Volle naam van die webwerf';
$string['functiondisabled'] = 'Daardie funksionaliteit is tans versper';
$string['general'] = 'Algemene';
$string['geolocation'] = 'breedtegraad - lengtegraad';
$string['gettheselogs'] = 'Kry hierdie logs';
$string['go'] = 'Gaan';
$string['gobacktosite'] = 'Gaan terug na die webwerf toe';
$string['gpl'] = 'Copyright (C) vanaf 1999 Martin Dougiamas (http://moodle.com)

Hierdie program is gratis sagteware, u kan dit herversprei en / of wysig onder die voorwaardes van die GNU Algemene Publieke Lisensie soos gepubliseer deur die Free Software Foundation; of weergawe 2 van die lisensie, of (as jy wil) enige latere weergawe.

Hierdie program word versprei in die hoop dat dit nuttig sal wees, maar SONDER ENIGE WAARBORG, selfs sonder die geïmpliseerde waarborg van VERHANDELBAARHEID of GESKIKTHEID VIR \'N SPESIFIEKE DOEL.

Sien die Moodle Lisensie inligtingsbladsy vir volledige besonderhede: http://docs.moodle.org/dev/License';
$string['gpl3'] = 'Copyright (C) vanaf 1999 Martin Dougiamas (http://moodle.com)

Hierdie program is gratis sagteware, u kan dit herversprei en / of wysig onder die voorwaardes van die GNU Algemene Publieke Lisensie soos gepubliseer deur die Free Software Foundation; of weergawe 3 van die lisensie, of (as jy wil) enige latere weergawe.

Hierdie program word versprei in die hoop dat dit nuttig sal wees, maar SONDER ENIGE WAARBORG, selfs sonder die geïmpliseerde waarborg van VERHANDELBAARHEID of GESKIKTHEID VIR \'N SPESIFIEKE DOEL.

Sien die Moodle lisensie inligting bladsy vir volledige besonderhede: http://docs.moodle.org/dev/License';
$string['gpllicense'] = 'GPL lisensie';
$string['gradenoun'] = 'Punt';
$string['grades'] = 'Punte';
$string['gradeverb'] = 'Merk';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> is vir hierdie webwerf ontsper. As jy nie \'n profielfoto oplaai nie, sal Moodle probeer om \'n profielfoto vir jou op te laai vanaf Gravatar.';
$string['group'] = 'Groep';
$string['groupadd'] = 'Voeg nuwe groep by';
$string['groupaddusers'] = 'Voeg geselekteerde by groep';
$string['groupfor'] = 'vir groep';
$string['groupinfo'] = 'Inligting oor die geselekteerde groep';
$string['groupinfoedit'] = 'Redigeer groep instellings';
$string['groupinfomembers'] = 'Inligting oor die geselekteerde groep';
$string['groupinfopeople'] = 'Inligting oor geselekteerde mense';
$string['groupmembers'] = 'Lede van die groep';
$string['groupmemberssee'] = 'Sien groeplede';
$string['groupmembersselected'] = 'Lede van die groep gekies';
$string['groupmode'] = 'Groep modus';
$string['groupmodeforce'] = 'Forseer groep modus';
$string['groupmy'] = 'My groep';
$string['groupnonmembers'] = 'Mense nie in \'n groep nie';
$string['groupnotamember'] = 'Jammer, jy is nie \'n lid van daardie groep nie';
$string['grouprandomassign'] = 'Wys almal lukraak na groepe aan';
$string['groupremove'] = 'Verwyder geselekteerde groep';
$string['groupremovemembers'] = 'Verwyder geselekteerde lede';
$string['groups'] = 'Groepe';
$string['groupsnone'] = 'Geen groepe';
$string['groupsseparate'] = 'Afsonderlike groepe';
$string['groupsvisible'] = 'Sigbare groepe';
$string['guest'] = 'Besoeker';
$string['guestdescription'] = 'Besoeker het minimale voorregte en kan gewoonlik nie enige teks enige plek invoer nie.';
$string['guestskey'] = 'Laat gaste toe wat die sleutel het';
$string['guestsno'] = 'Moet geen besoekers inlaat nie';
$string['guestsnotallowed'] = 'Jammer, \'{$a}\' laat nie besoekers toe nie.';
$string['guestsyes'] = 'Laat gaste toe wat nie die sleutel het nie';
$string['guestuser'] = 'Besoekers gebruiker';
$string['guestuserinfo'] = 'Hierdie gebruiker is \'n spesiale gebruiker lees-alleen toegang tot sommige kursusse.';
$string['help'] = 'Hulp';
$string['helpprefix2'] = 'Hulp met {$a}';
$string['helpwiththis'] = 'Hulp met hierdie';
$string['hiddenassign'] = 'Versteekte opdrag';
$string['hiddenfromstudents'] = 'Versteek van studente';
$string['hiddenoncoursepage'] = 'Beskikbaar, maar gaan nie op die kursus bladsy vertoon word nie';
$string['hiddensections'] = 'Versteekte afdelings';
$string['hiddensections_help'] = 'Hierdie instelling bepaal of verborge afdelings vertoon aan studente in verstrekte vorm (miskien vir \'n kursus in weeklikse formaat om vakansies aan te dui), of heeltemal versteek is.';
$string['hiddensectionscollapsed'] = 'Versteekte afdelings word in verstrekte vorm vertoon';
$string['hiddensectionsinvisible'] = 'Verborge afdelings is heeltemal onsigbaar';
$string['hiddenwithbrackets'] = '(versteek)';
$string['hide'] = 'Verberg';
$string['hideadvancedsettings'] = 'Versteek gevorderde instellings';
$string['hidechartdata'] = 'Versteek grafiek se data';
$string['hidefromstudents'] = 'Versteek van studente';
$string['hideoncoursepage'] = 'Maak beskikbaar maar moet nie op die kursus bladsy vertoon nie';
$string['hidepopoverwindow'] = 'Versteek die \'popover\' venster';
$string['hidesection'] = 'Verberg artikel {$a}';
$string['hidesettings'] = 'Versteek instellings';
$string['hideshowblocks'] = 'Toon of verberg blokke';
$string['highlight'] = 'Verlig';
$string['highlighted'] = 'Uitgelig';
$string['highlightoff'] = 'Verwyder verligting';
$string['hits'] = 'Besoekers';
$string['hitsoncourse'] = 'Besoeke op {$a->coursename} deur {$a->username}';
$string['hitsoncoursetoday'] = 'Vandag se besoeke op {$a->coursename} deur {$a->username}';
$string['home'] = 'Tuisblad';
$string['homeheader'] = 'Tuis spyskaart';
$string['hour'] = 'uur';
$string['hours'] = 'ure';
$string['howtomakethemes'] = 'Hoe om nuwe temas te maak';
$string['htmleditor'] = 'Gebruik HTML redakteur';
$string['htmleditoravailable'] = 'Die HTML redigeerder is beskikbaar';
$string['htmleditordisabled'] = 'Jy het die HTML redigeerder in jou gerbuikersprofiel versper';
$string['htmleditordisabledadmin'] = 'Die administrateur het fie HTML redigeerder op hierdie webwerf versper';
$string['htmleditordisabledbrowser'] = 'Die HTML redigeerder is onbeskikbaar omdat jou webblaaier nie versoenbaar is nie';
$string['htmlfilesonly'] = 'HTML-lêers alleenlik';
$string['htmlformat'] = 'Mooi HTML-formaat';
$string['icon'] = 'Ikoon';
$string['idnumber'] = 'ID nommer';
$string['idnumbercourse'] = 'Kursus ID-nommer';
$string['idnumbercourse_help'] = 'Die ID-nommer van \'n kursus word slegs gebruik wanneer ooreenstem met die kursus teen eksterne stelsels en is nie oral op die werf vertoon nie. Indien die kursus het \'n amptelike kode naam dit mag ingeskryf word, anders sal die veld kan leeg gelaat word.';
$string['idnumbercoursecategory'] = 'Kategorie ID nommer';
$string['idnumbercoursecategory_help'] = 'Die ID-nommer van \'n kursus kategorie word slegs gebruik wanneer dit ooreenstem met die kategorie teen eksterne stelsels en word nêrens op die werf vertoon nie. Indien die kategorie \'n amptelike kode naam het,  mag dit ingeskryf word, anders kan die veld leeg gelaat word.';
$string['idnumbergroup'] = 'Groep ID nommer';
$string['idnumbergroup_help'] = 'Die ID-nommer van \'n groep word slegs gebruik wanneer dit ooreenstem met die groep teen eksterne stelsels en is nie oral op die werf vertoon nie. As die groep \'n amptelike kode naam het mag dit ingeskryf word, anders sal die veld kan leeg gelaat word.';
$string['idnumbergrouping'] = 'Groepering ID nommer';
$string['idnumbergrouping_help'] = 'Die ID-nommer van \'n groepering word slegs gebruik wanneer dit ooreenstem met die groepering teen eksterne stelsels en is nie oral op die werf vertoon nie. As die groepering \'n amptelike kode naam het mag dit ingeskryf word, anders sal die veld kan leeg gelaat word.';
$string['idnumbermod'] = 'ID-nommer';
$string['idnumbermod_help'] = 'Die opstel van \'n ID-nommer voorsien \'n manier van die identifisering van die aktiwiteit vir die doeleindes van punte berekening of persoonlike verslae. Anders kan die veld leeg gelos word.

Vir assesserings aktiwiteite, kan die ID-nommer ook in die punteboek gestel word, alhoewel dit slegs op die aktiwiteit se instellingsbladsy verander kan word.';
$string['idnumbertaken'] = 'Hierdie ID-nommer is reeds geneem';
$string['imagealt'] = 'Beeld beskrywing';
$string['import'] = 'Invoer';
$string['importdata'] = 'Voer kursus data in';
$string['importdataexported'] = 'Data is suksesvol van \'van\' kursus uitgevoer.<br /> Gaan voort om na jou \'aan\' kursus in te voer.';
$string['importdatafinished'] = 'Invoer voltooi! Gaan voort na jou kursus';
$string['importdatafrom'] = 'Vind \'n kursus om data van in te voer:';
$string['importinfo'] = 'Voer items van ander kursusse in, soos aktiwiteite, blokke of kalendergeleenthede. Geen gebruikerdata word ingevoer.';
$string['inactive'] = 'Onaktief';
$string['include'] = 'Sluit in';
$string['includeallusers'] = 'Sluit alle gebruikers in';
$string['includecoursefiles'] = 'Sluit alle kursus lêers in';
$string['includecourseusers'] = 'Sluit alle kursus gebruikers in';
$string['included'] = 'Ingesluit';
$string['includelogentries'] = 'Sluit log inskrywings in';
$string['includemodules'] = 'Sluit modules in';
$string['includemoduleuserdata'] = 'Sluit module gebruiker data in';
$string['includeneededusers'] = 'Sluit benodigde gebruikers in';
$string['includenoneusers'] = 'Sluit geen gebruikers in';
$string['includeroleassignments'] = 'Sluit rol aanwysings in';
$string['includesitefiles'] = 'Sluit webwerf lêers wat in hierdie kursus gebruik word, in';
$string['includesubcategories'] = 'Sluit subkategorieë in';
$string['includeuserfiles'] = 'Sluit gebruiker lêers in';
$string['increasesections'] = 'Vermeeder die aantal afdelings';
$string['indicator:accessesafterend'] = 'Toegan verkry tot kursus na die einddatum';
$string['indicator:accessesafterend_help'] = 'Hierdie aanwyser weerspieël of die student toegang tot die kursus gehad het na die einddatum van die kursus.';
$string['indicator:accessesbeforestart'] = 'Toegan verkry tot kursus voor die begin datum';
$string['indicator:accessesbeforestart_help'] = 'Hierdie aanwyser weerspieël of die student toegang tot die kursus gekry het voor die begin datum van die kursus.';
$string['indicator:activitiesdue'] = 'Aktiwiteite wat ingehandig moet word';
$string['indicator:activitiesdue_help'] = 'Die gebruiker het geen aktiwiteite wat ingehandig moet word nie.';
$string['indicator:anycourseaccess'] = 'Enige kursus toegang';
$string['indicator:anycourseaccess_help'] = 'Hierdie aanwyser reflekteer toegang tot enige kursus waarin die gebruiker ingeskryf is.';
$string['indicator:anywrite'] = 'Enige skryfaksie';
$string['indicator:anywrite_help'] = 'Hierdie aanwyser toon enige skryfaksie (indiening) aan wat deur die student geneem word.';
$string['indicator:anywriteincourse'] = 'Enige skryfaksie in die kursus';
$string['indicator:anywriteincourse_help'] = 'Hierdie aanwyser toon enige skryfaksie (indiening) aan wat deur die student geneem word in enige kursus aktiwiteit.';
$string['indicator:completeduserprofile'] = 'Gebruiker profiel is voltooi';
$string['indicator:completeduserprofile_help'] = 'Hierdie aanwyser toon aan of die student hul gebruiker profiel voltooi het.';
$string['indicator:completeduserprofiledef'] = 'Gebruiker profiel is voltooi';
$string['indicator:completeduserprofiledef_help'] = 'Die gebruiker het tot die webwerf se beleide ingestem en die volgende velde ingevul: Institusie, Departement, Adres, Stad, Land en URL.';
$string['indicator:completionenabled'] = '';
$string['indicator:completionenabled_help'] = '';
$string['indicator:nostudent'] = 'Studente inskrywings';
$string['indicator:nostudent_help'] = 'Hierdie aanwyser reflekteer die beskikbaarheid van studente in die kursus.';
$string['indicator:noteacher'] = 'Onderwyser beskikbaarheid';
$string['indicator:noteacher_help'] = 'Hierdie aanwyser reflekteer die beskikbaarheid van onderwysers in die kursus.';
$string['indicator:potentialcognitive'] = 'Kursus se potensiële kognitiewe diepte';
$string['indicator:potentialcognitive_help'] = 'Hierdie aanwyser is gebaseer op die potensiële kognitiewe diepte wat deur studente bereik kan word deur deel te neem in die kursus se aktiwiteite.';
$string['indicator:potentialcognitivedef'] = 'Kursus potensiële kognitiewe diepte';
$string['indicator:potentialcognitivedef_help'] = 'Die vlak waartoe die kursus "diep" kognitiewe betrokkenheid aanbied, bv. indiening van werk vir terugvoering, die geleentheid om ander se werk te hersien en die geleentheid om werk te hersien en weer in te dien.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Kursus potensiële sosiale breedte';
$string['indicator:potentialsocial_help'] = 'Hierdie aanwyser is gebaseer op die potensiële sosiale breedte wat deur studente bereik kan word deur deel te neem in die kursus se aktiwiteite.';
$string['indicator:potentialsocialdef'] = 'Kursus potensiële sosiale betrokkenheid';
$string['indicator:potentialsocialdef_help'] = 'Die vlak waartoe die kursus "breë" sosiale betrokkenheid aanbied, interaksies met ander deelnemers en binne die gemeenskap van oefening buite die klaskamer.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Aantal leesaksies';
$string['indicator:readactions_help'] = 'Hierdie aanwyser toon die aantal leesaksies (beskigtig) aan wat deur die student gedoen is.';
$string['indicator:userforumstracking'] = 'Gebruikers volg forums';
$string['indicator:userforumstracking_help'] = 'Hierdie aanwyser toon aan of \'n student opgeteken het om forums te volg of nie.';
$string['info'] = 'Inligting';
$string['inprogress'] = 'Onderweg';
$string['insertcontentbefore'] = 'Voeg inhoud by voor \'{$a->activityname}\'';
$string['insertresourceoractivitybefore'] = 'Voeg \'n aktiwiteit of hulpbron by voor \'{$a->activityname}\' in';
$string['institution'] = 'Instansie';
$string['instudentview'] = 'in student se beskouing';
$string['interests'] = 'Belange';
$string['interestslist'] = 'Lys van belange';
$string['interestslist_help'] = 'Gee jou belange, een vir een wat dan vertoon word op jou profiel as etikette.';
$string['invalidemail'] = 'Ongeldige e-posadres';
$string['invalidlogin'] = 'Ongeldige intek probeerslag, probeer weer';
$string['invalidtaskclassname'] = 'Ongeldige taakklas {$a}';
$string['invalidtaskid'] = 'Ongeldige taak-ID';
$string['invalidusername'] = 'Die gebruikersnaam kan slegs alfa numeriese klein letters (letters en syfers), onderstreep (_), koppelteken (-), punt (.) of by simbool (@) bevat.';
$string['invalidusernameupload'] = 'Ongeldige gebruikernaam';
$string['ip_address'] = 'IP adres';
$string['jump'] = 'Skuif';
$string['jumpto'] = 'Skuif na ...';
$string['keep'] = 'Hou';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Taal rigting links-na-regs';
$string['langrtl'] = 'Taal rigting regs-na-links';
$string['language'] = 'Taal';
$string['languagegood'] = 'Hierdie taalpakket is op datum! :-)';
$string['languageselector'] = 'Taal keurder';
$string['last'] = 'Laaste';
$string['lastaccess'] = 'Laaste toegang';
$string['lastcourseaccess'] = 'Laaste toegang na die kursus';
$string['lastedited'] = 'Laaste gewysig';
$string['lastip'] = 'Laaste IP adres';
$string['lastlogin'] = 'Laaste intekening';
$string['lastmodified'] = 'Laaste wysiging';
$string['lastname'] = 'Van';
$string['lastnamephonetic'] = 'Van - foneties';
$string['lastpage'] = 'Laaste bladsy';
$string['lastsiteaccess'] = 'Laaste toegang tot die blad';
$string['lastyear'] = 'Verlede jaar';
$string['latestlanguagepack'] = 'Kyk vir die nuutste taalpakket op moodle.org';
$string['layouttable'] = 'Uitleg tabel';
$string['leavetokeep'] = 'Los oop om huidige wagwoord te behou';
$string['legacylogginginuse'] = 'Hierdie blad het die instelling geaktiveer om na die oudtydse aantekening lêers. Om na hierdie aantekening lêers te skryf is opgeskort. Skryf asseblief na \'n aantekeninge wat ondersteun word soos "standaard" of "ekstern".';
$string['legacythemeinuse'] = 'Hierdie blad word in \'n verenigbare model vertoon omdat jou weblewer te oud is.';
$string['license'] = 'Lisensie';
$string['licenses'] = 'Lisensies';
$string['liketologin'] = 'Wil jy nou inteken met \'n volledige gebruiker profiel?';
$string['list'] = 'Lys';
$string['listfiles'] = 'Lys van lêers in {$a}';
$string['listofallpeople'] = 'Lys van alle mense';
$string['listofcourses'] = 'Lys van kursusse';
$string['loading'] = 'Besig om te laai';
$string['loadinghelp'] = 'Besig om te laai ...';
$string['local'] = 'Plaaslik';
$string['localplugins'] = 'Plaaslike invoegde toepassings';
$string['localpluginsmanage'] = 'Bestuur plaaslike ingevoegde toepassings';
$string['location'] = 'Plek';
$string['locktimeout'] = 'Die operasie tyd het verstrek terwyl gewag is vir uitsluiting.';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Jy is ingeteken as {$a}';
$string['loggedinasguest'] = 'U gebruik tans gaste toegang';
$string['loggedinnot'] = 'Jy is nie in geteken nie.';
$string['login'] = 'Teken in';
$string['login_failure_logs'] = 'Inteken mislukking logs';
$string['loginactivity'] = 'Inteken aktiwiteite';
$string['loginagain'] = 'Teken weer in';
$string['loginalready'] = 'Jy is reeds ingeteken';
$string['loginas'] = 'Teken in as';
$string['loginaspasswordexplain'] = '<p>Jy moet die spesiale "loginas password" invoer om hierdie eienskap te gebruik.<br />As jy nei weet wat dit is nie, vra jou bediener administrateur.</p>';
$string['loginguest'] = 'Teken in as \'n besoeker';
$string['loginsite'] = 'Teken in op die blad';
$string['loginsteps'] = 'Vir volle toegang tot die blad moet jy eerste \'n profiel skep.';
$string['loginstepsnone'] = '<p>Hi!</p>
<p>Vir volle toegang tot die kursusse moet jy vir jouself \'n profiel skep.</p>
<p>Al wat jy hoef te doen, is om \'n gebruikersnaam en wagwoord te skep en dan te gebruik in die vorm op hierdie bladsy!</p>
<p>As iemand klaar die gebruikernaam gekies het, sgaan jy weer met \'n ander gebruikersnaam moet probeer.</p>';
$string['loginto'] = 'Teken in na {$a}';
$string['logoof'] = 'Logo van {$a}';
$string['logout'] = 'Teken uit';
$string['logoutconfirm'] = 'Wil jy regtig uiteken?';
$string['logs'] = 'Aantekeninge';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">meer</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">meer</a> ]';
$string['lookback'] = 'Kyk terug';
$string['mailadmins'] = 'Stel administrateurs in kennis';
$string['mailstudents'] = 'Stel studente in kennis';
$string['mailteachers'] = 'Stel onderwysers in kennis';
$string['maincoursepage'] = 'Kursus voorblad';
$string['makeafolder'] = 'Skep \'n gids';
$string['makeavailable'] = 'Maak beskikbaar';
$string['makeeditable'] = 'As jy \'{$a}\' deur die webbediener proses (bv. apache) redigeerbaar maak, kan jy hierdie lêer direk vanaf hierdie bladsy redigeer';
$string['makethismyhome'] = 'Maak hierdie my tuisblad';
$string['makeunavailable'] = 'Trek beskikbaarheid terug';
$string['manageblocks'] = 'Blokke';
$string['managecategories'] = 'bestuur van kursus kategorie';
$string['managecategorythis'] = 'Bestuur hierdie kategorie';
$string['managecombined'] = 'bestuur van kursus kategorie en kursuse';
$string['managecontentbanktypes'] = 'Bestuur inhoud tipes';
$string['managecourses'] = 'Bestuur kursusse';
$string['managedatabase'] = 'Databasis';
$string['managedataformats'] = 'Bestuur data formate';
$string['manageeditorfiles'] = 'Bestuur lêers wat deur die redigeerder gebruik word';
$string['managefilters'] = 'Filters';
$string['managemodules'] = 'Modules';
$string['manageroles'] = 'Rolle en regte';
$string['markallread'] = 'Merk alles as gelees';
$string['match'] = 'Pas';
$string['matchingsearchandrole'] = 'Bypassende \'{$a->search}\' met {$a->role}';
$string['matchofthefollowing'] = 'van die volgende:';
$string['maxareabytesreached'] = 'Die lêer (of die totale grootte van verskeie lêers) is groter as die spasie wat beskikbaar is in hierdie gebied.';
$string['maxfilesize'] = 'Maksimum grootte vir nuwe lêers: {$a}';
$string['maxfilesreached'] = 'Jy word toegelaat om \'n maksimum van {$a} lêer(s) aan te heg aan hierdie item';
$string['maximumchars'] = 'Maksimum van {$a} karakters';
$string['maximumgrade'] = 'Maksimum punt';
$string['maximumgradex'] = 'Maksimum punt: {$a}';
$string['maximumshort'] = 'Maksimum';
$string['maximumupload'] = 'Maksimum oplaai grootte';
$string['maximumupload_help'] = 'Hierdie instelling bepaal die grootste grootte van die lêer wat opgelaai kan word op die kursus, beperk deur die instelling wat deur \'n administrateur gestel is. Aktiwiteit modules sluit ook \'n maksimum oplaai grootte instelling vir verdere beperking van die grootte van die lêer in.';
$string['maxnumberweeks'] = 'Maksimum aantal afdelings';
$string['maxnumberweeks_desc'] = 'Die maksimum waarde van die aantal afdelings kieslys (geld net vir sekere formate van kursus).';
$string['maxnumcoursesincombo'] = 'Bekyk <a href="{$a->link}">{$a->numberofcourses} kursusse</a> .';
$string['maxsectionslimit'] = 'Kan nie \'n nuwe afdeling skep nie omdat dit die maksimum aantal afdelings gaan oorskry vir hierdie kursus ({$a}).';
$string['maxsize'] = 'Maks grootte: {$a}';
$string['maxsizeandareasize'] = 'Maksimum grootte vir nuwe lêers: {$a->size}, algehele limiet: {$a->areasize}';
$string['maxsizeandattachments'] = 'Maksimum lêergrootte: {$a->size}, maksimum aantal lêers: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Maksimum lêergrootte: {$a->size}, maksimum aantal lêers: {$a->attachments}, maksimum totale grootte: {$a->areasize}';
$string['memberincourse'] = 'Mense in die kursus';
$string['menu'] = 'Kieslys';
$string['message'] = 'Boodskap';
$string['messagebody'] = 'Boodskap inhoud';
$string['messagedselectedusers'] = 'Boodskap gestuur aan gekose gebruikers en die lys van ontvangers is herstel.';
$string['messagedselectedusersfailed'] = '\'n Fout het voorgekom terwyl die boodskap aan die gekose gebruikers gestuur is. Sommige gebruikers mag dalk die e-pos ontvang het.';
$string['messageprovider:asyncbackupnotification'] = 'Asinchroniese rugsteun / herstel kennisgewings';
$string['messageprovider:availableupdate'] = 'Beskikbare bywerking kennisgewings';
$string['messageprovider:backup'] = 'Rugsteun kennisgewings';
$string['messageprovider:badgecreatornotice'] = 'Kenteken skepper kennisgewings';
$string['messageprovider:badgerecipientnotice'] = 'Kenteken ontvanger kennisgewings';
$string['messageprovider:competencyplancomment'] = 'Kommentaar geplaas op \'n leerplan';
$string['messageprovider:competencyusercompcomment'] = 'Kommentaar geplaas op \'n bekwaamheid';
$string['messageprovider:coursecompleted'] = 'Kursus voltooi';
$string['messageprovider:coursecontentupdated'] = 'kursus inhoud veranderinge';
$string['messageprovider:courserequestapproved'] = 'Kursus skepping goedkeurings versoek kennisgewing';
$string['messageprovider:courserequested'] = 'Kursus skepping versoek kennisgewing';
$string['messageprovider:courserequestrejected'] = 'Kursus skepping versoek verwerpings kennisgewing';
$string['messageprovider:enrolcoursewelcomemessage'] = 'Welkomboodskap vir nuwe kursusinskrywings';
$string['messageprovider:errors'] = 'Belangrike foute met die blad';
$string['messageprovider:errors_help'] = 'Hierdie is belangrike foute wat \'n administrateur van moet weet.';
$string['messageprovider:failedtaskmaxdelay'] = 'Taak bereik sy maksimum mislukkingsvertraging';
$string['messageprovider:gradenotifications'] = 'Punte Kennisgewings';
$string['messageprovider:infected'] = 'Antivirus mislukking kennisgewings';
$string['messageprovider:insights'] = 'Insigte gegenereer deur voorspellingsmodelle';
$string['messageprovider:instantmessage'] = 'Persoonlike boodskappe tussen gebruikers';
$string['messageprovider:instantmessage_help'] = 'Hierdie afdeling stel in wat gebeur met boodskappe wat ander gebruikers direk aan jou stuur op hierdie blad.';
$string['messageprovider:messagecontactrequests'] = 'Boodskap kontak navrae kennisgewing';
$string['messageprovider:newlogin'] = 'Nuwe inteken kennisgewings';
$string['messageprovider:notices'] = 'Kennisgewings oor klein probleme';
$string['messageprovider:notices_help'] = 'Hierdie is kennisgewings wat \'n administrateur dalk in belang sal stel.';
$string['messageprovider:reportbuilderschedule'] = 'Skedules van pasgemaakte rapporte';
$string['messageselect'] = 'Kies hierdie gebruiker as \'n ontvanger van die boodskap';
$string['messageselectadd'] = 'Stuur \'n boodskap';
$string['middlename'] = 'Middel naam';
$string['migratinggrades'] = 'Versagtende punte';
$string['min'] = 'min';
$string['mins'] = 'mins';
$string['minute'] = 'minuut';
$string['minutes'] = 'minute';
$string['miscellaneous'] = 'Allerlei';
$string['missingcategory'] = 'Jy moet \'n kategorie kies';
$string['missingdescription'] = 'Vermiste beskrywing';
$string['missingemail'] = 'Uitstaande e-posadres';
$string['missingfirstname'] = 'Uitstaande noemnaam';
$string['missingfromdisk'] = 'Ontbreek van hardeskyf';
$string['missingfullname'] = 'Uitstaande volle naam';
$string['missinglastname'] = 'Uitstaande van';
$string['missingname'] = 'Uitstaande naam';
$string['missingnewpassword'] = 'Vermiste nuwe wagwoord';
$string['missingpassword'] = 'Uitstaande wagwoord';
$string['missingrecaptchachallengefield'] = 'Ongeldige reCAPTCHA uitdaging, probeer asseblief weer.';
$string['missingreqreason'] = 'Uitstaande rede';
$string['missingshortname'] = 'Uitstaande kort naam';
$string['missingshortsitename'] = 'Vermiste kort webwerf naam';
$string['missingsitedescription'] = 'Vermiste webwerf beskrywing';
$string['missingsitename'] = 'Vermiste webwerf naam';
$string['missingstrings'] = 'Kyk of daar enige woorde of frases is wat nie vertaal is nie';
$string['missingstudent'] = 'Moet iets kies';
$string['missingsummary'] = 'Vermiste opsomming';
$string['missingteacher'] = 'Moet iets kies';
$string['missingurl'] = 'Vermiste URL';
$string['missingusername'] = 'Uitstaande gebruikersnaam';
$string['moddoesnotsupporttype'] = 'Module {$a->modname} ondersteun nie die oplaai van die tipe {$a->type}';
$string['modhide'] = 'Verberg';
$string['modified'] = 'Veranderd';
$string['modshow'] = 'Vertoon';
$string['moduleintro'] = 'Beskrywing';
$string['modulesetup'] = 'Besig om module tabelle op te stel';
$string['modulesuccess'] = '{$a} tabelle is korrek opgestel';
$string['modulesused'] = 'Modules gebruik';
$string['modvisible'] = 'Beskikbaarheid';
$string['modvisible_help'] = 'Indien die beskikbaarheid gestel is na \'Vertoon op kursus bladsy\', is die aktiwiteit of hulpbron aan studente beskikbaar (onderhewig aan enige toegangsbeperkinge wat opgestel is).

Indien die beskikbaarheid gestel is na \'Versteek van studente\', is die aktiwiteit of hulpbron slegs beskikbaar aan vir gebruikers met die regte om versteekte kursusse te sien (by verstek gebruikers met die rol van onderwyser of nie-redigerende onderwyser).';
$string['modvisiblehiddensection'] = 'Beskikbaarheid';
$string['modvisiblehiddensection_help'] = 'Indien die beskikbaarheid gestel is na \'Versteek van studente\', is die aktiwiteit of hulpbron slegs beskikbaar aan gebruikers met die regte om versteekte aktiwiteite te sien (by verstek gebruikers met die rol van onderwyser of nie-redigerende onderwyser).

Indien die kursus verskeie aktiwiteite of hulpbronne bevat, kan die kursusblad vereenvoudig word deur die beskikbaarheid te stel na \'Maak sigbaar maar moet nie op kursusblad vertoon nie\'. In hierdie geval moet \'n skakel na die aktiwiteit of hulpbron van elders voorsien word, soos \'n bladsy hulpbron. Die aktiwiteit gaan steeds in die punteboek en ander verslae gelys word.';
$string['modvisiblewithstealth'] = 'Beskikbaarheid';
$string['modvisiblewithstealth_help'] = 'Indien die beskikbaarheid gestel is na \'Vertoon op kursusbladsy\', is die aktiwiteit of hulpbron beskikbaar aan studente (onderhewig aan enige toegangsbeperkinge wat opgestel is).

Indien die beskikbaarheid gestel is na \'Versteek van studente\', is die aktiwiteit of hulpbron slegs beskikbaar aan gebruikers met die regte om versteekte aktiwiteite te sien (by verstek gebruikers met die rol van onderwyser of nie-redigerende onderwyser).

Indien die kursus verskeie aktiwiteite of hulpbronne bevat, kan die kursusblad vereenvoudig word deur die beskikbaarheid te stel na \'Maak sigbaar maar moet nie op kursusblad vertoon nie\'. In hierdie geval moet \'n skakel na die aktiwiteit of hulpbron van elders voorsien word, soos \'n bladsy hulpbron. Die aktiwiteit gaan steeds in die punteboek en ander verslae gelys word';
$string['month'] = 'Maand';
$string['months'] = 'Maande';
$string['moodledocs'] = 'Moodle Doks';
$string['moodledocslink'] = 'Hulp Dokumente vir hierdie bladsy';
$string['moodlelogo'] = 'Moodle logo';
$string['moodlenet:cannotconnecttoserver'] = 'Kan nie aan MoodleNet-bediener koppel nie';
$string['moodlenet:columnname'] = 'Naam';
$string['moodlenet:columnsenddate'] = 'Versent datum';
$string['moodlenet:columnsendstatus'] = 'Versent status';
$string['moodlenet:columntype'] = 'Tipe';
$string['moodlenet:configoauthservice'] = 'Kies \'n MoodleNet OAuth 2-diens om deling na daardie MoodleNet-werf moontlik te maak. As die diens nog nie bestaan nie, sal jy dit moet <a href="{$a}">skep</a>.';
$string['moodlenet:deletedactivity'] = 'Geskrapte aktiwiteit';
$string['moodlenet:deletedcourse'] = 'Geskrapte kursus';
$string['moodlenet:gotomoodlenet'] = 'Gaan na MoodleNet-konsepte';
$string['moodlenet:issuerisnotauthorized'] = 'MoodleNet-uitreiker is nie gemagtig nie';
$string['moodlenet:issuerisnotenabled'] = 'MoodleNet-uitreiker is nie geaktiveer nie';
$string['moodlenet:issuerisnotset'] = 'MoodleNet-uitreiker is nie op werfadministrasie gestel nie';
$string['moodlenet:sharingto'] = 'Deel na:';
$string['moodlerelease'] = 'Moodle vrystelling';
$string['moodleservicesandsupport'] = 'Dienste en ondersteuning';
$string['moodleversion'] = 'Moodle weergawe';
$string['more'] = 'meer';
$string['moreactions'] = 'meer aksies';
$string['morehelp'] = 'meer hulp';
$string['morehelpaboutmodule'] = 'Meer hulp oor die {$a} aktiwiteit';
$string['moreinfo'] = 'Meer inligting';
$string['moreinformation'] = 'Meer informasie oor hierdie fout';
$string['moremenu'] = 'Meer';
$string['morenavigationlinks'] = 'Meer...';
$string['moreprofileinfoneeded'] = 'Vertel ons asseblief meer van jouself';
$string['mostrecently'] = 'meer onlangs';
$string['move'] = 'Skuif';
$string['movecategoriessuccess'] = '{$a->count} kategorieë is sukssesvol geskuif na kategorie \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = '{$a->count} kategorieë is suksesvol na boonste vlak geskuif';
$string['movecategorycontentto'] = 'Skuif na';
$string['movecategorysuccess'] = 'Kategorie \'{$a->moved}\' is suksesvol geskuif na die sub-kategorie \'{$a->to} \'';
$string['movecategoryto'] = 'Skuif kategorie na:';
$string['movecategorytotopsuccess'] = 'Kategorie \'{$a->moved}\' is suksesvol geskuif na die boonste vlak';
$string['movecontent'] = 'Skuif {$a}';
$string['movecontentafter'] = 'Na "{$a}"';
$string['movecontentstoanothercategory'] = 'Skuif inhoud na \'n ander kategorie';
$string['movecontenttothetop'] = 'Na die bokant van die lys';
$string['movecoursemodule'] = 'Skuif hulpbron';
$string['movecoursesection'] = 'Skuif afdeling';
$string['movecourseto'] = 'Skuif kursus na:';
$string['movedown'] = 'Skuif af';
$string['movefilestohere'] = 'Skuif lêers hierheen';
$string['movefull'] = 'Skuif {$a} na hierdie plek';
$string['movehere'] = 'Skuif tot hier';
$string['moveleft'] = 'Skuif links';
$string['moveright'] = 'Skuif regs';
$string['movesection'] = 'Skuif afdeling {$a}';
$string['moveselectedcategoriesto'] = 'Skuif geselekteerde kategorieë na';
$string['moveselectedcoursesto'] = 'Skuif geselekteerde kursusse na ...';
$string['movetoanotherfolder'] = 'Skuif na \'n ander lêergids';
$string['moveup'] = 'Skuif op';
$string['mustchangepassword'] = 'Die nuwe wagwoord moet anders as die huidige een wees';
$string['mustconfirm'] = 'U moet u profiel bevestig';
$string['mycourses'] = 'My kursusse';
$string['myfiles'] = 'My private lêers';
$string['myfilesmanage'] = 'Bestuur my private lêers';
$string['myhome'] = 'Paneelbord';
$string['mymoodledashboard'] = 'My Moodle Paneelbord';
$string['myprofile'] = 'My profiel';
$string['name'] = 'Naam';
$string['namedfiletoolarge'] = 'Die lêer \'{$a->filename}\' is te groot en kan nie opgelaai word nie';
$string['nameforlink'] = 'Wat wil jy hierdie skakel noem?';
$string['nameforpage'] = 'Naam';
$string['navigation'] = 'Navigasie';
$string['needed'] = 'Nodig';
$string['networkdropped'] = 'Ons het bepaal dat jou Internet-verbinding onbetroubaar is, of is onderbreek. <br />
Wees asseblief bewus daarvan dat die veranderinge nie behoorlik gestoor kan word totdat jou verbinding verbeter nie.';
$string['never'] = 'Nooit';
$string['neverdeletelogs'] = 'Nooit rekords verwyder';
$string['new'] = 'Nuut';
$string['newaccount'] = 'Nuwe profiel';
$string['newactivityname'] = 'Nuwe naam vir aktiwiteit {$a}';
$string['newcourse'] = 'Nuwe kursus';
$string['newloginnotificationbodyfull'] = '<p>Hi {$a->userfullname},</p>
<p>Jou {$a->sitename} rekening was nou net ingeteken vanaf die onderste toestel</p>
<ul>
<li>jou rekening: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Gereedskap: {$a->logindevice}</li>
<li>IP: {$a->loginip}</li>
</ul>
<p>As dit jy was, staan daar niks te doen nie.</p>
<p>As jy nie jy was nie, <a href="{$a->changepasswordlink}">verander jou wagwoord</a>.</p>';
$string['newloginnotificationbodysmall'] = 'Jou {$a} rekening was ingeteken vanaf `n nuwe toestel';
$string['newloginnotificationtitle'] = 'Nuwe inteken aksie op jou rekening {$a}';
$string['newpassword'] = 'Nuwe wagwoord';
$string['newpassword_help'] = 'Tik \'n nuwe wagwoord in of los skoon om huidige wagwoord te behou.';
$string['newpasswordfromlost'] = '<strong>KENNISGEWING:</strong> Jou <strong>Huidige wagwoord</strong> is na jou gestuur in die <strong>tweede</strong> e-pos as deel van die verlore wagwoord herstel proses. Maak seker dat jy jou nuwe wagwoord ontvang het voordat jy met hierdie skerm voortgaan.';
$string['newpasswordtext'] = 'Hi {$a->firstname},

Jou rekening wagwoord by \'{$a->sitename}\' is herstel en \'n nuwe tydelike wagwoord is aan jou uitgereik.

Jou huidige intekenings besonderhede is as volg:
   Gebruikersnaam: {$a->username}
   Wagwoord: {$a->newpassword}

Gaan na hierdie bladsy om jou wagwoord te verander:
   {$a->link}

In meeste programe sal dit as \'n blou skakel vertoon word waarop jy slegs hoef te klik. As dit nie werk nie, sny en plak dan die adres in die adreslyn bo aan jou webblaaier.

Groete van die \'{$a->sitename}\' administrateur,
{$a->signoff}';
$string['newpicture'] = 'Nuwe prent';
$string['newpicture_help'] = 'Om \'n nuwe prent by te voeg, soek en selekteer die prent (in JPG of PNG formaat) en klik op \'Werk profiel by\'. Die prent sal aangepas word na \'n vierkant en kleiner gemaak word na 100px x 100px.';
$string['newpictureusernotsetup'] = '\'n Profiel prent kan slegs bygevoeg word sodra alle vereiste profiel inligting gestoor is.';
$string['newsectionname'] = 'Nuwe naam vir afdeling {$a}';
$string['newsitem'] = 'nuus item';
$string['newsitems'] = 'aankondigings';
$string['newsitemsnumber'] = 'Aantal aankondigings';
$string['newsitemsnumber_help'] = 'Die aankondigings forum is \'n spesiale forum wat outomaties geskep word in die kursus, het alle gebruikers ingeskryf by verstek en slegs gebruikers met die nodige regte (by verstek onderwysers) kan inskrywings of aankondigings maak.

Hierdie instelling bepaal hoeveel van die onlangse aankondigings vertoon word in die blok vir onlangse aankondigings.

Indien die aankondiging forum nie vereis word nie moet hierdie instelling gestel word na nul.';
$string['newuser'] = 'Nuwe gebruiker';
$string['newusernewpasswordsubj'] = 'Nuwe gebruikers profiel';
$string['newusernewpasswordtext'] = 'Hi {$a->firstname},

\'n Nuwe rekening is geskep by \'{$a->sitename}\' en \'n nuwe tydelike wagwoord is aan jou uitgereik.

Jou huidige intekenings besonderhede is as volg:
  Gebruikersnaam: {$a->username}
  Wagwoord: {$a->newpassword}
(jy sal jou wagwoord moet verander wanneer jy inteken vir die eerste keer)

Om \'{$a->sitename}\' te begin gebruik, teken in by {$a->link}

In die meeste e-pos programme, verskyn hierdie as \'n blou skakel wat jy net hoef te klik. As dit nie werk nie, sny en plak dan die adres in die adres lyn bo aan jou webblaaier venster.

Groete van die \'{$a->sitename}\' administrateur,
{$a->signoff}';
$string['newusers'] = 'Nuwe gebruikers';
$string['newwindow'] = 'Nuwe venster';
$string['next'] = 'Volgende';
$string['nextpage'] = 'Volgende bladsy';
$string['nextsection'] = 'Volgende afdeling';
$string['no'] = 'Nee';
$string['noblockstoaddhere'] = 'Daar is geen blokke wat jy by hierdie bladsy kan byvoeg nie.';
$string['nobody'] = 'Niemand';
$string['nochange'] = 'Geen verandering';
$string['nocomments'] = 'Geen kommentaar';
$string['nocourses'] = 'Geen kursusse';
$string['nocoursesfound'] = 'Geen kursusse was gevind met die woorde \'{$a}\'';
$string['nocoursestarttime'] = 'Die kursus het nie \'n begindatum nie.';
$string['nocoursesyet'] = 'Geen kursusse in hierdie kategorie';
$string['nodstpresets'] = 'Die administrateur het nie Dagligbesparingstyd ondersteuning ontsper nie.';
$string['nofilesselected'] = 'Geen lêers is geselekteer om te herstel nie';
$string['nofilesyet'] = 'Geen lêers is opgelaai vir hierdie kursus nie';
$string['nofiltersapplied'] = 'Geen filters is toegepas nie';
$string['nograde'] = 'Geen punt';
$string['nohelpforactivityorresource'] = 'Daar is tans geen hulp wat geassosieer word met hierdie hulpbron of aktiwiteit nie';
$string['noimagesyet'] = 'Geen beelde is al na jou kursus opgelaai nie';
$string['noitemsfound'] = 'Geen items gevind nie.';
$string['nologsfound'] = 'Geen aantekeninge is gevind nie';
$string['nomatchingusers'] = 'Geen gebruikers stem ooreen met \'{$a}\'';
$string['nomorecourses'] = 'Geen meer ooreenstemmende kursusse kon gevind word nie';
$string['nomoreidnumber'] = '\'n ID-nommer word nie gebruik nie om botsings te voorkom';
$string['none'] = 'Niks';
$string['noneditingteacher'] = 'Nie-wysigende onderwyser';
$string['noneditingteacherdescription'] = 'Nie-wysigende onderwysers kan in kursusse onderrig gee en punte toeken, maar kan nie die aktiwiteite verander nie.';
$string['nonstandard'] = 'Nie-standaard';
$string['nopendingcourses'] = 'Daar is geen kursusse met hangende goedkeuring';
$string['nopotentialadmins'] = 'Geen potensiële administrateurs';
$string['nopotentialcreators'] = 'Geen potensiële kursus skeppers';
$string['nopotentialstudents'] = 'Geen potensiële studente';
$string['nopotentialteachers'] = 'Geen potensiële onderwysers';
$string['norecentactivity'] = 'Geen onlangse aktiwiteit';
$string['noreplybouncemessage'] = 'Jy het geantwoord op \'n onbereikbare (noreply) e-posadres. As jy probeer om te antwoord op \'n forum inskrywing, gebruik liewer hierdie {$a} forums om dit te beantwoord.

Die volgende is die inhoud van jou e-pos:';
$string['noreplybouncesubject'] = '{$a} - gehopte e-pos.';
$string['noreplyname'] = 'Moet nie reageer op hierdie e-pos nie';
$string['noresetrecord'] = 'Daar is geen rekord van die herstel versoek nie. Versoek asseblief \'n nuwe wagwoord.';
$string['noresults'] = 'Geen resultate';
$string['noresultsfor'] = 'Geen resultate vir "{$a}" nie.';
$string['noresultsfor_help'] = 'Gaan jou spelling na of probeer ander woorde.';
$string['normal'] = 'Normaal';
$string['normalfilter'] = 'Normale soek';
$string['nosite'] = 'Kan nie werbwerf vlak kursusse vind nie';
$string['nostudentsfound'] = 'Geen {$a} gevind';
$string['nostudentsingroup'] = 'Daar is nog nie studente in hierdie groep nie';
$string['nostudentsyet'] = 'Daar is nog geen studente in hierdie kursus ingeskryf nie.';
$string['nosuchemail'] = 'Daardie e-posadres bestaan nie';
$string['notavailable'] = 'Nie beskikbaar';
$string['notavailablecourse'] = '{$a} is nie beskikbaar nie';
$string['noteachersyet'] = 'Geen onderwysers is al in hierdie kursus nie';
$string['noteachingupcomingcourses'] = 'Opkomende kursusse het geen onderwysers of studente nie';
$string['notenrolled'] = '{$a} is nie in die kursus ingeskryf nie.';
$string['notenrolledprofile'] = 'Hierdie profiel is nie beskikbaar nie omdat hierdie gebruiker nie in die kursus ingeskryf is nie.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Let wel:</strong> Die vermoë om datums terug te rol tydens die herstel van hierdie rugsteun is versper, omdat jy nie die nodige toestemming het nie.';
$string['noteuserschangednonetocourse'] = '<strong>Let wel:</strong> Kursus gebruikers moet herstel word wanneer gebruikersdata (in aktiwiteite, lêers of boodskappe) herstel word. Hierdie instelling is vir jou verander.';
$string['nothingnew'] = 'Geen nuwe aktiwiteit nie';
$string['nothingtodisplay'] = 'Niks om te vertoon';
$string['notice'] = 'Kennisgewing';
$string['noticenewerbackup'] = 'Hierdie rugsteun lêer is geskep met Moodle {$a->backuprelease} ({$a->backupversion}) en dit is nuwer as jou tans geïnstalleerde Moodle {$a->serverrelease} ({$a->serverversion}). Dit kan \'n paar teenstrydighede veroorsaak omdat versoenbaarheid met ouer rugsteun lêers nie gewaarborg kan word nie.';
$string['notifications'] = 'Kennisgewings';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Gebruiker: {$a->info}, Gebruiker volle name: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Jy kan hierdie aantekeninge besigtig by {$a}';
$string['notifyloginfailuresmessagestart'] = 'Hier is \'n lys van mislukte intekeningpogings by  {$a} sedert jy laas in kennis gestel was.';
$string['notifyloginfailuressubject'] = '{$a} :: mislukte intekening kennisgewing';
$string['notincluded'] = 'Nie ingesluit';
$string['notingroup'] = 'Jammer, maar jy moet deel van \'n groep wees om hierdie blad te kan sien.';
$string['notpublic'] = 'Nie publiek!';
$string['nousersfound'] = 'Geen gebruikers gevind';
$string['nousersmatching'] = 'Geen gebruikers wat ooreenstem met \'{$a}\' is gevind nie';
$string['nousersyet'] = 'Daar is nog nie gebruikers nie';
$string['novalidcourses'] = 'Geen geldige kursusse kan vertoon word nie';
$string['now'] = 'nou';
$string['numattempts'] = '{$a} mislukte intekening poging(s)';
$string['numberofcourses'] = 'Aantal kursusse';
$string['numberweeks'] = 'Aantal afdelings';
$string['numday'] = '{$a} dag';
$string['numdays'] = '{$a} dae';
$string['numhours'] = '{$a} ure';
$string['numletters'] = '{$a} letters';
$string['numminutes'] = '{$a} minute';
$string['nummonth'] = '{$a} maand';
$string['nummonths'] = '{$a} maande';
$string['numseconds'] = '{$a} sekondes';
$string['numviews'] = '{$a} besigtigings';
$string['numweek'] = '{$a} week';
$string['numweeks'] = '{$a} weke';
$string['numwords'] = '{$a} woorde';
$string['numyear'] = '{$a} jaar';
$string['numyears'] = '{$a} jare';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Huidige wagwoord';
$string['olduserdirectory'] = 'Hierdie is die OU gebruikers se lêergids en word nie meer benodig nie. Dit is veilig om dit uit te wis. Die lêers wat dit behou het, is na die NUWE gebruikers se lêergids gekopieer.';
$string['oneitemfound'] = 'Daar is 1 item gevind.';
$string['opendrawerblocks'] = 'Maak blok laai oop';
$string['opendrawerindex'] = 'Maak die kursus indeks oop';
$string['opensinnewwindow'] = 'Maak oop in `n nuwe venster';
$string['operator_and'] = 'en';
$string['operator_andnot'] = 'en';
$string['operator_or'] = 'of';
$string['optional'] = 'opsioneel';
$string['options'] = 'opsies';
$string['order'] = 'Volgorde';
$string['originalpath'] = 'Oorspronklike weg';
$string['orphanedactivitiesinsectionno'] = 'Verlate aktiwiteite (afdeling {$a})';
$string['other'] = 'Ander';
$string['outline'] = 'Uiteensetting';
$string['outlinereport'] = 'Uiteensetting verslag';
$string['page'] = 'Bladsy';
$string['pagea'] = 'Bladsy {$a}';
$string['pagedcontentnavigation'] = 'Paginasie navigasie';
$string['pagedcontentnavigationactiveitem'] = 'Huidige bladsy, bladsy {$a}';
$string['pagedcontentnavigationitem'] = 'Gaan na bladsy {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Vertoon {$a} items per bladsy';
$string['pageheaderconfigablock'] = 'Besig om \'n blok in {$a->fullname} te konfigureer';
$string['pagepath'] = 'Bladsy weg';
$string['pageshouldredirect'] = 'Hierdie bladsy moet outomaties herlei. As niks gebeur nie gebruik asseblief die \'Gaan voort\' skakel hieronder.';
$string['parentcategory'] = 'Ouer kategorie';
$string['parentcoursenotfound'] = 'Ouer kursus nie gevind!';
$string['parentfolder'] = 'Ouer lêer';
$string['participants'] = 'Deelnemers';
$string['participantslist'] = 'Deelnemers lys';
$string['participationratio'] = 'Deelname verhouding';
$string['participationreport'] = 'Deelname verslag';
$string['password'] = 'Wagwoord';
$string['passwordchanged'] = 'Wagwoord is verander';
$string['passwordextlink'] = 'Die volgende skakel word voorsien om jou verlore wagwoord terug te kry. Hierdie sal jou uit Moodle uit neem.';
$string['passwordforgotten'] = 'Vergete wagwoord';
$string['passwordforgotteninstructions'] = 'Jou besonderhede moet eers indie gebruikerdatabasis gevind word. Voer asseblief jou gebruikersnaam <strong>of</strong> jou geregisteerde e-posadres in die toepaslike boksie in. Jy hoef nie beide in te vul nie.';
$string['passwordforgotteninstructions2'] = 'Jou wagwoord te herstel, tik jou gebruikersnaam of jou e-posadres hieronder in. As ons jou kan vind in die databasis, sal \'n e-pos aan jou gestuur word met instruksies hoe om weer toegang te kry.';
$string['passwordpolicynomatch'] = 'Jou huidige wagwoord stem nie meer ooreen met die ingestelde wagwoord beleid nie.
{$a}';
$string['passwordsdiffer'] = 'Hierdie wagwoorde stem nie ooreen nie';
$string['passwordset'] = 'U wagwoord is herstel.';
$string['path'] = 'Weg';
$string['pathnotexists'] = 'Baan bestaan nie in jou bediener nie!';
$string['pathslasherror'] = 'Baan kan nie met \'n skuinsstreep eindig nie!';
$string['paymentinstant'] = 'Gebruik die knoppie hieronder om te betaal en binne minute ingeskryf te word!';
$string['paymentpending'] = '(<small><u><b>{$a}</b></u> hangend</small>)';
$string['paymentrequired'] = 'Die kursus benodig \'n betaling vir toegang.';
$string['payments'] = 'Betalings';
$string['paymentsorry'] = 'Dankie vir jou betaling! Ongelukkig is jou betaling nog nie ten volle verwerk nie en jy is nog nie geregistreer om die kursus \'{$a->fullname}\' te betree nie. Probeer asseblief in \'n paar sekondes weer om die in die kursus te gaan en as jy nog steeds probleme het na dit, kontak asseblief die {$a->teacher} of die blad administrateur hieroor';
$string['paymentthanks'] = 'Dankie vir jou betaling! Jy is nou ingeskryf in die kursus :<br />"{$a}"';
$string['pendingrequests'] = 'Hangende versoeke';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Tydperk eindig ({$a})';
$string['perpage'] = 'Per bladsy';
$string['perpagea'] = 'Per bladsy: {$a}';
$string['personal'] = 'Persoonlike';
$string['personalprofile'] = 'Persoonlike profiel';
$string['phone'] = 'Telefoon';
$string['phone1'] = 'Foon';
$string['phone2'] = 'Selfoon';
$string['phpinfo'] = 'PHP Info';
$string['pictureof'] = 'Prentjie van {$a}';
$string['pictureofuser'] = 'Gebruiker prentjie';
$string['placeholdertypeorselect'] = 'Tik of kies ...';
$string['pleaseclose'] = 'Maak asseblief nou die venster toe.';
$string['pleasesearchmore'] = 'Soek asseblief meer';
$string['pleaseusesearch'] = 'Gebruik asseblief die soektog';
$string['plugin'] = 'Aanvullende toepassing';
$string['plugincheck'] = 'Kontroleer aanvullende toepassing';
$string['plugindeletefiles'] = 'Alle data wat verband hou met die aanvullende toepassing \'{$a->name}\' is uit die databasis verwyder. Om te voorkom dat die aanvullende toepassing homself herinstalleer, moet jy hierdie gids van jou bediener verwyder: {$a->directory}';
$string['pluginsetup'] = 'Besig om inprop tabelle op te stel';
$string['policyaccept'] = 'Ek verstaan en stem saam';
$string['policyagree'] = 'Jy moet met hierdie beleid saamstem om voort te gaanom die blad te gebruik. Stem jy saam?';
$string['policyagreement'] = 'Blad beleid ooreenkoms';
$string['policyagreementclick'] = 'Skakel na blad beleid ooreenkoms';
$string['popup'] = '\'popup\'';
$string['popupwindow'] = 'Maak lêer in nuwe venster oop';
$string['popupwindowname'] = 'Afhaal venster';
$string['post'] = 'Inskrywing';
$string['posts'] = 'Inskrywings';
$string['potentialadmins'] = 'Potensiële administrateurs';
$string['potentialcreators'] = 'Potensiële kursus skeppers';
$string['potentialstudents'] = 'Potensiële studente';
$string['potentialteachers'] = 'Potensiële onderwysers';
$string['poweredbymoodle'] = 'Word gedryf deur <a href="https://moodle.com">Moodle</a>';
$string['preferences'] = 'Voorkeure';
$string['preferredlanguage'] = 'Voorkeur taal';
$string['preferredtheme'] = 'Gewenste tema';
$string['preprocessingbackupfile'] = 'Besig om rugsteun lêer vooraf te verwerk';
$string['prev'] = 'Terug';
$string['preview'] = 'Voorskou';
$string['previeworchoose'] = 'Voorskou of kies \'n tema';
$string['previous'] = 'Vorige';
$string['previouslyselectedusers'] = 'Voorheen geselekteerde gebruikers stem nie ooreen met \'{$a}\'';
$string['previouspage'] = 'Vorige bladsy';
$string['previoussection'] = 'Vorige afdeling';
$string['primaryadminsetup'] = 'Opstelling van administrateur rekening';
$string['privacy:metadata:config_log'] = 'Die aantekeninge van opstelling veranderinge.';
$string['privacy:metadata:config_log:name'] = 'Die naam van die instelling wat verander is.';
$string['privacy:metadata:config_log:oldvalue'] = 'Die vorige waarde van die instelling.';
$string['privacy:metadata:config_log:plugin'] = 'Die aanvullende toepassing is verander.';
$string['privacy:metadata:config_log:timemodified'] = 'Die tyd waarop die verandering plaasgevind het.';
$string['privacy:metadata:config_log:userid'] = 'Die gebruiker wat die verandering gemaak het.';
$string['privacy:metadata:config_log:value'] = 'Siw nuwe waarde vir die instelling.';
$string['privacy:metadata:events_queue'] = 'Die ry van gebruiker geneure wat wag om verwerk te word.';
$string['privacy:metadata:events_queue:eventdata'] = 'Die data gestoor in die gebeurtenis.';
$string['privacy:metadata:events_queue:stackdump'] = 'Enige \'stacktrace\' wat met die gebeure geassosieer word.';
$string['privacy:metadata:events_queue:timecreated'] = 'Die tyd wat die gebeurtenis geskep was.';
$string['privacy:metadata:events_queue:userid'] = 'Die gebruiker ID wat met die gebeurtenis geassosieer is';
$string['privacy:metadata:log'] = '\'n Versameling van gebeure in die verlede';
$string['privacy:metadata:log:action'] = '\'n Beskrywing van die aksie';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'kursus';
$string['privacy:metadata:log:info'] = 'Addisionele inligting';
$string['privacy:metadata:log:ip'] = 'Die IP adresse wat gebruik was ten tye van die gebeurtenis';
$string['privacy:metadata:log:module'] = 'module';
$string['privacy:metadata:log:time'] = 'Die tyd wat die aksie plaasgevind het';
$string['privacy:metadata:log:url'] = 'Die URL wat gekoppel is aan die gebeurtenis';
$string['privacy:metadata:log:userid'] = 'Die ID van die gebruiker wat die aksie uitgevoer het';
$string['privacy:metadata:oauth2_refresh_token'] = 'Verfis teken wat in OAuth 2.0 kommunikasie gebruik is';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'Die ID van die uitreiker met wie die teken ooreenkom';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'Die ID van die gebruiker met wie die teken ooreenkom';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Die tyd wanneer die teken geskep is';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'Die tyd wanneer die teken laas opgedateer is';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Die verfris teken vir die onderskeie omvangs en gebruiker';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'Die ID van die gebruiker met wie die teken ooreenkom';
$string['privacy:metadata:task_adhoc'] = 'Die status van ad hoc take.';
$string['privacy:metadata:task_adhoc:component'] = 'Die komponent wat die taak besit.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Die vroegste tyd wat die taak uitgevoer kan word.';
$string['privacy:metadata:task_adhoc:userid'] = 'Die gebruiker wat die taak moet uitvoer.';
$string['privacy:metadata:task_log'] = 'Log uitset vir \'n log';
$string['privacy:metadata:task_log:component'] = 'Die komponent wat die taak besit.';
$string['privacy:metadata:task_log:userid'] = 'Die gebruiker aan wie die taak behoort.';
$string['privacy:metadata:upgrade_log'] = 'Die opgradering aantekeninge.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Enige terugstappe wat geassosieer is met hierdie stap van die opgradering.';
$string['privacy:metadata:upgrade_log:details'] = 'Ekstra inligting wat verwant is aan die opgradering.';
$string['privacy:metadata:upgrade_log:info'] = 'Die hoofinligting vir hierdie stap van opgradering.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Die ingevoegde toepassing wat opgegradeer is.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Die nuwe weergawe waarheen opgegradeer word.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Die tyd wat die opgradering plaasgevind het.';
$string['privacy:metadata:upgrade_log:type'] = 'Die tipe aantekening inskrywing.';
$string['privacy:metadata:upgrade_log:userid'] = 'Die gebruiker wat die opgradering uitgewerk het.';
$string['privacy:metadata:upgrade_log:version'] = 'Die vorige weergawe van die ingevoegde toepassing.';
$string['private_files_handler'] = 'Stoor aanhegsels aan \'n e-pos in die gebruiker se privaat lêer spasie.';
$string['private_files_handler_name'] = 'E-pos na private lêers';
$string['privatefiles'] = 'Privaat lêers';
$string['privatefilesmanage'] = 'Bestuur privaat lêers';
$string['proceed'] = 'Gaan voort';
$string['profile'] = 'Profiel';
$string['profilenotshown'] = 'Hierdie profiel beskrywing sal nie gewys word totdat die persoon minstens een kursus ingeskryf is.';
$string['publicprofile'] = 'Openbare profiel';
$string['publicsitefileswarning'] = 'Let wel: enigiemand kan toegang verkry tot lêers wat hier geplaas word';
$string['publicsitefileswarning2'] = 'Let wel: Enigiemand wat die URL ken (of kan raai) kan toegang verkry tot lêers wat hier geplaas word. Vir sekuriteitsdoeleindes word dit voorgestel dat enige rugsteun lêers dadelik na herstel uitgewis word.';
$string['publicsitefileswarning3'] = 'Let wel: Enigiemand wat die URL ken (of kan raai) kan toegang verkry tot lêers wat hier geplaas word. <br />Vir sekuriteitsdoeleindes moet rugsteun lêers slegs in die veilige backupdata lêer gestoor word.';
$string['question'] = 'Vraag';
$string['questionsinthequestionbank'] = 'Vrae in die vraag bank';
$string['queued'] = 'In die ry geplaas';
$string['quotausage'] = 'Jy het tans {$a->used} van {$a->total} spasie limiet gebruik.';
$string['readinginfofrombackup'] = 'Besig om inligting vanaf rugsteun te lees';
$string['readme'] = 'Lees my';
$string['recentactivity'] = 'Onlangse aktiwiteit';
$string['recentactivityreport'] = 'Volledige verslag van onlangse aktiwiteite...';
$string['recipientslist'] = 'Ontvangers lys';
$string['recommended'] = 'Voorgestel';
$string['recreatedcategory'] = 'Kategorie is weer geskep {$a}';
$string['redirect'] = 'Herlei';
$string['reducesections'] = 'Verminder die aantal afdelings';
$string['refresh'] = 'Verfris';
$string['refreshingevents'] = 'Herlaai gebeure';
$string['registration'] = 'Moodle registrasie';
$string['registrationcontact'] = 'Kontak vanaf die publiek';
$string['registrationcontactno'] = 'Nee, ek wil nie deur ander mense gekontak word nie';
$string['registrationcontactyes'] = 'Ja, verskaf \'n vorm vir ander Moodlers om my te kontak';
$string['registrationemail'] = 'E-pos kennisgewings';
$string['registrationinfo'] = '<p> Hierdie bladsy laat jou toe om jou Moodle webwerf by moodle.org te registreer. Registrasie is gratis.
Die grootste voordeel van registrasie is dat jy op \'n lae-volume poslys vir belangrike kennisgewings sal bygevoeg word soos sekuriteit waarskuwings en nuwe weergawes van Moodle. </p>
<p> As standaard, sal jou inligting privaat gehou word, en sal nooit verkoop of oorgedra word aan enige iemand anders. Die enigste rede vir die versameling van hierdie inligting is vir ondersteunings doeleindes, en om te help bou aan \'n statistiese beeld van die Moodle gemeenskap as \'n geheel. </p>
<p> As jy sou kies, kan jy toelaat dat jou blad naam, land en URL bygevoeg word by die publiek lys van Moodle bladsye. </p>
<p> Alle nuwe registrasies word handgewys gekontroleer voordat dit by die lys gevoeg word, maar sodra jy bygevoeg is kan jy jou registrasie (en inskrywing op die publieke lys) enige tyd verander deur die vorm weer in te dien. </p>';
$string['registrationinfotitle'] = 'Registrasie inligting';
$string['registrationsend'] = 'Stuur registrasie inligting na moodle.org';
$string['registrationyes'] = 'Ja, stel my in kennis van nuwe Moodle vrystellings, sekuriteitswaarskuwings en ander belangrike nuus';
$string['reject'] = 'Verwerp';
$string['rejectdots'] = 'Verwerp...';
$string['relativedatesmode'] = 'Datums in verhouding modus';
$string['relativedatesmode_help'] = 'Vertoon kursus- of aktiwiteitdatums in verhouding met die gebruiker se begindatum in die kursus.

Die gebruiker se kursus begindatum sal die begindatum van hul inskrywing wees, tensy hulle voor die kursus begin ingeskryf het. In daardie geval sal hul begindatum die begindatum van die kursus wees.

WAARSKUWING: Hierdie is \'n eksperimentele eienskap en dit is moontlik dat alle aktiwiteite dit nie ondersteun nie. As die kursus eers geskep is, kan hierdie kursus instelling nie meer verander word nie.';
$string['relativedatesmode_warning'] = '<strong>Waarskuwing:</strong> Datums in verhouding modus kan nie verander word na die kursus geskep is nie.';
$string['reload'] = 'Herlaai';
$string['remoteappuser'] = 'Afstand {$a} Gebruiker';
$string['remove'] = 'Verwyder';
$string['removeadmin'] = 'Verwyder administrateur';
$string['removecreator'] = 'Verwyder kursus skepper';
$string['removestudent'] = 'Verwyder student';
$string['removeteacher'] = 'Verwyder onderwyser';
$string['rename'] = 'Hernoem';
$string['renamefileto'] = 'Herbenoem <b>{$a}</b> na';
$string['report'] = 'Verslag';
$string['reports'] = 'Verslae';
$string['reporttype'] = 'Verslagtipe';
$string['repositories'] = 'Bronne';
$string['requestcourse'] = 'Versoek \'n kursus';
$string['requestedby'] = 'Versoek deur';
$string['requestedcourses'] = 'Versoek kursusse';
$string['requestreason'] = 'Rede vir die kursus versoek';
$string['requests'] = 'Navrae';
$string['required'] = 'Vereis';
$string['requirespayment'] = 'Hierdie kursus vereis betaling vir toegang';
$string['resendemail'] = 'Stuur e-pos weer';
$string['reset'] = 'Herstel';
$string['resetcomponent'] = 'Komponent';
$string['resetcourse'] = 'Herstel kursus';
$string['resetinfo'] = 'Hierdie bladsy laat jou toe om \'n kursus van die gebruiker data skoon te maak terwyl die aktiwiteite en ander instellings behou word. Wees asseblief gewaarsku dat deur die keuse van items hieronder en stuur van hierdie bladsy sal die gebruiker data van hierdie kursus vir altyd te verwyder wees!';
$string['resetnotimplemented'] = 'Herstel nie geïmplementeer nie';
$string['resetrecordexpired'] = 'Die wagwoord herstel skakel wat jy gebruik is meer as {$a} minute oud en het verval. Stel asseblief \'n nuwe versoek vir \'n wagwoord herstelling.';
$string['resetstartdate'] = 'Stel begindatum terug';
$string['resetstatus'] = 'Status';
$string['resettable'] = 'Herstel tabelvoorkeure';
$string['resettask'] = 'Taak';
$string['resettodefaults'] = 'Stel terug na verstek';
$string['resortcourses'] = 'Sorteer kursusse';
$string['resortsubcategoriesby'] = 'Sorteer subkategorieë by {$a} opgaande';
$string['resortsubcategoriesbyreverse'] = 'Sorteer subkategorieë by {$a} afgaande';
$string['resource'] = 'Hulpbronne';
$string['resourcedisplayauto'] = 'Outomaties';
$string['resourcedisplaydownload'] = 'Forseer aflaai';
$string['resourcedisplayembed'] = 'Ingebed';
$string['resourcedisplayframe'] = 'In raam';
$string['resourcedisplaynew'] = 'Nuwe venster';
$string['resourcedisplayopen'] = 'Oop';
$string['resourcedisplaypopup'] = 'In \'n \'pop up\'';
$string['resources'] = 'Hulpbronne';
$string['resources_help'] = 'Hulpbron tipes stel jou in staat om bykans enige soort web-inhoud in die kursus te plaas.';
$string['restore'] = 'Herstel';
$string['restorecancelled'] = 'Herstel gekanselleer';
$string['restorecannotassignroles'] = 'Herstel moet rolle kan aanwys en jy het nie die nodige toestemming om dit te doen nie';
$string['restorecannotcreateorassignroles'] = 'Herstel moet rolle kan skep of aanwys en jy het nie die nodige toestemming om dit te doen nie';
$string['restorecannotcreateuser'] = 'Herstelling benodig om die gebruiker \'{$a}\' te skep van \'n rugsteun af en jy het nie die regte om dit te doen nie';
$string['restorecannotoverrideperms'] = 'Herstel moet toestemming kan oorheers en jy het nie die nodige toestemming om dit te doen nie';
$string['restorecoursenow'] = 'Herstel hierdie kursus nou!';
$string['restoredaccount'] = 'Herstelde rekening';
$string['restoredaccountinfo'] = 'Hierdie rekening is ingevoer uit \'n ander bediener en die wagwoord is verlore. Om \'n nuwe wagwoord per e-pos in te stel, kliek op \'Gaan voort\'';
$string['restorefinished'] = 'Herstel is suksesvol voltooi';
$string['restoremnethostidmismatch'] = 'MNet ID van gebruiker \'{$a}\' stem nie ooreen met die plaaslike MNet ID.';
$string['restoreto'] = 'Herstel na';
$string['restoretositeadding'] = 'Waarskuwing: Jy is op die punt om die webwerf voorblad te herstel en data daarby te voeg!';
$string['restoretositedeleting'] = 'Waarskuwing: Jy is op die punt om die webwerf voorblad te herstel en data daarvan uit te wis!';
$string['restoreuserconflict'] = 'Probeer om gebruiker \'{$a}\' te herstel vanaf rugsteun lêer sal konflik veroorsaak';
$string['restoreuserinfofailed'] = 'Die herstel proses het gestop omdat jy nie toestemming het om gebruikerdata te herstel nie.';
$string['restoreusersprecheck'] = 'Besig om gebruikerdata na te gaan';
$string['restoreusersprecheckerror'] = 'Sommige probleme is opgemerk tydens die nagaan van gebruikerdata';
$string['restricted'] = 'Beperk';
$string['resultsfound'] = '{$a} resultate gevind';
$string['retry'] = 'Probeer weer';
$string['returningtosite'] = 'Keer jy terug na hierdie webblad?';
$string['returntooriginaluser'] = 'Keer terug na {$a}';
$string['revert'] = 'Keer terug na';
$string['role'] = 'Rol';
$string['roleassignments'] = 'Rol toekennings';
$string['rolemappings'] = 'Rol afbeeldings';
$string['rolerenaming'] = 'Rol naamsverandering';
$string['rolerenaming_help'] = 'Hierdie instelling maak dit moontlik om die vertoon name vir rolle wat in die kursus gebruik word te verander. Slegs die vertoon naam verander - rol regte word nie geraak nie. Nuwe rol name sal verskyn op die kursus deelnemers bladsy en elders in die kursus. As die hernoemde rol een is wat die administrateur gekies het as \'n kursus bestuurder rol, sal die nuwe rol naam ook verskyn as deel van die volledige kursus lys.';
$string['roles'] = 'Rolle';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Aantal onlangse RSS artikels';
$string['rsserror'] = 'Daar is fout met die lees van RSS data';
$string['rsserrorauth'] = 'Jou RSS skakel bevat nie \'n geldige verifiëring sleutel nie.';
$string['rsserrorguest'] = 'Hierdie \'feed\' gebruik gaste togeang om die data te verkry, maar gaste het nie regte om die data te lees nie. Besoek die oorspronklike plek waar die \'feed\' vanaf kom (URL) as \'n geldige gebruiker en kry \'n nuwe RSS skakel van daar af.';
$string['rsskeyshelp'] = '<p>Om sekuriteit en privaatheid te verseker, bevat RSS-feed-URL\'s \'n spesiale koepon waarmee die gebruiker geïdentifiseer word. Dit voorkom dat ander gebruikers toegang verkry tot areas van die webwerf waar hulle nie toegelaat word nie.</p><p>Die koepon word outomaties die eerste keer geskep as jy toegang verkry tot \'n area wat \'n RSS-voer produseer. As u dink dat u RSS-koepon gekompromitteer is, kan u \'n nuwe een aanvra deur op die herstel skakel te klik. Let asseblief daarop dat u huidige RSS-voedings-URL\'s dan ongeldig word.</p>';
$string['rsstype'] = 'RSS \'feed\' vir hierdie aktiwiteit';
$string['save'] = 'Stoor';
$string['saveandnext'] = 'Stoor en wys volgende';
$string['savechanges'] = 'Stoor veranderinge';
$string['savechangesanddisplay'] = 'Stoor en vertoon';
$string['savechangesandreturn'] = 'Stoor en keur terug';
$string['savechangesandreturntocourse'] = 'Stoor en keer terug na kursus';
$string['savecomment'] = 'Stoor kommentaar';
$string['savedat'] = 'Gestoor op:';
$string['savepreferences'] = 'Stoor voorkeure';
$string['saveto'] = 'Stoor na';
$string['scale'] = 'Skaal';
$string['scale_help'] = '\'n Skaal bied \'n manier aan om \'n aktiwiteit te evalueer of prestasie te gradeer. Dit word gedefinieer deur \'n geordende lys van waardes, wat wissel van negatief na positief, geskei deur kommas, byvoorbeeld "Teleurstellend, Nie goed genoeg nie, Gemiddeld, Goed, Baie goed, Uitstekend!"';
$string['scale_link'] = 'punt/skaal';
$string['scales'] = 'Skale';
$string['scalescustom'] = 'Pasgemaakte skale';
$string['scalescustomcreate'] = 'Voeg \'n nuwe skaal by';
$string['scalescustomno'] = 'Geen doelgemaakte skale is al geskep nie';
$string['scalesstandard'] = 'Standaard skale';
$string['scalestandard'] = 'Standaard skaal';
$string['scalestandard_help'] = '\'n Standaard skaal is beskikbaar vir alle kursusse.';
$string['scalestandard_link'] = 'punt/skaal';
$string['scalestip'] = 'Om doelgemaakte skale te skep, gebruik die \'Skale...\' skakel in jou kursus administrasie kieslys.';
$string['scalestip2'] = 'Om pasgemaakte skale te skep, klik op die Punte-skakel in die kursus administrasie kieslys, kies dan Wysig, dan Skale.';
$string['schedule'] = 'Skedule';
$string['screenshot'] = 'Skermskoot';
$string['search'] = 'Soek';
$string['search_help'] = 'Vir basiese soek van een of meer woorde op enige plek in die teks, tik die woorde in, geskei deur spasies. Alle woorde langer as twee karakters word gebruik.

Vir gevorderde soek, druk op die soek knoppie sonder om iets in die soektog te tik om toegang tot die gevorderde soek vorm te kry.';
$string['searchactivities'] = 'Soek na aktiwiteite per naam of beskrywing';
$string['searchagain'] = 'Soek weer';
$string['searchbyemail'] = 'Soek volgens e-posadres';
$string['searchbyusername'] = 'Soek volgens gebruikersnaam';
$string['searchcoursecategories'] = 'Soek kategoriee';
$string['searchcourses'] = 'Soek deur kursusse';
$string['searchoptions'] = 'Soek opsies';
$string['searchresults'] = 'Soek resultate';
$string['sec'] = 'sek';
$string['seconds'] = 'sekondes';
$string['secondsleft'] = '{$a} sek';
$string['secondstotime172800'] = '2 dae';
$string['secondstotime259200'] = '3 dae';
$string['secondstotime345600'] = '4 dae';
$string['secondstotime432000'] = '5 dae';
$string['secondstotime518400'] = '6 dae';
$string['secondstotime604800'] = '1 week';
$string['secondstotime86400'] = '1 dag';
$string['secretalreadyused'] = 'Die verander wagwoord bevestigings skakel is reeds gebruik, wagwoord is nie verander nie.';
$string['secs'] = 'sekondes';
$string['section'] = 'Afdeling';
$string['sectionactionnotsupported'] = '"{$a}" aksie vir die afdeling word nie hier ondersteun nie';
$string['sectionname'] = 'Afdeling naam';
$string['sections'] = 'Afdeling';
$string['seealsostats'] = 'Sien ook: statistieke';
$string['selctauser'] = 'Kies \'n gebruiker';
$string['select'] = 'Kies';
$string['selectacategory'] = 'Kies \'n kategorie';
$string['selectacountry'] = 'Kies \'n land';
$string['selectacourse'] = 'Kies \'n kursus';
$string['selectacoursesite'] = 'Kies \'n kursus of webwerf';
$string['selectagroup'] = 'Kies \'n groep';
$string['selectall'] = 'Kies almal';
$string['selectallusersonpage'] = 'Kies alle gebruikers op die bladsy';
$string['selectalluserswithcount'] = 'Kies al {$a} gebruikers';
$string['selectamodule'] = 'Selekteer asseblief \'n aktiwiteitsmodule';
$string['selectanaction'] = 'Kies \'n aksie';
$string['selectanoptions'] = 'Kies \'n opsie';
$string['selectaregion'] = 'Kies \'n streek';
$string['selectcategorysort'] = 'Watter kategorieë sou jy graag wou sorteer?';
$string['selectcategorysortby'] = 'Kies hoe jy kategorieë wil sorteer';
$string['selectcoursesortby'] = 'Kies hoe jy kursusse wil sorteer';
$string['selectdefault'] = 'Kies die standaard';
$string['selectedcategories'] = 'Geselekteerde kategorieë';
$string['selectedfile'] = 'Geselekteerde lêer';
$string['selectednowmove'] = '{$a} lêers is geselekteer om te skuif. Gaan nou na die lêer waarheen hulle geskuif moet word en druk \'Skuif lêers hierheen\'';
$string['selectfiles'] = 'Kies lêers';
$string['selectfiltertype'] = 'Kies';
$string['selectitem'] = 'Selekteer \'{$a}\'';
$string['selectmoduletoviewhelp'] = 'Kies \'n aktiwiteit of hulpbron om sy hulp te sien.

Dubbel-klik op \'n aktiwiteit of hulpbron se naam om dit vinnig by te voeg.';
$string['selectnos'] = 'Kies alle \'Nee\'';
$string['selectperiod'] = 'Kies tydperk';
$string['senddetails'] = 'Stuur my besonderhede via e-pos';
$string['separate'] = 'Afsonderlike';
$string['separateandconnected'] = 'Afsonderlike en Verbonde kennis';
$string['separateandconnected1'] = 'Meestal eiesoortige kennis';
$string['separateandconnected2'] = 'Eiesoortig en verbonde';
$string['separateandconnected3'] = 'Meestal verbonde kennis';
$string['separateandconnectedinfo'] = 'Die skaal gebaseer op die teorie van afsonderlike en verbonde kennis. Hierdie teorie beskryf twee verskillende maniere waarop ons kan evalueer en leer oor die dinge wat ons sien en hoor. <ul><li><strong>Afsonderlike kenners</strong> bly so objektief as moontlik sonder om gevoelens en emosies in te sluit. In \'n gesprek met ander mense sal hulle hul eie idees verdedig, met behulp van logika  en deur gate in die opponent se idees te vind.</li><li><strong>Verbonde keners</strong> is meer sensitief vir ander mense. Hulle is vaardig met empatie en is geneig om te luister en vrae te vra totdat hul voel hul maak \'n konneksie en "verstaan dinge vanuit hul oogpunt". Hulle leer deur te probeer deel in die ervarings van ander wat dan lei tot die kennis wat hulle in ander mense vind.</li></ul>';
$string['servererror'] = '\'n Fout het voorgekom terwyl kommunikasie met die bediener onderhewe was';
$string['serverlocaltime'] = 'Bediener se lokale tyd';
$string['sessionforceclean'] = 'As \'n sekuriteitsvoorsorgmaatreël, word skriptekste wat deur gebruikers gegenereer is, in hierdie sessie versper.';
$string['sessiontimeoutsoon'] = 'Jou sessie is op die punt om die tydafsnyding te bereik. Wil jy jou huidige sessie verleng?';
$string['setcategorytheme'] = 'Stel kategorie tema in';
$string['setmode'] = 'gevestigde wyse';
$string['setpassword'] = 'Stel wagwoord';
$string['setpasswordinstructions'] = 'Vul asseblief jou wagwoord hieronder in en stoor die veranderinge.';
$string['settings'] = 'Instellings';
$string['shortname'] = 'Kort naam';
$string['shortnamecollisionwarning'] = '[*] = Hierdie kort naam is reeds gebruik deur \'n ander kursus en sal verander moet word na goedkeuring';
$string['shortnamecourse'] = 'Kursus kort naam';
$string['shortnamecourse_help'] = 'Die kort naam van die kursus word vertoon in die navigasie en word ook gebruik in die onderwerplyn van e-posboodskappe wat vanuit die kursus gestuur word.';
$string['shortnametaken'] = 'Kort naam word reeds gebruik vir \'n ander kursus ({$a})';
$string['shortnameuser'] = 'Gebruiker kort naam';
$string['shortsitename'] = 'Kort naam vir die webblad (bv. een woord)';
$string['show'] = 'Vertoon';
$string['showactions'] = 'Vertoon aksies';
$string['showactivitydates'] = 'Vertoon aktiwiteit datums';
$string['showactivitydates_help'] = 'Die aktiwiteit datums word altyd op die aktiwiteitsbladsy vertoon. Heirdie instelling bepaal of aktiwiteit datums ook onder elke aktiwiteit op die kursusbladsy vertoon word.';
$string['showadvancededitor'] = 'Gevorderde';
$string['showadvancedsettings'] = 'Vertoon gevorderde instellings';
$string['showall'] = 'Vertoon al {$a}';
$string['showallcourses'] = 'Vertoon alle kursusse';
$string['showblockcourse'] = 'Vertoon lys van kursusse wat die blok bevat';
$string['showcategory'] = 'Vertoon {$a}';
$string['showchartdata'] = 'Vertoon grafiek data';
$string['showcomments'] = 'Vertoon/Verberg kommentaar';
$string['showcommentsnonjs'] = 'Vertoon kommentaar';
$string['showdescription'] = 'Vertoon beskrywing op kursus blad';
$string['showdescription_help'] = 'Indien geaktiveer, sal die beskrywing hierbo vertoon word op die kursus bladsy net onder die skakel na die aktiwiteit of hulpbron.';
$string['showgrades'] = 'Vertoon punteboek aan studente';
$string['showgrades_help'] = 'Baie aktiwiteite in die kursus laat toe dat punte ingestel word. Hierdie instelling bepaal of \'n student \'n lys van al hul punte vir die kursus kan sien via \'n punte-skakel in die navigasie laai of blok.';
$string['showingacourses'] = 'Vertoning al {$a} kursusse';
$string['showingxofycourses'] = 'Vertoning kursusse {$a->start} tot {$a->end} van {$a->total} kursusse';
$string['showlistofcourses'] = 'Vertoon lys van kursusse';
$string['showmodulecourse'] = 'Vertoon \'n lys van kursusse wat die aktiwiteit bevat';
$string['showoncoursepage'] = 'Vertoon op kursus bladsy';
$string['showonly'] = 'Vertoon net';
$string['showperpage'] = 'Vertoon {$a} per blad';
$string['showpopoverwindow'] = 'Vertoon \'n \'popover\' venster';
$string['showrecent'] = 'Vertoon onlangse aktiwiteit';
$string['showreports'] = 'Vertoon aktiwiteite verslae';
$string['showreports_help'] = 'Aktiwiteit verslae is beskikbaar vir elke deelnemer wat hul aktiwiteit in die kursus wys. \'n Volledige lys van hul bydraes sal ook vertoon word, soos forum inskrywings of werkstuk inhandigings, asook toegang aantekeninge. Hierdie instelling bepaal of \'n student hul eie aktiwiteite verslae kan sien deur middel van hul profiel bladsy.';
$string['showsettings'] = 'Vertoon instellings';
$string['showtheselogs'] = 'Vertoon hierdie logs';
$string['showthishelpinlanguage'] = 'Vertoon hierdie hulp in taal: {$a}';
$string['sidepanel'] = 'Glypaneel';
$string['signoutofotherservices'] = 'Teken oral uit';
$string['signoutofotherservices_help'] = 'Indien gekies gaan die profiel uitgeteken word op alle toestelle en stelsels wat die webdienste gebruik, soos bv. die App.';
$string['since'] = 'Sedert';
$string['sincelast'] = 'sedert laaste intekening';
$string['site'] = 'Webwerf';
$string['sitedefault'] = 'Webwerf verstek';
$string['sitedefaultspecified'] = 'Webwerf verstek ({$a})';
$string['siteerrors'] = 'Webwerf foute';
$string['sitefiles'] = 'Webwerf lêers';
$string['sitefilesused'] = 'Webwerf lêers wat in hierdie kursus gebruik word';
$string['sitehome'] = 'Tuisblad';
$string['sitelegacyfiles'] = 'Verouderde webwerf lêers';
$string['sitelogs'] = 'Webwerf logs';
$string['sitenews'] = 'Webwerf aankondigings';
$string['sitepages'] = 'Webwerf bladsye';
$string['sitepartlist'] = 'Jy het nie die nodige toestemming om die deelnemerlys te besigtig nie';
$string['sitepartlist0'] = 'Jy moet \'n webwerf onderwyser wees om toestemming te kry om die webwerf deelmerlys te besigitig';
$string['sitepartlist1'] = 'Jy moet \'n onderwyser wees om toestemming te kry om die webwerf deelmerlys te besigitig';
$string['sites'] = 'Webwerwe';
$string['sitesection'] = 'Sluit \'n onderwerp afdeling in';
$string['sitesettings'] = 'Webwerf instellings';
$string['siteteachers'] = 'Webwerf onderwysers';
$string['size'] = 'Grootte';
$string['sizeb'] = 'grepe';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Oorgeslaan';
$string['skiptocategorylisting'] = 'Slaan oor na die kategorie lys';
$string['skiptocoursedetails'] = 'Slaan oor na die gedetaileerder kursus inligting';
$string['skiptocourselisting'] = 'Slaan oor na die kursus lys';
$string['someallowguest'] = 'Party kursusse laat besoekers toe';
$string['someerrorswerefound'] = 'Sommige inligting is vermis of inkorrek. Sien onder vir besonderhede.';
$string['sort'] = 'Sorteer';
$string['sortby'] = 'Sorteer volgens';
$string['sortbyx'] = 'Sorteer stygende volgens {$a}';
$string['sortbyxreverse'] = 'Sorteer dalende volgens {$a}';
$string['sorting'] = 'Sortering';
$string['sourcerole'] = 'Bron rol';
$string['specifyname'] = 'Jy moet \'n naam spesifiseer.';
$string['standard'] = 'Standaard';
$string['starpending'] = '([*] = Kursus goedkeuring nog hangende)';
$string['startdate'] = 'Kursus begin datum';
$string['startdate_help'] = 'Hierdie instelling bepaal die begin van die eerste week van \'n kursus wat in week-formaat gestel is. Dit bepaal ook die vroegste datum waarop aantekeninge vir aktiwiteite beskikbaar is. Indien die kursus herstel is en die begin datum word verander, gaan alle datums in die kursus aangepas word volgens die nuwe begin datum.';
$string['startingfrom'] = 'Begin vanaf';
$string['startsignup'] = 'Skep \'n nuwe profiel';
$string['state'] = 'Staat/Provinsie';
$string['statistics'] = 'Statistieke';
$string['statisticsgraph'] = 'Statistiek grafiek';
$string['stats'] = 'Statistieke';
$string['statslogins'] = 'Intekeninge';
$string['statsmodedetailed'] = 'Gedetailleerde (gebruiker) skerm';
$string['statsmodegeneral'] = 'Algemene skerm';
$string['statsnodata'] = 'Daar is geen beskikbare data vir die kombinasie van daardie kursus en tydperk.';
$string['statsnodatauser'] = 'Daar is geen beskikbare data vir daardie kombinasie van kursus, gebruiker en tydperk nie.';
$string['statsoff'] = 'Statistieke is huidiglik nie geaktiveer nie';
$string['statsreads'] = 'Beskouings';
$string['statsreport1'] = 'Intekeninge';
$string['statsreport10'] = 'Gebruiker aktiwiteit';
$string['statsreport11'] = 'Mees aktiewe kursusse';
$string['statsreport12'] = 'Mees aktiewe kursusse (geweeg)';
$string['statsreport13'] = 'Die mees deelnemende kursusse (inskrywings)';
$string['statsreport14'] = 'Kursusse met die meeste deelname (besoeke/plasings)';
$string['statsreport2'] = 'Vertoon (alle rolle)';
$string['statsreport3'] = 'Inskrywings (alle rolle)';
$string['statsreport4'] = 'Alle aktiwiteit (alle rolle)';
$string['statsreport5'] = 'Alle aktiwiteit (skerms en poste)';
$string['statsreport7'] = 'Gebruikers aktiwiteit (skerms en poste)';
$string['statsreport8'] = 'Alle gebruikers aktiwiteit';
$string['statsreport9'] = 'Intekeninge (webwerf kursus)';
$string['statsreportactivity'] = 'Alle aktiwiteit (alle rolle)';
$string['statsreportactivitybyrole'] = 'Alle aktiwiteit (besoeke en plasings)';
$string['statsreportforuser'] = 'vir';
$string['statsreportlogins'] = 'Intekeninge';
$string['statsreportreads'] = 'Besoeke (alle rolle)';
$string['statsreporttype'] = 'Tipe verslag';
$string['statsreportwrites'] = 'Plasings (alle rolle)';
$string['statsstudentactivity'] = 'Student aktiwiteit';
$string['statsstudentreads'] = 'Student besoeke';
$string['statsstudentwrites'] = 'Student plasings';
$string['statsteacheractivity'] = 'Onderwyser aktiwiteit';
$string['statsteacherreads'] = 'Onderwyser besoeke';
$string['statsteacherwrites'] = 'Onderwyser plasings';
$string['statstimeperiod'] = 'Tydperk - laaste:';
$string['statsuniquelogins'] = 'Unieke aantekeninge';
$string['statsuseractivity'] = 'Alle aktiwiteite';
$string['statsuserlogins'] = 'Aantekeninge';
$string['statsuserreads'] = 'Skerms';
$string['statsuserwrites'] = 'Inskrywings';
$string['statswrites'] = 'Inskrywings';
$string['status'] = 'Status';
$string['statuscritical'] = 'Krities';
$string['statuserror'] = 'Fout';
$string['statusinfo'] = 'Inligting';
$string['statusna'] = 'Nie Beskikbaar';
$string['statusok'] = 'Reg';
$string['statusunknown'] = 'Onbekend';
$string['statuswarning'] = 'Waarskuwing';
$string['stringsnotset'] = 'Die volgende stringe in {$a} is nie gedefinieer nie';
$string['studentnotallowed'] = 'Jammer, maar jy kan nie in hierdie kursus ingaan as \'{$a}\' nie';
$string['students'] = 'Studente';
$string['studentsandteachers'] = 'Studente en onderwysers';
$string['subcategories'] = 'Subkategorieë';
$string['subcategory'] = 'Subkategorie';
$string['subcategoryof'] = 'Subkategorie van {$a}';
$string['subject'] = 'Onderwerp';
$string['submit'] = 'Dien in';
$string['success'] = 'Sukses';
$string['successduration'] = 'Sukses ({$a} sekondes)';
$string['summary'] = 'Opsomming';
$string['suspended'] = 'Opgeskort';
$string['suspendedusers'] = 'Opgeskorte gebruikers';
$string['switchdevicedefault'] = 'Skakel oor na die standaard tema';
$string['switchdevicerecommended'] = 'Skakel oor na die voorgestelde tema vir jou toestel';
$string['switchrolereturn'] = 'Keer terug na my normale rol';
$string['switchroleto'] = 'Skakel oor na rol...';
$string['switchroleto_help'] = 'Kies \'n rol om \'n idee te kry van hoe iemand met daardie rol die kursus gaan sien.

Let asseblief op dat die skerm dalk nie perfek gaan vertoon nie (<a href="https://docs.moodle.org/en/Switch_roles">Sien besonderhede en alternatiewe</a>).';
$string['tag'] = 'Merker';
$string['tagalready'] = 'Hierdie etiket bestaan alreeds';
$string['tagmanagement'] = 'Voeg etikette by / wis etikette uit';
$string['tags'] = 'Merkers';
$string['targetrole'] = 'Teikenrol';
$string['teacheronly'] = 'slegs vir die {$a}';
$string['teacherroles'] = '{$a} rolle';
$string['teachers'] = 'Onderwysers';
$string['textcopiedtoclipboard'] = 'Teks gekopieer na die knipbord';
$string['textediting'] = 'Teksredigeerder';
$string['textediting_help'] = 'Indien \'n HTML redigeerder soos Atto of TinyMCE gekies is, gaan teks areas \'n gereedskapslys hê met knoppies om maklik die inhoud by te voeg.

Indien \'n \'eenvoudige teks area\' gekies is, kan \'n formaat soos HTML of Markdown gekies word om teks in te voer.

Die lys van teksredigeerders word bepaal deur die administrateur.';
$string['texteditor'] = 'Gebruik standaard webvorms';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Eenvoudige teks formaat';
$string['thanks'] = 'Dankie';
$string['theme'] = 'Tema';
$string['themepreviewdescription'] = '{$a} temabeskrywing';
$string['themepreviewimage'] = '{$a} voorskouprent';
$string['themes'] = 'Temas';
$string['themesaved'] = 'Nuwe tema gekies';
$string['therearecourses'] = 'Daar is {$a} kursusse';
$string['thereareno'] = 'Daar is geen {$a} in die kursus';
$string['thiscategory'] = 'Hierdie kategorie';
$string['thiscategorycontains'] = 'Hierdie kategorie bevat';
$string['time'] = 'Tyd';
$string['timecreated'] = 'Tyd geskep';
$string['timecreatedcourse'] = 'Tyd wat kursus geskep is';
$string['timesplitting:deciles'] = 'Laaste tiende';
$string['timesplitting:deciles_help'] = 'Hierdie analise interval verdeel die kursus op in tiendes (10 gelyke dele). Elke voorspelling is gebaseer op die data van net die mees onlangse vorige tiende.';
$string['timesplitting:decilesaccum'] = 'Alle vorige tiendes';
$string['timesplitting:decilesaccum_help'] = 'Hierdie analise interval verdeel die kursus op in tiendes (10 gelyke dele). Elke voorspelling is gebaseer op die gesamentlike data van al die vorige tiendes.';
$string['timesplitting:nosplitting'] = 'Geen tydlimiete';
$string['timesplitting:nosplitting_help'] = 'Geen analise interval is vir hierdie model gedefinieer nie.';
$string['timesplitting:onemonthafterstart'] = 'Een maand na begin';
$string['timesplitting:onemonthafterstart_help'] = 'Hierdie analise interval genereer \'n voorspelling 1 maand na die analiseerbare begin.';
$string['timesplitting:oneweekafterstart'] = 'Een week na begin';
$string['timesplitting:oneweekafterstart_help'] = 'Hierdie analise interval genereer \'n voorspelling 1 week na die analiseerbare begin.';
$string['timesplitting:past3days'] = 'Afgelope 3 dae';
$string['timesplitting:past3days_help'] = 'Hierdie analise interval genereer voorspellings elke 3 dae. Die aanwysing bewerkinge sal op die afgelope 3 dae gebaseer word.';
$string['timesplitting:pastmonth'] = 'Afgelope maand';
$string['timesplitting:pastmonth_help'] = 'Hierdie analise interval genereer voorspellings elke maand. Die aanwysing bewerkinge sal op die afgelope maand gebaseer word.';
$string['timesplitting:pastweek'] = 'Afgekope week';
$string['timesplitting:pastweek_help'] = 'Hierdie analise interval genereer voorspellings elke week. Die aanwysing bewerkinge sal op die afgelope week gebaseer word.';
$string['timesplitting:quarters'] = 'Laaste kwart';
$string['timesplitting:quarters_help'] = 'Hierdie analise interval verdeel die kursus op in kwarte (4 gelyke dele). Elke voorspelling is gebaseer op die data van net die mees onlangse vorige kwart.';
$string['timesplitting:quartersaccum'] = 'Alle vorige kwarte';
$string['timesplitting:quartersaccum_help'] = 'Hierdie analise interval verdeel die kursus op in kwarte (4 gelyke dele). Elke voorspelling is gebaseer op die gesamentlike data van al die vorige kwarte.';
$string['timesplitting:singlerange'] = 'Van begin tot einde';
$string['timesplitting:singlerange_help'] = 'Hierdie analise interval beskou die hele kursus as \'n enkele duur.';
$string['timesplitting:tenpercentafterstart'] = '10% na begin';
$string['timesplitting:tenpercentafterstart_help'] = 'Hierdie analise interval genereer \'n voorspelling nadat 10% van die kursus voltooi is.';
$string['timesplitting:upcoming3days'] = 'Opkomende 3 dae';
$string['timesplitting:upcoming3days_help'] = 'Hierdie analise interval genereer voorspellings elke 3 dae. Die aanwysing bewerkinge sal op die opkomende 3 dae gebaseer word.';
$string['timesplitting:upcomingfortnight'] = 'Opkomende 2 weke';
$string['timesplitting:upcomingfortnight_help'] = 'Hierdie analise interval genereer voorspellings elke 2 weke. Die aanwysing bewerkinge sal op die opkomende 2 weke gebaseer word.';
$string['timesplitting:upcomingweek'] = 'Opkomende week';
$string['timesplitting:upcomingweek_help'] = 'Hierdie analise interval genereer voorspellings elke week. Die aanwysing bewerkinge sal op die opkomende week gebaseer word.';
$string['timezone'] = 'Tydsone';
$string['tocontent'] = 'Na item "{$a}"';
$string['tocreatenewaccount'] = 'Slaan oor om \'n nuwe profiel te skep';
$string['todate'] = 'Aan';
$string['today'] = 'Vandag';
$string['todaylogs'] = 'Vandag se aantekeninge';
$string['toeveryone'] = 'aan almal';
$string['toggleemojipicker'] = 'Wissel emoji kieser';
$string['togglesearch'] = 'Wissel soek invoer';
$string['toomanybounces'] = 'Daardie e-posadres het te veel kere gehop. Jy <b>moet</b> dit verander voordat jy kan voort gaan.';
$string['toomanytags'] = 'Hierdie soektog bevat te veel merkers; sommige merkers mag dalk geïgnoreer wees';
$string['toomanytoshow'] = 'Daar is te veel gebruikers om te vertoon.';
$string['toomanyusersmatchsearch'] = 'Te veel gebruikers ({$a->count}) stem ooreen met \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Te veel gebruikers ({$a}) om te vertoon';
$string['toonly'] = 'slegs aan {$a}';
$string['top'] = 'Bo';
$string['topic'] = 'Afdeling';
$string['toplevelcategory'] = 'Boonste vlak van die kategorie';
$string['torecipient'] = 'Aan';
$string['total'] = 'Totaal';
$string['totopofsection'] = 'Gaan na die begin van afdeling "{$a}"';
$string['trackforums'] = 'Volg die forum';
$string['trackforumsno'] = 'Nee: moet nie tred hou met die inskrywings wat ek besigtig het nie';
$string['trackforumsyes'] = 'Ja, merk die nuwe inskrywings vir my';
$string['trysearching'] = 'Probeer eerder om te soek,';
$string['turneditingoff'] = 'Stel redigering af';
$string['turneditingon'] = 'Skakel redigering aan';
$string['unabletocopytoclipboard'] = 'Nie in staat om teks na die knipbord te kopieer';
$string['unauthorisedlogin'] = 'Die gebruiker profiel "{$a}" is nie beskikbaar op die webwerf nie';
$string['undecided'] = 'Onbeslis';
$string['unexistingcmid'] = 'Kursus module ID word nie gevind nie';
$string['unexistingsectionid'] = 'Kursus afdeling ID word nie gevind nie';
$string['unfinished'] = 'Onvoltooid';
$string['unknowncategory'] = 'Onbekende kategorie';
$string['unknownerror'] = 'Onbekende fout';
$string['unknownuser'] = 'Onbekende gebruiker';
$string['unlimited'] = 'Onbeperk';
$string['unpacking'] = 'Uitpak van {$a}';
$string['unsafepassword'] = 'Onveilige wagwoord - probeer iets anders';
$string['untilcomplete'] = 'Tot voltooi';
$string['unusedaccounts'] = 'Rekeninge wat vir meer as {$a} dae nie gebruik word nie, sal outomaties teruggetrek word';
$string['unzip'] = 'Uitpak';
$string['unzippingbackup'] = 'Besig om rugsteun te ontzip';
$string['up'] = 'Op';
$string['update'] = 'Bywerk';
$string['updated'] = '{$a} is bygewerk';
$string['updatemymoodleoff'] = 'Stop die verpersoonliking van die bladsy';
$string['updatemymoodleon'] = 'Verpersoonlik hierdie bladsy';
$string['updatemyprofile'] = 'Werk profiel by';
$string['updatesevery'] = 'Werk elke {$a} sekondes by';
$string['updatethis'] = 'Werk {$a} by';
$string['updatethiscourse'] = 'Dateer hierdie kursus op';
$string['upload'] = 'Laai op';
$string['uploadafile'] = 'Laai \'n lêer op';
$string['uploadcantwrite'] = 'Kan nie na die hardeskyf toe skruif nie';
$string['uploadedfile'] = 'Lêer suksesvol opgelaai';
$string['uploadedfileto'] = '{$a->file} na {$a->directory} opgelaai';
$string['uploadedfiletoobig'] = 'Jammer, maar die lêer is te groot (limiet is {$a} bytes)';
$string['uploadextension'] = 'Die oplaai van die lêer is gestop deur \'n PHP uitbreiding';
$string['uploadfailednotrecovering'] = 'Die oplaai was nie suksesvol nie omdat daar \'n probleem met een van die lêer {$a->name} is.<br />Hier is die aantekeninge wat gemaak is oor die probleem:<br />{$a->problem}<br />Kan nie herwin nie.';
$string['uploadfilelog'] = 'Laai aantekeninge op vir lêer {$a}';
$string['uploadformlimit'] = 'Die opgelaaide lêer {$a} oorskry die maksimum limiet wat gestel is op die forum';
$string['uploadlabel'] = 'Titel:';
$string['uploadlimitwithsize'] = '{$a->contextname} oplaai limiet ({$a->displaysize})';
$string['uploadnewfile'] = 'Laai nuwe lêer op';
$string['uploadnofilefound'] = 'Geen lêer is gevind nie - is jy seker jy het een geselekteer om opgelaai te word?';
$string['uploadnotallowed'] = 'Oplaai word nie toegelaat nie';
$string['uploadnotempdir'] = '\'n Tydelike gids ontbreek';
$string['uploadoldfilesdeleted'] = 'Die ou lêer(s) in jou oplaai area is verwyder';
$string['uploadpartialfile'] = 'Die lêer is slegs gedeeltelik opgelaai';
$string['uploadproblem'] = '\'n Onbekende fout het voorgekom terwyl \'{$a}\' opgelaai word (miskien was dit te groot?)';
$string['uploadrenamedchars'] = 'Lêer was herbenoem vanaf {$a->oldname} na {$a->newname} omdat dit ongeldige karakters bevat het.';
$string['uploadrenamedcollision'] = 'Lêer was herbenoem vanaf {$a->oldname} na {$a->newname} omdat daar \'n lêer met \'n soortgelyk naam is.';
$string['uploadserverlimit'] = 'Die opgelaaide lêer oorskei die maksimum limiet wat deur die bediener voorgeskryf word';
$string['uploadthisfile'] = 'Laai hierdie lêer op';
$string['url'] = 'URL';
$string['used'] = 'Gebruik';
$string['usedinnplaces'] = 'Gebruik in {$a} plekke';
$string['user'] = 'Gebruiker';
$string['useraccount'] = 'Gebruiker profiel';
$string['useractivity'] = 'Aktiwiteit';
$string['userconfirmed'] = 'Bevestig {$a}';
$string['userdata'] = 'Gebruiker data';
$string['userdeleted'] = 'Hierdie gebruiker se profiel is verwyder';
$string['userdescription'] = 'Beskrywing';
$string['userdescription_help'] = 'Hierdie boksie bied vir hou die opsie om \'n paar woorde oor jouself te verskaf wat dan op jou profiel vertoon gaan word vir ander om te lees.';
$string['userdetails'] = 'Gebruiker besonderhede';
$string['userfiles'] = 'Gebruiker lêers';
$string['userlist'] = 'Lys van gebruikers';
$string['usermenu'] = 'Gebruiker kieslys';
$string['usermenugoback'] = 'Terug na gebruiker spyskaart';
$string['username'] = 'Gebruikersnaam';
$string['usernameemail'] = 'Gebruikersnaam of e-posadres';
$string['usernameemailmatch'] = 'Die gebruikersnaam en e-posadres verwys nie na dieselfde gebruiker nie';
$string['usernameexists'] = 'Die gebruikersnaam bestaan reeds, kies \'n ander';
$string['usernamelowercase'] = 'Slegs kleinletters toegelaat';
$string['usernamenotfound'] = 'Die gebruikersnaam is nie gevind in die databasis nie';
$string['usernameoremail'] = 'Verskaf of die gebruikersnaam of die e-posadres';
$string['usernotconfirmed'] = 'Kon nie {$a} bevestig nie';
$string['userpic'] = 'Gebruiker foto';
$string['userpreferences'] = 'Gebruikersvoorkeure';
$string['users'] = 'Gebruikers';
$string['userselectorautoselectunique'] = 'As slegs een gebruiker ooreenstem met die soektog, kies hom outomaties';
$string['userselectorpreserveselected'] = 'Hou die gebruikers geselekteer, al voldoen hulle nie meer aan die soektog nie';
$string['userselectorsearchanywhere'] = 'oral';
$string['userselectorsearchexactmatchonly'] = 'slegs presiese ooreenkomste';
$string['userselectorsearchfromstart'] = 'van die begin af';
$string['userselectorsearchmatching'] = 'Pas by:';
$string['usersnew'] = 'Nuwe gebruikers';
$string['usersnoaccesssince'] = 'Onaktief vir meer as';
$string['userswithfiles'] = 'Gebruikers met dokumente';
$string['useruploadtype'] = 'Gebruiker tipe oplaai: {$a}';
$string['userzones'] = 'Gebruiker sones';
$string['usetheme'] = 'Gebruiker tema';
$string['usingexistingcourse'] = 'Gebruik bestaande kursus';
$string['validatehtml'] = 'Bekragtig HTML';
$string['valuealreadyused'] = 'Hierdie waarde is reeds gebruik.';
$string['version'] = 'Weergawe';
$string['view'] = 'Beskou';
$string['viewallcourses'] = 'Beskou al die kursusse';
$string['viewallcoursescategories'] = 'Beskou al die kursusse en katogorieë';
$string['viewallresults'] = 'View all results ({$a})';
$string['viewallsubcategories'] = 'Beskou alle subkatogorieë';
$string['viewfileinpopup'] = 'Besigtig lêer in \'n afhaal venster';
$string['viewing'] = 'Beskou tans:';
$string['viewmore'] = 'Beskou meer';
$string['viewprofile'] = 'Beskou profiel';
$string['views'] = 'Beskouings';
$string['viewsolution'] = 'beskou oplossing';
$string['visible'] = 'Sigbaar';
$string['visible_help'] = 'Hierdie instelling bepaal of die kursus verskyn in die lys van kursusse. Afgesien van onderwysers en administrateurs, word gebruikers nie toegelaat om die kursus binne te gaan nie.';
$string['visibletostudents'] = 'Sigbaar aan {$a}';
$string['warning'] = 'Waarskuwing';
$string['warningdeleteresource'] = 'Waarskuwing: Daar word na {$a} in \'n hulpbron verwys. Wil jy die hulpbron opdateer?';
$string['wcagcheck'] = 'Kontroleer Web Content Accessibility Guidelines (WCAG)';
$string['webpage'] = 'Webblad';
$string['week'] = 'Week';
$string['weeks'] = 'weke';
$string['welcomeback'] = 'Welkom terug, {$a->firstname}! 👋';
$string['welcometocourse'] = 'Welkom by {$a}';
$string['welcometocoursetext'] = 'Welkom by {$a->coursename}!

Indien jy nie reeds jou profiel bygewerk het sodat ons meer van jou kan leer, kan jy dit hier doen:

  {$a->profileurl}';
$string['welcometosite'] = 'Welkom, {$a->firstname}! 👋';
$string['whatforlink'] = 'Wat wil jy met die skakel doen?';
$string['whatforpage'] = 'Wat wil jy met die teks doen?';
$string['whatisyourage'] = 'Wat is jou ouderdom?';
$string['whattocallzip'] = 'Wat wil jy die zip lêer noem?';
$string['whattodo'] = 'Wat om te doen';
$string['wheredoyoulive'] = 'In watter land bly jy?';
$string['whyisthisrequired'] = 'Hoekom word dit benodig?';
$string['windowclosing'] = 'Hierdie venster moet outomaties toemaak. Indien nie, maak dit asseblief nou toe.';
$string['withchosenfiles'] = 'Met gekose lêers';
$string['withdisablednote'] = '{$a} (gedeaktiveer)';
$string['withoutuserdata'] = 'sonder gebruiker data';
$string['withselectedusers'] = 'Met geselekteerde gebruikers...';
$string['withuserdata'] = 'met geselekteerde data';
$string['wontrunfuturescheduledtask'] = 'Sal nie taak uitvoer wat nie misluk het nie en geskeduleer is om in die toekoms te loop.';
$string['wordforstudent'] = 'Jou woord vir Student';
$string['wordforstudenteg'] = 'bv. Student, deelnemer, ens.';
$string['wordforstudents'] = 'Jou woord vir Studente';
$string['wordforstudentseg'] = 'bv. Studente, deelnemers, ens.';
$string['wordforteacher'] = 'Jou woord vir Onderwyser';
$string['wordforteachereg'] = 'bv. Onderwyser, Afrigter, Fasiliteerder, ens.';
$string['wordforteachers'] = 'Jou woord vir Onderwysers';
$string['wordforteacherseg'] = 'bv. Onderwysers, Afrigters, Fasiliteerders, ens.';
$string['writingblogsinfo'] = 'Webjoernale skryf inligting';
$string['writingcategoriesandquestions'] = 'Skryfkategoriee en vrae';
$string['writingcoursedata'] = 'Skryf kursus data';
$string['writingeventsinfo'] = 'Skryfgebeurtenisse inligting';
$string['writinggeneralinfo'] = 'Skryf algemene inligting';
$string['writinggradebookinfo'] = 'Skryf die punteboek se inligting';
$string['writinggroupingsgroupsinfo'] = 'Skryf groeperings/groepe inligting';
$string['writinggroupingsinfo'] = 'Skryf groeperings inligting';
$string['writinggroupsinfo'] = 'Skryf groepe inligting';
$string['writingheader'] = 'Skryf opskrifte';
$string['writingloginfo'] = 'Skryf logs inligting';
$string['writingmessagesinfo'] = 'Skryf boodskappe inligting';
$string['writingmoduleinfo'] = 'Skryf modules inligting';
$string['writingscalesinfo'] = 'Skryf skale inligting';
$string['writinguserinfo'] = 'Skryf gebruikers inligting';
$string['wrongpassword'] = 'Inkorrekte wagwoord vir hierdie gebruikersnaam';
$string['year'] = 'jaar';
$string['years'] = 'jare';
$string['yes'] = 'Ja';
$string['youareabouttocreatezip'] = 'Jy gaan \'n zip lêer skep wat die volgende bevat';
$string['youaregoingtorestorefrom'] = 'Jy gaan die herstel proses begin vir';
$string['youhaveupcomingactivitiesdue'] = 'Jou opkomende aktiwiteite is uitstaande';
$string['youhaveupcomingactivitiesdueinfo'] = 'Beste {$a},

<br/><br/>Opkomende aktiwiteite is uitstaande:';
$string['youneedtoenrol'] = 'Om hierdie aksie uit te voer moet jy eers vir die kursus ingeskryf wees.';
$string['yourlastlogin'] = 'Jou laaste intekening was';
$string['yourself'] = 'jouself';
$string['yourteacher'] = 'jou {$a}';
$string['yourwordforx'] = 'Jou woord vir \'{$a}\'';
$string['zippingbackup'] = 'Besig om rugsteun te zip';
