<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'af', version '5.1'.
 *
 * @package     install
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'Die gespesifiseerde admingids is verkeerd';
$string['admindirname'] = 'Admingids';
$string['admindirsetting'] = 'Slegs \'n paar webgashere gebruik /admin \'n spesiale URL sodat jy toegang tot \'n kontrolepaneel of iets dergliks kan verkry. Ongelukkig bots dit met die standaardligging vir die Moodle-adminblaaie. Jy kan dit regstel deur die admingids in jou installasie te herbenaam, en daardie nuwe naam hier aan te bring. Byvoorbeeld: <br /> <br /><b>moodleadmin</b><br /> <br />
    Dit sal die adminskakels in Moodle regstel.';
$string['admindirsettinghead'] = 'Stel tans die admingids in ...';
$string['admindirsettingsub'] = 'Slegs \'n paar webgashere gebruik /admin \'n spesiale URL sodat jy toegang tot \'n kontrolepaneel of iets dergliks kan verkry. Ongelukkig bots dit met die standaardligging vir die Moodle-adminblaaie. Jy kan dit regstel deur die admingids in jou installasie te herbenaam, en daardie nuwe naam hier aan te bring. Byvoorbeeld: <br /> <br /><b>moodleadmin</b><br /> <br />
    Dit sal die adminskakels in Moodle regstel.';
$string['availablelangs'] = 'Beskikbare taalpakkette';
$string['caution'] = 'Waarskuwing';
$string['chooselanguage'] = 'Kies \'n taal';
$string['chooselanguagehead'] = 'Kies \'n taal';
$string['chooselanguagesub'] = 'Kies asseblief \'n taal vir die installasie. Hierdie taal sal ook as die verstektaal vir die webwerf gebruik word, alhoewel dit later verander kan word.';
$string['cliadminemail'] = 'Nuwe admingebruiker se e-posadres';
$string['cliadminpassword'] = 'Nuwe admingebruiker se wagwoord';
$string['cliadminusername'] = 'Adminrekening se gebruikernaam';
$string['clialreadyconfigured'] = 'Die konfigurasielêer config.php bestaan reeds. Gebruik admin/cli/install_database.php asseblief om Moodle vir hierdie webwerf te installeer.';
$string['clialreadyinstalled'] = 'Die konfigurasielêer config.php bestaan reeds. Gebruik admin/cli/install_database.php asseblief om Moodle vir hierdie webwerf by te werk.';
$string['cliinstallfinished'] = 'Installasie suksesvol afgehandel.';
$string['cliinstallheader'] = 'Installasieprogram vir Moodle-{$a}-opdraglyn';
$string['climustagreelicense'] = 'In nie-interaktiewe modus moet jy instem tot die lisensie deur --stem in-lisensieopsie te spesifiseer';
$string['cliskipdatabase'] = 'Slaan databasisinstallasie oor.';
$string['clitablesexist'] = 'Databasistabelle reeds teenwoordig: CLI-installasie kan nie voortgesit word nie.';
$string['compatibilitysettings'] = 'Gaan tans jou PHP-instellings na ...';
$string['compatibilitysettingshead'] = 'Gaan tans jou PHP-instellings na ...';
$string['compatibilitysettingssub'] = 'Jou bediener moet al hierdie toetse slaag sodat Moodle na behore kan loop';
$string['configfilenotwritten'] = 'Die installeerderskrip kon nie \'n config.php-lêer wat jou gekose instellings bevat outomaties skep nie, waarskynlik omdat daar nie na die Moodle-gids geskryf kan word nie. Jy kan die volgende kode handmatig na \'n lêer genaamd config.php binne die Moodle-stamgids kopieer.';
$string['configfilewritten'] = 'config.php suksesvol geskep';
$string['configurationcomplete'] = 'Konfigurasie afgehandel';
$string['configurationcompletehead'] = 'Konfigurasie afgehandel';
$string['configurationcompletesub'] = 'Moodle het probeer om jou konfigurasie in die stam van jou Moodle-installasie te stoor.';
$string['database'] = 'Databasis';
$string['databasehead'] = 'Databasisinstellings';
$string['databasehost'] = 'Databasisgasheer';
$string['databasename'] = 'Databasisnaam';
$string['databasepass'] = 'Databasiswagwoord';
$string['databaseport'] = 'Databasispoort';
$string['databasesocket'] = 'Unix-sok';
$string['databasetypehead'] = 'Kies databasisdrywer';
$string['databasetypesub'] = 'Moodle werk met verskeie tipes databasisbedieners. Kontak bedieneradministrateur asseblief as jy nie weet watter tipe om te gebruik nie.';
$string['databaseuser'] = 'Databasisgebruiker';
$string['dataroot'] = 'Datagids';
$string['datarooterror'] = 'Die \'datagids\' wat jy gespesifiseer het, kon nie gevind of geskep word nie. Stel óf die roete reg óf skep daardie gids handmatig.';
$string['datarootpermission'] = 'Datagidstoestemming';
$string['datarootpublicerror'] = 'Die \'datagids\' wat jy gespesifiseer het, is direk toeganklik via die web. Jy moet \'n ander gids gebruik.';
$string['dbconnectionerror'] = 'Ons kon nie die databasis wat jy gespesifiseer het, verbind nie. Gaan asseblief jou databasisinstellings na.';
$string['dbcreationerror'] = 'Iets het skeefgeloop met die skep van databasis. Kon nie die gegewe databasisnaam skep met die instellings wat verskaf is nie.';
$string['dbhost'] = 'Gasheerbediener';
$string['dbpass'] = 'Wagwoord';
$string['dbport'] = 'Poort';
$string['dbprefix'] = 'Tabelvoorvoegsel';
$string['dbtype'] = 'Tipe';
$string['directorysettings'] = '<p>Bevestig asseblief die liggings van hierdie Moodle-installasie.</p>

<p><b>Webadres:</b>
Spesifiseer die volledige webadres waar toegang tot Moodle verkry sal word.
As jou webwerf via veelvoudige URL\'e toeganglik is, kies dan die een wat die mees natuurlike is een wat jou studente sal gebruik.  Moenie \'n agterste skuinsstreep insluit nie.</p>

<p><b>Moodle-gids:</b>
Spesifiseer die volledige gidsroete na hierdie installasie.
Maak seker dat hoof-/kleinletters korrek is.</p>

<p><b>Datagids:</b>
Jy het \'n plek nodig waar Moodle opgelaaide lêers kan stoor.  Hierdie gids moet vir die gebruiker van die webbediener (gewoonlik \'niemand\' of \'apache\') leesbaar en SKRYFBAAR wees, maar dit moet nie regstreeks via die web toeganklik wees nie.  Die installeerder sal probeer om dit te skep as dit nie bestaan nie.</p>';
$string['directorysettingshead'] = 'Bevestig asseblief die liggings van hierdie Moodle-installasie';
$string['directorysettingssub'] = '<b>Webadres:</b>
Spesifiseer die volledige webadres waar toegang tot Moodle verkry sal word.
As jou webwerf via veelvoudige URL\'e toeganglik is, kies dan die een wat die mees natuurlike is een wat jou studente sal gebruik.  Moenie \'n agterste skuinsstreep insluit nie.
<br />
<br />
<b>Moodle-gids:</b>
Spesifiseer die volledige gidsroete na hierdie installasie.
Maak seker dat hoof-/kleinletters korrek is.
<br />
<br />
<b>Datagids:</b>
Jy het \'n plek nodig waar Moodle opgelaaide lêers kan stoor.  Hierdie gids moet vir die gebruiker van die webbediener (gewoonlik \'niemand\' of \'apache\') leesbaar en SKRYFBAAR wees, maar dit moet nie regstreeks via die web toeganklik wees nie.  Die installeerder sal probeer om dit te skep as dit nie bestaan nie.';
$string['dirroot'] = 'Moodle-gids';
$string['dirrooterror'] = 'Dit blyk dat die \'Moodle-gids\'-instelling verkeerd is - ons kon nie \'n Moodle-installasie daar vind nie. Die waarde hieronder is teruggestel.';
$string['download'] = 'Laai af';
$string['downloadlanguagebutton'] = 'Laai die &quot;{$a}&quot; taalpakket af';
$string['downloadlanguagehead'] = 'Laai taalpakket af';
$string['downloadlanguagenotneeded'] = 'Jy kan die installasieproses voortsit deur van die verstektaalpakket gebruik te maak, "{$a}".';
$string['downloadlanguagesub'] = 'Jy het nou die opsie om \'n taalpakket af te laai en die installasieproses in daardie taal voort te sit.<br /><br />As jy nie die taalpakket kan aflaai nie, sal die installasieproses in Engels voortgaan. (Sodra die installasieproses afgehandel is, sal jy die geleentheid hê om addisionele taalpakkette te installeer.)';
$string['doyouagree'] = 'Stem jy in? (ja/nee):';
$string['environmenthead'] = 'Gaan tans jou omgewing na ...';
$string['environmentsub'] = 'Ons kontroleer tans of die onderskeie komponente van jou stelsel aan die stelselvereistes voldoen.';
$string['environmentsub2'] = 'Elke Moodle-vrystelling het \'n paar minimumvereistes vir PHP-weergawes en \'n aantal verpligte PHP-uitbreidings.
Volledige omgewingskontrole word vóór elke installasie en opgradering gedoen. Kontak bedieneradministrateur asseblief as jy nie weet hoe om nuwe weergawe te installeer of PHP-uitbreidings te ontsper nie.';
$string['errorsinenvironment'] = 'Omgewingskontrole het misluk!';
$string['fail'] = 'Faal';
$string['fileuploads'] = 'Oplaai van lêers';
$string['fileuploadserror'] = 'Dit behoort aangeskakel te wees';
$string['fileuploadshelp'] = '<p>Die oplaai van lêers op jou bediener is klaarblyklik versper.</p>

<p>Moodle kan steeds geïnstalleer word, maar sonder hierdie vermoë sal jy nie in staat wees om kursuslêers of nuwe gebruikerprofielfoto\'s op te laai nie.</p>

<p>Om die oplaai van lêers te ontsper, moet jy (of jou stelseladministrateur) die meester-php.ini-lêer op jou stelsel redigeer en die instelling vir <b>file_uploads</b> na \'1\' verander.</p>';
$string['inputdatadirectory'] = 'Datagids:';
$string['inputwebadress'] = 'Webwerf:';
$string['inputwebdirectory'] = 'Moodle-gids:';
$string['installation'] = 'Installasie';
$string['invaliddbprefix'] = 'Ongeldige voorvoegsel. Die voorvoegsel kan slegs uit kleinletters en onderstreep bestaan.';
$string['langdownloaderror'] = 'Jammer, die taal "{$a}" kon nie afgelaai word nie. Die installasieproses sal in Engels voortgesit word.';
$string['langdownloadok'] = 'Die taal "{$a}" is suksesvol geïnstalleer. Die installasieproses sal in daardie taal voortgesit word.';
$string['memorylimit'] = 'Geheueperk';
$string['memorylimiterror'] = 'Die PHP-geheueperk is ietwat laag gestel ... jy kan dalk later probleme ervaar.';
$string['mysqliextensionisnotpresentinphp'] = 'PHP is nie behoorlik met die MySQLi-uitbreiding gekonfigureer sodat dit met MySQL kan kommunikeer nie. Gaan asseblief jou php.ini-lêer na of herkompileer PHP.';
$string['nativeauroramysql'] = 'Aurora MySQL (moeder/auroramysql)';
$string['nativeauroramysqlhelp'] = '<p>Die databasis is waar meeste van die Moodle-instellings en -data gestoor word en moet hier gekonfigureer word.</p>
<p>Die databasisnaam, gebruikernaam en wagwoord is vereiste velde; tabelvoorvoegsel is opsioneel.</p>
<p>Die databasisnaam kan slegs alfanumeriese karakters, dollar ($) en onderstreep (_) bevat.</p>
<p>As die databasis tans nie bestaan nie, en die gebruiker wat deur jou gespesifiseer word toestemming het, sal Moodle poog om \'n nuwe databasis met die korrekte toestemmings en instellings te skep.</p>
<p>Hierdie drywer is nie met argaïese MyISAM-enjin versoenbaar nie.</p>';
$string['nativemariadb'] = 'MariaDB (moeder/mariadb)';
$string['nativemariadbhelp'] = '<p>Die databasis is waar meeste van die Moodle-instellings en -data gestoor word en moet hier gekonfigureer word.</p>
<p>Die databasisnaam, gebruikernaam en wagwoord is vereiste velde; tabelvoorvoegsel is opsioneel.</p>
<p>Die databasisnaam kan slegs alfanumeriese karakters, dollar ($) en onderstreep (_) bevat.</p>
<p>As die databasis tans nie bestaan nie, en die gebruiker wat deur jou gespesifiseer word toestemming het, sal Moodle poog om \'n nuwe databasis met die korrekte toestemmings en instellings te skep.</p>
<p>Hierdie drywer is nie met argaïese MyISAM-enjin versoenbaar nie.</p>';
$string['nativemysqli'] = 'Improved MySQL (moeder/mysqli)';
$string['nativemysqlihelp'] = '<p>Die databasis is waar meeste van die Moodle-instellings en -data gestoor word en moet hier gekonfigureer word.</p>
<p>Die databasisnaam, gebruikernaam en wagwoord is vereiste velde; tabelvoorvoegsel is opsioneel.</p>
<p>Die databasisnaam kan slegs alfanumeriese karakters, dollar ($) en onderstreep (_) bevat.</p>
<p>As die databasis tans nie bestaan nie, en die gebruiker wat deur jou gespesifiseer word toestemming het, sal Moodle poog om \'n nuwe databasis met die korrekte toestemmings en instellings te skep.</p>
<p>Hierdie drywer is nie met argaïese MyISAM-enjin versoenbaar nie.</p>';
$string['nativepgsql'] = 'PostgreSQL (moeder/pgsql)';
$string['nativepgsqlhelp'] = '<p>Die databasis is waar meeste van die Moodle-instellings en -data gestoor word en moet hier gekonfigureer word.</p>
<p>Die databasisnaam, gebruikernaam, wagwoord en tabelvoorvoegsel is vereiste velde.</p>
<p>Die databasis moet reeds bestaan en die gebruiker moet toegang hê om dit beide te lees en om daarheen te skryf.</p>';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (moeder/sqlsrv)';
$string['nativesqlsrvhelp'] = 'Nou moet jy die databasis skep waar die meeste Moodle-data gestoor sal word.
Hierdie databasis moet reeds geskep wees en \'n gebruikernaam en wagwoord wat toegang daartoe verleen, moet geskep wees. Tabelvoorvoegsel is verpligtend.';
$string['nativesqlsrvnodriver'] = 'Microsoft-drywers vir SQL-bediener vir PHP is nie geïnstalleer nie of is nie behoorlik gekonfigureer nie.';
$string['pass'] = 'Slaag';
$string['paths'] = 'Roetes';
$string['pathserrcreatedataroot'] = 'Datagids ({$a->dataroot}) kan nie deur installeerder geskep word nie.';
$string['pathshead'] = 'Bevestig roetes';
$string['pathsrodataroot'] = 'Datastamgids is nie skryfbaar nie.';
$string['pathsroparentdataroot'] = 'Moedergids ({$a->parent}) is nie skryfbaar nie. Datagids ({$a->dataroot}) kan nie deur installeerder geskep word nie.';
$string['pathssubadmindir'] = 'Slegs \'n paar webgashere gebruik /admin \'n spesiale URL sodat jy toegang tot \'n kontrolepaneel of iets dergliks kan verkry. Ongelukkig bots dit met die standaardligging vir die Moodle-adminblaaie. Jy kan dit regstel deur die admingids in jou installasie te herbenaam, en daardie nuwe naam hier aan te bring. Byvoorbeeld: <em>moodleadmin</em>. Dit sal die adminskakels in Moodle regstel.';
$string['pathssubdataroot'] = '<p>\'n Gids waar Moodle alle lêerinhoud wat deur gebruikers opgelaai is, sal stoor.</p>
<p>Hierdie gids moet vir die gebruiker van die webbediener (gewoonlik \'www-data\', \'niemand\' of \'apache\') leesbaar en skryfbaar wees.</p>
</p>Dit moet nie regstreeks via die web toeganklik wees nie.</p>
<p>As die gids nie tans bestaan nie, sal die installasieproses probeer om dit te skep.</p>';
$string['pathssubdirroot'] = '<p>Die volledige roete na die gids wat die Moodle-kode bevat.</p>';
$string['pathssubwwwroot'] = '<p>Die volledige adres waar toegang tot Moodle verkry sal word, d.w.s. die adres wat gebruikers in die adresbalk van hul blaaier sal intik om toegang tot Moodle te verkry.</p>
<p>Dit is nie moontlik om toegang tot Moodle te verkry deur van veelvoudige adresse gebruik te maak nie. As jou webwerf via veelvoudige adresse toeganklik is, kies dan die maklikste een en stel \'n permanente heradressering vir elk van die ander adresse op.</p>
<p>As jou webwerf beide via die Internet en \'n interne netwerk (soms bekend as \'n Intranet) toeganklik is, gebruik dan die publieke adres hier.</p>
<p>As die huidige adres nie korrek is nie, verander asseblief die URL in jou blaaier se adresbalk en herbegin die installasie.</p>';
$string['pathsunsecuredataroot'] = 'Ligging van datastam is nie veilig nie';
$string['pathswrongadmindir'] = 'Admingids bestaan nie';
$string['pgsqlextensionisnotpresentinphp'] = 'PHP is nie behoorlik met die PGSQL-uitbreiding gekonfigureer sodat dit met PostgreSQL kan kommunikeer nie. Gaan asseblief jou php.ini-lêer na of herkompileer PHP.';
$string['phpextension'] = '{$a} PHP-uitbreiding';
$string['phpversion'] = 'PHP-weergawe';
$string['releasenoteslink'] = 'Vir meer inligting oor hierdie weergawe van Moodle, kyk asseblief na die vrystellingskennisgewings by {$a}.';
$string['safemode'] = 'Veilige modus';
$string['safemodeerror'] = 'Moodle kan dalk probleme ervaar as veilige modus aan is.';
$string['safemodehelp'] = '<p>Moodle kan allerhande probleme hê as veilige modus aangeskakel is, waarvan \'n onvermoë om nuwe lêers te skep waarskynlik die ergste is.</p>

<p>Veilige modus word gewoonlik slegs deur paranoïese gashere van openbare webwerwe geaktiveer, so jy sal dalk eenvoudig \'n nuwe webgasheermaatskappy vir jou Moodle-webwerf moet vind.</p>

<p>Dit staan jou vry om te probeer om die installasie voort te sit, maar wees bedag daarop dat jy later \'n paar probleme gaan ondervind.</p>';
$string['sessionautostart'] = 'Outobegin sessie';
$string['sessionautostarterror'] = 'Hierdie moet afgeskakel wees';
$string['sessionautostarthelp'] = '<p>Moodle benodig sessie-ondersteuning en sal nie daarsonder funksioneer nie.</p>

<p>Sessies kan in die php.ini-lêer ontsper word ... vind die session.auto_start-parameter.</p>';
$string['sqliteextensionisnotpresentinphp'] = 'PHP is nie behoorlik met die SQLite-uitbreiding gekonfigureer nie. Gaan asseblief jou php.ini-lêer na of herkompileer PHP.';
$string['upgradingqtypeplugin'] = 'Opgraderingsvraag/tipe inprop';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'Jy sien hierdie blad omdat jy die <strong>{$a->packname} {$a->packversion}</strong>-pakket suksesvol geïnstalleer en op jou rekenaar laat loop het. Baie geluk!';
$string['welcomep30'] = 'Hierdie vrystelling van die <strong>{$a->installername}</strong> sluit die toepassings in om \'n omgewing te skep waarbinne <strong>Moodle</strong> gaan funksioneer, naamlik:';
$string['welcomep40'] = 'Die pakket sluit ook <strong>Moodle {$a->moodlerelease} ({$a->moodleversion})</strong> in.';
$string['welcomep50'] = 'Die gebruik van al die toepassings in hierdie pakket word beheer deur hul onderskeie lisensies. Die volledige <strong>{$a->installername}</strong>-pakket is <a href="https://www.opensource.org/docs/definition_plain.html">-oopbron</a> en word versprei onder die  <a href="https://www.gnu.org/copyleft/gpl.html">GPL</a>-lisensie.';
$string['welcomep60'] = 'Die volgende blaaie gaan jou deur \'n paar maklik volgbare stappe lei om <strong>Moodle</strong> op jou rekenaar te konfigureer en op te stel. Jy kan die verstekinstellings aanvaar of, opsioneel, hulle wysig om by jou eie behoeftes te pas.';
$string['welcomep70'] = 'Klik die "Volgende"-knoppie hieronder om voort te gaan met die opstelling van <strong>Moodle</strong>.';
$string['wwwroot'] = 'Webadres';
$string['wwwrooterror'] = 'Dit lyk asof die \'Webadres\' nie geldig is nie - hierdie Moodle-installasie is klaarblyklik nie daar nie. Die waarde hieronder is teruggestel.';
