<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'es', version '5.1'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'Serán instalados';
$string['accept'] = 'Aceptar';
$string['action'] = 'Acción';
$string['actionchoice'] = '¿Qué desea hacer con el archivo \'{$a}\'?';
$string['actions'] = 'Acciones';
$string['actionsfor'] = 'Acciones para {$a}';
$string['actionsmenu'] = 'Menú de acciones';
$string['active'] = 'Activo';
$string['activeusers'] = 'Usuarios activos';
$string['activities'] = 'Actividades';
$string['activities_help'] = 'Actividades como foros, exámenes y wikis habilitan el contenido interactivo a ser agregado al curso.';
$string['activity'] = 'Actividad';
$string['activityclipboard'] = 'Moviendo esta actividad: {$a}';
$string['activityheader'] = 'Menú de Actividad';
$string['activityicon'] = 'Icono {$a}';
$string['activityiscurrentlyhidden'] = 'Lo sentimos, esta actividad está actualmente oculta';
$string['activitymodule'] = 'Módulo de Actividad';
$string['activitymodules'] = 'Módulos de Actividad';
$string['activitynotready'] = 'La actividad aún no está lista';
$string['activityorresource'] = 'Actividad o recurso';
$string['activityreport'] = 'Reporte de Actividad';
$string['activityreports'] = 'Reportes de Actividad';
$string['activityselect'] = 'Seleccione esta actividad para moverse a otro lugar';
$string['activitysince'] = 'Actividad desde {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Actividad por usuario';
$string['add'] = 'Añadir';
$string['addactivity'] = 'Agregar una actividad ...';
$string['addactivitytosection'] = 'Añadir una actividad a la sección \'{$a}\'';
$string['addadmin'] = 'Agregar administrador';
$string['addblock'] = 'Agregar un bloque';
$string['addcomment'] = 'Agregar un comentario...';
$string['addcondition'] = 'Añadir condición';
$string['addcontent'] = 'Añadir contenido';
$string['addcountertousername'] = 'Crea el usuario agregando un número al nombre de usuario';
$string['addcreator'] = 'Agregar creador de curso';
$string['adddots'] = 'Agregar...';
$string['added'] = 'Añadido {$a}';
$string['addedtogroup'] = 'Agregado al grupo "{$a}"';
$string['addedtogroupnot'] = 'No añadido al grupo "{$a}"';
$string['addedtogroupnotenrolled'] = 'No agregado al grupo "{$a}" , porque no está suscrito al curso';
$string['addfilehere'] = 'Arrastre y suelte los archivos aquí para agregarlos al final de esta sección';
$string['addfilesdrop'] = 'Para subir archivos puede arrastrarlos y soltarlos aquí o clicar para seleccionarlos.';
$string['addinganew'] = 'Nuevo {$a}';
$string['addingdatatoexisting'] = 'Agregandos datos a los datos existentes';
$string['additionalcustomnav'] = 'Navegación adicional personalizada';
$string['additionalnames'] = 'Nombres adicionales';
$string['addlinkhere'] = 'Agregar enlace aquí';
$string['addnew'] = 'Añadir un nuevo {$a}';
$string['addnewcategory'] = 'Crear nueva categoría';
$string['addnewcourse'] = 'Crear un nuevo curso';
$string['addnewuser'] = 'Crear un nuevo usuario';
$string['addnousersrecip'] = 'Agregue usuarios que no han accedido a este {$a} a lista de recipientes';
$string['addpagehere'] = 'Añada texto aquí';
$string['addresource'] = 'Agregue un recurso ...';
$string['addresourceoractivity'] = 'Añadir una actividad o un recurso';
$string['addresourcetosection'] = 'Añadir un recurso a la sección \'{$a}\'';
$string['address'] = 'Dirección';
$string['addsections'] = 'Añadir secciones';
$string['addstudent'] = 'Agregar estudiante';
$string['addsubcategory'] = 'Agregar categoría';
$string['addteacher'] = 'Agregar profesor';
$string['admin'] = 'Administrador';
$string['adminhelpaddnewuser'] = 'Para crear manualmente una nueva cuenta de usuario';
$string['adminhelpassignadmins'] = 'Los administradores puede hacer lo que sea e ir a cualquier lugar del sitio';
$string['adminhelpassigncreators'] = 'Los creadores de cursos pueden crear nuevos cursos';
$string['adminhelpassignsiteroles'] = 'Aplicar roles de sitio definidos a usuarios específicos';
$string['adminhelpassignstudents'] = 'Entra al curso y agrega estudiantes desde el menú administrativo del curso';
$string['adminhelpauthentication'] = 'Puede usar cuentas de usuarios internas o cuentas de usuarios alojadas en bases de datos externas';
$string['adminhelpbackup'] = 'Configure respaldos automáticos y programe la tarea de respaldo';
$string['adminhelpconfiguration'] = 'Configure cómo el sitio se ve y trabaja';
$string['adminhelpconfigvariables'] = 'Configure variables que afectan la operación general del sitio';
$string['adminhelpcourses'] = 'Defina cursos y categorías y asigne personas a ellos, edite los cursos pendientes';
$string['adminhelpeditorsettings'] = 'Defina configuraciones básicas para el editor HTML';
$string['adminhelpedituser'] = 'Examine la lista de cuentas de usuarios y edite alguno de ellos';
$string['adminhelpenvironment'] = 'Compruebe si su servidor se ajusta a los requerimientos de instalación actuales y futuros.';
$string['adminhelpfailurelogs'] = 'Revisar registros de accesos fallidos';
$string['adminhelplanguage'] = 'Revisar y editar el paquete de idioma actual';
$string['adminhelplogs'] = 'Navegar por los registros de toda la actividad del sitio';
$string['adminhelpmanageblocks'] = 'Manejar bloques instalados y sus ajustes';
$string['adminhelpmanagedatabase'] = 'Acceder directamente a la base de datos (¡cuidado!)';
$string['adminhelpmanagefilters'] = 'Seleccionar filtros de texto y su configuración';
$string['adminhelpmanagemodules'] = 'Administrar los módulos instalados y sus configuraciones';
$string['adminhelpmanageroles'] = 'Crear y definir roles que pueden aplicarse a los usuarios';
$string['adminhelpmymoodle'] = 'Configurar los bloques de "Mi Moodle" para usuarios';
$string['adminhelpreports'] = 'Clasificación de cursos por distintos criterios';
$string['adminhelpsitefiles'] = 'Publicar archivos en general o subir copias de seguridad externas';
$string['adminhelpsitesettings'] = 'Definir como debe ser el aspecto de la página principal del sitio';
$string['adminhelpstickyblocks'] = 'Configurar bloques \'sticky\' a través de Moodle';
$string['adminhelpthemes'] = 'Elegir el estilo del sitio (colores, fuentes, etc.)';
$string['adminhelpuploadusers'] = 'Importar usuarios desde un archivo de texto';
$string['adminhelpusers'] = 'Definir los usuarios y configurar la identificación';
$string['adminhelpxmldbeditor'] = 'Interfaz para editar archivos XMLDB. Sólo para desarrolladores.';
$string['administration'] = 'Administración';
$string['administrationsite'] = 'Administración del sitio';
$string['administrator'] = 'Administrador';
$string['administratordescription'] = 'Normalmente los administradores pueden hacer cualquier cosa en el sitio, en todos los cursos.';
$string['administrators'] = 'Administradores';
$string['administratorsall'] = 'Todos los administradores';
$string['administratorsandteachers'] = 'Administradores y profesores';
$string['advanced'] = 'Avanzada';
$string['advancedfilter'] = 'Búsqueda avanzada';
$string['advancedsettings'] = 'Ajustes avanzados';
$string['afterresource'] = 'Después del recurso "{$a}"';
$string['aftersection'] = 'Después de la sección "{$a}"';
$string['again'] = 'de nuevo';
$string['agelocationverification'] = 'Verificación de localización y edad';
$string['ajaxuse'] = 'AJAX y Javascript';
$string['all'] = 'Todos';
$string['allactions'] = 'Todas las acciones';
$string['allactivities'] = 'Todas las actividades';
$string['allcategories'] = 'Todas las categorías';
$string['allchanges'] = 'Todos los cambios';
$string['alldays'] = 'Todos los días';
$string['allfiles'] = 'Todos los archivos';
$string['allgroups'] = 'Todos los grupos';
$string['alllogs'] = 'Todas las entradas';
$string['allmods'] = 'Todos {$a}';
$string['allow'] = 'Permitir';
$string['allowinternal'] = 'Permitir también métodos internos';
$string['allownone'] = 'No permitir ninguno';
$string['allownot'] = 'No permitir';
$string['allowstealthmodules'] = 'Permitir actividades sigilosas';
$string['allowstealthmodules_help'] = 'Si se habilita, las actividades pueden hacerse disponibles pero no mostradas en secciones visibles de la página del curso. Si así fuera, los enlaces hacia las actividades sigilosas deben de proporcionarse desde otro lado, como por ejemplo desde un recurso página. Las actividades ocultas aún se encuentran listadas en el libro de calificaciones y otros reportes.';
$string['allparticipants'] = 'Todos los participantes';
$string['allteachers'] = 'Todos los profesores';
$string['alphanumerical'] = 'Sólo puede contener caracteres alfanuméricos, guión (-) o punto (.)';
$string['alreadyconfirmed'] = 'El registro ya ha sido confirmado';
$string['alternatename'] = 'Nombre alternativo';
$string['always'] = 'Siempre';
$string['and'] = '{$a->one} y {$a->two}';
$string['answer'] = 'Respuesta';
$string['any'] = 'Cualquiera';
$string['appearance'] = 'Apariencia';
$string['apply'] = 'Aplicar';
$string['applyfilters'] = 'Aplicar filtros';
$string['approve'] = 'Aprobar';
$string['areyousure'] = '¿Está seguro?';
$string['areyousuretorestorethis'] = '¿Está seguro de que desea continuar?';
$string['areyousuretorestorethisinfo'] = 'Más adelante en este proceso tendrá la opción de agregar esta copia a otro curso o utilizarla para crear un curso completamente nuevo.';
$string['asc'] = 'Ascendente';
$string['assessment'] = 'Evaluación';
$string['assignadmins'] = 'Asignar administradores';
$string['assigncreators'] = 'Asignar creadores';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Asignar roles para todo el sitio';
$string['authenticateduser'] = 'Usuario identificado';
$string['authenticateduserdescription'] = 'Todos los usuarios identificados.';
$string['authentication'] = 'Identificación';
$string['authenticationplugins'] = 'Extensiones (plugins) de identificación';
$string['autosubscribe'] = 'Subscripción automática al foro';
$string['autosubscribeno'] = 'No: no me suscriba automáticamente a los foros';
$string['autosubscribeyes'] = 'Sí: cuando envíe un mensaje suscríbame a ese foro';
$string['availability'] = 'Disponibilidad';
$string['availablecourses'] = 'Cursos disponibles';
$string['back'] = 'Atrás';
$string['backto'] = 'Regresar a {$a}';
$string['backtocourselisting'] = 'Volver a la lista de cursos';
$string['backtohome'] = 'Regresar a la página inicial del sitio';
$string['backtopageyouwereon'] = 'Volver a la página de procedencia';
$string['backup'] = 'Copia de seguridad';
$string['backupactivehelp'] = 'Decida si se hacen o no copias de seguridad automatizadas';
$string['backupadhocpending'] = 'Tarea pendiente ad hoc de respaldo del curso';
$string['backupcancelled'] = 'Copia de seguridad cancelada';
$string['backupcoursefileshelp'] = 'Si se activa, los archivos del curso se incluirán en copias de seguridad automatizadas';
$string['backupdate'] = 'Fecha de la copia de seguridad';
$string['backupdatenew'] = '{$a->TAG} es ahora {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} fue {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Detalles de la copia de seguridad';
$string['backuperrorinvaliddestination'] = 'La carpeta destino de la copia de seguridad no existe o no se puede escribir.';
$string['backupexecuteathelp'] = 'Decida a qué hora se realizarán las copias de seguridad automatizadas';
$string['backupfailed'] = 'Algunos de sus cursos no se han guardado.';
$string['backupfilename'] = 'copia de seguridad';
$string['backupfinished'] = 'Copia de seguridad completada con éxito';
$string['backupfromthissite'] = '¿Se ha hecho copia de seguridad en el sitio?';
$string['backupgradebookhistoryhelp'] = 'Si está habilitada la opción, la historia del libro de calificaciones se incluirá en las copias de seguridad automatizadas. Advierta que la historia de calificaciones no debe estar desactivada en los ajustes del servidor (disablegradhistory) para que esta característica funcione.';
$string['backupincludemoduleshelp'] = 'Seleccione si desea incluir los módulos, con o sin los datos de usuario, en las copias de seguridad';
$string['backupincludemoduleuserdatahelp'] = 'Decida si quiere incluir datos del usuario del módulo en las copias de seguridad automatizadas.';
$string['backupinfo'] = 'Hacer una copia de este curso, incluyendo todo el contenido y las actividades actualizadas. Usted puede usar el archivo de la copia de seguridad para restaurar el curso.';
$string['backuplogdetailed'] = 'Registro de ejecución detallado';
$string['backuploglaststatus'] = 'Último registro de ejecución';
$string['backupmissinguserinfoperms'] = 'Nota: Esta copia de seguridad no contiene datos de usuarios. Las actividades de Ejercicio y Taller no se incluirán en la copia de seguridad, puesto que estos módulos no son compatibles con este tipo de copia.';
$string['backupnext'] = 'Siguiente copia de seguridad';
$string['backupnonisowarning'] = 'ATENCIÓN: esta copia de respaldo proviene de una versión de Moodle no Unicode (anterior a la 1.6). Si la copia contiene cualquier texto que no sea ISO-8859-1 puede CORROMPERSE si intenta restaurarla a esta versión Unicode de Moodle.
Puede consultar <a href="https://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> para más información acerca de cómo recuperar esta copia de seguridad correctamente.';
$string['backupnotyetrun'] = 'Copia de seguridad automática pendiente';
$string['backuporiginalname'] = 'Nombre de la copia de seguridad';
$string['backuproleassignments'] = 'Copia de seguridad de las asignaciones de rol de estos roles';
$string['backupsavetohelp'] = 'Ruta completa del directorio en el que desea que se guarden las copias de seguridad';
$string['backupsitefileshelp'] = 'Si se activa esta opción, los archivos del sitio usados en los cursos se incluirán en copias de seguridad automatizadas';
$string['backuptakealook'] = 'Por favor, examine los registros de su copia de seguridad en: {$a}';
$string['backupuserfileshelp'] = 'Seleccione si desea incluir los archivos personales de los usuarios (e.g., imágenes) en la copia de seguridad';
$string['backupversion'] = 'Versión de la copia de seguridad';
$string['badges'] = 'Insignias';
$string['between'] = 'Entre';
$string['block'] = 'Bloque';
$string['blockconfiga'] = 'Configurando un bloque {$a}';
$string['blockconfigbad'] = 'Este bloque no se ha implementado correctamente y por consiguiente no se puede proporcionar una interfaz de configuración.';
$string['blocks'] = 'Bloques';
$string['blocks_main'] = 'Bloques de contenido principales';
$string['blocks_supplementary'] = 'Bloques suplementarios';
$string['blocksaddedit'] = 'Añadir/Editar bloques';
$string['blockseditoff'] = 'Desactivar la edición de bloques';
$string['blocksediton'] = 'Activar la edición de bloques';
$string['blocksetup'] = 'Configurando tablas de bloque';
$string['blocksuccess'] = 'Las tablas de {$a} han sido instaladas correctamente';
$string['brief'] = 'Resumen';
$string['bulkactions'] = 'Acciones masivas';
$string['bulkactionselect'] = '{$a} selección acción masiva';
$string['bulkcancel'] = 'Cerrar edición masiva';
$string['bulkmovecoursessuccess'] = 'Movidos con éxito {$a->courses} cursos a {$a->category}';
$string['bulkselection'] = '{$a} seleccionado';
$string['bycourseorder'] = 'Por orden de curso';
$string['byname'] = 'por {$a}';
$string['bypassed'] = 'Evitado';
$string['cachecontrols'] = 'Controles de caché';
$string['calltofeedback'] = 'A los creadores de este programa les gustaría conocer su opinión.';
$string['calltofeedback_give'] = 'Opinar sobre este software';
$string['calltofeedback_remind'] = 'Recordarme luego';
$string['cancel'] = 'Cancelar';
$string['cancelled'] = 'Cancelado';
$string['categories'] = 'Categorías';
$string['categoriesandcourses'] = 'Categorías de cursos y cursos';
$string['category'] = 'Categoría';
$string['categoryadded'] = 'Se instaló la categoría \'{$a}\'';
$string['categorybulkaction'] = 'Acciones masivas sobre las categorías seleccionadas';
$string['categorycontents'] = 'Subcategorías y cursos';
$string['categorycurrentcontents'] = 'Contenido de {$a}';
$string['categorydeleted'] = 'Se ha borrado la categoría \'{$a}\'';
$string['categoryduplicate'] = 'Ya existe una categoría llamada \'{$a}\'.';
$string['categoryheader'] = 'Menú de categorías';
$string['categoryhidden'] = '(oculto/s)';
$string['categorymodifiedcancel'] = 'La categoría se ha modificado. Por favor, cancele y pruebe de nuevo.';
$string['categoryname'] = 'Nombre de la categoría';
$string['categorypath'] = 'Ruta de categoría';
$string['categorysubcategoryof'] = '{$a->category} - subcategory de {$a->parentcategory}';
$string['categoryupdated'] = 'La categoría \'{$a}\' ha sido actualizada';
$string['changedpassword'] = 'Contraseña actualizada';
$string['changepassword'] = 'Cambiar contraseña';
$string['changesmade'] = 'Cambios realizados';
$string['changesmadereallygoaway'] = 'Ha realizado cambios. ¿Seguro que quiere salir y perder los cambios?';
$string['changessaved'] = 'Cambios actualizados';
$string['check'] = 'Revisar';
$string['checkactual'] = 'Actual';
$string['checkall'] = 'Comprobar todo';
$string['checkerror'] = 'Error al obtener comprobación "{$a}". Compruebe la consola del navegador para más información.';
$string['checkexpected'] = 'Esperado';
$string['checkingbackup'] = 'Revisando la copia de seguridad';
$string['checkingcourse'] = 'Revisando el curso';
$string['checkingforbbexport'] = 'Comprobando exportación a Blackboard';
$string['checkinginstances'] = 'Revisando casos';
$string['checkingsections'] = 'Revisando secciones';
$string['checklanguage'] = 'Revisar el idioma';
$string['checkloading'] = 'Obteniendo el resultado de comprobación "{$a}"';
$string['checknone'] = 'No comprobar nada';
$string['checks'] = 'Comprobaciones';
$string['checksok'] = 'Todas las comprobaciones \'{$a}\' correctas';
$string['childcoursenotfound'] = '¡Curso secundario no encontrado!';
$string['childcourses'] = 'Cursos hijo';
$string['choose'] = 'Elegir';
$string['choosecourse'] = 'Seleccione un curso';
$string['choosedots'] = 'Elegir...';
$string['chooselivelogs'] = 'o vea la actividad actual';
$string['chooselogs'] = 'Seleccione los registros que desea ver';
$string['choosereportfilter'] = 'Elegir un filtro para el informe';
$string['choosetheme'] = 'Elegir tema gráfico';
$string['chooseuser'] = 'Seleccionar un usuario';
$string['city'] = 'Ciudad';
$string['cleaningtempdata'] = 'Borrando archivos temporales';
$string['clear'] = 'Limpiar';
$string['clearall'] = 'Limpiar todo';
$string['clearfilterrow'] = 'Eliminar filtro de fila';
$string['clearfilters'] = 'Limpiar filtros';
$string['clearsearch'] = 'Limpiar datos de búsqueda';
$string['clickhelpiconformoreinfo'] = '...continúa... Haga clic en el icono de ayuda para leer el artículo completo';
$string['clickhere'] = 'Clic aquí...';
$string['clicktohideshow'] = 'Clic para expandir o colapsar';
$string['closeblockdrawer'] = 'Cerrar cajón del bloque';
$string['closebuttontitle'] = 'Cerrar';
$string['closecourseindex'] = 'Cerrar el índice del curso';
$string['closedrawer'] = 'Cerrar caja';
$string['closewindow'] = 'Cerrar esta ventana';
$string['collapse'] = 'Colapsar';
$string['collapseall'] = 'Colapsar todo';
$string['collapsecategory'] = 'Colapsar {$a}';
$string['comebacklater'] = 'Por favor vuelva más tarde.';
$string['commentincontext'] = 'Encontrar este comentario en el contexto';
$string['comments'] = 'Comentarios';
$string['commentscount'] = 'Comentarios ({$a})';
$string['commentsnotenabled'] = 'La característica de Comentarios no está habilitada';
$string['commentsrequirelogin'] = 'Necesita identificarse para ver los comentarios.';
$string['comparelanguage'] = 'Comparar y editar el presente idioma';
$string['complete'] = 'Completado';
$string['completed'] = 'Completado';
$string['completereport'] = 'Informe completo';
$string['configuration'] = 'Configuración';
$string['confirm'] = 'Confirmar';
$string['confirmaccount'] = 'Confirmar cuenta';
$string['confirmcheckfull'] = '¿Está totalmente seguro que quiere confirmar {$a}?';
$string['confirmcoursemove'] = '¿Está seguro de que desea mover este curso ({$a->course}) a esta categoría ({$a->category})?';
$string['confirmdeletesection'] = '¿Está absolutamente seguro que desea borrar completamente "{$a}" y todas las actividades que contiene?';
$string['confirmed'] = 'Registro confirmado';
$string['confirmednot'] = 'Su registro no se ha confirmado aún. Por favor compruebe su correo electrónico.';
$string['considereddigitalminor'] = 'Es muy joven para crear una cuenta en esta página.';
$string['contactsbyrolelist'] = '{$a->role}: {$a->contacts}';
$string['content'] = 'Contenido';
$string['contentbank'] = 'Banco de contenido';
$string['contentexport_aboutthiscourse'] = 'Resumen del curso';
$string['contentexport_coursesummary'] = 'Este archivo es parte del contenido descargado de <a href="{$a->courselink}">{$a->coursename}</a>.';
$string['contentexport_footersummary'] = 'Este archivo es parte del contenido descargado de <a href="{$a->courselink}">{$a->coursename}</a> por {$a->userfullname} el {$a->date}.';
$string['contentexport_modulesummary'] = 'Este archivo descargado forma parte del contenido de <a href="{$a->modulelink}">{$a->modulename}</a> el {$a->date}. Tenga en cuenta que contenido o archivos con tamaño superior a  {$a->maxfilesize} no serán descargados.';
$string['contentexport_viewfilename'] = 'Visualizar el archivo {$a}';
$string['context'] = 'Contexto';
$string['contextlevel'] = 'Nivel de contexto';
$string['contextname'] = 'Nombre de contexto';
$string['contextparent'] = 'Padre';
$string['contexturl'] = 'URL de contexto';
$string['continue'] = 'Continuar';
$string['continuetocourse'] = 'Haga clic aquí para entrar a su curso';
$string['convertingwikitomarkdown'] = 'Convirtiendo Wiki a Markdown';
$string['cookiesenabled'] = 'Las \'Cookies\' deben estar habilitadas en su navegador';
$string['cookiesenabled_help'] = '<p>Este sitio utiliza dos "cookies".</p>

<p>La cookie esencial es la de sesión, normalmente llamada <b>MoodleSession</b>.
Debe permitir que su navegador la acepte para poder mantener el servicio
funcionando mientras navega el sitio. Cuando sale de la plataforma o cierra su navegador la \'cookie\' se destruye (en su navegador y en el servidor).</p>

<p>La otra \'cookie\', normalmente llamada <b>MOODLEID</b> o similar, es para su comodidad. Se limita a recordar su nombre de usuario dentro del navegador. Esto significa que cuando regresa al sitio, se escribirá automáticamente su nombre en el campo nombre de usuario
Si desea mayor seguridad no utilice esta opción: sólo tendrá que escribir su nombre manualmente cada vez que quiera ingresar.</p>';
$string['cookiesenabled_help_html'] = 'Este sitio web utiliza dos cookies:<br/><br/>

La cookie esencial es la cookie de sesión, normalmente llamada MoodleSession. Debe permitir esta cookie en su navegador para dar continuidad y permanecer conectado mientras navega por el sitio. Cuando cierre la sesión o cierre el navegador, esta cookie se borra (en el navegador y en el servidor).<br/><br/>

La otra cookie es puramente por conveniencia, normalmente llamada MOODLEID o similar. Esta solo recuerda su nombre de usuario en el navegador. Esto significa que cuando regrese a este sitio, el campo de nombre de usuario en la página de inicio de sesión ya estará completado. Es seguro rechazar esta cookie - solo tendrá que volver a escribir su nombre de usuario cada vez que inicie sesión.';
$string['cookiesenabledonlysession'] = 'Las \'Cookies\' deben estar habilitadas en su navegador';
$string['cookiesenabledonlysession_help'] = 'Este sitio usa una cookie de sesión, generalmente llamada MoodleSession. Debe permitir esta cookie en su navegador para proporcionar continuidad y mantenerse conectado al navegar por el sitio. Cuando salga del sitio o cierre el navegador, esta cookie es destruida (en su navegador y en el servidor).';
$string['cookiesnotenabled'] = 'Las \'cookies\' no están habilitadas en su navegador';
$string['cookiesnotice'] = 'Aviso de Cookies';
$string['copy'] = 'copia';
$string['copyasnoun'] = 'copia';
$string['copycourse'] = 'Copiar curso';
$string['copyingcoursefiles'] = 'Copiando los archivos del curso';
$string['copyingsitefiles'] = 'Copiando los archivos del sitio usados en el curso';
$string['copyinguserfiles'] = 'Copiando los archivos de los usuarios';
$string['copyingzipfile'] = 'Copiando archivo zip';
$string['copyrightnotice'] = 'Copyright';
$string['copytoclipboard'] = 'Copiar al portapapeles';
$string['coresystem'] = 'Sistema';
$string['cost'] = 'Coste';
$string['costdefault'] = 'Costo por defecto';
$string['count_of_total'] = '<strong>{$a->count}</strong> de {$a->total}';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'País';
$string['course'] = 'Curso';
$string['courseadministration'] = 'Administración del curso';
$string['courseapprovedemail'] = 'El curso que ha solicitado ha sido aprobado, <a href="{$a->url}">{$a->name}</a>, y usted es {$a->teacher}.';
$string['courseapprovedemail2'] = 'El curso que ha solicitado ha sido aprobado: <a href="{$a->url}">{$a->name}</a>.';
$string['courseapprovedfailed'] = '¡No se ha podido guardar su curso como aprobado!';
$string['courseapprovedsubject'] = 'Su curso ha sido autorizado.';
$string['courseavailable'] = 'Este curso está disponible para los estudiantes';
$string['courseavailablenot'] = 'Este curso no está disponible para los estudiantes';
$string['coursebackup'] = 'Copia de seguridad del curso';
$string['coursebulkaction'] = 'Acciones masivas sobre los cursos seleccionados';
$string['coursecategories'] = 'Categorías de cursos';
$string['coursecategory'] = 'Categoría de cursos';
$string['coursecategory_help'] = 'Este ajuste determina la categoría en la que aparecerá el curso en la lista de cursos.';
$string['coursecategorydeleted'] = 'Eliminada la categoría de curso {$a}';
$string['coursecatmanagement'] = 'Gestión de cursos y categorías';
$string['coursecompletion'] = 'Finalización del curso';
$string['coursecompletions'] = 'Finalizaciones del curso';
$string['coursecreators'] = 'Creador de curso';
$string['coursecreatorsdescription'] = 'Los creadores de cursos pueden crear nuevos cursos.';
$string['coursedeleted'] = 'Eliminado el curso {$a}';
$string['coursedetails'] = 'Detalles del curso';
$string['coursedisplay'] = 'Paginación del curso';
$string['coursedisplay_help'] = 'Las secciones del curso se pueden mostrar en una página o se distribuyen en varias páginas.';
$string['coursedisplay_multi'] = 'Mostrar una sección por página';
$string['coursedisplay_single'] = 'Mostrar todas las secciones en una página';
$string['courseduration'] = 'Duración del curso';
$string['courseduration_desc'] = 'La duración del curso es usada para calcular por defecto la fecha de finalización del curso. La fecha de fin de curso solamente es usada para determinar cuando un curso debe ser incluido en un listado de cursos de un usuario. También puede ser usada para reportes personalizados. Los usuarios pueden ingresar al curso después de la fecha de finalización.';
$string['courseenddateenabled'] = 'Fecha de finalización del curso habilitada por defecto';
$string['courseenddateenabled_desc'] = 'Esta configuración determina si la fecha de finalización del curso se habilitará de manera predeterminada para los cursos nuevos y se establecerá en la fecha calculada a partir de la duración del curso.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Archivos heredados del curso';
$string['coursefilesedit'] = 'Editar archivos heredados del curso';
$string['coursefileswarning'] = 'Los archivos del curso están en desuso';
$string['coursefileswarning_help'] = 'Los archivos del curso están en desuso desde Moodle 2.0; por favor, utilice repositorios externos en su lugar cuanto le sea posible.';
$string['courseformatdata'] = 'Datos de formato del curso';
$string['courseformatoptions'] = 'Opciones de formato para {$a}';
$string['courseformats'] = 'Formatos de curso';
$string['courseformatudpate'] = 'Actualización de formato';
$string['coursegrades'] = 'Calificaciones del curso';
$string['courseheader'] = 'Menú de Curso';
$string['coursehelpcategory'] = 'Coloque el curso en el listado de cursos a fin de facilitar el acceso a los estudiantes.';
$string['coursehelpforce'] = 'Forzar el modo de grupo en el curso para todas las actividades del curso.';
$string['coursehelpformat'] = 'La portada del curso se mostrará en este formato.';
$string['coursehelphiddensections'] = 'Cómo se mostrarán a los estudiantes las secciones ocultas del curso.';
$string['coursehelpmaximumupload'] = 'Definir el tamaño máximo de los archivos que los estudiantes pueden subir a este curso, limitado por el ajuste general del sitio.';
$string['coursehelpnewsitemsnumber'] = 'Número de anuncios recientes del Foro de Novedades que aparecen en el bloque de Últimas noticias en la página del curso.  Si se indica cero, el Foro de Novedades no será creado.';
$string['coursehelpnumberweeks'] = 'Número de secciones en el curso (aplicable solo a ciertos formatos de curso).';
$string['coursehelpshowgrades'] = 'Activa la presentación del libro de calificaciones. No impide que las calificaciones se muestren dentro de las actividades individuales.';
$string['coursehidden'] = 'Este curso no es accesible de momento a los estudiantes';
$string['courseinfo'] = 'Información del curso';
$string['courselegacyfiles'] = 'Archivos de curso heredados';
$string['courselegacyfiles_help'] = 'El área de archivos del curso proporciona cierta compatibilidad hacia atrás con las versiones de Moodle 1.9 y anteriores. Todos los archivos de este área son siempre accesibles a todos los participantes en el curso (tanto si enlaza a ellos como si no) y no hay manera de saber dónde se pueden estar usando en Moodle cualquiera de estos archivos.

Si utiliza este área para almacenar archivos de curso, puede exponerse a una serie de riesgos de privacidad y de seguridad, así como a la pérdida de archivos en las copias de seguridad, en las importaciones de cursos o cada vez que el contenido del curso sea compartido o reutilizado. Por ello se recomienda que no utilice esta área a menos que realmente sepa lo que está haciendo.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Archivos del curso heredados: {$a}';
$string['coursenotaccessible'] = 'Este curso no permite acceso público';
$string['courseoverview'] = 'Vista general del curso';
$string['courseoverviewfiles'] = 'Archivos del resumen del curso';
$string['courseoverviewfiles_help'] = 'El archivo de imagen del curso se muestra en "Mis cursos" y en la lista de cursos disponibles en la página principal. Los administradores del sitio pueden permitir tipos de archivo adicionales y el uso de múltiples archivos. Si usa múltiples archivos, se mostrarán todos en la lista de cursos disponibles en la página principal.';
$string['courseoverviewfilesext'] = 'Extensiones de los archivos de resumen del curso';
$string['courseoverviewfileslimit'] = 'Límite de archivos en el resumen del curso';
$string['courseoverviewgraph'] = 'Gráfico global del curso';
$string['courseprofiles'] = 'Perfiles de curso';
$string['coursereasonforrejecting'] = 'Razones para rechazar esta solicitud';
$string['coursereasonforrejectingemail'] = 'Esto se enviará al solicitante';
$string['coursereject'] = 'Rechazar solicitud de curso';
$string['courserejected'] = 'El curso ha sido rechazado y así se ha notificado al solicitante.';
$string['courserejectemail'] = 'Lo sentimos, el curso solicitado ha sido rechazado por la siguiente razón:

{$a}';
$string['courserejectreason'] = 'Escriba sus razones para rechazar este curso<br />(serán enviadas al solicitante)';
$string['courserejectsubject'] = 'Su curso ha sido rechazado';
$string['coursereport'] = 'Informe de curso';
$string['coursereports'] = 'Informes del curso';
$string['courserequest'] = 'Solicitud de curso';
$string['courserequestdetails'] = 'Detalles del curso que solicita';
$string['courserequestfailed'] = 'Por alguna razón desconocida, su solicitud de curso no ha podido guardarse';
$string['courserequestintro'] = 'Utilice este formulario para solcitar la creación de un curso.<br />Suministre toda la información posible para facilitar<br />a los administradores la comprensión de las razones por las que solicita el curso.';
$string['courserequestreason'] = 'Razones para solicitar el curso';
$string['courserequestroleerror'] = 'El rol de creador en la configuración de nuevos cursos no es válido. Por favor, consulte <a href="{$a}">políticas de usuario</a>.';
$string['courserequestsuccess'] = 'Su solicitud de curso se ha guardado con éxito.';
$string['courserequestsupport'] = 'Información de apoyo para ayudar al administrador a evaluar esta solicitud';
$string['courserequestwarning'] = 'El usuario que solicite este curso será automáticamente matriculado y se le asignará el rol de {$a}.';
$string['courserestore'] = 'Restaurar curso';
$string['coursereuse'] = 'Reutilización de curso';
$string['coursereusenavigationmenu'] = 'Reutilización del curso de menú de navegación';
$string['courses'] = 'Cursos';
$string['coursesectionsummaries'] = 'Resúmenes de sección del curso';
$string['coursesectiontitle'] = '{$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitlebulkediting'] = 'Editar masivamente {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Editar {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'Ajustes por defecto del curso';
$string['coursesmovedout'] = 'Cursos apartados de {$a}';
$string['coursespending'] = 'Cursos pendientes de aprobación';
$string['coursestart'] = 'Comienzo del curso';
$string['coursesummary'] = 'Resumen del curso';
$string['coursesummary_help'] = 'Una breve descripción de su curso. Se podrá buscar por el contenido añadido aquí.';
$string['coursetitle'] = 'Curso: {$a->course}';
$string['coursetitlebulkediting'] = 'Editar masivamente curso: {$a->course}';
$string['coursetitleediting'] = 'Editar curso: {$a->course}';
$string['courseupdates'] = 'Actualizaciones de cursos';
$string['coursevisibility'] = 'Visibilidad del curso';
$string['coursevisibility_help'] = '* Mostrar: El curso aparece en la lista de cursos y los estudiantes pueden acceder a él.
* Ocultar: Acceso restringido a profesores y usuarios con permiso para ver cursos ocultos.';
$string['create'] = 'Crear';
$string['createaccount'] = 'Crear cuenta';
$string['createcategory'] = 'Crear categoría';
$string['createfolder'] = 'Crear un directorio en {$a}';
$string['createnew'] = 'Crear nuevo';
$string['createnewcategory'] = 'Crear nueva categoría';
$string['createnewcourse'] = 'Crear nuevo curso';
$string['createnewsubcategory'] = 'Crear nueva subcategoría';
$string['createsubcategoryof'] = 'Crear subcategoría de {$a}';
$string['createuser'] = 'Crear usuario';
$string['createziparchive'] = 'Crear archivo zip';
$string['creatingblocks'] = 'Creando bloques';
$string['creatingblocksroles'] = 'Creando asignaciones y anulaciones de rol en nivel de bloque';
$string['creatingblogsinfo'] = 'Creando información de blogs';
$string['creatingcategoriesandquestions'] = 'Creando categorías y preguntas';
$string['creatingcoursemodules'] = 'Creando módulos de curso';
$string['creatingcourseroles'] = 'Creando asignaciones y anulaciones de rol en nivel de curso';
$string['creatingevents'] = 'Creando eventos';
$string['creatinggradebook'] = 'Creando libro de calificaciones';
$string['creatinggroupings'] = 'Creando agrupamientos';
$string['creatinggroupingsgroups'] = 'Agregando grupos a agrupamientos';
$string['creatinggroups'] = 'Creando grupos';
$string['creatinglogentries'] = 'Creando entradas de registro';
$string['creatingmessagesinfo'] = 'Creando información sobre mensajes';
$string['creatingmodroles'] = 'Creando asignaciones y anulaciones de rol en nivel de módulo';
$string['creatingnewcourse'] = 'Creando nuevo curso';
$string['creatingrolesdefinitions'] = 'Creando definiciones de roles';
$string['creatingscales'] = 'Creando escalas';
$string['creatingsections'] = 'Creando secciones';
$string['creatingtemporarystructures'] = 'Creando estructuras temporales';
$string['creatinguserroles'] = 'Creando asignaciones y anulaciones de rol en nivel de usuario';
$string['creatingusers'] = 'Creando usuarios';
$string['creatingxmlfile'] = 'Creando el archivo XML';
$string['currency'] = 'Moneda';
$string['currentcourse'] = 'Curso actual';
$string['currentcourseadding'] = 'Curso actual, agregando información';
$string['currentcoursedeleting'] = 'Curso actual, borrando primero';
$string['currentlanguage'] = 'Idioma actual';
$string['currentlocaltime'] = 'su hora local';
$string['currentpicture'] = 'Imagen actual';
$string['currentrelease'] = 'Información de la versión';
$string['currenttheme'] = 'Tema actual';
$string['currentversion'] = 'Versión';
$string['databasechecking'] = 'Actualizando la base de datos de Moodle desde la versión {$a->oldversion} a {$a->newversion}';
$string['databaseperformance'] = 'Rendimiento de la base de datos';
$string['databasesetup'] = 'Configurando la base de datos';
$string['databasesuccess'] = 'La base de datos se ha actualizado satisfactoriamente';
$string['databaseupgradebackups'] = 'La versión de la copia de seguridad es {$a}';
$string['databaseupgradeblocks'] = 'La versión de los bloques es {$a}';
$string['databaseupgradegroups'] = 'La versión de los grupos es {$a}';
$string['databaseupgradelocal'] = 'La versión de personalización de la base de datos local es ahora {$a}';
$string['databaseupgrades'] = 'Actualizando la base de datos';
$string['dataformats'] = 'Formatos de datos';
$string['date'] = 'Fecha';
$string['datechanged'] = 'Fecha cambiada';
$string['datemostrecentfirst'] = 'Fecha - primero el más reciente';
$string['datemostrecentlast'] = 'Fecha - último el más reciente';
$string['datetimefilterafter'] = '{$a->title} después de';
$string['datetimefilterbefore'] = '{$a->title} antes de';
$string['day'] = 'día';
$string['days'] = 'días';
$string['decodinginternallinks'] = 'Decodificando enlaces internos';
$string['default'] = 'Por defecto';
$string['defaultcategoryname'] = 'Categoría 1';
$string['defaultcompetencescale'] = 'Escala de competencia por defecto';
$string['defaultcompetencescaledesc'] = 'Una escala de valoración binaria que no proporciona ninguna información adicional más allá de si alguien ha demostrado competencia o no.';
$string['defaultcompetencescalenotproficient'] = 'No competente aún';
$string['defaultcompetencescaleproficient'] = 'Competente';
$string['defaultcoursestudent'] = 'Estudiante';
$string['defaultcoursestudentdescription'] = 'Los estudiantes tienen por lo general menos privilegios dentro de un curso.';
$string['defaultcoursestudents'] = 'Estudiantes';
$string['defaultcoursesummary'] = 'Escriba aquí la descripción del curso';
$string['defaultcourseteacher'] = 'Profesor';
$string['defaultcourseteacherdescription'] = 'Los profesores pueden realizar cualquier acción dentro de un curso, incluyendo cambiar actividades y calificar a los estudiantes.';
$string['defaultcourseteachers'] = 'Profesores';
$string['defaulteditor'] = 'Editor por defecto';
$string['defaulthomepageuser'] = 'Página de Inicio';
$string['defaulthomepageuser_help'] = '¿A qué página debe ser redirigido después de iniciar sesión en el sitio?';
$string['delete'] = 'Borrar';
$string['deleteablock'] = 'Eliminar un bloque';
$string['deleteall'] = 'Borrar todo';
$string['deleteallcannotundo'] = 'Eliminar todo (no se puede deshacer)';
$string['deleteallcomments'] = 'Todos los comentarios';
$string['deleteallratings'] = 'Todas las valoraciones';
$string['deletecategory'] = 'Eliminar categoría: {$a}';
$string['deletecategorycheck'] = '¿Está totalmente seguro que quiere eliminar por completo la categoría <b>\'{$a}\'</b>?<br /> Esta acción trasladará todos los cursos a la categoría padre (si existe) o a Miscelánea.';
$string['deletecategorycheck2'] = 'Si elimina esta categoría, necesita decidir qué hacer con los cursos y subcategorías que contiene.';
$string['deletecategoryempty'] = 'Esta categoría está vacía';
$string['deletecheck'] = '¿ Borrar {$a} ?';
$string['deletecheckfiles'] = '¿Está totalmente seguro que quiere borrar estos archivos?';
$string['deletecheckfull'] = '¿Está totalmente seguro que quiere borrar al usuario {$a}, incluyendo sus matriculaciones, pertenencia a grupos y cohortes y algunos datos de su actividad?';
$string['deletechecktype'] = '¿Está seguro que quiere borrar esto {$a->type}?';
$string['deletechecktypename'] = '¿Está seguro que quiere borrar el/la {$a->type}  "{$a->name}"?';
$string['deletecheckwarning'] = 'Está a punto de borrar estos archivos';
$string['deletecommentbyon'] = 'Borrar el comentario publicado por  {$a->user} el {$a->time}';
$string['deletecompletely'] = 'Borrado';
$string['deletecourse'] = 'Borrar curso';
$string['deletecoursecheck'] = '¿Está totalmente seguro que quiere borrar definitivamente este curso y toda la información que contiene?';
$string['deleted'] = 'Borrado';
$string['deletedactivity'] = 'Se ha borrado {$a}';
$string['deletedcourse'] = '{$a} se ha borrado satisfactoriamente';
$string['deletednot'] = 'No se pudo borrar {$a}.';
$string['deletepicture'] = 'Borrar';
$string['deletesection'] = 'Borrar';
$string['deleteselected'] = 'Borrar seleccionado';
$string['deleteselectedkey'] = 'Eliminar clave seleccionada';
$string['deletingcourse'] = 'Borrando {$a}';
$string['deletingexistingcoursedata'] = 'Borrando datos del curso';
$string['deletingolddata'] = 'Borrando datos antiguos';
$string['department'] = 'Departamento';
$string['deprecatedeventname'] = '{$a} (caducado)';
$string['desc'] = 'Descendente';
$string['description'] = 'Descripción';
$string['deselectall'] = 'No seleccionar ninguno';
$string['deselectnos'] = 'Deseleccionar todos los \'No\'';
$string['detailedless'] = 'Menos detalle';
$string['detailedmore'] = 'Más detalle';
$string['details'] = 'Detalles';
$string['digitalminor'] = 'Menor digital';
$string['digitalminor_desc'] = 'Por favor solicitar a su padre o tutor que contacte a:';
$string['directory'] = 'Directorio';
$string['disable'] = 'Deshabilitar';
$string['disabledcomments'] = 'Los comandos están desactivados';
$string['dismissnotification'] = 'Descartar esta notificación';
$string['displayingfirst'] = 'Mostrando las primeras {$a->count} {$a->things}';
$string['displayingrecords'] = 'Mostrando {$a} registros';
$string['displayingusers'] = 'Mostrando los usuarios desde {$a->start} hasta {$a->end}';
$string['displayonpage'] = 'Mostrar en página';
$string['dndcourse'] = 'Puede arrastrar y soltar este curso para alterar su clasificación o moverlo a otra categoría.';
$string['dndenabled_inbox'] = 'Puede arrastrar y soltar archivos aquí para añadirlos';
$string['dndnotsupported'] = 'La subida mediante \'drag and drop\' no está soportada';
$string['dndnotsupported_help'] = 'Su navegador no soporta la subida mediante \'drag and drop\'.Esta funcionalidad está disponible en todas las versiones recientes de Chrome, Firefox y Safari, así como en Internet Explorer versión 10 y superiores.';
$string['dndnotsupported_insentence'] = 'Eventos de arrastrar y soltar no soportados';
$string['dnduploadwithoutcontent'] = 'Esta carga de ficheros no tiene ningún contenido.';
$string['dndworkingfile'] = 'Para subir archivos, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['dndworkingfilelink'] = 'Para subir archivos o enlaces, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['dndworkingfiletext'] = 'Para subir archivos o texto, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['dndworkingfiletextlink'] = 'Para subir archivos, textos o enlaces, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['dndworkinglink'] = 'Para subir enlaces, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['dndworkingtext'] = 'Para subir textos, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['dndworkingtextlink'] = 'Para subir  textos o enlaces, arrastrar y soltarlos dentro de las secciones de los cursos';
$string['documentation'] = 'Documentación de Moodle';
$string['dontsortcategories'] = 'No ordenar categorías';
$string['dontsortcourses'] = 'No ordenar cursos';
$string['down'] = 'Abajo';
$string['download'] = 'Descargar';
$string['downloadall'] = 'Descargar todo';
$string['downloadexcel'] = 'Descargar en formato Excel';
$string['downloadfile'] = 'Descargar archivo';
$string['downloadods'] = 'Descargar en formato ODS';
$string['downloadtext'] = 'Descargar en formato de texto';
$string['doyouagree'] = '¿Ha leído y comprendido los términos y condiciones?';
$string['droptoupload'] = 'Suelte los archivos a subir aquí';
$string['duplicate'] = 'Duplicar';
$string['duplicatedmodule'] = '{$a} (copia)';
$string['duplicatedsection'] = '{$a} (copia)';
$string['edhelpaspellpath'] = 'Para usar un revisor de ortografía dentro del editor, usted DEBE tener instalado <strong>aspell 0.50</strong> o superior en su servidor, y debe especificar la ruta correcta de acceso al aspell binario. En sistemas Unix/Linux, esta ruta normalmente es <strong>/usr/bin/aspell</strong>, pero podría ser cualquiera otra.';
$string['edhelpbgcolor'] = 'Defina el color de fondo del área de edición.<br />Valores válidos son, por ejemplo: #ffffff o \'white\'';
$string['edhelpcleanword'] = 'Este ajuste activa o desactiva el filtro de formato específico Word.';
$string['edhelpenablespelling'] = 'Activa o desactiva la corrección ortográfica. Cuando está activado, <strong>aspell</strong> debe estar instalado en el servidor.';
$string['edhelpfontfamily'] = 'La propiedad familia de fuentes es una lista de nombres de fuentes y/o nombres de una familia genérica. Los nombres de la familia deben estar separados por comas.';
$string['edhelpfontlist'] = 'Defina las fuentes usadas en el menú emergente de editores.';
$string['edhelpfontsize'] = 'El tamaño por defecto de la fuente ajusta dicho tamaño. <br />Valores válidos son, por ejemplo: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Editar';
$string['edita'] = 'Editar {$a}';
$string['editcategorysettings'] = 'Editar ajustes de categoría';
$string['editcategorythis'] = 'Editar esta categoría';
$string['editcoursesettings'] = 'Editar la configuración del curso';
$string['editfiles'] = 'Editar archivos';
$string['editgroupprofile'] = 'Editar descripción del grupo';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'Este valor no puede editarse.';
$string['editmode'] = 'Modo de edición';
$string['editmyprofile'] = 'Editar perfil';
$string['editorbgcolor'] = 'Color de fondo';
$string['editorcleanonpaste'] = 'Limpiar HTML de Word al pegar';
$string['editorcommonsettings'] = 'Ajustes comunes';
$string['editordefaultfont'] = 'Fuente por defecto';
$string['editorenablespelling'] = 'Activar corrección ortográfica';
$string['editorfontlist'] = 'Lista de fuentes';
$string['editorfontsize'] = 'Tamaño de la fuente por defecto';
$string['editorpreferences'] = 'Configuración del editor';
$string['editorresettodefaults'] = 'Volver a valores por defecto';
$string['editorsettings'] = 'Ajustes del editor';
$string['editorshortcutkeys'] = 'Atajos del editor';
$string['editsection'] = 'Editar ajustes';
$string['editsectionname'] = 'Modificar nombre de sección';
$string['editsectionsettings'] = 'Editar ajustes de sección';
$string['editsectiontitle'] = 'Editar sección: {$a}';
$string['editsettings'] = 'Editar ajustes';
$string['editthisactivity'] = 'Editar esta actividad';
$string['editthiscategory'] = 'Editar esta categoría';
$string['edittitle'] = 'Editar título';
$string['edittitleinstructions'] = 'Esc para cancelar, Enter para finalizar';
$string['edituser'] = 'Editar usuario';
$string['edulevel'] = 'Todos los eventos';
$string['edulevel_help'] = '* Enseñanza - acciones realizadas por un profesor, p.e.: actualizar un recurso
* Participación - acciones realizadas por un estudiante, p.e.: enviar un mensaje a un foro
* Otro - acciones realizadas por un usuario con un rol que no es profesor o estudiante';
$string['edulevelother'] = 'Otro';
$string['edulevelparticipating'] = 'Participando';
$string['edulevelteacher'] = 'Enseñando';
$string['email'] = 'Dirección de correo';
$string['emailactive'] = 'Correo activado';
$string['emailagain'] = 'Correo (de nuevo)';
$string['emailalreadysent'] = 'Se ha enviado un correo electrónico de restablecimiento de contraseña. Por favor, consulte su buzón de correo electrónico.';
$string['emailcharset'] = 'Conjunto de caracteres para email';
$string['emailconfirm'] = 'Confirme su cuenta';
$string['emailconfirmation'] = 'Hola, {$a->firstname}.

Se ha solicitado la creación de una cuenta en "{$a->sitename}" utilizando su dirección de correo.

Para confirmar su nueva cuenta, por favor vaya a esta dirección web:

{$a->link}

En la mayoría de programas de correo electrónico, debería aparecer un enlace azul donde poder hacer clic.
Si no funciona, cópielo y péguelo en la barra de direcciones de su navegador.

Si necesita ayuda, por favor contacte con el administrador del sitio, {$a->admin}';
$string['emailconfirmationresend'] = 'Reenviar correo de confirmación';
$string['emailconfirmationsubject'] = 'Confirmación de la cuenta  {$a}';
$string['emailconfirmsent'] = '<p>Hemos enviado un correo electrónico a <b>{$a}</b></p>
<p>En él encontrará instrucciones sencillas para concluir el proceso.</p>
<p>Si tuviera alguna dificultad, contacte con el Administrador del Sistema.</p>';
$string['emailconfirmsentfailure'] = 'No se pudo enviar correo de confirmación';
$string['emailconfirmsentsuccess'] = 'Correo de confirmación enviado exitosamente';
$string['emaildigest'] = 'Tipo de resumen de correo';
$string['emaildigest_help'] = 'Este es el ajuste de resumen diario que usarán los foros por defecto.

* Sin resumen - recibirá un correo electrónico por cada mensaje del foro;
* Resumen - mensaje completo - recibirá un correo resumen por día con los contenidos completos de cada mensaje del foro;
* Resumen - solo asuntos - recibirá un correo resumen por día solo con los asuntos de cada mensaje del foro.

Puede elegir también un ajuste diferente para cada uno de los foros, si así lo desea.';
$string['emaildigestcomplete'] = 'Completo (correo diario con mensajes completos)';
$string['emaildigestoff'] = 'Sin resumen (un correo por cada mensaje del foro)';
$string['emaildigestsubjects'] = 'Por temas (correo diario sólo con temas)';
$string['emaildisable'] = 'Esta dirección de correo no está habilitada';
$string['emaildisableclick'] = 'Haga clic aquí para desactivar el envío de correo a esta dirección';
$string['emaildisplay'] = 'Visibilidad del correo electrónico';
$string['emaildisplay_help'] = '* Oculto: sólo los usuarios con los permisos correspondientes, como los profesores, pueden ver tu dirección de correo electrónico.
* Visible para todos: todos los usuarios del sitio pueden ver su dirección de correo electrónico.
* Visible para los participantes del curso - Sólo los participantes de los cursos en los que está inscrito pueden ver su dirección de correo electrónico.';
$string['emaildisplaycourse'] = 'Visible para los participantes en el curso';
$string['emaildisplaycoursemembersonly'] = '(Visible para otros participantes del curso)';
$string['emaildisplayeveryone'] = '(Visible para todos)';
$string['emaildisplayhide'] = '(Oculto a todo el mundo excepto a los usuarios con los permisos adecuados)';
$string['emaildisplayno'] = 'Oculto';
$string['emaildisplayyes'] = 'Visible para todos';
$string['emailenable'] = 'La dirección de correo está habilitada';
$string['emailenableclick'] = 'Haga clic aquí para volver a activar el envío de correo a esta dirección';
$string['emailexists'] = 'Esta dirección de correo ya está registrada.';
$string['emailexistshintlink'] = 'Recuperar nombre de usuario olvidado o contraseña';
$string['emailexistssignuphint'] = '¿Quizás creaste una cuenta en el pasado? {$a}';
$string['emailformat'] = 'Formato de correo';
$string['emailmustbereal'] = 'IMPORTANTE: Debe escribir una dirección de correo real';
$string['emailnotallowed'] = 'Las direcciones email de estos dominios no están permitidas ({$a})';
$string['emailnotfound'] = 'No se ha encontrado la dirección email en la base de datos';
$string['emailonlyallowed'] = 'Este email no se puede usar. Los dominios permitidos son: {$a}.';
$string['emailpasswordchangeinfo'] = 'Hola {$a->firstname},

Alguien (seguramente usted) ha solicitado una nueva contraseña para su
cuenta \'{$a->username}\' en \'{$a->sitename}\'.

Para cambiar su contraseña, por favor, diríjase a la siguiente dirección:

{$a->link}

En la mayoría de los programas de correo electrónico, esto aparecerá como un enlace en color azul en el que usted puede hacer clic. Si no funcionara, copie y pegue la dirección en la barra de navegación de su navegador.

Si necesita ayuda, por favor póngase en contacto con el administrador del sitio,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Hola, {$a->firstname},

Alguien (probablemente usted) ha solicitado una nueva contraseña para su cuenta en \'{$a->sitename}\'.

Desafortunadamente su cuenta en este sitio ha sido desactivada y su contraseña no puede ser reactivada. Por favor, contacte con el administrador del sitio, {$a->admin}.';
$string['emailpasswordchangeinfofail'] = 'Hola, {$a->firstname}.

Alguien (probablemente usted) ha solicitado una nueva contraseña para su cuenta en \'{$a->sitename}\'.

Desafortunadamente las contraseñas no pueden cambiarse en este sitio. Por favor, contacte con el administrador del sitio, {$a->admin}.';
$string['emailpasswordchangeinfosubject'] = '{$a}: Información sobre cambiar la contraseña';
$string['emailpasswordconfirmation'] = 'Hola, {$a->firstname}.

Recibimos la solicitud de nueva contraseña para su cuenta
en \'{$a->sitename}\'.

Para concluir el proceso y poder enviarle una nueva contraseña por correo,
diríjase a la siguiente dirección:

{$a->link}

En la mayoría de programas de correo electrónico el
enlace anterior debería aparecer en azul y puede hacer
clic sobre él. Si no funcionara, cópielo y péguelo en la
ventana de direcciones de su navegador.

Si necesita ayuda adicional, póngase en contacto con el
administrador, {$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: confirmación de cambio de contraseña';
$string['emailpasswordconfirmmaybesent'] = '<p>Si ha suministrado un nombre de usuario correcto o dirección de correo electrónico única, se le debería haber enviado un correo electrónico.</p>
<p>Contiene instrucciones sencillas para confirmar y completar este cambio de contraseña. Si sigue teniendo problemas, por favor contacte con el administrador del sitio.</p>';
$string['emailpasswordconfirmnoemail'] = '<p> La cuenta de usuario que ha especificado no tiene una dirección de correo electrónico registrada. </p><p> Por favor, póngase en contacto con el administrador del sitio. </p>';
$string['emailpasswordconfirmnotsent'] = '<p> Los datos de usuario que ha introducido no identifican una cuenta de usuario existente. </p><p> Compruebe la información introducida por favor y vuelva a intentarlo. Si continúa teniendo problemas, por favor póngase en contacto con el administrador del sitio. </p>';
$string['emailpasswordconfirmsent'] = 'Hemos enviado un correo a su dirección <b>{$a}</b>.
<p>Este mensaje contiene instrucciones sencillas para completar y confirmar el cambio de contraseña.
Si tuviera alguna dificultad, contacte con el Administrador.</p>';
$string['emailresetconfirmation'] = 'Hola, {$a->firstname}.

Se ha solicitado un restablecimiento de contraseña para su cuenta \'{$a->username}\' en {$a->sitename}.

Para confirmar esta petición y establecer una nueva contraseña para su cuenta, por favor, vaya a la siguiente dirección de Internet:
<a href="{$a->link}">{$a->link}</a>

(Este enlace es válido durante  {$a->resetminutes} minutos desde el momento en que hizo la solicitud por primera vez.

Si usted no ha solicitado este restablecimiento de contraseña, no necesita realizar ninguna acción.

Si necesita ayuda, por favor póngase en contacto con el administrador del sitio, {$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Solicitud de restablecimiento de contraseña';
$string['emailresetconfirmsent'] = 'Se ha enviado un correo electrónico a su dirección en <b>{$a}.</b> <br /> Contiene unas sencillas instrucciones para confirmar y completar el cambio de contraseña.
Si continúa teniendo problemas, póngase en contacto con el administrador del sitio.';
$string['emailstop'] = 'Desactivar notificaciones';
$string['emailtoprivatefiles'] = 'También puede enviar directamente archivos vía e-mail a esta zona de archivos privados. Simplemente adjunte sus archivos a un correo electrónico y envíelo a {$a}';
$string['emailtoprivatefilesdenied'] = 'El administrador ha desactivado la opción de subir sus propios archivos privados.';
$string['emailvia'] = '{$a->name} (vía {$a->siteshortname})';
$string['emojicategoryactivities'] = 'Actividades';
$string['emojicategoryanimalsnature'] = 'Animales y naturaleza';
$string['emojicategoryflags'] = 'Banderas';
$string['emojicategoryfooddrink'] = 'Comida y bebida';
$string['emojicategoryobjects'] = 'Objetos';
$string['emojicategorypeoplebody'] = 'Personas y cuerpo';
$string['emojicategoryrecent'] = 'Reciente';
$string['emojicategorysmileysemotion'] = 'Caritas sonrientes y emociones';
$string['emojicategorysymbols'] = 'Símbolos';
$string['emojicategorytravelplaces'] = 'Viaje y lugares';
$string['emptycmids'] = 'IDs de módulo vacío de curso';
$string['emptydragdropregion'] = 'región vacía';
$string['emptysectionids'] = 'IDs de sección vacía';
$string['enable'] = 'Habilitar';
$string['encryptedcode'] = 'Código encriptado';
$string['enddate'] = 'Fecha de finalización del curso';
$string['enddate_help'] = 'La fecha de finalización del curso no restringe el acceso de estudiantes al curso. Determina si un curso se lista como finalizado en "Mis cursos".';
$string['enddatewithtaskenabled'] = 'Fecha fin de curso';
$string['enddatewithtaskenabled_help'] = 'La fecha en que el curso se ocultará a estudiantes, que ya no podrán acceder a él.';
$string['english'] = 'Inglés';
$string['enrolmentmethods'] = 'Métodos de matriculación';
$string['entercourse'] = 'Haga clic aquí para entrar al curso';
$string['enteremail'] = 'Haga clic para entrar en este curso';
$string['enteremailaddress'] = 'Escriba su dirección de correo electrónico.
Le enviaremos una nueva contraseña.';
$string['enterusername'] = 'Escriba su nombre de usuario';
$string['entries'] = 'Entradas';
$string['error'] = 'Error';
$string['errorcreatingactivity'] = 'No se puede crear una instancia de la actividad \'{$a}\'';
$string['errorfiletoobig'] = 'El archivo era más grande que el límite de {$a} bytes';
$string['errornouploadrepo'] = 'No existe un repositorio de carga habilitados para este sitio';
$string['errorwhenconfirming'] = 'Ha ocurrido un error, por lo que usted aún no ha sido confirmado. Si llegó aquí a través de un enlace en su correo electrónico, asegúrese de que esa línea  en su correo no esté rota o cortada. De ser así, tendrá que utilizar copiar y pegar para reconstruir adecuadamente el enlace.';
$string['eventcommentcreated'] = 'Comentario creado';
$string['eventcommentdeleted'] = 'Comentario eliminado';
$string['eventcommentsviewed'] = 'Comentarios vistos';
$string['eventconfiglogcreated'] = 'Registro de configuración creado';
$string['eventcontentviewed'] = 'Contenido visto';
$string['eventcoursebackupcreated'] = 'Copia de curso creada';
$string['eventcoursecategorycreated'] = 'Categoría creada';
$string['eventcoursecategorydeleted'] = 'Categoría eliminada';
$string['eventcoursecategoryupdated'] = 'Categoría actualizada';
$string['eventcoursecategoryviewed'] = 'Categorías vistas';
$string['eventcoursecontentdeleted'] = 'Contenido del curso eliminado';
$string['eventcoursecreated'] = 'Curso creado';
$string['eventcoursedeleted'] = 'Curso eliminado';
$string['eventcourseended'] = 'Curso finalizado';
$string['eventcourseinformationviewed'] = 'Sumarios de cursos vistos';
$string['eventcoursemodulecreated'] = 'Módulo de curso creado';
$string['eventcoursemoduledeleted'] = 'Módulo de curso eliminado';
$string['eventcoursemoduleinstancelistviewed'] = 'Instancia del módulo del curso visualizada';
$string['eventcoursemoduleupdated'] = 'Módulo de curso actualizado';
$string['eventcoursemoduleviewed'] = 'Módulo de curso visto';
$string['eventcourseoverviewviewed'] = 'Página de resumen de actividades de curso vista';
$string['eventcourseresetended'] = 'Reinicio de curso finalizado';
$string['eventcourseresetstarted'] = 'Reinicio de curso iniciado';
$string['eventcourserestored'] = 'Curso restaurado';
$string['eventcoursesectioncreated'] = 'Sección del curso creada';
$string['eventcoursesectiondeleted'] = 'Sección de curso eliminada';
$string['eventcoursesectionupdated'] = 'Sección de curso actualizado';
$string['eventcoursessearched'] = 'Cursos buscados';
$string['eventcoursestarted'] = 'Curso comenzado';
$string['eventcourseupdated'] = 'Curso actualizado';
$string['eventcourseuserreportviewed'] = 'Informe usuario del curso visto';
$string['eventcourseviewed'] = 'Curso visto';
$string['eventdashboardreset'] = 'Restablecimiento del tablero de eventos';
$string['eventdashboardsreset'] = 'Restablecimiento del tablero de eventos';
$string['eventdashboardviewed'] = 'Tablero de eventos vistos';
$string['eventdatabasetextfieldcontentreplaced'] = 'Búsqueda y reemplazo en base de datos global';
$string['eventemailfailed'] = 'No se pudo enviar el correo electrónico';
$string['eventmycoursesviewed'] = 'Mis cursos vistos';
$string['eventname'] = 'Nombre evento';
$string['eventrecentactivityviewed'] = 'Actividad reciente vista';
$string['eventsearchindexed'] = 'Datos de búsqueda indexados';
$string['eventsearchresultsviewed'] = 'Resultados de búsqueda vistos';
$string['eventsectionviewed'] = 'Sección vista';
$string['eventunknownlogged'] = 'Evento desconocido';
$string['eventurlblocked'] = 'La URL fue bloqueada';
$string['eventusercreated'] = 'Usuario creado';
$string['eventuserdeleted'] = 'Usuario eliminado';
$string['eventuserfeedbackgiven'] = 'Entrar en el enlace de comentarios';
$string['eventuserfeedbackremind'] = 'Recuérdar más tarde entrar en el enlace de comentarios';
$string['eventuserinfocategorycreated'] = 'Campo de categoría de perfil de usuario creado';
$string['eventuserinfocategorydeleted'] = 'Campo de categoría de perfil de usuario eliminado';
$string['eventuserinfocategoryupdated'] = 'Campo de categoría de perfil de usuario actualizado';
$string['eventuserinfofieldcreated'] = 'Campo de perfil de usuario creado';
$string['eventuserinfofielddeleted'] = 'Campo de perfil de usuario eliminado';
$string['eventuserinfofieldupdated'] = 'Campo de perfil de usuario actualizado';
$string['eventuserlistviewed'] = 'Lista de usuarios vista';
$string['eventuserloggedout'] = 'Usuario desconectado';
$string['eventuserpasswordpolicyfailed'] = 'Fallo de contraseña de usuario por políticas de contraseña';
$string['eventuserpasswordupdated'] = 'Contraseña de usuario actualizada';
$string['eventuserprofileviewed'] = 'Perfil de usuario visto';
$string['eventuserupdated'] = 'Usuario actualizado';
$string['everybody'] = 'Todos';
$string['executeat'] = 'Ejecutar a las';
$string['existing'] = 'Existente';
$string['existingadmins'] = 'Administradores existentes';
$string['existingcourse'] = 'Curso existente';
$string['existingcourseadding'] = 'Curso existente, agregando información';
$string['existingcoursedeleting'] = 'Curso existente, borrando primero';
$string['existingcreators'] = 'Creadores existentes';
$string['existingstudents'] = 'Estudiantes inscritos';
$string['existingteachers'] = 'Profesores existentes';
$string['expand'] = 'Expandir';
$string['expandall'] = 'Expandir todo';
$string['expandcategory'] = 'Expandir {$a}';
$string['explanation'] = 'Explicación';
$string['explanationdigitalminor'] = 'Esta información es necesaria para determinar si su edad está por encima de la edad digital de consentimiento. Esta es la edad a la que un individuo puede aceptar los términos y condiciones y que sus datos sean legalmente almacenados y procesados.';
$string['extendperiod'] = 'Período de ampliación';
$string['extendsession'] = 'Extender sesión';
$string['failedloginattempts'] = '{$a->attempts} intentos de identificación fallidos desde su último acceso';
$string['failedtaskbody'] = '<p>Hola, {$a->firstname}.</p>
<p>La tarea <b>{$a->taskname}</b> ha fallado numerosas veces y requiere atención.</p>
<p><a href="{$a->link}">Ver tarea</a></p>';
$string['failedtaskcontexturlname'] = 'Informe de estado';
$string['failedtasksubject'] = 'Tarea fallida: {$a}';
$string['favourites'] = 'Destacados';
$string['feedback'] = 'Retroalimentación';
$string['file'] = 'Archivo';
$string['fileexists'] = 'Ya existe un archivo llamado {$a}';
$string['filemissing'] = 'No se encuentra {$a}';
$string['filereaderror'] = 'No se puede leer el archivo \'{$a}\' . Por favor revise que sea realmente un archivo y no una carpeta.';
$string['files'] = 'Archivos';
$string['filesanduploads'] = 'Archivos y subida';
$string['filesfolders'] = 'Archivos/directorios';
$string['fileuploadwithcontent'] = 'La carga de archivos no debe incluir el parámetro contenido';
$string['filloutallfields'] = 'Por favor rellene todos los campos de este formulario';
$string['filter'] = 'Filtro';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = 'Filtro {$a}';
$string['filters'] = 'Filtros';
$string['filtersetmatchdescription'] = 'Cómo se deben combinar varios filtros';
$string['filtertype'] = 'Tipo de filtro';
$string['findmorecourses'] = 'Encontrar más cursos...';
$string['first'] = 'Primero';
$string['firstaccess'] = 'Primer acceso';
$string['firstname'] = 'Nombre';
$string['firstnamephonetic'] = 'Nombre - fonético';
$string['firstpage'] = 'Primera página';
$string['firstsiteaccess'] = 'Primer acceso al sitio';
$string['firsttime'] = 'Registrarse como usuario';
$string['folder'] = 'Carpeta';
$string['folderclosed'] = 'Carpeta cerrada';
$string['folderopened'] = 'Carpeta abierta';
$string['followingoptional'] = 'Los siguientes datos son opcionales';
$string['followingrequired'] = 'Los siguientes datos son indispensables';
$string['for'] = 'Para';
$string['force'] = 'Forzar';
$string['forcelanguage'] = 'Forzar idioma';
$string['forceno'] = 'No forzar';
$string['forcepasswordchange'] = 'Forzar cambio de contraseña';
$string['forcepasswordchange_help'] = 'Si se marca, se avisará al usuario de que cambie su contraseña en su próximo acceso.';
$string['forcepasswordchangecheckfull'] = '¿Está totalmente seguro que quiere forzar un cambio de contraseña a {$a} ?';
$string['forcepasswordchangenot'] = 'No se pudo forzar el cambio de contraseña a {$a}';
$string['forcepasswordchangenotice'] = 'Para continuar, deberá cambiar su contraseña.';
$string['forcepasswordresetfailurenotice'] = 'Su contraseña actual ya no cumple las políticas de contraseña establecidas. Por favor contacte con su administrador de Moodle para recibir ayuda.
   {$a}';
$string['forcepasswordresetnotice'] = 'Su contraseña actual ya no cumple las políticas de contraseña. Debe cambiar su contraseña para iniciar sesión.
   {$a}';
$string['forcetheme'] = 'Forzar tema';
$string['forgotaccount'] = '¿Olvidó su contraseña?';
$string['forgotten'] = '¿Olvidó su nombre de usuario o contraseña?';
$string['forgottenduplicate'] = 'La dirección email es compartida por varias cuentas: por favor, utilice el nombre de usuario en su lugar.';
$string['forgotteninvalidurl'] = 'Contraseña no válida, reiniciar URL';
$string['format'] = 'Formato';
$string['formathtml'] = 'Formato HTML';
$string['formatmarkdown'] = 'Formato Markdown';
$string['formatplain'] = 'Formato de texto plano';
$string['formattext'] = 'Formato automático';
$string['forumpreferences'] = 'Configuración del foro';
$string['framesetinfo'] = 'Este documento contiene:';
$string['fromdate'] = 'Desde';
$string['fromsender'] = 'Desde';
$string['frontpagecategorycombo'] = 'Lista combo';
$string['frontpagecategorynames'] = 'Mostrar la lista de categorías';
$string['frontpagecourselist'] = 'Mostrar la lista de cursos';
$string['frontpagecoursesearch'] = 'Caja de texto de búsqueda en el curso';
$string['frontpagedescription'] = 'Resumen de la página principal del sitio';
$string['frontpagedescriptionhelp'] = 'Este resumen puede mostrarse en la página principal del sitio utilizando el bloque Resumen del curso/sitio.';
$string['frontpageenrolledcourselist'] = 'Cursos inscritos';
$string['frontpageformat'] = 'Formato de la página principal del sitio';
$string['frontpageformatloggedin'] = 'Formato de página principal del sitio al iniciar sesión';
$string['frontpagenews'] = 'Anuncios';
$string['frontpagesettings'] = 'Ajustes de la página principal del sitio';
$string['fulllistofcourses'] = 'Todos los cursos';
$string['fullname'] = 'Nombre completo';
$string['fullnamecourse'] = 'Nombre completo del curso';
$string['fullnamecourse_help'] = 'El nombre del curso que se muestra en "Mis cursos" y en la lista de cursos disponibles de la página principal.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Nombre completo del usuario';
$string['fullprofile'] = 'Perfil completo';
$string['fullsitename'] = 'Nombre completo del sitio';
$string['functiondisabled'] = 'Esta funcionalidad está actualmente desactivada';
$string['general'] = 'General';
$string['geolocation'] = 'latitud - longitud';
$string['gettheselogs'] = 'Conseguir estos registros';
$string['go'] = 'Ir';
$string['gobacktosite'] = 'Volver al sitio principal';
$string['gpl'] = 'Copyright (C) 1999 en adelante, Martin Dougiamas (https://moodle.com)

Este programa es software libre; usted puede redistribuirlo y /o modificarlo bajo los términos de la GNU (General Public License) publicada por The Free Software Foundation; tanto la versión 2 de la Licencia, o (a su elección) alguna posterior.

Este programa se distribuye con la esperanza de que resulte útil, pero SIN GARANTÍA ALGUNA; incluso sin la garantía implícita de DISTRIBUCIÓN MERCANTIL o AJUSTE A UN PROPÓSITO PARTICULAR.

Para más detalles, vea la página de información de Licencia de Moodle: https://moodledev.io/general/license';
$string['gpl3'] = 'Copyright (C) 1999 en adelante, Martin Dougiamas (https://moodle.com)

Este programa es software libre: usted puede redistribuirlo y/o modificarlo bajo los términos de la GNU (General Public License) publicada por la Fundación para el Software Libre, ya sea la versión 3 de dicha Licencia, o (a su elección) cualquier versión posterior.

Este programa se distribuye con la esperanza de que sea útil, pero SIN NINGUNA GARANTÍA; sin la garantía implícita de COMERCIALIZACIÓN o IDONEIDAD PARA UN PROPÓSITO PARTICULAR.

Vea la página de información de Licencia de Moodle para más detalles: https://moodledev.io/general/license';
$string['gpllicense'] = 'Licencia GPL';
$string['gradable'] = 'Evaluable';
$string['gradenoun'] = 'Calificación';
$string['grades'] = 'Calificaciones';
$string['gradeverb'] = 'Calificar';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> se ha habilitado para este sitio. Si usted no carga una imagen en su perfil, Moodle intentará cargar una imagen para su perfil desde Gravatar';
$string['group'] = 'Grupo';
$string['groupadd'] = 'Agregar nuevo grupo';
$string['groupaddusers'] = 'Agregar seleccionados al grupo';
$string['groupfor'] = 'para el grupo';
$string['groupinfo'] = 'Información sobre el grupo seleccionado';
$string['groupinfoedit'] = 'Editar ajustes de grupo';
$string['groupinfomembers'] = 'Información sobre los miembros seleccionados';
$string['groupinfopeople'] = 'Información sobre las personas seleccionadas';
$string['groupmembers'] = 'Miembros del grupo';
$string['groupmemberssee'] = 'Ver los integrantes del grupo';
$string['groupmembersselected'] = 'Miembros del grupo seleccionado';
$string['groupmode'] = 'Modo de grupo';
$string['groupmodeforce'] = 'Forzar el modo de grupo';
$string['groupmy'] = 'Mi grupo';
$string['groupnonmembers'] = 'Personas que no están en ningún grupo';
$string['groupnotamember'] = 'Lo sentimos, usted no es miembro de ese grupo';
$string['grouprandomassign'] = 'Asignar aleatoriamente a todos a grupos';
$string['groupremove'] = 'Quitar el grupo seleccionado';
$string['groupremovemembers'] = 'Quitar los miembros seleccionados';
$string['groups'] = 'Grupos';
$string['groupsnone'] = 'No hay grupos';
$string['groupsseparate'] = 'Grupos separados';
$string['groupsvisible'] = 'Grupos visibles';
$string['guest'] = 'Invitado';
$string['guestdescription'] = 'Los invitados tienen privilegios mínimos y normalmente no están autorizados para escribir.';
$string['guestskey'] = 'Permitir la matriculación a invitados con contraseña';
$string['guestsno'] = 'No admitir invitados';
$string['guestsnotallowed'] = 'Lo sentimos, \'{$a}\' no permite acceso a invitados.';
$string['guestsyes'] = 'Permitir matriculación a invitados sin contraseña';
$string['guestuser'] = 'Invitado';
$string['guestuserinfo'] = 'Este usuario sólo tiene acceso de lectura en ciertos cursos.';
$string['help'] = 'Ayuda';
$string['helpprefix2'] = 'Ayuda con {$a}';
$string['helpwiththis'] = 'Ayuda';
$string['hiddenassign'] = 'Tarea oculta';
$string['hiddenfromstudents'] = 'Ocultado a los estudiantes';
$string['hiddenoncoursepage'] = 'Disponibles pero no visibles en la página del curso';
$string['hiddensections'] = 'Secciones ocultas';
$string['hiddensections_help'] = 'Las secciones ocultas se muestran a los estudiantes como "no disponible" en la página del curso, se están completamente ocultas.';
$string['hiddensectionscollapsed'] = 'Mostrar solamente los nombres de sección';
$string['hiddensectionscollapsed_description'] = 'Se muestran los nombres de las secciones a los estudiantes, pero su contenido está oculto.';
$string['hiddensectionsinvisible'] = 'Ocultar completamente';
$string['hiddensectionsinvisible_description'] = 'Las secciones ocultas no se muestran a los estudiantes.';
$string['hiddenwithbrackets'] = '(oculto)';
$string['hide'] = 'Ocultar';
$string['hideadvancedsettings'] = 'Ocultar ajustes avanzados';
$string['hidecategory'] = '¿Ocultar categoría?';
$string['hidecategorymany'] = 'La categoría {$a->category} contiene {$a->coursecount} cursos.
<br/>Si la oculta, los usuarios sin permiso para ver categorías ocultas no tendrán acceso a estos cursos.';
$string['hidecategoryone'] = 'La categoría {$a->category} contine un curso.
<br/>Si la oculta, los usuarios sin permiso para ver categorías no podrán acceder a ese curso.';
$string['hidechartdata'] = 'Ocultar datos del gráfico';
$string['hidefromstudents'] = 'Ocultar en la página del curso';
$string['hideoncoursepage'] = 'Hacerlo disponible pero no mostrarlo en la página del curso';
$string['hidepopoverwindow'] = 'Ocultar ventana emergente';
$string['hidesection'] = 'Ocultar sección {$a}';
$string['hidesettings'] = 'Ocultar ajustes';
$string['hideshowblocks'] = 'Ocultar o mostrar bloques';
$string['highlight'] = 'Destacar';
$string['highlighted'] = 'Destacado';
$string['highlightoff'] = 'Dejar de destacar';
$string['hits'] = 'Clics';
$string['hitsoncourse'] = 'Clics de {$a->username} en {$a->coursename}';
$string['hitsoncoursetoday'] = 'Clics de hoy de {$a->username} en {$a->coursename}';
$string['home'] = 'Página Principal';
$string['homeheader'] = 'Menú de inicio';
$string['hour'] = 'hora';
$string['hours'] = 'horas';
$string['howtomakethemes'] = 'Cómo desarrollar temas';
$string['htmleditor'] = 'Use el editor de HTML';
$string['htmleditoravailable'] = 'El editor HTML está disponible';
$string['htmleditordisabled'] = 'Usted ha desactivado el editor HTML en su perfil de usuario.';
$string['htmleditordisabledadmin'] = 'El administrador ha deshabilitado el editor HTML';
$string['htmleditordisabledbrowser'] = 'El editor de HTML no está disponible porque su navegador no es compatible.';
$string['htmlfilesonly'] = 'Sólo archivos HTML';
$string['htmlformat'] = 'Formato HTML';
$string['icon'] = 'Icono';
$string['idnumber'] = 'Número de ID';
$string['idnumbercourse'] = 'Número ID del curso';
$string['idnumbercourse_help'] = 'Sólo usado para conectar el curso con sistemas externos. Déjelo en blanco si no tiene un ID oficial de curso.';
$string['idnumbercoursecategory'] = 'Número ID de la categoría';
$string['idnumbercoursecategory_help'] = 'El número de identificación ID de una categoría de cursos sólo se usa cuando se compara la categoría contra un sistema externo y no se muestra en ningún lugar del sitio. Si la categoría tiene un código oficial, este puede ser introducido, de lo contrario, el campo puede dejarse en blanco.';
$string['idnumbergroup'] = 'Número de identificación del grupo';
$string['idnumbergroup_help'] = 'El número de identificación ID de un grupo sólo se usa cuando se compara el grupo con un sistema externo, y no se muestra en ningún otro lugar del sitio. Si el grupo tiene un código oficial, entonces se puede introducir este, de lo contrario, el campo se puede dejar en blanco.';
$string['idnumbergrouping'] = 'Número de identificación del agrupamiento';
$string['idnumbergrouping_help'] = 'El número de identificación ID de un agrupamiento sólo se usa cuando se compara al agrupamiento contra un sistema externo y no se muestra en ningún otro lugar en el sitio. Si el agrupamiento tiene un código oficial se pueden introducir, de lo contrario el campo se puede dejar en blanco.';
$string['idnumbermod'] = 'Número ID';
$string['idnumbermod_help'] = 'La configuración de un número de ID proporciona una forma de identificar la actividad o el recurso para fines como el cálculo de calificaciones o informes personalizados. De lo contrario, el campo se puede dejar en blanco.

Para las actividades calificables, el número de ID también se puede configurar en el libro de calificaciones, aunque solo se puede editar en la página de configuración de la actividad.';
$string['idnumbertaken'] = 'Este número ID ya está ocupado';
$string['imagealt'] = 'Descripción de la imagen';
$string['import'] = 'Importar';
$string['importdata'] = 'Importar datos del curso';
$string['importdataexported'] = 'Datos correctamente exportados \'desde\' el curso.<br />Continúe importando \'hacia\' su curso.';
$string['importdatafinished'] = 'Importación completa. Continúe con su curso';
$string['importdatafrom'] = 'Encontrar un curso desde el que importar datos:';
$string['importinfo'] = 'Importar elementos de otros cursos, como actividades, bloques o eventos de calendario. No se importarán datos de usuarios.';
$string['inactive'] = 'Inactivo';
$string['include'] = 'Incluir';
$string['includeallusers'] = 'Incluir a todos los usuarios';
$string['includecoursefiles'] = 'Incluir los archivos del curso';
$string['includecourseusers'] = 'Incluir los usuarios del curso';
$string['included'] = 'Incluido';
$string['includelogentries'] = 'Incluir las entradas de registro';
$string['includemodules'] = 'Incluir Módulos';
$string['includemoduleuserdata'] = 'Incluir datos del usuario del módulo';
$string['includeneededusers'] = 'Incluir usuarios necesarios';
$string['includenoneusers'] = 'No incluir usuarios';
$string['includeroleassignments'] = 'Incluir asignaciones de rol';
$string['includesitefiles'] = 'Incluir archivos del sitio usados en este curso';
$string['includesubcategories'] = 'Incluir subcategorías';
$string['includeuserfiles'] = 'Incluir los archivos de los usuarios';
$string['increasesections'] = 'Aumentar el número de secciones';
$string['indicator:accessesafterend'] = 'Acceso al curso después de la fecha límite';
$string['indicator:accessesafterend_help'] = 'Este indicador refleja que el estudiante accedió al curso después de la fecha límite,';
$string['indicator:accessesbeforestart'] = 'Curso accedido antes de la fecha de inicio';
$string['indicator:accessesbeforestart_help'] = 'Este indicador refleja si el alumno accedió al curso antes de la fecha de inicio del curso.';
$string['indicator:activitiesdue'] = 'Actividades pendientes';
$string['indicator:activitiesdue_help'] = 'El usuario tiene actividades pendientes.';
$string['indicator:anycourseaccess'] = 'Acceso a cualquier curso';
$string['indicator:anycourseaccess_help'] = 'Este indicador refleja el acceso a cualquier curso en que el usuario esté matriculado.';
$string['indicator:anywrite'] = 'Cualquier acción de escritura';
$string['indicator:anywrite_help'] = 'Este indicador representa cualquier acción de escritura (envío) realizada por el estudiante.';
$string['indicator:anywriteincourse'] = 'Cualquier acción de escritura en el curso';
$string['indicator:anywriteincourse_help'] = 'Este indicador representa cualquier acción de escritura (envío) realizada por el alumno en cualquier actividad del curso.';
$string['indicator:completeduserprofile'] = 'El perfil de usuario se completa';
$string['indicator:completeduserprofile_help'] = 'Este indicador representa que el alumno ha completado su perfil de usuario.';
$string['indicator:completeduserprofiledef'] = 'El perfil de usuario está completo';
$string['indicator:completeduserprofiledef_help'] = 'Las políticas del sitio han sido aceptadas y el usuario ha completado los siguientes campos: Institución, Departamento, Dirección, Ciudad, País, Dirección de sitio web.';
$string['indicator:completionenabled'] = 'Seguimiento de finalización habilitado';
$string['indicator:completionenabled_help'] = 'Este indicador representa que se ha habilitado el seguimiento de finalización para este curso.';
$string['indicator:nostudent'] = 'Estudiantes inscriptos';
$string['indicator:nostudent_help'] = 'Este indicador refleja que este curso no tiene estudiantes.';
$string['indicator:noteacher'] = 'No hay profesores';
$string['indicator:noteacher_help'] = 'Este indicador refleja que este curso no tiene profesores.';
$string['indicator:potentialcognitive'] = 'Profundidad cognitiva potencial del curso';
$string['indicator:potentialcognitive_help'] = 'Este indicador se basa en la profundidad cognitiva potencial que podría alcanzar un estudiante que participa en las actividades del curso.';
$string['indicator:potentialcognitivedef'] = 'Profundidad potencial cognitivo del curso';
$string['indicator:potentialcognitivedef_help'] = 'El grado en el que el curso ofrece "profundo" compromiso cognitivo, por ejemplo envío de trabajo para retroalimentación, la oportunidad para  revisar el trabajo de otros, y la oportunidad para revisar y reenviar trabajo.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Amplitud social potencial del curso';
$string['indicator:potentialsocial_help'] = 'Este indicador se basa en la amplitud social potencial que podría alcanzar el alumno que participa en las actividades del curso.';
$string['indicator:potentialsocialdef'] = 'Amplitud potencial social del curso';
$string['indicator:potentialsocialdef_help'] = 'El grado en el que el curso ofrece "amplio" compromiso social, interactuando con otros participantes y con la comunidad de práctica más allá de la clase.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Cantidad de acciones de lectura';
$string['indicator:readactions_help'] = 'Este indicador representa el número de acciones de lectura (vista) realizadas por el alumno.';
$string['indicator:userforumstracking'] = 'El usuario está rastreando foros';
$string['indicator:userforumstracking_help'] = 'Este indicador representa si el estudiante ha activado o no el seguimiento en los foros.';
$string['info'] = 'Información';
$string['inprogress'] = 'En progreso';
$string['insertcontentbefore'] = 'Insertar contenido antes de \'{$a->activityname}\'';
$string['insertcontentsection'] = 'Insertar contenido en sección "{$a->sectionname}"';
$string['insertresourceoractivitybefore'] = 'Insertar una actividad o recurso antes de \'{$a->activityname}\'';
$string['institution'] = 'Institución';
$string['instudentview'] = 'en vista estudiante';
$string['interests'] = 'Intereses';
$string['interestslist'] = 'Lista de intereses';
$string['interestslist_help'] = 'Introduzca sus intereses, uno por uno, que se mostrarán después en su página de perfil como etiquetas.';
$string['invalidemail'] = 'Dirección de correo no válida';
$string['invalidlogin'] = 'Acceso inválido. Por favor, inténtelo otra vez.';
$string['invalidtaskclassname'] = 'Clase de trabajo inválida {$a}';
$string['invalidtaskid'] = 'ID de trabajo inválida';
$string['invalidusername'] = 'El nombre de usuario sólo puede contener caracteres alfanuméricos en minúsculas (letras y números), subrayado (_), guión (-), punto (.) o arroba (@).';
$string['invalidusernameupload'] = 'Nombre de usuario no válido';
$string['ip_address'] = 'Dirección IP';
$string['jump'] = 'Salto';
$string['jumpto'] = 'Ir a...';
$string['keep'] = 'Mantener';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Dirección normal de texto';
$string['langrtl'] = 'Dirección inversa de texto';
$string['language'] = 'Idioma';
$string['languagegood'] = 'Este idioma está actualizado.';
$string['languageselector'] = 'Selector de idioma';
$string['last'] = 'Último';
$string['lastaccess'] = 'Último acceso';
$string['lastcourseaccess'] = 'Último acceso al curso';
$string['lastedited'] = 'Última edición';
$string['lastip'] = 'Última dirección IP';
$string['lastlogin'] = 'Último inicio de sesión';
$string['lastmodified'] = 'Última modificación';
$string['lastname'] = 'Apellido(s)';
$string['lastnamephonetic'] = 'Apellido(s) - fonético';
$string['lastpage'] = 'Última página';
$string['lastsiteaccess'] = 'Último acceso al sitio';
$string['lastyear'] = 'Último año';
$string['latestlanguagepack'] = 'Ver la última versión del idioma en moodle.org';
$string['layouttable'] = 'Tabla esquema';
$string['leavetokeep'] = 'Dejar en blanco para mantener la contraseña actual';
$string['legacylogginginuse'] = 'Este sitio tiene habilitada la escritura al registro heredado. Escribir a éste almacenamiento de registro es obsoleto. Por favor escriba a un almacenamiento de registro soportado como "estándar" o " externo".';
$string['legacythemeinuse'] = 'El sitio aparece en modo de compatibilidad porque su navegador es demasiado antiguo.';
$string['license'] = 'Licencia';
$string['licenses'] = 'Licencias';
$string['liketologin'] = '¿Desea acceder ahora con una cuenta de usuario completa?';
$string['list'] = 'Lista';
$string['listfiles'] = 'Lista de archivos en {$a}';
$string['listofallpeople'] = 'Lista total de personas';
$string['listofcourses'] = 'Listado de cursos';
$string['loading'] = 'Cargando';
$string['loadinghelp'] = 'Cargando...';
$string['local'] = 'Local';
$string['localplugins'] = 'Extensiones locales';
$string['localpluginsmanage'] = 'Gestionar extensiones locales';
$string['location'] = 'Ubicación';
$string['locktimeout'] = 'La operación ha agotado el tiempo de espera para un bloqueo.';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Usted se ha identificado como {$a}';
$string['loggedinasguest'] = 'En este momento está usando el acceso para invitados';
$string['loggedinnot'] = 'Usted no se ha identificado.';
$string['login'] = 'Acceder';
$string['login_failure_logs'] = 'Registro de fallos de acceso';
$string['loginactivity'] = 'Actividad de accesos';
$string['loginagain'] = 'Autenticarse nuevamente';
$string['loginalready'] = 'Usted ya ha accedido al sistema';
$string['loginas'] = 'Entrar como';
$string['loginaspasswordexplain'] = '<p>Debe introducir la "loginas password" especial para usar esta característica.<br />Si no la sabe, pregunte al administrador de su servidor.</p>';
$string['loginguest'] = 'Entrar como persona invitada';
$string['loginsite'] = 'Entrar al sitio';
$string['loginsteps'] = 'Para acceder a esta página debe crear una cuenta primero.';
$string['loginstepsnone'] = '<p>¡Hola!</p>
<p>Para acceder a todos los cursos necesita crear una cuenta.</p>
<p>Todo lo que tiene que hacer es inscribirse en esta página.</p>
<p>Si alguna otra persona hubiera elegido su nombre de usuario o su contraseña, deberá elegir un nombre de usuario diferente.</p>';
$string['loginto'] = 'Entrar a {$a}';
$string['logoof'] = 'Logotipo de {$a}';
$string['logout'] = 'Cerrar sesión';
$string['logoutconfirm'] = '¿Realmente desea salir?';
$string['logs'] = 'Registros';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">more</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">more</a> ]';
$string['lookback'] = 'Período';
$string['mailadmins'] = 'Informar a administradores';
$string['mailstudents'] = 'Informar a estudiantes';
$string['mailteachers'] = 'Informar a profesores';
$string['maincoursepage'] = 'Página principal del curso';
$string['makeafolder'] = 'Crear un directorio';
$string['makeavailable'] = 'Hacer disponible';
$string['makeeditable'] = 'Si hace a \'{$a}\' editable por el proceso del servidor web (por ejemplo, apache), entonces podría editar este archivo directamente desde esta página';
$string['makethismyhome'] = 'Hacer de esta mi página de inicio';
$string['makeunavailable'] = 'Hacer que no esté disponible';
$string['manageblocks'] = 'Bloques';
$string['managecategories'] = 'Administrar categorías de cursos';
$string['managecategorythis'] = 'Gestionar esta categoría';
$string['managecombined'] = 'Administrar categorías de cursos y cursos';
$string['managecontentbanktypes'] = 'Administrar tipos de contenido';
$string['managecourses'] = 'Gestionar cursos';
$string['managedatabase'] = 'Administrar la base de datos';
$string['managedataformats'] = 'Manejar formatos de datos';
$string['manageeditorfiles'] = 'Gestionar archivos usados por el editor';
$string['managefilters'] = 'Filtros';
$string['managemodules'] = 'Administrar módulos';
$string['manageroles'] = 'Roles y permisos';
$string['markallread'] = 'Marcar como leído';
$string['match'] = 'Coincidir';
$string['matchingsearchandrole'] = 'Coincidencias \'{$a->search}\' y {$a->role}';
$string['matchofthefollowing'] = 'de los siguientes:';
$string['maxareabytesreached'] = 'El archivo (o el tamaño total de varios archivos) es más grande que el espacio que queda en esta zona.';
$string['maxfilesize'] = 'Tamaño máximo para archivos nuevos: {$a}';
$string['maxfilesreached'] = 'Puede adjuntar un máximo de {$a} archivo(s)  a este item';
$string['maximumchars'] = 'Máximo: {$a} caracteres';
$string['maximumgrade'] = 'Calificación máxima';
$string['maximumgradex'] = 'Calificación máxima {$a}';
$string['maximumshort'] = 'Máx.';
$string['maximumupload'] = 'Tamaño máximo para archivos cargados por usuarios';
$string['maximumupload_help'] = 'Tamaño máximo de archivo permitido en las subidas de estudiantes al curso. Adicionalmente, usted puede restringir más el tamaño de subida máximo para cada actividad.';
$string['maxlengthreached'] = 'Se ha alcanzado el límite máximo de {$a} caracteres.';
$string['maxnumberweeks'] = 'Número máximo de secciones (obsoleto)';
$string['maxnumberweeks_desc'] = 'El valor máximo del número de secciones del menú desplegable (aplica sólo a ciertos formatos de curso). Este ajuste está obsoleto y se eliminará en una versión futura de Moodle. Por favor, use la configuración de formato de curso en su lugar.';
$string['maxnumcoursesincombo'] = 'Examinar <a href="{$a->link}">{$a->numberofcourses} cursos</a>.';
$string['maxsectionslimit'] = 'No se puede crear nueva sección ya que excedería el número máximo de secciones permitidas para este curso ({$a}).';
$string['maxsize'] = 'Tamaño máximo: {$a}';
$string['maxsizeandareasize'] = 'El tamaño máximo para los archivos nuevos es: {$a->size},para el límite global es: {$a->areasize}';
$string['maxsizeandattachments'] = 'Tamaño máximo de archivo: {$a->size}, número máximo de archivos: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'El tamaño máximo para los archivos nuevos es: {$a->size}, el número máximo de archivos adjuntos es: {$a->attachments}, el límite global es: {$a->areasize}';
$string['memberincourse'] = 'Personas en el curso';
$string['menu'] = 'Menú';
$string['message'] = 'Mensaje';
$string['messagebody'] = 'Cuerpo del mensaje';
$string['messagedselectedusers'] = 'Se ha enviado un mensaje a los usuarios seleccionados y se ha restablecido la lista de destinatarios.';
$string['messagedselectedusersfailed'] = 'Algo ha ido mal al enviar mensajes a los usuarios seleccionados. Algunos pueden haber recibido el mensaje.';
$string['messageprovider:asyncbackupnotification'] = 'Notificaciones de copia de seguridad/restauración asíncronas';
$string['messageprovider:availableupdate'] = 'Notificaciones de actualización disponibles';
$string['messageprovider:backup'] = 'Notificaciones de copia de seguridad';
$string['messageprovider:badgecreatornotice'] = 'Notificaciones del creador de Insignias';
$string['messageprovider:badgerecipientnotice'] = 'Notificaciones a los receptores de Insignias';
$string['messageprovider:competencyplancomment'] = 'Comentario enviado en un plan de aprendizaje';
$string['messageprovider:competencyusercompcomment'] = 'Comentario enviado a una competencia';
$string['messageprovider:coursecompleted'] = 'Curso completado';
$string['messageprovider:coursecontentupdated'] = 'Cambios en el contenido del curso';
$string['messageprovider:courserequestapproved'] = 'Notificacíón de aprobación de solicitud de creación de curso';
$string['messageprovider:courserequested'] = 'Notificación de solicitud de creación de curso';
$string['messageprovider:courserequestrejected'] = 'Notificacíón de rechazo de solicitud de creación de curso';
$string['messageprovider:enrolcoursewelcomemessage'] = 'Mensaje de bienvenida para nuevos matriculados';
$string['messageprovider:errors'] = 'Errores importantes en el sitio';
$string['messageprovider:errors_help'] = 'Estos son errores importantes que un administrador debería conocer.';
$string['messageprovider:failedtaskmaxdelay'] = 'La tarea alcanza su retardo máximo de error';
$string['messageprovider:gradenotifications'] = 'Notificación de calificaciones';
$string['messageprovider:infected'] = 'Notificaciones de falla del antivirus.';
$string['messageprovider:insights'] = 'Información generada por los modelos de predicción';
$string['messageprovider:instantmessage'] = 'Mensajes personales entre los usuarios';
$string['messageprovider:instantmessage_help'] = 'Esta sección configura lo que sucede con los mensajes que otros usuarios le han enviado en el sitio.';
$string['messageprovider:messagecontactrequests'] = 'Notificación de solicitudes de contacto de mensaje';
$string['messageprovider:newlogin'] = 'Nuevas notificaciones de inicio de sesión';
$string['messageprovider:notices'] = 'Avisos sobre problemas menores';
$string['messageprovider:notices_help'] = 'Estos son avisos que un administrador podría estar interesado en ver.';
$string['messageprovider:reportbuilderschedule'] = 'Horarios personalizados del editor de reportes';
$string['messageselect'] = 'Seleccionar este usuario como receptor de mensaje';
$string['messageselectadd'] = 'Enviar un mensaje';
$string['middlename'] = 'Nombre intermedio';
$string['migratinggrades'] = 'Migrando calificaciones';
$string['min'] = 'minutos';
$string['mins'] = 'minutos';
$string['minute'] = 'minuto';
$string['minutes'] = 'minutos';
$string['miscellaneous'] = 'Miscelánea';
$string['missingcategory'] = 'Necesita elegir una categoría';
$string['missingdescription'] = 'Falta la descripción';
$string['missingemail'] = 'Falta la dirección de correo';
$string['missingfirstname'] = 'Falta el nombre dado';
$string['missingfromdisk'] = 'Ausente del disco';
$string['missingfullname'] = 'Falta el nombre completo';
$string['missinglastname'] = 'Falta(n) apellido(s)';
$string['missingname'] = 'Falta el nombre';
$string['missingnewpassword'] = 'Falta la nueva contraseña';
$string['missingpassword'] = 'Falta la contraseña';
$string['missingrecaptchachallengefield'] = 'Falta el campo \'challenge\' de reCAPTCHA';
$string['missingreqreason'] = 'Falta la razón';
$string['missingshortname'] = 'Falta el nombre corto';
$string['missingshortsitename'] = 'Falta el nombre corto del sitio';
$string['missingsitedescription'] = 'Falta la descripción del sitio';
$string['missingsitename'] = 'Falta el nombre del sitio';
$string['missingstrings'] = 'Revisar palabras o frases sin traducir';
$string['missingstudent'] = 'Debe elegir algo';
$string['missingsummary'] = 'Falta el resumen';
$string['missingteacher'] = 'Debe elegir algo';
$string['missingurl'] = 'Falta URL';
$string['missingusername'] = 'Falta el nombre de usuario';
$string['moddoesnotsupporttype'] = 'El módulo {$a->modname} no soporta subida de archivos del tipo {$a->type}';
$string['modhide'] = 'Ocultar';
$string['modified'] = 'Modificado';
$string['modshow'] = 'Mostrar';
$string['moduleintro'] = 'Descripción';
$string['modulesetup'] = 'Instalando el módulo de tablas';
$string['modulesuccess'] = 'El módulo de tablas {$a} se instaló correctamente';
$string['modulesused'] = 'Módulos utilizados';
$string['modvisible'] = 'Disponibilidad';
$string['modvisible_help'] = '* Mostrar en la página del curso: Disponible para los estudiantes (sujeto a las restricciones de acceso que se puedan establecer).
* Ocultar en la página del curso: No disponible para estudiantes.';
$string['modvisiblehiddensection'] = 'Disponibilidad';
$string['modvisiblehiddensection_help'] = '* Ocultar en la página del curso: No disponible para estudiantes.
* Poner a disposición pero no mostrar en la página del curso: disponible para los estudiantes si proporciona un enlace. Las actividades seguirán apareciendo en el libro de calificaciones y otros informes.';
$string['modvisiblewithstealth'] = 'Disponibilidad';
$string['modvisiblewithstealth_help'] = '* Mostrar en la página del curso: Disponible para los estudiantes (sujeto a las restricciones de acceso que se puedan establecer).
* Ocultar en la página del curso: No disponible para estudiantes.
* Poner a disposición pero no mostrar en la página del curso: disponible para los estudiantes si proporciona un enlace. Las actividades seguirán apareciendo en el libro de calificaciones y otros informes.';
$string['month'] = 'Mes';
$string['months'] = 'Meses';
$string['moodledocs'] = 'Moodle Docs';
$string['moodledocslink'] = 'Documentación para esta página';
$string['moodlelogo'] = 'Logo de Moodle';
$string['moodlenet:cannotconnecttoserver'] = 'No se puede conectar a servidor MoodleNet';
$string['moodlenet:columnname'] = 'Nombre';
$string['moodlenet:columnsenddate'] = 'Fecha de envío';
$string['moodlenet:columnsendstatus'] = 'Estado de envío';
$string['moodlenet:columntype'] = 'Tipo';
$string['moodlenet:configoauthservice'] = 'Seleccionar un servicio de OAuth 2 MoodleNet para habilitar compertir a ese sitio Moodle. Si el servicio aun no existe, usted necesitará  <a href="{$a}">crear</a>lo.';
$string['moodlenet:deletedactivity'] = 'Actividad borrada';
$string['moodlenet:deletedcourse'] = 'Curso borrado';
$string['moodlenet:eventresourceexported'] = 'Recurso exportado';
$string['moodlenet:gotomoodlenet'] = 'Ir a borradores MoodleNet';
$string['moodlenet:issuerisnotauthorized'] = 'Emisor MoodleNet no está autorizado';
$string['moodlenet:issuerisnotenabled'] = 'Emisor MoodleNet no está habilitado';
$string['moodlenet:issuerisnotset'] = 'Emisor MoodleNet no está configurado en administración del sitio';
$string['moodlenet:nosharedresources'] = 'No hay recursos compartidos para mostrar en este momento.';
$string['moodlenet:outboundsettings'] = 'Configuraciones de salida de MoodleNet';
$string['moodlenet:packagingandsending'] = 'Empacando su archivo y enviándolo a MoodleNet...';
$string['moodlenet:sharefailtext'] = 'Hubo un error al compartir su contenido a MoodleNet.<br>Por favor inténtelo de nuevo después.';
$string['moodlenet:sharefailtextwithsitesupport'] = 'Hubo un error al compartir su contenido a MoodleNet.<br>Por favor inténtelo de nuevo después o <a href="{$a}">póngase en contacto con el soporte del sitio</a>.';
$string['moodlenet:sharefailtitle'] = 'Algo salió mal';
$string['moodlenet:sharefilesizelimitexceeded'] = 'El tamaño del recurso que está siendo compartido ({$a->filesize} bytes) excede el límite de {$a->filesizelimit} bytes.';
$string['moodlenet:sharenoticeactivity'] = 'Esta actividad se está compartiendo con MoodleNet como un recurso.';
$string['moodlenet:sharenoticecourse'] = 'Este curso se está compartiendo con MoodleNet como un recurso.';
$string['moodlenet:sharenoticepartial'] = 'Las actividades seleccionadas se están compartiendo con MoodleNet como un recurso.';
$string['moodlenet:sharenoticepartialactivitynumber'] = '{$a} actividades se incluirán en el curso.';
$string['moodlenet:shareprogress'] = 'Progreso de compartición de MoodleNet';
$string['moodlenet:shareprogressinfo'] = 'La lista muestra cursos y actividades que usted ha compartido en MoodleNet. <br>Clique en el nombre del recurso para verlo en MoodleNet.';
$string['moodlenet:sharesuccesstext'] = '¡Casi terminamos! Visite sus borradores en MoodleNet para terminar de compartir su contenido.';
$string['moodlenet:sharesuccesstitle'] = 'Guardado a borradores de MoodleNet';
$string['moodlenet:sharetomoodlenet'] = 'Compartir a MoodleNet';
$string['moodlenet:sharinglargefile'] = 'Los archivos grandes pueden demorar un largo tiempo.';
$string['moodlenet:sharingstatus'] = 'Compartiendo a MoodleNet';
$string['moodlenet:sharingto'] = 'Compartiendo a:';
$string['moodlerelease'] = 'Lanzamiento de Moodle';
$string['moodleservicesandsupport'] = 'Soporte y servicios';
$string['moodleversion'] = 'Versión de Moodle';
$string['more'] = 'más';
$string['moreactions'] = 'Mas acciones';
$string['morehelp'] = 'Más ayuda';
$string['morehelpaboutmodule'] = 'Más ayuda acerca de la actividad {$a}';
$string['moreinfo'] = 'Más información';
$string['moreinformation'] = 'Más información sobre este error';
$string['moremenu'] = 'Más';
$string['morenavigationlinks'] = 'Más ...';
$string['moreprofileinfoneeded'] = 'Por favor, díagnos algo acerca de sí mismo';
$string['mostrecently'] = 'más recientes';
$string['move'] = 'Mover';
$string['movecategoriessuccess'] = 'Se han movido con éxito {$a->count} categorías dentro de la categoría \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = 'Movidas con éxito al nivel principal {$a->count} categorías';
$string['movecategorycontentto'] = 'Mover a';
$string['movecategorysuccess'] = 'Se ha movido con éxito la categoría \'{$a->moved}\' dentro de la categoría \'{$a->to}\'';
$string['movecategoryto'] = 'Mover categoría a:';
$string['movecategorytotopsuccess'] = 'Movidas con éxito al nivel principal \'{$a->moved}\' categorías';
$string['movecontent'] = 'Mover {$a}';
$string['movecontentafter'] = 'Después de "{$a}"';
$string['movecontentstoanothercategory'] = 'Mover el contenido a otra categoría';
$string['movecontenttothetop'] = 'Mover arriba de la lista';
$string['movecoursemodule'] = 'Mover actividad';
$string['movecoursesection'] = 'Mover la sección';
$string['movecourseto'] = 'Mover curso a:';
$string['movedown'] = 'Mover hacia abajo';
$string['movefilestohere'] = 'Colocar archivos aquí';
$string['movefull'] = 'Mover {$a} a este lugar';
$string['movehere'] = 'Colocar aquí';
$string['moveitemdown'] = 'Mover {$a} abajo';
$string['moveitemup'] = 'Mover {$a} arriba';
$string['moveleft'] = 'Mover a la izquierda';
$string['moveright'] = 'Mover a la derecha';
$string['movesection'] = 'Mover sección {$a}';
$string['moveselectedcategoriesto'] = 'Mover las categorías seleccionadas a';
$string['moveselectedcoursesto'] = 'Mover los cursos seleccionados a...';
$string['movetoanotherfolder'] = 'Mover a otro directrorio';
$string['moveup'] = 'Mover hacia arriba';
$string['multipleitemsfound'] = 'Se han encontrado {$a} elementos.';
$string['mustchangepassword'] = 'La nueva contraseña debe ser diferente a la actual';
$string['mustconfirm'] = 'Necesita confirmar su cuenta';
$string['mycourses'] = 'Mis cursos';
$string['myfiles'] = 'Mis archivos privados';
$string['myfilesmanage'] = 'Gestionar mis archivos privados';
$string['myhome'] = 'Área personal';
$string['mymoodledashboard'] = 'Mi área personal';
$string['myprofile'] = 'Mi perfil';
$string['name'] = 'Nombre';
$string['namedfiletoolarge'] = 'El fichero \'{$a->filename}\' es muy grande y no puede subirse';
$string['nameforlink'] = '¿Cómo quiere llamar a este enlace?';
$string['nameforpage'] = 'Nombre';
$string['navigation'] = 'Navegación';
$string['needed'] = 'Requerido';
$string['networkdropped'] = 'Hemos detectado que su conexión a Internet no es fiable o ha sido interrumpida.<br /> Por favor tenga en cuenta que los cambios realizados podrían no guardarse correctamente hasta que su conexión se recupere.';
$string['never'] = 'Nunca';
$string['neverdeletelogs'] = 'Nunca borrar los registros';
$string['new'] = 'Nuevo';
$string['newaccount'] = 'Nueva cuenta';
$string['newactivityname'] = 'Nuevo nombre para actividad {$a}';
$string['newcourse'] = 'Nuevo curso';
$string['newloginnotificationbodyfull'] = '<p>Hola {$a->userfullname},</p>
<p>Acabas de iniciar sesión con tu cuenta en  {$a->sitename} desde un nuevo dispositivo.</p>
<ul>
<li>Tu cuenta: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Dispositivo: {$a->logindevice}</li>
<li>IP: {$a->loginip}</li>
</ul>
<p>Si fuiste tú, entonces no necesitas hacer nada.</p>
<p>Si no reconoces esta solicitud, por favor <a href="{$a->changepasswordlink}">cambia tu contraseña</a>.</p>';
$string['newloginnotificationbodysmall'] = 'Se acaba de iniciar sesión en tu cuenta {$a} desde un nuevo dispositivo.';
$string['newloginnotificationtitle'] = 'Nuevo inicio de sesión con tu cuenta {$a}';
$string['newpassword'] = 'Nueva contraseña';
$string['newpassword_help'] = 'Escriba una nueva contraseña o déjelo en blanco para mantener la contraseña actual.';
$string['newpasswordfromlost'] = '<strong>AVISO:</strong> Su<strong>Contraseña actual</strong> ha sido enviada en el <strong>segundo</strong> de los dos correos electrónicos enviados como parte del proceso de recuperación de la contraseña perdida. Asegúrese de que ha recibido la nueva contraseña antes de continuar con esta pantalla.';
$string['newpasswordtext'] = 'Hola, {$a->firstname}.

La contraseña de su cuenta en \'{$a->sitename}\' se ha
cancelado y se le ha otorgado una nueva contraseña temporal.

Su nueva información de acceso es:
   Nombre de usuario: {$a->username}
   Contraseña: {$a->newpassword}

Diríjase por favor a esta página y cambie su contraseña temporal por una que pueda recordar mejor:
   {$a->link}

En la mayoría de los programas de correo electrónico el
enlace anterior aparecerá como una línea de texto en azul
sobre la que puede hacer clic. Si eso no sucede, copie y
pegue la dirección en la barra de direcciones de su navegador.

Atte. El Administrador de \'{$a->sitename}\',
{$a->signoff}';
$string['newpicture'] = 'Imagen nueva';
$string['newpicture_help'] = 'Para añadir una imagen nueva, navegue y seleccione una imagen (en formato JPG o PNG) y después haga clic en "Actualizar perfil". La imagen será recortada a un cuadrado y escalada a 100 x 100 pixeles.';
$string['newpictureusernotsetup'] = 'La foto del perfil solo es agregada cuando todos los campos del perfil han sido guardados';
$string['newsectionname'] = 'Nuevo nombre para la sección {$a}';
$string['newsitem'] = 'noticias';
$string['newsitems'] = 'anuncios';
$string['newsitemsnumber'] = 'Número de anuncios';
$string['newsitemsnumber_help'] = 'El foro de anuncios tiene forzada la suscripción por defecto. Sólo profesores y otros usuarios con permisos adecuados pueden postear en él.

Si no necesita un foro de anuncios, configure esto a cero.

Este ajuste también determina cuántos anuncios recientes aparecerán en el bloque de avisos recientes.';
$string['newuser'] = 'Nuevo usuario';
$string['newusernewpasswordsubj'] = 'Cuenta de nuevo usuario';
$string['newusernewpasswordtext'] = 'Hola, {$a->firstname}.

Se le ha creado una nueva cuenta en "{$a->sitename}".

  Nombre de usuario: {$a->username}
  Contraseña: {$a->newpassword}

(Deberá cambiar su contraseña cuando acceda por primera vez)

Para comenzar a usar "{$a->sitename}", entre en
{$a->link}

Si necesita ayuda, puede contactar con el administrador del sitio,
{$a->signoff}';
$string['newusers'] = 'Nuevos usuarios';
$string['newwindow'] = 'Nueva ventana';
$string['next'] = 'Siguiente';
$string['nextpage'] = 'Siguiente página';
$string['nextsection'] = 'Siguiente sección';
$string['no'] = 'No';
$string['noblockstoaddhere'] = 'No existen bloques que pueda agregar a esta página.';
$string['nobody'] = 'Nadie';
$string['nochange'] = 'Sin cambios';
$string['nocomments'] = 'No hay comentarios';
$string['nocourses'] = 'Sin cursos';
$string['nocoursesfound'] = 'No se encontraron cursos con las palabras {$a}';
$string['nocoursestarttime'] = 'El curso no tiene un momento de inicio';
$string['nocoursesyet'] = 'No hay cursos en esta categoría';
$string['nodstpresets'] = 'El administrador no ha activado el soporte Daylight Savings Time';
$string['nofilesselected'] = 'No se ha seleccionado ningún archivo para restaurar';
$string['nofilesyet'] = 'Aún no se han subido archivos a su curso';
$string['nofiltersapplied'] = 'No se aplicaron filtros';
$string['nograde'] = 'No hay calificación';
$string['nohelpforactivityorresource'] = 'Actualmente no hay ayuda asociada a este recurso o actividad';
$string['noimagesyet'] = 'Aún no se han subido  imágenes a su curso';
$string['noitemsfound'] = 'No se han encontrado elementos.';
$string['nologsfound'] = 'No se han encontrado registros';
$string['nomatchingusers'] = 'Ningún usuario coincide con {$a}';
$string['nomorecourses'] = 'No se encontraron más cursos que cumplan el criterio';
$string['nomoreidnumber'] = 'No se usa un número de identificación para evitar colisiones';
$string['none'] = 'Ninguno';
$string['noneditingteacher'] = 'Profesor sin permiso de edición';
$string['noneditingteacherdescription'] = 'Los profesores sin permiso de edición pueden enseñar en los cursos y calificar a los estudiantes, pero no pueden modificar las actividades.';
$string['nonstandard'] = 'No estándar';
$string['nopendingcourses'] = 'No hay cursos pendientes de aprobación';
$string['nopotentialadmins'] = 'No hay administradores potenciales';
$string['nopotentialcreators'] = 'No hay creadores potenciales';
$string['nopotentialstudents'] = 'No hay estudiantes potenciales';
$string['nopotentialteachers'] = 'No hay profesores potenciales';
$string['norecentactivity'] = 'No hay actividad reciente';
$string['noreplybouncemessage'] = 'Ha respondido a una dirección \'no-reply\'. Si está intentando responder a un mensaje de foro, use por favor los foros {$a}.

Éste es el contenido de su correo:';
$string['noreplybouncesubject'] = '{$a} - correo devuelto.';
$string['noreplyname'] = 'No contestar a este correo';
$string['noresetrecord'] = 'No hay constancia de esa solicitud. Por favor haga una nueva solicitud de restablecimiento de contraseña.';
$string['noresults'] = 'No hay resultados';
$string['noresultsfor'] = 'No hay resultados para "{$a}"';
$string['noresultsfor_help'] = 'Compruebe la ortografía o pruebe con otras palabras.';
$string['normal'] = 'Normal';
$string['normalfilter'] = 'Búsqueda normal';
$string['nosite'] = 'No se encontró curso en el nivel de sitio';
$string['nostudentsfound'] = 'No se encuentra {$a}';
$string['nostudentsingroup'] = 'Aún no hay estudiantes en este grupo';
$string['nostudentsyet'] = 'No hay estudiantes matriculados en este curso.';
$string['nosuchemail'] = 'No existe esa dirección de correo';
$string['notavailable'] = 'No disponible';
$string['notavailablecourse'] = '{$a} no disponible';
$string['noteachersyet'] = 'Aún no hay profesores en este curso';
$string['noteachingupcomingcourses'] = 'Cursos próximos sin profesores o estudiantes';
$string['notenrolled'] = '{$a} no está matriculado en este curso.';
$string['notenrolledprofile'] = 'Este perfil no está disponible porque el usuario no está matriculado en este curso.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Nota:<strong>La posibilidad de mover fechas al restaurar esta copia de seguridad se ha desactivado porque no tiene los permisos necesarios.';
$string['noteuserschangednonetocourse'] = '<strong>Nota:<strong>Los usuarios de los cursos deben ser restaurados cuando se restauran los datos de usuario (en actividades, archivos o mensajes). Esta configuración ha sido cambiada para usted.';
$string['nothingnew'] = 'Sin actividad reciente';
$string['nothingtodisplay'] = 'Nada que mostrar';
$string['notice'] = 'Aviso';
$string['noticenewerbackup'] = 'Esta copia de seguridad ha sido creada con Moodle {$a->backuprelease} ({$a->backupversion}) y es más reciente que la versión instalada de Moodle {$a->serverrelease} ({$a->serverversion}). Esto podría ocasionar algunas inconsistencias debido a que no se puede garantizar la compatibilidad retrospectiva de las copias de seguridad.';
$string['notifications'] = 'Notificaciones';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Usuario: {$a->info}, Nombre completo del usuario: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Puede ver estos logs en {$a}';
$string['notifyloginfailuresmessagestart'] = 'Listado de intentos fallidos de acceso a {$a} desde que se le envió la última notificación';
$string['notifyloginfailuressubject'] = '{$a} :: Notificación de intentos de identificación fallidos';
$string['notincluded'] = 'No incluido';
$string['notingroup'] = 'Lo sentimos,  necesita ser miembro de un grupo para ver esta página.';
$string['notpublic'] = '¡No es público!';
$string['nousersfound'] = 'No se encuentran usuarios';
$string['nousersmatching'] = 'No se encontraron usuarios con \'{$a}\'';
$string['nousersyet'] = 'Aún no hay usuarios';
$string['novalidcourses'] = 'No hay cursos válidos para mostrar';
$string['now'] = 'ahora';
$string['numattempts'] = '{$a} intento(s) de identificación fallido(s)';
$string['numberofcourses'] = 'Número de cursos';
$string['numberweeks'] = 'Número de secciones';
$string['numday'] = '{$a} día';
$string['numdays'] = '{$a} días';
$string['numhours'] = '{$a} horas';
$string['numletters'] = '{$a} letras';
$string['numminutes'] = '{$a} minutos';
$string['nummonth'] = '{$a} mes';
$string['nummonths'] = '{$a} meses';
$string['numseconds'] = '{$a} segundos';
$string['numviews'] = '{$a} vistas';
$string['numweek'] = '{$a} semana';
$string['numweeks'] = '{$a} semanas';
$string['numwords'] = '{$a} palabras';
$string['numyear'] = '{$a} año';
$string['numyears'] = '{$a} años';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Contraseña actual';
$string['olduserdirectory'] = 'Este es el directorio de usuarios ANTIGUOS, ya no es necesario conservarlo. Puede eliminarlo. Los archivos que contiene se han copiado al NUEVO directorio de usuarios.';
$string['oneitemfound'] = 'Se ha encontrado un elemento.';
$string['opendrawerblocks'] = 'Abrir cajón de bloques';
$string['opendrawerindex'] = 'Abrir índice del curso';
$string['opensinnewwindow'] = 'Abrir en una nueva ventana';
$string['operator_and'] = 'y';
$string['operator_andnot'] = 'y';
$string['operator_or'] = 'o';
$string['optional'] = 'opcional';
$string['options'] = 'opciones';
$string['order'] = 'Ordenar';
$string['originalpath'] = 'Ruta original';
$string['orphanedactivitiesinsectionno'] = 'Actividades huérfanas (sección {$a})';
$string['other'] = 'Otro';
$string['outline'] = 'Diagrama';
$string['outlinereport'] = 'Informe preliminar';
$string['page'] = 'Página';
$string['pagea'] = 'Página {$a}';
$string['pagedcontentnavigation'] = 'Navegación de paginación';
$string['pagedcontentnavigationactiveitem'] = 'Página actual, página {$a}';
$string['pagedcontentnavigationitem'] = 'Ir a la página {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Mostrar {$a} elementos por página';
$string['pageheaderconfigablock'] = 'Configurando un bloque en {%fullname%}';
$string['pagepath'] = 'Ruta a la página';
$string['pageshouldredirect'] = 'Esta página debería redireccionar automáticamente. Si no ocurre nada, por favor utilice el enlace de continuar que aparece más abajo.';
$string['parentcategory'] = 'Categoría padre';
$string['parentcoursenotfound'] = '¡Curso raíz no encontrado!';
$string['parentfolder'] = 'Directorio raíz';
$string['participants'] = 'Participantes';
$string['participantslist'] = 'Lista de participantes';
$string['participationratio'] = 'Tasa de participación';
$string['participationreport'] = 'Informe de participación';
$string['password'] = 'Contraseña';
$string['passwordchanged'] = 'La contraseña ha cambiado';
$string['passwordextlink'] = 'Este enlace sirve para recuperar su contraseña perdida y requiere salir de Moodle.';
$string['passwordforgotten'] = 'Contraseña olvidada';
$string['passwordforgotteninstructions'] = 'Sus detalles deben encontrarse primero en la base de datos del usuario. Por favor, escriba <strong>o bien</strong> su nombre de usuario o bien su dirección registrada de correo electrónico en el recuadro apropiado. No es necesario escribir ambos.';
$string['passwordforgotteninstructions2'] = 'Para reajustar su contraseña, envíe su nombre de usuario o su dirección de correo electrónico. Si podemos encontrarlo en la base de datos, le enviaremos un email con instrucciones para poder acceder de nuevo.';
$string['passwordpolicynomatch'] = 'Su contraseña actual ya no cumple la política de contraseña establecida.
   {$a}';
$string['passwordsdiffer'] = 'Las contraseñas son diferentes';
$string['passwordset'] = 'Se ha establecido su contraseña.';
$string['path'] = 'Ruta';
$string['pathnotexists'] = '¡Esta ruta no existe en su servidor!';
$string['pathslasherror'] = 'La ruta no puede terminar con una barra.';
$string['paymentinstant'] = 'Utilice el botón de abajo para pagar y poder matricularse en minutos.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> pendiente</small>)';
$string['paymentrequired'] = 'Para entrar a este curso es necesario pagar.';
$string['payments'] = 'Pagos';
$string['paymentsorry'] = 'Gracias por su pago. Cuando se procese, podrá entrar al curso "{$a->fullname}". Por favor, espere e inténtelo de nuevo. Si continúa teniendo problemas, avise al {$a->teacher} o al administrador del sitio';
$string['paymentthanks'] = 'Gracias por su pago. Ahora se ha matriculado en el curso {$a}.';
$string['pendingrequests'] = 'Solicitudes pendientes';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Fin del período ({$a})';
$string['perpage'] = 'Por página';
$string['perpagea'] = 'Por página: {$a}';
$string['personal'] = 'Personal';
$string['personalprofile'] = 'Información personal';
$string['phone'] = 'Teléfono';
$string['phone1'] = 'Teléfono';
$string['phone2'] = 'Teléfono móvil';
$string['phpinfo'] = 'Información PHP';
$string['picture'] = 'Imagen';
$string['pictureof'] = 'Imagen de {$a}';
$string['pictureofuser'] = 'Imagen del usuario';
$string['placeholdertypeorselect'] = 'Escriba o seleccione...';
$string['pleaseclose'] = 'Por favor, cierre ahora esta ventana.';
$string['pleasesearchmore'] = 'Por favor, busque algo más';
$string['pleaseusesearch'] = 'Por favor, use la búsqueda';
$string['plugin'] = 'Complemento';
$string['pluginarea'] = 'Área';
$string['plugincheck'] = 'Comprobación de \'plugins\'';
$string['plugindeletefiles'] = 'Todos los datos asociados con el plugin \'{$a->name}\' han sido eliminados de la base de datos. Para prevenir que el plugin se reinstale por sí mismo, debería eliminar ahora el directorio de su servidor: {$a->directory}';
$string['pluginitemid'] = 'ID del producto';
$string['pluginmissingfromdisk'] = '{$a->name} (Faltante en el disco)';
$string['pluginsetup'] = 'Ajustando tablas de plugins';
$string['policyaccept'] = 'Entiendo y estoy de acuerdo';
$string['policyagree'] = 'Usted deberá estar de acuerdo con estas condiciones antes de seguir usando este sitio. ¿Está de acuerdo?';
$string['policyagreement'] = 'Acuerdo con las Condiciones del Sitio';
$string['policyagreementclick'] = 'Acuerdo de privacidad del sitio';
$string['popup'] = 'emergente';
$string['popupwindow'] = 'Abrir el archivo en una ventana nueva';
$string['popupwindowname'] = 'Ventana emergente';
$string['post'] = 'Mensaje';
$string['posts'] = 'Mensajes';
$string['potentialadmins'] = 'Administradores potenciales';
$string['potentialcreators'] = 'Creadores potenciales';
$string['potentialstudents'] = 'Estudiantes potenciales';
$string['potentialteachers'] = 'Profesores potenciales';
$string['poweredbymoodle'] = 'Desarrollado por <a href="https://moodle.com">Moodle</a>';
$string['preferences'] = 'Preferencias';
$string['preferredlanguage'] = 'Idioma preferido';
$string['preferredtheme'] = 'Tema preferido';
$string['preprocessingbackupfile'] = 'Procesando el archivo de copia de seguridad';
$string['prev'] = 'Prev';
$string['preview'] = 'Vista previa';
$string['previeworchoose'] = 'Prever o elegir un tema';
$string['previewthemename'] = 'Vista previa del tema "{$a}"';
$string['previous'] = 'Anterior';
$string['previouslyselectedusers'] = 'Usuarios previamente seleccionados que no coinciden con {$a}';
$string['previouspage'] = 'Página anterior';
$string['previoussection'] = 'Sección anterior';
$string['primaryadminsetup'] = 'Ajustar cuenta del administrador';
$string['privacy:metadata:config_log'] = 'El registro de cambios de configuración.';
$string['privacy:metadata:config_log:name'] = 'El nombre de los cambios de configuración.';
$string['privacy:metadata:config_log:oldvalue'] = 'El valor anterior para esta configuración.';
$string['privacy:metadata:config_log:plugin'] = 'El plugin modificado.';
$string['privacy:metadata:config_log:timemodified'] = 'Fecha en la que se realizó el cambio.';
$string['privacy:metadata:config_log:userid'] = 'El usuario que hizo el cambio.';
$string['privacy:metadata:config_log:value'] = 'El nuevo valor para la configuración.';
$string['privacy:metadata:events_queue'] = 'La cola de eventos del usuario que esperan para ser procesados.';
$string['privacy:metadata:events_queue:eventdata'] = 'Los datos almacenados en el evento.';
$string['privacy:metadata:events_queue:stackdump'] = 'Cualquier stacktrace asociado con este evento.';
$string['privacy:metadata:events_queue:timecreated'] = 'La hora en la cual fue creado este evento.';
$string['privacy:metadata:events_queue:userid'] = 'La ID del usuario asociado con este evento';
$string['privacy:metadata:log'] = 'Una colección de eventos anteriores';
$string['privacy:metadata:log:action'] = 'Una descripción de la acción';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'curso';
$string['privacy:metadata:log:info'] = 'Información adicional';
$string['privacy:metadata:log:ip'] = 'La dirección IP usada durante el evento';
$string['privacy:metadata:log:module'] = 'módulo';
$string['privacy:metadata:log:time'] = 'El momento en el que tuvo lugar la acción';
$string['privacy:metadata:log:url'] = 'La URL asociada al evento';
$string['privacy:metadata:log:userid'] = 'El ID del usuario que realizó la acción';
$string['privacy:metadata:moodlenet_share_progress'] = 'Detalles de progreso de compartición MoodleNet';
$string['privacy:metadata:moodlenet_share_progress:cmid'] = 'El ID del módulo de curso asociado';
$string['privacy:metadata:moodlenet_share_progress:courseid'] = 'El ID del curso asociado';
$string['privacy:metadata:moodlenet_share_progress:resourceurl'] = 'La URL devuelta por MoodleNet tras una compartición satisfactoria';
$string['privacy:metadata:moodlenet_share_progress:status'] = 'El estado resultante de la compartición';
$string['privacy:metadata:moodlenet_share_progress:timecreated'] = 'El momento en que se hizo la compartición';
$string['privacy:metadata:moodlenet_share_progress:type'] = 'El tipo de compartición que se realizó';
$string['privacy:metadata:moodlenet_share_progress:userid'] = 'El usuario que realizó la compartición';
$string['privacy:metadata:oauth2_refresh_token'] = 'Actualizar el token utilizado en la comunicación OAuth 2.0';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'La ID del emisor a quien corresponde el token';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'La ID del usuario a quien corresponde el token';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'La hora de cuando fue creado el token';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'La hora de cuando fue actualizado por ultima vez el token';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'El token de refresco para los alcances (scopes) y usuario respectivos';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'La ID del usuario a quien corresponde el token';
$string['privacy:metadata:shortlink'] = 'Detalles de URL acortada';
$string['privacy:metadata:shortlink:component'] = 'El componente asociado a la URL acortada';
$string['privacy:metadata:shortlink:identifier'] = 'El identificador único asociado a la dirección acortada';
$string['privacy:metadata:shortlink:linktype'] = 'El tipo de enlace con el que puede identificarse la URL acortada';
$string['privacy:metadata:shortlink:shortcode'] = 'El código corto para usar para la URL acortada';
$string['privacy:metadata:shortlink:userid'] = 'El ID del usuario asociado a la URL acortada';
$string['privacy:metadata:task_adhoc'] = 'El estado de los trabajos ad-hoc.';
$string['privacy:metadata:task_adhoc:component'] = 'El componente propietario de la tarea.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'La hora más temprana para ejecutar este trabajo.';
$string['privacy:metadata:task_adhoc:userid'] = 'El usuario con el que ejecutar la acción.';
$string['privacy:metadata:task_log'] = 'Registre salida para un registro';
$string['privacy:metadata:task_log:component'] = 'El componente propietario de la tarea.';
$string['privacy:metadata:task_log:userid'] = 'El usuario que fue propietario de la tarea.';
$string['privacy:metadata:upgrade_log'] = 'El registro de actualización.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Cualquier backtrace asociado con este paso de actualización.';
$string['privacy:metadata:upgrade_log:details'] = 'Información extra relacionada con la actualización.';
$string['privacy:metadata:upgrade_log:info'] = 'La información principal para este paso de la actualización.';
$string['privacy:metadata:upgrade_log:plugin'] = 'El plugin que fue actualizado.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'La nueva versión a la cual actualizar.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'La fecha en la que tuvo lugar la actualización.';
$string['privacy:metadata:upgrade_log:type'] = 'El tipo de entrada de registro.';
$string['privacy:metadata:upgrade_log:userid'] = 'El usuario que ejecutó la actualización.';
$string['privacy:metadata:upgrade_log:version'] = 'La versión antigua del plugin.';
$string['private_files_handler'] = 'Almacenar los adjuntos de un correo electrónico en el espacio de almacenamiento de archivos privados del usuario.';
$string['private_files_handler_name'] = 'Enviar por correo electrónico a Archivos Privados';
$string['privatefiles'] = 'Archivos privados';
$string['privatefilesmanage'] = 'Gestionar archivos privados';
$string['proceed'] = 'Proceder';
$string['profile'] = 'Perfil';
$string['profilenotshown'] = 'Esta descripción de perfil no se mostrará hasta que esta persona se matricule al menos en un curso.';
$string['progress'] = 'Progreso';
$string['publicprofile'] = 'Perfil público';
$string['publicsitefileswarning'] = 'Nota: cualquiera puede ver los archivos colocados aquí';
$string['publicsitefileswarning2'] = 'Nota: Los archivos colocados aquí pueden ser vistos por cualquiera que conozca (o pueda adivinar) la URL. Por razones de seguridad, se recomienda que los archivos de cualquier copia de seguridad se eliminen inmediatamente después de restaurarlos.';
$string['publicsitefileswarning3'] = 'Nota: Los archivos colocados aquí pueden ser vistos por cualquiera que conozca (o pueda adivinar) la URL. <br />Por razones de seguridad, se recomienda que los archivos de cualquier copia de seguridad se eliminen inmediatamente después de restaurarlos.';
$string['question'] = 'Pregunta';
$string['questionsinthequestionbank'] = 'Preguntas en el banco de preguntas';
$string['queued'] = 'Puesto en cola';
$string['quotausage'] = 'Actualmente has utilizado {$a->used} de tu {$a->total} límite.';
$string['readinginfofrombackup'] = 'Leyendo información de la copia de seguridad';
$string['readme'] = 'LÉAME';
$string['recentactivity'] = 'Actividad reciente';
$string['recentactivityreport'] = 'Informe completo de la actividad reciente...';
$string['recipientslist'] = 'Lista de receptores';
$string['recommended'] = 'Recomendado';
$string['recreatedcategory'] = 'Categoría recreada {$a}';
$string['redirect'] = 'Redireccionar';
$string['reducesections'] = 'Reducir el número de secciones';
$string['refresh'] = 'Recargar';
$string['refreshingevents'] = 'Refrescando eventos';
$string['registration'] = 'Registro de Moodle';
$string['registrationcontact'] = 'Contacto del público';
$string['registrationcontactno'] = 'No, no deseo ser contactado por otras personas.';
$string['registrationcontactyes'] = 'Sí, proporcione un formulario para que otros Moodlers contacten conmigo';
$string['registrationemail'] = 'Notificaciones por correo electrónico';
$string['registrationinfo'] = '<p>Esta página le permite registrar si sitio Moodle en moodle.org. El registro es gratuito.
El principal beneficio del registro es que usted será incluido en una lista de correo de bajo volumen para
notificaciones importantes como alertas de seguridad y nuevos lanzamientos de Moodle.</p>
<p>Su información será confidencial, y nunca será vendida o transmitida a nadie más. La única razón para
recopilar esta información es prestarle apoyo y ayudar a costruir un cuadro estadístico de la comunidad
Moodle.</p>
<p>Si lo desea, puede escribir el nombre de su sitio, país y URL para que aparezca en la lista pública de los sitios que usan Moodle.</p>
<p>Todos los registros son verificados manualmente antes de ser colocados en la lista, pero una vez en ella, puede actualizar su registro (y sus datos en la lista pública) en cualquier momento rellenando de nuevo este formulario.</p>';
$string['registrationinfotitle'] = 'Información de registro';
$string['registrationsend'] = 'Enviar mi información de registro a moodle.org';
$string['registrationyes'] = 'Sí, envíeme notificaciones de nuevos lanzamientos de Moodle, alertas de seguridad y otras noticias importantes.';
$string['reject'] = 'Rechazar';
$string['rejectdots'] = 'Rechazar...';
$string['relativedatesmode'] = 'Modo de fechas relativas';
$string['relativedatesmode_help'] = 'Mostrar fechas de curso o actividad relativas a la fecha de inicio del usuario en el curso.

La fecha de inicio del curso del usuario será su fecha de matriculación, a menos que sea matriculado antes de que el curso empiece, en cuyo caso su fecha de inicio será la fecha de inicio del curso.

ADVERTENCIA: Esta es una característica experimental y es posible que no todas las actividades la soporten. Una vez que el curso haya sido creado, esta configuración del curso ya no podrá ser cambiada.';
$string['relativedatesmode_warning'] = '<strong>Advertencia:</strong> El modo de fechas relativas no puede ser cambiado una vez que el curso haya sido creado.';
$string['reload'] = 'Recargar';
$string['remoteappuser'] = 'Usuario {$a} remoto';
$string['remove'] = 'Quitar';
$string['removeadmin'] = 'Quitar administrador';
$string['removecreator'] = 'Quitar creador';
$string['removed'] = '{$a} eliminado';
$string['removestudent'] = 'Quitar estudiante';
$string['removeteacher'] = 'Quitar profesor';
$string['rename'] = 'Renombrar';
$string['renamefileto'] = 'Renombrar <b>{$a}</b> a';
$string['report'] = 'Informe';
$string['reports'] = 'Informes';
$string['reporttype'] = 'Tipo de informe';
$string['repositories'] = 'Repositorios';
$string['requestcourse'] = 'Solicitar un curso';
$string['requestedby'] = 'Solicitado por';
$string['requestedcourses'] = 'Cursos solicitados';
$string['requestreason'] = 'Razón para solicitar el curso';
$string['requests'] = 'Peticiones';
$string['required'] = 'Obligatorio';
$string['requirespayment'] = 'Para acceder a este curso es preciso pagar';
$string['resendemail'] = 'Reenviar correo de confirmación';
$string['reset'] = 'Reiniciar';
$string['resetcomponent'] = 'Componente';
$string['resetcourse'] = 'Reiniciar curso';
$string['resetcourseconfirm'] = '¿Reiniciar curso?';
$string['resetcoursewarning'] = '¿Seguro que quiere reiniciar el curso "{$a}"?
<br/><br/>
Esto borrará todos los datos seleccionados y reseteará el curso a su estado original. No puede deshacer esta acción.';
$string['resetinfo'] = 'Esta característica permite borrar todos los datos de usuario y devolver el curso a su estado original. Las actividades del curso y la configuración permanecen sin cambios.';
$string['resetinfoselect'] = 'Seleccione los datos que desea borrar o reiniciar de las siguientes categorías:';
$string['resetnotimplemented'] = 'Reinicio no soportado';
$string['resetnotimplementedinfo'] = 'Estas actividades no se pueden resetear:';
$string['resetrecordexpired'] = 'El enlace para restablecer la contraseña que utilizó tiene más de {$a} minutos y ha expirado. Por favor, inicie un nuevo restablecimiento de contraseña.';
$string['resetstartdate'] = 'Reajustar fecha inicial';
$string['resetstatus'] = 'Estatus';
$string['resettable'] = 'Restablecer preferencias de tabla';
$string['resettask'] = 'Reiniciar';
$string['resettodefaults'] = 'Reajustar a valores por defecto';
$string['resortcourses'] = 'Ordenar cursos';
$string['resortsubcategoriesby'] = 'Ordenar categorías por {$a} ascendente';
$string['resortsubcategoriesbyreverse'] = 'Ordenar categorías por {$a} descendente';
$string['resource'] = 'Recurso';
$string['resource_type'] = 'Tipo de recurso';
$string['resourcedisplayauto'] = 'Automático';
$string['resourcedisplaydownload'] = 'Forzar descarga';
$string['resourcedisplayembed'] = 'Incrustar';
$string['resourcedisplayframe'] = 'En el marco';
$string['resourcedisplaynew'] = 'Nueva ventana';
$string['resourcedisplayopen'] = 'Abrir';
$string['resourcedisplaypopup'] = 'En ventana emergente';
$string['resources'] = 'Recursos';
$string['resources_help'] = 'Los tipos de recurso posibilitan que prácticamente cualquier contenido web se pueda insertar en el curso.';
$string['restore'] = 'Restaurar';
$string['restorecancelled'] = 'Cancelada la restauración';
$string['restorecannotassignroles'] = 'La restauración necesita asignar roles y usted carece de permiso para hacerlo';
$string['restorecannotcreateorassignroles'] = 'La restauración necesita crear o asignar roles y usted carece de permiso para hacerlo';
$string['restorecannotcreateuser'] = 'La restauración necesita crear un usuario \'{$a}\' a partir de la copia de seguridad y usted carece de permiso para hacerlo';
$string['restorecannotoverrideperms'] = 'La restauración necesita anular permisos y usted carece de permiso para hacerlo';
$string['restorecoursenow'] = 'Restaurar este curso ahora';
$string['restoredaccount'] = 'Cuenta restaurada';
$string['restoredaccountinfo'] = 'Esta cuenta se ha importado de otro servidor y la contraseña se ha perdido. Para fijar una nueva contraseña por email, haga clic en "Continuar"';
$string['restorefinished'] = 'Restauración completada con éxito';
$string['restoreinfo'] = 'Usar una copia de seguridad para restaurar una versión anterior de un curso, o para crear un nuevo curso.';
$string['restoremnethostidmismatch'] = 'Id de Host MNet de usuario \'{$a}\' no es igual al id de Host MNet local.';
$string['restoreto'] = 'Restaurar a';
$string['restoretositeadding'] = '¡Advertencia: Está a punto de restaurar la página principal del sitio añadiéndole datos!';
$string['restoretositedeleting'] = 'Advertencia: Está a punto de restaurar la página principal del sitio eliminando primero sus datos.';
$string['restoreuserconflict'] = 'Tratar de restaurar al usuario \'{$a}\' a partir del archivo de copia de seguridad puede ocasionar conflicto';
$string['restoreuserinfofailed'] = 'El proceso de restauración se ha detenido porque usted no tiene permiso para restaurar datos de usuario.';
$string['restoreusersprecheck'] = 'Comprobando los datos de usuario';
$string['restoreusersprecheckerror'] = 'Se han detectado problemas en la comprobación de los datos de usuario';
$string['restricted'] = 'Restringido';
$string['resultsfound'] = '{$a} resultados encontrados';
$string['retry'] = 'Inténtelo de nuevo';
$string['returningtosite'] = 'Usuarios registrados';
$string['returntooriginaluser'] = 'Volver a \'{$a}\'';
$string['revert'] = 'Revertir';
$string['role'] = 'Rol';
$string['roleassignments'] = 'Asignaciones de roles';
$string['rolemappings'] = 'Mapeos de rol';
$string['rolerenaming'] = 'Renombrar rol';
$string['rolerenaming_help'] = 'Cambiar los nombres a mostrar de los roles de este curso.';
$string['rolerenaming_success'] = 'Nombres de roles de curso actualizados';
$string['roles'] = 'Roles';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Número de artículos recientes RSS';
$string['rsserror'] = 'Error al leer datos RSS';
$string['rsserrorauth'] = 'Su enlace RSS no contiene una ficha de identificación válida.';
$string['rsserrorguest'] = 'Esta fuente utiliza el acceso de invitados para acceder a los datos, pero el invitado no tiene permiso para leer los datos. Visite la ubicación original de la que esta fuente proviene (URL) como un usuario válido y obtenga de allí un nuevo enlace RSS.';
$string['rsskeyshelp'] = '<p>Para garantizar la seguridad y la privacidad, las direcciones URL RSS feed contienen un \'testigo\' especial que identifica al usuario para el que son. Esto impide que otros usuarios accedan a áreas de Moodle a las que no deben tener acceso.</p><p>Este \'testigo\' se crea automáticamente la primera vez que accede a un área que produce una fuente RSS. Si usted piensa que su \'testigo\' de fuente RSS ha sido comprometido de alguna manera, usted puede solicitar uno nuevo haciendo clic en el vínculo restablecer enlace. Tenga en cuenta que la URL de la fuente RSS actual dejará de ser válida.</p>';
$string['rsstype'] = 'Canal RSS para esta actividad';
$string['save'] = 'Guardar';
$string['saveandnext'] = 'Guardar y mostrar siguiente';
$string['savechanges'] = 'Guardar cambios';
$string['savechangesanddisplay'] = 'Guardar cambios y mostrar';
$string['savechangesandreturn'] = 'Guardar y volver';
$string['savechangesandreturntocourse'] = 'Guardar cambios y regresar al curso';
$string['savecomment'] = 'Guardar comentario';
$string['savedat'] = 'Guardado en:';
$string['savepreferences'] = 'Guardar preferencias';
$string['saveto'] = 'Guardar en';
$string['scale'] = 'Escala';
$string['scale_help'] = 'Una escala proporciona una manera de evaluar o calificar el desempeño en una actividad. Está definida por una lista ordenada de valores, que van de negativo a positivo, separados por comas; por ejemplo, "Decepcionante, Insuficiente, Promedio, Bueno, Muy bueno, Excelente".';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Escalas';
$string['scalescustom'] = 'Escalas personalizadas';
$string['scalescustomcreate'] = 'Agregar una nueva escala';
$string['scalescustomno'] = 'Aún no se han creado nuevas escalas';
$string['scalesstandard'] = 'Escalas estándar';
$string['scalestandard'] = 'Escala estándar';
$string['scalestandard_help'] = 'Una escala estándar es una que está disponible globalmente en el sitio, para todos los cursos.';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'Para crear escalas personalizadas utilice el enlace \'Escalas...\' en el menú de administración del curso.';
$string['scalestip2'] = 'Para crear escalas personalizadas, haga clic en el enlace Calificaciones del menú de administración del curso, luego seleccione Editar, Escalas.';
$string['schedule'] = 'Programación';
$string['screenshot'] = 'Pantallazo';
$string['search'] = 'Buscar';
$string['search_help'] = 'Para realizar una búsqueda básica de una o más palabras en cualquier lugar del texto, simplemente escríbalas separadas por espacios. Se usarán todas las palabras de más de dos caracteres.

Para realizar una búsqueda avanzada, pulse el botón de búsqueda sin teclear nada en la caja de texto para acceder al formulario de búsqueda avanzada.';
$string['searchactivities'] = 'Buscar actividades por nombre o descripción';
$string['searchagain'] = 'Volver a buscar';
$string['searchbyemail'] = 'Buscar por dirección email';
$string['searchbyusername'] = 'Buscar por nombre de usuario';
$string['searchcoursecategories'] = 'Buscar categorías';
$string['searchcourses'] = 'Buscar cursos';
$string['searchgroups'] = 'Buscar grupos';
$string['searchitems'] = 'Buscar ítems';
$string['searchoptions'] = 'Opciones de búsqueda';
$string['searchresults'] = 'Resultados de la búsqueda';
$string['searchusers'] = 'Buscar usuarios';
$string['sec'] = 'segundos';
$string['seconds'] = 'segundos';
$string['secondsleft'] = '{$a} segundos';
$string['secondstotime172800'] = '2 días';
$string['secondstotime259200'] = '3 días';
$string['secondstotime345600'] = '4 días';
$string['secondstotime432000'] = '5 días';
$string['secondstotime518400'] = '6 días';
$string['secondstotime604800'] = '1 semana';
$string['secondstotime86400'] = '1 día';
$string['secretalreadyused'] = 'El enlace de confirmación de cambio de contraseña ya se ha utilizado, y la contraseña no se ha cambiado.';
$string['secs'] = 'segundos';
$string['section'] = 'Sección';
$string['sectionactionnotsupported'] = 'La sección acción "{$a} no es soportada aquí';
$string['sectionname'] = 'Nombre de sección';
$string['sectionoutline'] = 'Perfilado de sección';
$string['sections'] = 'Secciones';
$string['seealsostats'] = 'Ver también: estadísticas';
$string['selctauser'] = 'Seleccionar un usuario';
$string['select'] = 'Seleccionar';
$string['selectacategory'] = 'Por favor, seleccione una categoría';
$string['selectacountry'] = 'Seleccione su país';
$string['selectacourse'] = 'Seleccionar un curso';
$string['selectacoursesite'] = 'Seleccione un curso o un sitio';
$string['selectagroup'] = 'Seleccionar un grupo';
$string['selectall'] = 'Seleccionar todos';
$string['selectallusersonpage'] = 'Seleccione a todos los usuarios en esta página';
$string['selectalluserswithcount'] = 'Seleccione a todos los usuarios {$a}';
$string['selectamodule'] = 'Por favor, seleccione un módulo de actividad';
$string['selectanaction'] = 'Seleccionar acciones';
$string['selectanoptions'] = 'Seleccione una opción';
$string['selectaregion'] = 'Seleccionar una región';
$string['selectcategorysort'] = '¿Qué categorías desearía ordenar?';
$string['selectcategorysortby'] = 'Seleccione cómo le gustaría ordenar las categorías';
$string['selectcoursesortby'] = 'Seleccione cómo le gustaría ordenar los cursos';
$string['selectdates'] = 'Seleccione fechas';
$string['selectdefault'] = 'Seleccionar por defecto';
$string['selectedcategories'] = 'Categorías seleccionadas';
$string['selectedfile'] = 'Archivo seleccionado';
$string['selectednowmove'] = '{$a} archivos seleccionados para mover. Ahora vaya a la carpeta de destino y pulse sobre \'Mover archivos aquí\'';
$string['selectfiles'] = 'Seleccionar archivos';
$string['selectfiltertype'] = 'Seleccionar';
$string['selectgroupsseparate'] = 'Seleccionar grupos separados';
$string['selectgroupsvisible'] = 'Seleccionar grupos visibles';
$string['selectitem'] = 'Seleccionar \'{$a}\'';
$string['selectmoduletoviewhelp'] = 'Seleccione una actividad o un recurso para ver la ayuda.

Haga doble clic en el nombre de una actividad o recurso para añadirla de forma rápida';
$string['selectnos'] = 'Seleccione todos \'no\'';
$string['selectperiod'] = 'Seleccionar período';
$string['selecttheme'] = 'Seleccionar tema';
$string['selectthemename'] = 'Seleccionar tema "{$a}"';
$string['senddetails'] = 'Enviar detalles por correo electrónico';
$string['sent'] = 'Enviar';
$string['separate'] = 'Separar';
$string['separateandconnected'] = 'Vías de conocimiento separadas y conectadas';
$string['separateandconnected1'] = 'Conocimiento mayoritariamente separado';
$string['separateandconnected2'] = 'Separado y conectado';
$string['separateandconnected3'] = 'Conocimiento mayoritariamente conectado';
$string['separateandconnectedinfo'] = 'La escala está basada en la teoría de las vías de conocimiento separadas (aprendizaje individual)  y conectadas (aprendizaje colaborativo). Esta teoría describe dos maneras diferentes con las que podemos evaluar y aprender a partir de lo que vemos y oímos. <li><strong> Conocedores separados (individulaistas) </strong> se mantiene lo la más objetivso posible, sin incluir sentimientos y emociones. En una discusión con otras personas, les gusta defender sus propias ideas, usando la lógica para encontrar fisuras en las ideas del adversario. </li> <li> <strong> Conocedores conectados (colaborativos) </strong> son más sensibles a otras personas. Son expertos en empatía y tienden a escuchar y hacer preguntas hasta que sienten que pueden conectar y "entender las cosas desde otros punto de vista". Aprenden tratando de compartir experiencias lo que les permite encontrar el conocimiento en las demás personas.';
$string['servererror'] = 'Se produjo un error mientras se comunicaba con el servidor';
$string['serverlocaltime'] = 'Hora local del servidor';
$string['sessionforceclean'] = 'Como medida de seguridad, los scripts generados por el usuario se han desactivado dentro de esta sesión.';
$string['sessiontimeoutsoon'] = 'Su sesión está a punto de caducar. ¿Quiere extender su sesión actual?';
$string['setcategorytheme'] = 'Ajustar el tema de la categoría';
$string['setmode'] = 'Modo de ajuste';
$string['setpassword'] = 'Establecer contraseña';
$string['setpasswordinstructions'] = 'Por favor, introduzca la nueva contraseña arriba y guarde los cambios.';
$string['settings'] = 'Configuración';
$string['share'] = 'Compartir';
$string['shortname'] = 'Nombre corto';
$string['shortnamecollisionwarning'] = '[*] = Este nombre corto ya está en uso por un curso, y necesita cambiarse hasta que se apruebe';
$string['shortnamecourse'] = 'Nombre corto del curso';
$string['shortnamecourse_help'] = 'El nombre a mostrar en zonas con espacio limitado. Debe ser único.';
$string['shortnametaken'] = 'Este nombre corto ya está en uso en otro curso ({$a})';
$string['shortnameuser'] = 'Nombre corto del usuario';
$string['shortsitename'] = 'Nombre corto para el sitio (una palabra)';
$string['show'] = 'Mostrar';
$string['showactions'] = 'Mostrar acciones';
$string['showactivitydates'] = 'Mostrar fechas de actividad';
$string['showactivitydates_help'] = 'Mostrar fechas de actividades en la página del curso.';
$string['showadvancededitor'] = 'Avanzada';
$string['showadvancedsettings'] = 'Mostrar ajustes avanzados';
$string['showall'] = 'Mostrar {$a}';
$string['showallcourses'] = 'Mostrar todos los cursos';
$string['showblockcourse'] = 'Mostrar lista de cursos que contienen bloque';
$string['showcategory'] = 'Mostrar {$a}';
$string['showchartdata'] = 'Mostrar datos del gráfico';
$string['showcomments'] = 'Mostrar/ocultar comentario';
$string['showcommentsnonjs'] = 'Mostrar comentarios';
$string['showdescription'] = 'Muestra la descripción en la página del curso';
$string['showdescription_help'] = 'Si se activa, la descripción anterior se mostrará en la página del curso justo debajo del enlace a la actividad o recurso.';
$string['showgrades'] = 'Mostrar libro de calificaciones a los estudiantes';
$string['showgrades_help'] = 'Permitir a los estudiantes ver una lista de todas sus calificaciones en el curso.';
$string['showingacourses'] = 'Mostrando todos {$a} cursos';
$string['showingxofycourses'] = 'Mostrando cursos {$a->start} a {$a->end} de {$a->total} cursos';
$string['showless'] = 'Mostrar menos';
$string['showlistofcourses'] = 'Mostrar listas de cursos';
$string['showmodulecourse'] = 'Mostrar lista de cursos que contienen actividad';
$string['showmore'] = 'Mostrar más';
$string['showoncoursepage'] = 'Mostrar en la página del curso';
$string['showonly'] = 'Mostrar solamente';
$string['showperpage'] = 'Mostrar {$a} por página';
$string['showpopovermenu'] = 'Abrir ventana emergente';
$string['showpopoverwindow'] = 'Mostar ventanas emergentes';
$string['showrecent'] = 'Mostrar actividad reciente';
$string['showreports'] = 'Mostrar informes de actividad';
$string['showreports_help'] = 'Permitir a los estudiantes ver sus propios registros de actividad a través de su página de perfil.';
$string['showsettings'] = 'Mostrar ajustes';
$string['showtheselogs'] = 'Mostrar estos registros';
$string['showthishelpinlanguage'] = 'Mostrar esta ayuda en el idioma: \'{$a}\'';
$string['sidepanel'] = 'Panel lateral';
$string['signoutofotherservices'] = 'Salir de todas las apps web';
$string['signoutofotherservices_help'] = 'Si se ha identificado, la cuenta se cerrará de todos los dispositivos y sistemas que utilizan servicios web, como la aplicación para dispositivos móviles. Las sesiones de navegador se mantendrán.';
$string['since'] = 'Desde';
$string['sincelast'] = 'desde el último acceso';
$string['site'] = 'Sitio';
$string['sitedefault'] = 'Configuración por defecto del sitio';
$string['sitedefaultspecified'] = 'Configuración por defecto del sitio ({$a})';
$string['siteerrors'] = 'Errores de sitio';
$string['sitefiles'] = 'Archivos del sitio';
$string['sitefilesused'] = 'Archivos del sitio usados en este curso';
$string['sitehome'] = 'Página principal del sitio';
$string['sitelegacyfiles'] = 'Archivos heredados del sitio';
$string['sitelogs'] = 'Registros del sitio';
$string['sitenews'] = 'Anuncios de la página';
$string['sitepages'] = 'Páginas del sitio';
$string['sitepartlist'] = 'No dispone de los permisos necesarios para ver la lista de participantes';
$string['sitepartlist0'] = 'Para poder ver la lista de participantes, usted debe ser un profesor del sitio';
$string['sitepartlist1'] = 'Para poder ver la lista de participantes, usted debe ser un profesor';
$string['sites'] = 'Sitios';
$string['sitesection'] = 'Añadir contenido personalizado';
$string['sitesettings'] = 'Configurar el sitio';
$string['siteteachers'] = 'Profesores del sitio';
$string['size'] = 'Tamaño';
$string['sizeb'] = 'bytes';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Pasado por alto';
$string['skiptocategorylisting'] = 'Ir a la lista de categorías';
$string['skiptocoursedetails'] = 'Ir a la información detallada del curso';
$string['skiptocourselisting'] = 'Ir a la lista de cursos';
$string['someallowguest'] = 'Algunos cursos permiten el acceso de invitados';
$string['someerrorswerefound'] = 'Falta alguna información o es incorrecta. Abajo aparecen más detalles.';
$string['sort'] = 'Ordenar';
$string['sortby'] = 'Ordenar por';
$string['sortbyx'] = 'Ordenar por {$a} ascendente';
$string['sortbyxreverse'] = 'Ordenar por {$a} descendente';
$string['sorting'] = 'Ordenando';
$string['sourcerole'] = 'Rol fuente';
$string['specifyname'] = 'Debe especificar un nombre.';
$string['standard'] = 'Estándar';
$string['starpending'] = '([*] = curso pendiente de aprobación)';
$string['startdate'] = 'Fecha de inicio del curso';
$string['startdate_help'] = 'Este ajuste determina el comienzo de la primera semana para un curso en formato semanal. También determina la fecha más temprana para la que existirá registro de las actividades del curso.

Si se reinicia el curso y la fecha de inicio del curso se modifica, todas las fechas en el curso se trasladarán en relación a la nueva fecha de inicio.';
$string['startdatewithtaskenabled'] = 'Fecha de comienzo del curso';
$string['startdatewithtaskenabled_help'] = 'La fecha en que el curso se vuelve visible para estudiantes. Antes de esta fecha no podrán acceder a él.

Esta fecha también determina el comienzo de la primera semana de un curso en formato semanal, y es la fecha de comienzo de registro de actividades del curso. Si reinicia el curso y cambia esta fecha, todas las fechas del curso se desplazarán en relación a la nueva fecha de comienzo.';
$string['startingfrom'] = 'Comienzo en';
$string['startsignup'] = 'Crear nueva cuenta';
$string['state'] = 'Estado/Municipio';
$string['statistics'] = 'Estadísticas';
$string['statisticsgraph'] = 'Gráfico de estadísticas';
$string['stats'] = 'Estadísticas';
$string['statslogins'] = 'Accesos';
$string['statsmodedetailed'] = 'Vista detallada (usuario)';
$string['statsmodegeneral'] = 'Vista general';
$string['statsnodata'] = 'No existen datos para esa combinación de curso y período de tiempo.';
$string['statsnodatauser'] = 'No existen datos disponibles para esa combinación de curso, usuario y período de tiempo.';
$string['statsoff'] = 'Las estadísticas no están habilitadas actualmente';
$string['statsreads'] = 'Vistas';
$string['statsreport1'] = 'Accesos';
$string['statsreport10'] = 'Actividad del usuario';
$string['statsreport11'] = 'Cursos más activos';
$string['statsreport12'] = 'Cursos más activos (ponderados)';
$string['statsreport13'] = 'Cursos con más participación (matriculaciones)';
$string['statsreport14'] = 'Cursos con más participación (vistas/mensajes)';
$string['statsreport2'] = 'Vistas (todos los roles)';
$string['statsreport3'] = 'Mensajes (todos los roles)';
$string['statsreport4'] = 'Toda la actividad (todos los roles)';
$string['statsreport5'] = 'Toda la actividad (vistas y mensajes)';
$string['statsreport7'] = 'Actividad del usuario (vistas y mensajes)';
$string['statsreport8'] = 'Toda la actividad del usuario';
$string['statsreport9'] = 'Accesos (sitio y curso)';
$string['statsreportactivity'] = 'Toda la actividad (profesor y estudiante)';
$string['statsreportactivitybyrole'] = 'Toda la actividad (vistas y mensajes)';
$string['statsreportforuser'] = 'para';
$string['statsreportlogins'] = 'Accesos';
$string['statsreportreads'] = 'Vistas (todos los roles)';
$string['statsreporttype'] = 'Tipo de informe';
$string['statsreportwrites'] = 'Mensajes (todos los roles)';
$string['statsstudentactivity'] = 'Actividad del estudiante';
$string['statsstudentreads'] = 'Vistas del estudiante';
$string['statsstudentwrites'] = 'Mensajes del estudiante';
$string['statsteacheractivity'] = 'Actividad del profesor';
$string['statsteacherreads'] = 'Vistas del profesor';
$string['statsteacherwrites'] = 'Mensajes del profesor';
$string['statstimeperiod'] = 'Período de tiempo - último:';
$string['statsuniquelogins'] = 'Accesos únicos';
$string['statsuseractivity'] = 'Toda la actividad';
$string['statsuserlogins'] = 'Accesos';
$string['statsuserreads'] = 'Vistas';
$string['statsuserwrites'] = 'Mensajes';
$string['statswrites'] = 'Mensajes';
$string['status'] = 'Estado';
$string['statuschecks'] = 'Comprobaciones de estado';
$string['statuscritical'] = 'Crítico';
$string['statusdone'] = 'Hecho';
$string['statuserror'] = 'Error';
$string['statusinfo'] = 'Información';
$string['statusna'] = 'No disponible';
$string['statusok'] = 'OK';
$string['statusunknown'] = 'Desconocido';
$string['statuswarning'] = 'Advertencia';
$string['stringsnotset'] = 'Las siguientes cadenas no están definidas en {$a}';
$string['studentnotallowed'] = 'Lo sentimos, pero no puede entrar a este curso como \'{$a}\'';
$string['students'] = 'Estudiantes';
$string['studentsandteachers'] = 'Estudiantes y profesores';
$string['subcategories'] = 'Subcategorías';
$string['subcategory'] = 'Subcategoría';
$string['subcategoryof'] = 'Subcategoría de {$a}';
$string['subject'] = 'Asunto';
$string['submit'] = 'Enviar';
$string['subsectionmoveerror'] = 'No puede mover esta subsección dentro de otra subsección';
$string['success'] = 'Éxito';
$string['successduration'] = 'Éxito ({$a} segundos)';
$string['summary'] = 'Resumen';
$string['suspended'] = 'Suspendido';
$string['suspendedusers'] = 'Usuarios expulsados';
$string['switchdevicedefault'] = 'Cambiar al tema estándar';
$string['switchdevicerecommended'] = 'Cambiar al tema recomendado para su dispositivo';
$string['switchrolereturn'] = 'Volver a mi rol normal';
$string['switchroleto'] = 'Cambiar rol a...';
$string['switchroleto_help'] = 'Elija un rol para tener una idea de cómo alguien con ese rol verá este curso.

Tenga en cuenta que esta vista puede no ser perfecta (<a href="https://docs.moodle.org/en/Switch_roles">Ver detalles y alternativas</a>).';
$string['tag'] = 'Marca';
$string['tagalready'] = 'Esta marca ya existe';
$string['tagmanagement'] = 'Agregar/Eliminar marcas';
$string['tags'] = 'Marcas';
$string['targetrole'] = 'Rol destino';
$string['teacheronly'] = 'para {$a} solamente';
$string['teacherroles'] = 'roles de {$a}';
$string['teachers'] = 'Profesores';
$string['textcopiedtoclipboard'] = 'Texto copiado al portapapeles';
$string['textediting'] = 'Editor de texto';
$string['textediting_help'] = 'Si se selecciona un editor HTML como Atto o TinyMCE, las áreas de entrada de texto tendrán una barra de herramientas con botones para agregar contenido fácilmente.

Si se selecciona \'área de texto plano\', se podrán elegir los formatos HTML o Markdown para las áreas de entrada de texto.

La lista de los editores de texto disponibles es determinada por el administrador del sitio.';
$string['texteditor'] = 'Use formas estándar de HTML';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Formato de texto';
$string['thanks'] = 'Gracias';
$string['theme'] = 'Tema';
$string['themepreviewdescription'] = 'Descripción del tema {$a}';
$string['themepreviewimage'] = 'Vista previa de imagen {$a}';
$string['themes'] = 'Temas';
$string['themesaved'] = 'Se ha guardado el nuevo tema';
$string['therearecourses'] = 'Hay {$a} cursos';
$string['thereareno'] = 'No hay {$a} en este curso';
$string['thiscategory'] = 'Esta categoría';
$string['thiscategorycontains'] = 'Esta categoría contiene';
$string['time'] = 'Hora';
$string['timecreated'] = 'Fecha de matriculación al curso';
$string['timecreatedcourse'] = 'Hora de creación del curso';
$string['timesplitting:deciles'] = 'Décimas';
$string['timesplitting:deciles_help'] = 'Este intervalo de análisis divide el curso en décimas (10 partes iguales), y cada predicción se basa en los datos de la décima anterior más reciente.';
$string['timesplitting:decilesaccum'] = 'Décimas acumuladas';
$string['timesplitting:decilesaccum_help'] = 'El intervalo de análisis divide el curso en décimos (10 partes iguales), y cada predicción está basada en los datos de todos los décimos anteriores.';
$string['timesplitting:nosplitting'] = 'Sin límite de tiempo';
$string['timesplitting:nosplitting_help'] = 'No se define ningún intervalo de análisis para este modelo.';
$string['timesplitting:onemonthafterstart'] = 'Un mes después del inicio';
$string['timesplitting:onemonthafterstart_help'] = 'Este intérvalo de análisis genera una predicción 1 mes después del inicio analizable.';
$string['timesplitting:oneweekafterstart'] = 'Una semana después del inicio';
$string['timesplitting:oneweekafterstart_help'] = 'Este intérvalo de análisis genera una predicción 1 semana después del inicio analizable.';
$string['timesplitting:past3days'] = 'Últimos 3 días';
$string['timesplitting:past3days_help'] = 'Este intervalo de análisis genera predicciones cada 3 días. Los cálculos se basarán en los últimos 3 días.';
$string['timesplitting:pastmonth'] = 'Mes pasado';
$string['timesplitting:pastmonth_help'] = 'Este intérvalo de análisis genera predicciones cada mes. Los cálculos de los indicadores se basarán en el último mes.';
$string['timesplitting:pastweek'] = 'Semana pasada';
$string['timesplitting:pastweek_help'] = 'Este intérvalo de análisis genera predicciones cada semana. Los cálculos de los indicadores se basarán en la semana anterior.';
$string['timesplitting:quarters'] = 'Último cuarto';
$string['timesplitting:quarters_help'] = 'Este intervalo de análisis divide el curso en cuartos (4 partes iguales), y cada predicción se basa únicamente en los datos del cuarto anterior más reciente.';
$string['timesplitting:quartersaccum'] = 'Todos los trimestres anteriores';
$string['timesplitting:quartersaccum_help'] = 'Este intervalo de análisis divide el curso en cuartos (4 partes iguales), y cada predicción se basa en los datos acumulados de todos los cuartos anteriores.';
$string['timesplitting:singlerange'] = 'Desde el principio hasta el final';
$string['timesplitting:singlerange_help'] = 'Este intervalo de análisis considera todo el curso como un único lapso.';
$string['timesplitting:tenpercentafterstart'] = '10% después del inicio';
$string['timesplitting:tenpercentafterstart_help'] = 'Este intérvalo de análisis genera una predicción después de completar el 10% del curso.';
$string['timesplitting:upcoming3days'] = 'Próximos 3 días';
$string['timesplitting:upcoming3days_help'] = 'Este intervalo de análisis genera predicciones cada 3 días. Los cálculos de indicadores se basarán en los 3 días próximos.';
$string['timesplitting:upcomingfortnight'] = 'Próxima quincena';
$string['timesplitting:upcomingfortnight_help'] = 'Este intervalo de análisis genera predicciones cada 2 semanas. Los cálculos de indicadores se basarán en las 2 semanas próximas.';
$string['timesplitting:upcomingweek'] = 'Próxima semana';
$string['timesplitting:upcomingweek_help'] = 'Este intervalo de análisis genera predicciones cada semana. Los cálculos de indicadores se basarán en la semana próxima.';
$string['timezone'] = 'Zona horaria';
$string['tocontent'] = 'Al elemento "{$a}"';
$string['tocreatenewaccount'] = 'Saltar a creación de una nueva cuenta';
$string['todate'] = 'Hasta';
$string['today'] = 'Hoy';
$string['todaylogs'] = 'Registros de hoy';
$string['toeveryone'] = 'a todos';
$string['toggleemojipicker'] = 'Selector de emoticono';
$string['togglesearch'] = 'Selector de búsqueda de entrada';
$string['toomanybounces'] = 'Esta dirección de correo ha tenido muchas devoluciones. <b>Debe</b> cambiarla para continuar.';
$string['toomanytags'] = 'Esta búsqueda incluyó demasiadas etiquetas; algunas habrán sido ignoradas.';
$string['toomanytoshow'] = 'Hay demasiados usuarios para mostrarlos aquí';
$string['toomanyusersmatchsearch'] = 'Demasiados usuarios ({$a->count}) coinciden con \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Demasiados usuarios ({$a}) para mostrar';
$string['toonly'] = 'sólo a {$a}';
$string['top'] = 'Superior';
$string['topic'] = 'Tema';
$string['toplevelcategory'] = 'Categoría de nivel superior';
$string['torecipient'] = 'Hasta';
$string['total'] = 'Total';
$string['totopofsection'] = 'Al inicio de la sección "{$a}"';
$string['trackforums'] = 'Rastreo del foro';
$string['trackforumsno'] = 'No: no registrar los mensajes que he visto';
$string['trackforumsyes'] = 'Sí: resaltar los mensajes nuevos';
$string['trysearching'] = 'Intente una búsqueda en su lugar.';
$string['turneditingoff'] = 'Desactivar edición';
$string['turneditingon'] = 'Activar edición';
$string['unabletocopytoclipboard'] = 'No fue posible copiar el texto al portapapeles';
$string['unauthorisedlogin'] = 'La cuenta del usuario "{$a}" no está disponible en este sitio';
$string['undecided'] = 'No decidido';
$string['unexistingcmid'] = 'ID de módulo de curso no encontrado';
$string['unexistingsectionid'] = 'ID de sección de curso no encontrado';
$string['unfinished'] = 'Sin terminar';
$string['unknowncategory'] = 'Categoría desconocida';
$string['unknownerror'] = 'Error desconocido';
$string['unknownuser'] = 'Usuario desconocido';
$string['unlimited'] = 'Sin límite';
$string['unpacking'] = 'Abriendo {$a}';
$string['unsafepassword'] = 'Esta contraseña no es segura, intente otra';
$string['untilcomplete'] = 'Hasta que se complete';
$string['unusedaccounts'] = 'Las personas que no entren al curso durante {$a} días se darán de baja automáticamente. Su cuenta seguirá existiendo y podrán reinscribirse en cualquier momento.';
$string['unzip'] = 'Descomprimir';
$string['unzippingbackup'] = 'Descomprimiendo la copia de seguridad';
$string['up'] = 'Arriba';
$string['update'] = 'Actualizar';
$string['updated'] = 'Actualizado: {$a}';
$string['updatemymoodleoff'] = 'Dejar de personalizar esta página';
$string['updatemymoodleon'] = 'Personalizar esta página';
$string['updatemyprofile'] = 'Actualizar información personal';
$string['updatesevery'] = 'Actualizado cada {$a} segundos';
$string['updatethis'] = 'Actualizar {$a}';
$string['updatethiscourse'] = 'Actualizar este curso';
$string['upload'] = 'Subir';
$string['uploadafile'] = 'Subir un archivo';
$string['uploadcantwrite'] = 'No se pudo escribir el archivo en el disco';
$string['uploadedfile'] = 'Archivo subido con éxito';
$string['uploadedfileto'] = 'El archivo {$a->file} ha sido subido al directorio {$a->directory}';
$string['uploadedfiletoobig'] = 'Lo sentimos, el archivo es demasiado grande (el límite es de {$a} bytes)';
$string['uploadextension'] = 'Subida del archivo detenida por una extensión PHP';
$string['uploadfailednotrecovering'] = 'La subida del archivo ha fallado debido a un problema con uno de los archivos, {$a->name}.<br/> Éste es el registro de los problemas:<br />{$a->problem}<br />Sin recuperar.';
$string['uploadfilelog'] = 'Registro de subida para el archivo {$a}';
$string['uploadformlimit'] = 'El archivo subido {$a} sobrepasa el límite de tamaño máximo establecido por el formulario';
$string['uploadlabel'] = 'Título:';
$string['uploadlimitwithsize'] = '{$a->contextname} límite de subida ({$a->displaysize})';
$string['uploadnewfile'] = 'Subir un nuevo archivo';
$string['uploadnofilefound'] = 'No se encontró el archivo. ¿Está seguro de que seleccionó uno?';
$string['uploadnotallowed'] = 'No se permite subir archivos';
$string['uploadnotempdir'] = 'Falta un directorio temporal';
$string['uploadoldfilesdeleted'] = 'El(los) archivo(s) viejos de su área de subida ha(n) sido destruído(s)';
$string['uploadpartialfile'] = 'El archivo ha sido parcialmente subido';
$string['uploadproblem'] = 'Ha ocurrido un problema inesperado al subir {$a} (tal vez es demasiado grande).';
$string['uploadrenamedchars'] = 'El nombre del archivo se ha cambiado de {$a->oldname} a {$a->newname} debido a la existencia de caracteres no válidos.';
$string['uploadrenamedcollision'] = 'El nombre del archivo se ha cambiado de {$a->oldname} a {$a->newname} debido a la existencia de un conflicto con el nombre del archivo.';
$string['uploadserverlimit'] = 'El archivo subido sobrepasa el límite de tamaño máximo establecido por el servidor';
$string['uploadthisfile'] = 'Subir este archivo';
$string['url'] = 'URL';
$string['used'] = 'Usado';
$string['usedinnplaces'] = 'Usado en {$a} lugares';
$string['user'] = 'Usuario';
$string['useraccount'] = 'Cuenta de usuario';
$string['useractivity'] = 'Actividad';
$string['userconfirmed'] = 'Confirmado {$a}';
$string['userdata'] = 'Datos de usuario';
$string['userdeleted'] = 'Esta cuenta se ha cancelado';
$string['userdescription'] = 'Descripción';
$string['userdescription_help'] = 'Esta caja le permite escribir un texto sobre usted mismo. Luego se mostrará en la página de su perfil para que otras personas puedan verlo.

Por favor, cuide sus datos personales y considere IMPORTANTE tener la precaución de  no escribir "datos personales sensibles" (estado de salud, información genética, creencias religiosas, filosóficas y morales, afiliación sindical, opiniones políticas, orígen racial o étnico, preferencia sexual...) que pudieran causarle responsabilidades o riesgos innecesarios a Usted y a la Institución.';
$string['userdetails'] = 'Detalles de usuario';
$string['userfiles'] = 'Archivos del usuario';
$string['userlist'] = 'Lista de usuarios';
$string['usermatchedon'] = 'Este usuario coincide con la búsqueda mediante el siguiente campo';
$string['usermenu'] = 'Menú de usuario';
$string['usermenugoback'] = 'Ir atrás al menú de usuario';
$string['username'] = 'Nombre de usuario';
$string['usernameemail'] = 'Nombre de usuario o correo electrónico';
$string['usernameemailmatch'] = 'El nombre de usuario y la dirección de correo electrónico no se refieren al mismo usuario';
$string['usernameexists'] = 'Este nombre de usuario ya existe. Por favor, seleccione otro.';
$string['usernamelowercase'] = 'Sólo se permiten minúsculas';
$string['usernamenotfound'] = 'No se ha encontrado el nombre de usuario en la base de datos';
$string['usernameoremail'] = 'Escribir nombre de usuario o dirección email';
$string['usernotconfirmed'] = 'No se pudo confirmar {$a}';
$string['userpic'] = 'Imagen del usuario';
$string['userpreferences'] = 'Preferencias del usuario';
$string['users'] = 'Usuarios';
$string['userselectorautoselectunique'] = 'Si sólo un usuario coincide con la búsqueda, seleccionarlo automáticamente';
$string['userselectorpreserveselected'] = 'Mantener los usuarios seleccionados, incluso si no coinciden más con la búsqueda';
$string['userselectorsearchanywhere'] = 'Cualquier parte';
$string['userselectorsearchexactmatchonly'] = 'sólo coincidencias exactas';
$string['userselectorsearchfromstart'] = 'desde el principio';
$string['userselectorsearchmatching'] = 'Coincidiendo:';
$string['usersnew'] = 'Usuarios nuevos';
$string['usersnoaccesssince'] = 'Mostrar usuarios que han estado inactivos durante más de';
$string['userswithfiles'] = 'Usuarios con archivos';
$string['useruploadtype'] = 'Tipo de subida de usuario: {$a}';
$string['userzones'] = 'Zonas de usuarios';
$string['usetheme'] = 'Usar tema';
$string['usingexistingcourse'] = 'Usando un curso existente';
$string['validatehtml'] = 'Validar HTML';
$string['valuealreadyused'] = 'Este valor ya ha sido usado.';
$string['version'] = 'Versión';
$string['view'] = 'Vista';
$string['viewallcourses'] = 'Ver todos los cursos';
$string['viewallcoursescategories'] = 'Ver todos los cursos y categorías';
$string['viewallresults'] = 'Ver todos los resultados ({$a})';
$string['viewallsubcategories'] = 'Ver todas las subcategorías';
$string['viewfileinpopup'] = 'Ver archivo en ventana desplegable';
$string['viewing'] = 'Viendo:';
$string['viewmore'] = 'Ver más';
$string['viewprofile'] = 'Ver perfil';
$string['views'] = 'Vistas';
$string['viewsolution'] = 'ver solución';
$string['visible'] = 'Visible';
$string['visible_help'] = 'Esta opción determina si el curso aparece en la lista de cursos. Excepto los profesores y administradores, los usuarios no pueden entrar al curso.';
$string['visibletostudents'] = 'Visible a {$a}';
$string['warning'] = 'Advertencia';
$string['warningdeleteresource'] = 'ATENCIÓN: Un recurso hace referencia a {$a}. ¿Desea actualizar el recurso?';
$string['wcagcheck'] = 'Comprobación de Pautas de accesibilidad al contenido web (WCAG)';
$string['webpage'] = 'Página web';
$string['week'] = 'Semana';
$string['weeks'] = 'semanas';
$string['welcomeback'] = '¡Hola, {$a->firstname}! 👋';
$string['welcometocourse'] = 'Bienvenido/a a {$a}';
$string['welcometocoursetext'] = '¡Le damos la bienvenida a {$a->coursename}!

Si no lo ha hecho aún, debería actualizar su información personal para que sepamos algo más sobre usted:

<a href="{$a->profileurl}">{$a->profileurl}</a>';
$string['welcometosite'] = '¡Bienvenido/a, {$a->firstname}! 👋';
$string['whatforlink'] = '¿Qué quiere hacer con el enlace?';
$string['whatforpage'] = '¿Qué quiere hacer con el texto?';
$string['whatisyourage'] = '¿Qué edad tiene?';
$string['whattocallzip'] = '¿Cómo quiere que se llame el archivo zip?';
$string['whattodo'] = 'Qué hacer';
$string['wheredoyoulive'] = '¿En qué país vive?';
$string['whyisthisrequired'] = '¿Por qué es necesario esto?';
$string['windowclosing'] = 'Esta ventana debería cerrarse automáticamente. De no ser así, ciérrela ahora, por favor.';
$string['withchosenfiles'] = 'Con los archivos escogidos';
$string['withdisablednote'] = '{$a} (desactivado)';
$string['withoutuserdata'] = 'sin datos de usuario';
$string['withselectedusers'] = 'Con los usuarios seleccionados...';
$string['withuserdata'] = 'con datos de usuario';
$string['wontrunfuturescheduledtask'] = 'No ejecutará una prueba que no haya fallado y esté agendada para ejecutarse en el futuro.';
$string['wordforstudent'] = 'Su palabra para Estudiante';
$string['wordforstudenteg'] = 'por ejemplo: Estudiante, Alumno, Participante, etc.';
$string['wordforstudents'] = 'Su palabra para Estudiantes';
$string['wordforstudentseg'] = 'por ejemplo: Estudiantes, Alumnos, Participantes, etc.';
$string['wordforteacher'] = 'Su palabra para Profesor';
$string['wordforteachereg'] = 'por ejemplo: Profesor, Tutor, Asesor, etc.';
$string['wordforteachers'] = 'Su palabra para Profesores';
$string['wordforteacherseg'] = 'por ejemplo: Profesores, Tutores, Asesores, etc.';
$string['writingblogsinfo'] = 'Escribiendo información de blogs';
$string['writingcategoriesandquestions'] = 'Escribiendo categorías y preguntas';
$string['writingcoursedata'] = 'Escribiendo información del curso';
$string['writingeventsinfo'] = 'Escribiendo información del evento';
$string['writinggeneralinfo'] = 'Escribiendo información general';
$string['writinggradebookinfo'] = 'Escribiendo información del libro de calificaciones';
$string['writinggroupingsgroupsinfo'] = 'Escribiendo información de agrupamientos/grupos';
$string['writinggroupingsinfo'] = 'Escribiendo información de agrupamientos';
$string['writinggroupsinfo'] = 'Escribiendo información de grupos';
$string['writingheader'] = 'Escribiendo el encabezado';
$string['writingloginfo'] = 'Escribiendo información de registros';
$string['writingmessagesinfo'] = 'Escribiendo información de mensajes';
$string['writingmoduleinfo'] = 'Escribiendo información del módulo';
$string['writingscalesinfo'] = 'Escribiendo información de escalas';
$string['writinguserinfo'] = 'Escribiendo información del usuario';
$string['wrongpassword'] = 'Contraseña incorrecta para este nombre de usuario';
$string['year'] = 'año';
$string['years'] = 'años';
$string['yes'] = 'Sí';
$string['youareabouttocreatezip'] = 'Está a punto de crear un archivo \'zip\' que contiene';
$string['youaregoingtorestorefrom'] = 'Está a punto de comenzar el proceso de restauración de';
$string['youhaveupcomingactivitiesdue'] = 'Tiene actividades próximas pendientes';
$string['youhaveupcomingactivitiesdueinfo'] = 'Hola, {$a},

<br/><br/>Tienes actividades próximas pendientes:';
$string['youneedtoenrol'] = 'Para llevar a cabo esta acción necesita matricularse en este curso.';
$string['yourlastlogin'] = 'Su último acceso fue el';
$string['yourself'] = 'usted';
$string['yourteacher'] = 'su {$a}';
$string['yourwordforx'] = 'Su palabra para \'{$a}\'';
$string['zippingbackup'] = 'Comprimiendo la copia de seguridad';
