<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'ai', language 'sk', version '5.1'.
 *
 * @package     ai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptai'] = 'Prijať a pokračovať';
$string['action'] = 'Akcia';
$string['action_explain_text'] = 'Vysvetliť text';
$string['action_explain_text_desc'] = 'Vysvetľuje obsah textu na stránke kurzu.';
$string['action_explain_text_instruction'] = 'Od používateľa dostanete textový vstup. Vašou úlohou je vysvetliť zadaný text. Postupujte podľa týchto pokynov:
    1. Vypracujte: Rozšírte kľúčové myšlienky a pojmy, pričom dbajte na to, aby vysvetlenie pridalo zmysluplnú hĺbku a vyhlo sa doslovnému opakovaniu textu.
    2. Zjednodušte: Rozložte zložité pojmy alebo myšlienky na jednoduchšie zložky, aby boli ľahko zrozumiteľné pre široké publikum vrátane študentov.
    3. Uveďte kontext: Vysvetlite, prečo sa niečo deje, ako to funguje alebo aký to má účel. V prípade potreby uveďte relevantné príklady alebo analógie na zlepšenie pochopenia.
    4. Logicky usporiadajte: Vyskladajte svoje vysvetlenie tak, aby prirodzene plynulo, začnite základnými myšlienkami a až potom prejdite na jemnejšie detaily.

Dôležité pokyny:
    1. Odovzdajte zhrnutie len v obyčajnom texte.
    2. Nevkladajte žiadne formátovanie značiek, pozdravy ani frázy.
    3. Zamerajte sa na jasnosť, stručnosť a prístupnosť.


Uistite sa, že vysvetlenie je ľahko čitateľné a účinne vyjadruje hlavné body pôvodného textu.';
$string['action_generate_image'] = 'Generovať obrázok';
$string['action_generate_image_desc'] = 'Generuje obrázok na základe textovej výzvy.';
$string['action_generate_text'] = 'Generovať text';
$string['action_generate_text_desc'] = 'Generuje text na základe textovej výzvy.';
$string['action_generate_text_instruction'] = 'Od používateľa dostanete textový vstup. Vašou úlohou je vygenerovať text na základe jeho požiadavky. Postupujte podľa týchto dôležitých pokynov:
    1. Vráťte súhrn len v obyčajnom texte.
    2. Nezahrňujte žiadne formátovanie značiek, pozdravy ani frázy.';
$string['action_summarise_text'] = 'Zhrnúť text';
$string['action_summarise_text_desc'] = 'Zhrnie obsah textu na stránke kurzu.';
$string['action_summarise_text_instruction'] = 'Od používateľa dostanete textový vstup. Vašou úlohou je zhrnúť zadaný text. Postupujte podľa týchto pokynov:
    1. Skráťte ho: Skráťte dlhé pasáže na kľúčové body.
    2. Zjednodušte: Zjednodušte zložité informácie tak, aby boli zrozumiteľnejšie najmä pre študentov.

Dôležité pokyny:
    1. Vráťte zhrnutie len v obyčajnom texte.
    2. Nezahrňujtee žiadne formátovanie značiek, pozdravy ani frázy.
    3. Zamerajte sa na jasnosť, stručnosť a prístupnosť.


Uistite sa, že zhrnutie je ľahko čitateľné a účinne vyjadruje hlavné body pôvodného textu.';
$string['action_translate_text'] = 'Preložiť text';
$string['action_translate_text_desc'] = 'Preložte poskytnutého textu z jedného jazyka do druhého.';
$string['actionsettingprovider'] = '{$a} nastavenia akcie';
$string['actionsettingprovider_desc'] = 'Tieto nastavenia riadia, ako {$a->providername} vykoná akciu {$a->actionname}.';
$string['actionsettings'] = 'Nastavenia akcie';
$string['actionsettings_desc'] = 'Tieto nastavenia riadia akcie AI pre túto inštanciu poskytovateľa.';
$string['ai'] = 'AI';
$string['aiactionregister'] = 'Register akcií AI';
$string['aiplacements'] = 'Umiestnenia AI';
$string['aipolicyacceptance'] = 'Prijatie politiky AI';
$string['aipolicyregister'] = 'Register politík AI';
$string['aiproviders'] = 'Poskytovatelia AI';
$string['aireports'] = 'Správy AI';
$string['aiusage'] = 'Využitie AI';
$string['aiusagepolicy'] = 'Zásady používania AI';
$string['availableplacements'] = 'Vyberte, kde sú k dispozícii akcie AI';
$string['availableplacements_desc'] = 'Umiestnenia definujú, ako a kde možno akcie AI na vašom portáli použiť. Prostredníctvom nastavení si môžete vybrať, ktoré akcie sú dostupné v jednotlivých umiestneniach.';
$string['availableproviders'] = 'Spravovať poskytovateľov AI pripojených k vášmu systému LMS';
$string['availableproviders_desc'] = 'Poskytovatelia umelej inteligencie pridávajú na vašu stránku funkcie umelej inteligencie prostredníctvom „akcií“, ako je napríklad sumarizácia textu alebo generovanie obrázkov.<br/>
Akcie môžete spravovať pre každého poskytovateľa v jeho nastaveniach.';
$string['btninstancecreate'] = 'Vytvoriť inštanciu';
$string['btninstanceupdate'] = 'Aktualizovať inštanciu';
$string['completiontokens'] = 'Tokeny dokončenia';
$string['completiontokens_help'] = 'Tokeny dokončenia sú textové jednotky generované modelom AI ako odpoveď na vaše vstupné údaje. Pri dlhších odpovediach sa používa viac tokenov, čo pravdepodobne stojí viac.';
$string['configureprovider'] = 'Konfigurácia inštancie poskytovateľa';
$string['contentwatermark'] = 'Vytvorené umelou inteligenciou';
$string['createnewprovider'] = 'Vytvoriť novú inštanciu poskytovateľa';
$string['dateaccepted'] = 'Dátum schválenia';
$string['declineaipolicy'] = 'Odmietnuť';
$string['enableglobalratelimit'] = 'Nastavenie limitu sadzby pre celý portál';
$string['enableglobalratelimit_help'] = 'Obmedzí počet požiadaviek, ktoré môže poskytovateľ AI prijímať na celom portáli každú hodinu.';
$string['enableuserratelimit'] = 'Nastavenie limitu rýchlosti používateľa';
$string['enableuserratelimit_help'] = 'Obmedzí počet požiadaviek, ktoré môže každý používateľ odoslať poskytovateľovi AI každú hodinu.';
$string['error:400'] = 'Nesprávna požiadavka';
$string['error:401'] = 'Neoprávený';
$string['error:401:upstreamless'] = 'Nie je možné sa pripojiť k službe AI. Skúste to neskôr.';
$string['error:404'] = 'Nenájdené';
$string['error:404:upstreamless'] = 'Služba AI je dočasne nedostupná. Skúste to neskôr.';
$string['error:429'] = 'Príliš veľa požiadaviek';
$string['error:429:internalsitewide'] = 'AI dosiahla maximálny počet požiadaviek za hodinu v rámci celého portálu. Skúste to neskôr.';
$string['error:429:internaluser'] = 'Dosiahli ste maximálny počet požiadaviek pre umelú inteligenciu, ktoré môžete za hodinu vykonať. Skúste to neskôr.';
$string['error:429:upstreamless'] = 'Táto služba umelej inteligencie dosiahla limit požiadaviek. Skúste to neskôr.';
$string['error:500'] = 'Interná chyba serveru';
$string['error:503'] = 'Služba nie je k dispozícii';
$string['error:actionnotfound'] = 'Akcia \'{$a}\' nie je podporovaná.';
$string['error:defaultmessage'] = 'Pri spracovaní vašej požiadavky došlo k chybe. Skúste to neskôr.';
$string['error:defaultmessageshort'] = 'Skúste to neskôr';
$string['error:defaultname'] = 'Niečo sa pokazilo';
$string['error:noproviders'] = 'Nie sú k dispozícii žiadni poskytovatelia pre spracovanie akcie.';
$string['error:providernotfound'] = 'Inštancia poskytovateľa AI sa nenašla.';
$string['error:unknown'] = 'Neznáma chyba';
$string['globalratelimit'] = 'Maximálny počet požiadaviek v rámci celého portálu';
$string['globalratelimit_help'] = 'Počet požiadaviek na celý portál povolený za hodinu.';
$string['manageaiplacements'] = 'Spravovať umiestnenia AI';
$string['manageaiproviders'] = 'Spravovať poskutovateľov AI';
$string['noproviders'] = 'Táto akcia nie je k dispozícii. Pre túto akciu nie sú definovaní žiadni <a href="{$a}">AI poskytovatelia</a>.';
$string['placement'] = 'Umiestnenie';
$string['placementactionsettings'] = 'Akcie';
$string['placementactionsettings_desc'] = 'Akcie AI dostupné pre toto umiestnenie.';
$string['placementsettings'] = 'Nastavenia špecifické pre umiestnenie';
$string['placementsettings_desc'] = 'Tieto nastavenia riadia spôsob, akým sa toto umiestnenie AI pripája k službe AI a súvisiacim operáciám.';
$string['privacy:metadata:ai_action_explain_text'] = 'Tabuľka, v ktorej sú uložené požiadavky na vysvetlenie textu zadané používateľmi.';
$string['privacy:metadata:ai_action_explain_text:completiontoken'] = 'Dokončovacie tokeny použité na vysvetlenie textu.';
$string['privacy:metadata:ai_action_explain_text:fingerprint'] = 'Jedinečný hash reprezentujúci stav/verziu modelu a obsahu.';
$string['privacy:metadata:ai_action_explain_text:generatedcontent'] = 'Skutočný text vygenerovaný modelom umelej inteligencie na základe vstupnej výzvy.';
$string['privacy:metadata:ai_action_explain_text:prompt'] = 'Prompt pre vysvetlenie textovej požiadaky.';
$string['privacy:metadata:ai_action_explain_text:prompttokens'] = 'Tokeny promptu, ktoré sa používajú na vysvetlenie textu.';
$string['privacy:metadata:ai_action_explain_text:responseid'] = 'ID odpovede.';
$string['privacy:metadata:ai_action_generate_image'] = 'Tabuľka ukladajúca požiadavky na generovanie obrázkov, ktoré zadali používatelia.';
$string['privacy:metadata:ai_action_generate_image:aspectratio'] = 'Pomer strán vygenerovaných obrázkov.';
$string['privacy:metadata:ai_action_generate_image:numberimages'] = 'Počet vygenerovaných obrázkov.';
$string['privacy:metadata:ai_action_generate_image:prompt'] = 'Výzva na zadanie požiadavky na generovanie obrázka.';
$string['privacy:metadata:ai_action_generate_image:quality'] = 'Kvalita vygenerovaných obrázkov.';
$string['privacy:metadata:ai_action_generate_image:revisedprompt'] = 'Revidovaná výzva generovaných obrázkov.';
$string['privacy:metadata:ai_action_generate_image:sourceurl'] = 'Zdrojová adresa URL vygenerovaných obrázkov.';
$string['privacy:metadata:ai_action_generate_image:style'] = 'Štýl generovaných obrázkov.';
$string['privacy:metadata:ai_action_generate_text'] = 'Tabuľka, v ktorej sú uložené požiadavky na generovanie textu zadané používateľmi.';
$string['privacy:metadata:ai_action_generate_text:completiontoken'] = 'Doplňovacie znaky použité na generovanie textu.';
$string['privacy:metadata:ai_action_generate_text:fingerprint'] = 'Jedinečný hash reprezentujúci stav/verziu modelu a obsahu.';
$string['privacy:metadata:ai_action_generate_text:generatedcontent'] = 'Skutočný text vygenerovaný modelom umelej inteligencie na základe vstupnej výzvy.';
$string['privacy:metadata:ai_action_generate_text:prompt'] = 'Výzva pre požiadavku na generovanie textu.';
$string['privacy:metadata:ai_action_generate_text:prompttokens'] = 'Tokeny výzvy použité na generovanie textu.';
$string['privacy:metadata:ai_action_generate_text:responseid'] = 'ID odpovede.';
$string['privacy:metadata:ai_action_register'] = 'Tabuľka, v ktorej sa ukladajú požiadavky na akcie zadané používateľmi.';
$string['privacy:metadata:ai_action_register:actionid'] = 'ID žiadosti o akciu.';
$string['privacy:metadata:ai_action_register:actionname'] = 'Názov akcie žiadosti.';
$string['privacy:metadata:ai_action_register:model'] = 'Model použitý na vytvorenie odpovede.';
$string['privacy:metadata:ai_action_register:provider'] = 'Názov poskytovateľa, ktorý spracoval požiadavku.';
$string['privacy:metadata:ai_action_register:success'] = 'Stav žiadosti o akciu.';
$string['privacy:metadata:ai_action_register:timecompleted'] = 'Čas dokončenia požiadavky.';
$string['privacy:metadata:ai_action_register:timecreated'] = 'Čas vytvorenia požiadavky.';
$string['privacy:metadata:ai_action_register:userid'] = 'ID používateľa, ktorý zadal požiadavku.';
$string['privacy:metadata:ai_action_summarise_text'] = 'Tabuľka, v ktorej sa ukladajú súhrnné textové požiadavky používateľov.';
$string['privacy:metadata:ai_action_summarise_text:completiontoken'] = 'Doplňovacie znaky použité na zhrnutie textu.';
$string['privacy:metadata:ai_action_summarise_text:fingerprint'] = 'Jedinečný hash reprezentujúci stav/verziu modelu a obsahu.';
$string['privacy:metadata:ai_action_summarise_text:generatedcontent'] = 'Skutočný text vygenerovaný modelom umelej inteligencie na základe promptu.';
$string['privacy:metadata:ai_action_summarise_text:prompt'] = 'Prompt pre žiadosť o zhrnutie textu.';
$string['privacy:metadata:ai_action_summarise_text:prompttokens'] = 'Prompty použité na zhrnutie textu.';
$string['privacy:metadata:ai_action_summarise_text:responseid'] = 'ID odpovede.';
$string['privacy:metadata:ai_policy_register'] = 'Tabuľka, v ktorej je uložený stav prijatia zásad umelej inteligencie pre každého používateľa.';
$string['privacy:metadata:ai_policy_register:contextid'] = 'ID kontextu, ktorého údaje boli uložené.';
$string['privacy:metadata:ai_policy_register:timeaccepted'] = 'Čas, kedy používateľ prijal politiku UI.';
$string['privacy:metadata:ai_policy_register:userid'] = 'ID používateľa, ktorého údaje boli uložené.';
$string['prompttokens'] = 'Tokeny promptu';
$string['prompttokens_help'] = 'Tokeny promptu sú textové jednotky, ktoré tvoria vstupné údaje, ktoré posielate modelu umelej inteligencie. Dlhšie vstupy používajú viac tokenov, čo pravdepodobne stojí viac.';
$string['provider'] = 'Poskytovateľ';
$string['provideractionsettings'] = 'Akcie';
$string['provideractionsettings_desc'] = 'Vyberte a nakonfigurujte akcie, ktoré {$a} môže vykonávať na vašom portáli.';
$string['providerinstanceactionupdated'] = '{$a} aktualizované nastavenia akcie';
$string['providerinstancecreated'] = '{$a} Vytvorená inštancia poskytovateľa AI.';
$string['providerinstancedelete'] = 'Odstránenie inštancie poskytovateľa AI';
$string['providerinstancedeleteconfirm'] = 'Chystáte sa odstrániť inštanciu poskytovateľa AI {$a->name} ({$a->provider}). Ste si istí?';
$string['providerinstancedeleted'] = '{$a} inštancia poskytovateľa AI odstránená.';
$string['providerinstancedeletefailed'] = 'Nie je možné odstrániť {$a} inštancia poskytovateľa AI. Poskytovateľ sa buď používa, alebo je problém v databáze. Skontrolujte, či je poskytovateľ aktívny, alebo sa obráťte na správcu databázy a požiadajte ho o pomoc.';
$string['providerinstancedisablefailed'] = 'Nie je možné vypnúť inštanciu poskytovateľa AI. Poskytovateľ sa buď používa, alebo je problém s databázou. Skontrolujte, či je poskytovateľ aktívny, alebo sa obráťte na správcu databázy a požiadajte o pomoc.';
$string['providerinstanceupdated'] = '{$a} Aktualizovaná inštancia poskytovateľa AI.';
$string['providermoveddown'] = '{$a} sa posunul nadol.';
$string['providermovedup'] = '{$a} sa posunul nahor.';
$string['providername'] = 'Názov inštancie';
$string['providers'] = 'Poskytovatelia';
$string['providersettings'] = 'Nastavenia';
$string['providertype'] = 'Vyberte si zásuvný modul poskytovateľa AI';
$string['timegenerated'] = 'Čas generovania';
$string['unknownvalue'] = '—';
$string['userpolicy'] = '<h4><strong>Vítajte v novej funkcii AI!</strong></h4>
<p>Táto funkcia umelej inteligencie (AI) je založená výlučne na externých veľkých jazykových modeloch (LLM), ktoré zlepšujú vaše skúsenosti s učením a výučbou. Skôr ako začnete používať tieto služby AI, prečítajte si tieto zásady používania.</p>
<h4><strong>Presnosť obsahu generovaného AI</strong></h4>
<p>AI môže poskytovať užitočné návrhy a informácie, ale jej presnosť sa môže líšiť. Poskytnuté informácie by ste mali vždy dvakrát skontrolovať, aby ste sa uistili, že sú presné, úplné a vhodné pre vašu konkrétnu situáciu.</p>
<h4><strong>Ako sa vaše údaje spracúvajú</strong></h4>
<p>Táto funkcia AI využíva externé veľké jazykové modely (LLM). Ak použijete túto funkciu, všetky informácie alebo osobné údaje, ktoré poskytnete, budú spracované v súlade so zásadami ochrany osobných údajov týchto LLM. Odporúčame vám prečítať si ich zásady ochrany osobných údajov, aby ste pochopili, ako budú s vašimi údajmi zaobchádzať. Okrem toho sa na tejto stránke môže uložiť záznam o vašich interakciách s funkciami UI.</p>
<p>Ak máte otázky týkajúce sa spôsobu spracovania vašich údajov, informujte sa u svojich učiteľov alebo vzdelávacej organizácie.</p>
<p>Pokračovaním potvrdzujete, že týmto zásadám rozumiete a súhlasíte s nimi.</p>';
$string['userratelimit'] = 'Maximálny počet požiadaviek na používateľa';
$string['userratelimit_help'] = 'Počet povolených požiadaviek za hodinu na používateľa.';
