<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'turnitintool', language 'es_mx', version '5.1'.
 *
 * @package     turnitintool
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_turnitintool'] = 'Añadir Tarea Turnitin';
$string['addcomment'] = 'Añadir Comentario';
$string['addeditcomment'] = 'Añadir / Editar Comentario';
$string['addsubmission'] = 'Añadir Envío';
$string['advancedoptions'] = 'Opciones Avanzadas Turnitin';
$string['allowlate'] = 'Permitir Envíos Retrasados';
$string['allowlate_help'] = 'Esta configuración le permite al instructor seleccionar si es que permitirá o no envíos tardíos a la tarea. Si se configura a si, los estudiantes podrán enviar la tarea después de la fecha esperada si no han hecho un envío previamente. Si se configura a no, los estudiantes no podrán enviar después de la fecha esperada de la tarea.';
$string['allstudents'] = 'Todos los Estudiantes';
$string['allsubmissions'] = 'Buzón de Envío';
$string['allsubmissionsmade'] = 'Todos los envíos posibles han sido hechos';
$string['alreadysubmitted'] = 'El envío no fue aceptado ya que esa parte de  la tarea ya había sido enviada.';
$string['anon'] = 'Anónimo';
$string['anonenabled'] = 'Calificación Anónima Habilitada';
$string['anytype'] = 'Cualquier Tipo de Envío';
$string['apiunavailable'] = 'URL  aAse de API Turnitin incorrecta o no disponible.';
$string['assigndtdue'] = 'Fecha de vencimiento de la tarea';
$string['assigndtpost'] = 'Fecha de publicación de la tarea';
$string['assigndtstart'] = 'Fecha de comienzo de la tarea';
$string['assigngeterror'] = 'No pudieron obtenerse datos de turnitintool';
$string['assignmentdeleteprocess'] = 'Borrando parte {$a} de la tarea';
$string['assignmentdoesnotexist'] = 'La tarea no existe en Turnitin';
$string['assignmentindividualise'] = 'Procesando parte {$a} de la tarea';
$string['assignmentprocess'] = 'Inicializando parte {$a} de la tarea';
$string['assignmentupdate'] = 'Actualizando parte {$a} de la tarea';
$string['autorefreshgrades'] = 'Auto Refrescar Calificaciones / Puntajes';
$string['autorefreshgrades_help'] = 'Por defecto, después de cada llamada a Turnitin, el plugin de integración a Moodle intentará automáticamente jalar los cambios hechos mientras estaba en Turnitin. Usted puede usar esta opción para desactivar esta característica.
Sin embargo, para mantener la sincronización entre ambos sistemas, Usted necesitará manualmente refrescar calificaciones y puntajes de originalidad desde adentro de Moodle.';
$string['autosubmit'] = 'Auto Enviar';
$string['autosubmit_help'] = 'Para enviar automáticamente los envíos del usuario a Turnitin conforme se suban, ajuste esta opción a \'Enviar a Turnitin inmediatamente al Subir\'. Alternativamente, Usted puede ajustar la opción a requerir que los envíos sean almacenados en Moodle y subidos manualmente a Turnitin al seleccionar \'Revisar Subida antes de Enviar a Turnitin\'.';
$string['autosubmitoff'] = 'Revisar la subida antes de enviar a Turnitin';
$string['autosubmiton'] = 'Enviar a Turnitin inmediatamente al subir';
$string['bulkupload'] = 'Subida masiva de envíos';
$string['ced'] = 'Fecha fin de la clase';
$string['changeowner'] = 'Cambiar Propietario ...';
$string['changingowner'] = 'Cambiar el propietario de la clase Turnitin';
$string['characters'] = 'Caracteres';
$string['classcreationerror'] = 'Creación de clase Turnitin fallida';
$string['classprocess'] = 'Procesando datos de la clase';
$string['classupdateerror'] = 'No se han podido actualizar los datos de la clase Turnitin';
$string['comment'] = 'Comentario';
$string['commentby'] = 'Comentar Por';
$string['commentdeleteerror'] = 'No se he podido borrar el comentario de la base de datos';
$string['commenteditwindow'] = 'Los comentarios permanecen editables';
$string['commenteditwindow_help'] = 'Esta opción le permite configurar la ventana de tiempo en la cual un usuario puede editar los comentarios que hizo con respecto a un envío. Los usuarios con la habilidad para calificar envíos, por ejemplo tutores, pueden cambiar sus propios comentarios en cualquier momento.';
$string['commentgeterror'] = 'No se he podido obtener el comentario de la base de datos';
$string['commentsgeterror'] = 'Error al recibir datos de los comentarios';
$string['commentssettings'] = 'Configuración de comentarios';
$string['configureerror'] = 'Usted debe configurar este módulo completamente antes de usarlo en un curso. Por favor contacte a su administrador Moodle.';
$string['connecttest'] = 'Iniciar test de conectividad';
$string['connecttestcommerror'] = 'No se pudo conectar a Turnitin. Revise doblemente su configuración de URL de API.';
$string['connecttesterror'] = 'Hubo un error al conectarse a Turnitin. El mensaje de error está debajo:<br /><br /><i><b>{$a}</b></i>';
$string['connecttesting'] = 'Realizando test de conectividad';
$string['connecttestsuccess'] = 'Moodle se ha conectado correctamente a Turnitin.';
$string['connecttimeouterror'] = 'No se ha podido conectar a Turnitin / conexión de tiempo superado. Inténtelo de nuevo.';
$string['copyassigndata'] = 'Copiando datos de la tarea de Turnitin';
$string['copyassigndataerror'] = 'Copiando datos de error de la tarea de Turnitin';
$string['copyrightagreement'] = 'Al seleccionar esta casilla,
 Yo confirmo que este envío es mi propio trabajo y yo acepto toda la responsabilidad por cualquier violación al derecho de autor (copyright) que pudiera ocurrir como un resultado de este envío.';
$string['correctingovergrade'] = 'Corrigiendo Trabajo Sobrecalificado';
$string['coursegeterror'] = 'No pudieron obtenerse datos del curso';
$string['courseiderror'] = 'ID del curso es incorrecta';
$string['created'] = 'Creado';
$string['dateformat'] = 'Formato de Fecha';
$string['dateformat_help'] = 'Use esta configuración para poner el formato de fecha usado para mostrarle fechas a a usuarios.';
$string['defaultdtdue'] = 'Fecha Esperada Por Defecto';
$string['defaultdtpost'] = 'Fecha de Publicación por Defecto';
$string['defaultdtstart'] = 'Fecha de Inicio por Defecto';
$string['defaults'] = 'Ajustes por defecto';
$string['defaults_desc'] = 'Las configuraciones siguientes serán las configuraciones por defcto usadas para las nuevas instancias de la Tarea Noodle Direct Turnitin';
$string['defaultsoverwrite'] = 'Sobrescribir Fechas';
$string['defaultsoverwrite_help'] = 'Esta configuración será mostrada cuando se actualice una tarea. Al seleccionar Sí aquí se reiniciará la fecha de inicio de la tarea, la fecha esperada y la fecha post, para que todas las partes de tarea sean las mismas que los valores que Usted ingrese en las configuraciones de fecha por defecto.';
$string['deletable'] = 'Eliminable';
$string['delete'] = 'Eliminar';
$string['delete_turnitintool'] = 'Eliminar Tarea Turnitin';
$string['deletecomment'] = 'Eliminar Comentario';
$string['deletecommentconfirm'] = '¿Está seguro de querer eliminar este comentario?\\n\\n Esto no puede deshacerse.';
$string['deleteconfirm'] = '¿Está seguro de querer eliminar este envío?\\n\\n Esto no puede deshacerse.';
$string['deleteerror'] = 'Error de Eliminación';
$string['deletesubmission'] = 'Eliminar envío';
$string['deletingsubmission'] = 'Eliminando Envío Turnitin';
$string['displaygradesas'] = 'Visualización de Calificación';
$string['displaygradesas_help'] = 'Esta opción configura el modo de visualización para calificaciones. Las opciones son mostrar como porcentaje o mostrar como una fracción, por ejemplo 45/60';
$string['displaygradesasfraction'] = 'Mostrar calificaciones como fracción (por ej: 89/100)';
$string['displaygradesaspercent'] = 'Mostrar calificaciones como porcentajes (por ej: 89%)';
$string['dorequesterror'] = 'No pudo procesarse solicitud de página';
$string['downloadexport'] = 'Exportar';
$string['downloadgradexls'] = 'Exportación de Calificación (XLS)';
$string['downloadingfile'] = 'Descargando Archivo';
$string['downloadingfileerror'] = 'Error al Descargar Archivo';
$string['downloadorigzip'] = 'Archivo ZIP (Formato Original)';
$string['downloadpdfzip'] = 'Archivo ZIP (PDF)';
$string['downloadsubmission'] = 'Descargar Envío';
$string['dtdue'] = 'Fecha Esperada';
$string['dtpost'] = 'Fecha Post';
$string['dtstart'] = 'Fecha de Inicio';
$string['duplicatesfound'] = 'Se encontraron copias duplicadas de la misma tarea Turnitin; los duplicados ocurren cuando una o más tareas Moodle Direct están conectadas a la misma tarea Turnitin vía la API Turnitin. Esto se sabe que causa probleemas, principalmente en envíos hechos a uno de los duplicados que aparecerán en el buzón de envío de los otros. Para corregir esto, Usted debería de eliminar las tareas duplicadas o reiniciar el curso en donde están las tareas duplicadas.<br /><br />Se encontraron los siguientes duplicados:';
$string['edit'] = 'Editar';
$string['editcomment'] = 'Editar Comentario';
$string['edituntil'] = 'Publicación puede ser eliminada o editada hasta';
$string['editwindow'] = 'Editable Para';
$string['enablepseudo'] = 'Habilitar Privacidad de Estudiante';
$string['enablepseudo_desc'] = 'Si esta opción es seleccionada, las direcciones Email de estudiantes serán transformadas en un pseudo equivalente para llamadas API Turnitin.<br /><i>(<b>Nota:</b> Esta opción no puede ser cambiada si ya se ha sincronizado algún dato de usuario con Turnitin)</i>';
$string['erater'] = 'Habilitar revisión de gramática e-rater';
$string['erater_categories'] = 'Categorías e-rater';
$string['erater_dictionary'] = 'Diccionario e-rater';
$string['erater_dictionary_en'] = 'Ambos Diccionarios de Inglés: Estadounidense y Británico';
$string['erater_dictionary_engb'] = 'Diccionario Inglés Británico';
$string['erater_dictionary_enus'] = 'Diccionario Inglés Estadounidense';
$string['erater_grammar'] = 'Gramática';
$string['erater_handbook'] = 'ETS© Handbook (Manual)';
$string['erater_handbook_advanced'] = 'Avanzado';
$string['erater_handbook_elementary'] = 'Escuela Primaria (elemental)';
$string['erater_handbook_highschool'] = 'Escuela Preparatoria (Bachillerato)';
$string['erater_handbook_learners'] = 'Estudiantes de Inglés';
$string['erater_handbook_middleschool'] = 'Escuela Secundaria';
$string['erater_help'] = 'Cuando esta configuración es habilitada, los envíos vistos dentro de GradeMark también contendrán puntos por retroalimentación para gramática y otros rasgos de escritura.';
$string['erater_mechanics'] = 'Mecánica';
$string['erater_spelling'] = 'Ortografía';
$string['erater_style'] = 'Estilo';
$string['erater_usage'] = 'Uso';
$string['estimatingtime'] = 'Estimando Tiempo Restante';
$string['excludebiblio'] = 'Excluir Bibliografía';
$string['excludebiblio_help'] = 'Esta configuración le permite al instructor excluir texto que aparece en secciones de referencias, la bibliografía, o trabajos citados, de los trabajos de los estudiantes, de ser revisados para coincidencias al generar Reportes de Originalidad. Esta configuración puede ser anulada en los Reportes de Originalidad individuales.';
$string['excludepercent'] = 'Porcentaje';
$string['excludequoted'] = 'Excluir Material Citado Entrecomillado';
$string['excludequoted_help'] = 'Esta configuración le permite al instructor elegir excluir texto que aparece en las citas entrecomilladas, de que sean revisadas para coincidencias al generar Reportes de Originalidad. Esta configuración puede ser anulada en reportes de Originalidad individuales.';
$string['excludevalue'] = 'Excluir Concordancias Pequeñas';
$string['excludevalue_help'] = 'Esta configuración le permite al instructor elegir excluir coincidencias que no sean de largo suficiente (determinado por el instructor) de ser consideradas al generar Reportes de Originalidad. Esta configuración puede ser anulada en Reportes de Originalidad individuales.';
$string['excludewords'] = 'Palabras';
$string['feedback'] = 'Comentarios';
$string['file'] = 'Archivo';
$string['filebrowser'] = 'Navegador de Archivo Directo de Moodle';
$string['filedeleteconfirm'] = '¿Está seguro de querer eliminar este archivo? Esta acción no puede deshacerse.';
$string['filename'] = 'Nombre de archivo';
$string['filenotfound'] = 'No se enconttró el archivo para enviar en el servidor Moodle. Podría estar corrupto o faltante. El intento de envío Turnitin será eliminado.';
$string['files'] = 'Archivos';
$string['filetosubmit'] = 'Archivo a Enviar';
$string['filetosubmit_help'] = 'Cuando se envía una parte de envío, revise su computadora para encontrar el archivo a subir usando este elemento del formato.';
$string['fileupload'] = 'Subida de Archivo';
$string['fileuploaderror'] = 'Error en Subida de Archivo';
$string['filewriteerror'] = 'No se pudieron escribir datos al archivo';
$string['genduedate'] = 'Generar reportes en fecha esperada';
$string['generalsettings'] = 'Configuraciones Generales';
$string['genimmediately1'] = 'Generar reportes inmediatamente, primer reporte es final';
$string['genimmediately2'] = 'Generar reportes inmediatamente, los reportes pueden ser sobrescritos hasta la fecha esperada';
$string['genspeednote'] = 'Nota: La generación del reporte de originalidad para re-envíos está sujeta a un retraso de veinticuatro horas.';
$string['goback'] = 'Regresar';
$string['gradessettings'] = 'Ajustes para Calificar';
$string['hideall'] = 'Ocultar Todo';
$string['hidesubmissions'] = 'Ocultar Envíos';
$string['hours'] = 'Horas';
$string['hrs'] = 'Hrs';
$string['inactive'] = 'Inactivo';
$string['inserterror'] = 'Error de Inserción';
$string['institutionalrepository'] = 'Repositorio Institucional (Donde Sea Aplicable)';
$string['instructor'] = 'Instructor';
$string['internetcheck'] = 'Revisar contra Internet';
$string['internetcheck_help'] = 'Esta configuración le permite al instructor seleccionar contra cuales repositorios de estudiantes de Turnitin serán revisados los envíos de los estudiantes al procesar los Reportes de Originalidad para trabajos. El porcentaje del índice de similitud puede disminuir si una opción de repositorio es des-seleccionada.';
$string['joiningclass'] = 'Uniéndose a Clase Turnitin {$a}';
$string['journalcheck'] = 'Revisar contra revistas, <br />periódico y publicaciones';
$string['journalcheck_help'] = 'Esta configuración le permite al instructor seleccionar contra cuales repositorios de estudiantes de Turnitin serán revisados los envíos de los estudiantes al procesar los Reportes de Originalidad para trabajos. El porcentaje del índice de similitud puede disminuir si una opción de repositorio es des-seleccionada.';
$string['list_turnitintool'] = 'Enlistar tareas Turnitin';
$string['marks'] = 'Puntajes';
$string['matches'] = 'Coincidencias';
$string['maxcommenterror'] = 'Este comentario es demasiado largo ({$a->actual} characters). Caracteres máximos permitidos {$a->allowed}.';
$string['maxcommentjserror'] = 'Este comentario es demasiado largo. Caracteres máximos permitidos {$a}.';
$string['maxcommentsize'] = 'Máxima Longitud de Comentario';
$string['maxcommentsize_help'] = 'Esta opción configura el número de caracteres permitidos en un comentario. El ajuste por defecto para esta opción es 800 caracteres.';
$string['maxfilesize'] = 'Tamaño de Archivo Máximo';
$string['maxfilesize_help'] = 'Esta configuración determina el tamaño máximo de archivo  para envíos de usuario para cada parte de tarea. El valor máximo que puede Usted configurar está dictado por el valor configurado en las configuraciones del curso; este valor es limitado aun más a un tamaño máximo de archivo de 40MB, que es el máximo tamaño de archivo permitido para subidas de archivo a Turnitin.';
$string['maxlength'] = 'La longitud máxima para {$a->field} es {$a->length} caracteres';
$string['maxmarks'] = 'Puntajes Máx';
$string['mins'] = 'Mins';
$string['minutes'] = 'Minutos';
$string['modulename'] = 'Tarea Turnitin';
$string['modulename_help'] = 'Crea una tarea Turnitin Moodle Directa, que enlaza una actividad en Moodle a una tarea / tareas en Turnitin. Una vez activada, la actividad le permite a los instructores evaluar y proporcionar retroalimentación para el trabajo escrito de estudiantes, usando las herramientas de evaluación dentro del Visor de Documento Turnitin.';
$string['modulenameplural'] = 'Tareas Turnitin';
$string['moduleversion'] = 'Versión';
$string['moodle2only'] = 'Esta característica solamente está soportada por Moodle 2+.';
$string['moreallowed'] = 'Más Permitido';
$string['mysubmissions'] = 'Mis Envíos';
$string['namedparts'] = 'Partes Nombradas';
$string['no'] = 'No';
$string['nocommenterror'] = 'Usted debe escribir un comentario';
$string['nocomments'] = 'No hay comentarios para este envío';
$string['noenrolledstudents'] = 'Actualmente no hay estudiantes inscritos en este curso';
$string['nogrademark'] = 'No; usar Moodle para calificar envíos';
$string['nogrades'] = 'No; yo refrescaré manualmente calificaciones y puntajes de originalidad';
$string['nolimit'] = 'Sin límite';
$string['nonmoodlestudents'] = 'Estudiantes No Moodle';
$string['nonmoodleuser'] = 'Usuario No Moodle';
$string['nonorsubmission'] = 'Envío no OR';
$string['norepository'] = 'Sin Repositorio';
$string['nosubmission'] = 'Sin Envío';
$string['nosubmissions'] = 'No se han hecho envíos';
$string['nosubmissionsdue'] = 'No hay partes activas a esta tarea; por ejemplo las fechas esperadas ya han pasado o las fechas de inicio no se han cumplido.';
$string['notavailableyet'] = 'No disponible';
$string['notes'] = 'Comentarios y retroalimentación';
$string['notyetsubmitted'] = 'Aun No Enviado';
$string['numberofparts'] = 'Número de Partes';
$string['numberofparts_help'] = 'Permite la creación de una tarea multi parte; los usuarios individuales pueden enviar un trabajo a cada parte.';
$string['objectid'] = 'ID del trabajo';
$string['of'] = 'de';
$string['oneclasspercourse'] = 'Hubo un error al enlazar su Clase Turnitin. Usted solamente puede tener una Clase Turnitin asociada con un Curso Moodle, y no se pueden tener dos cursos Moodle enlazados a la misma Clase Turnitin.';
$string['onepartdeleteerror'] = 'Usted no puee  eliminar la única parte de una tarea';
$string['options'] = 'Opciones';
$string['optionsupdateerror'] = 'No se pudieron actualizar datos de opciones';
$string['optionsupdatesaved'] = 'Datos de opciones exitosamente actualizados';
$string['overallgrade'] = 'Calificación General';
$string['overallgrade_help'] = 'La calificación global determina la calificación máxima permitida para la tarea en general,
 cada parte de una tarea tiene un puntaje máximo asignado, el cual es usado para distribuir proporcionalmente las calificaciones, para así determinar la calificación global.';
$string['partdberror'] = 'Hubo un problema al ingresar la Parte  {$a} adentro de la Base de Datos<br />';
$string['partdeleteerror'] = 'No pudieron eliminarse datos de parte de tarea';
$string['partdeletewarning'] = 'La parte de tarea que Usted está tratando de eliminar contiene envíos. Usted perderá estos envíos si elimina esta parte de tarea.\\n\\n¿Está seguro de querer continuar?';
$string['partdueerror'] = 'La fecha de inicio debe ser anterior a la fecha de publicación.<br />';
$string['parterror'] = 'Hubo errores con sus entradas:<br /><br />';
$string['partgeterror'] = 'No pudo obtenerse datos de parte de tarea';
$string['partmarkserror'] = 'Puntaje debe ser un número.<br />';
$string['partname'] = 'Parte de Tarea';
$string['partnameerror'] = 'Nombre de parte no puede dejarse vacío.<br />';
$string['partnames'] = 'Partes de Tarea';
$string['partnames_help'] = '<p>Determina si es que las Partes de esta tarea son Partes Nombradas o si esta tarea es una tarea de Portafolio.</p>';
$string['partnaming'] = 'Nombres de Partes';
$string['partstarterror'] = 'La fecha de inicio debe ser antes de la fecha esperada.<br />';
$string['partweighterror'] = 'La ponderación de parte {$a} no puede estar vacía<br />';
$string['pending'] = 'Pendiente';
$string['permissiondeniederror'] = 'Usted no tiene los permisos correctos para completar la acción solicitada';
$string['pleasenote'] = 'Por favor tome en cuenta';
$string['pluginadministration'] = 'Administración de Tarea Turnitin';
$string['pluginname'] = 'Tarea Turnitin';
$string['portfolio'] = 'Portafolio';
$string['posted'] = 'Enviado';
$string['previewtextsubmission'] = 'Previsualizar texto del Envío';
$string['previewwebpage'] = 'Previsualizar Página web';
$string['privacy:metadata:core_files'] = 'Tarea Turnitin almacena archivos que han sido subidos a Moodle para formar un envío Turnitin.';
$string['privacy:metadata:turnitintool_client'] = 'Para hacer exitosamente un envío a Turnitin, datos específicos del usuario necesitan ser intercambiados entre Moodle y Turnitin.';
$string['privacy:metadata:turnitintool_client:email'] = 'La dirección Email del usuario es compartida por Moodle para habilitar la creación de una cuenta Turnitin.';
$string['privacy:metadata:turnitintool_client:firstname'] = 'El nombre del usuario es enviado a Turnitin para que el usuario pueda ser identificado.';
$string['privacy:metadata:turnitintool_client:lastname'] = 'El apellido(s) del usuario es enviado a Turnitin para que el usuario pueda ser identificado.';
$string['privacy:metadata:turnitintool_client:submission_filename'] = 'El nombre del archivo enviado es enviado a Turnitin para que sea identificable.';
$string['privacy:metadata:turnitintool_client:submission_title'] = 'El título del envío es enviado a Turnitin para que sea identificable.';
$string['privacy:metadata:turnitintool_comments'] = 'Comentarios hechos acerca de un envío que ha sido enviado a Turnitin.';
$string['privacy:metadata:turnitintool_comments:commenttext'] = 'Un comentario anexo a un envío.';
$string['privacy:metadata:turnitintool_comments:userid'] = 'La ID del usuario que ha hecho un comentario.';
$string['privacy:metadata:turnitintool_submissions'] = 'Información acerca de un envío que ha sido enviado a Turnitin.';
$string['privacy:metadata:turnitintool_submissions:submission_attempts'] = 'Un sello de tiempo que indica cuando el usuario vió retroalimentación en su envío.';
$string['privacy:metadata:turnitintool_submissions:submission_filename'] = 'El nombre del archivo que ha sido enviado a Turnitin.';
$string['privacy:metadata:turnitintool_submissions:submission_grade'] = 'La calificación aplicada por un instructor al envío.';
$string['privacy:metadata:turnitintool_submissions:submission_hash'] = 'Una hash específica del envío que contiene la ID del usuario.';
$string['privacy:metadata:turnitintool_submissions:submission_modified'] = 'Un sello de tiempo que indica cuando el usuario modificó por última vez su envío.';
$string['privacy:metadata:turnitintool_submissions:submission_objectid'] = 'La ID usada por Turnitin para referenciar el envío.';
$string['privacy:metadata:turnitintool_submissions:submission_score'] = 'El puntaje de similitud del envío.';
$string['privacy:metadata:turnitintool_submissions:submission_title'] = 'El título del envío.';
$string['privacy:metadata:turnitintool_submissions:submission_transmatch'] = 'Indica si es que Turnitin usó concordancia traducida para producir un Reporte de Similitud para el envío.';
$string['privacy:metadata:turnitintool_submissions:submission_unanon'] = 'Indica que el anonimato del envío ha sido quitado, haciendo la identidad del autor disponible al instructor.';
$string['privacy:metadata:turnitintool_submissions:submission_unanonreason'] = 'Una explicación para la remoción del anonimato de un autor, proporcionada por su instructor.';
$string['privacy:metadata:turnitintool_submissions:userid'] = 'La ID del usuario que ha hecho un envío.';
$string['privacy:metadata:turnitintool_users'] = 'Información que enlaza un usuario Moodle a una cuenta de usuario Turnitin y cualquier preferencias específicas de Turnitin. Estas incluyen ajustes por defecto de tarea y cualquier rúbrica Turnitin propiedad de ellos.';
$string['privacy:metadata:turnitintool_users:instructor_defaults'] = 'Los ajustes de tarea por defecto del instructor';
$string['privacy:metadata:turnitintool_users:instructor_rubrics'] = 'Las tarjetas -de-puntaje (scorecards) Turnitin que pertenecen al instructor';
$string['privacy:metadata:turnitintool_users:turnitin_uid'] = 'La ID de la cuenta Turnitin del usuario.';
$string['privacy:metadata:turnitintool_users:user_agreement_accepted'] = 'Indica si es que el usuario ha aceptado el Acuerdo de Licencia del Usuario Final Turnitin, Turnitin End User Licence Agreement (EULA).';
$string['privacy:metadata:turnitintool_users:userid'] = 'La ID del usuario que está siendo enlazado a una cuenta Tui Turnitin.';
$string['processed'] = 'Tarea Procesada';
$string['proxypassword'] = 'Contraseña delProxy';
$string['proxypassword_desc'] = '<b>[Opcional]</b><br />Si su proxy requiere Autenticación ingrese la contraseña aquí.';
$string['proxyport'] = 'Puerto del Proxy';
$string['proxyport_desc'] = '<b>[Opctional]</b><br />Si su servidor usa un Proxy para conectarse al internet ingrese el puerto del proxy aquí.';
$string['proxyurl'] = 'URL del Proxy';
$string['proxyurl_desc'] = '<b>[Opctional]</b><br />Si su servidor usa un Proxy para conectarse al internet ingrese la dirección del proxy aquí.';
$string['proxyuser'] = 'Nombre_de_usuario del Proxy';
$string['proxyuser_desc'] = '<b>[Opcional]</b><br />Si su proxy requiere Autenticación ingrese el nombre_de_usuario aquí.';
$string['pseudoemailaddress'] = 'Pseudo Dirección Email';
$string['pseudoemaildomain'] = 'Pseudo Dominio Email';
$string['pseudoemaildomain_desc'] = '<b>[Opctional]</b><br />Un dominio opcional para pseudo direcciones Email. (Valor por defecto es @tiimoodle.com si se deja vacío)';
$string['pseudoemailsalt'] = 'Pseudo Sal de Encriptación';
$string['pseudoemailsalt_desc'] = '<b>[Opcional]</b><br />Una sal opcional para aumentar la complejidad de la Pseudo dirección Email de Estudiante.<br />(<b>Notae:</b> La sal debe permanecer inalterada para mantener pseudo direcciones Email consistentes )';
$string['pseudofirstname'] = 'Pseudo Nombre del Estudiante';
$string['pseudofirstname_desc'] = '<b>[Opcional]</b><br />El nombre de estudiante a mostrar en el visor de documento Turnitin';
$string['pseudolastname'] = 'Pseudo Apellido(s) del Estudiante';
$string['pseudolastname_desc'] = 'Apellido(s) a mostrar en el visor de documento Turnitin';
$string['pseudolastnamegen'] = 'Auto Generar Apellido(s)';
$string['pseudolastnamegen_desc'] = 'Si se configura a Si y el pseudo apellido se configura a un campo del perfil del usuario, el campo será poblado automáticamente con un identificador único.';
$string['pushinggrade'] = 'Actualizando Calificación {$a->num} de {$a->total} a Turnitin}';
$string['redirect'] = 'Si Usted no es redirigido automáticamente, por favor presione aquí.';
$string['reducepartserror'] = 'Usted no puede reducir el número de envíos permitidos si ya se han hecho envíos. Por favor quite la Parte de Tarea usando la página del resumen de la Tarea. Por favor tenga en cuenta que Usted no puede modificar el número de envíos permitidos en una Tarea de Portafolios sin primeramente eliminar todos los envíos.';
$string['refresh'] = 'Refrescar';
$string['refreshmatches'] = 'Refrescar Coincidencias';
$string['relinkusers'] = 'Re-enlazar Usuarios';
$string['remaining'] = 'Aproximadamente {$a} Restantes';
$string['removecoursedata'] = 'Quitar Datos Turnitin del Curso';
$string['removesubmissiondata'] = 'Quitar Datos Turnitin de Envío';
$string['removeturnitinassign'] = 'Eliminar Datos de Tarea de Turnitin';
$string['replaceassigndata'] = 'Remplazar Datos de Tarea Turnitin';
$string['replaceassigndataerror'] = 'Error de Remplazo de Datos de Tarea Turnitin';
$string['reportgenspeed'] = 'Velocidad de Generación del Reporte';
$string['reportgenspeed_help'] = 'Hay tres opciones para esta configuración de tarea: "Generar reportes inmediatamente (re-envíos no están permitidos)", "Generar reportes inmediatamente (re-envíos están permitidos hasta la fecha esperada)", y "Generar reportes en la fecha esperada (re-envíos están permitidos hasta la fecha esperada)".<br><br>La opción "inmediatamente el primer reporte es final" genera el Reporte de Originalidad inmediatamente cuando un estudiante hace un envío. Con esta opción seleccionada sus estudiantes no podrán re-enviar a la tarea.<br><br>Para permitir re-envíos, seleccione la opción "inmediatamente (puede sobrescribir reportes hasta fecha esperada)". Esto le  permite a los estudiantes re-enviar continuamente trabajos a la tarea hasta la fecha esperada. Podría tomar hasta 24 horas para procesar Reportes de Originalidad  para re-envíos.<br><br>La opción "en fecha esperada" solamente generará un reporte de Originalidad en la fecha esperada de la tarea. Esta configuración también hará que todos los trabajos enviados a la tarea sean comparados contra todos ellos mismos cuando sean creados los Reportes de Originalidad.';
$string['resubmission'] = 'Re-envío';
$string['resubmissiongradewarn'] = 'Los re-envíos están permitidos para esta tarea hasta antes de que pase la fecha  esperada. Cualquier y todos los puntajes serán eliminados cuando, o si es que, el trabajo es re-enviado. ¿Desea continuar?';
$string['resubmissionnotenabled'] = 'Re-envíos no habilitados';
$string['resubmit'] = 'Re-enviar';
$string['resultsperpage'] = 'Resultados Por Página';
$string['resultsperpage_help'] = 'Configurar el número de resultados a mostrar en el Buzón  de Envío';
$string['reveal'] = 'Revelar';
$string['revealerror'] = 'Usted debe incluir una razón válida para desenmascarar un nombre de estudiante.';
$string['revealreason'] = 'Razón para Desenmascarar';
$string['savechanges'] = 'Guardar Cambios';
$string['saveusage'] = 'Guardar Volcado de Datos';
$string['scorenotavailable'] = 'El puntaje de originalidad aun no está disponible.';
$string['secs'] = 'Segs';
$string['selectoption'] = 'Seleccionar Opción';
$string['semptytable'] = 'No se encontraron resultados';
$string['showall'] = 'Mostrar todo';
$string['shownonsubmissions'] = 'Enlistar todos los estudiantes';
$string['showonlysubmissions'] = 'Solamente enlistar estudiantes que hanhecho envíos';
$string['showusage'] = 'Mostrar Volcado de Datos';
$string['sinfo'] = 'Mostrando {$a->start} a {$a->end} de {$a->total} entradas.';
$string['slengthmenu'] = 'Mostrar {$a} Entradas';
$string['snext'] = 'Siguiente';
$string['spapercheck'] = 'Revisar contra trabajos de estudiante almacenados';
$string['spapercheck_help'] = 'Elegir esta opción instruye a Turnitin para que solamente añada documentos enviados a un repositorio privado de su institución. Las revisiones de similitud a los documentos enviados serán hechas por otros instructores dentro de su institución.';
$string['sprevious'] = 'Anterior';
$string['sprocessing'] = 'Procesando...';
$string['ssearch'] = 'Búsqueda:';
$string['stage'] = 'Stage';
$string['standardrepository'] = 'Repositorio Estandar';
$string['status'] = 'Estado';
$string['string'] = '{$a}';
$string['student'] = 'Estudiante';
$string['student_notread'] = 'El estudiante no ha visto este trabajo.';
$string['student_read'] = 'El estudiante vio esta página en:';
$string['studentdataprivacy'] = 'Ajustes de Privacidad de Datos de estudiante';
$string['studentdataprivacy_desc'] = 'Los ajustes siguientes se pueden configurar para asegurar que los datos personales de los estudiantes no sean transmitidos a Turnitin vía la API.';
$string['studentdeleteconfirm'] = 'Eliminar este trabajo le permitirá hacer un nuevo envío en su lugar.\\nUsted no podrá recuperar su envío una vez que haya sido eliminado.\\n\\n¿Está seguro de querer eliminar esta tarea?';
$string['studentnotallowed'] = '<b>Nota:</b> Los estudiantes no pueden ver reportes de originalidad para esta tarea.';
$string['studentreports'] = 'Reportes de Originalidad de Estudiante';
$string['studentreports_help'] = 'Le permite mostrar reportes de originalidad Turnitin a usuarios estudiantes. Si se ajusta a si, los reportes de originalidad generados por Turnitin están disponibles para que los estudiantes los vean.';
$string['studentsname'] = 'Nombre del Estudiante';
$string['studentsname_help'] = 'Cuando se hace un envío a nombre y en representación de un usuario, Usted debería de usar esta caja de selección para elegir el nombre del usuario por quien se está enviando el trabajo.';
$string['studentstatus'] = 'Enviado {$a->modified} (ID del trabajo: {$a->objectid})';
$string['submission'] = 'Envío';
$string['submissionagreementerror'] = 'Usted debe aceptar el acuerdo para este envío';
$string['submissionconnecterror'] = 'Hubo un error al conectarse a Turnitin. El envío ha sido puesto en cola.';
$string['submissiondelete'] = 'Eliminar\';';
$string['submissiondeleteerror'] = 'No pudieron eliminarse envíos';
$string['submissionfileerror'] = 'Usted debe anexar un archivo para envío';
$string['submissionfiletypeerror'] = 'Tipo de archivo no permitido. Los tipos permitidos son ({$a})';
$string['submissionfinalgrade'] = 'Calificación final para esta tarea';
$string['submissionframeseterror'] = 'Esta página aparentemente contiene marcos (frames), y no puede ser enviada.';
$string['submissiongeterror'] = 'No se pudieron obtener datos del envío';
$string['submissiongrade'] = 'Calificación';
$string['submissiongradetoohigh'] = 'La calificación que Usted ingresó para \'{$a->fullname}\' - \'{$a->part}\' era demasiado alta. El máximo es {$a->maximum}.<br />';
$string['submissioniframeerror'] = 'Esta página aparentemente contiene iframes, y no puede ser enviada.';
$string['submissionlist'] = 'Lista de Envío';
$string['submissionlist_help'] = 'Esta opción le permite enlistar a todos los usuarios sin importar que hayan hecho o no un envío.';
$string['submissionnotyetuploaded'] = 'Aun no enviado a Turnitin';
$string['submissionorig'] = 'Similitud';
$string['submissionpart'] = 'Parte de Envío';
$string['submissionpart_help'] = 'Seleccione la parte de la Tarea Turnitin a la que pertenece este envío.';
$string['submissionprotocolerror'] = 'Usted debe incluir la parte http:// o https:// de la URL para este envío por página web';
$string['submissions'] = 'Envíos';
$string['submissionstudent'] = 'Envío de Estudiante';
$string['submissiontexterror'] = 'Usted debe incluir el texto para este envío';
$string['submissiontitle'] = 'Título del Envío';
$string['submissiontitle_help'] = 'Ingresar el título del envío para la fracción de trabajo que Usted está enviando.';
$string['submissiontitleduplicate'] = 'Usted debe ingresar un título diferente para cada envío';
$string['submissiontitleerror'] = 'Usted debe ingresar un título para este envío';
$string['submissiontype'] = 'Tipo de Envío';
$string['submissiontype_help'] = '<p>Indica los tipos de envío que Usted tiene permitido enviar a Turnitin. Las opciones son:</p>';
$string['submissionupdateerror'] = 'No se pudieron actualizar los datos del envío';
$string['submissionuploadsuccess'] = 'Envío subido exitosamente a Turnitin.';
$string['submissionurlerror'] = 'Usted debe incluir la URL para este envío de página web';
$string['submit'] = 'Añadir Envío';
$string['submitpaper'] = 'Enviar Trabajo';
$string['submitpapersto'] = 'Almacenar Trabajos de Estudiante';
$string['submitpapersto_help'] = '<strong>Sin repositorio: </strong><br />Se le instruye a Turnitin para que no almacene documentos envidos a ningún repositorio. Nosotros solamente procesaremos el trabajo para realizar la primera revisión de similaridad.<br /><br /><strong>Repositorio Estándar: </strong><br />Turnitin almacenará una copia del documento enviado solamente en el repositorio estándar. Al elegir esta opción, Turnitin es instruido a solamente usar documentos almacenados para hacer revisiones de similitud contra cualquier documento enviado en el futuro.<br /><br /><strong>Repositorio Institucional (Donde sea Aplicable): </strong><br />Al elegir esta opción se instruye a Turnitin para que solamente añada documento enviados a un repositorio privado de su institución. Las revisiones de similitud a los documentos enviados solamente se harán por otros instructore dentro de su institución.';
$string['submitted'] = 'Modificado';
$string['submittedmax'] = 'Usted ha hecho el número máximo de envíos permitidos.';
$string['submittoturnitin'] = 'Enviar a Trnitin';
$string['synchallconfirm'] = '"Usted está a punto de sincronizar todos los envíos para este conjunto de partes de tarea con los envíos almacenados en Turnitin". Esto jalará cualquier envío que no hubiera sido enviado usando Moodle. Para números grandes de estudiantes con una tarea multipartes grande, esto podría demorar mucho tiempo. Por favor, no detenga el proceso una vez iniciado,.\\n\\n¿Está seguro de querer proceder?';
$string['synchallsubmissions'] = 'Recuperar Todos los Datos de Estudiante de Turnitin';
$string['synchassignments'] = 'Recuperar Datos de Tarea de Turnitin';
$string['synchronisingturnitin'] = 'Sincronizando Datos de Turnitin';
$string['synchstudentsubmissions'] = 'Recuperar Envíos del Estudiante de Turnitin';
$string['synchyoursubmissions'] = '¿Enviado a Turnitin? Haga  click aquí para recuperar.';
$string['szerorecords'] = 'Sin registros para mostrar';
$string['textsubmission'] = 'Envío de Texto';
$string['texttosubmit'] = 'Texto a Enviar';
$string['texttosubmit_help'] = 'Copie y pegue el texto de su envío dentro de esta caja.';
$string['title'] = 'Título';
$string['transmatch'] = 'Concordancia Traducida';
$string['transmatch_desc'] = 'Determina si es que la Concordancia Traducida estará disponible como una configuración en la pantalla de configuración de tarea.<br /><i>(Habilite esta opción solamente si Concordancia Traducida está habilitada en su cuenta Turnitin)</i>';
$string['transmatch_help'] = 'Cuando Concordancia Traducida está habiilitada, Turnitin generará un Reporte de Originalidad separado basado en traducciones al Inglés de los envíos de estudiantes no angloparlantes. Los idiomas siguientes están soportados para Concordancia Traducida:<br><br>Checo, Danés, Holandés, Finlandés, Francés, Alemán, Griego, Húngaro, Italiano, Polaco, Portugués, Rumano, Español, Sueco y Turco.';
$string['turnitinaccountid'] = 'ID de Cuenta Turnitin';
$string['turnitinaccountid_desc'] = '<b>[Necesario]</b><br />Ingrese su Turnitin Primary Account ID (ID de Cuenta Primaria Turnitin)';
$string['turnitinanon'] = 'Calificación Anónima';
$string['turnitinanon_help'] = 'Usted puede configurar su tarea Turnitin para usar Calificación Anónima (Anonymous Marking) al configurar este valor a Si. Una vez que se haya habilitado Anonymous Marking en una tarea, no puede ser deshabilitado.';
$string['turnitinapiurl'] = 'URL de API Turnitin';
$string['turnitinapiurl_desc'] = '<b>[Necesario]</b><br />Ingrese la URL de la API Turnitin<br /><i>(por ejemplo https://api.turnitin.com/api.asp)<br />(por ejemplo https://api.turnitinuk.com/api.asp)</i>';
$string['turnitincommunicationerror'] = 'Hubo un error al comunicarse con el servidor Turnitin. Por favor inténtelo nuevamente después.';
$string['turnitindeleteconfirm'] = 'Eliminar trabajos los quita de su lista de envíos y de su buzón de entrada, pero no los quita\\n completamente de la Base de datos de Turnitin.\\n\\n¿Está seguro de querer eliminar este envío? Esta acción no puede deshacerse.';
$string['turnitindeletionerror'] = 'Falló la eliminación del envío Turnitin. La copia local del Entorno de Aprendizaje Virtual fue removida pero el envío en Turnitin no pudo ser eliminado.';
$string['turnitindiagnostic'] = 'Habilitar Modo Diagnóstico';
$string['turnitindiagnostic_desc'] = '<b>[Precaución]</b><br />Habilite el Modo Diagnóstico solamente para diagnosticar los problemas con la API Turnitin.';
$string['turnitinenrollstudents'] = 'Inscribir a Todos los Estudiantes';
$string['turnitinid'] = 'ID Turnitin';
$string['turnitinloading'] = 'Sincronizando Datos';
$string['turnitinpart'] = 'Parte {$a}';
$string['turnitinpartname'] = 'Nombre de Parte';
$string['turnitinreceiptemail'] = 'Emails de Recibos';
$string['turnitinreceiptemail_desc'] = 'Configura si es que los estudiantes deberían recibir Emails de recibo digital cuando envíen trabajos a Turnitin vía el Entorno de Aprendizaje Virtual.';
$string['turnitinrefreshsubmissions'] = 'Refrescar Envíos';
$string['turnitinsecretkey'] = 'Clave Compartida Turnitin';
$string['turnitinsecretkey_desc'] = '<b>[Necesario]</b><br />Ingrese su Clave Compartida Turnitin (Turnitin Shared Key)<br /><i>(Configurada por su Administrador  Turnitin)</i>';
$string['turnitinstudentemail'] = 'Emails de Estudiantes';
$string['turnitinstudentemail_desc'] = 'Configurar si es que los estudiantes deberían recibir Emails con detalles de la cuenta cuando se les configura una cuenta Turnitin para ellos por el Entorno de Aprendizaje Virtual.';
$string['turnitinsubaccountid'] = 'ID SUb Cuenta Turnitin';
$string['turnitinsubaccountid_desc'] = '<b>[Opcional]</b><br />Ingrese su Turnitin Sub Account ID (ID de Sub- Cuenta Turnitin)<br /><i>(Usar esto solamente si se está configurando para una Sub Cuenta)</i>';
$string['turnitintool'] = 'Herramienta Turnitin';
$string['turnitintool:addinstance'] = 'Añadir Actividad Herramienta Turnitin';
$string['turnitintool:admin'] = 'Administrar Herramienta Turnitin';
$string['turnitintool:grade'] = 'Calificar Tareas Herramienta Turnitin';
$string['turnitintool:submit'] = 'Enviar a Tareas Herramienta Turnitin';
$string['turnitintool:view'] = 'Ver Tareas Herramienta Turnitin';
$string['turnitintooladministration'] = 'Administración de Tarea turnitin';
$string['turnitintoolagreement'] = 'Declaratoria / Acuerdo';
$string['turnitintoolagreement_default'] = 'Al seleccionar esta casilla, yo confirmo que este envío es mi propio trabajo y acepto toda la responsabilidad por cualquier infracción al derecho de autor (copyright) que pudiera ocurrir como resultado de este envío.';
$string['turnitintoolagreement_desc'] = '<b>[Opcional]</b><br />Escriba un párrafo de confirmación de acuerdo para los envíos.<br />(<b>Nota:</b> Si el acuerdo se deja completamente vacío, entonces no se necesitará una confirmación de acuerdo por los estudiantes durante el envío)';
$string['turnitintooldeleteerror'] = 'No pudieron eliminarse datos Turnitintool';
$string['turnitintoolgeterror'] = 'No pudieron obtenerse datos Turnitintool';
$string['turnitintoolintro'] = 'Resumen';
$string['turnitintoolname'] = 'Nombre de Tarea Turnitin';
$string['turnitintoolowner'] = 'Propietario de Clase Turnitin';
$string['turnitintoolowner_help'] = 'Indica al \'propietario\' o creador de la clase Turnitin. Todas las tareas y envíos serán añadidos a esta cuenta del \'propietario\' Turnitin.';
$string['turnitintoolresetdata0'] = 'Copiar Tareas Turnitin <i>(Crear Duplicados, Nueva Clase Turnitin)</i>';
$string['turnitintoolresetdata1'] = 'Remplazar Tareas Turnitin<i>(Remplazar Partes de Tarea, Re-usar Clase Turnitins)</i>';
$string['turnitintoolresetdata2'] = 'Dejar Tareas Turnitin Inalteradas';
$string['turnitintoolresetinfo'] = 'Elegir una opción debajo para las Tareas Turnitin en este curso:';
$string['turnitintoolupdateerror'] = 'No se pudieron actualizar datos turnitintool';
$string['turnitintutoremail'] = 'Emails del Instructor';
$string['turnitintutoremail_desc'] = 'Configurar si es que los instructores deberían recibir Emails con detalles de la cuenta cuando se configura una nueva cuenta Turnitin para ellos por el Entorno de Aprendizaje Virtual.';
$string['turnitintutors'] = 'Tutores Turnitin';
$string['turnitintutors_desc'] = 'Los tutores eleccionados debajo están inscritos como tutores en esta Clase turnitin. Los tutores inscritos pueden ganar acceso a esta clase al ingresar al sitio web Turnitin.';
$string['turnitintutorsadd'] = 'Añadir Tutor Turnitin';
$string['turnitintutorsadding'] = 'Añadiendo Tutor Turnitin';
$string['turnitintutorsallenrolled'] = 'Todos los Tutores están inscritos en Turnitin';
$string['turnitintutorsremove'] = 'Quitar Tutores Turnitin';
$string['turnitintutorsremove_errorlast'] = 'Error: Usted necesita tener al menos un tutor inscrito en el curso en Turnitin';
$string['turnitintutorsremoving'] = 'Quitando Tutores Turnitin';
$string['turnitintutorsretrieving'] = 'Recuperando Tutores Turnitin';
$string['turnitinuseanon'] = 'Usar Calificación Anónima';
$string['turnitinuseanon_desc'] = 'Elegir si se va a permitir o no Calificación Anónima (Anonymous Marking) al calificar envíos.<br /><i>(Esto solamente está disponible para aquellos que tengan configurado Anonymous Marking para su cuenta)</i>';
$string['turnitinuseerater'] = 'Habilitar ETS©';
$string['turnitinuseerater_desc'] = 'Decidir si es que se habilita o no la revisión de gramática ETS© grammar checking.<br /><i>(Solamente habilite esta opción si  ETS© e-rater está habilitada en su cuenta Turnitin)</i>';
$string['turnitinusegrademark'] = 'Usar GradeMark';
$string['turnitinusegrademark_desc'] = 'Elegir si es que se usa GradeMark para calificar envíos o se usa Moodle.<br /><i>(Esto solamente está disponible para aquellos que tengan GradeMark configurado para su cuenta)</i>';
$string['turnitinusegrademark_help'] = 'Use esta configuración para decidir entre usar Turnitin GradeMark para calificar los envíos o usar Moodle para calificar el envío.';
$string['turnitinuserepository'] = 'Habilitar Repositorio Institucional';
$string['turnitinuserepository_desc'] = 'Elija si permitirá el uso de Repositorios Institucionales en Tareas Turnitin .<br /><i>(Esto solamente está disponible para aquellos que tengan un Repositorio Institucional habilitado para su cuenta)</i>';
$string['turnitinuserepository_help'] = 'Use esta opción para habilitar la opción del repositorio Institucional en la pantalla de configuración de tarea.';
$string['tutorgeterror'] = 'No sepudieron obtener datos de tutor de tarea';
$string['tutorstatus'] = '{$a->submitted}/{$a->total} Envíos de Estudiante, {$a->graded} Envío{$a->gplural} Calificado(s)';
$string['type'] = 'Tipo de Envío';
$string['types'] = 'Tipo de Envíos';
$string['types_help'] = '<p>Los envíos pueden hacerse en tres difere.</p>';
$string['unlinkedusers'] = 'Usuarios Desligados';
$string['unlinkinfo'] = 'Use este formato para romper la unión entre Usuarios Turnitin y Moodle. Esto quitará la ID de Usuario Almacenado Turnitin del sistema Moodle, forzando a Moodle a que intente re-enlazar los usuarios en la siguiente llamada a Turnitin.';
$string['unlinkrelinkusers'] = 'Desligar / Re-ligar Usuarios Turnitin';
$string['unlinkusers'] = 'Desligar Usuarios';
$string['update'] = 'Actualizar';
$string['update_turnitintool'] = 'Actualizar Tarea Turnitin';
$string['updateerror'] = 'Error de Actualización';
$string['updatestudent'] = 'Actualizando envío {$a->from} de {$a->to}';
$string['updatinggrade'] = 'Recuperando Calificación Turnitin';
$string['updatingreport'] = 'Recuperando Puntaje de Reporte Turnitin';
$string['updatingscores'] = 'Recuperando Datos para {$a->user} / Parte de Tarea {$a->proc}';
$string['upgradeavailable'] = 'Actualización Disponible';
$string['uploadingtoturnitin'] = 'Subiendo Archivo a Turnitin';
$string['urlsnapshot'] = 'Tomando Instantánea de URL';
$string['urltosubmit'] = 'URL de Página Web a Enviar';
$string['urltosubmit_url'] = 'Ingrese la dirección de la página web que Usted está enviando. Solamente pueden enviarse páginas web simples. Será tomada una instantánea de la página y el HTML será subido a Turnitin.';
$string['useaverage'] = 'Calificar usando promedio del envío';
$string['user'] = 'Usuario';
$string['usercreationerror'] = 'Falló creación de usuario Turnitin';
$string['userdeleteerror'] = 'No se pudieron eliminar datos de usuario';
$string['usergeterror'] = 'No se pudieron obtener datos de usuario';
$string['userprocess'] = 'Procesando Datos del Usuario';
$string['userstounlink'] = 'Usuarios a Des-ligar';
$string['usersunlinkrelink'] = 'Usuarios a Des-ligar / Re-ligar';
$string['userupdateerror'] = 'No se pudieron actualizar datos del usuario';
$string['view'] = 'Ver';
$string['view_turnitintool'] = 'Ver tarea Turnitin';
$string['viewdelete'] = 'Ver/Eliminar';
$string['viewreport'] = 'Ver Reporte';
$string['viewsubmissions'] = 'Ver Envíos';
$string['webpage'] = 'Página Web';
$string['weight'] = 'Proporción de Ponderación de Puntaje';
$string['wrongaccountid'] = 'Hubo un error al enlazar su clase Turnitin. La cuenta que Usted ha configurado es la cuenta {$a->current}. La cuenta de donde es esta clase es la {$a->backupid}. Usted solamente puede restaurar clases que se originaron en la misma cuenta Turnitin..';
$string['yes'] = 'Si';
$string['yesgrademark'] = 'Si, usar GradeMark para calificar envíos';
$string['yesgrades'] = 'Si, refrescar automáticamente calificaciones y puntajes de originalidad';
