<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_mergeusers', language 'es_mx', version '5.1'.
 *
 * @package     tool_mergeusers
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choose_users'] = 'Elegir usuarios a juntar';
$string['clear_selection'] = 'Limpiar selección actual de usuario';
$string['cligathering:description'] = 'Introducir pares de ID de usuario para fusionar el primero con el segundo. El primer ID de usuario (fromid) perderá todos sus datos para migrarlos al segundo (toid). El usuario "toid" incluirá datos de ambos usuarios.';
$string['cligathering:fromid'] = 'ID del usuario fuente (desde_ID)';
$string['cligathering:stopping'] = 'Para detener la fusión, presione Ctrl+C o escriba -1 en los campos fromid o toid.';
$string['cligathering:toid'] = 'ID del usuario destino (a_id)';
$string['dbko_no_transactions'] = '<strong>¡Fusión fallida!</strong> <br/>Su motor de base de datos no admite transacciones. Por lo tanto, su base de datos <strong>se ha actualizado</strong>. El estado de su base de datos puede ser inconsistente. <br/>Pero revise el registro de fusión e informe del error a los desarrolladores del plugin. Recibirá una solución en breve. Después de actualizar el plugin a la última versión, que incluirá la solución a ese problema, repita la fusión para completarla correctamente.';
$string['dbko_transactions'] = '<strong>¡Fusión fallida! Su motor de base de datos admite transacciones. Por lo tanto, se ha revertido toda la transacción actual y no se ha realizado ninguna modificación en su base de datos.</strong>.';
$string['dbok'] = 'Unión exitosa';
$string['deletableuser'] = 'Esta cuenta de usuario está suspendida y la última fusión se realizó con otra cuenta con éxito: esta cuenta se puede eliminar. Sin embargo, verifique esto dos veces antes de continuar.';
$string['deleted'] = 'El usuario con ID {$a} fue eliminado';
$string['error_return'] = 'Regresar al formato de búsqueda';
$string['errorsameuser'] = 'Tratando de unir al mismo usuario';
$string['errortransactionsonly'] = 'Error: Se requieren transacciones, pero el tipo de base de datos {$a} no las admite. Si es necesario, puede permitir la fusión de usuarios sin transacciones. Revise la configuración del plugin para configurarla correctamente.';
$string['eventusermergedfailure'] = 'Falló la unión';
$string['eventusermergedsuccess'] = 'Fusión exitosa';
$string['exception:nocoursemodule'] = 'No se puede encontrar el módulo del curso para el módulo "{$a->module}", activity.id "{$a->activityid}" y course.id "{$a->courseid}".';
$string['exception:nomoduleinstance'] = 'No se puede encontrar la actividad "{$a->module}" con id "{$a->activityid}".';
$string['excluded_exceptions'] = 'Excluir excepciones';
$string['excluded_exceptions_desc'] = 'La experiencia en este tema sugiere que todas estas tablas de base de datos deben excluirse de la fusión. Consulte el archivo README para obtener más información. <br> Por lo tanto, para aplicar el comportamiento predeterminado del plugin, debe seleccionar \'{$a}\' para excluir todas esas tablas del proceso de fusión (recomendado).<br> Si lo prefiere, puede excluir cualquiera de esas tablas e incluirlas en el proceso de fusión (no recomendado).';
$string['exportlogs'] = 'Exportar bitácoras como CSV';
$string['finishtime'] = 'Fusión finalizó en {$a}';
$string['form_description'] = '<p>Puede buscar usuarios aquí si desconoce su nombre de usuario o número de identificación. De lo contrario, puede expandir el formulario para ingresar esa información directamente. Consulte la ayuda sobre los campos para obtener más información.</p>';
$string['form_header'] = 'Encontrar usuarios a juntar';
$string['frommedetail'] = 'Desde esta cuenta a {$a->profilelink} con {$a->success} el {$a->time}. {$a->loglink}';
$string['header'] = 'Unir dos usuarios dentro de una sola cuenta';
$string['header_help'] = 'Si se elimina un usuario y se conserva otro, se fusionarán los datos del usuario anterior con los del usuario actual. Tenga en cuenta que ambos usuarios deben existir previamente y que no se eliminará ninguna cuenta. El administrador debe realizar este proceso manualmente.</p><p><strong>¡Haga esto solo si sabe lo que hace, ya que es irreversible!</strong></p>
<p> <strong> ¡Haga esto solo si sabe lo que estás haciendo, ya que no es reversible! </strong> </p>';
$string['into'] = 'dentro de';
$string['invalid_option'] = 'Opción de formato inválida';
$string['invaliduser'] = 'No existe un usuario con el campo "{$a->field}" = "{$a->value}"';
$string['lastmerge'] = 'Ultimas fusiones que involucran a este usuario:';
$string['logid'] = 'Para mayores referencias, estos resultados están guardados en la bitácora id {$a}.';
$string['logko'] = 'Ocurrió algun error:';
$string['loglist'] = 'Todos estos registros son acciones de fusión realizadas, mostrando si salieron bien:';
$string['logok'] = 'Aquí están las consultas que han sido enviadas a la BasedeDatos:';
$string['mergedbyuseridonlog'] = 'Unido por';
$string['mergeusers'] = 'Unir cuentas de usuarios';
$string['mergeusers:mergeusers'] = 'Juntar cuentas de usuario';
$string['mergeusers:view'] = 'Unir Cuentas de Usuarios';
$string['mergeusers:viewlog'] = 'Ver bitácoras de fusión';
$string['mergeusers_confirm'] = 'Después de confirmar, se iniciará el proceso de fusión.<br /><strong>¡Esto no será reversible!</strong> ¿Está seguro de que desea continuar?';
$string['mergeusersadvanced'] = '<strong>Dirigir entrada del usuario</strong>';
$string['mergeusersadvanced_help'] = 'Aquí puede ingresar los campos a continuación si sabe exactamente qué usuarios desea fusionar.<br /><br /> Haga clic en el botón "Buscar" para verificar/confirmar que los datos ingresados corresponden de hecho a usuarios.';
$string['merging'] = 'Unida';
$string['newuser'] = 'Usuario a conservar';
$string['newuserid'] = 'ID de usuario a conservar';
$string['newuseridonlog'] = 'Usuario conservado';
$string['no_saveselection'] = 'Usted no seleccionó ni al usuario viejo ni al nuevo.';
$string['nologs'] = 'Aún no hay registros de fusión. ¡Bien por ti!';
$string['nomergedby'] = 'No grabado';
$string['nondeletableuser'] = 'Esta cuenta de usuario no está suspendida o la última fusión fue exitosa con esta cuenta: <strong>esta cuenta está activa y debe mantenerse</strong>.';
$string['olduser'] = 'Usuario a quitar';
$string['olduserid'] = 'ID de usuario a ser removida';
$string['olduseridonlog'] = 'Usuario removido';
$string['openlog'] = 'Ver bitácora';
$string['pluginname'] = 'Unir cuentas de usuarios';
$string['privacy:metadata'] = 'El plugin para Juntar Cuentas de Usuario no almacena ningún dato personal.';
$string['profilefields'] = 'Campos de perfil de usuario';
$string['profilefieldsdesc'] = 'Este plugin ahora muestra el estado de la fusión en un cuadro específico en la página de perfil de usuario. Los campos de perfil de usuario personalizados anteriores relacionados con este plugin ya no se utilizan y muestran información obsoleta. Le informamos que los campos con el nombre corto "{$a->shortnames}" aún están presentes en la categoría de campo "{$a->categories}". Visite la <a href="{$a->url}">página de gestión de campos de perfil de usuario</a> para eliminarlos manualmente. No los eliminamos durante el proceso de actualización para que pueda adaptarse a la nueva situación.';
$string['qa_action_delete_fromid'] = 'Conservar intentos del nuevo usuario';
$string['qa_action_delete_toid'] = 'Conservar intentos del antiguo usuario';
$string['qa_action_remain'] = 'No hacer nada: no juntar ni eliminar';
$string['qa_action_remain_log'] = 'Los datos del usuario de la tabla <strong>{$a}</strong> no están actualizados';
$string['qa_action_renumber'] = 'Juntar intentos de ambos usuarios y renumerarlos';
$string['qa_chosen_action'] = 'Opción activa para intentos de exámenes: {$a}.';
$string['qa_grades'] = 'Calificaciones recalculadas para los exámenes: {$a}.';
$string['quizattemptsaction'] = 'Cómo resolver los intentos de exámenes';
$string['quizattemptsaction_desc'] = 'Al fusionar intentos de examen, pueden darse tres casos: <ol><li>Solo el usuario anterior tiene intentos de examen. Todos los intentos aparecerán como si los hubiera realizado el nuevo usuario.</li><li>Solo el nuevo usuario tiene intentos de examen. Todo es correcto y no se realiza ninguna acción.</li><li>Ambos usuarios tienen intentos para el mismo examen. <strong>Debe elegir qué hacer en caso de conflicto.</strong> Debe elegir una de las siguientes acciones: <ul> <li><strong>{$a->renumber}</strong>. Los intentos del usuario anterior se fusionan con los del nuevo usuario y se renumeran según el momento en que se iniciaron.</li><li><strong>{$a->delete_fromid}</strong>. Los intentos del usuario anterior se eliminan. Los intentos del nuevo usuario se conservan, ya que esta opción los considera los más importantes.</li><li><strong>{$a->delete_toid}</strong>. Los intentos del nuevo usuario se eliminan. Los del antiguo se conservan, ya que esta opción los considera los más importantes.</li><li><strong>{$a->remain}</strong>. Los intentos no se fusionan ni se eliminan, sino que permanecen relacionados con el usuario que los realizó. Esta es la acción más segura, pero fusionar usuarios del usuario A al usuario B o del usuario B al A puede generar diferentes calificaciones del examen.</li></ul> </li></ol>
</ol>';
$string['results'] = 'Resultados y bitácora de la fusión';
$string['review_users'] = 'Confirmar usuarios a juntar';
$string['saveselection_submit'] = 'Guardar selección';
$string['searchuser'] = 'Buscar a Usuario';
$string['searchuser_help'] = 'Introducir la expresión que desea buscar para un campo de usuario específico. Solo "Id" ofrece una coincidencia exacta. El resto de los campos de usuario ofrecen coincidencias parciales. También puede buscar todos los campos de usuario compatibles a la vez.';
$string['setting:invalidjson'] = 'Contenido JSON no válido.';
$string['settings:calculateddbsettings'] = 'Configuración de la base de datos calculada';
$string['settings:calculateddbsettingsdesc'] = 'Las siguientes configuraciones son las de la base de datos calculada y las predeterminadas, para ayudarle a comprender y comparar ambas. Las configuraciones calculadas incluyen las predeterminadas y personalizadas correctamente fusionadas, y se utilizarán al fusionar usuarios.<p><table><tr><th>{$a->calculatedname}</th><th>{$a->defaultname}</th></tr><tr><td><blockquote><code><pre>{$a->calculated}</pre></code></blockquote></td><td><blockquote><code><pre>{$a->default}</pre></code></blockquote></td></tr></table>';
$string['settings:customdbsettings'] = 'Configuración de base de datos personalizada';
$string['settings:customdbsettingsdesc'] = 'Especifique la configuración personalizada de la base de datos para esta instancia de Moodle en formato JSON. Esta complementará y anulará la configuración predeterminada de la base de datos. El contenido actual del archivo <code>config/config.local.php</code> (si existe) se mostrará como valor predeterminado para facilitar la migración. El contenido se formatea automáticamente al almacenar el valor de la configuración. Si encuentra errores de sintaxis al almacenar esta configuración, considere usar caracteres de escape, ya que debe ser una cadena JSON válida. Por ejemplo, la barra invertida (<code>\\</code>) debe estar presente como una barra invertida doble (<code>\\\\\\</code>).';
$string['settings:databasesettings'] = 'Configuración de la base de datos';
$string['settings:defaultdbsettings'] = 'Configuración de base de datos predeterminada de <code>default_db_config.php</code>';
$string['settings:generalsettings'] = 'Configuraciones generales';
$string['starttime'] = 'Fusión inició en {$a}';
$string['suspenduser_setting'] = 'Suspender usuario antiguo';
$string['suspenduser_setting_desc'] = 'Si está habilitada, suspende automáticamente al usuario antiguo tras una fusión exitosa, impidiéndole iniciar sesión en Moodle (recomendado). Si está deshabilitada, el usuario antiguo permanece activo. En ambos casos, no tendrá acceso a sus datos relacionados.';
$string['tableko'] = 'Tabla {$a} : ¡ actualización NO OK !';
$string['tableok'] = 'Tabla {$a} : actualización OK';
$string['tableskipped'] = 'Por razones de registro o seguridad, omitimos <strong>{$a}</strong>. <br />Para eliminar estas entradas, elimine el usuario antiguo una vez que este script se haya ejecutado correctamente.';
$string['timetaken'] = 'La unión tomó {$a} segundos';
$string['tomedetail'] = 'Desde {$a->profilelink} a esta cuenta con {$a->success} el {$a->time}. {$a->loglink}';
$string['transactions_not_supported'] = 'Para su información, su base de datos <strong>no admite transacciones</strong>.';
$string['transactions_setting'] = 'Transacciones permitidas solamente';
$string['transactions_setting_desc'] = 'Si está habilitada, la fusión de usuarios no funcionará en bases de datos que NO admitan transacciones (recomendado). Habilitarla es necesario para garantizar la consistencia de la base de datos en caso de errores de fusión. Si está deshabilitada, siempre se ejecutarán acciones de fusión. En caso de error, el registro de fusión mostrará el problema. Informar a los responsables del plugin le proporcionará una solución rápida. Este plugin ya considera las tablas principales de Moodle y algunos plugins de terceros. Si no tiene ningún plugin de terceros en su instalación de Moodle, puede activar o desactivar esta opción sin problemas.';
$string['transactions_supported'] = 'Para su información, su base de datos <strong>admite transacciones</strong>.';
$string['uniquekeynewidtomaintain'] = 'Conservar datos de usuario nuevo';
$string['uniquekeynewidtomaintain_desc'] = 'En caso de conflicto, como cuando la columna relacionada con user.id es una clave única, este plugin conservará los datos del nuevo usuario (por defecto). Esto también significa que se eliminarán los datos del usuario anterior para mantener la coherencia. De lo contrario, si desmarca esta opción, se conservarán los datos del usuario anterior.contrario, si Usted desactiva esta opción, se conservarán los datos del antiguo usuario.';
$string['unknownprofile'] = 'ID de usuario desconocido {$a}';
$string['usermergingheader'] = '&laquo;{$a->username}&raquo; (user ID = {$a->id})';
$string['userreviewtable_legend'] = '<b>Revisar usuarios a juntar</b>';
$string['userselecttable_legend'] = '<b>Seleccionar usuarios a juntar</b>';
$string['viewlog'] = 'Bitácoras de unión de usuarios';
$string['wronglogid'] = 'La bitácora que Usted pide ya no existe';
