<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_kopere_bi', language 'es_mx', version '5.1'.
 *
 * @package     local_kopere_bi
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['active_enrolments'] = 'Inscripciones activas';
$string['all_learners'] = 'Todos los alumos';
$string['area_desc'] = 'Generar un gráfico de área';
$string['area_name'] = 'Gráfica de Área';
$string['block_add'] = 'Añadir nuevo Bloque';
$string['block_delete_message'] = '¿Realmente quiere eliminar permanentemente este bloque y <br> sus reportes?';
$string['block_delete_title'] = 'Eliminar Bloque';
$string['block_extra'] = 'Opciones muy avanzadas de la gráfica';
$string['block_not_found'] = 'Bloque no encontrado';
$string['block_theme'] = 'Tema del Bloque';
$string['block_theme_blue'] = 'Tema Azul';
$string['block_theme_dark'] = 'Tema Oscuro';
$string['block_theme_green'] = 'Tema Verde';
$string['block_theme_light'] = 'Tema claro (predeterminado)';
$string['block_theme_orange'] = 'Tema Naranja';
$string['block_theme_pink'] = 'Tema Rosa';
$string['blocktype_not_found'] = 'Tipo de bloque no encontrado';
$string['c_enablecompletion'] = 'Finalización habilitada';
$string['c_format'] = 'Formato del Curso';
$string['c_fullname'] = 'Nombre completo del curso';
$string['c_id'] = 'ID del curso';
$string['c_shortname'] = 'Nombre corto';
$string['c_tempo'] = 'Tiempo empleado';
$string['c_timemodified'] = 'Modificado en';
$string['c_visible'] = 'Visible';
$string['ca_completed_activities'] = 'Actividades completadas';
$string['cache_time'] = 'Tiempo de caché';
$string['cache_time_15min'] = '15 minutos';
$string['cache_time_1d'] = '24 horas';
$string['cache_time_1h'] = '1 hora';
$string['cache_time_30min'] = '30 minutos';
$string['cache_time_6h'] = '6 horas';
$string['cache_time_desc'] = 'Tiempo que los resultados de SQL deben permanecer en caché antes de borrarse';
$string['cache_time_no'] = 'Sin caché';
$string['cachedef_block_chart_data_15m'] = 'Caché de datos de gráfica por 15 minutos';
$string['cachedef_block_chart_data_1d'] = 'Caché de datos de gráfica por 1 día';
$string['cachedef_block_chart_data_1h'] = 'Caché de datos de gráfica por 1 hora';
$string['cachedef_block_chart_data_30m'] = 'Caché de datos de gráfica por 30 minutos';
$string['cachedef_block_chart_data_6h'] = 'Caché de datos de gráfica por 6 horas';
$string['cachedef_block_chart_data_none'] = 'Caché de datos de gráfica sin datos';
$string['cachedef_ip_user_location'] = 'Caché de localización del usuario por IP';
$string['cachedef_mustache_nosql'] = 'Almacenamiento en caché de datos de Mustache para NoSQL';
$string['cachedef_mustache_sql'] = 'Caché de datos de Mustache para SQL';
$string['case_complete'] = 'Completado';
$string['case_incomplete'] = 'Incompleto';
$string['case_never_accessed'] = 'Nunca accesado';
$string['cat_delete'] = 'Eliminar categoría';
$string['cat_description'] = 'Descripción de categoría';
$string['cat_edit'] = 'Editar categoría';
$string['cat_name'] = 'Nombre de categoría';
$string['cat_new'] = 'Nueva categoría';
$string['cat_not_found'] = 'Categoría no encontrada';
$string['cat_title'] = 'Categoría';
$string['cat_upload'] = 'Subir un archivo de plantilla';
$string['cat_upload_filetitle'] = 'seleccionar y subir el archivo JSON exportado desde Kopere BI';
$string['category_delete_confirm'] = 'Eliminación de Categoría';
$string['category_delete_message'] = '¿Realmente quiere eliminar la categoría <strong>{$a}</strong>  y todas sus páginas y bloques?';
$string['cc_id'] = 'Cursos completados';
$string['cc_timecompleted'] = 'Completado en';
$string['chart_area_default'] = 'Configuración predeterminada del gráfico de área';
$string['chart_column_default'] = 'Configuración predeterminada del gráfico de columnas';
$string['chart_default_desc'] = 'Cambiar este valor no afectará ningún gráfico existente.<br>Edítelo solo si está familiarizado con los gráficos de Apex. Para obtener más información, visite <a target="_blank" href="https://apexcharts.com/docs/series/">apexcharts.com/docs</a>';
$string['chart_line_default'] = 'Configuración predeterminada del gráfico de línea';
$string['chart_pie_default'] = 'Configuración predeterminada del gráfico de pastel';
$string['city_name'] = 'Ciudad';
$string['class_not_found'] = 'Clase no encontrada';
$string['click_new_block'] = 'Haga clic en el tipo de bloque que desea agregar.';
$string['client_name'] = 'Navegador';
$string['client_version'] = 'Versión';
$string['cm_cmid'] = 'ID del módulo del curso';
$string['column_desc'] = 'Generar un gráfico de Columna';
$string['column_name'] = 'Gráfico de Columna';
$string['completed_learners'] = 'Alumnos que completaron los cursos';
$string['completion_status'] = 'Monitoreo';
$string['completionstate_status'] = 'Finalización';
$string['country_name'] = 'País';
$string['course_completed'] = 'Porcentaje de finalización';
$string['create'] = 'Crear';
$string['create_report'] = 'Crear reporte';
$string['css_extra'] = 'CSS adicional';
$string['css_extra_desc'] = 'Agregue estilos CSS o SCSS a este bloque.<br>El CSS agregado solo se aplicará al contenido de este bloque y no tendrá efecto en ninguna otra parte de Moodle.';
$string['ctx_instanceid'] = 'Cursos inscritos';
$string['data_not_found'] = 'Sin datos encontrados';
$string['delete_report_text'] = '¿Realmente quiere eliminar este reporte?';
$string['delete_report_title'] = 'Eliminar reporte';
$string['e_enrol'] = 'Tipo de inscripción';
$string['edit_report'] = 'Editar reporte';
$string['enrol_status'] = 'Estado de inscripción';
$string['enrol_timeend'] = 'Finalización de inscripción';
$string['error_chart_renderer'] = 'Error al renderizar la gráfica';
$string['error_data_loader'] = 'Error al cargar datos de la gráfica';
$string['expired_enrolments'] = 'Inscripciones expiradas';
$string['extra_langs_customs_title'] = 'Para ayudarle con las nuevas cadenas, dejé algunos campos en blanco:';
$string['extra_langs_filter_component'] = 'Componente';
$string['extra_langs_header_identifier'] = 'Identificador';
$string['extra_langs_header_lang_key'] = 'Clave de reemplazo';
$string['extra_langs_header_string'] = 'Texto actual';
$string['extra_langs_title'] = 'Claves que ya existen';
$string['extra_options'] = 'Opciones avanzadas del bloque';
$string['firstname'] = 'Nombre del estudiante';
$string['g_finalgrade'] = 'Calificación final';
$string['grade'] = 'Calificación';
$string['grade_course'] = 'Calificación del curso';
$string['html_after'] = 'Texto adicional opcional (en formato Texto, HTML o Mustache) que se muestra después del gráfico.';
$string['html_before'] = 'Optional additional text (in Text, HTML, or Mustache format) displayed above the chart';
$string['html_block'] = 'Bloque HTML con soporte Mustache';
$string['html_block_desc'] = '<p>El HTML agregado a este campo debe seguir el formato <strong>Mustache</strong>, lo que permite la sustitución dinámica de datos en sus páginas. Utilice llaves dobles <code>{{ }}</code> para hacer referencia a los valores de las columnas SQL directamente en el HTML, lo que garantiza que los datos se inserten correctamente.</p>
<cita en bloque>
    <p>Por ejemplo, utilizando la siguiente consulta SQL:</p>
    <pre>SELECT firstname, lastname, email FROM mdl_user WHERE id = :userid</pre>
 <p>Puede hacer referencia a los valores devueltos en tu HTML utilizando la siguiente sintaxis:</p>
    <pre>&lt;p&gt;Email: {{{email}}}&lt;/p&gt;
    &lt;p&gt;Nombre completo: {{{firstname}}} {{{lastname}}}&lt;/p&gt;</pre>
</blockquote>
<blockquote>
 <p>En este ejemplo, quiero mostrar varias filas de un resultado SQL, que devuelve una lista de usuarios registrados con autenticación manual. El SQL utilizado para esto es:</p>
    <pre>SELECT firstname, lastname, email FROM mdl_user WHERE auth = \'manual\'</pre>
 <p>Para iterar sobre los resultados y mostrar los datos en formato de tabla, uso <code>{{#lines}}</code> en la plantilla para repetir el contenido de cada registro devuelto. La plantilla se vería así:</p>
    <pre>&lt;table class="table table-bordered"&gt;
    &lt;tr&gt;
        &lt;th&gt;E-mail&lt;/th&gt;
        &lt;th&gt;Full name&lt;/th&gt;
    &lt;/tr&gt;
    <strong>{{#lines}}</strong>
        &lt;tr&gt;
            &lt;td&gt;{{{email}}}&lt;/td&gt;
            &lt;td&gt;{{{firstname}}} {{{lastname}}}&lt;/td&gt;
        &lt;/tr&gt;
    <strong>{{/lines}}</strong>
&lt;/table&gt;</pre>
</blockquote>
<p>Las llaves triples <code>{{{ }}}</code> permiten insertar el valor sin escapar el HTML, lo que resulta útil para mostrar contenido que puede contener etiquetas HTML.</p>
<p>Para obtener más información sobre el uso de plantillas Mustache en Moodle, consulte la documentación oficial: <a href="https://moodledev.io/docs/guides/templates" target="_blank">Guía de plantillas de Moodle</a>.</p>';
$string['html_desc'] = 'Muestra un bloque HTML con datos provenientes de la base de datos';
$string['html_name'] = 'Bloque HTML';
$string['inactive_enrolments'] = 'Inscripciones Inactivas';
$string['info_desc'] = 'Sólo información. Ideal para mostrar el nombre del estudiante, estado de inscripción, etc.';
$string['info_error_sql'] = 'Error al ejecutar SQL';
$string['info_name'] = 'Línea de información';
$string['info_sql_warning'] = 'Recuerde que el SQL a continuación debe devolver solo una fila con solo una columna.';
$string['integracaoroot'] = 'Integraciones';
$string['item_not_found'] = 'Elemento no encontrado';
$string['kopere_bi:manage'] = 'Gestionar la inteligencia empresarial';
$string['kopere_bi:view'] = 'Ver inteligencia empresarial';
$string['l_ip'] = 'IP';
$string['l_origin'] = 'Origen';
$string['l_timecreated'] = 'Creado en';
$string['line_desc'] = 'Generar una gráfica de líneas';
$string['line_name'] = 'Gráfica de líneas';
$string['line_sql_warning'] = '<p>Recuerde que el SQL a continuación debe retornar con la siguiente estructura:</p>
<ul>
 <li>La primera columna debe contener el texto que se utilizará como nombres del eje X.</li>
 <li>Las demás columnas deberán estructurarse de la siguiente manera:
 <ul>
 <li>El nombre de la columna se utilizará como nombre de la serie. Puede utilizar cadenas de traducción como se explica en la
 <a href="?classname=bi-extra_langs&method=index" target="_blank">página de cadenas</a>.</li>
 <li>El valor de la columna representará los datos de la serie en el gráfico.</li>
 </ul>
 </li>
</ul>
<blockquote>En el siguiente ejemplo, la primera columna devuelve el nombre del curso y la segunda columna devuelve la cantidad de noticias de cada curso:
<pre>SELECT fullname,
       newsitems AS "Course news items count"
  FROM mdl_course</pre></blockquote>
<blockquote>En el siguiente ejemplo, además de que la primera columna es el nombre del curso, se generan dos líneas adicionales en el gráfico, con nombres de columnas traducidos:
<pre>  SELECT c.fullname AS course_name,
         COUNT(cm.section) AS \'lang::thiscourse::theme_rebel\',
         COUNT(cm.module)  AS \'lang::ca_completed_activities::local_kopere_bi\'
    FROM mdl_course AS c
    JOIN mdl_course_modules AS cm ON c.id = cm.course
GROUP BY c.id</pre></blockquote>';
$string['loading'] = 'Cragndo...';
$string['maps_1_city'] = '{a1} y una ciudad más';
$string['maps_desc'] = 'Crear un mapa de estudiantes en línea basado en sus IPs';
$string['maps_many_city'] = '{a1} y {a2} ciudades más';
$string['maps_name'] = 'Mapa de estudiantes en línea';
$string['maps_online'] = '{a1} estudiante en línea';
$string['maps_onlines'] = '{a1} estudiantes en línea';
$string['maps_sql_warning'] = '<p>Recuerde que el SQL a continuación debe devolver solo una columna, y esa columna debe contener una IP válida.<br>Ejemplo: el SQL <code>SELECT lastip FROM {user} WHERE lastaccess > UNIX_TIMESTAMP() - (10 * 60)</code> devuelve todos los estudiantes que accedieron a Moodle en los últimos 10 minutos</p>';
$string['module_count'] = 'Número de módulos';
$string['module_name'] = 'Nombre del módulo';
$string['modulename'] = 'inteligencia empresarial';
$string['new_block'] = 'Nuevo bloque en esta página';
$string['new_block_1'] = 'Un bloque';
$string['new_block_12'] = 'Uno más dos bloques';
$string['new_block_2'] = 'Dos bloques';
$string['new_block_21'] = 'Dos más un bloque';
$string['new_block_25'] = 'Uno ancho y uno angosto';
$string['new_block_3'] = 'Tres bloques';
$string['new_block_4'] = 'Cuatro bloques';
$string['new_block_52'] = 'Uno angosto y uno ancho';
$string['not_accessed_learners'] = 'Estudiantes que no han accedido a la plataforma';
$string['not_completed_learners'] = 'Estudiantes que no han completado cursos';
$string['num_activelearners'] = 'Número de estudiantes activos';
$string['num_completedlearners'] = 'Número de estudiantes que completaron cursos';
$string['num_courses'] = 'Número de cursos disponibles';
$string['num_learners'] = 'Número total de estudiantes';
$string['num_user'] = 'Número de estudiantes';
$string['os_name'] = 'Sistema Operativo';
$string['page_delete_confirm'] = 'Eliminación de página';
$string['page_delete_message'] = '¿Realmente quiere eliminar la página <strong>{$a}</strong> y todos sus bloques?';
$string['page_description'] = 'descripción de página';
$string['page_edit'] = 'Editar página';
$string['page_name'] = 'Nombre de página';
$string['page_new_cat'] = 'Añadir una nueva página en esta categoría';
$string['page_new_sequence'] = 'Arrastre bloques para cambiar el orden de los bloques.';
$string['page_not_found'] = 'Página no encontrada';
$string['page_preview'] = 'Página anterior';
$string['page_title_edit'] = 'Editar el título de esta página';
$string['page_title_export'] = 'Exportar página';
$string['pie_desc'] = 'Crear una gráfica de pastel';
$string['pie_name'] = 'Gráfica de pastel';
$string['pie_sql_warning'] = '<p>El SQL a continuación debe devolver solo dos columnas.</p><p>La primera columna será el nombre de la columna y la segunda columna debe ser un valor numérico.</p>';
$string['pluginname'] = 'inteligencia empresarial';
$string['privacy:metadata:city_name'] = 'El nombre de la ciudad desde donde accede el usuario.';
$string['privacy:metadata:client_name'] = 'El nombre del cliente o navegador utilizado por el usuario.';
$string['privacy:metadata:client_type'] = 'El tipo de cliente, como navegador o aplicación.';
$string['privacy:metadata:client_version'] = 'La versión del cliente o navegador.';
$string['privacy:metadata:country_code'] = 'El código del país desde donde accede el usuario.';
$string['privacy:metadata:country_name'] = 'El nombre del país desde donde accede el usuario.';
$string['privacy:metadata:day'] = 'El día del acceso.';
$string['privacy:metadata:lastip'] = 'LA última dirección IP registrada del usuario.';
$string['privacy:metadata:latitude'] = 'La latitud de la ubicación del usuario durante el acceso.';
$string['privacy:metadata:local_kopere_bi_online'] = 'Tabla que almacena información sobre los usuarios actualmente en línea para su análisis.';
$string['privacy:metadata:local_kopere_bi_statistic'] = 'Tabla que almacena datos estadísticos para fines analíticos.';
$string['privacy:metadata:longitude'] = 'La longitud de la ubicación del usuario durante el acceso.';
$string['privacy:metadata:month'] = 'El mes del acceso';
$string['privacy:metadata:os_name'] = 'El nombre del Sistema Operativo usado por el usuario.';
$string['privacy:metadata:os_version'] = 'La versión  del Sistema Operativo usado por el usuario.';
$string['privacy:metadata:seconds'] = 'Los segundos del tiempo de acceso.';
$string['privacy:metadata:user_id'] = 'El identificador único del usuario en la plataforma.';
$string['privacy:metadata:userid'] = 'El identificador del usuario para registros específicos.';
$string['privacy:metadata:weekday'] = 'El día de la semana del acceso';
$string['privacy:metadata:year'] = 'El año del acceso';
$string['reload_time'] = 'Recargar datos cada';
$string['reload_time_10m'] = '10 minutos';
$string['reload_time_1h'] = '1 hora';
$string['reload_time_1m'] = '1 minuto';
$string['reload_time_20m'] = '20 minutos';
$string['reload_time_2h'] = '2 horas';
$string['reload_time_30m'] = '30 minutos';
$string['reload_time_40m'] = '40 minutos';
$string['reload_time_50m'] = '50 minutos';
$string['reload_time_5m'] = '5 minutos';
$string['reload_time_desc'] = 'Recargar datos cada X minutos. ¡Este valor debe ser mayor que el valor de caché!';
$string['reload_time_none'] = 'Nunca';
$string['report_1_cat_description'] = 'Informes sobre el desempeño y progreso de los estudiantes en sus cursos.';
$string['report_1_cat_title'] = 'Estudiantes';
$string['report_1_categories'] = 'Categorías';
$string['report_1_description'] = 'Reportes sobre el estado de los estudiantes';
$string['report_1_modules'] = 'Módulos';
$string['report_1_title'] = 'Estudiantes activos';
$string['report_1_user_status'] = 'Estado del estudiante';
$string['report_1_user_summary'] = 'Resumen de estudiantes activos';
$string['report_1_users'] = 'Estudiantes';
$string['report_2_cat_description'] = 'Análisis exhaustivos de todos los cursos disponibles, rendimiento, progreso y desarrollo de los estudiantes.';
$string['report_2_cat_title'] = 'Cursos';
$string['report_2_completion_progress'] = 'Porcentaje del progreso de finalización';
$string['report_2_course_access_statistics'] = 'Estadísticas de acceso al curso';
$string['report_2_course_analysis_participation_completion'] = 'Análisis del curso: participación y finalización';
$string['report_2_course_progress'] = 'Progreso del curso';
$string['report_2_description'] = 'Reporte del curso';
$string['report_2_title'] = 'Cursos';
$string['report_2_total_engagement'] = 'Participación total por curso';
$string['report_3_cat_description'] = 'Informe de todos los que están en línea en Moodle';
$string['report_3_cat_title'] = 'En línea';
$string['report_3_course_access_time'] = 'Tiempo de acceso al curso';
$string['report_3_course_last30days'] = 'Datos solo de los últimos 30 días';
$string['report_3_description'] = 'Mostrar estudiantes en línea y regiones superiores';
$string['report_3_operating_systems'] = 'Sistemas operativos con el mayor tiempo de acceso';
$string['report_3_title'] = 'Estudiantes en línea';
$string['report_3_top_browsers'] = 'Navegadores con el mayor tiempo de acceso';
$string['report_3_top_country_access'] = 'Ciudades/Países con mayor tiempo de acceso';
$string['report_3_users_online'] = 'Estudiantes en línea';
$string['report_3_users_online_list'] = 'Lista de Estudiantes en línea';
$string['report_4_cat_description'] = 'Reportes de inscripción que cubren el historial, el estado actual y las tendencias de inscripción en los cursos.';
$string['report_4_cat_title'] = 'Inscripciones';
$string['report_4_completion_0'] = 'Seguimiento de finalización deshabilitado para esta actividad';
$string['report_4_completion_1'] = 'Seguimiento de finalización habilitado para esta actividad';
$string['report_4_completion_2'] = 'Seguimiento automático de finalización habilitado para esta actividad';
$string['report_4_completion_none'] = 'Finalización desconocida';
$string['report_4_completionstate_0'] = 'Actividad no completada';
$string['report_4_completionstate_1'] = 'Actividad completada, pero no se especifica si se aprueba o no';
$string['report_4_completionstate_2'] = 'Actividad realizada con una calificación superior al mínimo requerido para aprobar';
$string['report_4_completionstate_3'] = 'Actividad realizada con una calificación inferior al mínimo requerido para aprobar';
$string['report_4_completionstate_4'] = 'Reprobó un elemento oculto';
$string['report_4_completionstate_none'] = 'Finalización desconocida';
$string['report_4_coursesenrollmentstatus'] = 'Estado de inscripción a cursos';
$string['report_4_description'] = 'Reportes de inscripción que cubren el historial, el estado actual y las tendencias de inscripción en los cursos.';
$string['report_4_enrolpercourse'] = 'Inscripciones por curso';
$string['report_4_title'] = 'Estadísticas';
$string['report_5_cat_description'] = 'Este informe proporciona una descripción general de las métricas e información clave del sistema, lo que permite un análisis integral de su rendimiento y funcionamiento.';
$string['report_5_cat_title'] = 'Sistema';
$string['report_5_component'] = 'Componente';
$string['report_5_coursefilesizes'] = 'Archivos del Curso';
$string['report_5_coursefilesizes_title'] = 'Espacio ocupado por cada curso';
$string['report_5_description'] = 'El reporte general ofrece un resumen detallado de todos los aspectos del sistema, incluidos datos de uso, rendimiento y áreas de mejora. Ideal para administradores y gerentes que buscan optimizar la eficiencia del sistema.';
$string['report_5_filesize'] = 'Tamaño del archivo';
$string['report_5_filesizes'] = 'Tamaños del los archivos';
$string['report_5_modulesdeleting'] = 'Módulos eliminando';
$string['report_5_modulesfilesizes'] = 'Archivos de módulos';
$string['report_5_numfiles'] = 'Número de archivos';
$string['report_5_title'] = 'General';
$string['report_5_upload_title'] = 'Space occupied by each module';
$string['report_6_cat_description'] = 'Monitoreo y estadísticas de ingresos al sistema';
$string['report_6_cat_title'] = 'Reportes de Ingresos';
$string['report_6_login'] = 'Ingresos';
$string['report_6_login_report'] = 'Reporte de Ingresos a Moodle';
$string['report_7_inactive'] = 'Inscripciones inactivas';
$string['report_7_inactive_report'] = 'Reporte de Inscripciones inactivas';
$string['report_7_users_not_accessed_course'] = 'Usuarios registrados que no han accedido a su curso';
$string['report_8_engagement'] = 'Compromiso';
$string['report_8_student_teacher_engagement'] = 'Reporte sobre el compromiso de estudiantes y docentes';
$string['report_8_teacher_access'] = 'Acceso del Profesor';
$string['report_8_total_engagement_per_course'] = 'Compromiso Total por Curso';
$string['report_9_category_desc'] = 'Reporte sobre módulos de curso';
$string['report_9_category_title'] = 'Módulos del Curso';
$string['report_9_report_1_name'] = 'Estadísticas del Módulo';
$string['report_dashboard_cat_title'] = 'Tablero';
$string['report_dashboard_page_1_cursos'] = 'Cursos / Visibles';
$string['report_dashboard_page_1_newusers'] = 'Usuarios nuevos en los últimos 12 meses';
$string['report_dashboard_page_1_online'] = 'En línea / Última hora';
$string['report_dashboard_page_1_title'] = 'Tablero';
$string['report_dashboard_page_1_users'] = 'Usuarios / Activos';
$string['report_new'] = 'Nuevo reporte para "{$a}"';
$string['report_preview'] = 'Previsualizar reporte';
$string['report_save'] = 'Guardar e ir a configuración de columna';
$string['report_title'] = 'Título del reporte';
$string['reports_selectcourse'] = 'Seleccionar los cursos para generar el reporte';
$string['reports_selectuser'] = 'Seleccionar los estudiantes para generar el reporte';
$string['return_edit'] = '<< Regresar a editar';
$string['rolename'] = 'Nombre del rol';
$string['save'] = 'Guardar';
$string['seconds'] = 'Por cuanto tiempo';
$string['select_report_select_type'] = 'Seleccionar tipo de reporte';
$string['select_report_select_type_desc'] = 'Primero, elija qué tipo de reporte desea para este bloque';
$string['select_report_type'] = 'Tipo de reporte';
$string['select_report_type_desc'] = 'Puede cambiar entre los tipos "{$a->line}", "{$a->area}" o "{$a->column}"';
$string['setting_apex'] = 'Configuración de gráficos de Apex';
$string['setting_apex_desc'] = 'Edite únicamente si está familiarizado con Apex Charts. Para obtener más información, visite <a target="_blank" href="https://apexcharts.com/docs/series/">apexcharts.com/docs</a>';
$string['sql_no_rows'] = 'El SQL devolvió 0 filas. Para configurar las columnas, la consulta SQL debe devolver al menos 1 fila.';
$string['sql_read_only'] = 'All SQL queries are protected by a read-only connection, and it is not possible to execute INSERT/UPDATE/DELETE commands.';
$string['sql_replace_keys'] = '<h4>Claves de reemplazo</h4>
<ul>
 <li><b>:userid</b> ID del estudiante para generar el reporte.</li>
 <li><b>:courseid</b> ID del curso para generar el reporte.</li>
</ul>
<h4>Multi-idioma</h4>
<p>Para devolver columnas que se traducirán según los paquetes de idioma de Moodle, se requiere un formato específico que permita procesar las cadenas y localizarlas correctamente. El formato correcto es:</p>
<pre>lang::{identifier}::{component}</pre>
<p>Dónde:</p>
<ul>
    <li><b>{identifier}</b>:Representa el identificador de cadena que se utilizará para obtener la traducción del paquete de idioma.</li>
    <li><b>{component}</b>: se refiere al componente donde se define la cadena de idioma y normalmente es el nombre del plugin (por ejemplo, <code>mod_forum</code>, <code>local_kopere_dashboard</code>, <code>theme_degrade</code>).</li>
</ul>
<p><em>Ejemplo: si necesita devolver una cadena traducida para el componente <code>mod_forum</code> con el identificador <code>postmessage</code>, la devolución debe estructurarse de la siguiente manera:</em></p>
<pre>SELECT \'<b>lang::postmessage::mod_forum</b>\' FROM mdl_forum</pre>
<p>Visite la <a href="?classname=bi-extra_langs&method=index" target="_blank">página de cadenas</a> para ver todas las cadenas disponibles.</p>';
$string['sql_replace_keys_mdl'] = '<h4>Prefijo de base de datos</h4>
<p>Siempre puede usar el prefijo <code>mdl_</code> incluso si su base de datos usa el prefijo <code>{$a}</code>.
 La inteligencia empresarial se encargará de este reemplazo.</p>';
$string['table_col_title'] = 'Título de columna';
$string['table_column_not_configured'] = 'Columnas no configuradas en esta tabla';
$string['table_desc'] = 'Mostrar una tabla con paginación de datos.';
$string['table_edit_column'] = 'Columna';
$string['table_first_5'] = 'Los primeros cinco registros de la consulta';
$string['table_info_topo'] = 'Primero, verá una vista previa de los resultados de la búsqueda. A continuación, se presentarán una serie de columnas para que usted nombre los títulos y defina el formato de los datos de cada columna.';
$string['table_info_types'] = 'Ahora puede establecer un nombre para la columna y luego especificar el formato deseado y si desea algún formato adicional con Mustache.
<ul>
 <li><strong>Sin formato</strong>: muestra el contenido exactamente como está o aplica Mustache si lo agrega.</li>
 <li><strong>No mostrar esta columna</strong>: oculta la columna seleccionada en la vista, pero los datos permanecen disponibles para el procesamiento de Mustache.</li>
 <ul><li>Mustache no disponible</li></ul>
 <li><strong>Números</strong>: formatea la columna para mostrar solo valores numéricos, aplicando reglas de visualización de números estándar, como separadores de miles y decimales.</li>
 <ul><li>Mustache no disponible</li></ul>
 <li><strong>Convertir columna al nombre completo "fullname()"</strong>: ejecuta la función <code>fullname()</code> para generar el nombre completo según el idioma, que se almacenará en esta misma columna. Para que esto funcione, la columna <code>lastname</code> es obligatoria y debe estar oculta si es posible.</li>
 <li><strong>Convertir el ID de estudiante en foto de perfil</strong>: utiliza el ID de esta columna para crear la foto de perfil.</li>
 <li><strong>Campo binario para visible/invisible</strong>: utiliza el valor binario para determinar la visibilidad, donde "0"/"falso" significa invisible y "1"/"verdadero" significa visible.</li>
 <li><strong>Campo binario para Activo/Inactivo</strong>: utiliza el valor binario para determinar el estado, donde "0"/"falso" significa Inactivo y "1"/"verdadero" significa Activo.</li>
 <li><strong>Campo "Tiempo" formateado como fecha</strong>: convierte el valor de hora (marca de tiempo) en la columna en una fecha legible, mostrando solo la fecha (día/mes/año).</li>
 <ul><li>Mustache no disponible</li></ul>
 <li><strong>Campo "Tiempo" formateado como fecha y hora</strong>: muestra el valor de la hora (marca de tiempo) en la columna como una fecha completa, incluida la hora (día/mes/año y horas:minutos).</li>
 <ul><li>Mustache no disponible</li></ul>
 <li><strong>Campo "Tiempo" formateado como hora</strong>: formatea el valor de hora (marca de tiempo) en la columna para mostrar solo la hora (horas:minutos), omitiendo la fecha.</li>
 <ul><li>Mustache no disponible</li></ul>
</ul>';
$string['table_name'] = 'Tabla de datos';
$string['table_renderer_date'] = 'Campo "Tiempo" formateado como fecha';
$string['table_renderer_datetime'] = 'Campo "Tiempo" formateado como fecha y hora';
$string['table_renderer_filesize'] = 'Convierte al tamaño de datos del disco';
$string['table_renderer_mustache'] = 'HTML de la
Columna <a href="https://moodledev.io/docs/guides/templates" target="_blank">Mustache</a>';
$string['table_renderer_none'] = 'No mostrar esta columna';
$string['table_renderer_number'] = 'Números';
$string['table_renderer_seconds'] = 'Campo "Tiempo" formateado como hora';
$string['table_renderer_status'] = 'Campo binario para Activo/Inactivo';
$string['table_renderer_title'] = 'Formateo de columna';
$string['table_renderer_translate'] = 'Utilice get_string("identifier", "component") para traducir la columna';
$string['table_renderer_userfullname'] = 'Convierte la columna al nombre completo del estudiante con la función "fullname()"';
$string['table_renderer_userphoto'] = 'Convertir la ID del estudiante en foto de perfil';
$string['table_renderer_visible'] = 'Campo binario para Visible/Invisible';
$string['theme_palette_default'] = 'Paleta predeterminada';
$string['theme_palette_desc'] = 'Colores de paleta:';
$string['theme_palette_desc2'] = 'Ver aquí todos los temas';
$string['theme_palette_palette'] = 'Paleta {$a}';
$string['theme_palette_title'] = 'Paleta de Colores';
$string['timecompleted'] = 'Inscripción completada';
$string['title'] = 'inteligencia empresarial';
$string['u_fullname'] = 'Nombre completo del estudiante';
$string['u_id'] = 'ID del estudiante';
$string['u_idnumber'] = 'Número ID';
$string['ue_id'] = 'ID de inscripción';
$string['ue_status'] = 'Estado de Inscripción';
$string['ue_timecreated'] = 'Inscripción creada en';
$string['ue_timeend'] = 'Inscripción termina en';
$string['ul_timeaccess'] = 'Último acceso';
$string['unknown'] = 'Desconocido';
$string['use_this_type'] = 'Usar este tipo';
$string['word_extra_00'] = '';
$string['word_extra_01'] = '';
$string['word_extra_02'] = '';
$string['word_extra_03'] = '';
$string['word_extra_04'] = '';
$string['word_extra_05'] = '';
$string['word_extra_06'] = '';
$string['word_extra_07'] = '';
$string['word_extra_08'] = '';
$string['word_extra_09'] = '';
$string['word_extra_10'] = '';
$string['word_extra_11'] = '';
$string['word_extra_12'] = '';
$string['word_extra_13'] = '';
$string['word_extra_14'] = '';
$string['word_extra_15'] = '';
$string['word_extra_16'] = '';
$string['word_extra_17'] = '';
$string['word_extra_18'] = '';
$string['word_extra_19'] = '';
$string['word_extra_20'] = '';
$string['word_extra_21'] = '';
$string['word_extra_22'] = '';
$string['word_extra_23'] = '';
$string['word_extra_24'] = '';
$string['word_extra_25'] = '';
$string['word_extra_26'] = '';
$string['word_extra_27'] = '';
$string['word_extra_28'] = '';
$string['word_extra_29'] = '';
$string['word_extra_30'] = '';
$string['word_extra_31'] = '';
$string['word_extra_32'] = '';
$string['word_extra_33'] = '';
$string['word_extra_34'] = '';
$string['word_extra_35'] = '';
$string['word_extra_36'] = '';
$string['word_extra_37'] = '';
$string['word_extra_38'] = '';
$string['word_extra_39'] = '';
$string['word_extra_40'] = '';
$string['word_extra_41'] = '';
$string['word_extra_42'] = '';
$string['word_extra_43'] = '';
$string['word_extra_44'] = '';
$string['word_extra_45'] = '';
$string['word_extra_46'] = '';
$string['word_extra_47'] = '';
$string['word_extra_48'] = '';
$string['word_extra_49'] = '';
$string['word_extra_50'] = '';
$string['word_extra_51'] = '';
$string['word_extra_52'] = '';
$string['word_extra_53'] = '';
$string['word_extra_54'] = '';
$string['word_extra_55'] = '';
$string['word_extra_56'] = '';
$string['word_extra_57'] = '';
$string['word_extra_58'] = '';
$string['word_extra_59'] = '';
$string['word_extra_60'] = '';
$string['word_extra_61'] = '';
$string['word_extra_62'] = '';
$string['word_extra_63'] = '';
$string['word_extra_64'] = '';
$string['word_extra_65'] = '';
$string['word_extra_66'] = '';
$string['word_extra_67'] = '';
$string['word_extra_68'] = '';
$string['word_extra_69'] = '';
$string['word_extra_70'] = '';
$string['word_extra_71'] = '';
$string['word_extra_72'] = '';
$string['word_extra_73'] = '';
$string['word_extra_74'] = '';
$string['word_extra_75'] = '';
$string['word_extra_76'] = '';
$string['word_extra_77'] = '';
$string['word_extra_78'] = '';
$string['word_extra_79'] = '';
$string['word_extra_80'] = '';
