<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'pdfannotator', language 'ja', version '5.1'.
 *
 * @package     pdfannotator
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actiondropdown'] = 'オプション';
$string['activities'] = '活動';
$string['addAComment'] = 'コメントを追加する';
$string['add_private_comment'] = '個人的なメモにコメントを追加する';
$string['add_protected_comment'] = '非公開の質問にコメントを追加する';
$string['ago'] = '{$a} 前';
$string['all'] = 'すべて';
$string['all_answers'] = 'すべての回答';
$string['all_questions'] = 'すべての質問';
$string['allanswers'] = 'すべて';
$string['allquestions'] = 'すべて';
$string['allquestionsimgtitle'] = 'このドキュメントの質問すべてを表示する';
$string['allquestionstitle'] = 'すべての質問 -';
$string['allreports'] = 'すべての報告';
$string['annotationDeleted'] = 'アノテーションが削除されました。';
$string['anonymous'] = '匿名';
$string['answer'] = '回答';
$string['answerButton'] = '回答';
$string['answerSolved'] = 'この回答はマネージャに正しいとマークされました。';
$string['answercounthelpicon'] = '回答数';
$string['answercounthelpicon_help'] = 'このカラムはあなたが受け取った質問の回答数を表示します。';
$string['answers'] = '回答';
$string['answerstab'] = '回答';
$string['answerstabicon'] = '回答';
$string['answerstabicon_help'] = 'このページではあなたのすべての回答または購読している回答のみ表示できます。リストはこのコースのすべてのアノテータをカバーします。<br />あなたが質問を投稿した場合、その質問は購読解除するまで自動的に購読されます。';
$string['author'] = '作成者';
$string['average'] = '平均';
$string['average_answers'] = '平均回答数';
$string['average_help'] = '少なくとも1つのコメントを記入したユーザのみ平均の計算 (算術平均) に含まれます。';
$string['average_questions'] = '平均質問数';
$string['by'] = 'by';
$string['by_other_users'] = 'by 他のユーザ';
$string['bynameondate'] = 'by {$a->name} - {$a->date}';
$string['cancelButton'] = 'キャンセル';
$string['chart_title'] = 'このコースのアノテータの質問および回答';
$string['clicktoopen2'] = 'ファイルを表示するには {$a} リンクをクリックしてください。';
$string['closedquestions'] = '解決済み';
$string['colorPicker'] = '色を選択する';
$string['comment'] = 'コメント';
$string['commentDeleted'] = 'コメントが削除されました。';
$string['comments'] = 'コメント';
$string['configmaxbytes'] = '最大ファイルサイズ';
$string['correct'] = '正しい';
$string['count'] = 'カウント';
$string['createAnnotation'] = 'アノテーションを作成する';
$string['currentPage'] = '現在のページ番号';
$string['day'] = '日';
$string['days'] = '日';
$string['decision'] = '決定する';
$string['decision:overlappingAnnotation'] = 'あなたは2箇所以上のアノテーションのエリアをクリックしました。あなたがクリックしたいアノテーション1つを決定してください。';
$string['delete'] = '削除';
$string['deleteComment'] = 'コメントを削除する';
$string['deletedComment'] = '削除済みコメント';
$string['deletedQuestion'] = '削除済み質問';
$string['deletingAnnotation_manager'] = 'アノテーションおよび関連コメントすべてが削除されます。';
$string['deletingAnnotation_student'] = 'アノテーションおよび関連コメントすべてが削除されます。<br />他のユーザによってコメントが投稿されない限り、あなた自身のアノテーションを削除できます。';
$string['deletingComment'] = 'コメントは削除されます。スレッドの最後のコメントでない限り、削除済みとして表示されます。';
$string['deletingCommentTitle'] = '本当によろしいですか?';
$string['deletingQuestion_manager'] = 'コメントが削除されます。<br />ヒント: あなたが同様にすべての答えを削除したい場合、ドキュメントのアノテーションを削除してください。';
$string['deletingQuestion_student'] = '質問が削除されます。<br />質問に回答されていない場合、アノテーションも削除されます。そうでない場合、質問が削除された旨、表示されます。';
$string['deletionForbidden'] = '削除不許可';
$string['didyouknow'] = 'ご存知ですか?';
$string['dnduploadpdfannotator'] = 'PDFアノテーションのファイルを作成する';
$string['document'] = 'ドキュメント';
$string['drawing'] = 'ドキュメントにペンで描きます。';
$string['edit'] = '編集';
$string['editAnnotation'] = 'アノテーションが移動されます。<br />これにより質問のコンテクストが変る場合があります。';
$string['editAnnotationTitle'] = '本当によろしいですか?';
$string['editButton'] = '保存';
$string['editNotAllowed'] = '回転は許可されていません!';
$string['editedComment'] = '最新の編集';
$string['emptypdf'] = '現在、このアノテータにはコメントがありません。';
$string['enterText'] = 'テキストを入力する';
$string['entity_helptitle'] = 'ヘルプ';
$string['error'] = 'エラー!';
$string['error:addAnnotation'] = 'アノテーションの追加中にエラーが発生しました。';
$string['error:addComment'] = 'コメントの追加中にエラーが発生しました。';
$string['error:closequestion'] = '質問のクローズ/オープン中にエラーが発生しました。';
$string['error:deleteAnnotation'] = 'アノテーションの削除中にエラーが発生しました。';
$string['error:editAnnotation'] = 'アノテーションの編集中にエラーが発生しました。';
$string['error:editcomment'] = 'コメントの編集中にエラーが発生しました。';
$string['error:findimage'] = '画像 {$a} を検索しようとしてエラーが発生しました。';
$string['error:forwardquestion'] = '質問の転送中にエラーが発生しました。';
$string['error:forwardquestionnorecipient'] = '質問の転送中にエラーが発生しました： このコースには転送された質問を受信できるユーザはいません。';
$string['error:getAllQuestions'] = 'このドキュメントの質問取得中にエラーが発生しました。';
$string['error:getAnnotation'] = 'アノテーションの取得中にエラーが発生しました。';
$string['error:getAnnotations'] = 'すべてのアノテーションの取得中にエラーが発生しました。';
$string['error:getComments'] = 'コメントの取得中にエラーが発生しました。';
$string['error:getQuestions'] = 'このページの質問取得中にエラーが発生しました。';
$string['error:getimageheight'] = '{$a}の画像の高さを取得中にエラーが発生しました。';
$string['error:getimagewidth'] = '{$a}の画像幅を取得中にエラーが発生しました。';
$string['error:hideComment'] = '参加者の表示からコメントを隠している最中にエラーが発生しました。';
$string['error:markasread'] = 'アイテムを既読マークできませんでした。';
$string['error:markasunread'] = 'アイテムを未読マークできませんでした。';
$string['error:markcorrectanswer'] = '回答を正しいとマークしている最中にエラーが発生しました。';
$string['error:maximalsizeoffile'] = 'あなたのファイル {$a->filename} は、ファイルの最大サイズ {$a->filesize} を超えています。最大 {$a->maxfilesize} のファイルを一つのコメントに添付できます。';
$string['error:openingPDF'] = 'PDFファイルのオープン中にエラーが発生しました。';
$string['error:openprintview'] = 'PDFをAcrobat Readerで開いている最中にエラーが発生しました。';
$string['error:printcomments'] = 'PDFのコメントを開いている最中にエラーが発生しました。';
$string['error:printcommentsdata'] = 'サーバからのデータでエラーが発生しました。';
$string['error:printlatex'] = 'LaTeXの数式をpdfに追加しようとしてエラーが発生しました。';
$string['error:redihideCommentsplayComment'] = '参加者のコメントの再投稿中にエラーが発生しました。';
$string['error:redisplayComment'] = 'コメントの再表示中にエラーが発生しました。';
$string['error:renderPage'] = 'ページ描写中にエラーが発生しました。';
$string['error:reportComment'] = '報告の保存中にエラーが発生しました。';
$string['error:subscribe'] = '質問の購読中にエラーが発生しました。';
$string['error:unsubscribe'] = '質問の購読解除中にエラーが発生しました。';
$string['error:unsupportedextension'] = '入稿データの拡張子はサポートされていません。他の拡張子を選択してください。';
$string['error:voteComment'] = '投票の保存中にエラーが発生しました。';
$string['eventreport_added'] = 'コメントが報告されました。';
$string['filenotfound'] = '申し訳ございません、ファイルが見つかりませんでした。';
$string['fullscreen'] = 'フルスクリーン';
$string['fullscreenBack'] = 'フルスクリーンを終了する';
$string['global_setting_anonymous'] = '匿名投稿を許可しますか?';
$string['global_setting_anonymous_desc'] = 'このオプションによりあなたのユーザによる匿名コメントの投稿を許可します。このオプションは全体での匿名投稿を有効にします';
$string['global_setting_attobuttons'] = 'Attoエディタのツールバー設定';
$string['global_setting_attobuttons_desc'] = 'プラグインのリストと表示順序はここで設定できます。設定はグループ(1行に1つ)の後に、そのグループのプラグインの順番に並んだリストで構成されます。グループとプラグインは等号で区切り、プラグインはカンマで区切ります。グループ名は一意でなければならず、ボタンの共通点を示す必要があります。ボタン名とグループ名は繰り返してはならず、英数字のみ使用できます。';
$string['global_setting_latexapisetting'] = 'LaTeXからPNGへのAPI';
$string['global_setting_use_private_comments'] = '個人的なメモを許可';
$string['global_setting_use_private_comments_desc'] = '参加者が個人的な注釈や個人的なメモを書けるようになります。';
$string['global_setting_use_protected_comments'] = '非公開コメントを許可';
$string['global_setting_use_protected_comments_desc'] = '参加者が非公開の注釈やコメントを書き込めるようにします。このコメントは作成者と管理者だけが見ることができます。';
$string['global_setting_use_studentdrawing'] = '参加者にドローイングを許可';
$string['global_setting_use_studentdrawing_desc'] = 'ドローイングは匿名のため、コメントおよび報告できないことに留意してください。';
$string['global_setting_use_studenttextbox'] = '参加者にテキストボックスを許可';
$string['global_setting_use_studenttextbox_desc'] = 'テキストボックスアノテーションは匿名のため、コメントおよび報告できないことに留意してください。';
$string['global_setting_useprint'] = '保存および印刷を許可';
$string['global_setting_useprint_comments'] = 'コメントの保存および印刷を許可しますか?';
$string['global_setting_useprint_comments_desc'] = '参加者がアノテーションやコメントを保存し、印刷できるようにする。';
$string['global_setting_useprint_desc'] = '参加者がPDFドキュメントとそのコメントを保存・印刷できるようにする。';
$string['global_setting_useprint_document'] = 'ドキュメントの保存および印刷を許可';
$string['global_setting_useprint_document_desc'] = '参加者がpdfドキュメントを保存・印刷できるようにする。';
$string['global_setting_usevotes'] = 'コメントへの「いいね」を許可';
$string['global_setting_usevotes_desc'] = 'ユーザは自分の投稿以外の投稿に「いいね！」や「投票」をすることができます。';
$string['hiddenComment'] = '非表示コメント';
$string['hiddenforparticipants'] = '学生から隠す';
$string['hideAnnotations'] = 'アノテーションを隠す';
$string['highlight'] = 'テキストをハイライトしてコメントを追加します。';
$string['hour'] = '時間';
$string['hours'] = '時間';
$string['in_course'] = 'このコース';
$string['in_document'] = 'このドキュメント';
$string['infonocomments'] = '現在、このドキュメントにコメントはありません。';
$string['iscorrecthelpicon'] = '正しい';
$string['iscorrecthelpicon_help'] = '教師またはマネージャが回答を正しいとマークした場合、回答の隣に緑のチェックマークが表示されます。';
$string['itemsperpage'] = '1ページあたりのアイテム数';
$string['justnow'] = '現在';
$string['lastanswered'] = '最新の回答';
$string['lastedited'] = '最新の編集';
$string['legacyfiles'] = '古いコースファイルの移行';
$string['legacyfilesactive'] = 'アクティブ';
$string['legacyfilesdone'] = '終了済み';
$string['like'] = 'いいね';
$string['likeAnswer'] = '有益';
$string['likeAnswerForbidden'] = '有益であるとマーク済み';
$string['likeCountAnswer'] = 'この回答を有益であると考える人';
$string['likeCountQuestion'] = 'この質問が興味深いと考える人';
$string['likeForbidden'] = 'あなたはこのコメントに「いいね」できません。';
$string['likeOwnComment'] = '自分のコメント';
$string['likeQuestion'] = '興味深い質問';
$string['likeQuestionForbidden'] = 'すでに有益であるとマーク済み';
$string['loading'] = '読み込み中!';
$string['markCorrect'] = '正しいとマークする';
$string['markSolved'] = '質問を閉じる';
$string['markUnsolved'] = '質問を再度開く';
$string['markasread'] = '既読にする';
$string['markasunread'] = '未読にする';
$string['markhidden'] = '隠す';
$string['maximumfilesize'] = '最大ファイルサイズ';
$string['maximumfilesize_help'] = 'ユーザーによってアップロードされたファイルは、このサイズまで可能です。';
$string['me'] = '私';
$string['messageforwardform'] = '受信者へのメッセージ';
$string['messageprovider:forwardedquestion'] = '質問があなたに転送されたとき';
$string['messageprovider:newanswer'] = 'あなたが購読している質問に回答された場合';
$string['messageprovider:newquestion'] = '新しい質問に回答された場合';
$string['messageprovider:newreport'] = 'コメントが報告された場合';
$string['min0Chars'] = '中身のない質問やコメントは無効です。';
$string['minute'] = '分';
$string['minutes'] = '分';
$string['missingAnnotation'] = '該当するアノテーションが見つかりませんでした!';
$string['modifiedby'] = 'by';
$string['modulename'] = 'PDFアノテーション';
$string['modulename_help'] = 'このツールではPDFドキュメント上に共同マークアップを追加できます。ユーザはPDFの特定部分にアノテーションを追加して他のユーザと議論できます。';
$string['modulename_link'] = 'mod/pdfannotator/view';
$string['modulenameplural'] = 'PDFアノテーション';
$string['month'] = '月';
$string['months'] = '月';
$string['myanswers'] = '私の回答';
$string['mypost'] = '私の投稿';
$string['myprivate'] = '個人的なメモ';
$string['myprotectedanswers'] = '非公開の回答';
$string['myprotectedquestions'] = '非公開の質問';
$string['mypublicanswers'] = '私の公開回答';
$string['mypublicquestions'] = '私の公開質問';
$string['myquestion'] = '質問';
$string['myquestions'] = '私の質問';
$string['newanswerhtml'] = 'あなたが購読中の質問「 {$a->question} 」が  {$a->answeruser} さんによってコメントで回答されました:<br /><br />「 {$a->content} 」<br /><br />回答は<a href="{$a->urltoanswer}">ここ</a>で閲覧できます。';
$string['newanswertext'] = 'あなたが購読中の質問「 {$a->question} 」が  {$a->answeruser} さんによってコメントで回答されました:

「 {$a->content} 」

回答は次で閲覧できます: {$a->urltoanswer}';
$string['newquestionhtml'] = '新しい質問が {$a->answeruser} さんによって追加されました。コンテンツは以下のとおりです: <br /> <br />「 {$a->content} 」<br /><br />
質問は<a href="{$a->urltoanswer}">ここ</a>で閲覧できます。';
$string['newquestions'] = '最近の質問';
$string['newquestiontext'] = '新しい質問が {$a->answeruser} さんによって追加されました。コンテンツは以下のとおりです:

「 {$a->content} 」

質問は次で閲覧できます: {$a->urltoanswer}';
$string['nextPage'] = '次のページ';
$string['noCommentsupported'] = 'この種のアノテーションはコメントをサポートしません。';
$string['noanswers'] = '現在、このコースに回答はありません。';
$string['noanswerssubscribed'] = '現在、このコースの購読された質問に回答はありません。';
$string['nomyposts'] = 'あなたはまだこのコースで質問または回答を投稿していません。';
$string['noquestions'] = 'このページに質問はありません!';
$string['noquestions_overview'] = '現在、このコースに質問はありません。';
$string['noquestions_view'] = '現在、このドキュメントに質問はありません。';
$string['noquestionsclosed_overview'] = '現在、このコースにクローズ質問はありません。';
$string['noquestionsopen_overview'] = '現在、このコースにオープン質問はありません。';
$string['noreadreports'] = '現在、このコースに既読報告はありません。';
$string['noreports'] = '現在、このコースに報告はありません。';
$string['nosearchresults'] = '検索結果が見つかりませんでした。';
$string['notificationsubject:forwardedquestion'] = '{$a}で転送された質問';
$string['notificationsubject:newanswer'] = '{$a} の購読済み質問への新しい回答';
$string['notificationsubject:newquestion'] = '{$a} の新しい質問';
$string['notificationsubject:newreport'] = '{$a} でコメントが報告されました。';
$string['nounreadreports'] = '現在、このコースに未読報告はありません。';
$string['on'] = 'on';
$string['onlyDeleteOwnAnnotations'] = '別のユーザに属しています。';
$string['onlyDeleteUncommentedPosts'] = '他のユーザのコメントも同時に削除されます。';
$string['openquestions'] = '未解決';
$string['overview'] = '概要';
$string['overviewactioncolumn'] = '管理';
$string['ownpoststab'] = '私の投稿';
$string['ownpoststabicon'] = '私の投稿';
$string['ownpoststabicon_help'] = 'このページではこのコースであなたが投稿したコメントすべてを表示します。';
$string['page'] = 'ページ';
$string['pdfButton'] = 'ドキュメント';
$string['pdfannotator'] = 'ドキュメント';
$string['pdfannotator:addinstance'] = 'インスタンスを追加する';
$string['pdfannotator:administrateuserinput'] = 'コメントを管理する';
$string['pdfannotator:closeanyquestion'] = 'すべての質問をクローズする';
$string['pdfannotator:closequestion'] = '自分の質問をクローズする';
$string['pdfannotator:create'] = 'アノテーションおよびコメントを作成する';
$string['pdfannotator:deleteany'] = 'すべてのアノテーションおよびコメントを削除する';
$string['pdfannotator:deleteown'] = 'あなた自身のアノテーションおよびコメントを削除する';
$string['pdfannotator:edit'] = 'あなた自身のアノテーションおよびコメントを編集する';
$string['pdfannotator:editanypost'] = 'すべてのアノテーションおよびコメントを編集する';
$string['pdfannotator:getforwardedquestions'] = '転送された質問を受け取る';
$string['pdfannotator:hidecomments'] = '参加者のコメントを隠す';
$string['pdfannotator:markcorrectanswer'] = '回答を正しいとマークする';
$string['pdfannotator:printcomments'] = 'コメントをダウンロードする';
$string['pdfannotator:printdocument'] = 'ドキュメントをダウンロードする';
$string['pdfannotator:recievenewquestionnotifications'] = '新しい質問に関して通知を受信する';
$string['pdfannotator:report'] = '不適切なコメントをコースマネージャに報告する';
$string['pdfannotator:seehiddencomments'] = '非表示コメントを閲覧する';
$string['pdfannotator:subscribe'] = '質問を購読する';
$string['pdfannotator:usedrawing'] = 'ドローイングを使用する (PDFアノテータでオプションが無効にされている場合でも)';
$string['pdfannotator:usetextbox'] = 'テキストボックスを使用する (PDFアノテータでオプションが無効にされている場合でも)';
$string['pdfannotator:view'] = 'PDFアノテーションを表示する';
$string['pdfannotator:viewanswers'] = '購読質問への回答を表示する (概要ページ)';
$string['pdfannotator:viewposts'] = '自分のコメントを表示する (概要ページ)';
$string['pdfannotator:viewprotectedcomments'] = '非公開コメントを見る';
$string['pdfannotator:viewquestions'] = 'オープン質問を表示する (概要ページ)';
$string['pdfannotator:viewreports'] = '報告済みコメントを表示する (概要ページ)';
$string['pdfannotator:viewstatistics'] = '統計ページを表示する';
$string['pdfannotator:viewteacherstatistics'] = '統計ページで追加情報を閲覧する';
$string['pdfannotator:vote'] = '興味深い質問または有益な回答として投票する';
$string['pdfannotator:writeprivatecomments'] = '個人的なメモを作成する';
$string['pdfannotator:writeprotectedcomments'] = '非公開コメントを書く';
$string['pdfannotatorcolumn'] = 'ドキュメント';
$string['pdfannotatorcontent'] = 'ファイルおよびサブフォルダ';
$string['pdfannotatorname'] = 'PDFアノテーションツール';
$string['pdfannotatorpost'] = 'コメントと質問';
$string['pluginadministration'] = 'PDFアノテーション管理';
$string['pluginname'] = 'PDFアノテーション';
$string['point'] = 'ドキュメントにピンを追加してコメントを投稿します。';
$string['prevPage'] = '前のページ';
$string['print'] = 'ドキュメントをダウンロードする';
$string['printButton'] = 'ダウンロード';
$string['printviewtitle'] = 'コメント';
$string['printwithannotations'] = 'コメントをダウンロードする';
$string['privacy:metadata:core_files'] = 'PDFアノテータはアノテーションおよびディスカッションを根拠としてアップロードされたファイルを保存します。';
$string['privacy:metadata:pdfannotator_annotations'] = 'ユーザが作成したアノテーションに関する情報です。これにはアノテーションのタイプ (ハイライトまたはドローイング)、特定ファイル内でのポジションおよび作成時間を含みます。';
$string['privacy:metadata:pdfannotator_annotations:annotationid'] = '作成されたアノテーションのIDです。これは上に一覧表示されたデータを参照します。';
$string['privacy:metadata:pdfannotator_annotations:userid'] = 'このアノテーションを作成したユーザのIDです。';
$string['privacy:metadata:pdfannotator_comments'] = 'ユーザのコメントに関する情報です。これにはコンテンツ、コメントの作成時間および付随するアノテーションを含みます。';
$string['privacy:metadata:pdfannotator_comments:annotationid'] = '付随するアノテーションのIDです。';
$string['privacy:metadata:pdfannotator_comments:content'] = '文字のコメントです。';
$string['privacy:metadata:pdfannotator_comments:userid'] = 'コメント作成者のIDです。';
$string['privacy:metadata:pdfannotator_reports'] = 'ユーザは他のユーザのコメントを不適切として報告できます。これらの報告は保存されます。これには報告者、コンテンツ、報告時間および報告されたコメントのIDを含みます。';
$string['privacy:metadata:pdfannotator_reports:commentid'] = '報告済みコメントのIDです。';
$string['privacy:metadata:pdfannotator_reports:message'] = 'レポートのテキストコンテンツです。';
$string['privacy:metadata:pdfannotator_reports:userid'] = 'レポートの作成者です。';
$string['privacy:metadata:pdfannotator_subscriptions'] = '個別の質問/ディスカッションの購読に関する情報です。';
$string['privacy:metadata:pdfannotator_subscriptions:annotationid'] = '購読された質問/ディスカッションのIDです。';
$string['privacy:metadata:pdfannotator_subscriptions:userid'] = 'この購読のユーザのIDです。';
$string['privacy:metadata:pdfannotator_votes'] = '興味深いまたは有益としてマークされた質問およびコメントに関する情報です。';
$string['privacy:metadata:pdfannotator_votes:commentid'] = 'コメントのIDです。';
$string['privacy:metadata:pdfannotator_votes:userid'] = 'コメントを興味深いまたは有益であるとマークしたユーザのIDです。これはユーザによる同じコメントへの繰り返し投票を防ぐため保存されます。';
$string['private_comments'] = '個人的なメモ';
$string['private_comments_help'] = '自分にだけ見える。';
$string['protected_answers'] = '非公開回答';
$string['protected_comments'] = '非公開コメント';
$string['protected_comments_help'] = 'あなたと先生だけに見える。';
$string['protected_questions'] = '非公開質問';
$string['public_comments'] = '公開コメント';
$string['publicanswers'] = '公開回答';
$string['publicquestions'] = '公開質問';
$string['question'] = '質問';
$string['questionSolved'] = '質問がクローズされました。しかし、あなたはまだ新しいコメントを作成できます。';
$string['questionsimgtitle'] = 'このページの質問すべてを表示する';
$string['questionstab'] = '未解決の質問';
$string['questionstabicon'] = '未解決の質問';
$string['questionstabicon_help'] = 'このページではこのコースで回答された未解決の質問すべてが表示されます。あなたはこのコースのすべての質問または解決済み質問すべてを選択することもできます。';
$string['questionstitle'] = 'ページの質問';
$string['read'] = '読む';
$string['reason'] = '説明';
$string['recievenewquestionnotifications'] = '新しい質問に関して通知する';
$string['rectangle'] = 'ドキュメントに長方形を追加してコメントを書きます。';
$string['removeCorrect'] = '正しいとマークされたものを削除する';
$string['removehidden'] = '表示';
$string['report'] = 'レポート';
$string['reportaddedhtml'] = '{$a->reportinguser} が次のメッセージのコメントを報告しました: <br /><br />「 {$a->introduction} 」<br /><br />
これは<a href="{$a->urltoreport}">ウェブサイトで閲覧できます</a>。';
$string['reportaddedtext'] = '{$a->reportinguser} が次のメッセージのコメントを報告しました:

「 {$a->introduction} 」

これは次で閲覧できます: {$a->urltoreport}';
$string['reportedby'] = '報告者 / 報告日時';
$string['reportedcomment'] = '報告済みコメント';
$string['reports'] = '報告済みコメント';
$string['reportsendbutton'] = '送信する';
$string['reportstab'] = '報告済みコメント';
$string['reportstabicon'] = '報告済みコメント';
$string['reportstabicon_help'] = 'このページではこのコースで不適切であると報告されたコメントすべてを表示します。あなたは未読/既読のみ報告またはすべての報告を表示するよう選択できます。<br />このコースのマネージャは報告を既読にできます。';
$string['reportwassentoff'] = 'コメントが報告されました。';
$string['search'] = '検索';
$string['searchresults'] = '検索結果';
$string['second'] = '秒';
$string['seconds'] = '秒';
$string['seeabove'] = '&nbsp;';
$string['seenreports'] = '既読のみ';
$string['sendAnonymous'] = '匿名で投稿する';
$string['sendPrivate'] = '個人的なメモを追加';
$string['sendProtected'] = '非公開コメントの投稿';
$string['setting_alternative_name'] = '名称';
$string['setting_alternative_name_desc'] = 'PDFの代替名を提供してください。空白にした場合、PDF名が代表名として取得されます。';
$string['setting_alternative_name_help'] = '名称が半角20文字を超えた場合、残りの文字はアノテータ内部タブナビゲーション内で「...」に置換されます。';
$string['setting_anonymous'] = '匿名投稿を許可しますか?';
$string['setting_fileupload'] = 'PDFファイルを選択する';
$string['setting_fileupload_help'] = 'あなたは「保存」をクリックしてアノテータが作成されるまで選択されたファイルを編集できます。';
$string['setting_use_private_comments'] = '個人的なメモを許可';
$string['setting_use_private_comments_help'] = '参加者が個人的なメモを書けるようにする。このコメントは他の人には見えません。';
$string['setting_use_protected_comments'] = '非公開コメントを許可';
$string['setting_use_protected_comments_help'] = '参加者が非公開コメントを書けるようにする。このコメントは作成者とトレーナーのみが見ることができます。';
$string['setting_use_studentdrawing'] = 'ドローイング';
$string['setting_use_studentdrawing_help'] = 'ドローイングは匿名であり、コメントも報告もできないことにご注意ください。';
$string['setting_use_studenttextbox'] = 'テキストボックス';
$string['setting_use_studenttextbox_help'] = 'テキストボックスアノテーションは匿名ではないため、コメントおよび報告できないことに留意してください。';
$string['setting_useprint'] = '保存および印刷';
$string['setting_useprint_comments'] = 'コメントの保存と印刷';
$string['setting_useprint_comments_help'] = '参加者が注釈やコメントを保存し、印刷できるようにします。';
$string['setting_useprint_document'] = 'PDFドキュメントの保存と印刷';
$string['setting_useprint_document_help'] = '参加者がpdfドキュメントを保存・印刷できるようにします。';
$string['setting_useprint_help'] = 'ドローイングは匿名ではないため、コメントおよび報告できないことに留意してください。';
$string['setting_usevotes'] = '投票/いいね';
$string['setting_usevotes_help'] = 'このオプションを有効にした場合、ユーザは自分以外の投稿に「いいね/投票」できます。';
$string['show'] = '表示';
$string['showAnnotations'] = 'アノテーションを表示する';
$string['showless'] = '少なく表示する';
$string['showmore'] = 'さらに表示する';
$string['slotdatetimelabel'] = '日付および時間';
$string['startDiscussion'] = 'ディスカッションを開始する';
$string['statistic'] = '統計';
$string['strftimedatetime'] = '%Y/%m/%d (%a) %H:%M';
$string['strikeout'] = 'テキストに取り消し線を引いてコメントを追加します。';
$string['studentdrawingforbidden'] = 'このアノテータはあなたのユーザロールではドローイングをサポートしません。';
$string['studenttextboxforbidden'] = 'このアノテータはあなたのユーザロールではテキストボックスをサポートしません。';
$string['subscribe'] = 'このアノテーションを購読する';
$string['subscribeQuestion'] = '購読';
$string['subscribed'] = '購読済み';
$string['subscribedanswers'] = '→ 私の購読済み質問';
$string['subtitleforreportcommentform'] = 'コースマネージャへのあなたのメッセージ';
$string['successfullyEdited'] = '変更が保存されました。';
$string['successfullyHidden'] = 'このコメントは参加者には非表示として表示されます。';
$string['successfullyRedisplayed'] = 'コメントが参加者に再度表示されます。';
$string['successfullySubscribed'] = '質問を購読しました。';
$string['successfullyUnsubscribed'] = 'あなたの購読がキャンセルされました。';
$string['successfullyUnsubscribedPlural'] = 'あなたの購読がキャンセルされました。 {$a} 件すべての質問の回答がこのテーブルから削除されました。';
$string['successfullyUnsubscribedSingular'] = 'あなたの質問の購読がキャンセルされました。このテーブルから回答のみ削除されました。';
$string['successfullyUnsubscribedTwo'] = 'あなたの購読がキャンセルされました。このテーブルから質問および回答の両方が削除されました。';
$string['successfullymarkedasread'] = '報告が既読マークされました。';
$string['successfullymarkedasreadandnolongerdisplayed'] = '報告が既読マークされてテーブルから削除されました。';
$string['successfullymarkedasunread'] = '報告が未読マークされました。';
$string['successfullymarkedasunreadandnolongerdisplayed'] = '報告が未読マークされてテーブルから削除されました。';
$string['sumPages'] = 'ページ数';
$string['text'] = 'ドキュメントにテキストを追加します。';
$string['titleforreportcommentform'] = 'コメントを報告する';
$string['toreport'] = 'レポート';
$string['unseenreports'] = '未読のみ';
$string['unsolvedquestionstitle'] = '未解決の質問';
$string['unsolvedquestionstitle_help'] = 'このコースの未解決の質問すべてが一覧表示されます。';
$string['unsubscribe'] = 'このアノテーションを購読解除する';
$string['unsubscribeQuestion'] = '購読解除';
$string['unsubscribe_notification'] = '通知を解除するには<a href="{$a}">ここ</a>をクリックしてください。';
$string['unsubscribingDidNotWork'] = '購読をキャンセルできませんでした。';
$string['use_private_comments'] = '参加者に個人的なメモを許可しますか？';
$string['use_protected_comments'] = '参加者に非公開コメントを許可しますか？';
$string['use_studentdrawing'] = '参加者のドローイングを有効にしますか?';
$string['use_studenttextbox'] = '参加者のテキストボックスツールを有効にしますか?';
$string['useprint'] = '参加者がPDFにアクセスできるようにしますか?';
$string['useprint_comments'] = '参加者がPDFにアクセスしてコメントできるようにしますか?';
$string['useprint_document'] = '参加者がPDFにアクセスできるようにしますか?';
$string['usevotes'] = 'ユーザによるコメントへの「いいね」を許可します。';
$string['view'] = 'ドキュメント';
$string['votes'] = 'いいね';
$string['voteshelpicon'] = 'いいね';
$string['voteshelpicon_help'] = 'このカラムは他の何人が質問に興味を持ったか示します。';
$string['voteshelpicontwo'] = 'いいね';
$string['voteshelpicontwo_help'] = 'このカラムはあなたの投稿が何回「いいね」されたか示します。';
$string['week'] = '週';
$string['weeks'] = '週';
$string['year'] = '年';
$string['years'] = '年';
$string['yesButton'] = 'Yes';
$string['zoom'] = 'ズーム';
$string['zoomin'] = 'ズームイン';
$string['zoomout'] = 'ズームアウト';
