<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_deepseek', language 'ja', version '5.1'.
 *
 * @package     aiprovider_deepseek
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:explain_text:endpoint'] = 'APIエンドポイント';
$string['action:explain_text:model'] = 'テキスト説明モデル';
$string['action:explain_text:model_help'] = '提供されたテキストを説明するモデルです。';
$string['action:explain_text:systeminstruction'] = 'システムインストラクション';
$string['action:explain_text:systeminstruction_help'] = 'このインストラクションはユーザのプロンプトと共にAIモデルに送信されます。本当に必要な場合を除き、このインストラクションの編集は推奨されません。';
$string['action:generate_text:endpoint'] = 'APIエンドポイント';
$string['action:generate_text:model'] = 'AIモデル';
$string['action:generate_text:model_help'] = 'テキストレスポンスを生成するために使用されたモデルです。';
$string['action:generate_text:systeminstruction'] = 'システムインストラクション';
$string['action:generate_text:systeminstruction_help'] = 'このインストラクションはユーザのプロンプトと共にAIモデルに送信されます。本当に必要な場合を除き、インストラクション指示の編集は推奨されません。';
$string['action:summarise_text:endpoint'] = 'APIエンドポイント';
$string['action:summarise_text:model'] = 'AIモデル';
$string['action:summarise_text:model_help'] = '提供されたテキストを要約するために使用されたモデルです。';
$string['action:summarise_text:systeminstruction'] = 'システムインストラクション';
$string['action:summarise_text:systeminstruction_help'] = 'このインストラクションはユーザのプロンプトと共にAIモデルに送信されます。本当に必要な場合を除き、このインストラクションの編集は推奨されません。';
$string['apikey'] = 'DeepSeek APIキー';
$string['apikey_help'] = 'あなたの<a href="https://platform.deepseek.com/api_keys" target="_blank">DeepSeek APIキー</a>でキーを取得してください。';
$string['custom_model_name'] = 'カスタムモデル名';
$string['extraparams'] = '追加パラメータ';
$string['extraparams_help'] = '追加パラメータはここで設定できます。私たちはJSON形式をサポートしています。例えば次のようになります。
<pre>
{
    "temperature": 0.5,
    "max_tokens": 100
}
</pre>';
$string['invalidjson'] = '無効なJSON文字列です。';
$string['pluginname'] = 'DeepSeek APIプロバイダ';
$string['privacy:metadata'] = 'DeepSeek APIプロバイダプラグインはいかなる個人データモ保存しません。';
$string['privacy:metadata:aiprovider_deepseek:externalpurpose'] = 'この情報はレスポンスを生成するためにDeepSeek APIに送信されます。あなたのDeepSeek アカウントの設定により、DeepSeek がこのデータを保存および保持する方法が変更される場合があります。このプラグインでユーザデータが明示的にDeepSeek に送信またはMoodle LMSに保存されることはありません。';
$string['privacy:metadata:aiprovider_deepseek:model'] = 'レスポンスを生成するために使用されたモデルです。';
$string['privacy:metadata:aiprovider_deepseek:prompttext'] = 'レスポンスを生成するために使用されたユーザが入力したテキストプロンプトです。';
$string['settings'] = '設定';
$string['settings_frequency_penalty'] = 'frequency_penalty';
$string['settings_frequency_penalty_help'] = '-2.0から2.0までの数値です。正の値はテキスト内の既存の出現頻度に基づいて新しいトークンにペナルティを課した上でモデルが同じ行をそのまま繰り返す可能性を低下させます。';
$string['settings_help'] = '以下の設定を調整してDeepSeekへのリクエスト送信方法をカスタマイズしてください。';
$string['settings_logprobs'] = 'logprobs';
$string['settings_logprobs_help'] = '出力トークンの対数確率を返すかどうかしていしてください。この設定が有効な場合、メッセージコンテンツで返されるそれぞれの出力トークンの対数確率を返します。';
$string['settings_logprobs_label'] = '有効';
$string['settings_max_tokens'] = 'max_tokens';
$string['settings_max_tokens_help'] = '1から8192までの整数です。チャット補完で生成可能なトークンの最大数です。入力トークンおよび生成トークンの合計長はモデルのコンテクスト長により制限されます。max_tokensが指定されていない場合、デフォルト値4096が使用されます。';
$string['settings_presence_penalty'] = 'presence_penalty';
$string['settings_presence_penalty_help'] = '-2.0から2.0までの数値です。正の値はこれまでテキストに現れたかどうかに基づいて新しいトークンにペナルティを課した上でモデルが新しいトピックについて会話する可能性を高めます。';
$string['settings_temperature'] = '温度';
$string['settings_temperature_help'] = 'サンプリング温度は0から2の範囲で設定してください。0.8のような高い値は出力をよりランダムにしますが、0.2のような低い値はより集中した決定論的な出力にします。通常私たちは両者ではなく、この値または「top_p」のいずれか一方の変更を推奨します。';
$string['settings_top_logprobs'] = 'top_logprobs';
$string['settings_top_logprobs_help'] = '0から20までの整数でそれぞれのトークン位置で返す可能性が最も高いトークン数を指定してください。それぞれのトークンには対応する対数確率が関連付けられます。このパラメータを使用する場合、logprobsを有効にする必要があります。';
$string['settings_top_p'] = 'top_p';
$string['settings_top_p_help'] = '温度によるサンプリングの代替手法として核サンプリングと呼ばれる手法があります。この手法ではモデルは確率質量の上位top_pにあるトークンの結果を考慮します。そのため、0.1とは確率質量の上位10%を構成するトークンのみが考慮されることを意味します。通常私たちは両者ではなく、この値または温度のいずれか一方の変更を推奨します。';
