<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_dataprivacy', language 'mn', version '5.1'.
 *
 * @package     tool_dataprivacy
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitiesandresources'] = 'Үйл ажиллагаа ба нөөц';
$string['addcategory'] = 'Ангилал нэмэх';
$string['addnewdefaults'] = 'Өгөгдмөл шинэ модуль нэмэх';
$string['addpurpose'] = 'Зорилго нэмэх';
$string['addroleoverride'] = 'Нэмэлт үүрэг нэмэх';
$string['approve'] = 'Зөвшөөрөх';
$string['approvedrequestsubmitted'] = 'Таны хүсэлтийг илгээсэн бөгөөд удахгүй шийдвэрлэгдэх болно.';
$string['approverequest'] = 'Хүсэлтийг зөвшөөрөх';
$string['automaticdatadeletionapproval'] = 'Автоматаар өгөгдөл устгах хүсэлтийг зөвшөөрөх';
$string['automaticdatadeletionapproval_desc'] = 'Хэрэв идэвхжүүлсэн бол өгөгдөл устгах хүсэлтийг автоматаар зөвшөөрнө.<br/>Энэ тохиргоог идэвхжүүлсэн тохиолдолд автоматаар өгөгдөл устгах хүсэлтийг зөвхөн шинэ өгөгдөл устгах хүсэлтэд хэрэглэнэ гэдгийг анхаарна уу. Зөвшөөрөл хүлээгдэж буй өгөгдөл устгах хүсэлтийг нууцлалын ажилтан гараар баталгаажуулах шаардлагатай хэвээр байх болно.';
$string['automaticdataexportapproval'] = 'Автоматаар өгөгдөл экспортлох хүсэлтийг зөвшөөрөх';
$string['automaticdataexportapproval_desc'] = 'Идэвхжүүлсэн тохиолдолд өгөгдөл экспортлох хүсэлтийг автоматаар зөвшөөрнө.<br/>Энэ тохиргоог идэвхжүүлсэн тохиолдолд зөвхөн шинэ өгөгдөл экспортлох хүсэлтэд автомат зөвшөөрөл хэрэгжинэ гэдгийг анхаарна уу. Зөвшөөрөл хүлээгдэж буй өгөгдөл экспортлох хүсэлтийг нууцлалын ажилтан гараар баталгаажуулах шаардлагатай хэвээр байх болно.';
$string['automaticdeletionrequests'] = 'Автоматаар өгөгдөл устгах хүсэлт үүсгэх';
$string['automaticdeletionrequests_desc'] = 'Хэрэв идэвхжүүлсэн бол гараар устгасан хэрэглэгчийн бүртгэлд автоматаар өгөгдөл устгах хүсэлт үүснэ.';
$string['bulkapproverequests'] = 'Хүсэлтийг зөвшөөрөх';
$string['bulkdenyrequests'] = 'Хүсэлтийг татгалзах';
$string['cachedef_contextlevel'] = 'Хам сэдвийн түвшний зорилго ба ангилал';
$string['cachedef_purpose'] = 'Өгөгдлийн зорилго';
$string['cachedef_purpose_overrides'] = 'Өгөгдлийн нууцлалыг хамгаалах хэрэгслийн зорилгыг хүчингүй болгох';
$string['cancelrequest'] = 'Хүсэлтийг цуцлах';
$string['cancelrequestconfirmation'] = 'Та энэ өгөгдлийн хүсэлтийг үнэхээр цуцлахыг хүсэж байна уу?';
$string['cannotreset'] = 'Энэ хүсэлтийг дахин тохируулах боломжгүй байна. Зөвхөн татгалзсан хүсэлтийг дахин тохируулах боломжтой.';
$string['categories'] = 'Ангилал';
$string['categorieslist'] = 'Өгөгдлийн ангиллын жагсаалт';
$string['category'] = 'Ангилал';
$string['category_help'] = 'Өгөгдлийн бүртгэл дэх ангилал нь өгөгдлийн төрлийг тодорхойлдог. Шинэ ангиллыг нэмж болно, эсвэл Өвлөх сонгосон бол дээд хам түвшний өгөгдлийн ангиллыг хэрэглэнэ. Хам түвшин нь (өссөн байдлаар): Блок > Үйл ажиллагааны модулиуд > Хичээлүүд > Хичээлийн ангилал > Сайт.';
$string['categorycreated'] = 'Ангилал үүслээ';
$string['categorydefault'] = 'Өгөгдмөл ангилал';
$string['categorydefault_help'] = 'Өгөгдмөл ангилал нь аливаа шинэ жишээнүүдэд хэрэглэгдэх өгөгдлийн ангилал юм. Хэрэв Өвлөх сонгосон бол дээд хам түвшний өгөгдлийн ангиллыг хэрэглэнэ. Хам түвшин нь (өссөн байдлаар): Блок > Үйл ажиллагааны модулиуд > Хичээлүүд> Хичээлийн ангилал > Хэрэглэгч > Сайт.';
$string['categoryupdated'] = 'Ангиллыг шинэчиллээ';
$string['close'] = 'Хаах';
$string['compliant'] = 'Нийцтэй';
$string['confirmapproval'] = 'Та үнэхээр энэ өгөгдлийн хүсэлтийг зөвшөөрөхийг хүсэж байна уу?';
$string['confirmbulkapproval'] = 'Та үнэхээр сонгосон өгөгдлийн хүсэлтүүдээ бөөнөөр нь зөвшөөрөхийг хүсэж байна уу?';
$string['confirmbulkdenial'] = 'Та үнэхээр сонгосон өгөгдлийн хүсэлтүүдээ бөөнөөр нь татгалзахыг хүсэж байна уу?';
$string['confirmcompletion'] = 'Та үнэхээр энэ хэрэглэгчийн хүсэлтийг бүрэн дууссан гэж тэмдэглэхийг хүсэж байна уу?';
$string['confirmcontextdeletion'] = 'Та үнэхээр сонгосон хам сэдвүүдийг устгахыг баталгаажуулахыг хүсэж байна уу? Энэ нь мөн тус тусын дэд хам сэдвийн хэрэглэгчийн бүх өгөгдлийг устгах болно.';
$string['confirmdenial'] = 'Та үнэхээр энэ өгөгдлийн хүсэлтийг татгалзахыг хүсэж байна уу?';
$string['confirmrequestresubmit'] = 'Та {$a->username}-н одоогийн {$a->type} хүсэлтийг цуцалж, дахин илгээхдээ итгэлтэй байна уу?';
$string['contactdataprotectionofficer'] = 'Нууцлалын ажилтантай холбоо барих';
$string['contactdataprotectionofficer_desc'] = 'Идэвхжүүлсэн тохиолдолд хэрэглэгчид хувийн нууцлалын ажилтантай холбогдож, өөрийн профайл хуудасны холбоосоор дамжуулан өгөгдлийн хүсэлт гаргах боломжтой болно.';
$string['contactdpoviaprivacypolicy'] = 'Нууцлалын бодлогод заасны дагуу нууцлалын ажилтантай холбогдоно уу.';
$string['contextlevelname10'] = 'Сайт';
$string['contextlevelname30'] = 'Хэрэглэгчид';
$string['contextlevelname40'] = 'Хичээлийн ангилал';
$string['contextlevelname50'] = 'Хичээлүүд';
$string['contextlevelname70'] = 'Үйл ажиллагааны модулиуд';
$string['contextlevelname80'] = 'Блок';
$string['contextpurposecategorysaved'] = 'Зорилго ба ангиллыг хадгаллаа.';
$string['createcategory'] = 'Өгөгдлийн ангилал үүсгэх';
$string['createdeletedatarequest'] = 'Өгөгдөл устгах хүсэлт үүсгэх';
$string['createnewdatarequest'] = 'Шинэ өгөгдлийн хүсэлт үүсгэх';
$string['createpurpose'] = 'Өгөгдлийн зорилго үүсгэх';
$string['creationauto'] = 'Автоматаар';
$string['creationmanual'] = 'Гараар';
$string['datadeletion'] = 'Өгөгдөл устгалт';
$string['datadeletionpagehelp'] = 'Хадгалах хугацаа нь дууссан өгөгдлүүдийг энд жагсаав. Урьдчилан төлөвлөсөн "Хугацаа нь дууссан хам сэдвүүдийг устгах" даалгавраар устгах гэж буй өгөгдлүүдийг шалгаж хянана уу.';
$string['dataprivacy:downloadallrequests'] = 'Хүн бүрд экспортлогдсон өгөгдлийг татаж авах';
$string['dataprivacy:downloadownrequest'] = 'Өөрийн экспортлосон өгөгдлийг татаж авах';
$string['dataprivacy:makedatadeletionrequestsforchildren'] = 'Насанд хүрээгүй хүүхдийн өгөгдлийг устгах хүсэлт гаргах';
$string['dataprivacy:makedatarequestsforchildren'] = 'Насанд хүрээгүй хүүхдэд зориулсан өгөгдлийн хүсэлт гаргах';
$string['dataprivacy:managedataregistry'] = 'Өгөгдлийн регистр удирдах';
$string['dataprivacy:managedatarequests'] = 'Өгөгдлийн хүсэлт удирдах';
$string['dataprivacy:requestdelete'] = 'Өөрийн өгөгдлийг устгах хүсэлт илгээх';
$string['dataprivacy:requestdeleteforotheruser'] = 'Өөр хэрэглэгчийн өмнөөс өгөгдөл устгах хүсэлт илгээх';
$string['dataregistry'] = 'Өгөгдлийн регистр';
$string['dataregistryinfo'] = 'Өгөгдлийн регистр нь сайтын бүх агуулгын ангилал (өгөгдлийн төрөл) болон зорилго (өгөгдөл боловсруулах шалтгаан) -ийг хэрэглэгч, хичээлээс эхлээд үйл ажиллагаа, блок хүртэл тохируулах боломжийг олгодог. Зорилго бүрийн хувьд хадгалах хугацааг тогтоож болно. Хадгалах хугацаа дууссаны дараа өгөгдлийг тэмдэглэж, устгахаар жагсааж админ баталгаажуулах хүртэл хүлээлгэдэг.';
$string['datarequestcreatedforuser'] = '{$a}-ийн өгөгдлийн хүсэлт үүсгэсэн';
$string['datarequestcreatedfromscheduledtask'] = 'Урьдчилан төлөвлөсөн ажлаас автоматаар үүсгэсэн (урьдчилан устгасан хэрэглэгч).';
$string['datarequestcreatedupondelete'] = 'Хэрэглэгч устгасны дараа автоматаар үүсгэсэн';
$string['datarequestemailsubject'] = 'Өгөгдлийн хүсэлт:{a}';
$string['datarequests'] = 'Өгөгдлийн хүсэлт';
$string['dataretentionexplanation'] = 'Энэ тойм нь хэрэглэгчийн өгөгдлийг хадгалах үндсэн ангилал, зорилгыг харуулж байна. Зарим хэсгүүд энд жагсаагдсанаас илүү тодорхой ангилал, зорилготой байж болно.';
$string['dataretentionsummary'] = 'Өгөгдөл хадгалалтын тойм';
$string['datecomment'] = '[{$a->date}]:
 {$a->comment}';
$string['daterequested'] = 'Хүсэлт илгээсэн огноо';
$string['daterequesteddetail'] = 'Хүсэлт илгээсэн огноо:';
$string['defaultexpired'] = 'Бүх хэрэглэгчдэд зориулсан өгөгдөл';
$string['defaultexpiredexcept'] = 'Дараах үүрэг бүхий хэрэглэгчдээс бусад бүх хэрэглэгчдэд зориулсан өгөгдөл:<br>
{$a->unexpired}';
$string['defaultsinfo'] = 'Өгөгдмөл ангилал, зорилго нь утгыг нь тодорхойлоогүй байгаа бүх шинэ болон одоо байгаа загваруудад автоматаар оноогдоно.';
$string['defaultssaved'] = 'Өгөгдмөл утгыг хадгалсан';
$string['defaultswarninginfo'] = 'Анхааруулга: Эдгээр өгөгдмөл тохиргоог өөрчлөх нь одоо байгаа загваруудыг хадгалах хугацаанд нөлөөлж болзошгүй.';
$string['defaultunexpired'] = 'Зөвхөн дараах үүргүүдийн аль нэгийг эзэмшдэг хэрэглэгчдэд зориулсан өгөгдөл:<br>
{$a->expired}';
$string['defaultunexpiredwithexceptions'] = 'Дараах үүргүүдийн аль нэгийг нь давхар гүйцэтгэдэггүй:<br>
{$a->unexpired}

Зөвхөн дараах үүргүүдийн аль нэгийг эзэмшдэг хэрэглэгчдэд зориулсан өгөгдөл:<br>
{$a->expired}';
$string['deletecategory'] = 'Ангилал устгах';
$string['deletecategorytext'] = '\'{$a}\' ангиллыг устгахдаа итгэлтэй байна уу?';
$string['deletedefaults'] = 'Өгөгдмөлийг устгах: {a}';
$string['deletedefaultsconfirmation'] = '{$a} модулийн өгөгдмөл ангилал ба зорилгыг устгахдаа итгэлтэй байна уу?';
$string['deleteexistingdeleteduserstask'] = 'Өмнө устгасан хэрэглэгчийн өгөгдлийг устгах хүсэлт үүсгэх';
$string['deleteexpiredcontextstask'] = 'Хугацаа дууссан агуулгыг устгах';
$string['deleteexpireddatarequeststask'] = 'Хугацаа нь дууссан өгөгдлийн хүсэлтийн экспорт файлуудыг устгана уу';
$string['deletemyaccount'] = 'Өөрийн бүртгэлийг устгах';
$string['deletepurpose'] = 'Зорилго устгах';
$string['deletepurposetext'] = 'Та \'{$a}\' зорилгыг устгахдаа итгэлтэй байна уу?';
$string['deny'] = 'Татгалзах';
$string['denyrequest'] = 'Хүсэлтийг татгалзах';
$string['deprecated'] = 'Хүчингүй болсон';
$string['deprecatedexplanation'] = 'Энэ нэмэлт хэрэгсэл нь нууцлалын интерфэйсүүдийн аль нэгнийх нь хуучин хувилбарыг ашиглаж байгаа тул шинэчлэх шаардлагатай.';
$string['download'] = 'Татаж авах';
$string['downloadexpireduser'] = 'Татаж авах хугацаа дууссан. Хэрэв та хувийн мэдээллээ экспортлохыг хүсвэл шинэ хүсэлт гаргана уу.';
$string['dporolemapping'] = 'Нууцлалын ажилтны үүргийн зураглал';
$string['dporolemapping_desc'] = 'Нууцлалын ажилтан өгөгдлийн хүсэлтийг удирдах боломжтой.  tool/dataprivacy:managedatarequests чадварыг нууцлалын ажилтны үүргийн зураглалын сонголтоор жагсаахыг зөвшөөрөх ёстой.';
$string['duplicaterole'] = 'Үүрэг аль хэдийн тодорхойлогдсон';
$string['editcategories'] = 'Ангиллуудыг засах';
$string['editcategory'] = 'Ангилал засах';
$string['editdefaults'] = 'Өгөгдмөл утгыг засах: {$a}';
$string['editmoduledefaults'] = 'Модулийн өгөгдмөл тохиргоог засах';
$string['editpurpose'] = 'Зорилго засах';
$string['editpurposes'] = 'Зорилгуудыг засах';
$string['effectiveretentionperiodcourse'] = '{$a} (хичээл дуусах өдрөөс хойш)';
$string['effectiveretentionperioduser'] = '{$a} (хэрэглэгч сайт руу хамгийн сүүлд нэвтэрснээс хойш)';
$string['emailsalutation'] = 'Эрхэм хүндэт {$a},';
$string['errorcannotrequestdeleteforother'] = 'Танд энэ хэрэглэгчийн өмнөөс устгах хүсэлт гаргах зөвшөөрөл байхгүй байна.';
$string['errorcannotrequestdeleteforself'] = 'Танд өөрөө устгах хүсэлт гаргах зөвшөөрөл байхгүй байна.';
$string['errorcannotrequestexportforself'] = 'Танд өөрөө экспорт хийх хүсэлт гаргах зөвшөөрөл байхгүй байна.';
$string['errorcontactdpodisabled'] = 'Нууцлалын ажилтантай холбогдох сонголтыг идэвхгүй болгосон.';
$string['errorcontexthasunexpiredchildren'] = '"{$a}" хам сэдэв хугацаа нь дуусаагүй дэд хам сэдвүүдтэй байна. Устгахаар тэмдэглэсэн хам сэдэв байхгүй байна.';
$string['errorinvalidrequestcomments'] = 'Тайлбарын талбар нь зөвхөн энгийн текст агуулж болно.';
$string['errorinvalidrequestcreationmethod'] = 'Хүсэлт үүсгэх арга буруу байна!';
$string['errorinvalidrequeststatus'] = 'Хүсэлтийн төлөв буруу байна!';
$string['errorinvalidrequesttype'] = 'Хүсэлтийн төрөл буруу байна!';
$string['errornocapabilitytorequestforothers'] = '{$a->requestedby} хэрэглэгч {$a->userid} хэрэглэгчийн өмнөөс хүсэлт гаргах боломжгүй.';
$string['errornoexpiredcontexts'] = 'Шийдвэрлэх ёстой хугацаа нь дууссан хам сэдэв байхгүй байна';
$string['errorrequestalreadyexists'] = 'Танд өмнө нээсэн хүсэлт байна.';
$string['errorrequestnotfound'] = 'Хүсэлт олдсонгүй';
$string['errorrequestnotwaitingforapproval'] = 'Шийдвэрлэгдээгүй хүсэлт алга байна. Энэ нь хүсэлт хараахан бэлэн болоогүй эсвэл аль хэдийн шийдвэрлэгдсэн гэсэн үг.';
$string['errorsendingmessagetodpo'] = '{$a} руу зурвас илгээх явцад алдаа гарлаа.';
$string['exceptionnotificationbody'] = '<p><b>{$a->fullmethodname}</b>-г дуудах үед онцгой тохиолдол гарлаа.<br>Энэ нь <b>{$a->component}</b>  нэмэлт хэрэгсэл өгөгдлийг боловсруулж дуусаагүй гэсэн үг юм. Дараах онцгой тохиолдлын мэдээлэл нь нэмэлт хэрэгсэл хөгжүүлэгч рүү дамжуулагдаж болно:</p><pre>{$a->message<br>

{$a->backtrace}</pre>';
$string['exceptionnotificationsubject'] = 'Нууцлалын мэдээллийг боловсруулах явцад онцгой тохиолдол гарлаа';
$string['expandplugin'] = 'Нэмэлт хэрэгслийг дэлгэх ба хураах';
$string['expandplugintype'] = 'Нэмэлт хэрэгслийн төрлийг дэлгэх ба хураах.';
$string['expiredretentionperiodtask'] = 'Хадгалах хугацаа дууссан';
$string['expiredrolewithretention'] = '{$a->retention} (Хугацаа дууссан)';
$string['expiry'] = 'Хугацаа дуусах';
$string['explanationtitle'] = 'Энэ хуудсанд ашигласан дүрст тэмдгүүд ба тэдгээрийн утга.';
$string['external'] = 'Нэмэлт';
$string['externalexplanation'] = 'Энэ сайтад нэмэлт хэрэгсэл суулгасан.';
$string['filteroption'] = '{$a->category}: {$a->name}';
$string['frontpagecourse'] = 'Сайтын нүүр хуудсан дахь хичээл';
$string['gdpr_art_6_1_a_description'] = 'Өгөгдлийн субъект нь өөрийн хувийн мэдээллийг нэг буюу хэд хэдэн тодорхой зорилгоор боловсруулахыг зөвшөөрсөн';
$string['gdpr_art_6_1_a_name'] = 'Зөвшөөрөл (GDPR-ийн 6.1(а) зүйл)';
$string['gdpr_art_6_1_b_description'] = 'Өгөгдлийн субьект нь оролцогч тал болох  эсвэл гэрээг байгуулахаас өмнө өгөгдлийн субьектийн хүсэлтийн дагуу арга хэмжээ авахын тулд гэрээний гүйцэтгэлд боловсруулалт хийх шаардлагатай';
$string['gdpr_art_6_1_b_name'] = 'Гэрээ (GDPR-н 6.1(b) зүйл)';
$string['gdpr_art_6_1_c_description'] = 'Хянагч нь субъект болохын хувьд хууль ёсны үүргийн нийцэлд боловсруулалт хийх шаардлагатай';
$string['gdpr_art_6_1_c_name'] = 'Хууль ёсны үүрэг (GDPR-ийн 6.1(c) зүйл)';
$string['gdpr_art_6_1_d_description'] = 'Өгөгдлийн субьект эсвэл өөр хувь хүний ашиг сонирхлыг хамгаалахын тулд боловсруулалт хийх шаардлагатай';
$string['gdpr_art_6_1_d_name'] = 'Ашиг сонирхол (GDPR-ийн 6.1(d) зүйл)';
$string['gdpr_art_6_1_e_description'] = 'Нийтийн ашиг сонирхлын үүднээс ажил гүйцэтгэх эсвэл хянагчдад олгосон албан ёсны эрх мэдлийг хэрэгжүүлэхэд боловсруулалт хийх шаардлагатай.';
$string['gdpr_art_6_1_e_name'] = 'Нийтийн үүрэг (GDPR-ийн 6.1(е) зүйл)';
$string['gdpr_art_6_1_f_description'] = 'Хувийн мэдээллийг хамгаалах шаардлагатай буюу ялангуяа өгөгдлийн субъект нь хүүхэд байх тохиолдолд өгөгдлийн субъектын ашиг сонирхол, үндсэн эрх, эрх чөлөөгөөр давж гарахаас бусад тохиолдолд хянагч эсвэл гуравдагч этгээдийн хууль ёсны ашиг сонирхолд боловсруулалт хийх шаардлагатай.';
$string['gdpr_art_6_1_f_name'] = 'Хууль ёсны ашиг сонирхол (GDPR-ийн 6.1(f) зүйл)';
$string['gdpr_art_9_2_a_description'] = 'Холбооны болон гишүүн улсын хуулиар GDPR-ийн 9 дүгээр зүйлийн 1 дэх хэсэгт дурдсан хоригийг өгөгдлийн субъект цуцалж болохгүй гэж зааснаас бусад тохиолдолд өгөгдлийн субъект нь эдгээр хувийн мэдээллийг нэг буюу хэд хэдэн тусгайлсан зорилгоор боловсруулахыг илэрхий зөвшөөрсөн.';
$string['gdpr_art_9_2_a_name'] = 'Ил тод зөвшөөрөл (GDPR-ийн 9.2(a) зүйл)';
$string['gdpr_art_9_2_b_description'] = 'Хөдөлмөр эрхлэлт, нийгмийн хамгаалал, нийгмийн хамгааллын хууль тогтоомжийн хүрээнд Холбооны болон гишүүн улсын хуулиар эсвэл өгөгдлийн субъектийн үндсэн эрх, ашиг сонирхлыг хамгаалах зохих баталгааг тусгасан гишүүн улсын хуулийн дагуу хамтын гэрээгээр зөвшөөрөгдсөн тохиолдолд хянагч эсвэл өгөгдлийн субъектийн үүргээ биелүүлэх, тодорхой эрхийг хэрэгжүүлэхэд боловсруулалт хийх шаардлагатай.';
$string['gdpr_art_9_2_b_name'] = 'Хөдөлмөр эрхлэлт, нийгмийн хамгаалал/хамгаалалтын хууль (GDPR-ийн 9.2(b) зүйл)';
$string['gdpr_art_9_2_c_description'] = 'Өгөгдлийн субъект нь бие махбодийн болон хууль зүйн хувьд зөвшөөрөл өгөх чадваргүй тохиолдолд өгөгдлийн субъект эсвэл өөр хувь хүний ашиг сонирхлыг хамгаалахын тулд боловсруулалт хийх шаардлагатай.';
$string['gdpr_art_9_2_c_name'] = 'Ашиг сонирхлыг хамгаалах (GDPR-ийн 9.2(c) зүйл)';
$string['gdpr_art_9_2_d_description'] = 'Боловсруулалт нь  улс төр, гүн ухаан, шашин шүтлэг, үйлдвэрчний эвлэлийн зорилготой сан, холбоо болон бусад ашгийн бус байгууллагын хууль ёсны үйл ажиллагааны явцад зохих хамгаалалттайгаар хийгддэг бөгөөд боловсруулалтыг зөвхөн тухайн байгууллагын гишүүд эсвэл хуучин гишүүдтэй холбоотой байх, эсвэл түүний зорилгын дагуу түүнтэй тогтмол харилцдаг хүмүүст хамаарах тохиолдолд хувийн мэдээллийг тухайн байгууллагаас гадуур өгөгдлийн субьектүүдийн зөвшөөрөлгүйгээр задруулахгүй байх нөхцөлтэйгээр хийдэг.';
$string['gdpr_art_9_2_d_name'] = 'Сан, холбоо эсвэл ашгийн төлөө бус бусад байгууллагын гишүүдтэй холбоотой хууль ёсны үйл ажиллагаа (GDPR-ийн 9.2(d))';
$string['gdpr_art_9_2_e_description'] = 'Боловсруулалт нь өгөгдлийн субъектийн олон нийтэд илэрхий ил болгосон хувийн мэдээлэлтэй холбоотой байдаг.';
$string['gdpr_art_9_2_e_name'] = 'Өгөгдлийн субъектийн нийтэд зарласан өгөгдөл (GDPR-ийн 9.2(е) зүйл)';
$string['gdpr_art_9_2_f_description'] = 'Хууль ёсны нэхэмжлэлийг гаргах, хэрэгжүүлэх, хамгаалахад эсвэл шүүх нь шүүх эрх мэдлийн хүрээндээ ажиллаж байх тохиолдолд боловсруулалт хийх шаардлагатай.';
$string['gdpr_art_9_2_f_name'] = 'Хууль ёсны нэхэмжлэл ба шүүхийн үйл ажиллагаа (GDPR-ийн 9.2(f) зүйл)';
$string['gdpr_art_9_2_g_description'] = 'Олон нийтийн ашиг сонирхлын үүднээс Холбооны эсвэл гишүүн улсын хууль тогтоомжийн үндсэн дээр боловсруулалт хийх шаардлагатай бөгөөд энэ нь зорилгодоо нийцсэн, мэдээлэл хамгаалах эрхийн мөн чанарыг хүндэтгэсэн, өгөгдлийн субьектийн үндсэн эрх, ашиг сонирхлыг хамгаалахад тохиромжтой, тодорхой арга хэмжээ авдаг байх ёстой';
$string['gdpr_art_9_2_g_name'] = 'Нийтийн ашиг сонирхол (GDPR-ийн 9.2(g) зүйл)';
$string['gdpr_art_9_2_h_description'] = 'Холбооны болон гишүүн улсын хууль тогтоомжийн үндсэн дээр эсвэл эрүүл мэндийн мэргэжилтэнтэй байгуулсан гэрээний дагуу урьдчилан сэргийлэх эсвэл мэргэжлийн эмчилгээ хийх, ажилтны хөдөлмөрийн чадавхийг үнэлэх, эмнэлгийн оношлогоо, эрүүл мэнд, нийгмийн халамж, эмчилгээ, нийгмийн халамжийн тогтолцоо, үйлчилгээний менежментэд боловсруулалт хийх шаардлагатай бөгөөд GDPR-ийн 9 дүгээр зүйлийн 3 дахь хэсэгт дурдсан нөхцөл, хамгаалалтыг харгалзан үзнэ.';
$string['gdpr_art_9_2_h_name'] = 'Эмчилгээний зорилго (GDPR-ийн 9.2(h) зүйл)';
$string['gdpr_art_9_2_i_description'] = 'Өгөгдлийн субъектийн эрх, эрх чөлөөг, ялангуяа мэргэжлийн нууцыг хамгаалахад тохиромжтой, тодорхой арга хэмжээг тусгасан Холбооны эсвэл гишүүн улсын хуулийн үндсэн дээр эрүүл мэндэд ноцтой аюул занал учруулахаас хамгаалах эсвэл эрүүл мэндийн тусламж үйлчилгээ, эм, эмнэлгийн хэрэгслийн чанар, аюулгүй байдлын өндөр стандартыг хангах зэрэг нийгмийн эрүүл мэндийн салбарт олон нийтийн ашиг сонирхлын үүднээс боловсруулалт хийх шаардлагатай.';
$string['gdpr_art_9_2_i_name'] = 'Нийгмийн эрүүл мэнд (GDPR-ийн 9.2(i) зүйл)';
$string['gdpr_art_9_2_j_description'] = 'Нийтийн ашиг сонирхлын үүднээс, шинжлэх ухаан эсвэл түүхийн судалгааны зорилгоор эсвэл статистикийн зорилгоор архивлах боловсруулалтыг Холбооны болон гишүүн улсын хууль тогтоомжид үндэслэсэн 89 дүгээр зүйлийн 1-д заасны дагуу хийх шаардлагатай. Энэ нь зорилгодоо нийцсэн байх ёстой бөгөөд мэдээлэл хамгаалах эрхийн мөн чанарыг хүндэтгэж, өгөгдлийн субъектийн үндсэн эрх, ашиг сонирхлыг хамгаалахад тохиромжтой, тодорхой арга хэмжээ авах шаардлагатай.';
$string['gdpr_art_9_2_j_name'] = 'Олон нийтийн ашиг сонирхол, эсвэл шинжлэх ухаан/түүх/статистик судалгаа (GDPR-ийн 9.2(j) зүйл)';
$string['hide'] = 'Бүгдийг хураах';
$string['httpwarning'] = 'Энэ сайтаас татаж авсан аливаа өгөгдлийг шифрлээгүй байж магадгүй. Системийн администратортойгоо холбогдож, энэ сайт дээр SSL суулгахыг хүснэ үү.';
$string['inherit'] = 'Удамших';
$string['lawfulbases'] = 'Хуулийн үндэслэл';
$string['lawfulbases_help'] = 'Хувийн мэдээллийг боловсруулах хуулийн үндэслэлүүдээс дор хаяж нэгийг сонгоно уу. Эдгээр хуулийн үндэслэлийн талаар дэлгэрэнгүй мэдээлэл авахыг хүсвэл <a href="https://gdpr-info.eu/art-6-gdpr/" target="_blank">GDPR 6.1-р зүйл</a>-ийг үзнэ үү.';
$string['markcomplete'] = 'Бүрэн гүйцэд гэж тэмдэглэх';
$string['markedcomplete'] = 'Таны хүсэлтийг нууцлалын ажилтан бүрэн гүйцэд гэж тэмдэглэсэн.';
$string['message'] = 'Зурвас';
$string['messagelabel'] = 'Зурвас:';
$string['messageprovider:contactdataprotectionofficer'] = 'Өгөгдлийн хүсэлт';
$string['messageprovider:datarequestprocessingresults'] = 'Өгөгдлийн хүсэлт боловсруулалтын үр дүн';
$string['messageprovider:notifyexceptions'] = 'Өгөгдлийн хүсэлтийн онцгой тохиолдлын мэдэгдлүүд';
$string['moduleinstancename'] = '{$a->instancename} ({$a->modulename})';
$string['mypersonaldatarequests'] = 'Миний өгөгдлийн хүсэлт';
$string['nameandparent'] = '{$a->parent} / {$a->name}';
$string['nameemail'] = '{$a->name} ({$a->email})';
$string['nchildren'] = '{$a} хүүхдүүд';
$string['newrequest'] = 'Шинэ хүсэлт';
$string['noactivitiestoload'] = 'Үйл ажиллагаа байхгүй байна';
$string['noassignedroles'] = 'Энэ хам сэдэвт үүрэг оноогоогүй байна';
$string['noblockstoload'] = 'Блок байхгүй байна';
$string['nocategories'] = 'Одоогоор ангилал байхгүй байна';
$string['nocoursestoload'] = 'Үйл ажиллагаа байхгүй байна';
$string['nodatarequests'] = 'Өгөгдлийн хүсэлт байхгүй байна';
$string['nodatarequestsmatchingfilter'] = 'Өгөгдсөн шүүлтүүрт тохирох өгөгдлийн хүсэлт байхгүй байна';
$string['noexpiredcontexts'] = 'Энэ хам сэдвийн түвшинд хадгалах хугацаа нь дууссан өгөгдөл байхгүй байна.';
$string['nopersonaldatarequests'] = 'Танд өгөгдлийн хүсэлт байхгүй байна';
$string['nopurposes'] = 'Одоогоор зорилго байхгүй байна';
$string['nosubjectaccessrequests'] = 'Танд ажиллах шаардлагатай өгөгдлийн хүсэлт байхгүй байна';
$string['nosystemdefaults'] = 'Сайтын зорилго, ангилал хараахан тодорхой болоогүй байна.';
$string['notset'] = 'Тохируулаагүй (өгөгдмөл утгыг ашиглана уу)';
$string['notyetexpired'] = '{$a} (хугацаа нь хараахан дуусаагүй)';
$string['overrideinstances'] = 'Тусгай утгууд бүхий хүсэлтүүдийг дахин тохируулах';
$string['pluginname'] = 'Өгөгдлийн нууцлал';
$string['pluginname_help'] = 'Өгөгдлийн нууцлал нэмэлт хэрэгсэл';
$string['pluginregistry'] = 'Нэмэлт хэрэгслийн нууцлалын бүртгэл';
$string['pluginregistrytitle'] = 'Нэмэлт хэрэгслийн нууцлалын зөвшөөрлийн бүртгэл';
$string['privacy'] = 'Нууцлал';
$string['privacy:metadata:preference:tool_dataprivacy_request-filters'] = 'Өгөгдлийн хүсэлтийн хуудсанд одоогоор ашиглаж буй шүүлтүүрүүд.';
$string['privacy:metadata:preference:tool_dataprivacy_request-perpage'] = 'Хэрэглэгч нэг хуудсанд харж болох өгөгдлийн хүсэлтийн тоо';
$string['privacy:metadata:purpose'] = 'Энэ сайтад зориулсан өгөгдлийн зорилгоос авсан мэдээлэл.';
$string['privacy:metadata:purpose:usermodified'] = 'Зорилгыг өөрчилсөн хэрэглэгчийн ID';
$string['privacy:metadata:request'] = 'Энэ сайтад зориулсан хувийн өгөгдлийн хүсэлтээс авсан мэдээлэл (сэдвийн хандалт ба устгах хүсэлт).';
$string['privacy:metadata:request:comments'] = 'Хүсэлтийг дагалдсан аливаа хэрэглэгчийн сэтгэгдэл.';
$string['privacy:metadata:request:dpocomment'] = 'Хүсэлттэй холбоотой сайтын нууцлалын ажилтны хийсэн аливаа тайлбар.';
$string['privacy:metadata:request:requestedby'] = 'Хэрэв өөр хэрэглэгчийн нэрийн өмнөөс хүсэлт гаргасан бол тухайн хэрэглэгчийн ID.';
$string['privacy:metadata:request:timecreated'] = 'Хэрэглэгч хэзээ хүсэлт гаргасныг харуулах цаг хугацаа.';
$string['privacy:metadata:request:userid'] = 'Хүсэлтэд хамаарах хэрэглэгчийн ID';
$string['privacyofficeronly'] = 'Зөвхөн нууцлалын ажилтан ({$a}) үүрэг авсан хэрэглэгчид энэ агуулгад хандах эрхтэй';
$string['privacyrequestexpiry'] = 'Өгөгдлийн хүсэлтийн хугацаа дууссан';
$string['privacyrequestexpiry_desc'] = 'Дуусахаас нь өмнө өгөгдлийн хүсэлтийг татаж авах боломжтойг илтгэх хугацаа. Хэрэв 0 гэж тохируулсан бол хугацааны хязгаарлалт байхгүй.';
$string['protected'] = 'Хамгаалагдсан';
$string['protectedlabel'] = 'Энэ өгөгдлийг хадгалах нь хэрэглэгчийн мартагдах хүсэлтээс илүү хууль эрх зүйн давуу талтай. Хадгалах хугацаа дууссаны дараа л энэ өгөгдөл устгагдах болно.';
$string['purpose'] = 'Зорилго';
$string['purpose_help'] = 'Зорилго нь өгөгдлийг боловсруулах шалтгааныг тодорхойлдог. Шинэ зорилго нэмж болно, эсвэл Удамших сонгосон бол дээд хам сэдвийн зорилгыг хэрэглэнэ. Хам сэдэв нь (багааас дээд хүртэл): Блокууд > Үйл ажиллагааны модулиуд > Хичээлүүд > Хичээлийн ангилал > Хэрэглэгч > Хуудас.';
$string['purposecreated'] = 'Зорилго үүслээ';
$string['purposedefault'] = 'Өгөгдмөл зорилго';
$string['purposedefault_help'] = 'Өгөгдмөл зорилго нь аливаа шинэ хүсэлтэд хэрэглэгдэх зорилго юм. Удамших сонгосон бол дээд хам сэдвийн зорилгыг хэрэглэнэ. Хам сэдэв нь (багааас дээд хүртэл): Блокууд > Үйл ажиллагааны модулиуд > Хичээлүүд > Хичээлийн ангилал > Хэрэглэгч > Хуудас.';
$string['purposeoverview'] = 'Зорилго нь хадгалсан өгөгдлийн зориулалтын ашиглалт, хадгалалтын бодлогыг тодорхойлдог. Энэ өгөгдлийг хадгалах үндэслэлийг мөн зорилгод тайлбарласан болно.';
$string['purposes'] = 'Зорилго';
$string['purposeslist'] = 'Өгөгдлийн зорилгын жагсаалт';
$string['purposeupdated'] = 'Зорилго шинэчлэгдлээ';
$string['replyto'] = 'Хариулах';
$string['requestactions'] = 'Үйлдлүүд';
$string['requestapproved'] = 'Хүсэлтийг зөвшөөрсөн';
$string['requestby'] = 'Хүсэлт гаргасан';
$string['requestbydetail'] = 'Хүсэлт гаргасан:';
$string['requestcomments'] = 'Тайлбар';
$string['requestcomments_help'] = 'Энэ хайрцаг нь өгөгдлийн хүсэлтийн талаар дэлгэрэнгүй мэдээллээ оруулах боломжийг танд олгоно.';
$string['requestcreation'] = 'Бүтээл';
$string['requestdenied'] = 'Хүсэлтийг зөвшөөрөөгүй';
$string['requestemailintro'] = 'Та өгөгдлийн хүсэлт хүлээн авлаа:';
$string['requestfor'] = 'Хэрэглэгч';
$string['requestmarkedcomplete'] = 'Хүсэлтийг бүрэн гүйцэд гэж тэмдэглэсэн';
$string['requestorigin'] = 'Сайт';
$string['requestsapproved'] = 'Хүсэлтүүдийг зөвшөөрсөн';
$string['requestsdenied'] = 'Хүсэлтүүдийг зөвшөөрөөгүй';
$string['requeststatus'] = 'Төлөв';
$string['requestsubmitted'] = 'Таны хүсэлтийг нууцлалын ажилтанд илгээсэн';
$string['requesttype'] = 'Төрөл';
$string['requesttype_help'] = 'Нууцлалын ажилтантай холбогдох шалтгааныг сонгоно уу. Бүх хувийн мэдээллийг устгаснаар та сайтад нэвтрэх боломжгүй болно гэдгийг анхаарна уу.';
$string['requesttypedelete'] = 'Миний хувийн мэдээллийг бүгдийг устга';
$string['requesttypedeleteshort'] = 'Устгах';
$string['requesttypeexport'] = 'Миний хувийн бүх мэдээллийг экспортлох';
$string['requesttypeexportshort'] = 'Экспортлох';
$string['requesttypeothers'] = 'Ерөнхий хүсэлт';
$string['requesttypeothersshort'] = 'Зурвас';
$string['requesttypeuser'] = '{$a->typename} ({$a->user})';
$string['requireallenddatesforuserdeletion'] = 'Дуусах огноогүй хичээлүүдийг идэвхтэй гэж үзэх';
$string['requireallenddatesforuserdeletion_desc'] = 'Хэрэглэгчийн хугацаа дуусахыг тооцоолохдоо хэд хэдэн хүчин зүйлийг харгалзан үзнэ.

* хэрэглэгчийн сүүлд нэвтэрсэн хугацааг хэрэглэгч хадгалах хугацаатай харьцуулсан; болон
* хэрэглэгч ямар нэг сургалтад идэвхтэй хамрагдаж байгаа эсэх.

Хэрэглэгчийг хичээлд идэвхтэй хамрагдаж байгаа эсэхийг шалгах үед тухайн хичээл нь дуусах огноогүй бол энэ тохиргоо нь тухайн хичээлийг идэвхтэй гэж үзэх эсэхийг тодорхойлохын тулд ашиглагдана.

Хэрэв хичээл дуусах огноогүй бөгөөд энэ тохиргоог идэвхжүүлсэн бол хэрэглэгчийг устгах боломжгүй.';
$string['requiresattention'] = 'Анхаарал хандуулах шаардлагатай.';
$string['requiresattentionexplanation'] = 'Энэ нэмэлт хэрэгсэл нь Moodle нууцлалын API-г хэрэгжүүлдэггүй. Хэрэв энэ нэмэлт хэрэгсэл нь ямар нэгэн хувийн мэдээлэл хадгалдаг бол Moodle-ийн нууцлалын системээр дамжуулан экспортлох эсвэл устгах боломжгүй.';
$string['resubmitrequest'] = '{$a->username} -д {$a->type} хүсэлт дахин илгээх';
$string['resubmitrequestasnew'] = 'Шинэ хүсэлт болгон дахин илгээх';
$string['resubmittedrequest'] = '{$a->username}-д одоо байгаа {$a->type} хүсэлтийг цуцалж, дахин илгээсэн.';
$string['resultdeleted'] = 'Та саяхан {$a} дахь бүртгэл болон хувийн мэдээллээ устгах хүсэлт тавьсан. Энэ үйл явц дууссан тул та цаашид нэвтрэх боломжгүй болно.';
$string['resultdownloadready'] = 'Таны саяхан ирүүлсэн {$a}-с хувийн мэдээллийн хуулбар авах хүсэлт биелэгдэж дараах холбоосоор татаж авах боломжтой боллоо.';
$string['retentionperiod'] = 'Хадгалах хугацаа';
$string['retentionperiod_help'] = 'Хадгалах хугацаа нь өгөгдлийг хадгалах хугацааг тодорхойлдог. Хадгалах хугацаа дууссаны дараа өгөгдлийг тэмдэглэж, устгахаар жагсаах бөгөөд администраторын баталгаажуулалтыг хүлээдэг.';
$string['retentionperiodnotdefined'] = 'Хадгалах хугацааг тодорхойлоогүй байна';
$string['retentionperiodzero'] = 'Хадгалах хугацаа байхгүй';
$string['reviewdata'] = 'Өгөгдлийг хянах';
$string['role'] = 'Үүрэг';
$string['role_help'] = 'Нэмэлтээр үүрэг оноох үүрэг';
$string['roleoverride'] = 'Нэмэлт үүрэг';
$string['roleoverrideoverview'] = 'Өгөгдмөл хадгалалтын бодлогыг хэрэглэгчийн тодорхой дүрд зориулан нэмэлт үүрэг оноож, илүү урт эсвэл богино хугацаанд хадгалах бодлогыг зааж өгөх боломжтой. Хэрэглэгч бүх үүргийн хугацаа дууссан үед л хугацаа нь дуусна.';
$string['roleoverrides'] = 'Нэмэлт үүрэг';
$string['selectbulkaction'] = 'Үйлдлийг олноор нь сонгоно уу.';
$string['selectdatarequests'] = 'Өгөгдлийн хүсэлтүүд сонгоно уу.';
$string['selectuserdatarequest'] = '{$a->username}-ийн {$a->requesttype} өгөгдлийн хүсэлтийг сонгох.';
$string['send'] = 'Илгээх';
$string['sensitivedatareasons'] = 'Хувийн нууц бүхий өгөгдөл боловсруулах шалтгаан';
$string['sensitivedatareasons_help'] = 'Энэ зорилготой холбоотой хувийн нууц мэдээллийг боловсруулахыг хориглох нэг буюу хэд хэдэн холбогдох шалтгааныг сонгоно уу. Дэлгэрэнгүй мэдээллийг <a href="https://gdpr-info.eu/art-9-gdpr/" target="_blank">GDPR 9.2 зүйл</a>-ээс харна уу.';
$string['setdefaults'] = 'Өгөгдмөл тохируулах';
$string['showdataretentionsummary'] = 'Өгөгдөл хадгалалтын хураангуйг харуулах';
$string['showdataretentionsummary_desc'] = 'Хэрэв идэвхжүүлсэн бол, өгөгдөл хадгалалтын хураангуйн холбоос хэрэглэгчийн профайл болон хуудасны хөлд харагдана.';
$string['statusapproved'] = 'Зөвшөөрөгдсөн';
$string['statusawaitingapproval'] = 'Зөвшөөрөл хүлээж буй';
$string['statuscancelled'] = 'Татгалзсан';
$string['statuscomplete'] = 'Дууссан';
$string['statusdeleted'] = 'Устгасан';
$string['statusdetail'] = 'Төлөв:';
$string['statusexpired'] = 'Хугацаа дууссан';
$string['statuspending'] = 'Хүлээгдэж буй';
$string['statusprocessing'] = 'Боловсруулагдаж буй';
$string['statusready'] = 'Татаж авахад бэлэн';
$string['statusrejected'] = 'Татгалзсан';
$string['subjectscope'] = 'Сэдвийн хамрах хүрээ';
$string['subjectscope_help'] = 'Сэдвийн хамрах хүрээ нь энэ хам сэдэвт хуваарилагдаж болох үүргийг жагсаасан болно.';
$string['summary'] = 'Бүртгэлийн тохиргооны тойм';
$string['systemconfignotsetwarning'] = 'Сайтын зорилго, ангилал тодорхойлогдоогүй байна. Эдгээр нь тодорхойлогдоогүй тохиолдолд устгах хүсэлтийг боловсруулах үед бүх өгөгдөл устах болно.';
$string['tobedeleted'] = 'Устгагдах өгөгдөл';
$string['unexpiredrolewithretention'] = '{$a->retention} (Unexpired)';
$string['user'] = 'Хэрэглэгч';
$string['userlistexplanation'] = 'Энэ нэмэлт хэрэгсэл нь үндсэн үйлчилгээ үзүүлэгчтэй боловч нууцлалын функцийг бүрэн дэмжихийн тулд хэрэглэгчийн жагсаалтын үйлчилгээ үзүүлэгчийг хэрэгжүүлэх ёстой.';
$string['userlistnoncompliant'] = 'Хэрэглэгчийн жагсаалтын үйлчилгээ үзүүлэгч байхгүй байна';
$string['viewrequest'] = 'Хүсэлтийг харах';
$string['visible'] = 'Бүгдийг дэлгэх';
