<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_ldap', language 'mn', version '5.1'.
 *
 * @package     auth_ldap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_ldap_ad_create_req'] = 'Идэвхтэй лавлахад шинэ бүртгэл үүсгэх боломжгүй. Үүнийг ажиллуулах бүх шаардлагыг хангасан эсэхээ шалгана уу (LDAPS холболт, эрх бүхий хэрэглэгчийг холбох гэх мэт).';
$string['auth_ldap_attrcreators'] = 'Гишүүд нь атрибут үүсгэхийг зөвшөөрсөн бүлэг эсвэл хамрах хүрээний жагсаалт. Хэд хэдэн бүлгийг \';\' тэмдгээр тусгаарлана. Ихэвчлэн \'cn=teachers,ou=taff,o=myorg\' зэрэг байдаг.';
$string['auth_ldap_attrcreators_key'] = 'Атрибут үүсгэгч';
$string['auth_ldap_auth_user_create_key'] = 'Хэрэглэгчдийг гаднаас үүсгэх';
$string['auth_ldap_bind_dn'] = 'Хэрэглэгчийг хайхад холбох-хэрэглэгч ашиглах тохиолдолд энд зааж өгнө. \'cn=ldapuser,ou=public,o=org\' гэх мэт';
$string['auth_ldap_bind_dn_key'] = 'Таних нэр';
$string['auth_ldap_bind_pw'] = 'Холбох-хэрэглэгчийн нууц үг.';
$string['auth_ldap_bind_pw_key'] = 'Нууц үг';
$string['auth_ldap_bind_settings'] = 'Холбох тохиргоо';
$string['auth_ldap_changepasswordurl_key'] = 'Нууц үг солих URL хаяг';
$string['auth_ldap_contexts'] = 'Хэрэглэгч байрших хамрах хүрээний жагсаалт. Хамрах \';\' тэмдгээр тусгаарлана. Жишээ нь: \'ou=users,o=org; ou=бусад,o=org\'';
$string['auth_ldap_contexts_key'] = 'Хамрах хүрээ';
$string['auth_ldap_create_context'] = 'Хэрэглэгчийг цахим шуудангийн баталгаажуулалтаар үүсгэхийг идэвхжүүлэх тохиолдолд хэрэглэгчийг үүсгэсэн хамрах хүрээг зааж өгнө. Аюулгүй байдлын асуудлаас урьдчилан сэргийлэх үүднээс уг хамрах хүрээ нь бусад хэрэглэгчээс ялгаатай байх ёстой. Уг хамрах хүрээг ldap_context-variable рүү нэмэх шаардлагагүй, Moodle энэ хамрах хүрээнээс хэрэглэгчийг автоматаар хайх болно.<br /><b>Тэмдэглэл!</b> Хэрэглэгч үүсгэхийн тулд auth/ldap/auth.php файлд user_create() аргыг өөрчлөх шаардлагатай.';
$string['auth_ldap_create_context_key'] = 'Шинэ хэрэглэгчдэд зориулсан хамрах хүрээ';
$string['auth_ldap_create_error'] = 'LDAP дээр хэрэглэгч үүсгэхэд алдаа гарлаа.';
$string['auth_ldap_expiration_desc'] = 'Хугацаа дууссан нууц үг шалгахыг идэвхгүй болгоход \'{$a->no}\' эсвэл LDAP серверээс нууц үг дуусах хугацааг шууд уншихад \'{$a->ldapserver}\' сонгоно.';
$string['auth_ldap_expiration_key'] = 'Хугацаа дуусах';
$string['auth_ldap_expiration_warning_desc'] = 'Нууц үгийн хүчинтэй байх хугацаа дуусах тухай анхааруулгыг өгөхөөс өмнөх өдрийн тоо.';
$string['auth_ldap_expiration_warning_key'] = 'Хугацаа дуусах тухай анхааруулга';
$string['auth_ldap_expireattr_desc'] = 'Сонголт: Нууц үгийн дуусах хугацааг хадгалдаг LDAP атрибутыг хүчингүй болгоно.';
$string['auth_ldap_expireattr_key'] = 'Хугацаа дуусах атрибут';
$string['auth_ldap_graceattr_desc'] = 'Сонголт: Хугацаа дууссан нууц үгээр нэвтрэх атрибутыг хүчингүй болгоно.';
$string['auth_ldap_gracelogin_key'] = 'Хугацаа дууссан нууц үгээр нэвтрэх атрибут';
$string['auth_ldap_gracelogins_desc'] = 'LDAP дээр хугацаа дууссан нууц үгээр нэвтрэх сонголтыг идэвхжүүлнэ. Нууц үгийн хугацаа дууссаны дараа хэрэглэгч нэвтрэх эрхийн тоог 0 болтол нэвтрэх боломжтой. Уг тохиргоог идэвхжүүлснээр нууц үгийн хугацаа дууссан тохиолдолд хугацаа дууссан нууц үгээр нэвтрэх зурвасыг харуулна.';
$string['auth_ldap_gracelogins_key'] = 'Хугацаа дууссан нууц үгээр нэвтрэх';
$string['auth_ldap_groupecreators'] = 'Гишүүд нь бүлэг үүсгэхийг зөвшөөрсөн бүлэг эсвэл хамрах хүрээний жагсаалт. Бүлгийг \';\' тэмдгээр тусгаарлана. Ихэвчлэн \'cn=teachers,ou=taff,o=myorg\' зэрэг байна.';
$string['auth_ldap_groupecreators_key'] = 'Бүлэг үүсгэгч';
$string['auth_ldap_host_url'] = '\'ldap://ldap.myorg.com/\' эсвэл \'ldaps://ldap.myorg.com/\' зэргээр URL хэлбэрээр LDAP хостыг зааж өгнө . Серверийг \';\' тэмдгээр тусгаарлана.';
$string['auth_ldap_host_url_key'] = 'Хост URL хаяг';
$string['auth_ldap_ldap_encoding'] = 'LDAP серверийн ашигладаг кодчилол нь utf-8 байх магадлалтай. LDAP v2 сонгосон тохиолдолд идэвхтэй лавлах нь cp1252 эсвэл cp1250 зэрэг тохируулсан шифрлэлтийг ашигладаг.';
$string['auth_ldap_ldap_encoding_key'] = 'LDAP шифрлэл';
$string['auth_ldap_login_settings'] = 'Нэвтрэх тохиргоо';
$string['auth_ldap_memberattribute'] = 'Сонголт: Хэрэглэгч бүлэгт харьяалагдах үед хэрэглэгчийн гишүүний атрибутыг идэвхгүй болгоно. Ихэвчлэн \'гишүүн\' байна';
$string['auth_ldap_memberattribute_isdn'] = 'Гишүүн атрибутын утгын зохицуулалтыг хүчингүй болгоно';
$string['auth_ldap_memberattribute_isdn_key'] = 'Гишүүн атрибут нь dn ашигладаг';
$string['auth_ldap_memberattribute_key'] = 'Гишүүн атрибут';
$string['auth_ldap_no_mbstring'] = 'Идэвхтэй лавлах дээр хэрэглэгч үүсгэхэд mbstring өргөтгөл шаардлагатай.';
$string['auth_ldap_noconnect'] = 'LDAP-модуль серверт холбогдож чадахгүй байна: {$a}';
$string['auth_ldap_noconnect_all'] = 'LDAP-модуль дурын серверт холбогдож чадахгүй байна: {$a}';
$string['auth_ldap_noextension'] = 'PHP LDAP модуль байхгүй бололтой. Баталгаажуулалтын нэмэлт хэрэгслийг ашиглахыг хүсвэл түүнийг суулгаж, идэвхжүүлсэн эсэхийг шалгана уу.';
$string['auth_ldap_objectclass'] = 'Сонголт:  ldap_user_type дээр хэрэглэгчийг нэрлэх/хайхад ашигладаг objectClass классыг хүчингүй болгодог. Үүнийг өөрчлөх шаардлагагүй.';
$string['auth_ldap_objectclass_key'] = 'Объектын класс';
$string['auth_ldap_opt_deref'] = 'Хайлтын явцад тохирох нэрийг хэрхэн зохицуулахыг тодорхойлно. Дараах утгын аль нэгийг сонгоно: "Үгүй" (LDAP_DEREF_NEVER) эсвэл "Тийм" (LDAP_DEREF_ALWAYS)';
$string['auth_ldap_opt_deref_key'] = 'Ялгах тохирох нэр';
$string['auth_ldap_passtype'] = 'LDAP серверт шинэ эсвэл өөрчилсөн нууц үгийн форматыг тодорхойлно.';
$string['auth_ldap_passtype_key'] = 'Нууц үгийн формат';
$string['auth_ldap_passwdexpire_settings'] = 'LDAP нууц үгийн хугацаа дуусах тохиргоо';
$string['auth_ldap_preventpassindb'] = 'Moodle өгөгдлийн санд нууц үг хадгалагдахаас сэргийлж, тийм сонголтыг хийнэ.';
$string['auth_ldap_preventpassindb_key'] = 'Нууц үг хадгалагдахаас урьдчилан сэргийлэх';
$string['auth_ldap_rolecontext'] = '{$a->localname} хамрах хүрээ';
$string['auth_ldap_rolecontext_help'] = 'LDAP хамрах хүрээг <i>{$a->localname}</i> буулгалтад ашигладаг. Олон бүлгийг \';\' тэмдгээр тусгаарлана. Ихэвчлэн "cn={$a->shortname},ou=first-ou-with-role-groups,o=myorg; cn={$a->shortname},ou=second-ou-with-role-groups,o=myorg" зэрэг байна.';
$string['auth_ldap_search_sub'] = 'Дэд хамрах хүрээнээс хэрэглэгчийг хайх.';
$string['auth_ldap_search_sub_key'] = 'Дэд хамрах хүрээг хайх.';
$string['auth_ldap_server_settings'] = 'LDAP серверийн тохиргоо';
$string['auth_ldap_suspended_attribute'] = 'Сонголт: Энэ атрибутыг өгсөн тохиолдолд дотоодод үүсгэсэн хэрэглэгчийн бүртгэлийг идэвхжүүлэх/түдгэлзүүлэхэд ашиглана.';
$string['auth_ldap_suspended_attribute_key'] = 'Түдгэлзүүлсэн атрибут';
$string['auth_ldap_unsupportedusertype'] = 'auth: ldap user_create() нь сонгосон хэрэглэгчийн төрлийг дэмждэггүй: {$a}';
$string['auth_ldap_update_userinfo'] = 'LDAP серверээс хэрэглэгчийн мэдээллийг (нэр, овог, хаяг..)  Moodle рүү шинэчлэх. Шаардлагатай бол "Өгөгдлийн буулгалт" тохиргоог зааж өгнө.';
$string['auth_ldap_user_attribute'] = 'Сонголт: Хэрэглэгчийг нэрлэх/хайхад ашигласан атрибутыг хүчингүй болгоно. Ихэвчлэн \'cn\' байна.';
$string['auth_ldap_user_attribute_key'] = 'Хэрэглэгчийн атрибут';
$string['auth_ldap_user_exists'] = 'LDAP хэрэглэгчийн нэр хэдийн байна.';
$string['auth_ldap_user_settings'] = 'Хэрэглэгчийг хайх тохиргоо';
$string['auth_ldap_user_type'] = 'Хэрэглэгчийг LDAP серверт хэрхэн хадгалахыг сонгоно. Түүнчлэн уг тохиргоо нь нэвтрэх хугацаа хэрхэн дуусах, нууц үгийн хугацаа дуусан нэвтрэлт, хэрэглэгч үүсгэхийг хэрхэн ажиллахыг тодорхойлдог.';
$string['auth_ldap_user_type_key'] = 'Хэрэглэгчийн төрөл';
$string['auth_ldap_usertypeundefined'] = 'config.user_type тодорхойлогдоогүй эсвэл ldap_expirationtime2unix функц нь сонгосон төрлийг дэмжихгүй байна!';
$string['auth_ldap_usertypeundefined2'] = 'config.user_type тодорхойлогдоогүй эсвэл ldap_unixi2expirationtime функц нь сонгосон төрлийг дэмжихгүй байна!';
$string['auth_ldap_version'] = 'Таны серверийн ашиглаж байгаа LDAP протоколын хувилбар.';
$string['auth_ldap_version_key'] = 'Хувилбар';
$string['auth_ldapdescription'] = 'Энэ арга нь гадаад LDAP серверийн эсрэг нэвтрэлт таних боломжийг олгодог. Өгөгдсөн хэрэглэгчийн нэр, нууц үг хүчинтэй тохиолдолд Moodle өөрийн өгөгдлийн санд шинэ хэрэглэгчийн бичлэгийг үүсгэдэг. Энэ нэмэлт хэрэгсэл нь LDAP серверээс хэрэглэгчийн атрибутыг уншиж, Moodle системд шаардлагатай талбарыг урьдчилан бөглөнө. Дараагийн нэвтрэлтэд зөвхөн хэрэглэгчийн нэр, нууц үгийг шалгана.';
$string['auth_ldapextrafields'] = 'Эдгээр талбар нь сонголттой болно. Та энд тодорхойлсон <b>LDAP талбарын</b> мэдээллээр Moodle хэрэглэгчийн зарим талбарыг урьдчилан бөглөхөөр сонгож болно. <p>Эдгээр талбарыг хоосон орхивол LDAP серверээс юу ч дамжуулагдахгүй бөгөөд оронд нь Moodle системийн өгөгдмөл тохиргоог ашиглах болно.</p><p> Аль ч тохиолдолд хэрэглэгч нэвтэрсний дараа эдгээр бүх талбарыг засах боломжтой болно.</p>';
$string['auth_ldapnotinstalled'] = 'LDAP баталгаажуулалтыг ашиглах боломжгүй. PHP LDAP модулийг суулгаагүй байна.';
$string['auth_ntlmsso'] = 'NTLM SSO';
$string['auth_ntlmsso_enabled'] = 'NTLM домэйноор нэг удаагийн нэвтрэлтээр нэвтрэх оролдлогыг хийхийн тулд тийм гэж тохируулна. Энэ нь ажиллахын тулд сервер дээр нэмэлт тохиргоо хийх шаардлагатайг анхаарна уу. Дэлгэрэнгүй мэдээллийг <a href="https://docs.moodle.org/en/NTLM_authentication">NTLM баталгаажуулалт</a> баримт бичгээс харна уу.';
$string['auth_ntlmsso_enabled_key'] = 'Идэвхжүүлэх';
$string['auth_ntlmsso_ie_fastpath'] = 'NTLM SSO шуурхай замыг идэвхжүүлэх тохиргоог хийнэ (үйлчлүүлэгчийн хөтөч нь MS Internet Explorer бол тодорхой алхмыг алгасах).';
$string['auth_ntlmsso_ie_fastpath_attempt'] = 'Бүх хөтчөөр NTLM оролдлого хийх';
$string['auth_ntlmsso_ie_fastpath_key'] = 'MS IE шуурхай зам мөн эсэх?';
$string['auth_ntlmsso_ie_fastpath_yesattempt'] = 'Тийм, NTLM бусад хөтчөөр оролдлого хийх';
$string['auth_ntlmsso_ie_fastpath_yesform'] = 'Тийм, бусад бүх хөтөч стандарт нэвтрэх маягтыг ашигладаг';
$string['auth_ntlmsso_maybeinvalidformat'] = 'REMOTE_USER толгой хэсгээс хэрэглэгчийн нэрийг задлах боломжгүй. Тохируулсан формат зөв үү?';
$string['auth_ntlmsso_missing_username'] = 'Та алсын хэрэглэгчийн нэрийн форматад дор хаяж %username% гэж тодорхойлох хэрэгтэй';
$string['auth_ntlmsso_remoteuserformat'] = 'Та \'Баталгаажуулалтын төрөл\' дотроос \'NTLM\' гэж сонгосон тохиолдолд энд алсын хэрэглэгчийн нэрийн форматыг тодорхойлж болно. Үүнийг хоосон орхисон тохиолдолд DOMAIN\\username форматыг өгөгдмөл тохиргоогоор ашиглана. Домэйн нэрийг хаана харагдахыг зааж өгөхийн тулд сонголтоор <b>%domain%</b> орлуулагчийг, хэрэглэгчийн нэрийг хаана харагдахыг зааж өгөхийн тулд <b>%username%</b> орлуулагчийг ашиглаж болно. <br /><br />Өргөн хэрэглэгддэг зарим формат нь <tt>%domain%\\%username%</tt> (MS Windows өгөгдмөл), <tt>%domain%/%username%</tt>, <tt>%domain%+%username%</tt> and just <tt>%username%</tt> (домэйн хэсэг байхгүй тохиолдолд).';
$string['auth_ntlmsso_remoteuserformat_key'] = 'Алсын хэрэглэгчийн нэрийн формат';
$string['auth_ntlmsso_subnet'] = 'Тохируулсан тохиолдолд энэ нь зөвхөн энэ дэд сүлжээнд байгаа үйлчлүүлэгчтэй SSO нэвтрэлтийн оролдлого хийх болно. Формат: xxx.xxx.xxx.xxx/bitmask. Дэд сүлжээг \',\' (таслал) тэмдгээр тусгаарлана.';
$string['auth_ntlmsso_subnet_key'] = 'Дэд сүлжээ';
$string['auth_ntlmsso_type'] = 'Хэрэглэгчийг баталгаажуулахын тулд веб серверт тохируулсан баталгаажуулалтын арга (эргэлзэж байвал NTLM сонгоно)';
$string['auth_ntlmsso_type_key'] = 'Баталгаажуулалтын төрөл';
$string['cannotmaprole'] = '"{$a->rolename}" товч нэр нь хэт урт ба/буюу зураас агуулсан тул "{$a->rolename}" үүргийг харьцуулах боломжгүй. Үүнийг харьцуулахыг зөвшөөрөхийн тулд товч нэрийг хамгийн ихдээ {$a->charlimit} тэмдэгт болгон багасгаж, зураасыг арилгах шаардлагатай. <a href="{$a->link}">Үүргийг засварлах</a>';
$string['connectingldap'] = 'LDAP серверт холбогдож байна...';
$string['connectingldapsuccess'] = 'Таны LDAP сервертэй амжилттай холбогдлоо';
$string['creatingtemptable'] = '{$a} завсрын хүснэгт үүсгэж байна';
$string['diag_contextnotfound'] = '{$a} хамрах хүрээ байхгүй эсвэл DN холболтоор унших боломжгүй.';
$string['diag_emptycontext'] = 'Хоосон хамрах хүрээ олдсон.';
$string['diag_genericerror'] = '{$a->subject} унших {$a->code} LDAP алдаа: {$a->message}.';
$string['diag_rolegroupnotfound'] = '{$a->localname} үүрэгт зориулсан {$a->group} бүлэг байхгүй эсвэл DN холболтоор унших боломжгүй.';
$string['diag_toooldversion'] = 'Орчин үеийн LDAP сервер нь LDAPv2 протоколыг ашиглах магадлал бага. Буруу тохиргоо нь хэрэглэгчийн талбарын утгыг эвдэж болно. LDAP администратороосоо нягтална уу.';
$string['didntfindexpiretime'] = 'password_expire() нь хугацаа дуусах хугацааг олсонгүй.';
$string['didntgetusersfromldap'] = 'LDAP серверээс ямар ч хэрэглэгч аваагүй -- алдаа? -- гарах';
$string['gotcountrecordsfromldap'] = 'LDAP серверээс {$a} бичлэг авсан';
$string['invalidusererrors'] = 'Анхааруулга: {$a} хэрэглэгчийн бүртгэлийг үүсгэхийг алгассан.';
$string['invaliduserexception'] = 'Алдаа: Шинэ хэрэглэгчийн бүртгэлийг үүсгэх боломжгүй. Дэлгэрэнгүй болон шалтгаан:
{$a}
Энэ хэрэглэгчийг алгасаж байна.';
$string['ldapnotconfigured'] = 'Одоогоор LDAP хостын URL хаягийг тохируулаагүй байна';
$string['morethanoneuser'] = 'LDAP серверт нэгээс олон хэрэглэгчийн бичлэг олдсон. Зөвхөн эхнийхийг ашиглаж байна.';
$string['needbcmath'] = 'Идэвхтэй лавлахыг ашиглан хугацаа нь дууссан нууц үгийг шалгахад BCMath өргөтгөл шаардлагатай.';
$string['needmbstring'] = 'Идэвхтэй лавлах дахь нууц үгийг солиход mbstring өргөтгөл шаардлагатай';
$string['nodnforusername'] = 'user_update_password()-д алдаа гарлаа. {$a->username} хэрэглэгчид DN байхгүй';
$string['noemail'] = 'Танд цахим шуудан илгээхийг оролдсон боловч амжилтгүй боллоо!';
$string['notcalledfromserver'] = 'Веб серверээс дуудаж болохгүй!';
$string['noupdatestobedone'] = 'Шинэчлэлт хийх шаардлагагүй';
$string['nouserentriestoremove'] = 'Устгах хэрэглэгчийн бичлэг байхгүй';
$string['nouserentriestorevive'] = 'Сэргээх хэрэглэгчийн бичлэг байхгүй';
$string['nouserstobeadded'] = 'Нэмэх хэрэглэгчийн бичлэг байхгүй';
$string['ntlmsso_attempting'] = 'NTLM ашиглан нэг удаагийн нэвтрэлт хийхийг оролдож байна...';
$string['ntlmsso_failed'] = 'Автоматаар нэвтэрч чадсангүй, ердийн нэвтрэх хуудсаар хандана  уу...';
$string['ntlmsso_isdisabled'] = 'NTLM SSO идэвхгүй байна.';
$string['ntlmsso_unknowntype'] = 'Үл мэдэгдэх ntlmsso төрөл!';
$string['pagedresultsnotsupp'] = 'LDAP хуудасны илэрц дэмжигдээгүй (таны PHP хувилбарыг дэмждэггүй, Moodle системийг LDAP протоколын 2-р хувилбарыг ашиглахаар тохируулсан эсвэл Moodle нь LDAP сервертэй холбогдож хуудасны дэмжлэг байгаа эсэхийг шалгах боломжгүй байна.)';
$string['pagesize'] = 'Энэ утга нь таны LDAP серверийн илэрцийн тогтоосон хэмжээ хязгаараас бага байгаа эсэхийг шалгана (нэг хүсэлтэд буцаах боломжтой бичлэгийн хамгийн их тоо)';
$string['pagesize_key'] = 'Хуудасны хэмжээ';
$string['pluginname'] = 'LDAP сервер';
$string['pluginnotenabled'] = 'Нэмэлт хэрэгслийг идэвхжүүлээгүй байна!';
$string['privacy:metadata'] = 'LDAP серверийн баталгаажуулалтын нэмэлт хэрэгсэл нь хувийн ямар ч өгөгдлийг хадгалдаггүй.';
$string['renamingnotallowed'] = 'LDAP дахь хэрэглэгчийн нэрийг өөрчлөхийг зөвшөөрдөггүй';
$string['rootdseerror'] = 'Идэвхтэй лавлахад зориулсан rootDSE хүсэлтэд алдаа гарлаа';
$string['start_tls'] = 'TLS шифрлэлт бүхий ердийн LDAP үйлчилгээг (порт 389) ашиглах';
$string['start_tls_key'] = 'TLS ашиглах';
$string['syncroles'] = 'LDAP серверээс системийн үүргийг синхрончлох';
$string['synctask'] = 'LDAP хэрэглэгч үйлдлийг синхрончлох';
$string['systemrolemapping'] = 'Системийн үүргийн харьцуулах';
$string['updatepasserror'] = 'user_update_password()-д алдаа гарлаа. Алдааны код: {$a->errno}; Алдааны мөр: {$a->errstring}';
$string['updatepasserrorexpire'] = 'Нууц үг дуусах хугацааг унших үед user_update_password()-д алдаа гарлаа. Алдааны код: {$a->errno}; Алдааны мөр: {$a->errstring}';
$string['updatepasserrorexpiregrace'] = 'Дуусах хугацаа ба/буюу хугацаа дууссан нууц үгээр нэвтрэх эрхийг өөрчлөх үед user_update_password()-д алдаа гарлаа. Алдааны код: {$a->errno}; Алдааны мөр: {$a->errstring}';
$string['updateremfail'] = 'LDAP бичлэгийг шинэчлэхэд алдаа гарлаа. Алдааны код: {$a->errno}; Алдааны мөр: {$a->errstring}<br/>Түлхүүр ({$a->key}) - хуучин Moodle утга: \'{$a->ouvalue}\' шинэ утга: \'{$a->nuvalue}\'';
$string['updateremfailamb'] = '{$a->key} гэсэн тодорхойгүй талбар бүхий LDAP-г шинэчилж чадсангүй; хуучин moodle утга: \'{$a->ouvalue}\', шинэ утга: \'{$a->nuvalue}\'';
$string['updateusernotfound'] = 'Гаднаас шинэчлэх үед хэрэглэгч олдсонгүй. Дэлгэрэнгүй мэдээлэл: хайлтын суурь: \'{$a->userdn}\'; хайлтын шүүлтүүр: \'(objectClass=*)\'; хайлтын атрибут: {$a->attribs}';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() нь сонгосон хэрэглэгчийн төрлийг дэмждэггүй: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_disable() нь сонгосон хэрэглэгчийн төрлийг дэмждэггүй: {$a}';
$string['useracctctrlerror'] = '{$a}-н userAccountControl авахад алдаа гарлаа';
$string['userentriestoadd'] = 'Нэмэх хэрэглэгчийн бичлэг: {$a}';
$string['userentriestoremove'] = 'Устгах хэрэглэгчийн бичлэг: {$a}';
$string['userentriestorevive'] = 'Сэргээх хэрэглэгчийн бичлэг: {$a}';
$string['userentriestoupdate'] = 'Шинэчлэх хэрэглэгчийн бичлэг: {$a}';
$string['usernotfound'] = 'LDAP дээр хэрэглэгч олдсонгүй';
