<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'lt', version '5.1'.
 *
 * @package     role
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'Įtraukiamas naujas vaidmuo';
$string['addrole'] = 'Įtraukti naują vaidmenį';
$string['advancedoverride'] = 'Išplėstinis vaidmenų keitimas';
$string['ai:acceptpolicy'] = 'Priimti DI politiką';
$string['ai:fetchanyuserpolicystatus'] = 'Gauti naudotojų DI politikos patvirtinimą';
$string['ai:fetchpolicy'] = 'Gauti naudotojų DI politikos patvirtinimą';
$string['ai:viewaipolicyacceptancereport'] = 'Peržiūrėti DI politikos priėmimo ataskaitą';
$string['ai:viewaiusagereport'] = 'Peržiūrėti DI naudojimo ataskaitą';
$string['allow'] = 'Leisti';
$string['allowassign'] = 'Leisti vaidmenų priskyrimus';
$string['allowed'] = 'Leidžiama';
$string['allowoverride'] = 'Leisti vaidmenų keitimus';
$string['allowroletoassign'] = 'Leisti naudotojams, kurių vaidmuo {$a->fromrole}, priskirti vaidmenį {$a->targetrole}';
$string['allowroletooverride'] = 'Leisti naudotojams, kurių vaidmuo {$a->fromrole}, keisti vaidmenį {$a->targetrole}';
$string['allowroletoswitch'] = 'Leisti naudotojams, kurių vaidmuo {$a->fromrole}, perjungti vaidmenis į vaidmenį {$a->targetrole}';
$string['allowroletoview'] = 'Leisti naudotojams, kurių vaidmuo {$a->fromrole}, peržiūrėti vaidmenis kaip {$a->targetrole}';
$string['allowswitch'] = 'Leisti vaidmenų perjungimus';
$string['allowview'] = 'Leisti vaidmenų peržiūrą';
$string['allsiteusers'] = 'Visi svetainės naudotojai';
$string['analytics:listinsights'] = 'Įžvalgų sąrašas';
$string['analytics:listowninsights'] = 'Išvardyti savo įžvalgas';
$string['analytics:managemodels'] = 'Valdyti modelius';
$string['archetype'] = 'Vaidmens archetipas';
$string['archetype_help'] = 'Vaidmens archetipas nustato teises, kai nustatomos numatytosios vaidmens reikšmės. Jis taip pat nustato visas naujas vaidmens teises atnaujinant sistemą.';
$string['archetypecoursecreator'] = 'ARCHETYPE: kursų kūrėjas';
$string['archetypeeditingteacher'] = 'ARCHETYPE: dėstytojas (redagavimas)';
$string['archetypefrontpage'] = 'ARCHETIPAS: Autentifikuotas naudotojas svetainėje';
$string['archetypeguest'] = 'ARCHETYPE: Svečias';
$string['archetypemanager'] = 'ARCHETYPE: Tvarkytojas';
$string['archetypestudent'] = 'ARCHETYPE: Besimokantysis';
$string['archetypeteacher'] = 'ARCHETYPE: dėstytojas (be redagavimo)';
$string['archetypeuser'] = 'ARCHETYPE: autentifikuotas naudotojas';
$string['assignanotherrole'] = 'Priskirti kitą vaidmenį';
$string['assignedroles'] = 'Priskirti vaidmenys';
$string['assignerror'] = 'Įvyko klaida naudotojui {$a->user} priskiriant vaidmenį {$a->role}.';
$string['assignglobalroles'] = 'Priskirti sistemos vaidmenis';
$string['assignmentcontext'] = 'Priskyrimo kontekstas';
$string['assignmentoptions'] = 'Priskyrimo parinktys';
$string['assignrole'] = 'Priskirti vaidmenį';
$string['assignrolenameincontext'] = 'Priskirti {$a->context} vaidmenį {$a->role}';
$string['assignroles'] = 'Priskirti vaidmenis';
$string['assignroles_help'] = 'Priskirdami naudotojui vaidmenį kontekste, suteikiate jam to vaidmens teises dabartiniame kontekste ir visuose žemesnio lygio kontekstuose. Pvz., jei naudotojui suteikiamas kursų besimokančiojo vaidmuo, jis taip pat turės besimokančiojo vaidmenį visose šių kursų veiklose ir blokuose.';
$string['assignroles_link'] = 'admin/roles/assign';
$string['assignrolesin'] = 'Priskirti {$a} vaidmenis';
$string['assignrolesrelativetothisuser'] = 'Priskirti vaidmenis';
$string['backtoallroles'] = 'Grįžti į visų vaidmenų sąrašą';
$string['backup:anonymise'] = 'Kuriant atsarginę kopiją naudotojo duomenis padaryti anoniminiais';
$string['backup:backupactivity'] = 'Kurti atsarginę veiklų kopiją';
$string['backup:backupcourse'] = 'Kurti atsarginę kursų kopiją';
$string['backup:backupsection'] = 'Kurti atsarginę dalių kopiją';
$string['backup:backuptargetimport'] = 'Importavimui skirta atsarginė kopija';
$string['backup:configure'] = 'Konfigūruoti atsarginių kopijų kūrimo parinktis';
$string['backup:downloadfile'] = 'Atsisiųsti failus iš atsarginių kopijų sričių';
$string['backup:userinfo'] = 'Kurti atsarginę naudotojo duomenų kopiją';
$string['badges:awardbadge'] = 'Skirti naudotojui pasiekimą';
$string['badges:configurecriteria'] = 'Nustatyti / redaguoti kriterijus pasiekimui gauti';
$string['badges:configuredetails'] = 'Nustatyti / redaguoti pasiekimo informaciją';
$string['badges:configuremessages'] = 'Nustatyti pasiekimo pranešimus';
$string['badges:createbadge'] = 'Sukurti/dubliuoti pasiekimus';
$string['badges:deletebadge'] = 'Trinti pasiekimus';
$string['badges:earnbadge'] = 'Gauti pasiekimą';
$string['badges:manageglobalsettings'] = 'Valdyti pasiekimų globalius nustatymus';
$string['badges:manageownbadges'] = 'Peržiūrėti ir tvarkyti savo gautus pasiekimus';
$string['badges:revokebadge'] = 'Atšaukti pasiekimą iš naudotojo';
$string['badges:viewawarded'] = 'Peržiūrėkite naudotojus, kurie pelnė konkretų pasiekimą, bet negalėjo jo gauti';
$string['badges:viewbadges'] = 'Peržiūrėti galimus pasiekimus, jų negaunant';
$string['badges:viewotherbadges'] = 'Peržiūrėti viešus pasiekimus kitų naudotojų profiliuose';
$string['block:edit'] = 'Redaguoti bloko parametrus';
$string['block:view'] = 'Peržiūrėti bloką';
$string['blog:create'] = 'Kurti naujus tinklaraščio įrašus';
$string['blog:manageentries'] = 'Redaguoti ir tvarkyti įrašus';
$string['blog:manageexternal'] = 'Redaguoti ir tvarkyti išorinius tinklaraščius';
$string['blog:search'] = 'Ieškoti tinklaraščio įrašų';
$string['blog:view'] = 'Peržiūrėti tinklaraščio įrašus';
$string['blog:viewdrafts'] = 'Peržiūrėti tinklaraščio juodraščio įrašus';
$string['calendar:manageentries'] = 'Tvarkyti visus kalendoriaus įrašus';
$string['calendar:managegroupentries'] = 'Tvarkyti grupės kalendoriaus įrašus';
$string['calendar:manageownentries'] = 'Tvarkyti savo kalendoriaus įrašus';
$string['capabilities'] = 'Galimybės';
$string['capability'] = 'Galimybė';
$string['category:create'] = 'Kurti kategorijas';
$string['category:delete'] = 'Naikinti kategorijas';
$string['category:manage'] = 'Tvarkyti kategorijas';
$string['category:update'] = 'Naujinti kategorijas';
$string['category:viewcourselist'] = 'Peržiūrėti kursų kategoriją ir joje esančius kursus';
$string['category:viewhiddencategories'] = 'Matyti paslėptas kategorijas';
$string['category:visibility'] = 'Matyti paslėptas kategorijas';
$string['checkglobalpermissions'] = 'Tikrinti sistemos teises';
$string['checkpermissions'] = 'Tikrinti teises';
$string['checkpermissionsin'] = 'Tikrinti {$a} teises';
$string['checksystempermissionsfor'] = 'Tikrinti {$a->fullname} sistemos teises';
$string['checkuserspermissionshere'] = 'Tkrinti teises, kurias {$a->fullname} turi šiame {$a->contextlevel}';
$string['chooseroletoassign'] = 'Pasirinkite priskirtiną vaidmenį';
$string['cohort:assign'] = 'Įtraukti ir šalinti junginio narius';
$string['cohort:configurecustomfields'] = 'Konfigūruoti tinkintus junginio laukus';
$string['cohort:manage'] = 'Kurti, naikinti ir perkelti junginius';
$string['cohort:view'] = 'Peržiūrėti visus svetainės junginius';
$string['comment:delete'] = 'Naikinti komentarus';
$string['comment:post'] = 'Skelbti komentarus';
$string['comment:view'] = 'Žiūrėti komentarus';
$string['competency:competencygrade'] = 'Nustatyto kompetencijos reitingą';
$string['competency:competencymanage'] = 'Tvarkyti kompetencijų sistemas';
$string['competency:competencyview'] = 'Žiūrėti kompetencijų sistemas';
$string['competency:coursecompetencyconfigure'] = 'Konfigūruoti kurso kompetencijos nustatymus';
$string['competency:coursecompetencygradable'] = 'Gauti kompetencijos žymes';
$string['competency:coursecompetencymanage'] = 'Tvarkyti kursų kompetencijas';
$string['competency:coursecompetencyview'] = 'Peržiūrėti kursų kompetencijas';
$string['competency:evidencedelete'] = 'Naikinti įrodymus';
$string['competency:plancomment'] = 'Komentuoti mokymosi planą';
$string['competency:plancommentown'] = 'Komentuoti savo mokymosi planą';
$string['competency:planmanage'] = 'Tvarkyti mokymosi planus';
$string['competency:planmanagedraft'] = 'Tvarkyti kuriamus mokymosi planus';
$string['competency:planmanageown'] = 'Tvarkyti savo mokymosi planus';
$string['competency:planmanageowndraft'] = 'Tvarkyti savo kuriamus mokymosi planus';
$string['competency:planrequestreview'] = 'Prašyti peržiūrėti mokymosi planą';
$string['competency:planrequestreviewown'] = 'Prašyti peržiūrėti savo mokymosi planą';
$string['competency:planreview'] = 'Peržiūrėti mokymosi planą';
$string['competency:planview'] = 'Peržiūrėti visus mokymosi planus';
$string['competency:planviewdraft'] = 'Peržiūrėti kuriamus mokymosi planus';
$string['competency:planviewown'] = 'Peržiūrėti savo mokymosi planus';
$string['competency:planviewowndraft'] = 'Peržiūrėti savo kuriamus mokymosi planus';
$string['competency:templatemanage'] = 'Tvarkyti mokymosi plano šablonus';
$string['competency:templateview'] = 'Žiūrėti mokymosi plano šablonus';
$string['competency:usercompetencycomment'] = 'Komentuoti naudotojo kompetenciją';
$string['competency:usercompetencycommentown'] = 'Komentuoti savo naudotojo kompetencijas';
$string['competency:usercompetencyrequestreview'] = 'Prašyti peržiūrėti naudotojo kompetenciją';
$string['competency:usercompetencyrequestreviewown'] = 'Prašyti peržiūrėti savo naudotojo kompetenciją';
$string['competency:usercompetencyreview'] = 'Peržiūrėti naudotojo kompetenciją';
$string['competency:usercompetencyview'] = 'Žiūrėti naudotojo kompetenciją';
$string['competency:userevidencemanage'] = 'Tvarkyti ankstesnio mokymosi įrodymus';
$string['competency:userevidencemanageown'] = 'Tvarkyti savo ankstesnio mokymosi įrodymus';
$string['competency:userevidenceview'] = 'Peržiūrėti naudotojo ankstesnio mokymosi įrodymą';
$string['confirmaddadmins'] = 'Ar tikrai norite įtraukti šiuos naudotojus į svetainės administratorių sąrašą?';
$string['confirmremoveadmins'] = 'Ar tikrai norite pašalinti šiuos naudotojus iš svetainės administratorių sąrašo?';
$string['confirmroleprevent'] = 'Ar tikrai norite pašalinti <strong>"{$a->role}"</strong> iš konteksto "{$a->context}" galimybės "{$a->cap}" leidžiamų vaidmenų sąrašo ?';
$string['confirmroleunprohibit'] = 'Ar tikrai norite pašalinti <strong>"{$a->role}"</strong> iš konteksto "{$a->context}" galimybės "{$a->cap}" draudžiamų vaidmenų sąrašo ?';
$string['confirmunassign'] = 'Ar tikrai norite pašalinti šio naudotojo vaidmenį?';
$string['confirmunassignno'] = 'Atšaukti';
$string['confirmunassigntitle'] = 'Patvirtinti vaidmens keitimą';
$string['confirmunassignyes'] = 'Šalinti';
$string['contentbank:access'] = 'Prieiga prie interaktyvaus turinio banko';
$string['contentbank:changelockedcustomfields'] = 'Keisti turinio banko užrakintus pasirinktinius laukus';
$string['contentbank:configurecustomfields'] = 'Interaktyvaus turinio banko pasirinktinių laukų konfigūravimas';
$string['contentbank:copyanycontent'] = 'Kopijuoti bet kokį turinio banko turinį';
$string['contentbank:copycontent'] = 'Turinio banko turinio kopijavimas';
$string['contentbank:deleteanycontent'] = 'Naikinti bet kokį turinį iš interaktyvaus turinio banko';
$string['contentbank:deleteowncontent'] = 'Naikinti turinį iš savo interaktyvaus turinio banko';
$string['contentbank:downloadcontent'] = 'Atsisiųsti turinį iš turinio banko';
$string['contentbank:manageanycontent'] = 'Tvarkyti interaktyvaus turinio banko turinį';
$string['contentbank:manageowncontent'] = 'Tvarkyti savo interaktyvaus turinio banko turinį';
$string['contentbank:upload'] = 'Įkelti naują turinį interaktyvaus turinio banką';
$string['contentbank:useeditor'] = 'Kurti arba redaguoti turinį naudojant turinio tipo rengyklę';
$string['contentbank:viewunlistedcontent'] = 'Peržiūrėti neįtrauktą turinį iš turinio banko';
$string['context'] = 'Kontekstas';
$string['contextrolenotallowed'] = 'Vaidmuo {$a} šiame kontekste neleidžiamas.';
$string['course:activityvisibility'] = 'Slėpti / rodyti veiklas';
$string['course:bulkmessaging'] = 'Siųsti žinutę daugeliui žmonių';
$string['course:changecategory'] = 'Keisti kursų kategoriją';
$string['course:changefullname'] = 'Keisti visą kursų pavadinimą';
$string['course:changeidnumber'] = 'Keisti kursų ID numerį';
$string['course:changelockedcustomfields'] = 'Pakeisti užrakintus pasirinktinius laukus';
$string['course:changeshortname'] = 'Keisti trumpąjį kursų pavadinimą';
$string['course:changesummary'] = 'Keisti kursų suvestinę';
$string['course:configurecoursecommunication'] = 'Kurso komunikacijos nustatymų konfigūravimas';
$string['course:configurecustomfields'] = 'Konfigūruoti pasirinktinius kurso laukus';
$string['course:configuredownloadcontent'] = 'Konfigūruoti atsisiunčiamo kurso turinį';
$string['course:create'] = 'Kurti kursus';
$string['course:creategroupconversations'] = 'Sukurti pokalbius grupėse';
$string['course:delete'] = 'Naikinti kursus';
$string['course:downloadcoursecontent'] = 'Parsisiųsti kurso turinį';
$string['course:editcoursewelcomemessage'] = 'Redaguoti kurso sveikinimo žinutę';
$string['course:enrolconfig'] = 'Konfigūruoti kursų registracijos egzempliorius';
$string['course:enrolreview'] = 'Peržiūrėti kursų registracijas';
$string['course:ignoreavailabilityrestrictions'] = 'Nepaisyti prieinamumo apribojimų';
$string['course:ignorefilesizelimits'] = 'Naudoti failus didesnius, nei failų apribojimai';
$string['course:isincompletionreports'] = 'Rodoma užbaigimo ataskaitose';
$string['course:manageactivities'] = 'Tvarkyti veiklas';
$string['course:managefiles'] = 'Tvarkyti failus';
$string['course:managegrades'] = 'Tvarkyti įvertinimus';
$string['course:managegroups'] = 'Tvarkyti grupes';
$string['course:managescales'] = 'Tvarkyti skales';
$string['course:markcomplete'] = 'Užbaigus kursus pažymėti naudotojus kaip užbaigtus';
$string['course:movesections'] = 'Perkelti dalis';
$string['course:overridecompletion'] = 'Keisti veiklos užbaigimo būseną';
$string['course:recommendactivity'] = 'Veiklų parinkiklyje rekomenduojamos veiklos';
$string['course:renameroles'] = 'Pervadinti vaidmenis';
$string['course:request'] = 'Prašyti naujų kursų';
$string['course:reset'] = 'Iš naujo nustatyti kursus';
$string['course:reviewotherusers'] = 'Peržiūrėti kitus naudotojus';
$string['course:sectionvisibility'] = 'Valdyti dalies matomumą';
$string['course:setcurrentsection'] = 'Nustatyti dabartinę dalį';
$string['course:setforcedlanguage'] = 'Nurodyti priverstinę kurso ar veiklos kalbą';
$string['course:tag'] = 'Keisti kurso žymes';
$string['course:togglecompletion'] = 'Rankiniu būdu pažymėti veiklą kaip užbaigtą';
$string['course:update'] = 'Atnaujinti kursų parametrus';
$string['course:useremail'] = 'Įjungti / išjungti el. pašto adresą';
$string['course:view'] = 'Peržiūrėti kursus, kuriuose nedalyvaujama';
$string['course:viewcoursegrades'] = 'Peržiūrėti kursų įvertinimus';
$string['course:viewhiddenactivities'] = 'Peržiūrėti paslėptas veiklas';
$string['course:viewhiddencourses'] = 'Peržiūrėti paslėptus kursus';
$string['course:viewhiddengroups'] = 'Peržiūrėti paslėptas grupes';
$string['course:viewhiddensections'] = 'Peržiūrėti paslėptas dalis';
$string['course:viewhiddenuserfields'] = 'Peržiūrėti paslėptus naudotojo laukus';
$string['course:viewparticipants'] = 'Peržiūrėti dalyvius';
$string['course:viewscales'] = 'Peržiūrėti skales';
$string['course:viewsuspendedusers'] = 'Peržiūrėti sulaikytus naudotojus';
$string['course:visibility'] = 'Slėpti / rodyti kursus';
$string['createrolebycopying'] = 'Kurti naują vaidmenį kopijuojant {$a}';
$string['createthisrole'] = 'Kurti šį vaidmenį';
$string['currentcontext'] = 'Dabartinis kontekstas';
$string['currentrole'] = 'Dabartinis vaidmuo';
$string['customroledescription'] = 'Pasirinktinis aprašymas';
$string['customroledescription_help'] = 'Standartinių vaidmenų aprašymai lokalizuojami automatiškai, jei tinkintas aprašas tuščias.';
$string['customrolename'] = 'Tinkantis pilnas pavadinimas';
$string['customrolename_help'] = 'Standartinių vaidmenų pavadinimai automatiškai lokalizuojami, jei pavadinimo laukas yra tuščias. Turite nurodyti tinkantį pilną pavadinimą kuriamam vaidmeniui.';
$string['defaultrole'] = 'Numatytasis vaidmuo';
$string['defaultx'] = 'Numatyta: {$a}';
$string['defineroles'] = 'Apibrėžti vaidmenis';
$string['definitionofrolex'] = 'Vaidmens "{$a}" apibrėžimas';
$string['deletecourseoverrides'] = 'Visi kurso keitimai';
$string['deletelocalroles'] = 'Visi vaidmenų priskyrimai';
$string['deleterolesure'] = '<p>Ar tikrai norite naikinti vaidmenį  "{$a->name} ({$a->shortname})"?</p><p>Dabar šis vaidmuo priskirtas {$a->count} naudotojui (-ams).</p>';
$string['deletexrole'] = 'Naikinti {$a} vaidmenį';
$string['duplicaterole'] = 'Dubliuoti vaidmenį';
$string['duplicaterolesure'] = '<p>Ar tikrai norite dubliuoti vaidmenį "{$a->name} ({$a->shortname})"?</p>';
$string['editingrolex'] = 'Redaguojamas vaidmuo {$a}';
$string['editrole'] = 'Redaguoti vaidmenį';
$string['editxrole'] = 'Redaguoti {$a} vaidmenį';
$string['errorbadrolename'] = 'Netinkamas vaidmens pavadinimas';
$string['errorbadroleshortname'] = 'Netinkamas trumpasis vaidmens pavadinimas';
$string['errorexistsrolename'] = 'Vaidmens pavadinimas jau yra';
$string['errorexistsroleshortname'] = 'Vaidmens pavadinimas jau yra';
$string['errorroleshortnametoolong'] = 'Trumpas pavadinimas neturi viršyti 100 simbolių';
$string['eventcapabilityassigned'] = 'Suteiktos galimybės';
$string['eventcapabilityunassigned'] = 'Galimybė nepriskirta';
$string['eventroleallowassignupdated'] = 'Leisti vaidmens priskyrimą';
$string['eventroleallowoverrideupdated'] = 'Leisti vaidmens perrašymą';
$string['eventroleallowswitchupdated'] = 'Leisti vaidmenų perjungimą';
$string['eventroleallowviewupdated'] = 'Leisti vaidmens peržiūrą';
$string['eventroleassigned'] = 'Vaidmuo priskirtas';
$string['eventrolecapabilitiesupdated'] = 'Vaidmenų teisės atnaujintos';
$string['eventrolecreated'] = 'Sukurtas vaidmuo';
$string['eventroledeleted'] = 'Vaidmuo ištrintas';
$string['eventroleunassigned'] = 'Vaidmuo nepriskirtas';
$string['eventroleupdated'] = 'Vaidmuo atnaujintas';
$string['existingadmins'] = 'Dabartiniai svetainės administratoriai';
$string['existingusers'] = 'Esami naudotojai: {$a}';
$string['explanation'] = 'Paaiškinimas';
$string['export'] = 'Eksportuoti';
$string['extusers'] = 'Esami naudotojai';
$string['extusersmatching'] = 'Esami naudotojai, atitinkantys {$a}';
$string['filter:manage'] = 'Tvarkyti vietinio filtro parametrus';
$string['frontpageuser'] = 'Autentifikuotas pradinio svetainės puslapio naudotojas';
$string['frontpageuserdescription'] = 'Visi prisijungę pagrindinio svetainės puslapio kurso naudotojai';
$string['globalrole'] = 'Sistemos vaidmuo';
$string['globalroleswarning'] = 'ĮSPĖJIMAS! Visi vaidmenys, kuriuos priskiriate šiame puslapyje, bus pritaikyti priskirtiems naudotojams visoje sistemoje, įskaitant pradinį svetainės puslapį ir visus kursus.';
$string['gotoassignroles'] = 'Eiti į Priskirti vaidmenis šiam {$a->contextlevel}';
$string['gotoassignsystemroles'] = 'Eiti į Priskirti sistemos vaidmenis';
$string['grade:edit'] = 'Redaguoti įvertinimus';
$string['grade:export'] = 'Eksportuoti įvertinimus';
$string['grade:hide'] = 'Slėpti / neslėpti įvertinimus ar elementus';
$string['grade:import'] = 'Importuoti įvertinimus';
$string['grade:lock'] = 'Užrakinti įvertinimus arba elementus';
$string['grade:manage'] = 'Tvarkyti įvertinimų elementus';
$string['grade:managegradingforms'] = 'Tvarkyti patobulintus vertinimo metodus';
$string['grade:manageletters'] = 'Tvarkyti raidinius įvertinimus';
$string['grade:manageoutcomes'] = 'Tvarkyti įvertinimų rezultatus';
$string['grade:managesharedforms'] = 'Tvarkyti patobulintas vertinimo formų šablonus';
$string['grade:override'] = 'Keisti įvertinimus';
$string['grade:sharegradingforms'] = 'Pasidalinti patobulinta vertinimo forma kaip šablonu';
$string['grade:unlock'] = 'Atrakinti įvertinimus arba elementus';
$string['grade:view'] = 'Žiūrėti savo įvertinimus';
$string['grade:viewall'] = 'Žiūrėti kitų naudotojų įvertinimus';
$string['grade:viewhidden'] = 'Peržiūrėti nuo gavėjo paslėptus įvertinimus';
$string['group:configurecustomfields'] = 'Grupės/grupavimo pasirinktinių laukų konfigūravimas';
$string['h5p:deploy'] = 'Įdiegti H5P turinį';
$string['h5p:setdisplayoptions'] = 'Nustatyti H5P rodymo parinktis';
$string['h5p:updatelibraries'] = 'Tvarkyti H5P turinio tipus';
$string['highlightedcellsshowdefault'] = 'Pažymėtuose toliau pateiktos lentelės langeliuose rodomos šio vaidmens tipo numatytosios teisės, remiantis Senstelėjęs vaidmens tipas viršuje.';
$string['highlightedcellsshowinherit'] = 'Pažymėtuose toliau pateiktos lentelės langeliuose rodomos teisės (jei yra), kurios bus paveldėtos. Turite viską palikti nustatytą kaip Paveldėti išskyrus galimybes, kurių teises tikrai norite keisti.';
$string['inactiveformorethan'] = 'Neaktyvu ilgiau nei {$a->timeperiod}';
$string['ingroup'] = 'į grupę {$a->group}';
$string['inherit'] = 'Paveldėti';
$string['invalidpresetfile'] = 'Netinkamas vaidmens aprašymo failas';
$string['legacy:admin'] = 'LEGACY ROLE: administratorius';
$string['legacy:coursecreator'] = 'LEGACY ROLE: kursų kūrėjas';
$string['legacy:editingteacher'] = 'LEGACY ROLE: dėstytojas (redagavimas)';
$string['legacy:guest'] = 'LEGACY ROLE: Svečias';
$string['legacy:student'] = 'LEGACY ROLE: Besimokantysis';
$string['legacy:teacher'] = 'LEGACY ROLE: Dėstytojas (be redagavimo)';
$string['legacy:user'] = 'LEGACY ROLE: Autentifikuotas naudotojas';
$string['legacytype'] = 'Senstelėjusio vaidmens tipas';
$string['listallroles'] = 'Išvardyti visus vaidmenis';
$string['localroles'] = 'Vietoje priskirti vaidmenys';
$string['mainadmin'] = 'Pagrindinis administratorius';
$string['mainadminset'] = 'Nustatyti pagrindinį administratorių';
$string['manageadmins'] = 'Tvarkyti svetainės administratorius';
$string['manager'] = 'Tvarkytojas';
$string['managerdescription'] = 'Tvarkytojai gali pasiekti kursus ir juos modifikuoti, tačiau paprastai jie juose nedalyvauja.';
$string['manageroles'] = 'Tvarkyti vaidmenis';
$string['maybeassignedin'] = 'Konteksto tipai, kuriuose šį vaidmenį galima priskirti';
$string['moodlenet:shareactivity'] = 'Pasidalinti veikla su MoodleNet';
$string['moodlenet:sharecourse'] = 'Dalytis kursu su MoodleNet';
$string['morethan'] = 'Daugiau nei {$a}';
$string['multipleroles'] = 'Keli vaidmenys';
$string['my:configsyspages'] = 'Konfigūruoti "Mano pagrindinis" puslapio sistemos šablonus';
$string['my:manageblocks'] = 'Tvarkyti mano pagrindinio puslapio blokus';
$string['neededroles'] = 'Vaidmenys su teisėmis';
$string['nocapabilitiesincontext'] = 'Šiame kontekste galimybių nėra';
$string['noneinthisx'] = 'Nėra šiame {$a}';
$string['noneinthisxmatching'] = 'Šiame {$a->contexttype} nėra naudotojų, atitinkančių {$a->search}';
$string['norole'] = 'Nėra vaidmens';
$string['noroleassignments'] = 'Šioje svetainėje šis naudotojas niekur neturi jokių priskirtų vaidmenų.';
$string['noroles'] = 'Vaidmenų nėra';
$string['notabletoassignroleshere'] = 'Administratorius neįjungė šiam kontekstui vaidmenų priskyrimo.';
$string['notabletooverrideroleshere'] = 'Čia negalite keisti jokių vaidmenų teisių';
$string['notes:manage'] = 'Tvarkyti pastabas';
$string['notes:view'] = 'Peržiūrėti pastabas';
$string['notset'] = 'Nenustatyta';
$string['novisibleroles'] = 'Nėra vaidmenų';
$string['overrideanotherrole'] = 'Keisti kitą vaidmenį';
$string['overridecontext'] = 'Keisti kontekstą';
$string['overridepermissions'] = 'Keisti teises';
$string['overridepermissions_help'] = 'Naudojant teisių keitimus įjungiama galimybė leisti arba neleisti naudoti pasirinktas galimybes konkrečiame kontekste.';
$string['overridepermissions_link'] = 'admin/roles/override';
$string['overridepermissionsforrole'] = 'Keisti {$a->context} vaidmens {$a->role} teises';
$string['overridepermissionsin'] = 'Keisti {$a} teises';
$string['overrideroles'] = 'Keisti pastabas';
$string['overriderolesin'] = 'Keisti {$a} vaidmenis';
$string['overrides'] = 'Keitimai';
$string['overridesbycontext'] = 'Keitimai (pagal kontekstą)';
$string['payment:manageaccounts'] = 'Tvarkyti paskyras';
$string['payment:viewpayments'] = 'Peržiūrėti mokėjimus';
$string['permission'] = 'Teisė';
$string['permission_help'] = 'Teisės yra galimybių parametrai. Yra 4 parinktys: * Nenustatyta * Leisti – suteikta teisė naudoti galimybę * Neleisti – pašalinta teisė naudoti galimybę, net jei ji leidžiama aukštesnio lygio kontekste * Drausti – teisė yra visiškai uždrausta, jos negalima pakeisti jokiame žemesniame (konkretesniame) kontekste';
$string['permissions'] = 'Teisės';
$string['permissionsforuser'] = 'Naudotojo {$a} teisės';
$string['permissionsincontext'] = '{$a} teises';
$string['portfolio:export'] = 'Eksportuoti į portfelius';
$string['potentialusers'] = '{$a} potencialūs naudotojai';
$string['potusers'] = 'Potencialūs naudotojai';
$string['potusersmatching'] = 'Potencialūs naudotojai, atitinkantys {$a}';
$string['prevent'] = 'Neleisti';
$string['privacy:metadata:preference:showadvanced'] = 'Valdyti perjungiamo išplėstinio režimo mygtuką.';
$string['privacy:metadata:role_assignments'] = 'Vaidmenų priskyrimai';
$string['privacy:metadata:role_assignments:component'] = 'Papildinys, atsakingas už vaidmenų priskyrimą, tuščias, kai priskiriamas rankiniu būdu.';
$string['privacy:metadata:role_assignments:itemid'] = 'Registracijos / autentifikavimo egzemplioriaus, atsakingo už šį vaidmens priskyrimą, ID';
$string['privacy:metadata:role_assignments:modifierid'] = 'Naudotojo, kuris sukūrė arba pakeitė vaidmens priskyrimą, ID';
$string['privacy:metadata:role_assignments:roleid'] = 'Vaidmens ID';
$string['privacy:metadata:role_assignments:tableexplanation'] = 'Šioje lentelėje saugomi kiekviename kontekste priskirti vaidmenys.';
$string['privacy:metadata:role_assignments:timemodified'] = 'Data, kada vaidmens priskyrimas buvo sukurtas arba pakeistas.';
$string['privacy:metadata:role_assignments:userid'] = 'Naudotojo ID';
$string['privacy:metadata:role_capabilities'] = 'Vaidmenų galimybės';
$string['privacy:metadata:role_capabilities:capability'] = 'Galimybės pavadinimas.';
$string['privacy:metadata:role_capabilities:modifierid'] = 'Galimybę sukūrusio arba pakeitusio naudotojo ID';
$string['privacy:metadata:role_capabilities:permission'] = 'Galimybės leidimas: paveldėti, leisti, užkirsti kelią arba uždrausti.';
$string['privacy:metadata:role_capabilities:roleid'] = 'Vaidmens ID.';
$string['privacy:metadata:role_capabilities:tableexplanation'] = 'Galimybės ir keitimo galimybės tam tikram vaidmeniui tam tikrame kontekste';
$string['privacy:metadata:role_capabilities:timemodified'] = 'Data, kada galimybė buvo sukurta arba pakeista.';
$string['privacy:metadata:role_cohortroles'] = 'Junginio vaidmenys';
$string['prohibit'] = 'Drausti';
$string['prohibitedroles'] = 'Uždrausta';
$string['question:add'] = 'Įtraukti naujus klausimus';
$string['question:commentall'] = 'Komentuoti visus klausimus';
$string['question:commentmine'] = 'Komentuoti savo klausimus';
$string['question:config'] = 'Konfigūruoti klausimų tipus';
$string['question:editall'] = 'Redaguoti visus klausimus';
$string['question:editmine'] = 'Redaguoti nuosavus klausimus';
$string['question:flag'] = 'Pažymėti klausimus vėliavėle juos bandant';
$string['question:managecategory'] = 'redaguoti klausimų kategorijas';
$string['question:moveall'] = 'Perkelti visus klausimus';
$string['question:movemine'] = 'Perkelti nuosavus klausimus';
$string['question:tagall'] = 'Žymėti visus klausimus';
$string['question:tagmine'] = 'Žymėti savo klausimus';
$string['question:useall'] = 'Naudoti visus klausimus';
$string['question:usemine'] = 'Naudoti nuosavus klausimus';
$string['question:viewall'] = 'Peržiūrėti visus klausimus';
$string['question:viewmine'] = 'Peržiūrėti nuosavus klausimus';
$string['rating:rate'] = 'Į elementus įtraukti pažymius';
$string['rating:view'] = 'Peržiūrėti bendrą gautą pažymį';
$string['rating:viewall'] = 'Peržiūrėti visus, asmenų parašytus, pažymius';
$string['rating:viewany'] = 'Peržiūrėti visų gautus bendrus pažymius';
$string['reportbuilder:edit'] = 'Redaguoti savo tinkintas ataskaitas';
$string['reportbuilder:editall'] = 'Redaguoti visas tinkintas ataskaitas';
$string['reportbuilder:scheduleviewas'] = 'Suplanuokite ataskaitas, kad jos būtų peržiūrėtos kaip kiti naudotojai';
$string['reportbuilder:view'] = 'Peržiūrėti pasirinktines ataskaitas';
$string['reportbuilder:viewall'] = 'Peržiūrėti visas pasirinktines ataskaitas';
$string['resetrole'] = 'Nustatyti numatytąsias reikšmes';
$string['resettingrole'] = 'Atstatomas vaidmuo \'{$a}\'';
$string['restore:configure'] = 'Konfigūruoti atkūrimo parinktis';
$string['restore:createuser'] = 'Atkuriant kurti naudotojus';
$string['restore:restoreactivity'] = 'Atkurti veiklas';
$string['restore:restorecourse'] = 'Atkurti kursus';
$string['restore:restoresection'] = 'Atkurti dalis';
$string['restore:restoretargetimport'] = 'Atkurti iš failų, skirtų importavimui';
$string['restore:rolldates'] = 'Atkuriant leista grąžinti veiklos konfigūravimo datas';
$string['restore:uploadfile'] = 'Įkelti failus į atsarginių kopijų kūrimo sritis';
$string['restore:userinfo'] = 'Atkurti naudotojo duomenis';
$string['restore:viewautomatedfilearea'] = 'Atkurti kursus iš automatinių atsarginių kopijų';
$string['risks'] = 'Rizika';
$string['role:assign'] = 'Priskirti naudotojams vaidmenis';
$string['role:manage'] = 'Kurti ir tvarkyti vaidmenis';
$string['role:override'] = 'Keisti kitų teises';
$string['role:review'] = 'Peržiūrėti kitų teises';
$string['role:safeoverride'] = 'Keisti kitų saugos teises';
$string['role:switchroles'] = 'Perjungti kitų vaidmenis';
$string['roleallowheader'] = 'Leisti vaidmenį:';
$string['roleallowinfo'] = 'Pasirinkite vaidmenį, kuris bus įtrauktas į konteksto "{$a->context}" leidžiamų vaidmenų sąrašą, galimybė "{$a->cap}":';
$string['roleassignment'] = 'Vaidmens priskyrimas';
$string['roleassignments'] = 'Vaidmenų priskyrimai';
$string['roledefinitions'] = 'Vaidmenų apibrėžimai';
$string['rolefullname'] = 'Vaidmens pavadinimas';
$string['roleincontext'] = '{$a->role} {$a->context}';
$string['roleoriginalname'] = 'Originalus pavadinimas';
$string['roleprohibitheader'] = 'Drausti vaidmenį';
$string['roleprohibitinfo'] = 'Pasirinkite vaidmenį, kuris bus įtrauktas į konteksto "{$a->context}" draudžiamų vaidmenų sąrašą, galimybė "{$a->cap}":';
$string['rolerepreset'] = 'Naudoti vaidmens išankstinių nustatymų rinkinį';
$string['roleresetdefaults'] = 'Numatytieji';
$string['roleresetrole'] = 'Naudoti vaidmenį ar archetipą';
$string['rolerisks'] = 'Vaidmenų rizikos';
$string['roles'] = 'Vaidmenys';
$string['roles_help'] = 'Vaidmuo – tai visai sistemai apibrėžtų teisių rinkinys, kurį galite priskirti konkretiems naudotojams konkrečiame kontekste.';
$string['roles_link'] = 'roles';
$string['roleselect'] = 'Pasirinkti vaidmenį';
$string['rolesforuser'] = 'Vaidmenys naudotojams {$a}';
$string['roleshortname'] = 'Trumpas pavadinimas';
$string['roleshortname_help'] = 'Trumpasis vaidmens pavadinimas yra žemo lygio vaidmens identifikatorius, kuriame leidžiami tik ASCII raidiniai ir skaitiniai simboliai.';
$string['roletoassign'] = 'Priskirtinas vaidmuo';
$string['roletooverride'] = 'Keistinas vaidmuo';
$string['safeoverridenotice'] = 'Pastaba: galimybės, kurių rizika didesnė, yra užrakintos, nes galite keisti tik saugias galimybes.';
$string['search:query'] = 'Atlikti visos svetainės paiešką';
$string['selectanotheruser'] = 'Pasirinkti kitą naudotoją';
$string['selectauser'] = 'Pasirinkite naudotoją';
$string['selectrole'] = 'Pasirinkite vaidmenį';
$string['showallroles'] = 'Rodyti visus vaidmenis';
$string['showthisuserspermissions'] = 'Rodyti šio naudotojo teises';
$string['site:accessallgroups'] = 'Pasiekti visas grupes';
$string['site:approvecourse'] = 'Patvirtinti kursų kūrimą';
$string['site:backup'] = 'Kurti atsarginę kursų kopiją';
$string['site:config'] = 'Keisti vietos konfigūraciją';
$string['site:configview'] = 'Peržiūrėti svetainės administravimo medį (bet ne visus jo puslapius)';
$string['site:deleteanymessage'] = 'Naikinti bet kokias žinutes svetainėje';
$string['site:deleteownmessage'] = 'Naikinti naudotojui ir naudotojo siunčiamas žinutes';
$string['site:doanything'] = 'Leista daryti viską';
$string['site:doclinks'] = 'Rodyti saitus su ne svetainėje esančiais dokumentais';
$string['site:forcelanguage'] = 'Nepaisyti kurso kalbos';
$string['site:import'] = 'Į kursą importuoti kitus kursus';
$string['site:maintenanceaccess'] = 'Prieiga prie svetainės techninės priežiūros metu';
$string['site:manageallmessaging'] = 'Pridėti, pašalinti, blokuoti ir atblokuoti bet kurio naudotojo kontaktus';
$string['site:manageblocks'] = 'Tvarkyti puslapio blokus';
$string['site:managecontextlocks'] = 'Tvarkyti kontekstų užšaldymą';
$string['site:messageanyuser'] = 'Apeiti naudotojo privatumo nuostatas, kad galėtumėte siųsti žinutes bet kuriam naudotojui';
$string['site:mnetloginfromremote'] = 'Prisijungti iš nuotolinės taikomosios programos per „MNet“';
$string['site:mnetlogintoremote'] = 'Jungtis prie nuotolinės taikomosios programos per „MNet“';
$string['site:readallmessages'] = 'Skaityti visas svetainės esančias žinutes';
$string['site:restore'] = 'Atkurti kursus';
$string['site:senderrormessage'] = 'Iš klaidos puslapio išsiųsti pranešimą palaikymo naudotojui';
$string['site:sendmessage'] = 'Siųsti žinutes bet kuriam naudotojui';
$string['site:trustcontent'] = 'Pasitikėti pateiktu turiniu';
$string['site:uploadusers'] = 'Įkelti naujus naudotojus iš failo';
$string['site:viewanonymousevents'] = 'Peržiūrėti anoniminius įvykius ataskaitose';
$string['site:viewfullnames'] = 'Visada matyti naudotojų vardą ir pavardę';
$string['site:viewparticipants'] = 'Peržiūrėti dalyvius';
$string['site:viewreports'] = 'Peržiūrėti ataskaitas';
$string['site:viewuseridentity'] = 'Peržiūrėti pilna naudotojo atpažinimą sąraše';
$string['siteadministrators'] = 'Svetainės administratoriai';
$string['siteadministratorsconfigphp'] = 'Svetainės administratorių sąrašo keisti negalima, nes jis yra apibrėžtas config.php.';
$string['tag:edit'] = 'Redaguoti esamas žymes';
$string['tag:editblocks'] = 'Redaguoti žymių puslapių blokus';
$string['tag:flag'] = 'Žymėti žymas kaip netinkamą';
$string['tag:manage'] = 'Tvarkyti visas žymes';
$string['thisnewrole'] = 'Šis naujas vaidmuo';
$string['thisusersroles'] = 'Naudotojo vaidmenų priskyrimai';
$string['unassignarole'] = 'Panaikinti vaidmens {$a} priskyrimą';
$string['unassignconfirm'] = 'Ar tikrai norite panaikinti vaidmens {$a->role} priskyrimą naudotojui {$a->user}?';
$string['unassignerror'] = 'Įvyko klaida naikinant vaidmens {$a->role} priskyrimą naudotojui {$a->user}.';
$string['user:changeownpassword'] = 'Keisti nuosavą slaptažodį';
$string['user:create'] = 'Kurti naudotojus';
$string['user:delete'] = 'Naikinti naudotojus';
$string['user:editmessageprofile'] = 'Redaguoti naudotojo žinučių profilį';
$string['user:editownmessageprofile'] = 'Redaguoti nuosavą naudotojo žinučių profilį';
$string['user:editownprofile'] = 'Redaguoti nuosavą naudotojo profilį';
$string['user:editprofile'] = 'Redaguoti naudotojo profilį';
$string['user:ignoreuserquota'] = 'Nepaisyti naudotojo kvotos ribos';
$string['user:loginas'] = 'Prisijungti kaip kiti naudotojai';
$string['user:manageblocks'] = 'Tvarkyti kitų naudotojų naudotojo profilio blokus';
$string['user:manageownblocks'] = 'Tvarkyti nuosavo viešojo naudotojo profilio blokus';
$string['user:manageownfiles'] = 'Tvarkyti failus nuosavose privačių failų srityse';
$string['user:managesyspages'] = 'Konfigūruoti viešųjų naudotojų profilių numatytąjį puslapio maketą';
$string['user:readuserblogs'] = 'Matyti visų naudotojų tinklaraščius';
$string['user:readuserposts'] = 'Matyti visų naudotojų skelbimus';
$string['user:update'] = 'Naujinti naudotojų profilius';
$string['user:viewalldetails'] = 'Peržiūrėti visą naudotojo informaciją';
$string['user:viewdetails'] = 'Peržiūrėti naudotojų profilius';
$string['user:viewhiddendetails'] = 'Peržiūrėti paslėptą naudotojų išsamią informaciją';
$string['user:viewlastip'] = 'Peržiūrėti naudotojo paskutinį IP adresą';
$string['user:viewprofilepictures'] = 'Peržiūrėti naudotojo nuotraukas (jei įjungtas priverstinis prisijungimas)';
$string['user:viewuseractivitiesreport'] = 'Matyti naudotojų veiklos ataskaitas';
$string['user:viewusergrades'] = 'Žiūrėti naudotojų įvertinimus';
$string['usersfrom'] = 'Naudotojai iš {$a}';
$string['usersfrommatching'] = 'Naudotojai iš {$a->contextname}, atitinkantys {$a->search}';
$string['usersinthisx'] = 'Naudotojai šiame {$a}';
$string['usersinthisxmatching'] = 'Naudotojai šiame {$a->contexttype}, atitinkantys {$a->search}';
$string['userswithrole'] = 'Visi naudotojai, turintys vaidmenį';
$string['userswiththisrole'] = 'Naudotojai, turintys vaidmenį';
$string['useshowadvancedtochange'] = 'Norint keisti, naudoti Rodyti išplėstinį';
$string['viewingdefinitionofrolex'] = 'Peržiūrimas vaidmens {$a} apibrėžimas';
$string['viewrole'] = 'Rodyti išsamią vaidmens informaciją';
$string['webservice:createmobiletoken'] = 'Kurti žiniatinklio paslaugos atpažinimo ženklą mobiliai prieigai';
$string['webservice:createtoken'] = 'Kurti žiniatinklio paslaugos atpažinimo ženklą';
$string['webservice:managealltokens'] = 'Valdyti visų naudotojų žiniatinklio paslaugų ženklus';
$string['whydoesuserhavecap'] = 'Kodėl {$a->fullname} turi galimybę {$a->capability} kontekste {$a->context}?';
$string['whydoesusernothavecap'] = 'Kodėl {$a->fullname} neturi galimybės {$a->capability} kontekste {$a->context}?';
$string['xroleassignments'] = '{$a} vaidmenų priskyrimai';
$string['xuserswiththerole'] = 'Naudotojai, turintys vaidmenį {$a->role}';
