<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_openai', language 'hu', version '5.1'.
 *
 * @package     aiprovider_openai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:explain_text:endpoint'] = 'API végpont';
$string['action:explain_text:model'] = 'MI modell';
$string['action:explain_text:model_help'] = 'A kapott szöveget elmagyarázó modell.';
$string['action:explain_text:systeminstruction'] = 'Rendszerutasítás';
$string['action:explain_text:systeminstruction_help'] = 'Ez az utasítás a felhasználói prompttal együtt lesz elküldve az MI modellnek. Az utasítás módosítása nem javasolt, csak ha mindenképpen indokolt.';
$string['action:generate_image:endpoint'] = 'API végpont';
$string['action:generate_image:model'] = 'MI modell';
$string['action:generate_image:model_desc'] = 'A felhasználói promptokból képeket generáló modell.';
$string['action:generate_image:model_help'] = 'A felhasználói promptokból képeket generáló modell.';
$string['action:generate_text:endpoint'] = 'API végpont';
$string['action:generate_text:model'] = 'MI modell';
$string['action:generate_text:model_desc'] = 'A szöveges válasz létrehozásához használt modell.';
$string['action:generate_text:model_help'] = 'A szöveges válasz létrehozásához használt modell.';
$string['action:generate_text:systeminstruction'] = 'Rendszerutasítás';
$string['action:generate_text:systeminstruction_desc'] = 'Ez az utasítás a felhasználói prompttal együtt lesz elküldve az MI modellnek. Az utasítás módosítása nem javasolt, csak ha mindenképpen indokolt.';
$string['action:generate_text:systeminstruction_help'] = 'Ez az utasítás a felhasználói prompttal együtt lesz elküldve az MI modellnek. Az utasítás módosítása nem javasolt, csak ha mindenképpen indokolt.';
$string['action:summarise_text:endpoint'] = 'API végpont';
$string['action:summarise_text:model'] = 'MI modell';
$string['action:summarise_text:model_desc'] = 'A kapott szöveget összefoglaló modell.';
$string['action:summarise_text:model_help'] = 'A kapott szöveget összefoglaló modell.';
$string['action:summarise_text:systeminstruction'] = 'Rendszerutasítás';
$string['action:summarise_text:systeminstruction_desc'] = 'Ez az utasítás a felhasználói prompttal együtt lesz elküldve az MI modellnek. Az utasítás módosítása nem javasolt, csak ha mindenképpen indokolt.';
$string['action:summarise_text:systeminstruction_help'] = 'Ez az utasítás a felhasználói prompttal együtt lesz elküldve az MI modellnek. Az utasítás módosítása nem javasolt, csak ha mindenképpen indokolt.';
$string['apikey'] = 'OpenAI API kulcs';
$string['apikey_desc'] = 'A kulcs beszerezhető az <a href="https://platform.openai.com/account/api-keys">OpenAI Platform API kulcsok</a> oldalon.';
$string['apikey_help'] = 'Kulcs beszerzése a saját <a href="https://platform.openai.com/account/api-keys" target="_blank">OpenAI API kulcsok</a> oldalról.';
$string['custom_model_name'] = 'Egyedi modell név';
$string['enableglobalratelimit'] = 'Portálszintű használati limit beállítása';
$string['enableglobalratelimit_desc'] = 'Korlátozás beállítása az egész portál által az OpenAI API-hoz óránként küldhető kérések számához.';
$string['enableuserratelimit'] = 'Felhasználszintű használati limit beállítása';
$string['enableuserratelimit_desc'] = 'Korlátozás beállítása az egyes felhasználók által az OpenAI API-hoz óránként küldhető kérések számához.';
$string['extraparams'] = 'További paraméterek';
$string['extraparams_help'] = 'Itt lehetséges további paramétereket megadni. A JSON formátum támogatott. Például:
<pre>
{
    "temperature": 0.5,
    "max_completion_tokens": 100
}
</pre>';
$string['globalratelimit'] = 'A portálszinten küldhető kérések maximuma';
$string['globalratelimit_desc'] = 'Az egész portál által óránként engedélyezett kérések száma.';
$string['invalidjson'] = 'Érvénytelen JSON string';
$string['orgid'] = 'OpenAI szervezeti azonosító';
$string['orgid_desc'] = 'Az OpenAI szervezeti azonosító megtalálható az <a href="https://platform.openai.com/account/org-settings">OpenAI Platform API fiók</a> oldalon.';
$string['orgid_help'] = 'Az OpenAI szervezeti azonosítóját megtalálja a saját <a href="https://platform.openai.com/account/org-settings" target="_blank">OpenAI fiók</a> oldalán.';
$string['pluginname'] = 'OpenAI API szolgáltató';
$string['privacy:metadata'] = 'Az OpenAI API szolgáltató segédprogram nem tárol semmilyen személyes adatot.';
$string['privacy:metadata:aiprovider_openai:externalpurpose'] = 'Ez az információ elküldésre kerül az OpenAI API-nak a válasz létrehozásához. Az OpenAI fiók beállításai felülírhatják, miként kezeli és tárolja ezen adatokat az OpenAI. Ez a plugin célzottan semmilyen felhasználói adatot nem küld az OpenAI-nak, és nem tárol el a Moodle LMS-ben sem.';
$string['privacy:metadata:aiprovider_openai:model'] = 'A válasz előállításához használt modell.';
$string['privacy:metadata:aiprovider_openai:numberimages'] = 'A képgenerálás során a válaszban használt képek száma.';
$string['privacy:metadata:aiprovider_openai:prompttext'] = 'A felhasználó által beírt szöveges prompt a válasz létrehozásához.';
$string['privacy:metadata:aiprovider_openai:responseformat'] = 'A válasz létrehozásának formátuma, képgenerálás esetén.';
$string['settings'] = 'Beállítások';
$string['settings_frequency_penalty'] = 'frequency_penalty';
$string['settings_frequency_penalty_help'] = 'Az „ismétlődés büntetése” beállítás szabályozza, milyen gyakran ismétlődnek egyes kifejezések. Minél nagyobb ez az érték, annál kevesebb ismétlődés lesz a létrehozott szövegben.';
$string['settings_help'] = 'A lenti beállítások módosításával szabályozható, miként kerülnek elküldésre a kérések az OpenAI-nak.';
$string['settings_max_completion_tokens_help'] = 'A létrehozott válaszban használt tokenek maximális száma.';
$string['settings_max_tokens'] = 'max_tokens';
$string['settings_max_tokens_help'] = 'A létrehozott válaszban használt tokenek maximális száma.';
$string['settings_presence_penalty'] = 'presence_penalty';
$string['settings_presence_penalty_help'] = 'A „jelenlét büntetése” beállítás arra ösztönzi a modellt, hogy új kifejezéseket használjon, növelve annak esélyét, hogy olyan szavakat használ, amiket korábban még nem. Nagyobb érték esetén a létrehozott szöveg változatosabb, kisebb érték esetén több ismétlődést fog tartalmazni.';
$string['settings_top_p'] = 'top_p';
$string['settings_top_p_help'] = 'top_p (nucleus mintavételezés) megadja a szóba jöhető lehetséges szavak számát. Nagyobb érték esetén (pl. 0.9) a modell több szóból válogat, így a létrehozott szöveg változatosabb lesz.';
$string['userratelimit'] = 'A felhasználószinten küldhető kérések maximuma';
$string['userratelimit_desc'] = 'Egy felhasználónak, egy órában engedélyezett kérések száma.';
