<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'hu', version '5.1'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Hozzáférés elutasítva';
$string['accountlocked'] = 'A fiók zárolva van. A feloldáshoz szükséges linket email-ben küldtük el.';
$string['accounts'] = 'Fiókok';
$string['accountunlocked'] = 'A fiók zárolása megszűnt. Most már bejelentkezhet.';
$string['addcategory'] = 'Kategória hozzáadása';
$string['additionalhtml'] = 'Kiegészítő HTML';
$string['additionalhtml_desc'] = 'Itt állíthatja be, milyen HTML szerepeljen minden oldalon. Megadhatja, milyen HTML szerepeljen az oldal HEAD címkéjében közvetlenül a BODY címke megnyitása után vagy a bezárása előtt.<br />Ezzel testre szabott fejlécet és láblécet használhat minden oldalon, illetve szolgáltatásokat, pl. a Google Analytics használatát támogathatja igen egyszerűen - a kiválasztott stílustól függetlenül.';
$string['additionalhtml_heading'] = 'Minden oldalhoz hozzáadandó kiegészítő HTML. ';
$string['additionalhtmlfooter'] = 'A BODY bezárása előtt';
$string['additionalhtmlfooter_desc'] = 'Az itt szereplő tartalom minden oldalhoz hozzáadódik a BODY bezárása előtt.';
$string['additionalhtmlhead'] = 'A HEAD-en belül';
$string['additionalhtmlhead_desc'] = 'Az itt szereplő tartalom minden oldalhoz hozzáadódik a HEAD címke aljához.';
$string['additionalhtmltopofbody'] = 'A BODY megnyitásakor';
$string['additionalhtmltopofbody_desc'] = 'Az itt szereplő tartalom minden oldalhoz hozzáadódik, közvetlenül a BODY címke megnyitása után.';
$string['admincategory'] = 'Kategória: {$a}';
$string['adminseesall'] = 'A rendszergazdák mindent látnak';
$string['adminseesallevents'] = 'A rendszergazdák minden eseményt látnak';
$string['adminseesownevents'] = 'A rendszergazdák nem különböznek a többi felhasználótól';
$string['advancedfeatures'] = 'További jellemzők';
$string['agedigitalconsentverification'] = 'Hozzájárulás digitális korának ellenőrzése';
$string['agedigitalconsentverification_desc'] = 'Lehetővé teszi a digitális hozzájárulási korhatár-ellenőrzést még az önregisztrációs beiratkozási oldal megjelenítése előtt. Ezzel megelőzhetjük, hogy kiskorúak szülői/gondviselői hozzájárulás nélkül regisztráljanak a portálra. A <a target="_blank" href="{$a}">Támogatói kapcsolat</a> részletei további segítségként jelennek meg.';
$string['ageofdigitalconsentmap'] = 'Digitális hozzájárulási korhatár';
$string['ageofdigitalconsentmap_desc'] = 'A digitális hozzájárulási korhatár alapértéke, és az adott országokban érvényes, az alapbeállítástól eltérő életkor. Az egyes korok megadása soronként: országkód, életkor (vesszővel elválasztva). Az alapbeállítás szerinti életkort az országkód helyén * jelzi. Az országkódokat az ISO 3166-2 írja elő.';
$string['allcountrycodes'] = 'Az összes országkód';
$string['allowattachments'] = 'Csatolmányok engedélyezése';
$string['allowbeforeblock'] = 'Először az engedélyezett lista feldolgozására kerül sor.';
$string['allowbeforeblockdesc'] = 'Alaphelyzetben először a zárolt IP-lista elemeinek párosítására kerül sor. Ezen funkció bekapcsolása esetén a zárolt  lista feldolgozása előtt történik az engedélyezett IP-lista elemeinek a feldolgozása.';
$string['allowcategorythemes'] = 'Kategóriastílusok engedélyezése';
$string['allowcohortthemes'] = 'Globális csoportstílusok engedélyezése';
$string['allowcoursethemes'] = 'Kurzusstílusok engedélyezése';
$string['allowedemaildomains'] = 'Engedélyezett e-mail-domének';
$string['allowediplist'] = 'Engedélyezett IP-lista';
$string['allowemailaddresses'] = 'Engedélyezett e-mail-domének';
$string['allowemojipicker'] = 'Hangulatjel-választó';
$string['allowframembedding'] = 'Keretbeágyazás engedélyezése';
$string['allowframembedding_help'] = 'Bekapcsolása esetén a portál egy távoli rendszerben keretbe ágyazható. Ez a \'Közzététel LTI-eszközként\' beiratkozási segédprogram használata esetén ajánlott. Egyéb esetben biztonsági okokból lehetőleg kerülendő. A mobil alkalmazás ezt a beállítást figyelmen kívül hagyja, a keretbe ágyazást pedig mindig engedélyezi.';
$string['allowguestmymoodle'] = 'Hozzáférés engedélyezése az Irányítópulthoz vendégek számára';
$string['allowindexing'] = 'Indexálás engedélyezése keresőgépek számára';
$string['allowindexing_desc'] = 'Ez határozza meg, engedélyezi-e, hogy a keresőgépek indexálják portálját. "Mindenhol" esetén a bejelentkező oldalakon is kereshetnek, így indexálják az előírt bejelentkezésű portálokat is.  A keresett bejelentkező oldalon előforduló levélszemét elkerülésére használja a "Bejelentkező oldalak kivételével mindenhol" lehetőséget. A "Sehol" tiltja a keresőgépek számára az összes weboldal indexálását. A beállítás csak egy címke a portál fejlécén: a keresőgép dönti el, hogy figyelembe veszi-e.';
$string['allowindexingeverywhere'] = 'Mindenhol';
$string['allowindexingexceptlogin'] = 'Bejelentkező oldalak kivételével mindenhol';
$string['allowindexingnowhere'] = 'Sehol';
$string['allowobjectembed'] = 'EMBED és OBJECT címke használatának engedélyezése';
$string['allowthemechangeonurl'] = 'Stílusmódosítások engedélyezése a webcímben';
$string['allowuserblockhiding'] = 'Felhasználók számára blokkok elrejtésének engedélyezése';
$string['allowusermailcharset'] = 'Felhasználók számára karakterkészlet kiválasztásának engedélyezése';
$string['allowuserswitchrolestheycantassign'] = 'Szerepváltás engedélyezése szerep-hozzárendelő funkcióval nem rendelkező felhasználók részére';
$string['allowuserthemes'] = 'Felhasználói stílusok engedélyezése';
$string['alternativefullnameformat'] = 'Másik formátum a teljes névhez';
$string['alternativefullnameformat_desc'] = 'Ez írja elő, hogyan jelenjenek meg a nevek a teljes nevet látó felhasználók (alapesetben a vezető, a tanár vagy a nem szerkesztő tanár) számára. A helyőrzők használata azonos a "Teljes név formátuma" beállításéval.';
$string['always'] = 'Mindig';
$string['appearance'] = 'Megjelenés';
$string['aspellpath'] = 'Útvonal az aspellhez';
$string['asyncbackupdisabled'] = 'A portálja jelenleg szinkron biztonsági mentéseket használ. Az aszinkron biztonsági mentések jobb felhasználói élményt biztosítanak, mert használatukkal lehetséges más műveleteket végezni, miközben a mentés vagy a helyreállítás zajlik. Minden Moodle 4.5 LTS vagy újabb portál aszinkron mentéseket használ. A szinkron mentések használatára a 4.5 LTS verziót követő Moodle rendszereknél nem lesz lehetőség.';
$string['authentication'] = 'Hitelesítés';
$string['authpreventaccountcreation'] = 'Fiók létrehozásának megakadályozása hitelesítés közben';
$string['authpreventaccountcreation_help'] = 'Egy felhasználó hitelesítésekor a portálon - ha még nincs - automatikusan létrejön egy fiók. Ha a hitelesítéshez külső adatbázist, pl. LDAP-t használ, de a hozzáférést már fiókkal rendelkező felhasználókra kívánja korlátozni, akkor ezt a funkciót be kell kapcsolnia. Új fiókokat kézzel vagy a felhasználó-feltöltési funkcióval hozhat létre. Ne feledje, hogy ez a beállítás nem érvényes MNet.hitelesítés esetén.';
$string['authsettings'] = 'Hitelesítés kezelése';
$string['autolang'] = 'Nyelv automatikus észlelése';
$string['autolangusercreation'] = 'Fiók létrehozása során használja a felhasználó böngészőjének a nyelvét';
$string['autologinguests'] = 'Vendégek automatikus beléptetése';
$string['availableto'] = 'Elérheti';
$string['availabletoanyone'] = 'A portál minden látogatójának elérhető';
$string['availabletoauthenticated'] = 'Bejelentkezett felhasználók számára';
$string['backgroundcolour'] = 'Áttetsző szín';
$string['backup_shortname'] = 'Kurzusnév használata a biztonsági mentés állománynevében';
$string['backup_shortnamehelp'] = 'Kurzusnév használata a biztonsági mentés állománynevében';
$string['backups'] = 'Biztonsági mentések';
$string['badwordsconfig'] = 'Adja meg a nem használható szavak vesszővel elválasztott jegyzékét.';
$string['badwordsdefault'] = 'Ha a testre szabott lista üres, a rendszer a nyelvi csomag alapbeállítás szerinti listáját fogja használni.';
$string['badwordslist'] = 'Nem használható szavak egyedi felsorolása';
$string['blockediplist'] = 'Blokkolt IP-lista';
$string['blockinstances'] = 'Előfordulások';
$string['blockmultiple'] = 'Többszöri';
$string['blockprotect'] = 'Példányok védelme';
$string['blockprotect_help'] = 'Ha zárol egy adott blokktípust, akkor ehhez senki sem adhat hozzá vagy törölhet példányokat. Szerkesztésükhöz oldja fel a zárat.

Ez alapvetően a navigációs és a beállítási blokkokat védi, amelyek visszaállítása véletlen törlés esetén igen körülményes lehet.';
$string['blockprotectblock'] = '{$a} példányok védelme';
$string['blockprotected'] = '{$a} blokk példányai védettek.';
$string['blocksettings'] = 'Blokkok kezelése';
$string['blockunprotectblock'] = '{$a} példányok védelmének feloldása.';
$string['blockunprotected'] = '{$a} blokk példányai nem védettek.';
$string['bloglevel'] = 'Blog láthatósága';
$string['bookmarkadded'] = 'Könyvjelző hozzáadva.';
$string['bookmarkalreadyexists'] = 'Ezt az oldalt már megjelölte.';
$string['bookmarkdeleted'] = 'Könyvjelző törölve.';
$string['bookmarkthispage'] = 'Az oldal megjelölése';
$string['cacheapplication'] = 'Alkalmazás gyorsítótára';
$string['cacheapplicationhelp'] = 'A gyorsítótárba helyezett elemeket az összes felhasználó eléri, időtartamát egy adott ttl szabja meg.';
$string['cachejs'] = 'Javascript gyorsítótárban futtatása';
$string['cachejs_help'] = 'A javascript gyorsítótárban futtatása és tömörítése nagyban javítja az oldalak betöltését, használata éles portálokon mindenképpen ajánlatos. Fejlesztők inkább kerülik a funkció használatát.';
$string['cacherequest'] = 'Gyorsítótár kérése';
$string['cacherequesthelp'] = 'Felhasználóhoz kötődő gyorsítótár, mely a kérés teljesítésekor ér véget. Statikus tárakat helyettesít.';
$string['cachesession'] = 'Munkafolyamat gyorsítótára';
$string['cachesessionhelp'] = 'Felhasználóhoz kötődő gyorsítótár, mely a munkafolyamat befejezésekor ér véget. A munkafolyamat lelassulását fékezi.';
$string['cachesettings'] = 'A gyorsítótár beállításai';
$string['cachetemplates'] = 'Sablonok gyorsítótárazása';
$string['cachetemplates_help'] = 'A sablonok gyorsítótárazása javítja az oldalbetöltési teljesítményt, használata éles portálokon kifejezetten ajánlott. A fejlesztők valószínűleg eltekintenek a használatától.';
$string['caching'] = 'Kezelés gyorsítótárban';
$string['calendar_weekend'] = 'Hétvége';
$string['calendarexportsalt'] = 'Naptárexportáló rejtjelbitek';
$string['calendarsettings'] = 'Naptár';
$string['calendartype'] = 'Naptár típusa';
$string['calendartype_desc'] = 'Válassza ki a naptár alaptípusát az egész portál számára. A beállítás módosítható a kurzusbeállításokban vagy a felhasználók saját profiljában';
$string['campaign'] = 'Kampány';
$string['cannotdeletemodfilter'] = 'A(z) \'{$a->filter}\' nem távolítható el, mert a(z) \'{$a->module}\' modul része.';
$string['cannotuninstall'] = 'A(z) {$a} nem távolítható el.';
$string['categoryemail'] = 'E-mail';
$string['cfgwwwrootslashwarning'] = 'A(z) $CFG->wwwroot hibásan van megadva config.php fájljában. Tartalmaz egy \'/\' karaktert a végén, amelyet törölni kell.';
$string['cfgwwwrootwarning'] = 'A(z) $CFG->wwwroot hibásan van megadva a config.php fájlban. Egyeznie kell azzal a webcímmel, amelyet a jelenlegi oldal eléréséhez használ.';
$string['change'] = 'módosítás';
$string['checkboxno'] = 'Nem';
$string['checkboxyes'] = 'Igen';
$string['checkupgradepending'] = 'Frissítés';
$string['choosefiletoedit'] = 'Válassza ki a szerkesztendő állományt';
$string['cleanup'] = 'Tisztítás';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'i';
$string['cliexitgraceful'] = 'Kilépés rövidesen...';
$string['cliexitnow'] = 'Kilépés RÖGVEST';
$string['cliincorrectvalueerror'] = 'Hiba, "{$a->value}" értéke "{$a->option}" esetén hibás';
$string['cliincorrectvalueretry'] = 'Hibás érték, próbálja újra.';
$string['clistatusdisabled'] = 'Állapot: kikapcsolva';
$string['clistatusenabled'] = 'Állapot: bekapcsolva';
$string['clistatusenabledlater'] = 'állapot: a  {$a} CLI karbantartási üzemmódját bekapcsolja';
$string['clitypevalue'] = 'érték beírása';
$string['clitypevaluedefault'] = 'érték beírása, Enter esetén alapérték ({$a}) használata';
$string['cliunknowoption'] = 'Ismeretlen paraméter: {$a}. Használja a --help paramétert.';
$string['cliupgradedefault'] = 'Új beállítás: {$a}';
$string['cliupgradedefaultheading'] = 'Új alapértékek beállítása';
$string['cliupgradedefaultverbose'] = 'Új beállítás: {$a->name}, alapérték: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'A parancssori frissítés  {$a->oldversion} verzióról {$a->newversion} verzióra sikerült.';
$string['cliupgrademaintenancenotrequired'] = 'Ez a frissítés NEM FOG karbantartási üzemmódot eredményezni a felhasználók számára.';
$string['cliupgrademaintenancerequired'] = 'Ez a frissítés KARBANTARTÁSI ÜZEMMÓDBA helyezi a felhasználókat.';
$string['cliupgradenoneed'] = 'A telepített {$a} verziót nem szükséges frissíteni.';
$string['cliupgradepending'] = 'Frissítés folyamatban';
$string['cliupgradesetlock'] = 'A frissítés csak CLI-s végrehajtás esetén lehetséges.';
$string['cliupgradeunsetlock'] = 'A meglévő CLI végrehajtásos frissítési korlátozás visszavonva.';
$string['cliyesnoprompt'] = 'írjon be i-t (igen) vagy n-t (nem)';
$string['close'] = 'Bezárás';
$string['cohort_customfield'] = 'Globális csoport mezők';
$string['commentsperpage'] = 'Oldalanként megjelenő megjegyzések száma';
$string['commonactivitysettings'] = 'Általános beállítások';
$string['commonfiltersettings'] = 'Általános szűrőbeállítások';
$string['commonsettings'] = 'Általános beállítások';
$string['componentinstalled'] = 'Összetevő telepítve';
$string['computedfromlogs'] = 'A(z) {$a} óta gyűjtött naplókból kiszámítva.';
$string['condifmodeditdefaults'] = 'Tevékenység vagy tananyag létrehozásakor a beállítási űrlapon alapértékek jelennek meg.';
$string['confeditorhidebuttons'] = 'Válassza ki a HTML-szerkesztőben elrejtendő gombokat.';
$string['configallcountrycodes'] = 'Ez a különféle helyeken, például a felhasználói profilban kiválasztható országok listája. Ha üresen hagyja (alaphelyzet), akkor az angol nyelvi alapcsomagban lévő felsorolás jelenik meg. Ez az ISO 3166-1 szerinti lista. Ellenkező esetben meghatározhat egy sor vesszővel elválasztott kódot, pl. GB,FR,ES. Ha új, nem szabvány szerinti kódokat ad meg, azokat hozzá kell adnia mind a nyelvi csomagjának megfelelő, mind az \'en\' countries.php állományhoz.';
$string['configallowassign'] = 'Válassza ki, hogy a bal oszlopban lévő szerepekkel rendelkezők mely szerepeket rendelhetik hozzá másokhoz.';
$string['configallowattachments'] = 'Bekapcsolása esetén a portálon keletkező e-mail üzenetekhez csatolmányok,  pl. kitűzők mellékelhetők.';
$string['configallowcategorythemes'] = 'Bekapcsolása esetén a stílusokat kategóriaszinten állíthatja be. Ez minden lentebbi kategóriára és kurzusra érvényes lesz, hacsak azokhoz nincs külön stílus beállítva. FIGYELEM: A kategóriastílusok bekapcsolása befolyásolhatja a teljesítményt!';
$string['configallowcohortthemes'] = 'Bekapcsolása esetén a stílusok globális csoport szintjén állíthatók. Ez csak az egy globális csoporthoz vagy az azonos stílushoz, de több csoporthoz tartozó felhasználókat érinti.';
$string['configallowcoursethemes'] = 'Ennek bekapcsolásakor a kurzusok önmaguk állíthatják be a stílusokat. A kurzusstílusok minden egyéb kiválasztott stílust (portál-, felhasználó-, csoport- vagy webcímstílust) felülírnak.';
$string['configallowedemaildomains'] = 'Sorolja föl a kimenő e-mail "Feladó" részében megjeleníthető e-mail-doméneket. Ha "Üres" az alapeset, akkor minden kimenő e-mail esetén Ne válaszolj címet ad meg. Helyettesítő karaktereket használhat, pl. *.example.com esetén az example.com aldoménről minden levelet beenged, de magáráról az example.com aldoménről nem: ahhoz külön bejegyzést kell készíteni.';
$string['configallowemailaddresses'] = 'Ha új e-mail-címeket konkrét doménekre kíván korlátozni, szóközökkel elválasztva sorolja fel őket itt. Minden egyéb domént a rendszer elutasít. Fődomén aldoménjeivel együtt való engedélyezéséhez kétszer adja meg a domént , az egyiket \'.\' előzze meg, pl. .intezmeny.hu intezmeny.hu.';
$string['configallowemojipicker'] = 'A hangulatjel-választóval az Atto eszköztáron lévő gombbal hangulatjeleket fűzhet az üzenetekhez és egyéb szövegterületekhez.';
$string['configallowemojipickerincompatible'] = 'A jelenlegi adatbázis-konfiguráció nem megfelelően támogatja hangulatjelek használatát. A hangulatjel-választó bekapcsolásához <a href="https://docs.moodle.org/en/MySQL_full_unicode_support">frissítse adatbázisát az Unicode teljes támogatására</a>.';
$string['configallowguestmymoodle'] = 'Bekapcsolása esetén a vendégek hozzáférnek  az Irányítópulthoz, ellenkező esetben visszakerülnek a portál címoldalára';
$string['configallowobjectembed'] = 'Biztonsági intézkedésként a tanulói szereppel bíró felhasználók nem ágyazhatnak be multimédiát a HTML szövegébe az EMBED és OBJECT tag-ekkel, de multimédia elemek továbbra is megjeleníthetők a multimédia segédprogram szűrővel. Ezen tag-ek engedélyezéséhez ezt a beállítást be kell kapcsolni.';
$string['configallowoverride'] = 'A bal oldalon lévő szerepekkel rendelkezők részére engedélyezheti egyes oszlopszerepek felülírását';
$string['configallowoverride2'] = 'Válassza ki, hogy a bal oszlopban lévő szerepekkel rendelkezők mely szerepeket írhatnak felül.<br />A felhasználóknak ehhez szükséges továbbá a moodle/role:override vagy a moodle/role:safeoverride képességgel is rendelkezniük kell.';
$string['configallowswitch'] = 'Válassza ki, hogy a bal oszlopban lévő szerepekkel rendelkezők mely szerepekre válthatnak át. Az átváltáshoz a felhasználóknak a moodle/role:switchroles képességgel is rendelkezniük kell.';
$string['configallowthemechangeonurl'] = 'Ha ezt a beállítást bekapcsolja, akkor a stílust bármely Moodle webcím esetén módosíthatja a theme={themename} hozzáadásával (pl.:  mymoodlesite.com/?theme=afterburner ) vagy <br />&theme=themename egy belső Moodle webcímre (pl.: mymoodlesite.com/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'A felhasználók az egész portálon elrejthetik/megjeleníthetik az oldalsó blokkokat? Ez a funkció javascript és sütik használatával emlékezik az egyes becsukható blokkok állapotára, és csak a felhasználó saját nézetére van hatással.';
$string['configallowusermailcharset'] = 'Bekapcsolásakor a felhasználó profilbeállításai között saját karakterkészletet állíthat be az e-mailhez.';
$string['configallowuserswitchrolestheycantassign'] = 'Alaphelyzetben a felhasználók a moodle/role:assign segítségével váltanak szerepet. Ennek bekapcsolása esetén ez a követelmény elhárul és a szerepek elérhetővé válnak a "Szerep átváltása erre..." lenyíló menüből, melyet csak a "Szerepek hozzárendelésének engedélyezése" táblázat beállításai határoznak meg. Ajánlatos elkerülni, hogy a "Szerepek hozzárendelésének engedélyezése" táblázat beállításai alapján a felhasználók meglévő szerepüknél szélesebb hatókörű szerepre váltsanak át.';
$string['configallowuserthemes'] = 'Ennek bekapcsolásakor a felhasználók beállíthatják saját stílusukat. A felhasználói stílusok felülírják a portálstílusokat (de a kurzusstílusokat nem).';
$string['configallowview'] = 'Válassza ki, hogy a bal oszlopban lévő szerepekkel rendelkezők mely szerepeket láthatnak, kereshetnek és szűrhetnek rá.';
$string['configallusersaresitestudents'] = 'A portál kezdőoldalán szereplő tevékenységekhez MINDEN felhasználó tanulónak tekintendő? Ha válasza "Igen", akkor minden jóváhagyott felhasználó tanulóként részt vehet ezekben a tevékenységekben. Ha válasza "Nem", akkor csak a legalább egy kurzusban már részt vevő felhasználók kapcsolódhatnak be a kezdőoldalon szereplő tevékenységekbe. A kezdőoldalon szereplő tevékenységeket illetően csak a rendszergazdák és a külön kijelölt tanárok vehetnek részt tanári minőségben.';
$string['configauthenticationplugins'] = 'Válassza ki a használni kívánt hitelesítő segédprogramokat és rendezze el őket végrehajtási sorrend szerint.';
$string['configautolang'] = 'Kikapcsolt portálbeállítás esetén az alapbeállítás szerinti nyelvet állapítsa meg a böngésző beállítása alapján.';
$string['configautolangusercreation'] = 'Bekapcsolása esetén ha első bejelentkezés alkalmával a felhasználói fiók automatikusan létrejön (pl. LDAP vagy OAuht 2 hitelesítés esetén), akkor a böngésző nyelvét állítja be alapnyelvként. Ellenkező esetben a portál alapnyelve lesz a felhasználó választott nyelve.';
$string['configautologinguests'] = 'A látogatók automatikusan vendégként lépjenek-e be, ha valamely kurzusba vendégként jelentkeznek be?';
$string['configbloglevel'] = 'Ezzel a beállítással korlátozhatja, mely felhasználói blogokat lehet megtekinteni ezen a portálon. Ezzel a blog MEGTEKINTÉSÉNEK tartalmát szabja meg, nem annak feladóját vagy a blogüzenetek típusait. A blogokat teljes egészében kikapcsolhatja, ha egyáltalán nem akarja őket használni.';
$string['configcalendarcustomexport'] = 'Naptár egyéni adattartományként való exportálásának bekapcsolása';
$string['configcalendarexportsalt'] = 'Ez a véletlenszerűen előálló szöveg a naptárexportáláshoz használt hitelesítő tokenek biztonságosságát fokozza. Ha ezeket a rejtjelbiteket módosítja, minden jelenlegi token érvénytelenné válik.';
$string['configcookiesecure'] = 'Ha a szerver csak https-kapcsolatot fogad el, akkor ajánlott bekapcsolni a biztonságos sütik küldését. Bekapcsolása esetén ügyeljen arra, hogy a webszerver ne fogadjon el http://-t, vagy állítson be állandó https://-címre való átirányítást és ha lehet, küldjön HSTS-fejléceket. Ha a <em>wwwroot</em> címe nem https:// kezdetű, akkor a beállítást figyelmen kívül hagyja.';
$string['configcountry'] = 'Ha itt egy ország van megadva, akkor az új felhasználók esetén alaphelyzetben ez az ország lesz a kiválasztott ország. A választás előírásához hagyja ezt a helyet üresen.';
$string['configcoursegraceperiodafter'] = 'Régi kurzusok besorolása a kurzus vége után még ennyi napon át tartóként.';
$string['configcoursegraceperiodbefore'] = 'Régi kurzusok besorolása a kurzus vége után még ennyi napon át tartóként.';
$string['configcourseoverviewfilesext'] = 'Az engedélyezett kurzusképfájlok kiterjesztéseinek vesszővel elválasztott listája';
$string['configcourseoverviewfileslimit'] = 'A kurzuslista oldalán a kurzusösszegzés mellett megjeleníthető állományok maximális száma. Az elsőként hozzáadott képfájl lesz az Irányítópulton a kurzusáttekintő kurzusképe; az esetleges további állományok  csak a kurzuslista oldalán látszanak.';
$string['configcourserequestnotify'] = 'Adja meg az új kurzus kérésekor értesítendő felhasználó felhasználói nevét.';
$string['configcourserequestnotify2'] = 'Kurzuskérés esetén értesített felhasználók. A listán csak a kurzuskérést jóváhagyó felhasználók jelennek meg.';
$string['configcoursesperpage'] = 'Kurzusok oldalankénti számának megadása a kurzuslista megjelenítéséhez.';
$string['configcourseswithsummarieslimit'] = 'Kurzuslistán megjelenítendő kurzusok maximális száma összegzésekkel együtt';
$string['configcronclionly'] = 'A cron böngészőből futtatása esetén névtelen felhasználók bizalmas adatok juthatnak a tudomásukra. Ezért vagy csak a parancssorból futtassa a crfont, vagy állítson be jelszót a távoli eléréshez.';
$string['configcronremotepassword'] = 'Ez azt jelenti, hogy a cron.php kód böngészőből nem futtatható az alábbi formájú webcím:<pre>      http://site.example.com/admin/cron.php?password=opensesame </pre> segítségével megadott jelszó nélkül. Ha üresen hagyja, nem lesz szükség jelszóra.';
$string['configcurlcache'] = 'A cURL gyorsítótár működési ideje másodpercekben.';
$string['configcustommenuitems'] = 'Itt egy egyéni menü állítható be. Minden menüelem új sorként kerüljön be, az alábbi formában: menü felirata, URL hivatkozás (választható, de nem almenükkel rendelkező főmenü elem esetén), tooltip (választható) és nyelvi kód vagy vesszőkkel elválasztott kódlistát  (választható, a sor megjelenítése csak a megadott nyelvet használóknak), mind egy-egy függőleges vonal karakterrel elválasztva egymástól. A kötőjellel kezdődő sorok az előző főmenü elemeiként jelennek meg, elhatároláshoz a ### karaktersor  használható. Például:
<pre>
Kurzusok
-Az összes kurzus|/course/
-Kurzuskeresés|/course/search.php
-###
-GYIK|https://webcím.xyz/gyik
-Spanyol GYIK|https://webcím.xyz/pmf||es
Mobil alkalmazás|https://webcím.xyz/app|Alkalmazásunk letöltése
</pre>';
$string['configcustomusermenuitems'] = 'A felhasználói menü tartalmát beállíthatja  (az automatikusan hozzáadott kilépési hivatkozást kivéve). A sorokat | választja el, felépítésük: 1) "langstringname, componentname" formájú vagy egyszerű szöveg és 2) egy webcím. A választójelek adott esetben megadhatók egy külön sorba írt egy vagy több # karakterrel.';
$string['configdbsessions'] = 'Bekapcsolásakor ez a beállítás a pillanatnyi eseményekről szóló adatokat adatbázisban tárolja. Ne feledje, hogy a beállítás módosítása esetén minden belépett felhasználót a rendszer kiléptet (Önt is beleértve). Ha MySQL-t használ, a my.cnf-ben (vagy my.ini-ben) a  \'max_allowed_packet\' legalább 4 MB legyen. A többi eseményvezérlő közvetlenül a config.php-ben állítható be, lásd: config-dist.php. Ez a lehetőség eltűnik, ha az eseményvezérlőt a config.php-ben állítja be.';
$string['configdebug'] = 'Bekapcsolt állapotban a PHP hibajelentése bővebb lesz, azaz több figyelmeztetést nyomtat ki. Ez csak a fejlesztőknek hasznos.';
$string['configdebugdisplay'] = 'Bekapcsolása esetén a hibajelentések a HTML-oldalra kerülnek. Noha ez egy praktikus megoldás, általában véve tönkreteszi az XHTML-t, a JS-t, a sütiket és a HTTP-fejléceket. Kikapcsolása esetén a hibajelentéseket a szervernaplóba küldi, így jobb hibaelhárítást tesz lehetővé. A PHP error_log beállítása határozza meg, hogy ez melyik naplóba kerül.';
$string['configdebugpageinfo'] = 'Ha bekapcsolja, az oldal láblécén megjelennek az oldallal kapcsolatos információk.';
$string['configdebugvalidators'] = 'Ha bekapcsolja, az oldal láblécén hivatkozások jelennek meg a külső validálóhoz. Előfordulhat, hogy új felhasználót kell létrehoznia <em>w3cvalidator</em> névvel és engedélyeznie kell a vendégként való hozzáférést.A módosítások jogosulatlan szerverelérést tehetnek lehetővé. éles portálon ne kapcsolja be!';
$string['configdefaulthomepage'] = 'Hova kerüljenek a felhasználók belépés után? Ez a beállítás határozza meg Classic alapú séma felhasználói számára az első navigációs hivatkozást is.';
$string['configdefaultrequestcategory'] = 'A rendszerkörnyezetben új kurzusok kérésére jogosult felhasználók által kért kurzusok ebbe a kategóriába kerülnek, ha nem választhatnak egy másik kategóriát.';
$string['configdefaultrequestedcategory'] = 'Alapkategória az igényelt kurzusok elhelyezésére, amennyiben megtörténik jóváhagyásuk.';
$string['configdefaultuserroleid'] = 'Minden belépett felhasználó megkapja az itt megadott szerephez tartozó portálszintű jogosultságokat, az esetleges EGYÉB szerepei mellett. Az alapbeállítás a hitelesített felhasználói szerep. Ne feledje, hogy ez nem ütközik többi szerepükkel, csak biztosítja, hogy minden felhasználó rendelkezzen olyan lehetőségekkel, amelyek kurzusszinten nem rendelhetők hozzá (pl. blogüzeneteket helyezhetnek el, saját naptárukat kezelhetik stb.).';
$string['configdeleteincompleteusers'] = 'Ezen idő eltelte után minden utónév, családi név vagy e-mail nélkül beállított fiókot töröl a rendszer.';
$string['configdeleteunconfirmed'] = 'Egyes hitelesítési módszerek esetén a felhasználónak bizonyos időn belül meg kell erősítenie a fiókját. Ezen idő elteltével a korábbi, meg nem erősített felhasználói azonosítókat törli a rendszer.';
$string['configdenyemailaddresses'] = 'Ha nem kíván konkrét doménekről e-mailt fogadni, ugyanúgy sorolja fel őket itt. Minden egyéb domént a rendszer elfogad. Aldomének elutasításához a domént \'.\'-vel adja meg. Pl. hotmail.com yahoo.co.uk.';
$string['configdisableuserimages'] = 'Felhasználói profilkép módosításának tiltása felhasználók számára.';
$string['configdisplayloginfailures'] = 'Ez tájékoztatja a felhasználókat a korábbi sikertelen belépésekről.';
$string['configdndallowtextandlinks'] = 'Szöveg és hivatkozások kurzusoldalra való elhúzásának ki-be kapcsolása, állományok elhúzásával együtt. Vegye figyelembe, hogy Firefox esetén és böngészők között a szöveg átemelése nem megbízhatóan működik!';
$string['configdoclang'] = 'Ez a nyelv lesz használatos a dokumentációs oldalak hivatkozásaihoz.';
$string['configdocroot'] = 'Megadja a Moodle Docs elérési útvonalát az oldalak láblécében található, az adott kontextusnak megfelelő dokumentáció eléréséhez, "Az oldal dokumentációja" hivatkozás formájában . Ha üresen marad, nem jelennek meg a hivatkozások.';
$string['configdoctonewwindow'] = 'Ennek bekapcsolásakor a Moodle Docs hivatkozásai új ablakban jelennek meg.';
$string['configduration_high'] = 'A megadott érték túl magas. A maximum érték {$a}.';
$string['configduration_low'] = 'A megadott érték túl alacsony. A minimum érték {$a}.';
$string['configeditordictionary'] = 'A rendszer ezt az értéket használja, ha az aspell nem rendelkezik a felhasználó nyelve szerinti szótárral.';
$string['configeditorfontlist'] = 'Válassza ki a szerkesztő lenyíló listáján megjelenítendő betűfajtákat.';
$string['configemailchangeconfirmation'] = 'E-mailben való megerősítést ír elő, ha a felhasználók profiljukban módosítják e-mail címüket.';
$string['configemaildkimselector'] = 'A DKIM-választó használata önkényes, DNS-rekordjainak illeszkedniük kell ehhez.';
$string['configemailfromvia'] = 'A kimenő e-mail "Feladó" részében útvonalra vonatkozó adatot ad hozzá. Ez tájékoztatja a címzettet, hogy honnan jött az e-mail, továbbá kezeli a Ne válaszolj címre véletlenül válaszolók helyzetét.';
$string['configemailheaders'] = 'Minden kimenő e-mailhez szó szerint hozzáadandó nyers fejléc.';
$string['configemailsubjectprefix'] = 'Minden kimenő levél tárgysorához fűzendő szöveg';
$string['configenableanalytics'] = 'Az olyan analitikai modellek, mint a \'Kimaradás veszélyének kitett tanulók\' vagy az \'Esedékes elkövetkező tevékenységek\' segítségével jóslások készíthetők, értesítések küldhetők és további lépések - pl. üzenetküldés felhasználóknak - kezdeményezhetők.';
$string['configenableblogs'] = 'Ez a kapcsoló minden portált használó számára saját blogot biztosít.';
$string['configenablecalendarexport'] = 'Exportálás vagy naptárak előjegyzésének engedélyezése.';
$string['configenablecomments'] = 'Megjegyzések engedélyezése';
$string['configenablecourserequests'] = 'Bekapcsolása esetén az új kurzusok kérésére (moodle/course:request) jogosult felhasználók kurzust igényelhetnek. A jogosultsággal az alapszerepek nincsenek felruházva. Rendszer- vagy kategóriakörnyezetben alkalmazható.';
$string['configenablemobilewebservice'] = 'A mobil webszolgáltatások szükségesek a Moodle-alkalmazáshoz. Ha a portálja HTTPS-t használ, ezek alapértelmezetten be vannak kapcsolva. További információk: {$a}.';
$string['configenablerssfeeds'] = 'Bekapcsolása esetén a portálon különféle RSS-hírek készülnek, pl. blogokról. fórumokról. adatbázis-tevékenységekről és szójegyzékekről. A változások megjelenítéséhez az egyes tevékenységmodulokban is be kell kapcsolni az RSS-híreket';
$string['configenablerssfeedsdisabled'] = 'Nem elérhető, mert az RSS-hírek az egész portálon ki vannak kapcsolva. Bekapcsolásukhoz térjen át a Portálkezelés alatt a Változók beállítása pontra.';
$string['configenablerssfeedsdisabled2'] = 'Az RSS-hírek portálszinten ki vannak kapcsolva. Kapcsolja be a Speciális funkciók / Portálkezelés menüpontban.';
$string['configenablestats'] = 'Ha ezt bekapcsolja, a Moodle cronjob programja feldolgozza a naplókat és statisztikát állít elő. A portál forgalmától függően ez sok időt vehet igénybe. Használata esetén az egyes kurzusokról vagy az egész portálról érdekes grafikonokat és statisztikákat tekinthet meg.';
$string['configenabletrusttext'] = 'Alaphelyzetben a Moodle a felhasználóktól érkező szövegeket mindig gondosan megtisztítja a biztonságot veszélyeztető esetleges hibás kódtól, médiafájloktól stb. A megbízható tartalom rendszerével a megbízhatónak tekintett felhasználóknak engedélyezheti ezen fejlettebb funkciók ütközésmentes használatát. A rendszer bekapcsolásához először jelölje be ezt a beállítást, majd rendeljen megbízható tartalom szerinti engedélyt egy konkrét Moodle-szerephez.  Az ilyen felhasználók által létrehozott vagy feltöltött szövegek megbízható jelölést kapnak és megjelenítésük előtt nem esnek át a tisztítási folyamaton.';
$string['configenablewebservices'] = 'A webszolgáltatások lehetővé teszik egyéb rendszerek, pl. a Moodle alkalmazás számára, hogy belépjenek erre a portálra és műveleteket hajtsanak végre. A biztonság érdekében ezt célszerű kikapcsolni, ha nem használja az alkalmazást vagy egy olyan külső eszközt/szolgáltatást, amely a webszolgáltatások integrálását írja elő.';
$string['configenablewsdocumentation'] = 'Bekapcsolása esetén a webszolgáltatások dokumentációja automatikusan előállítódik. A felhasználó saját dokumentációját biztonsági kulcsainak {$a} oldalán érheti el. Csak a bekapcsolt protokollok dokumentációját jeleníti meg.';
$string['configerrorlevel'] = 'Válassza ki, hány PHP-figyelmeztetés jelenjen meg. A Szokásos kiválasztása rendszerint a legjobb megoldás.';
$string['configexportlookahead'] = 'Exportálás közbeni előretekintés napjainak száma';
$string['configexportlookback'] = 'Exportálás közbeni visszatekintés napjainak száma';
$string['configextendedusernamechars'] = 'Ezt bekapcsolva a felhasználónevekben (a nagybetűk kivételével) bármilyen karakter szerepelhet. Ellenkező esetben a felhasználónév csak kisbetűket, számokat, aláhúzást (_), kötőjelet (-), pontot (.) vagy kukacot (@) tartalmazhat.';
$string['configextramemorylimit'] = 'Egyes programkódoknak (pl. keresés, mentés/helyreállítás, cron) nagyobb memóriára van szükségük. Nagy portál esetén állítson be magasabb értékeket.';
$string['configfilterall'] = 'Minden szövegsor szűrése, beleértve a fejléceket, a címeket, a navigációs sávot stb. Bekapcsolása akkor hasznos, ha a multilang szűrőt használja, egyéb esetben csak növeli a portál leterhelését.';
$string['configfiltermatchoneperpage'] = 'Automatikusan kapcsoló szűrők esetén csak az oldalon a szöveg első előfordulásához áll elő kapcsolat. Az összes többit a rendszer figyelmen kívül hagyja.';
$string['configfiltermatchonepertext'] = 'Automatikusan kapcsoló szűrők esetén az oldalon csak az egyes szövegek első előfordulásához áll elő kapcsolat. Az összes többit a rendszer figyelmen kívül hagyja. Ezt a beállítást figyelmen kívül hagyja, ha a fenti \'Oldalanként egy...\' beállítás érvényes.';
$string['configfilternavigationwithsystemcontext'] = 'A szűrés normál használata a kontextushoz kötődik, amelyben használják (pl. kurzus kontextus), de a webhely navigációjához a "tartalom és címsorok" szűrésének explicit módon a webhely kontextusával történő szűrése teljesítményjavulást eredményezhet.';
$string['configfilteruploadedfiles'] = 'Minden feltöltött HTML- és szöveges állományt, csak a feltöltött HTML-állományokat, illetve egyetlen állományt se dolgozzon fel a szűrőkkel, mielőtt megjelennének.';
$string['configforcelogin'] = 'A portál kezdőoldalát és a kurzuslistákat (de nem a kurzusokat) bárki megtekintheti anélkül, hogy belépne a portálra. Ha azt szeretné, hogy a portálra látogatók ELŐSZÖR lépjenek be, ezt a beállítást be kell kapcsolni.';
$string['configforceloginforprofiles'] = 'Ezzel a beállítással érhető el, hogy a bejelentkezőknek ne vendégként, hanem valódi felhasználónévvel kelljen belépni, mielőtt valamely felhasználói profilt megtekintenének. Ha ezt a beállítást kikapcsolta, előfordulhat, hogy egyes felhasználók hirdetést (levélszemetet) vagy egyéb, oda nem illő tartalmat tesznek közzé profiljukban, amely így az egész világ számára láthatóvá válik.';
$string['configfrontpage'] = 'A fent kiválasztott elemek megjelennek a portál kezdőoldalán.';
$string['configfrontpagecourselimit'] = 'A kurzusok maximális száma';
$string['configfrontpagecourselimithelp'] = 'A portál nyitóoldalán a kurzusok felsorolásában megjelenő kurzusok maximális száma';
$string['configfrontpageloggedin'] = 'A fent kiválasztott elemek megjelennek a portál kezdőoldalán, ha egy felhasználó bejelentkezik.';
$string['configfullnamedisplay'] = 'Itt adható meg a megjelenő nevek alakja.  A "language" alapértéke szerinti nyelvi csomagban a "fullnamedisplay" határozza meg. Egyes nyelvekben a nevek másként jelenhetnek meg.

Az egynyelvű portálok esetén a legmegfelelőbb beállítás az alapértelmezett \'Vezetéknév + Keresztnév\', de dönthet úgy, hogy a vezetéknevek egyáltalán ne jelenjenek meg, vagy dönthet erről az adott nyelvi csomag alapján is (egyes nyelvekben az elrendezés ettől eltérő lehet). Használható helyőrzők: firstname, lastname, firstnamephonetic, lastnamephonetic, middlename és alternatename.';
$string['configgeoipfile'] = 'A  GeoLite2 City bináris adatállomány helye. Az állomány nem része a Moodle-csomagnak, külön kell beszerezni a <a href="http://www.maxmind.com/">MaxMind</a>-tól. Megvásárolhatja a kereskedelmi változatot vagy használhatja az ingyeneset. Az adatbázis letöltéséhez regisztráljon a <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a> oldalon, majd töltse le az állományt és csomagolja ki szervere "{$a}" könyvtárába.';
$string['configgetremoteaddrconf'] = 'Ha szervere egy fordított gyorsítótár mögött van, ezzel a beállítással megadhatja, mely HTTP-fejlécek tartalmazhatják a megbízható távoli IP-címet. A fejlécek beolvasása sorrendben történik, kezdve az első elérhetővel.';
$string['configgradebookroles'] = 'Ezzel a beállítással szabályozhatja, ki szerepeljen az értékelésnaplóban. A felhasználóknak adott kurzusban legalább ezen szerepek egyikével kell rendelkezni ahhoz, hogy megjelenjenek a kurzus értékelésnaplójában.';
$string['configgradeexport'] = 'Válassza ki, mely formátumú értékelésnaplók lesznek az értékelések exportálására használt elsődleges módszerek. A kiválasztott segédprogramok minden értékelés esetén az \'utoljára exportált\' mezőt fogják beállítani és használni. Az exportált rekordok azonosítója ennek alapján lehet például \'új\' vagy \'frissített\'. Ha bizonytalan, hagyjon mindent bejelöletlenül.';
$string['configgradeexportdefault'] = 'Válassza ki, hogy melyik értékelésnapló formátum legyen az alapértelmezett módszer az értékelések exportálásához.';
$string['confighiddenuserfields'] = 'Válassza ki, milyen információt tartalmazó mezőket kíván elrejteni a tanárokon/rendszergazdákon kívül minden egyéb felhasználó elől. Ezzel növelheti a tanulók adatainak titkosságát. A CTRL lenyomásával egyszerre több mezőt választhat ki.';
$string['configidnumber'] = 'Ezzel az opcióval adható meg, hogy (a) a felhasználóktól kell-e egyáltalán azonosítószámot kérni, (b) a felhasználóktól kér a rendszer azonosítószámot, de üresen hagyhatják, illetve (c) a felhasználóktól a rendszer azonosítószámot kér, ők pedig ezt nem hagyhatják üresen. Ha van megadva, akkor a felhasználói azonosítószám megjelenik a profiljukban.';
$string['configintro'] = 'Ezen az oldalon adhatók meg olyan beállítási változók, amelyekkel a Moodle megfelelően működhet az adott szerveren. Nem szükséges a beállítással sokat vesződni, az alapbeállítások rendszerint megfelelnek, emellett bármikor vissza lehet térni erre az oldalra és módosítani lehet a beállításokon.';
$string['configintroadmin'] = 'Ezen az oldalon kell megadni a fő rendszergazdát, aki ezt követően az egész portál fölött rendelkezik majd. Ügyeljen arra, hogy a felhasználónév és a jelszó biztonságos, az e-mail cím pedig valóságos legyen. Később további rendszergazdákat adhat meg.';
$string['configintrosite'] = 'Ezen az oldalon állíthatja be a kezdőoldalt és az új portál nevét. Később bármikor visszatérhet ide és módosíthatja a beállításokat a honlap portálkezelési menüivel.';
$string['configiplookup'] = 'Ha a naplózásokhoz hasonlóan egy IP-címre kattint (pl. 34.12.222.93), egy térkép jelenik meg, amely megbecsüli, hol található az adott IP.  Különféle segédprogramok közül választhat, melyek más-más előnyökkel és hátrányokkal rendelkeznek.';
$string['configkeeptagnamecase'] = 'Jelölje be, ha meg szeretné tartani a felhasználók által eredetileg megadott kis- és nagybetűket.';
$string['configlang'] = 'Válasszon egy alapértelmezett nyelvet a teljes portál számára. A felhasználók ezt a beállítást a nyelvi menüben vagy személyes profiljukban felülírhatják.';
$string['configlanglist'] = 'Ha ezt üresen hagyja, a felhasználók a Moodle adott telepítéséből elérhető bármely nyelvet választhatják. A nyelvi menüt lerövidítheti, ha vesszővel elválasztva itt felsorolja a kívánt nyelvek kódjait. Például:  en,es_es,fr,it, en_kids,de_kids.';
$string['configlangmenu'] = 'Itt adja meg, hogy megjelenjen-e az általános nyelvi menü a honlapon, a belépési oldalon stb. Ez nem korlátozza a felhasználókat abban, hogy a nekik megfelelő nyelvet saját profiljukban beállítsák.';
$string['configlangstringcache'] = 'Az adatkönyvtárban az összes nyelvi szöveget lefordított fájlokká alakítja a gyorsítótárhoz. Ha a Moodle-t fordítja vagy annak forráskódját módosítja, ezt kikapcsolhatja. Ellenkező esetben a jobb teljesítmény érdekében hagyja bekapcsolva.';
$string['configlatinexcelexport'] = 'Válassza ki az Excel-exportálás kódolását.';
$string['configlocale'] = 'Válasszon egy egész portálra érvényes nyelvterületet - ez befolyásolja a dátumok formáját és nyelvét. Ehhez az adott operációs rendszerben a nyelvterületre vonatkozó adatoknak már telepítve kell lenni (linux esetén pl. en_US vagy es_ES). A legtöbbször ezt a mezőt célszerű üresen hagyni.';
$string['configlockrequestcategory'] = 'Bekapcsolása esetén a rendszerkörnyezetben új kurzusok igénylésére jogosult felhasználók a kurzusigénylő űrlapon nem választhatnak kategóriát. Az új kurzus kérésére jogosult felhasználók egyetlen kategóriára való korlátozásának másik módja, ha az új kurzusok igénylését kategóriakörnyezethez köti.';
$string['configloglifetime'] = 'Itt adható meg a felhasználói aktivitás naplózásának megőrzési ideje. Az ennél régebbi naplókat a rendszer automatikusan törli. Érdemes a naplókat a lehető leghosszabb ideig megőrizni, mert szükség lehet rájuk. Ha viszont túlságosan nagy a szerver forgalma és gondok merülnek fel a teljesítménnyel kapcsolatban, akkor csökkentheti a naplómegőrzés időtartamát. A statisztika megfelelő működése érdekében azonban 30-nál alacsonyabb értéket nem célszerű megadni.';
$string['configlookahead'] = 'Előrenézési napok száma';
$string['configmailnewline'] = 'Levélüzenetekben használt újsor-karakterek. A CRLF használatát az RFC 822bis írja elő, egyes levelező szerverek automatikusan végrehajtják az LF-ről CRLF-re való átalakítást, más levelező szerverek hibásan alakítják át a CRLF-et CRCRLF-re, és vannak olyanok, amelyek elutasítják a sima LF-et tartalmazó leveleket (például a qmail). Próbálja meg módosítani ezt a beállítást, ha gondja van a kézbesítetlen levelekkel vagy a kettős új sorokkal.';
$string['configmaxbytes'] = 'Itt adható meg a teljes portálra vonatkozóan a feltöltött állományok maximális mérete. Ezt a beállítást a PHP post_max_size  és upload_max_filesize, és az Apache LimitRequestBody beállítása határolja be. Ugyanakkor a maxbytes a kurzusszinten vagy a tevékenységszinten választható méreteket korlátozza. Ha a \'Portál feltöltési korlátja\' lett kiválasztva, a rendszer a szerver által engedélyezett maximumot fogja figyelembe venni.';
$string['configmaxconsecutiveidentchars'] = 'A jelszavak legfeljebb ennyi egymás után következő azonos karakterből állhatnak. Az ellenőrzést a 0-t választva kapcsolhatja ki.';
$string['configmaxeditingtime'] = 'Ez adja meg azt az időt, amely alatt még lehet fórumüzeneteket, naplóvisszajelzéseket stb. újraszerkeszteni. Rendszerint egy 30 perces időtartam megfelelőnek mondható.';
$string['configmaxevents'] = 'Előrenézés eseményei';
$string['configmaxusersperpage'] = 'A felhasználói kiválasztó modulban megjelenítendő felhasználók max. száma kurzus, csoport, globális csoport, webszolgáltatás stb. esetén';
$string['configmessaging'] = 'Bekapcsolása esetén a portál felhasználói üzenetet küldhetnek egymásnak.';
$string['configmessagingallowemailoverride'] = 'E-mail értesítések a felhasználói profilban szereplőtől eltérő címre küldésének engedélyezése.';
$string['configmessagingallusers'] = 'Bekapcsolása esetén a felhasználók láthatják a portál minden felhasználójának a listáját és üzenetküldési beállításait, ha valakit üzenetküldésre kiválasztanak, és ha be van jelölve az üzenetek fogadása a portálon bárkitől. Egyébként a felhasználók számára csak kétféle üzenetküldési beállításra van lehetőség: üzenetek fogadása a velük kapcsolatban lévőktől, illetve emellett a kurzus bármely résztvevőjétől.';
$string['configmessagingdefaultpressenter'] = 'A felhasználók üzenetküldő beállításaiban alapesetben be van-e kapcsolva a \'Küldés Enterrel\'.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Helytakarékosság érdekében törölheti az olvasott és olvasatlan értesítéseket. Létrehozásuk után mennyi idővel legyenek törölhetők?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Az elolvasott értesítések helytakarékosság céljából törölhetők. Az olvasás és a törlés között mennyi idő teljen el?';
$string['configminpassworddigits'] = 'A jelszavakban legalább ennyi számjegynek kell szerepelni.';
$string['configminpasswordlength'] = 'A jelszavakban legalább ennyi karakternek kell szerepelni.';
$string['configminpasswordlower'] = 'A jelszavakban legalább ennyi kisbetűnek kell szerepelni.';
$string['configminpasswordnonalphanum'] = 'A jelszavakban legalább ennyi nem alfanumerikus karakternek kell szerepelni.';
$string['configminpasswordupper'] = 'A jelszavakban legalább ennyi nagybetűnek kell szerepelni.';
$string['configmypagelocked'] = 'Ezzel megakadályozza, hogy az alapoldalt rendszergazdákon kívül mások szerkeszthessék.';
$string['confignavcourselimit'] = 'Korlátozza a navigáló felhasználó számára a megjelenő kurzusok számát.';
$string['confignavshowallcourses'] = 'Beállítása esetén a felhasználók az általuk felvett kurzusokat mind a Kurzusok ágon, mind a Kurzusaim alatt látni fogják.';
$string['confignavshowcategories'] = 'A navigációs sávon és a navigációs blokkokban látsszanak a kurzuskategóriák. Ez nem fordul elő azon kurzusok esetén, amelyeket a felhasználó felvett, ugyanakkor kategóriák nélkül megjelennek a Kurzusaim alatt.';
$string['confignoreplyaddress'] = 'E-maileket esetenként egy felhasználó nevében továbbít a rendszer (pl. fórumüzenetek). Az itt megadott e-mail cím jelenik meg mint \'Feladó\' azon esetekben, amikor a címzettek nem válaszolhatnak közvetlenül a felhasználónak (például amikor a felhasználó úgy dönt, hogy címét nem hozza nyilvánosságra).';
$string['confignotifyloginfailures'] = 'A belépési hibáról ezeknek a kiválasztott felhasználóknak küldjön értesítés. Ehhez a belső logstore-t (pl.  Standard Logstore) be kell kapcsolni.';
$string['confignotifyloginthreshold'] = 'Ha a sikertelen belépésekről szóló értesítés be van kapcsolva, egy felhasználótól vagy egy IP-címről hány sikertelen belépés után kerüljön sor az értesítésre?';
$string['confignotloggedinroleid'] = 'A portálra be nem lépett felhasználókat úgy tekinti a rendszer, mint akik a portálon ezzel a szereppel rendelkeznek.  Legtöbbször a vendégként való kezelés megfelelő, de létrehozhat ennél bővebb vagy szűkebb jogosultságot biztosító szerepeket.  Például az üzenetküldés továbbra is csak megfelelő belépés esetén engedélyezett.';
$string['configopentowebcrawlers'] = 'Ezen beállítás bekapcsolásakor a Google-lal vendégként léphet be a portálra. Emellett a Google-keresés révén a portálra eljutók automatikusan vendégként tudnak bejelentkezni. Ne feledje, hogy ez csak azon kurzusokhoz biztosít követhető hozzáférést, amelyek engedélyezik vendégek belépésé.';
$string['configoverride'] = 'A config.php definiálja';
$string['configpasswordpolicy'] = 'Bekapcsolásakor a Moodle a jelszavakat az alábbi beállításokban megadott jelszószabvány szempontjából ellenőrzi. A jelszószabvány bekapcsolása a meglévő felhasználókat mindaddig nem érinti, amíg nem kívánják/kényszerülnek módosítani a jelszavukat, illetve ha a \'Jelszó ellenőrzése belépéskor\' be van kapcsolva.';
$string['configpasswordpolicycheckonlogin'] = 'Bekapcsolásakor a Moodle a jelszavakat belépéskor a jelszószabvány szempontjából ellenőrzi. Ha az ellenőrzés sikertelen, továbblépés előtt a felhasználónak módosítania kell a jelszavát. A jelszószabvány frissítése után célszerű ezt bekapcsolni.';
$string['configpasswordresettime'] = 'Ennyi idő alatt lehet egy jelszó-visszaállítási kérelmet érvényesíteni. Általában 30 perc elegendő.';
$string['configpathtodu'] = 'Útvonal a du-hoz. Például /usr/bin/du. Megadásakor a könyvtártartalmakat mutató oldalak sokkal gyorsabban futtathatók olyan könyvtárak esetén, amelyekben sok állomány van.';
$string['configpathtophp'] = 'A PHP CLI útvonala. Pl. /usr/bin/php. Ha megadja, akkor a cron parancsait futtathatja a rendszergazda webes felületéről.';
$string['configperfdebug'] = 'Ha bekapcsolja, a teljesítményre vonatkozó információk megjelennek a standard stílus lábrészében.';
$string['configprofileroles'] = 'A felhasználói profilokban és a részvevők oldalon felsorolt szerepek';
$string['configprofilesforenrolledusersonly'] = 'A levélszemétküldők támadásának megelőzésére a még be nem iratkozott felhasználók profiljának leírása rejtve marad. Az új felhasználóknak legalább egy kurzust fel kell venni ahhoz, hogy hozzáadhassák profiljuk leírását.';
$string['configprotectusernames'] = 'Alapesetben az elfelejtett jelszó űrlapja nem ad semmilyen ötletet a felhasználónevek vagy az e-mail címek kitalálásához.';
$string['configproxybypass'] = 'Olyan (részleges) gazdagép- és IP-címek listája, amelyeknek a proxyt ki kell hagyniuk. Az elválasztáshoz használjon vesszőt, szóköz nélkül, pl. 192.168.0.0/16,*.mydomain.com.';
$string['configproxyfixunsafe_help'] = 'Megkísérli kijavítani a belső hívásokat – amelyek nem mennek át a proxy-n – a MoodleBot User Agent hozzáadásával és a proxy használatával.';
$string['configproxyhost'] = 'Ha ennek a szervernek proxyszámítógépet (például tűzfal) kell használni az Internet eléréséhez, akkor a proxygazdagép nevét és portszámát itt kell megadni. Ellenkező esetben hagyja üresen.';
$string['configproxylogunsafe_help'] = 'Megkísérli naplózni a belső hívásokat, amelyek nem mennek át a proxy-n, de át kellene menniük.';
$string['configproxypassword'] = 'Szükség esetén az internet proxyn keresztüli eléréséhez szükséges jelszó, üres, ha nincs rá szükség (PHP cURL-bővítményre van szükség).';
$string['configproxyport'] = 'Ha a szerver proxy-számítógépet használ, itt adja meg a proxy portját.';
$string['configproxytype'] = 'Webproxy típusa (PHP5-re és cURL-bővítményre van szükség a SOCKS5 támogatásához).';
$string['configproxyuser'] = 'Szükség esetén az internet proxyn keresztüli eléréséhez szükséges felhasználónév, üres, ha nincs rá szükség (PHP cURL-bővítményre van szükség).';
$string['configrecaptchaprivatekey'] = 'Karaktersor (titkos kulcs) az Ön Moodle-szervere és a recaptcha.net szerver közötti kommunikációhoz. Erről a portálról szerezhet be egyet: <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Karaktersor (portálkulcs) a reCAPTCHA-elem használatához a belépési űrlapon. Erről a portálról szerezhet be egyet: <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestedstudentname'] = 'A tanuló megnevezése a kért kurzusokban';
$string['configrequestedstudentsname'] = 'A tanulók megnevezése a kért kurzusokban';
$string['configrequestedteachername'] = 'A tanár megnevezése a kért kurzusokban';
$string['configrequestedteachersname'] = 'A tanárok megnevezése a kért kurzusokban';
$string['configreverseproxyignore'] = 'Ha szervere több olyan fordított proxy mögött működik, amelyek X-Forwarded-For fejlécet szúrnak be, akkor a kihagyandó fordított proxyk IP-címének vagy alhálózatainak vesszővel tagolt listáját kell megadnia a felhasználó helyes IP-címének az azonosításához.';
$string['configsectioninterface'] = 'Felület';
$string['configsectionmail'] = 'Levelezés';
$string['configsectionmaintenance'] = 'Karbantartás';
$string['configsectionmisc'] = 'Egyéb';
$string['configsectionoperatingsystem'] = 'Operációs rendszer';
$string['configsectionpermissions'] = 'Engedélyek';
$string['configsectionrequestedcourse'] = 'Kurzuskérések';
$string['configsectionsecurity'] = 'Biztonság';
$string['configsectionstats'] = 'Statisztika';
$string['configsectionuser'] = 'Felhasználó';
$string['configsecureforms'] = 'A Moodle további biztonsági szintet használhat internetes űrlapok fogadásakor. Ennek bekapcsolásakor a böngésző HTTP_REFERER változóját ellenőrzi az adott űrlap címe szempontjából. Igen ritka esetekben ez gondot okozhat, ha a felhasználó olyan beállítású tűzfalat (pl. Zonealarm) használ, amely a HTTP_REFERER változót kiiktatja az internetes forgalomból. Ezt jelzi, ha az űrlap \'lefagy\'. Ha felhasználóinak gondja támad (például) a belépési oldallal, megfontolható ennek a beállításnak a kikapcsolása, jóllehet, ez a durvább jelszó elleni támadásokkal szemben védtelenül hagyhatja a rendszert. Ha bizonytalan, hagyja ezt a paramétert \'Igen\' beállításban.';
$string['configservicespage'] = 'Adja meg egy szolgáltatási és támogatási oldal URL-jét, vagy hagyja üresen, hogy a moodle.com-on található Moodle szolgáltatásokra mutasson. A link csak a webhely adminisztrátorai számára jelenik meg.';
$string['configsessioncookie'] = 'Ez a beállítás szabja meg azt a sütinevet, amelyet a Moodle eseményei használni fognak. Megadása opcionális, és csak annyiban van értelme, hogy a sütik nem keverednek össze, ha ugyanazon a portálon a Moodle egynél több példányban fut.';
$string['configsessioncookiedomain'] = 'Ezzel módosíthatja azt a domént, ahonnan a Moodle-sütik elérhetők. Ez hasznos a Moodle olyan testre szabása esetén (pl. hitelesítés vagy beiratkozási segédprogramok), amely során a Moodle egy internetes alkalmazással vagy egy másik aldoménnel információkat kényszerül megosztani. <strong>VIGYÁZAT: kifejezetten ajánlott megtartani az alapbeállítást (üres), mert hibás érték esetén senki nem jelentkezhet be a portálra.</strong>';
$string['configsessioncookiepath'] = 'Ha módosítani kívánja a Moodle sütijeinek helyét, megadhat egy alkönyvtárat a portálján. Ellenkező esetben megfelelő az alapértelmezett \'/\'.';
$string['configsessiontimeout'] = 'Ha a portálra belépett személyek sokáig tétlenek (oldalak betöltése nélkül), a rendszer automatikusan kilépteti őket (eseményük befejeződik). Ez a változó szabja meg ezt az időtartamot.';
$string['configsessiontimeoutwarning'] = 'Ha a portálra bejelentkezettek hosszú ideig tétlenek (nem töltenek be oldalakat), a lejáratról figyelmeztetést kapnak. Ez a változó szabja meg, mennyi ideig lehetnek tétlenek.';
$string['configsessiontimeoutwarningcheck'] = 'A figyelmzetési idő nem lehet hosszabb, mint a lejárati idő.';
$string['configshowcommentscount'] = 'Megjegyzések számának kijelzése; a megjegyzések hivatkozásának kijelzésekor eggyel több lekérdezést jelent.';
$string['configshowicalsource'] = 'iCal-események forrásadatainak megjelenítése';
$string['configshowsiteparticipantslist'] = 'Az oldalhoz tartozó összes tanuló és tanár neve szerepelni fog az oldalhoz tartozó résztvevők felsorolásában. Ki tekintheti meg az oldalhoz tartozó résztvevők felsorolását?';
$string['configsitedefaultlicense'] = 'Alapértelmezett portállicenc';
$string['configsitedefaultlicensehelp'] = 'Alapértelmezett licenc valamely tartalom portálon való közzétételéhez';
$string['configsitemailcharset'] = 'A portálról küldött összes e-mail ezzel a karakterkészlettel fog megjelenni.';
$string['configsitemaxcategorydepth'] = 'Maximális kategóriamélység';
$string['configsitemaxcategorydepthhelp'] = 'Ez határozza meg a megjelenő alárendelt kategóriák maximális megjelenítési mélységét kategóriák vagy kombinált lista szerinti felsorolás esetén. A mélyebb szintű kategóriák hivatkozásként láthatók, melyeket a felhasználó AJAX-utasítással nyithat meg.';
$string['configslasharguments'] = 'SCORM-csomagok és több állományból álló tananyagok helyes megjelenítéséhez \'perjeles argumentumokra\' van szükség (<em>PATH_INFO</em>használatával) . Ha szervere nem támogatja a perjeles argumentumokat és nem sikerül beállítania, kikapcsolhatja ezt a beállítást, bár emiatt néhány dolog nem fog működni. <br />Megjegyzés: A jövőben a Moodle előírja a perjeles argumentumok használatát.';
$string['configsmtpauthtype'] = 'Ez állítja be az SMTP szerveren használandó hitelesítés típusát.';
$string['configsmtphosts'] = 'Adja meg egy vagy több olyan helyi SMTP-szerver teljes nevét, amelyet a Moodle levélküldésre használhat (pl. \'mail.a.com\' vagy \'mail.a.com;mail.b.com\'). Ha nem alapértelmezett (vagyis 25) portot ad meg, használhatja a [server]:[port] alakot (pl. \'mail.a.com:587\'. Biztonságos kapcsolathoz ltalában a 465-ös port  használatos SSL-lel, az 587-es port pedig TLS-sel. Ha szükséges, alább adja meg a protokollt. Ha üresen hagyja, a Moodle levélküldésre a PHP alapbeállítás szerinti módszerét fogja használni.';
$string['configsmtpmaxbulk'] = 'Egy SMTP-folyamat alatt küldött üzenetek maximális száma. Az üzenetek csoportosítása felgyorsíthatja az e-mailek küldését. A 2-nél alacsonyabb értékek minden egyes e-mailhez új SMTP-folyamatot írnak elő.';
$string['configsmtpoauthservice'] = 'Válassza ki az OAuth 2 szolgáltatást, amely úgy van konfigurálva, hogy kommunikáljon az SMTP szerverrel. Ha a szolgáltatás még nem létezik, akkor létre kell hoznia. Vegye figyelembe, hogy az SMTP hitelesítési típust XOAUTH2-re kell állítania.';
$string['configsmtpsecure'] = 'Ha az smtp-szerver biztonságos kapcsolatot ír elő, adja meg a protokoll megfelelő típusát.';
$string['configsmtpuser'] = 'Ha fentebb beállított egy SMTP-szervert és a szervernek hitelesítésre van szüksége, a felhasználónevet és a jelszót adja meg itt.';
$string['configstartwday'] = 'A hét kezdete';
$string['configstatsfirstrun'] = 'Itt adható meg, mely korábbi naplók legyenek feldolgozva, amikor a cronjob először készül feldolgozni a statisztikát. Ha nagy a forgalma és másokkal osztozik a portálon, jobb kerülni a túl régre való visszanyúlást, mert sokáig tarthat és sok erőforrást köthet le. (Ne feledje, hogy ennél a beállításnál 1 hónap = 28 nap. Az előállított grafikonok és jelentések esetén viszont 1 hónap = 1 naptári hónap.)';
$string['configstatsmaxruntime'] = 'A statisztika feldolgozása erőforrás-igényes lehet, ezért ezt a mezőt a lefuttatás idejének és időtartamának a megadásához kapcsolja össze a következővel.';
$string['configstatsmaxruntime2'] = 'A statisztika feldolgozása erőforrás-igényes lehet, ezért adjon meg egy maximális időt, amelyet az egy napi statisztika összegyűjtésére engedélyez. Egyetlen cron lefuttatásához a feldolgozható napok száma maximum 31 lehet.';
$string['configstatsmaxruntime3'] = 'Adja meg az egy napra statisztika kiszámítására fordítható maximális időt, figyelembe véve azt, hogy ez a feldolgozás erősen megterheli a szervert. Alább adhatja meg az egy cron alatt feldolgozható napok maximális számát.';
$string['configstatsruntimedays'] = 'Adja meg az egyes statisztikákban feldolgozott napok maximális számát. Naprakész statisztika esetén csak egy napot dolgoz föl a rendszer, ezért ezt az értéket a szerver leterheltsége szerint állítsa be; ha rövidebb cronra van szüksége, rövidítse az időtartamot.';
$string['configstatsruntimestart'] = 'A statisztikai feldolgozást végző cronjob mikor induljon el? Ha egy szerveren több Moodle fut, célszerű más-más időpontot megadni.';
$string['configstatsuserthreshold'] = 'Ez határozza meg a kurzust felvettek azon minimális számát, akikről készül statisztika.';
$string['configstrictformsrequired'] = 'Bekapcsolása esetén a felhasználók az űrlapok kitöltendő mezőibe nem írhatnak szóközt vagy sortörést.';
$string['configstripalltitletags'] = 'Szüntesse meg a bejelölést, ha engedélyezni kívánja HTML címkék használatát tevékenység- és tananyagnevekben.';
$string['configsupportavailability'] = 'Megadja a láblécben, hogy ki léphet kapcsolatba a webhely ügyfélszolgálatával.';
$string['configsupportemail'] = 'Ha a portálon van SMTP beállítva, de támogatási oldal nincs, akkor erre az e-mail-címre érkeznek a támogatási űrlapon leadott üzenetek. Ha a küldés sikertelen, a bejelentkezett felhasználók számára megjelenik ez az email-cím.';
$string['configsupportname'] = 'A támogatási űrlapon vagy a támogatói oldalon keresztól segítséget nyújtó személy vagy szervezet neve.';
$string['configsupportpage'] = 'Adja meg egy támogatási oldal URL-jét vagy hagyja üresen, hogy egy kapcsolatfelvételi űrlapra mutasson. A hivatkozás az oldal láblécében jelenik meg.';
$string['configtempdatafoldercleanup'] = 'A kiválasztott időnél régebbi adatmappából törölje az ideiglenes adatállományokat.';
$string['configthemedesignermode'] = 'A stílusokhoz tartozó képek és a CSS a teljesítmény érdekében régóta a böngésző és a szerver gyorsítótárában vannak. Stílusok kidolgozása vagy kódírás esetén kapcsolja be a gyorsítótáras verziók elkerülése érdekében. Figyelem: ezzel portálja minden felhasználó számára lelassul! A gyorsítótárban lévő stílusokat kézzel is visszaállíthatja a stílusválasztó oldalon.';
$string['configthemelist'] = 'Ha ez üres, bármely érvényes stílus használható. Ha a stílusmenüt rövidíteni kívánja, itt a nevekből megadhat egy vesszővel elválasztott felsorolást. Ne használjon szóközt! Például: standard,orangewhite.';
$string['configtimezone'] = 'Ez az alapértelmezett időzóna a dátumok megjelenítésére - minden felhasználó felülírhatja ezt a beállítást a saját profiljában. Itt történik a cron feladatainak és egyéb beállításoknak a megadása. Módosítsa a beállítást, ha az "Érvénytelen időzóna" jelenik meg.';
$string['configuseblogassociations'] = 'A felhasználók szervezhessék blogjukat az üzenetek kurzusokhoz és kurzusmodulokhoz kapcsolása révén?';
$string['configusesitenameforsitepages'] = 'Bekapcsolása esetén a "portáloldalak" helyett a portál rövid neve szerepel a portáloldalak navigáláshoz való csomópontjaként.';
$string['configusetags'] = 'A címkék használatát az egész portálra bekapcsolja?';
$string['configvariables'] = 'Változók';
$string['configverifychangedemail'] = 'Bekapcsolja a módosított e-mail-címek ellenőrzését az engedélyezett és a tiltott e-mail-domén-beállítások alapján. Kikapcsolása esetén a domének használatára csak új felhasználók létrehozása esetén kerül sor.';
$string['configvisiblecourses'] = 'Rejtett kategóriák kurzusainak szokásos megjelenítése.';
$string['configwarning'] = 'Ezen beállítások módosításakor óvatosságra van szükség - a furcsa értékek gondot okozhatnak.';
$string['configyuicomboloading'] = 'Ennek révén YUI-könyvtárak optimális kombinált állománybetöltésre nyílik lehetőség. Éles környezetben a teljesítmény érdekében bekapcsolandó.';
$string['confirmation'] = 'Megerősítés';
$string['confirmationpending'] = 'Megerősítés függőben';
$string['confirmcontextlock'] = 'A(z) {$a->contextname} nincs befagyasztva. Ha befagyasztja, csak olvasható lesz, és a felhasználóknak módosításokra nem lesz lehetőségük. Folytatja?';
$string['confirmcontextunlock'] = 'A(z) {$a->contextname} nincs befagyasztva. Ha befagyasztja, további módosításokra nem lesz lehetőség. Folytatja?';
$string['confirmdeletecomments'] = 'Biztosan törli a kiválasztott megjegyzés(eke)t?';
$string['confirmed'] = 'Megerősítve';
$string['contactsitesupport'] = 'Portáltámogatás elérése';
$string['contenttypeuninstalling'] = '{$a->type} által támogatott {$a->count} törlés előtti tartalom áll rendelkezésre. Biztosan folytatja?';
$string['contextlockappliestoadmin'] = 'A környezet befagyasztása a rendszergazdákra vonatkozik.';
$string['contextlockappliestoadmin_desc'] = 'Kikapcsolása esetén a rendszergazdák írási jogosultsága a  befagyasztott környezetekben megmarad.';
$string['contextlocking'] = 'Környezet befagyasztása';
$string['contextlocking_desc'] = 'Ezzel a beállítással olvasási jogosultság állítható be a kiválasztott kategóriákhoz, kurzusokhoz. tevékenységekhez vagy blokkokhoz.';
$string['cookiesecure'] = 'Csak biztonságos sütik';
$string['country'] = 'Alapértelmezett ország';
$string['course_customfield'] = 'Kurzus egyedi mezői';
$string['coursecolor'] = 'Szín: {$a}';
$string['coursecolorheading_desc'] = 'A kurzusbeállítások között kurzusképet nem tartalmazó kurzusok a Kurzusaim oldalon mintás kurzuskártyával jelennek meg. A minta színeit alább adhatja meg.';
$string['coursecolorsettings'] = 'A kurzuskártya színei';
$string['coursecontact'] = 'Kurzusvezetők';
$string['coursecontact_desc'] = 'Ezzel a beállítással megadhatja, ki jelenjen meg a kurzusleírásban. A felhasználóknak legalább ezen szerepek közül eggyel rendelkezni kell az adott kurzusban ahhoz, hogy annak kurzusleírásában megjelenjenek.';
$string['coursecontactduplicates'] = 'Összes kurzusbeli kapcsolattartói szerep megjelenítése';
$string['coursecontactduplicates_desc'] = 'Bekapcsolása esetén a kurzusleírásban szerepükkel együtt megjelennek a több kiválasztott kurzusbeli kapcsolattartói szereppel rendelkező felhasználók. Egyébként csak egy szereppel jelennek meg (amely a Portáladminisztráció \'Szerepek meghatározása\' alatt legfölül szerepel).';
$string['coursecreationguide'] = 'Moodle kurzus létrehozás útmutató URL';
$string['coursecreationguide_help'] = 'Meghatározza az "Első lépések" útmutatóhoz vezető utat, amely rövid videókat és általános tippeket tartalmaz a kurzusok létrehozásához. A útmutatóhoz vezető link megjelenik a Saját kurzusok oldalon, ha nincsenek megjelenítendő kurzusok. Csak azok a felhasználók látják a linket, akik jogosultak kurzusok létrehozására.';
$string['coursegraceperiodafter'] = 'Régi kurzusok türelmi ideje';
$string['coursegraceperiodbefore'] = 'Jövőbeli kurzusok türelmi ideje';
$string['courselistshortnames'] = 'Kibővített kurzusnevek megjelenítése';
$string['courselistshortnames_desc'] = 'Bekapcsolása esetén a rövid kurzuscímek is megjelennek. Szükség esetén a \'courseextendednamedisplay\' nyelvi megfelelőjének szerkesztésével szabhatja testre a kibővített kurzuscímeket a nyelv testreszabása funkció segítségével.';
$string['coursemgmt'] = 'Kurzusok és kategóriák kezelése';
$string['courseoverview'] = 'Kurzusáttekintés';
$string['courserequestnotify'] = 'Értesítés kurzuskérésről';
$string['courserequestnotifyemail'] = '<p>{$a->user} felhasználó új kurzust igényelt az Ön portálján.</p>
<p>Az igényt itt megtekintheti: <a href="{$a->link}">{$a->link}</a>.</p>

<p>Igény részletei:</p>
<ul>
<li>Kurzus teljes neve: {$a->fullname}</li>
<li>Kurzus rövid neve: {$a->shortname}</li>
<li>Kategória: {$a->category}</li>
<li>A kurzusigénylés indoka: {$a->reason}</li>
</ul>';
$string['courserequests'] = 'Kurzuskérelmek';
$string['courserequestspending'] = 'Függőben lévő kurzuskérések';
$string['courses'] = 'Kurzusok';
$string['coursesperpage'] = 'Kurzus oldalanként';
$string['courseswithsummarieslimit'] = 'Kurzusok összegzésekkel korlátozásával';
$string['creatornewroleid'] = 'Szerkesztői szerep új kurzusokban';
$string['creatornewroleid_help'] = 'Ha a felhasználó még nem rendelkezik az új kurzus kezeléséhez szükséges engedéllyel, akkor automatikusan ezzel a szereppel iratkozik be.';
$string['cron'] = 'Cron';
$string['cron_enabled'] = 'A cron bekapcsolása';
$string['cron_enabled_desc'] = 'A cront általában be kell kapcsolni. Ezzel a beállítással ideiglenesen, pl. a szerver újraindítása idejére kikapcsolhatja. Kikapcsolása esetén a rendszer nem indít el új háttérfeladatokat. Hosszabb ideig ne hagyja a cront kikapcsolva.';
$string['cron_help'] = 'A cron.php karbantartó programkóddal egyes Moodle-modulok ütemezett feladatokat hajthatnak végre (pl. új fórumüzenetek kiküldése). A kódot rendszeresen, lehetőleg percenként le kell  futtatni.';
$string['cron_keepalive_desc'] = 'A további feladatokra vonatkozó lekérdezés időtartama. Ez a beállítás annak biztosítására szolgál, hogy a cron mindig fusson. Ha dedikált feladatfutókat használ, állítsa 0-ra. Ellenkező esetben állítsa be az adhoc feladatok párhuzamossági határához hasonló értékre. Kerülje a hosszabb időt. A maximális idő 15 perc.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'A cron futtatása csak a parancssorból';
$string['cronerrorclionly'] = 'Az oldal internetes elérését a rendszergazda kikapcsolta.';
$string['cronerrorpassword'] = 'Az oldal eléréséhez nem adott meg érvényes jelszót';
$string['croninfrequent'] = 'A cron karbantartó kód utolsó két futása között több mint {$a->actual} idő telt el {$a->expected} helyett. Ajánlott gyakoribb futtatásra állítania.';
$string['cronremotepassword'] = 'Cron-jelszó a távoli eléréshez';
$string['cronwarning'] = 'A <a href="{$a->url}">admin/cron.php script kódot</a> {$a->actual} ideje nem használta, futtassa {$a->expected} időközönként.';
$string['cronwarningcli'] = 'A <code>admin/cli/cron.php</code> kódot {$a->actual} ideje nem használta, futtassa {$a->expected} időközönként.';
$string['cronwarningnever'] = 'A <code>admin/cli/cron.php</code> kódot sohasem nem használta, futtassa {$a->expected} időközönként.';
$string['cronwarningneverweb'] = 'A(z) <a href="{$a->url}">admin/cron.php script</a> kódot még nem futtatta, {$a->expected} időközönként le kell futtatnia.';
$string['ctyperequired'] = 'A ctype PHP-bővítményt a Moodle előírja a portál teljesítményének növelése és a több nyelvű kompatibilitás érdekében.';
$string['curlcache'] = 'cURL-gyorsítótári TTL';
$string['curlrequired'] = 'A Moodle a Moodle-adattárakkal való kommunikációhoz most már megköveteli a cURL PHP bővítményt.';
$string['curlsecurityallowedport'] = 'A cURL engedélyezett portjainak listája';
$string['curlsecurityallowedportsyntax'] = 'A cURL által használható portszámok felsorolása. Csak egész számok használhatók. Minden bejegyzés egy sorba írandó. Ha üresen hagyja, minden portot engedélyez. Beállítása esetén szinte mindig mind a 443-at, mind a 80-at meg kell adni a cURL számára a standard HTTPS és HTTP portokhoz csatlakozáshoz.';
$string['curlsecurityblockedhosts'] = 'A cURL zárolt gazdagépeinek listája';
$string['curlsecurityblockedhostssyntax'] = 'Minden bejegyzés új sorba írandó. Érvényes bejegyzések: teljes IPv4 vagy IPv6 címek (pl. 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::), melyek egy gazdagépet azonosítanak; vagy CIDR-jelölés (pl. 231.54.211.0/20 vagy fe80::/64); vagy IP-címtartomány (pl. 231.3.56.10-20 vagy fe80::1111-bbbb), ahol a tartomány az utolsó címcsoportot jelenti; vagy doménnevek (pl. localhost vagy example.com); vagy doménnevek helyettesítő karakterekkel (pl. *.example.com vagy *.sub.example.com). Üres sor nem használható.';
$string['curlsecurityurlblocked'] = 'Az URL zárolva van.';
$string['curltimeoutkbitrate'] = 'A cURL minimális időtúllépésének kiszámításához használt bitsebesség (Kbps)';
$string['curltimeoutkbitrate_help'] = 'A HTTP HEAD-hez kapcsolódó kérelem alapján történik az időtúllépés kiszámítása a fájlméret alapján. A 0 kikapcsolja a kérelmet.';
$string['currenttheme'] = 'Aktuális stílus';
$string['customcheck'] = 'Egyéb ellenőrzések';
$string['custommenu'] = 'Egyedi menü';
$string['custommenuitems'] = 'Egyedi menü elemei';
$string['customusermenuitems'] = 'A felhasználói menü elemei';
$string['datarootsecurityerror'] = '<p><strong>BIZTONSÁGI FIGYELMEZTETÉS!</strong></p><p>Adatainak gyökérkönyvtára rossz helyen van és elérhető a netről. Így minden magánállományát bárki elérheti, portáljára pedig jogosulatlan rendszergazdaként való belépésre ad lehetőséget!</p>
<p>Adatainak gyökérkönyvtárát ({$a}) <em>mindenképpen</em> helyezze át nyilvánosan elérhető internetes könyvtárán kívülre, valamint frissítse a <code>$CFG->dataroot</code> beállítást config.php állományában.</p>';
$string['datarootsecuritywarning'] = 'Előfordulhat, hogy portáljának beállítása nem biztonságos. Ellenőrizze, hogy adatainak gyökérkönyvtárát ({$a}) nem lehet-e közvetlenül elérni a netről.';
$string['dbprefixtoolong'] = 'A webhely adatbázis előtagja ($CFG->prefix) túl hosszú ({$a->current} karakterek). A maximálisan megengedett karakterek száma {$a->maximum}.';
$string['dbsessions'] = 'Adatbázis használata a folyamatról szóló információkhoz';
$string['debug'] = 'Hibaszűrési üzenetek';
$string['debugall'] = 'MIND: a PHP összes használható hibaszűrési üzenetének megjelenítése';
$string['debugdeveloper'] = 'FEJLESZTŐ: a Moodle külön hibaszűrési üzenetei fejlesztők számára';
$string['debugdisplay'] = 'Hibaszűrési üzenetek megjelenítése';
$string['debugging'] = 'Hibaszűrés';
$string['debugminimal'] = 'MINIMÁLIS: csak a végzetes hibákat jelzi';
$string['debugnone'] = 'EGY SEM: semmilyen hibát vagy figyelmeztetést nem jelez';
$string['debugnormal'] = 'SZOKÁSOS: jelzi a hibákat, a figyelmeztetéseket és a tájékoztató üzeneteket';
$string['debugpageinfo'] = 'Oldalra vonatkozó információk megjelenítése';
$string['debugsqltrace'] = 'SQL-hívások eredetének megjelenítése';
$string['debugsqltrace1'] = 'Csak egyetlen hívó sor megjelenítése';
$string['debugsqltrace100'] = 'Teljes híváslánc megjelenítése';
$string['debugsqltrace2'] = 'A híváslánc 2 sorának megjelenítése';
$string['debugsqltrace_desc'] = 'Bekapcsolása esetén az SQL-hez megjegyzésként részleges vagy teljes PHP-hívásláncot ad hozzá';
$string['debugstringids'] = 'Nyelvi szövegek eredetének kijelzése';
$string['debugstringids_desc'] = 'Bekapcsolása esetén az oldal webcíméhez a ?strings=1 vagy az &strings=1 paramétert hozzáadva kijelzi a nyelvi állományt és az azonosítókat.';
$string['debugtemplateinfo'] = 'Mutasd a sablon információit';
$string['debugtemplateinfo_desc'] = 'Ha engedélyezve van, a megjelenítéshez használt sablonok megjegyzések formájában jelennek meg a HTML oldalon. A beállítás módosítása után ki kell üríteni a gyorsítótárat. Csak ideiglenes hibakereséshez használja, mivel HTML-érvényesítési hibákat eredményez, és megszakíthatja az oldal szkriptjeit. Az alapvető működést is megszakíthatja!';
$string['debugvalidators'] = 'Validáló hivatkozásainak megjelenítése';
$string['defaultcity'] = 'Alapbeállítás szerinti város';
$string['defaultcity_help'] = 'Az itt megadott város lesz új felhasználói fiókok létrehozása során az alapbeállítás szerinti város.';
$string['defaultformatnotset'] = 'Hiba a kurzus alapformátumának meghatározása során. Ellenőrizze a portál beállításait.';
$string['defaulthomepage'] = 'Felhasználók kezdőlapja';
$string['defaultrequestcategory'] = 'Alapkategória kurzuskérésekhez';
$string['defaultsettinginfo'] = 'Alapbeállítás: {$a}';
$string['defaultuserroleid'] = 'Alapszerep minden felhasználó esetén';
$string['deletedplugintypesdetected'] = 'Törölt segédprogram észlelve: \'{$a}\'. Ezt migrálni/törölni kellett volna az elavulási időszakban. Mivel ez már egy nem támogatott segédprogram típus, a telepítés/frissítés nem tud folytatódni mindaddig, amíg ez nincs eltávolítva.';
$string['deleteduserx'] = '{$a} törölt felhasználó';
$string['deleteincompleteusers'] = 'Hiányosan megadott felhasználók törlése ennyi idő elteltével';
$string['deleteunconfirmed'] = 'Hiányosan beállított felhasználók törlése ennyi idő elteltével';
$string['deleteuser'] = 'Felhasználó törlése';
$string['density'] = 'Sűrűség';
$string['denyemailaddresses'] = 'Elutasított e-mailek doménjei';
$string['development'] = 'Fejlesztés';
$string['devicetype'] = 'Eszköz típusa';
$string['devlibdirpresent'] = 'Fejlesztéseket tartalmazó, pl. <em>vendor</em> vagy <em>node_modules</em> könyvtáraknak nyilvános portálokon nincs helye. További részletek: <a href="{$a->moreinfourl}">biztonsági áttekintés</a>.';
$string['disabled'] = 'Kikapcsolva';
$string['disableplugin'] = '{$a} letiltása';
$string['disableuserimages'] = 'Felhasználói profilképek kikapcsolása';
$string['displayerrorswarning'] = 'A <em>display_errors</em> PHP-beállítás bekapcsolása nem ajánlott éles portálokon, mert egyes hibaüzenetek érzékeny adatokat adhatnak ki a szerveréről.';
$string['displayloginfailures'] = 'Sikertelen belépések megjelenítése';
$string['divertallemails'] = 'E-mail eltérítése';
$string['divertallemailsdetail'] = 'Fejlesztési környezetben biztonsági megoldás e-mailek tesztelésére, éles környezetben ne használja.';
$string['divertallemailsexcept'] = 'E-mail eltérítésével kapcsolatos kivételek';
$string['divertallemailsexcept_desc'] = 'Vesszőkkel vagy új sorokkal elválasztott e-mailes kivételszabályok listája. Minden szabályt reguláris kifejezésként értelmez, pl. <pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Minden e-mail eltérítése';
$string['divertallemailsto_desc'] = 'Beállítása esetén minden e-mailt erre az egyetlen címre terel át.';
$string['dndallowtextandlinks'] = 'Szöveg/hivatkozások feltöltésének elhúzása';
$string['doclang'] = 'Dokumentumok nyelve';
$string['docroot'] = 'Moodle Docs dokumentumok gyökérkönyvtára';
$string['doctonewwindow'] = 'Új ablakban jelenik meg';
$string['doesnotfit'] = 'E-mail megjelenítési beállításai';
$string['doesnotfitdetail'] = 'Moodle-ból küldött e-mail megjelenítési beállításai';
$string['download'] = 'Letöltés';
$string['downloadcoursecontentallowed'] = 'Kurzustartalom letöltési funkciója elérhető';
$string['downloadcoursecontentallowed_desc'] = 'Kurzustartalom letöltési funkciója elérhető-e a kurzusokhoz. Ha igen, a kurzustartalom letöltése ki/be kapcsolható a kurzusszerkesztési menü "Kurzustartalom letöltésének bekapcsolása" beállításból (alapesetben ez a <a href={$a} target="_blank">Kurzus alapbeállításai</a>n keresztül történik).';
$string['durationunits'] = 'időegységek';
$string['edithelpdocs'] = 'Súgóállományok szerkesztése';
$string['editlang'] = '<b>Szerkesztés</b>';
$string['editorbackgroundcolor'] = 'Háttérszín';
$string['editordictionary'] = 'Szerkesztő szótára';
$string['editorfontfamily'] = 'Betűtípus';
$string['editorfontlist'] = 'Betűtípusok felsorolása';
$string['editorfontsize'] = 'Betűméret';
$string['editorhidebuttons'] = 'Rejtett gombok';
$string['editorkillword'] = 'Word-forma szűrője';
$string['editorspelling'] = 'Szerkesztő helyesírás-ellenőrzése';
$string['editorspellinghelp'] = 'Helyesírás-ellenőrzés ki-/bekapcsolása. Bekapcsolása esetén az aspellnek a szerveren telepítve kell lennie.';
$string['editstrings'] = 'Szavak vagy kifejezések szerkesztése';
$string['emailchangeconfirmation'] = 'E-mail módosításának megerősítése';
$string['emaildkim'] = 'DKIM-e-mail-aláírás';
$string['emaildkiminfo'] = 'Ha mind a  DKIM-választó be van állítva, mind fellelhető egy magánjellegű tanúsító fájl, amely a $CFG->dataroot/dkim/[domain]/[selector].private alatt megfelel a "Feladó" címtartomány e-mailjeinek, akkor az e-mail megkapja az aláírást. Legtöbbször (pl. ha az allowedemaildomains üres) csak egy tanúsítványra van szükség itt: <pre>{$a->path}</pre>. A beállítás további részleteit lásd itt: <a href="{$a->docs}">Levélbeállítás</a>.';
$string['emaildkimselector'] = 'DKIM-választó';
$string['emailfromvia'] = 'E-mail útvonalának adatai';
$string['emailheaders'] = 'E-mail fejlécek';
$string['emailsubjectprefix'] = 'E-mail tárgysorához fűzendő szöveg';
$string['emoticonalt'] = 'Alternatív szöveg ';
$string['emoticoncomponent'] = 'Képelem';
$string['emoticonimagename'] = 'Kép neve';
$string['emoticons'] = 'Hangulatjelek használata';
$string['emoticons_desc'] = 'Az űrlap meghatározza a portálján használt hangulatjeleket (emotikonokat). Ha egy sort ki akar törölni a táblázatból, mentse el az űrlapot bármely kitöltendő mezőben egy üres értékkel. Új hangulatjel felvételéhez töltse ki az utolsó üres sorban lévő mezőket. Az összes mező alapértékekkel való visszaállításához kövesse a fenti hivatkozást.
* Szöveg (kitöltendő) - Ez a szöveg jelenik meg a hangulatjel képe helyén. Legalább két karakter hosszúnak kell lennie.
* Kép neve (kitöltendő) - A hangulatjel képállományának neve kiterjesztés nélkül, a pix mappához viszonyítva.
* Képelem (kitöltendő) - Az ikont létrehozó elem.
* Alternatív szöveg (választható) - Szövegazonosító és a hangulatjel alternatív szövegeleme.';
$string['emoticonsreset'] = 'Hangulatjelek visszaállítása alapértékekre';
$string['emoticontext'] = 'Szöveg';
$string['emptysettingvalue'] = 'Üres';
$string['enableanalytics'] = 'Analitika';
$string['enableblogs'] = 'Blogok bekapcsolása';
$string['enablecalendarexport'] = 'Naptárexportálás bekapcsolása';
$string['enablecomments'] = 'Megjegyzések engedélyezése';
$string['enablecommunicationsubsystem'] = 'Engedélyezze a kommunikációs szolgáltatókat';
$string['enablecommunicationsubsystem_desc'] = 'Lehetővé teszi a kommunikációs szolgáltatókkal, például a Matrix-szal való integrációt, hogy a tanárok és a diákok könnyebben kommunikálhassanak egymással. Ezeket az integrációkat a <a href="settings.php?section=managecommunicationproviders">Plugins</a> alatt kezelheti.';
$string['enablecourserelativedates'] = 'Viszonyított kurzusdátumok bekapcsolása';
$string['enablecourserelativedates_desc'] = 'Kurzusok beállítása a felhasználó kurzuskezdéséhez viszonyított dátumok megjelenítésével.';
$string['enablecourserequests'] = 'Kurzuskérések bekapcsolása';
$string['enabled'] = 'Bekapcsolva';
$string['enabledashboard'] = 'Irányítópult engedélyezése';
$string['enabledashboard_help'] = 'Az irányítópult alapértelmezetten az Idősort, a Naptárt és a Mostanában felkeresett tételeket mutatja. Lehetséges mindenki számára egy ettől eltérő Irányítópultot kialakítani, valamint engedélyezni a felhasználóknak az egyedi Irányítópultjuk kialakítását. Amennyiben letiltásra kerül, a "Felhasználók kezdőoldala" értéket másra kell állítani';
$string['enableglobalsearch'] = 'Globális keresés bekapcsolása';
$string['enableglobalsearch_desc'] = 'Bekapcsolása esetén indexeli az adatokat és ütemezett feladattal szinkronizálja.';
$string['enablegravatar'] = 'A Gravatar bekapcsolása';
$string['enablegravatar_help'] = 'Bekapcsolása esetén a Moodle megpróbál Gravatarból elérni egy felhasználói profilképet, ha a felhasználó nem töltött föl egyet.';
$string['enablemobilewebservice'] = 'Mobil eszközökhöz webszolgáltatás bekapcsolása';
$string['enablepdfexportfont'] = 'Engedélyezze a PDF betűtípusokat.';
$string['enablepdfexportfont_desc'] = 'Ha a webhelyén különböző nyelvű kurzusok vannak, amelyekhez más betűtípusokra van szükség a generált PDF-fájlokban, akkor lehetőséget biztosíthat a betűtípus beállítására a kurzusbeállításokban. Meg kell adnia a rendelkezésre álló betűtípusokat a $CFG->pdfexportfont beállításban a config.php fájlban.';
$string['enableplugin'] = '{$a} engedélyezése';
$string['enablerecordcache'] = 'Rekord-gyorsítótár bekapcsolása';
$string['enablerssfeeds'] = 'RSS-hírek bekapcsolása';
$string['enablesearchareas'] = 'Keresési területek bekapcsolása';
$string['enablesharingtomoodlenet'] = 'Engedélyezze a megosztást a MoodleNet-en (kimenő)';
$string['enablesharingtomoodlenet_desc'] = 'Lehetővé teszi a felhasználók számára, hogy megoszthassák a kurzus tartalmát a MoodleNet-tel, ha rendelkeznek a megfelelő jogosultsággal.';
$string['enablestats'] = 'Statisztika bekapcsolása';
$string['enabletrusttext'] = 'Megbízható tartalom bekapcsolása';
$string['enableuserfeedback'] = 'A Moodle-lal kapcsolatos visszajelzés bekapcsolása';
$string['enableuserfeedback_desc'] = 'Bekapcsolása esetén az irányítópulton és a láblécen megjelenik egy \'Visszajelzés küldése\' hivatkozás a Moodle-lal kapcsolatos, központnak szóló visszajelzés küldéséhez. Az irányítópulton megjelenik az \'Emlékeztessen később\' lehetőség is. Ha azt \'Soha\' értékre állítja, azzal kikapcsolja az irányítópult emlékeztetőjét, de a láblécen megmarad a \'Visszajelzés küldése\' hivatkozás.';
$string['enablewebservices'] = 'Webszolgáltatások bekapcsolása';
$string['enablewsdocumentation'] = 'Webszolgáltatások dokumentációja';
$string['encryptedpassword_edit'] = 'Új érték megadása';
$string['encryptedpassword_set'] = '(Beállítva és titkosítva)';
$string['enroladminnewcourse'] = 'Rendszergazda automatikus beiratkoztatása új kurzusokba';
$string['enroladminnewcourse_help'] = 'Ha egy rendszergazda új kurzust ad hozzá, automatikusan beiratkozzon-e az új kurzusba létrehozói szerepben?';
$string['enrolinstancedefaults'] = 'Beiratkozási esemény alapbeállításai';
$string['enrolinstancedefaults_desc'] = 'Beiratkozás alapbeállításai új kurzusok esetén';
$string['enrolmultipleusers'] = 'A felhasználók beíratása';
$string['entitytasklog'] = 'Feladatnapló';
$string['environment'] = 'Környezet';
$string['environmenterrortodo'] = 'A fentiekben fellelt összes környezeti problémát (hibát) el kell hárítania, mielőtt folytatja a Moodle ezen változatának a telepítését!';
$string['environmenterrorupgrade'] = 'Figyelmeztetés: a fentiekben talált összes környezeti problémát (hibát) el kell hárítania, mielőtt folytatja a Moodle ezen változatának frissítését! Ha a követelmények teljesítése nélkül végzi el a frissítést, gondokba (például adatvesztés) ütközhet. Biztosan folytatja a frissítést?';
$string['environmentmariadbwrongdbtype'] = 'Hibás $CFG->dbtype. Módosítani kell a config.php állományban \'mysql\'-ról \'mariadb\'-re.';
$string['environmentmustfixsetting'] = 'A PHP beállításait módosítani kell.';
$string['environmentok'] = 'Szerverkörnyezete megfelel az összes minimális követelménynek.';
$string['environmentrecommendcustomcheck'] = 'ha ez az ellenőrzés sikertelen, az potenciális gondot jelez';
$string['environmentrecommendinstall'] = 'a megfelelő teljesítmény érdekében telepítse és kapcsolja be';
$string['environmentrecommendversion'] = 'minimum a {$a->needed} változat ajánlott,  jelenleg a {$a->current} verziót használja';
$string['environmentrequirecustomcheck'] = 'ennek az ellenőrzésnek sikerülnie kell';
$string['environmentrequireinstall'] = 'telepíteni kell és be kell kapcsolni';
$string['environmentrequireversion'] = 'minimum a {$a->needed} változat szükséges,  jelenleg a {$a->current} verziót használja';
$string['environmentsettingok'] = 'ajánlott beállítás észlelve';
$string['environmentshouldfixcustomcheck'] = 'a legjobb eredmény érdekében engedélyezve kell lennie';
$string['environmentshouldfixsetting'] = 'A PHP beállítását módosítani kell.';
$string['environmentxmlerror'] = 'Hiba a környezeti adatok ({$a->error_code}) beolvasása közben';
$string['errordeletingconfig'] = 'Hiba történt a(z)\'{$a}\' segédprogram beállítási rekordjainak törlése közben.';
$string['errorsetting'] = 'Ezt a beállítást nem lehetett elmenteni:';
$string['errorwithsettings'] = 'Egyes beállításokat hiba miatt nem lehetett módosítani.';
$string['eventshandlersinuse'] = 'Az alábbi segédprogramjai elavult Events 1 API kezelőket használnak: \'{$a}\'. Kérjük, frissítse őket az Events 2 API használatához! Részletek: https://docs.moodle.org/dev/Events_API#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Bárki, aki számára \'{$a}\' engedélyezve van.';
$string['exceptions'] = 'kivételek';
$string['execpathnotallowed'] = 'A futtatási és lokális útvonalak beállítása a config.php-ben ki van kapcsolva.';
$string['experimental'] = 'Kísérleti';
$string['experimentalsettings'] = 'Kísérleti beállítások';
$string['extendedusernamechars'] = 'Tetszőleges karakterek engedélyezése a felhasználónevekben';
$string['extramemorylimit'] = 'Külön php-memóriakorlát';
$string['fatalsessionautostart'] = '<p>Súlyos konfigurációs hiba, tájékoztassa róla a rendszergazdát.</p><p> A helyes működéshez a rendszergazdának módosítania kell a PHP beállításait.</p><p>A <code>session.auto_start</code> <code>off</code>-ra állítandó.</p><p>Ezt a beállítást a szerveren lévő <code>php.ini</code>, Apache/IIS <br />beállításának vagy a <code>.htaccess</code> állomány szerkesztésével módosíthatja.</p>';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'A favicon az oldal címe mellett jelenik meg a böngésző lapján. A Moodle favicon jelenik meg, ha nincs megadva egyéni favicon.';
$string['feedbacksettings'] = 'Visszajelzés beállításai';
$string['fileconversioncleanuptask'] = 'Ideiglenes rekordok kitakarítása állományok átalakításához.';
$string['filecreated'] = 'Új állomány létrehozva';
$string['filescleanupperiod'] = 'Kukában lévő állományok törlése';
$string['filescleanupperiod_help'] = 'Milyen gyakran kerül sor a kukában lévő állományok törlésére. Ezek általában már nem létező környezethez kapcsolódnak, például ha egy kurzust törölnek. Ne feledje: a beállítás eredményeként egy kurzusból biztonsági mentés, törlés, majd helyreállítás során állományok tűnhetnek el, ha kikapcsolja az \'Automatikus biztonsági mentési beállítások\' alatt az \'Állományokkal együtt\'  (backup_auto_files) opciót.';
$string['filesizeunits'] = 'állományméretek';
$string['filestoredin'] = 'Állomány mentése ebbe a mappába:';
$string['filestoredinhelp'] = 'Ahová az állomány kerül';
$string['filterall'] = 'Minden szövegsor szűrése';
$string['filtermatchoneperpage'] = 'Oldalanként egy találat kiszűrése';
$string['filtermatchonepertext'] = 'Szövegenként egy találat kiszűrése';
$string['filternavigationwithsystemcontext'] = 'Szűrő navigáció rendszerkontextussal';
$string['filters'] = 'Szűrők';
$string['filtersettings'] = 'Szűrők kezelése';
$string['filtersettingsgeneral'] = 'Általános szűrőbeállítások';
$string['filteruploadedfiles'] = 'Feltöltött állományok szűrése';
$string['forceclean'] = 'Tartalomtisztítás mindenhol';
$string['forceclean_desc'] = 'A portálhoz hozzáadott tartalom megjelenítés előtt rendszerint tisztításra kerül a biztonsági kockázat kiszűrése érdekében. Egyes helyeken, pl. tevékenység-leírásban, HTML-blokkokban stb. erre nem kerül sor forráskód, média, keretek stb. hozzáadása végett. Bekapcsolása esetén MINDEN tartalom tisztítására sor kerül, így előfordulhat, hogy a meglévő tartalom hibásan jelenik meg.';
$string['forcelogin'] = 'Felhasználói belépés előírása';
$string['forceloginforprofileimage'] = 'Felhasználók számára a felhasználói képek megtekintéséhez belépés előírása';
$string['forceloginforprofileimage_help'] = 'Bekapcsolása esetén a felhasználóknak a felhasználói profilképek megtekintéséhez be kell lépni. Az alapbeállítás szerinti felhasználói kép jelenik meg minden tájékoztató e-mailben.';
$string['forceloginforprofiles'] = 'Felhasználói belépés előírása a profilhoz';
$string['forcetimezone'] = 'Időzóna megadásának előírása';
$string['formatuninstallwithcourses'] = 'Összesen {$a->count} kurzus használja a{$a->format} formátumot. Ezek {$a->defaultformat} formátumra módosulnak (a portál alapformátuma). Egyes kapcsolódó adatok elvesznek. Biztosan folytatja?';
$string['frontpage'] = 'Kezdőoldal';
$string['frontpagebackup'] = 'A kezdőoldal biztonsági mentése';
$string['frontpagedefaultrole'] = 'Kezdőoldali alapszerep';
$string['frontpagefilters'] = 'Kezdőoldali szűrők';
$string['frontpageloggedin'] = 'A kezdőoldal elemei belépéskor';
$string['frontpageoverrides'] = 'Kezdőoldali engedélyek felülírása';
$string['frontpagequestions'] = 'A kezdőoldal kérdései';
$string['frontpagerestore'] = 'A kezdőoldal helyreállítása';
$string['frontpageroles'] = 'A kezdőoldal szerepei';
$string['frontpagesettings'] = 'A kezdőoldal beállításai';
$string['fullnamedisplay'] = 'Teljes név szerinti forma';
$string['fullnamedisplayprivate'] = 'Teljes név formája - magán';
$string['gdrequired'] = 'A GD-bővítményre a Moodle-nak a képek átalakításához szüksége van';
$string['generalsettings'] = 'Általános beállítások';
$string['geoipdbedition'] = 'GeoIP Adatbázis Kiadás';
$string['geoipdbedition_desc'] = 'Válassza ki a GeoIP adatbázis letöltendő kiadását. Felhívjuk figyelmét, hogy a GeoIP2-City adatbázis használatához érvényes (vásárolt) licenc szükséges.';
$string['geoipfile'] = 'GeoIP City adatbázis';
$string['geoipmaxmindaccid'] = 'MaxMind belépési ID';
$string['geoipmaxmindaccid_desc'] = 'A MaxMind API szolgáltatásban létrehozott fiók felhasználói azonosítója';
$string['geoipmaxmindlicensekey'] = 'A MaxMind API szolgáltatáson létrehozott fiók ID.';
$string['geoipmaxmindlicensekey_desc'] = 'A MaxMind API szolgáltatáson létrehozott fiók licenckulcsa.';
$string['getremoteaddrconf'] = 'Naplózott IP-cím forrása';
$string['globalsearch'] = 'Globális keresés';
$string['globalsearchmanage'] = 'Globális keresés kezelése';
$string['googlemapkey3'] = 'A Google Maps API V3 kulcsa';
$string['googlemapkey3_help'] = 'Speciális kódot kell megadnia, ha a Google Maps segítségével kíván IP-címeket megjeleníteni. A kód ingyenesen beszerezhető a <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a> címről.';
$string['gotofirst'] = 'Ugrás az első hiányzó szövegsorra';
$string['gradebook'] = 'Értékelésnapló';
$string['gradebookroles'] = 'Értékelt szerepek';
$string['gradeexport'] = 'Elsődleges értékelésexportálási módszerek';
$string['gradeexportdefault'] = 'Alapértelmezett értékelésexportálási módszer';
$string['gravatardefaulturl'] = 'Gravatar alapképének webcíme';
$string['gravatardefaulturl_help'] = 'A Gravatarnak szüksége van egy megjelenítendő alapképre, ha nem talál képet egy adott felhasználóhoz. Teljes webcímet adjon meg a képhez! Alapértelmezett képek készítéséhez való kódok elérhetők a <a href="https://docs.gravatar.com/api/avatars/images/">Gravatar for Developers - Avatar Requests</a> oldalon.';
$string['group_customfield'] = 'Egyedi csoportmezők';
$string['groupenrolmentkeypolicy'] = 'Csoportos beiratkozási kulcsra vonatkozó szabvány';
$string['groupenrolmentkeypolicy_desc'] = 'Bekapcsolása esetén a Moodle ellenőrzi, hogy a csoportos beiratkozási kulcsok megfelelnek-e a fenti beállítások szerinti jelszószabványnak.';
$string['grouping_customfield'] = 'Egyéni mezők csoportosítása';
$string['guestroleid'] = 'Vendégszerep';
$string['guestroleid_help'] = 'Ezt a szerepet a vendég automatikusan megkapja. Ideiglenesen azon be nem iratkozott felhasználók is megkapják, akik a kurzusba a vendéget beiratkoztató segédprogramon keresztül lépnek be.
';
$string['h5pgetcontenttypestask'] = 'Elérhető H5P tartalomtípusok letöltése a h5p.org portálról.';
$string['helpadminseesall'] = 'A portálnaptárban a rendszergazdák minden kurzusnaptár eseményét lássanak és szűrhessenek, vagy csak a kurzusukból származókat? A választástól függetlenül a rendszergazdák mindig minden kurzusnaptár eseményét kezelhetik, ha előbb ellátogatnak a kurzusba, majd közvetlenül belépnek annak naptárába.';
$string['helpcalendarcustomexport'] = 'Naptárexportálás során  az egyéni adattartományként való exportálás bekapcsolása. Ehhez előbb be kell kapcsolni a naptárexportálást.';
$string['helpexportlookahead'] = 'A naptár egyéni exportálásához hány nappal tekintsen előre a naptár?';
$string['helpexportlookback'] = 'A naptár egyéni exportálásához hány nappal tekintsen vissza a naptár?';
$string['helpforcetimezone'] = 'A felhasználók számára lehetővé teheti, hogy egyenként válasszák ki a saját időzónájukat, vagy dönthet úgy, hogy mindenkinek egyetlen időzónát biztosít.';
$string['helpshowicalsource'] = 'Kapcsolja be, ha importált iCal-eseményekhez szeretné megjeleníteni az iCalhoz tartozó nevet és hivatkozást';
$string['helpsitemaintenance'] = 'Verziófrissítések és egyéb tennivalók';
$string['helpstartofweek'] = 'Melyik nappal kezdődjék a naptárban a hét?';
$string['helpupcominglookahead'] = 'Alaphelyzetben a naptár hány nappal előre keressen közelgő eseményeket?';
$string['helpupcomingmaxevents'] = '(Maximum) hány közelgő eseményt lássanak a felhasználók alaphelyzetben?';
$string['helpweekenddays'] = 'A hét mely napjait kezelje a rendszer eltérő színben megjelenített \'ünnepnapként\'?';
$string['hiddenuserfields'] = 'Felhasználói mezők elrejtése';
$string['hidefromall'] = 'Elrejtés minden felhasználó elől';
$string['hidefromnone'] = 'Senki elől ne rejtse el';
$string['hidefromstudents'] = 'Elrejtés a tanulók elől';
$string['hookcallbacknotcallable'] = 'Ez a visszahívás nem működik. Ennek oka lehet, hogy az osztály vagy a metódus nem létezik, vagy hogy a metódus nem nyilvános.';
$string['hookcallbacks'] = 'Visszahívások';
$string['hookconfigoverride'] = 'Felülbírálva';
$string['hookconfigoverride_help'] = 'Ennek a visszahívásnak a definíciója felül lett írva a webhely konfigurációs fájljában, a config.php fájlban.';
$string['hookdeprecates'] = 'Elavult visszahívások';
$string['hookdescription'] = 'Leírás';
$string['hookunknown_desc'] = 'Az objektum, amelyre ez a visszahívás figyel, nem elérhető. Lehet, hogy eltávolították vagy átnevezték, vagy lehet, hogy a Moodle ezen verziójában nem érhető el.';
$string['hostname'] = 'Gazdagép neve';
$string['htmleditor'] = 'HTML-szerkesztő';
$string['htmleditorsettings'] = 'A HTML-szerkesztő beállításai';
$string['htmlsettings'] = 'HTML-beállítások';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP-biztonság';
$string['iconvrequired'] = 'Telepíteni kell az ICONV-bővítményt.';
$string['igbinary322buggyversion'] = 'PHP 7.2 futtatása során a portálon gondot okozhat a php-igbinary bővítmény. Ajánlott legalább 3.2.5 verzióra, avagy legalább PHP 7.3-ra frissítenie.';
$string['ignore'] = 'Kihagy';
$string['importantupdates_content'] = '<p>A Moodle 5.0-ban a Csevegés és a Felmérés tevékenységek nem elérhetők. Segédprogramként elérhetők a <a href="https://moodle.org/plugins/">Moodle  segédprogramkönyvtárában.</a>.</p>
<p>Ha továbbra is szeretné használni a Csevegést vagy a Felmérést a webhelyén, akkor a Moodle 5.0-ra való frissítéskor segéprogramként telepítheti őket.</p>';
$string['importantupdates_title'] = 'Fontos frissítés a Csevegés és a Felmérés tevékenységekhez.';
$string['includemoduleuserdata'] = 'Modul felhasználói adatainak hozzáadása';
$string['incompatibleblocks'] = 'A blokkok nem kompatibilisek';
$string['incompleteunicodesupport'] = 'A MySQL vagy a MariaDB aktuális telepítése \'utf8\' kódolást használ. Ez nem támogatja négybájtos karakterek, pl. emoji alkalmazását. Ezért rekordfrissítés során ezek a karakterek hibát eredményeznek, az adatbázisba küldött adatok pedig elvesznek. Állítsa át beállítását \'utf8mb4\'-re. További részleteket a dokumentációban talál.';
$string['indexdata'] = 'Adatok indexelése';
$string['indexinginfo'] = 'Portálja tartalmának indexálására ajánlott a  "Globális keresés indexálása"  ütemezett feladat használata.';
$string['installhijacked'] = 'A telepítést az eredeti IP-címről kell befejezni.';
$string['installsessionerror'] = 'A PHP-folyamat nem indítható el, ellenőrizze, hogy böngészőjében a sütik be vannak-e kapcsolva.';
$string['intlrecommended'] = 'Az Intl-bővítménnyel javítható a többnyelvű szövegek támogatása, például a portál nyelve szerinti rendezés.';
$string['intlrequired'] = 'A nemzetközi kiterjesztésre a többnyelvűség támogatása érdekében van szükség, pl. helyi nyelv szerinti rendezéshez és nemzetközi doménnevekhez.';
$string['invalidagedigitalconsent'] = 'A digitális hozzájárulási korhatár érvénytelen: {$a}';
$string['invalidforgottenpasswordurl'] = 'Az elfelejtett jelszó webcíme érvénytelen webcím.';
$string['invalidsection'] = 'Érvénytelen szekció.';
$string['invalidthemepreset'] = 'A kiválasztott előbeállított állomány nem Kompatibilis ezzel a stílussal. A SCSS fordítási hibája ez volt:  "{$a}"';
$string['invaliduserchangeme'] = 'A \'changeme\' felhasználói név fenntartott név - ezzel nem hozhat létre felhasználói nevet.';
$string['ipblocked'] = 'A portál jelenleg nem érhető el.';
$string['ipblocker'] = 'IP-blokkoló';
$string['ipblockersyntax'] = 'Minden tételt egy sorba írjon. Érvényes az a teljes IP-cím (pl. <b>192.168.10.1</b>), amely egyetlen gazdagépet azonosít; a részleges cím (pl. <b>192.168.</b>), amely bármely ilyen számokkal kezdődő címet azonosít; a CIDR-jelölés (pl. <b>231.54.211.0/20</b>); vagy az IP-címek tartománya (pl. <b>231.3.56.10-20</b>), ahol a tartomány a cím utolsó részére vonatkozik. A szöveges doménnevek (pl \'example.com\') használatát a rendszer nem támogatja, az üres sorokat és a  "#" karakter utáni szöveget pedig figyelmen kívül hagyja.';
$string['iplookup'] = 'IP-cím keresése';
$string['iplookupgeoplugin'] = '<a href="http://www.geoplugin.com">A geoPlugin</a> szolgáltatás földrajzi információkat keres. Pontosabb eredményekhez javasoljuk a MaxMind GeoIP City adatbázis helyi példányának telepítését.';
$string['iplookupinfo'] = 'Az ingyenes online NetGeo szervert IP-címek helyének kikereséséhez való. De az adatbázist már nem frissítik, így téves adatokkal szolgálhat. Ajánlott a MaxMind GeoIP adatbázisának helyi példányát telepíteni.<br />
Ha adott egy Google Térkép API V3 kulcs, az IP-cím helye a Google Térképen jelenik meg. Ehhez szükséges egy Google fiók és egy Google Térkép API kulcs igénylése. Ha nincs megadva Google Térkép API V3 kulcs, az IP-cím helyzete az OpenStreetMap-en jelenik meg.';
$string['iplookupmaxmindnote'] = 'Ez a termék a MaxMind által létrehozott GeoIP City adatokat tartalmazza, elérhetők a <a href="http://www.maxmind.com/">http://www.maxmind.com/</a> portálról.';
$string['iscustomadminwarnings'] = 'Portálja egyedi rendszergazdai könyvtárat használ. Ezt a lehetőséget a továbbiakban nem támogatjuk, a Moodle 4.2 verziója után töröljük.';
$string['ishttpswarning'] = 'Portálja nem HTTPS-t használ. A biztonság és más rendszerekkel való jobb együttműködés érdekében mindenképpen ajánlott áttérnie HTTPS-re.';
$string['keeptagnamecase'] = 'Címkenév betűalakjának megőrzése';
$string['lang'] = 'Alapnyelv';
$string['langcache'] = 'Nyelvi menü gyorsítótárba helyezése';
$string['langcache_desc'] = 'Nyelvi menü gyorsítótárba helyezése. Bekapcsolása esetén az elérhető fordítások a gyorsítótárba kerülnek. A gyorsítótár egy nyelvi csomag beépített nyelvcsomag-kezelővel  való telepítése vagy törlése esetén automatikusan frissítődik. A nyelvi csomag kézi telepítése esetén az összes gyorsítótár kiürítése funkcióval kell frissítenie a gyorsítótárban lévő csomagok listáját.';
$string['langlist'] = 'A nyelvi menü nyelvei';
$string['langmenu'] = 'A nyelvi menü megjelenítése';
$string['langmenuinsecurelayout'] = 'Nyelvi menü megjelenítése biztonságos elrendezésben';
$string['langmenuinsecurelayout_desc'] = 'Bekapcsolása esetén a felhasználó nyelvet módosíthat, miközben biztonságos elrendezés használata során teszttel vagy egyéb tevékenységgel próbálkozik.';
$string['langpackwillbeupdated'] = 'A verzióváltás során a Moodle megpróbálja frissíteni a kiválasztott nyelvi csomagot.';
$string['langstringcache'] = 'Az összes nyelvi szöveg gyorsítótárba helyezése';
$string['languagesettings'] = 'Nyelvi beállítások';
$string['latinexcelexport'] = 'Excel-kódolás';
$string['legacyfilesaddallowed'] = 'Korábbi kurzusállományokhoz való hozzáadás engedélyezése';
$string['legacyfilesaddallowed_help'] = 'Ha egy kurzusnak vannak korábbi kurzusállományai, engedélyezi ezekhez új állományok és mappák hozzáadását.';
$string['legacyfilesinnewcourses'] = 'Új kurzusokban szereplő korábbi kurzusállományok';
$string['legacyfilesinnewcourses_help'] = 'Alapesetben a korábbi kurzusállományok területe csak frissített kurzusokban érhető el. Ezzel a beállítással egyes funkciók, pl. az egyetlen tevékenység biztonsági mentése/visszaállítása, nem használhatók.';
$string['libcurlwarning'] = 'Libcurl CURLOPT_PROTOCOL támogatással nem található. Biztonsági okokból ajánlott friss Libcurl-telepítést használnia.';
$string['licensesettings'] = 'Licencbeállítások';
$string['linkadmincategories'] = 'Rendszergazdai kategóriák összekapcsolása';
$string['linkadmincategories_help'] = 'Bekapcsolása esetén a rendszergazdai kategóriák hivatkozásokként jelennek meg a rendszergazdai kategóriák oldalához.';
$string['loading'] = 'Betöltés';
$string['localetext'] = 'Az egész portál nyelvi környezete';
$string['localstringcustomization'] = 'Helyi szöveg testre szabása';
$string['location'] = 'Hely';
$string['locationsettings'] = 'Hely beállításai';
$string['locked'] = 'Zárolva';
$string['lockoutduration'] = 'Fiók felfüggesztésének időtartama';
$string['lockoutduration_desc'] = 'A felfüggesztett fiók ezen időtartam letelte után automatikusan újraindul.';
$string['lockoutemailbody'] = 'Kedves {$a->firstname}!<br>
<br>
A(z) {$a->username} felhasználónévre szóló,  \'{$a->sitename}\' szerveren lévő fiókját többszöri érvénytelen bejelentkezés miatt felfüggesztettük. <br>
<br>
A fiók azonnal visszakapcsolásához térjen át ide:<br>
<br>
{$a->link}<br>
<br>
A legtöbb levelező programban ez kék színű, kattintható hivatkozásként jelenik meg.
Ha ez nem működik, másolja ki a címet és illessze be a böngésző címsorába!<br>
<br>
Ha segítségre van szüksége, forduljon a portál rendszergazdájához:<br>
{$a->admin}';
$string['lockoutemailsubject'] = '{$a} szerveren futó fiókját felfüggesztettük.';
$string['lockouterrorunlock'] = 'A felfüggesztés feloldásához érvénytelen adatot adott meg.';
$string['lockoutthreshold'] = 'Fiók felfüggesztésének küszöbértéke';
$string['lockoutthreshold_desc'] = 'Válassza ki, hány érvénytelen bejelentkezési kísérlet után függesszük föl a fiók használatát. Ezzel segítheti a szervertámadások elleni védelmet.';
$string['lockoutwindow'] = 'Fiók felfüggesztését figyelő ablak';
$string['lockoutwindow_desc'] = 'Fiók felfüggesztésének figyelési ideje. Ezen idő eltelte után sikertelen próbálkozások elmaradása esetén a küszöbérték számlálója nullázódik.';
$string['lockrequestcategory'] = 'Kategóriaválasztás megakadályozása';
$string['log'] = 'Naplók';
$string['logguests'] = 'Vendég hozzáférésének naplózása';
$string['logguests_help'] = 'Ezzel bekapcsolja vendégek és be nem lépők tevékenységeinek naplózását. Nagy forgalmú portálokon a teljesítményre tekintettel kikapcsolható ez a naplózás. Éles portálokon azonban ajánlott bekapcsolva tartani.';
$string['logininfoinsecurelayout'] = 'Belépett felhasználó megjelenítése biztonságos elrendezésben';
$string['logininfoinsecurelayout_desc'] = 'Bekapcsolása esetén a navigációs sávon megjelenik a belépett felhasználó neve, miközben biztonságos elrendezés használata során teszttel vagy egyéb tevékenységgel próbálkozik.';
$string['loginpageautofocus'] = 'Bejelentkezési űrlap automatikus fókusza';
$string['loginpageautofocus_help'] = 'Bekapcsolásával javul a bejelentkező oldal használhatósága, de a mezők automatikus fókusza elérhetőségi gondokat vethet fel.';
$string['loglifetime'] = 'Naplók megőrzése ehhez';
$string['logo'] = 'Logó';
$string['logo_desc'] = 'Teljes logó egyes (alap-) stílusok díszítéséhez. A kép felbontása igen nagy is lehet, mert leskálázásra kerül sor (és a teljesítmény növelése érdekében gyorsítótárba kerül). A szélesebb, mint magasabb képek általában jobban mutatnak.';
$string['logocompact'] = 'Kompakt logó';
$string['logocompact_desc'] = 'A fenti logó kompakt változata, mint egy embléma, címer vagy ikon. A képnek kis méretben is jól láthatónak kell lenni.';
$string['logossettings'] = 'Logók';
$string['logstorenotrequired'] = 'Naplótároló nem szükséges';
$string['logstoressupported'] = 'A jelentést támogató naplótárolók';
$string['longtimewarning'] = '<b>Ne feledje, hogy ez a folyamat eltarthat egy ideig.</b>';
$string['mailnewline'] = 'Újsor-karakterek a levélben';
$string['maintenancemode'] = 'Karbantartási üzemmódban';
$string['maintenancemodeisscheduled'] = 'A portál {$a->min} percen és {$a->sec} másodpercen belül  karbantartási üzemmódba kapcsol.';
$string['maintenancemodeisscheduledlong'] = 'A portál {$a->hour} órán, {$a->min} percen, {$a->sec} másodpercen belül karbantartási üzemmódba kerül';
$string['maintfileopenerror'] = 'Hiba a karbantartási állományok megnyitása közben!';
$string['maintinprogress'] = 'A karbantartás folyamatban...';
$string['managecontextlock'] = 'Fagyassza be a környezetet';
$string['managecontextlocklocked'] = 'A(z) {$a->contextname} és minden leágazása be van fagyasztva.';
$string['managecontextlockunlocked'] = 'A(z) {$a->contextname} és minden leágazása fel van oldva.';
$string['managecontextunlock'] = 'Környezet befagyasztásának feloldása';
$string['managecustomfields'] = 'Egyedi mezőtípusok kezelése';
$string['manageformats'] = 'Kurzusformátumok kezelése';
$string['manageformatsgotosettings'] = 'Az alapformátum {$a} esetén megváltozik.';
$string['managelang'] = 'Kezelés';
$string['manageqbanks'] = 'Kérdésbank segédprogramjainak kezelése';
$string['manageqbehaviours'] = 'Kérdések viselkedésének kezelése';
$string['manageqtypes'] = 'Kérdéstípusok kezelése';
$string['maturity100'] = 'Béta';
$string['maturity150'] = 'Jelölt közzététele';
$string['maturity200'] = 'Stabil verzió';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Ötlet: - Próbálja futtatni a programot az --allow-unstable opcióval.';
$string['maturitycoreinfo'] = 'Portálján jelenleg a fejlesztés alatt álló  "{$a}" program fut.';
$string['maturitycorewarning'] = 'Olyan "{$a}" jelzéssel megjelölt verzióra kívánja frissíteni a Moodle-t, amely még nem használható élesben. Ellenőrizze, hogy valóban ezt akarja-e, és ehhez a Moodle STABIL változatának a forráskódját jelölte-e be. További részleteket olvashat a Moodle Docs alatt.';
$string['maxbytes'] = 'Maximálisan feltölthető állományméret';
$string['maxcharacter'] = 'Maximum {$a} karakter';
$string['maxconsecutiveidentchars'] = 'Egymást követő azonos karakterek';
$string['maxeditingtime'] = 'Maximális üzenet-szerkesztési idő';
$string['maxsizeperdownloadcoursefile'] = 'Maximális állományméret';
$string['maxsizeperdownloadcoursefile_desc'] = 'Maximális állományméret kurzustartalom letöltése esetén. Az ennél nagyobb állományokat nem tölti le.';
$string['maxtimelimit'] = 'Maximális időkorlát';
$string['maxtimelimit_desc'] = 'Itt adja meg másodpercben, legfeljebb mennyi ideig korlátozza a Moodle a PHP-futtatás eredményének megjelenítését. 0 esetén az alapbeállítás fog működni. Ha nincs saját időkorláttal rendelkező előtér-kiszolgáló, akkor állítsa az értéket alacsonyabbra a PHP-hibák naplózásához. CLI-programkódok esetén hatástalan.';
$string['maxusersperpage'] = 'Oldalankénti felhasználók maximális száma';
$string['mbstringrecommended'] = 'A portál teljesítményének javítása érdekében ajánlatos telepíteni az opcionális MBSTRING-könyvtárat, különösen, ha a portál támogatja nemlatin nyelvek használatát.';
$string['mbstringrequired'] = 'A portál teljesítményének növeléséhez telepítse a MBSTRING-könyvtárat, különösen nem latin nyelveket támogató portál esetén.';
$string['mediapluginavi'] = '.avi szűrő bekapcsolása';
$string['mediapluginflv'] = '.flv szűrő bekapcsolása';
$string['mediapluginimg'] = 'Kapcsolt képek automatikus beágyazásának engedélyezése';
$string['mediapluginmov'] = '.mov szűrő bekapcsolása';
$string['mediapluginmp3'] = '.mp3 szűrő bekapcsolása';
$string['mediapluginmpg'] = '.mpg szűrő bekapcsolása';
$string['mediapluginogg'] = 'Az .ogg szűrő bekapcsolása';
$string['mediapluginogv'] = 'Az .ogv szűrő bekapcsolása';
$string['mediapluginram'] = '.ram szűrő bekapcsolása';
$string['mediapluginrm'] = '.rm szűrő bekapcsolása';
$string['mediapluginrpm'] = '.rpm szűrő bekapcsolása';
$string['mediapluginwmv'] = '.wmv szűrő bekapcsolása';
$string['mediapluginyoutube'] = 'A YouTube hivatkozásszűrőjének bekapcsolása';
$string['messaging'] = 'Üzenetküldő rendszer bekapcsolása';
$string['messagingallowemailoverride'] = 'Értesítési e-mail felülírása';
$string['messagingallusers'] = 'Üzenetek engedélyezése a portálról bárki számára';
$string['messagingcategory'] = 'Üzenetküldés';
$string['messagingdefaultpressenter'] = 'Alapesetben a \'Küldés Enterrel\' bekapcsolva';
$string['messagingdeleteallnotificationsdelay'] = 'Az összes értesítés törlése';
$string['messagingdeletereadnotificationsdelay'] = 'Elolvasott értesítések törlése';
$string['messagingssettings'] = 'Üzenetküldési beállítások';
$string['minpassworddigits'] = 'Számjegyek';
$string['minpasswordlength'] = 'Jelszó hossza';
$string['minpasswordlower'] = 'Kisbetűk';
$string['minpasswordnonalphanum'] = 'Nem alfanumerikus karakterek';
$string['minpasswordupper'] = 'Nagybetűk';
$string['misc'] = 'Egyéb';
$string['mlbackendsettings'] = 'Gépi tanulási háttéralkalmazás beállításai';
$string['mnetrestore_extusers'] = '<strong>Megjegyzés</strong>: Ebben a biztonsági mentésben a Moodle Network olyan távoli felhasználói fiókjai szerepelnek, amelyeket a rendszer a folyamat részeként helyreállít.';
$string['mnetrestore_extusers_admin'] = '<strong>Megjegyzés:</strong> Ez a biztonsági mentés feltehetőleg egy másik Moodle-telepítésből való, a Moodle-hálózat távoli felhasználói fiókjait tartalmazza. A helyreállítási folyamat minden létrehozott fiókot a Moodle-hálózat gazdagépeihez illeszt. A nem egyező fiókok esetén automatikusan belső hitelesítésre kapcsol át (mnet helyett). Erről a helyreállítási napló tájékoztatja.';
$string['mnetrestore_extusers_mismatch'] = 'Megjegyzés: Ez a biztonsági mentés nyilvánvalóan egy másik Moodle-telepítésből való, és benne a Moodle Network olyan távoli felhasználói fiókjai szerepelnek, amelyek helyreállítása esetleg sikertelen lesz. Ezt a műveletet a rendszer nem támogatja. Ha biztos benne, hogy a Moodle ezen telepítésével hozta létre, illetve ha gondoskodni tud arról, hogy a Moodle Network összes gazdagépe konfigurálva legyen, úgy megpróbálkozhat a helyreállítással.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Megjegyzés:</strong> Ez a biztonsági mentés feltehetőleg egy másik Moodle-telepítésből való, a Moodle-hálózat távoli felhasználói fiókjait tartalmazza. Ilyen típusú helyreállítást nem hajthat végre. Forduljon a portál rendszergazdájához vagy felhasználói információk (modulok, állományok...) nélkül hajtsa végre a helyreállítást.';
$string['mnetrestore_extusers_switchuserauth'] = 'A Moodle-hálózat {$a->username} távoli felhasználója ({$a->mnethosturl} helyről) helyi {$a->auth} hitelesítésű felhasználóra váltott.';
$string['mobilenotconfiguredwarning'] = 'A Moodle mobil alkalmazása nincs bekapcsolva.';
$string['modassignmentinuse'] = 'Az Ön webhelye még mindig az Assignment 2.2 (Feladat) kiegészítőt használja. A frissítés előtt 1) készítsen biztonsági mentést minden olyan Assignment 2.2 (Feladat) tevékenységről, amelyet meg szeretne tartani, és állítsa vissza azokat Assignment tevékenységként, valamint 2) törölje az összes Assignment 2.2 adatot az adatbázisból.';
$string['modassignmentsubpluginsexist'] = 'Assignment 2.2. almodulok lehetnek jelen a rendszerben. A mod/assignment mappát és az összes almodulját távolítsa el a frissítés előtt.';
$string['modeditdefaults'] = 'Alapértékek tevékenységek beállításához';
$string['modsettings'] = 'Tevékenységek kezelése';
$string['modulesecurity'] = 'Modulbiztonság';
$string['moodlebrandedapp'] = 'Márkás Moodle-alkalmazás';
$string['moodlebrandedappreference'] = 'Vagy tegyen szert egy <a href="https://moodle.com/branded-app">Márkás Moodle-alkalmazásra</a> saját egyedi márkájával.';
$string['mustenablestats'] = 'A portálon nincs bekapcsolva a statisztika.';
$string['mycourses'] = 'Kurzusaim';
$string['mydashboard'] = 'A rendszer alapértelmezett irányítópultja';
$string['mymoodle'] = 'Irányítópult';
$string['mypage'] = 'Elsődleges Irányítópult-oldal';
$string['mypagelocked'] = 'Elsődleges oldal zárolása';
$string['myprofile'] = 'Elsődleges profiloldal';
$string['navadduserpostslinks'] = 'Felhasználói hozzászólások megtekintéséhez hivatkozások hozzáadása';
$string['navadduserpostslinks_help'] = 'Bekapcsolása esetén a navigáláshoz minden felhasználóhoz két hivatkozás adódik hozzá az adott felhasználó által kezdeményezett viták és az egész portálon vagy egyes kurzusokon belül a fórumokra részéről beérkező hozzászólások megtekintéséhez.';
$string['navcourselimit'] = 'Kurzuskorlát';
$string['navfilter'] = 'Egyedi menü szűrése';
$string['navfilter_desc'] = 'Az egyedi menü feldolgozása a Moodle szűrőkkel, melyek a <strong>Tartalom és Címsorok</strong>-ra vonatkoznak. Hasznos dinamikus egyéni menüelemek engedélyezésére.';
$string['navigationupgrade'] = 'Ez a verziófrissítés két új navigációs blokkot tartalmaz, melyek ezen blokkokat váltják fel: Adminisztráció, Kurzusok, Tevékenységek és Felhasználók. Ha ezekhez a blokkokhoz külön engedélyeket rendelt, ellenőrizze, hogy minden a kívánt módon működik-e.';
$string['navshowallcourses'] = 'Az összes kurzus megjelenítése';
$string['navshowcategories'] = 'Kurzuskategóriák megjelenítése';
$string['navshowfrontpagemods'] = 'A navigálás során látsszanak a kezdőoldali tevékenységek';
$string['navshowfrontpagemods_help'] = 'Bekapcsolása esetén a navigálás során a portáloldalak alatt látszanak a kezdőoldali tevékenységek. Ez a beállítás csak a Classic sablonon alapuló sablonokra vonatkozik.';
$string['navshowfullcoursenames'] = 'Teljes kurzuscímek megjelenítése';
$string['navshowfullcoursenames_help'] = 'Bekapcsolása esetén a navigáció során a rövid helyett a teljes kurzuscímek jelennek meg.';
$string['navshowmycoursecategories'] = 'Kurzuskategóriáim megjelenítése';
$string['navshowmycoursecategories_help'] = 'Bekapcsolása esetén a kurzusok megjelennek a felhasználó navigációs blokkjában a  kategóriák között (Classic alapú stílusok esetén).';
$string['navsortmycourseshiddenlast'] = 'Rejtett kurzusaim rendezése utoljára';
$string['navsortmycourseshiddenlast_help'] = 'Bekapcsolása esetén a rejtett kurzusok felsorolása a látható kurzusok után következik (azoknak, akik rejtett kurzusokat tekinthetnek meg). Ellenkező esetben láthatóságtól függetlenül minden kurzus rendezése a \'Kurzusaim rendezése\' beállításnak megfelelően történik.';
$string['navsortmycoursessort'] = 'Kurzusok rendezése a navigációk blokkban';
$string['navsortmycoursessort_help'] = 'A kurzusok listázása a Portáladminisztráció > Kurzusok > Kurzusok és kategóriák kezelésénél beállított sorrendben, vagy betűrendben történjen? A beállítás csak a Classic-on alapuló stílusoknál érvényes.';
$string['never'] = 'Soha';
$string['neverdeleteruns'] = 'Profilkészítések soha ne törlődjenek';
$string['newestdocindexed'] = 'Legújabb indexált dokumentum';
$string['nobookmarksforuser'] = 'Nincsenek könyvjelzői.';
$string['nodatabase'] = 'Nincs adatbázis';
$string['noemaileverwarning'] = '<strong>Figyelem:</strong> Minden kimenő levél küldése ki lett kapcsolva';
$string['nohttpsformobilewarning'] = 'Ajánlatos érvényes tanúsítvánnyal rendelkező HTTPS-t bekapcsolni. A Moodle először mindig biztonságos csatlakozást próbál használni.';
$string['nomissingstrings'] = 'Nincs hiányzó szöveg';
$string['none'] = 'Nincs';
$string['nonewsettings'] = 'A frissítés során nem került sor új beállítások hozzáadására.';
$string['nonexistentbookmark'] = 'A kért könyvjelző nem létezik.';
$string['noreplyaddress'] = 'Választ nem váró cím';
$string['noreplydomain'] = 'Ne válaszolj és domén';
$string['noreplydomaindetail'] = 'A Ne válaszolj cím és a konfigurált domének beállításai';
$string['noresults'] = 'Nincs eredmény.';
$string['noroles'] = 'Nincs szerep.';
$string['nosupportedlogstore'] = 'Nincs  támogatott naplótároló';
$string['noteunneededblocks'] = 'Megjegyzés: A megjelenítésre beállított blokkok nem jelennek meg a \'Blokk hozzáadása\' menüben egy kurzusban, ha a téma beállításban szerepel a \'Nem szükséges blokkok\'.';
$string['notifications'] = 'Értesítések';
$string['notifyloginfailures'] = 'Sikertelen belépésekről e-mailben értesítendő';
$string['notifyloginthreshold'] = 'E-mailben történt értesítések küszöbértéke';
$string['notloggedinroleid'] = 'Látogatói szerep';
$string['numberofmissingstrings'] = 'Hiányzó szövegek száma: {$a}';
$string['numberofstrings'] = 'Összes szövegszám: {$a->strings}<br></br>Hiányzó: {$a->missing} ({$a->missingpercent} %)';
$string['oauthrefreshtokenexpired'] = '{$a->siteurl} portálján az egyik {$a->issuer}  OAuth szolgáltatás frissítési vezérjele lejárt. Emiatt a szolgáltatást használó segédprogramok korlátozottan fognak működni. Ennek elhárításához látogasson el az OAuth 2 szolgáltatások beállítási oldalára és kattintson a szolgáltatás táblázatának "Rendszerfiók csatlakoztatása" sorában lévő ikonra. Az OAuth rendszerbe mindig ugyanarról a fiókról jelentkezzen be.';
$string['oauthrefreshtokenexpiredshort'] = '{$a->siteurl} portálján a(z) {$a->issuer} OAuth frissítési token lejárt.';
$string['onlynoreply'] = 'Csak ha Ne válaszolj címről érkezik';
$string['opcacherecommended'] = 'A PHP műveleti kód gyorsítótárazása javítja a teljesítményt és csökkenti a memóriaszükségletet. Az OPcache kibővítés használata ajánlott és teljes mértékben támogatott.';
$string['opensslrecommended'] = 'Határozottan ajánlott az OpenSSL-könyvtár telepítése - ezzel kapcsolható be a hálózati Moodle.';
$string['opensslrequired'] = 'A biztonságosabb rejtjelezés érdekében a Moodle előírja a OpenSSL PHP-kiterjesztés használatát.';
$string['opentowebcrawlers'] = 'A Google engedélyezése';
$string['optionalmaintenancemessage'] = 'Opcionális karbantartási üzenet';
$string['order1'] = 'Első';
$string['order2'] = 'Második';
$string['order3'] = 'Harmadik';
$string['order4'] = 'Negyedik';
$string['outgoingmailconfig'] = 'Kimenő levél beállításai';
$string['overridetossl'] = 'A bejelentkezési HTTPS már nem használható. Az adott előfordulás SSL-hez kerül. A figyelmeztetés elkerüléséhez módosítsa a wwwroot megadását a config.php fájlban https://-re.';
$string['pageinfodebugsummary'] = 'Ez az oldal: {$a}';
$string['passwordchangelogout'] = 'Jelszómódosítás után kilépés';
$string['passwordchangelogout_desc'] = 'Bekapcsolása esetén jelszómódosítás során a böngésző minden egyéb eseményt lezár (a beállítás nem érinti a tömeges felhasználófeltöltés esetén végrehajtott jelszómódosításokat).';
$string['passwordchangetokendeletion'] = 'Jelszómódosítás után a webszolgáltatás-hozzáférési tokenjének törlése';
$string['passwordchangetokendeletion_desc'] = 'Bekapcsolása esetén jelszómódosítás esetén a felhasználó összes webszolgáltatás-hozzáférési tokenje törlődik.';
$string['passwordpolicy'] = 'Jelszószabvány';
$string['passwordpolicycheckonlogin'] = 'Jelszó ellenőrzése belépéskor';
$string['passwordresettime'] = 'Jelszó-visszaállítási kérelem érvényesítésére rendelkezésre álló maximális idő';
$string['passwordreuselimit'] = 'Jelszórotáció határa';
$string['passwordreuselimit_desc'] = 'Hányszor kell jelszót módosítani, mielőtt a korábbit újból használhatja. A korábbi jelszavakat a helyi adatbázistábla tárolja. Előfordulhat, hogy egyes külső hitelesítő segédprogramokkal ez nem működik.';
$string['pathtodot'] = 'Útvonal a dothoz';
$string['pathtodot_help'] = 'Útvonal a dothoz. Linux alatt például /usr/bin/dot. Windows esetén pl. C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe, Mac esetén pedig pl. /opt/local/bin/dot. Ahhoz, hogy DOT-állományokból grafikát tudjon előállítani, rendelkeznie kell telepített dot-programmal és itt hivatkoznia kell rá.';
$string['pathtodu'] = 'A du útvonala';
$string['pathtogs'] = 'Útvonal a  ghostscripthez';
$string['pathtogs_help'] = 'A Linuxok többségénél ez maradhat \'/usr/bin/gs\'. Windows alatt ez feltehetőleg \'c:\\gs\\bin\\gswin32c.exe\' (az útvonal nem tartalmazhat szóközöket - szükség esetén másolja a \'gswin32c.exe\' és a \'gsdll32.dll\' fájlt egy új, szóközt az útvonalban nem tartalmazó mappába).';
$string['pathtopdftoppm'] = 'A pdftoppm útvonala';
$string['pathtopdftoppm_help'] = 'A <a href="https://poppler.freedesktop.org/">Poppler</a> olyan PDF-kezelő könyvtár, amelynek része a PDF-et PNG-be konvertáló pdftoppm eszköz. A teljesítménye általában jobb a Ghostscripténél, különösen nagy fájlok esetén. Ahol elérhető, ott a Ghostscript helyett a pdftoppm használatára kerül sor. Linuxos telepítések esetén az útvonal többnyire maradhat /usr/bin/pdftoppm. Egyéb esetben telepíteni kell a Poppler segédeszközeit vagy csomagját. Windows esetén az eszközt a Cygwin tartalmazza.';
$string['pathtopgdump'] = 'A pg_dump útvonala';
$string['pathtopgdumpdesc'] = 'Ezt csak akkor kell megadni, ha egynél több pg_dump van a rendszerben (ha pl. a postgresql egynél több verziója van telepítve)';
$string['pathtopgdumpinvalid'] = 'Érvénytelen pg_dump-útvonal - vagy az útvonal hibás, vagy a kód nem futtatható';
$string['pathtophp'] = 'A PHP CLI útvonala';
$string['pathtopsql'] = 'A psql útvonala';
$string['pathtopsqldesc'] = 'Ezt csak akkor kell megadni, ha egynél több psql van a rendszerben (ha pl. a postgresql egynél több verziója van telepítve)';
$string['pathtopsqlinvalid'] = 'Érvénytelen psql-útvonal - vagy az útvonal hibás, vagy a kód nem futtatható';
$string['pathtopython'] = 'A Python útvonala';
$string['pathtopythondesc'] = 'A futtatható Python-kód útvonala (mind a Python 2, mind a Python 3 elfogadható)';
$string['pathtosassc'] = 'Az SassC útvonala';
$string['pathtosassc_help'] = 'Ha megadja az SassC helyét, akkor az SASS-fordító a Moodle szerinti PHP-től átkerül az SassC-hez. További információk: https://github.com/sass/sassc .';
$string['pcreunicodewarning'] = 'Ajánlatos az unikódos karaterekkel kompatibilis PCRE PHP kiegészítés használata.';
$string['perfdebug'] = 'Teljesítményről szóló tájékoztató';
$string['performance'] = 'Teljesítmény';
$string['pgcluster'] = 'PostgreSQL-fürt';
$string['pgclusterdescription'] = 'A PostgreSQL-verzió/-fürt paramétere parancssori műveletekhez. Ha csak egy postgresql van a rendszerén telepítve, illetve ha nem biztos abban, melyik van telepítve, akkor hagyja ezt a mezőt üresen.';
$string['phpfloatproblem'] = 'A PHP lebegőpontos számainak - {$a} - kezelésében váratlan hiba történt.';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'Portálja regisztrálva van, utolsó frissítésének időpontja: {$a}.<br />
A frissítés ütemezetten történik. Kézzel bármikor elvégezheti a frissítést.';
$string['pleaserefreshregistrationnewdata'] = 'A regisztrációs adatok módosultak. Erősítse meg a \'Regisztráció frissítése\' gombbal.';
$string['pleaserefreshregistrationunknown'] = 'Portáljának regisztrálási időpontja ismeretlen. A \'Regisztráció frissítése\' gombbal aktualizálja, vagy automatikus frissítéshez kapcsolja be az ütemezett \'Portál regisztrálása\' feladatot.';
$string['plugin'] = 'Segédprogram';
$string['plugin_disabled'] = '{$a} letiltva.';
$string['plugin_enabled'] = '{$a} engedélyezve.';
$string['plugins'] = 'Segédprogramok';
$string['pluginscheck'] = 'Segédprogramok kapcsolódásainak ellenőrzése';
$string['pluginscheckfailed'] = 'Kapcsolódások ellenőrzése {$a->pluginslist} esetén sikertelen.';
$string['pluginschecktodo'] = 'A segédprogramokkal kapcsolatos összes követelményt teljesítenie kell, mielőtt továbblép a Moodle ezen verziójának a telepítésével.';
$string['pluginsoverview'] = 'Segédprogramok áttekintése';
$string['pluginsoverviewsee'] = 'A részleteket lásd a <a href="{$a->url}">segédprogramok áttekintése</a> oldalon.';
$string['policysettings'] = 'Házirend beállításai';
$string['privacy:metadata'] = 'Az  Administration segédprogram semmilyen személyes adatot nem tárol.';
$string['privacyandpolicies'] = 'Adatvédelem és házirendek';
$string['privacysettings'] = 'Adatvédelmi beállítások';
$string['profilecategory'] = 'Kategória';
$string['profilecategoryname'] = 'Kategórianév (egyedinek kell lennie)';
$string['profilecategorynamenotunique'] = 'Ezt a kategórianevet már használják';
$string['profilecommonsettings'] = 'Általános beállítások';
$string['profileconfirmcategorydeletion'] = 'Ebben a kategóriában olyan mező(k) van(nak), amely(ek) a felette lévő kategóriába kerül(nek) át (vagy - legfelső kategória esetén - az alá).<br />Biztosan törli a kategóriát?';
$string['profileconfirmfielddeletion'] = 'Ebben a mezőben felhasználói rekord(ok) van(nak), amely(ek)et a rendszer törölni fog.<br />Biztosan törli a mezőt?';
$string['profilecreatecategory'] = 'Új profilkategória létrehozása';
$string['profilecreatefield'] = 'Új profilmező létrehozása:';
$string['profilecreatenewcategory'] = 'Új kategória létrehozása';
$string['profilecreatenewfield'] = 'Új \'{$a}\' profilmező létrehozása';
$string['profiledefaultcategory'] = 'Egyéb mezők';
$string['profiledefaultchecked'] = 'Alaphelyzetben ellenőrizve';
$string['profiledefaultdata'] = 'Alapérték';
$string['profiledeletecategory'] = 'Kategória törlése';
$string['profiledeletefield'] = '\'{$a}\' mező törlése';
$string['profiledescription'] = 'A mező leírása';
$string['profiledscript'] = 'A kód bekerült a profilba.';
$string['profiledscriptview'] = 'A kód profiladatainak megtekintése';
$string['profileeditcategory'] = 'Kategória szerkesztése: {$a}';
$string['profileeditfield'] = 'Profilmező szerkesztése: {$a}';
$string['profilefield'] = 'Profilmező';
$string['profilefieldcolumns'] = 'Oszlopok';
$string['profilefieldispassword'] = 'Ez jelszómező?';
$string['profilefieldlink'] = 'Hivatkozás';
$string['profilefieldlink_help'] = 'A szöveg hivatkozássá alakításához adjon meg egy $$-t tartalmazó webcímet, ahol a $$ helyére kerül a szöveg. Például egy Twitter-azonosító hivatkozássá alakításához írja be a http://twitter.com/$$-t.';
$string['profilefieldlinktarget'] = 'Hivatkozás célpontja';
$string['profilefieldmaxlength'] = 'Karakterek száma';
$string['profilefieldmaxlength_help'] = 'A \'Felhasználó adatainak megjelenítése\' beállításban a mező használatához a karakterek számát legfeljebb 255-re kell beállítani.';
$string['profilefieldrows'] = 'Sorok';
$string['profilefields'] = 'Felhasználói profilmezők';
$string['profilefieldsize'] = 'Megjelenítési méret';
$string['profileforceunique'] = 'Az adatok egyediek legyenek?';
$string['profileinvaliddata'] = 'Érvénytelen érték';
$string['profilelocked'] = 'A mező zárolva van?';
$string['profilemenudefaultnotinoptions'] = 'Az alapérték nem szerepel a lehetőségek között';
$string['profilemenunooptions'] = 'Nincsenek megadva menüpontok';
$string['profilemenuoptions'] = 'Menüpontok (soronként egy)';
$string['profilemenutoofewoptions'] = 'Legalább két menüpontot meg kell adnia';
$string['profilename'] = 'Név';
$string['profilenofieldsdefined'] = 'Nincsenek megadva mezők';
$string['profilerequired'] = 'Szükség van erre a mezőre?';
$string['profileroles'] = 'Látható szerepek profilja';
$string['profilesforenrolledusersonly'] = 'Profil csak beiratkozott felhasználó esetén';
$string['profileshortname'] = 'Rövid cím (egyedinek kell lennie)';
$string['profileshortnameinvalid'] = 'Ez a rövid név csak betűket, számokat vagy aláhúzást (_) tartalmazhat.';
$string['profileshortnamenotunique'] = 'Ezt a rövid címet már használják';
$string['profilesignup'] = 'Látsszon a belépési oldalon?';
$string['profilespecificsettings'] = 'Konkrét beállítások';
$string['profilevisible'] = 'Ki látja ezt a mezőt?';
$string['profilevisible_help'] = '* Láthatatlan - Csak a rendszergazda által látható magánadatokhoz
* Felhasználó számára látható - a felhasználó és a rendszergazda által látható magánadatokhoz
* Felhasználó, tanár és rendszergazda számára  látható - Felhasználó, tanár és rendszergazda által (kurzusprofilon) látható magánadatokhoz
* Bárki számára látható';
$string['profilevisibleall'] = 'Mindenki látja';
$string['profilevisiblenone'] = 'Nem látható';
$string['profilevisibleprivate'] = 'A felhasználó látja';
$string['profilevisibleteachers'] = 'Látható a felhasználó, a tanárok és a rendszergazdák számára';
$string['profiling'] = 'Profilkészítés';
$string['profilingallowall'] = 'Folyamatos profilkészítés';
$string['profilingallowall_help'] = 'Bekapcsolása esetén bármikor bárhol (PGC) használhatja a PROFILEALL paramétert az összes végrehajtott kód profilkészítéséhez a Moodle-folyamat teljes tartama alatt. Leállítására használja a PROFILEALLSTOP paramétert. ';
$string['profilingallowme'] = 'Választható profilkészítés';
$string['profilingallowme_help'] = 'Bekapcsolása esetén bárhol (PGC) használhatja a PROFILEME paramétert, és sor kerül az adott kód profilkészítésére. A profilkészítés megelőzésére használja a DONTPROFILEME paramétert. ';
$string['profilingautofrec'] = 'Automatikus profilkészítés';
$string['profilingautofrec_help'] = 'Beállítása esetén (véletlenszerűen, a megadott 1/XXX frekvencia alapján) kiválaszt valamely kérelmet és automatikusan elkészíti profilját, az eredményeket további elemzéshez eltárolja. Az ilyen profilkészítés tekintetbe veszi a beiktat/kihagy beállításokat. 0-ra állítva kikapcsolja az automatikus profilkészítést.';
$string['profilingenabled'] = 'Profilkészítés bekapcsolása';
$string['profilingenabled_help'] = 'Bekapcsolása esetén a portálon elérhető lesz a profilkészítés, melynek  viselkedését a következők szerint állíthatja be. ';
$string['profilingexcluded'] = 'Profilkészítés kihagyása';
$string['profilingexcluded_help'] = 'Azon (vesszővel elválasztott, a wwwroot útvonalat teljesen kihagyó, meghívható) webcímek listája, amelyeket kihagy azon profilkészítésből, amely a \'Profilkészítés ezekről\' beállításban van megadva.';
$string['profilingimportprefix'] = 'Importálási előtag beállítása';
$string['profilingimportprefix_desc'] = 'Az egyszerűbb kereséshez minden importált profilfuttatás az itt megadott előtaggal egészül ki.';
$string['profilingincluded'] = 'Profilkészítés ezekről';
$string['profilingincluded_help'] = 'Azon (vesszővel elválasztott, a wwwroot útvonalat teljesen kihagyó, meghívható) webcímek listája, amelyekről automatikusan profil készül. Pl.:  /index.php, /course/view.php. Bárhol elfogadja a * karakterhelyettesítőt is, pl: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Profilkészítések megőrződjenek';
$string['profilinglifetime_help'] = 'Adja meg, mennyi ideig kívánja megőrizni a régi profilkészítéseket. A régiek időről időre törlődnek. A folyamatból kimaradnak a \'referenciaprofilok\' névvel megjelöltek.';
$string['profilingslow'] = 'Lassú oldalakról profil készítése';
$string['profilingslow_help'] = 'Másodpercekben megadott minimális idő esetén az annál lassabb oldalak a profilba kerülnek. Csak az azonos kódhoz meglévő profilnál lassabb profilok őrződnek meg. Kikapcsoláshoz állítson be 0-t. Ez figyelembe veszi a kivételes beállításokat.';
$string['protectusernames'] = 'Felhasználónevek védelme';
$string['proxybypass'] = 'Proxyt elkerülő gazdagépek';
$string['proxyhost'] = 'Proxy-gazdagép';
$string['proxypassword'] = 'Proxy-jelszó';
$string['proxyport'] = 'Proxy-port';
$string['proxytype'] = 'Proxy típusa';
$string['proxyuser'] = 'Proxy-felhasználó';
$string['purgecaches'] = 'Az összes gyorsítótár kiürítése';
$string['purgecachesconfirm'] = 'A Moodle gyorsítótárazni tud stílusokat, JavaScriptet, nyelvi szövegeket, szűrt szövegeket, RSS-híreket és további számított adatot. A gyorsítótárak kiürítésével az adatok törlődnek a szerverről, a böngészőknek pedig újból be kell olvasni ezeket, így biztos lehet benne, hogy a jelenlegi kód által készített legfrissebbek értékeket látja. A gyorsítótárak kiürítése nem veszélyes, de a portál működése lassabbnak tűnhet, amíg a szerver és az ügyfelek kiszámítják és gyorsítótárba helyezik az új adatokat.';
$string['purgecachesfinished'] = 'Az összes gyorsítótár kiürítése megtörtént.';
$string['purgecachesnoneselected'] = 'Válasszon ki egy vagy több véglegesen kiürítendő gyorsítótárat';
$string['purgecachespage'] = 'Gyorsítótárak kiürítése';
$string['purgecoursecache'] = 'Kurzusok';
$string['purgefiltercache'] = 'Szövegszűrők';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Nyelvi szövegek';
$string['purgemuc'] = 'Az összes MUC-gyorsítótár';
$string['purgeothercaches'] = 'Az összes állományt tartalmazó és egyéb gyorsítótár';
$string['purgeselectedcaches'] = 'Kiválasztott gyorsítótárak végleges kiürítése';
$string['purgeselectedcachesfinished'] = 'A kiválasztott gyorsítótárak végleges kiürítése megtörtént.';
$string['purgetemplates'] = 'Sablonok';
$string['purgethemecache'] = 'Témák';
$string['query'] = 'Lekérdezés';
$string['question'] = 'Kérdés';
$string['questionbehaviours'] = 'Kérdések viselkedése';
$string['questioncwqpfscheck'] = 'Valamely tesztben egy vagy több \'véletlenszerűen kiválasztott\' kérdés úgy van beállítva, hogy osztott és osztatlan kérdéskategóriák egyvelegéből válasszon kérdéseket. Részletesebb leírást olvashat erről <a href="{$a->reporturl}">itt</a> és a Moodle Docs oldalon <a href="{$a->docsurl}">itt</a>.';
$string['questioncwqpfsok'] = 'Rendben. Tesztjei között nem szerepelnek  \'véletlenszerűen kiválasztott\', megosztott és megosztatlan kérdéskategóriák egyvelegéből választandó kérdések.';
$string['questiontype'] = 'Kérdéstípus';
$string['questiontypes'] = 'Kérdéstípusok';
$string['quizattemptsupgradedmessage'] = 'A Moodle 2.1 átszabta a kérdéseket. Az adatbázis-frissítést későbbre lehetett halasztani, de a 2.7-re frissítés előtt végre kellett hajtani.';
$string['recaptchaprivatekey'] = 'A ReCAPTCHA magánkulcsa';
$string['recaptchapublickey'] = 'A ReCAPTCHA portálkulcsa';
$string['referrernone'] = 'Alapböngésző';
$string['referrerpolicy'] = 'Hivatkozási házirend';
$string['referrerpolicydesc'] = 'Állítsa be a portáljáról érkező válaszok hivatkozási házirendjének fejlécét.';
$string['register'] = 'Regisztrálja portálját.';
$string['registration'] = 'Regisztráció';
$string['registration_help'] = 'Ha regisztrál:

* Biztonsági értesítéseket kap
* Portáljáról bekapcsolhatja a mobil alkalmazás leküldéses értesítéseit
* Gazdagítja a közösségre vonatkozó Moodle-statisztikánkat';
$string['registrationwarning'] = 'Ne maradjon le fontos frissítésekről és biztonsági riasztásokról!';
$string['registrationwarningcontactadmin'] = 'Ezt a portált még nem regisztrálták. Kérje meg rendszergazdáját a regisztrálásra, hogy ne maradjon le a fontos frissítésekről!';
$string['releasenoteslink'] = 'A Moodle ezen verziójának adataival kapcsolatosan olvassa el az online <a target="_blank" href="{$a}">Változatra vonatkozó megjegyzések</a>et';
$string['rememberuserlicensepref'] = 'Emlékezzen a felhasználói engedély beállítására';
$string['rememberuserlicensepref_help'] = 'Bekapcsolása esetén a felhasználó által legutóbb használt engedély előre kiválasztódik, amikor egy fájlt feltöltenek a fájlválasztóba. Ellenkező esetben az alapértelmezett portálengedély lesz előre kiválasztva.';
$string['rememberusername'] = 'Felhasználónév megjegyzése';
$string['rememberusername_desc'] = 'Kapcsolja be, ha a felhasználók bejelentkezésekor állandó sütikben kívánja megőrizni a felhasználónevüket. Hozzájárulásuk nélküli használata magánjogot sérthet.';
$string['replacefrontsearch'] = 'Kezdőoldali kurzuskeresésre használatos';
$string['reportsmanage'] = 'Jelentések kezelése';
$string['required'] = 'Szükséges';
$string['requiredentrieschanged'] = 'Megjegyzés: Frissítés után a \'Megtekintés előtt kitöltendő bejegyzések\' szükségesek lesznek az alábbi adatbázis-műveletekhez: <br/>{$a->text}<br/>';
$string['requiremodintro'] = 'Tevékenység leírásának előírása';
$string['requiremodintro_desc'] = 'Bekapcsolása esetén a felhasználóknak minden tevékenységhez leírást kell megadni.';
$string['requires'] = 'Előfeltétel';
$string['resetindentation'] = 'A behúzás visszaállítása az egész oldalon';
$string['resetindentation_help'] = 'Ez eltávolítja a korábban a webhelyen található összes kurzusra a {$a->format}-ban beállított behúzásokat.';
$string['resetindentation_title'] = 'A behúzás visszaállítása az egész oldalon?';
$string['resetindentationsuccess'] = 'Behúzás visszaállítása.';
$string['restorecourse'] = 'Kurzus visszaállítása';
$string['restorernewroleid'] = 'Helyreállítók kurzusbeli szerepe';
$string['restorernewroleid_help'] = 'Ha a felhasználó még nem rendelkezik engedéllyel az újonnan helyreállított kurzusok kezeléséhez, akkor automatikusan megkapja ezt a szerepet és szükség esetén beíratására is sor kerül. Válassza az "Egy sem" pontot, ha a helyreállítók részére nem kívánja engedélyezni minden újonnan helyreállított kurzusok kezelését.';
$string['resultfilter'] = 'Szűrés eredmény alapján';
$string['reverseproxy'] = 'Fordított proxy';
$string['reverseproxyignore'] = 'Fordított proxyk kihagyása';
$string['riskconfig'] = 'A felhasználók módosíthatják a portál beállításait és működését';
$string['riskconfigshort'] = 'Konfigurációs veszély';
$string['riskdataloss'] = 'A felhasználók terjedelmes tartalmat és információkat tehetnek tönkre.';
$string['riskdatalossshort'] = 'Adatvesztés kockázata';
$string['riskmanagetrust'] = 'A felhasználók módosíthatják más felhasználók megbízhatósági beállításait';
$string['riskmanagetrustshort'] = 'Megbízhatóság kezelése';
$string['riskpersonal'] = 'A felhasználók hozzáférhetnek más felhasználók magánadataihoz';
$string['riskpersonalshort'] = 'Személyes adatok veszélyben';
$string['riskspam'] = 'A felhasználók levélszemetet küldhetnek a portál felhasználóinak és másoknak';
$string['riskspamshort'] = 'Levélszemét veszélye';
$string['riskxss'] = 'A felhasználók hozzáadhatnak portálok közötti kódolást (XSS) engedélyező állományokat és szövegeket';
$string['riskxssshort'] = 'XSS-veszély';
$string['roleswithexceptions'] = '{$a->roles}, {$a->exceptions} kivétellel';
$string['rssglobaldisabled'] = 'Portálszinten kikapcsolva';
$string['save'] = 'Mentés';
$string['savechanges'] = 'Változások mentése';
$string['scssinvalid'] = 'Az SCSS-kód érvénytelen, {$a} esetén nem működik.';
$string['search'] = 'Keresés';
$string['searchablecourses'] = 'Kereshető kurzusok';
$string['searchallavailablecourses'] = 'Kereshető kurzusok';
$string['searchallavailablecourses_desc'] = 'Egyes esetekben a keresőmotor nagyszámú kurzusok között nem tud keresni. Ha szűkítenie kell a keresést, korlátozza azt felvett kurzusokra.';
$string['searchallavailablecourses_off'] = 'Keresés csak felvett kurzusokban';
$string['searchallavailablecourses_on'] = 'Keresés minden elérhető kurzusban';
$string['searchallavailablecoursesdesc'] = 'Ha a keresés felvett kurzusokra van beállítva, akkor a keresés csak a felhasználó által felvett kurzusok adataira (cím és összegzés) és tartalmára korlátozódik. Egyéb esetben a keresés kiterjed minden olyan kurzusra, amelyhez a felhasználó hozzáfér.';
$string['searchalldeleted'] = 'Minden indexált tartalom törölve lett.';
$string['searchalternatesettings'] = 'Csak választható beállítások lekérdezése';
$string['searchalternatesettings_desc'] = 'Ha kitölti ezeket a beállításokat, a \'Globális keresés kezelése\' oldalon a csak lekérdezés keresőmotorja lehetőség alatt kiválaszthatja a \'választható beállítások\'-at ehhez a keresőmotorhoz. Ez csak akkor hasznos, ha két azonos típusú keresőmotor között mozog.';
$string['searchareadisabled'] = 'Keresési terület kikapcsolva';
$string['searchareaenabled'] = 'Keresési terület bekapcsolva';
$string['searchareas'] = 'Keresési területek';
$string['searchbanner'] = 'Keresési adatok';
$string['searchbannerenable'] = 'Keresési adatok megjelenítése';
$string['searchbannerenable_desc'] = 'Bekapcsolása esetén az alábbi szöveg jelenik meg minden felhasználó számára a kereső képernyő tetején. Ezzel tájékoztathatja a felhasználókat, mikor kerül sorra a keresőmotor karbantartása.';
$string['searchdefaultcategory'] = 'Alapvető keresési kategória';
$string['searchdefaultcategory_desc'] = 'Alapesetben a kiválasztott keresési területhez tartozó kategória eredményei jelennek meg.';
$string['searchdeleteindex'] = 'Minden indexált tartalom törlése';
$string['searchdisplay'] = 'Keresési eredmények megjelenítésének a lehetőségei';
$string['searchenablecategories'] = 'Az eredmények megjelenítése külön kategóriákban';
$string['searchenablecategories_desc'] = 'Bekapcsolása esetén a keresési eredmények külön kategóriákban jelennek meg.';
$string['searchengine'] = 'Keresőmotor';
$string['searchenginealternatesettings'] = '{$a} (választható beállítások)';
$string['searchenginequeryonly'] = 'Csak lekérdező keresőmotor';
$string['searchenginequeryonly_desc'] = 'Ez a keresőmotor csak lekérdezésre használatos, indexálásra nem. Ezzel újraindexálást hajthat végre egy másik keresőmotorral, miközben a felhasználói lekérdezések innen folytatódnak.';
$string['searchenginequeryonly_none'] = 'Egy sem (fő keresőmotor használata a lekérdezésekhez)';
$string['searchenginequeryonlysame'] = 'A csak lekérdező keresőmotor és a fő keresőmotor nem állítható ugyanarra az értékre.';
$string['searchhideallcategory'] = 'Az összes eredménykategória elrejtése';
$string['searchhideallcategory_desc'] = 'Bejelölése esetén a kategória eredményeivel együtt rejtve lesz a keresési eredmény képernyőjén.';
$string['searchincludeallcourses'] = 'Az összes látható kurzust beleértve';
$string['searchincludeallcourses_desc'] = 'Bekapcsolása esetén a felhasználó számára látható kurzusok adataira (cím és összegzés) korlátozódik, akkor is, ha azok tartalmához nem fér hozzá .';
$string['searchindexactions'] = 'Lépések indexálása';
$string['searchindexdeleted'] = 'Index törölve';
$string['searchindextime'] = 'Indexálás időkorlátja';
$string['searchindextime_desc'] = 'Nagy mennyiségű új tartalom indexálása során az ütemezett feladat az időkorlát elérésekor leáll. Akkor folytatódik, amikor a feladatra újból sor kerül.';
$string['searchindexupdated'] = 'Keresőmotor tartalma frissítve lett';
$string['searchindexwhendisabled'] = 'Indexálás kikapcsolás esetén';
$string['searchindexwhendisabled_desc'] = 'Lehetővé teszi az ütemezett feladat számára keresési index létrehozását akkor is, ha a keresés ki van kapcsolva. Ez akkor jön kapóra, amikor az indexet még azelőtt szeretné létrehozni, hogy a keresőt a tanulók meglátják.';
$string['searchinsettings'] = 'Keresés a beállítások között';
$string['searchlastrun'] = 'Utolsó futtatás (időpont, dokumentumok száma, feljegyzések száma, kihagyások száma)';
$string['searchmanagement'] = 'Keresés kezelése';
$string['searchmanagement_desc'] = 'Ezek a lehetőségek akkor hasznosak, amikor nagyon nagy keresési indexekkel rendelkező portálokat módosít, melyek újraépítése sok időt vesz igénybe.';
$string['searchmaxtopresults'] = 'Legjobb eredmények maximális száma';
$string['searchmaxtopresults_desc'] = 'A kurzustartalom, kurzusok és felhasználók keresési eredményei fölött megjelenítendő legjobb eredmények maximális száma.';
$string['searchnotavailable'] = 'A keresés nem elérhető';
$string['searchoptions'] = 'Keresési lehetőségek';
$string['searchpartial'] = '(még nincs teljesen indexálva)';
$string['searchreindexed'] = 'Minden portáltartalom újraindexálva.';
$string['searchreindexindex'] = 'Minden portáltartalom újraindexálása';
$string['searchresults'] = 'Keresési eredmények';
$string['searchsetupinfo'] = 'Keresés beállítása';
$string['searchteacherroles'] = 'Tanári szerepek';
$string['searchteacherroles_desc'] = 'Válassza ki az összes magasabb szintű szerepet a keresési eredményekben megjelenő felhasználók számára.';
$string['searchtopresults'] = 'Legjobb eredmények';
$string['searchupdateindex'] = 'Indexált tartalmak frissítése';
$string['sectionerror'] = 'Szekcióhiba!';
$string['secureforms'] = 'Kiegészítő űrlapbiztonság használata';
$string['security'] = 'Biztonság';
$string['selectsearchengine'] = 'Keresőmotor kiválasztása';
$string['server'] = 'Szerver';
$string['serverchecks'] = 'Szerverellenőrzések';
$string['serverlimit'] = 'Szerverkorlát';
$string['servicespage'] = 'Támogatás és szolgáltatások hivatkozás';
$string['sessionautostartwarning'] = '<p>Súlyos beállítási hiba lépett föl, tájékoztassa a rendszergazdát.</p><p>A Moodle megfelelő működéséhez a rendszergazdának módosítania kell a PHP beállításait.</p><p>A <code>session.auto_start</code> <code>off</code>-ra állítandó.</p><p>Ezt a szerveren a <code>php.ini</code> fájlnak, az Apache/IIS <br />konfigurációjának vagy a <code>.htaccess</code> fájlnak a szerkesztésével érheti el.</p>';
$string['sessioncookie'] = 'Süti előtagja';
$string['sessioncookiedomain'] = 'Süti doménje';
$string['sessioncookiepath'] = 'Süti útvonala';
$string['sessionhandling'] = 'Folyamat kezelése';
$string['sessiontimeout'] = 'Időtúllépés';
$string['sessiontimeoutwarning'] = 'Időtúllépésre szóló figyelmeztetés';
$string['settingdependenton'] = 'A(z)  <strong>{$a}</strong> értéke alapján a beállítás rejtett lehet.';
$string['settingfileuploads'] = 'A szokásos működéshez állományfeltöltésre van szükség, engedélyezze a PHP beállításában.';
$string['settingmaxinputvars'] = 'A max_input_vars ajánlott értéke legalább 5000.';
$string['settingmaxinputvarsrequired'] = 'A max_input_vars értéke legyen legalább 5000.';
$string['settingmemorylimit'] = 'Kevés a memória, állítsa be magasabbra a PHP beállításában.';
$string['settingsafemode'] = 'A Moodle nem teljesen kompatibilis a csökkentett üzemmóddal, kérje meg a rendszergazdát, hogy kapcsolja ki. Ha csökkentett üzemmódban futtatja a Moodle-t, különféle problémákra kell felkészülnie.';
$string['settingzendexceptionignoreargs'] = 'Biztonsági szempontból erősen ajánlott a zend.exception_ignore_args PHP beállítás bekapcsolása.';
$string['setupsearchengine'] = 'Keresőmotor beállítása';
$string['showcommentscount'] = 'Megjegyzések számának kijelzése';
$string['showdetails'] = 'Részletek megtekintése';
$string['showuseridentity'] = 'Felhasználó kilétének megjelenítése';
$string['showuseridentity_desc'] = 'Felhasználók kiválasztása, keresése és megjelenítése során ezek a mezők nevük mellett megjeleníthetők. Csak azok számára láthatók, akik rendelkeznek moodle/site:viewuseridentity jogosultsággal. Ezek alapesetben a tanárok és a vezetők. (Leginkább akkor van értelme, ha az intézményben előírt egy-két mezőt választja ki.)
A csillaggal jelölt mezők egyedi profilmezők. Kiválaszthatja ezeket a mezőket, de ezek egyes képernyőkön nem jelennek meg.';
$string['simplexmlrequired'] = 'A Moodle most már előírja a SimpleXML PHP-bővítményt .';
$string['sitemailcharset'] = 'Karakterkészlet';
$string['sitemaintenance'] = 'A portálon karbantartás folyik, jelenleg nem elérhető';
$string['sitemaintenancemode'] = 'Karbantartási üzemmód';
$string['sitemaintenanceoff'] = 'A karbantartási üzemmód kikapcsolva, a portál ismét a szokásos módon üzemel';
$string['sitemaintenanceon'] = 'Portálja jelenleg karbantartási üzemmódban van (a portálra csak rendszergazdák jelentkezhetnek be).';
$string['sitemaintenanceoncli'] = 'Portálján a CLI karbantartási üzemmódban van, internetes hozzáférés nem engedélyezett.';
$string['sitemaintenancetitle'] = '{$a} karbantartás alatt';
$string['sitemaintenancewarning'] = 'Portálja jelenleg karbantartási üzemmódban van (csak rendszergazdák jelentkezhetnek be). Szokásos üzemmódba való visszatéréshez <a href="maintenance.php">kapcsolja ki a karbantartási üzemmódot</a>.';
$string['sitemaintenancewarning2'] = 'Portálja most karbantartási módban üzemel (csak rendszergazdák jelentkezhetnek be). A normál üzemmód visszaállításához  <a href="{$a}">kapcsolja ki a karbantartási módot</a>.';
$string['sitemenubar'] = 'Portálnavigáció';
$string['sitenameintitle'] = 'Portál nevének megjelenítése az oldal címében';
$string['sitenameintitle_help'] = 'Ez a beállítás a webhely nevét az oldal címének végére illeszti. Javasoljuk, hogy a webhely neve szerepeljen az oldal címében, mivel ez javítja a webhely elérhetőségét, mivel a felhasználók gyorsan azonosítani tudják, hogy éppen melyik oldalon vannak.';
$string['sitepolicies'] = 'Portál biztonsági beállításai';
$string['sitepolicy'] = 'Portálházirend webcíme';
$string['sitepolicy_help'] = 'Azon portálházirend webcíme, amelyet a regisztrált felhasználóknak belépés előtt el kell olvasni és el kell fogadni. A beállítás csak akkor működik, ha a portálházirend-kezelő alapra van beállítva (core).';
$string['sitepolicyguest'] = 'Vendégeknek szóló portálházirend webcíme';
$string['sitepolicyguest_help'] = 'Azon portálházirend webcíme, amelyet a vendégeknek belépés előtt el kell olvasni és el kell fogadni. A beállítás csak akkor működik, ha a portálházirend-kezelő alapra van beállítva (core).';
$string['sitepolicyhandler'] = 'Portál házirend-kezelője';
$string['sitepolicyhandler_desc'] = 'Meghatározza a portál házirendjének és a házirend elfogadásának a kezelését. Alapesetben (core) a kezelő bekapcsolja a portálházirend webcímét és egy másikat a vendég felhasználóknak. A házirendkezelő lehetővé teszi a portál, az adatvédelem és más házirendek beállítását, valamint a felhasználói elfogadás megtekintését és, ha szükséges, a kiskorúak részéről adandó beleegyezést.';
$string['sitepolicyhandlercore'] = 'Alapeset';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Egy szekció megjelenítése az oldal tetején, ahol egyéni tartalom helyezhető el.';
$string['sixtyfourbitsrequired'] = 'Észleltük, hogy a portálja nem 64 bites PHP verziót használ. Ezen Moodle verzió telepítése előtt frissítenie kell a rendszerét (operációs rendszer, PHP...).';
$string['sixtyfourbitswarning'] = 'Portálja nem  64-bites PHP-t használ. A jövőbeni kompatibilitás érdekében ajánlott frissíteni a portálját.';
$string['slasharguments'] = 'Perjeles argumentumok használata';
$string['slashargumentswarning'] = 'Ajánlott a perjeles argumentumok használatát a jövőben bekapcsolni. Részletek:  <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Using slash arguments</a>.';
$string['smallscreensonly'] = 'Kizárólag kis méretű kijelzők';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP-hitelesítés típusa';
$string['smtpdetail'] = 'Egyszerű levélküldési protokoll (SMTP) beállításai levélküldéshez.';
$string['smtphosts'] = 'SMTP-gazdagépek';
$string['smtpmaxbulk'] = 'Az SMTP-folyamat korlátja';
$string['smtppass'] = 'SMTP-jelszó';
$string['smtpsecure'] = 'SMTP-biztonság';
$string['smtpuser'] = 'SMTP-felhasználó';
$string['soaprecommended'] = 'A soap-kiegészítés telepítése webszolgáltatások és egyes segédprogramok esetén hasznos lehet.';
$string['sort_fullname'] = 'Teljes kurzuscím';
$string['sort_idnumber'] = 'Kurzus azonosítószáma';
$string['sort_shortname'] = 'Rövid kurzuscím';
$string['sort_sortorder'] = 'Rendezés';
$string['spellengine'] = 'Helyesírásmotor';
$string['spelllanguagelist'] = 'Helyesírás-ellenőrző nyelvek';
$string['splrequired'] = 'A Moodle előírja az SPL PHP-bővítményt.';
$string['stats'] = 'Statisztika';
$string['statsfirstrun'] = 'Maximális feldolgozási intervallum';
$string['statsmaxruntime'] = 'Maximális futásidő';
$string['statsmoodleorg'] = 'statisztika';
$string['statsruntimedays'] = 'Földolgozandó napok';
$string['statsruntimestart'] = 'Végrehajtás időpontja';
$string['statsuserthreshold'] = 'Felhasználói küszöbérték';
$string['stickyblocks'] = 'Megmaradó blokkok';
$string['stickyblockscourseview'] = 'Kurzusoldal';
$string['stickyblocksduplicatenotice'] = 'Ha ide beszúr egy blokkot, amely már létezik egy másik oldalon, akkor másodpéldány jön létre.<br />Csak a rögzített blokkot nem tudja szerkeszteni, a másodpéldányt viszont igen.';
$string['stickyblocksmymoodle'] = 'Személyes Moodle-oldal';
$string['stickyblockspagetype'] = 'Beállítandó oldaltípus';
$string['strictformsrequired'] = 'A kitöltendő mezők szigorú ellenőrzése';
$string['stripalltitletags'] = 'Minden tevékenységnévből törölje a HTML címkéket.';
$string['supportandservices'] = 'Támogatás és szolgáltatások';
$string['supportavailability'] = 'Támogatás elérhetősége';
$string['supportcontact'] = 'Támogatói kapcsolat';
$string['supportemail'] = 'Támogatói e-mail';
$string['supportemailsubject'] = 'Portáltámogató kérelem - {$a}';
$string['supportname'] = 'Támogató neve';
$string['supportpage'] = 'Portáltámogatás felkeresése hivatkozás';
$string['suspenduser'] = 'Felhasználói fiók felfüggesztése';
$string['swaggerui'] = 'Moodle REST API UI (SwaggerUI)';
$string['switchlang'] = 'Nyelvi könyvtárak közötti váltás';
$string['systempaths'] = 'Rendszerútvonalak';
$string['tablenosave'] = 'A fenti táblázat módosításainak mentése automatikus';
$string['tablesnosave'] = 'A fenti táblázatok módosításainak mentése automatikus';
$string['tabselectedtofront'] = 'Tabulátoros táblázatokban a kiválasztott elemet tartalmazó sor elölre kerüljön.';
$string['tabselectedtofronttext'] = 'Fülek kiválasztott sorának előtérbe hozása';
$string['task_adhoc_concurrency_limit'] = 'Eseti feladatok párhuzamossági korlátja';
$string['task_adhoc_concurrency_limit_desc'] = 'Párhuzamos futtatásra engedélyezett eseti feladatfeldolgozók száma. Ha a korlát magas, az ütemezett feladatok rendszertelenül hajtódhatnak végre sok eseti feladat esetén. 0 beállításával teljesen kikapcsolja az eseti feladatok feldolgozását.';
$string['task_adhoc_failed_retention'] = 'Sikertelen alkalmi feladat megőrzési ideje';
$string['task_adhoc_failed_retention_desc'] = 'A maximális időszak amíg a sikertelen alkalmi feladatok a sorban maradhatnak, miután elérték az újrapróbálási korlátjukat.';
$string['task_adhoc_max_runtime'] = 'Az eseti feladatfeldolgozó élettartama';
$string['task_adhoc_max_runtime_desc'] = 'Az eseti feladatfeldolgozó mentesítést megelőző kora. Ajánlott rövid időtartamot alkalmazni, mert a sorban álló eseti feladatok számát illetően nincs korlát. Ha a szám túl magas és az eseti feladatok sora hosszú, az ütemezett feladatok rendszertelenül hajtódhatnak végre.';
$string['task_dbreads'] = 'Adatbázis olvasások';
$string['task_dbstats'] = 'Adatbázis';
$string['task_dbwrites'] = 'Adatbázis írások';
$string['task_duration'] = 'Időtartam';
$string['task_endtime'] = 'Befejezés ideje';
$string['task_logmode'] = 'Naplózás ideje';
$string['task_logmode_all'] = 'Minden munka kimeneti naplójának tárolása';
$string['task_logmode_desc'] = 'Megválaszthatja, mikor kerüljön sor feladatnaplózásra. Alapesetben mindig készül napló. Kikapcsolhatja teljes egészében, vagy szűkítheti a naplózást a sikertelen feladatokra.';
$string['task_logmode_failonly'] = 'Csak a sikertelen feladatokat naplózza.';
$string['task_logmode_none'] = 'Naplózás kihagyása';
$string['task_logoutput'] = 'Feladat eredménye';
$string['task_logretainruns'] = 'Feldolgozások megőrzése';
$string['task_logretainruns_desc'] = 'Az egyes feladatok megőrizendő feldolgozásainak a száma. Ez a beállítás összefügg a \'Megőrzési idő\' beállításával: amelyik hamarabb bekövetkezik, arra kerül sor.';
$string['task_logretention'] = 'Megőrzési idő';
$string['task_logretention_desc'] = 'A naplók megőrzésének maximális időtartama. Ez a beállítás összefügg a \'Feldolgozások megőrzése\' beállításával: amelyik hamarabb bekövetkezik, arra kerül sor.';
$string['task_logtostdout'] = 'Naplózási kimenet megjelenítése';
$string['task_logtostdout_desc'] = 'Feladatok futtatása közben és a kimenet rögzítése esetén a rögzített kimenet megjelenjen-e.';
$string['task_result'] = 'Eredmény';
$string['task_result:failed'] = 'Hiba';
$string['task_scheduled_concurrency_limit'] = 'Ütemezett feladatok párhuzamosságának korlátja';
$string['task_scheduled_concurrency_limit_desc'] = 'A párhuzamosan futtatható ütemezett feladatfeldolgozók száma. Magas korlát beállítása esetén a szerver túlterhelt lehet.  0 beállításával teljesen kikapcsolja az ütemezett feladatok feldolgozását.';
$string['task_scheduled_max_runtime'] = 'Az ütemezett feladatfeldolgozó élettartama';
$string['task_scheduled_max_runtime_desc'] = 'Az ütemezett feladatfeldolgozó mentesítést megelőző kora.';
$string['task_starttime'] = 'Kezdési időpont';
$string['task_stats:dbreads'] = '{$a} olvasás';
$string['task_stats:dbwrites'] = '{$a} írás';
$string['task_status'] = 'Feladat állapota';
$string['task_status_desc'] = 'A(z)  \'{$a->name}\' feladat állapota:  {$a->status}. Részletek {$a->class}{$a->extradescription} az <a href="{$a->gotourl}">Ütemezett feladatok</a> alatt.';
$string['task_type:adhoc'] = 'Eseti';
$string['task_type:scheduled'] = 'Ütemezett';
$string['taskadmintitle'] = 'Feladatok';
$string['taskanalyticscleanup'] = 'Analitika takarítása';
$string['taskautomatedbackup'] = 'Automatikus biztonsági mentések';
$string['taskautomatedbackup_report'] = 'Automatikus mentések jelentés';
$string['taskbackupcleanup'] = 'Biztonsági mentések tábláinak, naplóinak és állományainak törlése';
$string['taskbadgesadhoc'] = 'Kitűző adományozása';
$string['taskbadgescron'] = 'Kitűzők adományozása alkalmi feladatok hozzáadása';
$string['taskbadgesmessagecron'] = 'Kitűzőkről szóló értesítések küldésének háttérben zajló feldolgozása';
$string['taskblogcron'] = 'Külső blogok szinkronizálása';
$string['taskcachecleanup'] = 'Gyorsítótár lejárt bejegyzéseinek törlése';
$string['taskcachecron'] = 'Gyorsítótári feldolgozás a háttérben';
$string['taskcalendarcron'] = 'Naptári értesítések küldése';
$string['taskcheckforupdates'] = 'Frissítések ellenőrzése';
$string['taskcompletiondaily'] = 'Megkezdett teljesítési jegy';
$string['taskcompletionregular'] = 'Szokásos teljesítési adatok számítása';
$string['taskcontextcleanup'] = 'Környezetek takarítása';
$string['taskcreatecontexts'] = 'Hiányzó környezetek létrehozása';
$string['taskdeleteincompleteusers'] = 'Hiányos felhasználók törlése';
$string['taskdeleteunconfirmedusers'] = 'Nem visszaigazolt felhasználók törlése';
$string['taskeventscron'] = 'Eseményfeldolgozás a háttérben';
$string['taskfiletrashcleanup'] = 'Kukában lévő állományok takarítása';
$string['taskglobalsearchindex'] = 'Globális keresés indexálása';
$string['taskglobalsearchoptimize'] = 'Globális keresés indexálásának optimalizálása';
$string['taskgradecron'] = 'Értékelésnapló feldolgozása a háttérben';
$string['taskgradehistorycleanup'] = 'Értékelési előzménytáblák háttérben futó tisztítása';
$string['taskh5pcleanup'] = 'Nem használt H5P-fájlok eltakarítása';
$string['tasklegacycron'] = 'Korábbi cron feldolgozása segédprogramokhoz';
$string['tasklockcleanuptask'] = 'Alkalmi feladat metaadatainak törlése';
$string['tasklogcleanup'] = 'Feladatnaplók takarítása';
$string['tasklogging'] = 'Feladatnapló beállítása';
$string['tasklogs'] = 'Feladatnaplók';
$string['taskmessagingcleanup'] = 'Üzenetküldés feldolgozása a háttérben';
$string['taskpasswordresetcleanup'] = 'Jelszó-visszaállítási próbálkozások takarítása';
$string['taskplagiarismcron'] = 'Korábbi cron másolási segédprogramokhoz  feldolgozás a háttérben';
$string['taskportfoliocron'] = 'Portfólió-segédprogramokhoz  feldolgozás a háttérben';
$string['taskprocessing'] = 'Feladat feldolgozása';
$string['taskquestioncron'] = 'Kérdéselőnézetek takarítása a háttérben';
$string['taskquestionstatscleanupcron'] = 'Kérdésstatisztika gyorsítótárának takarítása a háttérben';
$string['taskrefreshsystemtokens'] = 'OAuth token frissítése a szolgáltatási fiókokhoz';
$string['taskregistrationcron'] = 'Portál regisztrálása';
$string['tasksendfailedloginnotifications'] = 'Hibás belépésről szóló értesítések elküldése';
$string['tasksendnewuserpasswords'] = 'Új felhasználói jelszavak elküldése';
$string['tasksessioncleanup'] = 'Régi munkamenetek takarítása';
$string['taskstatscron'] = 'Statisztikához feldolgozás a háttérben';
$string['tasktagcron'] = 'Címkékhez feldolgozás a háttérben';
$string['tasktempfilecleanup'] = 'Elavult ideiglenes állományok törlése';
$string['tasktype'] = 'Típus';
$string['taskupdategeoip2file'] = 'GeoIP állomány frissítése';
$string['tempdatafoldercleanup'] = 'Ennél régebbi ideiglenes adatállományok törlése';
$string['templates'] = 'Sablonok';
$string['testoutgoingmailconf'] = 'Kimenő levélbeállítás ellenőrzése';
$string['testoutgoingmailconf_errorcommunications'] = 'A Moodle nem tudott a levelezőszerverével kommunikálni. Ellenőrizze a kimenő levelek beállítását.';
$string['testoutgoingmailconf_fromemail'] = 'Felhasználónév vagy e-mail-cím alapján';
$string['testoutgoingmailconf_fromemail_help'] = 'A mező szerint az üzenet a felhasználótól érkezik, de a tényleges e-mail Feladó fejléce egyéb beállításoktól függ, mint pl. az allowedemaildomains';
$string['testoutgoingmailconf_fromemail_invalid'] = 'Érvénytelen feladói felhasználónév vagy e-mail-cím. Használjon érvényes e-mail-formátumot vagy egy Moodle-ben használt  felhasználónevet.';
$string['testoutgoingmailconf_message'] = 'Ez egy próbaüzenet. Ha megkapta, akkor sikeresen beállította portálja kimenő e-mailjét. Feladás: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'Próbaüzenet küldése';
$string['testoutgoingmailconf_sentmail'] = 'A Moodle sikeresen elküldte a próbaüzenetet a levelezőszerverre.
<br />Feladó: {$a->fromemail}<br />Címzett: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: próbaüzenet. {$a->additional} Feladva ekkor: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'További tárgy';
$string['testoutgoingmailconf_toemail'] = 'E-mail-címre';
$string['testoutgoingmaildetail'] = 'Ellenőrzés előtt mentse el a beállítást.<br />{$a}';
$string['testsiteupgradewarning'] = 'Jelenleg a tesztelő {$a} portált használja. Megfelelő frissítéséhez használja a parancssori felületet.';
$string['themedefinedinconfigphp'] = 'A stílus nem módosítható, mert a config.php-ban a(z) {$a} stílusra van beállítva.';
$string['themedesignermode'] = 'Stílustervező üzemmód';
$string['themedesignermodewarning'] = 'Stílustervező üzemmód bekapcsolva. Éles portálokon kerülendő, mert visszafogja a teljesítményt.';
$string['themeeditsettingsname'] = '\'{$a}\' stílusbeállítások módosítása';
$string['themelist'] = 'Stílusjegyzék';
$string['themeresetcaches'] = 'Stílust tartalmazó gyorsítótárak törlése';
$string['themeselect'] = 'Stílus módosítása';
$string['themeselector'] = 'Stílusok';
$string['themesettingsadvanced'] = 'Haladó stílus beállítások';
$string['themesettingscustom'] = 'Egyéni stílus beállítás';
$string['themesettingsname'] = '\'{$a}\' stílus beállítása';
$string['themeusagereportname'] = 'Jelentés a(z) \'{$a}\' stílus használatáról';
$string['therewereerrors'] = 'Adataiban hiba volt';
$string['thirdpartylibrary'] = 'Könyvtár';
$string['thirdpartylibrarylocation'] = 'Hely';
$string['thirdpartylibs'] = 'Külsős könyvtárak';
$string['timezone'] = 'Alapidőzóna';
$string['timezoneforced'] = 'Ezt a portál rendszergazdája írja elő';
$string['timezoneinvalid'] = 'Érvénytelen "{$a}" időzóna';
$string['timezoneisforcedto'] = 'Használatának előírása minden felhasználó számára';
$string['timezonenotforced'] = 'A felhasználók kiválaszthatják saját időzónájukat';
$string['timezonephpdefault'] = 'Alapértelmezett PHP-időzóna ({$a})';
$string['timezoneserver'] = 'Szerveridőzóna ({$a})';
$string['tlswarning'] = 'A TLSv1.2 támogatáshoz nincs PHP/cURL-kiterjesztés. Egyes szolgáltatások esetleg nem működnek. Mindenképpen frissítse TLS-könyvtárait.';
$string['tokenduration'] = 'Felhasználó által létrehozott token érvényessége';
$string['tokenduration_desc'] = 'A felhasználó által (pl. a mobil alkalmazáson keresztül) létrehozott új webszolgáltatási token eddig lesz érvényes.';
$string['tokenizerrecommended'] = 'Ajánlott a PHP Tokenizer bővítmény telepítése - javítja a hálózati Moodle használhatóságát.';
$string['tools'] = 'Rendszergazda eszközei';
$string['toolsmanage'] = 'Rendszergazda eszközeinek kezelése';
$string['unattendedoperation'] = 'Felügyelet nélküli működtetés';
$string['unbookmarkthispage'] = 'Oldal könyvjelzőjének eltávolítása';
$string['unicoderequired'] = 'Minden adatot unikódban (UTF-8) kell tárolni. Az új telepítéseket unikód alapkészletű adatbázisokba kell telepíteni. Ha újabb változatra vált, végre kell hajtania az UTF-8-ra való áttérést (lásd a Portálkezelés oldalát).';
$string['uninstallplugin'] = 'Eltávolítás';
$string['unlockaccount'] = 'Fiók felfüggesztésének feloldása';
$string['unoconvwarning'] = 'Az unoconv Ön által telepített verzióját a rendszer nem támogatja.';
$string['unsupported'] = 'Nem támogatott';
$string['unsupporteddbfileformat'] = 'Adatbázisában Antelope állományformájú táblák vannak. MySQL és MariaDB esetén a teljes UTF-8 támogatáshoz Barracuda állományformára van szükség. Konvertálja tábláit Barracuda állományformájúra. Lásd az <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">A MySQL teljes unikódos támogatása </a> alatti részleteket.';
$string['unsupporteddbfilepertable'] = 'Mind MySQL, mind MariaDB esetén a teljes UTF-8 támogatáshoz a MySQL \'innodb_file_per_table\' beállítását állítsa át \'ON\'-ra. További részleteket a dokumentációban talál.';
$string['unsupporteddblargeprefix'] = 'Mind MySQL, mind MariaDB esetén a teljes UTF-8 támogatáshoz a MySQL \'innodb_large_prefix\' beállítását állítsa át \'ON\'-ra. További részleteket a dokumentációban talál.';
$string['unsupporteddbstorageengine'] = 'A használt adatbázis-tárolót a rendszer már nem támogatja.';
$string['unsupporteddbtablerowformat'] = 'Adatbázisában Antelope táblák vannak. Ajánlott ezeket Barracuda formájúra átalakítani. Az InnoDB táblák Barracuda.formájúra alakításának részleteit lásd: <a href="https://docs.moodle.org/en/cli">Administration via command line</a>.';
$string['unsupportedphpversion7'] = 'A 7-es és afölötti PHP verziókat a rendszer nem támogatja.';
$string['unsupportedphpversion71'] = 'A 7.1 és afölötti PHP verziókat a rendszer nem támogatja.';
$string['unsupportedphpversion72'] = 'A 7.2 és afölötti PHP verziókat a rendszer nem támogatja.';
$string['unsupportedphpversion73'] = 'A 7.3 és afölötti PHP verziókat a rendszer nem támogatja.';
$string['unsupportedphpversion74'] = 'A 7.4 és afölötti PHP verziókat a rendszer nem támogatja.';
$string['unsupportedphpversion80'] = 'A 8.0 és afölötti PHP verziókat a rendszer nem támogatja.';
$string['unsupportedphpversion81'] = 'A PHP 8.1 verziót vagy újabbat a rendszer nem támogat.';
$string['unsupportedphpversion82'] = 'A PHP 8.2 verziót vagy újabbat a rendszer nem támogat.';
$string['unsupportedphpversion83'] = 'A PHP 8.3 verziót vagy újabbat a rendszer nem támogat.';
$string['unsupportedphpversion84'] = 'A 8.4 és afölötti PHP verziókat a rendszer nem támogatja.';
$string['unsuspenduser'] = 'Felhasználói fiók bekapcsolása';
$string['updateaccounts'] = 'Meglévő fiókok frissítése';
$string['updateautocheck'] = 'Elérhető frissítések automatikus ellenőrzése';
$string['updateautocheck_desc'] = 'Bekapcsolása esetén portálja automatikusan ellenőrzi, vannak-e elérhető frissítések a Moodle-hoz és a segédprogramokhoz. Ha vannak, a portál rendszergazdája erről értesítést kap.';
$string['updateavailable'] = 'Újabb Moodle-verzió érhető el!';
$string['updateavailable_moreinfo'] = 'További részletek...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Verzió {$a}';
$string['updateavailabledetailslink'] = 'A részleteket lásd itt: {$a->url}.';
$string['updateavailableforplugin'] = 'Újabb segédprogram-verziók érhetők el!';
$string['updateavailableinstall'] = 'Frissítés telepítése';
$string['updateavailableinstallall'] = 'Elérhető frissítések  ({$a}) telepítése';
$string['updateavailableinstallallhead'] = 'Elérhető frissítések telepítése';
$string['updateavailablenot'] = 'Az Ön Moodle-verziója a legfrissebb.';
$string['updateavailablerecommendation'] = 'A legutóbbi biztonsági- és hibajavítások eléréséhez frissítse portálját!';
$string['updatecomponent'] = 'Összetevő frissítése';
$string['updateminmaturity'] = 'Szükséges programérettség';
$string['updateminmaturity_desc'] = 'Csak akkor figyelmeztessen elérhető frissítésekre, ha a program érettsége legalább a beállított szintet eléri. A programérettség szintjéről nem nyilatkozó segédprogramok frissítéséről mindig kap tájékoztatást - ettől a beállítástól függetlenül.';
$string['updatenotificationfooter'] = 'Az Ön {$a->siteurl} Moodle-portálján be van kapcsolva az elérhető frissítések automatikus ellenőrzése. Ezt az üzenetet a portál rendszergazdájaként kapja. Az elérhető frissítések automatikus ellenőrzését kikapcsolhatja a Portálkezelés / Szerver / Frissítési értesítések alatt, vagy testre szabhatja az értesítést a Beállítások oldalon.';
$string['updatenotifications'] = 'Értesítések frissítésekről.';
$string['updatenotificationsubject'] = 'Moodle-frissítések érhetők el ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Értesítés új programváltozatokról';
$string['updatenotifybuilds_desc'] = 'Bekapcsolása esetén akkor is kap értesítést, ha az elérhető frissítés az adott verziónak egy programváltozatát tartalmazza. A programváltozat valamely verzió folyamatos fejlesztésének egy állomását jelenti. A programváltozatok hetente állnak elő. Kikapcsolása esetén csak akkor kap értesítést frissítésekről, ha az a Moodle egy magasabb verziójának felel meg. A beállítás a segédprogramok ellenőrzését nem befolyásolja.';
$string['upgradeerror'] = 'Ismeretlen hiba {$a->plugin} {$a->version} verzióra frissítése során, a Moodle leáll.';
$string['upgradeforumread'] = 'A Moodle 1.5 új elemmel bővült az elolvasott/még nem olvasott fórumhozzászólások nyomon követésére.<br />Ennek használatához <a href="{$a}">frissítenie kell táblázatait</a>.';
$string['upgradeforumreadinfo'] = 'A Moodle 1.5 új elemmel bővült az elolvasott/még nem olvasott fórumhozzászólások nyomon követésére. Ennek használatához frissítenie kell táblázatait az összes meglévő hozzászólásra vonatkozó nyomon követési információval. A portál méretétől függően ez hosszú időbe (akár órákba) telhet és igénybe veheti az adatbázis erőforrását, ezért ennek elvégzésére célszerű egy nyugodtabb időszakot kiválasztani. Ugyanakkor a portál a frissítés alatt továbbra is üzemel, a felhasználókat ez nem érinti. Ha a folyamatot elindítja, hagyja, hogy véget érjen (a böngésző ablakát tartsa nyitva). Ha mégis becsukná, semmi probléma, újrakezdheti.<br /><br />Most akarja elindítani a frissítést?';
$string['upgradekeyreq'] = 'Frissítési kulcs szükséges';
$string['upgradekeyset'] = 'Frissítési kulcs (beállítás kihagyásához hagyja üresen)';
$string['upgradelogs'] = 'Az összes funkció működéséhez minden régi naplóállományt frissíteni kell. <a href="{$a}">További tájékoztatás</a>';
$string['upgradelogsinfo'] = 'A naplóállományok tárolásában nemrégiben változásokra került sor. Ha a régebbi naplóállományokat tevékenységek szerint kívánja megtekinteni, akkor ezeket frissítenie kell. Ez az adott portáltól függően sok időt (akár órákat) vehet igénybe és meglehetősen megterhelheti a nagyobb portálok adatbázisait. Ha nekilát a folyamatnak, hagynia kell, hogy befejeződjék (azaz a böngésző ablakát hagyja nyitva). A naplóállományok frissítése közben a portál mások számára minden gond nélkül üzemel.<br /><br />Most kívánja frissíteni a naplóállományait?';
$string['upgradepluginsfirst'] = 'Először az elérhető frissítéseket kell telepítenie.';
$string['upgradepluginsinfo'] = 'Segédprogramok frissítése';
$string['upgradepluginsinfo_help'] = 'Egyes segédprogramjaihoz frissítések állnak rendelkezésre, melyeket a Moodle adatbázisának verziófrissítése előtt kell telepítenie. Ha portálja nem támogatja az automatikus frissítést, a frissítéseket kézi úton kell letöltenie és telepítenie.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Új beállítások';
$string['upgradesettingsintro'] = 'Az alábbi beállítások hozzáadása a Moodle utolsó verziófrissítése óta történt. Az alapbeállításokon hajtsa végre a szükséges módosításokat, majd kattintson az oldal alján lévő "Beállítások mentése" pontra.';
$string['upgradestalefiles'] = 'Vegyes verziójú a Moodle telepítése, a frissítés nem folytatható.';
$string['upgradestalefilesinfo'] = 'A Moodle frissítési folyamata szünetel, mert a Moodle legalább két fő verziójából származó PHP-kódok fordulnak elő a Moodle-könyvtárban.

Ez jelentős problémákat okozhat később, ezért gondoskodjon arról, hogy a Moodle-könyvtár csak az egyik verzióból származó fájlokat  tartalmazza.

A Moodle-könyvtár megtisztításához:

* nevezze át a jelenlegi Moodle-könyvtárat "moodle_old"-ra;
* hozzon létre egy új könyvtárat, amely csak egy szabványos Moodle-csomag fájljait tartalmazza;
* a "moodle_old" könyvtárból helyezze át az eredeti config.php fájlt és a nem szabványos segédprogramokat az új Moodle-könyvtárba.

Ha elkészült a megtisztított Moodle-könyvtár, frissítse az oldalt és folytassa a Moodle frissítési folyamatát.

Ez a figyelmeztetés gyakran azért jelenik meg, mert egy standard csomagot egy korábbi verzióra másol rá. Kisebb frissítések esetén ez nem jelent gondot, nagyobb frissítés esetén azonban nem ajánlott.

A figyelmeztetést okozhatja az is, ha nem teljes frissítést hajt végre egy Git-adattár esetén. Ilyen esetben várja meg a frissítés végét vagy ismételje meg a műveletet.

Bővebb információ a frissítésről: <a href="{$a}">{$a}</a>.';
$string['upgradestart'] = 'A Moodle adatbázisának verziófrissítése most.';
$string['upgradesure'] = 'Moodle-állományai módosultak, szerverét pedig automatikusan erre a változatra frissíti:<p>  <strong>{$a}</strong> </p><p> Ha ezt teszi, nem lesz módja a visszatérésre.
A folyamat elég sokáig tarthat. <p>Biztosan frissíti a szervert erre a verzióra?';
$string['upgradetimedout'] = 'A frissítési idő lejárt, indítsa újra a frissítést.';
$string['upgradingdata'] = 'Adatok frissítése';
$string['upgradinglogs'] = 'Naplóállományok frissítése';
$string['upgradingversion'] = 'Frissítés új verzióra';
$string['upwards'] = 'felfelé';
$string['useblogassociations'] = 'Társítások bekapcsolása';
$string['user'] = 'Felhasználó';
$string['userbulk'] = 'Tömeges felhasználói műveletek';
$string['userbulkdownload'] = 'Felhasználók exportálása ekként';
$string['userdefaultpreferences'] = 'Felhasználó alapbeállításai';
$string['userfeedbackafterupgrade'] = 'Minden főbb frissítés után';
$string['userfeedbackencouragement'] = '<p>A Moodle 3.9-től kezdődően elérhető új funkcióval a Moodle-ről visszajelzés küldhető a Moodle központnak, egy külső, a központ által működtetett felmérő portálon keresztül. A portálra nem érkezik a felhasználót azonosító adat.</p>
<p>A Moodle központja az adatgyűjtés terén nyíltságra és átláthatóságra törekszik, ezért hívja fel a figyelmet a funkció létezésére, és a tudatos használatára.</p>
<p>A felhasználók visszajelzései nagyban segítik a Moodle fejlesztőit a Moodle szoftverének tökéletesítésében. A funkció bekapcsolásához térjen át a <a href="{$a}">Visszajelzés beállításai</a> pontra.</p>';
$string['userfeedbacknextreminder'] = 'Következő visszajelzésre emlékeztető';
$string['userfeedbacknextreminder_desc'] = 'Mikor kérjünk visszajelzést a felhasználótól?';
$string['userfeedbackperiodically'] = 'Időről időre';
$string['userfeedbackremindafter'] = 'Emlékeztető megjelenítése ezt követően';
$string['userfeedbackremindafter_desc'] = 'Felhasználók emlékeztetése visszajelzés küldésére x nap elteltével.';
$string['userfiltersdefault'] = 'Alapvető felhasználói szűrők';
$string['userfiltersdefault_desc'] = 'Válassza ki, mely szűrők jelenjenek meg az \'Ömlesztett felhasználói lépések\' oldalon. Több elem kiválasztásához tartsa lenyomva a Ctrl-t. A nem kiválasztott szűrők a \'További részletek\' hivatkozásra kattintással érhetők el.';
$string['userimagesdisabled'] = 'Felhasználói profilképek kikapcsolva';
$string['userlist'] = 'Felhasználók listázása';
$string['usermanagement'] = 'Felhasználókezelés';
$string['userpolicies'] = 'Felhasználói szabványok';
$string['userpreference'] = 'Felhasználói beállítások';
$string['userquota'] = 'Felhasználói kvóta';
$string['userquota_desc'] = 'A felhasználó által magánterületen tárolható állományok maximális mennyisége.';
$string['users'] = 'Felhasználók';
$string['usesitenameforsitepages'] = 'Portálnév használata a portál oldalaihoz';
$string['usetags'] = 'Címkék működésének bekapcsolása';
$string['validateemptylineerror'] = 'Üres sor nem használható.';
$string['validateerror'] = 'Ez az érték nem érvényes:';
$string['validateerrorlist'] = 'Érvénytelen bejegyzések:  {$a}';
$string['validateiperror'] = 'A következő IP-címek érvénytelenek: {$a}';
$string['verifychangedemail'] = 'Domének korlátozása e-mail módosításakor';
$string['warningcurrentsetting'] = 'Érvénytelen aktuális érték: {$a}';
$string['warningiconvbuggy'] = 'Az iconv-könyvtár adott verziója nem támogatja az //IGNORE használatát. Helyette telepítse az mbstring bővítményt az érvénytelen UTF-8 karakterek kiszűréséhez.';
$string['webproxy'] = 'Web-proxy';
$string['webproxyinfo'] = 'Töltse ki az alábbi lehetőségeket, ha Moodle-szerverének nincs közvetlen hozzáférése az internethez. Internet-hozzáférés szükséges környezeti adatok, nyelvi csomagok, RSS-hírek, időzónák stb. letöltéséhez.<br /><em>Használja a PHP cURL-bővítményét.</em>';
$string['xmlrpcwebserviceenabled'] = 'Portálján bekapcsolt XML-RPC-webszolgáltatást észleltünk, amely a PHP által már nem támogatott PHP XML-RPC-bővítményt használja.';
$string['yuicomboloading'] = 'YUI-kombó betöltése';
$string['ziprequired'] = 'A Moodle a Zip PHP bővítményt igényli, az info-ZIP bináris állományokra vagy a PclZip könyvtárra már nincs szükség.';
