<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_xp', language 'pl', version '5.1'.
 *
 * @package     block_xp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Czynności';
$string['activityoresourceis'] = 'Aktywność lub zasób to {$a}';
$string['addacondition'] = 'Dodaj warunek';
$string['addarule'] = 'Dodaj regułę';
$string['addinstructions'] = 'Dodaj więcej informacji';
$string['additionalresources'] = 'Dodatkowe zasoby';
$string['addoninstallationerror'] = 'Wykrywamy problem z wtyczką (local_xp), wygląda na to, że nie jest on poprawnie zainstalowany. Administrator powinien zakończyć jego instalację.';
$string['addonnotactivated'] = 'Wtyczka nie jest aktywowana.';
$string['addrulesformhelp'] = 'Ostatnia kolumna określa ilość punktów doświadczenia zdobytych po spełnieniu kryteriów.';
$string['admindefaultrulesintro'] = 'Poniższe reguły będą używane domyślnie dla kursów, w których blok jest dodany.';
$string['admindefaultsettingsintro'] = 'Poniższe ustawienia będą używane jako domyślne po dodaniu bloku do kursu. Niektóre ustawienia można zablokować, w takim przypadku ich wartość jest ściśle wymuszana we wszystkich wystąpieniach wtyczki.';
$string['admindefaultvisualsintro'] = 'Poniższe ustawienia będą używane jako domyślne, gdy blok zostanie nowo dodany do kursu.';
$string['anonymity'] = 'Tryb anonimowy';
$string['anonymity_help'] = 'To ustawienie określa, czy uczestnicy mogą widzieć swoje imię i awatar.';
$string['awardaxpwhen'] = '<strong>{$a}</strong> punkty doświadczenia są zdobywane kiedy:';
$string['basexp'] = 'Baza algorytmu';
$string['blockappearance'] = 'Wygląd bloku';
$string['blockappearancemovedtopluginsettings'] = 'Ustawienia wyglądu bloku zostały przeniesione na stronę ustawień wtyczki.';
$string['cachedef_filters'] = 'Filtry poziomów';
$string['cachedef_ruleevent_eventslist'] = 'Lista niektórych zdarzeń';
$string['cannotshowblockconfig'] = 'Zwykle wyświetlałbym tutaj ustawienia wyglądu, ale nie mogłem znaleźć twojego bloku. Aby zmienić wygląd bloku, wróć [tutaj]({$a}) (lub tam, gdzie dodałeś blok), włącz tryb edycji i postępuj zgodnie z opcją „Konfiguruj” w menu bloku. Jeśli nie możesz znaleźć bloku, dodaj go ponownie do swojego kursu.';
$string['cannotshowblockconfigsys'] = 'Zwykle wyświetlałbym tutaj ustawienia wyglądu, ale nie mogłem znaleźć twojego bloku. Może brakować go na [stronie głównej]({$a->fp}) i [domyślnym kokpicie]({$a->mysys}) twoich użytkowników lub może być obecny w obu. Aby edytować ustawienia z tego miejsca, upewnij się, że pojawia się tylko w jednym z nich.';
$string['changelevelformhelp'] = 'Jeśli zmienisz liczbę poziomów, odznaki poziomów niestandardowych zostaną tymczasowo wyłączone, aby uniemożliwić poziomy bez odznak. Jeśli zmienisz liczbę poziomów, przejdź do strony „Wizualizacje”, aby ponownie włączyć niestandardowe odznaki po zapisaniu tego formularza.';
$string['cheatguard'] = 'Strażnik oszustw';
$string['clicktoselectcm'] = 'Kliknij, aby wybrać aktywność lub zasób';
$string['cmselector'] = 'Selektor modułów kursu';
$string['coefxp'] = 'Współczynnik algorytmu';
$string['colon'] = '{$a->a}: {$a->b}';
$string['configdescription'] = 'Wstęp';
$string['configdescription_help'] = 'Krótki wstęp wyświetlany w bloku, poniżej poziomu studenta. Studenci mają możliwość odrzucenia wiadomości, dzięki czemu nie zobaczą jej ponownie.';
$string['configheader'] = 'Ustawienia';
$string['configrecentactivity'] = 'Wyświetl ostatnie nagrody';
$string['configrecentactivity_help'] = 'Po włączeniu blok wyświetli krótką listę ostatnich zdarzeń, które nagrodziły ucznia punktami.';
$string['configtitle'] = 'Tytuł';
$string['configtitle_help'] = 'Tytuł bloku.';
$string['congratulationsyouleveledup'] = 'Gratulacje!';
$string['coolthanks'] = 'Super, dzięki!';
$string['courselog'] = 'Logi kursu';
$string['coursereport'] = 'Raport kursu';
$string['courserules'] = 'Zasady kursu';
$string['courseselectedcolon'] = 'Wybrany kurs:';
$string['coursesettings'] = 'Ustawienia kursu';
$string['coursevisuals'] = 'Wizualizacje kursu';
$string['customizelevels'] = 'Dostosuj poziomy';
$string['dangerzone'] = 'Strefa niebezpieczeństwa';
$string['defaultlevels'] = 'Poziomy domyślne';
$string['defaultrules'] = 'Domyślne zasady';
$string['defaultrulesformhelp'] = 'Są to domyślne reguły dostarczane przez wtyczkę, automatycznie przypisują domyślne punkty i ignorują niektóre zbędne zdarzenia. Twoje własne zasady mają nad nimi pierwszeństwo.';
$string['defaultsettings'] = 'Ustawienia domyślne';
$string['defaultvisuals'] = 'Domyślne wizualizacje';
$string['deletecondition'] = 'Usuń warunek';
$string['deleterule'] = 'Usuń regułę';
$string['description'] = 'Opis';
$string['difference'] = 'Różn.';
$string['discoverlevelupplus'] = 'Odkryj Level Up XP+';
$string['dismissnotice'] = 'Ukryj powiadomienie';
$string['displayeveryone'] = 'Pokaż wszystkich';
$string['displaynneighbours'] = 'Wyświetl {$a} sąsiadów';
$string['displayoneneigbour'] = 'Wyświetl jednego sąsiada';
$string['displayparticipantsidentity'] = 'Wyświetl tożsamość uczestników';
$string['displayrank'] = 'Wyświetl ranking';
$string['displayrelativerank'] = 'Wyświetl względny ranking';
$string['documentation'] = 'Dokumentacja';
$string['editinstructions'] = 'Edytuj informacje';
$string['enablecheatguard'] = 'Włącz ochronę przed oszustami';
$string['enablecheatguard_help'] = 'Ochrona przed oszustami oferuje prosty, niedrogi mechanizm zapobiegający nadużywaniu systemu przez studentów za pomocą oczywistych technik, takich jak ciągłe odświeżanie tej samej strony lub powtarzanie tej samej czynności w kółko.

[Więcej informacji](https://levelup.plus/docs/article/level-up-cheat-guard?ref=blockxp_help)';
$string['enableinfos'] = 'Włącz stronę informacyjną';
$string['enableinfos_help'] = 'Po ustawieniu opcji na „Nie” uczniowie nie będą mogli przeglądać strony informacyjnej.';
$string['enableladder'] = 'Włącz ranking';
$string['enableladder_help'] = 'Po ustawieniu na „Nie”, uczniowie nie będą mogli oglądać drabinki.';
$string['enablelevelupnotif'] = 'Włącz powiadomienie o zwiększeniu poziomu';
$string['enablelevelupnotif_help'] = 'Po ustawieniu opcji na „Tak”, uczniom zostanie wyświetlone wyskakujące okienko z gratulacjami za osiągnięty nowy poziom.';
$string['enablelogging'] = 'Włącz logowanie';
$string['enablexpgain'] = 'Włącz zdobywanie punktów';
$string['enablexpgain_help'] = 'Po ustawieniu opcji na „Nie”, nikt nie zdobędzie punktów w trakcie kursu. Jest to przydatne, aby zamrozić zdobyte punkty lub włączyć je w określonym momencie.

Należy pamiętać, że można to również kontrolować bardziej szczegółowo, korzystając z uprawnienia _block/xp:earnxp_.';
$string['entersearchterm'] = 'Wpisz wyszukiwane hasło';
$string['errorcontextcoursemismatchforwholesite'] = 'Adres URL tej strony <em>Level Up XP</em> nie jest zgodny z bieżącą konfiguracją wtyczki. Twoja bieżąca konfiguracja deklaruje, że <em>Level Up XP</em> będzie używany „Dla całej witryny”, jednak ta strona oczekiwała, że będzie używany „Na kurs”. Proszę <a href="{$a->nexturl}">kliknij tutaj</a>, aby przejść do właściwej strony. Wyszukaj ustawienie administratora „block_xp_context”, jeśli chcesz zmienić konfigurację.';
$string['errorcontextcoursemismatchpercourse'] = 'Adres URL tej strony <em>Level Up XP</em> nie jest zgodny z bieżącą konfiguracją wtyczki. Twoja bieżąca konfiguracja deklaruje, że <em>Level Up XP</em> będzie używany „Na kurs”, ale ta strona oczekuje, że będzie używany „Dla całej witryny”. Najprawdopodobniej pochodzi to z <em>bloku</em>, który został dodany do kokpitu lub strony głównej w innej konfiguracji. Powinieneś usunąć block z tych stron i używać go tylko w poszczególnych kursach.';
$string['errorformvalues'] = 'Wystąpiły błędy w wartościach formularza, popraw je.';
$string['errorlevelsincorrect'] = 'Minimalna liczba poziomów to 2';
$string['errornotalllevelsbadgesprovided'] = 'Nie wszystkie odznaki poziomów zostały dostarczone. Brak: {$a}';
$string['errorunknownevent'] = 'Błąd: nieznane zdarzenie';
$string['errorunknownmodule'] = 'Błąd: nieznany moduł';
$string['errorxprequiredlowerthanpreviouslevel'] = 'Wymagane punkty są niższe lub równe poprzedniemu poziomowi.';
$string['event_user_leveledup'] = 'Użykownik zdobył wyższy poziom';
$string['eventis'] = 'Zdarzenie to {$a}';
$string['eventname'] = 'Nazwa zdarzenia';
$string['eventproperty'] = 'Właściwość zdarzenia';
$string['eventsrules'] = 'Zasady zdarzeń';
$string['eventsrules_help'] = 'Ta wtyczka wykorzystuje zdarzenia do przypisywania punktów do działań wykonywanych przez uczniów.
Za pomocą poniższego formularza możesz dodawać własne reguły i modyfikować te domyślne.

Zaleca się sprawdzenie strony _Log_ wtyczki, aby określić, które zdarzenia są uruchamiane, gdy uczniowie wykonują czynności w ramach kursu.

Dodatkowe zasoby:

- [Jak obliczane są punkty doświadczenia?](https://levelup.plus/docs/article/how-are-experience-points-calculated?ref=blockxp_help)
- [Zasady rozwiązywania problemów](https://levelup.plus/docs/article/event-rule-not-working?ref=blockxp_help)';
$string['eventtime'] = 'Czas zdarzenia';
$string['filtermodules'] = 'Filtruj moduły';
$string['for1day'] = 'Przez 1 dzień';
$string['for1month'] = 'Przez miesiąc';
$string['for1week'] = 'Na tydzień';
$string['for3days'] = 'Przez 3 dni';
$string['forever'] = 'Na zawsze';
$string['forthewholesite'] = 'Dla całej witryny';
$string['give'] = 'dawać';
$string['gotofullladder'] = 'Przejdź do pełnej drabinki';
$string['grid'] = 'Siatka';
$string['hideparticipantsidentity'] = 'Ukryj tożsamość uczestników';
$string['hiderank'] = 'Ukryj pozycję';
$string['incourses'] = 'W kursach';
$string['ineffective'] = 'Nieskuteczny';
$string['infos'] = 'Informacja';
$string['instructions'] = 'Więcej informacji';
$string['invalidxp'] = 'Nieprawidłowa wartość punktów';
$string['keeplogs'] = 'Zachowaj dzienniki';
$string['ladder'] = 'Ranking';
$string['ladderadditionalcols'] = 'Dodatkowe kolumny';
$string['ladderadditionalcols_help'] = 'To ustawienie określa, które dodatkowe kolumny są wyświetlane w drabince. Naciśnij klawisz CTRL lub CMD podczas klikania, aby wybrać więcej niż jedną kolumnę lub odznaczyć wybraną kolumnę.';
$string['ladderempty'] = 'Ranking jest obecnie pusty, nie zapomnij wrócić później!';
$string['level'] = 'Poziom';
$string['levelbadges'] = 'Odznaki poziomu';
$string['levelbadgesformhelp'] = 'Nazwij pliki [poziom].[rozszerzenie pliku], na przykład: 1.png, 2.jpg itp. Zalecany rozmiar obrazu to 100x100.';
$string['levelcount'] = 'Liczba poziomów';
$string['leveldesc'] = 'Opis poziomu';
$string['leveldesc_help'] = 'Krótki opis poziomu, który jest wyświetlany na stronie informacyjnej obok tego samego poziomu. Możesz użyć tego, aby opisać nagrodę dla studentów, którzy osiągnęli ten poziom, dołączyć instrukcje, jak dążyć do tego poziomu, opisać poziom w zabawny sposób (np. _Tylko najodważniejsze dusze osiągnęły ten poziom_) itp. .';
$string['levelname'] = 'Nazwa poziomu';
$string['levelname_help'] = 'Krótka nazwa do wyświetlenia zamiast domyślnego Level #1_, _Level #2_ itd. który czasami jest wyświetlany. Jeśli nadajesz nazwy niektórym poziomom, zalecamy nadanie nazwy wszystkim z nich!';
$string['levels'] = 'Poziomy';
$string['levelswillbereset'] = 'Ostrzeżenie! Zapisanie tego formularza spowoduje ponowne obliczenie poziomów dla wszystkich!';
$string['levelup'] = 'Level up!';
$string['levelupplus'] = 'Level Up XP+';
$string['levelx'] = 'Poziom #{$a}';
$string['likenotice'] = '<strong>Podoba Ci się wtyczka?</strong> Poświęć chwilę, aby <a href="{$a->moodleorg}" target="_blank">dodać ją do ulubionych</a> na Moodle.org i <a href="{$a->github}" target="_blank">oznacz ją gwiazdką na GitHubie</a>.';
$string['limitparticipants'] = 'Limit uczestników';
$string['limitparticipants_help'] = 'To ustawienie kontroluje, kto jest wyświetlany na tablicy wyników. Sąsiedzi to uczestnicy w rankingu powyżej i poniżej bieżącego użytkownika. Na przykład, wybierając opcję „Wyświetl 2 sąsiadów”, wyświetlą się tylko dwaj uczestnicy, którzy znajdują się bezpośrednio wyżej i niżej niż bieżący użytkownik.';
$string['list'] = 'Lista';
$string['logging'] = 'Logowanie';
$string['manually'] = 'Ręcznie';
$string['maxactionspertime'] = 'Maks. czynności w przedziale czasowym';
$string['maxactionspertime_help'] = 'Maksymalna liczba czynności, które będą liczyć się do punktów w podanym przedziale czasowym. Wszelkie kolejne czynności zostaną zignorowane. Gdy ta wartość jest pusta lub równa zero, opcja nie ma zastosowania.';
$string['movecondition'] = 'Przenieś warunek';
$string['moverule'] = 'Przenieś regułę';
$string['name'] = 'Nazwa';
$string['navinfos'] = 'Informacje';
$string['navladder'] = 'Ranking';
$string['navlevels'] = 'Poziomy';
$string['navlevelssetup'] = 'Ustawienia';
$string['navlog'] = 'Logi';
$string['navpoints'] = 'Punkty';
$string['navpromo'] = 'XP+';
$string['navreport'] = 'Raport';
$string['navrules'] = 'Zasady';
$string['navsettings'] = 'Ustawienia';
$string['navvisuals'] = 'Wizualizacje';
$string['nodescription'] = 'Brak opisu';
$string['nologsrecordedyet'] = 'Logi nie zostały jeszcze zarejestrowane.';
$string['noname'] = 'Bez nazwy';
$string['notesomesettingslocked'] = 'Pamiętaj, że niektórych ustawień nie można edytować, jeśli zostały zablokowane przez administratora.';
$string['occasionally'] = 'Sporadycznie';
$string['participant'] = 'Uczestnik';
$string['participatetolevelup'] = 'Weź udział w kursie, aby zdobyć punkty doświadczenia i zdobyć wyższy poziom!';
$string['perpagecolon'] = 'Na stronę:';
$string['pickaconditiontype'] = 'Pick a condition type';
$string['pluginname'] = 'Level Up XP';
$string['pluginsoutofsync'] = '__Wtyczki nie są zsynchronizowane!__

Oznacza to, że uaktualniłeś _Level Up XP_ , ale nie _Level Up XP+_. Chociaż dokładamy wszelkich starań, aby zapobiegać wszelkim problemom, niektóre funkcje mogą już nie działać poprawnie, w tym sama wtyczka _Level Up XP_. Zalecamy uaktualnienie _Level Up XP+_ do najnowszej wersji. [Czytaj więcej]({$a->url})';
$string['pointsintimelinker'] = 'za';
$string['pointsrequired'] = 'Wymagane punkty';
$string['privacy:metadata:log'] = 'Przechowuje dziennik zdarzeń';
$string['privacy:metadata:log:eventname'] = 'Nazwa zdarzenia';
$string['privacy:metadata:log:time'] = 'Data, w której to się stało';
$string['privacy:metadata:log:userid'] = 'Użytkownik, który zdobył punkty';
$string['privacy:metadata:log:xp'] = 'Punkty przyznane za zdarzenie';
$string['privacy:metadata:prefintro'] = 'Rejestruje, czy użytkownik odrzucił wprowadzenie do bloku';
$string['privacy:metadata:prefladderpagesize'] = 'Preferowany przez użytkownika rozmiar strony podczas przeglądania drabinki';
$string['privacy:metadata:preflevelup'] = 'Rejestruje, czy użytkownik powinien zobaczyć powiadomienie o zwiększeniu poziomu';
$string['privacy:metadata:prefnotices'] = 'Rejestruje, czy użytkownik zamknął powiadomienie o wsparciu';
$string['privacy:metadata:prefseenpromo'] = 'Rejestruje, kiedy użytkownik oglądał stronę promocyjną';
$string['privacy:metadata:xp'] = 'Przechowuje punkty i poziom użytkowników';
$string['privacy:metadata:xp:lvl'] = 'Poziom użytkownika';
$string['privacy:metadata:xp:userid'] = 'Użytkownik';
$string['privacy:metadata:xp:xp'] = 'Punkty użytkownika';
$string['privacy:path:addon'] = 'Wtyczka';
$string['privacy:path:level'] = 'Poziom';
$string['privacy:path:logs'] = 'Logi';
$string['progress'] = 'Postęp';
$string['progressbar'] = 'Pasek postępu';
$string['promocheatguard'] = 'Ochrona przed oszustwem nie jest przeznaczona do obsługi długich ram czasowych. Rozważ uaktualnienie do <em>Level Up XP+</em>, aby odblokować dłuższe ramy czasowe i inne funkcje. <a href="{$a->url}">Więcej informacji znajdziesz tutaj</a>.';
$string['promocontactintro'] = 'Skontaktuj się z nami, aby uzyskać więcej informacji.';
$string['promocontactus'] = 'Skontaktuj się';
$string['promoemailusat'] = 'Napisz do nas na _levelup@branchup.tech_.';
$string['promoerrorsendingemail'] = 'Auć! Nie udało się wysłać wiadomości... proszę napisz do nas bezpośrednio na adres: {$a}. Dziękujemy!';
$string['promoifpreferemailusat'] = 'Psst! Jeśli wolisz, napisz do nas bezpośrednio na adres _{$a}_.';
$string['promointro'] = 'Zostań mistrzem gry i uwolnij pełny potencjał Level Up. Odblokuj dodatkowe funkcje dzięki Level Up XP+!';
$string['promointroinstalled'] = 'Dodatek _Level Up XP+_ jest zainstalowany w systemie i wszystkie jego funkcje zostały włączone.';
$string['promorulesdidyouknow'] = 'Czy wiesz, że dzięki <em>Level Up XP+</em> uczniowie mogą otrzymywać punkty za <em>ukończenie kursów</em> i <em>aktywności</em>, a nawet otrzymywać punkty zgodnie ze swoimi <em>ocenami </em>? <a href="{$a->url}">Więcej informacji znajdziesz tutaj</a>.';
$string['promoyourmessagewassent'] = 'Dziękujemy, twoja wiadomość została wysłana. Wkrótce skontaktujemy się z Tobą.';
$string['property:action'] = 'Akcja zdarzenia';
$string['property:component'] = 'Składnik zdarzenia';
$string['property:crud'] = 'Zdarzenie CRUD';
$string['property:eventname'] = 'Nazwa zdarzenia';
$string['property:target'] = 'Cel zdarzenia';
$string['rank'] = 'Pozycja';
$string['ranking'] = 'Ranking';
$string['ranking_help'] = 'Pozycja to bezwzględna pozycja bieżącego użytkownika w drabince. Pozycja względna to różnica w punktach doświadczenia między użytkownikiem a jego sąsiadami.';
$string['reallydeleteuserstate'] = 'Usunięcie użytkownika jest przydatne tylko do usunięcia go z drabinki. Z innych powodów zalecamy zamiast tego ustawienie ich punktów na 0. Pamiętaj, że ich usunięcie nie wpłynie na ich zdolność do zdobywania punktów w przyszłości.

Co ważne, podczas korzystania z _Level Up XP_ dla całej witryny, usunięcie ich spowoduje, że znikną z raportu, w którym to przypadku nie będzie można ponownie przypisać im punktów. Jeśli jednak korzystasz z _Level Up XP_ na kurs, uczestnik może nadal pojawiać się w raporcie, jeśli jest zapisany na kurs.

Czy na pewno chcesz usunąć punkty tego użytkownika?';
$string['reallyresetallcoursestodefaults'] = 'Naprawdę zresetować wszystkie reguły kursów do reguł domyślnych? To działanie jest nie odwracalne.';
$string['reallyresetcourserulestodefaults'] = 'Naprawdę zresetować reguły kursu do reguł domyślnych? To działanie jest nie odwracalne.';
$string['reallyresetdata'] = 'Naprawdę zresetować poziomy i punkty wszystkich na tym kursie?';
$string['reallyresetgroupdata'] = 'Naprawdę zresetować poziomy i punkty wszystkich w tej grupie?';
$string['reallyreverttopluginsdefaults'] = 'Naprawdę zresetować domyślne reguły do wartości domyślnych sugerowanych przez wtyczkę? To działanie nie jest odwracalne.';
$string['recentrewards'] = 'Ostatnie nagrody';
$string['releasenotes'] = 'Informacje o wydaniu';
$string['reportisempty'] = 'Raport jest pusty, student musi jeszcze zdobyć punkty.';
$string['reportisemptyenrolstudents'] = 'Raport jest pusty, czy studenci są zapisani w tym kursie?';
$string['requires'] = 'Wymaga';
$string['resetallcoursestodefaults'] = 'Zresetuj wszystkie kursy do wartości domyślnych';
$string['resetallcoursestodefaultsintro'] = 'Kliknij przycisk poniżej, aby zresetować wszystkie kursy do powyższych wartości domyślnych.';
$string['resetcoursedata'] = 'Zresetuj dane kursu';
$string['resetcourserulestodefaults'] = 'Zresetuj reguły kursu do wartości domyślnych';
$string['resetgroupdata'] = 'Zresetuj dane grupy';
$string['reverttopluginsdefaults'] = 'Przywróć ustawienia domyślne wtyczki';
$string['reverttopluginsdefaultsintro'] = 'Użyj poniższego przycisku, jeśli chcesz przywrócić powyższe ustawienia domyślne do ustawień domyślnych wtyczki. Nie wpływa to na zasady obowiązujące w istniejących kursach.';
$string['reward'] = 'Nagroda';
$string['rule'] = 'Zasada';
$string['rule:contains'] = 'zawiera';
$string['rule:eq'] = 'jest równe';
$string['rule:eqs'] = 'jest ściśle równa';
$string['rule:gt'] = 'jest większe niż';
$string['rule:gte'] = 'jest większe lub równe';
$string['rule:lt'] = 'jest mniejsze niż';
$string['rule:lte'] = 'jest mniejsze lub równe';
$string['rule:regex'] = 'pasuje do wyrażenia regularnego';
$string['rulecm'] = 'Aktywność lub zasób';
$string['rulecm_help'] = 'Ten warunek jest spełniony, gdy zdarzenie występuje w określonej aktywności lub zasobie.';
$string['rulecmdesc'] = 'Aktywność lub zasób to \'{$a->contextname}\'.';
$string['rulecmdescwithcourse'] = 'Aktywność lub zasób to: \'{$a->contextname}\' w \'{$a->coursename}\'.';
$string['rulecminfo'] = 'Warunek ten wymaga, aby czynność miała miejsce w określonej aktywności lub zasobie.';
$string['ruleevent'] = 'Konkretne zdarzenie';
$string['ruleeventdesc'] = 'Zdarzenie to \'{$a->eventname}\'';
$string['ruleeventinfo'] = 'Wybierz czynność, którą muszą wykonać użytkownicy, z wybranej listy zdarzeń.';
$string['ruleproperty'] = 'Właściwość zdarzenia';
$string['rulepropertydesc'] = 'Właściwość \'{$a->property}\' {$a->compare} \'{$a->value}\'.';
$string['rulepropertyinfo'] = 'Ten warunek dotyczy zaawansowanych użytkowników, którzy mają techniczną wiedzę na temat zdarzeń i ich właściwości.';
$string['ruleset'] = 'Zestaw warunków';
$string['ruleset:all'] = 'WSZYSTKIE warunki są spełnione';
$string['ruleset:any'] = 'DOWOLNY warunek jest spełniony';
$string['ruleset:none'] = 'ŻADEN warunek nie jest spełniony';
$string['rulesetinfo'] = 'Połącz wiele warunków w jeden.';
$string['rulesformhelp'] = '<p>Ta wtyczka wykorzystuje zdarzenia do przypisywania punktów do działań wykonywanych przez uczniów. Możesz użyć poniższego formularza, aby dodać własne reguły i wyświetlić te domyślne.</p>
<p>Zaleca się sprawdzenie <a href="{$a->log}">dziennika</a> wtyczki, aby określić, jakie zdarzenia są wyzwalane podczas wykonywania działań w kursie, a także przeczytać więcej o zdarzeniach: <a href="{$a->list}">lista wszystkich wydarzeń</a>, <a href="{$a->doc}">dokumentacja dla programistów</a>.</p>
<p>Na koniec pamiętaj, że wtyczka zawsze ignoruje:
<ul>
     <li>Czynności wykonywane przez administratorów, gości lub niezalogowanych użytkowników.</li>
     <li>Czynności wykonywane przez użytkowników, którzy nie mają uprawnienia <em>block/xp:earnxp</em>.</li>
     <li>Powtarzane czynności w krótkim odstępie czasu, aby zapobiec oszustwom.</li>
     <li>Wydarzenia oznaczone jako <em>anonimowe</em>, np. w anonimowej opinii.</li>
     <li>Wydarzenia na poziomie edukacyjnym nie równym <em></em>Uczestniczącym.</li>
</ul>
</p>';
$string['searchandselectcourse'] = 'Wyszukaj i wybierz kurs';
$string['searchandselectmodule'] = 'Wyszukaj i wybierz aktywność lub zasób';
$string['send'] = 'Wyślij';
$string['setpoints'] = 'Ustaw punkty';
$string['shortcode:xpbadge'] = 'Odznaka odpowiadająca poziomowi aktualnego użytkownika.';
$string['shortcode:xpiflevel'] = 'Wyświetlaj zawartość, gdy aktualny poziom użytkownika jest zgodny.';
$string['shortcode:xpiflevel_help'] = 'Zapoznaj się z poniższymi przykładami, aby sformatować ten krótki kod. Gdy poziom jest ściśle określony, zawartość będzie wyświetlana niezależnie od innych reguł.
Wszystkie reguły _większe_ i _mniej niż_ muszą być zgodne, aby treść była wyświetlana. Uważaj, ponieważ czasami może to spowodować, że treść nigdy nie zostanie wyświetlona!
Pamiętaj, że nauczyciele lub inni użytkownicy z możliwością edycji zawsze będą widzieć wszystko.

```
[xpiflevel 1 3 5]
    Wyświetlany, jeśli poziom użytkownika wynosi dokładnie 1, 3 lub 5.
[/xpiflevel]

[xpiflevel >3]
    Wyświetlany, jeśli poziom użytkownika jest wyższy niż 3.
[/xpiflevel]

[xpiflevel >=3]
    Wyświetlany, jeśli poziom użytkownika jest wyższy lub równy 3.
[/xpiflevel]

[xpiflevel >=10 <20 30]
    Wyświetlany, jeśli poziom użytkownika jest większy lub równy 10 ORAZ jest ściśle mniejszy niż 20
    LUB jest dokładnie równy 30.
[/xpiflevel]

[xpiflevel<=10 >=20]
    Nigdy nie wyświetlane, ponieważ poziom użytkownika nigdy nie może być mniejszy lub równy 10 ORAZ większy lub równy 20.
[/xpiflevel]
```

Zauważ, że te skróty NIE MOGĄ być zagnieżdżone w sobie.';
$string['shortcode:xpladder'] = 'Wyświetl część drabinki.';
$string['shortcode:xpladder_help'] = 'Domyślnie zostanie wyświetlona część rankingu w najbliższym sąsiedztwie bieżącego użytkownika.

```
[xpladder]
```

Aby wyświetlić 10 najlepszych studentów zamiast sąsiadów bieżącego użytkownika, ustaw parametr `top`. Możesz opcjonalnie ustawić liczbę wyświetlanych użytkowników, np. `top=20`.

```
[xpladder top]
[xpladder top=15]
```

Link do pełnego rankingu zostanie automatycznie wyświetlony pod tabelą, jeśli nie chcesz wyświetlać takiego linku, dodaj argument `ukryj link`.

```
[xpladder hidelink]
```

Domyślnie tabela nie zawiera kolumny postępu, która wyświetla pasek postępu. Jeśli taka kolumna została wybrana w dodatkowych kolumnach w ustawieniach rankingu, możesz użyć argumentu `withprogress`, aby ją wyświetlić.

```
[xpladder withprogress]
```

Zwróć uwagę, że jeśli kurs wykorzystuje grupy, ranking najlepiej odgadnie, dla której grupy wyświetlić wyniki.';
$string['shortcode:xplevelname'] = 'Wyświetl nazwę poziomu.';
$string['shortcode:xplevelname_help'] = 'Domyślnie tag wyświetla nazwę aktualnego poziomu użytkownika.
Alternatywnie możesz użyć argumentu `level`, aby wyświetlić nazwę konkretnego poziomu.

```
[xplevelname]
[xplevelname level=5]
```

Jeśli podano argument `level`, a poziom nie istnieje, nic nie zostanie wyświetlone.';
$string['shortcode:xppoints'] = 'Wyświetlaj liczbę punktów sformatowanych jako punkty doświadczenia.';
$string['shortcode:xpprogressbar'] = 'Pasek postępu bieżącego użytkownika do następnego poziomu.';
$string['someoneelse'] = 'Ktoś inny';
$string['somethinghappened'] = 'Coś się stało';
$string['taskcollectionloggerpurge'] = 'Wyczyść dzienniki';
$string['taskusagereport'] = 'Raport użytkowania';
$string['thankyou'] = 'Dziękujemy!';
$string['timebetweensameactions'] = 'Czas wymagany między identycznymi czynnościami';
$string['timebetweensameactions_help'] = 'Minimalny czas wymagany przed ponownym zaakceptowaniem czynności, która już miała miejsce. Czynność jest uważana za identyczna, jeśli została umieszczona w tym samym kontekście i przedmiocie, przeczytanie posta na forum zostanie uznane za identyczne, jeśli ten sam post zostanie ponownie przeczytany. Gdy ta wartość jest pusta lub równa zero, nie ma zastosowania.';
$string['timeformaxactions'] = 'Ramy czasowe dla max. czynności';
$string['timeformaxactions_help'] = 'Ramy czasowe (w sekundach), w których użytkownik nie powinien przekroczyć maksymalnej liczby czynności.';
$string['tinytimenow'] = '';
$string['tinytimeweeks'] = '';
$string['tinytimewithinayearformat'] = '';
$string['total'] = 'Suma';
$string['unknowneventa'] = 'Nieznane zdarzenie ({$a})';
$string['updateandpreview'] = 'Aktualizacja i podgląd';
$string['upgradingplugins'] = 'Aktualizacja wtyczek';
$string['urlaccessdeprecated'] = 'Dostęp przez ten adres URL jest przestarzały, zaktualizuj swoje linki.';
$string['usagereport'] = 'Udostępnij raport użytkowania';
$string['usagereport_desc'] = 'Okresowo udostępniaj anonimowe informacje o użytkowaniu twórcom wtyczek. Informacje te pomogą lepiej zrozumieć, w jaki sposób wtyczka jest używana i wpłyną na jej rozwój. Udostępnione informacje zawierają podstawowe informacje o witrynie Moodle (adres URL, wersja) oraz informacje o użytkowaniu wtyczki (liczba użytkowników zdobywających punkty, przegląd ustawień, używane reguły, ...).';
$string['usealgo'] = 'Użyj algorytmu';
$string['usecustomlevelbadges'] = 'Użyj niestandardowych odznak poziomu';
$string['usecustomlevelbadges_help'] = 'Po ustawieniu na tak musisz podać obraz dla każdego poziomu.';
$string['usingalgo'] = 'Używając algorytmu';
$string['value'] = 'Wartość';
$string['valuessaved'] = 'Wartości zostały pomyślnie zapisane.';
$string['viewas'] = 'Zobacz jako';
$string['viewtheladder'] = 'Zobacz drabinkę';
$string['visualsintro'] = 'Prześlij obrazy, aby dostosować wygląd poziomów.';
$string['wewillreplyat'] = 'Odpowiemy pod adresem: _{$a}_.';
$string['when'] = 'Kiedy';
$string['wherearexpused'] = 'Gdzie są używane punkty?';
$string['wherearexpused_desc'] = 'W przypadku ustawienia opcji „W kursach”, zdobyte punkty będą uwzględniały tylko kurs, do którego dodano blok. W przypadku ustawienia opcji „Dla całej witryny” użytkownik będzie zdobywał punkty na całej witrynie, a nie wybiórczo według kursu, wszystkie punkty zdobyte w witrynie będą wykorzystywane.';
$string['whoops'] = 'Ups!';
$string['xp'] = 'Punkty doświadczenia';
$string['xp:addinstance'] = 'Dodaj nowy blok';
$string['xp:earnxp'] = 'Zdobywanie punktów';
$string['xp:manage'] = 'Zarządzaj wszystkimi aspektami punktów doświadczenia';
$string['xp:myaddinstance'] = 'Dodaj blok do mojego Kokpitu';
$string['xp:view'] = 'Wyświetl blok i powiązane z nim strony';
$string['xp:viewlogs'] = 'Wyświetl dzienniki';
$string['xp:viewreport'] = 'Zobacz raport';
$string['xpgaindisabled'] = 'Zdobywanie punktów wyłączone';
$string['xprequired'] = 'Wymagane doświadczenie';
$string['xptogo'] = '[[{$a}]] do zdobycia';
$string['youreachedlevel'] = 'Osiągnąłeś poziom:';
$string['youreachedlevela'] = 'Osiągnąłeś poziom {$a}!';
$string['yourmessage'] = 'Twoja wiadomość';
$string['yourownrules'] = 'Twoje reguły';
