<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'uk', version '5.1'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Ви можете переглянути цей тест, але якщо б це була реальна спроба проходження тесту, перегляд буде заблоковано, тому що:';
$string['action'] = 'Дія';
$string['activityoverview'] = 'Ви маєте тести, які потрібно виконати';
$string['adaptive'] = 'Адаптивний режим';
$string['adaptive_help'] = 'Після запуску, в межах однієї спроби проходження тесту, дозволяється відповідати на запитання декілька разів. Отже, наприклад, якщо відповідь позначена як неправильна, студент може одразу ж спробувати відповісти знову. Проте, в залежності від налаштувань "Застосувати санкцію", за кожну неправильну відповідь студент втрачатиме бали.';
$string['add'] = 'Додати';
$string['addaquestion'] = 'нове питання';
$string['addarandomquestion'] = 'випадкове питання';
$string['addarandomquestion_help'] = 'Внаслідок вибору випадкового запитання, хаотично-обрані запитання з категорії вставляються в тест. Це означає, що різні студенти можуть отримати різний вибір запитань, і коли налаштування тесту дозволяють багато спроб, то кожна спроба може містити нові запитання.';
$string['addarandomselectedquestion'] = 'Додати випадково виділене питання....';
$string['addasection'] = 'Заголовок нової секції';
$string['adddescriptionlabel'] = 'Додати опис';
$string['addingquestion'] = 'Додавання запитання';
$string['addingquestions'] = '<p>На цій сторінці Ви можете управляти базою Ваших питань.  Питання зберігаються в категоріях (для організації сортування) і можуть використовуватися будь-яким тестом у Вашому курсі, або навіть декількох курсах, за умови, що категорія є \'Опублікованою\' . </p>
<p> Після того, як Ви створили категорію для питань, Ви зможете створювати або редагувати питання.  Після створення виберіть ті питання, які Ви хочете додати в тест.</p>';
$string['addmoreoverallfeedbacks'] = 'Додати {no} полів коментаря';
$string['addnewgroupoverride'] = 'Додати перевизначення групи';
$string['addnewpagesafterselected'] = 'Додати нову сторінку після вибраних запитань';
$string['addnewquestionsqbank'] = 'Додати запитання до категорії {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Додати перевизначення для користувача';
$string['addpagebreak'] = 'Додати розрив сторінки';
$string['addpagehere'] = 'Додати сторінку тут';
$string['addquestion'] = 'Додати питання';
$string['addquestionfrombankatend'] = 'Додати з банку питання в кінець';
$string['addquestionfrombanktopage'] = 'Додати з банку питань до сторінки {$a}';
$string['addquestions'] = 'Додати питання';
$string['addquestionstoquiz'] = 'Додати питання в поточний тест';
$string['addrandom'] = 'Додати {$a} випадкових питань';
$string['addrandom1'] = '<<Додати';
$string['addrandom2'] = 'випадкові питання';
$string['addrandomfromcategory'] = 'Додати випадкові питання з категорії:';
$string['addrandomquestion'] = 'Додати випадкове питання';
$string['addrandomquestionatend'] = 'Додати випадкове питання в кінець';
$string['addrandomquestiontopage'] = 'Додати випадкове питання до сторінки {$a}';
$string['addrandomquestiontoquiz'] = 'Додати випадкове питання до тесту {$a}';
$string['addselectedquestionstoquiz'] = 'Додати вибрані питання до тесту';
$string['addselectedtoquiz'] = 'Додати обране в тест';
$string['addtoquiz'] = 'Додати до тесту';
$string['affectedstudents'] = 'Протестовано {$a}';
$string['aftereachquestion'] = 'Після додавання кожного запитання';
$string['afternquestions'] = 'Після додавання {$a} запитань';
$string['age'] = 'період';
$string['allattempts'] = 'Усі спроби';
$string['allinone'] = 'Не обмежено';
$string['allowreview'] = 'Дозволити огляд';
$string['alreadysubmitted'] = 'Ви вже використали цю спробу';
$string['alternativeunits'] = 'Альтернативні одиниці виміру';
$string['alwaysavailable'] = 'Завжди доступний';
$string['alwayslatest'] = 'Завжди останній';
$string['analysisoptions'] = 'Параметри аналізу';
$string['analysistitle'] = 'Таблиця \'Аналіз тесту\'';
$string['answer'] = 'Відповідь';
$string['answered'] = 'Відповів';
$string['answerhowmany'] = 'Одна або кілька відповідей?';
$string['answers'] = 'Правильні відповіді';
$string['answersingleno'] = 'Кілька відповідей';
$string['answersingleyes'] = 'Одна відповідь';
$string['answertoolong'] = 'Відповідь перевищує максимальну кількість символів після {$a} (допустима кількість символів – 255)';
$string['anytags'] = 'Будь-які теги';
$string['aon'] = 'Формат AON';
$string['areyousureremoveselected'] = 'Ви впевнені, що хочете видалити всі обрані запитання?';
$string['asshownoneditscreen'] = 'Як показано у вікні редагування';
$string['attempt'] = 'Спроба {$a}';
$string['attemptalreadyclosed'] = 'Ця спроба вже завершена.';
$string['attemptclosed'] = 'Спроба ще не завершена';
$string['attemptduration'] = 'Затрачений час';
$string['attemptedon'] = 'Час спроби';
$string['attempterror'] = 'Вам не дозволено зараз проходити спробу тесту оскільки: {$a}';
$string['attempterrorcontentchange'] = 'Цей попередній перегляд тесту більше не існує. (Коли тест редагується, усі поточні попередні перегляди автоматично видаляються.)';
$string['attempterrorcontentchangeforuser'] = 'Ця спроба тесту більше не існує.';
$string['attempterrorinvalid'] = 'Недійсний ідентифікатор спроби тесту';
$string['attemptfirst'] = 'Перша спроба';
$string['attemptgradeddelay'] = 'Спроба відстроченої затримки сповіщень';
$string['attemptgradeddelay_desc'] = 'Перед надсиланням сповіщень із оцінкою за спробу застосувати затримку, щоб дати вчителю час для редагування оцінки.';
$string['attemptincomplete'] = 'Ця спроба ({$a}) ще не закінчена.';
$string['attemptlast'] = 'Остання спроба';
$string['attemptnumber'] = 'Спроба';
$string['attemptquiz'] = 'Спроба тесту';
$string['attemptquiznow'] = 'Почати тестування';
$string['attemptreviewtitle'] = '{$a}: спроба перегляду';
$string['attemptreviewtitlepaged'] = '{$a->name}: спроба перегляду (сторінка {$a->currentpage} з {$a->totalpages})';
$string['attempts'] = 'Спроби';
$string['attempts_help'] = 'Загальна кількість дозволених спроб (не кількість додаткових спроб).';
$string['attemptsallowed'] = 'Дозволено спроб';
$string['attemptsdeleted'] = 'Спроби тесту вилучено';
$string['attemptselection'] = 'Виберіть, які спроби аналізувати для кожного користувача:';
$string['attemptsexist'] = 'Цей тест вже має спроби відповіді.<br />Ви не можете більше додавати або вилучати питання.';
$string['attemptsnum'] = 'Спроб: {$a}';
$string['attemptsnumthisgroup'] = 'Спроб: {$a->total} ({$a->group} з цієї групи)';
$string['attemptsnumyourgroups'] = 'Спроб: {$a->total} ({$a->group} з ваших груп)';
$string['attemptsonly'] = 'Показати тільки студентів зі спробами';
$string['attemptstate'] = 'Стан';
$string['attemptstillinprogress'] = 'Спроба ще триває';
$string['attemptsummarytitle'] = '{$a}: підсумок спроби';
$string['attemptsunlimited'] = 'Необмежена кількість спроб';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (сторінка {$a->currentpage} з {$a->totalpages})';
$string['autosaveperiod'] = 'Затримка автоматичного збереження';
$string['autosaveperiod_desc'] = 'Відповіді студентів можуть зберігатися автоматично кожні кілька хвилин, протягом спроби тесту. Це компромісне рішення: автозбереження відповідей збільшує навантаження на сервер, але знижує ймовірність того, що роботу студентів буде втрачено.';
$string['back'] = 'Повернутися до перегляду запитання';
$string['backtocourse'] = 'Повернутися до курсу';
$string['backtoquestionlist'] = 'Повернутися до списку питань';
$string['backtoquiz'] = 'Повернутися до редагування';
$string['bestgrade'] = 'Кращий результат';
$string['bothattempts'] = 'Показати всіх студентів';
$string['browsersecurity'] = 'Безпека браузера';
$string['browsersecurity_help'] = 'Якщо вибрано "Повноекранний режим з JavaScript безпекою",
* Тестування розпочнеться лише в тому випадку, якщо студент має оснащений JavaScript мережевий браузер
* Вікно тесту з\'явиться на весь екран, закриє інші вікна, не допускається навігаційне управління
* По можливості не допускається використання студентами таких дій як скопіювати та вставити';
$string['cachedef_overrides'] = 'Інформація про заміну користувача та групи';
$string['calculated'] = 'Розрахункове';
$string['calculatedquestion'] = 'Розрахункове питання не підтримується в рядку {$a}. Це питання буде ігноруватися';
$string['cannotcreatepath'] = 'Неможливо створити шлях ({$a})';
$string['cannoteditafterattempts'] = 'Ви не можете додати чи видалити питання, тому що цей тест має спроби (треба видалити усі спроби або створити новий тест). ({$a})';
$string['cannotfindprevattempt'] = 'Неможливо знайти попередню спробу, на яку можна було б опертися.';
$string['cannotfindquestionregard'] = 'Не вдалося отримати питання для переоцінення!';
$string['cannotinsert'] = 'Неможливо вставити питання';
$string['cannotinsertrandomquestion'] = 'Неможливо вставити нове випадкове питання!';
$string['cannotloadquestion'] = 'Неможливо завантажити опції запитання';
$string['cannotloadtypeinfo'] = 'Неможливо завантажити інформацію питання для специфічного типу питання';
$string['cannotopen'] = 'Не вдається відкрити файл експорту ({$a})';
$string['cannotremoveallsectionslots'] = 'Ви вибрали всі запитання під заголовком розділу "{$a}". Не дозволяється видаляти всі запитання під заголовком розділу.';
$string['cannotremoveslots'] = 'Неможливо видалити запитання';
$string['cannotrestore'] = 'Неможливо відтворити послідовність запитань';
$string['cannotreviewopen'] = 'Ви не можете переглянути цю спроби, вона все ще відкрита';
$string['cannotsavelayout'] = 'Не вдалося зберегти макет';
$string['cannotsavenumberofquestion'] = 'Не вдалося зберегти кількість питань на сторінці';
$string['cannotsavequestion'] = 'Неможливо зберегти список питань';
$string['cannotsetgrade'] = 'Не вдалося встановити нову максимальну оцінку за тест';
$string['cannotsetsumgrades'] = 'Не вдалося встановити сумарну оцінку';
$string['cannotstartgradesmismatch'] = 'Ви не можете пройти цей тест, оскільки він передбачає оцінку з {$a->grade}, але жодне питання тесту не має шкали оцінювання. Він може розташовуватися на Сторінці редагування тестів.';
$string['cannotstartmissingquestion'] = 'Ви не можете пройти цей тест. Тест містить запитання, яке не існує.';
$string['cannotstartnoquestions'] = 'Ви не можете розпочати спробу проходження тесту, оскільки він ще не визначений. Не додано жодного запитання.';
$string['cannotwrite'] = 'Неможливо записати до файлу експорту ({$a})';
$string['canredoquestions'] = 'Дозволити повторну відповідь у спробі';
$string['canredoquestions_desc'] = 'Якщо ввімкнено, після завершення спроби поставити запитання відображається кнопка «Спробуйте інше запитання, як це». Це дає змогу спробувати створити подібне запитання (вибрано випадковим чином) або повторити те саме запитання без необхідності надсилати всю спробу тесту та не розпочати іншу спробу. Ця опція корисна для практичних тестів.

Цей параметр впливає лише на запитання та поведінку (наприклад, миттєвий зворотній зв’язок або інтерактивне з кількома спробами), якщо питання можна завершити до того, як спроба буде подана.';
$string['canredoquestions_help'] = 'Якщо ввімкнено, після завершення спроби поставити запитання відображається кнопка «Спробуйте інше запитання, як це». Це дає змогу спробувати створити подібне запитання (вибрано випадковим чином) або повторити те саме запитання без необхідності надсилати всю спробу тесту та не розпочати іншу спробу. Ця опція корисна для практичних тестів.

Цей параметр впливає лише на запитання та поведінку (наприклад, миттєвий зворотній зв’язок або інтерактивне з кількома спробами), якщо питання можна завершити до того, як спроба буде подана.';
$string['canredoquestionsyes'] = 'Так, надайте можливість спробувати інше запитання';
$string['caseno'] = 'Ні, регістр неважливий (малі чи великі літери не відрізняються)';
$string['casesensitive'] = 'Чутливість відповіді до регістра';
$string['caseyes'] = 'Так, регістр має відповідати (малі та великі літери відрізняються)';
$string['categoryadded'] = 'Категорію \'{$a}\' було додано';
$string['categorydeleted'] = 'Категорію \'{$a}\' було видалено';
$string['categorynoedit'] = 'Ви не маєте права редагування у категорії \'{$a}\'.';
$string['categoryupdated'] = 'Категорія була успішно оновлена';
$string['close'] = 'Закрити вікно';
$string['closebeforeopen'] = 'Неможливо оновити тест. Ви вказали дату завершення перед датою початку тесту.';
$string['closed'] = 'Закритий';
$string['closepreview'] = 'Закрити попередній перегляд';
$string['closereview'] = 'Закрити огляд';
$string['comment'] = 'Коментар';
$string['commentorgrade'] = 'Зробити коментар або змінити оцінку';
$string['comments'] = 'Коментарі';
$string['completedon'] = 'Завершено';
$string['completionattemptsexhausted'] = 'Або всі доступні спроби закінчено';
$string['completionattemptsexhausted_help'] = 'Тест позначається закінченим, коли студент використав максимальну кількість спроб.';
$string['completiondetail:minattempts'] = 'Зробіть спроби: {$a}';
$string['completiondetail:passorexhaust'] = 'Отримайте прохідну оцінку або виконайте всі доступні спроби';
$string['completionminattempts'] = 'Мінімальна кількість спроб:';
$string['completionminattemptsdesc'] = 'Необхідна мінімальна кількість спроб: {$a}';
$string['completionminattemptserror'] = 'Мінімальна кількість спроб має бути меншою або дорівнювати дозволеній кількості спроб.';
$string['completionpassorattemptsexhausteddesc'] = 'Студент повинен отримати прохідну оцінку або вичерпати всі доступні спроби для виконання цього завдання';
$string['configadaptive'] = 'Якщо Ви оберете Так у цих варіантах відповідей, студент матиме змогу багаторазово відповідати на запитання навіть у межах однієї спроби проходження тесту.';
$string['configattemptsallowed'] = 'Обмеження числа спроб проходження тесту студентом.';
$string['configdecimaldigits'] = 'Кількість знаків після коми при показу оцінки.';
$string['configdecimalplaces'] = 'Кількість знаків після коми, які мають бути показаними під час висвічування на екрані оцінки за тест.';
$string['configdecimalplacesquestion'] = 'Кількість цифр, які повинні бути показані після десяткової коми при відображенні оцінки для окремих питань.';
$string['configdelay1'] = 'Якщо ви встановите час очікування, то студент повинен зачекати, перш ніж він зможе спробувати тест вдруге.';
$string['configdelay1st2nd'] = 'Якщо Ви установите тут час затримки, студент не матиме змоги розпочати свою другу спробу, поки не пройде встановлений проміжок часу після першої спроби.';
$string['configdelay2'] = 'Якщо ви встановите час очікування, то студент повинен зачекати, перш ніж він зможе розпочати третю та наступні спроби.';
$string['configdelaylater'] = 'Якщо Ви установите тут час затримки, студент не матиме змоги розпочати свою третю, четверту, ... спробу, поки не пройде встановлений проміжок часу після завершення попередньої спроби.';
$string['configeachattemptbuildsonthelast'] = 'Якщо студентам дозволено кілька спроб, то кожна наступна спроба буде містити результати попередньої.';
$string['configgrademethod'] = 'Якщо студентам дозволено кілька спроб, то який метод підрахунку фінальної оцінки потрібно використовувати.';
$string['configintro'] = 'Встановлені тут параметри визначають типові параметри, які використані в налаштуваннях, коли Ви створюєте новий тест. Ви також можете визначити, які з параметрів будуть належати до розширених.';
$string['configmaximumgrade'] = 'Типова оцінка, до якої буде приводитися оцінка за тест.';
$string['confignavmethod'] = 'При Довільній навігації можна давати відповіді на питання не послідовно, а вибірково, використовуючи навігацію. При Послідовній навігації питання потребують відповіді у чітко визначеній послідовності.';
$string['confignewpageevery'] = 'При додаванні питань до тесту розриви сторінки автоматично вставлятимуться у відповідності з вказаними тут налаштуваннями.';
$string['configoutcomesadvanced'] = 'Якщо ця опція включена, то Результати у формі редагування тесту є розширеними налаштуваннями.';
$string['configpenaltyscheme'] = 'Штрафні бали за кожну неправильну відповідь у навчальному режимі.';
$string['configpopup'] = 'Примусово спроба відкриватиметься у новому вікні, та використовуватиметься JavaScript для заборони копіювання та вставки (і іншого) в процесі проходження спроби тесту.';
$string['configrequirepassword'] = 'Студенти повинні ввести цей пароль для того щоб розпочати спробу тестування.';
$string['configrequiresubnet'] = 'Студенти зможуть проходити спроби тільки з цих комп’ютерів.';
$string['configreviewoptions'] = 'Ці параметри контролюють, яку інформацію зможуть бачити студенти при перегляді спроби тесту або при перегляді звіту тестування.';
$string['configshowblocks'] = 'Показувати блоки під час спроби проходження тесту.';
$string['configshowuserpicture'] = 'Показувати фотографію користувача на екрані під час проходження тесту.';
$string['configshufflewithin'] = 'Якщо ви включите цю опцію, то порядок відповідей у питаннях буде випадковим кожного разу, коли студент починає нову спробу тесту, за умови, що подібна опція включена і в налаштуванні питання.';
$string['configtimelimit'] = 'Типове обмеження часу для проходження тесту в хвилинах. 0 означає "без обмежень".';
$string['configtimelimitsec'] = 'Типове обмеження часу для проходження тесту в секундах. 0 означає "без обмежень".';
$string['configurerandomquestion'] = 'Налаштування питання';
$string['confirmclose'] = 'Надіславши свої відповіді, ви не зможете їх змінити.';
$string['confirmremovequestion'] = 'Ви впевнені, що бажаєте видалити це питання {$a}?';
$string['confirmremovesectionheading'] = 'Ви впевнені, що бажаєте видалити заголовок секції {$a}?';
$string['confirmserverdelete'] = 'Ви впевнені, що хочете видалити сервер <b>{$a}</b> зі списку?';
$string['connectionerror'] = 'Мережеве підключення втрачено. (Автозбереження не вдалося).

Запишіть відповіді введені на цій сторінці за останні кілька хвилин, потім спробуйте знову підключити.

Після того, як з\'єднання буде відновлено, ваші відповіді мають бути збережені і це повідомлення зникне.';
$string['connectionok'] = 'Мережеве підключення відновлено. Ви можете безпечно продовжувати.';
$string['containercategorycreated'] = 'Ця категорія була створена для зберігання всіх оригінальних категорій переміщених у рівня сайту через причини, зазначені нижче.';
$string['continueattemptquiz'] = 'Продовжуйте свою спробу';
$string['continuepreview'] = 'Продовжити останній перегляд';
$string['copyingfrom'] = 'Створення копії питання "{$a}"';
$string['copyingquestion'] = 'Копіювання питання';
$string['correct'] = 'Правильно';
$string['correctanswer'] = 'Правильна відповідь';
$string['correctanswerformula'] = 'Формула для правильної відповіді (без "=", напр.: <b>2*sin({x}+{y})</b>)';
$string['correctansweris'] = 'Правильна відповідь: {$a}';
$string['correctanswerlength'] = 'Значущих цифр';
$string['correctanswers'] = 'Правильні відповіді';
$string['correctanswershows'] = 'Показати правильну відповідь';
$string['corrresp'] = 'Правильна відповідь';
$string['countdown'] = 'Зворотний відлік';
$string['countdownfinished'] = 'Тест зараз закриється. Ви повинні відправити відповіді зараз.';
$string['countdowntenminutes'] = 'Тестування завершиться через 10 хвилин.';
$string['coursetestmanager'] = 'Формат - управління тестуванням курсу';
$string['createcategoryandaddrandomquestion'] = 'Створити категорію та додати випадкове питання';
$string['createfirst'] = 'Ви повинні спочатку створити кілька питань типу Коротка Відповідь';
$string['createmultiple'] = 'Додати в тест кілька випадкових питань';
$string['createnewquestion'] = 'Створити питання';
$string['createquestionandadd'] = 'Створює нове запитання та додає його до тесту.';
$string['custom'] = 'Формат користувача';
$string['dataitemneed'] = 'Вам необхідно додати хоча б одну відповідь, щоб питання було дійсним';
$string['datasetdefinitions'] = 'Визначення набору даних багатократного використання для категорії {$a}';
$string['datasetnumber'] = 'Номер';
$string['daysavailable'] = 'Доступно днів';
$string['decimaldigits'] = 'Десяткове значення в оцінках';
$string['decimalplaces'] = 'Кількість десяткових знаків в оцінці за тест';
$string['decimalplaces_help'] = 'Це налаштування визначає кількість десяткових знаків, які будуть відображатися при показу оцінок та балів. Актуальне тільки під час показу оцінок, у базі даних та під час обрахунку оцінок, їх значення буде повне. Тобто, якщо ви захочете змінити кількість знаків після коми, то оцінка буде відображатися правильно.';
$string['decimalplacesquestion'] = 'Десяткові знаки в знаках для питань';
$string['decimalplacesquestion_help'] = 'Кількість цифр, що відображаються після коми під час відображення оцінок для окремих питань.';
$string['decimalpoints'] = 'Десяткові знаки';
$string['default'] = 'Типово';
$string['defaultgrade'] = 'Типова оцінка з питання';
$string['defaultinfo'] = 'Типова категорія для запитань';
$string['delay1'] = 'Час між першою та другою спробами';
$string['delay1st2nd'] = 'Примусовий час очікування між першою та другою спробами';
$string['delay1st2nd_help'] = 'Якщо включено, то студент повинен зачекати визначений час перед тим як матиме можливість другої спроби.';
$string['delay2'] = 'Час між пізнішими спробами';
$string['delaylater'] = 'Примусовий час очікування між пізнішими спробами';
$string['delaylater_help'] = 'Якщо включено, то студент повинен зачекати визначений час перед тим як матиме можливість третьої та наступних спроб.';
$string['deleteattemptcheck'] = 'Ви упевнені, що хочете повністю видалити ці спроби?';
$string['deleteselected'] = 'Видалити вибрані';
$string['deletingquestionattempts'] = 'Видалення спроб питання';
$string['description'] = 'Опис';
$string['disabled'] = 'Відключено';
$string['displayoptions'] = 'Параметри перегляду';
$string['donotuseautosave'] = 'Не використовувати автоматичне збереження';
$string['download'] = 'Натисніть для збереження файлу експорту на своєму комп\'ютері.';
$string['downloadextra'] = '(файл також зберігається у файлах курсу в каталозі /backupdata/quiz)';
$string['dragtoafter'] = 'Після {$a}';
$string['dragtostart'] = 'На початок';
$string['duplicateresponse'] = 'Відповідь не була відправлена, оскільки Ви дали аналогічну відповідь раніше.';
$string['eachattemptbuildsonthelast'] = 'Кожна спроба ґрунтується на попередній';
$string['eachattemptbuildsonthelast_help'] = 'Якщо студентам дозволено проходити кілька спроб тестування та включено цей параметр, то кожна нова спроба тестування буде включати результати попередньої. Це дозволяє завершити тест протягом кількох спроб.';
$string['edit_slotdisplaynumber_hint'] = 'Редагувати номер запитання (максимум 16 символів)';
$string['edit_slotdisplaynumber_label'] = 'Нове значення для {$a}';
$string['editcategories'] = 'Редагувати категорії';
$string['editcategory'] = 'Редагувати категорію';
$string['editcatquestions'] = 'Редагувати питання в категорії';
$string['editingquestion'] = 'Редагування питання';
$string['editingquiz'] = 'Редагування тесту';
$string['editingquiz_help'] = 'При роботі з тестом є такі основні поняття:
* Тест - набір питань на одній або кількох сторінках
* Банк питань - зберігає копії всіх питань розділені за категоріями
* Випадкові питання - студенти можуть отримувати різні питання при кожній наступній спробі та кожен зі студентів буде отримувати власний набір питань';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Редагування тесту: {$a}';
$string['editmaxmark'] = 'Редагувати максимальну оцінку';
$string['editoverride'] = 'Редагувати перевизначення';
$string['editqcats'] = 'Редагувати категорії питань';
$string['editquestion'] = 'Редагувати питання';
$string['editquestions'] = 'Редагувати питання';
$string['editquiz'] = 'Редагувати тест';
$string['editquizquestions'] = 'Редагувати питання тесту';
$string['emailconfirmautosubmitsmall'] = 'Дякуємо, що надіслали свої відповіді на "{$a->quizname}"';
$string['emailconfirmbody'] = 'Шановний(на) {$a->username},

 Дякуємо, що надіслали свої відповіді на \'{$a->quizname}\' в курсі \'{$a->coursename}\' в {$a->submissiontime}.

Це повідомлення підтверджує, що ваші відповіді збережено.

Ви можете мати доступ до результатів курсу за цим посиланням: {$a->quizurl}.';
$string['emailconfirmbodyautosubmit'] = 'Привіт, {$a->username}!

Час проведення тесту \'{$a->quizname}\' в курсі \'{$a->coursename}\' закінчився.

Ваші відповіді надіслано автоматично о {$a->submissiontime}.

Це повідомлення підтверджує, що ваші відповіді збережено. Ви можете отримати доступ до цього тесту на сторінці {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Дякуємо Вам за проходження тесту \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Підтвердження проходження тесту: {$a->quizname}';
$string['emailmanualgradedbody'] = 'Вітаємо, {$a->studentname}!

Ваші відповіді на "{$a->quizname}" з курсу "{$a->coursename}" на {$a->attempttimefinish} тепер оцінені.

Ви зможете переглянути свої оцінки та відгуки, відвідавши \'{$a->quizurl}\' та переглянувши свою спробу.';
$string['emailmanualgradedsubject'] = 'Вашу спробу {$a->quizname} оцінено';
$string['emailnotifybody'] = 'Привіт, {$a->username}!

{$a->studentname} завершив \'{$a->quizname}\' ({$a->quizurl}) з курсу \'{$a->coursename}\'.

Ви можете переглянути цю спробу на сторінці {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} пройшов {$a->quizname}. Дивіться {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} пройшов тест {$a->quizname}';
$string['emailoverduebody'] = 'Вітаємо, {$a->studentname}!

Ви почали спробу \'{$a->quizname}\' в курсі \'{$a->coursename}\', але так і не подали її. Його мав надіслати {$a->attemptduedate}.

Якщо ви все одно хочете надіслати цю спробу, перейдіть на сторінку {$a->attemptsummaryurl} і натисніть кнопку надіслати. Ви повинні зробити це до {$a->attemptgraceend}, інакше ваша спроба не буде зарахована.';
$string['emailoverduesmall'] = 'Ви не закінчили вашої спроби {$a->quizname}. Будь ласка, перейдіть до {$a->attemptsummaryurl} до {$a->attemptgraceend}, щоб закінчити її.';
$string['emailoverduesubject'] = 'Прострочена спроба: {$a->quizname}';
$string['empty'] = 'Порожньо';
$string['enabled'] = 'Дозволено';
$string['endtest'] = 'Завершити спробу...';
$string['erroraccessingreport'] = 'Ви не маєте доступу до цього звіту';
$string['errorinquestion'] = 'Помилка в питанні';
$string['errormissingquestion'] = 'Помилка: У системі відсутні питання з ідентифікатором {$a}';
$string['errornotnumbers'] = 'Помилка: Відповіді повинні бути числовими';
$string['errorunexpectedevent'] = 'Несподіваний код події {$a->event} знайдено для питання {$a->questionid} у спробі {$a->attemptid}.';
$string['essay'] = 'Есе';
$string['essayquestions'] = 'Питання';
$string['eventattemptautosaved'] = 'Спроба тесту автоматично збережена';
$string['eventattemptdeleted'] = 'Вилучено спробу тесту';
$string['eventattemptmanualgradingcomplete'] = 'Спроба тестування вручну завершена';
$string['eventattemptpreviewstarted'] = 'Почато перегляд спроби тесту';
$string['eventattemptquestionrestarted'] = 'Питання про спробу тесту перезапущено';
$string['eventattemptreviewed'] = 'Переглянуто спробу тесту';
$string['eventattemptsummaryviewed'] = 'Переглянуто резюме спроби тесту';
$string['eventattemptupdated'] = 'Спроба тесту оновлена';
$string['eventattemptviewed'] = 'Переглянуто спробу тесту';
$string['eventeditpageviewed'] = 'Переглянуто сторінку редагування тесту';
$string['eventoverridecreated'] = 'Створено перевизначення тесту';
$string['eventoverridedeleted'] = 'Вилучено перевизначення тесту';
$string['eventoverrideupdated'] = 'Оновлено перевизначення тесту';
$string['eventpagebreakcreated'] = 'Розрив сторінки створено';
$string['eventpagebreakdeleted'] = 'Розрив сторінки видалено';
$string['eventquestionmanuallygraded'] = 'Оцінено питання вручну';
$string['eventquizattemptabandoned'] = 'Кинута спроба тесту';
$string['eventquizattemptregraded'] = 'Спроба тесту переоцінена';
$string['eventquizattemptreopened'] = 'Спроба вікторини знову відкрита';
$string['eventquizattemptstarted'] = 'Почато спробу тесту';
$string['eventquizattemptsubmitted'] = 'Завершено спробу тесту';
$string['eventquizattempttimelimitexceeded'] = 'Перевищено час на спробу тесту';
$string['eventquizgradeupdated'] = 'Оцінку тесту оновлено';
$string['eventquizrepaginated'] = 'Тест повторно розбитий на сторінки';
$string['eventreportviewed'] = 'Переглянуто звіт тесту';
$string['eventsectionbreakcreated'] = 'Створено розрив розділу';
$string['eventsectionbreakdeleted'] = 'Розрив розділу видалено';
$string['eventsectionshuffleupdated'] = 'Перемішування розділів оновлено';
$string['eventsectiontitleupdated'] = 'Оновлено назву розділу';
$string['eventslotcreated'] = 'Слот створено';
$string['eventslotdeleted'] = 'Слот видалено';
$string['eventslotdisplayedquestionnumberupdated'] = 'Номер запитання, що відображається у слоті, оновлено';
$string['eventslotmarkupdated'] = 'Позначка слота оновлена';
$string['eventslotmoved'] = 'Слот переміщено';
$string['eventslotrequirepreviousupdated'] = 'Слот вимагає попереднього оновлення';
$string['everynquestions'] = 'Кожні {$a} питань(ня)';
$string['everyquestion'] = 'Кожне запитання';
$string['everythingon'] = 'Все включено';
$string['existingcategory'] = 'Існуюча категорія';
$string['exportcategory'] = 'експорт категорії';
$string['exporterror'] = 'Помилка під час процесу експортування';
$string['exportingquestions'] = 'Запитання експортовано у файл';
$string['exportname'] = 'Ім`я файлу';
$string['exportquestions'] = 'Експортувати питання у файл';
$string['extraattemptrestrictions'] = 'Додаткові обмеження на спроби';
$string['false'] = 'Неправильно';
$string['feedback'] = 'Відгук';
$string['feedbackerrorboundaryformat'] = 'Межа для відгуку до оцінки за неповну відповідь повинна бути відсотком або числом. Введене вами значення {$a} не приймається.';
$string['feedbackerrorboundaryoutofrange'] = 'Межа для відгуку до оцінки за неповну відповідь повинна бути в межах 0-100%. Введене вами значення {$a} не в діапазоні.';
$string['feedbackerrorjunkinboundary'] = 'Вам потрібно заповнити всі межі для коментарів до рівнів оцінок без пропуску.';
$string['feedbackerrorjunkinfeedback'] = 'Вам потрібно заповнити всі відгуки до рівнів оцінок без пропусків.';
$string['feedbackerrororder'] = 'Межі для відгуку до оцінки за неповну відповідь повинні бути відсортовані від найвищих до найменших. Введене вами значення {$a} поза послідовністю.';
$string['file'] = 'Файл';
$string['fileformat'] = 'Формат файлу';
$string['fillcorrect'] = 'Заповнити правильно';
$string['filloutnumericalanswer'] = 'Ви забезпечуєте як мінімум одну можливу відповідь та припустиме відхилення. Перша відповідна відповідь буде використовуватися для оцінювання та коментарю. Якщо ви маєте певні коментарі без вказаної відповіді, це буде показано студентам, якщо їхня відповідь не підпадає під жодну категорію.';
$string['filloutoneanswer'] = 'Необхідно заповнити хоча б одну можливу відповідь, інакше питання не буде використовуватися. Порожні варіанти також не використовуватимуться. Символ ’*’ (зірочка) може відповідати будь-якій послідовності символів. Перший варіант, що збігся з відповіддю, буде використовуватися для оцінювання та коментування.';
$string['filloutthreequestions'] = 'Необхідно заповнити не менше трьох варіантів відповідей. Ви можете надати додаткові неправильні відповіді, даючи відповідь з порожнім питанням. Записи, де і питання і відповідь будуть порожні - ігноруватимуться.';
$string['fillouttwochoices'] = 'Необхідно заповнити не менше двох варіантів відповідей. Можуть залишатися порожні поля.';
$string['finishattemptdots'] = 'Завершити спробу...';
$string['finishreview'] = 'Завершити перегляд';
$string['forceregeneration'] = 'примусове оновлення';
$string['formatnotfound'] = 'Формат імпорту / експорту {$a} не знайдений';
$string['formulaerror'] = 'Помилка в формулі!';
$string['fractionsaddwrong'] = 'Позитивні оцінки за питання в сумі не становлять 100% <br />Їхня сума {$a}%.<br />  Повернутися й виправити питання?';
$string['fractionsnomax'] = 'Одна з відповідей повинна бути оцінена в 100%, щоб<br />було можливо одержати оцінку за це питання<br /> чи хочете ви повернутися й виправити питання?';
$string['fromfile'] = 'з файлу:';
$string['functiondisabledbysecuremode'] = 'Наразі ця функціональність вимкнена';
$string['generalfeedback'] = 'Загальний відгук';
$string['generalfeedback_help'] = 'Загальний відгук - це текст, який показується після того, як відбулася спроба відповіді на питання. На відміну від відгуку до конкретної відповіді, яка була обрана, загальний відгук показується завжди.';
$string['gobacktoquiz'] = 'Повертайся';
$string['graceperiod'] = 'Пільговий період подання';
$string['graceperiod_desc'] = 'Якщо для параметра "Що робити після закінчення часу" встановлено значення "Існує пільговий період...", то це дозволений додатковий час за замовчуванням.';
$string['graceperiod_help'] = 'Якщо для параметра «Що робити після закінчення часу» встановлено значення «Є пільговий період...», то це дозволений додатковий час.';
$string['graceperiodmin'] = 'Останній пільговий період подання';
$string['graceperiodmin_desc'] = 'У кінці тесту є потенційна проблема. З одного боку, ми хочемо, щоб студенти продовжували працювати до останньої секунди – за допомогою таймера, який автоматично подає тест, коли закінчиться час. З іншого боку, сервер може бути перевантажений, і йому знадобиться деякий час для обробки відповідей. Тому ми прийматимемо відповіді протягом тривалого часу після закінчення часу, тому вони не будуть покарані за повільну роботу сервера. Однак учень міг обдурити і отримати стільки секунд, щоб відповісти на тест. Ви повинні зробити компроміс на основі того, наскільки ви довіряєте продуктивності свого сервера під час тестів.';
$string['graceperiodtoosmall'] = 'Пільговий період повинен бути більше ніж {$a}.';
$string['gradeall'] = 'Оцінити все';
$string['gradeaverage'] = 'Середня оцінка';
$string['gradeboundary'] = 'Гранична оцінка';
$string['gradeessays'] = 'Оцінити есе';
$string['gradehighest'] = 'Краща оцінка';
$string['gradeitems'] = 'Елементи оцінювання';
$string['grademethod'] = 'Метод оцінювання';
$string['grademethod_help'] = 'Якщо в процесі проходження тесту дозволено кілька спроб, то фінальна оцінка може вираховуватися кількома способами:

* Найкраща оцінка зі всіх спроб
* Середня оцінка зі всіх спроб
* Перша спроба (всі інші ігноруються)
* Остання спроба (всі інші ігноруються)';
$string['gradesdeleted'] = 'Оцінювання тесту вилучено';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Оцінка для успішного проходження не може бути нульовою, оскільки для цього тесту встановлений метод проходження, який вимагає проходження. Будь ласка, встановіть ненульове значення.';
$string['gradetopassoutof'] = 'Прохідний бал: {$a->grade} з {$a->maxgrade}';
$string['gradingdetails'] = 'Балів за відповідь: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'З урахуванням попередніх штрафів набрано <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'При наступній спробі буде знято {$a} бала';
$string['gradingdetailszeropenalty'] = 'Дана відповідь не спричинила штрафу';
$string['gradingmethod'] = 'Метод оцінювання: {$a}.';
$string['groupoverrides'] = 'Перевизначення для групи';
$string['groupoverridesdeleted'] = 'Перевизначення для групи вилучено';
$string['groupsnone'] = 'Немає груп, до яких ви можете отримати доступ.';
$string['guestsno'] = 'Гість не може бачити або проходити тест';
$string['hidebreaks'] = 'Сховати розриви сторінок';
$string['hidereordertool'] = 'Сховати інструменти переупорядкування';
$string['history'] = 'Історія відповідей:';
$string['howquestionsbehave_desc'] = 'Типові налаштування для поведінки питань у тесті.';
$string['imagedisplay'] = 'Картинка для показу';
$string['import_help'] = 'Ця функція дозволяє імпортувати питання із зовнішніх текстових файлів.

Якщо ваш файл містить не-ASCII символи, то він повинен використовувати кодування UTF-8. Будьте особливо обережні з файлами, створеними в програмах Microsoft Office, так як вони зазвичай використовують спеціальне кодування, яке не буде оброблено правильно.

Імпорт і експорт форматів це модульний ресурс. Інші додаткові формати можуть бути доступні в базі даних модулів та плагінів.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'імпортувати категорію';
$string['importerror'] = 'Помилка під час процесу імпортування';
$string['importfilearea'] = 'Імпортування з файлу, який вже завантажено до курсу...';
$string['importfileupload'] = 'Імпортування з файлу, який буде завантажено на сервер...';
$string['importfromthisfile'] = 'Імпорт з цього файлу';
$string['importingquestions'] = 'Імпортування {$a} запитань з файлу';
$string['importmax10error'] = 'У цьому питанні помилка. Ви не можете вказувати більше 10 відповідей';
$string['importmaxerror'] = 'У цьому питанні помилка. Ви вказали дуже багато відповідей';
$string['importquestions'] = 'Імпорт питань з файлу';
$string['inactiveoverridehelp'] = '* Це перевизначення неактивне, оскільки доступ користувача до активності обмежено. Це може бути пов’язано з призначенням груп або ролей, іншими обмеженнями доступу або прихованою активністю.';
$string['incorrect'] = 'Неправильно';
$string['indicator:cognitivedepth'] = 'Тест: пізнавальний аспект';
$string['indicator:cognitivedepth_help'] = 'Цей показник базується на глибині пізнання, досягнутої студентом під час тесту.';
$string['indicator:cognitivedepthdef'] = 'Тест пізнавальна';
$string['indicator:cognitivedepthdef_help'] = 'Учасник досяг цього відсотка когнітивної активності, запропонованої тестом під час цього інтервалу аналізу (Рівні = Немає перегляду, Переглянути, Надіслати, Переглянути відгук, Коментар до відгуку, Повторно надіслати після перегляду відгуку)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Тест: соціальний аспект';
$string['indicator:socialbreadth_help'] = 'Цей показник заснований на соціальному розширенні, досягнутому студентом у тесті.';
$string['indicator:socialbreadthdef'] = 'Тест соц';
$string['indicator:socialbreadthdef_help'] = 'Учасник досяг цього відсотка соціальної залученості, запропонованої за допомогою тесту, протягом цього інтервалу аналізу (Рівні = Без участі, Учасник сам, Учасник з іншими)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Відповіді учасників з кожного питання';
$string['info'] = 'Інформація';
$string['infoshort'] = 'і';
$string['initialnumfeedbacks'] = 'Початкова кількість полів для відгуків';
$string['initialnumfeedbacks_desc'] = 'Коли створюється новий тест, буде створено таку кількість полів під відгуки. Коли тест вже створено, форма покажу таку кількість полів для відгуків у тесті. Потрібно, щоб було визначено хоча б 1.';
$string['inprogress'] = 'В процесі';
$string['introduction'] = 'Опис';
$string['invalidattemptid'] = 'Не існує спроби з таким кодом';
$string['invalidcategory'] = 'Некоректний ідентифікатор категорії';
$string['invalidoverrideid'] = 'Неправильний код перевизначення';
$string['invalidquestionid'] = 'Неправильний код питання';
$string['invalidquizid'] = 'Неправильний код тесту';
$string['invalidrandomslot'] = 'Недійсний ідентифікатор місця для випадкового запитання.';
$string['invalidsource'] = 'Джерело не прийнято за дійсне.';
$string['invalidsourcetype'] = 'Неправильний тип джерела.';
$string['invalidstateid'] = 'Неприпустимий код';
$string['lastanswer'] = 'Ваша остання відповідь була';
$string['layout'] = 'Макет';
$string['layoutasshown'] = 'Розмітка сторінки, як показано.';
$string['layoutasshownwithpages'] = 'Розмітка сторінки, як показано.<small>(Автоматично нову сторінку на кожні {$a} питань.)</small>';
$string['layoutshuffledandpaged'] = 'Питання перемішані у випадковому порядку по {$a} на сторінку.';
$string['layoutshuffledsinglepage'] = 'Питання перемішані у випадковому порядку, всі на одній сторінці.';
$string['link'] = 'Посилання';
$string['listitems'] = 'Список елементів тесту';
$string['literal'] = 'Буквенний';
$string['loadingquestionsfailed'] = 'Помилка завантаження питаннь: {$a}';
$string['makecopy'] = 'Зберегти як нове питання';
$string['managetypes'] = 'Управляти типами питань і серверами';
$string['manualgradequestion'] = 'Вручну оцінити відповідь на питання {$a->question} в {$a->quiz} від {$a->user}';
$string['manualgrading'] = 'Оцінювання';
$string['mark'] = 'Перевірити';
$string['markall'] = 'Перевірити сторінку';
$string['marks'] = 'Балів';
$string['marks_help'] = 'Бали по кожному питанню і за всю спробу взагалі';
$string['match'] = 'Відповідність';
$string['matchanswer'] = 'Відповідна відповідь';
$string['matchanswerno'] = 'Відповідна відповідь {$a}';
$string['max'] = 'Макс';
$string['maxmark'] = 'Максимальна оцінка';
$string['maxmarks'] = 'Максимальні оцінки';
$string['maxmarks_help'] = 'Максимальна кількість балів визначає, чи прихована інформація про оцінку, чи як вона відображається:

* Щоб повністю приховати інформацію про оцінку, не встановлюйте цей прапорець (прапорець «Оцінки» вимикається автоматично).

* Щоб відображати лише максимальну кількість балів: установіть цей прапорець, а не прапорець «Балки».

* Щоб відображати як максимальні бали, так і бали, установіть цей прапорець, а також прапорець «Оцінки».';
$string['messageprovider:attempt_grading_complete'] = 'Повідомлення про те, що вашу спробу оцінено';
$string['messageprovider:attempt_overdue'] = 'Попередження, коли спроба тесту стає простроченою';
$string['messageprovider:confirmation'] = 'Підтвердження власного проходження тесту';
$string['messageprovider:submission'] = 'Повідомлення про те, що ваші студенти подали тести';
$string['min'] = 'Мін';
$string['minutes'] = 'Хвилин';
$string['missingcorrectanswer'] = 'Повинна бути визначена правильна відповідь';
$string['missingitemtypename'] = 'Відсутня назва';
$string['missingquestion'] = 'Це питання вже не існує';
$string['modulename'] = 'Тест';
$string['modulename_help'] = '<p>Цей модуль надає викладачу можливість розробляти тести, що складаються з різних типів питань: багатоваріантний вибір, вибір правильного варіанту, коротка відповідь тощо.</p>
<p>Можна створити тест з кількома спробами, питання можуть перемішуватися або вибиратися випадково з банку питань. За потреби, можна обмежити час на проходження тесту.</p>
<p>Кожна спроба оцінюється автоматично, за виключенням текстових відповідей введених власноруч, із записом результатів у журнал оцінок.</p>
<p>Можна вибрати, чи будуть підказки, відгук, правильні відповіді та коли вони будуть показані студентам.</p>
<p><b>Тести</b> можуть бути використані:</p>
<ul>
  <li>В іспитах курсу</li>
  <li>Як міні-тести для прочитаних завдань або наприкінці теми</li>
  <li>У підсумковому іспиті, використовуючи питання із проміжних іспитів</li>
  <li>Для отримання зворотного зв’язку з метою оцінки ефективності навчання</li>
  <li>Для самоконтролю</li>
</ul>';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Тести';
$string['moveselectedonpage'] = 'Перемістити обрані запитання на сторінку: {$a}';
$string['multichoice'] = 'Множинний вибір';
$string['multipleanswers'] = 'Виберіть хоча б одну відповідь';
$string['mustbesubmittedby'] = 'Ця спроба має бути відправлена до {$a}.';
$string['name'] = 'Назва';
$string['navigatenext'] = 'Наступна сторінка';
$string['navigateprevious'] = 'Попередня сторінка';
$string['navmethod'] = 'Метод переходу';
$string['navmethod_free'] = 'Вільний';
$string['navmethod_help'] = 'Якщо включено послідовний метод переходу, то студент повинен буде відповідати на питання по черзі і не зможе повертатися до попередніх або перескакувати до наступних';
$string['navmethod_seq'] = 'Послідовний';
$string['navnojswarning'] = 'Увага: ці посилання не збережуть ваші відповіді. Використовуйте кнопку "Далі" внизу сторінки.';
$string['neverallononepage'] = 'Ніколи, усі запитання на одній сторінці';
$string['newattemptfail'] = 'Помилка: Не можливо розпочати нову спробу тестування';
$string['newcategory'] = 'Нова категорія';
$string['newpage'] = 'Нова сторінка';
$string['newpage_help'] = 'Для великих тестів є сенс розбити всі питання на окремі сторінки з фіксованою кількістю питань на сторінку. Після додавання питань до тесту, розриви сторінок будуть додані автоматично у відповідності з цим налаштуванням. Однак в подальшому можна вручну вказати місця розриву сторінки.';
$string['newpageevery'] = 'Автоматично почати нову сторінку';
$string['newsectionheading'] = 'Новий заголовок';
$string['noanswers'] = 'Не було обрано жодної відповіді!';
$string['noattempts'] = 'Не було спроб пройти тест';
$string['noattemptsfound'] = 'Спроб не знайдено.';
$string['noattemptstoshow'] = 'Немає більше спроб для показу';
$string['nocategory'] = 'Неправильно або не вказано категорію';
$string['noclose'] = 'Немає дати закінчення';
$string['nocommentsyet'] = 'Коментарів ще немає.';
$string['noconnection'] = 'Немає зв`язку з веб-сервісом, який повинен обробляти це питання. Зв`яжіться з Вашим адміністратором.';
$string['nodataset'] = 'нічого - це не символ підстановки';
$string['nodatasubmitted'] = 'Дані не було відправлено';
$string['noessayquestionsfound'] = 'Не знайдено питань для ручного оцінювання';
$string['nogradewarning'] = 'Цей тест не було оцінено, отже ви не можете дати загальний відгук, що відрізняється від оцінки.';
$string['nomoreattempts'] = 'У Вас більше немає спроб';
$string['none'] = 'немає';
$string['noopen'] = 'Немає дати початку';
$string['nooverridedata'] = 'Вам потрібно перевстановити принаймні один з параметрів тесту.';
$string['nopossibledatasets'] = 'Немає доступних наборів даних';
$string['noquestionintext'] = 'Формулювання запитання не містить вкладених питань';
$string['noquestions'] = 'Жодного питання не було додано';
$string['noquestionsfound'] = 'Запитань не знайдено';
$string['noquestionsinquiz'] = 'У цьому тесті немає питань.';
$string['noquestionsnotinuse'] = 'Це випадкове питання не використовується, поки категорія порожня.';
$string['noquestionsonpage'] = 'Порожня сторінка';
$string['noresponse'] = 'Немає відповіді';
$string['noreview'] = 'Вам не дозволено огляд тесту';
$string['noreviewattempt'] = 'Вам не дозволено переглядати цю спробу.';
$string['noreviewshort'] = 'Немає допуску';
$string['noreviewuntil'] = 'Ви не можете побачити тест до {$a}';
$string['noreviewuntilshort'] = 'Доступні {$a}';
$string['noscript'] = 'Java-скрипт повинен бути дозволений у вашому браузері для продовження!';
$string['notavailabletostudents'] = 'Примітка: цей тест наразі недоступний для ваших студентів.';
$string['notenoughrandomquestions'] = 'Не вистачає питань у категорії {$a->category} для створення питання {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Була визначена недостатня кількість підпитань!<br />Повернутися до редагування питання?';
$string['notifyattemptsgradedtask'] = 'Надсилати оцінені сповіщення про спробу тесту';
$string['notimedependentitems'] = 'Елементи із заданим часом в даний час не підтримуються модулем \'тест\'. Ви можете, проте, вийти з положення, встановивши ліміт часу для всього тесту. Ви хочете вибрати інший елемент або використовувати поточний?';
$string['notyetgraded'] = 'Ще не оцінено';
$string['notyetviewed'] = 'Ще не переглядалося';
$string['notyourattempt'] = 'Це не ваша спроба!';
$string['noview'] = 'Зареєстрованому користувачу заборонено переглядати цей тест';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} зробив {$a->attemptnum} спроб(и)';
$string['numberabbr'] = '№';
$string['numerical'] = 'Числовий';
$string['numquestionsx'] = 'Питань: {$a}';
$string['oneminute'] = '1 хвилина';
$string['onlyteachersexport'] = 'Тільки викладачі можуть експортувати питання';
$string['onlyteachersimport'] = 'Тільки викладачі з правами редагування можуть експортувати питання';
$string['onthispage'] = 'На цій сторінці';
$string['open'] = 'Без відповіді';
$string['openafterclose'] = 'Не вдалося оновити тест. Ви вказали дату відкриття після дати закриття.';
$string['openclosedatesupdated'] = 'Час відкриття та закриття тесту оновлено';
$string['optional'] = 'Додатково';
$string['orderandpaging'] = 'Порядок і сторінки';
$string['orderandpaging_help'] = 'Числа 10, 20, 30, ... навпроти кожного запитання означають номер запитань. Числа змінюються з кроком 10, для того, щоб була можливість завантажити додаткові запитання. Розташувати запитання в іншому порядку, змінити нумерацію можна за допомогою кнопки "Змінити порядок запитань"
Для того, щоб додати розрив сторінки після певних запитань, поставте позначки у кнопках-прапорцях навпроти запитань, потім натисніть кнопку "Додати нові сторінки після обраних запитань".
Для того, щоб розташувати запитання на кількості сторінок, натисніть кнопку "" і оберіть бажане число запитань на сторінку.';
$string['orderingquiz'] = 'Порядок і сторінки';
$string['orderingquizx'] = 'Порядок і сторінки: {$a}';
$string['outcomesadvanced'] = 'Результати є розширеними налаштуваннями';
$string['outof'] = '{$a->grade} з {$a->maxgrade} можливих';
$string['outofpercent'] = '{$a->grade} з можливих {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Розширений відгук';
$string['overallfeedback_help'] = 'Розширений відгук - це текст, який показується після проходження спроби тестування. Якщо вказати межі оцінок (у відсотках або числом), то в залежності від отриманої оцінки можна побачити різний коментар.';
$string['overdue'] = 'Прострочено';
$string['overduehandling'] = 'Коли час спливає';
$string['overduehandling_desc'] = 'Типова подія, якщо студент не відправляє тест на перевірку, перш ніж час закінчиться.';
$string['overduehandling_help'] = 'Цей параметр визначає, що станеться, якщо студент не подає тест до закінчення часу. Якщо учень у цей час активно працює над тестом, таймер зворотного відліку завжди автоматично надсилатиме спробу для нього, але якщо він вийшов із системи, цей параметр керує тим, що відбувається.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'Відповіді повинні бути відправлені до завершення часу, інакше вони не зараховуються';
$string['overduehandlingautosubmit'] = 'Початі спроби будуть закінчуватися автоматично';
$string['overduehandlinggraceperiod'] = 'Надається пільговий період, коли готові відповіді можуть бути відправлені без можливості відповісти на інші питання';
$string['overduemustbesubmittedby'] = 'Ця спроба в даний час прострочена. Вона повинна вже були відправлена. Якщо Ви хочете, щоб цей тест було оцінено, Ви повинні відправити його до {$a}. Якщо ви не відправите його до вказаного часу, оцінки за цю спробу не будуть зараховані.';
$string['override'] = 'Перевизначення';
$string['overridedeletegroupsure'] = 'Ви впевнені, що хочете видалити перевизначення для групи {$a}?';
$string['overridedeleteusersure'] = 'Ви впевнені, що хочете видалити перевизначення для користувача {$a}?';
$string['overridegroup'] = 'Перевизначити для групи';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Перевизначення';
$string['overridesforquiz'] = 'Замінює налаштування: {$a}';
$string['overridesnoneforgroups'] = 'Для цього тесту не створено жодних змін налаштувань групи.';
$string['overridesnoneforusers'] = 'Для цього тесту не створено жодних змін налаштувань користувача.';
$string['overridessummary'] = 'Існують заміни налаштувань ({$a})';
$string['overridessummarygroup'] = 'Групи: {$a}';
$string['overridessummarythisgroup'] = 'Для цієї групи існують заміни налаштувань ({$a}).';
$string['overridessummaryuser'] = 'Користувачі: {$a}';
$string['overridessummaryyourgroups'] = 'Існують заміни налаштувань ({$a}) для ваших груп';
$string['overrideuser'] = 'Перевизначити  для користувача';
$string['overrideusereventname'] = '{$a->quiz} - Перевизначено';
$string['page-mod-quiz-attempt'] = 'Сторінка спроби тесту';
$string['page-mod-quiz-edit'] = 'Сторінка редагування тесту';
$string['page-mod-quiz-report'] = 'Будь-яка сторінка звіту тесту';
$string['page-mod-quiz-review'] = 'Сторінка перегляду спроби тесту';
$string['page-mod-quiz-summary'] = 'Сторінка резюме спроби тесту';
$string['page-mod-quiz-view'] = 'Інформаційна сторінка тесту';
$string['page-mod-quiz-x'] = 'Будь-яка сторінка модуля тесту';
$string['pageshort'] = 'Стор.';
$string['pagesize'] = 'Розмір сторінки';
$string['parent'] = 'Батьківський';
$string['parentcategory'] = 'Входить у категорію';
$string['parsingquestions'] = 'Розбір питань з файлу імпорту.';
$string['partiallycorrect'] = 'Частково правильно';
$string['penalty'] = 'Штраф';
$string['penaltyscheme'] = 'Нараховувати штрафи';
$string['penaltyscheme_help'] = 'Якщо включено, то штрафні бали будуть вираховуватися з кінцевої оцінки за питання при неправильних спробах. Розмір штрафу визначається в налаштуваннях питання. Ця можливість працює тільки при навчальному режимі тесту.';
$string['percentcorrect'] = 'Відсоток правильних';
$string['pleaseclose'] = 'Ваш запит був виконаний. Тепер Ви можете закрити це вікно';
$string['pluginadministration'] = 'Керування тестом';
$string['pluginname'] = 'Тест';
$string['popup'] = 'Показати тест у «безпечному» вікні';
$string['popupblockerwarning'] = 'Ця секція тесту є в захищеному виді, що означає відкриття тесту в окремому захищеному вікні. Будь ласка, зніміть блокування виринаючих вікон у вашому браузері. Дякуємо.';
$string['popupnotice'] = 'Студенти побачать цей тест у \'захищеному\' вікні';
$string['preprocesserror'] = 'Сталася помилка під час попередньої обробки!';
$string['preview'] = 'Перегляд';
$string['previewquestion'] = 'Перегляд питання';
$string['previewquiz'] = 'Попередній перегляд {$a}';
$string['previewquiznow'] = 'Переглянути тест зараз';
$string['previewquizstart'] = 'Попередній перегляд тесту';
$string['previous'] = 'Попередній стан';
$string['privacy:metadata:core_question'] = 'Дія тесту зберігає інформацію про використання запитання в підсистемі core_question.';
$string['privacy:metadata:quiz'] = 'У тесті використовуються звіти тесту.';
$string['privacy:metadata:quiz_attempts'] = 'Детальна інформація про кожну спробу цього тесту.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Номер спроби.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Поточна сторінка, на якій перебуває користувач.';
$string['privacy:metadata:quiz_attempts:gradednotificationsenttime'] = 'Час, коли користувач був повідомлений про завершення ручної оцінки його спроби';
$string['privacy:metadata:quiz_attempts:preview'] = 'Чи це попередній перегляд тесту.';
$string['privacy:metadata:quiz_attempts:state'] = 'Поточний стан спроби.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Сума оцінок за спробу.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Час, який перевіряли стан.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Час завершення спроби.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Час оновлення спроби.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Час, коли спроба була оновлена за допомогою автономного оновлення.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Час початку спроби.';
$string['privacy:metadata:quiz_grades'] = 'Детальна інформація про загальну оцінку за цей тест.';
$string['privacy:metadata:quiz_grades:grade'] = 'Загальна оцінка за цей тест.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Тест, що був оцінений.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Час зміни оцінки.';
$string['privacy:metadata:quiz_grades:userid'] = 'Користувач, який отримав оцінку.';
$string['privacy:metadata:quiz_overrides'] = 'Докладні відомості про перевизначення для цього тесту';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Тест з додатковою інформацією';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Новий час завершення тесту.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Нове обмеження часу для тесту.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Новий відкритий час для тесту.';
$string['privacy:metadata:quiz_overrides:userid'] = 'Користувач перевизначений';
$string['privacy:metadata:quizaccess'] = 'У тесті використовуються правила доступу до тесту.';
$string['publish'] = 'Опублікувати';
$string['publishedit'] = 'Ви повинні мати дозвіл у відкритому курсі на зміну або додавання питань в цю категорію';
$string['qbrief'] = 'Пит.{$a}';
$string['qname'] = 'назва';
$string['qti'] = 'IMS QTI-формат';
$string['qtypename'] = 'тип, назва';
$string['question'] = 'Питання';
$string['questionbank'] = 'з банку питань';
$string['questionbankmanagement'] = 'Керування банком питань';
$string['questionbehaviour'] = 'Поведінка питань';
$string['questioncats'] = 'Категорії питань';
$string['questiondeleted'] = 'Це питання видалено. Будь ласка, зверніться до свого вчителя.';
$string['questiondependencyadd'] = 'Немає обмежень на порядок спроби питання {$a->thisq} • Клацніть для зміни';
$string['questiondependencyfree'] = 'Немає обмежень на це питання';
$string['questiondependencyremove'] = 'Спроба питання {$a->thisq} не може бути раніше питання {$a->previousq}, на яке потрібно дати відповідь • Клацніть для зміни';
$string['questiondependsonprevious'] = 'Це питання не може бути розпочато доки попереднє питання не буде завершено.';
$string['questiondraftonly'] = 'Запитання {$a} має статус чернетки. Щоб використати його у вікторині, перейдіть до банку запитань і змініть статус на готовий.';
$string['questiondraftwillnotwork'] = 'Це питання знаходиться в статусі проекту. Щоб використати його у вікторині, перейдіть до банку запитань і змініть статус на готовий.';
$string['questioninuse'] = 'Питання \'{$a->questionname}\' в даний момент використовується в таких тестах: <br />{$a->quiznames}.<br /> Це питання буде вилучено тільки із списку категорій, але не з вказаних тестів.';
$string['questionmissing'] = 'Відсутнє питання для цієї сесії';
$string['questionname'] = 'Коротке означення питання';
$string['questionnonav'] = '<span class="accesshide">Питання </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Інформація </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Питання {$a} не було завантажене з бази даних';
$string['questionorder'] = 'Порядок питань';
$string['questionposition'] = 'Нова порядкова позиція для питання {$a}';
$string['questions'] = 'Питання';
$string['questionsetpreview'] = 'Попередній перегляд набору запитань';
$string['questionsinclhidden'] = 'Запитання (включаючи приховані)';
$string['questionsinthisquiz'] = 'Питання у цьому тесті';
$string['questionsmatchingfilter'] = 'Питання, які відповідають цьому фільтру: {$a}';
$string['questionsperpage'] = 'Питань на сторінку';
$string['questionsperpageselected'] = 'Кількість запитань на сторінку було визначено, отже нумерація сторінок на цей час є фіксованою. Як наслідок, регулювання нумерації сторінок недоступне. Ви можете змінити це у {$a}.';
$string['questionsperpagex'] = 'Питань на сторінку: {$a}';
$string['questiontext'] = 'Формулювання запитання';
$string['questiontextisempty'] = '[Питання не сформульовано]';
$string['questiontype'] = 'Тип питання {$a}';
$string['questiontypesetupoptions'] = 'Установка параметрів для типів питань';
$string['questionversion'] = 'v{$a}';
$string['questionversionlatest'] = 'v{$a} (останнє)';
$string['quiz:addinstance'] = 'Додавати новий тест';
$string['quiz:attempt'] = 'Проходити тест';
$string['quiz:deleteattempts'] = 'Видаляти спроби тесту';
$string['quiz:emailconfirmsubmission'] = 'Отримайте підтвердження ваших власних поданих тестів';
$string['quiz:emailnotifyattemptgraded'] = 'Отримайте сповіщення, коли ваша спроба буде оцінена';
$string['quiz:emailnotifysubmission'] = 'Отримуйте сповіщення про те, що ваші студенти подали тести';
$string['quiz:emailwarnoverdue'] = 'Отримайте попередження, коли ваша спроба тесту запізнюється';
$string['quiz:grade'] = 'Оцінювати тести вручну';
$string['quiz:ignoretimelimits'] = 'Ігноруйте ліміт часу тесту';
$string['quiz:manage'] = 'Керувати тестами';
$string['quiz:manageoverrides'] = 'Керуйте змінами налаштувань тесту';
$string['quiz:preview'] = 'Переглядати тести';
$string['quiz:regrade'] = 'Переоцінювати спроби тесту';
$string['quiz:reopenattempts'] = 'Повторно відкрити жодних спроб тестування';
$string['quiz:reviewmyattempts'] = 'Переглядати власні спроби';
$string['quiz:view'] = 'Переглядати опис тесту';
$string['quiz:viewoverrides'] = 'Перегляд налаштувань тесту';
$string['quiz:viewreports'] = 'Переглядати звіт тесту';
$string['quizavailable'] = 'Останній термін здачі - {$a}';
$string['quizclose'] = 'Завершити тестування';
$string['quizclosed'] = 'Тестування закінчене {$a}';
$string['quizcloses'] = 'Тест закривається у';
$string['quizcloseson'] = 'Тест буде закритий {$a}.';
$string['quizeventcloses'] = '{$a} закрито';
$string['quizeventopens'] = '{$a} доступно';
$string['quizisclosed'] = 'Тест закритий';
$string['quizisclosedwillopen'] = 'Тест закритий (відкривається {$a})';
$string['quizisopen'] = 'Тест відкритий';
$string['quizisopenwillclose'] = 'Тест відкритий (закриває {$a})';
$string['quiznavigation'] = 'Перехід по тесту';
$string['quizopen'] = 'Почати тестування';
$string['quizopenclose'] = 'Дати відкриття і закриття';
$string['quizopenclose_help'] = 'Студенти можуть починати спроби тестування тільки після дати відкриття тесту, а закінчити повинні до дати закриття.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopened'] = 'Тест відкрито.';
$string['quizopenedon'] = 'Цей тест відкритий з {$a}';
$string['quizopens'] = 'Тест відкривається з';
$string['quizopenwillclose'] = 'Тест відкритий, буде закритий {$a}';
$string['quizordernotrandom'] = 'Порядок тесту не перемішується';
$string['quizorderrandom'] = '* Порядок тесту перемішується';
$string['quizreport'] = 'Звіт про тест';
$string['quizsettings'] = 'Налаштування тесту';
$string['quiztimer'] = 'Таймер тесту';
$string['quizwillopen'] = 'Тест буде відкритий {$a}';
$string['random'] = 'Випадкове питання';
$string['randomcreate'] = 'Створити випадкові запитання';
$string['randomediting'] = 'Редагування випадкового запитання';
$string['randomfromcategory'] = 'Випадкове питання з категорії:';
$string['randomfromexistingcategory'] = 'Випадкове питання з існуючої категорії';
$string['randomfromunavailabletag'] = '{$a} (недоступно)';
$string['randomnosubcat'] = 'Питання лише з цієї категорії, а не з її підкатегорій.';
$string['randomnumber'] = 'Кількість випадкових питань';
$string['randomquestion'] = 'Випадкове питання';
$string['randomquestion_help'] = 'Випадкове запитання — це спосіб вставки випадково вибраного запитання з певної категорії або за вказаним тегом у дію.';
$string['randomquestiontags'] = 'Теги';
$string['randomquestiontags_help'] = 'Ви можете додатково обмежити критерії вибору, вказавши тут кілька тегів питань.

«Випадкові» питання будуть обрані з питань, що мають всі ці теги.';
$string['randomquestionusinganewcategory'] = 'Випадкове питання, використовуючи нову категорію';
$string['randomwithsubcat'] = 'Питання з цієї категорії і її підкатегорій';
$string['readytosend'] = 'Ви збираєтеся відправити весь свій тест на оцінювання. Ви впевнені, що готові продовжити?';
$string['reattemptquiz'] = 'Зробити наступну спробу';
$string['recentlyaddedquestion'] = 'Нещодавно додане питання!';
$string['recurse'] = 'Включати також питання з підкатегорій';
$string['redoesofthisquestion'] = 'Інші спроби питань тут: {$a}';
$string['redoquestion'] = 'Спробуйте інше запитання, подібне до цього';
$string['regrade'] = 'Переоцінити всі спроби';
$string['regradecomplete'] = 'Всі спроби були заново оцінені';
$string['regradecount'] = '{$a->changed} з {$a->attempt} оцінки були змінені';
$string['regradedisplayexplanation'] = 'Спроби, які змінюються після переоцінки, відображаються як гіперпосилання на вікно проглядання питання';
$string['regradenotallowed'] = 'Ви не маєте права переоцінювати цей тест';
$string['regradingquestion'] = 'Переоцінка \'{$a}\'.';
$string['regradingquiz'] = 'Переоцінка тесту \'{$a}\'';
$string['remove'] = 'Видалити';
$string['removeallgroupoverrides'] = 'Видалити всі перевизначення для групи';
$string['removeallquizattempts'] = 'Видалити всі спроби тестування';
$string['removealluseroverrides'] = 'Видалити всі перевизначення для користувача';
$string['removeemptypage'] = 'Видалити порожню сторінку';
$string['removepagebreak'] = 'Видалити розрив сторінки';
$string['removeselected'] = 'Видалити вибране';
$string['rename'] = 'Перейменувати';
$string['renderingserverconnectfailed'] = 'Сервер {$a} був не в змозі обробити запит RQP. Перевірте, що URL правильний.';
$string['reopenattempt'] = 'Знову відкрити';
$string['reopenattemptareyousuremessage'] = 'Це повторно відкриє спробу {$a->attemptnumber} користувача {$a->attemptuser}.';
$string['reopenattemptareyousuretitle'] = 'Повторна спроба?';
$string['reopenattemptwrongstate'] = 'Спроба {$a->attemptid} знаходиться в неправильному стані ({$a->state}), щоб бути повторно відкрита.';
$string['reopenedattemptwillbeinprogress'] = 'Спроба залишиться відкритою і може бути продовжена.';
$string['reopenedattemptwillbeinprogressuntil'] = 'Спроба залишиться відкритою, і її можна буде продовжувати до завершення тесту {$a}.';
$string['reopenedattemptwillbesubmitted'] = 'Спроба буде негайно подана на оцінювання.';
$string['reorderquestions'] = 'Перевпорядкувати питання';
$string['reordertool'] = 'Показати інструмент перевпорядкування';
$string['repaginate'] = 'Розподілити по {$a} питань на сторінку';
$string['repaginatecommand'] = 'Розподілити';
$string['repaginatenow'] = 'Розподілити зараз';
$string['replace'] = 'Замінити';
$string['replacementoptions'] = 'Параметри заміни';
$string['report'] = 'Звіти';
$string['reportanalysis'] = 'Аналіз тесту';
$string['reportattemptsfrom'] = 'Спроби від';
$string['reportattemptsthatare'] = 'Спроби, які';
$string['reportdisplayoptions'] = 'Параметри показу';
$string['reportfullstat'] = 'Детальна статистика';
$string['reportmulti_percent'] = 'Багатовідсоткові';
$string['reportmulti_q_x_student'] = 'Множинні вибори студентів';
$string['reportmulti_resp'] = 'Індивідуальні відгуки';
$string['reportmustselectstate'] = 'Ви повинні вибрати хоча б один стан';
$string['reportnotfound'] = 'Невідомий звіт ({$a})';
$string['reportoverview'] = 'Короткий огляд';
$string['reportregrade'] = 'Переоцінити спробу';
$string['reportresponses'] = 'Докладні відповіді';
$string['reports'] = 'Звіти';
$string['reportshowonly'] = 'Показувати тільки спроби';
$string['reportshowonlyfinished'] = 'Показати не більше однієї закінченої спроби на користувача  ({$a})';
$string['reportsimplestat'] = 'Спрощена статистика';
$string['reportusersall'] = 'всіх користувачів, які мають спроби тесту';
$string['reportuserswith'] = 'зарахованих користувачів, які мають спроби тесту';
$string['reportuserswithorwithout'] = 'зарахованих користувачів, які мають або не мають спроби тесту';
$string['reportuserswithout'] = 'зарахованих користувачів, які не мають спроб тесту';
$string['reportwhattoinclude'] = 'Що включати у звіт';
$string['requirepassword'] = 'Необхідний пароль';
$string['requirepassword_help'] = 'Якщо визначено пароль, то студент повине буде його ввести для початку проходження спроби тесту.';
$string['requiresubnet'] = 'Необхідна мережева адреса';
$string['requiresubnet_help'] = 'Доступ до тесту може бути обмежено певною підмережею в локальній мережі а бо Інтернеті. Вкажіть через кому список частин або повні ІР-адреси. Це може бути корисно для гарантування того, що тільки люди з визначеними адресами будуть здавати тест.';
$string['response'] = 'Відповідь';
$string['responses'] = 'Відповіді';
$string['results'] = 'Результати';
$string['returnattempt'] = 'Повернутися до спроби';
$string['reuseifpossible'] = 'повторне використання попередньо видалених';
$string['reverttodefaults'] = 'Повернутися до типового';
$string['review'] = 'Огляд';
$string['reviewafter'] = 'Дозволити огляд після того, як тест буде закритий';
$string['reviewalways'] = 'Дозволити огляд у будь-який час';
$string['reviewattempt'] = 'Перегляд спроби';
$string['reviewbefore'] = 'Дозволити огляд поки тест відкритий';
$string['reviewclosed'] = 'Після закриття тесту';
$string['reviewduring'] = 'Впродовж спроби';
$string['reviewimmediately'] = 'Безпосередньо після спроби';
$string['reviewnever'] = 'Заборонити огляд';
$string['reviewofquestion'] = 'Переглянути відповідь на питання {$a->question} в {$a->quiz} від {$a->user}';
$string['reviewopen'] = 'Пізніше, поки тест ще відкритий';
$string['reviewoptions'] = 'Студенти можуть переглядати';
$string['reviewoptionsheading'] = 'Параметри перегляду';
$string['reviewoptionsheading_help'] = 'Ці параметри визначають, яку інформацію можуть бачити учні, коли переглядають спробу тесту або переглядають звіти тестуівань. Налаштування

**Під час спроби** актуальні лише для деяких видів поведінки, як-от "інтерактивний із кількома спробами", які можуть відображати зворотний зв\'язок під час спроби.

**Одразу після спроби** налаштування застосовуються протягом перших двох хвилин після натискання кнопки «Надіслати все та завершити».

**Пізніше, поки тест ще відкритий** налаштування застосовуються після цього й до дати закриття тесту.

**Після закриття тесту** налаштування застосовуються після закінчення дати закриття тесту. Якщо тест не має дати завершення, цей стан ніколи не досягається.';
$string['reviewoverallfeedback'] = 'Загальний відгук';
$string['reviewoverallfeedback_help'] = 'Відгук надається в кінці спроби, в залежності від загального результату спроби';
$string['reviewresponse'] = 'Огляд відповіді';
$string['reviewresponsetoq'] = 'Огляд відповіді (питання {$a})';
$string['reviewthisattempt'] = 'Переглянути ваші відповіді в цій спробі';
$string['rqp'] = 'Віддалене питання';
$string['rqps'] = 'Віддалені питання';
$string['sameasoverall'] = 'Як в загальному оцінюванні';
$string['save'] = 'Зберегти';
$string['saveandedit'] = 'Зберегти зміни та редагувати питання';
$string['saveattemptfailed'] = 'Помилка збереження поточної спроби тесту.';
$string['savedfromdeletedcourse'] = 'Збережено з видаленого курсу \'{$a}\'';
$string['savegrades'] = 'Зберегти оцінки';
$string['savemyanswers'] = 'Зберегти мої відповіді';
$string['savenosubmit'] = 'Зберегти, але не відправляти';
$string['saveoverrideandstay'] = 'Зберегти та ввести інше перевизначення';
$string['savequiz'] = 'Зберегти тест';
$string['saving'] = 'Збереження';
$string['savingnewgradeforquestion'] = 'Збереження нової оцінки для питання з кодом {$a}.';
$string['savingnewmaximumgrade'] = 'Збереження нової максимальної оцінки';
$string['score'] = 'Набрано балів';
$string['scores'] = 'Бали';
$string['search:activity'] = 'Тест - інформація про діяльність';
$string['sectionheadingedit'] = 'Редагувати заголовок \'{$a}\'';
$string['sectionheadingremove'] = 'Вилучити заголовок \'{$a}\'';
$string['sectionnoname'] = 'Розділ без назви';
$string['seequestions'] = '(див. питання)';
$string['select'] = 'Вибір';
$string['selectall'] = 'Вибрати всі';
$string['selectattempt'] = 'Виберіть спробу';
$string['selectcategory'] = 'Вибрати категорію';
$string['selectedattempts'] = 'Вибрані спроби...';
$string['selectmultipleitems'] = 'Виберіть кілька елементів';
$string['selectmultipletoolbar'] = 'Виберіть декілька панелей інструментів';
$string['selectnone'] = 'Зняти виділення';
$string['selectquestionslot'] = 'Виберіть запитання {$a}';
$string['selectquestiontype'] = '--Виберіть тип питання--';
$string['serveradded'] = 'Сервер додано';
$string['serveridentifier'] = 'Ідентифікатор';
$string['serverinfo'] = 'Інформація про сервер';
$string['servers'] = 'Сервери';
$string['serverurl'] = 'URL сервера';
$string['shortanswer'] = 'Коротка відповідь';
$string['show'] = 'Показати';
$string['showall'] = 'Показати всі питання на одній сторінці';
$string['showblocks'] = 'Показувати блоки під час спроби проходження тесту';
$string['showblocks_help'] = 'Якщо встановлено у "так", то звичайні блоки будуть показані під час тест спроби';
$string['showbreaks'] = 'Показувати роздільники сторінок';
$string['showcategorycontents'] = 'Показати вміст категорії {$a->arrow}';
$string['showcorrectanswer'] = 'Показувати правильні відповіді у відгуку?';
$string['showdetailedmarks'] = 'Показувати оцінку детально';
$string['showeachpage'] = 'Показати одну сторінку за раз';
$string['showfeedback'] = 'Після відповіді показувати відгук?';
$string['showinsecurepopup'] = 'Використовувати для спроби "захищене" виринаюче вікно';
$string['showlargeimage'] = 'Велика картинка';
$string['shownoattempts'] = 'Показати студентів, що не зробили жодної спроби';
$string['shownoattemptsonly'] = 'Показати тільки студентів, що не зробили жодної спроби';
$string['shownoimage'] = 'Без картинки';
$string['showreport'] = 'Показати звіт';
$string['showsmallimage'] = 'Маленька картинка';
$string['showteacherattempts'] = 'Показати спроби викладача';
$string['showuserpicture'] = 'Показати фото студентів';
$string['showuserpicture_help'] = 'Якщо ввімкнено, ім’я та зображення учня відображатимуться на екрані під час спроби та на екрані перегляду, що полегшує перевірку того, чи студент увійшов під своїм ім’ям під час контрольованого (контрольованого) іспиту.';
$string['shuffle'] = 'Перемішати';
$string['shuffleanswers'] = 'Випадковий порядок відповідей';
$string['shuffledrandomly'] = 'У випадковому порядку';
$string['shufflequestions'] = 'Перемішувати';
$string['shufflequestions_help'] = 'Якщо ввімкнено, щоразу, коли виконується тест, порядок запитань у цьому розділі буде перемішуватися в іншому випадковому порядку.

Це може ускладнити учням ділитися відповідями, але це також ускладнює обговорення певного питання з учителем.';
$string['shufflewithin'] = 'Випадковий порядок відповідей';
$string['shufflewithin_help'] = 'Якщо включено, то відповіді в питаннях (де це можливо) будуть перемішуватися кожного разу, коли студент починає нову спробу тесу, за умови, що ця ж опція включена в налаштуваннях питання. Цей параметр застосовується тільки в питаннях, які мають кілька варіантів відповідей, таких як множинний вибір або питання на відповідність.';
$string['singleanswer'] = 'Виберіть одну правильну відповідь';
$string['sortage'] = 'Сортувати за часом створення';
$string['sortalpha'] = 'Сортувати за абеткою';
$string['sortquestionsbyx'] = 'Сортування питання за: {$a}';
$string['sortsubmit'] = 'Сортувати питання';
$string['sorttypealpha'] = 'Сортувати за типом, назвою';
$string['specificapathnotonquestion'] = 'Вказаного у питанні файлу немає за вказаним шляхом';
$string['specificquestionnotonquiz'] = 'У вказаному тесті немає зазначеного питання';
$string['startagain'] = 'Почати знову';
$string['startattempt'] = 'Почати спробу';
$string['startedon'] = 'Розпочато';
$string['startnewpreview'] = 'Розпочати нову спробу';
$string['stateabandoned'] = 'Не здано';
$string['statefinished'] = 'Завершено';
$string['statefinisheddetails'] = 'Здано {$a}';
$string['stateinprogress'] = 'В процесі';
$string['statenotloaded'] = 'Стан питання {$a} не вдалося завантажити з бази даних';
$string['stateoverdue'] = 'Прострочено';
$string['stateoverduedetails'] = 'Повинно бути надіслано {$a}';
$string['status'] = 'Статус';
$string['stoponerror'] = 'Зупинятися при помилці';
$string['submission_confirmation'] = 'Надіслати всі свої відповіді та закінчити?';
$string['submission_confirmation_unanswered'] = 'Запитання без відповіді: {$a}';
$string['submitallandfinish'] = 'Відправити все та завершити';
$string['subneterror'] = 'Вибачте, цей тест доступний для проходження тільки на певних комп`ютерах. На Вашому комп`ютері тест пройти не можна.';
$string['subnetnotice'] = 'Цей тест відкритий для доступу тільки з певних сегментів мережі. Ваш комп\'ютер не знаходиться в дозволеній частині. Як викладачу Вам дозволено тільки перегляд.';
$string['subplugintype_quiz'] = 'Звіт';
$string['subplugintype_quiz_plural'] = 'Звіти';
$string['subplugintype_quizaccess'] = 'Правило доступу';
$string['subplugintype_quizaccess_plural'] = 'Правила доступу';
$string['substitutedby'] = 'буде заміщений';
$string['summaryofattempt'] = 'Результати спроби';
$string['summaryofattempts'] = 'Результати ваших попередніх спроб';
$string['temporaryblocked'] = 'Вам тимчасово не дозволяється проходження нової спроби.<br /> Ви отримаєту цю можливість в:';
$string['theattempt'] = 'Спроба';
$string['theattempt_help'] = 'Як студент може переглядати спробу загалом';
$string['time'] = 'Час';
$string['timecompleted'] = 'Завершено';
$string['timedelay'] = 'Вам не дозволено проходити цей тест, оскільки не пройшов відведений час від проходження попереднього тесту';
$string['timeleft'] = 'Залишилося часу';
$string['timelimit'] = 'Обмеження в часі';
$string['timelimit_help'] = 'Якщо увікнено, то ліміт часу, вказаний на початковій сторінці тесту і таймер зворотного відліку відображається в блоці навігації тесту.';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'На жаль, час закінчився!';
$string['timestr'] = '%d/%m/%y у %H:%M:%S';
$string['timesup'] = 'Час вичерпано!';
$string['timing'] = 'Вибір часу';
$string['tofile'] = 'до файлу';
$string['tolerance'] = 'Похибка';
$string['toomanyrandom'] = 'Необхідне число випадкових питань, більше, ніж містить категорія ({$a})';
$string['top'] = 'Головна';
$string['totalmarksx'] = 'Всього балів: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Всього {$a}  питань у категорії.';
$string['true'] = 'Правильно';
$string['truefalse'] = 'Правильно/Неправильно';
$string['type'] = 'Тип';
$string['unfinished'] = 'відкритий';
$string['ungraded'] = 'Неоцінено';
$string['unit'] = 'Одиниця виміру';
$string['unknowntype'] = 'Тип запитання не підтримується у рядку {$a}. Запитання буде проігнорованим';
$string['updateoverdueattemptstask'] = 'Оновлення прострочених спроб тесту';
$string['updatequizslotswithrandomxofy'] = 'Оновлення проміжків тесту з "випадковими" даними запитань ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Оновити налаштування тесту';
$string['updatingatttemptgrades'] = 'Оновлення оцінок спроби.';
$string['updatingfinalgrades'] = 'Оновлення підсумкових оцінок.';
$string['updatingthegradebook'] = 'Оновлення журналу оцінок.';
$string['upgradesure'] = '<div>Для модуля "Тест" було підготовлено безліч різних змін, які в даній версії ґрунтовно не протестовані. Перед тим, як продовжити, наполегливо рекомендується зробити резервну копію вашої бази даних.</div>';
$string['upgradingquizattempts'] = 'Оновлення спроб тесту: тест {$a->done}/{$a->outof} (Код тесту {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Оновлення дуже старих спроб тесту: {$a->done}/{$a->outof}';
$string['url'] = 'URL (веб-посилання)';
$string['usedcategorymoved'] = 'Ця категорія була переміщена на рівень сайту, оскільки після видалення курсу її питання використовуються іншими тестами сервера.';
$string['useroverrides'] = 'Перевизначення для користувача';
$string['useroverridesdeleted'] = 'Вилучено перевизначення для користувача';
$string['usersnone'] = 'Студенти не мають доступу до цього тесту';
$string['validate'] = 'Підтвердити';
$string['viewallanswers'] = 'Подивитися закінчені спроби ({$a})';
$string['viewallreports'] = 'Подивитися звіт по {$a} спробам';
$string['viewed'] = 'Переглянуто';
$string['warningmissingtype'] = '<b>Це запитання відноситься до типу запитання, який ще не встановлено в системі. <br>Будь ласка, повідомте Вашого адміністратора Moodle.</b>';
$string['wheregrade'] = 'Де моя оцінка?';
$string['wildcard'] = 'Символ підстановки';
$string['windowclosing'] = 'Це вікно незабаром буде закрите.';
$string['withsummary'] = 'з сумарною статистикою';
$string['wronguse'] = 'Ви не можете використовувати цю сторінку таким чином';
$string['xhtml'] = 'Формат - XHTML';
$string['youneedtoenrol'] = 'Вам потрібно записатися на цей курс, щоб мати можливість проходити тест';
$string['yourfinalgradeis'] = 'Ваша підсумкова оцінка за цей тест: {$a}';
