<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'ai', language 'pt', version '5.1'.
 *
 * @package     ai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptai'] = 'Aceitar e continuar';
$string['action'] = 'Ação';
$string['action_explain_text'] = 'Explicar texto';
$string['action_explain_text_desc'] = 'Explica o conteúdo do texto numa página da disciplina.';
$string['action_explain_text_help'] = 'Fornece uma explicação que expande as ideias principais, simplifica conceitos complexos e acrescenta contexto para tornar o texto mais fácil de compreender.';
$string['action_explain_text_instruction'] = 'Receberá uma entrada de texto do utilizador. A sua tarefa é explicar o texto fornecido. Siga estas orientações:
1. Elabore: expanda as ideias e conceitos principais, garantindo que a explicação acrescenta uma profundidade significativa e evite repetir o texto literalmente.
2. Simplifique: divida termos ou ideias complexas em componentes mais simples, tornando-os fáceis de compreender para um público alargado, incluindo os alunos.
3. Forneça contexto: explique porque é que algo acontece, como funciona ou qual o seu propósito. Inclua exemplos ou analogias relevantes para melhorar a compreensão, quando apropriado.
4. Organize logicamente: estruture a sua explicação para que flua naturalmente, começando por ideias fundamentais antes de passar para detalhes mais subtis.

Instruções importantes:
1. Devolva o resumo apenas em texto simples.
2. Não inclua qualquer formatação markdown, saudações ou banalidades.
3. Concentre-se na clareza, concisão e acessibilidade.

Certifique-se de que a explicação é fácil de ler e transmite eficazmente os pontos principais do texto original.';
$string['action_generate_image'] = 'Gerar imagem';
$string['action_generate_image_desc'] = 'Gerar uma imagem com base numa prompt de texto.';
$string['action_generate_image_help'] = 'Cria uma imagem com base numa prompt.';
$string['action_generate_text'] = 'Gerar texto';
$string['action_generate_text_desc'] = 'Gerar um texto com base numa prompt de texto.';
$string['action_generate_text_help'] = 'Cria um texto com base numa prompt.';
$string['action_generate_text_instruction'] = 'Receberá uma entrada de texto do utilizador. A sua tarefa é gerar texto com base no pedido do utilizador. Siga estas instruções importantes:
 1. Devolver o resumo apenas em texto simples.
 2. Não incluir qualquer formatação de marcadores, saudações ou banalidades.';
$string['action_summarise_text'] = 'Resumir texto';
$string['action_summarise_text_desc'] = 'Resume o texto do conteúdo de uma página de uma disciplina.';
$string['action_summarise_text_help'] = 'Cria um breve resumo do conteúdo de uma página.';
$string['action_summarise_text_instruction'] = 'Receberá uma entrada de texto do utilizador. A sua tarefa é resumir o texto fornecido. Siga estas orientações:
 1. Condensar: resuma textos longos em pontos-chave.
 2. Simplificar: torne a informação complexa mais fácil de compreender, especialmente para os alunos.

Instruções importantes:
 1. Devolver o resumo apenas em texto simples.
 2. Não incluir qualquer formatação de marcadores, saudações ou banalidades.
 3. Concentrar-se na clareza, concisão e acessibilidade.

Certifique-se de que o resumo é fácil de ler e transmite eficazmente os pontos principais do texto original.';
$string['action_translate_text'] = 'Traduzir texto';
$string['action_translate_text_desc'] = 'Traduza o texto fornecido de um idioma para outro.';
$string['actionsettingprovider'] = 'Configurações da ação {$a}';
$string['actionsettingprovider_desc'] = 'Estas configurações controlam a forma como {$a->providername} executa a ação {$a->actionname}.';
$string['actionsettings'] = 'Configurações da ação';
$string['actionsettings_desc'] = 'Estas configurações controlam as ações de IA para esta instância do fornecedor.';
$string['ai'] = 'IA';
$string['aiactionregister'] = 'Registo de ação de IA';
$string['aiactionshdr'] = 'Selecione as funcionalidades de IA para esta atividade:';
$string['aiplacements'] = 'Inserções de IA';
$string['aipolicyacceptance'] = 'Aceitação da política de IA';
$string['aipolicyregister'] = 'Registo da política de IA';
$string['aiproviders'] = 'Fornecedores de IA';
$string['aireports'] = 'Relatórios da IA';
$string['aitools'] = 'Ferramentas de IA';
$string['aitoolsincourseactivitydesc'] = 'Se definido como Sim, pode especificar quais as funcionalidades de IA que estarão disponíveis.';
$string['aitoolsincoursedesc'] = 'Se definido como Sim, as ferramentas de IA estarão disponíveis para as atividades desta disciplina. As ferramentas de IA podem ser definidas nas configurações de cada atividade.';
$string['aitoolsnotenabled'] = 'Para especificar quais as funcionalidades de IA disponíveis nesta atividade, aceda às configurações da disciplina e ative as Ferramentas de IA.';
$string['aiusage'] = 'Utilização de IA';
$string['aiusagepolicy'] = 'Política de utilização de IA';
$string['availableplacements'] = 'Escolha onde as ações de IA estão disponíveis';
$string['availableplacements_desc'] = 'As inserções definem como e onde as ações de IA podem ser utilizadas no seu site. Pode escolher quais as ações disponíveis em cada inserção através das configurações.';
$string['availableproviders'] = 'Gerir os fornecedores de IA ligados ao seu LMS';
$string['availableproviders_desc'] = 'Os fornecedores de IA adicionam funcionalidades de IA ao seu site através de "ações", como o resumo de texto ou a geração de imagens. <br/>
Pode gerir as ações de cada fornecedor nas respetivas configurações.';
$string['btninstancecreate'] = 'Criar instância';
$string['btninstanceupdate'] = 'Atualizar instância';
$string['completiontokens'] = 'Tokens de conclusão';
$string['completiontokens_help'] = 'Os tokens de conclusão são unidades de texto geradas pelo modelo de IA como resposta à sua introdução. Respostas mais longas utilizam mais tokens, o que normalmente aumenta o custo.';
$string['configureprovider'] = 'Configurar instância do fornecedor';
$string['contentwatermark'] = 'Gerado por IA';
$string['createnewprovider'] = 'Criar uma nova instância de fornecedor';
$string['dateaccepted'] = 'Data da aceitação';
$string['declineaipolicy'] = 'Declinar';
$string['enableaitoolsincourse'] = 'Permitir ferramentas de IA para esta disciplina';
$string['enableaitoolsincourseactivity'] = 'Permitir ferramentas de IA nesta atividade';
$string['enableglobalratelimit'] = 'Definir limite da taxa para todo o site';
$string['enableglobalratelimit_help'] = 'Limita o número de pedidos que o fornecedor de IA pode receber de todo o site a cada hora.';
$string['enableuserratelimit'] = 'Definir limite da taxa do utilizador';
$string['enableuserratelimit_help'] = 'Limita o número de pedidos que cada utilizador pode fazer ao fornecedor da IA a cada hora.';
$string['error:400'] = 'Pedido incorreto';
$string['error:401'] = 'Não autorizado';
$string['error:401:upstreamless'] = 'Não foi possível ligar ao serviço de IA. Tente novamente mais tarde.';
$string['error:404'] = 'Não encontrado';
$string['error:404:upstreamless'] = 'O serviço de IA está temporariamente indisponível. Tente novamente mais tarde.';
$string['error:429'] = 'Muitos pedidos';
$string['error:429:internalsitewide'] = 'O serviço IA atingiu o número máximo de pedidos à IA em todo o site por hora. Tente novamente mais tarde.';
$string['error:429:internaluser'] = 'Atingiu o número máximo de pedidos à IA que pode fazer em uma hora. Tente novamente mais tarde.';
$string['error:429:upstreamless'] = 'Este serviço de IA atingiu o seu limite de pedidos. Tente novamente mais tarde.';
$string['error:500'] = 'Erro interno do servidor';
$string['error:503'] = 'Serviço indisponível';
$string['error:actionnotfound'] = 'A ação \'{$a}\' não é suportada.';
$string['error:defaultmessage'] = 'Ocorreu um erro ao processar o seu pedido. Tente novamente mais tarde.';
$string['error:defaultmessageshort'] = 'Tente novamente mais tarde.';
$string['error:defaultname'] = 'Ocorreu um erro';
$string['error:noproviders'] = 'Sem fornecedor disponível para processar a ação.';
$string['error:providernotfound'] = 'A instância de fornecedor de IA não foi encontrada.';
$string['error:unknown'] = 'Erro desconhecido';
$string['globalratelimit'] = 'Número máximo de pedidos em todo o site';
$string['globalratelimit_help'] = 'O número de pedidos permitidos em todo o site por hora.';
$string['manageaiplacements'] = 'Gerir inserções de IA';
$string['manageaiproviders'] = 'Gerir fornecedores de IA';
$string['noproviders'] = 'Esta ação não está disponível. Nenhum <a href="{$a}">fornecedor de IA</a> configurado para esta ação.';
$string['off'] = 'Off';
$string['on'] = 'On';
$string['placement'] = 'Inserção';
$string['placementactionsettings'] = 'Ações';
$string['placementactionsettings_desc'] = 'As ações de IA disponíveis para esta inserção.';
$string['placementsettings'] = 'Configurações específicas da inserção';
$string['placementsettings_desc'] = 'Estas configurações controlam a forma como este posicionamento de IA liga-se ao serviço de IA e às operações relacionadas.';
$string['privacy:metadata:ai_action_explain_text'] = 'Uma tabela que armazena os pedidos de explicação do texto feitos pelos utilizadores.';
$string['privacy:metadata:ai_action_explain_text:completiontoken'] = 'Os tokens de conclusão utilizados para explicar o texto.';
$string['privacy:metadata:ai_action_explain_text:fingerprint'] = 'O hash exclusivo que representa o estado/versão do modelo e do conteúdo.';
$string['privacy:metadata:ai_action_explain_text:generatedcontent'] = 'O texto real gerado pelo modelo de IA com base na prompt.';
$string['privacy:metadata:ai_action_explain_text:prompt'] = 'A prompt para o pedido de explicação do texto.';
$string['privacy:metadata:ai_action_explain_text:prompttokens'] = 'Os tokens de prompt utilizados para explicar o texto.';
$string['privacy:metadata:ai_action_explain_text:responseid'] = 'O ID da resposta.';
$string['privacy:metadata:ai_action_generate_image'] = 'Uma tabela que armazena os pedidos de geração de imagem efetuados pelos utilizadores.';
$string['privacy:metadata:ai_action_generate_image:aspectratio'] = 'A proporção das imagens geradas.';
$string['privacy:metadata:ai_action_generate_image:numberimages'] = 'O número de imagens geradas.';
$string['privacy:metadata:ai_action_generate_image:prompt'] = 'A prompt para o pedido de geração de imagem.';
$string['privacy:metadata:ai_action_generate_image:quality'] = 'A qualidade das imagens geradas.';
$string['privacy:metadata:ai_action_generate_image:revisedprompt'] = 'O prompt revisto das imagens geradas.';
$string['privacy:metadata:ai_action_generate_image:sourceurl'] = 'O URL da origem das imagens geradas.';
$string['privacy:metadata:ai_action_generate_image:style'] = 'O estilo das imagens geradas.';
$string['privacy:metadata:ai_action_generate_text'] = 'Uma tabela que armazena os pedidos de geração de texto feitos pelos utilizadores.';
$string['privacy:metadata:ai_action_generate_text:completiontoken'] = 'Os tokens de conclusão utilizados para gerar o texto.';
$string['privacy:metadata:ai_action_generate_text:fingerprint'] = 'O hash exclusivo que representa o estado/versão do modelo e do conteúdo.';
$string['privacy:metadata:ai_action_generate_text:generatedcontent'] = 'O texto real gerado pelo modelo de IA com base na prompt.';
$string['privacy:metadata:ai_action_generate_text:prompt'] = 'O prompt para o pedido de geração de texto.';
$string['privacy:metadata:ai_action_generate_text:prompttokens'] = 'Os tokens de prompt utilizados para gerar o texto.';
$string['privacy:metadata:ai_action_generate_text:responseid'] = 'O ID da resposta.';
$string['privacy:metadata:ai_action_register'] = 'Uma tabela que armazena os pedidos de ação feitos pelos utilizadores.';
$string['privacy:metadata:ai_action_register:actionid'] = 'O ID do pedido da ação.';
$string['privacy:metadata:ai_action_register:actionname'] = 'O nome da ação do pedido.';
$string['privacy:metadata:ai_action_register:model'] = 'O modelo utilizado para gerar a resposta.';
$string['privacy:metadata:ai_action_register:provider'] = 'O nome do fornecedor que tratou o pedido.';
$string['privacy:metadata:ai_action_register:success'] = 'O estado do pedido da ação.';
$string['privacy:metadata:ai_action_register:timecompleted'] = 'A data/hora da conclusão do pedido.';
$string['privacy:metadata:ai_action_register:timecreated'] = 'A data/hora de criação do pedido.';
$string['privacy:metadata:ai_action_register:userid'] = 'O ID do utilizador que fez o pedido.';
$string['privacy:metadata:ai_action_summarise_text'] = 'Uma tabela que armazena os pedidos de texto resumido feitos pelos utilizadores.';
$string['privacy:metadata:ai_action_summarise_text:completiontoken'] = 'Os tokens de conclusão utilizados para resumir o texto.';
$string['privacy:metadata:ai_action_summarise_text:fingerprint'] = 'O hash exclusivo que representa o estado/versão do modelo e do conteúdo.';
$string['privacy:metadata:ai_action_summarise_text:generatedcontent'] = 'O texto real gerado pelo modelo de IA com base na prompt.';
$string['privacy:metadata:ai_action_summarise_text:prompt'] = 'O prompt para o pedido de texto resumido.';
$string['privacy:metadata:ai_action_summarise_text:prompttokens'] = 'Os tokens do prompt utilizados para resumir o texto.';
$string['privacy:metadata:ai_action_summarise_text:responseid'] = 'O ID da resposta.';
$string['privacy:metadata:ai_policy_register'] = 'Uma tabela que armazena o estado da aceitação da política de IA para cada utilizador.';
$string['privacy:metadata:ai_policy_register:contextid'] = 'O ID do contexto cujos dados foram guardados.';
$string['privacy:metadata:ai_policy_register:timeaccepted'] = 'A data/hora a que o utilizador aceitou a política de IA.';
$string['privacy:metadata:ai_policy_register:userid'] = 'O ID do utilizador cujos dados foram guardados.';
$string['prompttokens'] = 'Tokens de prompt';
$string['prompttokens_help'] = 'Os tokens de prompt são unidades de texto que compõem a entrada que envia para o modelo de IA. As entradas mais longas utilizam mais tokens, o que provavelmente custará mais.';
$string['provider'] = 'Fornecedor';
$string['provideractionsettings'] = 'Ações';
$string['provideractionsettings_desc'] = 'Escolha e configure as ações que {$a} pode realizar no seu site.';
$string['providerinstanceactionupdated'] = 'configurações da ação {$a} atualizadas';
$string['providerinstancecreated'] = 'Criada instância do fornecedor de IA {$a}';
$string['providerinstancedelete'] = 'Apagar instância do fornecedor de IA';
$string['providerinstancedeleteconfirm'] = 'Está prestes a apagar a instância do fornecedor de IA: "{$a->name} ({$a->provider})". Tem a certeza?';
$string['providerinstancedeleted'] = 'Apagada instância do fornecedor de IA {$a}';
$string['providerinstancedeletefailed'] = 'Não é possível apagar a instância do fornecedor de IA {$a}. O fornecedor está em utilização ou existe um problema na base de dados. Verifique se o fornecedor está ativo ou contacte o administrador da base de dados para obter ajuda.';
$string['providerinstancedisablefailed'] = 'Não é possível desativar a instância do fornecedor de IA. O fornecedor está em utilização ou existe um problema na base de dados. Verifique se o fornecedor está ativo ou contacte o administrador da base de dados para obter ajuda.';
$string['providerinstanceupdated'] = 'Atualizada a instância do fornecedor de IA {$a}';
$string['providermoveddown'] = '{$a} movido para baixo.';
$string['providermovedup'] = '{$a} movido para cima.';
$string['providername'] = 'Nome da instância';
$string['providers'] = 'Fornecedores';
$string['providersettings'] = 'Configurações';
$string['providertype'] = 'Escolha o módulo do fornecedor de IA';
$string['timegenerated'] = 'Data/hora de geração';
$string['unknownvalue'] = '—';
$string['userpolicy'] = '<h4><strong>Bem-vindo à nova funcionalidade de IA!</strong></h4>
<p>Esta funcionalidade de Inteligência Artificial (IA) baseia-se exclusivamente em Large Language Models (LLM) externos para melhorar a sua experiência de aprendizagem e ensino. Antes de começar a utilizar estes serviços de IA, leia esta política de utilização.</p>
<h4><strong>Precisão do conteúdo gerado por IA</strong></h4>
<p>A IA pode fornecer sugestões e informações úteis, mas a sua precisão pode variar. Deve sempre verificar as informações fornecidas para ter a certeza de que são precisas, completas e adequadas à sua situação específica.</p>
<h4><strong>Como são processados os seus dados?</strong></h4>
<p>Esta funcionalidade de IA utiliza Large Language Models (LLM) externos. Se utilizar esta funcionalidade, quaisquer informações ou dados pessoais que partilhe serão tratados de acordo com a política de privacidade destes LLM. Recomendamos que leia a política de privacidade do LLM para compreender como os seus dados pessoais serão tratados.
Além disso, pode ser mantido, neste site, um registo das suas interações com os recursos de IA.</p>
<p>Se tiver dúvidas sobre como os seus dados são processados, consulte os seus professores ou os administradores da organização de aprendizagem.</p>
<p>Ao continuar, reconhece que compreende e concorda com esta política.</p>';
$string['userratelimit'] = 'Máximo de pedidos por utilizador';
$string['userratelimit_help'] = 'O número de pedidos permitidos por hora, por utilizador.';
