<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'el', version '5.1'.
 *
 * @package     theme_essential
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['above'] = 'Πάνω από';
$string['aftercontent'] = 'Μετά το περιεχόμενο';
$string['alert1'] = 'Πρώτη επαγρύπνηση';
$string['alert2'] = 'Δεύτερη επαγρύπνηση';
$string['alert3'] = 'Τρίτη επαγρύπνηση';
$string['alert_edit'] = 'Τροποποίηση επαγρυπνήσεων';
$string['alert_general'] = 'Ανακοίνωση';
$string['alert_info'] = 'Πληροφορίες';
$string['alert_warning'] = 'Προειδοποίηση';
$string['alertinfodesc'] = 'Δώστε τις ρυθμίσεις για την επαγρύπνησή σας.';
$string['alertsheading'] = 'Επαγρυπνήσεις χρήστη';
$string['alerttext'] = 'Κείμενο επαγρύπνησης';
$string['alerttextdesc'] = 'Ποιο είναι το κείμενο που θέλετε να εμφανίσετε στην ειδοποίηση.';
$string['alerttitle'] = 'Τίτλος';
$string['alerttype'] = 'Επίπεδο';
$string['allclasses'] = 'Όλες οι τάξεις';
$string['allcourses'] = 'Όλα τα μαθήματα';
$string['allmodules'] = 'Όλα τα αρθρώματα';
$string['allunits'] = 'Όλες οι μονάδες';
$string['alternativecolors'] = 'Εναλλακτικά χρώματα {$a}';
$string['alternativethemecolor'] = 'Εναλλακτικό χρώμα αισθητικού θέματος {$a}';
$string['alternativethemecolors'] = 'Εναλλακτικά χρώματα αισθητικού θέματος';
$string['alternativethemecolorsdesc'] = 'Ορίζει εναλλακτικά χρώματα αισθητικού θέματος που μπορεί να επιλέξει ο χρήστης.';
$string['alternativethemedefaultbuttonbackgroundcolour'] = 'Προεπιλεγμένο χρώμα υπόβαθρου κουμπιού {$a}';
$string['alternativethemedefaultbuttonbackgroundcolourdesc'] = 'Ορισμός του χρώματος υπόβαθρου για όλα τα προεπιλεγμένα πλήκτρα {$a}.';
$string['alternativethemedefaultbuttontextcolour'] = 'Χρώμα κειμένου προεπιλεγμένου πλήκτρου {$a}';
$string['alternativethemedefaultbuttontextcolourdesc'] = 'Ορισμός του χρώματος κειμένου για όλα τα προεπιλεγμένα πλήκτρα {$a}.';
$string['alwaysdisplay'] = 'Εμφάνιση πάντα';
$string['android'] = 'Android (Google Play)';
$string['androidurl'] = 'Διεύθυνση URL Android (Google Play)';
$string['asconfigintnan'] = '{$a->value} δεν είναι αριθμός';
$string['backtotop'] = 'Επιστροφή στην κορυφή';
$string['badgepreferences'] = 'Διακριτικό';
$string['badgesmi'] = 'Διακριτικά';
$string['beforecontent'] = 'Πριν το περιεχόμενο';
$string['below'] = 'Από κάτω';
$string['breadcrumbsimple'] = 'Απλό';
$string['breadcrumbstyle'] = 'Στυλ δυναμικού μονοπατιού (μπάρας πλοήγησης)';
$string['breadcrumbstyled'] = 'Φανταχτερό';
$string['breadcrumbstyledesc'] = 'Εδώ μπορείτε να αλλάξετε το στυλ των δυναμικών μονοπατιών (μπάρας πλοήγησης).';
$string['breadcrumbstylednocollapse'] = 'Φανταχτερό χωρίς σύμπτυξη';
$string['breadcrumbthin'] = 'Λεπτό';
$string['cachesused'] = 'Χρήση του περιεχομένου της κρυφής μνήμης';
$string['calendarmi'] = 'Ημερολόγιο';
$string['categoryctidesc'] = 'Αν ενεργοποιηθεί, θα επιτρέπει τον ορισμό εικόνων για κάθε κατηγορία.';
$string['categoryctiheading'] = 'Εικόνες τίτλου μαθημάτων κατηγορίας';
$string['categoryctiheadingcategory'] = 'Εικόνες τίτλου μαθημάτων κατηγορίας για: {$a->category}';
$string['categoryctiheadingcs'] = 'Ρυθμίσεις εικόνων τίτλου μαθημάτων κατηγορίας';
$string['categoryctiheadingsub'] = 'Χρήση εικόνων για αναπαράσταση των κατηγοριών σας σε ένα μάθημα';
$string['categoryctiheight'] = 'Ύψος εικόνας τίτλου μαθήματος κατηγορίας «{$a->category}»';
$string['categoryctiinfo'] = 'Ρυθμίσεις {$a->category}';
$string['categoryctiinfodesc'] = 'Ρυθμίσεις εικόνας τίτλου μαθήματος κατηγορίας για: {$a->category}';
$string['categoryctimage'] = 'Αρχείο εικόνας τίτλου μαθήματος κατηγορίας «{$a->category}»';
$string['categoryctimagedesc'] = 'Αρχείο εικόνας για τον τίτλο μαθήματος στην κατηγορία «{$a->category}».';
$string['categoryctimageurl'] = 'Διεύθυνση URL εικόνας τίτλου μαθήματος κατηγορίας «{$a->category}»';
$string['categoryctitextbackgroundcolour'] = 'Χρώμα υπόβαθρου κειμένου τίτλου μαθήματος κατηγορίας «{$a->category}»';
$string['categoryctitextbackgroundcolourdesc'] = 'Χρώμα υπόβαθρου κειμένου για τον τίτλο μαθήματος στην κατηγορία «{$a->category}».';
$string['categoryctitextcolour'] = 'Χρώμα κειμένου τίτλου μαθήματος κατηγορίας «{$a->category}»';
$string['categoryctitextcolourdesc'] = 'Χρώμα κειμένου για τον τίτλο μαθήματος στην κατηγορία «{$a->category}».';
$string['categoryiconcategory'] = 'Το εικονίδιο για την κατηγορία: {$a->category}.';
$string['categoryicondesc'] = 'Αν ενεργοποιηθεί, θα επιτρέπει τον ορισμό εικονιδίων/εικόνων για κάθε κατηγορία.';
$string['categoryiconheading'] = 'Εικονίδια/εικόνες κατηγοριών';
$string['categoryiconheadingsub'] = 'Χρήση εικονιδίων για αναπαράσταση των κατηγοριών σας';
$string['categoryiconinfo'] = 'Ορισμός προσαρμοσμένων εικονιδίων κατηγοριών';
$string['categoryimagecategory'] = 'Η εικόνα για την κατηγορία: {$a->category}.';
$string['categoryincoursebreadcrumbfeature'] = 'Κατηγορίες στο δυναμικό μονοπάτι (μπάρας πλοήγησης) του μαθήματος';
$string['categoryincoursebreadcrumbfeaturedesc'] = 'Εμφάνιση των συνδέσμων κατηγορίας στο δυναμικό μονοπάτι (μπάρας πλοήγησης) του μαθήματος.';
$string['ccd'] = 'Ημερομηνία δημιουργίας μαθήματος';
$string['ced'] = 'Ημερομηνία λήξης μαθήματος';
$string['cfn'] = 'Πλήρες όνομα μαθήματος';
$string['cid'] = 'Αναγνωριστικό μαθήματος';
$string['colordesc'] = 'Εδώ μπορείτε να βρείτε διάφορες ρυθμίσεις για να αλλάξετε πολλά από τα χρώματα που υπάρχουν σε αυτό το αισθητικό θέμα.';
$string['colorheading'] = 'Χρώμα';
$string['colorheadingsub'] = 'Ορισμός των χρωμάτων προς χρήση στο αισθητικό σας θέμα';
$string['configtitle'] = 'Ουσιώδες';
$string['contactinfo'] = 'Πληροφορίες επικοινωνίας';
$string['contactinfodesc'] = 'Δώστε τις πληροφορίες επικοινωνίας σας';
$string['copyright'] = 'Δικαιώματα πνευματικής ιδιοκτησίας (Copyright)';
$string['copyrightdesc'] = 'Το όνομα του οργανισμού σας.';
$string['coursecategorysettingstitle'] = 'Ρυθμίσεις κατηγορίας μαθημάτων';
$string['coursecontentsearch'] = 'Αναζήτηση περιεχομένου μαθήματος';
$string['coursecontentsearchdesc'] = 'Ενεργοποίηση αναζήτησης περιεχομένου μαθημάτων στη σελίδα «Ταμπλό». Λειτουργεί μόνο όταν το Essential δεν είναι στο «\\$CFG->themedir».';
$string['coursecontentsearchsortattribute'] = 'Ιδιοχαρακτηριστικό ταξινόμησης αναζήτησης περιεχομένου μαθήματος';
$string['coursecontentsearchsortattributedesc'] = 'Ταξινόμηση των αποτελεσμάτων της αναζήτησης κατά αυτό το ιδιοχαρακτηριστικό.';
$string['coursecontentsearchsortorder'] = 'Σειρά ταξινόμησης αναζήτησης περιεχομένου μαθήματος';
$string['coursecontentsearchsortorderdesc'] = 'Ταξινόμηση των αποτελεσμάτων της αναζήτησης κατά αύξουσα ή φθίνουσα σειρά.';
$string['coursegrades'] = 'Βαθμοί μαθήματος';
$string['coursegradesmi'] = 'Βαθμοί μαθήματος';
$string['courselistteachericon'] = 'Εικονίδιο διδάσκοντος λίστας μαθημάτων';
$string['coursesettingstitle'] = 'Ρυθμίσεις μαθήματος';
$string['coursetitleposition'] = 'Θέση τίτλου μαθήματος';
$string['csd'] = 'Ημερομηνία έναρξης μαθήματος';
$string['ctioverride'] = 'Παράκαμψη εικόνων κατηγοριών σε ένα μάθημα';
$string['customcss'] = 'Προσαρμοσμένο CSS';
$string['customcssdesc'] = 'Οποιουσδήποτε κανόνες CSS προσθέτετε σε αυτή την περιοχή κειμένου, θα αντικατοπτρίζονται σε κάθε σελίδα, διευκολύνοντας έτσι την προσαρμογή αυτού του αισθητικού θέματος.';
$string['customscrollbars'] = 'Προσαρμοσμένες μπάρες κύλισης';
$string['dontdisplay'] = 'Να μην εμφανίζεται ποτέ';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'Δώστε την διεύθυνση URL της σελίδας σας στο Facebook. (π.χ. https://www.facebook.com/tosxoleiomou)';
$string['facebookurl'] = 'Διεύθυνση URL στο Facebook';
$string['favicon'] = 'Προσαρμοσμένο αγαπ.εικονίδιο';
$string['favicondesc'] = 'Ανεβάστε το δικό σας αγαπ.εικονίδιο. Πρέπει να είναι ένα .ico αρχείο.';
$string['featuredesc'] = 'Εδώ μπορείτε να βρείτε διάφορες ρυθμίσεις για να αλλάξετε πολλές από τις λειτουργίες που βρίσκονται σε αυτό το αισθητικό θέμα.';
$string['featureheading'] = 'Λειτουργίες';
$string['featureheadingsub'] = 'Ορισμός των λειτουργιών που χρησιμοποιούνται στο αισθητικό θέμα σας';
$string['findcoursecontent'] = 'Αναζήτηση μαθήματος:';
$string['flickr'] = 'Flickr';
$string['flickrurl'] = 'Διεύθυνση URL στο Flickr';
$string['floatingsubmitbuttons'] = 'Αιωρούμενα πλήκτρα υποβολής';
$string['fontcharactersetcyrillic'] = 'Κυριλλικά';
$string['fontcharactersetcyrillicext'] = 'Κυριλλικά εκτεταμένα';
$string['fontcharactersetgreek'] = 'Ελληνικά';
$string['fontcharactersetgreekext'] = 'Ελληνικά εκτεταμένα';
$string['fontcharactersetlatinext'] = 'Λατινικά εκτεταμένα';
$string['fontcharactersetvietnamese'] = 'Βιετναμέζικα';
$string['fontfiles'] = 'Αρχεία γραμματοσειρών';
$string['fontfilesdesc'] = 'Ανεβάστε τα αρχεία γραμματοσειρών σας εδώ.';
$string['fontheadingdesc'] = 'Επιλέξτε και εισαγάγετε τις γραμματοσειρές που θέλετε να χρησιμοποιήσετε στο περιβάλλον σας Moodle.';
$string['fontheadingsub'] = 'Ρυθμίσεις γραμματοσειράς';
$string['fontnamebody'] = 'Γραμματοσειρά κειμένου';
$string['fontnamebodydesc'] = 'Πληκτρολογήστε το ακριβές όνομα για την γραμματοσειρά προς χρήση για όλα τα άλλα κείμενα.';
$string['fontnameheading'] = 'Γραμματοσειρά επικεφαλίδας';
$string['fontnameheadingdesc'] = 'Πληκτρολογήστε το ακριβές όνομα της γραμματοσειράς προς χρήση για επικεφαλίδες.';
$string['fontselect'] = 'Επιλογέας τύπου γραμματοσειράς';
$string['fontsettings'] = 'Γραμματοσειρά';
$string['fonttypecustom'] = 'Προσαρμοσμένες γραμματοσειρές';
$string['fonttypeuser'] = 'Γραμματοσειρές χρήστη';
$string['footerblockbackgroundcolour'] = 'Χρώμα υπόβαθρου μπλοκ υποσέλιδου';
$string['footerblockbackgroundcolourdesc'] = 'Ορισμός του χρώματος για το υπόβαθρο του μπλοκ στο υποσέλιδο.';
$string['footerblocktextcolour'] = 'Χρώμα κειμένου μπλοκ υποσέλιδου';
$string['footerblockurlcolour'] = 'Χρώμα συνδέσμου στο μπλοκ υποσέλιδου';
$string['footercolor'] = 'Χρώμα υπόβαθρου υποσέλιδου';
$string['footercolors'] = 'Χρώματα υποσέλιδου';
$string['footerheading'] = 'Υποσέλιδο';
$string['footerheadingcolor'] = 'Χρώμα επικεφαλίδας υποσέλιδου';
$string['footnote'] = 'Υποσημείωση';
$string['footnotedesc'] = 'Οτιδήποτε προσθέσετε σε αυτή την περιοχή κειμένου θα εμφανίζεται στο υποσέλιδο σε όλες τις σελίδες του Moodle ιστοτόπου σας.';
$string['forumdiscussionsmi'] = 'Συζητήσεις';
$string['forumpostsmi'] = 'Αναρτήσεις φόρουμ';
$string['fppagetopblocksperrow'] = 'Μέγιστος αριθμός μπλοκ σελίδας ανά γραμμή';
$string['frontcontentdesc'] = 'Εάν ενεργοποιηθεί, προσθέτει ένα προσαρμοσμένο περιεχόμενο μεταξύ του «Προβολή διαφανειών» και του «Κουτιά μάρκετινγκ» για το δικό σας προσαρμοσμένο περιεχόμενο.';
$string['frontcontentheading'] = 'Περιοχή περιεχομένου πρώτης σελίδας';
$string['frontpageblocks'] = 'Στοίχιση των μπλοκ πρώτης σελίδας';
$string['frontpageblocksheading'] = 'Μπλοκ πρώτης σελίδας';
$string['frontpageheading'] = 'Πρώτη σελίδα';
$string['frontpagesettingstitle'] = 'Ρυθμίσεις πρώτης σελίδας';
$string['fullname'] = 'Πλήρες όνομα ιστοτόπου';
$string['fullnamesummary'] = 'Πλήρες όνομα και σύνοψη';
$string['generalheadingdesc'] = 'Ρυθμίστε τις γενικές ρυθμίσεις για το αισθητικό θέμα εδώ.';
$string['generalheadingsub'] = 'Γενικές ρυθμίσεις';
$string['genericsettings'] = 'Γενικά';
$string['googleplus'] = 'Google+';
$string['googleplusurl'] = 'Διεύθυνση URL στο Google+';
$string['gotobottom'] = 'Μετάβαση στην βάση της σελίδας';
$string['gotopeople'] = 'Μετάβαση στα άτομα';
$string['haveheaderblock'] = 'Περιοχή μπλοκ κεφαλίδας';
$string['headerbackground'] = 'Εικόνα υπόβαθρου επικεφαλίδας';
$string['headerbackgrounddesc'] = 'Ανεβάστε τη δική σας εικόνα υπόβαθρου.';
$string['headerbackgroundstyle'] = 'Στυλ υπόβαθρου επικεφαλίδας';
$string['headerbackgroundstyledesc'] = 'Επιλογή του στυλ για το υπόβαθρο επικεφαλίδας.';
$string['headerblocksperrow'] = 'Μπλοκ επικεφαλίδας ανά γραμμή';
$string['headerheading'] = 'Επικεφαλίδα';
$string['headertextcolor'] = 'Χρώμα κειμένου επικεφαλίδας';
$string['headertextcolordesc'] = 'Ορισμός του χρώματος κειμένου για την επικεφαλίδα.';
$string['headertitle'] = 'Τίτλος επικεφαλίδας';
$string['helplink'] = 'Σύνδεσμος βοήθειας';
$string['helplinktype'] = 'Ενεργοποίηση συνδέσμου βοήθειας στο μενού';
$string['hidedefaulteditingbutton'] = 'Απόκρυψη προεπιλεγμένου πλήκτρου επεξεργασίας σελίδας';
$string['hideonphone'] = 'Απόκρυψη προβολής διαφανειών σε κινητά';
$string['hideontablet'] = 'Απόκρυψη προβολής διαφανειών σε τάμπλετ';
$string['hvpcustomcss'] = 'Προσαρμοσμένο CSS για το H5P';
$string['hvpcustomcssdesc'] = 'Προσαρμοσμένο CSS για το άρθρωμα H5P (moodle.org/plugins/mod_hvp) αν είναι εγκατεστημένο.';
$string['icon'] = 'εικονίδιο';
$string['image'] = 'εικόνα';
$string['included'] = 'Αρχεία που συμπεριλαμβάνονται';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'Δώστε την διεύθυνση URL της σελίδας σας στο Instagram. (i.e http://instagram.com/ToSxoleioMou)';
$string['instagramurl'] = 'Διεύθυνση URL στο Instagram';
$string['ios'] = 'iPhone/iPad (App Store)';
$string['iosurl'] = 'iPhone/iPad (App Store) URL';
$string['ipadicondesc'] = 'Το εικονίδιο πρέπει να είναι ένα PNG αρχείο με μέγεθος 72 εικονοστοιχεία επί 72 εικονοστοιχεία.';
$string['ipadretinaicon'] = 'Εικονίδιο iPad (Retina)';
$string['ipadretinaicondesc'] = 'Το εικονίδιο πρέπει να είναι ένα PNG αρχείο με μέγεθος 144 εικονοστοιχεία επί 144 εικονοστοιχεία.';
$string['layout'] = 'Χρήση μιας τυπικής διάταξης μαθήματος';
$string['left'] = 'Αριστερά';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'Δώστε την διεύθυνση URL του προφίλ σας στο LinkedIn. (π.χ. https://www.linkedin.com/company/mycollege)';
$string['linkedinurl'] = 'Διεύθυνση URL στο LinkedIn';
$string['loadtime'] = 'Χρόνος φόρτωσης';
$string['loggedinas'] = 'συνδεδεμένος ως';
$string['loggedinfrom'] = 'Συνδεδεμένος από';
$string['loggedinfrommi'] = 'Συνδεδεμένος από';
$string['loginbackground'] = 'Εικόνα υπόβαθρου σύνδεσης';
$string['loginbackgroundstyle'] = 'Στυλ υπόβαθρου σύνδεσης';
$string['loginbackgroundstyledesc'] = 'Επιλογή του στυλ για την ανεβασμένη εικόνα.';
$string['logo'] = 'Λογότυπο';
$string['logomobilewidth'] = 'Πλάτος λογότυπου κινητού';
$string['marketingbuttontext'] = 'Κείμενο συνδέσμου';
$string['marketingbuttontextdesc'] = 'Κείμενο προς εμφάνιση πάνω στο πλήκτρο.';
$string['marketingbuttonurl'] = 'Διεύθυνση URL συνδέσμου';
$string['marketingbuttonurldesc'] = 'Διεύθυνση URL στην οποία θα παραπέμπει το πλήκτρο.';
$string['marketingcontent'] = 'Περιεχόμενο';
$string['marketingheading'] = 'Σημεία πώλησης';
$string['marketingicon'] = 'Εικονίδιο';
$string['marketingimage'] = 'Εικόνα';
$string['marketingtitle'] = 'Τίτλος';
$string['marketingurltarget'] = 'Προορισμός συνδέσμου';
$string['marketingurltargetdesc'] = 'Επιλέξτε πως πρέπει να ανοίγει ο σύνδεσμος';
$string['marketingurltargetnew'] = 'Νέα σελίδα';
$string['marketingurltargetparent'] = 'Γονικό πλαίσιο';
$string['marketingurltargetself'] = 'Τρέχουσα σελίδα';
$string['memused'] = 'Μνήμη που χρησιμοποιήθηκε';
$string['messagesmi'] = 'Μηνύματα';
$string['messagesmidesc'] = 'Εμφάνιση του στοιχείου μενού μηνυμάτων εάν είναι ενεργοποιημένα τα μηνύματα.';
$string['mobileappsheading'] = 'Εφαρμογές';
$string['mobileappsheadingsub'] = 'Συνδεθείτε στην εφαρμογή σας για να κάνετε τους μαθητές σας να χρησιμοποιούν κινητά';
$string['modulesettingstitle'] = 'Ρυθμίσεις αρθρώματος';
$string['myclasses'] = 'Οι τάξεις μου';
$string['mycourses'] = 'Τα μαθήματά μου';
$string['mycoursescatsubmenu'] = 'Υπομενού κατηγορίας και μαθημάτων';
$string['mycoursesinfo'] = 'Μενού μαθημάτων';
$string['mycoursesmax'] = 'Μέγιστο μαθημάτων';
$string['mycoursesorder'] = 'Σειρά/ταξινόμηση μαθημάτων';
$string['mycoursesorderid'] = 'Αναγνωριστικό μαθήματος';
$string['mycoursesorderidasc'] = 'Αύξουσα';
$string['mycoursesorderiddes'] = 'Φθίνουσα';
$string['mycoursesorderidorder'] = 'Σειρά αναγνωριστικών μαθήματος';
$string['mycoursesorderidorderdesc'] = 'Η σειρά αναγνωριστικών μαθήματος για όταν το «Αναγνωριστικό μαθήματος» έχει οριστεί ως «Σειρά ταξινόμησης μαθημάτων»';
$string['mycoursesorderlast'] = 'Τελευταία πρόσβαση ή ώρα έναρξης εγγραφής, αν δεν έγινε ποτέ πρόσβαση';
$string['mycoursesordersort'] = 'Σειρά ταξινόμησης μαθημάτων';
$string['mycoursetitle'] = 'Ορολογία';
$string['mygrades'] = 'Οι βαθμοί μου';
$string['mygradesmi'] = 'Οι βαθμοί μου';
$string['mylatestclasses'] = 'Τα τελευταία μου μαθήματα';
$string['mylatestcourses'] = 'Τα τελευταία μαθήματά μου';
$string['mylatestmodules'] = 'Τα τελευταία αρθρώματά μου';
$string['mylatestunits'] = 'Οι τελευταίες ενότητές μου';
$string['mymodules'] = 'Τα αρθρώματά μου';
$string['myunits'] = 'Οι ενότητές μου';
$string['navbarabove'] = 'Μπάρα πλοήγησης πάνω από την επικεφαλίδα';
$string['navbarbelow'] = 'Μπάρα πλοήγησης κάτω από την επικεφαλίδα';
$string['navbartitle'] = 'Τίτλος μπάρας πλοήγησης';
$string['navbartitledesc'] = 'Διαμορφώστε εδώ τι τίτλος να εμφανίζεται στη γραμμή πλοήγησης.';
$string['nextsection'] = 'Επόμενη ενότητα';
$string['nobreadcrumb'] = 'Απόκρυψη';
$string['noenrolments'] = 'Δεν έχετε καθόλου τρέχουσες εγγραφές';
$string['noslidetitle'] = 'Δεν υπάρχει τίτλος για την διαφάνεια {$a->slide}';
$string['notitle'] = 'Κανένας τίτλος';
$string['numberofcoursesandsubcatcourses'] = 'Αριθμός μαθημάτων - μαθήματα υποκατηγορίας';
$string['numberofslides'] = 'Αριθμός διαφανειών';
$string['numberofslides_desc'] = 'Αριθμός διαφανειών στον ολισθητήρα.';
$string['oldnavbar'] = 'Χρήση της παλιάς θέσης της μπάρας πλοήγησης';
$string['pagebackground'] = 'Εικόνα υπόβαθρου σελίδας';
$string['pagebackgrounddesc'] = 'Ανεβάστε τη δική σας εικόνα υπόβαθρου. Επιλέξτε το στυλ της εικόνας παρακάτω.';
$string['pagebackgroundstyle'] = 'Στυλ υπόβαθρου σελίδας';
$string['pagebackgroundstyledesc'] = 'Επιλέξτε το στυλ για τη ανεβασμένη εικόνα.';
$string['pagetopblocksperrow'] = 'Μέγιστος αριθμός μπλοκ σελίδας ανά γραμμή';
$string['pagetopblocksperrowdesc'] = 'Καταχωρίστε μέχρι πόσα μπλοκ ανά γραμμή μεταξύ {$a->lower} και {$a->upper} για σελίδες με «Μέγιστος αριθμός μπλοκ σελίδας». Οι τρέχουσες σελίδες είναι: Μαθήματα, Κατηγορία Μαθήματος, Ταμπλό, Δημόσιο και Εκτύπωση.';
$string['pagewidth'] = 'Ορισμός πλάτους σελίδας';
$string['pagewidthdesc'] = 'Επιλέξτε το πλάτος του ιστοτόπου σας από μια λίστα με τα διαθέσιμα μεγέθη.';
$string['participantsmenu'] = 'Μενού συμμετεχόντων';
$string['participantsmenudesc'] = 'Εμφάνιση του μενού των συμμετεχόντων στις σελίδες του μαθήματος και της ενότητας.';
$string['paypal_click'] = 'Προφίλ Moodle';
$string['perf_max'] = 'Με λεπτομέρειες';
$string['perf_min'] = 'Μινιμαλιστικό';
$string['perfinfo'] = 'Λειτουργία πληροφοριών απόδοσης';
$string['perfinfoheading'] = 'Πληροφορίες απόδοσης';
$string['pinterest'] = 'Pinterest';
$string['pinterestdesc'] = 'Δώστε την διεύθυνση URL της σελίδας σας στο Pinterest. (π.χ. http://pinterest.com/mycollege)';
$string['pinteresturl'] = 'Διεύθυνση URL Pinterest';
$string['pluginname'] = 'Ουσιώδες';
$string['preferencesmi'] = 'Προτιμήσεις';
$string['preferencesmidesc'] = 'Εμφάνιση του στοιχείου μενού προτιμήσεων';
$string['previoussection'] = 'Προηγούμενη ενότητα';
$string['privatefilesmi'] = 'Ιδιωτικά αρχεία';
$string['profilebarcustomtitle'] = 'Τίτλος προσαρμοσμένου μπλοκ μπάρας προφίλ';
$string['profilebarcustomtitledesc'] = 'Τίτλος για το προσαρμοσμένο μπλοκ της μπάρας προφίλ.';
$string['profilelinkmi'] = 'Σύνδεσμος προφίλ';
$string['properties'] = 'Ιδιότητες';
$string['propertiesdesc'] = 'Λίστα από ιδιότητες.';
$string['propertiesproperty'] = 'Ιδιότητα';
$string['propertiesreturn'] = 'Επιστροφή';
$string['propertiessub'] = 'Οι ιδιότητες';
$string['propertiesvalue'] = 'Τιμή';
$string['putpropertiesadded'] = 'Προστέθηκε:';
$string['putpropertieschanged'] = 'Άλλαξε:';
$string['putpropertiesfrom'] = 'από';
$string['putpropertiesignorecti'] = 'Παράβλεψη όλων των ρυθμίσεων εικόνας τίτλου μαθήματος.';
$string['putpropertiesignored'] = 'Αγνοήθηκαν:';
$string['putpropertiessettingsreport'] = 'Αναφορά ρυθμίσεων:';
$string['putpropertiesunchanged'] = 'Αμετάβλητα:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyour'] = 'Για εμάς';
$string['putpropertyproperties'] = 'Ιδιότητες';
$string['putpropertyreport'] = 'Αναφορά:';
$string['putpropertyversion'] = 'Έκδοση:';
$string['readmore'] = 'Διαβάστε περισσότερα';
$string['region-footer-left'] = 'Υποσέλιδο (αριστερά)';
$string['region-footer-middle'] = 'Υποσέλιδο (μέση)';
$string['region-footer-right'] = 'Υποσέλιδο (δεξιά)';
$string['region-header'] = 'Επικεφαλίδα';
$string['region-hidden-dock'] = 'Κρυφό από τους χρήστες';
$string['region-home'] = 'Αρχική';
$string['region-page-top'] = 'Κορυφή σελίδας';
$string['region-side-post'] = 'Δεξιά';
$string['region-side-pre'] = 'Αριστερά';
$string['returntosection'] = 'Επιστροφή στην ενότητα: {$a->section}';
$string['returntosectionfeature'] = 'Επιστροφή στην ενότητα';
$string['right'] = 'Δεξιά';
$string['searchallcoursecontent'] = 'Αναζήτηση σε όλο το περιεχόμενο των μαθημάτων';
$string['searchallcoursecontentdefault'] = 'Προεπιλεγμένη αναζήτηση σε όλο το περιεχόμενο των μαθημάτων';
$string['searchallcoursecontentenable'] = 'Ενεργοποίηση αναζήτησης σε όλο το περιεχόμενο των μαθημάτων';
$string['serverload'] = 'Φορτίο εξυπηρετητή';
$string['sessionsize'] = 'Μέγεθος συνόδου';
$string['shortname'] = 'Σύντομο όνομα ιστοτόπου';
$string['shortnamesummary'] = 'Σύντομο όνομα και σύνοψη';
$string['siteicon'] = 'Εικονίδιο ιστοτόπου';
$string['skype'] = 'Λογαριασμός Skype';
$string['slidecaption'] = 'Λεζάντα διαφάνειας';
$string['slidecaptionbackgroundcolor'] = 'Χρώμα υπόβαθρου λεζάντας διαφάνειας';
$string['slidecaptionbelow'] = 'Λεζάντα διαφάνειας κάτω από την εικόνα';
$string['slidecaptionbelowdesc'] = 'Εάν η λεζάντα διαφάνειας πρέπει να βρίσκεται κάτω από την εικόνα.';
$string['slidecaptionbeside'] = 'Δίπλα';
$string['slidecaptioncentred'] = 'Κεντράρισμα λεζάντας διαφάνειας';
$string['slidecaptioncentreddesc'] = 'Εάν η διαφάνεια πρέπει να στοιχηθεί στο κέντρο.';
$string['slidecaptiondesc'] = 'Δώστε το κείμενο λεζάντας προς χρήση για τη διαφάνεια';
$string['slidecaptionontop'] = 'Πάνω';
$string['slidecaptionoptions'] = 'Επιλογές λεζάντας διαφάνειας';
$string['slidecaptionoptionsdesc'] = 'Που πρέπει να εμφανίζονται οι λεζάντες σε σχέση με την εικόνα.';
$string['slidecaptiontextcolor'] = 'Χρώμα κειμένου λεζάντας διαφάνειας';
$string['slidecaptionunderneath'] = 'Από κάτω';
$string['slidecolor'] = 'Χρώμα κειμένου διαφάνειας';
$string['slidecolordesc'] = 'Τι χρώμα θα πρέπει να είναι το κείμενο λεζάντας διαφανειών.';
$string['slideimage'] = 'Εικόνα διαφάνειας';
$string['slideimagedesc'] = 'Η εικόνα λειτουργεί καλύτερα αν είναι διαφανής.';
$string['slideinterval'] = 'Διάστημα/διάρκεια διαφάνειας';
$string['slideintervaldesc'] = 'Διάστημα/διάρκεια μετάβασης από διαφάνεια σε διαφάνεια σε χιλιοστά του δευτερολέπτου.';
$string['slideno'] = 'Διαφάνεια {$a->slide}';
$string['slidenodesc'] = 'Δώστε τις ρυθμίσεις για τη διαφάνεια {$a->slide}.';
$string['slideshowheading'] = 'Προβολή διαφανειών';
$string['slideshowheadingsub'] = 'Δυναμική προβολή διαφανειών για την πρώτη σελίδα';
$string['slidetitle'] = 'Τίτλος διαφάνειας';
$string['slidetitledesc'] = 'Δώστε έναν περιγραφικό τίτλο για την διαφάνειά σας';
$string['slideurl'] = 'Σύνδεσμος διαφάνειας';
$string['slideurldesc'] = 'Δώστε τον προορισμό στόχο του συνδέσμου εικόνας διαφάνειας';
$string['slideurltarget'] = 'Προορισμός συνδέσμου';
$string['slideurltargetnew'] = 'Νέα σελίδα';
$string['slideurltargetparent'] = 'Γονικό πλαίσιο';
$string['slideurltargetself'] = 'Τρέχουσα σελίδα';
$string['socialheading'] = 'Κοινωνική δικτύωση';
$string['socialheadingsub'] = 'Αυξήστε την συμμετοχή των χρηστών μέσω χρήσης Κοινωνικών Δικτύων';
$string['socialnetworks'] = 'Κοινωνικά Δίκτυα';
$string['stylecover'] = 'Εξώφυλλο';
$string['stylestretch'] = 'Τέντωμα';
$string['styletiled'] = 'Με πλακάκια';
$string['switchrolemi'] = 'Αλλαγή ρόλου';
$string['themecolor'] = 'Χρώμα αισθητικού θέματος';
$string['themecolordesc'] = 'Το χρώμα του αισθητικού θέματός σας. Αυτό μπορεί να αλλάξει πολλαπλά στοιχεία λογισμικού για να παράγει το χρώμα που επιθυμείτε σε όλο τον ιστότοπο του Moodle';
$string['themecolors'] = 'Χρώματα αισθητικού θέματος';
$string['themedefaultbuttonbackgroundcolour'] = 'Προεπιλεγμένο χρώμα υπόβαθρου πλήκτρου';
$string['themedefaultbuttonbackgroundcolourdesc'] = 'Ορισμός του χρώματος υπόβαθρου για όλα τα προεπιλεγμένα πλήκτρα.';
$string['themedefaultbuttonbackgroundhovercolour'] = 'Προεπιλεγμένο χρώμα αιώρησης υπόβαθρου πλήκτρου';
$string['themedefaultbuttonbackgroundhovercolourdesc'] = 'Ορισμός του χρώματος κατάδειξης/αιώρησης υπόβαθρου για όλα τα προεπιλεγμένα κουμπιά.';
$string['themedefaultbuttontextcolour'] = 'Χρώμα κειμένου προεπιλεγμένου κουμπιού';
$string['themedefaultbuttontextcolourdesc'] = 'Ορισμός του χρώματος κειμένου για όλα τα προεπιλεγμένα κουμπιά.';
$string['themedefaultbuttontexthovercolour'] = 'Χρώμα κατάδειξης/αιώρησης κειμένου προεπιλεγμένου κουμπιού';
$string['themedefaultbuttontexthovercolourdesc'] = 'Ορισμός του χρώματος κατάδειξης/αιώρησης κειμένου για όλα τα προεπιλεγμένα κουμπιά.';
$string['themehovercolor'] = 'Χρώμα αιώρησης/κατάδειξης θέματος';
$string['themehovercolordesc'] = 'Τι χρώμα πρέπει να χρησιμοποιείται για την κατάδειξη στο θέμα σας. Χρησιμοποιείται για συνδέσμους, μενού κ.λπ.';
$string['themeiconcolor'] = 'Χρώμα εικονιδίου';
$string['themeiconcolordesc'] = 'Ορισμός του χρώματος για όλα τα εικονίδια.';
$string['themenavcolor'] = 'Χρώμα κειμένου πλοήγησης';
$string['themequizsubmitbackgroundcolour'] = 'Κουίζ «Υποβολή όλων και ολοκλήρωση» χρώμα φόντου';
$string['themequizsubmitbackgroundcolourdesc'] = 'Ορισμός του χρώματος υπόβαθρου για το κουίζ «Υποβολή όλων και ολοκλήρωση» κουμπί.';
$string['themequizsubmittextcolour'] = 'Χρώμα κειμένου πλήκτρου «Υποβολή όλων και ολοκλήρωση» κουίζ';
$string['themestripebackgroundcolour'] = 'Χρώμα υπόβαθρου ρίγας';
$string['themestripetextcolour'] = 'Χρώμα κειμένου ρίγας';
$string['themetextcolor'] = 'Χρώμα κειμένου';
$string['themetextcolordesc'] = 'Ορισμός του χρώματος για το κείμενό σας.';
$string['themeurlcolor'] = 'Χρώμα συνδέσμου';
$string['themeurlcolordesc'] = 'Ορισμός του χρώματος για το συνδεδεμένο κείμενό σας.';
$string['thiscourse'] = 'Αυτό το μάθημα';
$string['twitter'] = 'Twitter';
$string['twitterurl'] = 'Διεύθυνση URL στο Twitter';
$string['usermenu'] = 'Μενού Χρήστη';
$string['usermenudesc'] = 'Το μενού για τον χρήστη.';
$string['usermenuuserimageborderradius'] = 'Ακτίνα περιγράμματος εικόνας μενού χρήστη';
$string['usersettingstitle'] = 'Ρυθμίσεις χρήστη';
$string['usesiteicon'] = 'Χρήση εικονιδίου ιστοτόπου';
$string['variablewidth'] = 'Μεταβλητό πλάτος';
$string['versionalerttitle'] = 'Προειδοποίηση έκδοσης:';
$string['website'] = 'Ιστότοπος';
$string['websitedesc'] = 'Δώστε την διεύθυνση URL του δικού σας ιστοτόπου. (π.χ. http://about.me/gjbarnard)';
$string['websiteurl'] = 'Διεύθυνση URL ιστοτόπου';
$string['windows'] = 'Επιφάνεια εργασίας των Windows';
$string['windowsurl'] = 'Διεύθυνση URL Windows';
$string['winphone'] = 'Windows Mobile';
$string['winphoneurl'] = 'Windows Mobile URL';
$string['within'] = 'Εντός';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'Εισαγάγετε τη διεύθυνση URL του καναλιού σας στο YouTube. (δηλ. https://www.youtube.com/user/tosxoleiomou)';
$string['youtubeurl'] = 'Διεύθυνση URL στο YouTube';
