<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'el', version '5.1'.
 *
 * @package     theme_adaptable
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'Σχετικά με εμένα';
$string['actingasrole'] = 'Αυτή τη στιγμή ενεργείτε με διαφορετικό ρόλο';
$string['activatetemplateoverride'] = 'Ενεργοποίηση παράκαμψης υποδείγματος για «{$a}»';
$string['activatetemplateoverridedesc'] = 'Όταν επιλεγεί, τότε η τιμή στη ρύθμιση «{$a->setting}» θα χρησιμοποιηθεί ως το υπόδειγμα «{$a->template}» εάν περιέχει κείμενο.';
$string['activitiesheading'] = 'Δραστηριότητες';
$string['alertaccess'] = 'Ορατότητα επαγρύπνησης';
$string['alertaccessadmins'] = 'Ορατό σε διαχειριστές';
$string['alertaccessdesc'] = 'Ορίστε τον τύπο περιορισμού πρόσβασης για ορατότητα στο πλαίσιο επαγρύπνισης. Σημείωση: εάν χρησιμοποιείτε «Προσθήκη περιορισμού πεδίου προσαρμοσμένου προφίλ» θα χρειαστεί να προσθέσετε τιμές για τα πεδία προφίλ παρακάτω.';
$string['alertaccessglobal'] = 'Ορατό σε οποιονδήποτε';
$string['alertaccessprofile'] = 'Προσθήκη περιορισμού προσαρμοσμένου πεδίου προφίλ';
$string['alertaccessusers'] = 'Ορατό σε συνδεδεμένους χρήστες';
$string['alertannounce'] = 'Ανακοίνωση';
$string['alertannouncedesc'] = 'Εμφάνιση μιας ανακοίνωσης στο κουτί επαγρυπνήσεων.';
$string['alertbackgroundcolorinfo'] = 'Χρώμα υπόβαθρου πληροφοριών';
$string['alertbackgroundcolorinfodesc'] = 'Χρώμα υπόβαθρου των κουτιών επαγρυπνήσεων τύπου πληροφόρησης';
$string['alertbackgroundcolorsuccess'] = 'Χρώμα υπόβαθρου ανακοίνωσης';
$string['alertbackgroundcolorsuccessdesc'] = 'Χρώμα υπόβαθρου των κουτιών επαγρυπνήσεων τύπου ανακοίνωσης';
$string['alertbackgroundcolorwarning'] = 'Χρώμα υπόβαθρου προειδοποίησης';
$string['alertbackgroundcolorwarningdesc'] = 'Χρώμα υπόβαθρου των κουτιών επαγρύπνησης τύπου προειδοποίησης';
$string['alertbordercolorinfo'] = 'Χρώμα περιγράμματος πληροφοριών';
$string['alertbordercolorinfodesc'] = 'Χρώμα περιγράμματος των κουτιών επαγρύπνησης τύπου πληροφόρησης';
$string['alertbordercolorsuccess'] = 'Χρώμα περιγράμματος ανακοίνωσης';
$string['alertbordercolorsuccessdesc'] = 'Χρώμα περιγράμματος των κουτιών επαγρύπνησης τύπου ανακοίνωσης';
$string['alertbordercolorwarning'] = 'Χρώμα περιγράμματος προειδοποίησης';
$string['alertbordercolorwarningdesc'] = 'Χρώμα περιγράμματος των κουτιών επαγρύπνησης τύπου προειδοποίησης';
$string['alertcolorinfo'] = 'Χρώμα πληροφοριών';
$string['alertcolorinfodesc'] = 'Χρώμα εικονιδίου των κουτιών επαγρύπνησης τύπου πληροφόρησης';
$string['alertcolorsheading'] = 'Προσαρμογή των κουτιών επαγρύπνησης στην κορυφή';
$string['alertcolorsuccess'] = 'Χρώμα ανακοίνωσης';
$string['alertcolorsuccessdesc'] = 'Χρώμα εικονιδίου των κουτιών επαγρύπνησης τύπου ανακοίνωσης';
$string['alertcolorwarning'] = 'Χρώμα προειδοποίησης';
$string['alertcolorwarningdesc'] = 'Χρώμα εικονιδίου των κουτιών επαγρύπνησης τύπου ανακοίνωσης';
$string['alertcount'] = 'Πλήθος επαγρυπνήσεων';
$string['alertcountdesc'] = 'Ο αριθμός των επαγρυπνήσεων προς εμφάνιση στην περιοχή επεξεργασίας παρακάτω.';
$string['alertdesc'] = 'Εισαγάγετε και προσαρμόστε ένα κείμενο που θα εμφανίζεται στην κορυφή του ιστότοπου ως επαγρύπνιση. Είναι δυνατόν να ορίσετε περισσότερες από μία ειδοποιήσεις για στόχευση διαφορετικών τύπων χρηστών. Έχετε επίσης την επιλογή εμφάνισης επαγρυπνίσεων σε ιστοτόπους ή μόνο σε αρχικές σελίδες. <br /> <br /> <strong> Σημείωση: </strong> είναι επίσης δυνατή η εμφάνιση ειδοποιήσεων στις σελίδες των μαθημάτων για να προειδοποιήσετε τους εκπαιδευτικούς ότι τα μαθήματα είναι κρυμμένα';
$string['alertdisabled'] = 'Απενεργοποίηση';
$string['alertdisabledesc'] = 'Απενεργοποίηση αυτής της επαγρύπνησης.';
$string['alerthiddencourse'] = 'Ενεργοποίηση επαγρυπνήσεων μαθημάτων';
$string['alerthiddencoursedesc'] = 'Εμφάνιση επαγρύπνησης σε σελίδα μαθήματος αν είναι σε απόκρυψη';
$string['alerticoninfo'] = 'Εικονίδιο πληροφοριών';
$string['alerticoninfodesc'] = 'Ορίστε το «<a href="http://fortawesome.github.io/Font-Awesome/icons/">Εικονίδιο γραμματοσειράς Awesome</a>» για χρήση στα πλαίσια επαγρύπνισης τύπου πληροφοριών. Εισαγάγετε το όνομα εικονιδίου χωρίς το πρόθεμα fa-.';
$string['alerticonsuccess'] = 'Εικονίδιο ανακοίνωσης';
$string['alerticonsuccessdesc'] = 'Ορίστε το «<a href="http://fortawesome.github.io/Font-Awesome/icons/">Εικονίδιο γραμματοσειράς Awesome</a>» για χρήση στα πλαίσια επαγρύπνισης τύπου ανακοίνωσης. Εισαγάγετε το όνομα εικονιδίου χωρίς το πρόθεμα fa-.';
$string['alerticonwarning'] = 'Εικονίδιο προειδοποίησης';
$string['alerticonwarningdesc'] = 'Ορίστε το «<a href="http://fortawesome.github.io/Font-Awesome/icons/">Εικονίδιο γραμματοσειράς Awesome</a>» για χρήση στα πλαίσια επαγρύπνισης τύπου προειδοποίησης. Εισαγάγετε το όνομα εικονιδίου χωρίς το πρόθεμα fa-.';
$string['alertinfo'] = 'Πληροφορίες';
$string['alertinfodesc'] = 'Εμφάνιση πληροφοριών στο κουτί επαγρυπνήσεων.';
$string['alertkeyvalue'] = 'Κλειδί επαγρύπνησης';
$string['alertkeyvalue_details'] = 'Το κλειδί που προσδιορίζει αυτήν την επαγρύπνηση, από προηγούμενες επαγρυπνήσεις. Εάν το αλλάξετε, όλοι οι χρήστες που έχουν απορρίψει την επαγρύπνηση στο παρελθόν θα τη δουν ξανά. Εάν αλλάξετε την επαγρύπνηση, πιθανότατα θα θέλετε να το αλλάξετε για να διασφαλίσετε ότι όλοι οι χρήστες θα την δουν.';
$string['alertprofilefield'] = 'Όνομα προσαρμοσμένου πεδίου προφίλ=Τιμή (προαιρετικά)';
$string['alertprofilefielddesc'] = 'Προσθέστε κανόνα πρόσβασης χρησιμοποιώντας ως προσαρμοσμένο πεδίο προφίλ, π.χ.: usertype=student.';
$string['alertsettings'] = 'Κουτί επαγρύπνησης {$a}';
$string['alertsettingscourse'] = 'Ρυθμίσεις επαγρύπνησης μαθήματος';
$string['alertsettingsgeneral'] = 'Γενικές ρυθμίσεις επαγρύπνησης';
$string['alertsettingsheading'] = 'Προσαρμογή του κουτιού επαγρύπνησης στην κορυφή. Δείτε τη διάταξη <a href="./../theme/adaptable/pix/layout.png" target="_blank">εδώ</a>';
$string['alerttext'] = 'Κείμενο επαγρύπνησης';
$string['alerttextdesc'] = 'Δώστε το κείμενο προς εμφάνιση στο κουτί επαγρυπνήσεων';
$string['alerttype'] = 'Τύπος κουτιού επαγρύπνησης';
$string['alerttypedesc'] = 'Επιλέξτε τον τύπο επαγρύπνησης: πληροφορίες (μπλε), προειδοποίηση (κίτρινο) ή ανακοίνωση (πράσινο).';
$string['alertwarning'] = 'Προειδοποίηση';
$string['alertwarningdesc'] = 'Εμφάνιση μιας προειδοποίησης στο κουτί επαγρυπνήσεων.';
$string['analyticscount'] = 'Πλήθος αναλυτικών';
$string['analyticscountdesc'] = 'Ο αριθμός των πεδίων αναλυτικής που θα εμφανίζονται στην περιοχή επεξεργασίας παρακάτω.';
$string['analyticsprofilefield'] = 'Όνομα προσαρμοσμένου πεδίου προφίλ=Τιμή (προαιρετικά)';
$string['analyticsprofilefielddesc'] = 'Προσθέστε κανόνα πρόσβασης χρησιμοποιώντας ως προσαρμοσμένο πεδίο προφίλ, π.χ.: usertype=student.';
$string['analyticssettings'] = 'Αναλυτική';
$string['analyticssettingsdesc'] = 'Μπορείτε να ρυθμίσετε πολλούς κωδικούς για τo Google Analytics και να τους στοχεύσετε σε πεδία προφίλ χρήστη. Ή μπορείτε να χρησιμοποιήσετε το Matomo, την Αναλυτική ανοικτού κώδικα.';
$string['analyticssettingsheading'] = 'Ρυθμίστε τo Google Analytics και/ή το Matomo';
$string['analyticstext'] = 'Αναγνωριστικό Αναλυτικής';
$string['analyticstextdesc'] = 'Δώστε αναγνωριστικό Google Analytics';
$string['anonymizega'] = 'Ανωνυμοποίηση της IP διεύθυνσης του χρήστη';
$string['anonymizegadesc'] = 'Ανωνυμοποίηση της διεύθυνσης IP του χρήστη που αποστέλλεται στo Google Analytics';
$string['bcustyle'] = 'Στυλ BCU';
$string['blockbackgroundcolor'] = 'Χρώμα υπόβαθρου μπλοκ';
$string['blockbackgroundcolordesc'] = 'Ορισμός χρώματος υπόβαθρου για όλα τα μπλοκ.';
$string['blockbordercolor'] = 'Χρώμα περιγράμματος μπλοκ';
$string['blockbordercolordesc'] = 'Ορισμός χρώματος περιγράμματος μπλοκ';
$string['blockheaderbackgroundcolor'] = 'Χρώμα υπόβαθρου επικεφαλίδας μπλοκ';
$string['blockheaderbackgroundcolordesc'] = 'Ορίστε το χρώμα υπόβαθρου επικεφαλίδας για όλα τα μπλοκ.';
$string['blockheaderborderbottom'] = 'Πάχος περιθωρίου κάτω κεφαλίδας μπλοκ';
$string['blockheaderborderbottomdesc'] = 'Ορίστε το πάχος του κάτω περιγράμματος των επικεφαλίδων μπλοκ.';
$string['blockheaderborderleft'] = 'Πάχος περιθωρίου αριστερής κεφαλίδας μπλοκ';
$string['blockheaderborderleftdesc'] = 'Ορίστε το πάχος του αριστερού περιγράμματος των επικεφαλίδων μπλοκ.';
$string['blockheaderborderright'] = 'Πάχος περιθωρίου δεξιάς κεφαλίδας μπλοκ';
$string['blockheaderborderrightdesc'] = 'Ορίστε το πάχος του δεξιού περιγράμματος των επικεφαλίδων μπλοκ.';
$string['blockheaderbordertop'] = 'Πάχος περιθωρίου πάνω κεφαλίδας μπλοκ';
$string['blockheaderbordertopdesc'] = 'Ορίστε το πάχος του πάνω περιγράμματος των επικεφαλίδων μπλοκ.';
$string['blockheaderbordertopstyle'] = 'Στυλ περιγράμματος επικεφαλίδας μπλοκ';
$string['blockheaderbordertopstyledesc'] = 'Ορίστε το στυλ του περιγράμματος των επικεφαλίδων μπλοκ.';
$string['blockheaderbottomradius'] = 'Ακτίνα κάτω επικεφαλίδας μπλοκ';
$string['blockheaderbottomradiusdesc'] = 'Ορίστε την ακτίνα του κάτω μπλοκ κεφαλίδας για να επιτύχετε ένα καμπύλο / στρογγυλεμένο αποτέλεσμα.';
$string['blockheadercolor'] = 'Χρώμα γραμματοσειράς επικεφαλίδας μπλοκ';
$string['blockheadercolordesc'] = 'Ορισμός του χρώματος γραμματοσειράς της επικεφαλίδας του μπλοκ.';
$string['blockheadertopradius'] = 'Ακτίνα πάνω επικεφαλίδας μπλοκ';
$string['blockheadertopradiusdesc'] = 'Ορίστε την ακτίνα του πάνω μπλοκ κεφαλίδας για να επιτύχετε ένα καμπύλο / στρογγυλεμένο αποτέλεσμα.';
$string['blockicons'] = 'Εικονίδια μπλοκ';
$string['blockiconsdesc'] = 'Ορίστε αυτό για να εμφανίσετε εικονίδια μπλοκ στην περιοχή κεφαλίδας μπλοκ.';
$string['blockiconsheadersize'] = 'Μέγεθος εικονιδίου κεφαλίδας μπλοκ';
$string['blockiconsheadersizedesc'] = 'Ορίστε το μέγεθος του εικονιδίου γραμματοσειράς που χρησιμοποιείται στην κεφαλίδα των μπλοκ του Moodle. Επιλέξτε μια τιμή από τη λίστα.';
$string['blocklayoutbuilder'] = 'Περιοχές μπλοκ πρώτης σελίδας';
$string['blocklayoutbuilderdesc'] = 'Παρακάτω μπορείτε να δημιουργήσετε τη δική σας διάταξη για τις περιοχές μπλοκ στην πρώτη σελίδα.<br/>Για να προσθέσετε περιεχόμενο σε αυτές τις περιοχές, θα χρειαστεί να <strong>ενεργοποιήσετε την επεξεργασία στην πρώτη σελίδα του Moodle</strong>.<br/>Στη συνέχεια, μπορείτε να αρχίσετε να μεταφέρετε/αποθέσετε μπλοκ στις περιοχές που δημιουργείτε!';
$string['blocklayoutlayoutcheck'] = 'Έλεγχος διάταξης';
$string['blocklayoutlayoutcheckdesc'] = 'Χρησιμοποιήστε το παρακάτω εργαλείο για να ελέγξετε τον αριθμό των μπλοκ που έχετε χρησιμοποιήσει και να δείτε μια αναπαράσταση της νέας σας διάταξης.';
$string['blocklayoutlayoutcount1'] = 'Μπορείτε να ορίσετε ένα μέγιστο ίσο με';
$string['blocklayoutlayoutcount2'] = 'περιοχές μπλοκ. Αυτήν τη στιγμή χρησιμοποιείτε:';
$string['blocklayoutlayoutrow'] = 'Γραμμή περιοχών μπλοκ';
$string['blocklayoutlayoutrowdesc'] = 'Προσθήκη / ορισμός διάταξης για γραμμή περιοχών μπλοκ στην πρώτη σελίδα.';
$string['blockmainborderbottom'] = 'Πάχος κάτω περιγράμματος κύριου μπλοκ';
$string['blockmainborderbottomdesc'] = 'Ορίστε το πάχος του κάτω περιγράμματος της κύριας περιοχής μπλοκ.';
$string['blockmainborderleft'] = 'Πάχος αριστερού περιγράμματος κύριου μπλοκ';
$string['blockmainborderleftdesc'] = 'Ορίστε το πάχος του αριστερού περιγράμματος της κύριας περιοχής μπλοκ.';
$string['blockmainborderright'] = 'Πάχος δεξιού περιγράμματος κύριου μπλοκ';
$string['blockmainborderrightdesc'] = 'Ορίστε το πάχος του δεξιού περιγράμματος της κύριας περιοχής μπλοκ.';
$string['blockmainbordertop'] = 'Πάχος πάνω περιγράμματος κύριου μπλοκ';
$string['blockmainbordertopdesc'] = 'Ορίστε το πάχος του πάνω περιγράμματος της κύριας περιοχής μπλοκ.';
$string['blockmainbordertopstyle'] = 'Στυλ κύριου περιγράμματος μπλοκ';
$string['blockmainbordertopstyledesc'] = 'Ορίστε το στυλ του περιγράμματος της περιοχής περιεχομένου μπλοκ.';
$string['blockmainbottomradius'] = 'Κάτω ακτίνα κύριου μπλοκ';
$string['blockmainbottomradiusdesc'] = 'Ορίστε την κάτω ακτίνα της κύριας περιοχής μπλοκ για να επιτύχετε ένα καμπύλο / στρογγυλεμένο αποτέλεσμα.';
$string['blockmaintopradius'] = 'Πάνω ακτίνα κύριου μπλοκ';
$string['blockmaintopradiusdesc'] = 'Ορίστε την πάνω ακτίνα της κύριας περιοχής μπλοκ για να επιτύχετε ένα καμπύλο / στρογγυλεμένο αποτέλεσμα.';
$string['blockregionbackground'] = 'Χρώμα υπόβαθρου περιοχής μπλοκ';
$string['blockregionbackgrounddesc'] = 'Χρώμα υπόβαθρου του περιέκτη που περιέχει προσαρμοσμένες διατάξεις μπλοκ στην πρώτη σελίδα.';
$string['blockside'] = 'Τοποθεσία των μπλοκ';
$string['blocksidedesc'] = 'Καθορίζει εάν τα μπλοκ θα εμφανίζονται αριστερά ή δεξιά της σελίδας.';
$string['breadcrumb'] = 'Δυναμικό μονοπάτι';
$string['breadcrumbbackgroundcolor'] = 'Χρώμα υπόβαθρου δυναμικού μονοπατιού';
$string['breadcrumbbackgroundcolordesc'] = 'Ορισμός του χρώματος υπόβαθρου του δυναμικού μονοπατιού (μπάρας πλοήγησης).';
$string['breadcrumbdisplay'] = 'Εμφάνιση δυναμικού μονοπατιού';
$string['breadcrumbdisplaydesc'] = 'Ορισμός της εμφάνισης του τι θα πρέπει να βρίσκεται στην περιοχή δυναμικού μονοπατιού (μπάρας πλοήγησης) σε ένα μάθημα.';
$string['breadcrumbhome'] = 'Αρχική σελίδα δυναμικού μονοπατιού';
$string['breadcrumbhomedesc'] = 'Εμφάνιση δυναμικού μονοπατιού (μπάρας πλοήγησης) αρχικής σελίδας ως εικονίδιο ή ως κείμενο.';
$string['breadcrumbhomeicon'] = 'Εικονίδιο';
$string['breadcrumbhometext'] = 'Κείμενο';
$string['breadcrumbseparator'] = 'Διαχωριστικό του δυναμικού μονοπατιού (μπάρας πλοήγησης)';
$string['breadcrumbseparatordesc'] = 'Ορίστε το <a href="https://fortawesome.github.io/Font-Awesome/icons/" target="_blank">Εικονίδιο Γραμματοσειράς Awesome</a> για να χρησιμοποιείται ως διαχωριστικό στοιχείων στο δυναμικό μονοπάτι (breadcrumb). Εισαγάγετε το όνομα του εικονιδίου χωρίς το πρόθεμα fa-.';
$string['breadcrumbtextcolor'] = 'Χρώμα κειμένου του δυναμικού μονοπατιού (μπάρας πλοήγησης)';
$string['breadcrumbtextcolordesc'] = 'Ορισμός του χρώματος κειμένου του δυναμικού μονοπατιού (μπάρας πλοήγησης).';
$string['breadcrumbtitle'] = 'Όνομα μαθήματος του δυναμικού μονοπατιού (μπάρας πλοήγησης)';
$string['breadcrumbtitledesc'] = 'Ορισμός της κατάστασης λειτουργίας εμφάνισης του τίτλου του μαθήματος στο δυναμικό μονοπάτι (μπάρας πλοήγησης).';
$string['bs4all'] = 'Πολύ μικρό - Πολύ μεγάλο';
$string['bs4extralarge'] = 'Μόνο πολύ μεγάλο';
$string['bs4large'] = 'Μεγάλο - Πολύ μεγάλο';
$string['bs4medium'] = 'Μεσαίο - Πολύ μεγάλο';
$string['bs4none'] = 'Κανένα';
$string['bs4small'] = 'Μικρό - Πολύ μεγάλο';
$string['buttoncolor'] = 'Χρώμα πλήκτρου';
$string['buttoncolorcancel'] = 'Χρώμα πλήκτρου ακύρωσης';
$string['buttoncolordesc'] = 'Το χρώμα των κύριων πλήκτρων που χρησιμοποιούνται σε όλο τον ιστότοπο.';
$string['buttoncolordesccancel'] = 'Χρώμα υπόβαθρου για το πλήκτρο ακύρωσης.<br />Πληκτρολογήστε transparent στο πλαίσιο για διαφάνεια.';
$string['buttoncolordescscnd'] = 'Το χρώμα των δευτερευόντων πλήκτρων που χρησιμοποιούνται σε ολόκληρο τον ιστότοπο.';
$string['buttoncolorscnd'] = 'Χρώμα δευτερεύοντος πλήκτρου';
$string['buttondesc'] = 'Μεταβολή της εμφάνισης των κουμπιών που χρησιμοποιούνται σε αυτό το αισθητικό θέμα.';
$string['buttondropshadow'] = 'Να πέφτει μια διακοσμητική σκιά στη βάση του πλήκτρου';
$string['buttondropshadowdesc'] = 'Εμφάνιση της διακοσμητικής σκιάς (σκίασης) στη βάση του πλήκτρου.';
$string['buttonhovercolor'] = 'Χρώμα πλήκτρου (κατά την αιώρηση)';
$string['buttonhovercolorcancel'] = 'Χρώμα πλήκτρου ακύρωσης (κατά την αιώρηση)';
$string['buttonhovercolordesc'] = 'Το χρώμα το οποίο παίρνει το πλήκτρο όταν το βελάκι του ποντικιού περνάει (αιωρείται) πάνω από το πλήκτρο.';
$string['buttonhovercolordesccancel'] = 'Το χρώμα το οποίο παίρνει το πλήκτρο ακύρωσης όταν το βελάκι του ποντικιού περνάει (αιωρείται) πάνω από το πλήκτρο. <br />Πληκτρολογήστε transparent στο πλαίσιο για διαφάνεια.';
$string['buttonhovercolordescscnd'] = 'Το χρώμα στο οποίο αλλάζει το δευτερεύον κουμπί κατά την αιώρηση πάνω από το κουμπί.';
$string['buttonhovercolorscnd'] = 'Χρώμα κατά την αιώρηση στο δευτερεύον κουμπί';
$string['buttonlogincolor'] = 'Χρώμα πλήκτρου σύνδεσης';
$string['buttonlogincolordesc'] = 'Το χρώμα του πλήκτρου σύνδεσης.';
$string['buttonloginheight'] = 'Ορίστε το ύψος για το κουμπί σύνδεσης';
$string['buttonloginheightdesc'] = 'Ισχύει μόνο εάν χρησιμοποιείτε μια φόρμα σύνδεσης στην επάνω κεφαλίδα.';
$string['buttonloginhovercolor'] = 'Χρώμα κατά την αιώρηση πάνω από το κουμπί σύνδεσης';
$string['buttonloginhovercolordesc'] = 'Το χρώμα του κουμπιού σύνδεσης κατά την αιώρηση του ποντικιού πάνω του.';
$string['buttonloginmargintop'] = 'Ορίστε το επάνω περιθώριο για το κουμπί σύνδεσης';
$string['buttonloginmargintopdesc'] = 'Επιτρέπει την αλλαγή διαστημάτων / θέσης του κουμπιού σύνδεσης.';
$string['buttonloginpadding'] = 'Ορισμός της αναπλήρωσης κελιών (padding) για το κουμπί σύνδεσης';
$string['buttonloginpaddingdesc'] = 'Μεγαλύτερος αριθμός = μεγαλύτερο κουμπί.';
$string['buttonlogintextcolor'] = 'Χρώμα κειμένου κουμπιού σύνδεσης';
$string['buttonlogintextcolordesc'] = 'Το χρώμα του κειμένου που χρησιμοποιείται στο κουμπί σύνδεσης.';
$string['buttonradius'] = 'Ορισμός της ακτίνας του κουμπιού';
$string['buttonradiusdesc'] = 'Μεγαλύτερη ακτίνα = καμπύλα κουμπιά, μικρότερη ακτίνα = τετράγωνα κουμπιά.';
$string['buttonsettings'] = 'Πλήκτρα';
$string['buttonsettingsheading'] = 'Προσαρμογή των πλήκτρων αυτού του αισθητικού θέματος.';
$string['buttontextcolor'] = 'Χρώμα κειμένου πλήκτρου';
$string['buttontextcolorcancel'] = 'Χρώμα κειμένου κουμπιού Ακύρωσης';
$string['buttontextcolordesc'] = 'Το χρώμα του κειμένου που χρησιμοποιείται στα πλήκτρα.';
$string['buttontextcolordesccancel'] = 'Το χρώμα του κειμένου που χρησιμοποιείται στα κουμπιά ακύρωσης.';
$string['buttontextcolordescscnd'] = 'Το χρώμα του κειμένου που χρησιμοποιείται σε δευτερεύοντα κουμπιά.';
$string['buttontextcolorscnd'] = 'Χρώμα κειμένου δευτερεύοντος κουμπιού';
$string['categoryhavecustomheader'] = 'Προσαρμοσμένη κεφαλίδα κατηγορίας';
$string['categoryhavecustomheaderdesc'] = 'Επιλέξτε τις κατηγορίες ανώτατου επιπέδου που θα έχουν προσαρμοσμένη κεφαλίδα. Για να επιλέξετε περισσότερες από μία ή να αποεπιλέξετε μια κατηγορία, χρησιμοποιήστε το πλήκτρο «Ctrl». Αποθηκεύστε και ανανεώστε τη σελίδα για ενημέρωση Σημείωση: Οι υποκατηγορίες των επιλεγμένων θα κληρονομήσουν τις τιμές ρύθμισης.';
$string['categoryheaderbgimage'] = 'Εικόνα υπόβαθρου κατηγορίας  «{$a->name}» με αναγνωριστικό «{$a->id}»';
$string['categoryheaderbgimagedesc'] = 'Ορίστε μια εικόνα υπόβαθρου για την κατηγορία ανώτατου επιπέδου «{$a->name}» με αναγνωριστικό «{$a->id}» στην κεφαλίδα. Το ελάχιστο μέγεθος είναι 1600x180 εικονοστοιχεία (συνιστάται 1900x180 εικονοστοιχεία). Η εικόνα θα καλύψει την πλήρη κεφαλίδα.';
$string['categoryheaderbgimagedescchildren'] = 'Ορίστε μια εικόνα υπόβαθρου για την κατηγορία ανώτατου επιπέδου «{$a->name}» με αναγνωριστικό «{$a->id}» και τις υπο-κατηγορίες της «{$a->children}» στην κεφαλίδα. Το ελάχιστο μέγεθος είναι 1600x180 εικονοστοιχεία (συνιστάται 1900x180 εικονοστοιχεία). Η εικόνα θα καλύψει την πλήρη κεφαλίδα.';
$string['categoryheadercustomcss'] = 'Προσαρμοσμένο CSS κατηγορίας  «{$a->name}» με αναγνωριστικό «{$a->id}»';
$string['categoryheadercustomcssdesc'] = 'Ορίστε προσαρμοσμένο CSS για την κατηγορία ανώτατου επιπέδου «{$a->name}» με αναγνωριστικό «{$a->id}». Αυτό θα δημιουργήσει CSS για τον επιλογέα θέματος με πρόθεμα «.category-{$a->id}». Εάν το CSS δεν φαίνεται να εφαρμόζεται, τότε ελέγξτε το αρχείο καταγραφών PHP.';
$string['categoryheadercustomtitle'] = 'Προσαρμοσμένος τίτλος κατηγορίας  «{$a->name}» με αναγνωριστικό «{$a->id}»';
$string['categoryheaderheader'] = 'Ρυθμίσεις για την ανωτάτου επιπέδου κατηγορία «{$a->name}» με αναγνωριστικό «{$a->id}»';
$string['categoryheaderheaderdesc'] = 'Ορισμός των ρυθμίσεων για την κατηγορία ανωτάτου επιπέδου «{$a->name}» με αναγνωριστικό «{$a->id}»';
$string['categoryheaderheaderdescchildren'] = 'Ορίστε τις ρυθμίσεις για την κατηγορία ανώτατου επιπέδου «{$a->name}» με αναγνωριστικό «{$a->id}» και τις υπο-κατηγορίες της «{$a->children}».';
$string['categoryheaderlogo'] = 'Κατηγορία «{$a->name}» με αναγνωριστικό «{$a->id}»';
$string['categoryheaderlogodesc'] = 'Ορίστε ένα λογότυπο για την κατηγορία ανώτατου επιπέδου «{$a->name}» με αναγνωριστικό «{$a->id}» στην κεφαλίδα. Το συνιστώμενο μέγεθος είναι 200 εικονοστοιχεία επί 80 εικονοστοιχεία.';
$string['categoryheaderlogodescchildren'] = 'Ορίστε ένα λογότυπο για την κατηγορία ανώτατου επιπέδου «{$a->name}» με αναγνωριστικό «{$a->id}» και τις υπο-κατηγορίες της «{$a->Children}» στην κεφαλίδα. Το συνιστώμενο μέγεθος είναι 200 εικονοστοιχεία επί 80 εικονοστοιχεία.';
$string['categoryheaderssettings'] = 'Επικεφαλίδες κατηγορίας';
$string['categoryheaderssettingsdesc'] = 'Ορίστε τις ρυθμίσεις για τις κεφαλίδες σε μια κατηγορία.';
$string['categoryheaderssettingsheading'] = 'Αλλάξτε την κεφαλίδα για μία ή περισσότερες κατηγορίες ανώτατου επιπέδου και παρακάτω.';
$string['cdefaulticon'] = 'Το προεπιλεγμένο εικονίδιο των μαθημάτων μου';
$string['cfrozenicon'] = 'Παγωμένο εικονίδιο των μαθημάτων μου';
$string['chiddenicon'] = 'Κρυφό εικονίδιο των μαθημάτων μου';
$string['cneveraccessedicon'] = 'Το εικονίδιο των μαθημάτων μου στα οποία δεν έγινε πρόσβαση ποτέ';
$string['collapsedtopicscoloursenabled'] = 'Εναλλαγή ρυθμίσεων χρώματος προσκηνίου και υπόβαθρου Συμπτυγμένων Θεμάτων';
$string['colordesc'] = 'Μπορείτε να επιλέξετε τα χρώματα που θέλετε να χρησιμοποιήσετε σε όλο το αισθητικό θέμα. Χρησιμοποιήστε το Hex ή οποιαδήποτε άλλη τυπική σημειογραφία. Ως εναλλακτική επιλογή μπορείτε να χρησιμοποιήσετε διαφανές και κληρονομημένο ως τιμή';
$string['colorsettings'] = 'Χρώματα';
$string['colorsettingsheading'] = 'Τροποποίηση των κύριων χρωμάτων που χρησιμοποιούνται σε όλο το αισθητικό θέμα.';
$string['configtabtitle'] = 'Ρυθμίσεις';
$string['configtitle'] = 'Προσαρμόσιμο';
$string['coursepageactivitybottomblockregionheading'] = 'Προσαρμοσμένη περιοχή κατώτατου μπλοκ δραστηριότητας μαθήματος';
$string['coursepageactivitybottomblockregionheadingdesc'] = 'Μια προσαρμοσμένη περιοχή μπλοκ που εμφανίζεται μετά το τέλος των δραστηριοτήτων.';
$string['coursepageblockactivitybottomenabled'] = 'Ενεργοποίηση περιοχής μπλοκ δραστηριότητας μαθημάτων στη σελίδα μαθημάτων';
$string['coursepageblockactivitybottomenableddesc'] = 'Ενεργοποίηση αυτής της περιοχής σε όλες τις σελίδες των μαθημάτων.';
$string['coursepageblocklayoutbuilder'] = 'Περιοχές μπλοκ σελίδων μαθήματος';
$string['coursesectionactivityheadingcolour'] = 'Χρώμα επικεφαλίδας δραστηριότητας ενότητας μαθήματος';
$string['coursesectionactivityheadingcolourdesc'] = 'Το χρώμα για δραστηριότητες με δυνατότητα κλικ που εμφανίζονται στην αρχική σελίδα του μαθήματος.';
$string['coursesectionactivityiconsize'] = 'Μέγεθος εικονιδίου δραστηριότητας ενότητας μαθήματος';
$string['coursesectionactivityiconsizedesc'] = 'Ορισμός του μεγέθους του εικονιδίου για δραστηριότητες / πόρους (π.χ. μια τιμή 16εικονοστοιχεία θα το ορίσει στα 16εικονοστοιχεία επί 16εικονοστοιχεία).';
$string['coursesectionactivityleftborderwidth'] = 'Πλάτος αριστερού περιγράμματος δραστηριότητας ενότητας μαθημάτων';
$string['coursesectionactivityleftborderwidthdesc'] = 'Ορισμός του πλάτους του περιγράμματος που εμφανίζεται στα αριστερά μιας δραστηριότητας ενότητας μαθημάτων.';
$string['coursesectionactivitymarginbottom'] = 'Ελάχιστη απόσταση/περιθώριο δραστηριοτήτων';
$string['coursesectionactivitymarginbottomdesc'] = 'Ελάχιστη απόσταση/περιθώριο μεταξύ των δραστηριοτήτων.';
$string['coursesectionactivitymargintop'] = 'Μέγιστη απόσταση/περιθώριο δραστηριοτήτων';
$string['coursesectionactivitymargintopdesc'] = 'Μέγιστη απόσταση/περιθώριο μεταξύ των δραστηριοτήτων.';
$string['coursesectionactivityquizbgcolor'] = 'Χρώμα υπόβαθρου δραστηριότητας κουίζ';
$string['coursesectionactivityquizbgcolordesc'] = 'Ορισμός του χρώματος υπόβαθρου δραστηριότητας κουίζ. Πληκτρολογήστε <strong>transparent/διαφανές</strong> στο πλαίσιο για διαφάνεια.';
$string['coursesectionactivityquizleftbordercolor'] = 'Χρώμα εμφάνισης αριστερού περιγράμματος δραστηριότητας κουίζ';
$string['coursesectionactivityquizleftbordercolordesc'] = 'Ορισμός του χρώματος του αριστερού περιγράμματος.';
$string['coursesectionbgcolor'] = 'Υπόβαθρο ενότητας μαθήματος';
$string['coursesectionbgcolordesc'] = 'Ορισμός του χρώματος υπόβαθρου της ενότητας μαθημάτων.';
$string['coursesectionbordercolor'] = 'Χρώμα περιγράμματος ενότητας μαθήματος';
$string['coursesectionbordercolordesc'] = 'Ορισμός του χρώματος περιγράμματος ενότητας μαθημάτων.';
$string['coursesectionborderradius'] = 'Ακτίνα περιγράμματος ενότητας μαθήματος';
$string['coursesectionborderradiusdesc'] = 'Ορισμός της ακτίνας του περιγράμματος ενότητας μαθήματος (στρογγυλεμένες γωνίες).';
$string['coursesectionborderstyle'] = 'Στυλ περιγράμματος ενότητας μαθήματος';
$string['coursesectionborderstyledesc'] = 'Ορισμός του στυλ περιγράμματος των ενοτήτων μαθημάτων.';
$string['coursesectionborderwidth'] = 'Πλάτος περιγράμματος ενότητας μαθήματος';
$string['coursesectionborderwidthdesc'] = 'Ορισμός του πλάτους των περιθωρίων της ενότητας μαθήματος.';
$string['coursesectionheaderbg'] = 'Υπόβαθρο κεφαλίδας ενότητας μαθήματος';
$string['coursesectionheaderbgdesc'] = 'Ορισμός του χρώματος υπόβαθρου των κεφαλίδων ενότητας μαθήματος.';
$string['coursesectionheaderbordercolor'] = 'Χρώμα περιγράμματος κεφαλίδας ενότητας μαθήματος';
$string['coursesectionheaderbordercolordesc'] = 'Ορισμός του χρώματος του περιγράμματος κεφαλίδας ενότητας μαθήματος (μόνο το κάτω περίγραμμα χρησιμοποιείται καθώς ο εξωτερικός περιέκτης έχει επίσης περίγραμμα).';
$string['coursesectionheaderborderradiusbottom'] = 'Κάτω ακτίνα περιγράμματος ενότητας κεφαλίδας μαθήματος';
$string['coursesectionheaderborderradiusbottomdesc'] = 'Ορισμός της κάτω ακτίνας των περιγραμμάτων κεφαλίδας ενότητας μαθήματος (στρογγυλεμένες γωνίες).';
$string['coursesectionheaderborderstyle'] = 'Στυλ περιγράμματος επικεφαλίδας ενότητας μαθήματος';
$string['coursesectionheaderborderwidth'] = 'Πλάτος περιγράμματος επικεφαλίδας ενότητας μαθήματος';
$string['coursesections'] = 'Ενότητες μαθήματος';
$string['coursesettings'] = 'Μορφότυποι μαθήματος';
$string['coursesettingsheading'] = 'Ρυθμίσεις μορφότυπου μαθήματος';
$string['coursetitlefullname'] = 'Πλήρες όνομα μαθήματος';
$string['coursetitlemaxwidth'] = 'Μέγιστο μήκος τίτλου μαθήματος';
$string['coursetitleshortname'] = 'Σύντομο όνομα / κωδικός μαθήματος';
$string['customcoursesubtitle'] = 'Προσαρμοσμένος τίτλος μαθήματος';
$string['customcoursetitle'] = 'Προσαρμοσμένος τίτλος μαθήματος';
$string['customcss'] = 'Προσαρμοσμένο CSS';
$string['customcssdesc'] = 'Οποιουσδήποτε κανόνες CSS προσθέτετε σε αυτή την περιοχή κειμένου, θα αντικατοπτρίζονται σε κάθε σελίδα, διευκολύνοντας έτσι την προσαρμογή αυτού του αισθητικού θέματος.';
$string['dashblocklayoutbuilder'] = 'Περιοχές Μπλοκ Ταμπλό';
$string['dashblocklayoutbuilderdesc'] = 'Παρακάτω μπορείτε να δημιουργήσετε τη δική σας διάταξη για τις περιοχές μπλοκ στη σελίδα του Ταμπλό.<br/>Για να προσθέσετε περιεχόμενο σε αυτές τις περιοχές, θα χρειαστεί να <strong>ενεργοποιήσετε την επεξεργασία, στη σελίδα του ταμπλό του Moodle</strong>.<br/>Στη συνέχεια, μπορείτε να αρχίσετε να μεταφέρετε/αποθέσετε μπλοκ στις περιοχές που δημιουργείτε!';
$string['dashblocklayoutlayoutrow'] = 'Γραμμή Περιοχής Μπλοκ Ταμπλό';
$string['dashblocklayoutlayoutrowdesc'] = 'Προσθήκη / ορισμός διάταξης για τη γραμμή περιοχής μπλοκ στη σελίδα του Ταμπλό.';
$string['dashblocksabovecontent'] = 'Εμφάνιση πάνω από το κύριο περιεχόμενο';
$string['dashblocksbelowcontent'] = 'Εμφάνιση κάτω από το κύριο περιεχόμενο';
$string['dashblocksenabled'] = 'Ενεργοποίηση προσαρμοσμένης περιοχής μπλοκ στη σελίδα του Ταμπλό';
$string['dashblocksenableddesc'] = 'Μπορείτε να ενεργοποιήσετε / απενεργοποιήσετε προσαρμοσμένες περιοχές μπλοκ στη σελίδα του Ταμπλό. Μπορείτε κατόπιν να μεταφέρετε και να αποθέσετε μπλοκ στις περιοχές που δημιουργήσατε.';
$string['dashboardblockregionsettings'] = 'Δόμηση Περιοχής Μπλοκ Ταμπλό';
$string['disabled'] = 'Ανενεργό';
$string['disablemenuscoursepagesdesc'] = 'Η ενεργοποίηση αυτής της επιλογής θα περιορίσει την εμφάνιση των μενού στο επάνω μέρος των σελίδων του ιστοτόπου, στην αρχική σελίδα και στο ταμπλό (Αρχική Σελίδα Μου) κλπ. και δεν θα εμφανίζονται σε οποιεσδήποτε σελίδες μαθημάτων.';
$string['discardbuttontext'] = 'Άκυρο';
$string['displaygrades'] = 'Εμφάνιση βαθμών';
$string['displaygradesdesc'] = 'Εμφάνιση του στοιχείου βαθμοί στο μενού.';
$string['displaylogin'] = 'Εμφάνιση σύνδεσης';
$string['displayloginbox'] = 'Κουτί σύνδεσης';
$string['displayloginbutton'] = 'Πλήκτρο';
$string['displaylogindesc'] = 'Επιλέξτε πως να εμφανίζεται το πλαίσιο σύνδεσης στην επικεφαλίδα.';
$string['displayloginno'] = 'Χωρίς πλαίσιο σύνδεσης';
$string['displayparticipants'] = 'Εμφάνιση συμμετεχόντων';
$string['displayparticipantsdesc'] = 'Εμφάνιση του στοιχείου συμμετέχοντες στο μενού.';
$string['emoticonsize'] = 'Μέγεθος φατσούλας';
$string['emoticonsizedesc'] = 'Ορισμός του ύψους και του πλάτους της φατσούλας Moodle.';
$string['enableaccesstool'] = 'προσβασιμότητας';
$string['enablealert'] = 'Ενεργοποίηση πλαισίου επαγρυπνήσεων {$a}';
$string['enablealertdesc'] = 'Ενεργοποίηση πλαισίου επαγρυπνήσεων {$a}';
$string['enablealerts'] = 'Ενεργοποίηση/Απενεργοποίηση επαγρυπνήσεων';
$string['enablealertsdesc'] = 'Ενεργοποίηση/απενεργοποίηση επαγρυπνήσεων. Όχι μαθήματος, δείτε την ρύθμιση «alerthiddencourse» στον ιστότοπό σας';
$string['enablealertstriptags'] = 'Αφαιρέστε αυτόματα τις ετικέτες html από τις επαγρυπνήσεις';
$string['enableanalytics'] = 'Ενεργοποίηση Google Analytics';
$string['enableanalyticsdesc'] = 'Ενεργοποίηση ρυθμίσεων Google Analytics στον ιστότοπό σας';
$string['enablebadges'] = 'Διακριτικά';
$string['enableblog'] = 'Ενεργοποίηση των ιστολογίων μου';
$string['enableblogdesc'] = 'Εμφάνισε ένα σύνδεσμο προς τη σελίδα ιστολογίων του χρήστη.';
$string['enablegrades'] = 'Βαθμοί';
$string['enablehomeredirectdesc'] = 'Ενεργοποίηση redirect=0 (όχι ανακατεύθυνση) στην αρχική σελίδα. Αυτό προορίζεται για χρήση σε ιστοτόπους όπου η Αρχική Σελίδα είναι η προεπιλεγμένη αρχική σελίδα. Αποτρέπει την ανακατεύθυνση των χρηστών που πατάνε στο σύνδεσμο «Αρχική Σελίδα» πίσω στην Αρχική Σελίδα / Ταμπλό.';
$string['enablemy'] = 'Ταμπλό';
$string['enablemydesc'] = 'Εμφάνιση ενός συνδέσμου στη σελίδα του Ταμπλό.';
$string['enablemysitesdesc'] = 'Εμφάνιση μιας πτυσσόμενης λίστας με τα μαθήματα ενός χρήστη';
$string['enablenote'] = 'Οι ειδοποιήσεις μου';
$string['enablenotedesc'] = 'Εμφάνιση ενός συνδέσμου προς την σελίδα ειδοποιήσεων χρήστη.';
$string['enableposts'] = 'Οι αναρτήσεις μου';
$string['enablepostsdesc'] = 'Εμφάνιση ενός συνδέσμου προς τη σελίδα των δικών μου αναρτήσεων χρήστη.';
$string['enablepref'] = 'Οι προτιμήσεις μου';
$string['enableprivatefiles'] = 'Ιδιωτικά αρχεία';
$string['enableprofile'] = 'Προφίλ χρήστη';
$string['enableprofiledesc'] = 'Εμφάνιση ενός συνδέσμου προς το προφίλ χρήστη.';
$string['enableshowhideblocks'] = 'Ενεργοποίηση Εμφάνιση/Απόκρυψη μπλοκ';
$string['enableshowhideblocksdesc'] = 'Επιτρέπει στους χρήστες να εμφανίζουν/αποκρύπτουν όλα τα μπλοκ.';
$string['enabletickermy'] = 'Ενεργοποίηση της στήλης ειδήσεων;';
$string['enabletickermydesc'] = 'Επιλέξτε για ενεργοποίηση της στήλης ειδήσεων στην Αρχική Σελίδα / Ταμπλό.';
$string['enablezoom'] = 'Ενεργοποίηση Μεγέθυνσης';
$string['events'] = 'Γεγονότα';
$string['expandable'] = 'Αναπτύξιμος';
$string['favicon'] = 'Αγαπ.εικονίδιο';
$string['favicondesc'] = 'Ανέβασμα αγαπ.εικονιδίου για χρήση στον ιστότοπό σας.';
$string['fontblockheadercolor'] = 'Χρώμα γραμματοσειράς επικεφαλίδας μπλοκ';
$string['fontblockheadercolordesc'] = 'Ορισμός του χρώματος των γραμματοσειρών μπλοκ επικεφαλίδων Moodle. Χρησιμοποιήστε δεκαεξαδικό κώδικα χρωμάτων HTML. Σημειώστε ότι αυτό επηρεάζει επίσης το χρώμα εικονιδίου.';
$string['fontblockheadersize'] = 'Μέγεθος γραμματοσειράς επικεφαλίδας μπλοκ';
$string['fontblockheaderweight'] = 'Βαρύτητα γραμματοσειράς επικεφαλίδας μπλοκ';
$string['fontheadercolor'] = 'Χρώμα γραμματοσειράς επικεφαλίδων';
$string['fontheadercolordesc'] = 'Ορισμός του χρώματος της γραμματοσειράς επικεφαλίδων στο αισθητικό θέμα. Χρησιμοποιήστε δεκαεξαδικό κώδικα χρωμάτων HTML.';
$string['fontheadername'] = 'Γραμματοσειρά επικεφαλίδων';
$string['fontname'] = 'Κύρια γραμματοσειρά';
$string['fontsettings'] = 'Γραμματοσειρές';
$string['fontsize'] = 'Μέγεθος κύριας γραμματοσειράς';
$string['fonttitlecolordesc'] = 'Ορισμός του χρώματος γραμματοσειράς του τίτλου ιστοτόπου και του τίτλου μαθήματος, στο αισθητικό θέμα. Χρησιμοποιήστε δεκαεξαδικό κώδικα χρωμάτων HTML.';
$string['fonttitlename'] = 'Γραμματοσειρά τίτλου ιστοτόπου/μαθήματος';
$string['fonttitlesize'] = 'Μέγεθος γραμματοσειράς τίτλου ιστοτόπου/μαθήματος';
$string['footerbkcolor'] = 'Χρώμα υπόβαθρου υποσέλιδου';
$string['footerbkcolordesc'] = 'Ορισμός του χρώματος υπόβαθρου υποσέλιδου';
$string['footerblocksplacement1'] = 'Σε όλο τον ιστότοπο';
$string['footerblocksplacement2'] = 'Μόνο αρχική σελίδα';
$string['footerblocksplacement3'] = 'Ποτέ';
$string['footercontent'] = 'Ενότητα περιεχομένου υποσέλιδου';
$string['footercontentdesc'] = 'Προσθήκη περιεχομένου στην ενότητα υποσέλιδου';
$string['footerdesc'] = 'Προσθήκη ενός τίτλου για την ενότητα υποσέλιδου';
$string['footerheader'] = 'Τίτλος ενότητας υποσέλιδου';
$string['footerlayoutrowdesc'] = 'Σχεδιάστε την διάταξή σας για περιοχές μπλοκ υποσέλιδου.';
$string['footerlinkcolor'] = 'Χρώμα συνδέσμου μπλοκ υποσέλιδου';
$string['footerlinkcolordesc'] = 'Χρώμα συνδέσμου μπλοκ υποσέλιδου.';
$string['footersettings'] = 'Υποσέλιδο';
$string['footertextcolor'] = 'Χρώμα κειμένου υποσέλιδου';
$string['footertextcolor2'] = 'Χρώμα κειμένου χαμηλότερου υποσέλιδου';
$string['footertextcolor2desc'] = 'Χρώμα κειμένου του χαμηλότερου υποσέλιδου';
$string['footertextcolordesc'] = 'Το χρώμα του κειμένου στο υποσέλιδο. Χρησιμοποιήστε δεκαεξαδικό κώδικα χρωμάτων HTML.';
$string['footnote'] = 'Υποσημείωση';
$string['footnotedesc'] = 'Προσθήκη κειμένου στο υποσέλιδο.';
$string['forumbodybackgroundcolor'] = 'Υπόβαθρο σώματος ανάρτησης φόρουμ';
$string['forumbodybackgroundcolordesc'] = 'Χρώμα υπόβαθρου για μια ανάρτηση φόρουμ';
$string['forumheaderbackgroundcolor'] = 'Υπόβαθρο επικεφαλίδας ανάρτησης φόρουμ';
$string['forumheaderbackgroundcolordesc'] = 'Χρώμα υπόβαθρου για ανάρτηση σε φόρουμ.';
$string['frnt-footer'] = 'Τα μπλοκ σε αυτή την περιοχή θα είναι ορατά μόνο σε διαχειριστές';
$string['frontpageblocksenableddesc'] = 'Μπορείτε να ενεργοποιήσετε / απενεργοποιήσετε προσαρμοσμένες περιοχές μπλοκ στην πρώτη σελίδα. Μπορείτε κατόπιν να μεταφέρετε και να αποθέσετε μπλοκ στις περιοχές που δημιουργήσατε.';
$string['frontpageblocksettings'] = 'Προωθητικά μπλοκ';
$string['frontpagecoursesettings'] = 'Λίστα μαθημάτων πρώτης σελίδας';
$string['frontpagemarketenabled'] = 'Ενεργοποίηση Προωθητικών μπλοκ';
$string['frontpagemarketenableddesc'] = 'Τοποθέτηση των Προωθητικών μπλοκ στην πρώτη σελίδα.';
$string['frontpagemarketoption'] = 'Επιλογή στυλ για τα Προωθητικά μπλοκ';
$string['frontpagerenderer'] = 'Πλαίσια μαθημάτων πρώτης σελίδας';
$string['frontpagerendererdefaultimage'] = 'Προεπιλεγμένη εικόνα μαθήματος';
$string['frontpagerendereroption1'] = 'Πλακίδια';
$string['frontpagerendereroption2'] = 'Πλακίδια με επικάλυψη';
$string['frontpagerendereroption3'] = 'Προεπιλογή Moodle';
$string['frontpagesettingsheading'] = 'Απόδοση πρώτης σελίδας';
$string['frontpageslidersettings'] = 'Ολισθητήρας πρώτης σελίδας';
$string['frontpagetiles1'] = '1 πλακίδιο';
$string['frontpagetiles2'] = '2 πλακίδια';
$string['frontpagetiles3'] = '3 πλακίδια';
$string['frontpagetiles4'] = '4 πλακίδια';
$string['frontpagetiles6'] = '6 πλακίδια';
$string['fullscreenwidth'] = 'Πλάτος πλήρους οθόνης.';
$string['headerbgimage'] = 'Εικόνα υπόβαθρου';
$string['headersettings'] = 'Επικεφαλίδα';
$string['help'] = 'Βοήθεια';
$string['helptitle'] = 'Βοήθεια {$a->number}';
$string['hide'] = 'Απόκρυψη';
$string['hidefootersocial'] = 'Εμφάνιση κοινωνικών δικτύων';
$string['hideinforum'] = 'Απόκρυψη βοήθειας και εργαλείων στα φόρουμ';
$string['home'] = 'Αρχική';
$string['homebk'] = 'Εικόνα υπόβαθρου πρώτης σελίδας';
$string['homebkdesc'] = 'Ανέβασμα μιας εικόνας που θα γίνει η εικόνα υπόβαθρου στην αρχική σελίδα.';
$string['infobox'] = 'Πλαίσιο πληροφοριών πρώτης σελίδας';
$string['infobox2'] = 'Πλαίσιο δευτερευόντων πληροφοριών πρώτης σελίδας';
$string['infoiconcolor'] = 'Χρώμα εικονιδίου βοήθειας';
$string['infoiconcolordesc'] = 'Ορισμός του χρώματος εικονιδίου πληροφοριών/βοήθειας που χρησιμοποιείται από τις αναδυόμενες συμβουλές εργαλείου.';
$string['jssectionrestricteddashboardonly'] = 'Συμπερίληψη Javascript μόνο στη σελίδα του ταμπλό';
$string['jssectionrestricteddashboardonlydesc'] = 'Εμφάνιση javascript μόνο στη σελίδα του ταμπλό. Διαφορετικά, εμφανίζεται σε ολόκληρο τον ιστότοπο.';
$string['jumpto'] = 'Μεταπήδηση σε...';
$string['layoutaddcontentdesc1'] = 'Έχετε ρυθμίσει';
$string['layoutcheck'] = 'Έλεγχος της διάταξής σας';
$string['layoutcount1'] = 'Μπορείτε να ορίσετε ένα μέγιστο από';
$string['layoutcount2'] = 'περιοχές μπλοκ. Χρησιμοποιείτε αυτή τη στιγμή:';
$string['layoutdesc'] = 'Ορίστε την προεπιλεγμένη διάταξη που βλέπουν οι χρήστες.';
$string['layoutsettings'] = 'Διάταξη';
$string['layoutsettingsheading'] = 'Ρυθμίστε διάφορες παραμέτρους/διαστάσεις της διάταξης του ιστοτόπου';
$string['leftblocks'] = 'Αριστερή πλευρά';
$string['linkhover'] = 'Χρώμα αιώρησης συνδέσμου';
$string['linkhoverdesc'] = 'Ορισμός του χρώματος συνδέσμων (κατά την αιώρηση), στο αισθητικό θέμα. Χρησιμοποιήστε δεκαεξαδικό κώδικα χρωμάτων HTML.';
$string['linksmenu'] = 'Μενού συνδέσμων';
$string['loadingcolor'] = 'Φόρτωση χρώματος';
$string['loginbgimage'] = 'Εικόνα υπόβαθρου';
$string['loginbgimagedesc'] = 'Προσθήκη μιας εικόνας υπόβαθρου στην σελίδα πλήρους μεγέθους.';
$string['logindesc'] = 'Προσαρμογή της σελίδας σύνδεσης προσθέτοντας μια εικόνα υπόβαθρου και κείμενα πάνω και κάτω από το πλαίσιο σύνδεσης.';
$string['loginplaceholder'] = 'Όνομα χρήστη';
$string['logintextbutton'] = 'Σύνδεση';
$string['logo'] = 'Λογότυπο';
$string['menusdesc'] = '';
$string['myblogs'] = 'Τα ιστολόγιά μου';
$string['mysites'] = 'Τα μαθήματά μου';
$string['mysitesdisabled'] = 'Απενεργοποίηση';
$string['mysitessortoverrideprofilefieldscohort'] = 'Εμφάνιση μαθημάτων που βρέθηκαν σε πεδία προφίλ + σύνολα χρηστών στην πρώτη λίστα, οι άλλες στο υπομενού';
$string['nextactivity'] = 'Επόμενη δραστηριότητα';
$string['nextsection'] = 'Επόμενη ενότητα';
$string['noenrolments'] = 'Δεν βρέθηκαν εγγραφές.';
$string['none'] = 'Κανένα';
$string['normal'] = 'Σταθερό πλάτος';
$string['nostyle'] = 'Χωρίς στυλ';
$string['pageheaderalternative'] = 'Εναλλακτική';
$string['pageheaderoriginal'] = 'Αρχική';
$string['passwordplaceholder'] = 'Κωδικός πρόσβασης';
$string['past'] = 'Παρελθόν';
$string['pastcourses'] = 'Περασμένα μαθήματα';
$string['people'] = 'Συμμετέχοντες';
$string['piwikenabled'] = 'Ενεργοποιημένο';
$string['piwikimagetrack'] = 'Παρακολούθηση εικόνων';
$string['piwiksiteid'] = 'Αναγνωριστικό ιστοτόπου';
$string['piwiksiteiddesc'] = 'Δώστε το αναγνωριστικό ιστοτόπου σας.';
$string['portrait'] = 'Πορτρέτο';
$string['previousactivity'] = 'Προηγούμενη δραστηριότητα';
$string['previoussection'] = 'Προηγούμενη ενότητα';
$string['printbodyfontsize'] = 'Μέγεθος γραμματοσειράς σώματος';
$string['printlineheight'] = 'Ύψος γραμμής';
$string['printlineheightdesc'] = 'Ορίστε το ύψος της γραμμής.';
$string['printmargin'] = 'Περιθώριο';
$string['printmargindesc'] = 'Ορισμός του περιθωρίου.';
$string['printpageorientation'] = 'Προσανατολισμός σελίδας';
$string['printsettings'] = 'Εκτύπωση';
$string['printsettingsdesc'] = 'Ορισμός των ρυθμίσεων για εκτύπωση.';
$string['printsettingsheading'] = 'Ρυθμίσεις εκτύπωσης';
$string['properties'] = 'Ρυθμίσεις εισαγωγής / εξαγωγής';
$string['propertiesproperty'] = 'Ιδιότητα';
$string['propertiesreturn'] = 'Επιστροφή';
$string['propertiessub'] = 'Ρυθμίσεις τρέχοντος αισθητικού θέματος';
$string['propertiesvalue'] = 'Τιμή';
$string['putpropertiesadded'] = 'Προστέθηκε:';
$string['putpropertieschanged'] = 'Άλλαξε:';
$string['putpropertiesfrom'] = 'από';
$string['putpropertiesheading'] = 'Εισαγωγή ρυθμίσεων αισθητικού θέματος';
$string['putpropertiesname'] = 'Εισαγωγή ιδιοτήτων';
$string['putpropertiessettingsreport'] = 'Αναφορά ρυθμίσεων:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyproperties'] = 'Ιδιότητες';
$string['putpropertyreport'] = 'Αναφορά:';
$string['region-frnt-footer'] = 'Υποσέλιδο';
$string['region-frnt-market-a'] = 'Περιοχή 1 σελίδας';
$string['region-frnt-market-b'] = 'Περιοχή 2 σελίδας';
$string['region-frnt-market-c'] = 'Περιοχή 3 σελίδας';
$string['region-frnt-market-d'] = 'Περιοχή 4 σελίδας';
$string['region-frnt-market-e'] = 'Περιοχή 5 σελίδας';
$string['region-frnt-market-f'] = 'Περιοχή 6 σελίδας';
$string['region-frnt-market-g'] = 'Περιοχή 7 σελίδας';
$string['region-frnt-market-h'] = 'Περιοχή 8 σελίδας';
$string['region-frnt-market-i'] = 'Περιοχή 9 σελίδας';
$string['region-frnt-market-j'] = 'Περιοχή 10 σελίδας';
$string['region-frnt-market-k'] = 'Περιοχή 11 σελίδας';
$string['region-frnt-market-l'] = 'Περιοχή 12 σελίδας';
$string['region-frnt-market-m'] = 'Περιοχή 13 σελίδας';
$string['region-frnt-market-n'] = 'Περιοχή 14 σελίδας';
$string['region-frnt-market-o'] = 'Περιοχή 15 σελίδας';
$string['region-frnt-market-p'] = 'Περιοχή 16 σελίδας';
$string['region-frnt-market-q'] = 'Περιοχή 17 σελίδας';
$string['region-frnt-market-r'] = 'Περιοχή 18 σελίδας';
$string['region-frnt-market-s'] = 'Περιοχή 19 σελίδας';
$string['region-frnt-market-t'] = 'Περιοχή 20 σελίδας';
$string['region-my-tab-one-a'] = 'Περιοχή 1 καρτέλας σελίδας ταμπλό';
$string['region-my-tab-two-a'] = 'Περιοχή 2 καρτέλας σελίδας ταμπλό';
$string['region-side-post'] = 'Δεξιά';
$string['region-side-pre'] = 'Αριστερά';
$string['responsiveheader'] = 'Κύρια επικεφαλίδα';
$string['responsivelogo'] = 'Λογότυπο';
$string['responsivepagefooter'] = 'Υποσέλιδο';
$string['responsivesectionnav'] = 'Πλοήγηση δραστηριότητας/ενότητας';
$string['responsivesettingsheading'] = 'Ελέγξτε τη συμπεριφορά του ιστοτόπου σας σε διαφορετικά μεγέθη οθόνης';
$string['responsiveslider'] = 'Ολισθητήρας πρώτης σελίδας';
$string['responsivesliderdesc'] = 'Σε τι μεγέθη οθόνης θα θέλατε ο Ολισθητήρας πρώτης σελίδας να εμφανίζεται;';
$string['responsivesocial'] = 'Εικονίδια κοινωνικών δικτύων';
$string['rightblocks'] = 'Δεξιά πλευρά';
$string['savebuttontext'] = 'Αποθήκευση αλλαγών';
$string['selectionbackground'] = 'Χρώμα υπόβαθρου επιλογής';
$string['selectiontext'] = 'Χρώμα κειμένου επιλογής';
$string['settingsanalytics'] = 'Αναλυτική';
$string['settingsblockicons'] = 'Εικονίδια';
$string['settingsborders'] = 'Περιθώρια';
$string['settingscolors'] = 'Χρώματα';
$string['settingsfonts'] = 'Γραμματοσειρές';
$string['settingsforumheading'] = 'Φόρουμ';
$string['show'] = 'Εμφάνιση';
$string['sitetitlecoursesenabled'] = 'Ενεργοποιημένο - εμφάνιση τίτλου ιστοτόπου και τίτλων μαθημάτων στις σελίδες μαθήματος';
$string['slidercaption'] = 'Λεζάντα ολισθητήρα';
$string['slidercaptiondesc'] = 'Προσθήκη μιας λεζάντας για τη διαφάνεια σας';
$string['slidercount'] = 'Πλήθος ολισθητήρα';
$string['sliderenabled'] = 'Ενεργοποίηση ολισθητήρα';
$string['sliderfullscreen'] = 'Πλήρης οθόνη ολισθητήρα';
$string['sliderimage'] = 'Εικόνα ολισθητήρα';
$string['slideroption2'] = 'Επιλογή τύπου ολισθητήρα';
$string['slideshowdesc'] = 'Ανέβασμα των εικόνων και προσθήκη των συνδέσμων & της περιγραφής για την κυκλική εναλλαγή στην πρώτη σελίδα.';
$string['slideshowsettings'] = 'Παρουσίαση διαφανειών';
$string['slideshowsettingsheading'] = 'Προσαρμογή της κυκλικής εναλλαγής εικόνων στην πρώτη σελίδα. Δείτε τη διάταξη <a href="./../theme/adaptable/pix/layout.png" target="_blank">εδώ</a>';
$string['socialiconlist'] = 'Λίστα εικονιδίων κοινωνικών δικτύων';
$string['socialsize'] = 'Ορισμός του μεγέθους γραμματοσειράς στα κοινωνικά εικονίδια';
$string['socialtargetdesc'] = 'Πως θέλετε να ανοίγουν οι σύνδεσμοι κοινωνικών δικτύων (στο ίδιο ή σε νέο παράθυρο).';
$string['standard'] = 'Τυπικό';
$string['standardview'] = 'Τυπική εμφάνιση';
$string['static'] = 'Στατικό';
$string['stickynavbar'] = 'Αυτοκόλλητη μπάρα πλοήγησης στην κορυφή';
$string['stickynavbardesc'] = 'Να παραμένει η μπάρα πλοήγησης στο πάνω μέρος της οθόνης κατά την κύλιση προς τα κάτω.';
$string['stylecover'] = 'Εξώφυλλο';
$string['stylestretch'] = 'Παραμόρφωση';
$string['tabbedlayoutcoursepage'] = 'Διάταξη με καρτέλες σελίδας μαθήματος';
$string['tabbedlayoutcoursepagelink'] = 'Σύνδεσμος μαθήματος διάταξης με καρτέλες σελίδας μαθήματος';
$string['tabbedlayoutcoursepagetabcolorselected'] = 'Επιλεγμένο χρώμα καρτέλας για σελίδα μαθήματος';
$string['tabbedlayoutcoursepagetabcolorselecteddesc'] = 'Επιλογή του χρώματος για την επιλεγμένη αυτή τη στιγμή καρτέλα.';
$string['tabbedlayoutcoursepagetabcolorunselecteddesc'] = 'Επιλογή του χρώματος για οποιαδήποτε άλλη καρτέλα.';
$string['tabbedlayoutdashboardtabcolorselected'] = 'Επιλεγμένο χρώμα καρτέλας για το Ταμπλό';
$string['tabbedlayoutdashboardtabcolorselecteddesc'] = 'Επιλογή του χρώματος για την επιλεγμένη αυτή τη στιγμή καρτέλα.';
$string['tabbedlayoutdashboardtabcolorunselected'] = 'Αποεπιλεγμένο χρώμα καρτέλας για το Ταμπλό';
$string['tabbedlayoutdashboardtabcolorunselecteddesc'] = 'Επιλογή του χρώματος για οποιαδήποτε άλλη καρτέλα.';
$string['tabbedlayoutheading'] = 'Διάταξη με καρτέλες του Προσαρμόσιμου (αισθητικού θέματος)';
$string['tabbedlayouttablabelcourse'] = 'Περιεχόμενο μαθήματος';
$string['tabbedlayouttablabelcourse1'] = 'Καρτέλα 1';
$string['tabbedlayouttablabelcourse2'] = 'Καρτέλα 2';
$string['tabbedlayouttablabeldashboard'] = 'Περιεχόμενο ταμπλό';
$string['tabbedlayouttablabeldashboard1'] = 'Καρτέλα 1';
$string['tabbedlayouttablabeldashboard2'] = 'Καρτέλα 2';
$string['targetnewwindow'] = 'Νέο παράθυρο';
$string['targetsamewindow'] = 'Ίδιο παράθυρο';
$string['thiscourse'] = 'Τρέχον μάθημα';
$string['ticker'] = 'Ανακοινώσεις';
$string['tickerdefault'] = 'Κανένα στοιχείο νέων προς εμφάνιση';
$string['tickerfullscreen'] = 'Πλάτος πλήρους οθόνης';
$string['tickertextprofilefield'] = 'Όνομα προσαρμοσμένου πεδίου προφίλ=Τιμή (προαιρετικά)';
$string['tickerwidth'] = 'Σταθερό πλάτος';
$string['tilesshowallcontacts'] = 'Εμφάνιση όλων των επαφών μαθήματος';
$string['tilesshowallcontactsdesc'] = 'Εμφάνιση όλων των επαφών μαθήματος ή μόνο μίας.';
$string['tilesshowcontacts'] = 'Εμφάνιση επαφών μαθήματος';
$string['tilesshowcontactsdesc'] = 'Εμφάνιση/απόκρυψη επαφών μαθήματος.';
$string['toolsmenudesc'] = 'Προσθήκη ενός πτυσσόμενου μενού στην κύρια μπάρα πλοήγησης.';
$string['toolsmenufield'] = 'Προσαρμοσμένο πεδίο προφίλ Όνομα=Τιμή (προαιρετικά)';
$string['toolsmenuheading'] = 'Μενού εργαλείων';
$string['toolsmenuscount'] = 'Πλήθος μενού εργαλείων';
$string['toolsmenuscountdesc'] = 'Ορισμός του αριθμού των μενού εργαλείων που θέλετε να προσθέσετε στην κύρια μπάρα πλοήγησης.';
$string['toolsmenutitle'] = 'Τίτλος μενού εργαλείων';
$string['toolsmenutitledefault'] = 'Εργαλεία';
$string['usermenu'] = 'Μενού χρήστη';
$string['usernameposition'] = 'Τοποθέτηση ονόματος χρήστη';
$string['usernamepositiondesc'] = 'Ορισμός της τοποθέτησης του ονόματος χρήστη, «Αριστερά» ή «Δεξιά».';
$string['usersettings'] = 'Προφίλ χρήστη';
$string['usersettingsdesc'] = 'Ορισμός ρυθμίσεων για το προφίλ χρήστη.';
$string['usersettingsheading'] = 'Ρυθμίστε διάφορες παραμέτρους/διαστάσεις του προφίλ χρήστη';
$string['versioninfo'] = 'Διανομή {$a->release}, έκδοση {$a->version} του Moodle {$a->moodle}';
$string['wide'] = 'Πλήρης οθόνη';
