<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hsuforum', language 'el', version '5.1'.
 *
 * @package     hsuforum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessible'] = 'Προσβάσιμο';
$string['activityoverview'] = 'Υπάρχουν νέες αναρτήσεις φόρουμ';
$string['addanewdiscussion'] = 'Προσθήκη ενός νέου θέματος συζήτησης';
$string['addanewtopic'] = 'Προσθήκη μιας νέας συζήτησης';
$string['addareply'] = 'Προσθήκη της απάντησής σας';
$string['addyourdiscussion'] = 'Προσθήκη της συζήτησής σας';
$string['advancedsearch'] = 'Προχωρημένη αναζήτηση';
$string['ajaxrequesterror'] = 'Αποτυχία ολοκλήρωσης αιτήματος. Παρακαλούμε, προσπαθήστε ξανά.';
$string['all'] = 'Όλα';
$string['allforums'] = 'Όλα τα φόρουμ';
$string['allowanonymous'] = 'Επιτρέπονται ανώνυμες αναρτήσεις';
$string['allsubscribe'] = 'Εγγραφή σε όλα τα φόρουμ';
$string['allunsubscribe'] = 'Απεγγραφή από όλα τα φόρουμ';
$string['alreadyfirstpost'] = 'Αυτή είναι ήδη η πρώτη ανάρτηση στην συζήτηση';
$string['anonymousalternatename'] = 'Ανώνυμος';
$string['anonymousfirstname'] = 'Ανώνυμος';
$string['anonymousfirstnamephonetic'] = 'Ανώνυμος';
$string['anonymouslastname'] = 'Χρήστης';
$string['anonymouslastnamephonetic'] = 'Χρήστης';
$string['anonymousmiddlename'] = '';
$string['anyfile'] = 'Οποιοδήποτε αρχείο';
$string['areapost'] = 'Μηνύματα';
$string['articledateformat'] = '%l:%M%P %b %e, %Y';
$string['attachment'] = 'Συνημμένα';
$string['attachments'] = 'Συνημμένα';
$string['attachments:x'] = 'Συνημμένα: {$a}';
$string['author'] = 'Συγγραφέας';
$string['blockafter'] = 'Κατώφλι αναρτήσεων για μπλοκάρισμα';
$string['blockafter_help'] = 'Αυτή η ρύθμιση καθορίζει τον μέγιστο αριθμό αναρτήσεων που μπορεί να αναρτήσει ένας χρήστης στην δεδομένη χρονική περίοδο. Χρήστες με την δυνατότητα mod/hsuforum:postwithoutthrottling εξαιρούνται από τα όρια αναρτήσεων.';
$string['blockperiod'] = 'Χρονική περίοδος για μπλοκάρισμα';
$string['blockperioddisabled'] = 'Όχι μπλοκάρισμα';
$string['blogforum'] = 'Το τυπικό φόρουμ να εμφανίζεται με μορφότυπο παρόμοιο με ιστολογίου';
$string['bynameondate'] = 'από {$a->name} - {$a->date}';
$string['byx'] = 'από {$a}';
$string['cannnotdeletesinglediscussion'] = 'Λυπούμαστε, αλλά δεν σας επιτρέπεται διαγραφή αυτής της συζήτησης!';
$string['cannotadd'] = 'Αδυναμία προσθήκης της συζήτησης σε αυτό το φόρουμ';
$string['cannotaddteacherforumto'] = 'Αδυναμία προσθήκης του μετατραπέντος στιγμιοτύπου του φόρουμ διδασκόντων στην ενότητα 0 στο μάθημα';
$string['cannotcreatediscussion'] = 'Αδυναμία δημιουργία νέας συζήτησης';
$string['cannotcreateinstanceforteacher'] = 'Αδυναμία δημιουργίας νέου στιγμιοτύπου αρθρώματος μαθήματος για το φόρουμ διδασκόντων';
$string['cannotdeletepost'] = 'Δεν είναι δυνατή η διαγραφή αυτής της ανάρτησης!';
$string['cannoteditposts'] = 'Δεν μπορείτε να αλλάξετε τις αναρτήσεις άλλων!';
$string['cannotfinddiscussion'] = 'Αδυναμία εύρεσης της συζήτησης σε αυτό το φόρουμ';
$string['cannotfindfirstpost'] = 'Αδυναμία εύρεσης της πρώτης ανάρτησης σε αυτό το φόρουμ';
$string['cannotmovenotvisible'] = 'Το φόρουμ δεν είναι ορατό';
$string['cannotmovetonotexist'] = 'Δεν μπορείτε να μετακινήσετε σε αυτό το φόρουμ - δεν υπάρχει!';
$string['cannotmovetonotfound'] = 'Το φόρουμ προορισμού δεν βρέθηκε σε αυτό το μάθημα.';
$string['cannotmovetosingleforum'] = 'Δεν είναι δυνατό να μετακινηθεί μια συζήτηση σε ένα απλό φόρουμ μιας συζήτησης';
$string['cannotpurgecachedrss'] = 'Δεν ήταν δυνατόν να καθαριστεί η κρυφή μνήμη των τροφοδοσιών RSS για το/τα φόρουμ προέλευσης και/ή προορισμού - ελέγξτε το αρχείο σας permissionsforums (δικαιώματα φόρουμ)';
$string['cannotremovesubscriber'] = 'Δεν ήταν δυνατόν να αφαιρεθεί η δήλωση εγγραφής χρήστη με αναγνωριστικό {$a} από αυτό το φόρουμ!';
$string['cannotreply'] = 'Δεν μπορείτε να απαντήσετε σε αυτήν την ανάρτηση';
$string['cannotsplit'] = 'Οι συζητήσεις από αυτό το φόρουμ δεν μπορούν να διαχωριστούν';
$string['cannotsubscribe'] = 'Λυπόμαστε, αλλά πρέπει να είστε μέλος ομάδας για να εγγραφείτε.';
$string['cannottrack'] = 'Αποτυχία τερματισμού παρακολούθησης αυτού του φόρουμ';
$string['cannotunsubscribe'] = 'Αποτυχία απεγγραφής σας από αυτό το φόρουμ';
$string['cannotupdatepost'] = 'Δεν μπορείτε να ενημερώσετε αυτήν την ανάρτηση';
$string['collapseall'] = 'Σύμπτυξη όλων';
$string['completiondiscussions'] = 'Ο μαθητής πρέπει να δημιουργήσει συζητήσεις:';
$string['completiondiscussionsdesc'] = 'Ο μαθητής πρέπει να δημιουργήσει τουλάχιστον {$a} συζητήσεις';
$string['completiondiscussionsgroup'] = 'Απαιτούνται συζητήσεις';
$string['completiondiscussionshelp'] = 'απαιτούνται συζητήσεις για την ολοκλήρωση';
$string['completionposts'] = 'Ο μαθητής πρέπει να αναρτήσει συζητήσεις ή απαντήσεις:';
$string['completionpostsdesc'] = 'Ο μαθητής πρέπει να αναρτήσει τουλάχιστον {$a} συζητήσεις/-η ή απαντήσεις/-η';
$string['completionpostsgroup'] = 'Απαιτούνται αναρτήσεις';
$string['completionpostshelp'] = 'απαιτούνται συζητήσεις ή απαντήσεις για την ολοκλήρωση';
$string['completionreplies'] = 'Ο μαθητής πρέπει να αναρτήσει απαντήσεις:';
$string['completionrepliesdesc'] = 'Ο μαθητής πρέπει να αναρτήσει {$a} τουλάχιστον αναρτήσεις/-η';
$string['completionrepliesgroup'] = 'Απαιτούνται απαντήσεις';
$string['completionreplieshelp'] = 'απαιτούνται απαντήσεις για την ολοκλήρωση';
$string['configlongpost'] = 'Οποιαδήποτε ανάρτηση μεγαλύτερη από αυτό το μήκος (σε χαρακτήρες μη συμπεριλαμβανομένου του HTML κώδικα) θεωρείται μεγάλη. Αναρτήσεις που εμφανίζονται στην πρώτη σελίδα ιστοτόπου, σε σελίδες μαθημάτων κοινωνικού μορφότυπου, ή σε προφίλ χρηστών περικόπτονται προς ένα φυσικό σημείο κάπου μεταξύ των τιμών των hsuforum_shortpost και hsuforum_longpost.';
$string['configreplytouser'] = 'Όταν μια ανάρτηση φόρουμ αποστέλλεται με ηλε.ταχυδρομείο, να περιέχει τη διεύθυνση του αποστολέα, ώστε οι παραλήπτες να μπορούν να απαντήσουν προσωπικά και όχι μόνο μέσω του φόρουμ; Ακόμα και αν οριστεί σε «Ναι» οι χρήστες μπορούν να επιλέξουν μέσα από το προφίλ τους να αποκρύπτουν την διεύθυνση ηλε.ταχυδρομείου τους.';
$string['configrssarticlesdefault'] = 'Εάν οι τροφοδοσίες RSS είναι ενεργοποιημένες, ορίζει τον προεπιλεγμένο αριθμό άρθρων (είτε συζητήσεις είτε αναρτήσεις).';
$string['configrsstypedefault'] = 'Εάν οι τροφοδοσίες RSS είναι ενεργοποιημένες, ορίζει τον προεπιλεγμένο τύπο δραστηριότητας.';
$string['configshortpost'] = 'Οποιαδήποτε ανάρτηση μικρότερη αυτού του μεγέθους (μη συμπεριλαμβανομένου του HTML) θεωρείται μικρή. (δείτε παρακάτω)';
$string['configusermarksread'] = 'Εάν «ναι», ο χρήστης πρέπει να επισημαίνει χειροκίνητα μια ανάρτηση ως αναγνωσμένη. Εάν «όχι», όταν μια ανάρτηση εμφανίζεται επισημαίνεται ως αναγνωσμένη.';
$string['confirmsubscribe'] = 'Σίγουρα θέλετε εγγραφή στο φόρουμ «{$a}»;';
$string['confirmunsubscribe'] = 'Θέλετε σίγουρα να απεγγραφείτε από το φόρουμ «{$a}»;';
$string['couldnotadd'] = 'Αδυναμία προσθήκης της ανάρτησής σας λόγω άγνωστου σφάλματος';
$string['couldnotdeletereplies'] = 'Λυπούμαστε, αλλά αυτή η ανάρτηση δεν μπορεί να διαγραφεί καθώς κάποιοι έχουν ήδη απαντήσει σε αυτή';
$string['couldnotupdate'] = 'Αδυναμία ενημέρωσης του μηνύματός σας λόγω άγνωστου σφάλματος';
$string['csv'] = 'CSV';
$string['date'] = 'Ημερομηνία';
$string['default'] = 'Προεπιλογή';
$string['delete'] = 'Διαγραφή';
$string['deleteattachments'] = 'Διαγραφή συνημμένων';
$string['deleteattachmentx'] = 'Διαγραφή {$a}';
$string['deleteddiscussion'] = 'Το θέμα συζήτησης διαγράφηκε';
$string['deletedpost'] = 'Η ανάρτηση διαγράφηκε';
$string['deletedposts'] = 'Αυτές οι αναρτήσεις έχουν διαγραφεί';
$string['deletesure'] = 'Σίγουρα να διαγραφεί αυτή η ανάρτηση;';
$string['deletesureplural'] = 'Σίγουρα να διαγραφεί αυτή η ανάρτηση και όλες οι απαντήσεις; ({$a} αναρτήσεις)';
$string['digestmailheader'] = 'Αυτή είναι η ημερήσια σύνοψη νέων αναρτήσεων από τα φόρουμ του ιστοτόπου {$a->sitename}. Για να αλλάξετε τις προεπιλεγμένες ρυθμίσεις ηλε.ταχυδρομείου του φόρουμ, επισκεφθείτε τη σελίδα {$a->userprefs}.';
$string['digestmailpost'] = 'Αλλαγή των προτιμήσεων σύνοψης φόρουμ';
$string['digestmailpostlink'] = 'Αλλαγή των προτιμήσεων σύνοψης φόρουμ: {$a}';
$string['digestmailprefs'] = 'το προφίλ σας ως χρήστης';
$string['digestmailsubject'] = '{$a}: σύνοψη φόρουμ';
$string['digestmailtime'] = 'Ώρα αποστολής συλλογικών μηνυμάτων ηλε.ταχυδρομείου';
$string['disallowsubscribe'] = 'Δεν επιτρέπονται εγγραφές';
$string['disallowsubscribeteacher'] = 'Οι εγγραφές δεν επιτρέπονται (εξαιρούνται οι καθηγητές)';
$string['discussion'] = 'Συζήτηση';
$string['discussion:x'] = 'Συζήτηση: {$a}';
$string['discussiondisplay'] = 'Εμφάνιση συζήτησης';
$string['discussionlocked'] = 'Αυτή η συζήτηση έχει κλειδωθεί, οπότε δεν μπορείτε πλέον να αναρτήσετε σε αυτή.';
$string['discussionlockingdisabled'] = 'Να μην κλειδώνονται συζητήσεις';
$string['discussionlockingheader'] = 'Κλείδωμα συζήτησης';
$string['discussionmoved'] = 'Αυτή η συζήτηση μετακινήθηκε στο «{$a}».';
$string['discussionname'] = 'Όνομα συζήτησης';
$string['discussionpin'] = 'Καρφίτσωμα';
$string['discussionpinned'] = 'Καρφιτσωμένο';
$string['discussionpinned_help'] = 'Καρφιτσωμένες συζητήσεις θα εμφανίζονται στην κορυφή ενός φόρουμ';
$string['discussions'] = 'Συζητήσεις';
$string['discussionsortkey:created'] = 'Ημερομηνία δημιουργίας';
$string['discussionsortkey:lastreply'] = 'Πρόσφατα';
$string['discussionsortkey:replies'] = 'Πιο δραστήριος';
$string['discussionsortkey:subscribe'] = 'Με εγγραφή';
$string['discussionsplit'] = 'Η συζήτηση διαχωρίστηκε';
$string['discussionsstartedby'] = 'Συζητήσεις που ξεκίνησαν από τον/την {$a}';
$string['discussionsstartedbyrecent'] = 'Συζητήσεις που ξεκίνησαν πρόσφατα από τον/την {$a}';
$string['discussionsstartedbyuserincourse'] = 'Συζητήσεις που ξεκίνησαν από «{$a->fullname}» στο «{$a->coursename}»';
$string['discussionsubscribers'] = 'Εγγεγραμμένοι/Συνδρομητές συζήτησης';
$string['discussionunpin'] = 'ξεκαρφίτσωμα';
$string['discussthistopic'] = 'Συζήτηση αυτού του θέματος';
$string['displaydiscussionreplies'] = 'Εμφάνιση απαντήσεων συζήτησης';
$string['displayend'] = 'Τέλος εμφάνισης';
$string['displayend_help'] = 'Αυτή η ρύθμιση καθορίζει εάν πρέπει να γίνει απόκρυψη μιας ανάρτησης μετά από μια συγκεκριμένη ημερομηνία. Σημειώστε πως οι διαχειριστές μπορούν πάντα να βλέπουν αναρτήσεις σε φόρουμ.';
$string['displayperiod'] = 'Περίοδος εμφάνισης';
$string['displaystart'] = 'Έναρξη εμφάνισης';
$string['displaystart_help'] = 'Αυτή η ρύθμιση καθορίζει εάν πρέπει να γίνει εμφάνιση μιας ανάρτησης μετά από μια συγκεκριμένη ημερομηνία. Σημειώστε πως οι διαχειριστές μπορούν πάντα να βλέπουν αναρτήσεις σε φόρουμ.';
$string['displaywordcount'] = 'Εμφάνιση αριθμού λέξεων';
$string['displaywordcount_help'] = 'Αυτή η ρύθμιση καθορίζει εάν πρέπει να εμφανίζεται ή όχι το πλήθος των λέξεων κάθε ανάρτησης.';
$string['eachuserforum'] = 'Κάθε άτομο θέτει ένα θέμα συζήτησης';
$string['edit'] = 'Επεξεργασία';
$string['editedby'] = 'Τροποποιήθηκε από {$a->name} - αρχική υποβολή στις {$a->date}';
$string['editedpostupdated'] = 'Η ανάρτηση του/της {$a} ενημερώθηκε';
$string['editing'] = 'Επεξεργασία';
$string['editingpost'] = 'Επεξεργασία ανάρτησης';
$string['emaildigestcompleteshort'] = 'Πλήρεις αναρτήσεις';
$string['emaildigestdefault'] = 'Προεπιλογή ({$a})';
$string['emaildigestoffshort'] = 'Χωρίς σύνοψη';
$string['emaildigestsubjectsshort'] = 'Θέματα μόνο';
$string['emaildigesttype'] = 'Επιλογές σύνοψης ηλε.ταχυδρομείου';
$string['erroremptymessage'] = 'Το μήνυμα της ανάρτησης δεν μπορεί να είναι κενό.';
$string['erroremptysubject'] = 'Το θέμα της ανάρτησης δεν μπορεί να είναι κενό.';
$string['errorenrolmentrequired'] = 'Πρέπει να εγγραφείτε σε αυτό το μάθημα για να αποκτήσετε πρόσβαση σε αυτό το περιεχόμενο';
$string['errortimestartgreater'] = 'Ο χρόνος έναρξης δεν μπορεί να είναι μετά από το τέλος.';
$string['errorwhiledelete'] = 'Ένα σφάλμα παρουσιάστηκε κατά τη διαγραφή εγγραφής.';
$string['eventassessableuploaded'] = 'Έχει αναρτηθεί κάποιο περιεχόμενο.';
$string['eventcoursesearched'] = 'Το μάθημα αναζητήθηκε';
$string['eventdiscussioncreated'] = 'Η συζήτηση δημιουργήθηκε';
$string['eventdiscussiondeleted'] = 'Η συζήτηση διαγράφηκε';
$string['eventdiscussionmoved'] = 'Η συζήτηση μετακινήθηκε';
$string['eventdiscussionpinned'] = 'Η συζήτηση καρφιτσώθηκε';
$string['eventdiscussionunpinned'] = 'Η συζήτηση ξεκαρφιτσώθηκε';
$string['eventdiscussionupdated'] = 'Η συζήτηση ενημερώθηκε';
$string['eventdiscussionviewed'] = 'Η συζήτηση προβλήθηκε';
$string['eventpostcreated'] = 'Η ανάρτηση δημιουργήθηκε';
$string['eventpostdeleted'] = 'Η ανάρτηση διαγράφηκε';
$string['eventpostupdated'] = 'Η ανάρτηση ενημερώθηκε';
$string['eventreadtrackingdisabled'] = 'Η παρακολούθηση ανάγνωσης απενεργοποιήθηκε';
$string['eventreadtrackingenabled'] = 'Η παρακολούθηση ανάγνωσης ενεργοποιήθηκε';
$string['eventsubscribersviewed'] = 'Οι εγγεγραμμένοι εμφανίστηκαν';
$string['eventsubscriptioncreated'] = 'Η εγγραφή δημιουργήθηκε';
$string['eventsubscriptiondeleted'] = 'Η εγγραφή διαγράφηκε';
$string['eventuserreportviewed'] = 'Εμφάνιση αναφοράς χρήστη';
$string['everyonecanchoose'] = 'Όλοι μπορούν να επιλέξουν να εγγραφούν';
$string['everyonecannowchoose'] = 'Οποιοσδήποτε μπορεί τώρα να επιλέξει να εγγραφεί';
$string['everyoneisnowsubscribed'] = 'Όλοι έχουν εγγραφεί τώρα σε αυτό το φόρουμ';
$string['everyoneissubscribed'] = 'Όλοι είναι εγγεγραμμένοι σε αυτό το φόρουμ';
$string['existingsubscribers'] = 'Υπάρχοντες εγγεγραμμένοι';
$string['expandall'] = 'Ανάπτυξη όλων';
$string['export'] = 'Εξαγωγή';
$string['exportattachments'] = 'Εξαγωγή συνημμένων';
$string['exportdiscussion'] = 'Εξαγωγή όλης της συζήτησης σε χαρτοφυλάκιο';
$string['exportformat'] = 'Μορφότυπος εξαγωγής';
$string['forcessubscribe'] = 'Αυτό το φόρουμ εφαρμόζει υποχρεωτική εγγραφή για όλους';
$string['forum'] = 'Φόρουμ';
$string['forumauthorhidden'] = 'Συγγραφέας (σε απόκρυψη)';
$string['forumblockingalmosttoomanyposts'] = 'Πλησιάζετε το ανώτατο όριο αναρτήσεων. Έχετε αναρτήσει {$a->numposts} φορές στα τελευταία {$a->blockperiod} και το όριο είναι {$a->blockafter} αναρτήσεις.';
$string['forumbodydeleted'] = 'Το περιεχόμενο αυτής της ανάρτησης στο φόρουμ έχει καταργηθεί και δεν είναι πλέον δυνατή η πρόσβαση.';
$string['forumbodyhidden'] = 'Δεν μπορείτε να δείτε αυτήν την ανάρτηση, πιθανώς επειδή δεν έχετε αναρτήσει στη συζήτηση, ο μέγιστος χρόνος επεξεργασίας δεν έχει ακόμη περάσει, η συζήτηση δεν έχει ξεκινήσει ή η συζήτηση έχει λήξει.';
$string['forumintro'] = 'Περιγραφή';
$string['forumname'] = 'Όνομα φόρουμ';
$string['forumposts'] = 'Αναρτήσεις φόρουμ';
$string['forums'] = 'Φόρουμ';
$string['forumsubjectdeleted'] = 'Αυτή η ανάρτηση στο φόρουμ έχει καταργηθεί';
$string['forumsubjecthidden'] = 'Θέμα συζήτησης (σε απόκρυψη)';
$string['forumtracked'] = 'Οι μη αναγνωσμένες αναρτήσεις παρακολουθούνται';
$string['forumtrackednot'] = 'Οι μη αναγνωσμένες αναρτήσεις δεν παρακολουθούνται';
$string['forumtype'] = 'Τύπος φόρουμ';
$string['forumtype_help'] = 'Υπάρχουν 5 τύποι φόρουμ:

* Απλό φόρουμ μίας συζήτησης - Ένα μοναδικό θέμα συζήτησης στο οποίο όλοι μπορούν να απαντήσουν (δεν μπορεί να χρησιμοποιηθεί για ξεχωριστές ομάδες).
* Κάθε άτομο αναρτά μία συζήτηση - Κάθε μαθητής μπορεί να αναρτήσει ακριβώς ένα νέο θέμα συζήτησης, στο οποίο μπορεί μετά να απαντήσει οποιοσδήποτε.
* Φόρουμ Ερώτησης & Απάντησης - Οι μαθητές πρέπει πρώτα να αναρτήσουν τις απόψεις τους προτού δουν τις αναρτήσεις των άλλων μαθητών.
* Τυπικό φόρουμ με μορφή ιστολογίου - Ένα ανοιχτό φόρουμ όπου οποιοσδήποτε μπορεί να αρχίσει μια νέα συζήτηση οποτεδήποτε, και στο οποίο τα θέματα συζήτησης εμφανίζονται σε μια σελίδα με συνδέσμους «Συζήτηση αυτού του θέματος».
* Τυπικό φόρουμ γενικής χρήσης - Ένα ανοιχτό φόρουμ όπου οποιοσδήποτε μπορεί να ξεκινήσει μια νέα συζήτηση οποτεδήποτε.';
$string['general'] = 'Γενικά';
$string['generalforum'] = 'Τυπικό φόρουμ γενικής χρήσης';
$string['generalforums'] = 'Γενικά φόρουμ';
$string['grade'] = 'Βαθμός';
$string['gradeitem:posts'] = 'Αναρτήσεις';
$string['gradetype'] = 'Τύπος βαθμού';
$string['gradetypemanual'] = 'Χειροκίνητα';
$string['gradetypenone'] = 'Κανένα';
$string['gradetyperating'] = 'Αξιολόγηση';
$string['gradingmethodpreview'] = 'Κριτήρια βαθμολόγησης';
$string['hiddenforumpost'] = 'Ανάρτηση φόρουμ σε απόκρυψη';
$string['hiderecentposts'] = 'Απόκρυψη πρόσφατων αναρτήσεων';
$string['hsuforum:addinstance'] = 'Προσθήκη νέου φόρουμ';
$string['hsuforum:addnews'] = 'Προσθήκη ανακοινώσεων';
$string['hsuforum:addquestion'] = 'Προσθήκη ερώτησης';
$string['hsuforum:allowforcesubscribe'] = 'Επιτρέπεται υποχρεωτική εγγραφή';
$string['hsuforum:allowprivate'] = 'Επιτρέψτε στον χρήστη να αποκρίνεται ιδιωτικά';
$string['hsuforum:canoverridediscussionlock'] = 'Απάντηση (και) σε κλειδωμένες συζητήσεις';
$string['hsuforum:canposttomygroups'] = 'Μπορεί να δημοσιεύσει σε όλες τις ομάδες στις οποίες έχετε πρόσβαση';
$string['hsuforum:createattachment'] = 'Δημιουργία συνημμένων';
$string['hsuforum:deleteanypost'] = 'Διαγραφή οποιασδήποτε ανάρτησης (οποτεδήποτε)';
$string['hsuforum:deleteownpost'] = 'Διαγραφή προσωπικών αναρτήσεων (μέσα στη διορία)';
$string['hsuforum:editanypost'] = 'Επεξεργασία οποιασδήποτε ανάρτησης';
$string['hsuforum:exportdiscussion'] = 'Εξαγωγή ολόκληρης της συζήτησης';
$string['hsuforum:exportownpost'] = 'Εξαγωγή των δικών σας αναρτήσεων';
$string['hsuforum:exportpost'] = 'Εξαγωγή ανάρτησης';
$string['hsuforum:managesubscriptions'] = 'Διαχείριση δηλώσεων εγγραφής';
$string['hsuforum:movediscussions'] = 'Μετακίνηση συζητήσεων';
$string['hsuforum:pindiscussions'] = 'Καρφίτσωμα συζητήσεων';
$string['hsuforum:postwithoutthrottling'] = 'Εξαίρεση από ανώτατο όριο αναρτήσεων';
$string['hsuforum:rate'] = 'Βαθμολόγηση αναρτήσεων';
$string['hsuforum:replynews'] = 'Απάντηση στις ανακοινώσεις';
$string['hsuforum:replypost'] = 'Απάντηση στις αναρτήσεις';
$string['hsuforum:splitdiscussions'] = 'Διαχωρισμός συζητήσεων';
$string['hsuforum:startdiscussion'] = 'Έναρξη νέων συζητήσεων';
$string['hsuforum:viewallratings'] = 'Εμφάνιση όλων των πρώτων αξιολογήσεων που δόθηκαν ατομικά';
$string['hsuforum:viewanyrating'] = 'Εμφάνιση όλων των συνολικών αξιολογήσεων που έλαβε κάποιος';
$string['hsuforum:viewdiscussion'] = 'Εμφάνιση συζητήσεων';
$string['hsuforum:viewflags'] = 'Προβολή σημαιοδοτήσεων ανάρτησης';
$string['hsuforum:viewhiddentimedposts'] = 'Εμφάνιση κρυμμένων χρονομετρημένων αναρτήσεων';
$string['hsuforum:viewposters'] = 'Προβολή χρηστών που έχουν αναρτήσει στο φόρουμ';
$string['hsuforum:viewqandawithoutposting'] = 'Πάντα να γίνεται προβολή των αναρτήσεων Ερωτήσεων και Απαντήσεων';
$string['hsuforum:viewrating'] = 'Εμφάνιση της συνολικής βαθμολογίας που έλαβες';
$string['hsuforum:viewsubscribers'] = 'Εμφάνιση εγγεγραμμένων';
$string['id'] = 'αναγνωριστικό';
$string['indicator:cognitivedepth'] = 'Βάθος κατανόησης φόρουμ';
$string['indicator:cognitivedepth_help'] = 'Αυτός ο δείκτης βασίζεται στο βάθος κατανόησης που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα Φόρουμ.';
$string['indicator:socialbreadth'] = 'Κοινωνικό εύρος Φόρουμ';
$string['indicator:socialbreadth_help'] = 'Αυτός ο δείκτης βασίζεται στο κοινωνικό εύρος που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα Φόρουμ.';
$string['inforum'] = 'σε {$a}';
$string['inreplyto'] = 'σε απάντηση στο';
$string['introblog'] = 'Οι αναρτήσεις σε αυτό το φόρουμ αντιγράφηκαν εδώ αυτόματα από ιστολόγια χρηστών αυτού του μαθήματος, διότι αυτές οι αναρτήσεις ιστολογίου δεν είναι πλέον διαθέσιμες';
$string['intronews'] = 'Γενικά νέα και ανακοινώσεις';
$string['introsocial'] = 'Ένα ανοιχτό φόρουμ για συνομιλία για οτιδήποτε θέλετε';
$string['introteacher'] = 'Ένα φόρουμ μόνο διδασκόντων για σημειώσεις και συζήτηση';
$string['invalidaccess'] = 'Η πρόσβαση σε αυτήν τη σελίδα δεν ήταν σωστή';
$string['invaliddigestsetting'] = 'Δόθηκε μη έγκυρη ρύθμιση περίληψης αλληλογραφίας';
$string['invaliddiscussionid'] = 'Το αναγνωριστικό συζήτησης ήταν λανθασμένο ή δεν υπάρχει πλέον';
$string['invalidforcesubscribe'] = 'Μη έγκυρη κατάσταση λειτουργίας επιβολής εγγραφής';
$string['invalidforumid'] = 'Το αναγνωριστικό φόρουμ ήταν λανθασμένο';
$string['invalidparentpostid'] = 'Το αναγνωριστικό της γονικής ανάρτησης ήταν λανθασμένο';
$string['invalidpostid'] = 'Μη έγκυρο αναγνωριστικό ανάρτησης - {$a}';
$string['javascriptdisableddisplayformat'] = 'Η Javascript έχει απενεργοποιηθεί στον περιηγητή σας. Παρακαλούμε, ενεργοποιήστε τη Javascript και φορτώστε ξανά τη σελίδα ή επιλέξτε μια διαφορετική οθόνη συζήτησης.';
$string['lastpostbyx'] = 'Τελευταία ανάρτηση από τον/την {$a->name} στις {$a->time}';
$string['lastposttimeago'] = 'Τελευταία {$a}';
$string['learningforums'] = 'Εκπαιδευτικά φόρουμ';
$string['loadmorediscussions'] = 'Φόρτωση περισσότερων συζητήσεων';
$string['lockdiscussionafter'] = 'Κλείδωμα συζητήσεων μετά από περίοδο αδράνειας';
$string['lockdiscussionafter_help'] = 'Οι συζητήσεις μπορούν να κλειδωθούν αυτόματα αφού παρέλθει ένα καθορισμένο χρονικό διάστημα από την τελευταία απάντηση. Οι χρήστες με την δυνατότητα απάντησης σε κλειδωμένες συζητήσεις μπορούν να τις ξεκλειδώσουν απαντώντας σε αυτές.';
$string['longpost'] = 'Μεγάλη ανάρτηση';
$string['mailnow'] = 'Αποστολή ειδοποιήσεων μέσω ηλε.ταχυδρομείου χωρίς καθυστέρηση/διορία για επεξεργασία';
$string['managesubscriptionson'] = 'Διαχείριση δηλώσεων εγγραφής';
$string['manualwarning'] = 'Η βαθμολόγηση δραστηριότητας δεν υποστηρίζεται ακόμη. Η βαθμολόγηση είναι διαθέσιμη μόνο μέσω του Βαθμολογίου Μαθημάτων.';
$string['manydiscussions'] = 'Συζητήσεις ανά σελίδα';
$string['markalldread'] = 'Επισήμανση όλων των αναρτήσεων σε αυτή τη συζήτηση ως αναγνωσμένων.';
$string['markallread'] = 'Χαρακτηρισμός όλων των αναρτήσεων σε αυτό το φόρουμ ως αναγνωσμένες.';
$string['markasreadonnotification'] = 'Κατά την αποστολή ειδοποίησης για ανάρτηση σε φόρουμ';
$string['markasreadonnotificationno'] = 'Να μην επισημαίνεται η ανάρτηση ως αναγνωσμένη';
$string['markasreadonnotificationyes'] = 'Να επισημαίνεται η ανάρτηση ως αναγνωσμένη';
$string['markread'] = 'Επισήμανση ως αναγνωσμένης';
$string['markreadbutton'] = 'Επισήμανση ως <br /> αναγνωσμένης';
$string['markunread'] = 'Επισήμανση ως μη αναγνωσμένης';
$string['markunreadbutton'] = 'Επισήμανση ως <br /> μη αναγνωσμένης';
$string['maxattachments'] = 'Μέγιστος αριθμός συνημμένων';
$string['maxattachments_help'] = 'Αυτή η ρύθμιση καθορίζει τον μέγιστο αριθμό αρχείων που μπορούν να επισυναφθούν σε μια ανάρτηση φόρουμ.';
$string['maxattachmentsize'] = 'Μέγιστο μέγεθος συνημμένου';
$string['maxattachmentsize_help'] = 'Αυτή η ρύθμιση καθορίζει το μέγιστο μέγεθος αρχείου που μπορεί να επισυναφθεί σε μια ανάρτηση φόρουμ.';
$string['maxtimehaspassed'] = 'Συγγνώμη, αλλά ο μέγιστος χρόνος για την επεξεργασία αυτού του μηνύματος ({$a}) έχει παρέλθει!';
$string['message'] = 'Μήνυμα';
$string['messageisrequired'] = 'Το μήνυμα απαιτείται';
$string['messageplaceholder'] = 'Πληκτρολογήστε την ανάρτησή σας';
$string['modethreaded'] = 'Εμφάνιση απαντήσεων σε μορφή νημάτων';
$string['modulename'] = 'Ανοικτό φόρουμ';
$string['modulename_link'] = '';
$string['modulenameplural'] = 'Ανοικτά φόρουμ';
$string['more'] = 'περισσότερα';
$string['movedmarker'] = '(Μετακινήθηκε)';
$string['movethisdiscussionto'] = 'Μετακίνηση αυτής της συζήτησης σε ...';
$string['mustprovidediscussionorpost'] = 'Πρέπει να παρέχετε είτε ένα αναγνωριστικό συζήτησης είτε ένα αναγνωριστικό ανάρτησης για εξαγωγή';
$string['myprofileotherdis'] = 'Συζητήσεις ανοικτού φόρουμ';
$string['myprofileotherpost'] = 'Αναρτήσεις ανοικτού φόρουμ';
$string['myprofileowndis'] = 'Συζητήσεις του ανοικτού φόρουμ μου';
$string['myprofileownpost'] = 'Αναρτήσεις του ανοικτού φόρουμ μου';
$string['namenews'] = 'Ανακοινώσεις';
$string['namesocial'] = 'Κοινωνικό φόρουμ';
$string['nested'] = 'Ένθετα/εμφωλευμένα';
$string['newforumposts'] = 'Πρόσφατες αναρτήσεις φόρουμ';
$string['nextdiscussion'] = 'Νεότερη συζήτηση';
$string['nextdiscussionx'] = '({$a}) Επόμενο >';
$string['noattachments'] = 'Δεν υπάρχουν συνημμένα σε αυτήν την ανάρτηση';
$string['nodiscussionsstartedby'] = 'Ο/Η {$a} δεν έχει ξεκινήσει καμία συζήτηση';
$string['nodiscussionsstartedbyyou'] = 'Δεν έχετε ξεκινήσει καμία συζήτηση ακόμη';
$string['noguestpost'] = 'Λυπούμαστε! Οι επισκέπτες δεν επιτρέπεται να αναρτούν.';
$string['noguesttracking'] = 'Λυπούμαστε! Δεν επιτρέπεται στους επισκέπτες να ορίσουν επιλογές παρακολούθησης.';
$string['nomorepostscontaining'] = 'Δεν βρέθηκαν άλλες αναρτήσεις που να περιέχουν «{$a}»';
$string['nonanonymous'] = 'Μη ανώνυμα';
$string['nonews'] = 'Δεν έχουν αναρτηθεί ακόμη ανακοινώσεις.';
$string['noonecansubscribenow'] = 'Οι εγγραφές δεν επιτρέπονται πλέον';
$string['nopermissiontosubscribe'] = 'Δεν έχετε τα δικαιώματα για να δείτε τους εγγεγραμμένους του φόρουμ';
$string['nopermissiontoview'] = 'Δεν έχετε δικαιώματα για να δείτε αυτή την ανάρτηση';
$string['nopostforum'] = 'Λυπούμαστε! Δεν σας επιτρέπεται να κάνετε ανάρτηση σε αυτό το φόρουμ';
$string['noposts'] = 'Καμία ανάρτηση';
$string['nopostsmadebyuser'] = 'Ο/Η {$a} δεν έχει κάνει αναρτήσεις';
$string['nopostsmadebyyou'] = 'Δεν έχετε κάνει αναρτήσεις';
$string['nosubscribers'] = 'Δεν υπάρχουν δηλώσεις εγγραφής ακόμη για αυτό το φόρουμ';
$string['notexists'] = 'Η συζήτηση δεν υπάρχει πλέον';
$string['nothingnew'] = 'Τίποτα νέο για {$a}';
$string['notingroup'] = 'Λυπούμαστε, αλλά πρέπει να συμμετέχετε σε μια ομάδα για να δείτε αυτό το φόρουμ.';
$string['notinstalled'] = 'Η ενότητα φόρουμ δεν έχει εγκατασταθεί';
$string['notpartofdiscussion'] = 'Αυτή η ανάρτηση δεν αποτελεί μέρος μιας συζήτησης!';
$string['notrackforum'] = 'Να μην γίνεται παρακολούθηση μη αναγνωσμένων αναρτήσεων';
$string['notuploadedfile'] = 'Παρουσιάστηκε κάποιο πρόβλημα με τη μεταφόρτωση (ανέβασμα) του αρχείου σας. Παρακαλούμε, δοκιμάστε ξανά.';
$string['noviewdiscussionspermission'] = 'Δεν έχετε τα δικαιώματα να δείτε συζητήσεις σε αυτό το φόρουμ';
$string['nowallsubscribed'] = 'Πλέον έχετε εγγραφεί σε όλα τα φόρουμ στο {$a}.';
$string['nowallunsubscribed'] = 'Μόλις καταργήσατε την εγγραφή σας από όλα τα φόρουμ στο {$a}.';
$string['nownotsubscribed'] = 'Ο/Η {$a->name} ΔΕΝ θα ειδοποιηθεί για νέες αναρτήσεις στο «{$a->forum}»';
$string['nownottracking'] = 'Ο/Η «{$a->name}» δεν παρακολουθεί πια το φόρουμ «{$a->forum}».';
$string['nowsubscribed'] = 'Ο/Η «{$a->name}» θα ειδοποιείται (με ηλε.ταχυδρομείο) για νέες αναρτήσεις στο φόρουμ «{$a->forum}»';
$string['nowtracking'] = 'Ο/Η «{$a->name}» θα παρακολουθεί εφεξής το φόρουμ «{$a->forum}».';
$string['numposts'] = '{$a} αναρτήσεις';
$string['olderdiscussions'] = 'Παλαιότερες συζητήσεις';
$string['oldertopics'] = 'Παλαιότερα θέματα';
$string['oldpostdays'] = 'Να θεωρούνται αναγνωσμένα μετά από τόσες ημέρες';
$string['onediscussion'] = '1 συζήτηση';
$string['onereply'] = '1 απόκριση';
$string['openmode0'] = 'Καμία συζήτηση, καμία απόκριση';
$string['openmode1'] = 'Όχι συζητήσεις, αλλά απαντήσεις επιτρέπονται';
$string['openmode2'] = 'Επιτρέπονται συζητήσεις και απαντήσεις';
$string['options'] = 'Επιλογές';
$string['orderdiscussionsby'] = 'Ταξινόμηση κατά';
$string['overviewnumpostssince'] = '{$a} αναρτήσεις από την τελευταία είσοδο';
$string['overviewnumunread'] = '{$a} συνολικά μη αναγνωσμένα';
$string['page-mod-hsuforum-discuss'] = 'Σελίδα νήματος συζήτησης αρθρώματος φόρουμ';
$string['page-mod-hsuforum-view'] = 'Κύρια σελίδα αρθρώματος φόρουμ';
$string['page-mod-hsuforum-x'] = 'Οποιαδήποτε σελίδα αρθρώματος φόρουμ';
$string['parent'] = 'Εμφάνιση γονικού';
$string['parentofthispost'] = 'Γονικό αυτού του μηνύματος';
$string['participants'] = 'Συμμετέχοντες';
$string['plaintext'] = 'Απλό κείμενο';
$string['pluginadministration'] = 'Διαχείριση φόρουμ';
$string['pluginname'] = 'Ανοικτό φόρουμ';
$string['postadded'] = '<p>Το μήνυμά σας προστέθηκε επιτυχώς.</p><p>Έχετε {$a} να το επεξεργαστείτε αν θέλετε να κάνετε αλλαγές.</p>';
$string['postaddedsuccess'] = 'Η ανάρτησή σας προστέθηκε με επιτυχία.';
$string['postaddedtimeleft'] = 'Έχετε {$a} για τροποποιήσεις αν θέλετε να κάνετε οποιεσδήποτε αλλαγές.';
$string['postbyuser'] = '{$a->post} από {$a->user}';
$string['postbyx'] = 'Ανάρτηση από τον/την {$a}';
$string['postbyxinprivatereplytox'] = 'Ιδιωτική απάντηση στο {$a->parent} από τον/την {$a->author}';
$string['postbyxinreplytox'] = 'Απάντηση στο {$a->parent} από τον/την {$a->author} {$a->parentpost}';
$string['postcreated'] = 'Η ανάρτηση δημιουργήθηκε';
$string['postdeleted'] = 'Η ανάρτηση διαγράφηκε';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postoptions'] = 'Επιλογές ανάρτησης';
$string['postrating1'] = 'Κυρίως ξεχωριστή γνώση';
$string['postrating2'] = 'Ξεχωριστή και συνδεδεμένη';
$string['posts'] = 'Αναρτήσεις';
$string['postsfor'] = 'Αναρτήσεις για';
$string['postsmadebyuser'] = 'Αναρτήσεις που έγιναν από τον/την {$a}';
$string['postsmadebyuserincourse'] = 'Αναρτήσεις που έγιναν από τον/την {$a->fullname} στο μάθημα {$a->coursename}';
$string['posttoforum'] = 'Ανάρτηση στο φόρουμ';
$string['posttomygroups'] = 'Αναρτήστε ένα αντίγραφο σε όλες τις ομάδες';
$string['posttomygroups_help'] = 'Αναρτά ένα αντίγραφο αυτού του μηνύματος σε όλες τις ομάδες στις οποίες έχετε πρόσβαση. Οι συμμετέχοντες σε ομάδες στις οποίες δεν έχετε πρόσβαση δεν θα βλέπουν αυτήν την ανάρτηση';
$string['postupdated'] = 'Η ανάρτησή σας ενημερώθηκε';
$string['postwasupdated'] = 'Η ανάρτηση ενημερώθηκε';
$string['potentialsubscribers'] = 'Πιθανοί εγγεγραμμένοι';
$string['prevdiscussionx'] = '< Προηγούμενη ({$a})';
$string['previousdiscussion'] = 'Παλιότερη συζήτηση';
$string['print'] = 'Εκτύπωση';
$string['privacy:digesttypepreference'] = 'Έχετε επιλέξει να λάβετε τον ακόλουθο τύπο σύνοψης φόρουμ: «{$a->type}».';
$string['privacy:discussionsubscriptionpreference'] = 'Έχετε επιλέξει την ακόλουθη προτίμηση εγγραφής σε συζήτηση για αυτό το φόρουμ: «{$a->preference}»';
$string['privacy:metadata:hsuforum_digests'] = 'Πληροφορίες σχετικά με τις προτιμήσεις σύνοψης για κάθε ανοικτό φόρουμ.';
$string['privacy:metadata:hsuforum_digests:maildigest'] = 'Η προτίμηση σύνοψης.';
$string['privacy:metadata:hsuforum_digests:userid'] = 'Το αναγνωριστικό του χρήστη με την προτίμηση σύνοψης.';
$string['privacy:metadata:hsuforum_discussions:name'] = 'Το όνομα της συζήτησης, όπως επιλέχθηκε από τον συγγραφέα.';
$string['privacy:metadata:hsuforum_discussions:timemodified'] = 'Πότε τροποποιήθηκε τελευταία η συζήτηση.';
$string['privacy:metadata:hsuforum_discussions:userid'] = 'Το αναγνωριστικό του χρήστη που δημιούργησε τη συζήτηση';
$string['privacy:metadata:hsuforum_discussions:usermodified'] = 'Το αναγνωριστικό του χρήστη που τροποποίησε τελευταία τη συζήτηση με κάποιο τρόπο.';
$string['privacy:metadata:hsuforum_posts'] = 'Πληροφορίες σχετικά με τις προτιμήσεις σύνοψης για κάθε ανοικτό φόρουμ.';
$string['privacy:metadata:hsuforum_posts:created'] = 'Πότε δημιουργήθηκε η ανάρτηση.';
$string['privacy:metadata:hsuforum_posts:discussion'] = 'Η συζήτηση στην οποία βρίσκεται η ανάρτηση.';
$string['privacy:metadata:hsuforum_posts:message'] = 'Το μήνυμα της ανάρτησης στο ανοικτό φόρουμ.';
$string['privacy:metadata:hsuforum_posts:modified'] = 'Πότε τροποποιήθηκε τελευταία η ανάρτηση.';
$string['privacy:metadata:hsuforum_posts:parent'] = 'Η γονική ανάρτηση η οποία απαντήθηκε.';
$string['privacy:metadata:hsuforum_posts:subject'] = 'Το θέμα της ανάρτησης στο ανοικτό φόρουμ.';
$string['privacy:metadata:hsuforum_posts:userid'] = 'Το αναγνωριστικό χρήστη του συγγραφέα της ανάρτησης στο ανοικτό φόρουμ.';
$string['privacy:metadata:hsuforum_queue:discussionid'] = 'Το αναγνωριστικό της συζήτησης.';
$string['privacy:metadata:hsuforum_queue:postid'] = 'Το αναγνωριστικό της ανάρτησης.';
$string['privacy:metadata:hsuforum_queue:timemodified'] = 'Ο χρόνος τροποποίησης της αρχικής ανάρτησης.';
$string['privacy:metadata:hsuforum_read'] = 'Πληροφορίες για το ποιές αναρτήσεις έχουν διαβαστεί από τον χρήστη.';
$string['privacy:metadata:hsuforum_read:discussionid'] = 'Η συζήτηση στην οποία βρίσκεται η ανάρτηση.';
$string['privacy:metadata:hsuforum_read:firstread'] = 'Η πρώτη φορά που η ανάρτηση διαβάστηκε.';
$string['privacy:metadata:hsuforum_read:lastread'] = 'Η πιο πρόσφατη φορά που η ανάρτηση διαβάστηκε.';
$string['privacy:metadata:hsuforum_read:postid'] = 'Η ανάρτηση που διαβάστηκε.';
$string['privacy:metadata:hsuforum_read:userid'] = 'Το αναγνωριστικό του χρήστη με τον οποίο σχετίζεται αυτή η εγγραφή.';
$string['privacy:metadata:hsuforum_subscriptions'] = 'Πληροφορίες σχετικά με τα ανοικτά φόρουμ στα οποία έχει εγγραφεί ο χρήστης.';
$string['privacy:metadata:hsuforum_subscriptions:forum'] = 'Το φόρουμ στο οποίο έγινε εγγραφή.';
$string['privacy:metadata:hsuforum_subscriptions:userid'] = 'Το αναγνωριστικό του χρήστη που σχετίζεται με αυτή τη εγγραφή σε ανοικτό φόρουμ.';
$string['privatereplies'] = 'Να επιτρέπονται ιδιωτικές απαντήσεις';
$string['privatereply'] = 'Ιδιωτική απάντηση';
$string['privatereplybyx'] = 'Ιδιωτική απάντηση από τον/την {$a}';
$string['prune'] = 'Διαχωρισμός';
$string['qandaforum'] = 'Φόρουμ Ερωτήσεων & Απαντήσεων';
$string['re'] = 'Απάντ:';
$string['removeallforumtags'] = 'Αφαίρεση όλων των ετικετών του φόρουμ';
$string['replies'] = 'Απαντήσεις';
$string['repliesmany'] = '{$a} απαντήσεις μέχρι τώρα';
$string['repliesone'] = '{$a} απάντηση μέχρι τώρα';
$string['repliesx'] = 'Απαντήσεις: {$a}';
$string['reply'] = 'Απάντηση';
$string['replybuttontitle'] = 'Απάντηση σε {$a}';
$string['replybyx'] = 'Απάντηση από τον/την {$a}';
$string['replyforum'] = 'Απάντηση σε φόρουμ';
$string['replytopostbyemail'] = 'Μπορείτε να απαντήσετε σε αυτό μέσω ηλε.ταχυδρομείου.';
$string['replytouser'] = 'Χρήση διεύθυνσης ηλε.ταχυδρομείου στην απάντηση';
$string['replytox'] = 'Απάντηση σε {$a}';
$string['resetforums'] = 'Διαγραφή αναρτήσεων από';
$string['resetforumsall'] = 'Διαγραφή όλων των αναρτήσεων';
$string['resetsubscriptions'] = 'Διαγραφή όλων των δηλώσεων εγγραφής στο φόρουμ';
$string['resettrackprefs'] = 'Διαγραφή όλων των προτιμήσεων παρακολούθησης φόρουμ';
$string['rssarticles'] = 'Πλήθος πρόσφατων άρθρων τροφοδοσίας RSS';
$string['rsssubscriberssdiscussions'] = 'Τροφοδοσία RSS συζητήσεων';
$string['rsssubscriberssposts'] = 'Τροφοδοσία RSS αναρτήσεων';
$string['rsstype'] = 'Τροφοδοσία RSS για αυτή τη δραστηριότητα';
$string['rsstypedefault'] = 'Τύπος τροφοδοσίας RSS';
$string['search'] = 'Αναζήτηση';
$string['searchdatefrom'] = 'Οι αναρτήσεις πρέπει να είναι νεότερες από αυτό';
$string['searchdateto'] = 'Οι αναρτήσεις πρέπει να είναι παλαιότερες από αυτό';
$string['searchforumintro'] = 'Παρακαλούμε, εισάγετε τους όρους αναζήτησης σε ένα ή περισσότερα από τα επόμενα πεδία';
$string['searchforums'] = 'Αναζήτηση';
$string['searchfullwords'] = 'Αυτές οι λέξεις πρέπει να εμφανίζονται ολόκληρες';
$string['searchnotwords'] = 'Αυτές οι λέξεις ΔΕΝ πρέπει να περιέχονται';
$string['searcholderposts'] = 'Αναζήτηση παλαιότερων μηνυμάτων...';
$string['searchphrase'] = 'Αυτή ακριβώς η φράση πρέπει να εμφανίζεται στην ανάρτηση';
$string['searchresults'] = 'Αποτελέσματα αναζήτησης';
$string['searchsubject'] = 'Αυτές οι λέξεις θα πρέπει να εμφανίζονται στο θέμα';
$string['searchtags'] = 'Έχει ετικέτα με όνομα';
$string['searchuser'] = 'Αυτό το όνομα θα πρέπει να ταιριάζει με το συγγραφέα';
$string['searchuserid'] = 'Το Αναγνωριστικό Moodle του συγγραφέα';
$string['subject'] = 'Θέμα';
$string['submit'] = 'Υποβολή';
$string['subscriptionoptional'] = 'Προαιρετική δήλωση εγγραφής';
$string['subscriptions'] = 'Δηλώσεις εγγραφής';
$string['tagarea_hsuforum_posts'] = 'Αναρτήσεις φόρουμ';
$string['thisisanonymous'] = 'Αυτό το φόρουμ είναι ανώνυμο.';
$string['totaldiscussions'] = 'Αναρτήσεις: {$a}';
$string['totalposts'] = 'Συνολικές αναρτήσεις';
$string['totalpostsanddiscussions'] = 'Συνολικές αναρτήσεις: {$a}';
$string['totalreplies'] = 'Απαντήσεις: {$a}';
$string['trackforum'] = 'Παρακολούθηση μη αναγνωσμένων αναρτήσεων';
$string['trackingoptions'] = 'Επιλογές παρακολούθησης';
$string['trackreadposts_header'] = 'Παρακολούθηση φόρουμ';
$string['tree'] = 'Δέντρο';
$string['unread'] = 'Νέο';
$string['unreadposts'] = 'Μη αναγνωσμένες αναρτήσεις';
$string['unreadpostsnumber'] = '{$a} μη αναγνωσμένες αναρτήσεις';
$string['unreadpostsone'] = '1 μη αναγνωσμένη ανάρτηση';
$string['unreadx'] = 'Μη αναγνωσμένες: {$a}';
$string['unsubscribe'] = 'Διαγραφή από αυτό το φόρουμ';
$string['unsubscribeall'] = 'Απεγγραφή από όλα τα φόρουμ';
$string['unsubscribeallconfirm'] = 'Αυτή τη στιγμή είστε εγγεγραμμένος σε {$a} φόρουμ. Θέλετε σίγουρα να απεγγραφείτε από όλα τα φόρουμ και να απενεργοποιήσετε την αυτόματη εγγραφή σε φόρουμ;';
$string['unsubscribealldone'] = 'Όλες οι προαιρετικές εγγραφές σε φόρουμ καταργήθηκαν. Θα λαμβάνετε ακόμα ειδοποιήσεις από φόρουμ με υποχρεωτική εγγραφή. Για να διαχειριστείτε τις ειδοποιήσεις από φόρουμ, παρακαλούμε πηγαίνετε στις ρυθμίσεις ανταλλαγής μηνυμάτων στο προφίλ σας.';
$string['unsubscribeallempty'] = 'Δεν είστε εγγεγραμμένος σε κανένα φόρουμ. Για να απενεργοποιήσετε όλες τις ειδοποιήσεις από αυτόν τον εξυπηρετητή, παρακαλούμε πηγαίνετε στις ρυθμίσεις ανταλλαγής μηνυμάτων στο προφίλ σας.';
$string['unsubscribed'] = 'Διαγραμμένος/-η';
$string['unsubscribedisc'] = 'Διαγραφή σε αυτή την συζήτηση';
$string['unsubscribediscussion'] = 'Διαγραφή από αυτή την συζήτηση';
$string['unsubscribediscussionlink'] = 'Διαγραφή από αυτή την συζήτηση: {$a}';
$string['unsubscribelink'] = 'Διαγραφή από αυτό το φόρουμ: {$a}';
$string['unsubscribeshort'] = 'Απεγγραφή';
$string['useadvancededitor'] = 'Χρησιμοποιήστε προηγμένο πρόγραμμα επεξεργασίας και πρόσθετες επιλογές';
$string['usermarksread'] = 'Χειροκίνητη επισήμανση ανάγνωσης του μηνύματος';
$string['validationerrorx'] = 'Παρουσιάστηκε σφάλμα με την υποβολή σας: {$a}';
$string['viewalldiscussions'] = 'Εμφάνιση όλων των συζητήσεων';
$string['viewposters'] = 'Εμφάνιση αναρτητών';
$string['viewthediscussion'] = 'Εμφάνιση της συζήτησης';
$string['xdiscussions'] = '{$a} συζητήσεις';
$string['xreplies'] = '{$a} απαντήσεις';
$string['xunread'] = '{$a} νέα';
$string['yournewquestion'] = 'Η νέα σας ερώτηση';
$string['yournewtopic'] = 'Το νέο σας θέμα συζήτησης';
$string['yourreply'] = 'Η απάντησή σας';
