<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_arialist', language 'de', version '5.1'.
 *
 * @package     theme_arialist
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div class="clearfix">
<div class="theme_screenshot">
<h2>Arialist</h2>
<img src="arialist/pix/screenshot.png" />
<h3>Forum zur Designdiskussion:</h3>
<p><a href="http://moodle.org/mod/forum/view.php?id=46">http://moodle.org/mod/forum/view.php?id=46</a></p>
<h3>Danksagungen (Designs):</h3>
<p><a href="http://docs.moodle.org/en/Theme_credits">http://docs.moodle.org/en/Theme_credits</a></p>
<h3>Dokumentationen:</h3>
<p><a href="http://docs.moodle.org/de/Designs">http://docs.moodle.org/de/Designs</a></p>
<h3>Fehler melden:</h3>
<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
</div>
<div class="theme_description">
<h2>Über Arialist</h2>
<p>Arialist ist ein sehr aufgeräumtes, einfaches Zwei-Spalten-Design mit variabler Breite für Moodle 2.0.</p>
<h2>Hinweise</h2>
<p>Dieses Design basiert auf den beiden in Moodle enthaltenen Grunddesigns Base und Canvas. Wenn Sie Änderungen vornehmen wollen, empfehlen wir unbedingt, vorher immer eine Kopie zu erstellen und diese umzubenennen. So wird verhindert, dass Ihre Änderungen bei einem Update von Moodle verloren gehen. Sollte Ihnen ein Fehler in den Änderungen unterlaufen, haben Sie so ebenfalls noch eine funktionierende Sicherheitskopie. Weitere Informationen zum Bearbeiten von Designs finden Sie in der <a href="http://docs.moodle.org/de/Designs">Designdokumentation</a>.</p>
<h2>Autor</h2>
<p>Dieses Design wurde erstellt und wird weiter unterstützt von Patrick Malley (NewSchool Learning). Kontaktaufnahme ist per E-Mail: contact@newschoollearning.com</p>
<h2>Lizenz</h2>
<p>Alle in Moodle enthaltenen Grunddesigns stehen unter der <a href="http://www.gnu.org/licenses/gpl.html">GNU General Public License</a>.</p>
</div>
</div>';
$string['configtitle'] = 'Arialist-Einstellungen';
$string['customcss'] = 'CSS-Anpassungen';
$string['customcssdesc'] = 'Die CSS-Anpassungen werden auf jeder Seite benutzt. Das Design kann so einfach geändert werden.';
$string['linkcolor'] = 'Linkfarbe';
$string['linkcolordesc'] = 'Diese Option stellt die Farbe für Links ein.';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Geben Sie die URL zu einem Bild ein, das Sie als Logo verwenden möchten. Es sollte etwa folgender Form entsprechen: http://www.seite.de/verzeichnis/logo.png';
$string['pluginname'] = 'Arialist';
$string['region-side-post'] = 'Rechts';
$string['region-side-pre'] = 'Links';
$string['regionwidth'] = 'Spaltenbreite';
$string['regionwidthdesc'] = 'Diese Einstellung legt die Breite der Blockbereiche in der linken und rechten Spalte fest.';
$string['tagline'] = 'Untertitel';
$string['taglinedesc'] = 'Ein kurzer Untertitel, der unterhalb des Seitennamens auf der Hauptseite angezeigt wird, aber nicht zusammen mit dem Logo';
