<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'openbook', language 'de', version '5.1'.
 *
 * @package     openbook
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_uploads'] = 'Dateien hinzufügen';
$string['allfiles'] = 'Dateiuploads';
$string['allowedfiletypes'] = 'Akzeptierte Dateitypen';
$string['allowedfiletypes_err'] = 'Eingabe überprüfen! Dateitypen enthalten ungültige Sonder- oder Trennzeichen';
$string['allowedfiletypes_help'] = 'Die akzeptierten Dateitypen können Sie hier einschränken. Entweder als kommagetrennte Liste aus Mimetypes, z.B. \'video/mp4, audio/mp3, image/png, image/jpeg\', oder als kommagtrennte Liste aus Dateiendungen, z.B, \'.png, .jpg\'. Falls das Feld leer ist, sind alle Dateitypen erlaubt.';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Die Details zur Aufgabe und das Einreichungsformular sind auf <strong>{$a}</strong> verfügbar';
$string['allowsubmissionsfromdate'] = 'Hochladen ab';
$string['allowsubmissionsfromdate_help'] = 'Wenn diese Option aktiviert ist, können die Teilnehmer/innen ihre Dateien erst ab diesem Datum hochladen. Ist die Option deaktiviert, können Teilnehmer/innen sofort mit dem Hochladen beginnen.';
$string['allowsubmissionsfromdate_upload'] = 'Hochladen ab';
$string['allowsubmissionsfromdatesummary'] = 'Für diesen Openbook Ressourcenordner werden Uploads ab <strong>{$a}</strong> akzeptiert.';
$string['alwaysshowdescription'] = 'Beschreibung immer anzeigen';
$string['alwaysshowdescription_help'] = 'Wenn diese Option deaktiviert ist, wird die Beschreibung des Openbook Ressourcenordner für Teilnehmer/innen nur ab dem Zeitpunkt von "Hochladen ab" angezeigt.';
$string['answered'] = 'Beantwortet';
$string['approval_required'] = 'Entscheidung ausstehend';
$string['approval_timeover'] = 'Es gibt keine Datei, die auf die Freigabe zum Teilen wartet, oder die Freigabezeit ist abgelaufen.';
$string['approval_timeover_description'] = 'Freigabe zum Teilen';
$string['approvalchange'] = 'Openbook Ressourcenordner Status geändert';
$string['approvalfromdate'] = 'Freigabe ab';
$string['approvalfromdate_help'] = 'Der Freigabestatus kann vor diesem Datum nicht geändert werden. Diese Einstellung ist nur relevant, wenn die Freigabe von Teilnehmer/innen nicht automatisch erfolgt.';
$string['approvalsettings'] = 'Openbook Ressourcenordner-Einstellungen';
$string['approvaltodate'] = 'Freigabe bis';
$string['approvaltodate_help'] = 'Der Status zum Teilen nach diesem Datum nicht geändert werden. Diese Einstellung ist nur relevant, wenn die Freigabe von Teilnehmer/innen nicht automatisch erfolgt.';
$string['approvaltodatevalidation'] = 'Das "Freigabe bis"-Datum muss nach dem "Freigabe ab"-Datum liegen.';
$string['approved'] = 'Genehmigt';
$string['approveusers'] = 'Genehmigen';
$string['assignment_notfound'] = 'Die Aufgabe, aus der Dateien importiert wurden, konnte nicht mehr gefunden werden.';
$string['assignment_notset'] = 'Es wurde keine Aufgabe ausgewählt.';
$string['availability'] = 'Bearbeitungszeitraum (Hochladen oder Genehmigung)';
$string['availabilityrestriction'] = 'Voraussetzungen auf Nutzerliste anwenden';
$string['availabilityrestriction_admin'] = 'Standardeinstellung für Voraussetzungen in der Nutzerliste';
$string['availabilityrestriction_admin_desc'] = 'Teilnehmer/innen, die aufgrund von definierten Voraussetzungen nicht auf die Aktivität zugreifen können, werden aus der Liste entfernt.<br>Dazu gehören nur Bedingungen, die auf Nutzerlisten anwendbar sind. Zum Beispiel werden Gruppenbedingungen einbezogen, aber Datumsbedingungen nicht.';
$string['availabilityrestriction_help'] = 'Teilnehmer/innen, die aufgrund von definierten Voraussetzungen nicht auf die Aktivität zugreifen können, werden aus der Liste entfernt.<br>Dazu gehören nur Bedingungen, die auf Nutzerlisten anwendbar sind. Zum Beispiel werden Gruppenbedingungen einbezogen, aber Datumsbedingungen nicht.';
$string['calendarapprovalend'] = '{$a} schließt für die Genehmigungen von Dateien';
$string['calendarapprovalstart'] = '{$a} öffnet für die Genehmigungen von Dateien';
$string['calendarsubmissionend'] = '{$a} schließt für Dateiuploads';
$string['calendarsubmissionstart'] = '{$a} öffnet für Dateiuploads';
$string['completiondetail:upload'] = 'Eine Datei hochladen';
$string['completionupload'] = 'Teilnehmer/in muss eine Datei hochladen';
$string['configautoimport'] = 'Diese Einstellung legt fest, dass Abgaben von Teilnehmer/innen automatisch in Openbook Ressourcenordner importiert werden. Diese Funktion für jeden Openbook Ressourcenordner separat aktiviert/deaktiviert werden.';
$string['configmaxbytes'] = 'Standardmäßige maximale Dateigröße für Dateien im Openbook Ressourcenordner.';
$string['configmaxfiles'] = 'Standardmäßig maximal zulässige Anzahl von Dateien pro Nutzer/in.';
$string['courseuploadlimit'] = 'Maximale Dateigröße';
$string['currentlynotapproved'] = '* Currently not approved or rejected to publication.';
$string['datalogapprovalstudent'] = '({$a->approving} von {$a->needed} Teilnehmer/innen) {$a->approval}';
$string['details'] = 'Details';
$string['downloadall'] = 'Alle Dateieinreichungen herunterladen';
$string['duedate'] = 'Hochladen bis';
$string['duedate_help'] = 'Wenn diese Option aktiviert ist, können die Teilnehmer/innen nach diesem Datum keine Dateien mehr hochladen. Ist die Option deaktiviert, können Teilnehmer/innen unbegrenzt hochladen.';
$string['duedate_upload'] = 'Hochladen bis';
$string['duedatevalidation'] = 'Das "Hochladen bis"-Datum muss nach dem "Hochladen ab"-Datum liegen.';
$string['edit_notcapable'] = 'Die Bearbeitungszeitraum ist geöffnet, aber Sie dürfen keine Dateien bearbeiten oder hochladen.';
$string['edit_teacher_uploads'] = 'Dateien von Trainer/innen bearbeiten/hochladen';
$string['edit_timeover'] = 'Dateien können nur während des Bearbeitungszeitraums bearbeitet/hochgeladen werden.';
$string['edit_uploads'] = 'Dateien bearbeiten/hochladen';
$string['email:filechange:footer'] = '</ul><br />Bitte überprüfen Sie, ob Sie die Berechtigung für den Openbook Ressourcenordner benötigen.';
$string['email:filechange_import:header'] = 'Die folgende(n) Datei(en) aus der Aufgabe <b>\'{$a->assign}\'</b> wurden am {$a->dayupdated} um {$a->timeupdated} in <b>\'{$a->openbook}\'</b> importiert:<br /><ul>';
$string['email:filechange_import:subject'] = 'File(s) imported';
$string['email:filechange_upload:header'] = '<b>{$a->username}</b> hat die folgenden Dateien zu <b>\'{$a->openbook}\'</b> am {$a->dayupdated} um {$a->timeupdated} hochgeladen:<br /><ul>';
$string['email:filechange_upload:subject'] = 'Dateien hochgeladen';
$string['email:statuschange:filename'] = '<li>\'{$a->filename}\' nach \'<b>{$a->apstatus}</b>\'</li>';
$string['email:statuschange:footer'] = '</ul>';
$string['email:statuschange:header'] = 'Der Openbook Ressourcenordner Status der folgenden Dateien für <b>\'{$a->openbook}\'</b> wurde am {$a->dayupdated} um {$a->timeupdated} von <b>{$a->username}</b> geändert:<br /><ul>';
$string['email:statuschange:subject'] = 'Openbook Ressourcenordner-Datei Status geändert';
$string['entiresperpage'] = 'Einträge pro Seite';
$string['eventopenbookapprovalchanged'] = 'Openbook Ressourcenordner-Datei Genehmigung geändert';
$string['eventopenbookduedateextended'] = 'Openbook Ressourcenordner Datum des Ende für Uploads überschrieben';
$string['eventopenbookfiledeleted'] = 'Openbook Ressourcenordner-Datei gelöscht';
$string['eventopenbookfileimported'] = 'Openbook Ressourcenordner-Datei importiert';
$string['eventopenbookfileuploaded'] = 'Openbook Ressourcenordner-Datei hochgeladen';
$string['eventoverridecreated'] = 'Openbook Ressourcenordner-Datei Überschreibung angelegt';
$string['eventoverridedeleted'] = 'Openbook Ressourcenordner-Datei Überschreibung gelöscht';
$string['eventoverrideupdated'] = 'Openbook Ressourcenordner-Datei Überschreibung aktualisiert';
$string['extensionto'] = 'Verlängerung bis';
$string['filedetails'] = 'Details';
$string['filesarepersonal'] = 'Dateien sind persönlich';
$string['filesarepersonal_admin'] = 'Dateien sind persönlich';
$string['filesarepersonal_admin_desc'] = 'Diese Einstellung legt die Standard-Sichtbarkeitseinstellung für Dateien von Teilnehmer/innen fest.';
$string['filesarepersonal_help'] = 'Diese Einstellung legt fest, ob eingereichte Dateien privat bleiben: <br><ul><li><strong>Ja</strong> - Dateien sind privat und persönlich.</li><li><strong>Nein</strong> - Dateien können zwischen Teilnehmer/innen geteilt werden, sofern die erforderlichen Personen dies genehmigen.</li></ul>';
$string['filesarepersonal_no'] = 'Nein (Dateien können zwischen Teilnehmer/innen geteilt werden.)';
$string['filesarepersonal_yes'] = 'Ja (Dateien sind persönlich)';
$string['filesofthesetypes'] = 'Dateien dieses Typs können hinzugefügt werden:';
$string['filter'] = 'Filter';
$string['filter:allfiles'] = 'Alle Dateiuploads';
$string['filter:approvalrequired'] = 'Entscheidung ausstehend';
$string['filter:approved'] = 'Genehmigte Dateiuploads';
$string['filter:nofiles'] = 'Keine Dateiuploads';
$string['filter:nofilter'] = 'Kein Filter';
$string['filter:rejected'] = 'Zurückgewiesene Dateiuploads';
$string['giveapproval'] = 'Genehmigung erteilen';
$string['go'] = 'Los';
$string['grantextension'] = 'Fristverlängerung gewähren';
$string['group_approved'] = 'Freigabe von allen Mitgliedern der Gruppe erteilt';
$string['guideline'] = 'Openbook Ressourcenordner aus Dateiuploads';
$string['hidden'] = 'Nicht veröffentlicht';
$string['maxbytes'] = 'Maximale Dateigröße';
$string['maxbytes_help'] = 'Legt die Größenbegrenzung für hochgeladene Dateien fest.';
$string['maxfiles'] = 'Maximale Anzahl an Dateien';
$string['maxfiles_help'] = 'Jede/r Teilnehmer/in kann bis zu dieser Anzahl von Dateien für sich hochladen.';
$string['messageprovider:openbook_updates'] = 'Openbook Ressourcenordner Benachrichtigungen';
$string['modulename'] = 'Openbook Ressourcenordner';
$string['modulename_help'] = 'Der Openbook Ressourcenordner bietet die folgenden Funktionen:<br><ul><li>Teilnehmer/innen können Dateien hochladen. Der Zeitraum kann vom Trainer/innen eingeschränkt werden. </li><li>Die Dateien werden automatisch oder nach Freigabe durch Teilnehmer/innen und/oder Genehmigung durch Trainer/innen veröffentlicht. Wenn dies erlaubt ist, können die Teilnehmer/innen die Datei für alle Teilnehmer/innen sichtbar machen, andernfalls sieht jede/r Teilnehmer/in nur ihre/seine eigenen hochgeladenen Dokumente.</li><li>Teilnehmer/innen und/oder Trainer/innen erhalten eine Benachrichtigung, wenn Teilnehmer/innen eine Datei hochladen oder ändern. Darüber hinaus erhalten Studierende und/oder Trainer/innen eine Benachrichtigung über alle Änderungen des Status des Openbook Ressourcenordner. </li><li>PDF-Dateien im Openbook Ressourcenordner können so eingestellt werden, dass sie in einem PDF.js geöffnet werden. </li><li>Die/der Trainer/in kann einen Zeitraum festlegen, in dem die geöffneten Dokumente in einem sicheren Fenster angezeigt werden, d. h. in einem Fenster ohne Moodle-Navigation usw.</li></li></ul>';
$string['modulenameplural'] = 'Openbook Ressourcenordner';
$string['myfiles'] = 'Eigene Dateien';
$string['mygroupfiles'] = 'Dateien meiner Gruppe';
$string['myownfiles'] = 'Meine eigenen Dateien';
$string['name'] = 'Name';
$string['noentries'] = 'Keine Einträge';
$string['nofiles'] = 'Keine Dateien verfügbar';
$string['nofilestodisplay'] = 'Aktuell sind noch keine Dateien vorhanden bzw. noch nicht veröffentlicht.';
$string['nofilestozip'] = 'Keine Dateien zum Zippen';
$string['nonexistentfiletypes'] = 'Die folgenden Dateitypen konnten nicht erkannt werden: {$a}';
$string['noopenbooksincourse'] = 'Es gibt keine Openbook Ressourcenordner-Instanzen in diesem Kurs.';
$string['notanswered'] = 'Nicht beantwortet';
$string['nothing_to_show_groups'] = 'Nichts anzuzeigen – keine Gruppen verfügbar';
$string['nothing_to_show_users'] = 'Nichts anzuzeigen – keine Teilnehmer/innen verfügbar';
$string['nothingtodisplay'] = 'Keine Einträge';
$string['notice'] = '<strong>Hinweis: </strong>';
$string['notice_group_all_teachernotrequired'] = '';
$string['notice_group_all_teacherrequired'] = '';
$string['notice_group_one_teachernotrequired'] = '';
$string['notice_group_one_teacherrequired'] = '';
$string['notice_import_studentnotrequired_teachernotrequired'] = 'Die Dateien werden <strong>automatisch</strong> veröffentlicht (für alle sichtbar gemacht).';
$string['notice_import_studentnotrequired_teacherrequired'] = 'Die Dateien werden nur <strong>nach Genehmigung einer/eines Trainer/in</strong> veröffentlicht (für alle sichtbar gemacht). Die Trainer/innen behalten sich das Recht vor, die Veröffentlichung Ihrer Dateien jederzeit zu widerrufen.';
$string['notice_import_studentrequired_teachernotrequired'] = 'Die Dateien werden nur <strong>nach Ihrer Genehmigung</strong> veröffentlicht (für alle sichtbar gemacht).';
$string['notice_import_studentrequired_teacherrequired'] = 'Die Dateien werden <strong>nach Genehmigung einer/eines Trainer/in und Ihrer Genehmigung</strong> veröffentlicht (für alle sichtbar gemacht). Die Trainer/innen behalten sich das Recht vor, die Veröffentlichung Ihrer Dateien jederzeit zu widerrufen.';
$string['notice_upload_filesarepersonal_teachernotrequired'] = 'Alle Dateien, die Sie hier hochladen, sind persönlich und <strong>automatisch</strong> für Sie sichtbar.';
$string['notice_upload_filesarepersonal_teacherrequired'] = 'Alle Dateien, die Sie hier hochladen, sind persönlich und <strong>nach der Genehmigung einer/eines Trainer/in</strong> für Sie sichtbar. Trainer/innen haben das Recht vor, die Genehmigung Ihrer Dateien jederzeit zurückzunehmen.';
$string['notice_upload_studentnotrequired_teachernotrequired'] = 'Die Dateien werden <strong>automatisch</strong> veröffentlicht (für alle sichtbar gemacht).';
$string['notice_upload_studentnotrequired_teacherrequired'] = 'Die Dateien werden nur <strong>nach Genehmigung einer/eines Trainer/in</strong> veröffentlicht (für alle sichtbar gemacht).';
$string['notice_upload_studentrequired_teachernotrequired'] = 'Die Dateien werden nur <strong>nach Ihrer Genehmigung</strong> veröffentlicht (für alle sichtbar gemacht).';
$string['notice_upload_studentrequired_teacherrequired'] = 'Die Dateien werden <strong>nach Genehmigung einer/eines Trainer/in und Ihrer Genehmigung</strong> veröffentlicht (für alle sichtbar gemacht). Die Trainer/innen behalten sich das Recht vor, die Veröffentlichung Ihrer Dateien jederzeit zu widerrufen.';
$string['notifications'] = 'Benachrichtigungen';
$string['notify:filechange'] = 'Benachrichtigungen über hochgeladene Dateien';
$string['notify:filechange_admin'] = 'Standardeinstellung für Benachrichtigung';
$string['notify:filechange_help'] = 'Wenn diese Option aktiviert ist, erhalten Teilnehmer/innen und/oder Trainer/innen eine Benachrichtigung wenn Teilnehmer/innen in einem Openbook Ressourcenordners eine Datei hochladen oder ändern.';
$string['notify:setting:0'] = 'Keine Benachrichtigungen';
$string['notify:setting:1'] = 'Nur Trainer/innen';
$string['notify:setting:2'] = 'Nur Teilnehmer/innen';
$string['notify:setting:3'] = 'Trainer/innen und Teilnehmer/innen';
$string['notify:statuschange'] = 'Benachrichtigungen über Openbook Ressourcenordner Statusänderungen';
$string['notify:statuschange_admin'] = 'Standardeinstellung für Benachrichtigung bei Änderungen des Status des Openbook Ressourcenordners';
$string['notify:statuschange_help'] = 'Wenn diese Option aktiviert ist, erhalten Teilnehmer/innen und/oder Trainer/innen eine Benachrichtigung wenn der Status einer Datei im Status des Openbook Ressourcenordners geändert wird.';
$string['notifystudents'] = 'Teilnehmer/innen über Änderungen im Openbook Ressourcenordner benachrichtigen';
$string['notifystudents_help'] = 'Wenn diese Option aktiviert ist, erhalten Teilnehmer/innen eine Benachrichtigung, wenn sich im Openbook Ressourcenordners der Status einer ihrer hochgeladenen Dateien ändert.';
$string['notifyteacher'] = 'Trainer/innen über hochgeladene Dateien benachrichtigen';
$string['notifyteacher_help'] = 'Wenn diese Option aktiviert ist, erhalten Trainer/innen eine Benachrichtigung, wenn Teilnehmer/innen eine Datei hochladen.';
$string['obtainapproval_automatic'] = 'Automatisch';
$string['obtainapproval_required'] = 'Erforderlich';
$string['obtaingroupapproval'] = 'Gruppenweise Genehmigung';
$string['obtaingroupapproval_admin'] = 'Standardmäßige Gruppenfreigabeeinstellung';
$string['obtaingroupapproval_admin_desc'] = 'Diese Einstellung legt die standardmäßige Genehmigung für Gruppen fest. Sie ist <strong>nur</strong> relevant, wenn der Modus auf "Dateien aus einer Aufgabenaktivität importieren" eingestellt ist und die Aufgabe eine Gruppenabgabe beinhaltet.';
$string['obtaingroupapproval_all'] = 'Zustimmung von ALLEN Mitgliedern erforderlich';
$string['obtaingroupapproval_help'] = 'Diese Einstellung legt fest, wie die Veröffentlichung (Sichtbarkeit) von Dateieinreichungen durch Gruppen erfolgt: <br /><ul><li><strong>Automatisch</strong> – Es ist keine Zustimmung von Gruppenmitgliedern erforderlich. Im Sinne des Urheberrechts bitten wir Sie, die Zustimmung zur Veröffentlichung von Dateien von Teilnehmer/innen separat einzuholen.</li><li><strong>Zustimmung von mindestens EINEM Mitglied erforderlich</strong> – Mindestens ein Gruppenmitglied muss zustimmen.</li><li><strong>Zustimmung von ALLEN Mitgliedern erforderlich</strong> – Alle Gruppenmitglieder müssen zustimmen.</li></ul>';
$string['obtaingroupapproval_single'] = 'Zustimmung von mindestens EINEM Mitglied erforderlich';
$string['obtaingroupapproval_title'] = 'Gruppenweise Genehmigung';
$string['obtainstudentapproval'] = 'Freigabe durch Teilnehmer/innen';
$string['obtainstudentapproval_admin'] = 'Standardmäßige Einstellung für die Freigabe durch Teilnehmer/innen';
$string['obtainstudentapproval_admin_desc'] = 'Diese Einstellung legt die standardmäßige Freigabe durch Teilnehmer/innen fest.';
$string['obtainstudentapproval_help'] = 'Diese Option legt fest, wie die Freigabe von Dateien durch Teilnehmer/innen im Openbook Ressourcenordner (Sichtbarkeit) erfolgt: <br><ul><li><strong>Automatisch</strong> – Keine Freigabe durch Teilnehmer/innen erforderlich.</li><li><strong>Erforderlich</strong> – Teilnehmer/innen müssen die Datei manuell für die Openbook Ressourcenordner genehmigen.</li></ul>';
$string['obtainstudentapproval_no'] = 'Automatisch';
$string['obtainstudentapproval_yes'] = 'Erforderlich';
$string['obtainteacherapproval'] = 'Genehmigung durch Trainer/in';
$string['obtainteacherapproval_admin'] = 'Standardmäßige Einstellung für die Genehmigung durch Trainer/innen';
$string['obtainteacherapproval_admin_desc'] = 'Diese Einstellung legt die standardmäßige Freigabe durch Trainer/innen fest';
$string['obtainteacherapproval_help'] = 'Diese Option legt fest, wie die Genehmigung von Dateien durch Trainer/innen im Openbook Ressourcenordner (Sichtbarkeit) erfolgt: <br><ul><li><strong>Automatisch</strong> – Keine Genehmigung durch Trainer/innen erforderlich.</li><li><strong>Erforderlich</strong> – Trainer/innen müssen die Datei manuell für die Openbook Ressourcenordner genehmigen.</li></ul>';
$string['obtainteacherapproval_no'] = 'Automatisch';
$string['obtainteacherapproval_yes'] = 'Erforderlich';
$string['openbook:addinstance'] = 'Neuen Openbook Ressourcenordner';
$string['openbook:approve'] = 'Entscheiden Sie, ob Dateien geteilt werden sollen (für alle Teilnehmer/innen sichtbar).';
$string['openbook:grantextension'] = 'Fristverlängerung gewähren';
$string['openbook:manageoverrides'] = 'Überschreibungen bearbeiten';
$string['openbook:receiveteachernotification'] = 'Receive notifications for teachers';
$string['openbook:upload'] = 'Dateien in einen Openbook Ressourcenordner hochladen';
$string['openbook:uploadcommonteacherfile'] = 'Upload teacher files that are visible to everybody to a Openbook resource folder';
$string['openbook:view'] = 'Openbook Ressourcenordner anzeigen';
$string['openbookstatus'] = 'Genehmigungsstatus';
$string['openbookstatus_help'] = 'Der Status dieser Datei repräsentiert die Genehmigung einer/eines Trainer/in: <ul><li><i class="fa fa-check text-success fa-fw"></i><i class="fa fa-share-from-square text-success fa-fw"></i> Die Datei wurde genehmigt, freigegeben und ist daher für alle Teilnehmer/innen sichtbar.</li><li><i class="fa fa-check text-success fa-fw"></i><i class="fa fa-user text-success fa-fw"></i> Die Datei wurde genehmigt und ist nur für die/den Teilnehmer/in sichtbar.</li><li><i class="fa fa-times text-danger fa-fw"></i> Die Datei wurde nicht genehmigt (die Genehmigung wurde noch nicht erteilt oder abgelehnt) und ist daher nicht sichtbar.</li></ul>';
$string['openpdffilesinpdfjs'] = 'PDF.js aktivieren';
$string['openpdffilesinpdfjs_admin'] = 'PDF-Dateien werden mit dem PDF.js-Viewer angezeigt.';
$string['openpdffilesinpdfjs_admin_desc'] = 'Diese Einstellung legt die Standardeinstellung für die Anzeige von PDF-Dokumenten fest.';
$string['openpdffilesinpdfjs_help'] = 'Diese Einstellung legt fest, ob hochgeladene PDF-Dateien mithilfe der Bibliothek PDF.js angezeigt werden sollen.';
$string['openpdffilesinpdfjs_no'] = 'Nein';
$string['openpdffilesinpdfjs_yes'] = 'Ja';
$string['optionalsettings'] = 'Optionen';
$string['overdue'] = 'Die Frist für das Bearbeiten/das Hochladen ist abgelaufen.';
$string['override:add:group'] = 'Gruppenüberschreibung hinzufügen';
$string['override:add:user'] = 'Nutzerüberschreibung hinzufügen';
$string['override:approval:from'] = 'Erlaube Freigaben ab {$a->from}';
$string['override:approval:fromto'] = 'Erlaube Freigaben von {$a->from} bis {$a->to}';
$string['override:approval:to'] = 'Erlaube Freigaben bis {$a->to}';
$string['override:delete:ask'] = 'Möchten Sie wirklich die Überschreibung für {$a->userorgroup} {$a->fullname} löschen?';
$string['override:delete:success'] = 'Überschreibung erfolgreich gelöscht!';
$string['override:group:choose'] = 'Gruppe wählen';
$string['override:invalidid'] = 'Ungültige Überschreibungs-ID';
$string['override:nothingtochange'] = 'Es gibt keine Einstellungen, die mit den aktuellen Aktivitätseinstellungen überschrieben werden können!';
$string['override:save:success'] = 'Überschreibung erfolgreich gespeichert';
$string['override:securewindow:from'] = 'Sicheres Browserfenster ab {$a->from}';
$string['override:securewindow:fromto'] = 'Sicheres Browserfenster von {$a->from} bis {$a->to}';
$string['override:securewindow:to'] = 'Sicheres Browserfenster bis {$a->to}';
$string['override:submission:from'] = 'Erlaube Uploads ab {$a->from}';
$string['override:submission:fromto'] = 'Erlaube Uploads von {$a->from} bis {$a->to}';
$string['override:submission:to'] = 'Erlaube Uploads bis {$a->to}';
$string['override:user:choose'] = 'Nutzer/in wählen';
$string['overrides'] = 'Überschreibungen';
$string['overrides:empty'] = 'Keine Überschreibungen';
$string['overview'] = 'Übersicht';
$string['pending'] = 'Ausstehend';
$string['pluginadministration'] = 'Openbook Ressourcenordner Administration';
$string['pluginname'] = 'Openbook Ressourcenordner';
$string['privacy:metadata:contenthash'] = 'SHA1-Hashwert des Dateiinhalts, der verwendet wird, um festzustellen, ob sich die Datei geändert hat.';
$string['privacy:metadata:fileid'] = 'Identifier der Datei.';
$string['privacy:metadata:filename'] = 'Name der Datei.';
$string['privacy:metadata:files'] = 'Speichert Informationen (Identifier, Eigentümer, Herkunft, Hashwert des Inhalts, Dateiname und Angabe, ob die Datei von der Trainerin/vom Trainer und/oder Teilnehmer/in genehmigt wurde) zu den Dateien, die in mod_openbook hochgeladen/importiert wurden.';
$string['privacy:metadata:openbook'] = 'Der Openbook Ressourcenordner';
$string['privacy:metadata:openbook_overrides'] = 'Die Überschreibungen für den Openbook Ressourcenordner';
$string['privacy:metadata:openbookfileexplanation'] = 'Die Dateien für dieses Plugin werden über die Datei-API von Moodle gespeichert.';
$string['privacy:metadata:openbookperpage'] = 'Wie viele Einträge auf einer einzelnen Tabellenseite angezeigt werden sollen';
$string['privacy:metadata:studentapproval'] = 'Ob die/der Teilnehmer/in das Teilen einer Datei freigegeben oder abgelehnt hat';
$string['privacy:metadata:teacherapproval'] = 'Ob die/der Trainer/in die Datei genehmigt oder zurückgewiesen hat';
$string['privacy:metadata:timecreated'] = 'Zeitpunkt und Datum der Erstellung des Datensatzes.';
$string['privacy:metadata:timemodified'] = 'Das letzte Datum und die letzte Uhrzeit, zu denen der Datensatz aktualisiert/geändert wurde.';
$string['privacy:metadata:userextensionallowsubmissionsfromdate'] = 'Das überschriebene Datum ab welchem Hochladen für diese/n Nutzer/in möglich ist.';
$string['privacy:metadata:userextensionapprovalfromdate'] = 'Das überschriebene Datum ab welchem Teilen für diese/n Nutzer/in möglich ist.';
$string['privacy:metadata:userextensionapprovaltodate'] = 'Das überschriebene Datum bis zu welchem Teilen für diese/n Nutzer/in möglich ist.';
$string['privacy:metadata:userextensionsecurewindowfromdate'] = 'Das überschriebene Datum ab welchem Hochladen für diese/n Nutzer/in möglich ist.';
$string['privacy:metadata:userextensionsecurewindowtodate'] = 'Das überschriebene Datum bis zu welchem das sichere Browserfenster für diese/n Nutzer/in eingestellt ist.';
$string['privacy:metadata:userextensiontodate'] = 'Das überschriebene Datum bis zu welchem Hochladen für diese/n Nutzer/in möglich ist.';
$string['privacy:metadata:userid'] = 'Identifier der Nutzerin/des Nutzers';
$string['privacy:path:files'] = 'Dateien';
$string['publicfiles'] = 'Geteilte Dateien';
$string['published_aftercheck'] = 'Genehmigung durch Trainer/in erforderlich';
$string['published_immediately'] = 'Automatisch';
$string['rejected'] = 'Abgelehnt';
$string['rejectusers'] = 'Zurückweisen';
$string['reset'] = 'Rückgängig machen';
$string['reset_userdata'] = 'Alle Daten';
$string['resetstudentapproval'] = 'Freigabe der/des Teilnehmer/in rückgängig machen';
$string['save_changes'] = 'Änderungen speichern';
$string['saveapproval'] = 'Änderungen speichern';
$string['savestudentapprovalwarning'] = 'Möchten Sie diese Änderungen wirklich speichern? Der Status der Veröffentlichung kann im Nachhinein nicht mehr geändert werden.';
$string['saveteacherapproval'] = 'Änderungen speichern';
$string['search:activity'] = 'Openbook Ressourcenordner - Aktivitätsinformation';
$string['securewindowfromdate'] = 'Sicheres Browserfenster ab';
$string['securewindowfromdate_help'] = 'Wenn diese Option aktiviert ist, wird die Aktivität in einem sicheren Fenster geöffnet, das die Navigation ausblendet und keine Links zu anderen Teilen von Moodle anbietet. So sind beispielsweise während eines Testversuchs nur Links zu den zugelassenen Dateien sichtbar. Das sichere Fenster wird ab dem angegebenen Datum geöffnet.';
$string['securewindowsettings'] = 'Einstellungen für sicheres Browserfenster';
$string['securewindowtodate'] = 'Sicheres Browserfenster bis';
$string['securewindowtodate_help'] = 'Wenn diese Option aktiviert ist, wird die Aktivität in einem sicheren Fenster geöffnet, das die Navigation ausblendet und keine Links zu anderen Teilen von Moodle anbietet. So sind beispielsweise während eines Testversuchs nur Links zu den zugelassenen Dateien sichtbar. Das sichere Fenster endet am angegebenen Datum.';
$string['securewindowtodatevalidation'] = 'Das "Sicheres Browserfenster bis"-Datum muss nach dem "Sicheres Browserfenster ab"-Datum liegen.';
$string['sharedfilesnotshowing'] = 'Die "Geteilte Dateien"- Tabelle ist verborgen, da die Dateien persönlich sind.';
$string['show_details'] = 'Details anzeigen';
$string['status'] = 'Status';
$string['status:approved'] = 'Genehmigt';
$string['status:approvedautomatic'] = 'Automatisch';
$string['status:approvednot'] = 'Abgelehnt';
$string['status:approvedrevoke'] = 'Zurückgezogen';
$string['student_approve'] = 'Teilen';
$string['student_approved'] = 'Teilen von der Teilnehmerin / dem Teilnehmer freigegeben.';
$string['student_approved_automatically'] = 'Teilen von der Teilnehmerin / dem Teilnehmer automatisch freigegeben.';
$string['student_pending'] = 'Die Entscheidung der Teilnehmerin / des Teilnehmers steht noch aus.';
$string['student_reject'] = 'Nicht teilen';
$string['student_rejected'] = 'Teilen von der Teilnehmerin / dem Teilnehmer abgelehnt';
$string['studentapproval'] = 'Freigabe (Teilnehmer/innen)';
$string['studentapproval_help'] = 'In der Spalte "Freigabe (Teilnehmer/innen)" wird die Antwort der Teilnehmer/innen angezeigt:<br><ul><li><i class="fa fa-question fa-fw text-warning"></i> - Entscheidung ausstehend</li><li><i class="fa fa-check text-success fa-fw"></i> - Teilen freigegeben</li><li><i class="fa fa-times text-danger fa-fw"></i> - Teilen abgelehnt</li></ul>';
$string['studentswhosubmitted'] = 'Teilnehmer/in, die/der hochgeladen hat';
$string['submissionsettings'] = 'Upload-Einstellungen';
$string['submittedbystudents'] = 'Von Teilnehmer/innen hochgeladene Dateien';
$string['submittedbyteachers'] = 'Von Trainer/innen hochgeladene Dateien';
$string['teacher_approve'] = 'Genehmigen';
$string['teacher_approved'] = 'Von der/m Trainer/in genehmigt';
$string['teacher_approved_automatically'] = 'Von der/m Trainer/in automatisch genehmigt';
$string['teacher_files'] = 'Dateien von Trainer/innen';
$string['teacher_pending'] = 'Die Entscheidung der/s Trainer/in steht noch aus.';
$string['teacher_reject'] = 'Zurückweisen';
$string['teacher_rejected'] = 'Von der/m Trainer/in zurückgewiesen';
$string['teacherapproval'] = 'Approval';
$string['teacherapproval_help'] = 'Aktueller Status der Dateien (Genehmigung/Ablehnung), d. h. ob sie für alle Teilnehmer/innen sichtbar sind:<br><ul><li><strong>Auswählen...</strong> – Entscheidung ausstehend/keine Genehmigung erteilt oder abgelehnt, diese Dateien sind nicht sichtbar.</li><li><strong>Genehmigen</strong> – Genehmigung erteilt, diese Dateien sind veröffentlicht und somit für alle sichtbar.</li><li><strong>Ablehnen</strong> – keine Genehmigung erteilt, diese Dateien sind nicht veröffentlicht und somit nicht sichtbar.</li></ul>';
$string['teacherfiles'] = 'Dateien von Trainer/innen, die für alle sichtbar sind';
$string['total'] = 'Total';
$string['updatefiles'] = 'Dateien aktualisieren';
$string['updatefileswarning'] = 'Bereits importierte Dateien werden ersetzt oder gelöscht, wenn die Originaldateien in der Aufgabe aktualisiert oder gelöscht wurden. Die Einstellungen der Teilnehmer/innen, wie z. B. die Genehmigung zur Veröffentlichung, bleiben unverändert.';
$string['uploaded'] = 'Uploaded';
$string['uploadnotopen'] = 'Der Dateiupload ist geschlossen!';
$string['uselegacyviewer'] = 'Legacy PDF.js-Viewer verwenden';
$string['uselegacyviewer_help'] = 'Wenn diese Option aktiviert ist, wird der Legacy PDF.js-Viewer verwendet. Andernfalls wird der moderne PDF.js-Viewer verwendet. Der Legacy Viewer wird benötigt, wenn alte Browserversionen verwendet werden, die Probleme mit der Anzeige von PDF-Dateien mit dem modernen PDF.js-Viewer haben.';
$string['uselegacyviewer_no'] = 'Nein';
$string['uselegacyviewer_yes'] = 'Ja';
$string['viewallxsubmissions'] = 'Alle {$a} Dateiuploads ansehen';
$string['visibility'] = 'Veröffentlicht';
$string['visible'] = 'Veröffentlicht';
$string['visibleforstudents'] = 'Veröffentlicht';
$string['visibleforstudents_no'] = 'Diese Datei ist nicht veröffentlicht (für Teilnehmer/innen nicht sichtbar).';
$string['visibleforstudents_yes'] = 'Diese Datei ist veröffentlicht (für Teilnehmer/innen sichtbar).';
$string['withselected'] = 'Mit Auswahl ...';
$string['zipusers'] = 'Ausgewählte Dateiuploads herunterladen';
