<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_deepseek', language 'de', version '5.1'.
 *
 * @package     aiprovider_deepseek
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:explain_text:endpoint'] = 'API endpoint';
$string['action:explain_text:model'] = 'Texterklärungsmodell';
$string['action:explain_text:model_help'] = 'Das Modell, das zur Erklärung des bereitgestellten Textes verwendet wird.';
$string['action:explain_text:systeminstruction'] = 'Systemanweisung';
$string['action:explain_text:systeminstruction_help'] = 'Diese Anweisung wird zusammen mit der Nutzereingabe an das KI-Modell gesendet. Es wird empfohlen, diese Anweisung nicht zu bearbeiten, es sei denn, dies ist unbedingt erforderlich.';
$string['action:generate_text:endpoint'] = 'API Endpoint';
$string['action:generate_text:model'] = 'KI-Modell';
$string['action:generate_text:model_help'] = 'Das Modell, das zum Generieren der Textantwort verwendet wird.';
$string['action:generate_text:systeminstruction'] = 'Systemanweisung';
$string['action:generate_text:systeminstruction_help'] = 'Diese Anweisung wird zusammen mit der Nutzereingabe an das KI-Modell gesendet. Es wird empfohlen, diese Anweisung nicht zu bearbeiten, es sei denn, dies ist unbedingt erforderlich.';
$string['action:summarise_text:endpoint'] = 'API Endpoint';
$string['action:summarise_text:model'] = 'KI-Modell';
$string['action:summarise_text:model_help'] = 'Das Modell, das zum Zusammenfassen des bereitgestellten Textes verwendet wird.';
$string['action:summarise_text:systeminstruction'] = 'Systemanweisung';
$string['action:summarise_text:systeminstruction_help'] = 'Diese Anweisung wird zusammen mit der Nutzereingabe an das KI-Modell gesendet. Es wird empfohlen, diese Anweisung nicht zu bearbeiten, es sei denn, dies ist unbedingt erforderlich.';
$string['apikey'] = 'DeepSeek API-Key';
$string['apikey_help'] = 'Holen Sie sich einen Key von Ihren <a href="https://platform.deepseek.com/api_keys" target="_blank">DeepSeek-API-Schlüsseln</a>.';
$string['custom_model_name'] = 'Nutzerdefinierter Modellname';
$string['extraparams'] = 'Zusätzliche Parameter';
$string['extraparams_help'] = 'Hier können zusätzliche Parameter konfiguriert werden. Wir unterstützen das JSON-Format, z.B.:
<pre>
{
    "temperature": 0,5,
    "max_tokens": 100
}
</pre>';
$string['invalidjson'] = 'Ungültiger JSON-Text';
$string['pluginname'] = 'DeepSeek API-Provider';
$string['privacy:metadata'] = 'Das Plugin "DeepSeek API-Provider" speichert keine personenbezogenen Daten.';
$string['privacy:metadata:aiprovider_deepseek:externalpurpose'] = 'Diese Informationen werden an die DeepSeek-API gesendet, um eine Antwort zu generieren. Ihre DeepSeek-Kontoeinstellungen können die Art und Weise ändern, wie DeepSeek diese Daten speichert und aufbewahrt. Dieses Plugin sendet keine Nutzerdaten explizit an DeepSeek und speichert sie auch nicht in Moodle LMS.';
$string['privacy:metadata:aiprovider_deepseek:model'] = 'Das Modell, das zum Generieren der Antwort verwendet wird.';
$string['privacy:metadata:aiprovider_deepseek:prompttext'] = 'Der eingegebene Text-Prompt, der zum Generieren der Antwort verwendet wird.';
$string['settings'] = 'Einstellungen';
$string['settings_frequency_penalty'] = 'frequency_penalty';
$string['settings_frequency_penalty_help'] = 'Zahl zwischen -2.0 und 2.0. Positive Werte bestrafen neue Token basierend auf ihrer bisherigen Häufigkeit im Text und verringern die Wahrscheinlichkeit, dass das Modell dieselbe Zeile wörtlich wiederholt.';
$string['settings_help'] = 'Passen Sie die folgenden Einstellungen an, um festzulegen, wie Anfragen an DeepSeek gesendet werden.';
$string['settings_logprobs'] = 'logprobs';
$string['settings_logprobs_help'] = 'Diese Option gibt an, ob die Log-Wahrscheinlichkeiten der Ausgabetoken zurückgegeben werden sollen oder nicht. Bei "true" werden die Log-Wahrscheinlichkeiten jedes Ausgabetokens zurückgegeben, das im Inhalt der Nachricht zurückgegeben wird.';
$string['settings_logprobs_label'] = 'Aktivieren';
$string['settings_max_tokens'] = 'max_tokens';
$string['settings_max_tokens_help'] = 'Ganzzahl zwischen 1 und 8192. Die maximale Anzahl von Token, die im Chat-Abschluss generiert werden können. Die Gesamtlänge der Eingabetoken und generierten Token wird durch die Kontextlänge des Modells begrenzt. Wenn max_tokens nicht angegeben ist, wird der Standardwert 4096 verwendet.';
$string['settings_presence_penalty'] = 'presence_penalty';
$string['settings_presence_penalty_help'] = 'Zahl zwischen -2.0 und 2.0. Positive Werte bestrafen neue Token basierend darauf, ob sie bisher im Text vorkommen, und erhöhen so die Wahrscheinlichkeit, dass das Modell über neue Themen spricht.';
$string['settings_temperature'] = 'temperature';
$string['settings_temperature_help'] = 'Welche Abtasttemperatur soll verwendet werden, zwischen 0 und 2. Höhere Werte wie z.B. 0.8 machen die Ausgabe zufälliger, während niedrigere Werte wie 0.2 sie fokussierter und deterministischer machen. Wir empfehlen grundsätzlich, dies oder top_p zu ändern, aber nicht beides.';
$string['settings_top_logprobs'] = 'top_logprobs';
$string['settings_top_logprobs_help'] = 'Eine Ganzzahl zwischen 0 und 20, die die Anzahl der Token angibt, die mit der höchsten Wahrscheinlichkeit an jeder Tokenposition zurückgegeben werden, jeweils mit einer zugehörigen Log-Wahrscheinlichkeit. logprobs muss auf "true" gesetzt werden, wenn dieser Parameter verwendet wird.';
$string['settings_top_p'] = 'top_p';
$string['settings_top_p_help'] = 'Eine Alternative zur Stichprobennahme mit temperature ist die sogenannte Kernstichprobe. Dabei berücksichtigt das Modell die Ergebnisse der Token mit der höchsten Wahrscheinlichkeitsmasse. 0.1 bedeutet also, dass nur die Token mit der höchsten 10%-Wahrscheinlichkeitsmasse berücksichtigt werden. Wir empfehlen grundsätzlich, dies oder die temperature zu ändern, aber nicht beides.';
