<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_eadtraining', language 'pt_br', version '5.1'.
 *
 * @package     theme_eadtraining
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['access_course'] = 'Acessar o curso';
$string['access_course_buy'] = 'Detalhes do curso';
$string['acctoolbar_access_declaration'] = 'Declaração de acessibilidade';
$string['acctoolbar_btn_bright'] = 'Alto contraste';
$string['acctoolbar_btn_cursor_black'] = 'Cursor preto grande';
$string['acctoolbar_btn_cursor_white'] = 'Cursor branco grande';
$string['acctoolbar_btn_font_down'] = 'Diminuir texto';
$string['acctoolbar_btn_font_readable'] = 'Texto legível';
$string['acctoolbar_btn_font_up'] = 'Aumentar texto';
$string['acctoolbar_btn_images_titles'] = 'Títulos das imagens';
$string['acctoolbar_btn_invert'] = 'Contraste invertido';
$string['acctoolbar_btn_monochrome'] = 'Exibição sem cores';
$string['acctoolbar_btn_open'] = 'Menu de acessibilidade';
$string['acctoolbar_btn_underline_headers'] = 'Sublinhar cabeçalhos';
$string['acctoolbar_btn_underline_links'] = 'Sublinhar links';
$string['acctoolbar_btn_zoom_in'] = 'Ampliar tela';
$string['acctoolbar_content_block_header'] = 'Destacar conteúdo';
$string['acctoolbar_contrast_block_header'] = 'Contraste de cores';
$string['acctoolbar_debug_contacts'] = 'Reportar um problema de acessibilidade';
$string['acctoolbar_disable_animattions'] = 'Bloquear animações';
$string['acctoolbar_dyslexic'] = 'Fonte legível para dislexia';
$string['acctoolbar_image_without_alt'] = 'Imagem sem texto';
$string['acctoolbar_keyboard_root'] = 'Navegação por teclado';
$string['acctoolbar_reset_all_settings'] = 'Redefinir configurações';
$string['acctoolbar_text_block_header'] = 'Tamanho do texto';
$string['acctoolbar_toolbar'] = 'Acessibilidade';
$string['acctoolbar_zoom_block_header'] = 'Ampliar';
$string['add_block'] = '+ Adicionar novo bloco';
$string['advancedsettings'] = 'Configurações avançadas';
$string['background_profile_image'] = 'Imagem de fundo padrão do curso';
$string['background_profile_image_desc'] = 'Define uma imagem de fundo padrão para o cabeçalho de todos os cursos. Esta imagem será exibida no topo da página do curso e pode ser substituída individualmente nas configurações do curso.';
$string['backgroundimage'] = 'Imagem de fundo';
$string['backgroundimage_desc'] = 'A imagem a ser exibida como plano de fundo do site. A imagem de fundo enviada aqui substituirá a imagem de fundo nos arquivos predefinidos do seu tema.';
$string['brandcolor'] = 'Cor primária da interface';
$string['brandcolor_background_menu'] = 'Aplicar cor da marca ao fundo do menu';
$string['brandcolor_background_menu_desc'] = 'Esta configuração define se a cor definida em "Cor da marca" será aplicada aos itens do menu ou ao fundo do menu.<br>Se aplicada ao fundo, o texto do menu será exibido em branco para garantir o contraste adequado.';
$string['brandcolor_desc'] = 'Defina a cor de destaque usando a seleção acima ou escolhendo na paleta abaixo.';
$string['cachedef_course_cache'] = 'Cache de dados do curso';
$string['cachedef_course_module_cache'] = 'Cache de módulos do curso';
$string['cachedef_css_cache'] = 'Cache de folhas de estilo CSS';
$string['cachedef_data_cache'] = 'Cache de dados';
$string['cachedef_frontpage_cache'] = 'Cache da página inicial';
$string['choosereadme'] = 'O Ead Training é um tema moderno e altamente personalizável. Este tema pode ser usado diretamente ou como tema pai ao criar novos temas utilizando o Bootstrap 4.';
$string['configtitle'] = 'Ead Training';
$string['course_summary'] = 'Mostrar resumo do curso antes do Curso';
$string['course_summary_banner'] = 'Mostrar resumo do curso antes do Curso';
$string['course_summary_banner_desc'] = 'Se habilitado, o resumo do curso será exibido antes do conteúdo principal do curso na página do curso.';
$string['course_summary_banner_edit'] = 'Editar a imagem do banner deste curso';
$string['course_summary_banner_none'] = 'Sem cabeçalho';
$string['course_summary_banner_simple'] = 'Cabeçalho simples com informações';
$string['course_summary_banner_title'] = 'Cabeçalho com banner';
$string['course_summary_desc'] = 'Se habilitado, o resumo do curso será exibido antes do conteúdo principal do curso na página do curso.';
$string['courseindexoptions'] = 'Opções do índice do curso';
$string['coursesettings'] = 'Curso';
$string['delete_block_confirm'] = 'Tem certeza de que deseja excluir o bloco?';
$string['delete_block_success'] = 'Bloco excluído com sucesso';
$string['delete_block_title'] = 'Excluir bloco';
$string['details-completaram'] = 'Concluiu o curso';
$string['details-emprogresso'] = 'Em andamento';
$string['details-not-access'] = 'Nunca acessado';
$string['details-teachers'] = 'Professores';
$string['details-users'] = 'Estudantes';
$string['edit_block'] = 'Editar bloco';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'O favicon é exibido ao lado do título da página na aba do navegador. Caso não seja fornecido um favicon personalizado, será exibido o favicon padrão do Moodle.';
$string['footer_background_color'] = 'Cor de fundo do rodapé';
$string['footer_background_color_desc'] = 'Selecione a cor de fundo para a seção de rodapé do site. Deixe em branco para usar a cor primária.';
$string['footer_copywriter'] = 'Feito com ❤️';
$string['footer_heading'] = 'Bloco {$a}';
$string['footer_heading_description_desc'] = '<ul>
  <li><strong>Nenhum bloco preenchido:</strong> o rodapé não será exibido.</li>
  <li><strong>1 bloco preenchido:</strong> o conteúdo será exibido como texto, sem formatação de bloco.</li>
  <li><strong>2, 3 ou 4 blocos preenchidos:</strong> o tema ajustará automaticamente o layout para exibir os blocos de forma responsiva e proporcional.</li>
</ul>
Preencha apenas os blocos necessários, o tema cuidará do restante.';
$string['footer_heading_description_title'] = 'O tema se adapta automaticamente ao número de blocos de rodapé que você preencher:';
$string['footer_html'] = 'HTML do Bloco de Rodapé {$a}';
$string['footer_html_desc'] = 'Adicione o código HTML personalizado que será exibido no bloco de rodapé {$a}.';
$string['footer_show_copywriter'] = 'Mostrar Feito com ❤️';
$string['footer_show_copywriter_desc'] = 'Desmarque se quiser ocultar o "Feito com ❤️"';
$string['footer_title'] = 'Título do Bloco {$a}';
$string['footer_title_desc'] = 'Defina o título que aparecerá acima do conteúdo HTML no bloco de rodapé {$a}.';
$string['footersettings'] = 'Configurações do Rodapé';
$string['frontpage_add_block'] = 'Adicionar novo bloco';
$string['frontpage_add_block_title'] = 'Selecione o bloco de exemplo para adicionar';
$string['frontpage_change_editor'] = 'Criar a página inicial com o editor de Páginas?';
$string['frontpage_enable_editing'] = 'Habilite a edição para adicionar itens à página inicial';
$string['generalsettings'] = 'Configurações gerais';
$string['homesettings'] = 'Configurações da Página Inicial';
$string['imageacceptedtypes'] = 'Somente arquivos de imagem do tipo {$a} são permitidos';
$string['language_all'] = 'Todos os idiomas disponíveis';
$string['loginbackgroundimage'] = 'Imagem de fundo da página de login';
$string['loginbackgroundimage_desc'] = 'A imagem que será exibida como fundo na página de login.';
$string['pluginname'] = 'Ead Training';
$string['preview'] = 'Pré-visualização do bloco';
$string['privacy:drawerblockclosed'] = 'A preferência atual para a gaveta de blocos é fechada.';
$string['privacy:drawerblockopen'] = 'A preferência atual para a gaveta de blocos é aberta.';
$string['privacy:drawerindexclosed'] = 'A preferência atual para a gaveta de índice é fechada.';
$string['privacy:drawerindexopen'] = 'A preferência atual para a gaveta de índice é aberta.';
$string['privacy:metadata'] = 'O tema Ead Training não armazena nenhum dado pessoal de nenhum usuário.';
$string['privacy:metadata:preference:draweropenblock'] = 'A preferência do usuário para ocultar ou mostrar a gaveta com blocos.';
$string['privacy:metadata:preference:draweropenindex'] = 'A preferência do usuário para ocultar ou mostrar a gaveta com o índice do curso.';
$string['privacy:metadata:preference:draweropennav'] = 'A preferência do usuário para ocultar ou mostrar a navegação do menu da gaveta.';
$string['quickstart_alert_notadd'] = 'Não é possível alterar o banner da página inicial após ele ter sido adicionado. Para modificá-lo, é necessário ir até a <a href="{$a}/">página inicial</a> e excluir o banner existente.';
$string['quickstart_alert_notdelete'] = 'Não é possível remover blocos adicionados aqui. Para excluí-los, vá até a <a href="{$a}/">página inicial</a> e remova os blocos que você não deseja mais.';
$string['quickstart_banner-recreation-room'] = 'Sala de recreação';
$string['quickstart_banner-saved'] = 'As configurações foram salvas com sucesso.';
$string['quickstart_course_choose_below'] = 'Ou escolha um banner abaixo';
$string['quickstart_course_upload_or_choose'] = 'Envie uma imagem ou escolha o tipo de banner que deseja';
$string['quickstart_home_pagebuilder'] = 'Página inicial com Editor de Páginas';
$string['quickstart_home_pagebuilder_desc'] = 'Interface personalizável com seções editáveis.';
$string['quickstart_home_selectsections'] = 'Selecione as seções desejadas:';
$string['quickstart_home_selectstyle'] = 'Escolha o estilo da Página Inicial';
$string['quickstart_home_traditional'] = 'Página Inicial Tradicional do Moodle';
$string['quickstart_home_traditional_desc'] = 'Página inicial padrão do Moodle com blocos e cursos. Clique no botão abaixo para editar as configurações do sistema.';
$string['quickstart_settings_link'] = '<div class="card mb-5">
<div class="card-header">Início Rápido</div>
<div class="card-body"><a href="{$a}">Acesse o Guia de Início Rápido</a> e use o configurador intuitivo para personalizar estas e outras configurações do tema Ead Training.</div>
</div>';
$string['quickstart_title'] = 'Central de Configurações do Tema';
$string['region-side-pre'] = 'Direita';
$string['settings_accessibility'] = 'Ativar opções de acessibilidade';
$string['settings_accessibility_desc'] = 'Permite personalizar opções para melhorar a acessibilidade da plataforma, como contraste, tamanho da fonte e navegação por teclado.';
$string['settings_accessibility_heading'] = 'Acessibilidade';
$string['settings_icons_change_icons'] = 'Alterar o ícone padrão na lista de cursos';
$string['settings_icons_color_icon'] = 'Defina uma cor personalizada para o ícone.';
$string['settings_icons_color_icon_desc'] = 'Selecione a cor de fundo para o ícone exibido na lista de cursos. Deixe em branco para usar a cor padrão do tema.';
$string['settings_icons_upload_icon'] = 'Enviar ícone personalizado.';
$string['settings_icons_upload_image'] = 'Imagem de bloco';
$string['settings_icons_upload_image_desc'] = 'Se uma imagem for fornecida, o tema converterá a linha do módulo em um bloco, usando a imagem como fundo. A imagem deve ter proporção de 16:9.';
$string['showfooter'] = 'Exibir rodapé';
$string['top_color_heading'] = 'Cor do Topo ao Rolar';
$string['top_scroll_background_color'] = 'Cor de Fundo do Menu Superior ao Rolar';
$string['top_scroll_background_color_desc'] = 'Defina a cor de fundo ao rolar a página.';
$string['top_scroll_fix'] = 'Fixar o menu ao rolar a página';
$string['top_scroll_fix_desc'] = 'Quando habilitado, o menu ficará fixo no topo da tela enquanto você rola a página, garantindo fácil acesso às opções do menu.';
$string['userprofilesettings'] = 'Perfil do Usuário';
