<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'pt_br', version '5.1'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility:rate:choice'] = 'Linha {$a->rowposition}, {$a->choicetitle}: Coluna {$a->colposition}, {$a->choiceanswer}.';
$string['action'] = 'Ação';
$string['activityoverview'] = 'Você tem enquetes que estão atrasadas';
$string['additionalinfo'] = 'Informação Adicional';
$string['additionalinfo_help'] = 'Texto a ser mostrado no topo da primeira página desta enquete. (Ex. instruções etc.)';
$string['addnewquestion'] = 'Adicionando questão do tipo: {$a}';
$string['addnewsection'] = 'Adicionar nova seção';
$string['addquestion'] = 'Adicionar questão...';
$string['addquestions'] = 'Adicionar questões';
$string['addquestiontosection'] = 'Adicionar questão à seção';
$string['addselqtype'] = 'Adicionar tipo de questão selecionado';
$string['alignment'] = 'Alinhamento dos botões de rádio';
$string['alignment_help'] = 'Selecione o alinhamento dos botões: Vertical (padrão) ou Horizontal.';
$string['all'] = 'Todos';
$string['allnameddegrees'] = 'Níveis nomeados';
$string['allnameddegrees_help'] = 'Especifique o texto a ser exibido para os valores de classificação em vez do número. Deixe um valor em branco para não usar.';
$string['alreadyfilled'] = 'Você já preencheu esta enquete para nós{$a}. Obrigado.';
$string['andaveragevalues'] = 'e os valores médios';
$string['anonymous'] = 'Anônimo';
$string['answer'] = 'Resposta';
$string['answergiven'] = 'Esta resposta foi dada';
$string['answernotgiven'] = 'Esta resposta não foi dada';
$string['answerquestions'] = 'Responda às perguntas...';
$string['answers'] = 'Respostas';
$string['attempted'] = 'Esta enquete foi enviado.';
$string['attemptstillinprogress'] = 'Em andamento. Salvo em:';
$string['autonumbering'] = 'Numeração automática';
$string['autonumbering_help'] = 'A numeração automática de perguntas e páginas. Você pode querer desativar a numeração automática de enquetes com ramificação condicional.';
$string['autonumberno'] = 'Não numere as perguntas ou páginas';
$string['autonumberpages'] = 'Número de páginas Auto';
$string['autonumberpagesandquestions'] = 'Numerar automaticamente páginas e questões';
$string['autonumberquestions'] = 'Numerar automaticamente questões';
$string['average'] = 'Média';
$string['averageposition'] = 'Posição média';
$string['averagerank'] = 'Médias';
$string['averagesrow'] = 'Médias (quando aplicável):';
$string['bodytext'] = 'Texto do corpo';
$string['boxesnbexact'] = 'exatamente {$a} opção(ões).';
$string['boxesnbmax'] = 'no máximo {$a} opção(ões).';
$string['boxesnbmin'] = 'no mínimo {$a} opção(ões).';
$string['boxesnbreq'] = 'Para esta questão você deve marcar';
$string['by'] = 'por';
$string['cannotviewpublicresponses'] = 'Você não pode ver respostas desta enquete público.';
$string['centerlabel'] = 'Rótulo central';
$string['chart:bipolar'] = 'Barras bipolares';
$string['chart:hbar'] = 'Barras horizontais';
$string['chart:radar'] = 'Radar';
$string['chart:rose'] = 'Rosa';
$string['chart:type'] = 'Tipo de gráfico';
$string['chart:type_help'] = 'Selecione o tipo de gráfico que você quer utilizar neste feedback';
$string['chart:vprogress'] = 'Barra de progresso vertical';
$string['checkallradiobuttons'] = 'Por favor, selecione opção para o botão de rádio <strong>{$a}</strong>!';
$string['checkboxes'] = 'Caixas de Checagem';
$string['checkboxes_help'] = 'Entre uma opção por linha para o usuário selecionar uma ou múltiplas respostas.';
$string['checkbreaksadded'] = 'Nova quebra de página (s) inserido na posição (s):';
$string['checkbreaksok'] = 'Todas as quebras de página necessárias estão presentes!';
$string['checkbreaksremoved'] = 'Removido {$a} quebra de página (s) extra.';
$string['checknotstarted'] = 'Verificação não iniciada';
$string['checkstarted'] = 'Verificação iniciada';
$string['clicktoswitch'] = '(Clique para mudar)';
$string['closebeforeopen'] = 'Você especificou uma data de fechamento antes da data de abertura.';
$string['closed'] = 'A enquete foi encerrado em {$a}. Obrigado.';
$string['closedate'] = 'Permitir respostas até';
$string['closeson'] = 'Enquete fecha em {$a}';
$string['completionsubmit'] = 'Estudante deve enviar esta enquete para concluir a atividade';
$string['condition'] = 'Condição';
$string['confalts'] = '- OU - <br />Página de confirmação';
$string['configemailreporting'] = 'Permitir relatórios por e-mail';
$string['configemailreportinglong'] = 'Ativa opções para que alguns relatórios sejam enviados por e-mail diretamente para endereços de e-mail especificados.';
$string['configmaxsections'] = 'Máximo de seções de feedback';
$string['configusergraph'] = 'Exibir gráficos para feedback "Teste de personalidade"';
$string['configusergraphlong'] = 'Use o <a href="http://www.rgraph.net/">Rgraph</a> biblioteca para exibir "Teste de personalidade" cartas de feedback.';
$string['confirmdelallresp'] = 'Você tem certeza que deseja remover TODAS as respostas desta enquete?';
$string['confirmdelchildren'] = 'Se você excluir esta pergunta,  as perguntas filhas também serão excluídos:';
$string['confirmdeletesection'] = 'Tem certeza de que deseja excluir a seção de feedback "{$a}"?';
$string['confirmdelgroupresp'] = 'Você está certo que deseja remover TODAS as respostas de {$a}?';
$string['confirmdelquestion'] = 'Tem certeza que deseja excluir a questão na posição {$a}?';
$string['confirmdelquestionresps'] = 'Isso também irá apagar a(s) {$a} resposta(s) já dada(s) a essa pergunta.';
$string['confirmdelresp'] = 'Você está certo que deseja remover as respostas de&nbsp;{$a}&nbsp;?';
$string['confirmremovequestion'] = 'Tem certeza de que deseja remover a questão "{$a->qname}" da seção "{$a->sname}"?';
$string['confpage'] = 'Texto do cabeçalho';
$string['confpage_help'] = 'Título (em negrito) e corpo de texto para a "Confirmação" página exibida depois que um usuário completa esta enquete. (URL, se presente, tem precedência sobre o texto de confirmação.) Se você deixar este campo em branco, uma mensagem padrão será exibido após a conclusão da enquete (Obrigado por completar esta enquete).';
$string['confpagedesc'] = 'Cabeçalho (em negrito) e corpo do texto para a página de "Confirmação" apresentada após o usuário completar esta enquete. (A URL, se presente, tem precedência sobre o texto de confirmação.)';
$string['contentoptions'] = 'Opções de conteúdo';
$string['couldnotcreatenewsurvey'] = 'Não é possível criar uma nova enquete!';
$string['couldnotdelresp'] = 'Não foi possível remover resposta';
$string['createcontent'] = 'Defina Novo Conteúdo';
$string['createcontent_help'] = 'Selecione uma das opções entre as do botão de rádio. "Criar nova" e a padrão.';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'Criar novo';
$string['crontask'] = 'Tarefa de limpeza de enquete';
$string['date'] = 'Data';
$string['date_help'] = 'Utilize este tipo de questão se deseja que a resposta seja uma data corretamente formatada';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = 'Usar o formato dia/mês/ano, ou seja, <strong>14/3/1945</strong> para 14 de Março de 1945';
$string['deleteallresponses'] = 'Excluir TODAS as respostas';
$string['deletecurrentquestion'] = 'Excluir questão {$a}';
$string['deletedallgroupresp'] = 'Excluir TODAS as respostas no grupo {$a}';
$string['deletedallresp'] = 'Respostas da enquete excluídas';
$string['deletedisabled'] = 'Este item não pode ser excluído';
$string['deletedresp'] = 'Respostas removidas';
$string['deleteresp'] = 'Excluir esta resposta';
$string['deletesection'] = 'Excluir esta seção';
$string['deletingresp'] = 'Excluindo a resposta';
$string['dependencies'] = 'Dependências';
$string['dependquestion'] = 'Questão Pai';
$string['dependquestion_help'] = 'Você pode selecionar uma questão pai e uma opção de escolha para esta questão. Uma questão filha só será exibida para o estudante se a sua questão pai for previamente selecionada.';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = 'Não respondeu a questão';
$string['directwarnings'] = 'As dependências diretas para esta questão serão removidas. Isso afetará:';
$string['displaymethod'] = 'Método de apresentação não definido para questão.';
$string['download'] = 'Baixar';
$string['downloadpdf'] = 'Baixar em formato PDF';
$string['downloadtextformat'] = 'Baixar em formato texto';
$string['downloadtextformat_help'] = 'Este recurso permite que você faça o download das respostas do questionário em um formato de arquivo de sua escolha.
O arquivo pode ser aberto em um programa de planilha (por exemplo, MS Excel ou Open Office Calc) ou em um pacote estatístico para processamento posterior.';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['downloadtypes'] = 'Tipo de relatório';
$string['dropdown'] = 'Caixa de Menu';
$string['dropdown_help'] = 'Não há vantagem real em utilizar a caixa de seleção ao invés de botões de rádio exceto pela longa lista de opções, para salvar espaço na tela.';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'Editar';
$string['editingfeedback'] = 'Editando as configurações de feedback';
$string['editingquestionnaire'] = 'Editar Configurações da Enquete';
$string['editquestion'] = 'Editando questão do tipo: {$a}';
$string['email'] = 'E-mail para enviar cópia das respostas';
$string['emailextra'] = 'Enviar download para emails';
$string['emailextra_help'] = 'Irá enviar o arquivo de download aos endereços de e-mail listados, separados por vírgulas. Observe que NENHUMA verificação de segurança ou privacidade é feita. \'allowemailreporting\' deve ser habilitado nas configurações do módulo para acessá-lo.';
$string['emailroles'] = 'Enviar download para papéis';
$string['emailroles_help'] = 'Enviará o arquivo de download para todas os papéis com permissão "mod/questionnaire:submissionnotification" por e-mail. \'allowemailreporting\' deve ser habilitado nas configurações do módulo para acessá-lo.';
$string['emailsend'] = 'Enviar relatórios';
$string['emailsnotspecified'] = 'Nenhum email foi especificado.';
$string['emailssent'] = 'Downloads enviados para e-mail(s) especificado(s).';
$string['errnewname'] = 'Lamentamos, mas o nome já está em uso. Utilize outro nome.';
$string['erroropening'] = 'Erro ao abrir enquete.';
$string['errortable'] = 'Erro de sistema: tabela corrompida.';
$string['essaybox'] = 'Campo de Texto';
$string['essaybox_help'] = 'Esta questão exibirá uma caixa de texto simples com x colunas Textarea (ou largura da área) e y linhas Textarea (número de linhas de texto).

Se você deixar x e y com o valor padrão 0 (ou se você definir como 0), então o editor HTML do Moodle será exibido com altura e largura padrão (se disponível no curso/contexto do usuário e perfil do usuário).';
$string['event_all_responses_deleted'] = 'Todas as respostas foram excluídas';
$string['event_all_responses_saved_as_text'] = 'Todas as respostas foram salvas como texto';
$string['event_all_responses_viewed'] = 'Todos os relatórios de respostas visualizados';
$string['event_individual_responses_viewed'] = 'Relatórios de respostas individuais visualizados';
$string['event_non_respondents_viewed'] = 'Não respondentes visualizados';
$string['event_previewed'] = 'Enquete visualizada';
$string['event_question_created'] = 'Questão criada';
$string['event_question_deleted'] = 'Questão deletada';
$string['event_response_deleted'] = 'Resposta individual deletada';
$string['event_resumed'] = 'Tentativa retomada';
$string['event_saved'] = 'As respostas foram salvas';
$string['event_submitted'] = 'As respostas foram submetidas';
$string['feedback'] = 'Feedback';
$string['feedback_help'] = 'Ajuda do feedback';
$string['feedbackaddmorefeedbacks'] = 'Adicionar mais {no} campos de feedback';
$string['feedbackbysection'] = 'Feedback das seções';
$string['feedbackdefaultlabel'] = '[Nova seção]';
$string['feedbackeditingglobal'] = 'Editando o feedback global da enquete';
$string['feedbackeditingmessages'] = 'Editando as mensagens de feedback da enquete';
$string['feedbackeditingsections'] = 'Editando as seções de feedback da enquete';
$string['feedbackeditmessages'] = 'Salvar configurações das seções e editar mensagens de feedback';
$string['feedbackeditsections'] = 'Salvar configurações e editar seções de feedback';
$string['feedbackerrorboundaryformat'] = 'Limites de pontuação do feedback devem ser um percentual ou um número. O valor inserido no limite {$a} não é reconhecido.';
$string['feedbackerrorboundaryoutofrange'] = 'Limites de pontuação do feedback devem estar entre 0% e 100%. O valor que você informou no limite {$a} está fora deste intervalo.';
$string['feedbackerrorjunkinboundary'] = 'Você deve preencher as caixas do limite da pontuação do feedback sem deixar lacunas.';
$string['feedbackerrorjunkinfeedback'] = 'Você deve preencher as caixas de feedback sem deixar lacunas.';
$string['feedbackerrororder'] = 'Limites de pontuação do feedback devem estar em ordem, com o maior primeiro. O valor inserido no limite {$a} está fora da seqüência.';
$string['feedbackglobal'] = 'Feedback global';
$string['feedbackglobalheading'] = 'Título do feedback global';
$string['feedbackglobalmessages'] = 'Mensagens de feedback globais';
$string['feedbackhdr'] = 'Feedbacks';
$string['feedbackheading'] = 'Título do feedback';
$string['feedbackheading_help'] = 'No campo de título do feedback você pode usar duas variáveis: $scorepercent e $oppositescorepercent.';
$string['feedbackmessages'] = 'Mensagens da seção {$a}';
$string['feedbacknextsection'] = 'Próxima seção {$a}';
$string['feedbacknone'] = 'Sem mensagens de feedback';
$string['feedbacknotes'] = 'Notas de feedback';
$string['feedbacknotes_help'] = 'O texto inserido aqui será apresentado aos respondentes no final de seu relatório de feedback';
$string['feedbackoptions'] = 'Opções de feedback';
$string['feedbackoptions_help'] = 'As opções de feedback estão disponíveis se o seu questionário contiver os seguintes tipos de questão e configurações da questão:
Botões de rádio; Caixa suspensa; Sim/Não; Avaliação (escala normal ou de Osgood) ou controle deslizante. Essas questões devem ser definidas como Obrigatórias, o campo Nome da Questão NÃO deve estar vazio e as escolhas de respostas possíveis devem conter um valor.
As questões de controle deslizante NÃO devem usar um valor negativo para o intervalo mínimo do controle do controle deslizante.';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovequestionfromsection'] = 'Esta questão faz parte de uma seção de comentários [{$a}]';
$string['feedbackremovesection'] = 'Remover esta questão irá remover completamente a seção de feedback [{$a}]';
$string['feedbackreport'] = 'Relatório de Feedback';
$string['feedbackscore'] = 'Pontuação de feedback';
$string['feedbackscoreboundary'] = 'Limite da pontuação de feedback';
$string['feedbackscores'] = 'Mostrar pontuações';
$string['feedbackscores_help'] = 'Mostrar a tabela da pontuação de feedback';
$string['feedbacksection'] = 'Seção';
$string['feedbacksectionheading'] = 'Título de feedback para a seção {$a}';
$string['feedbacksectionheadingmissing'] = 'Você deve digitar um título para esta seção Feedback!';
$string['feedbacksectionheadingtext'] = 'Título';
$string['feedbacksectionlabel'] = 'Rótulo';
$string['feedbacksectionlabel_help'] = 'Este rótulo será utilizado nos gráficos/diagramas. Por favor, mantenha-o mais curto possível!';
$string['feedbacksectionquestions'] = '{$a} seção de questões';
$string['feedbacksections'] = 'Seções de feedback';
$string['feedbacksectionsselect'] = 'Seções';
$string['feedbacksectionsselect_help'] = 'Coloque as suas questões para essas seções';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'Configurações de feedback salvas';
$string['feedbacktype'] = 'Tipo de feedback';
$string['field'] = 'Questão {$a}';
$string['fieldlength'] = 'Tamanho da caixa texto';
$string['fieldlength_help'] = 'Para a caixa de texto ** ** tipo de pergunta, digite o comprimento ** ** Caixa de Entrada eo comprimento do texto ** ** máxima do texto a ser digitado pelo entrevistado. Os valores padrão são 20 caracteres para a largura da caixa de entrada e 25 caracteres para o comprimento máximo do texto digitado.';
$string['finished'] = 'Você respondeu todas as perguntas na enquete!';
$string['firstrespondent'] = 'Primeiro respondente';
$string['formateditor'] = 'Editor HTML';
$string['formatplain'] = 'Texto plano';
$string['grade'] = 'Escala de notas';
$string['gradesdeleted'] = 'Notas da enquete deletadas';
$string['headingtext'] = 'Texto do cabeçalho';
$string['horizontal'] = 'Horizontal';
$string['id'] = 'ID';
$string['includechoicecodes'] = 'Incluir códigos de escolhas';
$string['includechoicetext'] = 'Incluir textos de escolhas';
$string['includeincomplete'] = 'Incluir respostas incompletas';
$string['includerankaverages'] = 'Incluir médias de questões de classificação';
$string['incorrectcourseid'] = 'ID do curso é incorreto';
$string['incorrectmodule'] = 'ID do módulo do curso é incorreto';
$string['incorrectquestionnaire'] = 'Enquete é incorreta';
$string['indirectwarnings'] = 'Esta lista mostra as questões indiretamente dependentes e as dependências restantes para questões diretamente dependentes:';
$string['invalidminmaxrange'] = 'Este tipo de questão suporta um intervalo máximo absoluto de -100 a +100. Esperamos que a grande maioria dos questionários use um intervalo de 1-10 ou -10 a +10.';
$string['invalidrange'] = 'O valor máximo do controle deslizante deve ser maior que o valor mínimo.';
$string['invalidresponse'] = 'Foi especificada uma resposta inválida.';
$string['invalidresponserecord'] = 'Foi especificado um registro de resposta inválido.';
$string['invalidsectionid'] = 'A seção de feedback especificada é inválida.';
$string['invalidstartingvalue'] = 'O valor inicial deve ser igual ou estar entre os valores mínimo e máximo. Por exemplo, se estiver usando uma escala de 1-10, o valor inicial pode ser 5.';
$string['invalidsurveyid'] = 'ID inválido para enquete.';
$string['kindofratescale'] = 'Tipo de escala de avaliação';
$string['kindofratescale_help'] = 'Clique com o botão direito no link "Mais ajuda" logo abaixo.';
$string['lastrespondent'] = 'Último respondente';
$string['leftlabel'] = 'Rótulo esquerdo';
$string['leftpart'] = '{$a->min} é {$a->leftlabel}';
$string['leftpartdefault'] = '{$a->min} é a faixa mínima do controle deslizante';
$string['length'] = 'Tamanho';
$string['managequestions'] = 'Gerenciar questões';
$string['managequestions_help'] = 'Na seção Gerenciar perguntas da página Editar perguntas, você pode realizar uma série de operações nas perguntas da enquete.';
$string['mandatory'] = 'Obrigatório - Todas essas dependências devem ser atendidas.';
$string['maxdigitsallowed'] = 'Número máximo de dígitos';
$string['maxdigitsallowed_help'] = 'Use **Número máximo de dígitos permitidos** para definir um limite para o número de caracteres inseridos em uma questão Numérica. Observe que o ponto decimal também conta como um caractere!';
$string['maxforcedresponses'] = 'Número máximo de marcações';
$string['maxforcedresponses_help'] = 'Use esses parâmetros para forçar o respondente a marcar um mínimo de ** Min. ** caixas e um máximo de ** Max. ** caixas de seleção. Para forçar a marcação de um número exato de caixas de seleção, defina ** Min. ** e ** Max. ** com o mesmo valor. Se apenas um valor mínimo ou máximo for desejado, apenas deixe o outro valor com seu valor padrão ** 0 **. Se você definir ** Min. ** ou ** Max. ** para valores diferentes do valor ** 0 ** padrão, uma mensagem de aviso será exibida se o respondente não cumprir seus requisitos. Obviamente, você deve deixar quaisquer requisitos claros para o respondente, seja nas instruções gerais da sua enquete ou no texto das questões relevantes.';
$string['maxrange'] = 'Faixa máxima do controle deslizante (direita)';
$string['maxrange_help'] = 'Defina o valor máximo da faixa no lado direito. O padrão é 100, mas pode ser qualquer número entre 1-100. Se o valor mínimo do lado esquerdo for um valor negativo, a faixa máxima será expressa com um sinal positivo (+).';
$string['maxtextlength'] = 'Tamanho máximo do texto';
$string['maxtextlength_help'] = 'Para o tipo de questão Caixa de texto, insira o comprimento da caixa de entrada e o comprimento máximo do texto a ser inserido pelo respondente. Os valores padrão são 20 caracteres para a largura da caixa de entrada e 25 caracteres para o comprimento máximo do texto inserido.';
$string['messageprovider:message'] = 'Lembrete de enquete';
$string['messageprovider:notification'] = 'Submissão de Enquete';
$string['middlepart'] = ', {$a->centreval} é {$a->middlelabel}';
$string['middlepartdefault'] = ', {$a->centreval} é a média';
$string['middlepartwithtwovalues'] = ', {$a->centreval1} e {$a->centreval2} são {$a->middlelabel}';
$string['middlepartwithtwovaluesdefault'] = ', {$a->centreval1} e {$a->centreval2} são a média';
$string['minforcedresponses'] = 'Número mínimo de marcações';
$string['minforcedresponses_help'] = 'Use esses parâmetros para forçar entrevistado assinalar um mínimo de ** min. ** Caixas e um máximo de Max **. ** Caixas de seleção. Para forçar um número exato de caixas de seleção para ser assinalada, definir Min **. ** E ** Max. ** Para o mesmo valor. Se apenas min ou um valor máximo é desejado, é só deixar o outro valor para o padrão ** 0 ** valor. Se você definir Min **. ** Ou ** Max. ** Para valores diferentes de seu padrão ** 0 ** valor, uma mensagem de advertência será exibida se entrevistado não está de acordo com suas exigências. Obviamente, você deve fazer quaisquer requisitos claros para o entrevistado ou nas instruções gerais da enquete ou no texto de questões relevantes.';
$string['minrange'] = 'Faixa mínima do controle deslizante (esquerda)';
$string['minrange_help'] = 'Defina o valor mínimo da faixa no lado esquerdo. O padrão é 1, mas pode ser definido até -100. Se você usar um número negativo (-100 a -1), o valor máximo à direita será expresso com um sinal positivo (+).';
$string['misconfigured'] = 'Curso está mal configurado';
$string['missingname'] = 'Questão {$a} não pode ser utilizada na presente seção de feeedback porque ela não tem nome.';
$string['missingnameandrequired'] = 'Questão {$a} não pode ser utilizada na presente seção de feeedback porque não tem um nome e não é obrigatória.';
$string['missingquestion'] = 'Por favor, responda à questão obrigatória';
$string['missingquestions'] = 'Por favor, responda às questões obrigatórias:';
$string['missingrequired'] = 'Questão {$a} não pode ser utilizada na presente seção de feeedback porque não é obrigatória.';
$string['modulename'] = 'Enquete';
$string['modulename_help'] = 'O módulo enquete permite que você construa pesquisas usando diversos tipos de questões, com o objetivo de coletar dados dos usuários.';
$string['modulenameplural'] = 'Enquetes';
$string['movedisabled'] = 'Este item não pode ser movido';
$string['myresponses'] = 'Todas as suas respostas';
$string['myresponsetitle'] = 'Suas {$a} respostas';
$string['myresults'] = 'Seus Resultados';
$string['name'] = 'Nome';
$string['navigate'] = 'Permitir questões de ramificação';
$string['navigate_help'] = 'Habilitar as questões Sim/Não e Botões de Rádio para ter questões filhas que dependam de suas escolhas em sua enquete.';
$string['navigatetosection'] = 'Vá para a seção de feedback';
$string['next'] = 'Próximo';
$string['nextpage'] = 'Próxima página';
$string['nlines'] = '{$a} linhas';
$string['noanswer'] = 'Sem resposta';
$string['noattempts'] = 'Não foram feitas tentativas nessa enquete';
$string['nodata'] = 'Nenhum dado foi postado.';
$string['noduplicates'] = 'Sem duplicações de escolhas';
$string['noduplicateschoiceserror'] = 'Você deve digitar pelo menos 2 respostas possíveis para a opção "Sem opções duplicadas"!';
$string['non_respondents'] = 'Usuários que ainda não enviaram as suas respostas a esta enquete';
$string['noneinuse'] = 'Esta enquete não contém questões.';
$string['nopermissions'] = 'Desculpe, mas você não tem permissões para ver esta página ou realizar esta ação no momento.';
$string['nopublicsurveys'] = 'Não há enquetes públicas.';
$string['noresponsedata'] = 'Sem respostas para esta questão.';
$string['noresponses'] = 'Sem respostas';
$string['normal'] = 'Normal';
$string['not_started'] = 'não começou';
$string['notanumber'] = '<strong>{$a}</strong> não é um formato aceito para números.';
$string['notapplicable'] = 'N/A';
$string['notapplicablecolumn'] = 'Com coluna N/A (não aplicável)';
$string['notavail'] = 'Este questionário não está mais disponível. Peça ao seu professor para excluí-lo.';
$string['noteligible'] = 'Você não faz parte do público alvo desta enquete.';
$string['notemplatesurveys'] = 'Não há enquetes modelo.';
$string['notenoughscaleitems'] = 'Você deve inserir um valor mínimo de 2 itens de escala!';
$string['notificationfull'] = 'Envio completo';
$string['notifications'] = 'Enviar notificações de submissão';
$string['notifications_help'] = 'Notificar funções com a capacidade "mod/questionnaire:submissionnotification" quando um envio for feito.';
$string['notificationsimple'] = 'Notificação somente';
$string['notopen'] = 'Esta enquete só será aberta em {$a}.';
$string['notrequired'] = 'Resposta não é necessária';
$string['notset'] = 'não configurado';
$string['nousersselected'] = 'Nenhum usuário selecionado';
$string['num'] = '#';
$string['numattemptsmade'] = '{$a} tentativas feitas nesta enquete';
$string['numberfloat'] = 'O número que você digitou <strong>{$a->number}</strong> foi reformatado/arredondado com <strong>{$a->precision}</strong> casa(s) decimal(ais).';
$string['numberofdecimaldigits'] = 'Número de casas decimais';
$string['numberofdecimaldigits_help'] = 'Use ** Nb de dígitos decimais ** para especificar o formato do valor médio contado e exibido na página Relatório da Enquete.';
$string['numberscaleitems'] = 'Número de itens da escala';
$string['numberscaleitems_help'] = 'N º de itens da escala é o número * de itens * para ser usado em sua escala de taxa. Você usaria normalmente um valor de 3 a 5. Valor padrão: ** 5 **.';
$string['numeric'] = 'Campo Numérico';
$string['numeric_help'] = 'Utilize este tipo de questão se deseja que a resposta seja um número corretamente formatado';
$string['of'] = 'de';
$string['openafterclose'] = 'Você especificou uma data de abertura após a data de fechamento';
$string['opendate'] = 'Permitir respostas de';
$string['option'] = 'opção {$a}';
$string['optional'] = 'Opcional - Pelo menos uma dessas dependências deve ser atendida.';
$string['optionalname'] = 'Nome da Questão';
$string['optionalname_help'] = 'O nome da questão só é usada quando você exporta as respostas para o formato CSV / Excel.
Se você nunca exportar para CSV, então você não precisa se preocupar com nomes pergunta.
Se você planeja exportar seus dados da enquete regularmente para CSV, então você tem uma escolha de duas opções para a questão de nomenclatura.';
$string['or'] = '- OU -';
$string['order_ascending'] = 'Ordem acendente';
$string['order_default'] = 'Visualizar ordem padrão';
$string['order_descending'] = 'Ordem descendente';
$string['orderresponses'] = 'Ordem por respostas';
$string['orderresponses_help'] = 'Ao exibir todas as respostas que você pode encomendar as escolhas por número de respostas (a coluna média) para o seguinte
  4 tipos de perguntas.

* Botão de rádio escolhas individuais
* Escolhas única lista suspensa
* Múltiplas escolhas (caixas de seleção)
* Questões de taxa (incluindo escalas de Likert).

Quando você chegar na página de respostas All, por padrão, todas as respostas são ordenados na ordem em que o criador da enquete informou nas escolhas de perguntas.
  Você pode escolher para ordená-las por ordem crescente ou decrescente.';
$string['osgood'] = 'Diferencial Semântico (Osgood)';
$string['other'] = 'Outro:';
$string['otherempty'] = 'Se você marcar esta opção você deverá digitar algum texto na caixa de texto!';
$string['overviewnumresplog'] = 'respostas';
$string['overviewnumresplog1'] = 'resposta';
$string['overviewnumrespvw'] = 'respostas';
$string['overviewnumrespvw1'] = 'respostas';
$string['owner'] = 'Proprietário';
$string['page'] = 'Página';
$string['pageof'] = 'Página {$a->page} de {$a->totpages}';
$string['parent'] = 'Pai';
$string['participant'] = 'Participante';
$string['pleasecomplete'] = 'Por favor complete essa escolha.';
$string['pluginadministration'] = 'Administração da Enquete';
$string['pluginname'] = 'Enquete';
$string['position'] = 'posição';
$string['possibleanswers'] = 'Respostas possíveis';
$string['posteddata'] = 'Reached page with posted data:';
$string['preview_label'] = 'Pré-visualização';
$string['preview_questionnaire'] = 'Pré-visualização da enquete';
$string['previewing'] = 'Pré-visualizando Enquete';
$string['previous'] = 'anterior';
$string['previouspage'] = 'Página Anterior';
$string['print'] = 'Imprimir esta Resposta';
$string['printblank'] = 'Imprimir em Branco';
$string['printblanktooltip'] = 'Abrir janela de visualização de impressão com a enquente em branco';
$string['printtooltip'] = 'Abrir uma janela de visualização de impressão com as respostas correntes';
$string['privacy:metadata:questionnaire_resp_multiple'] = 'Uma resposta de questão de múltipla escolha.';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'O ID de um registro escolhido para esta resposta.';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'O ID do registro da questão para esta resposta.';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'O ID do registro de resposta para esta resposta.';
$string['privacy:metadata:questionnaire_resp_single'] = 'Uma resposta de questão de escolha única.';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'O ID do registro de escolha para esta resposta.';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'O ID do registro da questão para esta resposta.';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'O ID do registro de resposta para esta resposta.';
$string['privacy:metadata:questionnaire_response'] = 'Uma resposta em andamento ou enviada';
$string['privacy:metadata:questionnaire_response:complete'] = 'O status de conclusão da resposta.';
$string['privacy:metadata:questionnaire_response:grade'] = 'A nota para esta resposta.';
$string['privacy:metadata:questionnaire_response:questionnaireid'] = 'O ID do registro da enquete para esta resposta.';
$string['privacy:metadata:questionnaire_response:submitted'] = 'O registro de data/hora para o salvamento mais recente desta resposta.';
$string['privacy:metadata:questionnaire_response:userid'] = 'O ID do usuário para esta resposta.';
$string['privacy:metadata:questionnaire_response_bool'] = 'Uma resposta de questão booleana (sim/não).';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'A resposta booleana específica.';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'O ID do registro da questão para esta resposta.';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'O ID do registro de resposta para esta resposta.';
$string['privacy:metadata:questionnaire_response_date'] = 'Uma resposta de questão de data.';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'O ID do registro da questão para esta resposta.';
$string['privacy:metadata:questionnaire_response_date:response'] = 'A data específica de resposta.';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'O ID do registro de resposta para esta resposta.';
$string['privacy:metadata:questionnaire_response_other'] = 'Uma "outra" escolha de resposta de texto.';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'O ID do registro de escolha para esta resposta.';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'O ID do registro da questão para esta resposta.';
$string['privacy:metadata:questionnaire_response_other:response'] = 'A resposta de texto específica.';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'O ID do registro de resposta para esta resposta.';
$string['privacy:metadata:questionnaire_response_rank'] = 'Uma resposta de questão de classificação.';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'O ID do registro de escolha para esta resposta.';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'O ID do registro da questão para esta resposta.';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = 'A resposta de classificação específica.';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'O ID do registro de resposta para esta resposta.';
$string['privacy:metadata:questionnaire_response_text'] = 'Uma resposta de questão de texto.';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'O ID do registro da questão para esta resposta.';
$string['privacy:metadata:questionnaire_response_text:response'] = 'A resposta de texto específica.';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'O ID do registro de resposta para esta resposta.';
$string['private'] = 'Privativa';
$string['progressbar'] = 'Mostrar barra de progresso';
$string['progressbar_info'] = 'Questionnaire {$a} completo.';
$string['progresshelp'] = 'Barra de progresso';
$string['progresshelp_help'] = 'Passe para a próxima página para preencher a barra de progresso';
$string['public'] = 'Público';
$string['publiccopy'] = 'Cópia:';
$string['publicoriginal'] = 'Original:';
$string['qtype'] = 'Tipo';
$string['qtype_help'] = 'Selecione caso um usuário tenha permissão para responder uma vez,  diariamente, semanalmente, mensalmente ou um número ilimitado de vezes (muitas)';
$string['qtypedaily'] = 'responder diariamente';
$string['qtypemonthly'] = 'responder mensalmente';
$string['qtypeonce'] = 'responder uma única vez';
$string['qtypeunlimited'] = 'responder várias vezes';
$string['qtypeweekly'] = 'responder semanalmente';
$string['questionnaire:addinstance'] = 'Adicionar nova enquete';
$string['questionnaire:copysurveys'] = 'Copiar enquetes modelo e privadas';
$string['questionnaire:createpublic'] = 'Criar enquetes públicas';
$string['questionnaire:createtemplates'] = 'Criar enquetes modelo';
$string['questionnaire:deleteresponses'] = 'Excluir qualquer resposta';
$string['questionnaire:downloadresponses'] = 'Baixar respostas em formato CSV';
$string['questionnaire:editquestions'] = 'Criar e editar questões em enquetes';
$string['questionnaire:manage'] = 'Criar e editar enquetes';
$string['questionnaire:message'] = 'Enviar mensagem para não respondentes';
$string['questionnaire:preview'] = 'Prévia da enquete';
$string['questionnaire:printblank'] = 'Imprimir enquete em branco';
$string['questionnaire:readallresponseanytime'] = 'Ler todas as respostas em qualquer instante';
$string['questionnaire:readallresponses'] = 'Ler resumo de respostas, sujeito ao horário de abertura';
$string['questionnaire:readownresponses'] = 'Ler as próprias respostas';
$string['questionnaire:submissionnotification'] = 'Receber notificação para cada submissão';
$string['questionnaire:submit'] = 'Completar e enviar uma enquete';
$string['questionnaire:view'] = 'Visualizar enquete';
$string['questionnaire:viewsingleresponse'] = 'Visualizar respostas individuais';
$string['questionnaireadministration'] = 'Administração da Enquete';
$string['questionnairecloses'] = 'Encerramento da enquete';
$string['questionnaireopens'] = 'Abertura da enquete';
$string['questionnairereport'] = 'Relatório da Enquete';
$string['questionnum'] = 'Questão #';
$string['questions'] = 'Questões';
$string['questionsinsection'] = 'Questões nesta seção:';
$string['questiontypes'] = 'Tipos de Questões';
$string['questiontypes_help'] = 'Verifique a documentação do Moodle abaixo';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'Botões de Rádio';
$string['radiobuttons_help'] = 'Neste tipo de seleção, o respondente precisa selecionar uma das escolhar oferecidas.';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'Rank';
$string['ratescale'] = 'Avaliação (escala 1..5)';
$string['ratescale_help'] = 'Verifique a documentação Moodle abaixo';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'Tipo de Enquete';
$string['realm_help'] = '* ** Há três tipos de enquetes: **
* Privada  - pertence somente ao curso definido.
* Modelo  - pode ser copiado e editado.
* Pública  - pode ser compartilhada entre os cursos.';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'URL que o usuário é redirecionado após completar esta enquete.';
$string['remove'] = 'Excluir';
$string['removeallquestionnaireattempts'] = 'Excluir todas as respostas da enquete';
$string['removenotinuse'] = 'Esta enquete dependia de uma enquete público que foi excluída.
Não pode mais ser usada e deve ser excluída.';
$string['required'] = 'Resposta obrigatória';
$string['required_help'] = 'Se você selecionar  ***Sim***, a resposta a esta pergunta será obrigatória, ou seja, o respondente não será capaz de enviar a enquete até que esta pergunta seja respondida.';
$string['requiredparameter'] = 'Um parâmetro obrigatório não foi informado.';
$string['reset'] = 'Limpar';
$string['respeligiblerepl'] = '(substituído por sobreposição de permissões)';
$string['respondent'] = 'Respondente';
$string['respondenteligibleall'] = 'todos';
$string['respondenteligiblestudents'] = 'apenas estudantes';
$string['respondenteligibleteachers'] = 'apenas professores';
$string['respondents'] = 'Respondentes';
$string['respondenttype'] = 'Tipo do respondente';
$string['respondenttype_help'] = 'Você pode exibir nomes de seus usuários completos com cada resposta, definindo-o como &quot;fullname&quot;. Você pode ocultar identidades de seus usuários a partir das respostas, definindo-o como &quot;anônimo&quot;.';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'anônimo';
$string['respondenttypefullname'] = 'nome completo';
$string['response'] = 'Resposta';
$string['responsefieldlines'] = 'Tamanho da caixa de entrada';
$string['responseformat'] = 'Formato de resposta';
$string['responseoptions'] = 'Opções de respostas';
$string['responses'] = 'Respostas';
$string['responseview'] = 'Estudantes podem visualizar TODAS as respostas';
$string['responseview_help'] = 'Você pode especificar quem pode ver as respostas de todos os respondentes às enquete apresentados (tabelas gerais de estatísticas).';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'Sempre';
$string['responseviewstudentsnever'] = 'Nunca';
$string['responseviewstudentswhenanswered'] = 'Depois de responder a enquete';
$string['responseviewstudentswhenclosed'] = 'Depois de encerrada a enquete';
$string['restrictedtoteacher'] = 'Estas funções são restritas aos professores!';
$string['resume'] = 'Salvar/Retomar respostas';
$string['resume_help'] = 'Definir esta opção permite que os usuários salvem suas respostas a uma enquete antes de submetê-las.
Os usuários podem deixar a enquete inacabada e retomar a partir do ponto de salvaguarda em uma data posterior.';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'Retomar enquete';
$string['return'] = 'Retornar';
$string['rightlabel'] = 'Rótulo direito';
$string['rightpart'] = 'e {$a->max} é {$a->rightlabel}';
$string['rightpartdefault'] = 'e {$a->max} é a faixa máxima do controle deslizante';
$string['save'] = 'Salvar preenchimento parcial';
$string['save_and_exit'] = 'Salvar e sair';
$string['saveasnew'] = 'Salvar como Nova Questão';
$string['savedbutnotsubmitted'] = 'Esta enquete foi salva, mas ainda não foi enviada.';
$string['savedprogress'] = 'Suas respostas foram salvas. Você pode retornar em qualquer instante para concluir esta enquete.';
$string['saveeditedquestion'] = 'Salvar questão {$a}';
$string['savesettings'] = 'Salvar opções';
$string['search:activity'] = 'Enquete - informação de atividade';
$string['search:question'] = 'Enquete - questões';
$string['section'] = 'Descrição';
$string['sectionbreak'] = '----- Quebra de Página -----';
$string['sectionbreak_help'] = '----- Quebra de página -----';
$string['sectionsnotset'] = 'Você deve selecionar pelo menos uma questão por seção! <br /> Seção(ões) não selecionada(s): {$a}';
$string['sectiontext'] = 'Rótulo';
$string['sectiontext_help'] = 'Esta não é uma questão mas um breve texto que será exibido para introduzir uma série de questões.';
$string['selecttheme'] = 'Selecione um tema (css) a ser usado nesta enquete.';
$string['send'] = 'Enviar';
$string['send_message'] = 'Enviar mensagem para os usuários selecionados';
$string['send_message_to'] = 'Enviar mensagem para:';
$string['sendemail'] = 'Envia uma cópia contendo os dados de cada submissão para o endereço de email informado. Deixe em branco caso não desejes receber cópias.';
$string['sendemail_help'] = 'Envia uma cópia de cada envio para o(s) endereço(s) especificado(s).
Você pode fornecer mais de um endereço separando-os com vírgulas.
Deixe em branco para não enviar backup por e-mail. "allowemailreporting" deve estar habilitado nas configurações do módulo para acessar isso.';
$string['set'] = 'conjunto';
$string['settings'] = 'Opções';
$string['settingssaved'] = 'Opções salvas';
$string['show_nonrespondents'] = 'Não respondentes';
$string['slider'] = 'Slider';
$string['slider_help'] = 'A questão de controle deslizante permite que os respondentes selecionem um valor de uma faixa contínua arrastando o controle entre dois extremos. Um valor central também pode ser definido.';
$string['started'] = 'Iniciado';
$string['startingvalue'] = 'Valor inicial do Slider';
$string['startingvalue_help'] = 'O valor inicial do controle deslizante especifica onde o controle deve aparecer inicialmente para os respondentes. O padrão é 1, pois a faixa é desconhecida. Você pode querer começar no centro da faixa, fornecendo um valor central (uma faixa de 1-100 tem um valor central de 50).';
$string['stepvalue'] = 'Valor de incremento do controle deslizante';
$string['stepvalue_help'] = 'O valor de incremento do controle deslizante especifica o quão precisamente você deseja que os respondentes indiquem suas respostas na faixa. A questão tem como padrão um intervalo de 1-100 com um incremento de um, permitindo que os respondentes forneçam valores como 70, 71, 72, 73, 74 etc. Mas você pode definir incrementos de cinco, permitindo que os respondentes forneçam valores de 60, 65, 70, 75, 80 etc., ou até mesmo um intervalo de 1-10 com incrementos de 1.';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['strictdateformatting'] = 'Insira a data usando o seletor de data abaixo.';
$string['subject'] = 'Assunto';
$string['submissionnotificationhtmlanon'] = 'Há uma nova submissão <a href="{$a->submissionurl}"> </a> para a enquete "{$a->name}".';
$string['submissionnotificationhtmluser'] = '<a href="{$a->profileurl}">{$a->username}</a> fez uma nova <a href="{$a->submissionurl}">submissão</a> para o questionário "{$a->name}" no curso "{$a->coursename}".';
$string['submissionnotificationsubject'] = 'Nova submissão de enquete';
$string['submissionnotificationtextanon'] = 'Há uma nova submissão ({$a->submissionurl}) para a enquete "{$a->name}".';
$string['submissionnotificationtextuser'] = '{$a->username} ({$a->profileurl}) fez uma nova submissão ({$a->submissionurl}) ao questionário "{$a->name}" no curso "{$a->coursename}".';
$string['submitoptions'] = 'Opções de envio';
$string['submitpreview'] = 'Enviar prévia';
$string['submitpreviewcorrect'] = 'Esta submissão seria aceita como corretamente preenchida.';
$string['submitsurvey'] = 'Enviar enquete';
$string['submitted'] = 'Enviada em:';
$string['subtitle'] = 'Subtítulo';
$string['subtitle_help'] = 'Subtítulo deste questionnaire. Aparece abaixo do título na primeira página apenas.';
$string['summary'] = 'Sumário';
$string['summaryreportattached'] = 'Relatório de resumo da enquete em anexo';
$string['surveynotexists'] = 'enquete does not exist.';
$string['surveyowner'] = 'Você precisa ser o proprietário da enquete para poder executar esta operação.';
$string['surveyresponse'] = 'Respostas da enquete';
$string['template'] = 'Modelo';
$string['templatenotviewable'] = 'Enquetes modelo não são visualizáveis.';
$string['text'] = 'Texto da Questão';
$string['textareacolumns'] = 'Colunas da caixa de texto';
$string['textareacolumns_help'] = 'Esta questão irá exibir uma caixa de texto simples, com ** x *** Textarea colunas * (área ou * largura *) e ** y *** Textarea linhas * (número de linhas de texto * *). Se você deixar ambos x e y ao padrão ** 0 ** valor (ou, se você configurá-lo para ** 0 **), então editor de HTML será exibido com altura padrão e largura (se disponível no contexto do curso / usuário e perfil do usuário).';
$string['textarearows'] = 'Linhas da caixa de texto';
$string['textbox'] = 'Caixa de Texto';
$string['textbox_help'] = 'Para o tipo de questão Caixa de Texto, introduza o comprimento caixa de entrada e o comprimento do texto máximo de texto a ser digitado pelo entrevistado. Os valores padrão são 20 caracteres para a largura da caixa de entrada e 25 caracteres para o comprimento máximo do texto digitado.';
$string['textdownloadoptions'] = 'Opções para baixar respostas em formato CSV';
$string['thank_head'] = 'Gratos por completar esta Enquete.';
$string['theme'] = 'Tema';
$string['thismonth'] = 'este mês';
$string['thisresponse'] = 'Esta resposta';
$string['thisweek'] = 'esta semana';
$string['thousands'] = 'Não use separadores de milhares.';
$string['title'] = 'Título';
$string['title_help'] = 'Título desta enquete, que aparecerá no topo de cada página. Por título padrão é definido como o nome da enquete, mas você pode editá-lo como quiser.';
$string['today'] = 'hoje';
$string['total'] = 'Total';
$string['totalofnumbers'] = 'Total de números inseridos';
$string['totalresponses'] = 'Total de respostas para questão';
$string['type'] = 'Tipo de Questão';
$string['unanswered'] = 'Não respondido';
$string['undefinedquestiontype'] = 'Tipo de questão não identificado!';
$string['unknown'] = 'Desconhecido';
$string['unknownaction'] = 'Especificada uma ação desconhecida para enquetes...';
$string['url'] = 'URL de confirmação';
$string['url_help'] = 'A URL para a qual um usuário é redirecionado depois de completar esta enquete.';
$string['useprivate'] = 'Copiar existente';
$string['usepublic'] = 'Usar pública';
$string['usetemplate'] = 'Usar modelo';
$string['vertical'] = 'Vertical';
$string['view'] = 'Ver';
$string['viewallresponses'] = 'Ver todas as respostas';
$string['viewallresponses_help'] = 'Se a enquete está definido para o  ** modo de grupo**: *Grupos visíveis* , ou está definido para  *Grupos separados * e o usuário atual
  tem o *moodle / site: accessallgroups* capacidade (no contexto atual), e os grupos foram definidos no curso atual,  em seguida, o usuário tem acesso a uma lista suspensa de grupos. Esta lista suspensa permite que o usuário "filtrar" as respostas à enquete por parte de grupos.  Se a definição for ** Modo Grupo **: *Grupos separados* , os usuários que não têm o *moodle / site: accessallgroups* capacidade (normalmente estudantes ou professores não-edição, etc.) só vai ser capaz de ver as respostas do grupo (s) a que pertencem.';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = 'Lista de respostas';
$string['viewindividualresponse'] = 'Respostas individuais';
$string['viewindividualresponse_help'] = 'Clique sobre os nomes dos respondentes na lista abaixo para visualizar as respostas individuais.';
$string['viewresponses'] = 'Todas as respostas ({$a})';
$string['viewyourresponses'] = 'Ver sua(s) resposta(s)';
$string['warning'] = 'Warning, error encountered.';
$string['where'] = 'onde';
$string['wronganswers'] = 'Há algo de errado com as suas respostas (veja abaixo)';
$string['wrongdateformat'] = 'A data fornecida: <strong>{$a}</strong> não está no formato apresentado no exemplo.';
$string['wrongdaterange'] = 'ERRO! O ano deve estar no intervalo entre 1902 e 2037.';
$string['wrongformat'] = 'Há alguma coisa errada com sua resposta para a questão:&nbsp;';
$string['wrongformats'] = 'Há alguma coisa errada com sua resposta para as questões:&nbsp;';
$string['yesno'] = 'Sim/Não';
$string['yesno_help'] = 'Questão simples Sim/Não.';
$string['yourresponse'] = 'Ver sua(s) resposta(s)';
$string['yourresponses'] = 'Ver sua(s) resposta(s)';
