<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'pt_br', version '5.1'.
 *
 * @package     competency
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'Todos os filhos estão concluídos';
$string['competencies'] = 'Competências';
$string['competenciesarenotenabled'] = 'Competências não estão habilitadas.';
$string['competenciessettings'] = 'Configurações das competências';
$string['competency'] = 'Competência';
$string['competencyframework'] = 'Estrutura de competência';
$string['completeplanstask'] = 'Concluir planos de aprendizagem que estão expirando';
$string['coursecompetencyoutcome_complete'] = 'Concluir a competência';
$string['coursecompetencyoutcome_evidence'] = 'Anexar evidência';
$string['coursecompetencyoutcome_none'] = 'Fazer nada';
$string['coursecompetencyoutcome_recommend'] = 'Enviar para revisão';
$string['coursemodulecompetencyoutcome_complete'] = 'Concluir a competência';
$string['coursemodulecompetencyoutcome_evidence'] = 'Anexar evidência';
$string['coursemodulecompetencyoutcome_none'] = 'Fazer nada';
$string['coursemodulecompetencyoutcome_recommend'] = 'Enviar para revisão';
$string['deletecompetencyratings'] = 'Excluir avaliações de competência';
$string['duplicateditemname'] = '{$a} (cópia)';
$string['enablecompetencies'] = 'Habilitar competências';
$string['enablecompetencies_desc'] = 'Competências permitem que os usuários possam ser avaliados de acordo com planos de aprendizado.';
$string['errorcannotchangeapastduedate'] = 'O prazo já passou; ele não pode ser alterado.';
$string['errorcannotsetduedateinthepast'] = 'O prazo não pode ser definido no passado.';
$string['errorcannotsetduedatetoosoon'] = 'O prazo é muito perto.';
$string['errorcompetencyrule'] = 'Regra de competência de curso "{$a}" desconhecida';
$string['errorcoursecompetencyrule'] = 'Regra de competência de curso "{$a}" desconhecida';
$string['errorinvalidcourse'] = 'Curso inválido.';
$string['errornocompetency'] = 'Competência {$a} não encontrada';
$string['errorplanstatus'] = 'Estado de planos de aprendizado \'{$a}\' desconhecido';
$string['errorscalealreadyused'] = 'A escala não pode ser alterada, pois já está em uso.';
$string['errorscaleconfiguration'] = 'A escala precisa ser configurada selecionando itens padrão e proficiência.';
$string['errorusercomptencystatus'] = 'Estado da competência do usuário \'{$a}\' desconhecido';
$string['eventcompetencycreated'] = 'Competência criada.';
$string['eventcompetencydeleted'] = 'Competência deletada.';
$string['eventcompetencyframeworkcreated'] = 'Estrutura da competência criada.';
$string['eventcompetencyframeworkdeleted'] = 'Estrutura da competência excluída.';
$string['eventcompetencyframeworkupdated'] = 'Estrutura da competência atualizada';
$string['eventcompetencyframeworkviewed'] = 'Estrutura da competência visualizada.';
$string['eventcompetencyupdated'] = 'Competência atualizada.';
$string['eventcompetencyviewed'] = 'Competência visualizada.';
$string['eventevidencecreated'] = 'Evidência criada.';
$string['eventplanapproved'] = 'Plano de ensino aprovado.';
$string['eventplancompleted'] = 'Plano de ensino concluído.';
$string['eventplancreated'] = 'Plano de ensino criado.';
$string['eventplandeleted'] = 'Plano de ensino excluído.';
$string['eventplanreopened'] = 'Plano de ensino reaberto.';
$string['eventplanreviewrequestcancelled'] = 'Solicitação de revisão do plano de aprendizagem cancelada.';
$string['eventplanreviewrequested'] = 'Revisão do plano de aprendizagem solicitada.';
$string['eventplanreviewstarted'] = 'Revisão do plano de aprendizagem iniciada.';
$string['eventplanreviewstopped'] = 'Revisão do plano de aprendizagem parou.';
$string['eventplanunapproved'] = 'Plano de aprendizagem não aprovado.';
$string['eventplanunlinked'] = 'Plano de aprendizagem não vinculado.';
$string['eventplanupdated'] = 'Plano de ensino atualizado.';
$string['eventplanviewed'] = 'Plano de ensino visualizado.';
$string['eventtemplatecreated'] = 'Modelo de plano de aprendizagem criado.';
$string['eventtemplatedeleted'] = 'Modelo de plano de aprendizagem excluído.';
$string['eventtemplateupdated'] = 'Modelo de plano de aprendizagem atualizado.';
$string['eventtemplateviewed'] = 'Modelo do plano de aprendizado visualizado.';
$string['eventusercompetencyplanviewed'] = 'Plano de competência de usuário visualizado.';
$string['eventusercompetencyrated'] = 'Competência do usuário avaliada.';
$string['eventusercompetencyratedincourse'] = 'Competência do usuário avaliada no curso.';
$string['eventusercompetencyratedinplan'] = 'Competência do usuário avaliada no plano de aprendizado.';
$string['eventusercompetencyreviewrequestcancelled'] = 'Solicitação de revisão de competência do usuário cancelada.';
$string['eventusercompetencyreviewrequested'] = 'Revisão de competência de usuário solicitada.';
$string['eventusercompetencyreviewstarted'] = 'Revisão de competência de usuário iniciada.';
$string['eventusercompetencyreviewstopped'] = 'Revisão de competência de usuário interrompida.';
$string['eventusercompetencyviewed'] = 'Competência de usuário visualizada.';
$string['eventusercompetencyviewedincourse'] = 'Competência do usuário visualizada no curso.';
$string['eventusercompetencyviewedinplan'] = 'Competência do usuário visualizada no plano de aprendizado.';
$string['eventuserevidencecreated'] = 'Evidência de aprendizagem prévia criada.';
$string['eventuserevidencedeleted'] = 'Evidência de aprendizagem prévia excluída.';
$string['eventuserevidenceupdated'] = 'Evidência de aprendizagem prévia atualizada.';
$string['evidence_competencyrule'] = 'A regra da competência foi cumprida.';
$string['evidence_coursecompleted'] = 'O curso \'{$a}\' foi concluído.';
$string['evidence_coursemodulecompleted'] = 'A atividade \'{$a}\' foi concluída.';
$string['evidence_courserestored'] = 'A classificação foi restaurada juntamente com o curso \'{$a}\'.';
$string['evidence_evidenceofpriorlearninglinked'] = 'Evidência de aprendizagem prévia \'{$a}\' ativada.';
$string['evidence_evidenceofpriorlearningunlinked'] = 'Evidência de aprendizagem prévia \'{$a}\' desativada.';
$string['evidence_manualoverride'] = 'A classificação de competência foi definida manualmente.';
$string['evidence_manualoverrideincourse'] = 'A classificação de competência foi definida manualmente no curso \'{$a}\'.';
$string['evidence_manualoverrideinplan'] = 'A classificação de competência foi definida manualmente no plano de aprendizado \'{$a}\'.';
$string['invalidevidencedesc'] = 'Descrição de evidência inválida';
$string['invalidgrade'] = 'Classificação inválida';
$string['invalidplan'] = 'Plano de aprendizado inválido';
$string['invalidtaxonomy'] = 'Taxonomia inválida: {$a}';
$string['invalidurl'] = 'A URL não é válida. Certifique-se de que ela começa com \'http://\' ou \'https://\'.';
$string['nouserplanswithcompetency'] = 'Nenhum plano de aprendizagem contém essa competência.';
$string['planstatusactive'] = 'Ativo';
$string['planstatuscomplete'] = 'Concluído';
$string['planstatusdraft'] = 'Rascunho';
$string['planstatusinreview'] = 'Em revisão';
$string['planstatuswaitingforreview'] = 'Aguardando revisão';
$string['pointsrequiredaremet'] = 'Pontos necessários atendidos';
$string['privacy:evidence:action:complete'] = 'Competência concluída se não tiver avaliação';
$string['privacy:evidence:action:log'] = 'Ação de log';
$string['privacy:evidence:action:override'] = 'Substituir classificação de competência';
$string['privacy:metadata:competency'] = 'Um registro das competências';
$string['privacy:metadata:competency_coursecomp'] = 'Um registro das competências vinculadas a um curso';
$string['privacy:metadata:competency_coursecompsetting'] = 'Um registro das configurações de competência em um curso';
$string['privacy:metadata:competency_evidence'] = 'Um registro das evidências que afetam o estado de uma competência';
$string['privacy:metadata:competency_framework'] = 'Um registro dos quadros de competências';
$string['privacy:metadata:competency_modulecomp'] = 'Um registro das competências vinculadas a um módulo';
$string['privacy:metadata:competency_plan'] = 'Um registro dos planos de aprendizado';
$string['privacy:metadata:competency_plancomp'] = 'Um registro das competências em um plano de aprendizado';
$string['privacy:metadata:competency_relatedcomp'] = 'Um registro da relação entre competências';
$string['privacy:metadata:competency_template'] = 'Um registro dos modelos de plano de aprendizado';
$string['privacy:metadata:competency_templatecohort'] = 'Um registro das coortes associadas a um modelo de plano de aprendizado';
$string['privacy:metadata:competency_templatecomp'] = 'Um registro das competências em um modelo de plano de aprendizado';
$string['privacy:metadata:competency_usercomp'] = 'Um registro do estado de competências de um usuário';
$string['privacy:metadata:competency_usercompcourse'] = 'Um registro do estado de competências de um usuário em um curso';
$string['privacy:metadata:competency_usercompplan'] = 'Um registro do estado de competências em um plano de aprendizado';
$string['privacy:metadata:competency_userevidence'] = 'Um registro da evidência da aprendizagem prévia';
$string['privacy:metadata:competency_userevidencecomp'] = 'Registro das competências associadas à evidência da aprendizagem prévia';
$string['privacy:metadata:core_comments'] = 'Comentários feitos sobre planos de aprendizagem e competências';
$string['privacy:metadata:evidence:action'] = 'O tipo de ação realizada com a evidência';
$string['privacy:metadata:evidence:actionuserid'] = 'O usuário executando a ação';
$string['privacy:metadata:evidence:desca'] = 'Os parâmetros opcionais da descrição da evidência tradutível';
$string['privacy:metadata:evidence:desccomponent'] = 'O componente da descrição da evidência traduzível';
$string['privacy:metadata:evidence:descidentifier'] = 'Um identificador da descrição da evidência traduzível';
$string['privacy:metadata:evidence:grade'] = 'A nota associada à evidência';
$string['privacy:metadata:evidence:note'] = 'Uma nota não localizada anexada à evidência';
$string['privacy:metadata:evidence:url'] = 'Um URL associado à evidência';
$string['privacy:metadata:plan:description'] = 'A descrição do plano de aprendizado';
$string['privacy:metadata:plan:duedate'] = 'A data de vencimento do plano de aprendizado';
$string['privacy:metadata:plan:name'] = 'O nome do plano de aprendizado';
$string['privacy:metadata:plan:reviewerid'] = 'O ID do revisor do plano de aprendizado';
$string['privacy:metadata:plan:status'] = 'O status do plano de aprendizado';
$string['privacy:metadata:plan:userid'] = 'O ID do usuário cujo plano de aprendizado é';
$string['privacy:metadata:timecreated'] = 'A hora em que o registro foi criado';
$string['privacy:metadata:timemodified'] = 'A hora em que o registro foi editado';
$string['privacy:metadata:usercomp:grade'] = 'A nota dada para a competência';
$string['privacy:metadata:usercomp:proficiency'] = 'Se a proficiência é alcançada';
$string['privacy:metadata:usercomp:reviewerid'] = 'O ID do revisor';
$string['privacy:metadata:usercomp:status'] = 'O status da competência';
$string['privacy:metadata:usercomp:userid'] = 'O ID do usuário cuja competência é';
$string['privacy:metadata:userevidence:description'] = 'A descrição da evidência';
$string['privacy:metadata:userevidence:name'] = 'A descrição da evidência';
$string['privacy:metadata:userevidence:url'] = 'Um URL associado à evidência';
$string['privacy:metadata:usermodified'] = 'O usuário que criou ou modificou o registro';
$string['privacy:path:plans'] = 'Planos de aprendizagem';
$string['privacy:path:relatedtome'] = 'Relacionado comigo';
$string['privacy:path:userevidence'] = 'Evidência da aprendizagem prévia';
$string['proficient'] = 'Proficiente';
$string['pushcourseratingstouserplans'] = 'Carregar classificações de cursos para planos de aprendizagem individuais';
$string['pushcourseratingstouserplans_desc'] = 'Valor padrão para a configuração do curso para atualizar planos de aprendizado individuais quando as competências do curso são avaliadas.';
$string['rating'] = 'Avaliação';
$string['syncplanscohorts'] = 'Planos sincronizados a partir dos coortes do modelo de plano de aprendizado.';
$string['taxonomy_behaviour'] = 'Comportamento';
$string['taxonomy_competency'] = 'Competência';
$string['taxonomy_concept'] = 'Conceito';
$string['taxonomy_domain'] = 'Domínio';
$string['taxonomy_indicator'] = 'Indicador';
$string['taxonomy_level'] = 'Nível';
$string['taxonomy_outcome'] = 'Resultado';
$string['taxonomy_practice'] = 'Prática';
$string['taxonomy_proficiency'] = 'Proficiência';
$string['taxonomy_skill'] = 'Habilidade';
$string['taxonomy_value'] = 'Valor';
$string['usercommentedonacompetency'] = '{$a->fullname} comentou sobre a competência "{$a->competency}":

{$a->comment}

Veja: {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} comentou sobre a competência "{$a->competency}":</p>
<div>{$a->comment}</div>
<p>Veja: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} comentou sobre a competência "{$a->competency}":';
$string['usercommentedonacompetencysubject'] = '{$a} comentou sobre a competência.';
$string['usercommentedonaplan'] = '{$a->fullname} comentou sobre o plano de aprendizado "{$a->plan}":

{$a->comment}

Veja: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} comentou o plano de aprendizagem "{$a->plan}":</p>
<div>{$a->comment}</div>
<p>Veja: <a href="{$a->url}">{$a->urlname}</a>.</p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} comentou sobre o plano de aprendizado "{$a->plan}".';
$string['usercommentedonaplansubject'] = '{$a} comentou o plano de aprendizagem.';
$string['usercompetency'] = 'Competência do usuário';
$string['usercompetencystatus_idle'] = 'inativo';
$string['usercompetencystatus_inreview'] = 'Em revisão';
$string['usercompetencystatus_waitingforreview'] = 'Esperando por revisão';
$string['userplans'] = 'Planos de aprendizado';
