<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'zoom', language 'cs', version '5.1'.
 *
 * @package     zoom
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accountid'] = 'ID účtu Zoom';
$string['actions'] = 'Akce';
$string['activitydate:ended'] = 'Ukončeno:';
$string['activitydate:started'] = 'Zahájeno:';
$string['activitydate:starts'] = 'Zahájení:';
$string['addparticipant'] = 'Přidat účastníka';
$string['addparticipantgroup'] = 'Přidat skupinu účastníků';
$string['addroom'] = 'Přidat místnost';
$string['addroomalert'] = 'Přidat místnost kliknutím';
$string['addtocalendar'] = 'Přidat do kalendáře';
$string['allmeetings'] = 'Všechny schůzky';
$string['allmeetings_desc'] = 'Pomocí tohoto nastavení můžete určit, zda se v dolní části každé stránky přehledu instance aktivity bude zobrazovat odkaz na indexovou stránku Zoom aktivity. Toto nastavení ovlivňuje pouze prezentaci odkazu na stránkách s přehledem aktivity Zoom. I když se rozhodnete odkaz nezobrazovat, uživatel může mít stále přístup na stránku indexu aktivity Zoom prostřednictvím jiných odkazů v rámci kurzu.';
$string['allmeetings_disable'] = 'Zakázat odkaz na všechny schůzky';
$string['allmeetings_enable'] = 'Povolit odkaz na všechny schůzky';
$string['alternative_hosts'] = 'Alternativní hostitelé';
$string['alternative_hosts_desc'] = 'Pomocí tohoto nastavení můžete určit, zda se uživatelům v nastavení instance aktivity zobrazí možnost zvolit alternativní hostitele. K dispozici jsou dva typy widgetů: Jednoduché vstupní pole, které přijímá e-mailové adresy oddělené čárkami. A výběr uživatelů s automatickým doplňováním, který umožňuje snadný výběr uživatelů, kteří jsou zapsáni do kurzu, mají účet Zoom a mají roli mimo {$a->roles}. Alternativní hostitelé, které mohli být nastaveni učitelem přímo v programu Zoom, ale nelze je vybrat v nástroji pro výběr uživatelů Moodle, se stále zobrazují na stránce s přehledem aktivit a jsou také zachovány při aktualizaci schůzky z prostředí Moodle.';
$string['alternative_hosts_disable'] = 'Zakázat možnost alternativních hostitelů';
$string['alternative_hosts_help'] = 'Alternativní možnost hostitele vám umožňuje naplánovat schůzky a určit další uživatele Zoom, aby schůzku také zahájili. Tito uživatelé obdrží od Zoom e -mail s oznámením, že byli přidáni jako alternativní hostitel, s odkazem na zahájení schůzky.
Ve vstupním formátu zadejte e -mailové adresy alternativních hostitelů. Více e -mailů můžete oddělit čárkou (bez mezer).';
$string['alternative_hosts_inputfield'] = 'Zobrazit alternativní možnost hostitele jako prosté vstupní pole';
$string['alternative_hosts_picker'] = 'Zobrazit alternativní možnost hostitele jako výběr uživatele s automatickým doplňováním';
$string['alternative_hosts_picker_help'] = 'Alternativní možnost hostitele vám umožňuje naplánovat schůzky a určit další uživatele Zoomu zapsané v tomto kurzu, aby také zahájili schůzku. Tito uživatelé obdrží od Zoom e -mail s oznámením, že byli přidáni jako alternativní hostitel, s odkazem na zahájení schůzky. \\n\\nMůžete si vybrat jednoho nebo více alternativních hostitelů na základě potřeb vaší schůzky. \\n\\nPokud v tomto výběru uživatelů nemůžete najít konkrétního uživatele, tento uživatel buď není zapsán do tohoto kurzu s příslušnou rolí, nebo nemá způsobilý účet na Zoom.';
$string['alternative_hosts_picker_noneselected'] = 'Není vybrán žádný alternativní hostitel';
$string['alternative_hosts_picker_placeholder'] = 'Vybrat uživatele';
$string['apiendpoint'] = 'Zoom API Endpoint';
$string['apiendpoint_desc'] = 'Vyberte, který koncový bod rozhraní Zoom API bude aktivita Zoom používat k připojení. Globální koncový bod API by měl fungovat pro všechny uživatele. Koncový bod API Evropské unie (EU) je určen pouze pro uživatele, kteří mají licenci Zoom s možností zřizování EU. Pokud si nejste jisti, použijte globální koncový bod API.';
$string['apiendpoint_eu'] = 'EU API koncový bod';
$string['apiendpoint_global'] = 'Globální koncový bod API';
$string['apiidentifier'] = 'Zoom API Identifikátor';
$string['apiidentifier_desc'] = 'Pole identifikátoru, které se má použít při volání rozhraní Zoom API';
$string['apiurl'] = 'Zoom API url';
$string['audio_both'] = 'Počítačové audio a telefon';
$string['audio_telephony'] = 'Pouze telefon';
$string['audio_voip'] = 'Pouze počítačové audio';
$string['audiodefault'] = 'Výchozí nastavení zvuku';
$string['authentication'] = 'Ověření';
$string['autorecording_cloud'] = 'Cloud';
$string['autorecording_local'] = 'Lokální';
$string['autorecording_none'] = 'Žádné';
$string['autorecording_userdefault'] = 'Použít výchozí nastavení uživatele Zoom';
$string['autorecordingoptionsupdate'] = 'Aktualizovat možnosti automatického nahrávání';
$string['breakoutrooms'] = 'Dílčí místnosti';
$string['cachedef_oauth'] = 'Přiblížení mezipaměti tokenu OAuth';
$string['cachedef_zoomid'] = 'Identifikátor uživatele Zoomu';
$string['cachedef_zoommeetingsecurity'] = 'Nastavení zabezpečení schůzky Zoom, včetně požadavků na heslo schůzky účtu';
$string['calendardescriptionintro'] = '\\nDescription:\\n{\\$a}';
$string['calendariconalt'] = 'Ikona kalendáře';
$string['calendarjoinurl'] = 'URL pro připojení k schůzce: {$a}.';
$string['changehost'] = 'Změnit hostitele';
$string['clickjoin'] = 'Potvrdili jste připojení ke schůzce';
$string['clientid'] = 'ID klienta zoomu';
$string['clientsecret'] = 'Klíč  Zoom klienta';
$string['connectionfailed'] = 'Připojení se nezdařilo:';
$string['connectionok'] = 'Připojení funguje.';
$string['connectionsettings'] = 'Nastavení připojení';
$string['connectionsettings_desc'] = 'Tato nastavení definují, jak se Moodle připojuje k Zoom.';
$string['connectionstatus'] = 'Stav připojení';
$string['day'] = 'Dny';
$string['defaultsettings'] = 'Výchozí nastavení Zoom schůzky';
$string['defaultsettings_help'] = 'Tato nastavení definují výchozí hodnoty pro všechny nové schůzky Zoom a webináře.';
$string['deletemeetingrecordings'] = 'Odstranit záznamy schůzek z Moodle';
$string['deleteroom'] = 'Odstranit místnost';
$string['displayfirstname'] = 'Pouze křestní jméno';
$string['displayfullname'] = 'Celé jméno';
$string['displayid'] = 'pouze (ID uživatele)';
$string['displayidfullname'] = '(ID uživatele) následované celým jménem';
$string['displayleadtime'] = 'Zobrazit čas před plánovaným časem zahájení';
$string['displayleadtime_desc'] = 'Pokud je tato možnost povolena, zobrazí se uživatelům doba trvání do schůzky. Tímto způsobem jsou uživatelé informováni, že / kdy se mohou připojit ke schůzce před plánovaným časem zahájení. To může uživatelům zabránit v neustálém načítání stránky, dokud se nepřipojí.';
$string['displayleadtime_nohideif'] = 'Poznámka: Toto nastavení je zpracováno pouze v případě, že je nastavení „{$a}“ nastaveno na hodnotu větší než nula.';
$string['displaypassword'] = 'Zobrazit přístupový kód';
$string['displaypassword_help'] = 'Pokud je povoleno, přístupový kód schůzky se bude vždy zobrazovat nehostitelům.';
$string['downloadical'] = 'Stáhnout iCal';
$string['downloadical_desc'] = 'Pomocí tohoto nastavení můžete určit, zda se na stránce s přehledem instance aktivity zobrazí odkaz na stažení souboru iCal pro schůzku. Toto nastavení ovlivní pouze možnost stáhnout soubor iCal pro nástroje kalendáře třetích stran. Bez ohledu na toto nastavení aktivita Zoom schůzky přidá položku kalendáře do kalendáře Moodle, jakmile je nastaveno datum zahájení schůzky.';
$string['downloadical_disable'] = 'Zakázat stahování odkazu iCal';
$string['downloadical_enable'] = 'Povolit stahování odkazu iCal';
$string['duration'] = 'Doba trvání (minut)';
$string['encryptiontype'] = 'Typ šifrování';
$string['encryptiontype_alwaysshow'] = 'Vždy zobrazit výběr typu šifrování bez ohledu na to, zda uživatel může použít šifrování typu end-to-end nebo ne';
$string['encryptiontype_desc'] = 'Pomocí tohoto nastavení můžete určit, zda se uživatelům v nastavení instance aktivity zobrazí možnost zvolit šifrování typu end-to-end přes rozšířené šifrování. Toto nastavení ovlivní pouze nastavení instance aktivity Moodle. I když se rozhodnete tuto možnost vždy zobrazit, uživatel bude i nadále potřebovat end-to-end šifrování v Zoom, aby konečně povolil end-to-end šifrování.';
$string['encryptiontype_disable'] = 'Zakázat výběr typu šifrování';
$string['encryptiontype_showonlyife2epossible'] = 'Zobrazit výběr typu šifrování pouze v případě, že uživatel může používat šifrování typu end-to-end';
$string['end_date_option_after'] = 'Po';
$string['end_date_option_by'] = 'Podle';
$string['end_date_option_occurrences'] = 'Výskytů';
$string['enddate'] = 'Datum ukončení';
$string['endtime'] = 'Čas ukončení';
$string['err_downloadicaldisabled'] = 'Stahování souborů Zoom meeting iCal bylo deaktivováno.';
$string['err_downloadicalrecurringempty'] = 'Stahování souboru Zoom meeting iCal pro tuto schůzku není možné, protože neobsahuje alespoň jeden výskyt.';
$string['err_downloadicalrecurringnofixed'] = 'Stahování souboru Zoom meeting iCal pro tuto schůzku není možné, protože se jedná o opakující se schůzku bez pevného času.';
$string['err_duration_nonpositive'] = 'Doba trvání musí být kladná hodnota.';
$string['err_duration_too_long'] = 'Doba trvání nesmí přesáhnout 150 hodin.';
$string['err_end_date'] = 'Datum ukončení opakování nemůže být v minulosti';
$string['err_end_date_before_start'] = 'Datum ukončení opakování nesmí být před datem zahájení';
$string['err_invalid_password'] = 'Heslo obsahuje neplatné znaky.';
$string['err_long_timeframe'] = 'Požadovaný časový rámec je příliš dlouhý, jsou zobrazeny výsledky v rozsahu posledního měsíce.';
$string['err_password'] = 'Přístupový kód může obsahovat pouze následující znaky: [a-z A-Z 0-9 @ - _ *]. Maximálně 10 znaků.';
$string['err_password_required'] = 'Heslo je označeno jako povinné, ale pole hesla je prázdné.';
$string['err_registration'] = 'Aktuální uživatel nemá oprávnění vytvářet schůzky/webináře, které vyžadují registraci.';
$string['err_repeat_monthly_interval'] = 'Maximální interval pro měsíční schůzku jsou 3 měsíce';
$string['err_repeat_weekly_interval'] = 'Maximální interval pro týdenní setkání je 12 týdnů';
$string['err_start_time_past'] = 'Počáteční datum nemůže být v minulosti.';
$string['err_start_time_past_recurring'] = 'U opakujících se schůzek je datumová část tohoto pole nejbližším možným datem příští schůzky. Toto datum musí být dnes nebo v budoucnosti.';
$string['err_weekly_days'] = 'Vybrat dny pro opakovanou týdenní schůzku';
$string['erroraddinstance'] = 'Nelze vytvořit novou schůzku zoom. Pro opakovanou schůzku byly vybrány neplatné možnosti.';
$string['errorwebservice'] = 'Chyba webové služby Zoom: {$a}.';
$string['errorwebservice_badrequest'] = 'Zoom obdržel špatný požadavek: {$a}';
$string['errorwebservice_notfound'] = 'Zdroj neexistuje: {$a}';
$string['export'] = 'Export';
$string['externaluser'] = 'Externí uživatel';
$string['firstjoin'] = 'První možnost připojit se';
$string['firstjoin_desc'] = 'První uživatel může připojit nejdříve (minuty před začátkem).';
$string['getmeetingrecordings'] = 'Získat nahrávky schůzek ze Zoomu';
$string['getmeetingreports'] = 'Získat zprávu o schůzce Zoom';
$string['globalsettings'] = 'Globální nastavení';
$string['globalsettings_desc'] = 'Tato nastavení platí pro plugin Zoom jako celek.';
$string['grading_needgrade'] = 'Následující uživatelé musí být ohodnoceni ručně, protože je nebylo možné identifikovat:\\n';
$string['grading_notenrolled'] = 'Následující uživatelé se připojili ke schůzce, ale nebyli rozpoznáni jako přihlášení uživatelé:\\n';
$string['grading_notfound'] = 'Seznam uživatelů, kteří se kliknutím připojili ke schůzce, ale nebyli rozpoznáni ve zprávě účastníka:\\n';
$string['gradingentry'] = 'Při vstupu';
$string['gradinglink'] = 'Zkontrolujte nebo aktualizujte hodnocení';
$string['gradingmessagebody'] = 'Pro relaci Zoom Meeting: {$a->zoomurl};
<br>
Počet uživatelů, kteří byli automaticky hodnoceni podle délky trvání schůzky: {$a->graded}.
<br>
Počet uživatelů, kteří již byli ohodnoceni: {$a->alreadygraded}.
<br>
 {$a->needgrade}<br>
Zde zkontrolujte nebo aktualizujte hodnocení uživatelů: {$a->gradeurl}
<br>
{$a->notfound}
<br>
{$a->notenrolled}';
$string['gradingmessagesubject'] = 'Hodnocení uživatelů pro schůzku Zoom: {$a->name}';
$string['gradingmethod'] = 'Metoda klasifikace';
$string['gradingmethod_heading'] = 'Možnosti metody klasifikace';
$string['gradingmethod_heading_help'] = 'Rozhodněte se, kterou metodu použijete při hodnocení účasti Zoom.';
$string['gradingmethod_help'] = 'Vyberte metodu, kterou chcete použít při hodnocení účasti studentů.<br>
Po vstupu: student obdrží plný počet bodů (maximální hodnocení), když se kliknutím připojí ke schůzce v Moodle.<br>
Délka docházky: Student získá skóre na základě procenta jeho účasti na schůzce ve srovnání s celkovou dobou trvání schůzky.<br>
Poznámky k metodě trvání docházky:<br>
- Tato metoda vyžaduje, aby zobrazovaný název obsahoval id nebo celé jméno.<br>
- Doporučuje se nastavit nastavení \'zoom | defaultjoinbeforehost\' na (Ne), aby bylo trvání schůzky přesné.<br>
- Někteří studenti, kteří jsou již přihlášeni do klienta Zoom s údaji, které neodpovídají údajům v Moodle, musí být ohodnoceni ručně po prostudování zprávy o schůzce.';
$string['gradingperiod'] = 'Doba trvání docházky';
$string['gradingsmallmeassage'] = 'Rychlý přehled hodnocení uživatele pro {$a->name}:
<br>
Potřebujete ruční hodnocení: {$a->number}
<br>
Hodnocení uživatelé: {$a->graded + $a->alreadygraded}';
$string['host'] = 'Hostitel';
$string['hostintro'] = '<a target="_blank" href="https://support.zoom.us/hc/en-us/articles/208220166">Alternativní hostitelé </a> mohou zahájit schůzky Zoom a spravovat čekárnu.';
$string['indicator:cognitivedepth'] = 'Zoom kognitivní';
$string['indicator:cognitivedepth_help'] = 'Tento indikátor je založen na kognitivní hloubce, které student dosáhl v aktivitě Zoom.';
$string['indicator:socialbreadth'] = 'Zoom sociální';
$string['indicator:socialbreadth_help'] = 'Tento indikátor je založen na sociální šíři dosažené studentem v aktivitě Zoom.';
$string['instanceusers'] = 'Zkontrolovat uživatele instance';
$string['instanceusers_desc'] = 'Pokud je povoleno Předefinovat licence, zkontrolujte pouze licencované uživatele v této instanci Moodle. Užitečné pro nastavení, kde samostatné instance rozdělují jeden fond licencí Zoom.';
$string['invalid_status'] = 'Stav je neplatný, zkontrolujte databázi.';
$string['invalidscheduleuser'] = 'Pro zadaného uživatele nelze naplánovat.';
$string['invitation_dialin'] = 'Vytáčení podle vzoru';
$string['invitation_dialin_help'] = 'Vzor regulárního výrazu pro vyhledání čísel schůzky Zoom.';
$string['invitation_h323'] = 'Vzor zprávy H.323';
$string['invitation_h323_help'] = 'Vzor regulárního výrazu pro vyhledání informací o schůzce Zoom H.323. Pokud vaše pozvánky neobsahují prvky SIP nebo H.323, nastavte odpovídající vzor regulárního výrazu na prázdný řetězec. (To platí zejména pro servery s povoleným laděním, protože může narušit formát speciálních typů souborů, jako je export iCal.)';
$string['invitation_icallink'] = 'Vzor zprávy odkazu iCal';
$string['invitation_icallink_help'] = 'Vzor regulárního výrazu pro nalezení odkazu Zoom na schůzku iCal.';
$string['invitation_invite'] = 'Vzor pozvánky';
$string['invitation_invite_help'] = 'Vzor regulárního výrazu pro nalezení úvodní zprávy schůzky Zoom.';
$string['invitation_joinurl'] = 'Připojit vzor adresy URL';
$string['invitation_joinurl_help'] = 'Vzor regulárního výrazu pro nalezení adresy URL pro připojení ke schůzce Zoom.';
$string['invitation_onetapmobile'] = 'Vzor klepnutím mobilního telefonu';
$string['invitation_onetapmobile_help'] = 'Vzor regulárního výrazu pro nalezení podrobností o schůzce Zoom jedním klepnutím.';
$string['invitation_sip'] = 'SIP vzor';
$string['invitation_sip_help'] = 'Vzor regulárního výrazu pro nalezení informací SIP schůzky Zoom. Pokud vaše pozvánky neobsahují prvky SIP nebo H.323, nastavte odpovídající vzor regulárního výrazu na prázdný řetězec. (To platí zejména pro servery s povoleným laděním, protože může narušit formát speciálních typů souborů, jako je export iCal.)';
$string['invitationmatchnotfound'] = 'V pozvánce na zoom nebyla nalezena shoda pro prvek: "{$a->element}" se vzorem: "{$a-> pattern}".';
$string['invitationmodificationfailed'] = 'Chyba v regulárním výrazu pro prvek pozvánky na zoom:  "{$a->element}" se vzorem: "{$a-> pattern}".';
$string['invitationregex'] = 'Regulární výraz pozvánky a možnosti Zoom';
$string['invitationregex_help'] = 'Definujte vzory regulárních výrazů, abyste izolovali každou část pozvánky přiblížení, aby bylo možné informace řídit funkcemi.';
$string['invitationregex_nohideif'] = 'Poznámka: Vzory regulárních výrazů budou použity pouze v případě, že je povoleno nastavení "{$a}".';
$string['invitationregexenabled'] = 'Povolit regulární výraz pozvánky a možnosti Zoom.';
$string['invitationregexenabled_help'] = 'Je-li povoleno, pozvánka přiblížení zobrazená v aktivitě bude rozdělena do prvků pomocí následujícího regulárního výrazu a k rozhodnutí, které části se zobrazí každému uživateli, se použijí možnosti. Viz možnosti zoom/viewjoinurl a zoom/viewdialin.';
$string['invitationremoveicallink'] = 'Odebrat odkaz iCal na pozvánku Zoom';
$string['invitationremoveicallink_help'] = 'Je -li povoleno, bude odkaz iCal, který může být součástí e -mailové zprávy se zoomem, odstraněn pomocí vzoru regex invitation_icallink.';
$string['invitationremoveinvite'] = 'Odebrat zprávu s pozvánkou pro Zoom';
$string['invitationremoveinvite_help'] = 'Pokud je tato možnost povolena, úvodní věta v e -mailové zprávě Zoom schůzky bude odstraněna pomocí vzoru regex invitation_invite.';
$string['join'] = 'Připojit se';
$string['join_meeting'] = 'Připojit se ke schůzce';
$string['joinbeforehost'] = 'Povolit ostatním připojit se ke schůzce před hostitelem';
$string['joinbeforehostenable'] = 'Umožnit účastníkům kdykoli se připojit';
$string['joinlink'] = 'Odkaz na připojení';
$string['jointime'] = 'Čas připojení';
$string['leavetime'] = 'Čas opuštění';
$string['licenseonjoin'] = 'Tuto možnost vyberte, pokud chcete, aby hostitel obdržel licenci při zahájení schůzky, <i> stejně jako </i> při vytvoření.';
$string['licensesettings'] = 'Nastavení licence';
$string['licensesettings_desc'] = 'Tato nastavení definují způsob, jakým Moodle zpracovává vaši licenci Zoom.';
$string['licensesnumber'] = 'Počet licencí';
$string['lowlicenses'] = 'Pokud počet vašich licencí překročí požadované, pak při vytváření každé nové aktivity uživatelem bude přiřazena licence PRO snížením stavu jiného uživatele. Tato možnost je účinná, pokud je počet aktivních licencí PRO vyšší než 5.';
$string['maskparticipantdata'] = 'Skrýt data účastníků';
$string['maskparticipantdata_help'] = 'Zabrání zobrazení dat účastníků v záznamech (užitečné pro weby, které pseudonymizují data účastníků, např. pro HIPAA).';
$string['media'] = 'Média';
$string['meeting_finished'] = 'Dokončení';
$string['meeting_invite'] = 'Informace o telefonu / telefonickém připojení';
$string['meeting_invite_hide'] = 'Skrýt pozvánku na schůzku';
$string['meeting_invite_show'] = 'Zobrazit pozvánku na schůzku';
$string['meeting_nonexistent_on_zoom'] = 'Na Zoomu nenalezen';
$string['meeting_not_started'] = 'Nespuštěno';
$string['meeting_started'] = 'Probíhá';
$string['meeting_time'] = 'Čas zahájení';
$string['meetingactivityurl'] = 'URL adresa aktivity schůzky: <a href="{$a}">{$a}</a>';
$string['meetingcapacitywarning'] = 'Upozornění na kapacitu schůzky';
$string['meetingcapacitywarning_desc'] = 'S tímto nastavením můžete zobrazit upozornění, pokud je v kurzu více aktivních a zapsaných účastníků, než je kapacita schůzky hostitele s licencí Zoom. Oznámení se zobrazí hostiteli (a alternativním hostitelům) na stránce Přehled aktivity zoomu. Doporučí hostiteli, aby se v případě potřeby obrátil na majitele účtu Zoom, aby získal větší licenci Zoom. Tuto zprávu můžete změnit pomocí přizpůsobení jazyka Moodle.';
$string['meetingcapacitywarning_disable'] = 'Zakázat upozornění na kapacitu schůzky';
$string['meetingcapacitywarning_enable'] = 'Povolit upozornění na kapacitu schůzky';
$string['meetingcapacitywarningbodyalthost'] = 'Licence Zoom hostitele této schůzky, {$a->hostname}, má kapacitu <strong> {$a->meetingcapacity} účastníků schůzky </strong>, ale tento kurz má <strong> <a href = "{$a->courseparticipantsurl} "> {$a->eligiblemeetingparticipants} zapsaní a aktivní účastníci </a> </strong>.';
$string['meetingcapacitywarningbodyrealhost'] = 'Vaše licence na zoom má kapacitu <strong> <a href="{$a->zoomprofileurl} "target ="_ blank "> {$a->meetingcapacity} účastníků schůzky </a> </strong>, ale tento kurz má <strong> <a href="{$a->kurzparticipantsurl} "> {$a->eligiblemeetingparticipants} zapsané a aktivní účastníky </a> </strong>.';
$string['meetingcapacitywarningcontactalthost'] = 'Pokud se všichni tito účastníci kurzu potřebují připojit ke schůzce, požádejte hostitele, aby se obrátil na majitele účtu Zoom, aby získal větší licenci Zoom.';
$string['meetingcapacitywarningcontactrealhost'] = 'Pokud se všichni tito účastníci kurzu potřebují připojit ke schůzce, obraťte se na majitele účtu Zoom a získejte větší licenci Zoom.';
$string['meetingcapacitywarningheading'] = 'Upozornění na kapacitu schůzky:';
$string['meetingparticipantsdeleted'] = 'Uživatelská data účastníka schůzky byla smazána.';
$string['meetingrecordingviewsdeleted'] = 'Data uživatelského zobrazení záznamu schůzky byla smazána.';
$string['messageprovider:ical_notifications'] = 'Odeslat účastníkům pozvánky přes iCal na nově vytvořenou událost Zoomu.';
$string['messageprovider:teacher_notification'] = 'Upozornit učitele na hodnocení uživatelů (podle délky trvání) v relaci Zoom';
$string['modulename'] = 'Schůzka přes Zoom';
$string['modulename_help'] = 'Zoom je platforma pro videokonference a webové konference, která oprávněným uživatelům umožňuje pořádat online schůzky.';
$string['modulenameplural'] = 'Schůzky Zoom';
$string['month'] = 'Měsíce';
$string['month_day_text'] = 'měsíce';
$string['newmeetings'] = 'Nové schůzky';
$string['nextoccurrence'] = 'Další výskyt';
$string['nomeetinginstances'] = 'Pro tuto schůzku nebyly nalezeny žádné relace.';
$string['nonrecognizedusergrade'] = '(Jméno: {$a->userid}, známka: {$a->grade})';
$string['nooccurrenceleft'] = 'Poslední výskyt již skončil';
$string['noparticipants'] = 'Pro tuto relaci nebyl v tuto chvíli nalezen žádný účastník.';
$string['norecordings'] = 'V tuto chvíli nebyly nalezeny žádné nahrávky této schůzky.';
$string['norooms'] = 'Žádné místnosti';
$string['nosessions'] = 'Pro zadaný rozsah nebyly nalezeny žádné relace.';
$string['nozooms'] = 'Žádné schůzky';
$string['nozoomsfound'] = 'Pro daný kurz nebyly nalezeny žádné schůzky.';
$string['occurson'] = 'Vyskytuje se';
$string['off'] = 'Vypnuto';
$string['oldmeetings'] = 'Uzavřené schůzky';
$string['on'] = 'Zapnuto';
$string['option_allow_recording_change'] = 'Povolit záznam změn';
$string['option_allow_recording_change_help'] = 'Povolit uživateli změnit nastavení nahrávání při vytváření aktivity';
$string['option_audio'] = 'Možnosti zvuku';
$string['option_audio_help'] = 'Pomocí této možnosti můžete uživatelům povolit volat pouze pomocí telefonu, zvuku počítače nebo obojího';
$string['option_authenticated_users'] = 'Pouze ověření uživatelé';
$string['option_authenticated_users_help'] = 'Povolení této možnosti vyžaduje, aby se všichni účastníci mohli přihlásit ke svému autorizovanému účtu zoomu, aby se mohli ke schůzce připojit. S přihlášením do Moodle se to  nijak<em> netýká</em>.';
$string['option_auto_recording'] = 'Automatické nahrávání';
$string['option_auto_recording_help'] = 'Povolením této možnosti se schůzka automaticky nahraje';
$string['option_encryption_type'] = 'Šifrování';
$string['option_encryption_type_endtoendencryption'] = 'Šifrování typu end-to-end';
$string['option_encryption_type_enhancedencryption'] = 'Vylepšené šifrování';
$string['option_encryption_type_help'] = 'Pomocí této možnosti ovládáte úroveň šifrování a soukromí této schůzky. \\n\\n* Vylepšené šifrování* znamená, že šifrovací klíč je uložen v cloudu Zoom. \\n\\n*Šifrování typu end-to-end* znamená, že šifrovací klíč je uložen na vašem místním zařízení a nikdo jiný nemůže získat váš šifrovací klíč, ani Zoom. \\n\\nUpozorňujeme, že když povolíte šifrování typu end-to-end, nebude v rámci schůzky k dispozici několik funkcí- [Viz podrobnosti v dokumentaci Zoom] (https://support.zoom.us/hc/en-us/articles/360048660871).';
$string['option_host_video'] = 'Video hostitele';
$string['option_host_video_help'] = 'Povolením této možnosti povolíte video hostitele při připojení ke schůzce. I když si vyberete vypnuto, hostitel bude mít možnost spustit své video.';
$string['option_jbh'] = 'Připojení před hostitelem';
$string['option_jbh_help'] = 'Povolení této možnosti umožní účastníkům připojit se ke schůzce před připojením hostitele nebo v případě, že se hostitel schůzky nemůže zúčastnit. \\n\\nTato možnost se vzájemně vylučuje s možností „Čekárna“, takže výběrem jedné se deaktivuje druhá.';
$string['option_mute_upon_entry'] = 'Ztlumit zvuk po vstupu';
$string['option_mute_upon_entry_help'] = 'Automaticky ztlumit všechny účastníky, když se připojí ke schůzce. Hostitel určuje, zda účastníci mohou následně sami aktivovat mikrofon.';
$string['option_participants_video'] = 'Video účastníků';
$string['option_participants_video_help'] = 'Povolení této možnosti aktivujete video účastníků při připojení ke schůzce. I když si vyberete vypnuto, účastníci budou mít možnost spustit své video.';
$string['option_proxyhost'] = 'Použít proxy server';
$string['option_proxyhost_desc'] = 'Proxy server nastavený jako \'<code>&lt;hostname&gt;:&lt;port&gt;</code>" se používá pouze pro komunikaci se Zoomem. Chcete-li použít výchozí nastavení proxy serveru Moodle, ponechte prázdné. Tuto možnost je třeba nastavit pouze v případě, že nechcete v Moodle nastavit globální proxy.';
$string['option_view_recordings'] = 'Povolit prohlížení nahrávek';
$string['option_waiting_room'] = 'Povolit čekárnu';
$string['option_waiting_room_help'] = 'Povolení této možnosti umožňuje hostiteli řídit, kdy se účastník připojí ke schůzce. \\n\\nTato možnost se vzájemně vylučuje s možností „Připojit se před hostitelem“, takže výběrem jedné deaktivujete druhou.';
$string['participantdatanotavailable'] = 'Podrobnosti nejsou k dispozici';
$string['participantdatanotavailable_help'] = 'Údaje o účastnících nejsou pro tuto relaci Zoomu k dispozici (např. z důvodu dodržování předpisů HIPAA).';
$string['participantgroups'] = 'Skupiny účastníků';
$string['participants'] = 'Účastníci';
$string['password'] = 'Přístupový kód';
$string['password_allowed_char'] = 'Heslo může obsahovat pouze následující znaky: [a-z A-Z 0-9 @-_ *].';
$string['password_consecutive'] = 'Maximální {$a} po sobě jdoucích znaků (abcd, 1111, 1234 atd.).';
$string['password_length'] = 'Minimální počet znaků: {$a}.';
$string['password_letter'] = 'Heslo musí obsahovat alespoň 1 písmeno.';
$string['password_lower_upper'] = 'Heslo musí obsahovat malá i velká písmena.';
$string['password_max_length'] = 'Maximálně 10 znaků.';
$string['password_number'] = 'Heslo musí obsahovat alespoň 1 číslo.';
$string['password_only_numeric'] = 'Heslo může obsahovat pouze čísla a žádné jiné znaky.';
$string['password_special'] = 'Heslo musí mít alespoň 1 speciální znak (@-_*).';
$string['passwordprotected'] = 'Chráněno Přístupovým kódem';
$string['pluginadministration'] = 'Spravovat schůzku';
$string['pluginname'] = 'Schůzka přes Zoom';
$string['privacy:metadata:zoom_breakout_participants'] = 'Databázová tabulka pro uložení seznamu účastníků dílčích místností schůzek Zoom';
$string['privacy:metadata:zoom_breakout_participants:userid'] = 'ID uživatele účastníka';
$string['privacy:metadata:zoom_meeting_details'] = 'Tabulka databáze, která ukládá informace o každé instanci schůzky.';
$string['privacy:metadata:zoom_meeting_details:topic'] = 'Název schůzky, které se uživatel zúčastnil.';
$string['privacy:metadata:zoom_meeting_participants'] = 'Tabulka databáze, která ukládá informace o účastnících schůzky.';
$string['privacy:metadata:zoom_meeting_participants:duration'] = 'Délka účasti uživatele';
$string['privacy:metadata:zoom_meeting_participants:join_time'] = 'Čas, kdy se účastník připojil ke schůzce';
$string['privacy:metadata:zoom_meeting_participants:leave_time'] = 'Čas, kdy účastník opustil schůzku';
$string['privacy:metadata:zoom_meeting_participants:name'] = 'Jméno účastníka';
$string['privacy:metadata:zoom_meeting_participants:user_email'] = 'E-mail účastníka';
$string['privacy:metadata:zoom_meeting_view'] = 'Databázová tabulka pro sledování uživatelů, kteří si prohlížejí záznamy schůzek';
$string['privacy:metadata:zoom_meeting_view:userid'] = 'ID uživatele, který si prohlížel záznam';
$string['protectedgroups'] = 'Chránit skupiny';
$string['protectedgroups_desc'] = 'Výběr skupin Zoom pro ochranu členských uživatelů před předefinováním licence';
$string['recording'] = 'Záznam';
$string['recordingadd'] = 'Přidat záznam';
$string['recordingdate'] = 'Datum záznamu';
$string['recordingdelete'] = 'Opravdu chcete smazat nahrávku „{$a}“?';
$string['recordinghide'] = 'Skrýt záznam (aktuálně viditelný)';
$string['recordinglink'] = 'Odkaz na záznam';
$string['recordingname'] = 'Název';
$string['recordingnotfound'] = 'Záznam nebyl nalezen';
$string['recordingnotvisible'] = 'Záznam není vidět. Pokud se domníváte, že se jedná o chybu, kontaktujte svého správce systému';
$string['recordingpasscode'] = 'Přístupový kód záznamu';
$string['recordings'] = 'Nahrávky';
$string['recordingshow'] = 'Zobrazit záznam (aktuálně skrytý)';
$string['recordingshowtoggle'] = 'Přepnout Zobrazit záznam';
$string['recordingtype_active_speaker'] = 'Aktivní mluvčí';
$string['recordingtype_audio_interpretation'] = 'Zvuková interpretace';
$string['recordingtype_audio_only'] = 'Pouze zvuk';
$string['recordingtype_audio_transcript'] = 'Zvukový přepis';
$string['recordingtype_chat'] = 'Soubor chatu';
$string['recordingtype_closed_caption'] = 'Skryté titulky';
$string['recordingtype_gallery'] = 'Zobrazení galerie';
$string['recordingtype_poll'] = 'Hlasování';
$string['recordingtype_production_studio'] = 'Produkční studio';
$string['recordingtype_shared'] = 'Sdílená obrazovka';
$string['recordingtype_shared_gallery'] = 'Sdílená obrazovka se zobrazením galerie';
$string['recordingtype_shared_speaker'] = 'Sdílená obrazovka se zobrazením reproduktoru';
$string['recordingtype_shared_speaker_cc'] = 'Sdílená obrazovka se zobrazením reproduktoru (CC)';
$string['recordingtype_sign'] = 'Znak tlumočení';
$string['recordingtype_speaker'] = 'Zobrazení mluvčího';
$string['recordingtype_summary'] = 'Souhrn';
$string['recordingtype_summary_next_steps'] = 'Shrnutí Další kroky';
$string['recordingtype_summary_smart_chapters'] = 'Souhrn chytrých kapitol?';
$string['recordingtype_timeline'] = 'Časová osa';
$string['recordingurl'] = 'Adresa URL záznamu';
$string['recordingview'] = 'Zobrazit nahrávky';
$string['recordingvisibility'] = 'Jsou záznamy z této schůzky viditelné ve výchozím nastavení?';
$string['recordingvisibility_help'] = 'Když se načítají nové nahrávky této schůzky, měly by být ve výchozím nastavení viditelné v Moodle?';
$string['recreatesuccessful'] = 'Úspěšně obnovená schůzka';
$string['recurrence_option_daily'] = 'Denně';
$string['recurrence_option_monthly'] = 'Měsíčně';
$string['recurrence_option_no_time'] = 'Žádný pevný čas';
$string['recurrence_option_weekly'] = 'Týdně';
$string['recurrencetype'] = 'Opakovaně';
$string['recurringmeeting'] = 'Opakovaná schůzka';
$string['recurringmeeting_help'] = 'Povolením této možnosti se schůzka stane opakovanou schůzkou bez data a času ukončení. Poté je možné se k ní kdykoli přihlásit.';
$string['recurringmeetingexplanation'] = 'Schůzka nemá datum ani čas ukončení';
$string['recurringmeetinglong'] = 'Opakovaná schůzka (schůzka bez koncového data nebo času)';
$string['recurringmeetingthisis'] = 'Toto je opakující se schůzka';
$string['recycleonjoin'] = 'Po připojení recyklujte licenci';
$string['redefinelicenses'] = 'Předefinování licencí';
$string['refreshreports'] = 'Obnovit sestavy o relacích';
$string['register'] = 'Registrace';
$string['registration'] = 'Vyžadovat registraci';
$string['registration_help'] = 'Povolení této možnosti přinutí účastníky, aby se před připojením zaregistrovali na schůzku/webinář Zoom.';
$string['registration_text'] = 'Vynutit účastníkům registraci na schůzku/webinář';
$string['repeatinterval'] = 'Opakujte každý';
$string['report'] = 'Zprávy';
$string['reportapicalls'] = 'Oznámení o vyčerpání počtu volání rozhraní API';
$string['requirepasscode'] = 'Vyžadovat přístupový kód schůzky';
$string['requirepasscode_help'] = 'Povolení této možnosti bude vyžadovat, aby hostitel nastavil přístupový kód pro schůzku. Připojování účastníků bude nutné zadat před připojením ke schůzce. Účastníci, kteří vstoupí na schůzku v rámci aktivity Moodle, nemusí tento přístupový kód zadávat.';
$string['resetapicalls'] = 'Obnovení počtu dostupných volání rozhraní API';
$string['resetzoomsall'] = 'Odstranit všechna hodnocení uživatelů, zaznamenávání dat zobrazení uživatelů a uživatelská data účastníků schůzky.';
$string['room'] = 'Místnost';
$string['roomname'] = 'Název místnosti';
$string['rooms'] = 'Místnosti';
$string['schedule'] = 'Plán';
$string['schedulefor'] = 'Naplánovat schůzku pro';
$string['schedulefor_help'] = 'Schůzky můžete naplánovat jménem jiného uživatele. Předpokladem je, že vám tento uživatel v aplikaci Zoom přidělil oprávnění pro plánování. Vybraný uživatel bude hostitelem schůzky a bude tím, jehož licence Zoom bude pro schůzku použita.';
$string['scheduleforself'] = 'Sám';
$string['schedulingprivilege'] = 'Oprávnění pro plánování';
$string['schedulingprivilege_desc'] = 'Pomocí tohoto nastavení můžete určit, zda se uživatelům v nastavení instance aktivity zobrazí možnost oprávnění plánování. Toto nastavení ovlivňuje pouze nastavení instance aktivity Moodle. I když se rozhodnete tuto možnost zobrazit, uživatel bude stále muset získat oprávnění pro plánování udělené jiným uživatelem v Zoom, aby mohl konečně naplánovat schůzku pro druhého uživatele.';
$string['schedulingprivilege_disable'] = 'Zakázat možnost oprávnění pro plánování';
$string['schedulingprivilege_enable'] = 'Povolit možnost oprávnění pro plánování';
$string['search:activity'] = 'Zoom - informace o aktivitě';
$string['security'] = 'Zabezpečení';
$string['selectionarea'] = 'Bez výběru';
$string['sendicalnotifications'] = 'Odeslat oznámení iCal';
$string['sendicalnotifications_help'] = 'Povolení této možnosti umožní odesílání oznámení iCal prostřednictvím naplánované úlohy „Odeslat oznámení iCal“.';
$string['sendicalnotifications_warning'] = 'Pro použití této možnosti musí být povoleny přílohy v sekci Administrace webu / Server / E-mail / Konfigurace odchozí pošty.';
$string['sessions'] = 'Relace';
$string['sessionsreport'] = 'Sestava relací';
$string['sesskeyinvalid'] = 'Byla zjištěna neplatná relace. Nelze pokračovat.';
$string['setpasscode'] = 'Nastavit přístupový kód';
$string['showmedia'] = 'Zobrazit sekci Média';
$string['showmedia_help'] = 'Po povolení této možnosti se na stránce aktivity schůzky zobrazí sekce Média.';
$string['showmediaonview'] = 'Zobrazit sekci Média na stránce schůzky';
$string['showschedule'] = 'Zobrazit sekci Plán';
$string['showschedule_help'] = 'Po povolení této možnosti se na stránce aktivity schůzky zobrazí sekce Plán.';
$string['showscheduleonview'] = 'Zobrazit sekci Plán na stránce schůzky';
$string['showsecurity'] = 'Zobrazit sekci Zabezpečení';
$string['showsecurity_help'] = 'Po povolení této možnosti se na stránce aktivity schůzky zobrazí sekce Zabezpečení.';
$string['showsecurityonview'] = 'Zobrazit sekci Zabezpečení na stránce schůzky';
$string['start'] = 'Začátek';
$string['start_meeting'] = 'Zahájit schůzku';
$string['start_time'] = 'Kdy';
$string['starthostjoins'] = 'Spuštění videa při připojení hostitele';
$string['startpartjoins'] = 'Spuštění videa, když se účastník připojí';
$string['starttime'] = 'Čas zahájení';
$string['status'] = 'Status';
$string['supplementaryfeaturessettings'] = 'Nastavení doplňkových funkcí';
$string['supplementaryfeaturessettings_desc'] = 'Tato nastavení určují, zda a jak jsou uživatelům poskytovány doplňkové funkce zoomu.';
$string['title'] = 'Název';
$string['topic'] = 'Téma';
$string['trackingfields'] = 'Sledovaná pole';
$string['trackingfields_help'] = 'Chcete-li aktivovat aktivity přiblížení, zadejte název(názvy)/popisek(y) pole Zoom oddělené čárkami.';
$string['trackingfields_recommendedvalues'] = 'Doporučené hodnoty:';
$string['unamedisplay'] = 'Zobrazované jméno uživatele';
$string['unamedisplay_help'] = 'Jak se má zobrazovat jméno uživatele na schůzkách (funguje pouze pro uživatele, kteří nejsou přihlášeni do klienta Zoom).';
$string['unavailable'] = 'V tuto chvíli se nemůžete připojit.';
$string['unavailablefinished'] = 'Setkání již skončilo.';
$string['unavailablefirstjoin'] = 'Můžete se připojit nejdříve {$a->mins} minut před plánovaným časem zahájení.';
$string['unavailablenotstartedyet'] = 'Schůzka ještě nezačala.';
$string['updatemeetings'] = 'Aktualizace nastavení schůzky ze Zoomu';
$string['updatetrackingfields'] = 'Aktualizujte nastavení pole sledování z Zoomu';
$string['usepersonalmeeting'] = 'Použít osobní ID schůzky {$a}';
$string['waitingroom'] = 'Čekárna povolena';
$string['waitingroomenable'] = 'Povolit čekárnu';
$string['webinar'] = 'Webinář';
$string['webinar_already_false'] = '<p><b>Tento modul byl již nastaven jako schůzka, nikoli jako webinář. Toto nastavení nelze po vytvoření schůzky přepnout.</b></p>';
$string['webinar_already_true'] = '<p><b>Tento modul byl již nastaven jako webinář, nikoli jako schůzka. Toto nastavení nelze po vytvoření webináře přepnout </b> </p>';
$string['webinar_alwaysshow'] = 'Vždy zobrazit možnost webináře bez ohledu na to, zda má uživatel licenci k pořádání webinářů';
$string['webinar_by_default'] = 'Webinář ve výchozím nastavení';
$string['webinar_by_default_desc'] = 'Ve výchozím nastavení vytvořte instanci Zoom jako webinář.';
$string['webinar_desc'] = 'Pomocí tohoto nastavení můžete určit, zda se uživatelům při vytváření schůzky zobrazí možnost vytvořit webinář. Toto nastavení ovlivňuje pouze nastavení instance aktivity Moodle. I když se rozhodnete tuto možnost vždy zobrazit, uživatel bude stále potřebovat platnou licenci pro webináře, aby mohl konečně hostit webinář.';
$string['webinar_disable'] = 'Zakázat webové semináře';
$string['webinar_help'] = 'Webináře poskytují hostitelům lepší kontrolu a flexibilitu při pořádání schůzek s větším publikem. \\n\\ nTato možnost je k dispozici pouze pro předem schválené účty Zoom.';
$string['webinar_showonlyiflicense'] = 'Zobrazit možnost webináře pouze v případě, že má uživatel licenci k pořádání webinářů';
$string['webinarthisis'] = 'Toto je webinář';
$string['week'] = 'Týdny';
$string['weekoption_first'] = 'První';
$string['weekoption_fourth'] = 'Čtvrtý';
$string['weekoption_last'] = 'Poslední';
$string['weekoption_second'] = 'Druhý';
$string['weekoption_third'] = 'Třetí';
$string['zoom:addinstance'] = 'Přidání nové schůzky přes Zoom';
$string['zoom:eligiblealternativehost'] = 'Volitelný jako alternativní hostitel v rámci schůzek Zoom';
$string['zoom:refreshsessions'] = 'Aktualizovat sestavy o schůzce Zoom';
$string['zoom:view'] = 'Zobrazení schůzek přes Zoom';
$string['zoom:viewdialin'] = 'Zobrazit Zoom informace o vytáčení';
$string['zoom:viewjoinurl'] = 'Zobrazit Zoom URL připojení';
$string['zoomerr'] = 'Při připojení přes Zoom došlo k chybě.';
$string['zoomerr_alternativehostusernotfound'] = 'Uživatel {$a} nebyl na Zoom nalezen.';
$string['zoomerr_apilimit'] = 'Dosáhli jste maximálního denního limitu sazby pro toto API. Zkuste to znovu v {$a}';
$string['zoomerr_field_missing'] = '{$a} nenalezeno';
$string['zoomerr_id_missing'] = 'Je nutné zadat ID course_module nebo ID instance.';
$string['zoomerr_licensesnumber_missing'] = 'Bylo nalezeno nastavení Zoomu, ale číslo licence nebylo nalezeno';
$string['zoomerr_maxretries'] = 'Pokusili jsme se spojit {$a->maxretries} krát, ale nezdařilo se: {$a->response}';
$string['zoomerr_meetingnotfound'] = 'Tuto schůzku nelze v aplikaci Zoom najít. Můžete ji <a href="{$a->recreate}">znovu vytvořit zde</a> nebo <a href="{$a->delete}">ji odstranit</a>.';
$string['zoomerr_meetingnotfound_info'] = 'Tuto schůzku nelze v aplikaci Zoom najít. Máte-li dotazy, obraťte se na hostitele schůzky.';
$string['zoomerr_no_access_token'] = 'Nebyl vrácen žádný přístupový token';
$string['zoomerr_scopes'] = 'V konfiguraci Zoom OAuth chybí tyto požadované rozsahy: {$a}';
$string['zoomerr_usernotfound'] = 'V aplikaci Zoom nelze najít váš účet.Pokud používáte Zoom poprvé, musíte si účet Zoom aktivovat přihlášením na <a href="{$a}" target="_blank">{$a}</a>. Po aktivaci účtu na Zoomu znovu načtěte tuto stránku a pokračujte v nastavování schůzky. Jinak se ujistěte, že váš e-mail na Zoom odpovídá vašemu e-mailu v tomto systému.';
$string['zoomerr_viewrecordings_off'] = 'Prohlížení záznamů je vypnuto, úlohu nelze spustit';
$string['zoomurl'] = 'URL domovské stránky Zoom';
