<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_essayautograde', language 'cs', version '5.1'.
 *
 * @package     qtype_essayautograde
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addmultiplebands'] = 'Přidat další {$a} stupňů hodnocení';
$string['addmultiplephrases'] = 'Přidat další cílové fráze ({$a})';
$string['addpartialgrades'] = 'Udělovat dílčí známky?';
$string['addpartialgrades_help'] = 'Pokud je tato možnost povolena, budou se přidávat známky i pro částečně splněné stupně hodnocení.';
$string['addsingleband'] = 'Přidat další 1 stupeň hodnocení';
$string['addsinglephrase'] = 'Přidat ještě 1 cílovou frázi';
$string['aiassistant'] = 'Asistent AI';
$string['aiassistant_help'] = 'Vyberte asistenta pro hodnocení s umělou inteligencí, pokud existuje, kterého chcete použít ke generování zpětné vazby a předběžného hodnocení odevzdaných studentských prací.';
$string['aiassistantnotenabled'] = 'Na tomto webu Moodle momentálně nejsou povoleni žádní asistenti s umělou inteligencí pro generování textu. Požádejte prosím svého administrátora Moodlu o přidání nastavení pro poskytovatele umělé inteligence (Administrace webu > Umělá inteligence).';
$string['aipercent'] = 'Známka AI';
$string['aipercent_help'] = 'Vyberte procentuální podíl známky z umělé inteligence na celkové známce pro tuto otázku.';
$string['aiprompt'] = 'Výzva AI';
$string['aiprompt_help'] = 'Přidejte výzvu vhodnou k odeslání asistentovi s umělou inteligencí za účelem získání zpětné vazby a/nebo hodnocení práce odevzdané studenty.';
$string['aisettings'] = 'Nastavení AI';
$string['allowsimilarity'] = 'Povolit podobnost?';
$string['allowsimilarity_help'] = 'Maximální povolená úroveň podobnosti mezi odpovědí studenta a šablonou odpovědi nebo vzorovou odpovědí. Čím vyšší je tato hodnota, tím podobnější může být odpověď studenta šabloně nebo vzoru. Naopak, čím nižší je hodnota, tím více se musí odpověď studenta od šablony nebo vzoru lišit. Úprava této hodnoty může ovlivnit úroveň originality a detailů, které se od studentů v jejich odpovědích požadují.';
$string['allowsimilaritypercent'] = 'Ano - povolit až {$a}% podobnost';
$string['auto'] = 'Automaticky';
$string['autograding'] = 'Automatické hodnocení';
$string['bandtext'] = 'Za {$a->count} nebo více položek udělte {$a->percent} hodnocení otázky.';
$string['bandtext1'] = 'Pro';
$string['bandtext2'] = 'nebo více položek, ocenění';
$string['bandtext3'] = 'známky úlohy.';
$string['chars'] = 'Znaků';
$string['charspersentence'] = 'Znaků na větu';
$string['commonerror'] = 'Častá chyba';
$string['commonerrors'] = 'Časté chyby';
$string['commonerrors_help'] = 'Běžné chyby jsou definovány ve „Slovníku chyb“ souvisejícím s touto úlohou.';
$string['correctresponse'] = 'Abyste za tuto otázku získali plný počet bodů, musíte splnit následující kritéria:';
$string['countcharslabel'] = 'Aktuální počet znaků';
$string['countfileslabel'] = 'Aktuální počet souborů';
$string['countparagraphslabel'] = 'Aktuální počet odstavců';
$string['countsentenceslabel'] = 'Aktuální počet vět';
$string['countwordslabel'] = 'Aktuální počet slov';
$string['crop'] = 'Oříznutí';
$string['enableautograde'] = 'Povolit automatické hodnocení';
$string['enableautograde_help'] = 'Povolit nebo zakázat automatického hodnocení';
$string['errorbehavior'] = 'Chování při porovnávání chyb';
$string['errorbehavior_help'] = 'Tato nastavení upřesňují chování při porovnávání položek ve slovníku běžných chyb.';
$string['errorcmid'] = 'Slovník chyb';
$string['errorcmid_help'] = 'Vyberte slovník, který obsahuje seznam běžných chyb.

Pokaždé, když se v eseji najde jedna z chyb, bude studentovi odečtena zadaná penalizace z hodnocení za tuto otázku.';
$string['errorpercent'] = 'Penalizace za chybu';
$string['errorpercent_help'] = 'Vyberte procento celkového hodnocení, které se má odečíst za každou chybu nalezenou v odpovědi.';
$string['excludecommonerrors'] = 'Nedělejte žádné z běžných chyb v <a href="{$a->href}" target="_blank">{$a->name</a>';
$string['explanationautopercent'] = 'Toto je mimo normální procentuální rozsah, takže bylo upraveno na {$a->autopercent}%.';
$string['explanationcommonerror'] = '{$a->percent}% za zahrnutí "{$a->error}", což je běžná chyba';
$string['explanationcompleteband'] = '{$a->percent}% za splnění hodnocení [{$a->gradeband}]';
$string['explanationdatetime'] = 'dne %Y %b %d (%a) ve %H:%M';
$string['explanationfiles'] = '{$a->percent}% pro odeslání souborů {$a->filecount} / {$a->itemcount}';
$string['explanationfirstitems'] = '{$a->percent}% pro první {$a->count} {$a->itemtype}';
$string['explanationgrade'] = 'Počítačem vygenerovaná známka pro tuto esej byla proto nastavena na {$a->finalgrade} = ({$a->finalpercent}% z {$a->maxgrade}).';
$string['explanationitems'] = '{$a->percent}% pro {$a->count} {$a->itemtype}';
$string['explanationmaxgrade'] = 'Maximální známka pro tuto úlohu je {$a->maxgrade}.';
$string['explanationnotenough'] = 'Hodnota {$a->count} {$a->itemtype} je menší než minimální počet požadovaný pro udělení známky.';
$string['explanationoverride'] = 'Později, {$a->datetime}, byla známka za tuto esej ručně nastavena na {$a->manualgrade}.';
$string['explanationpartialband'] = '{$a->percent}% za částečné splnění hodnocení [{$a->gradeband}]';
$string['explanationpenalty'] = 'Za kontrolu odpovědi před odesláním však byla odečtena hodnota {$a->penaltytext}.';
$string['explanationrawpercent'] = 'Hrubá procentuální známka pro tuto esej je {$a->rawpercent}% <br /> = {$a->details}.';
$string['explanationremainingitems'] = '{$a->percent}% pro zbývající {$a->count} {$a->itemtype}';
$string['explanationseecomment'] = '(viz komentář níže)';
$string['explanationtargetphrase'] = '{$a->percent} za zahrnutí fráze „{$a->phrase}“';
$string['feedback'] = 'Zpětná vazba';
$string['feedbackhintbreaks'] = 'Použili jste příliš mnoho zalomení řádků?';
$string['feedbackhintchars'] = 'Napsali jste požadovaný počet znaků?';
$string['feedbackhinterrors'] = 'Udělali jste nějaké běžné chyby?';
$string['feedbackhintfiles'] = 'Připojili jste požadovaný počet souborů?';
$string['feedbackhintparagraphs'] = 'Napsali jste požadovaný počet odstavců?';
$string['feedbackhintphrases'] = 'Zahrnuli jste všechny cílové fráze?';
$string['feedbackhints'] = 'Tipy pro zlepšení vaší známky';
$string['feedbackhintsentences'] = 'Napsali jste požadovaný počet vět?';
$string['feedbackhintwords'] = 'Dosáhli jste cílového počtu slov?';
$string['files'] = 'Soubory';
$string['fogindex'] = 'Fog index';
$string['fogindex_help'] = 'Index Gunning fog je měřítkem čitelnosti. Vypočítává se pomocí následujícího vzorce.

* ((slova ve větě) + (dlouhá slova ve větě)) x 0,4

Další informace naleznete na adrese: <https://en.wikipedia.org/wiki/Gunning_fog_index>';
$string['forceupgrade'] = 'Vynutit upgrade';
$string['gradeband'] = 'Známka pásma [{no}]';
$string['gradeband_help'] = 'Uveďte minimální počet započitatelných položek, na které se má toto pásmo použít, a známku, která se má udělit, pokud se toto pásmo použije.';
$string['gradebands'] = 'Známka pásma';
$string['gradecalculation'] = 'Výpočet známky';
$string['gradeforthisquestion'] = 'Hodnocení za tuto otázku';
$string['hidden'] = 'Skryté';
$string['hidesample'] = 'Skrýt vzorek';
$string['itemcount'] = 'Očekávaný počet položek';
$string['itemcount_help'] = 'Minimální počet spočetných položek, které musí být v textu eseje obsaženy, aby bylo za tuto úlohu dosaženo maximálního hodnocení.

 Upozorňujeme, že tato hodnota může být zneplatněna v případě níže definovaných pásem hodnocení, pokud existují.';
$string['itemtype'] = 'Typ započitatelných položek';
$string['itemtype_help'] = 'Vyberte typ položek v textu eseje, které budou přispívat k automatickému hodnocení.';
$string['lexicaldensity'] = 'Lexikální hustota';
$string['lexicaldensity_help'] = 'Lexikální hustota je procento vypočítané pomocí následujícího vzorce.

 * 100 x (počet unikátních slov) / (celkový počet slov)

Esej, ve které se mnoho slov opakuje, má tedy nízkou lexikální hustotu, zatímco esej s mnoha unikátními slovy má vysokou lexikální hustotu.';
$string['longwords'] = 'Dlouhá slova';
$string['longwords_help'] = '„Dlouhá slova“ jsou slova, která mají tři nebo více slabik. Upozorňujeme, že algoritmus pro určení počtu slabik poskytuje pouze přibližné výsledky.';
$string['longwordspersentence'] = 'Dlouhá slova ve větě';
$string['maximumfilecount'] = 'Maximální počet souborů: {$a}';
$string['maximumfilesize'] = 'Maximální velikost souboru: {$a}';
$string['maxwordserror'] = 'Jejda, napsali jste příliš mnoho slov!';
$string['maxwordslabel'] = 'Maximální počet slov';
$string['maxwordswarning'] = 'Jejda, napsali jste příliš mnoho slov!';
$string['minimumfilecount'] = 'Minimální počet souborů: {$a}';
$string['minwordserror'] = 'Jejda! Napsali jste málo slov.';
$string['minwordslabel'] = 'Minimální počet slov';
$string['minwordswarning'] = 'Jen tak dál! Ještě jste nenapsali dostatek slov.';
$string['missing'] = 'Chybějící';
$string['overflow'] = 'Přetéká';
$string['paragraphs'] = 'Odstavce';
$string['phrasebehavior'] = 'Chování cílové fráze [{no}]';
$string['phrasebehavior_help'] = 'Tato nastavení upřesňují chování při shodě pro tuto cílovou frázi.';
$string['phrasecasesensitiveno'] = 'Shoda nerozlišuje velká a malá písmena.';
$string['phrasecasesensitiveyes'] = 'Shoda rozlišuje velká a malá písmena.';
$string['phrasedivisor'] = 'Dělitel frází';
$string['phrasefullmatchno'] = 'Hledat celá nebo částečná slova.';
$string['phrasefullmatchyes'] = 'Hledat pouze celá slova.';
$string['phraseignorebreaksno'] = 'Rozpoznávat zalomení řádků.';
$string['phraseignorebreaksyes'] = 'Ignorovat zalomení řádků.';
$string['phrasematch'] = 'Frázová shoda';
$string['phrasepercent'] = 'Procento frází';
$string['phrasepercentdividedby'] = 'děleno {$a}';
$string['phrasepercentexactly'] = 'přesně';
$string['phrasetext'] = 'Pokud je použita {$a->phrase}, udělte {$a->percent} známky za úlohu.';
$string['phrasetext1'] = 'Když';
$string['phrasetext2'] = 'se používá, ocenění';
$string['phrasetext4'] = 'známka úlohy.';
$string['pleaseattachfiles'] = 'Prosím, přiložte požadovaný počet souborů.';
$string['pleaseinputtext'] = 'Prosím, zadejte svou odpověď do textového pole.';
$string['pluginname'] = 'Esej (automatické hodnocení)';
$string['pluginname_help'] = 'V odpovědi na úlohu, která může obsahovat obrázek, respondent napíše odpověď o jednom nebo více odstavcích. Známka je zpočátku udělena automaticky na základě počtu znaků, slov, vět nebo odstavců a přítomnosti určitých cílových frází. Automatickou známku může učitel později přepsat.';
$string['pluginname_link'] = 'question/type/essayautograde';
$string['pluginnameadding'] = 'Přidání úlohy Esej (automatické hodnocení)';
$string['pluginnameediting'] = 'Úprava úlohy Esej (automatické hodnocení)';
$string['pluginnamesummary'] = 'Umožňuje odeslat esej o několika větách nebo odstavcích jako odpověď na otázku. Esej je hodnocena automaticky. Známku lze později přepsat.';
$string['present'] = 'Současnost';
$string['privacy:metadata'] = 'Plugin otázek typu Esej(automatické hodnocení) neukládá žádné osobní údaje.';
$string['requiredfilecount'] = 'Požadovaný počet souborů: {$a}';
$string['responseisnotoriginal'] = 'Prosím, udělejte svůj text originálnější.';
$string['responsesample'] = 'Ukázková odpověď';
$string['responsesample_help'] = 'Jakýkoli text zde bude zobrazen jako vzorová odpověď, pokud student klikne na odkaz „Zobrazit vzorovou odpověď“ v textu úlohy.';
$string['responsesampleformat'] = 'Formát ukázky eseje';
$string['responsesampleformat_help'] = 'Vyberte formát vzorového textu odpovědi.';
$string['rewriteresubmit'] = 'a znovu odeslat.';
$string['rewriteresubmitbreaks'] = 'odstranit všechna zalomení řádků';
$string['rewriteresubmitchars'] = 'přidat další znaky';
$string['rewriteresubmiterrors'] = 'opravte běžné chyby,';
$string['rewriteresubmitfiles'] = 'přiložte požadovaný počet souborů';
$string['rewriteresubmitparagraphs'] = 'přidat další odstavce';
$string['rewriteresubmitphrases'] = 'přidat chybějící fráze';
$string['rewriteresubmitsentences'] = 'přidat další věty';
$string['rewriteresubmitwords'] = 'přidat další slova';
$string['rotate'] = 'Střídat';
$string['scale'] = 'Měřítko';
$string['sentences'] = 'Věty';
$string['sentencesperparagraph'] = 'Věty v odstavci';
$string['showcalculation'] = 'Zobrazit výpočet známek?';
$string['showcalculation_help'] = 'Pokud je tato možnost povolena, zobrazí se na stránkách pro hodnocení a kontrolu vysvětlení výpočtu automaticky generovaného hodnocení.';
$string['showfeedback'] = 'Zobrazit zpětnou vazbu studentům?';
$string['showfeedback_help'] = 'Pokud je tato možnost povolena, na stránkách pro hodnocení a kontrolu se zobrazí tabulka s užitečnou zpětnou vazbou. Použitelná zpětná vazba je zpětná vazba, která studentům říká, co by měli udělat pro zlepšení.';
$string['showgradebands'] = 'Zobrazit pásma známek?';
$string['showgradebands_help'] = 'Pokud je tato možnost povolena, zobrazí se na stránkách pro hodnocení a kontrolu podrobnosti o pásmech hodnocení.';
$string['showsample'] = 'Zobrazit ukázku';
$string['showtargetphrases'] = 'Zobrazit cílové fráze?';
$string['showtargetphrases_help'] = 'Pokud je tato možnost povolena, zobrazí se na stránkách pro hodnocení a kontrolu podrobnosti o cílových frázích.';
$string['showtextstats'] = 'Zobrazit statistiky textových zpráv?';
$string['showtextstats_help'] = 'Pokud je tato možnost povolena, zobrazí se statistiky o textu.';
$string['showtostudentsonly'] = 'Ano, zobrazit pouze studentům';
$string['showtoteachersandstudents'] = 'Ano, ukázat učitelům a studentům';
$string['showtoteachersonly'] = 'Ano, zobrazit pouze učitelům';
$string['targetphrase'] = 'Cílová fráze [{no}]';
$string['targetphrase_help'] = 'Uveďte známku, která bude přidána, pokud se tato cílová fráze objeví v eseji.

> **např.** Pokud je použito [Konečně], udělte [10 % známky z otázky.]

Cílová fráze může být jedna fráze nebo seznam frází oddělených čárkou "," nebo slovem "NEBO" (velkými písmeny).

> **např.** Pokud je použito [Konečně NEBO Konečně], udělte [10 % známky z otázky.]

Otazník "?" ve frázi odpovídá libovolnému jednotlivému znaku, zatímco hvězdička "*" odpovídá libovolnému počtu znaků (včetně nuly).

> **např.** Pokud je použito [První\\*Pak\\*Konečně], udělte [50 % známky z otázky.]';
$string['targetphrases'] = 'Cílové fráze';
$string['textstatistics'] = 'Statistiky textu';
$string['textstatitems'] = 'Statistické položky';
$string['textstatitems_help'] = 'Zde vyberte libovolné položky, které chcete zobrazit v textových statistikách zobrazených na stránkách s hodnocením a přehledy.';
$string['uniquewords'] = 'Unikátní slova';
$string['uploadfiles'] = 'Nahrát soubory';
$string['visible'] = 'Viditelné';
$string['words'] = 'Slova';
$string['wordspersentence'] = 'Slova ve větě';
