<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'backup', language 'mn', version '5.1'.
 *
 * @package     backup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['asyncbackupcomplete'] = 'Нөөцлөх процесс хийгдэж дууслаа';
$string['asyncbackupcompletebutton'] = 'Үргэлжлүүлэх';
$string['asyncbackupcompletedetail'] = 'Нөөцлөх процесс амжилттай хийгдэж дууслаа. <br/> Та <a href="{$a}">сэргээх хуудаснаас</a> нөөц хуулбарт хандах боломжтой.';
$string['asyncbackuperror'] = 'Нөөцлөх процесс амжилтгүй боллоо';
$string['asyncbackuperrordetail'] = 'Нөөцлөх процесс амжилтгүй боллоо. Системийн администратортой холбогдоно уу.';
$string['asyncbackuppending'] = 'Нөөцлөх процесс хүлээгдэж байна';
$string['asyncbackupprocessing'] = 'Нөөцлөлт хийгдэж байна';
$string['asyncbadexecution'] = 'Нөөцлөлт хянагчийн гүйцэтгэл амжилтгүй. Энэ нь {$a} байх ба 2 байх ёстой.';
$string['asynccheckprogress'] = 'Та ямар ч үед <a href="{$a}">сэргээх хуудаснаас</a> явцыг шалгах боломжтой.';
$string['asyncemailenable'] = 'Зурвас мэдэгдлийг идэвхжүүлэх';
$string['asyncemailenabledetail'] = 'Идэвхжүүлсэн тохиолдолд асинхрон нөөцлөлт эсвэл сэргээлт хийгдэж дуусахад хэрэглэгч зурвас хүлээн авах болно.';
$string['asyncgeneralsettings'] = 'Асинхрон нөөцлөлт/сэргээлт';
$string['asyncmessagebody'] = 'Зурвас';
$string['asyncmessagebodydefault'] = 'Таны {operation} (ID: {backupid}) амжилттай хийгдэж дууслаа. Та <a href="{link}">{link}</a> холбоосоор хандах боломжтой.';
$string['asyncmessagebodydetail'] = 'Асинхрон нөөцлөлт эсвэл сэргээлт хийгдэж дуусахад илгээх зурвас.';
$string['asyncmessagesubject'] = 'Агуулга';
$string['asyncmessagesubjectdefault'] = 'Moodle {operation} амжилттай хийгдэж дууслаа';
$string['asyncmessagesubjectdetail'] = 'Зурвасын агуулга';
$string['asyncnowait'] = 'Процесс нь үргэлжлэн хийгдэх тул та энд хүлээх шаардлагагүй.';
$string['asyncprocesspending'] = 'Процесс хүлээгдэж байна';
$string['asyncrestorecomplete'] = 'Сэргээх процесс хийгдэж дууслаа';
$string['asyncrestorecompletebutton'] = 'Үргэлжлүүлэх';
$string['asyncrestorecompletedetail'] = 'Сэргээх процесс амжилттай хийгдэж дууслаа. Үргэлжлүүлэх дээр дарвал <a href="{$a}">сэргээсэн хэсгийн хичээлд</a> шилжих болно.';
$string['asyncrestoreerror'] = 'Сэргээх процесс амжилтгүй боллоо';
$string['asyncrestoreerrordetail'] = 'Сэргээх процесс амжилтгүй боллоо. Системийн администратортой холбогдоно уу.';
$string['asyncrestoreinprogress'] = 'Сэргээлт хийгдэж байна';
$string['asyncrestoreinprogress_help'] = 'Хийгдэж байгаа асинхрон хичээлийн сэргээлтийг энд харуулав.';
$string['asyncrestorepending'] = 'Сэргээх процесс хүлээгдэж байна';
$string['asyncrestoreprocessing'] = 'Сэргээлт хийгдэж байна';
$string['asyncreturn'] = 'Хичээл рүү буцах';
$string['autoactivedescription'] = 'Автомат нөөцлөлт хийх эсэхийг сонгох. Гар аргыг сонгосон тохиолдолд автомат нөөцлөлтийг зөвхөн автомат нөөцлөлтийн CLI скриптээр хийх боломжтой. Энэ нь  командын мөрөнд гараас бичих эсвэл крон командаар хийгдэнэ.';
$string['autoactivedisabled'] = 'Идэвхгүй';
$string['autoactiveenabled'] = 'Идэвхтэй';
$string['autoactivemanual'] = 'Гар арга';
$string['automatedbackupschedule'] = 'Хуваарь';
$string['automatedbackupschedulehelp'] = 'Долоо хоногийн аль өдрүүдэд автомат нөөцлөлт хийхийг сонгох';
$string['automatedbackupsinactive'] = 'Сайтын админ автомат нөөцлөлтийг идэвхжүүлээгүй байна';
$string['automatedbackupstatus'] = 'Автомат нөөцлөлтийн төлөв';
$string['automateddeletedays'] = 'Өмнөх хуучин нөөц хуулбаруудыг устгах';
$string['automatedmaxkept'] = 'Хадгалагдсан нөөц хуулбарын хамгийн их тоо';
$string['automatedmaxkepthelp'] = 'Энэ нь хичээл тус бүрээр хадгалагдах сүүлд хийгдсэн автомат нөөцлөлтийн хамгийн их тоог заадаг. Хуучин нөөц хуулбарууд нь автоматаар устгагдана.';
$string['automatedminkept'] = 'Хадгалагдсан нөөцлөлтийн хамгийн бага тоо';
$string['automatedminkepthelp'] = 'Тодорхойлсон хоногийн тооноос илүү хуучирсан нөөц хуулбарыг устгах тохиолдолд идэвхгүй хичээлийн нөөцлөлт хийгдэхгүйгээр дуусаж болзошгүй. Үүнээс урьдчилан сэргийлэхийн тулд нөөцлөлтийн хамгийн бага тоог зааж өгөх шаардлагатай.';
$string['automatedsettings'] = 'Автомат нөөцлөлтийн тохиргоо';
$string['automatedsetup'] = 'Автомат нөөцлөлтийн бүтэц';
$string['automatedstorage'] = 'Автомат нөөцлөлтийн хадгалалт';
$string['automatedstoragehelp'] = 'Нөөц хуулбар автоматаар үүсгэх үед хадгалах байршлыг сонгох';
$string['backupactivity'] = 'Нөөцлөх үйл ажиллагаа: {$a}';
$string['backupautoactivitiesdescription'] = 'Нөөцлөлтөд үйл ажиллагааг оруулах үндсэн тохиргоог хийнэ. Хогийн савыг ажиллуулахын тулд энэ тохиргоог идэвхжүүлсэн байх ёстой.';
$string['backupcoursedetails'] = 'Хичээлийн дэлгэрэнгүй';
$string['backupcoursesection'] = 'Бүлэг: {$a}';
$string['backupcoursesections'] = 'Хичээлийн бүлгүүд';
$string['backupdate'] = 'Авсан огноо';
$string['backupdetails'] = 'Нөөцлөлтийн дэлгэрэнгүй';
$string['backupdetailsnonstandardinfo'] = 'Сонгосон файл нь стандарт Moodle нөөц файл биш байна. Сэргээх процесс нь нөөц файлыг стандарт форматад хөрвүүлж, дараа нь сэргээдэг.';
$string['backupformat'] = 'Формат';
$string['backupformatimscc1'] = 'IMS Common Cartridge 1.0';
$string['backupformatimscc11'] = 'IMS Common Cartridge 1.1';
$string['backupformatmoodle1'] = 'Moodle 1';
$string['backupformatmoodle2'] = 'Moodle 2';
$string['backupformatunknown'] = 'Танигдахгүй формат';
$string['backuplog'] = 'Техникийн мэдээлэл, анхааруулга';
$string['backupmode'] = 'Горим';
$string['backupmode10'] = 'Ерөнхий';
$string['backupmode20'] = 'Импортлох';
$string['backupmode30'] = 'Хаб';
$string['backupmode40'] = 'Ижил сайт';
$string['backupmode50'] = 'Автомат';
$string['backupmode60'] = 'Хөрвүүлсэн';
$string['backupmode70'] = 'Асинхрон';
$string['backupsection'] = 'Нөөц хичээлийн хэсэг: {$a}';
$string['backupsettings'] = 'Нөөцлөлтийн тохиргоо';
$string['backupsitedetails'] = 'Сайтын дэлгэрэнгүй';
$string['backupstage16action'] = 'Үргэлжлүүлэх';
$string['backupstage1action'] = 'Дараагийнх нь';
$string['backupstage2action'] = 'Дараагийнх нь';
$string['backupstage4action'] = 'Нөөцлөлт хийх';
$string['backupstage8action'] = 'Үргэлжлүүлэх';
$string['backuptype'] = 'Төрөл';
$string['backuptypeactivity'] = 'Үйл ажиллагаа';
$string['backuptypecourse'] = 'Хичээл';
$string['backuptypesection'] = 'Бүлэг';
$string['backupversion'] = 'Нөөцлөлтийн хувилбар';
$string['cannotfindassignablerole'] = 'Нөөц файл дахь {$a} эрхийг таны шилжүүлэхийг зөвшөөрсөн эрхүүдийн аль нэгэнд нь харьцуулан буулгах боломжгүй байна.';
$string['choosefilefromactivitybackup'] = 'Үйлдэл нөөцлөх хэсэг';
$string['choosefilefromactivitybackup_help'] = 'Өгөгдмөл тохиргооны дагуу хийгдсэн хичээлийн нөөцлөлтийг энд хадгална.';
$string['choosefilefromautomatedbackup'] = 'Автомат нөөцлөлт';
$string['choosefilefromautomatedbackup_help'] = 'Автоматаар үүсгэгдсэн нөөцлөлтийг агуулна.';
$string['choosefilefromcoursebackup'] = 'Хичээл нөөцлөх хэсэг';
$string['choosefilefromcoursebackup_help'] = 'Өгөгдмөл тохиргооны дагуу хийгдсэн хичээлийн нөөцлөлтийг энд хадгална.';
$string['choosefilefromuserbackup'] = 'Хэрэглэгчийн хувийн нөөцлөх хэсэг';
$string['choosefilefromuserbackup_help'] = 'Нэр нь нууцлагдсан хэрэглэгчийн мэдээлэл бүхий нөөц файлыг энд хадгална.';
$string['config_keep_groups_and_groupings'] = 'Одоогийн бүлэг болон дэд бүлгүүдийг өгөгдмөл тохиргоогоор хадгална.';
$string['config_keep_roles_and_enrolments'] = 'Одоогийн эрх, бүртгэлийг өгөгдмөл тохиргоогоор хадгална.';
$string['config_overwrite_conf'] = 'Хэрэглэгчид тухайн хичээлийн тохиргоог дахин хийх боломжийг олгох';
$string['config_overwrite_course_fullname'] = 'Өгөгдмөл тохиргоогоор хичээлийн бүтэн нэрийг нөөц файлаас авч өөрчилнө. Энэ нь "Overwrite course configuration" тохиргоог шалгах ба тухайн хэрэглэгч нь (moodle/course:changefullname) хичээлийн бүтэн нэрийг өөрчлөх эрхтэй байхыг шаардана.';
$string['config_overwrite_course_shortname'] = 'Өгөгдмөл тохиргоогоор хичээлийн товч нэрийг нөөц файлаас авч өөрчилнө. Энэ нь "Overwrite course configuration" тохиргоог шалгах ба тухайн хэрэглэгч нь (moodle/course:changeshortname) хичээлийн товч нэрийг өөрчлөх эрхтэй байхыг шаардана.';
$string['config_overwrite_course_startdate'] = 'Өгөгдмөл тохиргоогоор хичээл эхлэх огноог нөөц файлаас авч өөрчилнө. Энэ нь "Overwrite course configuration" тохиргоог шалгах ба тухайн хэрэглэгч нь сэргээлтэд (moodle/restore:rolldates) хичээлийн огноог тохируулах эрхтэй байхыг шаардана.';
$string['configgeneralactivities'] = 'Нөөцлөлтөд үйлдлийг оруулах өгөгдмөл тохиргоог хийнэ.';
$string['configgeneralanonymize'] = 'Идэвхжүүлсэн тохиолдолд өгөгдмөл тохиргоогоор хэрэглэгчдэд хамаарах бүх мэдээллийг танигдахгүй болгоно.';
$string['configgeneralbadges'] = 'Нөөцлөлтөд ялгах тэмдэг оруулах өгөгдмөл тохиргоог хийнэ.';
$string['configgeneralblocks'] = 'Нөөцлөлтөд блок оруулах өгөгдмөл тохиргоог хийнэ.';
$string['configgeneralcalendarevents'] = 'Нөөцлөлтөд хуанлийн арга хэмжээг оруулах өгөгдмөл тохиргоог хийнэ.';
$string['configgeneralcomments'] = 'Нөөцлөлтөд тайлбар оруулах өгөгдмөл тохиргоог хийнэ.';
$string['configgeneralcompetencies'] = 'Нөөцлөлтөд чадварыг оруулах өгөгдмөл тохиргоог хийнэ.';
$string['configgeneralcontentbankcontent'] = 'Нөөцлөлтөд агуулгын сангийн товч агуулгыг оруулах өгөгдмөл тохиргоог хийнэ.';
$string['configgeneralfiles'] = 'Нөөцлөлтөд оруулах файлын өгөгдмөл тохиргоог хийнэ. Анхаарах зүйл: Уг тохиргоог идэвхгүй болговол зөвхөн файлын лавлагаа бүхий нөөц үүсэх болно. Нөөцлөлтийг нэг сайт дээр сэргээж, файлыг \'Clean up trash pool files\' (filescleanupperiod) тохиргооны дагуу устгаагүй тохиолдолд энэ нь асуудал биш болно.';
$string['configgeneralfilters'] = 'Нөөцлөлтөд шүүлтүүр оруулах өгөгдмөл тохиргоог хийнэ.';
$string['configgeneralgroups'] = 'Нөөцлөлтөд бүлэг, дэд бүлэг оруулах өгөгдмөл тохиргоог хийнэ.';
$string['configgeneralhistories'] = 'Нөөцлөлтөд хэрэглэгчийн түүхийг оруулах өгөгдмөл тохиргоог хийнэ.';
$string['configgenerallogs'] = 'Идэвхжүүлсэн тохиолдолд нөөцлөлтөд лог бүртгэлийг өгөгдмөл тохиргоогоор оруулна.';
$string['configgeneralpermissions'] = 'Идэвхжүүлсэн тохиолдолд эрхийн зөвшөөрлийг импортлох болно. Энэ нь бүртгэлтэй хэрэглэгчдийн хүчин төгөлдөр зөвшөөрлийг хүчингүй болгож болзошгүй.';
$string['configgeneralquestionbank'] = 'Идэвхжүүлсэн тохиолдолд нөөцлөлтөд асуултын санг өгөгдмөл тохиргоогоор оруулна. АНХААРАХ ЗҮЙЛ: Уг тохиргоог идэвхгүй болговол асуулт-хариулт зэрэг асуултын санг ашигладаг үйлдлийн нөөцлөлт хийгдэхгүй.';
$string['configgeneralroleassignments'] = 'Идэвхжүүлсэн тохиолдолд нөөцлөлтөд лог бүртгэлийг өгөгдмөл тохиргоогоор оруулна.';
$string['configgeneralusers'] = 'Нөөцлөлтөд хэрэглэгчдийг оруулах эсэх өгөгдмөл тохиргоог хийнэ.';
$string['configgeneraluserscompletion'] = 'Идэвхжүүлсэн тохиолдолд нөөцлөлтөд хэрэглэгчийн гүйцэтгэлийн мэдээллийг өгөгдмөл тохиргоогоор оруулна.';
$string['configgeneralxapistate'] = 'Нөөцлөлтийн H5P үйл ажиллагаа зэрэг агуулгад хэрэглэгчийн төлөвийг оруулах үндсэн тохиргоог хийнэ.';
$string['configlegacyfiles'] = 'Нөөцлөлтөд хуучин хичээлийн файлыг оруулах өгөгдмөл тохиргоог хийнэ. Хуучин хичээлийн файлууд нь Moodle 2.0 хувилбарын өмнөх хувилбаруудын файл болно.';
$string['configloglifetime'] = 'Энэ нь нөөцлөлтийн лог бүртгэлийн мэдээллийг хадгалах хугацааг зааж өгнө. Заасан хугацаанаас цааших лог бүртгэлийг автоматаар устгана. Нөөцлөлтийн лог бүртгэлийн мэдээлэл асар их байж болох тул уг утгыг багаар тодорхойлохыг зөвлөж байна.';
$string['configrestoreactivities'] = 'Сэргээх үйлдлийн өгөгдмөл тохиргоог хийнэ.';
$string['configrestorebadges'] = 'Сэргээх ялгах тэмдгийн өгөгдмөл тохиргоог хийнэ.';
$string['configrestoreblocks'] = 'Сэргээх блокийн өгөгдмөл тохиргоог хийнэ.';
$string['configrestorecalendarevents'] = 'Сэргээх хуанлийн арга хэмжээний өгөгдмөл тохиргоог хийнэ.';
$string['configrestorecomments'] = 'Сэргээх тайлбарын өгөгдмөл тохиргоог хийнэ.';
$string['configrestorecompetencies'] = 'Сэргээх чадварын өгөгдмөл тохиргоог хийнэ.';
$string['configrestorecontentbankcontent'] = 'Сэргээх агуулгын сангийн товч агуулгын өгөгдмөл тохиргоог хийнэ.';
$string['configrestoreenrolments'] = 'Сэргээх бүртгэлийн аргын өгөгдмөл тохиргоог хийнэ.';
$string['configrestorefilters'] = 'Сэргээх шүүлтүүрийн өгөгдмөл тохиргоог хийнэ.';
$string['configrestoregroups'] = 'Нөөцлөлтөд орсон бүлэг, дэд бүлгийг сэргээх өгөгдмөл тохиргоог хийнэ.';
$string['configrestorehistories'] = 'Нөөцлөлтөд орсон хэрэглэгчийн түүхийг сэргээх өгөгдмөл тохиргоог хийнэ.';
$string['configrestorelogs'] = 'Идэвхжүүлсэн тохиолдолд нөөцлөлтөд орсон лог бүртгэлийг өгөгдмөл тохиргоогоор сэргээнэ.';
$string['configrestorepermissions'] = 'Идэвхжүүлсэн тохиолдолд эрхийн зөвшөөрлийг сэргээнэ. Энэ нь бүртгэлтэй хэрэглэгчдийн хүчин төгөлдөр зөвшөөрлийг өөрчилж болзошгүй.';
$string['configrestoreroleassignments'] = 'Идэвхжүүлсэн тохиолдолд нөөцлөлтөд орсон эрх хуваарилалтыг өгөгдмөл тохиргоогоор сэргээнэ.';
$string['configrestoreusers'] = 'Нөөцлөлтөд орсон хэрэглэгчдийг сэргээх эсэх өгөгдмөл тохиргоог хийнэ.';
$string['configrestoreuserscompletion'] = 'Идэвхжүүлсэн тохиолдолд нөөцлөлтөд орсон хэрэглэгчийн гүйцэтгэлийн мэдээллийг өгөгдмөл тохиргоогоор сэргээнэ.';
$string['configrestorexapistate'] = 'H5P үйл ажиллагаа зэрэг агуулгад хэрэглэгчийн төлөвийг оруулах үндсэн тохиргоог хийнэ.';
$string['confirmcancel'] = 'Нөөцлөлтийг цуцлах';
$string['confirmcancelimport'] = 'Импортыг цуцлах';
$string['confirmcancelno'] = 'Цуцалж болохгүй';
$string['confirmcancelquestion'] = 'Та цуцлахыг хүсэж байна уу?
Таны оруулсан дурын мэдээлэл устах болно.';
$string['confirmcancelrestore'] = 'Сэргээлтийг цуцлах';
$string['confirmcancelyes'] = 'Нөөцлөлтийг цуцлах';
$string['confirmnewcoursecontinue'] = 'Шинэ хичээлийн анхааруулга';
$string['confirmnewcoursecontinuequestion'] = 'Хичээлийг сэргээх үйлдлээр түр (нууцлагдсан) хичээл үүснэ. Сэргээлтийг зогсоохын тулд цуцлах дээр дарна. Сэргээх явцад хөтчийг хааж болохгүй.';
$string['copiesinprogress'] = 'Энэ хичээл нь ашиглагдаж буй хуулбартай байна. <a href="{$a}">Ашиглаж буй хуулбарыг харах.</a>';
$string['copycoursedesc'] = 'Энэ хичээлийг сонгосон хичээлийн ангилалд хуулбарлан оруулна.';
$string['copycoursetitle'] = 'Хуулах хичээл: {$a}';
$string['copydest'] = 'Хуулах байршил';
$string['copyfieldnotfound'] = 'Шаардлагатай талбарын өгөгдөл олдоогүй талбарууд: {$a}';
$string['copyformfail'] = 'Хичээлийн хуулбарын маягтын AJAX мэдүүлэг амжилтгүй боллоо.';
$string['copyingcourse'] = 'Хичээлийг хуулж байна';
$string['copyingcourseshortname'] = 'хуулж байна';
$string['copyop'] = 'Хийгдэж байгаа үйлдэл';
$string['copyprogressheading'] = 'Хичээлийн хуулбарууд хийгдэж байна';
$string['copyprogressheading_help'] = 'Энэ хүснэгтэд таны дуусаагүй хичээлийн бүх хуулбарын төлөвийг харуулав.';
$string['copyprogresstitle'] = 'Хичээлийн хуулбарын явц';
$string['copyreturn'] = 'Хуулаад буцах';
$string['copysource'] = 'Эх үүсвэр';
$string['copyview'] = 'Хуулаад харах';
$string['coursecategory'] = 'Хичээлийн ангиллыг сэргээнэ';
$string['courseid'] = 'Анхдагч ID';
$string['coursesettings'] = 'Хичээлийн тохиргоо';
$string['coursetitle'] = 'Гарчиг';
$string['currentstage1'] = 'Анхны тохиргоо';
$string['currentstage16'] = 'Дуусгах';
$string['currentstage2'] = 'Бүдүүвчийн тохиргоо';
$string['currentstage4'] = 'Баталгаажилт ба хяналт';
$string['currentstage8'] = 'Нөөцлөлтийг хийх';
$string['enableasyncbackup'] = 'Асинхрон нөөцлөлтийг идэвхжүүлэх';
$string['enableasyncbackup_help'] = 'Идэвхжүүлсэн тохиолдолд нөөцлөх, сэргээх бүх үйлдэл асинхрон байдлаар хийгдэнэ. Энэ нь импорт, экспортод нөлөөлөхгүй. Асинхрон нөөцлөлт, сэргээлт нь нөөцлөлт эсвэл сэргээлт хийгдэж байх үед хэрэглэгчдэд бусад үйлдлийг хийх боломжийг олгодог.';
$string['enterasearch'] = 'Хайлтыг оруулах';
$string['error_block_for_module_not_found'] = '(id: {$a->mid}) хичээлийн модульд (id: {$a->bid}) хамааралгүй блок олдлоо. Уг блокийг нөөцлөхгүй';
$string['error_course_module_not_found'] = '(id: {$a}) хамааралгүй хичээлийн модуль олдлоо. Уг модулийг нөөцлөхгүй';
$string['errorcopyingbackupfile'] = 'Сэргээхээс өмнө нөөц файлыг түр хавтсанд хуулж чадсангүй.';
$string['errorfilenamemustbezip'] = 'Таны оруулсан файлын нэр нь .mbz өргөтгөлтэй ZIP файл байх ёстой';
$string['errorfilenamerequired'] = 'Та уг нөөцлөлтийн файлын зөв нэрийг оруулах ёстой';
$string['errorfilenametoolong'] = 'Файлын нэр нь 255 тэмдэгтээс бага урттай байх ёстой.';
$string['errorinvalidformat'] = 'Нөөцлөлтийн формат танигдахгүй байна';
$string['errorinvalidformatinfo'] = 'Сонгосон файл нь хүчинтэй Moodle нөөц файл биш, сэргээх боломжгүй.';
$string['errorminbackup20version'] = 'Энэ нөөц файл нь Moodle ({$a->backup}) нөөцлөлтийн хөгжүүлэлтийн нэг хувилбараар үүсгэгдсэн. Шаардлагатай доод хэмжээ нь {$a->min}. Сэргээх боломжгүй.';
$string['errorrestorefrontpagebackup'] = 'Та зөвхөн нүүр хуудас дээрх сайтын нөөцлөлтийг сэргээх боломжтой';
$string['executionsuccess'] = 'Нөөц файлыг амжилттай үүсгэлээ.';
$string['extractingbackupfileto'] = 'Нөөц файлыг {$a} руу задалж байна';
$string['failed'] = 'Нөөцлөлт амжилтгүй боллоо';
$string['filealiasesrestorefailures'] = 'Хуулбарыг сэргээх алдаа';
$string['filealiasesrestorefailures_help'] = 'Алиас нь гадаад өгөгдлийн агуулахад хадгалагдсан файлыг оролцуулан бусад файлд хандах тэмдэгт холбоос юм. Зарим тохиолдолд Moodle тэдгээрийг сэргээж чаддаггүй. Жишээ нь, бусад сайт дээрх нөөцлөлтийг сэргээх, лавлагаа файл байхгүй үед.

Сэргээлтийн лог бүртгэлийн файлаас илүү дэлгэрэнгүй мэдээлэл болон алдааны бодит шалтгааныг харах боломжтой.';
$string['filealiasesrestorefailures_link'] = 'restore/filealiases';
$string['filealiasesrestorefailuresinfo'] = 'Нөөц файлд орсон зарим алиасыг сэргээх боломжгүй. Дараах жагсаалт нь тэдгээрийг хадгалахаар заасан байршил болон эх сайтыг заасан эх файлыг агуулсан болно.';
$string['filename'] = 'Файлын нэр';
$string['filereferencesincluded'] = 'Нөөц файлд гадаад агуулгын файлын лавлагаа оруулдаг. Энэ нь нөөцлөлтийг өөр сайт дээр сэргээх тохиолдолд ажиллахгүй.';
$string['filereferencesnotsamesite'] = 'Өөр сайтын нөөц файл тул файлын лавлагааг сэргээх боломжгүй.';
$string['filereferencessamesite'] = 'Энэ сайтын нөөц файл тул файлын лавлагааг сэргээх боломжтой.';
$string['generalactivities'] = 'Үйлдэл ба нөөцийг оруулах';
$string['generalanonymize'] = 'Мэдээллийг нууцлах';
$string['generalbackdefaults'] = 'Ерөнхий нөөцлөлтийн өгөгдмөл утга';
$string['generalbadges'] = 'Ялгах тэмдгийг оруулах';
$string['generalblocks'] = 'Блокийг оруулах';
$string['generalcalendarevents'] = 'Хуанлийн арга хэмжээг оруулах';
$string['generalcomments'] = 'Тайлбар оруулах';
$string['generalcompetencies'] = 'Чадвар оруулах';
$string['generalcontentbankcontent'] = 'Агуулгын сангийн товч агуулгыг оруулах';
$string['generalenrolments'] = 'Бүртгэлийн аргыг оруулах';
$string['generalfiles'] = 'Файлыг оруулах';
$string['generalfilters'] = 'Шүүлтүүрийг оруулах';
$string['generalgradehistories'] = 'Түүхийг оруулах';
$string['generalgroups'] = 'Бүлэг ба дэд бүлгийг оруулах';
$string['generalhistories'] = 'Түүхийг оруулах';
$string['generallegacyfiles'] = 'Хичээлийн хуучин файлыг оруулах';
$string['generallogs'] = 'Лог бүртгэлийг оруулах';
$string['generalpermissions'] = 'Өөрчлөх зөвшөөрлийг оруулах';
$string['generalquestionbank'] = 'Асуултын санг оруулах';
$string['generalrestoredefaults'] = 'Сэргээлтийн ерөнхий өгөгдмөл утга';
$string['generalrestoresettings'] = 'Сэргээлтийн ерөнхий тохиргоо';
$string['generalroleassignments'] = 'Эрх хуваарилалтыг оруулах';
$string['generalsettings'] = 'Нөөцлөлтийн ерөнхий тохиргоо';
$string['generalusers'] = 'Хэрэглэгчийг оруулах';
$string['generaluserscompletion'] = 'Хэрэглэгчийн гүйцэтгэлийн мэдээллийг оруулах';
$string['generalxapistate'] = 'H5P үйл ажиллагаа зэрэг агуулгад хэрэглэгчийн төлөвийг оруулах';
$string['hidetypes'] = 'Сонголтын төрлийг нуух';
$string['importbackupstage16action'] = 'Үргэлжлүүлэх';
$string['importbackupstage1action'] = 'Дараагийнх нь';
$string['importbackupstage2action'] = 'Дараагийнх нь';
$string['importbackupstage4action'] = 'Импорт хийх';
$string['importbackupstage8action'] = 'Үргэлжлүүлэх';
$string['importcurrentstage0'] = 'Хичээл сонголт';
$string['importcurrentstage1'] = 'Анхны тохиргоо';
$string['importcurrentstage16'] = 'Дуусгах';
$string['importcurrentstage2'] = 'Бүдүүвчийн тохиргоо';
$string['importcurrentstage4'] = 'Баталгаажилт ба хяналт';
$string['importcurrentstage8'] = 'Импорт хийх';
$string['importfile'] = 'Нөөц файлыг импортлох';
$string['importgeneralduplicateadminallowed'] = 'Админд маргаан шийдвэрлэхийг зөвшөөрөх';
$string['importgeneralduplicateadminallowed_desc'] = 'Сайт нь  \'admin\' username бүртгэлтэй тохиолдолд \'admin\' username бүртгэл бүхий нөөц файлыг сэргээх оролдлого нь зөрчил үүсгэж болзошгүй. Уг тохиргоог идэвхжүүлсэн тохиолдолд нөөц файл дахь username нэрийг \'admin_xyz\' болгон өөрчилж зөрчлийг шийдвэрлэнэ.';
$string['importgeneralmaxresults'] = 'Импортлох жагсаалтад орсон хичээлийн хамгийн их тоо';
$string['importgeneralmaxresults_desc'] = 'Энэ нь импортлох үйл явцын эхний шатанд жагсаагдсан хичээлийн тоог хянадаг';
$string['importgeneralsettings'] = 'Импортын ерөнхий өгөгдмөл тохиргоо';
$string['importrootsettings'] = 'Импортлох тохиргоо';
$string['importsettings'] = 'Импортлох ерөнхий тохиргоо';
$string['importsuccess'] = 'Импортолж дууслаа. Хичээлд буцахын тулд үргэлжлүүлэх дээр дарна уу.';
$string['includeactivities'] = 'Оруулах:';
$string['includeditems'] = 'Оруулсан зүйлс:';
$string['includefilereferences'] = 'Гадаад агуулгын файлын лавлагаа';
$string['includesection'] = '{$a} бүлэг';
$string['includeuserinfo'] = 'Хэрэглэгчийн өгөгдөл';
$string['inprogress'] = 'Нөөцлөлт хийгдэж байна';
$string['jumptofinalstep'] = 'Сүүлийн алхамд шилжих';
$string['keep'] = 'Хадгалах';
$string['keptroles'] = 'Бүртгэлийн эрхийг оруулах';
$string['keptroles_help'] = 'Сонгосон эрх бүхий хэрэглэгч шинэ хичээл хамрагдана. \'Include user data\' идэвхжээгүй тохиолдолд хэрэглэгчийн өгөгдөл хуулагдахгүй.';
$string['locked'] = 'Түгжигдсэн';
$string['lockedbyconfig'] = 'Энэ тохиргоог нөөцлөлтийн өгөгдмөл тохиргоогоор түгжсэн байна';
$string['lockedbyhierarchy'] = 'Хамааралтайгаар түгжигдсэн';
$string['lockedbypermission'] = 'Танд энэ тохиргоог өөрчлөх хангалттай зөвшөөрөл байхгүй байна';
$string['loglifetime'] = 'Лог бүртгэлийг хадгалах';
$string['managefiles'] = 'Нөөц файлыг удирдах';
$string['mergerestoredefaults'] = 'Өөр хичээлтэй нэгтгэх үед өгөгдмөл тохиргоог сэргээх';
$string['missingfilesinpool'] = 'Зарим файл нь нөөцлөх явцад хадгалагдахгүй тул тэдгээрийг сэргээх боломжгүй болно.';
$string['module'] = 'Модуль';
$string['moodleversion'] = 'Moodle хувилбар';
$string['morecoursesearchresults'] = '{$a} илүү хичээл олдлоо. Эхний {$a} илэрцийг харуулав';
$string['moreresults'] = 'Хэт олон илэрц байна, илүү тодорхой хайлт оруулна уу.';
$string['nomatchingcourses'] = 'Харуулах хичээл байхгүй';
$string['norestoreoptions'] = 'Сэргээх боломжтой ангилал эсвэл хичээл байхгүй байна.';
$string['originalwwwroot'] = 'Нөөцлөлтийн URL хаяг';
$string['overwrite'] = 'Дарж бичих';
$string['pendingasyncdeletedetail'] = 'Энэ хичээл нь хүлээгдэж байгаа асинхрон нөөцлөлттэй байна. <br/> Хичээлийг уг нөөцлөлтийг дуусах хүртэл устгах боломжгүй.';
$string['pendingasyncdetail'] = 'Асинхрон нөөцлөлт нь нөөцөд зөвхөн нэг хүлээгдэж байгаа нөөцлөлттэй байхыг хэрэглэгчид зөвшөөрдөг. <br/> Ижил нөөцийн хэд хэдэн асинхрон нөөцлөлтийг дараалалд оруулах боломжгүй, учир нь энэ нь ижил агуулга бүхий хэд хэдэн нөөцлөлт үүсгэх магадлалтай.';
$string['pendingasyncedit'] = 'Энэ хичээлд хүлээгдэж буй нөөцлөлт эсвэл хуулбар байна. Үүнийг дуусах хүртэл хичээлийг засаж болохгүй.';
$string['pendingasyncerror'] = 'Энэ нөөцийн нөөцлөлт хүлээгдэж байна';
$string['preparingdata'] = 'Өгөгдлийн бэлтгэж байна';
$string['preparingui'] = 'Хуудсыг харуулахаар бэлтгэж байна';
$string['previousstage'] = 'Өмнөх';
$string['privacy:metadata:backup:detailsofarchive'] = 'Энэ архив нь үнэлгээ, хэрэглэгчийн бүртгэл, үйл ажиллагааны өгөгдөл зэрэг хичээлтэй холбоотой хэрэглэгчийн төрөл бүрийн өгөгдлийг агуулж болно.';
$string['privacy:metadata:backup:externalpurpose'] = 'Уг архив нь цаашид сэргээх боломжтой тухайн хичээлтэй холбоотой мэдээллийг хадгалах зорилготой.';
$string['privacy:metadata:backup_controllers'] = 'Нөөцлөх үйлдлийн жагсаалт';
$string['privacy:metadata:backup_controllers:itemid'] = 'Хичээлийн ID';
$string['privacy:metadata:backup_controllers:operation'] = 'Хийгдсэн үйлдэл, сэргээх гэх мэт.';
$string['privacy:metadata:backup_controllers:timecreated'] = 'Үйлдлийг эхлүүлсэн хугацаа';
$string['privacy:metadata:backup_controllers:timemodified'] = 'Үйлдлийг өөрчилсөн хугацаа';
$string['privacy:metadata:backup_controllers:type'] = 'Хийгдэж буй зүйлийн төрөл, үйл ажиллагаа гэх мэт.';
$string['qcategory2coursefallback'] = 'Нөөц файл дахь систем/хичээлийн ангиллын агуулгад буй "{$a->name}" асуултын ангиллыг сэргээх замаар хичээлийн агуулгыг үүсгэнэ.';
$string['qcategorycannotberestored'] = '"{$a->name}" асуултын ангиллыг сэргээх замаар үүсгэх боломжгүй';
$string['question2coursefallback'] = 'Нөөц файл дахь систем/хичээлийн ангиллын агуулгад буй "{$a->name}" асуултын ангиллыг сэргээх замаар хичээлийн агуулгыг үүсгэнэ.';
$string['questioncannotberestored'] = '"{$a->name}" асуултыг сэргээх замаар үүсгэх боломжгүй';
$string['recyclebin_desc'] = 'Эдгээр тохиргоог мөн хогийн саванд ашиглаж болохыг анхаарна уу.';
$string['replacerestoredefaults'] = 'Өөр хичээлийн устгасан агуулгыг сэргээх үед өгөгдмөл тохиргоог сэргээх';
$string['restoreactivity'] = 'Үйлдлийг сэргээх';
$string['restorecourse'] = 'Хичээлийг сэргээх';
$string['restorecoursesettings'] = 'Хичээлийн тохиргоо';
$string['restoredcourseid'] = 'Сэргээсэн хичээлийн ID: {$a}';
$string['restoreexecutionsuccess'] = 'Хичээлийг амжилттай сэргээсэн.';
$string['restorefileweremissing'] = 'Нөөцлөлтөд байхгүй тул зарим файлыг сэргээх боломжгүй.';
$string['restorenewcoursefullname'] = 'Хичээлийн шинэ нэр';
$string['restorenewcourseshortname'] = 'Хичээлийн шинэ товч нэр';
$string['restorenewcoursestartdate'] = 'Эхлэх шинэ хугацаа';
$string['restorerolemappings'] = 'Эрхийн тулган харьцуулалтыг сэргээх';
$string['restorerootsettings'] = 'Тохиргоог сэргээх';
$string['restoresection'] = 'Бүлгийг сэргээх';
$string['restorestage1'] = 'Баталгаажуулах';
$string['restorestage16'] = 'Хянах';
$string['restorestage16action'] = 'Сэргээлтийг гүйцэтгэх';
$string['restorestage1action'] = 'Дараагийнх нь';
$string['restorestage2'] = 'Нөөцлөх газар';
$string['restorestage2action'] = 'Дараагийнх нь';
$string['restorestage32'] = 'Процесс';
$string['restorestage32action'] = 'Үргэлжлүүлэх';
$string['restorestage4'] = 'Тохиргоо';
$string['restorestage4action'] = 'Дараагийнх нь';
$string['restorestage64'] = 'Дуусгах';
$string['restorestage64action'] = 'Үргэлжлүүлэх';
$string['restorestage8'] = 'Бүдүүвч';
$string['restorestage8action'] = 'Дараагийнх нь';
$string['restoretarget'] = 'Товлосноо сэргээх';
$string['restoretocourse'] = 'Хичээл рүү сэргээх:';
$string['restoretocurrentcourse'] = 'Энэ хичээлд сэргээх';
$string['restoretocurrentcourseadding'] = 'Энэ хичээлд нөөц хичээлийг нэгтгэх';
$string['restoretocurrentcoursedeleting'] = 'Энэ хичээлийн агуулгыг устгаж, сэргээх';
$string['restoretoexistingcourse'] = 'Одоо байгаа хичээлд сэргээх';
$string['restoretoexistingcourseadding'] = 'Одоо байгаа хичээлд нөөц хичээлийг нэгтгэх';
$string['restoretoexistingcoursedeleting'] = 'Одоо байгаа хичээлийн агуулгыг устгаж, сэргээх';
$string['restoretonewcourse'] = 'Шинэ хичээл байдлаар сэргээх';
$string['restoringcourse'] = 'Хичээлийг сэргээж байна';
$string['restoringcourseshortname'] = 'сэргээх';
$string['rootenrolmanual'] = 'Гар бүртгэлээр сэргээх';
$string['rootsettingactivities'] = 'Үйлдэл ба нөөцийг оруулах';
$string['rootsettinganonymize'] = 'Хэрэглэгчийн мэдээллийг нууцлах';
$string['rootsettingbadges'] = 'Ялгах тэмдгийг оруулах';
$string['rootsettingblocks'] = 'Блокийг оруулах';
$string['rootsettingcalendarevents'] = 'Хуанцлийн арга хэмжээг оруулах';
$string['rootsettingcomments'] = 'Тайлбар оруулах';
$string['rootsettingcompetencies'] = 'Чадвар оруулах';
$string['rootsettingcontentbankcontent'] = 'Агуулгын сангийн товч агуулгыг оруулах';
$string['rootsettingcustomfield'] = 'Тусгай талбар оруулах';
$string['rootsettingenrolments'] = 'Бүртгэлийн арга оруулах';
$string['rootsettingenrolments_always'] = 'Тийм, үргэлж';
$string['rootsettingenrolments_never'] = 'Үгүй, хэрэглэгчийг гараар бүртгэснээр сэргээх';
$string['rootsettingenrolments_withusers'] = 'Тийм, гэвч зөвхөн хэрэглэгчийг оруулсан тохиолдолд';
$string['rootsettingfiles'] = 'Файлыг оруулах';
$string['rootsettingfilters'] = 'Шүүлтүүрийг оруулах';
$string['rootsettinggradehistories'] = 'Үнэлгээний түүхийг оруулах';
$string['rootsettinggroups'] = 'Бүлэг ба дэд бүлгийг оруулах';
$string['rootsettingimscc1'] = 'IMS Common Cartridge 1.0 рүү хөрвүүлэх';
$string['rootsettingimscc11'] = 'IMS Common Cartridge 1.1 рүү хөрвүүлэх';
$string['rootsettinglegacyfiles'] = 'Хичээлийн хуучин файлыг оруулах';
$string['rootsettinglogs'] = 'Хичээлийн лог бүртгэлийг оруулах';
$string['rootsettingpermissions'] = 'Хүчингүй болгох зөвшөөрлийг оруулах';
$string['rootsettingquestionbank'] = 'Асуултын санг оруулах';
$string['rootsettingroleassignments'] = 'Хэрэглэгчийн эрх хуваарилалтыг оруулах';
$string['rootsettings'] = 'Нөөцлөлтийн тохиргоо';
$string['rootsettingusers'] = 'Бүртгэгдсэн хэрэглэгчийг оруулах';
$string['rootsettinguserscompletion'] = 'Хэрэглэгчийн гүйцэтгэлийн дэлгэрэнгүйг оруулах';
$string['rootsettingxapistate'] = 'H5P үйл ажиллагаа зэрэг агуулгад хэрэглэгчийн төлөвийг оруулах';
$string['samesitenotification'] = 'Энэ нөөцлөлтийг файлаар нь бус зөвхөн түүний лавлагаагаар үүсгэсэн болно. Зөвхөн энэ сайт дээр сэргээлт хийгдэнэ.';
$string['sectionactivities'] = 'Үйлдлүүд';
$string['sectioninc'] = 'Нөөцлөлтөд оруулсан (хэрэглэгчийн мэдээлэл байхгүй)';
$string['sectionincanduser'] = 'Нөөцлөлтөд хэрэглэгчийн мэдээллийн хамтаар оруулсан';
$string['selectacategory'] = 'Ангилал сонгох';
$string['selectacourse'] = 'Хичээл сонгох';
$string['setting_course_fullname'] = 'Хичээлийн нэр';
$string['setting_course_shortname'] = 'Хичээлийн товч нэр';
$string['setting_course_startdate'] = 'Хичээл эхлэх огноо';
$string['setting_keep_groups_and_groupings'] = 'Одоогийн бүлэг ба дэд бүлгийг хадгалах';
$string['setting_keep_roles_and_enrolments'] = 'Одоогийн эрх ба бүртгэлийг хадгалах';
$string['setting_overwrite_conf'] = 'Хичээлийн тохиргоог дахин хийх';
$string['setting_overwrite_course_fullname'] = 'Хичээлийн бүтэн нэрийг дахин бичих';
$string['setting_overwrite_course_shortname'] = 'Хичээлийн товч нэрийг дахин бичих';
$string['setting_overwrite_course_startdate'] = 'Хичээлийн эхлэх огноог дахин тохируулах';
$string['showtypes'] = 'Тохиргооны төрлийг харуулах';
$string['sitecourseformatwarning'] = 'Энэ нь сайтын нүүр хуудасны нөөц болно. Үүнийг зөвхөн сайтын нүүр хуудас дээр сэргээх боломжтой.';
$string['skiphidden'] = 'Нуугдмал хичээлийг алгасах';
$string['skiphiddenhelp'] = 'Нуугдмал хичээлийг алгасах эсэхийг сонгох';
$string['skipmodifdays'] = 'Өөрчлөгдөөгүй хичээлийг алгасах';
$string['skipmodifdayshelp'] = 'Тодорхойлсон хоногоос хойш өөрчлөгдөөгүй хичээлийг алгасах сонголт хийх';
$string['skipmodifprev'] = 'Өмнөх нөөцлөлтөөс хойш өөрчлөгдөөгүй хичээлийг алгасах';
$string['skipmodifprevhelp'] = 'Сүүлийн автомат нөөцлөлтөөс хойш өөрчлөгдөөгүй хичээлийг алгасах эсэхийг сонгох. Энэ нь лог бүртгэлийг идэвхжүүлэхийг шаарддаг.';
$string['status'] = 'Төлөв';
$string['storagecourseandexternal'] = 'Хичээлийн нөөц файл талбар болон заасан лавлах';
$string['storagecourseonly'] = 'Хичээлийн нөөц файл талбар';
$string['storageexternalonly'] = 'Автомат нөөцлөлтийн заасан лавлах';
$string['successful'] = 'Амжилттай нөөцөллөө';
$string['successfulcopy'] = 'Амжилттай хууллаа';
$string['successfulrestore'] = 'Амжилттай сэргээлээ';
$string['timetaken'] = 'Авсан цаг';
$string['title'] = 'Гарчиг';
$string['totalcategorysearchresults'] = 'Нийт ангилал: {$a}';
$string['totalcoursesearchresults'] = 'Нийт хичээл: {$a}';
$string['undefinedrolemapping'] = '\'{$a}\' загварын эрхийн тохируулгыг тодорхойлоогүй.';
$string['unnamedsection'] = 'Нэрлэгдээгүй бүлэг';
$string['userdata'] = 'Хэрэглэгчийн өгөгдлийг оруулах';
$string['userdata_help'] = 'Идэвхжүүлсэн тохиолдолд форумын нийтлэл, илгээсэн даалгавар зэрэг өгөгдлийг  \'Include role enrolments\' хэсэгт хэсэгт сонгосон эрх бүхий дурын хэрэглэгчид зориулсан шинэ хичээлд хуулах болно.';
$string['userinfo'] = 'Userinfo';
