<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'lt', version '5.1'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Galite peržiūrėti šį testą, bet jei tai būtų tikras bandymas, būtumėte užblokuoti, nes:';
$string['action'] = 'Veiksmas';
$string['activityoverview'] = 'Jūs turite neatliktų testų';
$string['adaptive'] = 'Adaptyvusis režimas';
$string['adaptive_help'] = 'Jei įjungta, per tą patį testo bandymą leidžiami keli atsakymai į klausimą. Taigi, pavyzdžiui, jei atsakymas pažymimas kaip klaidingas, besimokančiajam bus leidžiama nedelsiant bandyti iš naujo. Tačiau atsižvelgiant į parametrą Taikyti baudas, už kiekvieną klaidingą bandymą bus taikoma bauda.';
$string['add'] = 'Įtraukti';
$string['addaquestion'] = 'naują klausimą';
$string['addarandomquestion'] = 'atsitiktinį klausimą';
$string['addarandomquestion_help'] = 'Kai įtraukiamas atsitiktinis klausimas, jam atsitiktiniu būdu parenkamas atsakymas iš kategorijos, įterpiamos į testą. Tai reiškia, kad skirtingiems besimokantiesiems greičiausiai bus pateikiami skirtingi klausimai, o kai teste leidžiami keli bandymai, kiekviename bandyme gali būti naujų klausimų.';
$string['addarandomquestion_success'] = 'Atsitiktiniai klausimai buvo pridėti';
$string['addarandomselectedquestion'] = 'Pridėti atsitiktinai parinktą klausimą ...';
$string['addasection'] = 'naują dalies antraštę';
$string['adddescriptionlabel'] = 'Įtraukti aprašą';
$string['addingquestion'] = 'Įtraukiamas klausimas';
$string['addingquestions'] = 'Šioje puslapio dalyje valdote savo klausimų duomenų bazę. Klausimai saugomi kategorijomis, padedančiomis juos tvarkyti, ir gali būti naudojami jūsų kurso teste ar net kituose kursuose, jei pasirinksite juos publikuoti. <br /><br />Pasirinkę arba sukūrę klausimų kategoriją galėsite kurti arba redaguoti klausimus. Galite pasirinkti įtraukti bet kurį iš šių klausimų į savo testą kitoje šio puslapio pusėje.';
$string['addmoreoverallfeedbacks'] = 'Įtraukti dar {no} atsiliepimų lauką (-us)';
$string['addnewgroupoverride'] = 'Įtraukti grupės keitimą';
$string['addnewpagesafterselected'] = 'Įtraukti naujų puslapių po pasirinktais klausimais';
$string['addnewquestionsqbank'] = 'Įtraukti klausimų į kategoriją {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Įtraukti naudotojo keitimą';
$string['addpagebreak'] = 'Pridėti puslapio lūžį';
$string['addpagehere'] = 'Čia įtraukti puslapį';
$string['addquestion'] = 'Įtraukti klausimą';
$string['addquestionfrombankatend'] = 'Įtraukti iš klausimų banko pabaigoje';
$string['addquestionfrombanktopage'] = 'Pridėti iš klausimų banko į puslapį {$a}';
$string['addquestions'] = 'Įtraukti klausimų';
$string['addquestionstoquiz'] = 'Įtraukti klausimų į dabartinį testą';
$string['addrandom'] = 'Įtraukti {$a} atsitiktinius (-ių) klausimus (-ų)';
$string['addrandom1'] = '<< Įtraukti';
$string['addrandom2'] = 'atsitiktiniai klausimai';
$string['addrandomfromcategory'] = 'Įtraukti atsitiktinių klausimų iš kategorijos:';
$string['addrandomquestion'] = 'Įtraukti atsitiktinį klausimą';
$string['addrandomquestionatend'] = 'Pridėti atsitiktinį klausimą pabaigoje';
$string['addrandomquestiontopage'] = 'Pridėti atsitiktinai parinktą klausimą į puslapį {$a}';
$string['addrandomquestiontoquiz'] = 'Įtraukti atsitiktinį klausimą į testą {$a}';
$string['addselectedquestionstoquiz'] = 'Įkelti pasirinktus klausimus į testą';
$string['addselectedtoquiz'] = 'Įtraukti pasirinktus į testą';
$string['addtoquiz'] = 'Įtraukti į testą';
$string['affectedstudents'] = 'Paveiktas {$a}';
$string['aftereachquestion'] = 'Įtraukus kiekvieną klausimą';
$string['afternquestions'] = 'Įtraukus {$a} klausimus (-ų)';
$string['age'] = 'amžius';
$string['allattempts'] = 'Visi bandymai';
$string['allinone'] = 'Neribota';
$string['allowreview'] = 'Leisti peržiūrėti';
$string['alreadysubmitted'] = 'Panašu, kad jau pateikėte šį bandymą';
$string['alternativeunits'] = 'Alternatyvieji moduliai';
$string['alwaysavailable'] = 'Visada prieinama';
$string['alwayslatest'] = 'Visada naujausias';
$string['analysisoptions'] = 'Analizės parinktys';
$string['analysistitle'] = 'Elementų analizės lentelė';
$string['answer'] = 'Atsakyti';
$string['answered'] = 'Atsakyta';
$string['answerhowmany'] = 'Vienas arba keli atsakymai?';
$string['answers'] = 'Atsakymai';
$string['answersingleno'] = 'Leidžiami keli atsakymai';
$string['answersingleyes'] = 'Tik vienas atsakymas';
$string['answertoolong'] = 'Atsakymas po eilutės {$a} per ilgas (daugiausia 255 simb.)';
$string['anytags'] = 'Visos žymės';
$string['aon'] = 'AON formatas';
$string['areyousureremoveselected'] = 'Ar tikrai norite naikinti visus pasirinktus klausimus?';
$string['asshownoneditscreen'] = 'Kaip rodoma redagavimo ekrane';
$string['attempt'] = 'Bandymas {$a}';
$string['attemptalreadyclosed'] = 'Šis bandymas jau baigtas.';
$string['attemptclosed'] = 'Bandymas dar neuždarytas';
$string['attemptduration'] = 'Trukmė';
$string['attemptedon'] = 'Bandyta';
$string['attempterror'] = 'Šiuo metu jums neleidžiama bandyti atlikti šio testo, nes: {$a}';
$string['attempterrorcontentchange'] = 'Šio testo peržiūra nebegalima. (Kai redaguojamas testas, bet kurios nebaigtos peržiūros yra automatiškai pašalinamos.)';
$string['attempterrorcontentchangeforuser'] = 'Testo bandymo nebėra.';
$string['attempterrorinvalid'] = 'Klaidingas testo bandymo ID';
$string['attemptfirst'] = 'Pirmasis bandymas';
$string['attemptgradeddelay'] = 'Bandymo įvertinimo pranešimo atidėjimas';
$string['attemptgradeddelay_desc'] = 'Prieš siunčiant pranešimus apie bandymą, taikomas delsimas, kad dėstytojas turėtų laiko redaguoti įvertinimą.';
$string['attemptincomplete'] = 'Bandymas (kurį atlieka {$a}) dar nebaigtas.';
$string['attemptlast'] = 'Paskutinis bandymas';
$string['attemptnumber'] = 'Bandymas';
$string['attemptquiz'] = 'Pradėti';
$string['attemptquiznow'] = 'Pradėti dabar';
$string['attemptreviewtitle'] = '{$a}: Bandymo peržiūra';
$string['attemptreviewtitlepaged'] = '{$a->name}: Bandymo peržiūra (puslapis {$a->currentpage} iš {$a->totalpages})';
$string['attempts'] = 'Bandymai';
$string['attempts_help'] = 'Visų leidžiamų bandymų skaičius (be papildomų bandymų skaičiaus).';
$string['attemptsallowed'] = 'Leidžiama bandymų';
$string['attemptsdeleted'] = 'Testo bandymai panaikinti';
$string['attemptselection'] = 'Pasirinkite, kuriuos kiekvieno naudotojo bandymus analizuoti:';
$string['attemptsexist'] = 'Nebegalite įtraukti arba šalinti klausimų.';
$string['attemptsnum'] = 'Bandymai: {$a}';
$string['attemptsnumthisgroup'] = 'Bandymai: {$a->total} ({$a->group} iš šios grupės)';
$string['attemptsnumyourgroups'] = 'Bandymai: {$a->total} ({$a->group} iš jūsų grupių)';
$string['attemptsonly'] = 'Rodyti tik besimokančiuosius su bandymais';
$string['attemptstate'] = 'Būsena';
$string['attemptstillinprogress'] = 'Vis dar bandoma';
$string['attemptsummarytitle'] = '{$a}: Bandymo santrauka';
$string['attemptsunlimited'] = 'Bandymų skaičius neribotas';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (puslapis {$a->currentpage} iš {$a->totalpages})';
$string['autosaveperiod'] = 'Automatinio išsaugojimo vėlavimas';
$string['autosaveperiod_desc'] = 'Atsakymai gali būti automatiškai išsaugoti testo bandymų metu. Atsakymai išsaugomi kiekvieną kartą, kai jie pakeičiami, o vėliau ir po šio delsos. Yra kompromisas: trumpesnis delsimas padidina serverio apkrovą, bet sumažina tikimybę, kad besimokantieji praras darbą. Jei ketinate šią delsą žymiai sutrumpinti, vertės keitimas turėtų būti palaipsniui ir reikia stebėti serverio apkrovą. Jei apkrova tampa per didelė, vėl pailginkite delsą. Nustačius delsą į 0, automatinis išsaugojimas išjungiamas.';
$string['back'] = 'Grįžti į klausimo peržiūrą';
$string['backtocourse'] = 'Grįžti į kursą';
$string['backtoquestionlist'] = 'Grįžti į klausimų sąrašą';
$string['backtoquiz'] = 'Grįžti į testo redagavimą';
$string['banknotfound'] = 'Klausimų bankas nerastas, prašome ieškoti dar kartą';
$string['bestgrade'] = 'Geriausias įvertinimas';
$string['bothattempts'] = 'Rodyti besimokančiuojus su bandymais ir be jų';
$string['browsersecurity'] = 'Naršyklės sauga';
$string['browsersecurity_help'] = 'Pasirinkus Iššokantysis langas visame ekrane su šiek tiek „JavaScript“ saugos, * testas bus pradėtas tik tuo atveju, jei besimokantysis turi „JavaScript“ palaikančią žiniatinklio naršyklę; * testas bus rodomas viso ekrano iššokančiajame lange, kuris uždengs visus kitus langus ir neturės naršymo valdiklių; * besimokantiesiems draudžiama (kiek įmanoma) naudoti tokias funkcijas, kaip kopijavimas ir įklijavimas.';
$string['cachedef_overrides'] = 'Naudotojo ir grupės keitimo informacija';
$string['calculated'] = 'Apskaičiuota';
$string['calculatedquestion'] = 'Apskaičiavimo klausimas nepalaikomas eilutėje {$a}. Klausimo bus nepaisoma';
$string['cannotcreatepath'] = 'Kelio sukurti negalima ({$a})';
$string['cannoteditafterattempts'] = 'Negalite pridėti ar pašalinti klausimų, nes jau buvo bandoma atlikti šį testą. ({$a})';
$string['cannotfindprevattempt'] = 'Nepavyko rasti ankstesnio bandymo, pagal kurį būtų galima kurti.';
$string['cannotfindquestionregard'] = 'Nepavyko gauti klausimų, kuriuos reikėtų įvertinti iš naujo!';
$string['cannotinsert'] = 'Negalima įterpti klausimo';
$string['cannotinsertrandomquestion'] = 'Nepavyko įterpti naujo atsitiktinio klausimo!';
$string['cannotloadquestion'] = 'Nepavyko įkelti klausimų parinkčių';
$string['cannotloadtypeinfo'] = 'Nepavyksta įkelti „questiontype“ konkretaus klausimo informacijos';
$string['cannotopen'] = 'Nepavyksta atidaryti eksporto failo ({$a})';
$string['cannotremoveallsectionslots'] = 'Skilties „{$a}“ antraštėje pasirinkote visus klausimus. Neleidžiama pašalinti visų klausimų po skyriaus antrašte.';
$string['cannotremoveslots'] = 'Negalima pašalinti klausimų';
$string['cannotrestore'] = 'Nepavyko atkurti klausimų seansų';
$string['cannotreviewopen'] = 'Negalite peržiūrėti šio bandymo, jis vis dar atidarytas.';
$string['cannotsavelayout'] = 'Nepavyko įrašyti maketo';
$string['cannotsavenumberofquestion'] = 'Nepavyko įrašyti kiekvieno puslapio klausimų skaičiaus';
$string['cannotsavequestion'] = 'Nepavyksta įrašyti klausimų sąrašo';
$string['cannotsetgrade'] = 'Nepavyko nustatyti naujo maksimalaus testo įvertinimo';
$string['cannotsetsumgrades'] = 'Nepavyko nustatyti „sumgrades“';
$string['cannotstartgradesmismatch'] = 'Nepavyko paleisti bandymo šiai apklausai. Apklausa bus vertinama, bet nėra nei vieno klausimo apklausoje kurie būtų verti pažymio.';
$string['cannotstartmissingquestion'] = 'Negalima pradėti testo bandymo. Testo aprašyme priskirtas klausimas, kuris neegzistuoja';
$string['cannotstartnoquestions'] = 'Nepavyko pradėti bandymo šiame teste. Testas dar nėra nustatytas. Klausimai nebuvo pridėti.';
$string['cannotwrite'] = 'Nepavyksta rašyti į eksporto failą ({$a})';
$string['canredoquestions'] = 'Leisti keisti per bandymą';
$string['canredoquestions_desc'] = 'Jei įjungta, baigus bandyti atsakyti į klausimą, rodomas mygtukas „Išbandyti kitą klausimą, panašų į šį“. Tai leidžia bandyti atsakyti į panašų klausimą (atsitiktinai pasirinktą) arba pakartoti tą patį klausimą, neatliekant viso testo ir nepradedant kito bandymo. Ši parinktis naudinga atliekant praktikos testus.

Šis parametras turi įtakos tik tiems klausimams ir klausimo veikimui (pvz.,  Tiesioginis grįžtamasis ryšys ar Sąveikaujantis su keliais bandymais), kai klausimą galima užbaigti prieš pateikiant bandymą.';
$string['canredoquestions_help'] = 'Jei įjungta, baigus bandyti atsakyti į klausimą, rodomas mygtukas „Išbandyti kitą klausimą, panašų į šį“. Tai leidžia bandyti atsakyti į panašų klausimą (atsitiktinai pasirinktą) arba pakartoti tą patį klausimą, neatliekant viso testo ir nepradedant kito bandymo. Ši parinktis naudinga atliekant praktikos testus.

Šis parametras turi įtakos tik tiems klausimams ir klausimo veikimui (pvz.,  Tiesioginis grįžtamasis ryšys ar Sąveikaujantis su keliais bandymais), kai klausimą galima užbaigti prieš pateikiant bandymą.';
$string['canredoquestionsyes'] = 'Taip, pasiūlyti galimybę išbandyti kitą klausimą';
$string['caseno'] = 'Ne, raidžių dydis nesvarbus';
$string['casesensitive'] = 'Didžiųjų ir mažųjų raidžių skyrimas';
$string['caseyes'] = 'Taip, raidės turi sutapti';
$string['categoryadded'] = 'Kategorija {$a} buvo įtraukta';
$string['categorydeleted'] = 'Kategorija {$a} buvo panaikinta';
$string['categorynoedit'] = 'Neturite kategorijos {$a} redagavimo teisių.';
$string['categoryupdated'] = 'Kategorija sėkmingai atnaujinta';
$string['close'] = 'Uždaryti langą';
$string['closebeforeopen'] = 'Uždarymo data turi būti vėlesnė nei atidarymo data.';
$string['closed'] = 'Uždaryta';
$string['closepreview'] = 'Uždaryti peržiūrą';
$string['closereview'] = 'Uždaryti peržiūrą';
$string['comment'] = 'Komentaras';
$string['commentorgrade'] = 'Komentuoti arba keisti įvertinimą';
$string['comments'] = 'Komentarai';
$string['completedon'] = 'Baigtas';
$string['completionattemptsexhausted'] = 'Išlaikymo įvertinimas arba atlikti visi galimi bandymai';
$string['completionattemptsexhausted_help'] = 'Pažymėti testo užbaigimą, kai studentas išnaudojo maksimalų bandymų skaičių.';
$string['completiondetail:minattempts'] = 'Atlikti bandymų: {$a}';
$string['completiondetail:passorexhaust'] = 'Gauti išlaikymo įvertinimą arba atlikti visus galimus bandymus.';
$string['completionminattempts'] = 'Mažiausias bandymų skaičius';
$string['completionminattemptsdesc'] = 'Privalomas mažiausias bandymų skaičius: {$a}';
$string['completionminattemptserror'] = 'Minimalus bandymų skaičius turi būti mažesnis arba lygus leidžiamiems bandymams.';
$string['completionpassorattemptsexhausteddesc'] = 'Besimokantysis turi pasiekti teigiamą įvertį arba išnaudoti visus galimus bandymus atlikti šią veiklą';
$string['configadaptive'] = 'Jei pasirinksite šios parinkties reikšmę Taip, besimokančiajam bus leidžiama pasirinkti kelis atsakymus į klausimą net per tą patį bandymą atlikti testą.';
$string['configattemptsallowed'] = 'Besimokančiajam leidžiamų bandymų atlikti testą skaičiaus apribojimas.';
$string['configdecimaldigits'] = 'Skaitmenų skaičius, kuris turėtų būti rodomas po kablelio rodant įvertinimus.';
$string['configdecimalplaces'] = 'Skaitmenų skaičius, kuris turėtų būti rodomas po kablelio rodant testo įvertinimus.';
$string['configdecimalplacesquestion'] = 'Skaitmenų po kablelio skaičius, kuris turėtų būti rodomas, kai rodomi atskirų klausimų balai.';
$string['configdelay1'] = 'Jei nustatysite uždelsimą, besimokantysis turės palaukti prieš bandydamas dar kartą atlikti testą po pirmojo bandymo.';
$string['configdelay1st2nd'] = 'Jei čia nustatysite uždelsimą, besimokantysis negalės pradėti antrojo bandymo, kol po pirmojo bandymo nebus praėjęs nurodytas laikotarpis.';
$string['configdelay2'] = 'Jei čia nustatysite uždelsimą, besimokantysis turės palaukti prieš bandydamas atlikti testą trečią arba dar tolesnį kartą.';
$string['configdelaylater'] = 'Jei čia nustatysite uždelsimą, besimokantysis negalės pradėti trečiojo, ketvirtojo ir t. t. bandymo, kol po ankstesnio bandymo nebus praėjęs nurodytas laikotarpis.';
$string['configeachattemptbuildsonthelast'] = 'Jei leidžiami keli bandymai, kiekviename naujame bandyme bus ankstesnio bandymo rezultatas.';
$string['configgrademethod'] = 'Kai leidžiami keli bandymai, kurį metodą reiktų naudoti besimokančiojo testo galutiniam įvertinimui apskaičiuoti.';
$string['configintro'] = 'Reikšmės, kurias nustatėte čia, apibrėžia numatytąsias reikšmes, parametrų formoje naudojamas kuriant naują testą. Taip pat galite konfigūruoti, kurie testo parametrai laikomi išplėstiniais.';
$string['configmaximumgrade'] = 'Numatytasis įvertinimas, kurio intervale turi būti testo įvertinimas.';
$string['confignavmethod'] = '"Laisvoje navigacijoje", į klausimus gali būti atsakoma bet kuria tvarka naudojantis navigacija. "Iš eilės" pasirinkime, klausimai turi būti atsakyti griežta seka.';
$string['confignewpageevery'] = 'Įtraukiant klausimus į testo puslapį, lūžiai bus automatiškai įterpiami atsižvelgiant į jūsų čia pasirinktą parametrą.';
$string['configoutcomesadvanced'] = 'Jei ši nuostata yra įjungta, tuomet "Rezultatai" testo redagavimo formoje yra su išplėstiniais nustatymais.';
$string['configpenaltyscheme'] = 'Bauda, taikoma už kiekvieną klaidingą atsakymą adaptuotame režime.';
$string['configpopup'] = 'Priverstinai taikyti bandymą atidaryti iššokantįjį langą ir naudoti „JavaScript“ ypatumus norint pabandyti apriboti kopijavimą, įklijavimą ir t. t. bandant atlikti testą.';
$string['configrequirepassword'] = 'Besimokantieji turi įvesti šį slaptažodį prieš bandydami atlikti testą.';
$string['configrequiresubnet'] = 'Besimokantieji gali bandyti atlikti testą tik naudodami šiuos kompiuterius.';
$string['configreviewoptions'] = 'Šios parinktys valdo, kokią informaciją naudotojai mato peržiūrėdami bandymą atlikti testą arba testo ataskaitas.';
$string['configshowblocks'] = 'Rodyti blokus atliekant testą.';
$string['configshowuserpicture'] = 'Bandymų metu ekrane rodyti naudotojo nuotrauką.';
$string['configshufflewithin'] = 'Jei įjungsite šią parinktį, atskirus klausimus sudarančios dalys bus atsitiktine tvarka maišomos kas kartą, kai besimokantysis bandys atlikti testą (jei ši parinktis taip pat įjungta klausimo parametruose).';
$string['configtimelimit'] = 'Numatytoji testų laiko riba minutėmis. 0 reiškia, kad laiko limito nėra.';
$string['configtimelimitsec'] = 'Numatytoji testų laiko riba sekundėmis. 0 reiškia, kad laiko limito nėra.';
$string['configurerandomquestion'] = 'Konfigūruoti klausimą';
$string['confirmclose'] = 'Kai pateiksite atsakymus, jų pakeisti nebegalėsite.';
$string['confirmremovequestion'] = 'Ar tikrai norite pašalinti šį „{$a}“ klausimą?';
$string['confirmremovesectionheading'] = 'Ar tikrai norite pašalinti šią \'{$a}\' dalies antraštę?';
$string['confirmserverdelete'] = 'Ar tikrai norite pašalinti serverį <b>{$a}</b> iš sąrašo?';
$string['connectionerror'] = 'Tinklo ryšys prarastas. (Automatiškai neišsaugota).

Pasižymėkite per paskutines kelias minutes įvestus atsakymus šiame puslapyje, tada bandykite dar kartą prisijungti.

Kai ryšys bus atkurtas, Jūsų atsakymai turi būti išsaugojami ir šis pranešimas pranyks.';
$string['connectionok'] = 'Tinklo ryšys atkurtas. Galite toliau sėkmingai tęsti.';
$string['containercategorycreated'] = 'Ši kategorija sukurta norint išsaugoti visas pradines kategorijas, perkeltas į svetainės lygį dėl toliau nurodytų priežasčių.';
$string['continueattemptquiz'] = 'Tęsti savo bandymą';
$string['continuepreview'] = 'Tęsti paskutinę peržiūrą';
$string['copyingfrom'] = 'Kuriama klausimo {$a} kopija';
$string['copyingquestion'] = 'Kopijuojamas klausimas';
$string['correct'] = 'Teisingas';
$string['correctanswer'] = 'Teisingas atsakymas';
$string['correctanswerformula'] = 'Teisingo atsakymo formulė';
$string['correctansweris'] = 'Teisingas atsakymas: {$a}';
$string['correctanswerlength'] = 'Reikšmingi skaičiai';
$string['correctanswers'] = 'Teisingi atsakymai';
$string['correctanswershows'] = 'Teisingas atsakymas rodo';
$string['corrresp'] = 'Teisingas atsakymas.';
$string['countdown'] = 'Atgalinis skaičiavimas';
$string['countdownfinished'] = 'Testas uždaromas, turėtumėte pateikti savo atsakymus dabar.';
$string['countdowntenminutes'] = 'Testas baigsis po dešimties minučių.';
$string['coursetestmanager'] = 'Kursų testo tvarkytuvo formatas';
$string['createcategoryandaddrandomquestion'] = 'Kurti kategoriją ir įtraukti atsitiktinį klausimą';
$string['createfirst'] = 'Pirmiausia turite sukurti klausimų su trumpais atsakymais.';
$string['createmultiple'] = 'Įtraukti kelis atsitiktinius klausimus į testą';
$string['createnewquestion'] = 'Kurti naują klausimą';
$string['createquestionandadd'] = 'Kurti naują klausimą ir įtraukti jį į testą';
$string['currentbank'] = 'Dabartinis bankas: {$a}';
$string['custom'] = 'Pasirinktinis formatas';
$string['dataitemneed'] = 'Turite įtraukti mažiausiai vieną duomenų elementų rinkinį, kad klausimas būtų leistinas';
$string['datasetdefinitions'] = 'Kategorijos {$a} pakartotinai naudojamo duomenų rinkinio apibrėžimai';
$string['datasetnumber'] = 'Skaičius';
$string['daysavailable'] = 'Turimos dienos';
$string['decimaldigits'] = 'Dešimtainiai skaitmenys įvertinimuose';
$string['decimalplaces'] = 'Dešimtainės vietos įvertinimuose';
$string['decimalplaces_help'] = 'Šis parametras nurodo skaitmenų, rodomų po dešimtainių vietų, skaičių rodant atskirų klausimų įverčius. Jis turi įtakos tik įverčių rodymui, bet ne duomenų bazėje saugomiems įverčiams ar vidiniams skaičiavimams, kurie atliekami norint užtikrinti tikslumą.';
$string['decimalplacesquestion'] = 'Dešimtainės vietos klausimų baluose';
$string['decimalplacesquestion_help'] = 'Skaitmenų po kablelio skaičius, kai rodomi atskirų klausimų balai.';
$string['decimalpoints'] = 'Skaičiai po kablelio';
$string['default'] = 'Numatyta';
$string['defaultgrade'] = 'Numatytasis klausimo įvertinimas';
$string['defaultinfo'] = 'Numatytoji klausimų kategorija.';
$string['delay1'] = 'Atidėjimas tarp pirmojo ir antrojo bandymo';
$string['delay1st2nd'] = 'Taikomas atidėjimas tarp pirmojo ir antrojo bandymo';
$string['delay1st2nd_help'] = 'Jei įjungta, besimokantysis turės palaukti, kol praeis nurodytas laikas, kad galėtų bandyti atlikti testą antrą kartą.';
$string['delay2'] = 'Atidėjimas tarp vėlesnių bandymų';
$string['delaylater'] = 'Taikomas atidėjimas tarp vėlesnių bandymų';
$string['delaylater_help'] = 'Jei įjungta, besimokantysis turės palaukti, kol praeis nurodytas laikas, kad galėtų bandyti atlikti testą trečią ar dar tolesnį kartą.';
$string['deleteattemptcheck'] = 'Ar esate visiškai įsitikinę, kad norite visiškai panaikinti šiuos bandymus?';
$string['deleteselected'] = 'Naikinti pasirinktus';
$string['deletingquestionattempts'] = 'Naikinami klausimų bandymai';
$string['description'] = 'Aprašas';
$string['disabled'] = 'Išjungta';
$string['displayoptions'] = 'Rodymo parinktys';
$string['donotuseautosave'] = 'Nenaudoti automatinio saugojimo';
$string['download'] = 'Spustelėkite, kad atsisiųstumėte eksportuotą kategorijos failą';
$string['downloadextra'] = '(failas taip pat saugomas kursų failuose, aplanke /backupdata/quiz)';
$string['dragtoafter'] = 'Po {$a}';
$string['dragtostart'] = 'Į pradžią';
$string['duplicateresponse'] = 'Šio pateikimo nepaisoma, nes anksčiau pateikėte atitinkamą atsakymą.';
$string['eachattemptbuildsonthelast'] = 'Kiekvienas bandymas pagrįstas ankstesniu';
$string['eachattemptbuildsonthelast_help'] = 'Jei leidžiami keli bandymai ir įjungtas šis parametras, kiekviename naujame bandyme atlikti testą bus ankstesnio bandymo rezultatas. Tai leidžia atlikti testą per kelis bandymus.';
$string['edit_slotdisplaynumber_hint'] = 'Redaguoti klausimo numerį (daugiausia 16 simbolių)';
$string['edit_slotdisplaynumber_label'] = 'Nauja {$a} vertė';
$string['editcategories'] = 'Redaguoti kategorijas';
$string['editcategory'] = 'Redaguoti kategoriją';
$string['editcatquestions'] = 'Redaguoti kategorijos klausimus';
$string['editingquestion'] = 'Redaguojamas klausimas';
$string['editingquiz'] = 'Redaguojamas testas';
$string['editingquiz_help'] = 'Kuriant testą, pagrindinės sąvokos yra tokios: * testas, kurio viename arba keliuose puslapiuose yra klausimų; * klausimų bankas, kuriame saugomos visų klausimų kopijos, suskirstytos į kategorijas; * atsitiktiniai klausimai – kas kartą bandydamas atlikti testą, besimokantysis gauna skirtingus klausimus, o skirtingi besimokantieji taip pat gauna skirtingus klausimus';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Redaguojamas testas: {$a}';
$string['editmaxmark'] = 'Redaguoti maksimalų įvertinimą';
$string['editoverride'] = 'Redaguoti keitimą';
$string['editqcats'] = 'Redaguoti klausimų kategorijas';
$string['editquestion'] = 'Redaguoti klausimą';
$string['editquestions'] = 'Redaguoti klausimus';
$string['editquiz'] = 'Testo redagavimas';
$string['editquizquestions'] = 'Redaguoti testo klausimus';
$string['emailconfirmautosubmitsmall'] = 'Dėkojame, kad pateikėte atsakymus į „{$a->quizname}“';
$string['emailconfirmbody'] = 'Gerb. {$a->username},

dėkojame, kad pateikėte savo atsakymus į kurso {$a->coursename} testą {$a->quizname} {$a->submissiontime}.

Šis el. laiškas patvirtina, kad Jūsų atsakymai priimti.

Prie testo galite prieiti spustelėję {$a->quizurl}.';
$string['emailconfirmbodyautosubmit'] = 'Sveiki, {$a->username},

Baigėsi kurso „{$a->coursename}“ testo „{$a->quizname}“ laikas. Jūsų atsakymai buvo pateikti automatiškai {$a->submissiontime}.

Šis pranešimas patvirtina, kad jūsų atsakymai buvo išsaugoti.

Šį testą galite pasiekti adresu {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Dėkojame, kad pateikėte savo atsakymus į {$a->quizname}';
$string['emailconfirmsubject'] = 'Testo pateikimo patvirtinimas: {$a->quizname}';
$string['emailmanualgradedbody'] = 'Sveiki, {$a->studentname},

Jūsų atsakymai į \'{$a->quizname}\' kurse \'{$a->coursename}\' {$a->attempttimefinish} dabar jau įvertinti.

Galėsite peržiūrėti savo rezultatą ir atsiliepimus apsilankę „{$a->quizurl}“ ir peržiūrėję savo bandymą.';
$string['emailmanualgradedsubject'] = 'Jūsų bandymas atlikti {$a->quizname} buvo įvertintas';
$string['emailnotifybody'] = 'Gerb. {$a->username},

{$a->studentname} atliko kursų {$a->coursename} testą {$a->quizname} ({$a->quizurl}). Šį bandymą galite peržiūrėti spustelėję {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} atliko {$a->quizname}. Žiūrėkite {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} atliko testą {$a->quizname}';
$string['emailoverduebody'] = 'Sveiki, {$a->studentname},

kurse {$a->coursename} Jūs pradėjote testo "{$a->quizname}" bandymą, bet niekada jo nepateikėte. Jis turėtų būti pateiktas {$a->attemptduedate}.

Jei Jūs vis dar norite pateikti šį bandymą, eikite į {$a->attemptsummaryurl} ir paspauskite pateikimo mygtuką. Turite tai padaryti iki {$a->attemptgraceend}, kitaip Jūsų bandymas nebus įskaitytas.';
$string['emailoverduesmall'] = 'Jūs nepateikėte savo bandymo teste {$a->quizname}. Prašome eiti į {$a->attemptsummaryurl} iki {$a->attemptgraceend}, jeigu vis dar norite pateikti.';
$string['emailoverduesubject'] = 'Testui atlikti skirtas laikas jau baigėsi: {$a->quizname}';
$string['empty'] = 'Tuščia';
$string['enabled'] = 'Įjungta';
$string['endtest'] = 'Baigti testą...';
$string['erroraccessingreport'] = 'Negalite prieiti prie šios ataskaitos';
$string['errorinquestion'] = 'Klaida klausime';
$string['errormissingquestion'] = 'Klaida: sistemoje nėra klausimo, turinčio ID {$a}';
$string['errornotnumbers'] = 'Klaida – atsakymai turi būti skaitiniai';
$string['errorunexpectedevent'] = 'Rastas klausimo {$a->questionid} nenumatyto bandymo  {$a->attemptid} nenumatyto įvykio kodas {$a->event}.';
$string['essay'] = 'Esė';
$string['essayquestions'] = 'Klausimai';
$string['eventattemptautosaved'] = 'Testo bandymas išsaugotas automatiškai';
$string['eventattemptdeleted'] = 'Testo bandymas ištrintas';
$string['eventattemptmanualgradingcomplete'] = 'Testo bandymo rankinis vertinimas baigtas';
$string['eventattemptpreviewstarted'] = 'Pradėta testo bandymo peržiūra';
$string['eventattemptquestionrestarted'] = '';
$string['eventattemptreviewed'] = 'Testo bandymas peržiūrėtas';
$string['eventattemptsummaryviewed'] = 'Testo bandymo santrauka peržiūrėta';
$string['eventattemptupdated'] = 'Testo bandymas atnaujintas';
$string['eventattemptviewed'] = 'Testo bandymas peržiūrėtas';
$string['eventeditpageviewed'] = 'Peržiūrėtas testo redagavimo puslapis';
$string['eventoverridecreated'] = 'Testo išimtis sukurta';
$string['eventoverridedeleted'] = 'Testo keitimas ištrintas';
$string['eventoverrideupdated'] = 'Testo keitimas atnaujintas';
$string['eventpagebreakcreated'] = 'Puslapio lūžis sukurtas';
$string['eventpagebreakdeleted'] = 'Puslapio lūžis panaikintas';
$string['eventquestionmanuallygraded'] = 'Rankiniu būdu įvertintas klausimas';
$string['eventquizattemptabandoned'] = 'Nebaigtas testo bandymas';
$string['eventquizattemptregraded'] = 'Testo bandymas įvertintas iš naujo';
$string['eventquizattemptreopened'] = 'Testas vėl atidarytas';
$string['eventquizattemptstarted'] = 'Pradėtas testo bandymas';
$string['eventquizattemptsubmitted'] = 'Pateiktas testo bandymas';
$string['eventquizattempttimelimitexceeded'] = 'Viršytas testo bandymo laiko limitas';
$string['eventquizgradeitemcreated'] = 'Sukurtas testo įvertinimo elementas';
$string['eventquizgradeitemdeleted'] = 'Ištrintas testo įvertinimo elementas';
$string['eventquizgradeitemorderchanged'] = 'Pakeista testo įvertinimo elementų tvarka';
$string['eventquizgradeitemupdated'] = 'Atnaujintas testo įvertinimo elementas';
$string['eventquizgradeupdated'] = 'Testo įvertinimas atnaujintas';
$string['eventquizrepaginated'] = 'Testas perpuslapiuotas';
$string['eventreportviewed'] = 'Testo ataskaita peržiūrėta';
$string['eventsectionbreakcreated'] = 'Skilties lūžis sukurtas';
$string['eventsectionbreakdeleted'] = 'Skilties lūžis panaikintas';
$string['eventsectionshuffleupdated'] = 'Skyrių maišymas atnaujintas';
$string['eventsectiontitleupdated'] = 'Skyriaus pavadinimas atnaujintas';
$string['eventslotcreated'] = 'Nustatyta vieta sukurta';
$string['eventslotdeleted'] = 'Nustatyta vieta panaikinta';
$string['eventslotdisplayedquestionnumberupdated'] = 'Nustatytos vietos rodomo klausimo numeris atnaujintas';
$string['eventslotmarkupdated'] = 'Nustatytos vietos žymė atnaujinta';
$string['eventslotmoved'] = 'Nustatyta vieta perkelta';
$string['eventslotrequirepreviousupdated'] = 'Nustatyta vieta reikalauja būti iš anksto atnaujinta';
$string['eventslotversionupdated'] = 'Susitikimo versija atnaujintas';
$string['everynquestions'] = 'Kas {$a} klausimus (-ų)';
$string['everyquestion'] = 'Kiekvienas klausimas';
$string['everythingon'] = 'Viskas';
$string['existingcategory'] = 'Esama kategorija';
$string['exportcategory'] = 'eksportuoti kategoriją';
$string['exporterror'] = 'Apdorojant eksportavimą įvyko klaida';
$string['exportingquestions'] = 'Klausimai eksportuojami į failą';
$string['exportname'] = 'Failo vardas';
$string['exportquestions'] = 'Eksportuoti klausimus į failą';
$string['extraattemptrestrictions'] = 'Papildomi bandymų apribojimai';
$string['false'] = 'Netiesa';
$string['feedback'] = 'Atsiliepimas';
$string['feedbackerrorboundaryformat'] = 'Atsiliepimų įvertinimų ribos turi būti procentas arba skaičius. Jūsų reikšmė, įvesta ribose {$a}, neatpažinta.';
$string['feedbackerrorboundaryoutofrange'] = 'Atsiliepimų įvertinimų ribos turi būti nuo 0 % iki 100%. Jūsų reikšmė, įvesta ribose {$a}, yra už intervalo ribų.';
$string['feedbackerrorjunkinboundary'] = 'Turite užpildyti atsiliepimo įvertinimo ribų laukus nepalikdami jokių tarpų.';
$string['feedbackerrorjunkinfeedback'] = 'Turite užpildyti atsiliepimo laukus nepalikdami jokių tarpų.';
$string['feedbackerrororder'] = 'Atsiliepimų įvertinimų ribos turi būti išrūšiuotos pradedant nuo didžiausio. Jūsų reikšmė, įvesta ribose {$a}, nepatenka į seką.';
$string['file'] = 'Failas';
$string['fileformat'] = 'Failo formatas';
$string['fillcorrect'] = 'Įvesti teisingą';
$string['filloutnumericalanswer'] = 'Pateikėte mažiausiai vieną galima atsakymą ir nuokrypį. Pirmasis atitinkantis atsakymas bus naudojamas norint nustatyti balą ir atsiliepimą. Jei pateiksite atsiliepimą pabaigoje nenurodę atsakymo, jis bus rodomas besimokantiesiems, kurių atsakymo neatitinka joks kitas atsakymas.';
$string['filloutoneanswer'] = 'Turite pateikti mažiausiai vieną galima atsakymą. Tušti atsakymai nebus naudojami. Simbolis * gali būti naudojamas kaip pakaitos simbolis, atitinkantis bet kuriuos simbolius. Pirmasis atitinkantis atsakymas bus naudojamas norint nustatyti balą ir atsiliepimą.';
$string['filloutthreequestions'] = 'Turite paleisti mažiausiai tris klausimus su atitinkamais atsakymais. Galite pateikti papildomų klaidingų atsakymų pateikdami atsakymą, kurio klausimas tuščias. Įrašų, kurių ir klausimas, ir atsakymas yra tušti, bus nepaisoma.';
$string['fillouttwochoices'] = 'Turite užpildyti mažiausiai du pasirinkimus. Tušti pasirinkimai nebus naudojami.';
$string['finishattemptdots'] = 'Baigti bandymą...';
$string['finishreview'] = 'Baigti peržiūrą';
$string['forceregeneration'] = 'reikalauti pakartotinai generuoti';
$string['formatnotfound'] = 'Importavimo / eksportavimo formatas {$a} nerastas';
$string['formulaerror'] = 'Formulės klaidos!';
$string['fractionsaddwrong'] = 'Jūsų pasirinkti teigiami įvertinimai nesudaro 100 %<br />Jie sudaro iki {$a} %<br />Ar norite grįžti ir pataisyti klausimą?';
$string['fractionsnomax'] = 'Vienas iš atsakymų turėtų būti 100 %, kad būtų <br />įmanoma gauti visą šio klausimo įvertį.<br />Ar norite grįžti ir pašalinti šią problemą?';
$string['fromfile'] = 'iš failo:';
$string['functiondisabledbysecuremode'] = 'Šis funkcionalumas šiuo metu išjungtas';
$string['generalfeedback'] = 'Bendrasis atsiliepimas';
$string['generalfeedback_help'] = 'Bendrasis atsiliepimas yra tekstas, rodomas pabandžius atsakyti klausimą. Skirtingai nei konkretaus klausimo atsiliepimas, kuris priklauso nuo pateikto atsakymo, visada rodomas tas pats bendrasis atsiliepimas.';
$string['gobacktoquiz'] = 'Eiti atgal';
$string['graceperiod'] = 'Atidėjimo laikotarpis';
$string['graceperiod_desc'] = 'Jei nustatyme kai laikas baigiasi yra parinkta "Yra papildomas pateikimo laikas...", tai čia yra numatytas papildomas pateikimo laikas.';
$string['graceperiod_help'] = 'Tai yra, jei nustatyme, kai laikas baigiasi yra parinkta "Yra papildomas pateikimo laikas...", atidėjimo laikas, po kurio bus leidžiamas pateikimas.';
$string['graceperiodmin'] = 'Paskutinis atidėjimo laikotarpis';
$string['graceperiodmin_desc'] = 'Testo pabaigoje yra galima problema. Viena vertus, norime leisti besimokantiesiems tęsti darbą iki paskutinės sekundės – naudojant laikmatį, kuris automatiškai pateikia testą, kai baigiasi laikas. Kita vertus, serveris gali būti perkrautas ir atsakymų apdorojimas užtruks šiek tiek laiko. Todėl mes priimsime atsakymus iki laiko, kai pasibaigs laikas, todėl jie nebus baudžiami už lėtą serverio darbą. Tačiau besimokantysis gali sukčiauti ir gauti keletą sekundžių atsakyti į testą. Turite padaryti kompromisą, atsižvelgdami į tai, kiek pasitikite savo serverio našumu testų metu.';
$string['graceperiodtoosmall'] = 'Atidėjimo laikotarpis turi būti daugiau nei {$a}.';
$string['gradeall'] = 'Vertinti viską';
$string['gradeaverage'] = 'Vidutinis įvertinimas';
$string['gradeboundary'] = 'Įvertinimo riba';
$string['gradeessays'] = 'Vertinti esė';
$string['gradehighest'] = 'Aukščiausias įvertinimas';
$string['gradeitemdefaultname'] = 'Naujas įvertinimo elementas {$a}';
$string['gradeitemdelete'] = 'Ištrinti įvertinimo elementą {$a}';
$string['gradeitemedit'] = 'Redaguoti įvertinimo elemento pavadinimą {$a}';
$string['gradeitemmarkscheme'] = 'Priskirti įvertinimo elementus';
$string['gradeitemnewname'] = 'Naujas įvertinimo elemento pavadinimas {$a}';
$string['gradeitemnoneselected'] = '[nėra]';
$string['gradeitemnoslots'] = 'Šiame teste dar nėra klausimų. Pirmiausia pridėkite klausimų, tada grįžkite čia ir nustatykite įvertinimo elementus.';
$string['gradeitems'] = 'Įvertinimų elementai';
$string['gradeitemsautosetup'] = 'Nustatykite kiekvieno skyriaus įvertinimą';
$string['gradeitemsetup'] = 'Įvertinimo elementų nustatymai';
$string['gradeitemsremoveall'] = 'Iš naujo nustatyti nustatymus';
$string['gradeitemsremoveallconfirm'] = 'Iš naujo nustatyti įvertinimo elementus?';
$string['gradeitemsremovealltitle'] = 'Iš naujo nustatyti vertinimo elementų sąranką';
$string['grademethod'] = 'Vertinimo metodas';
$string['grademethod_help'] = 'Kai leidžiami keli bandymai, galutiniam testo įvertinimui apskaičiuoti galima naudoti šiuos metodus:

* Aukščiausias visų bandymų įvertinimas;
* Vidutinis visų bandymų įvertinimas (vidurkis);
* Pirmasis bandymas (visų kitų bandymų nepaisoma)
* Paskutinis bandymas (visų kitų bandymų nepaisoma)';
$string['gradesdeleted'] = 'Testo įvertinimai panaikinti';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Išlaikymo įvertinimas negali būti nulis, nes teste yra taikomas užbaigimo metodas, kuriame nustatytas išlaikymo įvertinimas. Prašome nustatyti ne nulinę reikšmę.';
$string['gradetopassoutof'] = 'Išlaikymo įvertinimas: {$a->grade} iš {$a->maxgrade}';
$string['gradingdetails'] = 'Balai šiam pateikimui: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Su ankstesnėmis baudomis <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Šis pateikimas gavo nuobaudą {$a}.';
$string['gradingdetailszeropenalty'] = 'Jūs nebuvote nubausti už šį pateikimą.';
$string['gradingmethod'] = 'Vertinimo metodas: {$a}';
$string['groupoverrides'] = 'Grupės keitimai';
$string['groupoverridesdeleted'] = 'Grupės keitimai ištrinti';
$string['groupsnone'] = 'Nėra grupių, kurias galėtumėte pasiekti.';
$string['guestsno'] = 'Apgailestaujame, svečiai negali peržiūrėti ar atlikti testų';
$string['hidebreaks'] = 'Slėpti puslapio lūžius';
$string['hidereordertool'] = 'Slėpti tvarkos keitimo įrankį';
$string['history'] = 'Atsakymų retrospektyva:';
$string['howquestionsbehave_desc'] = 'Įprastiniai nustatymai, kaip klausimai turėtų veikti teste.';
$string['imagedisplay'] = 'Rodyti paveiksliuką';
$string['import_help'] = 'Ši funkcija leidžia jums importuoti klausimus iš išorinių teksto failų. Jei jūsų faile yra ne ASCII simbolių, jis turi naudoti UTF-8 kodavimą. Būkite ypač atsargūs naudodami „Microsoft Office“ taikomųjų programų sugeneruotus failus, nes juose dažnai naudojamas specialus kodavimas, kuris nebus tinkamai apdorotas. Importo ir eksporto formatai yra prijungiami ištekliai. Kiti pasirinktiniai formatai gali būti pateikti modulių ir papildinių duomenų bazėje.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'importuoti kategoriją';
$string['importerror'] = 'Apdorojant importavimą įvyko klaida';
$string['importfilearea'] = 'Importavimas iš failo jau kursų failuose...';
$string['importfileupload'] = 'Importavimas iš failų įkėlimo...';
$string['importfromthisfile'] = 'Importuoti iš šio failo';
$string['importingquestions'] = 'Iš failo importuojami {$a} klausimai (-ų)';
$string['importmax10error'] = 'Klausime yra klaida. Negalite turėti daugiau nei dešimties atsakymų';
$string['importmaxerror'] = 'Klausime yra klaida. Atsakymų yra per daug.';
$string['importquestions'] = 'Importuoti klausimus iš failo';
$string['inactiveoverridehelp'] = '* Šis perrašymas neaktyvus, nes naudotojo prieiga prie veiklos yra apribota. Taip gali nutikti dėl grupės ar vaidmenų priskyrimo, kitų prieigos apribojimų arba paslėptos veiklos.';
$string['incorrect'] = 'Klaidinga';
$string['indicator:cognitivedepth'] = 'Kognityvinis testas';
$string['indicator:cognitivedepth_help'] = 'Šis rodiklis pagrįstas pažinimo gyliu, kurį besimokantysis pasiekė Testo veikloje.';
$string['indicator:cognitivedepthdef'] = 'Kognityvinis testas';
$string['indicator:cognitivedepthdef_help'] = 'Dalyvis per šį analizės intervalą pasiekė šį kognityvinio įsitraukimo procentą, kurį siūlo Testo  veikla (Lygiai = Neperžiūrėta, Peržiūrėta, Pateikta, Peržiūrėtas atsiliepimas, Pakomentuotas atsiliepimas, Pateiktas iš naujo po peržiūros)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Socialinis testas';
$string['indicator:socialbreadth_help'] = 'Šis rodiklis pagrįstas socialiniu plotu, kurį besimokantysis pasiekė Testo veikloje.';
$string['indicator:socialbreadthdef'] = 'Socialinis testas';
$string['indicator:socialbreadthdef_help'] = 'Dalyvis per šį analizės intervalą pasiekė šį socialinio įsitraukimo procentą, kurį siūlo Testo veikla (Lygiai = Nedalyvauja, Dalyvis vienas, Dalyvis su kitais)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Asmenų atsakymai į kiekvieną elementą';
$string['info'] = 'Informacija';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Bendras grįžtamojo ryšio laukų pradinis skaičius';
$string['initialnumfeedbacks_desc'] = 'Kurdami naują testą pateikite daug tuščių bendrų atsiliepimų laukelių. Sukūrus testą, formoje rodomas laukelių skaičius, reikalingas atsiliepimų skaičiui teste. Nustatymas turi būti bent 1.';
$string['inprogress'] = 'Atliekama';
$string['introduction'] = 'Aprašymas';
$string['invalidattemptid'] = 'Nėra tokio bandymo ID';
$string['invalidcategory'] = 'Kategorijos ID yra neleistinas';
$string['invalidoverrideid'] = 'Netinkamas pakeitimo ID.';
$string['invalidquestionid'] = 'Neleistinas klausimo ID';
$string['invalidquizid'] = 'Neleistinas testo ID';
$string['invalidrandomslot'] = 'Netinkamas atsitiktinio klausimo nustatytos vietos ID.';
$string['invalidsource'] = 'Šaltinis nepriimamas kaip leistinas.';
$string['invalidsourcetype'] = 'Neleistinas šaltinio tipas.';
$string['invalidstateid'] = 'Neleistinas būsenos ID';
$string['lastanswer'] = 'Jūsų paskutinis atsakymas buvo';
$string['lastautosave'] = 'Paskutinį kartą išsaugotas: {$a}';
$string['layout'] = 'Maketas';
$string['layoutasshown'] = 'Puslapio maketas toks, koks rodomas.';
$string['layoutasshownwithpages'] = 'Puslapio maketas toks, koks rodomas. <small>(Automatinis naujas puslapis kas {$a} klausimus (-ų).</small>';
$string['layoutshuffledandpaged'] = 'Klausimai atsitiktine tvarka išmaišomi rodant {$a} klausimus (-ų) kiekviename puslapyje.';
$string['layoutshuffledsinglepage'] = 'Klausimai atsitiktine tvarka išmaišomi rodant visus viename puslapyje.';
$string['link'] = 'Saitas';
$string['listitems'] = 'Testo elementų sąrašas';
$string['literal'] = 'Raidinis';
$string['loadingquestionsfailed'] = 'Klausimų įkelti nepavyko: {$a}';
$string['makecopy'] = 'Įrašyti kaip naują klausimą';
$string['managetypes'] = 'Valdyti klausimų tipus ir serverius';
$string['manualgradequestion'] = 'Rankiniu būdu vertinamas klausimas {$a->question} teste {$a->quiz} naudotojo {$a->user}';
$string['manualgrading'] = 'Vertinimas';
$string['mark'] = 'Pateikti';
$string['markall'] = 'Pateikimo puslapis';
$string['marks'] = 'Balai';
$string['marks_help'] = 'Už kiekvieną klausimą gautas balas ir bendras bandymo rezultatas.';
$string['match'] = 'Atitikimas';
$string['matchanswer'] = 'Atitinkantis atsakymas';
$string['matchanswerno'] = 'Atitinkantis atsakymas {$a}';
$string['max'] = 'Maks.';
$string['maxmark'] = 'Maksimalus įvertinimas';
$string['maxmarks'] = 'Didžiausias balų skaičius';
$string['maxmarks_help'] = 'Didžiausias galimas kiekvieno klausimo įvertinimas.';
$string['messageprovider:attempt_grading_complete'] = 'Pranešimas, kad jūsų bandymas buvo įvertintas';
$string['messageprovider:attempt_overdue'] = 'Įspėti, kai testo nebus galima atlikti';
$string['messageprovider:confirmation'] = 'Jūsų testo pateikimų patvirtinimas';
$string['messageprovider:quiz_open_soon'] = 'Testas bus atvertas netrukus';
$string['messageprovider:submission'] = 'Pranešimas apie jūsų besimokančiųjų testo pateikimus';
$string['min'] = 'Min';
$string['minutes'] = 'Minutės';
$string['missingcorrectanswer'] = 'Būtina nurodyti teisingą atsakymą';
$string['missingitemtypename'] = 'Nėra pavadinimo';
$string['missingquestion'] = 'Klausimas atrodo jau nebeegzistuoja';
$string['modulename'] = 'Testas';
$string['modulename_help'] = 'Testo modulis leidžia dėstytojui kurti ir nustatyti testus, sudarytus iš klausimų su keliais pasirinktiniais atsakymais, teisinga / klaidinga tipo klausimų, gretinimo ir kitų tipų klausimų. Kiekvienas bandymas automatiškai įvertinamas, o dėstytojas gali pasirinkti palikti atsiliepimus ir (arba) rodyti teisingus atsakymus.';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Testai';
$string['moveselectedonpage'] = 'Perkelti pasirinktus klausimus į puslapį: {$a}';
$string['multichoice'] = 'Keli pasirinkimai';
$string['multipleanswers'] = 'Pasirinkite mažiausiai vieną atsakymą.';
$string['mustbesubmittedby'] = 'Atsakymą reikia pateikti iki {$a}.';
$string['name'] = 'Pavadinimas';
$string['navigatenext'] = 'Kitas';
$string['navigateprevious'] = 'Ankstesnis';
$string['navmethod'] = 'Navigacijos metodas';
$string['navmethod_free'] = 'Laisvas';
$string['navmethod_help'] = 'Kuomet įgalinta "Iš eilės" navigacija, besimokantysis turi atlikti testą iš eilės ir negali grįžti atgal ar peršokti į priekį.';
$string['navmethod_seq'] = 'Iš eilės';
$string['navnojswarning'] = 'Įspėjimas: šie saitai neišsaugos jūsų atsakymų. Naudokite puslapio apačioje esantį mygtuką Pirmyn.';
$string['neverallononepage'] = 'Niekada, visi klausimai viename puslapyje';
$string['newattemptfail'] = 'Klaida: nepavyko pradėti naujo bandymo atlikti testą';
$string['newcategory'] = 'Nauja kategorija';
$string['newpage'] = 'Naujas puslapis';
$string['newpage_help'] = 'Kuriant ilgesnius testus tampa prasminga išskaidyti testą per kelis puslapius, apribojant klausimų skaičių viename puslapyje. Įtraukiant klausimus į testą, puslapių lūžiai bus automatiškai įterpti atsižvelgiant į šį parametrą. Tačiau vėliau redagavimo puslapyje puslapių lūžius bus galima perkelti rankiniu būdu.';
$string['newpageevery'] = 'Automatiškai pradėti naują puslapį';
$string['newsectionheading'] = 'Nauja antraštė';
$string['noanswers'] = 'Nepasirinkta jokių atsakymų!';
$string['noattempts'] = 'Dar nebuvo bandymų atlikti šį testą';
$string['noattemptsfound'] = 'Bandymų nerasta.';
$string['noattemptstoshow'] = 'Nėra rodytinų bandymų';
$string['nocategory'] = 'Kategorija klaidinga arba nenurodyta';
$string['noclose'] = 'Nėra uždarymo datos';
$string['nocommentsyet'] = 'Komentarų dar nėra.';
$string['noconnection'] = 'Šiuo metu nėra ryšio su žiniatinklio tarnyba, kuri galėtų apdoroti šį klausimą. Kreipkitės į administratorių';
$string['nodataset'] = 'nieko – tai nėra pakaitos simbolis';
$string['nodatasubmitted'] = 'Nepateikta jokių duomenų.';
$string['noessayquestionsfound'] = 'Nerasta rankiniu būdų įvertintų klausimų';
$string['nogradewarning'] = 'Šis testas neįvertintas, todėl negalite nustatyti bendrų atsiliepimų, kurie skirtųsi pagal įvertį.';
$string['nomoreattempts'] = 'Daugiau bandyti neleidžiama';
$string['none'] = 'Nėra';
$string['noopen'] = 'Nėra atidarymo datos';
$string['nooverridedata'] = 'Turite keisti mažiausiai vieną testo parametrą.';
$string['nopossibledatasets'] = 'Nėra galimų duomenų rinkinių';
$string['noquestionintext'] = 'Klausimo tekste nėra jokių įdėtųjų klausimų';
$string['noquestions'] = 'Klausimai dar neįtraukti';
$string['noquestionsfound'] = 'Klausimų nerasta';
$string['noquestionsinquiz'] = 'Šiame teste nėra klausimų.';
$string['noquestionsnotinuse'] = 'Šis atsitiktinis klausimas nenaudojamas, nes jo kategorija tuščia.';
$string['noquestionsonpage'] = 'Tuščias puslapis';
$string['noresponse'] = 'Atsakymo nėra';
$string['noreview'] = 'Jums neleidžiama peržiūrėti šio testo';
$string['noreviewattempt'] = 'Jūs negalite peržiūrėti šio bandymo.';
$string['noreviewshort'] = 'Peržiūra neleidžiama';
$string['noreviewuntil'] = 'Jums neleidžiama peržiūrėti šio testo iki {$a}';
$string['noreviewuntilshort'] = 'Prieinamas {$a}';
$string['noscript'] = 'Norint tęsti turi būti įjungtas „JavaScript“!';
$string['notavailabletostudents'] = 'Pastaba: šis testas šiuo metu neprieinamas Jūsų besimokantiesiems.';
$string['notenoughrandomquestions'] = 'Nepakanka klausimų {$a->category} kategorijoje norint sukurti „{$a->name}“ klausimą  ({$a->id}).';
$string['notenoughsubquestions'] = 'Apibrėžta nepakankamai antrinių klausimų!<br />Ar norite grįžti ir pašalinti šią problemą?';
$string['notifyattemptsgradedtask'] = 'Siųsti testo bandymo įvertinimo pranešimus';
$string['notimedependentitems'] = 'Testo modulis šiuo metu nepalaiko nuo laiko priklausomų elementų. Norėdami išvengti šios problemos, nustatykite viso testo laiko limitą. Ar norite pasirinkti kitą elementą (arba vis tiek naudoti šį elementą)?';
$string['notyetgraded'] = 'Dar neįvertinta';
$string['notyetviewed'] = 'Dar neperžiūrėta';
$string['notyourattempt'] = 'Tai ne jūsų bandymas!';
$string['noview'] = 'Prisijungusiam naudotojui neleidžiama peržiūrėti šio testo';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} atliko {$a->attemptnum} bandymus (-ų)';
$string['numberabbr'] = 'Nr.';
$string['numerical'] = 'Skaitinis';
$string['numquestionsx'] = 'Klausimai: {$a}';
$string['oneminute'] = '1 minutė';
$string['onlyteachersexport'] = 'Tik dėstytojai gali eksportuoti klausimus';
$string['onlyteachersimport'] = 'Tik dėstytojai, turintys redagavimo teises, gali importuoti klausimus';
$string['onthispage'] = 'Šiame puslapyje';
$string['open'] = 'Neatsakyta';
$string['openafterclose'] = 'Testo atnaujinti nepavyko. Atidarymo data nurodyta po uždarymo datos.';
$string['openclosedatesupdated'] = 'Atidarymo ir uždarymo datos';
$string['optional'] = 'pasirinktinai';
$string['orderandpaging'] = 'Tvarka ir puslapių kaita';
$string['orderandpaging_help'] = 'Skaičiai 10, 20, 30 ir t. t., esantys prieš kiekvieną klausimą, nurodo klausimų tvarką. Skaičiai didėja po 10, kad liktų vietos papildomiems klausimams. Norėdami keisti šių klausimų tvarką, pakeiskite skaičius ir spustelėkite mygtuką Keisti klausimų tvarką. Norėdami po tam tikrų klausimų įtraukti puslapių lūžius, pažymėkite šalia klausimų esančius žymės langelius, tada spustelėkite mygtuką Įtraukti naujų puslapių po pasirinktų klausimų. Norėdami išdėstyti klausimus keliuose puslapiuose, spustelėkite mygtuką Perpuslapiuoti puslapius ir pasirinkite norimą klausimų skaičių viename puslapyje.';
$string['orderingquiz'] = 'Tvarka ir puslapių kaita';
$string['orderingquizx'] = 'Tvarka ir puslapių kaita: {$a}';
$string['outcomesadvanced'] = 'Rezultatai yra su išplėstiniais nustatymais';
$string['outof'] = '{$a->grade} iš maks. {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} iš maks. {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Bendras atsiliepimas';
$string['overallfeedback_help'] = 'Bendras atsiliepimas yra tekstas, rodomas pabandžius atlikti testą. Nurodžius papildomas įverčių ribas (kaip procentą arba kaip skaičių), rodomas tekstas gali priklausyti nuo gauto įverčio.';
$string['overdue'] = 'Uždelstas';
$string['overduehandling'] = 'Kai laikas baigiasi';
$string['overduehandling_desc'] = 'kas turi atsitikti pagal nutylėjimą, jeigu besimokantysis nepateikia atsakymų prieš laikui pasibaigiant';
$string['overduehandling_help'] = 'Šis nustatymas valdo, kas atsitiks, jei besimokantysis nepateiks bandymo atlikti testą nepasibaigus laikui. Jei besimokantysis tuo metu aktyviai dirba su testu, atgalinės atskaitos laikmatis visada automatiškai pateiks bandymą už jį, bet jei jis atsijungė, šis nustatymas valdo, kas atsitiks.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'Bandymai turi būti pateikti prieš pasibaigiant laikui arba jie nebus įskaičiuoti';
$string['overduehandlingautosubmit'] = 'Atviri bandymai yra pateikiami automatiškai';
$string['overduehandlinggraceperiod'] = 'Yra papildomas pateikimo laikas testams, kurie nepateikti, tačiau į klausimus atsakyti nebegalima';
$string['overduemustbesubmittedby'] = 'Šis bandymas jau pavėluotas. Jis jau turėjo būti pateiktas. Jei norite, kad šis testas būtų įvertintas, turite jį patvirtinti {$a}. Jei nepateiksite, tada balas šiam bandymui nebus skaičiuojamas.';
$string['override'] = 'Keisti';
$string['overridecannotsetbothgroupanduser'] = 'Vienu metu negalima nustatyti ir grupės, ir naudotojo.';
$string['overridedeletegroupsure'] = 'Ar tikrai norite naikinti grupės {$a} keitimą?';
$string['overridedeleteusersure'] = 'Ar tikrai norite naikinti naudotojo {$a} keitimą?';
$string['overridegroup'] = 'Keisti grupę';
$string['overridegroupeventname'] = '{$a->quiz} – {$a->group}';
$string['overrideinvalidattempts'] = 'Bandymų vertė turi būti didesnė už nulį.';
$string['overrideinvalidexistingid'] = 'Keitimas neegzistuoja.';
$string['overrideinvalidquiz'] = 'Testo ID rinkinys neegzistuoja.';
$string['overrideinvalidtimelimit'] = 'Laiko riba turi būti didesnė už nulį.';
$string['overridemultiplerecordsexist'] = 'Tam pačiam naudotojui/grupei negalima atlikti kelių pakeitimų.';
$string['overridemustsetuserorgroup'] = 'Turi būti nustatytas naudotojas arba grupė.';
$string['overrides'] = 'Keitimai';
$string['overridesforquiz'] = 'Perrašymo nuostatos: {$a}';
$string['overridesnoneforgroups'] = 'Šio testo grupių nustatymų perrašymas nesukurtas.';
$string['overridesnoneforusers'] = 'Šio testo naudotojų nustatymų perrašymas nesukurtas.';
$string['overridessummary'] = 'Yra nustatymų keitimai ({$a})';
$string['overridessummarygroup'] = 'Grupės: {$a}';
$string['overridessummarythisgroup'] = 'Šios grupės nustatymų keitimas yra ({$a}).';
$string['overridessummaryuser'] = 'Naudotojai: {$a}';
$string['overridessummaryyourgroups'] = 'Yra jūsų grupių nustatymų keitimas ({$a}).';
$string['overrideuser'] = 'Keisti naudotoją';
$string['overrideusereventname'] = '{$a->quiz} – keitimas';
$string['page-mod-quiz-attempt'] = 'Testo bandymo puslapis';
$string['page-mod-quiz-edit'] = 'Redaguoti testo puslapį';
$string['page-mod-quiz-report'] = 'Testo ataskaitos puslapis';
$string['page-mod-quiz-review'] = 'Testo bandymo peržiūros puslapis';
$string['page-mod-quiz-summary'] = 'Testo bandymo santraukos puslapis';
$string['page-mod-quiz-view'] = 'Testo informacijos puslapis';
$string['page-mod-quiz-x'] = 'Bet kuris testo puslapis';
$string['pageshort'] = 'P';
$string['pagesize'] = 'Puslapio dydis';
$string['parent'] = 'Pirminis';
$string['parentcategory'] = 'Pirminė kategorija';
$string['parsingquestions'] = 'Analizuojami klausimai iš importo failo.';
$string['partiallycorrect'] = 'Iš dalies teisingas';
$string['penalty'] = 'Nuobauda';
$string['penaltyscheme'] = 'Taikyti nuobaudas';
$string['penaltyscheme_help'] = 'Jei įjungta, už klaidingą atsakymą iš klausimo galutinio pažymio atimama bauda. baudos dydis nurodomas klausimo parametruose. Šis parametras taikomas tik įjungus adaptyvųjį režimą.';
$string['percentcorrect'] = 'Teisingų procentas';
$string['pleaseclose'] = 'Jūsų užduotis apdorota. Dabar galite uždaryti šį langą';
$string['pluginadministration'] = 'Testo administravimas';
$string['pluginname'] = 'Testas';
$string['popup'] = 'Testą rodyti „saugiame“ lange';
$string['popupblockerwarning'] = 'Ši testo dalis rodoma saugiuoju režimu, t. y. jūs turite atlikti testą saugiame lange. Išjunkite iššokančiųjų langų blokavimo priemonę. Dėkojame.';
$string['popupnotice'] = 'Besimokantieji matys šį testą saugiame lange';
$string['precreateyes'] = 'Taip, {$a} valandos iki testo pradžios';
$string['preprocesserror'] = 'Atliekant išankstinį apdorojimą įvyko klaida!';
$string['preview'] = 'Peržiūra';
$string['previewquestion'] = 'Peržiūrėti klausimą';
$string['previewquiz'] = 'Peržiūrėti  {$a}';
$string['previewquiznow'] = 'Peržiūrėti testą dabar';
$string['previewquizstart'] = 'Peržiūrėti testą';
$string['previous'] = 'Ankstesnė būsena';
$string['privacy:metadata:core_question'] = 'Testo veikla saugo klausimo naudojimo informaciją posistemėje core_question.';
$string['privacy:metadata:quiz'] = 'Testo veikloje naudojamos testo ataskaitos.';
$string['privacy:metadata:quiz_attempts'] = 'Išsami informacija apie kiekvieną bandymą teste.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Bandymo skaičius.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Dabartinis puslapis, kuriame yra naudotojas.';
$string['privacy:metadata:quiz_attempts:gradednotificationsenttime'] = 'Laikas, kai naudotojui buvo pranešta, kad jo bandymas rankiniu būdu buvo įvertintas';
$string['privacy:metadata:quiz_attempts:preview'] = 'Ar tai yra testo peržiūra.';
$string['privacy:metadata:quiz_attempts:state'] = 'Dabartinė bandymo būsena.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Bandymų įvertinimų suma.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Laikas, kai būsena buvo patikrinta.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Laikas, kai bandymas buvo baigtas.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Laikas, kai bandymas buvo atnaujintas.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Laikas, kai bandymas buvo atnaujintas per atnaujinimą neprisijungus.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Laikas, kai bandymas buvo pradėtas.';
$string['privacy:metadata:quiz_grades'] = 'Išsami informacija apie bendrą testo įvertinimą.';
$string['privacy:metadata:quiz_grades:grade'] = 'Testo bendras įvertinimas.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Įvertintas testas.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Laikas, kai įvertinimas buvo keistas.';
$string['privacy:metadata:quiz_grades:userid'] = 'Įvertintas naudotojas.';
$string['privacy:metadata:quiz_overrides'] = 'Išsami informacija apie testo keitimus.';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Testas su keitimų informacija';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Naujas testo uždarymo laikas.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Naujas laikas testo limitui.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Naujas testo atidarymo laikas.';
$string['privacy:metadata:quiz_overrides:userid'] = 'Naudotojas yra perrašytas';
$string['privacy:metadata:quizaccess'] = 'Testo veikloje naudojama testo prieigos taisyklės.';
$string['publish'] = 'Publikuoti';
$string['publishedit'] = 'Turite turėti publikavimo kursų teisę įtraukti arba redaguoti šioje kategorijoje esančius klausimus';
$string['qbrief'] = 'K. {$a}';
$string['qname'] = 'pavadinimas';
$string['qti'] = 'IMS QTI formatas';
$string['qtypename'] = 'tipas, pavadinimas';
$string['question'] = 'Klausimas';
$string['questionbank'] = 'iš klausimų banko';
$string['questionbankmanagement'] = 'Klausimų banko valdymas';
$string['questionbehaviour'] = 'Klausimo veikimas';
$string['questioncats'] = 'Klausimų kategorijos';
$string['questiondeleted'] = 'Šis klausimas ištrintas. Kreipkitės į savo dėstytoją';
$string['questiondependencyadd'] = 'Nėra apribojimo, kai gali būti  {$a->thisq} klausimo bandymas • Spustelėkite keisti';
$string['questiondependencyfree'] = 'Nėra apribojimų šiam klausimui';
$string['questiondependencyremove'] = 'Klausimas {$a->thisq} negali būti bandomas kol ankstesnis klausimas {$a->previousq} nebus baigtas • Spragtelkite, jei norite pakeisti';
$string['questiondependsonprevious'] = 'Šis klausimas negali būti bandomas, kol ankstesnis klausimas nebuvo baigtas.';
$string['questiondraftonly'] = 'Klausimas „{$a}“ yra juodraščio būsenoje. Norėdami jį naudoti teste, eikite į klausimų banką ir pakeiskite būseną į parengtą.';
$string['questiondraftwillnotwork'] = 'Šis klausimas yra juodraščio būsenoje. Norėdami jį naudoti teste, eikite į klausimų banką ir pakeiskite būseną į parengtą.';
$string['questioninuse'] = 'Klausimas {$a->questionname} šiuo metu naudojamas: <br />{$a->quiznames}<br />Klausimas nebus panaikintas iš šių testų. Jis bus panaikintas tik iš kategorijų sąrašo.';
$string['questionmissing'] = 'Nėra šio seanso klausimo';
$string['questionname'] = 'Klausimo pavadinimas';
$string['questionnonav'] = '<span class="accesshide">Klausimas </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informacija </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Klausimas {$a} neįkeltas iš duomenų bazės';
$string['questionorder'] = 'Klausimų tvarka';
$string['questionposition'] = 'Nauja klausimo {$a} vieta eilėje';
$string['questions'] = 'Klausimai';
$string['questionsetpreview'] = 'Klausimų rinkinio peržiūra';
$string['questionsinclhidden'] = 'Klausimai (įskaitant paslėptus)';
$string['questionsinthisquiz'] = 'Šio testo klausimai';
$string['questionsmatchingfilter'] = 'Klausimai, atitinkantys šį filtrą: {$a}';
$string['questionsperpage'] = 'Klausimų skaičius puslapyje';
$string['questionsperpageselected'] = 'Klausimų skaičius puslapyje nustatytas taip, kad šiuo metu puslapių kaita būtų fiksuota. Dėl to puslapių kaitos valdikliai išjungti. Tai galima keisti {$a}.';
$string['questionsperpagex'] = 'Klausimų skaičius puslapyje: {$a}';
$string['questiontext'] = 'Klausimo tekstas';
$string['questiontextisempty'] = '[Tuščias klausimo tekstas]';
$string['questiontype'] = 'Klausimo tipas {$a}';
$string['questiontypesetupoptions'] = 'Nustatyti klausimų tipų parinktis:';
$string['questionversion'] = 'v{$a}';
$string['questionversionlatest'] = 'v{$a} (naujausia)';
$string['quiz:addinstance'] = 'Pridėti naują testą';
$string['quiz:attempt'] = 'Bandyti atlikti testus';
$string['quiz:deleteattempts'] = 'Naikinti testo bandymus';
$string['quiz:emailconfirmsubmission'] = 'Gauti patvirtinimą apie savo pateiktą testą';
$string['quiz:emailnotifyattemptgraded'] = 'Gauti pranešimą, kai jūsų bandymas bus įvertintas';
$string['quiz:emailnotifysubmission'] = 'Gaukite pranešimą apie savo besimokančiųjų testo pateikimus';
$string['quiz:emailwarnoverdue'] = 'Gauti įspėjimą, kai vėluojama atlikti testą';
$string['quiz:grade'] = 'Vertinti testus rankiniu būdu';
$string['quiz:ignoretimelimits'] = 'Nepaisyti testo laiko limito';
$string['quiz:manage'] = 'Valdyti testus';
$string['quiz:manageoverrides'] = 'Valdyti testų nuostatų keitimus';
$string['quiz:preview'] = 'Peržiūrėti testus';
$string['quiz:regrade'] = 'Iš naujo vertinti bandymus atlikti testus';
$string['quiz:reopenattempts'] = 'Iš naujo atidaryti niekada nepateiktus testo bandymus';
$string['quiz:reviewmyattempts'] = 'Peržiūrėti savo bandymus';
$string['quiz:view'] = 'Peržiūrėti testo informaciją';
$string['quiz:viewoverrides'] = 'Peržiūrėti testų nuostatų keitimus';
$string['quiz:viewreports'] = 'Peržiūrėti testo ataskaitas';
$string['quizavailable'] = 'Testas galimas iki: {$a}';
$string['quizclose'] = 'Uždaryti testą';
$string['quizclosed'] = 'Šis testas uždarytas {$a}';
$string['quizcloses'] = 'Testas uždaromas';
$string['quizcloseson'] = 'Šis testas bus uždarytas {$a}.';
$string['quizeventcloses'] = '{$a} uždaromas';
$string['quizeventopens'] = '{$a} atidaroma';
$string['quizisclosed'] = 'Šis testas uždarytas';
$string['quizisclosedwillopen'] = 'Testas uždarytas (bus atidarytas {$a})';
$string['quizisopen'] = 'Šis testas atidarytas';
$string['quizisopenwillclose'] = 'Testas atidarytas (bus uždarytas {$a})';
$string['quiznavigation'] = 'Testo naršymas';
$string['quizopen'] = 'Atidaryti testą';
$string['quizopenclose'] = 'Atidarymo ir uždarymo datos';
$string['quizopenclose_help'] = 'Besimokantieji gali bandyti tiktai po atidarymo laiko ir jie privalo užbaigti savo bandymus prieš uždarymo laiką.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopendatesoonhtml'] = '<pSveiki, {$a->firstname},</p>
<p>Testas <strong>{$a->quizname}</strong> kurse {$a->coursename} tuoj atsidarys.
<p><strong>Atsidaro: {$a->timeopen}</strong></p>
<p><strong>Užsidaro: {$a->timeclose}</strong></p>
<p><a href="{$a->url}">Eiti į testą</a></p>';
$string['quizopendatesoonsubject'] = 'Atidaromas {$a->timeopen}: {$a->quizname}';
$string['quizopened'] = 'Šis testas atidarytas.';
$string['quizopenedon'] = 'Šis testas atidaromas nuo {$a}';
$string['quizopens'] = 'Testas atidaromas';
$string['quizopenwillclose'] = 'Šis testas atidarytas. Užsidaro {$a}';
$string['quizordernotrandom'] = 'Testo tvarka neišmaišyta';
$string['quizorderrandom'] = '* Testo tvarka išmaišyta';
$string['quizreport'] = 'Testo ataskaita';
$string['quizsettings'] = 'Testo parametrai';
$string['quizsetupnavigation'] = 'Testo nustatymų navigacija';
$string['quiztimer'] = 'Testo laikmatis';
$string['quizwillopen'] = 'Šis testas bus atidarytas {$a}';
$string['random'] = 'Atsitiktinis  klausimas';
$string['randomcatwithsubcat'] = '{$a} ir subkategorijos';
$string['randomcoursecatwithsubcat'] = 'Bet kuri kategorija, esanti kurso kategorijoje {$a}';
$string['randomcoursewithsubcat'] = 'Bet kuri šio kurso kategorija';
$string['randomcreate'] = 'Kurti  atsitiktinius klausimus';
$string['randomediting'] = 'Atsitiktinio klausimo redagavimas';
$string['randomfromcategory'] = 'Atsitiktinis klausimas iš kategorijos:';
$string['randomfromexistingcategory'] = 'Atsitiktinis klausimas iš esamos kategorijos';
$string['randomfromunavailabletag'] = '{$a} (nepasiekiamas)';
$string['randommodulewithsubcat'] = 'Bet kuri šio testo kategorija';
$string['randomnosubcat'] = 'Klausimai tik iš šios kategorijos (ne jos subkategorijų).';
$string['randomnumber'] = 'Atsitiktinių klausimų skaičius';
$string['randomqname'] = 'Atsitiktinis klausimas pagal filtro sąlygą';
$string['randomqnamecat'] = 'Atsitiktinis ({$a->category}) pagal filtro sąlygą';
$string['randomqnamecattags'] = 'Atsitiktinis ({$a->category}) pagal filtro sąlygą su žymėmis: {$a->tags}';
$string['randomqnametags'] = 'Atsitiktinis klausimas pagal filtro sąlygą su žymėmis: {$a}';
$string['randomquestion'] = 'Atsitiktinis klausimas';
$string['randomquestion_help'] = 'Atsitiktinis klausimas yra būdas įterpti pasirinktą klausimą atsitiktine tvarka iš nurodytos kategorijos arba pagal nurodytos žymę veikloje.';
$string['randomquestiontags'] = 'Žymės';
$string['randomquestiontags_help'] = 'Galite riboti atrankos kriterijus, nurodydami klausimo žymes čia.

Atsitiktiniai klausimai bus parinkti iš klausimų, kuriuose yra visos šios žymos.';
$string['randomquestionusinganewcategory'] = 'Atsitiktinis klausimas, naudojantis naują kategoriją';
$string['randomsystemwithsubcat'] = 'Bet kuri sistemos lygmens kategorija';
$string['randomwithsubcat'] = 'Klausimai iš šios kategorijos ir jos subkategorijų.';
$string['readytosend'] = 'Ruošiatės siųsti visą savo testą vertinti. Ar tikrai norite tęsti?';
$string['reattemptquiz'] = 'Dar kartą atlikti testą';
$string['recentlyaddedquestion'] = 'Neseniai įtrauktas klausimas!';
$string['recurse'] = 'Įtraukti ir klausimus iš subkategorijų';
$string['redoesofthisquestion'] = 'Kiti klausimų bandymai čia: {$a}';
$string['redoquestion'] = 'Bandyti kitą klausimą kaip šį';
$string['regrade'] = 'Iš naujo vertinti visus bandymus';
$string['regradecomplete'] = 'Visi bandymai įvertinti iš naujo';
$string['regradecount'] = '{$a->changed} iš {$a->attempt} įvertinimų buvo pakeisti (-a)';
$string['regradedisplayexplanation'] = 'Bandymai, kurie pasikeičia iš naujo vertinant, rodomi kaip hipersaitai su klausimų peržiūros langu';
$string['regradenotallowed'] = 'Neturite teisės iš naujo vertinti šio testo';
$string['regradingquestion'] = 'Iš naujo vertinamas {$a}.';
$string['regradingquiz'] = 'Iš naujo vertinamas testas {$a}';
$string['remove'] = 'Šalinti';
$string['removeallgroupoverrides'] = 'Visus grupės keitimai';
$string['removeallquizattempts'] = 'Visi testo bandymai';
$string['removealluseroverrides'] = 'Visus naudotojo keitimai';
$string['removeemptypage'] = 'Šalinti tuščią puslapį';
$string['removepagebreak'] = 'Pašalinti puslapio lūžį';
$string['removeselected'] = 'Šalinti pasirinktus';
$string['rename'] = 'Pervadinti';
$string['renderingserverconnectfailed'] = 'Serveriui nepavyko apdoroti {$a} RQP užklausos. Patikrinkite, ar URL teisingas.';
$string['reopenattempt'] = 'Atidaryti iš naujo';
$string['reopenattemptareyousuremessage'] = 'Tai iš naujo atidarys {$a->attemptnumber} bandymą, kurį atliko {$a->attemptuser}.';
$string['reopenattemptareyousuretitle'] = 'Atidaryti bandymą iš naujo?';
$string['reopenattemptwrongstate'] = 'Bandymas {$a->attemptid} yra netinkamos būsenos ({$a->state}), kad jį būtų galima atidaryti iš naujo.';
$string['reopenedattemptwillbeinprogress'] = 'Bandymas liks atviras ir gali būti tęsiamas.';
$string['reopenedattemptwillbeinprogressuntil'] = 'Bandymas liks atviras ir gali būti tęsiamas iki testas pasibaigs {$a}.';
$string['reopenedattemptwillbesubmitted'] = 'Bandymas bus nedelsiant pateiktas vertinimui.';
$string['reorderquestions'] = 'Keisti klausimų tvarką';
$string['reordertool'] = 'Rodyti tvarkos keitimo įrankį';
$string['repaginate'] = 'Perpuslapiuoti rodant {$a} klausimus (-ų) kiekviename puslapyje';
$string['repaginatecommand'] = 'Perpuslapiuoti';
$string['repaginatenow'] = 'Perpuslapiuoti dabar';
$string['replace'] = 'Keisti';
$string['replacementoptions'] = 'Keitimo parinktys';
$string['report'] = 'Ataskaitos';
$string['reportanalysis'] = 'Elementų analizė';
$string['reportattemptsfrom'] = 'Bandymus';
$string['reportattemptsthatare'] = 'Bandymus, kurie';
$string['reportdisplayoptions'] = 'Rodyti parinktis';
$string['reportfullstat'] = 'Išsamūs statistiniai duomenys';
$string['reportmulti_percent'] = 'Daugiaprocentiniai';
$string['reportmulti_q_x_student'] = 'Kelių besimokančiųjų pasirinkimai';
$string['reportmulti_resp'] = 'Individualūs atsakymai';
$string['reportmustselectstate'] = 'Turite pasirinkti nors vieną';
$string['reportnotfound'] = 'Ataskaita nežinoma ({$a})';
$string['reportoverview'] = 'Apžvalga';
$string['reportregrade'] = 'Iš naujo vertinti bandymus';
$string['reportresponses'] = 'Išsamūs atsakymai';
$string['reports'] = 'Ataskaitos';
$string['reportshowonly'] = 'Rodyti tik bandymus';
$string['reportshowonlyfinished'] = 'Rodyti ne daugiau, kaip vieną naudotojo užbaigtą bandymą ({$a})';
$string['reportsimplestat'] = 'Paprasti statistiniai duomenys';
$string['reportusersall'] = 'visų naudotojų, kurie atlikinėjo testą';
$string['reportuserswith'] = 'registruotų naudotojų, kurie atlikinėjo testą';
$string['reportuserswithorwithout'] = 'registruotų naudotojų, kurie bandė arba ne, atlikti testą';
$string['reportuserswithout'] = 'registruotų naudotojų neatlikusių testo';
$string['reportwhattoinclude'] = 'Ką įtraukti į ataskaitą';
$string['requirepassword'] = 'Reikalauti slaptažodžio';
$string['requirepassword_help'] = 'Jei slaptažodis nurodytas, besimokantysis turi jį įvesti prieš bandydamas atlikti testą.';
$string['requiresubnet'] = 'Reikalauti tinklo adreso';
$string['requiresubnet_help'] = 'Testo prieigą galima apriboti iki tam tikrų LAN arba interneto potinklių nurodant kableliais atskirtų dalinių arba visų IP adresų numerių sąrašą. Tai gali būti naudinga atliekant stebimąjį (prižiūrimą) testą, kai norima užtikrinti, kad prie testo galės prieiti tik tam tikroje vietoje esantys žmonės.';
$string['response'] = 'Atsakymas';
$string['responses'] = 'Atsakymai';
$string['results'] = 'Rezultatai';
$string['returnattempt'] = 'Grįžti atgal';
$string['reuseifpossible'] = 'pakartotinai naudoti pašalintą anksčiau';
$string['reverttodefaults'] = 'Atkurti numatytąsias testo reikšmes';
$string['review'] = 'Peržiūrėti';
$string['reviewafter'] = 'Leisti peržiūrėti uždarius testą';
$string['reviewalways'] = 'Leisti peržiūrėti bet kada';
$string['reviewattempt'] = 'Peržiūrėti bandymą';
$string['reviewbefore'] = 'Leisti peržiūrėti, kol testas atidarytas';
$string['reviewclosed'] = 'Uždarius testą';
$string['reviewduring'] = 'Bandymo metu';
$string['reviewimmediately'] = 'Iš karto po bandymo';
$string['reviewnever'] = 'Niekada neleisti peržiūrėti';
$string['reviewofquestion'] = 'Klausimo {$a->question} apžvalga {$a->quiz} teste naudotojo {$a->user}';
$string['reviewopen'] = 'Vėliau, kol testas dar vis atidarytas';
$string['reviewoptions'] = 'Besimokantieji gali peržiūrėti';
$string['reviewoptionsheading'] = 'Peržiūros parinktys';
$string['reviewoptionsheading_help'] = 'Šios parinktys valdo, kokią informaciją besimokantieji gali matyti peržiūrėdami bandymą atlikti testą arba testo ataskaitas.

**Bandymo metu** parametrai yra svarbus tik tam tikrai elgesenai,  kaip \'sąveikajauntis su keliais bandymais\', kuris gali rodyti atsiliepimus bandymo metu.

**Iškart po bandymo** nustatymai taikomi tik pirmąsias dvi minutes po \'Pateikti viską ir baigti\' paspaudimo.

**Vėliau, kol testas  vis dar atidarytas** nustatymai taikomi po to ir iki testo uždarymo datos.

**Uždarius testą** nustatymai taikomi po testo uždarymo datos.  Jei testas neturi uždarymo būsenos, ši būsena niekada nepasiekiama.';
$string['reviewoverallfeedback'] = 'Galutinis apibendrinimas';
$string['reviewoverallfeedback_help'] = 'Šis apibendrinimas yra pateikiamas pasibaigus bandymui ir priklauso nuo besimokančiojo galutinio įvertinimo.';
$string['reviewresponse'] = 'Peržiūrėti atsakymą';
$string['reviewresponsetoq'] = 'Peržiūrėti atsakymą (klausimas {$a})';
$string['reviewthisattempt'] = 'Peržiūrėti savo atsakymus šiam bandymui';
$string['rqp'] = 'Nuotolinis klausimas';
$string['rqps'] = 'Nuotoliniai klausimai';
$string['sameasoverall'] = 'Taip pat, kaip bendriems įvertinimams';
$string['save'] = 'Įrašyti';
$string['saveandedit'] = 'Įrašyti pakeitimus ir redaguoti klausimus';
$string['saveattemptfailed'] = 'Nepavyko įrašyti dabartinio bandymo atlikti testą.';
$string['savedfromdeletedcourse'] = 'Įrašyta iš panaikintų kursų {$a}';
$string['savegrades'] = 'Išsaugoti įvertinimus';
$string['savemyanswers'] = 'Įrašyti mano atsakymus';
$string['savenosubmit'] = 'Įrašyti nepateikus';
$string['saveoverrideandstay'] = 'Įrašyti ir įvesti kitą keitimą';
$string['savequiz'] = 'Įrašyti visą šį testą';
$string['saving'] = 'Saugoma';
$string['savingnewgradeforquestion'] = 'Saugomas naujas įvertinimas už klausimą ({a}).';
$string['savingnewmaximumgrade'] = 'Saugomas maksimalus įvertinimas.';
$string['score'] = 'Neapdorotas balas';
$string['scores'] = 'Balai';
$string['search:activity'] = 'Testas - veiklos informacija';
$string['searchbyname'] = 'Paieška pagal vardą...';
$string['sectionheadingedit'] = 'Redaguoti antraštę \'{$a}\'';
$string['sectionheadingremove'] = 'Pašalinti antraštę \'{$a}\'';
$string['sectionnoname'] = 'Skyrius be pavadinimo';
$string['seequestions'] = '(Pamatyti klausimus)';
$string['select'] = 'Pasirinkti';
$string['selectall'] = 'Pasirinkti viską';
$string['selectattempt'] = 'Pasirinkti bandymą';
$string['selectcategory'] = 'Pasirinkti kategoriją';
$string['selectedattempts'] = 'Pasirinkti bandymai...';
$string['selectmultipleitems'] = 'Pasirinkti kelis elementus';
$string['selectmultipletoolbar'] = 'Pasirinkti kelias įrankių juostas';
$string['selectnone'] = 'Naikinti visų žymėjimą';
$string['selectquestionbank'] = 'Pasirinkti klausimų banką';
$string['selectquestionslot'] = 'Pasirinkti klausimą {$a}';
$string['selectquestiontype'] = '-- Pasirinkti klausimo tipą --';
$string['sendnotificationopendatesoon'] = 'Pranešti naudotojui apie artėjančią testo atidarymo datą';
$string['serveradded'] = 'Serveris įtrauktas';
$string['serveridentifier'] = 'Identifikatorius';
$string['serverinfo'] = 'Serverio informacija';
$string['servers'] = 'Serveriai';
$string['serverurl'] = 'Serverio URL';
$string['shortanswer'] = 'Trumpas atsakymas';
$string['show'] = 'Rodyti';
$string['showall'] = 'Rodyti visus klausimus viename puslapyje';
$string['showblocks'] = 'Rodyti blokus atliekant testą';
$string['showblocks_help'] = 'Jei parinkta taip, tada standartiniai blokai bus rodomi testo bandymų metu';
$string['showbreaks'] = 'Rodyti puslapio lūžius';
$string['showcategorycontents'] = 'Rodyti kategorijos turinį {$a->arrow}';
$string['showcorrectanswer'] = 'Ar atsiliepime rodyti teisingus atsakymus?';
$string['showdetailedmarks'] = 'Rodyti išsamią pažymio informaciją';
$string['showeachpage'] = 'Tuo pat metu rodyti tik vieną puslapį';
$string['showfeedback'] = 'Ar atsakius rodyti atsiliepimą?';
$string['showinsecurepopup'] = 'Bandant atlikti testą naudoti „saugų“ iššokantįjį langą';
$string['showlargeimage'] = 'Didelis paveiksliukas';
$string['shownoattempts'] = 'Rodyti besimokančiuojus, nebandžiusius atlikti testo';
$string['shownoattemptsonly'] = 'Rodyti tik besimokančiuojus, nebandžiusius atlikti testo';
$string['shownoimage'] = 'Nėra paveiksliuko';
$string['showreport'] = 'Rodyti ataskaitą';
$string['showsmallimage'] = 'Mažas paveikslėlis';
$string['showteacherattempts'] = 'Rodyti dėstytojo bandymus atlikti testą';
$string['showuserpicture'] = 'Rodyti naudotojo nuotrauką';
$string['showuserpicture_help'] = 'Jei įjungta, besimokančiojo vardas ir nuotrauka bus rodomi ekrane bandant atlikti testą ir peržiūros lange, kad būtų lengviau patikrinti, ar besimokantysis pats prisijungė prie stebimo (prižiūrimo) egzamino.';
$string['shuffle'] = 'Maišyti';
$string['shuffleanswers'] = 'Maišyti atsakymus';
$string['shuffledrandomly'] = 'Maišyti atsitiktine tvarka';
$string['shufflequestions'] = 'Maišyti';
$string['shufflequestions_help'] = 'Jei įjungta, kiekvieną kartą, kai bandoma atlikti testą, klausimų tvarka šioje skiltyje bus sumaišyta į kitą atsitiktinę tvarką.

Dėl to besimokantiesiems gali būti sunkiau dalytis atsakymais, tačiau taip pat bus sunkiau aptarti konkretų klausimą su besimokančiuoju.';
$string['shufflewithin'] = 'Maišyti klausimuose';
$string['shufflewithin_help'] = 'Jei įjungta, kiekvieną klausimą sudarančios dalys bus atsitiktine tvarka maišomos kas kartą, kai besimokantysis bandys atlikti testą, jei ši parinktis taip pat įjungta klausimo parametruose. Šis parametras taikomas tik klausimams, sudarytiems iš kelių dalių, pvz., klausimams su keliais pasirinktiniais atsakymais arba atitikimo klausimams.';
$string['singleanswer'] = 'Pasirinkite vieną atsakymą.';
$string['sortage'] = 'Rūšiuoti pagal amžių';
$string['sortalpha'] = 'Rikiuoti pagal pavadinimą';
$string['sortquestionsbyx'] = 'Rūšiuoti klausimus pagal: {$a}';
$string['sortsubmit'] = 'Rūšiuoti klausimus';
$string['sorttypealpha'] = 'Rūšiuoti pagal tipą, pavadinimą';
$string['specificapathnotonquestion'] = 'Nurodyto failo kelio nėra nurodytame klausime';
$string['specificquestionnotonquiz'] = 'Nurodyto klausimo nėra nurodytame teste';
$string['startagain'] = 'Pradėti dar kartą';
$string['startattempt'] = 'Pradėti bandymą';
$string['startedon'] = 'Pradėta';
$string['startnewpreview'] = 'Pradėti naują peržiūrą';
$string['stateabandoned'] = 'Dar nepateikti';
$string['statefinished'] = 'Baigtas';
$string['statefinisheddetails'] = 'Registruota {$a}';
$string['stateinprogress'] = 'Nebaigta';
$string['statenotloaded'] = 'Klausimo {$a} būsena neįkelta iš duomenų bazės';
$string['stateoverdue'] = 'Pavėluota';
$string['stateoverduedetails'] = 'Turi būti pateiktas {$a}';
$string['status'] = 'Būsena';
$string['stoponerror'] = 'Stabdyti įvykus klaidai';
$string['submission_confirmation'] = 'Pateikti visus atsakymus ir baigti?';
$string['submission_confirmation_unanswered'] = 'Neatsakyti klausimai: {$a}';
$string['submitallandfinish'] = 'Pateikti viską ir baigti';
$string['subneterror'] = 'Apgailestaujame, šis testas užrakintas, todėl jį galima pasiekti tik iš tam tikrų vietų. Šiuo metu jūsų kompiuteris nėra vienas iš kompiuterių, kuriuos leidžiama naudoti norint atlikti šį testą.';
$string['subnetnotice'] = 'Šis testas užrakintas, todėl jį galima pasiekti tik iš tam tikrų vietų. Jūsų kompiuteris nėra leistiname potinklyje. Kaip dėstytojui jums vis tiek leidžiama peržiūrėti.';
$string['subplugintype_quiz'] = 'Ataskaita';
$string['subplugintype_quiz_plural'] = 'Ataskaitos';
$string['subplugintype_quizaccess'] = 'Priėjimo taisyklė';
$string['subplugintype_quizaccess_plural'] = 'Priėjimo taisyklės';
$string['substitutedby'] = 'Bus pakeista';
$string['summaryofattempt'] = 'Bandymo suvestinė';
$string['summaryofattempts'] = 'Jūsų bandymai';
$string['temporaryblocked'] = 'Jums laikinai neleidžiama iš naujo bandyti atlikti testo.<br /> Kitą kartą galėsite bandyti:';
$string['theattempt'] = 'Bandymas';
$string['theattempt_help'] = 'Ar besimokantysis gali peržiūrėti bandymą.';
$string['time'] = 'Laikas';
$string['timecompleted'] = 'Užbaigta';
$string['timedelay'] = 'Jums neleidžiama atlikti testo, nes dar nepraėjo atidėjimo laikotarpis, kuris turi praeiti prieš bandant atlikti kitą testą';
$string['timeleft'] = 'Likęs laikas';
$string['timelimit'] = 'Laiko limitas';
$string['timelimit_help'] = 'Jei įjungta, laiko limitas nurodomas pradiniame testo puslapyje, o atgalinio skaičiavimo laikmatis rodomas testo navigacijos bloke.';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Apgailestaujame! Testo laiko limitas viršytas!';
$string['timestr'] = '%H:%M:%S, %d/%m/%y';
$string['timesup'] = 'Laikas baigėsi!';
$string['timing'] = 'Laikas';
$string['tofile'] = 'į failą';
$string['tolerance'] = 'Nuokrypis';
$string['toomanyrandom'] = 'Būtinas atsitiktinių klausimų skaičius yra didesnis nei vis dar yra kategorijoje!';
$string['top'] = 'Viršus';
$string['totalmarks'] = 'Iš viso balų';
$string['totalmarksx'] = 'Balų suma: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Kategorijoje esančių {$a} klausimų suma.';
$string['true'] = 'Tiesa';
$string['truefalse'] = 'Tiesa / Netiesa';
$string['type'] = 'Tipas';
$string['unfinished'] = 'atidaryta';
$string['ungraded'] = 'Neįvertinta';
$string['unit'] = 'Vienetai';
$string['unknowntype'] = 'Klausimo tipas nepalaikomas eilutėje {$a}. Klausimo bus nepaisoma';
$string['updatefilterconditon'] = 'Atnaujinti filtro sąlygas';
$string['updatefilterconditon_success'] = 'Filtro sąlygos sėkmingai atnaujintos';
$string['updateoverdueattemptstask'] = 'Atnaujinami pavėluoti bandymai atlikti testą';
$string['updatequizslotswithrandomxofy'] = 'Atnaujinamos testo nustatytos vietos su atsitiktinių klausimų duomenimis ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Atnaujinti testo parametrus';
$string['updatingatttemptgrades'] = 'Atnaujinami bandymo pažymiai.';
$string['updatingfinalgrades'] = 'Atnaujinami galutiniai pažymiai.';
$string['updatingthegradebook'] = 'Atnaujinama pažymių knygelė.';
$string['upgradesure'] = '<div>Testo modulis atliks išsamų testų lentelių pakeitimą, o šis versijos atnaujinimas dar nepakankamai patikrintas. Primygtinai rekomenduojame prieš tęsiant sukurti savo duomenų bazės lentelių kopijas.</div>';
$string['upgradingquizattempts'] = 'Atnaujinami testų bandymai: testas {$a->done}/{$a->outof} (Testo id {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Atnaujinami labai seni testo bandymai:{$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Ši kategorija išsaugota ir perkelta į svetainės lygį, nes tai publikuota kategorija, kurią dar vis naudoja kiti kursai.';
$string['useroverrides'] = 'Naudotojo keitimai';
$string['useroverridesdeleted'] = 'Naudotojo keitimai ištrinti';
$string['usersnone'] = 'Jokie besimokantieji neturi prieigos prie šio testo';
$string['validate'] = 'Tikrinti';
$string['viewallanswers'] = 'Peržiūrėti {$a} bandymus (-ų) atlikti testą';
$string['viewallreports'] = 'Peržiūrėti {$a} bandymų ataskaitas';
$string['viewed'] = 'Peržiūrėtas';
$string['warningmissingtype'] = '<b>Šis klausimas yra tipo, kuris dar neįdiegtas jūsų „Moodle“.<br />Įspėkite savo „Moodle“ administratorių.</b>';
$string['wheregrade'] = 'Kur mano įvertinimas?';
$string['wildcard'] = 'Pakaitos simbolis';
$string['windowclosing'] = 'Šis langas netrukus užsidarys.';
$string['withsummary'] = 'su suvestinės statistiniais duomenimis';
$string['wronguse'] = 'Šio puslapio negalite naudoti tokiu būdu';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Turite įsiregistruoti į šį kursą, kad galėtumėte bandyti atlikti šį testą';
$string['yourfinalgradeis'] = 'Jūsų galutinis šio testo įvertinimas yra {$a}.';
