<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_azureai', language 'ja', version '5.1'.
 *
 * @package     aiprovider_azureai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:explain_text:apiversion'] = 'APIバージョン';
$string['action:explain_text:deployment'] = 'デプロイメントID';
$string['action:explain_text:deployment_help'] = 'プロバイダがこのアクションに使用するAPIエンドポイントに関連するデプロイメントIDです。';
$string['action:explain_text:systeminstruction'] = 'システムインストラクション';
$string['action:explain_text:systeminstruction_help'] = 'このインストラクションはユーザのプロンプトとともにAIモデルに送信されます。どうしても必要な場合を除き、このインストラクションの編集は推奨されません。';
$string['action:generate_image:apiversion'] = 'APIバージョン';
$string['action:generate_image:deployment'] = 'デプロイメントID';
$string['action:generate_image:deployment_help'] = 'プロバイダがこのアクションに使用するAPIエンドポイントに関連するデプロイメントIDです。';
$string['action:generate_text:apiversion'] = 'APIバージョン';
$string['action:generate_text:deployment'] = 'デプロイメントID';
$string['action:generate_text:deployment_help'] = 'プロバイダがこのアクションに使用するAPIエンドポイントに関連するデプロイメントIDです。';
$string['action:generate_text:systeminstruction'] = 'システムインストラクション';
$string['action:generate_text:systeminstruction_help'] = 'このインストラクションはユーザのプロンプトとともにAIモデルに送信されます。どうしても必要な場合を除き、このインストラクションの編集は推奨できません。';
$string['action:summarise_text:apiversion'] = 'APIバージョン';
$string['action:summarise_text:deployment'] = 'デプロイメントID';
$string['action:summarise_text:deployment_help'] = 'プロバイダがこのアクションに使用するAPIエンドポイントに関連するデプロイメントIDです。';
$string['action:summarise_text:systeminstruction'] = 'システムインストラクション';
$string['action:summarise_text:systeminstruction_help'] = 'このインストラクションはユーザのプロンプトとともにAIモデルに送信されます。どうしても必要な場合を除き、このインストラクションの編集は推奨できません。';
$string['action_apiversion'] = 'APIバージョン';
$string['action_deployment'] = 'デプロイメントID';
$string['action_deployment_desc'] = 'プロバイダがこのアクションに使用するAPIエンドポイントに関連するデプロイメントIDです。';
$string['action_systeminstruction'] = 'システムインストラクション';
$string['action_systeminstruction_desc'] = 'このインストラクションはユーザのプロンプトとともにAIモデルに送信されます。どうしても必要な場合を除き、このインストラクションの編集は推奨できません。';
$string['apikey'] = 'Azure AI APIキー';
$string['apikey_desc'] = 'Azure AI APIキーを入力してください。';
$string['apikey_help'] = 'あなたのAzure AI APIキーを入力してください。';
$string['deployment'] = 'Azure AI APIデプロイメント名';
$string['deployment_desc'] = 'Azure AI APIのデプロイメント名を入力してください。';
$string['enableglobalratelimit'] = 'サイト全体のレート制限を設定する';
$string['enableglobalratelimit_desc'] = 'Azure AI APIプロバイダが1時間ごとにサイト全体で受信できるリクエスト数を制限します。';
$string['enableuserratelimit'] = 'ユーザレート制限を設定する';
$string['enableuserratelimit_desc'] = 'それぞれのユーザがAzure AI APIプロバイダに対して1時間ごとに実行できるリクエスト数を制限します。';
$string['endpoint'] = 'Azure AI APIエンドポイント';
$string['endpoint_desc'] = 'Azure AI APIのエンドポイントURLを以下の形式で入力してください: https://YOUR_RESOURCE_NAME.azureai.azure.com/azureai/deployments';
$string['endpoint_help'] = 'あなたのAzure AI APIのエンドポイントURLを次の形式で入力してください: https://YOUR_RESOURCE_NAME.openai.azure.com';
$string['globalratelimit'] = 'サイト全体の最大リクエスト数';
$string['globalratelimit_desc'] = '1時間に許可されるサイト全体のリクエスト数です。';
$string['pluginname'] = 'Azure AI APIプロバイダ';
$string['privacy:metadata'] = 'Azure AI APIプロバイダはいかなる個人データも保存しません。';
$string['privacy:metadata:aiprovider_azureai:externalpurpose'] = 'この情報はレスポンスを生成するためにAzure APIに送信されます。あなたのAzure AIアカウント設定によりMicrosoftがこのデータを保存および保持する方法が変更される場合があります。このプラグインによりユーザデータが明示的にMicrosoftに送信されたり、Moodle LMSに保存されることはありません。';
$string['privacy:metadata:aiprovider_azureai:model'] = 'レスポンスの生成に使用されたモデルです。';
$string['privacy:metadata:aiprovider_azureai:numberimages'] = '画像を生成する場合のレスポンスに使用される画像数です。';
$string['privacy:metadata:aiprovider_azureai:prompttext'] = 'レスポンスを生成するためにユーザが入力したテキストプロンプトです。';
$string['privacy:metadata:aiprovider_azureai:responseformat'] = '画像を生成する場合のレスポンスのフォーマットです。';
$string['userratelimit'] = 'ユーザあたりの最大リクエスト数';
$string['userratelimit_desc'] = 'ユーザごとに1時間に許可されるリクエスト数です。';
