<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'id', version '5.1'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'akan dipasang';
$string['accept'] = 'Terima';
$string['action'] = 'Tindakan';
$string['actionchoice'] = 'Apa yang ingin Anda lakukan dengan berkas \'{$a}\'?';
$string['actions'] = 'Tindakan';
$string['actionsfor'] = 'Tindakan untuk {$a}';
$string['actionsmenu'] = 'Menu tindakan';
$string['active'] = 'Aktif';
$string['activeusers'] = 'Pengguna aktif';
$string['activities'] = 'Aktivitas';
$string['activities_help'] = 'Aktivitas seperti forum, kuis dan wiki, memungkinkan konten interaktif yang akan ditambahkan ke kursus.';
$string['activity'] = 'Aktivitas';
$string['activityclipboard'] = 'Memindahkan aktivitas ini: {$a}';
$string['activityheader'] = 'Menu aktivitas';
$string['activityicon'] = 'ikon {$a}';
$string['activityiscurrentlyhidden'] = 'Maaf, aktivitas ini saat ini disembunyikan';
$string['activitymodule'] = 'Modul aktivitas';
$string['activitymodules'] = 'Modul aktivitas';
$string['activitynotready'] = 'Aktivitas belum siap';
$string['activityorresource'] = 'Aktivitas atau sumber daya';
$string['activityreport'] = 'Laporan aktivitas';
$string['activityreports'] = 'Laporan aktivitas';
$string['activityselect'] = 'Pilih aktivitas ini untuk dipindahkan ke tempat lain';
$string['activitysince'] = 'Aktivitas sejak {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Aktivitas tiap pengguna';
$string['add'] = 'Tambahkan';
$string['addactivity'] = 'Tambahkan aktivitas...';
$string['addactivitytosection'] = 'Tambahkan aktivitas ke bagian \'{$a}\'';
$string['addadmin'] = 'Tambahkan admin';
$string['addblock'] = 'Tambahkan blok';
$string['addcomment'] = 'Tambahkan komentar...';
$string['addcondition'] = 'Tambah kondisi';
$string['addcontent'] = 'Tambahkan konten';
$string['addcountertousername'] = 'Membuat pengguna dengan menambahkan nomor ke nama pengguna';
$string['addcreator'] = 'Tambahkan pembuat kursus';
$string['adddots'] = 'Tambahkan...';
$string['added'] = '{$a} ditambahkan';
$string['addedtogroup'] = 'Menambahkan ke grup "{$a}"';
$string['addedtogroupnot'] = 'Batal menambahkan ke grup "{$a}"';
$string['addedtogroupnotenrolled'] = 'Tidak ditambahkan pada grup "{$a}", sebab tidak terdaftar pada kursus';
$string['addfilehere'] = 'Letakkan berkas di sini untuk menambahkannya di bagian bawah bagian ini';
$string['addfilesdrop'] = 'Anda dapat menarik dan melepas berkas di sini untuk diunggah atau klik untuk memilih.';
$string['addinganew'] = '{$a} baru';
$string['addingdatatoexisting'] = 'Ubah data yang telah ada.';
$string['additionalcustomnav'] = 'Navigasi kustom tambahan';
$string['additionalnames'] = 'Nama tambahan';
$string['addlinkhere'] = 'Tambahkan tautan di sini';
$string['addnew'] = 'Tambahkan {$a} yang baru';
$string['addnewcategory'] = 'Tambahkan kategori baru';
$string['addnewcourse'] = 'Tambahkan kursus baru';
$string['addnewuser'] = 'Tambahkan pengguna baru';
$string['addnousersrecip'] = 'Tambahkan pengguna yang belum mendapatkan akses {$a} ke daftar penerima';
$string['addpagehere'] = 'Tambahkan teks di sini';
$string['addresource'] = 'Tambahkan sumber ...';
$string['addresourceoractivity'] = 'Tambahkan aktivitas atau sumber';
$string['addresourcetosection'] = 'Tambahkan sumber pada bagian \'{$a}\'';
$string['address'] = 'Alamat';
$string['addsections'] = 'Tambahkan bagian';
$string['addstudent'] = 'Tambahkan siswa';
$string['addsubcategory'] = 'Tambahkan subkategori';
$string['addteacher'] = 'Tambahkan pengajar';
$string['admin'] = 'Admin';
$string['adminhelpaddnewuser'] = 'Tambahkan pengguna baru secara manual';
$string['adminhelpassignadmins'] = 'Admin dapat melakukan apa pun dan dapat berada di semua tempat di situs';
$string['adminhelpassigncreators'] = 'Pembuat kursus dapat sekaligus menjadi pengajar';
$string['adminhelpassignsiteroles'] = 'Terapkan peran di situs yang sudah didefinisikan pada pengguna tertentu';
$string['adminhelpassignstudents'] = 'Masuki kursus dan tambahkan siswa melalui menu admin';
$string['adminhelpauthentication'] = 'Anda dapat menggunakan basis data pemakai internal atau basis data pemakai eksternal';
$string['adminhelpbackup'] = 'Mengatur pencadangan otomatis serta penjadwalannya';
$string['adminhelpconfiguration'] = 'Mengatur tampilan situs dan cara kerjanya';
$string['adminhelpconfigvariables'] = 'Mengatur variabel yang memengaruhi pengoperasian situs secara umum';
$string['adminhelpcourses'] = 'Menentukan kursus dan kategorinya serta penugasan orang-orangnya, edit kursus yang ditangguhkan';
$string['adminhelpeditorsettings'] = 'Definisikan setelan dasar untuk editor HTML';
$string['adminhelpedituser'] = 'Lihat daftar akun anggota dan edit data mereka';
$string['adminhelpenvironment'] = 'Periksa kondisi server Anda apakah sesuai dengan persyaratan instalasi saat ini dan akan datang';
$string['adminhelpfailurelogs'] = 'Telusur log dari login yang gagal';
$string['adminhelplanguage'] = 'Untuk memeriksa dan mengedit paket bahasa sekarang';
$string['adminhelplogs'] = 'Melihat log semua semua catatan pada situs ini';
$string['adminhelpmanageblocks'] = 'Atus blok terpasang dan setelannya';
$string['adminhelpmanagedatabase'] = 'Akses basis data secara langsung (hati-hati)';
$string['adminhelpmanagefilters'] = 'Pilih filter teks dan setelan terkait';
$string['adminhelpmanagemodules'] = 'Kelola modul terpasang dan setelannya';
$string['adminhelpmanageroles'] = 'Membuat dan menentukan peran yang dapat diterapkan pada pengguna';
$string['adminhelpmymoodle'] = 'Atur blok Moodle Saya untuk para pengguna';
$string['adminhelpreports'] = 'Laporan Tingkat Situs';
$string['adminhelpsitefiles'] = 'Untuk menerbitkan berkas umum atau unggah cadangan eksternal';
$string['adminhelpsitesettings'] = 'Tentukan tampilan halaman beranda situs';
$string['adminhelpstickyblocks'] = 'Konfigurasikan blok melekat pada keseluruhan Moodle';
$string['adminhelpthemes'] = 'Pilih tampilan situs (huruf, warna, dll.)';
$string['adminhelpuploadusers'] = 'Impor pengguna baru dari berkas teks';
$string['adminhelpusers'] = 'Tentukan pengguna dan atur autentikasi';
$string['adminhelpxmldbeditor'] = 'Antarmuka untuk mengedit berkas XMLDB. Hanya untuk para pengembang.';
$string['administration'] = 'Administrasi';
$string['administrationsite'] = 'Administrasi situs';
$string['administrator'] = 'Administrator';
$string['administratordescription'] = 'Administrator dapat melakukan apapun di situs ini dan di semua kursus.';
$string['administrators'] = 'Administrator';
$string['administratorsall'] = 'Semua Administrator';
$string['administratorsandteachers'] = 'Administrator dan pengajar';
$string['advanced'] = 'Lanjutan';
$string['advancedfilter'] = 'Pencarian lanjutan';
$string['advancedsettings'] = 'Setelan lanjutan';
$string['afterresource'] = 'Setelah sumber "{$a}"';
$string['aftersection'] = 'Setelah bagian "{$a}"';
$string['again'] = 'lagi';
$string['agelocationverification'] = 'Verifikasi usia dan lokasi';
$string['ajaxuse'] = 'AJAX dan Javascript';
$string['all'] = 'Semua';
$string['allactions'] = 'Semua aksi';
$string['allactivities'] = 'Semua aktivitas';
$string['allcategories'] = 'Semua Kategori';
$string['allchanges'] = 'Semua perubahan';
$string['alldays'] = 'Sepanjang hari';
$string['allfiles'] = 'Semua berkas';
$string['allgroups'] = 'Semua grup';
$string['alllogs'] = 'Semua catatan';
$string['allmods'] = 'Semua {$a}';
$string['allow'] = 'Izinkan';
$string['allowinternal'] = 'Izinkan metode internal';
$string['allownone'] = 'Tidak mengizinkan apapun';
$string['allownot'] = 'Tidak diizinkan';
$string['allowstealthmodules'] = 'Izinkan aktivitas tersembunyi';
$string['allowstealthmodules_help'] = 'Jika diaktifkan, aktivitas dapat tersedia tetapi tidak ditampilkan di bagian yang terlihat dari halaman kursus. Jika demikian, tautan ke aktivitas tersembunyi harus disediakan dari tempat lain, seperti dari sumber halaman. Aktivitas Tersembunyi masih terdaftar di buku nilai dan laporan lainnya.';
$string['allparticipants'] = 'Semua peserta';
$string['allteachers'] = 'Semua pengajar';
$string['alphanumerical'] = 'Hanya dapat berisi karakter alfanumerik, tanda hubung (-) atau titik(.)';
$string['alreadyconfirmed'] = 'Pendaftaran telah dikonfirmasikan';
$string['alternatename'] = 'Nama alternatif';
$string['always'] = 'Selalu';
$string['and'] = '{$a->one} dan {$a->two}';
$string['answer'] = 'Jawaban';
$string['any'] = 'Setiap';
$string['appearance'] = 'Tampilan';
$string['apply'] = 'Terapkan';
$string['applyfilters'] = 'Terapkan filter';
$string['approve'] = 'Setuju';
$string['areyousure'] = 'Anda yakin?';
$string['areyousuretorestorethis'] = 'Anda ingin lanjutkan?';
$string['areyousuretorestorethisinfo'] = 'Selanjutnya pada proses ini Anda memiliki pilihan untuk menambahkan cadangan pada kursus yang ada atau menciptakan kursus yang sepenuhnya baru.';
$string['asc'] = 'Urut naik';
$string['assessment'] = 'Penilaian';
$string['assignadmins'] = 'Penugasan admin';
$string['assigncreators'] = 'Penugasan pembuat kursus';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Tetapkan peran situs menyeluruh';
$string['authenticateduser'] = 'Pengguna terautentikasi';
$string['authenticateduserdescription'] = 'Semua pengguna yang masuk';
$string['authentication'] = 'Autentikasi';
$string['authenticationplugins'] = 'Pengaya Autentikasi';
$string['autosubscribe'] = 'Otomatis berlangganan forum';
$string['autosubscribeno'] = 'Tidak: Saya tidak ingin berlangganan diskusi forum secara otomatis';
$string['autosubscribeyes'] = 'Ya: saat saya mengirim, daftarkan saya pada forum tersebut.';
$string['availability'] = 'Ketersediaan';
$string['availablecourses'] = 'Kursus yang tersedia';
$string['back'] = 'Kembali';
$string['backto'] = 'Kembali ke {$a}';
$string['backtocourselisting'] = 'Kembali ke daftar kursus';
$string['backtohome'] = 'Kembali ke beranda situs';
$string['backtopageyouwereon'] = 'Kembali ke halaman sebelumnya';
$string['backup'] = 'Cadangan';
$string['backupactivehelp'] = 'Pilih ya atau tidak untuk melakukan pencadangan secara otomatis';
$string['backupadhocpending'] = 'Pencadangan kursus tak terjadwal ditunda';
$string['backupcancelled'] = 'Pencadangan dibatalkan';
$string['backupcoursefileshelp'] = 'Jika diaktifkan maka berkas kursus akan dimasukkan ke pencadangan otomatis';
$string['backupdate'] = 'Tanggal pencadangan';
$string['backupdatenew'] = '&nbsp; {$a->TAG} is now {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} dulu adalah {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Detail pencadangan';
$string['backuperrorinvaliddestination'] = 'Direktori tujuan pencadangan tidak ada atau tidak dapat ditulis.';
$string['backupexecuteathelp'] = 'Pilih waktu dijalankannya pencadangan otomatis.';
$string['backupfailed'] = 'Beberapa kursus Anda tidak disimpan.';
$string['backupfilename'] = 'cadangan';
$string['backupfinished'] = 'Pencadangan berhasil';
$string['backupfromthissite'] = 'Pencadangan sudah dibuat di situs ini?';
$string['backupgradebookhistoryhelp'] = 'Jika diaktifkan, riwayat buku nilai akan disertakan dalam cadangan otomatis. Perhatikan bahwa riwayat penilaian tidak boleh dinonaktifkan di setelan server (nonaktifkan riwayat versi) agar ini berfungsi';
$string['backupincludemoduleshelp'] = 'Pilih apakah Anda ingin memasukkan modul kursus, dengan atau tanpa data pemakai, pada pencadangan otomatis';
$string['backupincludemoduleuserdatahelp'] = 'Pilih apakah Anda ingin memasukkan modul data pengguna dalam pencadangan otomatis.';
$string['backupinfo'] = 'Buat salinan kursus ini, termasuk semua konten dan aktivitas terkini. Anda dapat menggunakan berkas cadangan untuk memulihkan kursus ini.';
$string['backuplogdetailed'] = 'Log eksekusi terperinci';
$string['backuploglaststatus'] = 'Log eksekusi terakhir';
$string['backupmissinguserinfoperms'] = 'Catatan: Cadangan ini tidak berisi data pengguna. aktivitas Latihan dan Lokakarya tidak akan dimasukkan dalam cadangan, karena modul ini tidak kompatibel dengan jenis pencadangan ini.';
$string['backupnext'] = 'Pencadangan berikutnya';
$string['backupnonisowarning'] = 'Peringatan: cadangan ini berasal dari versi non-Unicode Moodle (sebelum 1.6). Jika cadangan ini berisi teks non-ISO-8859-1 maka akan terjadi KERUSAKAN jika anda mencoba untuk mengembalikannya ke versi Unicode Moodle ini. Lihat <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> untuk informasi lebih lanjut tentang bagaimana cara untuk memulihkan cadangan ini secara benar.';
$string['backupnotyetrun'] = 'Pencadangan otomatis tertunda';
$string['backuporiginalname'] = 'Nama cadangan';
$string['backuproleassignments'] = 'Pemberian akses mencadangkan untuk peran berikut';
$string['backupsavetohelp'] = 'Jalur direktori lengkap dimana anda akan menyimpan berkas cadangan';
$string['backupsitefileshelp'] = 'Jika diaktifkan maka berkas situs yang digunakan pada kursus akan dicadangkan juga pada pencadangan otomatis';
$string['backuptakealook'] = 'Harap lihat log cadangan Anda pada: {$a}';
$string['backupuserfileshelp'] = 'Tentukan apakah berkas pengguna (mis. gambar pada profil) juga dimasukkan pada pencadangan otomatis';
$string['backupversion'] = 'Versi pencadangan';
$string['badges'] = 'Lencana';
$string['between'] = 'Di antara';
$string['block'] = 'Blok';
$string['blockconfiga'] = 'Mengkonfigurasi blok {$a}';
$string['blockconfigbad'] = 'Blok ini belum diterapkan dengan benar dan dengan demikian tidak dapat menyediakan antarmuka konfigurasi.';
$string['blocks'] = 'Blok';
$string['blocks_main'] = 'Blok konten utama';
$string['blocks_supplementary'] = 'Blok tambahan';
$string['blocksaddedit'] = 'Tambah/Ubah blok';
$string['blockseditoff'] = 'Matikan pengeditan blok';
$string['blocksediton'] = 'Nyalakan pengeditan blok';
$string['blocksetup'] = 'Setel tabel blok';
$string['blocksuccess'] = '{$a} tabel telah disetel dengan benar';
$string['brief'] = 'Singkat';
$string['bulkactions'] = 'Tindakan massal';
$string['bulkactionselect'] = '{$a} pemilihan tindakan massal';
$string['bulkcancel'] = 'Tutup pengeditan massal';
$string['bulkmovecoursessuccess'] = 'Berhasil memindahkan {$a->courses} ke {$a->category}';
$string['bulkselection'] = '{$a} terpilih';
$string['bycourseorder'] = 'Berdasarkan urutan kursus';
$string['byname'] = 'oleh {$a}';
$string['bypassed'] = 'Dilewatkan';
$string['cachecontrols'] = 'Kontrol singgahan';
$string['calltofeedback'] = 'Pembuat perangkat lunak ini membutuhkan umpan balik Anda.';
$string['calltofeedback_give'] = 'Berikan umpan balik untuk perangkat lunak ini.';
$string['calltofeedback_remind'] = 'ngatkan saya nanti';
$string['cancel'] = 'Batal';
$string['cancelled'] = 'Dibatalkan';
$string['categories'] = 'Kategori kursus';
$string['categoriesandcourses'] = 'Kategori kursus dan kursus';
$string['category'] = 'Kategori';
$string['categoryadded'] = 'Kategori \'{$a}\' telah ditambahkan';
$string['categorybulkaction'] = 'Tindakan massal untuk kategori yang dipilih';
$string['categorycontents'] = 'Subkategori dan kursus';
$string['categorycurrentcontents'] = 'Isi dari {$a}';
$string['categorydeleted'] = 'Kategori \'{$a}\' telah dihapus';
$string['categoryduplicate'] = 'Nama kategori \'{$a}\' telah ada!';
$string['categoryheader'] = 'Menu kategori';
$string['categoryhidden'] = '(tersembunyi)';
$string['categorymodifiedcancel'] = 'Kategori dimodifikasi! Silakan batalkan dan coba lagi.';
$string['categoryname'] = 'Nama kategori';
$string['categorypath'] = 'Jalur kategori';
$string['categorysubcategoryof'] = '{$a->category} - subkategori dari {$a->parentcategory}';
$string['categoryupdated'] = 'Kategori \'{$a}\' telah diperbarui';
$string['changedpassword'] = 'Kata sandi yang diubah';
$string['changepassword'] = 'Ubah kata sandi';
$string['changesmade'] = 'Perubahan dilakukan';
$string['changesmadereallygoaway'] = 'Anda telah membuat perubahan. Apakah Anda yakin ingin berpindah dan kehilangan perubahan Anda?';
$string['changessaved'] = 'Perubahan disimpan';
$string['check'] = 'Periksa';
$string['checkactual'] = 'Aktual';
$string['checkall'] = 'Periksa semu';
$string['checkerror'] = 'Terjadi kesalahan saat mendapatkan hasil pemeriksaan \'{$a}\'. Periksa konsol peramban untuk informasi lebih lanjut.';
$string['checkexpected'] = 'Diharapkan';
$string['checkingbackup'] = 'Memeriksa cadangan';
$string['checkingcourse'] = 'Memeriksa kursus';
$string['checkingforbbexport'] = 'Periksa pengeksporan BlackBoard';
$string['checkinginstances'] = 'Periksa model';
$string['checkingsections'] = 'Periksa bagian';
$string['checklanguage'] = 'Periksa bahasa';
$string['checkloading'] = 'Mendapatkan hasil cek \'{$a}\'';
$string['checknone'] = 'Tidak perlu melakukan pemeriksaan';
$string['checks'] = 'Periksa';
$string['checksok'] = 'Semua \'{$a}\' ceklist benar';
$string['childcoursenotfound'] = 'Kursus anak tidak ditemukan';
$string['childcourses'] = 'Kursus anak';
$string['choose'] = 'Pilih';
$string['choosecourse'] = 'Pilih kursus';
$string['choosedots'] = 'Pilih...';
$string['chooselivelogs'] = 'atau melihat aktivitas saat ini';
$string['chooselogs'] = 'Pilih log mana yang akan dilihat';
$string['choosereportfilter'] = 'Pilih filter untuk laporan';
$string['choosetheme'] = 'Pilih tema';
$string['chooseuser'] = 'Pilih pengguna';
$string['city'] = 'Kota';
$string['cleaningtempdata'] = 'Menghapus data sementara';
$string['clear'] = 'Hapus';
$string['clearall'] = 'Bersihkan semua
';
$string['clearfilterrow'] = 'Hapus baris filter';
$string['clearfilters'] = 'Hapus filter';
$string['clearsearch'] = 'Bersihkan masukan pencarian';
$string['clickhelpiconformoreinfo'] = '... berlanjut ... Klik pada ikon bantuan untuk membaca artikel lengkap';
$string['clickhere'] = 'Klik di sini ...';
$string['clicktohideshow'] = 'Klik untuk memperluas atau menciutkan';
$string['closeblockdrawer'] = 'Tutup laci blok';
$string['closebuttontitle'] = 'Tutup';
$string['closecourseindex'] = 'Tutup indeks kursus';
$string['closedrawer'] = 'Tutup laci';
$string['closewindow'] = 'Tutup jendela ini';
$string['collapse'] = 'Ciutkan';
$string['collapseall'] = 'Ciutkan semua';
$string['collapsecategory'] = 'Ciutkan {$a}';
$string['comebacklater'] = 'Silakan kembali lagi nanti.';
$string['commentincontext'] = 'Cari komentar dalam konteks';
$string['comments'] = 'Komentar';
$string['commentscount'] = 'Komentar ({$a})';
$string['commentsnotenabled'] = 'Fitur komentar tidak diaktifkan';
$string['commentsrequirelogin'] = 'Anda harus masuk untuk melihat komentar';
$string['comparelanguage'] = 'Bandingkan dan edit bahasa saat ini';
$string['complete'] = 'Selesai';
$string['completed'] = 'Selesai';
$string['completereport'] = 'Laporan lengkap';
$string['configuration'] = 'Konfigurasi';
$string['confirm'] = 'Konfirmasi';
$string['confirmaccount'] = 'Konfirmasi akun';
$string['confirmcheckfull'] = 'Apakah Anda yakin untuk mengkonfirmasi {$a}?';
$string['confirmcoursemove'] = 'Apakah Anda yakin ingin memindahkan kursus ({$a->course}) ke dalam kategori ({$a->category})?';
$string['confirmdeletesection'] = 'Apakah anda benar-benar akan menghapus "{$a}" dan seluruh aktivitas di dalamnya?';
$string['confirmed'] = 'Pendaftaran Anda telah dikonfirmasi';
$string['confirmednot'] = 'Pendaftaran Anda belum dikonfirmasi. Silakan periksa kotak surat Anda untuk surel konfirmasi.';
$string['considereddigitalminor'] = 'Anda belum memiliki usia yang cukup untuk membuat akun di situs ini.';
$string['contactsbyrolelist'] = '{$a->role}: {$a->contacts}';
$string['content'] = 'Konten';
$string['contentbank'] = 'Bank konten';
$string['contentexport_aboutthiscourse'] = 'Ringkasan kursus';
$string['contentexport_coursesummary'] = 'Berkas ini adalah bagian dari konten yang diunduh dari <a href="{$a->courselink}"> {$a->coursename} </a>.';
$string['contentexport_footersummary'] = 'Berkas ini adalah bagian dari konten yang diunduh dari <a href="{$a->courselink}"> {$a->coursename} </a> oleh {$a->userfullname} pada {$a->date}.';
$string['contentexport_modulesummary'] = 'Halaman ini adalah bagian dari konten yang diunduh dari <a href="{$a->modulelink}"> {$a->modulename} </a> pada {$a->date}. Perhatikan bahwa beberapa konten dan berkas apa pun yang lebih besar dari {$a->maxfilesize} tidak diunduh.';
$string['contentexport_viewfilename'] = 'Lihat berkas {$a}';
$string['context'] = 'Konteks';
$string['contextlevel'] = 'Level konteks';
$string['contextname'] = 'Nama konteks';
$string['contextparent'] = 'Induk';
$string['contexturl'] = 'URL konteks';
$string['continue'] = 'Lanjutkan';
$string['continuetocourse'] = 'Klik di sini untuk masuk ke kursus Anda';
$string['convertingwikitomarkdown'] = 'Mengkonversikan wiki ke Markdown';
$string['cookiesenabled'] = 'Kuki harus diaktifkan pada peramban Anda';
$string['cookiesenabled_help'] = 'Dua kuki digunakan pada situs ini: Yang penting adalah kuki sesi, biasanya disebut MoodleSession. Anda harus membiarkan kuki ini di peramban Anda untuk memberikan kontinuitas dan mempertahankan login Anda dari halaman ke halaman. Ketika Anda keluar atau menutup kuki peramban ini dihapus (di peramban Anda dan di server).

Kuki lainnya adalah murni untuk kenyamanan, biasanya dinamakan seperti MOODLEID. Ini hanya pengingat nama pengguna Anda di peramban. Ini berarti ketika Anda kembali ke situs ini kolom nama pengguna pada halaman login akan sudah diisi untuk Anda. Aman untuk menolak kuki ini - Anda hanya perlu mengetik ulang nama pengguna Anda setiap kali Anda masuk.';
$string['cookiesenabled_help_html'] = 'Dua kuki digunakan di situs ini:<br/><br/>

Yang penting adalah kuki sesi, biasanya disebut MoodleSession. Anda harus mengizinkan kuki ini di peramban Anda untuk memberikan kontinuitas dan tetap masuk saat menjelajahi situs. Saat Anda log keluar atau menutup peramban, kuki ini dihapus (di peramban Anda dan di server).<br/><br/>

Kuki lainnya murni untuk kenyamanan, biasanya disebut MOODLEID atau sejenisnya. Itu hanya mengingat nama pengguna Anda di peramban. Ini berarti bahwa ketika Anda kembali ke situs ini, bidang nama pengguna pada halaman login sudah diisi untuk Anda. Aman untuk menolak kuki ini - Anda hanya perlu mengetik ulang nama pengguna Anda setiap kali Anda masuk.';
$string['cookiesenabledonlysession'] = 'Kuki harus diaktifkan pada peramban Anda';
$string['cookiesenabledonlysession_help'] = 'Situs ini menggunakan satu kuki sesi, biasanya disebut MoodleSession. Anda harus mengizinkan kuki ini di peramban Anda untuk memberikan kontinuitas dan tetap masuk saat menelusuri situs. Saat Anda keluar atau menutup peramban, kuki ini dihancurkan (di peramban Anda dan di server).';
$string['cookiesnotenabled'] = 'Sayang sekali, kuki tidak aktif dalam peramban Anda';
$string['cookiesnotice'] = 'Pemberitahuan kuki';
$string['copy'] = 'salin';
$string['copyasnoun'] = 'salin';
$string['copycourse'] = 'Salin kursus';
$string['copyingcoursefiles'] = 'Menyalin berkas kursus';
$string['copyingsitefiles'] = 'Menyalin berkas situs yang digunakan dalam kursus';
$string['copyinguserfiles'] = 'Menyalin berkas pengguna';
$string['copyingzipfile'] = 'Menyalin berkas zip';
$string['copyrightnotice'] = 'Pemberitahuan hak cipta';
$string['copytoclipboard'] = 'Salin ke papan klip';
$string['coresystem'] = 'Sistem';
$string['cost'] = 'Biaya';
$string['costdefault'] = 'Biaya bawaan';
$string['count_of_total'] = '<strong>{$a->count}</strong> dari {$a->total}';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Negara';
$string['course'] = 'kursus';
$string['courseadministration'] = 'Administrasi kursus';
$string['courseapprovedemail'] = 'Kursus yang Anda minta disetujui, <a href="{$a->url}">{$a->name}</a>, dan Anda adalah seorang {$a->teacher}.';
$string['courseapprovedemail2'] = 'Kursus yang Anda minta disetujui: <a href="{$a->url}">{$a->name}</a>.';
$string['courseapprovedfailed'] = 'Gagal dalam menyimpan kursus sebagaimana disetujui!';
$string['courseapprovedsubject'] = 'Kursus Anda telah disetujui.';
$string['courseavailable'] = 'Kursus ini tersedia untuk siswa';
$string['courseavailablenot'] = 'Kursus ini tidak tersedia untuk para siswa';
$string['coursebackup'] = 'Pencadangan kursus';
$string['coursebulkaction'] = 'Tindakan massal untuk kursus yang dipilih';
$string['coursecategories'] = 'Kategori kursus';
$string['coursecategory'] = 'Kategori kursus';
$string['coursecategory_help'] = 'Setelan ini menentukan kategori yang  akan muncul dalam daftar kursus.';
$string['coursecategorydeleted'] = 'Kategori kursus yang dihapus {$a}';
$string['coursecatmanagement'] = 'Kursus dan manajemen kategori';
$string['coursecompletion'] = 'Penyelesaian kursus';
$string['coursecompletions'] = 'Penyelesaian kursus';
$string['coursecreators'] = 'Pembuat kursus';
$string['coursecreatorsdescription'] = 'Pembuat kursus dapat membuat kursus baru.';
$string['coursedeleted'] = 'Kursus yang dihapus {$a}';
$string['coursedetails'] = 'Detail kursus';
$string['coursedisplay'] = 'Tata letak kursus';
$string['coursedisplay_help'] = 'Bagian kursus dapat ditampilkan semuanya dalam satu halaman atau dibagi menjadi beberapa halaman.';
$string['coursedisplay_multi'] = 'Tampilkan satu bagian per halaman';
$string['coursedisplay_single'] = 'Tampilkan semua bagian pada satu halaman';
$string['courseduration'] = 'Durasi kursus';
$string['courseduration_desc'] = 'Durasi kursus digunakan untuk menghitung tanggal akhir kursus bawaan. Tanggal akhir kursus digunakan untuk menentukan apakah suatu kursus harus dimasukkan dalam daftar kursus pengguna. Ini juga dapat digunakan oleh kustom tersuai. Pengguna masih dapat mengikuti kursus setelah tanggal berakhir.';
$string['courseenddateenabled'] = 'Tanggal berakhir kursus diizinkan sesuai bawaan';
$string['courseenddateenabled_desc'] = 'Setelan ini menentukan apakah tanggal akhir kursus akan diaktifkan secara bawaan untuk kursus baru dan ditetapkan ke tanggal yang dihitung dari durasi kursus.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Berkas kursus lawas';
$string['coursefilesedit'] = 'Edit berkas kursus lawas';
$string['coursefileswarning'] = 'Berkas kursus yang telah usang';
$string['coursefileswarning_help'] = 'Berkas kursus sudah tidak digunakan sejak Moodle 2.0, silakan gunakan repositori eksternal sebanyak mungkin.';
$string['courseformatdata'] = 'Data format kursus';
$string['courseformatoptions'] = 'Pilihan format untuk {$a}';
$string['courseformats'] = 'Format kursus';
$string['courseformatudpate'] = 'Perbarui format';
$string['coursegrades'] = 'Nilai kursus';
$string['courseheader'] = 'Menu kursus';
$string['coursehelpcategory'] = 'Posisikan kursus pada daftar kursus dan dapat memudahkan siswa untuk menemukannya.';
$string['coursehelpforce'] = 'Paksakan mode grup kursus ke setiap aktivitas di setiap kursus.';
$string['coursehelpformat'] = 'Halaman utama kursus akan ditampilkan dalam format ini.';
$string['coursehelphiddensections'] = 'Bagaimana bagian tersembunyai dari kursus ini ditampilkan pada siswa';
$string['coursehelpmaximumupload'] = 'Tentukan ukuran berkas terbesar yang dapat diunggah pada kursus, dibatasi oleh setelan situs utama.';
$string['coursehelpnewsitemsnumber'] = 'Jumlah pengumuman baru yang terlihat pada blok pengumuman pada halaman kursus. Jika diset 0, pengumuman tidak akan muncul.';
$string['coursehelpnumberweeks'] = 'Jumlah minggu / topik yang ditampilkan pada halaman utama  kursus.';
$string['coursehelpshowgrades'] = 'Aktifkan tampilan buku nilai. Itu tidak mencegah nilai ditampilkan dalam aktivitas individu.';
$string['coursehidden'] = 'Kursus ini sedang tidak tersedia untuk siswa';
$string['courseinfo'] = 'Info kursus';
$string['courselegacyfiles'] = 'Berkas kursus lawas';
$string['courselegacyfiles_help'] = 'Area berkas kursus menyediakan beberapa kompatibilitas dengan Moodle 1.9 dan sebelumnya. Semua berkas di area ini selalu dapat diakses oleh semua peserta dalam kursus (apakah Anda menautkannya atau tidak) dan tidak ada cara untuk mengetahui di mana berkas-berkas ini digunakan di Moodle. Jika Anda menggunakan area ini untuk menyimpan berkas kursus, Anda dapat memaparkan diri Anda pada sejumlah masalah privasi dan keamanan, serta mengalami berkas yang hilang dalam cadangan, impor pellajaran, dan setiap konten waktu dibagikan atau digunakan kembali. Karena itu disarankan agar Anda tidak menggunakan area ini kecuali Anda benar-benar tahu apa yang Anda lakukan.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Berkas kursus lawas: {$a}';
$string['coursenotaccessible'] = 'Kursus ini tidak membolehkan akses publik';
$string['courseoverview'] = 'Ikhtisar kursus';
$string['courseoverviewfiles'] = 'Gambar kursus';
$string['courseoverviewfiles_help'] = 'Gambar kursus ditampilkan di Kursus saya dan di daftar kursus yang tersedia di halaman Beranda. Administrator situs dapat mengaktifkan jenis berkas tambahan dan penggunaan banyak berkas.';
$string['courseoverviewfilesext'] = 'Ekstensi berkas gambar kursus';
$string['courseoverviewfileslimit'] = 'Batas berkas gambar kursus';
$string['courseoverviewgraph'] = 'Grafik ikhtisar kursus';
$string['courseprofiles'] = 'Profil kursus';
$string['coursereasonforrejecting'] = 'Alasan Anda menolak permintaan ini';
$string['coursereasonforrejectingemail'] = 'Ini akan dikirim melalui surel ke pemohon';
$string['coursereject'] = 'Tolak permintaan kursus';
$string['courserejected'] = 'Kursus telah ditolak dan peminta kursus tersebut telah diberi tahu.';
$string['courserejectemail'] = 'Maaf, tetapi kursus yang Anda minta telah ditolak. Berikut adalah berbagai alasannya: {$a}';
$string['courserejectreason'] = 'Garis besar alasan Anda untuk menolak kursus ini<br/>(ini akan dikirimkan lewat surel kepada pengguna yang meminta)';
$string['courserejectsubject'] = 'Kursus Anda telah ditolak';
$string['coursereport'] = 'Laporan kursus';
$string['coursereports'] = 'Laporan kursus';
$string['courserequest'] = 'Permintaan kursus';
$string['courserequestdetails'] = 'Detail kursus yang Anda minta';
$string['courserequestfailed'] = 'Untuk beberapa alasan, permintaan kursus Anda tidak dapat disimpan';
$string['courserequestintro'] = 'Gunakan formulir ini untuk meminta kursus dibuat untuk Anda. <br/> Masukkan informasi sebanyak mungkin yang diperbolehkan<br/>Admin akan memahami alasan Anda mengingingkan kursus ini';
$string['courserequestreason'] = 'Alasan Anda menginginkan kursus ini';
$string['courserequestroleerror'] = 'Peran pembuat dalam konfigurasi kursus baru tidak valid. Silakan lihat <a href="{$a}">kebijakan pengguna</a>.';
$string['courserequestsuccess'] = 'Permintaan kursus telah dikirimkan.';
$string['courserequestsupport'] = 'Informasi tambahan untuk membantu administrator mengevaluasi permintaan ini';
$string['courserequestwarning'] = 'Pengguna yang meminta kursus ini akan secara otomatis terdaftar dan diberi peran {$a}.';
$string['courserestore'] = 'Pemulihan kursus';
$string['coursereuse'] = 'Penggunaan kembali kursus';
$string['coursereusenavigationmenu'] = 'Menu navigasi penggunaan kembali kursus';
$string['courses'] = 'Kursus';
$string['coursesectionsummaries'] = 'Ringkasan topik kursus';
$string['coursesectiontitle'] = '{$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitlebulkediting'] = 'Edit massal {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Edit {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'Setelan bawaan kursus';
$string['coursesmovedout'] = 'Kursus dipindahkan dari {$a}';
$string['coursespending'] = 'Izin menunda kursus';
$string['coursestart'] = 'Mulai kursus';
$string['coursesummary'] = 'Ringkasan kursus';
$string['coursesummary_help'] = 'Deskripsi singkat tentang kursus Anda. Konten yang Anda tambahkan di sini dapat dicari.';
$string['coursetitle'] = 'Kursus: {$a->course}';
$string['coursetitlebulkediting'] = 'Edit kursus massal: {$a->course}';
$string['coursetitleediting'] = 'Edit kursus: {$a->course}';
$string['courseupdates'] = 'Kursus diperbarui';
$string['coursevisibility'] = 'Keterlihatan kursus';
$string['coursevisibility_help'] = '* Tampilkan: Kursus muncul di daftar kursus dan siswa dapat mengaksesnya.
* Sembunyikan: Akses dibatasi untuk pengajar dan pengguna lain dengan kemampuan untuk melihat kursus tersembunyi.';
$string['create'] = 'Buat';
$string['createaccount'] = 'Buat keanggotaan baru';
$string['createcategory'] = 'Buat kategori';
$string['createfolder'] = 'Buat folder di {$a}';
$string['createnew'] = 'Buat baru';
$string['createnewcategory'] = 'Buat kategori baru';
$string['createnewcourse'] = 'Buat kursus baru';
$string['createnewsubcategory'] = 'Buat subkategori baru';
$string['createsubcategoryof'] = 'Buat subkategori {$a}';
$string['createuser'] = 'Tambahkan pengguna';
$string['createziparchive'] = 'Buat arsip zip';
$string['creatingblocks'] = 'Membuat blok';
$string['creatingblocksroles'] = 'Membuat penetapan dan penyampingan peran tingkat blok';
$string['creatingblogsinfo'] = 'Membuat Info blog';
$string['creatingcategoriesandquestions'] = 'Membuat kategori dan soal';
$string['creatingcoursemodules'] = 'Membuat modul kursus';
$string['creatingcourseroles'] = 'Membuat penetapan peran tingkat kursus dan penyampingannya';
$string['creatingevents'] = 'Membuat acara';
$string['creatinggradebook'] = 'Membuat buku nilai';
$string['creatinggroupings'] = 'Membuat pengelompokan';
$string['creatinggroupingsgroups'] = 'Menambahkan grup ke dalam pengelompokan';
$string['creatinggroups'] = 'Membuat grup';
$string['creatinglogentries'] = 'Membuat entri log';
$string['creatingmessagesinfo'] = 'Membuat info pesan';
$string['creatingmodroles'] = 'Membuat penetapan dan penyampingan peran tingkat modul';
$string['creatingnewcourse'] = 'Membuat kursus baru';
$string['creatingrolesdefinitions'] = 'Membuat definisi peran';
$string['creatingscales'] = 'Membuat skala';
$string['creatingsections'] = 'Membuat bagian';
$string['creatingtemporarystructures'] = 'Membuat struktur sementara';
$string['creatinguserroles'] = 'Membuat penetapan dan penyampingan peran tingkat pengguna';
$string['creatingusers'] = 'Menambahkan pengguna';
$string['creatingxmlfile'] = 'Membuat berkas XML';
$string['currency'] = 'Mata uang';
$string['currentcourse'] = 'Kursus saat ini';
$string['currentcourseadding'] = 'Kursus saat ini, menambahkan data ke dalamnya';
$string['currentcoursedeleting'] = 'Kursus saat ini, menghapusnya terlebih dahulu';
$string['currentlanguage'] = 'Bahasa saat ini';
$string['currentlocaltime'] = 'Waktu lokal Anda saat ini';
$string['currentpicture'] = 'Gambar sekarang';
$string['currentrelease'] = 'Informasi versi sekarang';
$string['currenttheme'] = 'Tema saat ini';
$string['currentversion'] = 'Versi sekarang';
$string['databasechecking'] = 'Perbarui basis data Moodle dari versi {$a->oldversion} ke {$a->newversion}';
$string['databaseperformance'] = 'Performa basis data';
$string['databasesetup'] = 'Menyetel basis data';
$string['databasesuccess'] = 'Basis data telah selesai ditingkatkan';
$string['databaseupgradebackups'] = 'Versi pencadangan sekarang adalah {$a}';
$string['databaseupgradeblocks'] = 'Versi blok sekarang adalah {$a}';
$string['databaseupgradegroups'] = 'Versi grup sekarang adalah {$a}';
$string['databaseupgradelocal'] = 'Versi basis data lokal kustom adalah {$a}';
$string['databaseupgrades'] = 'Peningkatan basis data';
$string['dataformats'] = 'Format data';
$string['date'] = 'Tanggal';
$string['datechanged'] = 'Tanggal diubah';
$string['datemostrecentfirst'] = 'Tanggal - urut yang terbaru';
$string['datemostrecentlast'] = 'Tanggal - urut yang terlama';
$string['datetimefilterafter'] = '{$a->title} setelah';
$string['datetimefilterbefore'] = '{$a->title} sebelumnya';
$string['day'] = 'hari';
$string['days'] = 'hari';
$string['decodinginternallinks'] = 'Mendekode tautan internal';
$string['default'] = 'Bawaan';
$string['defaultcategoryname'] = 'Kategori 1';
$string['defaultcompetencescale'] = 'Skala kompetensi bawaan';
$string['defaultcompetencescaledesc'] = 'Skala peringkat biner yang tidak memberikan informasi lebih lanjut di luar apakah seseorang telah menunjukkan kemahiran atau tidak.';
$string['defaultcompetencescalenotproficient'] = 'Belum kompeten';
$string['defaultcompetencescaleproficient'] = 'Kompeten';
$string['defaultcoursestudent'] = 'Siswa';
$string['defaultcoursestudentdescription'] = 'Siswa umumnya memiliki hak lebih sedikit di dalam kursus.';
$string['defaultcoursestudents'] = 'Siswa';
$string['defaultcoursesummary'] = 'Tuliskan keterangan yang menarik di sini untuk menjelaskan apa tujuan dari kursus ini';
$string['defaultcourseteacher'] = 'Pengajar';
$string['defaultcourseteacherdescription'] = 'Pengajar dapat melakukan apa saja di dalam kursus, termasuk mengubah aktivitas dan menilai siswa.';
$string['defaultcourseteachers'] = 'Pengajar';
$string['defaulteditor'] = 'Editor bawaan';
$string['defaulthomepageuser'] = 'Halaman depan';
$string['defaulthomepageuser_help'] = 'Halaman mana yang harus Anda alihkan setelah masuk ke situs?';
$string['delete'] = 'Hapus';
$string['deleteablock'] = 'Hapus blok';
$string['deleteall'] = 'Hapus semua';
$string['deleteallcannotundo'] = 'Hapus semua - tidak dapat dibatalkan';
$string['deleteallcomments'] = 'Semua komentar';
$string['deleteallratings'] = 'Semua peringkat';
$string['deletecategory'] = 'Menghapus kategori: {$a}';
$string['deletecategorycheck'] = 'Apakah Anda yakin ingin menghapus kategori <b>\'{$a}\'</b> secara permanen? Hal ini akan mengakibatkan sistem memindahkan semua kursus ke kategori induk jika tersedia, atau ke lain-lain ...';
$string['deletecategorycheck2'] = 'Jika Anda menghapus kategori, Anda perlu memilih apa yang akan dilakukan dengan kursus dan subkategori yang ada di dalamnya.';
$string['deletecategoryempty'] = 'Kategori ini kosong.';
$string['deletecheck'] = 'Hapus {$a} ?';
$string['deletecheckfiles'] = 'Apakah Anda benar-benar yakin ingin menghapus berkas ini?';
$string['deletecheckfull'] = 'Apakah Anda yakin ingin menghapus pengguna {$a}, termasuk data seperti rincian profil, pendaftaran, keanggotaan grup dan kelompok, serta beberapa data aktivitas pengguna?';
$string['deletechecktype'] = 'Apakah Anda yakin ingin menghapus {$a->type}?';
$string['deletechecktypename'] = 'Apakah Anda yakin ingin menghapus {$a->type}
"{$a->name}"?';
$string['deletecheckwarning'] = 'Anda akan menghapus berkas ini';
$string['deletecommentbyon'] = 'Hapus komentar yang dikirim oleh {$a->user} pada {$a->time}';
$string['deletecompletely'] = 'Penghapusan selesai';
$string['deletecourse'] = 'Hapus kursus';
$string['deletecoursecheck'] = 'Anda benar-benar yakin akan menghapus kursus ini serta semua data di dalamnya?';
$string['deleted'] = 'Dihapus';
$string['deletedactivity'] = 'Hapus {$a}';
$string['deletedcourse'] = '{$a} telah berhasil dihapus';
$string['deletednot'] = 'Tidak dapat menghapus {$a}.';
$string['deletepicture'] = 'Hapus';
$string['deletesection'] = 'Hapus';
$string['deleteselected'] = 'Hapus yang terpilih';
$string['deleteselectedkey'] = 'Hapus kunci terpilih';
$string['deletingcourse'] = 'Menghapus {$a}';
$string['deletingexistingcoursedata'] = 'Hapus data kursus yang ada';
$string['deletingolddata'] = 'Hapus data lama';
$string['department'] = 'Departemen';
$string['deprecatedeventname'] = '{$a} (tidak lagi digunakan)';
$string['desc'] = 'Urut turun';
$string['description'] = 'Deskripsi';
$string['deselectall'] = 'Hilangkan semua seleksi';
$string['deselectnos'] = 'Batal memilih semua \'Tidak\'';
$string['detailedless'] = 'Kurang detail';
$string['detailedmore'] = 'Lebih detail';
$string['details'] = 'Detail';
$string['digitalminor'] = 'Anak di bawah umur digital';
$string['digitalminor_desc'] = 'Harap meminta orang tua/wali untuk menghubungi:';
$string['directory'] = 'Direktori';
$string['disable'] = 'Nonaktif';
$string['disabledcomments'] = 'Komentar dinonaktifkan';
$string['dismissnotification'] = 'Abaikan peringatan ini';
$string['displayingfirst'] = 'Hanya {$a->count} {$a->things} pertama yang ditampilkan';
$string['displayingrecords'] = 'Tampilkan data {$a}';
$string['displayingusers'] = 'Tampilkan pengguna {$a->start} sampai {$a->end}';
$string['displayonpage'] = 'Tampilkan pada halaman';
$string['dndcourse'] = 'Anda dapat seret dan lepas kursus ini untuk mengubah penyortirannya atau memindahkannya ke kategori lain.';
$string['dndenabled_inbox'] = 'Anda dapat seret dan lepas berkas di sini untuk menambahkan.';
$string['dndnotsupported'] = 'Tidak mendukung unggah dengan cara seret dan lepas';
$string['dndnotsupported_help'] = 'Peramban Anda tidak mendukung unggah dengan cara seret dan lepas. <br /> Fitur ini tersedia di semua versi terbaru dari Chrome, Firefox dan Safari, serta Internet Explorer v10 ke atas.';
$string['dndnotsupported_insentence'] = 'Tidak mendukung seret dan lepas';
$string['dnduploadwithoutcontent'] = 'Unggahan ini tidak ada isinya';
$string['dndworkingfile'] = 'Seret dan lepas berkas pada topik kursus untuk mengunggahnya';
$string['dndworkingfilelink'] = 'Seret dan lepas berkas atau tautan ke topik kursus untuk mengunggahnya';
$string['dndworkingfiletext'] = 'Seret dan lepas berkas atau teks ke topik kursus untuk mengunggahnya';
$string['dndworkingfiletextlink'] = 'Seret dan lepas berkas, teks atau tautan ke  topik kursus untuk mengunggahnya';
$string['dndworkinglink'] = 'Seret dan lepas tautan ke topik kursus untuk mengunggahnya';
$string['dndworkingtext'] = 'Seret dan lepas teks ke topik kursus untuk mengunggahnya';
$string['dndworkingtextlink'] = 'Seret dan lepas teks atau tautan ke topik kursus untuk mengunggahnya';
$string['documentation'] = 'Dokumentasi Moodle';
$string['dontsortcategories'] = 'Jangan memilah kategori';
$string['dontsortcourses'] = 'Jangan mengurutkan kursus';
$string['down'] = 'Turun';
$string['download'] = 'Unduh';
$string['downloadall'] = 'Unduh semua';
$string['downloadexcel'] = 'Unduh dalam format Excel';
$string['downloadfile'] = 'Unduh berkas';
$string['downloadods'] = 'Unduh dalam format ODS';
$string['downloadtext'] = 'Unduh dalam format teks';
$string['doyouagree'] = 'Apakah Anda telah membaca peraturan ini dan mengerti isinya?';
$string['droptoupload'] = 'Lepaskan berkas di sini untuk menggunggah';
$string['duplicate'] = 'Duplikat';
$string['duplicatedmodule'] = '{$a} (salinan)';
$string['duplicatedsection'] = '{$a} (salinan)';
$string['edhelpaspellpath'] = 'Untuk menggunakan pemeriksa-ejaan di editor, Anda HARUS memiliki <strong>aspell 0.50</strong> atau diinstal kemudian pada server Anda, dan Anda harus menentukan path yang benar untuk mengakses file aspell. Di sistem Unix/Linux, path ini biasanya <strong>/usr/bin/aspell</strong>, atau mungkin di path yang lain.';
$string['edhelpbgcolor'] = 'Atur warna latar belakang pengubahan.<br />Isi yang valid adalah, contoh:#FFFFFF atau white';
$string['edhelpcleanword'] = 'Setelan ini mengaktifkan atau menonaktifkan pemfilteran format khusus Word.';
$string['edhelpenablespelling'] = 'Aktifkan atau nonaktifkan pemeriksaan ejaan. Saat diaktifkan, <strong> aspell </strong> harus dipasang di server. Nilai kedua adalah <strong> kamus bawaan </strong>. Nilai ini akan digunakan jika aspell tidak memiliki kamus untuk bahasa pengguna sendiri.';
$string['edhelpfontfamily'] = 'Properti font-family adalah daftar nama keluarga fon dan/atau nama keluarga generik. Nama keluarga harus dipisahkan dengan koma.';
$string['edhelpfontlist'] = 'Tentukan fon yang digunakan pada menu tarik-turun editor.';
$string['edhelpfontsize'] = 'Ukuran huruf bawaan menentukan ukuran fon. <br /> Nilai yang valid misalnya: menengah, besar, lebih kecil, lebih besar, 10pt, 11px.';
$string['edit'] = 'Edit';
$string['edita'] = 'Edit {$a}';
$string['editcategorysettings'] = 'Edit setelan kategori';
$string['editcategorythis'] = 'Edit kategori ini';
$string['editcoursesettings'] = 'Edit setelan kursus';
$string['editfiles'] = 'Ubah berkas';
$string['editgroupprofile'] = 'Ubah deskripsi grup';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'Nilai ini tidak dapat diubah!';
$string['editmode'] = 'Mode Edit';
$string['editmyprofile'] = 'Edit profil';
$string['editorbgcolor'] = 'Warna latar belakang';
$string['editorcleanonpaste'] = 'Hilangkan HTML Word saat tempel';
$string['editorcommonsettings'] = 'Setelan umum';
$string['editordefaultfont'] = 'Fon bawaan';
$string['editorenablespelling'] = 'Nyalakan pemeriksa ejaan';
$string['editorfontlist'] = 'Daftar Fon';
$string['editorfontsize'] = 'Ukuran huruf bawaan';
$string['editorpreferences'] = 'Preferensi editor';
$string['editorresettodefaults'] = 'Reset ke nilai bawaan';
$string['editorsettings'] = 'Setelan Editor';
$string['editorshortcutkeys'] = 'Tombol pintas editor';
$string['editsection'] = 'Edit setelan';
$string['editsectionname'] = 'Edit nama bagian';
$string['editsectionsettings'] = 'Edit setelan topik';
$string['editsectiontitle'] = 'Bagian edit: {$a}';
$string['editsettings'] = 'Edit setelan';
$string['editthisactivity'] = 'Ubah aktivitas ini';
$string['editthiscategory'] = 'Edit kategori ini';
$string['edittitle'] = 'Mengedit judul';
$string['edittitleinstructions'] = 'Klik tombol Escape untuk membatalkan, tombol Enter ketika selesai.';
$string['edituser'] = 'Ubah keanggotaan pengguna';
$string['edulevel'] = 'Semua acara';
$string['edulevel_help'] = '* Pengajaran - tindakan yang dilakukan oleh seorang pangajar, mis. memperbarui sebuah sumber
* Berpartisipasi - tindakan yang dilakukan oleh siswa, mis. mengirim pesan di forum
* Lainnya - tindakan yang dilakukan oleh pengguna dengan peran selain pengajar atau siswa';
$string['edulevelother'] = 'Lain-lain';
$string['edulevelparticipating'] = 'Berpartisipasi';
$string['edulevelteacher'] = 'Mengajar';
$string['email'] = 'Alamat surel';
$string['emailactive'] = 'Surel diaktifkan';
$string['emailagain'] = 'Surel (lagi)';
$string['emailalreadysent'] = 'Sebuah surel berisi kata sandi telah dikirim. Silakan periksa surel Anda';
$string['emailcharset'] = 'Karakter set surel';
$string['emailconfirm'] = 'Konfirmasikan keanggotaan Anda';
$string['emailconfirmation'] = 'Hai, {$a->firstname},

Akun baru telah diminta di \'{$a->sitename}\' menggunakan alamat surel Anda.

Untuk mengonfirmasi akun baru Anda, silakan kunjungi alamat web ini:

{$a->link}

Di sebagian besar program surel, ini akan muncul sebagai tautan biru yang bisa Anda klik saja. Jika itu tidak berhasil, lalu potong dan tempel alamat tersebut ke dalam alamat baris di bagian atas jendela peramban  web Anda.

Jika Anda memerlukan bantuan, silakan hubungi administrator situs, {$a->admin}';
$string['emailconfirmationresend'] = 'Kirimkan kembali surel konfirmasi';
$string['emailconfirmationsubject'] = '{$a}: konfirmasi keanggotaan';
$string['emailconfirmsent'] = '<p> Sebuah surel seharusnya telah dikirimkan ke alamat Anda di <b>{$a}</b> </p> <p> Berisi petunjuk mudah untuk menyelesaikan pendaftaran Anda. </p> <p> Jika Anda melanjutkan mengalami kesulitan, hubungi administrator situs. </p>';
$string['emailconfirmsentfailure'] = 'Pengiriman surel konfirmasi gagal';
$string['emailconfirmsentsuccess'] = 'Pengiriman surel konfirmasi sukses';
$string['emaildigest'] = 'Tipe intisari surel';
$string['emaildigest_help'] = 'Ini adalah setelan intisari harian yang akan digunakan forum secara bawaan. <ul>
<li> Tidak ada intisari - Anda akan menerima satu surel per kiriman forum;
</li><li>Intisari - kiriman lengkap - Anda akan menerima satu surel intisari per hari yang berisi konten lengkap dari setiap kiriman forum;
</li><li>Intisari - hanya subjek - Anda akan menerima satu surel intisari per hari yang hanya berisi subjek dari setiap kiriman forum. </li> </ul>

Anda juga dapat memilih setelan berbeda untuk setiap forum jika diinginkan.';
$string['emaildigestcomplete'] = 'Lengkap (surel harian dengan kiriman penuh)';
$string['emaildigestoff'] = 'Tidak dirangkum (surel tunggal per kiriman forum)';
$string['emaildigestsubjects'] = 'Subjek (surel harian dengan subjek saja)';
$string['emaildisable'] = 'Alamat surel ini dinonaktifkan';
$string['emaildisableclick'] = 'Klik di sini untuk menonaktifkan semua surel yang dikirim ke alamat ini';
$string['emaildisplay'] = 'Tampilan surel';
$string['emaildisplay_help'] = '* Tersembunyi - Hanya pengguna dengan izin yang sesuai seperti pengajar yang dapat melihat alamat surel Anda.
* Dapat dilihat oleh semua orang - Semua pengguna di situs dapat melihat alamat surel Anda.
* Dapat dilihat oleh peserta kursus - Hanya peserta kursus yang Anda ikuti yang dapat melihat alamat surel Anda.';
$string['emaildisplaycourse'] = 'Terlihat peserta kursus';
$string['emaildisplaycoursemembersonly'] = '(Terlihat oleh peserta kursus yang lain)';
$string['emaildisplayeveryone'] = '(Terlihat oleh semua orang)';
$string['emaildisplayhide'] = '(Tersembunyi dari semua orang kecuali pengguna dengan izin yang sesuai)';
$string['emaildisplayno'] = 'Tersembunyi';
$string['emaildisplayyes'] = 'Terlihat semua orang';
$string['emailenable'] = 'Alamat surel ini diaktifkan';
$string['emailenableclick'] = 'Klik di sini untuk mengaktifkan kembali semua surel yang dikirim ke alamat ini';
$string['emailexists'] = 'Surel ini telah terdaftar.';
$string['emailexistshintlink'] = 'Pulihkan nama pengguna atau kata sandi yang terlupakan';
$string['emailexistssignuphint'] = 'Mungkin sebelumnya Anda sudah membuat akun? {$a}';
$string['emailformat'] = 'Format surel';
$string['emailmustbereal'] = 'Catatan: alamat surel Ada harus yang asli';
$string['emailnotallowed'] = 'Alamat surel dengan domain {$a} tidak diperbolehkan';
$string['emailnotfound'] = 'Alamat surel tidak ditemukan dalam basis data';
$string['emailonlyallowed'] = 'Surel ini tidak dapat digunakan. Domain surel yang diperbolehkan adalah: {$a}.';
$string['emailpasswordchangeinfo'] = 'Hallo {$a->firstname},

Seseorang (mungkin Anda) telah meminta kata sandi baru untuk akun anda di \'{$a->sitename}\'.

Untuk mengubah kata sandi Anda, silakan kunjungi alamat web berikut:
{$a->link}

Di program surel pada umumnya, akan ditampilkan sebagai link biru yang Anda dapat langsung mengkliknya. Jika tidak bisa, salin dan tempel alamat ke baris alamat di bagian atas jendela peramban web Anda.

Jika Anda perlu bantuan, silakan hubungi administrator situs,

{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Hai {$a->firstname},

Seseorang (mungkin Anda) telah meminta kata sandi baru untuk akun anda di \'{$a->sitename}\'.

Sayangnya akun Anda di situs ini dinonaktifkan dan tidak dapat direset, silakan hubungi pengelola situs, {$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Hai {$a->firstname},

Seseorang (mungkin Anda) telah meminta kata sandi baru untuk akun Anda di \'{$a->sitename}\'.

Sayangnya kata sandi tersebut tidak dapat direset pada situs ini, silakan hubungi administrator situs {$a->admin}.';
$string['emailpasswordchangeinfosubject'] = '{$a}: Informasi ubah kata sandi';
$string['emailpasswordconfirmation'] = 'Hallo {$a->firstname},

Seseorang (mungkin Anda sendiri) telah meminta sebuah kata sandi baru untuk keanggotaan Anda pada \'{$a->sitename}\'.

Untuk mengkonfirmasikan ini dan untuk mendapatkan sebuah kata sandi baru dikirimkan ke surel Anda, pergilah ke alamat web berikut ini:
{$a->link}

Pada kebanyakan program surel, ini akan ditampilkan dengan tautan berwarna biru dimana Anda dapat langsung mengkliknya. Jika tidak bekerja, lalu potong dan tempelkan alamat ini ke baris alamat pada bagian atas dari jendela peramban web Anda.

Jika Anda butuh bantuan, silakan hubungi administrator situs ini, {$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: konfirmasi penggantian kata sandi';
$string['emailpasswordconfirmmaybesent'] = '<p> Jika Anda memberikan nama pengguna atau alamat surel yang benar, maka seharusnya surel dikirimkan kepada Anda. </p> <p> Berisi instruksi mudah untuk mengonfirmasi dan menyelesaikan perubahan kata sandi ini. Jika Anda terus mengalami kesulitan, silakan hubungi administrator situs. </p>';
$string['emailpasswordconfirmnoemail'] = '<p> Akun pengguna yang Anda tentukan tidak memiliki alamat surel yang tercatat. </p> <p>Sila hubungi Administrator situs. </p>';
$string['emailpasswordconfirmnotsent'] = '<p>Detail pengguna yang Anda berikan tidak mengidentifikasi akun pengguna yang ada.</p>
<p>Silakan periksa informasi yang Anda masukkan, lalu coba lagi. Jika Anda terus mengalami kesulitan, silakan hubungi Administrator situs. </p>';
$string['emailpasswordconfirmsent'] = 'Sebuah surel telah dikirimkan ke alamat Anda di <b>{$a}</b>. <p>Surel ini berisi instruksi untuk melakukan konfirmasi terhadap penggantian kata sandi Anda. Jika Anda menemui kesulitan, Hubungi administrator situs.</p>';
$string['emailresetconfirmation'] = 'Hai {$a->firstname},

Reset kata sandi diminta untuk akun Anda \'{$a->username}\' pada {$a->sitename}.

Untuk mengonfirmasi permintaan ini, dan menyetel kata sandi baru untuk akun Anda, silakan kunjungi alamat web berikut:

<a href="{$a->link}">{$a->link}</a>

(Tautan ini berlaku selama {$a->resetminutes} menit sejak pertama kali reset ini diminta.)

Jika setel ulang kata sandi ini tidak diminta oleh Anda, abaikan. Jangan lakukan hal apapun.

Jika Anda memerlukan bantuan, silakan hubungi administrator situs, {$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Permintaan reset kata sandi';
$string['emailresetconfirmsent'] = 'Sebuah surel telah dikirim ke alamat Anda di <b>{$a}.</b> <br />Berisi petunjuk mudah untuk mengonfirmasi dan menyelesaikan perubahan kata sandi ini.

Jika Anda terus mengalami kesulitan, silakan hubungi Administrator situs.';
$string['emailstop'] = 'Nonaktifkan notifikasi';
$string['emailtoprivatefiles'] = 'Anda juga dapat mengirim berkas melalui berkas sebagai lampiran langsung ke ruang berkas pribadi Anda. Cukup lampirkan berkas Anda pada surel dan kirimkan ke {$a}';
$string['emailtoprivatefilesdenied'] = 'Administrator telah menonaktifkan opsi untuk mengunggah berkas pribadi Anda sendiri.';
$string['emailvia'] = '{$a->name} (via {$a->siteshortname})';
$string['emojicategoryactivities'] = 'Aktivitas';
$string['emojicategoryanimalsnature'] = 'Hewan & alam';
$string['emojicategoryflags'] = 'Penanda';
$string['emojicategoryfooddrink'] = 'Makanan dan minuman';
$string['emojicategoryobjects'] = 'Objek';
$string['emojicategorypeoplebody'] = 'Orang dan tubuh';
$string['emojicategoryrecent'] = 'Terbaru';
$string['emojicategorysmileysemotion'] = 'Senyuman dan emosi';
$string['emojicategorysymbols'] = 'Simbol';
$string['emojicategorytravelplaces'] = 'Perjalanan dan tempat';
$string['emptycmids'] = 'ID modul kursus kosong';
$string['emptydragdropregion'] = 'bagian kosong';
$string['emptysectionids'] = 'ID bagian kosong';
$string['enable'] = 'Aktifkan';
$string['encryptedcode'] = 'Kode terenkripsi';
$string['enddate'] = 'Tanggal berakhir kursus';
$string['enddate_help'] = 'Tanggal akhir tidak membatasi akses siswa ke kursus. Ini menentukan apakah suatu kursus terdaftar menjadi Kursus lamaku.';
$string['enddatewithtaskenabled'] = 'Tanggal akhir kursus';
$string['enddatewithtaskenabled_help'] = 'Tanggal saat kursus disembunyikan untuk siswa dan mereka tidak dapat lagi mengaksesnya.';
$string['english'] = 'Bahasa Inggris';
$string['enrolmentmethods'] = 'Metode pendaftaran';
$string['entercourse'] = 'Klik untuk memasuki kursus ini';
$string['enteremail'] = 'Masukkan alamat surel Anda';
$string['enteremailaddress'] = 'Masukkan alamat surel Anda untuk mereset kata sandi Anda dan Anda akan menerima kata sandi baru dikirimkan ke surel Anda.';
$string['enterusername'] = 'Masukkan nama pengguna Anda';
$string['entries'] = 'Entri';
$string['error'] = 'Galat';
$string['errorcreatingactivity'] = 'Tidak dapat membuat model dari aktivitas \'{$a}\'';
$string['errorfiletoobig'] = 'Berkas lebih besar dari batas {$a} byte';
$string['errornouploadrepo'] = 'Tidak ada repositori unggahan diaktifkan untuk situs ini';
$string['errorwhenconfirming'] = 'Anda belum dikonfirmasi saat ini karena ditemukan kesalahan. Jika Anda klik pranala pada surel Anda untuk sampai kesini, yakinkan bahwa baris pranala tersebut tidak terputus atau tergulung. Anda bisa juga menggunakan salin dan tempelkan untuk memperbaiki properti pranala tersebut.';
$string['eventcommentcreated'] = 'Membuat komentar';
$string['eventcommentdeleted'] = 'Menghapus komentar';
$string['eventcommentsviewed'] = 'Melihat komentar';
$string['eventconfiglogcreated'] = 'Membuat log konfigurasi';
$string['eventcontentviewed'] = 'Melihat konten';
$string['eventcoursebackupcreated'] = 'Membuat cadangan kursus';
$string['eventcoursecategorycreated'] = 'Membuat kategori';
$string['eventcoursecategorydeleted'] = 'Menghapus kategori';
$string['eventcoursecategoryupdated'] = 'Memperbarui kategori';
$string['eventcoursecategoryviewed'] = 'Melihat kategori';
$string['eventcoursecontentdeleted'] = 'Menghapus konten kursus';
$string['eventcoursecreated'] = 'Membuat kursus';
$string['eventcoursedeleted'] = 'Menghapus kursus';
$string['eventcourseended'] = 'Kursus berakhir';
$string['eventcourseinformationviewed'] = 'Melihat ringkasan kursus';
$string['eventcoursemodulecreated'] = 'Membuat modul kursus';
$string['eventcoursemoduledeleted'] = 'Menghapus modul kursus';
$string['eventcoursemoduleinstancelistviewed'] = 'Daftar model modul kursus dilihat';
$string['eventcoursemoduleupdated'] = 'Memperbarui modul kursus';
$string['eventcoursemoduleviewed'] = 'Melihat modul kursus';
$string['eventcourseoverviewviewed'] = 'Halaman ringkasan aktivitas kursus dilihat';
$string['eventcourseresetended'] = 'Mengakhiri reset kursus';
$string['eventcourseresetstarted'] = 'Memulai reset kursus';
$string['eventcourserestored'] = 'Memulihkan kursus';
$string['eventcoursesectioncreated'] = 'Membuat topik kursus';
$string['eventcoursesectiondeleted'] = 'Menghapus topik kursus';
$string['eventcoursesectionupdated'] = 'Mutakhirkan topik kursus';
$string['eventcoursessearched'] = 'Mencari kursus';
$string['eventcoursestarted'] = 'Kursus dimulai';
$string['eventcourseupdated'] = 'Memperbarui kursus';
$string['eventcourseuserreportviewed'] = 'Melihat laporan kursus';
$string['eventcourseviewed'] = 'Melihat kursus';
$string['eventdashboardreset'] = 'Set ulang Dasbor';
$string['eventdashboardsreset'] = 'Set ulang Dasbor';
$string['eventdashboardviewed'] = 'Melihat dasbor';
$string['eventdatabasetextfieldcontentreplaced'] = 'Pencarian dan penggantian basis data global';
$string['eventemailfailed'] = 'Gagal mengirim surel';
$string['eventmycoursesviewed'] = 'Melihat kursusku';
$string['eventname'] = 'Nama acara';
$string['eventrecentactivityviewed'] = 'Melihat aktivitas terbaru';
$string['eventsearchindexed'] = 'Mengindeks data pencarian';
$string['eventsearchresultsviewed'] = 'Melihat hasil pencarian';
$string['eventsectionviewed'] = 'Bagian dilihat';
$string['eventunknownlogged'] = 'Acara tidak dikenal';
$string['eventurlblocked'] = 'URL diblokir';
$string['eventusercreated'] = 'Membuat pengguna';
$string['eventuserdeleted'] = 'Menghapus pengguna';
$string['eventuserfeedbackgiven'] = 'Mengklik tautan umpan balik';
$string['eventuserfeedbackremind'] = 'Ingatkan saya nanti tautan umpan balik diklik';
$string['eventuserinfocategorycreated'] = 'Membuat kategori ruas profil pengguna';
$string['eventuserinfocategorydeleted'] = 'Menghapus kategori ruas profil pengguna';
$string['eventuserinfocategoryupdated'] = 'Memperbarui ruas profil pengguna';
$string['eventuserinfofieldcreated'] = 'Membuat ruas profil pengguna';
$string['eventuserinfofielddeleted'] = 'Menghapus ruas profil pengguna';
$string['eventuserinfofieldupdated'] = 'Memperbarui ruas profil pengguna';
$string['eventuserlistviewed'] = 'Melihat daftar pengguna';
$string['eventuserloggedout'] = 'Pengguna keluar';
$string['eventuserpasswordpolicyfailed'] = 'Sandi pengguna tidak memenuhi kebijakan sandi';
$string['eventuserpasswordupdated'] = 'Memperbarui kata sandi pengguna';
$string['eventuserprofileviewed'] = 'Melihat profil pengguna';
$string['eventuserupdated'] = 'Memperbarui pengguna';
$string['everybody'] = 'Semua orang';
$string['executeat'] = 'Dijalankan pada';
$string['existing'] = 'Yang ada';
$string['existingadmins'] = 'Admin yang ada';
$string['existingcourse'] = 'Kursus yang tersedia';
$string['existingcourseadding'] = 'Kursus ada, tambahkan data ke dalamnya';
$string['existingcoursedeleting'] = 'Kursus ada, hapus terlebih dahulu';
$string['existingcreators'] = 'Pembuat kursus yang ada';
$string['existingstudents'] = 'Siswa terdaftar';
$string['existingteachers'] = 'Pengajar yang ada';
$string['expand'] = 'Memperluas';
$string['expandall'] = 'Perluas semua';
$string['expandcategory'] = 'Memperluas {$a}';
$string['explanation'] = 'Penjelasan';
$string['explanationdigitalminor'] = 'Informasi ini diperlukan untuk menentukan apakah usia Anda melebihi usia digital dari persetujuan. Ini adalah usia ketika seorang individu dapat menyetujui syarat dan ketentuan dan data mereka secara hukum disimpan dan diproses.';
$string['extendperiod'] = 'Periode perpanjangan';
$string['extendsession'] = 'Perpanjang sesi';
$string['failedloginattempts'] = '{$a->attempts} kali gagal log masuk sejak Anda terakhir masuk';
$string['failedtaskbody'] = '<p>Hai {$a->firstname},</p>
<p>Tugas <b>{$a->taskname}</b> telah gagal beberapa kali dan memerlukan perhatian.</p>
<p><a href="{$a->link}">Lihat tugas</a></p>';
$string['failedtaskcontexturlname'] = 'Laporan status';
$string['failedtasksubject'] = 'Tugas gagal: {$a}';
$string['favourites'] = 'Bertanda bintang';
$string['feedback'] = 'Umpan balik';
$string['file'] = 'Berkas';
$string['fileexists'] = 'Sudah ada berkas bernama {$a}';
$string['filemissing'] = '{$a} hilang';
$string['filereaderror'] = 'Tidak dapat membaca berkas \'{$a}\'. Harap periksa apakah sesungguhnya itu adalah berkas atau folder.';
$string['files'] = 'Berkas';
$string['filesanduploads'] = 'Berkas dan Unggahan';
$string['filesfolders'] = 'Berkas/Folder';
$string['fileuploadwithcontent'] = 'Unggahan berkas seharusnya tidak termasuk parameter konten';
$string['filloutallfields'] = 'Silakan mengisi semua item pada formulir ini';
$string['filter'] = 'Filter';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = 'Filter {$a}';
$string['filters'] = 'Filter';
$string['filtersetmatchdescription'] = 'Bagaimana beberapa filter harus digabungkan';
$string['filtertype'] = 'Jenis filter';
$string['findmorecourses'] = 'Temukan kursus lainnya...';
$string['first'] = 'Pertama';
$string['firstaccess'] = 'Akses pertama';
$string['firstname'] = 'Nama Depan';
$string['firstnamephonetic'] = 'Nama depan - fonetik';
$string['firstpage'] = 'Laman pertama';
$string['firstsiteaccess'] = 'Akses pertama kali';
$string['firsttime'] = 'Ini yang pertama kali Anda kesini?';
$string['folder'] = 'Folder';
$string['folderclosed'] = 'Folder tertutup';
$string['folderopened'] = 'Folder terbuka';
$string['followingoptional'] = 'Item berikut adalah optional';
$string['followingrequired'] = 'Item berikut adalah wajib diisi';
$string['for'] = 'Untuk';
$string['force'] = 'Paksa';
$string['forcelanguage'] = 'Paksakan bahasa';
$string['forceno'] = 'Jangan paksa';
$string['forcepasswordchange'] = 'Paksa perubahan kata sandi';
$string['forcepasswordchange_help'] = 'Jika dicentang, pengguna akan diminta untuk mengubah kata sandinya saat mereka masuk berikutnya.';
$string['forcepasswordchangecheckfull'] = 'Apakah Anda benar-benar yakin ingin memaksa perubahan sandi menjadi {$a}?';
$string['forcepasswordchangenot'] = 'Tidak bisa memaksa perubahan kata sandi untuk {$a}';
$string['forcepasswordchangenotice'] = 'Anda harus mengubah kata sandi Anda untuk memproses lebih lanjut.';
$string['forcepasswordresetfailurenotice'] = 'Kata sandi Anda saat ini tidak lagi melewati kebijakan kata sandi yang ditetapkan. Silakan hubungi administrator Moodle Anda untuk bantuan. {$a}';
$string['forcepasswordresetnotice'] = 'Kata sandi Anda saat ini tidak lagi memenuhi kebijakan kata sandi. Anda harus mengatur ulang kata sandi untuk masuk.
   {$a}';
$string['forcetheme'] = 'Paksakan tema';
$string['forgotaccount'] = 'Lupa kata sandi?';
$string['forgotten'] = 'Lupa nama pengguna dan kata sandi?';
$string['forgottenduplicate'] = 'Alamat surel digunakan bersama oleh beberapa akun, masukkan nama pengguna sebagai gantinya';
$string['forgotteninvalidurl'] = 'URL reset kata sandi tidak valid';
$string['format'] = 'Format';
$string['formathtml'] = 'Format HTML';
$string['formatmarkdown'] = 'Format markdown';
$string['formatplain'] = 'Format teks biasa';
$string['formattext'] = 'Format otomatis Moodle';
$string['forumpreferences'] = 'Preferensi forum';
$string['framesetinfo'] = 'Frameset dokumen ini berisi:';
$string['fromdate'] = 'Dari';
$string['fromsender'] = 'Dari';
$string['frontpagecategorycombo'] = 'Daftar kombo';
$string['frontpagecategorynames'] = 'Daftar kategori';
$string['frontpagecourselist'] = 'Daftar kursus';
$string['frontpagecoursesearch'] = 'Kotak pencarian kursus';
$string['frontpagedescription'] = 'Ringkasan beranda situs';
$string['frontpagedescriptionhelp'] = 'Ringkasan ini dapat ditampilkan di beranda situs menggunakan blok ringkasan kursus/situs.';
$string['frontpageenrolledcourselist'] = 'kursus terdaftar';
$string['frontpageformat'] = 'Format beranda situs';
$string['frontpageformatloggedin'] = 'Format beranda situs ketika masuk';
$string['frontpagenews'] = 'Pengumuman';
$string['frontpagesettings'] = 'Setelan beranda situs';
$string['fulllistofcourses'] = 'Semua kursus';
$string['fullname'] = 'Nama lengkap';
$string['fullnamecourse'] = 'Nama lengkap kursus';
$string['fullnamecourse_help'] = 'Nama yang ditampilkan di kursus saya dan di daftar kursus yang tersedia di halaman Beranda.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Nama lengkap';
$string['fullprofile'] = 'Profil lengkap';
$string['fullsitename'] = 'Nama lengkap situs';
$string['functiondisabled'] = 'Saat ini fungsi sedang dinonaktifkan';
$string['general'] = 'Umum';
$string['geolocation'] = 'latitude - longitude';
$string['gettheselogs'] = 'Dapatkan log ini';
$string['go'] = 'Cari';
$string['gobacktosite'] = 'Kembali ke situs';
$string['gpl'] = 'Hak Cipta (C) 1999 dan seterusnya Martin Dougiamas (http://moodle.com)

Program ini adalah perangkat lunak bebas, Anda dapat menyebarluaskannya dan / atau memodifikasinya di bawah ketentuan GNU General Public License seperti dipublikasikan oleh Free Software Foundation; baik versi 2 dari Lisensi, atau (menurut pilihan anda) versi manapun setelahnya.

Program ini didistribusikan dengan harapan akan berguna, tetapi TANPA GARANSI; tanpa garansi yang termasuk dari DAGANGAN atau KECOCOKAN UNTUK TUJUAN TERTENTU.

Lihat halaman Moodle Lisensi informasi untuk rincian lengkap: https://moodledev.io/general/license';
$string['gpl3'] = 'Hak Cipta (C) 1999 dan seterusnya Martin Dougiamas (https://moodle.com)

Program ini adalah perangkat lunak gratis: Anda dapat mendistribusikannya kembali dan/atau memodifikasinya di bawah ketentuan GNU General Public License yang diterbitkan oleh Free Software Foundation, baik versi 3 dari Lisensi, atau (sesuai pilihan Anda) versi yang lebih baru.

Program ini didistribusikan dengan harapan bermanfaat, tetapi TANPA JAMINAN APA PUN; bahkan tanpa jaminan tersirat tentang DIPERDAGANGKAN atau KESESUAIAN UNTUK TUJUAN TERTENTU.

Lihat halaman informasi Lisensi Moodle untuk detail lengkapnya:  https://moodledev.io/general/license';
$string['gpllicense'] = 'Lisensi GPL';
$string['gradable'] = 'Dapat dinilai';
$string['gradenoun'] = 'Nilai';
$string['grades'] = 'Nilai';
$string['gradeverb'] = 'Nilai';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> sudah diaktifkan di situs ini. Jika anda tidak mengunggah gambar profil, Moodle akan menampilkan gambar profil anda dari Gravatar.';
$string['group'] = 'Grup';
$string['groupadd'] = 'Tambahkan grup baru';
$string['groupaddusers'] = 'Tambahkan yang terpilih ke grup';
$string['groupfor'] = 'untuk grup';
$string['groupinfo'] = 'Info tentang grup terpilih';
$string['groupinfoedit'] = 'Edit setelan grup';
$string['groupinfomembers'] = 'Info tentang anggota terpilih';
$string['groupinfopeople'] = 'Info tentang orang terpilih';
$string['groupmembers'] = 'Anggota grup';
$string['groupmemberssee'] = 'Lihat anggota grup';
$string['groupmembersselected'] = 'Anggota dari grup terpilih';
$string['groupmode'] = 'Mode Grup';
$string['groupmodeforce'] = 'Paksa mode grup';
$string['groupmy'] = 'Grup saya';
$string['groupnonmembers'] = 'Orang di luar grup';
$string['groupnotamember'] = 'Maaf, Anda bukan anggota dari grup ini';
$string['grouprandomassign'] = 'Daftarkan secara acak pada grup';
$string['groupremove'] = 'Hapus grup terpilih';
$string['groupremovemembers'] = 'Hapus anggota terpilih';
$string['groups'] = 'Grup';
$string['groupsnone'] = 'Tanpa grup';
$string['groupsseparate'] = 'Grup terpisah';
$string['groupsvisible'] = 'Grup terlihat';
$string['guest'] = 'Tamu';
$string['guestdescription'] = 'Tamu memiliki hak yang minimal dan biasanya tidak dapat mengetik teks di mana saja.';
$string['guestskey'] = 'Bolehkan pengguna tamu dengan kunci masuk';
$string['guestsno'] = 'Tidak membolehkan pengguna tamu masuk';
$string['guestsnotallowed'] = 'Maaf, \'{$a}\' pengguna tamu tidak diizinkan masuk.';
$string['guestsyes'] = 'Bolehkan pengguna tamu tanpa kunci masuk';
$string['guestuser'] = 'Pengguna tamu';
$string['guestuserinfo'] = 'Pengguna ini adalah pengguna khusus yang diizinkan masuk dengan mode hanya-baca di beberapa kursus.';
$string['help'] = 'Bantuan';
$string['helpprefix2'] = 'Bantuan dengan {$a}';
$string['helpwiththis'] = 'Bantuan dengan ini';
$string['hiddenassign'] = 'Penugasan tersembunyi';
$string['hiddenfromstudents'] = 'Tersembunyi dari siswa';
$string['hiddenoncoursepage'] = 'Tersedia tapi tidak ditampilkan di halaman kursus';
$string['hiddensections'] = 'Bagian yang disembunyikan';
$string['hiddensections_help'] = 'Bagian tersembunyi dapat ditampilkan kepada siswa tertulis \'tidak tersedia\' di halaman kursus, atau disembunyikan sepenuhnya.';
$string['hiddensectionscollapsed'] = 'Hanya tampilkan nama bagian';
$string['hiddensectionscollapsed_description'] = 'Nama bagian ditampilkan kepada siswa, tetapi konten bagian disembunyikan.';
$string['hiddensectionsinvisible'] = 'Sembunyikan sepenuhnya';
$string['hiddensectionsinvisible_description'] = 'Bagian yang tersembunyi tidak ditampilkan kepada siswa.';
$string['hiddenwithbrackets'] = '(tersembunyi)';
$string['hide'] = 'Sembunyikan';
$string['hideadvancedsettings'] = 'Sembunyikan setelan lanjutan';
$string['hidecategory'] = 'Sembunyikan kategori?';
$string['hidecategorymany'] = 'Kategori {$a->category} berisi {$a->coursecount} kursus.
<br/>Jika Anda menyembunyikannya, pengguna yang tidak memiliki izin untuk melihat kategori tersembunyi tidak akan lagi memiliki akses ke kursus tersebut.';
$string['hidecategoryone'] = 'Kategori {$a->category} berisi 1 kursus.
<br/>Jika Anda menyembunyikannya, pengguna yang tidak memiliki izin untuk melihat kategori tersembunyi tidak akan lagi memiliki akses ke kursus tersebut.';
$string['hidechartdata'] = 'Sembunyikan data grafik';
$string['hidefromstudents'] = 'Sembunyikan di halaman kursus';
$string['hideoncoursepage'] = 'Sediakan tetapi jangan tampilkan di halaman kursus';
$string['hidepopoverwindow'] = 'Sembunyikan jendela sembulan';
$string['hidesection'] = 'Sembunyikan bagian {$a}';
$string['hidesettings'] = 'Sembunyikan setelan';
$string['hideshowblocks'] = 'Sembunyikan atau tampilkan blok';
$string['highlight'] = 'Sorotan';
$string['highlighted'] = 'Yang disorot';
$string['highlightoff'] = 'Hapus sorotan';
$string['hits'] = 'Klik';
$string['hitsoncourse'] = 'Klik pada {$a->coursename} oleh {$a->username}';
$string['hitsoncoursetoday'] = 'Klik hari ini pada {$a->coursename} oleh {$a->username}';
$string['home'] = 'Beranda';
$string['homeheader'] = 'Menu beranda';
$string['hour'] = 'jam';
$string['hours'] = 'jam';
$string['howtomakethemes'] = 'Bagaimana membuat tema baru';
$string['htmleditor'] = 'Gunakan editor HTML';
$string['htmleditoravailable'] = 'Editor HTML tersedia';
$string['htmleditordisabled'] = 'Anda telah menonaktifkan editor HTML di profil pengguna Anda';
$string['htmleditordisabledadmin'] = 'Administrator telah menonaktifkan editor HTML di situs ini';
$string['htmleditordisabledbrowser'] = 'Editor HTML tidak tersedia karena peramban web Anda tidak kompatibel';
$string['htmlfilesonly'] = 'Hanya berkas HTML';
$string['htmlformat'] = 'Format Pretty HTML';
$string['icon'] = 'Ikon';
$string['idnumber'] = 'Nomor ID';
$string['idnumbercourse'] = 'Nomor ID kursus';
$string['idnumbercourse_help'] = 'Hanya digunakan untuk menghubungkan saja dengan sistem eksternal. Biarkan kosong jika Anda tidak memiliki ID kursus resmi.';
$string['idnumbercoursecategory'] = 'Nomor ID kategori';
$string['idnumbercoursecategory_help'] = 'Nomor ID kategori kursus hanya digunakan saat mencocokkan kategori dengan sistem eksternal dan tidak ditampilkan di mana pun di situs. Jika kategori memiliki nama kode resmi, kategori tersebut dapat dimasukkan, jika tidak, kolom dapat dikosongkan.';
$string['idnumbergroup'] = 'Grup nomor ID';
$string['idnumbergroup_help'] = 'Nomor ID dari grup hanya digunakan ketika pencocokan grup terhadap sistem eksternal dan tidak ditampilkan di mana saja di dalam situs. Jika grup memiliki kode nama resmi mungkin dimasukkan, jika ruas dapat dibiarkan kosong.';
$string['idnumbergrouping'] = 'Nomor ID Pengelompokan';
$string['idnumbergrouping_help'] = 'Nomor ID dari pengelompokan hanya digunakan ketika pencocokan pengelompokan terhadap sistem eksternal dan tidak ditampilkan dimana saja di situs. Jika pengelompokan memiliki kode nama resmi itu dapat dimasukkan, jika tidak dapat dibiarkan kosong.';
$string['idnumbermod'] = 'Nomor ID';
$string['idnumbermod_help'] = 'Menetapkan nomor ID menyediakan cara mengidentifikasi aktivitas atau sumber daya untuk tujuan seperti penghitungan tingkat atau pelaporan kustom. Kalau tidak, bidang tersebut dapat dibiarkan kosong. Untuk aktivitas bertahap, nomor ID juga dapat diatur dalam buku nilai, meskipun hanya dapat diedit pada halaman setelan aktivitas.';
$string['idnumbertaken'] = 'Nomor ID ini telah digunakan';
$string['imagealt'] = 'Deskripsi gambar';
$string['import'] = 'Impor';
$string['importdata'] = 'Impor data kursus';
$string['importdataexported'] = 'Data yang diekspor dari \'from\' kursus berhasil. <br /> Lanjut masukkan ke \'to\' kursus.';
$string['importdatafinished'] = 'Impor selesai! Lanjut ke kursus Anda';
$string['importdatafrom'] = 'Cari kursus untuk mengimpor data dari:';
$string['importinfo'] = 'Impor item dari kursus lain, seperti aktivitas, blok, atau acara kalender. Tidak ada data pengguna yang akan diimpor.';
$string['inactive'] = 'Tidak Aktif';
$string['include'] = 'Sertakan';
$string['includeallusers'] = 'Sertakan semua pengguna';
$string['includecoursefiles'] = 'Sertakan berkas kursus';
$string['includecourseusers'] = 'Sertakan pengguna kursus';
$string['included'] = 'Sertakan';
$string['includelogentries'] = 'Sertakan entri log';
$string['includemodules'] = 'Sertakan modul';
$string['includemoduleuserdata'] = 'Sertakan data modul pengguna';
$string['includeneededusers'] = 'Sertakan pengguna yang dibutuhkan';
$string['includenoneusers'] = 'Jangan sertakan pengguna';
$string['includeroleassignments'] = 'Sertakan penetapan peran';
$string['includesitefiles'] = 'Sertakan berkas situs yang digunakan dalam kursus ini';
$string['includesubcategories'] = 'Sertakan subkategori';
$string['includeuserfiles'] = 'Sertakan berkas pengguna';
$string['increasesections'] = 'Tingkatkan jumlah bagian';
$string['indicator:accessesafterend'] = 'Kursus diakses setelah tanggal akhir';
$string['indicator:accessesafterend_help'] = 'Indikator ini mencerminkan jika siswa mengakses kursus setelah tanggal akhir kursus.';
$string['indicator:accessesbeforestart'] = 'Kursus diakses sebelum tanggal mulai';
$string['indicator:accessesbeforestart_help'] = 'Indikator ini mencerminkan jika siswa mengakses kursus sebelum tanggal mulai kursus.';
$string['indicator:activitiesdue'] = 'Aktivitas jatuh tempo';
$string['indicator:activitiesdue_help'] = 'Pengguna memiliki aktivitas jatuh tempo.';
$string['indicator:anycourseaccess'] = 'Setiap akses kursus';
$string['indicator:anycourseaccess_help'] = 'Indikator ini menunjukkan akses kursus yang diikuti pengguna';
$string['indicator:anywrite'] = 'Setiap aksi menulis';
$string['indicator:anywrite_help'] = 'Indikator ini mewakili setiap tindakan tulis (ajukan) yang dilakukan oleh siswa.';
$string['indicator:anywriteincourse'] = 'Tindakan menulis apapun dalam kursus';
$string['indicator:anywriteincourse_help'] = 'Indikator ini mewakili setiap tindakan tulis (ajukan) yang dilakukan oleh siswa dalam setiap aktivitas kursus.';
$string['indicator:completeduserprofile'] = 'Profil pengguna lengkap';
$string['indicator:completeduserprofile_help'] = 'Indikator ini menunjukkan bahwa siswa telah menyelesaikan profil pengguna mereka.';
$string['indicator:completeduserprofiledef'] = 'Profil pengguna sudah lengkap';
$string['indicator:completeduserprofiledef_help'] = 'Kebijakan situs telah disetujui dan pengguna telah mengisi kolom ini: Institusi, Departemen, Alamat, Kota, Negara, URL.';
$string['indicator:completionenabled'] = 'Pelacakan penyelesaian diaktifkan';
$string['indicator:completionenabled_help'] = 'Indikator ini menunjukkan bahwa pelacakan penyelesaian telah diaktifkan untuk kursus ini.';
$string['indicator:nostudent'] = 'Pendaftaran siswa';
$string['indicator:nostudent_help'] = 'Indikator ini mencerminkan ketersediaan siswa dalam kursus.';
$string['indicator:noteacher'] = 'Ketersediaan pengajar';
$string['indicator:noteacher_help'] = 'Indikator ini mencerminkan bahwa kursus ini tidak memiliki pengajar.';
$string['indicator:potentialcognitive'] = 'Kedalaman potensi kognitif kursus';
$string['indicator:potentialcognitive_help'] = 'Indikator ini didasarkan pada kedalaman potensi kognitif yang dapat dicapai oleh siswa yang mengikuti aktivitas kursus.';
$string['indicator:potentialcognitivedef'] = 'Kedalaman kognitif potensial kursus';
$string['indicator:potentialcognitivedef_help'] = 'Sejauh mana kursus tersebut menawarkan keterlibatan kognitif yang "mendalam", misalnya. penyerahan karya untuk mendapatkan umpan balik, kesempatan untuk meninjau karya orang lain, dan kesempatan untuk merevisi dan mengirimkan kembali karya.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Kursus potensi luasnya sosial';
$string['indicator:potentialsocial_help'] = 'Indikator ini didasarkan pada keluasan sosial potensial yang dapat dijangkau oleh siswa yang mengikuti aktivitas kursus.';
$string['indicator:potentialsocialdef'] = 'Keluasan sosial potensial kursus';
$string['indicator:potentialsocialdef_help'] = 'Derajat keluasan sosial yang ditawarkan, misalnya berinteraksi dengan peserta lain dan dengan komunitas lain di luar kelas.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Baca jumlah tindakan';
$string['indicator:readactions_help'] = 'Indikator ini menunjukkan jumlah tindakan baca (lihat) yang dilakukan oleh siswa.';
$string['indicator:userforumstracking'] = 'Pengguna melakukan pelacakan forum';
$string['indicator:userforumstracking_help'] = 'Indikator ini mewakili apakah siswa mengaktifkan pelacakan atau tidak dalam forum.';
$string['info'] = 'Informasi';
$string['inprogress'] = 'Dalam proses';
$string['insertcontentbefore'] = 'Sisipkan konten sebelum \'{$a->activityname}\'';
$string['insertcontentsection'] = 'Masukkan konten di bagian \'{$a->sectionname}\'';
$string['insertresourceoractivitybefore'] = 'Sisipkan aktivitas atau sumber sebelum \'{$a->activityname}\'';
$string['institution'] = 'Institusi';
$string['instudentview'] = 'Apa yang dilihat oleh siswa';
$string['interests'] = 'Minat';
$string['interestslist'] = 'Daftar kesukaan';
$string['interestslist_help'] = 'Masukkan minat Anda, satu per satu, yang kemudian akan ditampilkan pada laman profil Anda sebagai tagar.';
$string['invalidemail'] = 'Alamat surel invalid';
$string['invalidlogin'] = 'Galat saat log masuk, silakan ulang lagi';
$string['invalidtaskclassname'] = 'Class tugas tidak valid {$a}';
$string['invalidtaskid'] = 'ID tugas tidak valid';
$string['invalidusername'] = 'Nama pengguna hanya dapat berisi karakter huruf kecil alfanumerik (huruf dan angka), garis bawah (_), tanda hubung (-), titik (.) atau pada simbol (@).';
$string['invalidusernameupload'] = 'Nama pengguna tidak valid';
$string['ip_address'] = 'Alamat IP';
$string['jump'] = 'Lompat';
$string['jumpto'] = 'Lompat ke...';
$string['keep'] = 'Simpan';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Penulisan bahasa dari kiri ke kanan';
$string['langrtl'] = 'Penulisan bahasa dari kanan ke kiri';
$string['language'] = 'Bahasa';
$string['languagegood'] = 'Paket bahasa ini sudah yang terbaru.';
$string['languageselector'] = 'Pilih bahasa';
$string['last'] = 'Terakhir';
$string['lastaccess'] = 'Terakhir akses';
$string['lastcourseaccess'] = 'Terakhir akses';
$string['lastedited'] = 'Terakhir diubah';
$string['lastip'] = 'Terakhir diubah';
$string['lastlogin'] = 'Log masuk terakhir';
$string['lastmodified'] = 'Terakhir diubah';
$string['lastname'] = 'Nama akhir';
$string['lastnamephonetic'] = 'Nama belakang - fonetik';
$string['lastpage'] = 'Laman terakhir';
$string['lastsiteaccess'] = 'Akses terakhir ke situs';
$string['lastyear'] = 'Tahun lalu';
$string['latestlanguagepack'] = 'Periksa paket bahasa terbaru pada moodle.org';
$string['layouttable'] = 'Tata letak tabel';
$string['leavetokeep'] = 'Biarkan kosong untuk memakai kata sandi yang lama';
$string['legacylogginginuse'] = 'Situs ini saat ini mengaktifkan penulisan ke penyimpanan log lama. Menulis ke penyimpanan log ini sudah tidak digunakan lagi. Silakan tulis ke penyimpanan log yang didukung seperti "standar" atau "eksternal".';
$string['legacythemeinuse'] = 'Situs ini ditampilkan dalam modus kompatibilitas dikarenakan peramban Anda terlalu tua.';
$string['license'] = 'Lisensi';
$string['licenses'] = 'Lisensi';
$string['liketologin'] = 'Apakah Anda ingin masuk sekarang dengan akun pengguna penuh?';
$string['list'] = 'Daftar';
$string['listfiles'] = 'Daftar berkas pada {$a}';
$string['listofallpeople'] = 'Daftar anggota';
$string['listofcourses'] = 'Daftar kursus';
$string['loading'] = 'Memuat';
$string['loadinghelp'] = 'Memuat...';
$string['local'] = 'Lokal';
$string['localplugins'] = 'Pengaya lokal';
$string['localpluginsmanage'] = 'Mengelola pengaya lokal';
$string['location'] = 'Lokasi';
$string['locktimeout'] = 'Kehabisan waktu ketika menunggu penguncian.';
$string['log_excel_date_format'] = 'd mmmm yyyy h:mm';
$string['loggedinas'] = 'Anda masuk sebagai {$a}';
$string['loggedinasguest'] = 'Anda sedang menggunakan akses tamu';
$string['loggedinnot'] = 'Anda belum masuk.';
$string['login'] = 'Masuk';
$string['login_failure_logs'] = 'Log masuk yang gagal';
$string['loginactivity'] = 'Aktivitas log masuk';
$string['loginagain'] = 'Login kembali';
$string['loginalready'] = 'Anda telah masuk';
$string['loginas'] = 'Masuk sebagai';
$string['loginaspasswordexplain'] = '<p>Anda harus memasukkan "kata kunci untuk masuk" spesial untuk menggunakan fitur ini.<br />Jika anda tidak tahu, tanyakan administrator server.</p>';
$string['loginguest'] = 'Akses sebagai tamu';
$string['loginsite'] = 'Masuk ke situs';
$string['loginsteps'] = 'Untuk akses penuh ke situs ini, Anda harus membuat akun terlebih dahulu.';
$string['loginstepsnone'] = '<p>Hai!</p><p>Untuk akses penuh pada kursus, Anda perlu membuat keanggotaan Anda sendiri.</p><p>Yang harus Anda lakukan adalah buatlah nama pengguna dan kata sandi dan gunakanlah pada formulir di halaman ini!</p><p>Jika orang lain telah menggunakan nama pengguna yang Anda pilih maka Anda harus mencoba kembali dengan menggunakan nama pengguna yang lain.</p>';
$string['loginto'] = 'Masuk ke {$a}';
$string['logoof'] = 'Logo dari {$a}';
$string['logout'] = 'Keluar';
$string['logoutconfirm'] = 'Apakah Anda benar-benar ingin keluar?';
$string['logs'] = 'Log';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">lagi</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">lagi</a> ]';
$string['lookback'] = 'Lihat sebelumnya';
$string['mailadmins'] = 'Beritahukan admin';
$string['mailstudents'] = 'Beritahukan siswa';
$string['mailteachers'] = 'Beritahukan pengajar';
$string['maincoursepage'] = 'Halaman utama kursus';
$string['makeafolder'] = 'Buat folder';
$string['makeavailable'] = 'Jadikan tersedia';
$string['makeeditable'] = 'Jika Anda membuat \'{$a}\' dapat diedit dengan proses server web (mis Apache2) lalu Anda dapat mengubah berkas ini secara langsung dari laman ini';
$string['makethismyhome'] = 'Jadikan halaman ini menjadi beranda bawaan saya';
$string['makeunavailable'] = 'Jadikan tidak tersedia';
$string['manageblocks'] = 'Blok';
$string['managecategories'] = 'Kelola kategori kursus';
$string['managecategorythis'] = 'Kelola kategori ini';
$string['managecombined'] = 'Kelola kategori dan kursus';
$string['managecontentbanktypes'] = 'Kelola tipe konten';
$string['managecourses'] = 'Mengelola kursus';
$string['managedatabase'] = 'Basis data';
$string['managedataformats'] = 'Atur format data';
$string['manageeditorfiles'] = 'Atur berkas yang digunakan oleh editor';
$string['managefilters'] = 'Filter';
$string['managemodules'] = 'Modul';
$string['manageroles'] = 'Peran dan perizinan';
$string['markallread'] = 'Tandai semua telah dibaca';
$string['match'] = 'Cocok';
$string['matchingsearchandrole'] = 'Pencocokan \'{$a->search}\' dan {$a->role}';
$string['matchofthefollowing'] = 'dari berikut ini:';
$string['maxareabytesreached'] = 'Berkas (atau total ukuran beberapa berkas) lebih besar dari ruang tersisa di area ini.';
$string['maxfilesize'] = 'Ukuran maksimum untuk berkas baru: {$a}';
$string['maxfilesreached'] = 'Anda diperbolehkan untuk melampirkan maksimal {$a} berkas untuk item ini';
$string['maximumchars'] = 'Maksimum dari {$a} karakter';
$string['maximumgrade'] = 'Nilai maksimum';
$string['maximumgradex'] = 'Nilai Maksimum: {$a}';
$string['maximumshort'] = 'Maks';
$string['maximumupload'] = 'Ukuran unggah maksimum';
$string['maximumupload_help'] = 'Ukuran berkas maksimum yang diizinkan untuk diunggah siswa ke kursus. Selain itu, Anda juga dapat membatasi ukuran unggahan maksimum untuk setiap aktivitas.';
$string['maxlengthreached'] = 'Batas karakter maksimum {$a} telah tercapai.';
$string['maxnumberweeks'] = 'Jumlah maksimum bagian (tidak berlaku)';
$string['maxnumberweeks_desc'] = 'Nilai maksimum dalam menu drop-down jumlah bagian (hanya berlaku untuk format kursus tertentu). Setelan ini sudah tidak berlaku lagi dan akan dihapus di versi Moodle mendatang. Harap gunakan setelan format kursus sebagai gantinya.';
$string['maxnumcoursesincombo'] = 'Jelajahi <a href="{$a->link}">{$a->numberofcourses} kursus</a>.';
$string['maxsectionslimit'] = 'Tidak dapat membuat bagian baru karena akan melebihi jumlah maksimum bagian yang diperbolehkan untuk mata kursus ini ({$a}).';
$string['maxsize'] = 'Ukuran tertinggi: {$a}';
$string['maxsizeandareasize'] = 'Ukuran maksimal untuk file baru: {$a->size}, batas keseluruhan: {$a->areasize}';
$string['maxsizeandattachments'] = 'Ukuran maksimum untuk berkas baru: {$a->size}, lampiran maksimum: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Ukuran maksimum untuk berkas baru: {$a->size}, lampiran maksimum: {$a->attachments}, batas keseluruhan: {$a->areasize}';
$string['memberincourse'] = 'Orang-orang dalam kursus';
$string['menu'] = 'Menu';
$string['message'] = 'Pesan';
$string['messagebody'] = 'Isi pesan';
$string['messagedselectedusers'] = 'Pengguna terpilih telah dikirimi pesan dan daftar penerima sudah direset.';
$string['messagedselectedusersfailed'] = 'Sesuatu yang salah saat pengiriman pesan ke pengguna terpilih. Beberapa pengguna mungkin telah menerima surel.';
$string['messageprovider:asyncbackupnotification'] = 'Cadangan asinkron/pulihkan notifikasi';
$string['messageprovider:availableupdate'] = 'Pemberitahuan pembaruan yang tersedia';
$string['messageprovider:backup'] = 'Pemberitahuan pencadangan';
$string['messageprovider:badgecreatornotice'] = 'Pemberitahuan pembuat lencana';
$string['messageprovider:badgerecipientnotice'] = 'Pemberitahuan penerima lencana';
$string['messageprovider:competencyplancomment'] = 'Komentar dikirimikan pada rencana pembelajaran';
$string['messageprovider:competencyusercompcomment'] = 'Komentar dikirim pada kompetensi';
$string['messageprovider:coursecompleted'] = 'Kursus selesai';
$string['messageprovider:coursecontentupdated'] = 'Perubahan konten kursus';
$string['messageprovider:courserequestapproved'] = 'Notifikasi persetujuan permintaan pembuatan kursus';
$string['messageprovider:courserequested'] = 'Notifikasi permintaan pembuatan kursus';
$string['messageprovider:courserequestrejected'] = 'Notifikasi penolakan permintaan pembuatan kursus';
$string['messageprovider:enrolcoursewelcomemessage'] = 'Pesan selamat datang untuk pendaftaran kursus baru';
$string['messageprovider:errors'] = 'Galat penting di situs';
$string['messageprovider:errors_help'] = 'Ini adalah galat penting yang wajib diketahui oleh administrator.';
$string['messageprovider:failedtaskmaxdelay'] = 'Tugas mencapat batas maksimum penundaan kegagalan';
$string['messageprovider:gradenotifications'] = 'Notifikasi penilaian';
$string['messageprovider:infected'] = 'Pemberitahuan kegagalan antivirus.';
$string['messageprovider:insights'] = 'Wawasan yang dihasilkan oleh model prediksi';
$string['messageprovider:instantmessage'] = 'Pesan pribadi antarpengguna';
$string['messageprovider:instantmessage_help'] = 'Bagian ini mengatur bagaimana pesan yang dikirimkan ke anda dari pengguna lain di situs ini.';
$string['messageprovider:messagecontactrequests'] = 'Kontak pesan meminta pemberitahuan';
$string['messageprovider:newlogin'] = 'Notifikasi log masuk baru';
$string['messageprovider:notices'] = 'Pemberitahuan tentang masalah kecil';
$string['messageprovider:notices_help'] = 'Ini adalah pemberitahuan bahwa administrator mungkin tertarik melihatnya.';
$string['messageprovider:reportbuilderschedule'] = 'Jadwal pembuat laporan kustom';
$string['messageselect'] = 'Pilih pengguna ini sebagai penerima surel';
$string['messageselectadd'] = 'Kirim pesan';
$string['middlename'] = 'Nama tengah';
$string['migratinggrades'] = 'Migrasi nilai';
$string['min'] = 'min';
$string['mins'] = 'min';
$string['minute'] = 'menit';
$string['minutes'] = 'menit';
$string['miscellaneous'] = 'Lain-lain';
$string['missingcategory'] = 'Anda perlu memilih kategori';
$string['missingdescription'] = 'Deskripsi tidak diisi';
$string['missingemail'] = 'Alamat surel tidak diisi';
$string['missingfirstname'] = 'Nama depan tidak diisi';
$string['missingfromdisk'] = 'Hilang dari diska';
$string['missingfullname'] = 'Nama lengkap tidak diisi';
$string['missinglastname'] = 'Nama akhir tidak diisi';
$string['missingname'] = 'Nama tidak diisi';
$string['missingnewpassword'] = 'Kata sandi baru tidak diisi';
$string['missingpassword'] = 'Kata sandi tidak diisi';
$string['missingrecaptchachallengefield'] = 'Tantangan reCAPTCHA gagal, coba lagi.';
$string['missingreqreason'] = 'Alasan tidak diisi';
$string['missingshortname'] = 'Nama singkat tidak diisi';
$string['missingshortsitename'] = 'Nama singkat situs tidak diisi';
$string['missingsitedescription'] = 'Keterangan situs tidak diisi';
$string['missingsitename'] = 'Nama situs tidak diisi';
$string['missingstrings'] = 'Periksa kata atau frasa yang belum diterjemahkan';
$string['missingstudent'] = 'Harus memilih sesuatu';
$string['missingsummary'] = 'Ringkasan kosong';
$string['missingteacher'] = 'Harus memilih sesuatu';
$string['missingurl'] = 'URL tidak diis';
$string['missingusername'] = 'Nama pengguna tidak diisi';
$string['moddoesnotsupporttype'] = 'Modul {$a->modname} tidak mendukung pengunggahan tipe berkas {$a->type}';
$string['modhide'] = 'Sembunyikan';
$string['modified'] = 'Diubah';
$string['modshow'] = 'Tampilkan';
$string['moduleintro'] = 'Deskripsi';
$string['modulesetup'] = 'Membuat tabel modul';
$string['modulesuccess'] = '{$a} tabel telah berhasil dibuat';
$string['modulesused'] = 'Modul yang digunakan';
$string['modvisible'] = 'Ketersediaan';
$string['modvisible_help'] = '* Tampilkan di halaman kursus: Tersedia untuk siswa (tunduk pada batasan akses apa pun yang mungkin diatur).
* Sembunyikan di halaman kursus: Tidak tersedia untuk siswa.';
$string['modvisiblehiddensection'] = 'Ketersediaan';
$string['modvisiblehiddensection_help'] = '* Sembunyikan di halaman kursus: Tidak tersedia untuk siswa.
* Sediakan tetapi jangan tampilkan di halaman kursus: Tersedia untuk siswa jika Anda memberikan tautan. Aktivitas akan tetap muncul di buku nilai dan laporan lainnya.';
$string['modvisiblewithstealth'] = 'Ketersediaan';
$string['modvisiblewithstealth_help'] = '* Tampilkan di halaman kursus: Tersedia untuk siswa (tunduk pada batasan akses apa pun yang mungkin diatur).
* Sembunyikan di halaman kursus: Tidak tersedia untuk siswa.
* Sediakan tetapi jangan tampilkan di halaman kursus: Tersedia untuk siswa jika Anda memberikan tautan. Aktivitas akan tetap muncul di buku nilai dan laporan lainnya.';
$string['month'] = 'Bulan';
$string['months'] = 'Bulan';
$string['moodledocs'] = 'Dokumen Moodle';
$string['moodledocslink'] = 'Dokumentasi untuk halaman ini';
$string['moodlelogo'] = 'Logo Moodle';
$string['moodlenet:cannotconnecttoserver'] = 'Tidak dapat terhubung ke server MoodleNet';
$string['moodlenet:columnname'] = 'Nama';
$string['moodlenet:columnsenddate'] = 'Tanggal kirim';
$string['moodlenet:columnsendstatus'] = 'Status kiriman';
$string['moodlenet:columntype'] = 'Tipe';
$string['moodlenet:configoauthservice'] = 'Pilih layanan MoodleNet OAuth 2 untuk mengaktifkan berbagi ke situs MoodleNet tersebut. Jika layanan belum ada, Anda harus <a href="{$a}">membuatnya</a>.';
$string['moodlenet:deletedactivity'] = 'Aktivitas yang dihapus';
$string['moodlenet:deletedcourse'] = 'Kursus yang dihapus';
$string['moodlenet:eventresourceexported'] = 'Sumber diekspor';
$string['moodlenet:gotomoodlenet'] = 'Buka draf MoodleNet';
$string['moodlenet:issuerisnotauthorized'] = 'Penerbit MoodleNet tidak diotorisasi';
$string['moodlenet:issuerisnotenabled'] = 'Penerbit MoodleNet tidak diaktifkan';
$string['moodlenet:issuerisnotset'] = 'Penerbit MoodleNet tidak diatur pada administrasi situs';
$string['moodlenet:nosharedresources'] = 'Tidak ada sumber daya bersama untuk ditampilkan saat ini.';
$string['moodlenet:outboundsettings'] = 'Setelan keluar MoodleNet';
$string['moodlenet:packagingandsending'] = 'Mengemas berkas Anda dan mengirimkannya ke MoodleNet...';
$string['moodlenet:sharefailtext'] = 'Galat saat membagikan konten Anda ke MoodleNet.<br>Coba lagi nanti.';
$string['moodlenet:sharefailtextwithsitesupport'] = 'Galat saat membagikan konten Anda ke MoodleNet.<br>Silakan coba lagi nanti atau <a href="{$a}">hubungi dukungan situs</a>.';
$string['moodlenet:sharefailtitle'] = 'Ada yang salah';
$string['moodlenet:sharefilesizelimitexceeded'] = 'Ukuran sumber yang dibagikan ({$a->filesize} byte) melebihi batas {$a->filesizelimit} byte.';
$string['moodlenet:sharenoticeactivity'] = 'Aktivitas ini dibagikan dengan MoodleNet sebagai sumber daya.';
$string['moodlenet:sharenoticecourse'] = 'Kursus ini dibagikan dengan MoodleNet sebagai sumber daya.';
$string['moodlenet:sharenoticepartial'] = 'Aktivitas yang dipilih dibagikan dengan MoodleNet sebagai sumber daya.';
$string['moodlenet:sharenoticepartialactivitynumber'] = '{$a} aktivitas akan disertakan dalam kursus.';
$string['moodlenet:shareprogress'] = 'MoodleNet membagikan progres';
$string['moodlenet:shareprogressinfo'] = 'Daftar tersebut menunjukkan kursus dan aktivitas yang telah Anda bagikan ke MoodleNet.<br>Klik nama sumber untuk melihatnya di MoodleNet.';
$string['moodlenet:sharesuccesstext'] = 'Hampir selesai! Kunjungi draf Anda di MoodleNet untuk menyelesaikan berbagi konten Anda.';
$string['moodlenet:sharesuccesstitle'] = 'Disimpan ke draf MoodleNet';
$string['moodlenet:sharetomoodlenet'] = 'Bagikan ke MoodleNet';
$string['moodlenet:sharinglargefile'] = 'File besar dapat memakan waktu.';
$string['moodlenet:sharingstatus'] = 'Berbagi ke MoodleNet';
$string['moodlenet:sharingto'] = 'Bagikan kepada:';
$string['moodlerelease'] = 'Rilis moodle';
$string['moodleservicesandsupport'] = 'Layanan dan dukungan';
$string['moodleversion'] = 'Versi Moodle';
$string['more'] = 'selanjutnya';
$string['moreactions'] = 'Aksi lainnya';
$string['morehelp'] = 'Bantuan labih lanjut';
$string['morehelpaboutmodule'] = 'Bantuan lain tentang aktivitas {$a}';
$string['moreinfo'] = 'Info lebih lanjut';
$string['moreinformation'] = 'Informasi selanjutnya mengenai galat ini';
$string['moremenu'] = 'Selengkapnya';
$string['morenavigationlinks'] = 'Selengkapnya...';
$string['moreprofileinfoneeded'] = 'Beritahu kami tentang diri Anda';
$string['mostrecently'] = 'yang terbaru';
$string['move'] = 'Pindahkan';
$string['movecategoriessuccess'] = 'Berhasil memindahkan {$a->count} kategori ke kategori \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = 'Berhasil memindahkan {$a->count} kategori ke tingkat atas';
$string['movecategorycontentto'] = 'Pindah ke';
$string['movecategorysuccess'] = 'Berhasil memindahkan kategori \'{$a->moved}\' ke kategori \'{$a->to}\'';
$string['movecategoryto'] = 'indahkan kategori ke:';
$string['movecategorytotopsuccess'] = 'Berhasil memindahkan kategori \'{$a->moved}\' ke tingkat puncak';
$string['movecontent'] = 'indahkan {$a}';
$string['movecontentafter'] = 'Setelah "{$a}"';
$string['movecontentstoanothercategory'] = 'Pindahkan konten ke kategori lain';
$string['movecontenttothetop'] = 'Ke puncak daftar';
$string['movecoursemodule'] = 'Pindah aktivitas';
$string['movecoursesection'] = 'Pindah bagian';
$string['movecourseto'] = 'Pindahkan kursus ke:';
$string['movedown'] = 'Pindah ke bawah';
$string['movefilestohere'] = 'Pindahkan berkas ke sini';
$string['movefull'] = 'Pindahkan {$a} ke lokasi ini';
$string['movehere'] = 'Pindahkan ke sini';
$string['moveitemdown'] = 'Pindah {$a} ke bawah';
$string['moveitemup'] = 'Pindah {$a} ke atas';
$string['moveleft'] = 'Geser ke kiri';
$string['moveright'] = 'Geser ke kanan';
$string['movesection'] = 'Pindahkan bagian {$a}';
$string['moveselectedcategoriesto'] = 'Pindah kategori terpilih ke';
$string['moveselectedcoursesto'] = 'Pindah kursus terpilih ke...';
$string['movetoanotherfolder'] = 'Pindah ke folder yang lain';
$string['moveup'] = 'Pindah ke atas';
$string['multipleitemsfound'] = 'Ada {$a} item yang ditemukan.';
$string['mustchangepassword'] = 'Kata sandi baru harus berbeda dengan kata sandi saat ini';
$string['mustconfirm'] = 'Anda perlu mengkonfirmasi akun Anda';
$string['mycourses'] = 'Kursusku';
$string['myfiles'] = 'Berkas pribadi saya';
$string['myfilesmanage'] = 'Mengelola berkas pribadi saya';
$string['myhome'] = 'Dasbor';
$string['mymoodledashboard'] = 'Dasbor Moodle saya';
$string['myprofile'] = 'Profil saya';
$string['name'] = 'Nama';
$string['namedfiletoolarge'] = 'Bersih \'{$a->filename}\' terlalu besar dan tidak dapat diunggah';
$string['nameforlink'] = 'Apa nama yang Anda inginkan untuk tautan ini?';
$string['nameforpage'] = 'Nama';
$string['navigation'] = 'Navigasi';
$string['needed'] = 'Diperlukan';
$string['networkdropped'] = 'Kami mendeteksi bahwa koneksi Internet Anda tidak dapat diandalkan atau telah terganggu. <br /> Perlu diketahui bahwa perubahan tidak dapat disimpan dengan baik sampai koneksi Anda membaik.';
$string['never'] = 'Tidak pernah';
$string['neverdeletelogs'] = 'Jangan pernah menghapus log';
$string['new'] = 'Baru';
$string['newaccount'] = 'Akun baru';
$string['newactivityname'] = 'Nama baru untuk aktivitas {$a}';
$string['newcourse'] = 'Kursus baru';
$string['newloginnotificationbodyfull'] = '<p>Hai {$a->userfullname},</p>
<p>Akun Anda pada {$a->sitename} baru saja masuk dari perangkat baru.</p> <ul>
 <li>Akun Anda: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Perangkat: {$a->logindevice}</li>
<li>IP: {$a->loginip}</li>
</ul>
<p>Jika ini Anda, maka Anda dapat abaikan pesan ini.</p> <p>Jika Anda tidak mengenali aktivitas ini, harap  <a href="{$a->changepasswordlink}">ubah sandi Anda</a></p>';
$string['newloginnotificationbodysmall'] = 'Akun {$a} Anda baru saja masuk dari perangkat baru.';
$string['newloginnotificationtitle'] = 'Anda baru saja log masuk ke akun {$a}';
$string['newpassword'] = 'Kata sandi baru';
$string['newpassword_help'] = 'Masukkan kata sandi baru atau kosongkan untuk menggunakan kata sandi saat ini.';
$string['newpasswordfromlost'] = '<strong> PEMBERITAHUAN: </strong> <strong> kata sandi sekarang </strong> akan dikirim kepada Anda dalam <strong> beberapa detik </strong> dari dua surel yang dikirim sebagai bagian dari proses pemulihan sandi hilang. Pastikan Anda telah menerima sandi pengganti Anda sebelum melanjutkan dengan layar ini.';
$string['newpasswordtext'] = 'Hallo {$a->firstname},

Kata sandi akun Anda pada \'{$a->sitename}\' telah direset dan Anda telah dikirimi sandi sementara yang baru. Informasi log masuk Anda yang terbaru sekarang:
Nama pengguna: {$a->username}
Sandi : {$a->newpassword}

Silakan masuk ke halaman ini untuk mengganti kata sandi Anda:
{$a->link}

Pada kebanyakan program penerima surel, ini akan ditampilkan sebagai tautan berwarna biru yang langsung dapat Anda klik. Jika ini tidak berfungsi, maka Anda dapat menyorot kemudian menyalin alamat ini dan tempelkan pada baris pengisian alamat pada bagian atas  peramban Anda.

Salam dari kami, administrator situs \'{$a->sitename}\',
{$a->signoff}';
$string['newpicture'] = 'Foto baru';
$string['newpicture_help'] = 'Untuk menambahkan gambar baru, telusuri dan pilih gambar (dalam format JPG atau PNG), lalu klik "Perbarui profil". Gambar akan dipangkas hingga persegi dan diubah ukurannya menjadi 100x100 piksel.';
$string['newpictureusernotsetup'] = 'Gambar profil hanya dapat ditambahkan setelah semua informasi profil yang diperlukan telah disimpan.';
$string['newsectionname'] = 'Nama baru untuk bagian {$a}';
$string['newsitem'] = 'item berita';
$string['newsitems'] = 'pengumuman';
$string['newsitemsnumber'] = 'Jumlah pengumuman';
$string['newsitemsnumber_help'] = 'Forum pengumuman telah memaksa langganan ditetapkan secara bawaan. Hanya guru dan pengguna lain dengan izin yang sesuai yang dapat mengirim di dalamnya.

Jika Anda tidak memerlukan forum pengumuman, setel ke nol.

Setelan ini juga menentukan berapa banyak pengumuman terbaru yang muncul di blok pengumuman terbaru.';
$string['newuser'] = 'Pengguna baru';
$string['newusernewpasswordsubj'] = 'Akun pengguna baru';
$string['newusernewpasswordtext'] = 'Hai {$a->firstname},

Akun baru telah dibuat untuk Anda di \'{$a->sitename}\'.

    nama pengguna: {$a->username}
    kata sandi: {$a->newpassword}

(Anda harus mengganti kata sandi ketika nanti masuk untuk pertama kalinya)

Untuk memulai menggunakan \'{$a->sitename}\', silakan masuk pada
    {$a->link}

Jika Anda memerlukan bantuan, Anda dapat menghubungi administrator situs, {$a->signoff}';
$string['newusers'] = 'Pengguna baru';
$string['newwindow'] = 'Jendela baru';
$string['next'] = 'Selanjutnya';
$string['nextpage'] = 'Laman selanjutnya';
$string['nextsection'] = 'Bagian selanjutnya';
$string['no'] = 'Tidak';
$string['noblockstoaddhere'] = 'Tidak ada blok yang dapat Anda tambahkan di halaman ini.';
$string['nobody'] = 'Tiada seorang pun';
$string['nochange'] = 'Tidak ada perubahan';
$string['nocomments'] = 'Tidak ada komentar';
$string['nocourses'] = 'Tidak ada kursus';
$string['nocoursesfound'] = 'Tidak ditemukan kursus dengan kata kunci \'{$a}\'';
$string['nocoursestarttime'] = 'Kursus ini tidak memiliki waktu mulai';
$string['nocoursesyet'] = 'Belum ada kursus pada kategori ini';
$string['nodstpresets'] = 'Administrator belum mengaktifkan dukungan Waktu Musim Panas.';
$string['nofilesselected'] = 'Belum ada berkas terpilih untuk dipulihkan';
$string['nofilesyet'] = 'Belum ada berkas yang diunggah untuk kursus Anda';
$string['nofiltersapplied'] = 'Tidak ada filter diterapkan';
$string['nograde'] = 'Tidak ada nilai';
$string['nohelpforactivityorresource'] = 'Saat ini tidak ada bantuan yang terkait dengan sumber atau aktivitas ini';
$string['noimagesyet'] = 'Belum ada gambar yang diunggah untuk kursus Anda';
$string['noitemsfound'] = 'Tidak ada item yang ditemukan.';
$string['nologsfound'] = 'Tidak ada log ditemukan';
$string['nomatchingusers'] = 'Tidak ada pengguna yang cocok \'{$a}\'';
$string['nomorecourses'] = 'Belum ada kursus yang cocok ditemukan';
$string['nomoreidnumber'] = 'Tidak menggunakan nomor ID untuk menghindari tabrakan (ID yang sama)';
$string['none'] = 'Tidak ada';
$string['noneditingteacher'] = 'Pengajar noneditor';
$string['noneditingteacherdescription'] = 'Pengajar Noneditor dapat mengajar kursus dan menilai siswa, namun tidak dapat mengubah aktivitas.';
$string['nonstandard'] = 'Tidak standar';
$string['nopendingcourses'] = 'Tidak ada izin menunda kursus';
$string['nopotentialadmins'] = 'Belum ada yang berpotensi sebagai admin';
$string['nopotentialcreators'] = 'Belum ada yang memiliki potensi sebagai pembuat kursus';
$string['nopotentialstudents'] = 'Belum ada yang berpotensi sebagai siswa';
$string['nopotentialteachers'] = 'Tidak ada pengajar potensial';
$string['norecentactivity'] = 'Tidak ada aktivitas terkini';
$string['noreplybouncemessage'] = 'Anda membalas ke alamat surel no-reply. Jika Anda mencoba untuk membalas ke forum, harap menggunakan forum {$a}. Berikut adalah isi dari surel Anda:';
$string['noreplybouncesubject'] = '{$a} - surel yang ditolak.';
$string['noreplyname'] = 'Jangan membalas surel ini';
$string['noresetrecord'] = 'Tidak ada catatan permintaan reset kata sandi. Silakan melakukan permintaan reset kata sandi baru.';
$string['noresults'] = 'Tidak ada hasil';
$string['noresultsfor'] = 'Tidak ada hasil untuk "{$a}"';
$string['noresultsfor_help'] = 'Periksa ejaan Anda atau coba kata lain.';
$string['normal'] = 'Normal';
$string['normalfilter'] = 'Pencarian normal';
$string['nosite'] = 'Tidak dapat menemukan kursus setingkat situs';
$string['nostudentsfound'] = '{$a} tidak ditemukan';
$string['nostudentsingroup'] = 'Belum ada siswa dalam grup ini sekarang';
$string['nostudentsyet'] = 'Belum ada siswa yang mendaftar pada kursus ini';
$string['nosuchemail'] = 'Bukan alamat surel';
$string['notavailable'] = 'Tidak tersedia';
$string['notavailablecourse'] = '{$a} tidak tersedia';
$string['noteachersyet'] = 'Belum ada pengajar untuk kursus ini';
$string['noteachingupcomingcourses'] = 'Kursus mendatang belum memiliki pengajar atau siswa';
$string['notenrolled'] = '{$a} tidak terdaftar pada kursus ini.';
$string['notenrolledprofile'] = 'Profil ini belum tersedia karena pengguna belum didaftarkan di kursus ini.';
$string['noteusercannotrolldatesoncontext'] = '<strong> Catatan: </ strong> Kemampuan untuk menggulung tanggal ketika memulihkan cadangan ini telah dinonaktifkan karena Anda tidak memiliki izin yang diperlukan.';
$string['noteuserschangednonetocourse'] = '<strong>Catatan: </strong> Pengguna kursus perlu dipulihkan ketika sedang memulihkan data pengguna (dalam aktivitas, berkas atau pesan). Setelan ini telah diubah untuk Anda.';
$string['nothingnew'] = 'Tidak ada aktivitas terbaru';
$string['nothingtodisplay'] = 'Tidak ada yang ditampilkan';
$string['notice'] = 'Perhatian';
$string['noticenewerbackup'] = 'Berkas cadangan ini telah dibuat oleh Moodle {$a->backuprelease} ({$a->backupversion}) dan ini lebih baru dari Moodle yang terinstal saat ini {$a->serverrelease} ({$a->serverversion}). Hal ini dapat menyebabkan beberapa inkonsistensi karena kompatibilitas berkas cadangan versi sebelumnya yang tidak dapat dijamin.';
$string['notifications'] = 'Notifikasi';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Pengguna: {$a->info}, Nama lengkap pengguna: {$a-> name}';
$string['notifyloginfailuresmessageend'] = 'Anda dapat melihat log ini di {$a}';
$string['notifyloginfailuresmessagestart'] = 'Berikut adalah daftar dari usaha login gagal pada {$a} sejak terakhir Anda diberitahu';
$string['notifyloginfailuressubject'] = '{$a} :: Notifikasi Login yang gagal';
$string['notincluded'] = 'Tidak disertakan';
$string['notingroup'] = 'Maaf, tapi Anda harus menjadi bagian dari grup untuk melihat aktivitas ini.';
$string['notpublic'] = 'Tidak untuk umum!';
$string['nousersfound'] = 'Tidak ada pengguna yang ditemukan';
$string['nousersmatching'] = 'Tidak ditemukan \'{$a}\' yang cocok';
$string['nousersyet'] = 'Belum ada pengguna saat ini';
$string['novalidcourses'] = 'Tidak ada kursus yang valid untuk ditampilkan';
$string['now'] = 'sekarang';
$string['numattempts'] = '{$a} upaya masuk gagal';
$string['numberofcourses'] = 'Jumlah kursus';
$string['numberweeks'] = 'Jumlah bagian';
$string['numday'] = '{$a} hari';
$string['numdays'] = '{$a} hari';
$string['numhours'] = '{$a} jam';
$string['numletters'] = '{$a} surat';
$string['numminutes'] = '{$a} menit';
$string['nummonth'] = '{$a} bulan';
$string['nummonths'] = '{$a} bulan';
$string['numseconds'] = '{$a} detik';
$string['numviews'] = '{$a} tampilan';
$string['numweek'] = '{$a} minggu';
$string['numweeks'] = '{$a} minggu';
$string['numwords'] = '{$a} kata';
$string['numyear'] = '{$a} tahun';
$string['numyears'] = '{$a} tahun';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Kata sandi saat ini';
$string['olduserdirectory'] = 'Ini adalah direktori pengguna LAMA, dan tidak lagi diperlukan. Anda dapat menghapusnya dengan aman. Berkas di dalamnya telah disalin ke direktori pengguna BARU.';
$string['oneitemfound'] = 'Ditemukan 1 item.';
$string['opendrawerblocks'] = 'Buka laci blok';
$string['opendrawerindex'] = 'Buka indeks kursus';
$string['opensinnewwindow'] = 'Buka di jendela baru';
$string['operator_and'] = 'dan';
$string['operator_andnot'] = 'dan';
$string['operator_or'] = 'atau';
$string['optional'] = 'opsional';
$string['options'] = 'pilihan';
$string['order'] = 'Urutan';
$string['originalpath'] = 'Lokasi awal';
$string['orphanedactivitiesinsectionno'] = 'Aktivitas tidak lengkap (bagian {$a})';
$string['other'] = 'Lainnya';
$string['outline'] = 'Garis besar';
$string['outlinereport'] = 'Ikhtisar laporan';
$string['page'] = 'Halaman';
$string['pagea'] = 'Halaman {$a}';
$string['pagedcontentnavigation'] = 'Navigasi paginasi';
$string['pagedcontentnavigationactiveitem'] = 'Halaman saat ini, halaman {$a}';
$string['pagedcontentnavigationitem'] = 'Buka halaman {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Menampilkan {$a} item per halaman';
$string['pageheaderconfigablock'] = 'Mengkonfigurasi blok dalam {$a->fullname}';
$string['pagepath'] = 'Lokasi halaman';
$string['pageshouldredirect'] = 'Halaman ini akan secara otomatis dialihkan. Jika tidak ada yang terjadi, silakan gunakan tautan lanjutkan di bawah ini.';
$string['parentcategory'] = 'Kategori induk';
$string['parentcoursenotfound'] = 'Kursus induk tidak ditemukan!';
$string['parentfolder'] = 'Folder induk';
$string['participants'] = 'Peserta';
$string['participantslist'] = 'Daftar peserta';
$string['participationratio'] = 'Rasio partisipasi';
$string['participationreport'] = 'Laporan partisipasi';
$string['password'] = 'Kata sandi';
$string['passwordchanged'] = 'Kata sandi telah diubah';
$string['passwordextlink'] = 'Tautan berikut telah disediakan untuk memulihkan kata sandi yang hilang. Ini akan membawa Anda keluar dari Moodle.';
$string['passwordforgotten'] = 'Lupa kata sandi';
$string['passwordforgotteninstructions'] = 'Rincian Anda pertama-tama harus ditemukan di basis data pengguna. Harap masukkan <strong> baik </ strong> nama pengguna atau alamat surel terdaftar Anda di kotak yang sesuai. Tidak perlu masukkan keduanya.';
$string['passwordforgotteninstructions2'] = 'Untuk mereset kata sandi Anda, masukkan nama pengguna atau alamat surel Anda di bawah. Jika kami dapat menemukan data Anda di basis data, surel akan dikirimkan ke alamat surel Anda, disertai instruksi tentang bagaimana cara untuk mendapatkan akses kembali.';
$string['passwordpolicynomatch'] = 'Kata sandi Anda saat ini tidak lagi sesuai dengan kebijakan kata sandi yang ditetapkan. {$a}';
$string['passwordsdiffer'] = 'Kata sandi ini tidak cocok';
$string['passwordset'] = 'Kata sandi Anda telah ditetapkan';
$string['path'] = 'Jalur';
$string['pathnotexists'] = 'Lokasi tidak ada di server Anda';
$string['pathslasherror'] = 'Jalur tidak dapat diakhiri dengan garis miring.';
$string['paymentinstant'] = 'Gunakan tombol di bawah untuk membayar dan mendaftar dalam hitungan menit.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> tertunda</small>)';
$string['paymentrequired'] = 'Kursus ini membutuhkan pembayaran untuk dapat mengikutinya';
$string['payments'] = 'Pembayaran';
$string['paymentsorry'] = 'Terima kasih atas pembayaran Anda. Setelah diproses, Anda akan dapat masuk ke kursus {$a->fullname}. Harap tunggu lalu coba lagi. Jika Anda masih mengalami masalah, hubungi {$a->teacher} atau administrator situs.';
$string['paymentthanks'] = 'Terima kasih atas pembayaran Anda. Anda sekarang terdaftar dalam kursus {$a}.';
$string['pendingrequests'] = 'Permintaan tertunda';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Periode akhir ({$a})';
$string['perpage'] = 'Per halaman';
$string['perpagea'] = 'Per halaman: {$a}';
$string['personal'] = 'Pribadi';
$string['personalprofile'] = 'Profil pribadi';
$string['phone'] = 'Telepon';
$string['phone1'] = 'Telepon';
$string['phone2'] = 'Ponsel';
$string['phpinfo'] = 'Info PHP';
$string['picture'] = 'Gambar';
$string['pictureof'] = 'Gambar dari {$a}';
$string['pictureofuser'] = 'Foto Pengguna';
$string['placeholdertypeorselect'] = 'Ketik atau pilih...';
$string['pleaseclose'] = 'Harap tutup jendela ini sekarang';
$string['pleasesearchmore'] = 'Silakan cari lagi';
$string['pleaseusesearch'] = 'Silakan gunakan pencarian';
$string['plugin'] = 'Pengaya';
$string['pluginarea'] = 'Area';
$string['plugincheck'] = 'Cek pengaya';
$string['plugindeletefiles'] = 'Semua data yang terkait dengan pengaya \'{$a->name}\' telah dihapus dari basis data. Untuk mencegah pengaya menginstal ulang sendiri, Anda sekarang harus menghapus direktori ini dari server Anda: {$a->directory}';
$string['pluginitemid'] = 'ID item';
$string['pluginmissingfromdisk'] = '{$a->name} (Hilang dari diska)';
$string['pluginsetup'] = 'Menyetel tabel plugin';
$string['policyaccept'] = 'Saya mengerti dan setuju';
$string['policyagree'] = 'Anda harus setuju pada kebijakan ini untuk menggunakan situs. Apakah anda setuju?';
$string['policyagreement'] = 'Kesepakatan kebijakan situs';
$string['policyagreementclick'] = 'Perjanjian kebijakan situs';
$string['popup'] = 'sembulan';
$string['popupwindow'] = 'Buka berkas di jendela baru';
$string['popupwindowname'] = 'Jendela sembulan';
$string['post'] = 'Kirim';
$string['posts'] = 'Kirim';
$string['potentialadmins'] = 'Yang berpotensi sebagai admin';
$string['potentialcreators'] = 'Yang berpotensi sebagai pembuat kursus';
$string['potentialstudents'] = 'Yang berpotensi sebagai siswa';
$string['potentialteachers'] = 'Yang berpotensi sebagai pengajar';
$string['poweredbymoodle'] = 'Ditenagai oleh <a href="https://moodle.com">Moodle</a>';
$string['preferences'] = 'Preferensi';
$string['preferredlanguage'] = 'Bahasa yang diinginkan';
$string['preferredtheme'] = 'Tema pilihan';
$string['preprocessingbackupfile'] = 'Mempersiapkan berkas cadangan';
$string['prev'] = 'Sebelumnya';
$string['preview'] = 'Pratinjau';
$string['previeworchoose'] = 'Pratinjau atau pilih tema';
$string['previewthemename'] = 'Pratinjau tema \'{$a}\'';
$string['previous'] = 'Sebelumnya';
$string['previouslyselectedusers'] = 'Pengguna yang diseleksi sebelumnya tidak cocok dengan \'{$a}\'';
$string['previouspage'] = 'Laman sebelumnya';
$string['previoussection'] = 'Bagian sebelumnya';
$string['primaryadminsetup'] = 'Atur akun administrator';
$string['privacy:metadata:config_log'] = 'Log perubahan konfigurasi.';
$string['privacy:metadata:config_log:name'] = 'Nama setelan berubah.';
$string['privacy:metadata:config_log:oldvalue'] = 'Nilai sebelumnya untuk setelan ini.';
$string['privacy:metadata:config_log:plugin'] = 'Pengaya dimodifikasi.';
$string['privacy:metadata:config_log:timemodified'] = 'Waktu perubahan dibuat.';
$string['privacy:metadata:config_log:userid'] = 'Pengguna yang melakukan perubahan.';
$string['privacy:metadata:config_log:value'] = 'Nilai baru untuk setelan ini.';
$string['privacy:metadata:events_queue'] = 'Antrean acara pengguna menunggu untuk diproses.';
$string['privacy:metadata:events_queue:eventdata'] = 'Data disimpan dalam acara tersebut.';
$string['privacy:metadata:events_queue:stackdump'] = 'Setiap jejak balik yang terkait dengan acara ini.';
$string['privacy:metadata:events_queue:timecreated'] = 'Waktu acara ini dibuat.';
$string['privacy:metadata:events_queue:userid'] = 'ID pengguna yang terkait dengan acara ini';
$string['privacy:metadata:log'] = 'Kumpulan acara sebelumnya';
$string['privacy:metadata:log:action'] = 'Deskripsi tindakan';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'kursus';
$string['privacy:metadata:log:info'] = 'Informasi tambahan';
$string['privacy:metadata:log:ip'] = 'Alamat IP yang digunakan pada saat acara tersebut';
$string['privacy:metadata:log:module'] = 'mudul';
$string['privacy:metadata:log:time'] = 'Waktu ketika aksi berlangsung';
$string['privacy:metadata:log:url'] = 'URL yang terkait dengan acara tersebut';
$string['privacy:metadata:log:userid'] = 'ID pengguna yang melakukan tindakan';
$string['privacy:metadata:moodlenet_share_progress'] = 'MoodleNet membagikan rincian progres';
$string['privacy:metadata:moodlenet_share_progress:cmid'] = 'ID modul kursus terkait';
$string['privacy:metadata:moodlenet_share_progress:courseid'] = 'ID kursus terkait';
$string['privacy:metadata:moodlenet_share_progress:resourceurl'] = 'URL yang dikembalikan dari MoodleNet setelah berhasil dibagikan';
$string['privacy:metadata:moodlenet_share_progress:status'] = 'Status bagian yang dihasilkan';
$string['privacy:metadata:moodlenet_share_progress:timecreated'] = 'Waktu pembagian itu dilakukan';
$string['privacy:metadata:moodlenet_share_progress:type'] = 'Jenis pembagian yang dilakukan';
$string['privacy:metadata:moodlenet_share_progress:userid'] = 'Pengguna yang melakukan pembagian';
$string['privacy:metadata:oauth2_refresh_token'] = 'Segarkan token yang digunakan di komunikasi OAuth 2.0';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'ID penerbit yang sesuai dengan token';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'ID pengguna yang terkait dengan token';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Waktu ketika token dibuat';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'Waktu saat token diperbarui terakhir kali';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Token penyegaran untuk masing-masing cakupan dan pengguna';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'ID pengguna yang terkait dengan token';
$string['privacy:metadata:shortlink'] = 'Rincian URL tautan pendek';
$string['privacy:metadata:shortlink:component'] = 'Komponen yang terkait dengan tautan pendek';
$string['privacy:metadata:shortlink:identifier'] = 'Pengidentifikasi unik yang terkait dengan tautan pendek';
$string['privacy:metadata:shortlink:linktype'] = 'Jenis tautan dari tautan pendek dapat diidentifikasi sebagai';
$string['privacy:metadata:shortlink:shortcode'] = 'Kode pendek yang digunakan untuk tautan pendek';
$string['privacy:metadata:shortlink:userid'] = 'ID pengguna yang terkait dengan tautan pendek';
$string['privacy:metadata:task_adhoc'] = 'Status tugas adhoc.';
$string['privacy:metadata:task_adhoc:component'] = 'Komponen yang memiliki tugas tersebut.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Waktu paling awal untuk menjalankan tugas ini.';
$string['privacy:metadata:task_adhoc:userid'] = 'Pengguna yang menjalankan tugas sebagai.';
$string['privacy:metadata:task_log'] = 'Keluaran log untuk log';
$string['privacy:metadata:task_log:component'] = 'Komponen yang memiliki tugas tersebut.';
$string['privacy:metadata:task_log:userid'] = 'Pengguna yang memiliki tugas tersebut.';
$string['privacy:metadata:upgrade_log'] = 'Log peningkatan.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Setiap jejak balik yang terkait dengan langkah peningkatan ini.';
$string['privacy:metadata:upgrade_log:details'] = 'Informasi tambahan yang berkaitan dengan peningkatan.';
$string['privacy:metadata:upgrade_log:info'] = 'Informasi utama untuk langkah peningkatan ini.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Pengaya yang ditingkatkan.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Versi baru untuk ditingkatkan.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Waktu peningkatan berlangsung.';
$string['privacy:metadata:upgrade_log:type'] = 'Tipe log entri';
$string['privacy:metadata:upgrade_log:userid'] = 'Pengguna yang menjalankan peningkatan.';
$string['privacy:metadata:upgrade_log:version'] = 'Pengaya versi lama.';
$string['private_files_handler'] = 'Menyimpan lampiran ke surel di ruang penyimpanan berkas pribadi pengguna.';
$string['private_files_handler_name'] = 'Surelkan  ke berkas pribadi';
$string['privatefiles'] = 'Berkas pribadi';
$string['privatefilesmanage'] = 'Kelola berkas pribadi';
$string['proceed'] = 'Diproses';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Keterangan profil ini tidak akan ditampilkan sampai orang ini terdaftar di setidaknya satu kursus.';
$string['progress'] = 'Progres';
$string['publicprofile'] = 'Profil publik';
$string['publicsitefileswarning'] = 'Catatan: berkas yang ditempatkan di sini dapat diakses siapa pun';
$string['publicsitefileswarning2'] = 'Catatan: Berkas yang ditempatkan di sini bisa diakses oleh siapa pun yang tahu (atau bisa menebak) URL. Demi keamanan, disarankan agar semua berkas cadangan dihapus segera setelah memulihkannya.';
$string['publicsitefileswarning3'] = 'Catatan: Berkas yang ditempatkan di sini bisa diakses oleh siapa pun yang tahu (atau bisa menebak) URL. Untuk alasan keamanan, berkas cadangan harus disimpan di folder backupdata aman saja.';
$string['question'] = 'Soal';
$string['questionsinthequestionbank'] = 'Daftar soal dan bank soal';
$string['queued'] = 'Antrean';
$string['quotausage'] = 'Saat ini Anda telah menggunakan {$a->used} dari batas {$a->total} Anda.';
$string['readinginfofrombackup'] = 'embaca info dari cadangan';
$string['readme'] = 'BACA SAYA';
$string['recentactivity'] = 'Aktivitas terkini';
$string['recentactivityreport'] = 'Laporan lengkap aktivitas terkini...';
$string['recipientslist'] = 'Daftar penerima';
$string['recommended'] = 'Direkomendasikan';
$string['recreatedcategory'] = 'Membuat ulang kategori {$a}';
$string['redirect'] = 'Alihkan';
$string['reducesections'] = 'Kurangi jumlah bagian';
$string['refresh'] = 'Segarkan';
$string['refreshingevents'] = 'Menyegarkan acara';
$string['registration'] = 'Pendaftaran Moodle';
$string['registrationcontact'] = 'Kontak dari publik';
$string['registrationcontactno'] = 'Tidak, saya tidak ingin dihubungi oleh orang lain';
$string['registrationcontactyes'] = 'Ya, berikan formulir untuk pengguna Moodle lain untuk menghubungi saya';
$string['registrationemail'] = 'Notifikasi surel';
$string['registrationinfo'] = '<p> Halaman ini memungkinkan Anda untuk mendaftarkan situs Moodle Anda dengan moodle.org. Pendaftaran gratis. Manfaat utama dari mendaftar adalah Anda akan ditambahkan ke milis volume rendah untuk pemberitahuan penting seperti peringatan keamanan dan rilis Moodle baru. </p> <p> Secara bawaan, informasi Anda akan dirahasiakan, dan akan tidak pernah dijual atau diteruskan ke orang lain. Satu-satunya alasan untuk mengumpulkan informasi ini adalah untuk tujuan dukungan, dan untuk membantu membangun gambaran statistik komunitas Moodle secara keseluruhan. </p> <p> Jika Anda memilih, Anda dapat mengizinkan nama situs, negara, dan URL Anda untuk ditambahkan ke daftar publik Situs Moodle. </p> <p> Semua pendaftaran baru diverifikasi secara manual sebelum ditambahkan ke daftar, tetapi begitu Anda ditambahkan, Anda dapat memperbarui pendaftaran Anda (dan entri Anda pada daftar publik) kapan saja dengan mengirimkan kembali formulir ini. </p>';
$string['registrationinfotitle'] = 'Informasi Pendaftaran';
$string['registrationsend'] = 'Kirim informasi pendaftaran ke moodle.org';
$string['registrationyes'] = 'Ya, beri tahu saya tentang rilis Moodle baru, peringatan keamanan, dan berita penting lainnya';
$string['reject'] = 'Tolak';
$string['rejectdots'] = 'Tolak...';
$string['relativedatesmode'] = 'Mode tanggal relatif';
$string['relativedatesmode_help'] = 'Tampilkan tanggal kursus atau aktivitas yang berhubungan dengan tanggal mulai pengguna dalam kursus. Tanggal mulai kursus pengguna akan menjadi tanggal mulai pendaftaran mereka, kecuali mereka telah terdaftar sebelum kursus dimulai dalam hal ini tanggal mulai mereka adalah tanggal mulai kursus. PERINGATAN: Ini adalah fitur eksperimental dan tidak semua aktivitas dapat mendukungnya. Setelah kursus dibuat, setelan kursus ini tidak dapat lagi diubah.';
$string['relativedatesmode_warning'] = '<strong> Peringatan: </strong> Mode tanggal relatif tidak dapat diubah setelah kursus dibuat.';
$string['reload'] = 'Muat ulang';
$string['remoteappuser'] = 'Pengguna jarak jauh {$a}';
$string['remove'] = 'Hapus';
$string['removeadmin'] = 'Hapus admin';
$string['removecreator'] = 'Hapus pembuat kursus';
$string['removed'] = 'Dihapus {$a}';
$string['removestudent'] = 'Hapus siswa';
$string['removeteacher'] = 'Hapus pengajar';
$string['rename'] = 'Ubah nama';
$string['renamefileto'] = 'Ganti nama <b>{$a}</b> ke';
$string['report'] = 'Laporan';
$string['reports'] = 'Laporan';
$string['reporttype'] = 'Tipe laporan';
$string['repositories'] = 'Repositori';
$string['requestcourse'] = 'Meminta kursus';
$string['requestedby'] = 'Diminta oleh';
$string['requestedcourses'] = 'Kursus yang diminta';
$string['requestreason'] = 'Alasan meminta kursus';
$string['requests'] = 'Permintaan';
$string['required'] = 'Diwajibkan';
$string['requirespayment'] = 'Untuk akses kursus ini Anda harus membayar';
$string['resendemail'] = 'Kirim ulang surel konfirmasi';
$string['reset'] = 'Reset';
$string['resetcomponent'] = 'Komponen';
$string['resetcourse'] = 'Set ulang kursus';
$string['resetcourseconfirm'] = 'Setel ulang kursus?';
$string['resetcoursewarning'] = 'Apakah Anda yakin ingin menyetel ulang kursus \'{$a}\'? <br/><br/>
Ini akan menghapus data yang dipilih dan mengatur ulang jalur kembali ke keadaan semula. Anda tidak dapat membatalkan tindakan ini.';
$string['resetinfo'] = 'Fitur ini memungkinkan Anda untuk menghapus semua data pengguna dan mengatur ulang kursus ke keadaan semula. Aktivitas dan setelan kursus tetap tidak berubah.';
$string['resetinfoselect'] = 'Pilih data yang ingin Anda hapus atau setel ulang dari kategori di bawah ini:';
$string['resetnotimplemented'] = 'Penyetelan ulang tidak didukung';
$string['resetnotimplementedinfo'] = 'Aktivitas berikut tidak dapat disetel ulang:';
$string['resetrecordexpired'] = 'Tautan penyetelan ulang kata sandi yang Anda gunakan lebih dari {$a} menit dan telah berakhir. Silakan mengajukan penyetelan ulang kata sandi baru.';
$string['resetstartdate'] = 'Reset tanggal mulai';
$string['resetstatus'] = 'Status';
$string['resettable'] = 'Reset preferensi tabel';
$string['resettask'] = 'Reset';
$string['resettodefaults'] = 'Reset ke setelan bawaan';
$string['resortcourses'] = 'Urutkan kursus';
$string['resortsubcategoriesby'] = 'Urutkan subkategori menurut {$a}, urut naik';
$string['resortsubcategoriesbyreverse'] = 'Urutkan subkategori menurut {$a}, urut turunj';
$string['resource'] = 'Sumber';
$string['resource_type'] = 'Tipe sumber';
$string['resourcedisplayauto'] = 'Otomatis';
$string['resourcedisplaydownload'] = 'Paksa unduh';
$string['resourcedisplayembed'] = 'Ditanamkan';
$string['resourcedisplayframe'] = 'Di bingkai';
$string['resourcedisplaynew'] = 'Jendela baru';
$string['resourcedisplayopen'] = 'Buka';
$string['resourcedisplaypopup'] = 'Dalam sembulan';
$string['resources'] = 'Sumber';
$string['resources_help'] = 'Tipe sumber mengaktifkan hampir semua konten web untuk dimasukkan dalam kursus.';
$string['restore'] = 'Pulihkan';
$string['restorecancelled'] = 'Pemulihan cadangan dibatalkan';
$string['restorecannotassignroles'] = 'Pemulihan dibutuhkan untuk menetapkan peran dan Anda tidak memiliki izin untuk melakukannya';
$string['restorecannotcreateorassignroles'] = 'Pemulihan dibutuhkan untuk membuat atau menetapkan peran dan Anda tidak memiliki izin untuk melakukannya';
$string['restorecannotcreateuser'] = 'Pemulihan diperlukan untuk membuat pengguna \'{$a}\' dari berkas cadangan dan Anda tidak memiliki izin untuk melakukannya';
$string['restorecannotoverrideperms'] = 'Pemulihan dibutuhkan untuk mengesampingkan hak akses dan Anda tidak memiliki izin untuk melakukannya';
$string['restorecoursenow'] = 'Pulihkan kursus ini sekarang!';
$string['restoredaccount'] = 'Akun yang dipulihkan';
$string['restoredaccountinfo'] = 'Akun ini diimpor dari server lain dan kata sandi telah hilang. Untuk mengatur kata sandi baru melalui surel, silakan klik "Lanjutkan"';
$string['restorefinished'] = 'Proses pemulihan berhasil';
$string['restoreinfo'] = 'Gunakan berkas cadangan untuk memulihkan versi kursus sebelumnya, atau untuk membuat kursus baru.';
$string['restoremnethostidmismatch'] = 'ID MNet hos pengguna \'{$a}\' tidak cocok dengan ID MNet hos lokal.';
$string['restoreto'] = 'Pulihkan ke';
$string['restoretositeadding'] = 'Peringatan: Anda akan memulihkan beranda situs, menambahkan data untuk itu!';
$string['restoretositedeleting'] = 'Peringatan: Anda akan memulihkan ke beranda situs. Hal pertama kali yang dilakukan adalah hapus datanya terlebih dahulu!';
$string['restoreuserconflict'] = 'Mencoba untuk memulihkan pengguna \'{$a}\' dari berkas cadangan akan menyebabkan konflik';
$string['restoreuserinfofailed'] = 'Proses pemulihan telah berhenti karena Anda tidak memiliki izin untuk mengembalikan data pengguna.';
$string['restoreusersprecheck'] = 'Memeriksa data pengguna';
$string['restoreusersprecheckerror'] = 'Beberapa masalah terdeteksi saat memeriksa data pengguna';
$string['restricted'] = 'Terbatas';
$string['resultsfound'] = '{$a} hasil ditemukan';
$string['retry'] = 'Coba lagi';
$string['returningtosite'] = 'Kembali ke situs ini?';
$string['returntooriginaluser'] = 'Kembali ke {$a}';
$string['revert'] = 'Kembali';
$string['role'] = 'Peran';
$string['roleassignments'] = 'Penetapan peran';
$string['rolemappings'] = 'Pemetaan peran';
$string['rolerenaming'] = 'Penamaan ulang peran';
$string['rolerenaming_help'] = 'Ubah nama tampilan peran dalam kursus ini.';
$string['rolerenaming_success'] = 'Nama peran kursus diperbarui.';
$string['roles'] = 'Peran';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Jumlah artikel terbaru RSS';
$string['rsserror'] = 'Kesalahan dalam membaca data RSS';
$string['rsserrorauth'] = 'Tautan RSS Anda tidak berisi token autentikasi yang valid';
$string['rsserrorguest'] = 'Umpan ini menggunakan akses tamu untuk mengakses data, tetapi tamu tidak memiliki izin untuk membaca data. Kunjungi lokasi asli asal umpan ini (URL) sebagai pengguna yang valid dan dapatkan tautan RSS baru dari sana.';
$string['rsskeyshelp'] = '<p>Untuk menjamin keamanan dan privasi, URL umpan RSS berisi token yang mengidentifikasi pengguna. Hal ini mencegah pengguna lain mengakses area dari Moodle dimana mereka tidak memiliki hak akses. </p> <p>Token ini secara otomatis dibuat saat pertama kali Anda mengakses area yang menghasilkan umpan RSS. Jika Anda merasa bahwa token umpan RSS telah diubah oleh yang tak berhak dalam berbagai cara, Anda dapat meminta yang baru dengan mengklik tautan Reset. Harap dicatat bahwa URL umpan RSS Anda saat ini akan menjadi tidak valid.</p>';
$string['rsstype'] = 'Umpan RSS untuk aktivitas ini';
$string['save'] = 'Simpan';
$string['saveandnext'] = 'Simpan dan tampilkan selanjutnya';
$string['savechanges'] = 'Simpan perubahan';
$string['savechangesanddisplay'] = 'Simpan dan tampilkan';
$string['savechangesandreturn'] = 'Simpan dan kembali';
$string['savechangesandreturntocourse'] = 'Simpan dan kembali ke kursus';
$string['savecomment'] = 'Simpan komentar';
$string['savedat'] = 'Disimpan di:';
$string['savepreferences'] = 'Disimpan di:';
$string['saveto'] = 'Simpan ke';
$string['scale'] = 'Skala';
$string['scale_help'] = 'Sebuah skala menyediakan cara untuk mengevaluasi atau menilai kinerja sebuah aktivitas. Hal ini didefinisikan oleh daftar nilai berurut, mulai dari negatif ke positif, dipisahkan oleh koma, misalnya "Mengecewakan, Tidak cukup baik, Rata-rata, Baik, Sangat baik, Luar biasa!"';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Skala';
$string['scalescustom'] = 'Skala kustom';
$string['scalescustomcreate'] = 'Tambahkan skala';
$string['scalescustomno'] = 'Tidak ada skala kustom yang telah dibuat';
$string['scalesstandard'] = 'Skala standar';
$string['scalestandard'] = 'Skala standar';
$string['scalestandard_help'] = 'Skala bawaan tersedia untuk situs, untuk semua kursus';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'Untuk membuat skala yang dibuat sendiri, gunakan tautan \'Skala...\' pada menu administrator kursus.';
$string['scalestip2'] = 'Untuk membuat skala kustom, klik tautan Nilai di menu administrasi kursus, lalu pilih Edit, Skala.';
$string['schedule'] = 'Jadwal';
$string['screenshot'] = 'Tangkapan layar';
$string['search'] = 'Cari';
$string['search_help'] = 'Untuk pencarian dasar dari satu atau lebih kata di manapun dalam teks, cukup ketikkan kata-kata tersebut dengan dipisahkan oleh spasi. Semua kata yang lebih panjang dari dua karakter digunakan. Untuk pencarian lanjutan, tekan tombol pencarian tanpa mengetik apapun di kotak pencarian untuk mengakses formulir pencarian lanjutan.';
$string['searchactivities'] = 'Cari aktivitas berdasarkan nama atau deskripsi';
$string['searchagain'] = 'Cari lagi';
$string['searchbyemail'] = 'Cari berdasarkan surel';
$string['searchbyusername'] = 'Cari berdasarkan nama pengguna';
$string['searchcoursecategories'] = 'Pencarian kategori';
$string['searchcourses'] = 'Cari kursus';
$string['searchgroups'] = 'Cari grup';
$string['searchitems'] = 'Cari item';
$string['searchoptions'] = 'Pilihan pencarian';
$string['searchresults'] = 'Hasil pencarian';
$string['searchusers'] = 'Cari pengguna';
$string['sec'] = 'detik';
$string['seconds'] = 'detik';
$string['secondsleft'] = '{$a} detik';
$string['secondstotime172800'] = '2 hari';
$string['secondstotime259200'] = '3 hari';
$string['secondstotime345600'] = '4 hari';
$string['secondstotime432000'] = '5 hari';
$string['secondstotime518400'] = '6 hari';
$string['secondstotime604800'] = '1 minggu';
$string['secondstotime86400'] = '1 hari';
$string['secretalreadyused'] = 'Tautan konfirmasi perubahan kata sandi sudah digunakan, kata sandi tidak diubah.';
$string['secs'] = 'detik';
$string['section'] = 'Bagian';
$string['sectionactionnotsupported'] = 'Tindakan bagian "{$a}" tidak didukung di sini';
$string['sectionname'] = 'Nama bagian';
$string['sectionoutline'] = 'Garis besar topik';
$string['sections'] = 'Bagian';
$string['seealsostats'] = 'Lihat juga: statistik';
$string['selctauser'] = 'Pilih pengguna';
$string['select'] = 'Pilih';
$string['selectacategory'] = 'Silakan pilih kategori';
$string['selectacountry'] = 'Pilih Negara';
$string['selectacourse'] = 'Pilih kursus';
$string['selectacoursesite'] = 'Pilih kursus atau situs';
$string['selectagroup'] = 'Pilih grup';
$string['selectall'] = 'Pilih semua';
$string['selectallusersonpage'] = 'Pilih semua pengguna di halaman ini';
$string['selectalluserswithcount'] = 'Pilih semua {$a} pengguna';
$string['selectamodule'] = 'Pilih modul aktivitas';
$string['selectanaction'] = 'Pilih aksi';
$string['selectanoptions'] = 'Pilih satu opsi';
$string['selectaregion'] = 'Pilih region';
$string['selectcategorysort'] = 'Kategori mana yang ingin Anda urutkan';
$string['selectcategorysortby'] = 'Pilih bagaimana Anda ingin mengurutkan kategori';
$string['selectcoursesortby'] = 'Pilihan untuk mengurutkan kursus';
$string['selectdates'] = 'Pilih tanggal';
$string['selectdefault'] = 'Pilih bawaan';
$string['selectedcategories'] = 'Kategori terpilih';
$string['selectedfile'] = 'Berkas terpilih';
$string['selectednowmove'] = '{$a} berkas terpilih untuk dipindahkan. Sekarang beralih ke tujuan berkas dan tekan \'Pindahkan berkas ke sini\'';
$string['selectfiles'] = 'Pilih berkas';
$string['selectfiltertype'] = 'Pilih';
$string['selectgroupsseparate'] = 'Pilih grup terpisah';
$string['selectgroupsvisible'] = 'Pilih grup terlihat';
$string['selectitem'] = 'Pilih \'{$a}\'';
$string['selectmoduletoviewhelp'] = 'Pilih aktivitas atau sumber untuk melihat bantuannya. Klik dua kali pada aktivitas atau nama sumber untuk menambahkannya dengan cepat.';
$string['selectnos'] = 'Pilih semua \'Tidak\'';
$string['selectperiod'] = 'Pilih periode';
$string['selecttheme'] = 'Pilih tema';
$string['selectthemename'] = 'Pilih tema \'{$a}\'';
$string['senddetails'] = 'Kirimkan detail saya via surel';
$string['sent'] = 'Terkirim';
$string['separate'] = 'Pisahkan';
$string['separateandconnected'] = 'Cara terpisah dan terhubung untuk mengetahui';
$string['separateandconnected1'] = 'Kebanyakan tahu secara terpisah';
$string['separateandconnected2'] = 'terpisah dan terhubung';
$string['separateandconnected3'] = 'Sebagian besar mengetahui dan terhubung';
$string['separateandconnectedinfo'] = 'Skala didasarkan pada teori pengetahuan yang terpisah dan terhubung. Teori ini menjelaskan dua cara berbeda yang dapat kita evaluasi dan pelajari tentang hal-hal yang kita lihat dan dengar. <ul> <li> <strong> Pemisah yang terpisah </strong> tetap seobyektif mungkin tanpa menyertakan perasaan dan emosi. Dalam diskusi dengan orang lain, mereka suka mempertahankan ide-ide mereka sendiri, menggunakan logika untuk menemukan lubang dalam ide-ide lawan. </li> <li> <strong> Orang yang terhubung </strong> lebih peka terhadap orang lain. Mereka terampil dalam empati dan cenderung mendengarkan dan mengajukan pertanyaan sampai mereka merasa dapat terhubung dan "memahami hal-hal dari sudut pandang mereka". Mereka belajar dengan mencoba berbagi pengalaman yang mengarah pada pengetahuan yang mereka temukan pada orang lain. </li> </ul>';
$string['servererror'] = 'Galat saat berkomunikasi dengan server';
$string['serverlocaltime'] = 'Waktu lokal server';
$string['sessionforceclean'] = 'Sebagai tindakan pencegahan keamanan, skrip yang dibuat pengguna telah dinonaktifkan dalam sesi ini.';
$string['sessiontimeoutsoon'] = 'Sesi Anda akan habis. Apakah Anda ingin memperpanjang sesi Anda saat ini?';
$string['setcategorytheme'] = 'Tetapkan tema kategori';
$string['setmode'] = 'Setel mode';
$string['setpassword'] = 'Setel kata sandi';
$string['setpasswordinstructions'] = 'Masukkan kata sandi baru, kemudian simpan perubahan.';
$string['settings'] = 'Setelan';
$string['share'] = 'Bagikan';
$string['shortname'] = 'Nama singkat';
$string['shortnamecollisionwarning'] = '[*] = Nama singkat ini sudah digunakan oleh kursus sebelumnya dan akan diganti setelah disetujui';
$string['shortnamecourse'] = 'Nama singkat kursus';
$string['shortnamecourse_help'] = 'Nama ditampilkan di area dengan ruang terbatas. Itu harus unik.';
$string['shortnametaken'] = 'Nama singkat telah digunakan untuk kursus yang lain ({$a})';
$string['shortnameuser'] = 'Nama singkat pengguna';
$string['shortsitename'] = 'Nama singkat untuk situs (mis. kata tunggal)';
$string['show'] = 'Tampilkan';
$string['showactions'] = 'Tunjukkan aksi';
$string['showactivitydates'] = 'Tampilkan waktu aktivitas';
$string['showactivitydates_help'] = 'Tampilkan tanggal aktivitas di halaman kursus.';
$string['showadvancededitor'] = 'Lanjutan';
$string['showadvancedsettings'] = 'Tampilkan setelan lanjutan';
$string['showall'] = 'Tampilkan semua {$a}';
$string['showallcourses'] = 'Tampilkan semua kursus';
$string['showblockcourse'] = 'Tampilkan daftar kursus yang mengandung blok';
$string['showcategory'] = 'Tampilkan {$a}';
$string['showchartdata'] = 'Tampilkan data grafik';
$string['showcomments'] = 'Tampilkan/sembunyikan komentar';
$string['showcommentsnonjs'] = 'Tampilkan komentar';
$string['showdescription'] = 'Tampilkan deskripsi di halaman kursus';
$string['showdescription_help'] = 'Jika diaktifkan, deskripsi di atas akan ditampilkan pada halaman kursus di bawah tautan aktivitas/sumber.';
$string['showgrades'] = 'Tampilkan buku nilai ke siswa';
$string['showgrades_help'] = 'Izinkan siswa untuk melihat daftar semua nilai mereka dalam kursus.';
$string['showingacourses'] = 'Menampilkan semua kursus {$a}';
$string['showingxofycourses'] = 'Menampilkan kursus {$a->start} hingga {$a->end} dari {$a->total} kursus';
$string['showless'] = 'Tampilkan lebih sedikit';
$string['showlistofcourses'] = 'Tampilkan daftar kursus';
$string['showmodulecourse'] = 'Tampilkan daftar kursus yang memiliki aktivitas.';
$string['showmore'] = 'Tampilkan lebih banyak';
$string['showoncoursepage'] = 'Tampilkan pada halaman kursus';
$string['showonly'] = 'Hanya tampilkan';
$string['showperpage'] = 'Tampilkan {$a} per halaman';
$string['showpopovermenu'] = 'Buka jendela sembul';
$string['showpopoverwindow'] = 'Tampilkan jendela sembulan';
$string['showrecent'] = 'Tampilkan aktivitas terbaru';
$string['showreports'] = 'Tampilkan laporan aktivitas';
$string['showreports_help'] = 'Izinkan siswa untuk melihat laporan aktivitas mereka sendiri melalui halaman profil mereka.';
$string['showsettings'] = 'Tampilkan setelan';
$string['showtheselogs'] = 'Tampilkan log ini';
$string['showthishelpinlanguage'] = 'Tampilkan bantuan ini dengan bahasa: {$a}';
$string['sidepanel'] = 'Panel samping';
$string['signoutofotherservices'] = 'Keluar dari semua aplikasi web';
$string['signoutofotherservices_help'] = 'Keluar dari semua perangkat dan sistem yang menggunakan layanan web, seperti aplikasi seluler. Sesi peramban akan tetap aktif.';
$string['since'] = 'Sejak';
$string['sincelast'] = 'sejak terakhir masuk';
$string['site'] = 'Situs';
$string['sitedefault'] = 'Situs bawaan';
$string['sitedefaultspecified'] = 'Situs baaawn ({$a})';
$string['siteerrors'] = 'Galat situs';
$string['sitefiles'] = 'Berkas situs';
$string['sitefilesused'] = 'Berkas situs yang digunakan dalam kursus ini';
$string['sitehome'] = 'Beranda situs';
$string['sitelegacyfiles'] = 'Berkas lawas situs';
$string['sitelogs'] = 'Log situs';
$string['sitenews'] = 'Pengumuman situs';
$string['sitepages'] = 'Laman situs';
$string['sitepartlist'] = 'Anda tidak diizinkan melihat daftar peserta';
$string['sitepartlist0'] = 'Anda harus menjadi pengajar situs agar dapat diizinkan melihat daftar peserta di situs';
$string['sitepartlist1'] = 'Anda harus menjadi pengajar agar diizinkan melihat daftar peserta situs';
$string['sites'] = 'Situs';
$string['sitesection'] = 'Tambahkan konten kustom';
$string['sitesettings'] = 'Setelan situs';
$string['siteteachers'] = 'Pengajar situs';
$string['size'] = 'Ukuran';
$string['sizeb'] = 'Byte';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Lewati';
$string['skiptocategorylisting'] = 'Loncat ke daftar kategori';
$string['skiptocoursedetails'] = 'Loncat ke informasi detail program';
$string['skiptocourselisting'] = 'Loncat ke daftar kursus';
$string['someallowguest'] = 'Beberapa kursus membolehkan akses pengguna tamu';
$string['someerrorswerefound'] = 'Beberapa informasi telah hilang atau tidak benar. Lihat di bawah untuk rinciannya.';
$string['sort'] = 'Urutkan';
$string['sortby'] = 'Urutkan berdasarkan';
$string['sortbyx'] = 'Urut naik berdasarkan  {$a}';
$string['sortbyxreverse'] = 'Urut turun berdasarkan { {$a}';
$string['sorting'] = 'Filter';
$string['sourcerole'] = 'Peran sumber';
$string['specifyname'] = 'Anda harus sebutkan nama';
$string['standard'] = 'Standar';
$string['starpending'] = '([*] = Izin menunda kursus)';
$string['startdate'] = 'Tanggal mulai kursus';
$string['startdate_help'] = 'Tanggal ini menentukan awal minggu pertama untuk kursus dalam format mingguan. Ini juga merupakan tanggal mulai untuk mencatat kegiatan kursus.

Jika Anda mengatur ulang kursus dan mengubah tanggal ini, semua tanggal dalam kursus akan dipindahkan sehubungan dengan tanggal mulai yang baru.';
$string['startdatewithtaskenabled'] = 'Tanggal mulai kursus';
$string['startdatewithtaskenabled_help'] = 'Tanggal saat kursus dapat dilihat oleh siswa. Sebelum tanggal ini, mereka tidak akan dapat mengakses kursus.

Tanggal ini juga menentukan dimulainya minggu pertama untuk kursus dalam format mingguan, dan merupakan tanggal mulai untuk log kegiatan kursus. jika Anda mengatur ulang kursus dan mengubah tanggal ini, semua tanggal dalam kursus akan dipindahkan sehubungan dengan tanggal mulai yang baru.';
$string['startingfrom'] = 'Dimulai sejak';
$string['startsignup'] = 'Buat akun baru';
$string['state'] = 'Provinsi';
$string['statistics'] = 'Statistik';
$string['statisticsgraph'] = 'Grafik Statistik';
$string['stats'] = 'Statistik';
$string['statslogins'] = 'Log masuk';
$string['statsmodedetailed'] = 'Tampilkan detail (pengguna)';
$string['statsmodegeneral'] = 'Pandangan umum';
$string['statsnodata'] = 'Tidak ada data yang tersedia pada kombinasi kursus dan periode waktu tersebut.';
$string['statsnodatauser'] = 'Tidak ada data yang tersedia pada kombinasi pengguna, kursus dan periode waktu tersebut.';
$string['statsoff'] = 'Statistik belum diaktifkan';
$string['statsreads'] = 'Tampilan';
$string['statsreport1'] = 'Masuk';
$string['statsreport10'] = 'Aktivitas pengguna';
$string['statsreport11'] = 'Kursus paling aktif';
$string['statsreport12'] = 'Kursus paling aktif (dibobotkan)';
$string['statsreport13'] = 'Kursus dengan peserta terbanyak (pendaftaran)';
$string['statsreport14'] = 'Kursus dengan peserta terbanyak (tampilan/kiriman)';
$string['statsreport2'] = 'Tampilan (semua peran)';
$string['statsreport3'] = 'Kiriman (semua peran)';
$string['statsreport4'] = 'Semua aktivitas (semua peran)';
$string['statsreport5'] = 'Semua aktivitas (tampilan dan kiriman)';
$string['statsreport7'] = 'Aktivitas pengguna (tampilan dan kiriman)';
$string['statsreport8'] = 'Semua aktivitas pengguna';
$string['statsreport9'] = 'Masuk (situs kursus)';
$string['statsreportactivity'] = 'Semua aktivitas (semua peran)';
$string['statsreportactivitybyrole'] = 'Semua aktivitas (tampilan dan kiriman)';
$string['statsreportforuser'] = 'untuk';
$string['statsreportlogins'] = 'Masuk';
$string['statsreportreads'] = 'Tampilan (semua peran)';
$string['statsreporttype'] = 'Tipe laporan';
$string['statsreportwrites'] = 'Kiriman (semua peran)';
$string['statsstudentactivity'] = 'Aktivitas siswa';
$string['statsstudentreads'] = 'Tampilan siswa';
$string['statsstudentwrites'] = 'Kiriman siswa';
$string['statsteacheractivity'] = 'Aktivitas pengajar';
$string['statsteacherreads'] = 'Tampilan pengajar';
$string['statsteacherwrites'] = 'Kiriman pengajar';
$string['statstimeperiod'] = 'Periode waktu - terakhir:';
$string['statsuniquelogins'] = 'Log masuk unik';
$string['statsuseractivity'] = 'Semua aktivitas';
$string['statsuserlogins'] = 'Masuk';
$string['statsuserreads'] = 'Tampilan';
$string['statsuserwrites'] = 'Kiriman';
$string['statswrites'] = 'Kiriman';
$string['status'] = 'Status';
$string['statuschecks'] = 'Pemeriksaan status';
$string['statuscritical'] = 'Kritis';
$string['statusdone'] = 'Selesai';
$string['statuserror'] = 'Galat';
$string['statusinfo'] = 'Info';
$string['statusna'] = 'N/A';
$string['statusok'] = 'OK';
$string['statusunknown'] = 'Tidak dikenal';
$string['statuswarning'] = 'Peringatan';
$string['stringsnotset'] = 'Kata berikut belum terdefinisi pada {$a}';
$string['studentnotallowed'] = 'Maaf, Anda tidak diizinkan masuk ke kursus ini sebagai \'{$a}\'';
$string['students'] = 'Siswa';
$string['studentsandteachers'] = 'Siswa dan pengajar';
$string['subcategories'] = 'Subkategori';
$string['subcategory'] = 'Subkategori';
$string['subcategoryof'] = 'Subkategori {$a}';
$string['subject'] = 'Subjek';
$string['submit'] = 'Ajukan';
$string['subsectionmoveerror'] = 'Tidak dapat memindahkan subtopik ini ke subtopik lain';
$string['success'] = 'Berhasil';
$string['successduration'] = 'Berhasil ({$a} detik)';
$string['summary'] = 'Ringkasan';
$string['suspended'] = 'Ditangguhkan';
$string['suspendedusers'] = 'Pengguna yang ditangguhkan';
$string['switchdevicedefault'] = 'Ganti menjadi tema standar';
$string['switchdevicerecommended'] = 'Ganti dengan tema yang direkomendasikan untuk perangkat Anda';
$string['switchrolereturn'] = 'Kembali ke peran normal';
$string['switchroleto'] = 'Beralih peran menjadi...';
$string['switchroleto_help'] = 'Pilih peran untuk mendapatkan gagasan tentang bagaimana seseorang dengan peran itu akan melihat kursus ini. Harap perhatikan bahwa tampilan ini mungkin tidak sempurna (<a href="https://docs.moodle.org/en/Switch_roles"> Lihat detail dan alternatif </a>).';
$string['tag'] = 'Tagar';
$string['tagalready'] = 'Tagar ini sudah ada';
$string['tagmanagement'] = 'Tambahkan/hapus tagar';
$string['tags'] = 'Tagar';
$string['targetrole'] = 'Sasaran';
$string['teacheronly'] = 'Hanya untuk {$a} saja';
$string['teacherroles'] = 'peran {$a}';
$string['teachers'] = 'Pengajar';
$string['textcopiedtoclipboard'] = 'Teks disalin ke papan klip';
$string['textediting'] = 'Editor teks';
$string['textediting_help'] = 'Jika editor HTML seperti Atto atau TinyMCE dipilih, area input teks akan memiliki toolbar dengan tombol untuk menambahkan konten dengan mudah. Jika \'area teks biasa\' dipilih, format untuk area input teks seperti HTML atau Penurunan harga dapat dipilih. Daftar editor teks yang tersedia ditentukan oleh administrator situs.';
$string['texteditor'] = 'Gunakan formulir standar web';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Format teks biasa';
$string['thanks'] = 'Terima kasih';
$string['theme'] = 'Tema';
$string['themepreviewdescription'] = 'deskripsi tema {$a}';
$string['themepreviewimage'] = '{$a} gambar pratinjau';
$string['themes'] = 'Tema';
$string['themesaved'] = 'Tema baru tersimpan';
$string['therearecourses'] = 'Terdapat {$a} kursus';
$string['thereareno'] = 'Tidak ada {$a} dalam kursus ini';
$string['thiscategory'] = 'Kategori ini';
$string['thiscategorycontains'] = 'Kategori ini terdiri';
$string['time'] = 'Waktu';
$string['timecreated'] = 'Waktu dibuat';
$string['timecreatedcourse'] = 'Waktu kursus dibuat';
$string['timesplitting:deciles'] = 'Sepersepuluh terakhir';
$string['timesplitting:deciles_help'] = 'Interval analisis ini membagi kursus menjadi sepersepuluh (10 bagian yang sama), dengan setiap prediksi didasarkan pada data sepersepuluh terakhir sebelumnya.';
$string['timesplitting:decilesaccum'] = 'Akumulasi persepuluhan';
$string['timesplitting:decilesaccum_help'] = 'Interval analisis ini membagi kursus menjadi sepersepuluh (10 bagian yang sama), dengan setiap prediksi didasarkan pada akumulasi data dari sepersepuluh sebelumnya.';
$string['timesplitting:nosplitting'] = 'Tidak ada batasan waktu';
$string['timesplitting:nosplitting_help'] = 'Tidak ada metode pemisahan waktu yang ditentukan untuk model ini.';
$string['timesplitting:onemonthafterstart'] = 'Satu bulan setelah dimulai';
$string['timesplitting:onemonthafterstart_help'] = 'Analisis interval ini menghasilkan prediksi 1 bulan setelah faktor yang dianalisis dimulai';
$string['timesplitting:oneweekafterstart'] = 'Satu minggu setelah dimulai';
$string['timesplitting:oneweekafterstart_help'] = 'Analisis interval ini menghasilkan prediksi 1 minggu setelah faktor yang dianalisis dimulai';
$string['timesplitting:past3days'] = '3 hari sebelumnya';
$string['timesplitting:past3days_help'] = 'Analisis interval ini menghasilkan prediksi setiap 3 hari. Indikator penghitungan berdasarkan penghitungan 3 hari yang lalu.';
$string['timesplitting:pastmonth'] = 'Bulan lalu';
$string['timesplitting:pastmonth_help'] = 'Analisis interval ini menghasilkan prediksi setiap bulan. Indikator penghitungan berdasarkan penghitungan bulan lalu.';
$string['timesplitting:pastweek'] = 'Minggu lalu';
$string['timesplitting:pastweek_help'] = 'Analisis interval ini menghasilkan prediksi setiap minggu. Indikator penghitungan berdasarkan penghitungan minggu lalu.';
$string['timesplitting:quarters'] = 'Seperempat';
$string['timesplitting:quarters_help'] = 'Metode pemisahan waktu ini membagi kursus menjadi empat bagian (4 bagian yang sama), dengan masing-masing prediksi didasarkan pada data kuartal terbaru sebelumnya.';
$string['timesplitting:quartersaccum'] = 'Semua kuartal sebelumnya';
$string['timesplitting:quartersaccum_help'] = 'Metode pembagian waktu ini membagi kursus menjadi empat bagian (4 bagian yang sama), dengan masing-masing prediksi didasarkan pada data semua kuartal sebelumnya.';
$string['timesplitting:singlerange'] = 'Dari awal sampai akhir';
$string['timesplitting:singlerange_help'] = 'Interval analisis ini menganggap seluruh kursus sebagai rentang tunggal.';
$string['timesplitting:tenpercentafterstart'] = '10% setelah mulai';
$string['timesplitting:tenpercentafterstart_help'] = 'Analisis interval ini menghasilkan prediksi setelah 10% kursus diselesaikan.';
$string['timesplitting:upcoming3days'] = '3 hari mendatang';
$string['timesplitting:upcoming3days_help'] = 'Metode pemisahan waktu ini menghasilkan prediksi setiap 3 hari. Perhitungan indikator akan didasarkan pada 3 hari mendatang.';
$string['timesplitting:upcomingfortnight'] = 'Dua minggu mendatang';
$string['timesplitting:upcomingfortnight_help'] = 'Interval analisis ini menghasilkan prediksi setiap dua minggu. Perhitungan indikator akan didasarkan pada dua minggu mendatang.';
$string['timesplitting:upcomingweek'] = 'Minggu yang akan datang';
$string['timesplitting:upcomingweek_help'] = 'Interval analisis ini menghasilkan prediksi setiap minggu. Perhitungan indikator akan didasarkan pada minggu mendatang.';
$string['timezone'] = 'Zona waktu';
$string['tocontent'] = 'Ke item "{$a}"';
$string['tocreatenewaccount'] = 'Abaikan untuk membuat akun baru';
$string['todate'] = 'Ke';
$string['today'] = 'Hari ini';
$string['todaylogs'] = 'Log hari ini';
$string['toeveryone'] = 'ke semua orang';
$string['toggleemojipicker'] = 'Alihkan alat pilih emoji';
$string['togglesearch'] = 'Alihkan input pencarian';
$string['toomanybounces'] = 'Alamat surel tersebut terlalu banyak memantul. Anda <b>harus</b> mengubahnya agar bisa melanjutkan.';
$string['toomanytags'] = 'Pencarian ini menyertakan terlalu banyak tagar; beberapa akan diabaikan.';
$string['toomanytoshow'] = 'Terlalu banyak Pengguna untuk ditampilkan';
$string['toomanyusersmatchsearch'] = 'Terlalu banyak pengguna ({$a->count}) cocok \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Terlalu banyak pengguna ({$a}) untuk ditampilkan';
$string['toonly'] = 'hanya ke {$a}';
$string['top'] = 'Puncak';
$string['topic'] = 'Topik';
$string['toplevelcategory'] = 'Kategori puncak';
$string['torecipient'] = 'Ke';
$string['total'] = 'Total';
$string['totopofsection'] = 'Menuju puncak bagian "{$a}"';
$string['trackforums'] = 'Pelacakan forum';
$string['trackforumsno'] = 'Tidak: jangan melacak kiriman yang telah saya lihat';
$string['trackforumsyes'] = 'Ya: sorot kiriman baru untuk saya';
$string['trysearching'] = 'Coba cari penggantinya.';
$string['turneditingoff'] = 'Matikan mode ubah';
$string['turneditingon'] = 'Hidupkan mode ubah';
$string['unabletocopytoclipboard'] = 'Tidak dapat menyalin teks ke papan klip';
$string['unauthorisedlogin'] = 'Akun pengguna "{$a}" tidak tersedia di situs ini';
$string['undecided'] = 'Belum ditentukan';
$string['unexistingcmid'] = 'ID modul kursus tidak ditemukan';
$string['unexistingsectionid'] = 'ID bagian kursus tidak ditemukan';
$string['unfinished'] = 'Tidak selesai';
$string['unknowncategory'] = 'Kategori tidak diketahui';
$string['unknownerror'] = 'Kesalahan tidak diketahui';
$string['unknownuser'] = 'Pengguna tak dikenal';
$string['unlimited'] = 'Tidak terbatas';
$string['unpacking'] = 'Mengurai paket {$a}';
$string['unsafepassword'] = 'Kata sandi tidak aman - coba ganti lainnya';
$string['untilcomplete'] = 'Sampai selesai';
$string['unusedaccounts'] = 'Ketika keanggotaan tidak dipergunakan selama lebih dari {$a} hari, maka akan secara otomatis dikeluarkan dari kursus';
$string['unzip'] = 'Unzip';
$string['unzippingbackup'] = 'Mengurai berkas cadangan zip';
$string['up'] = 'Naik';
$string['update'] = 'Perbarui';
$string['updated'] = '{$a} telah diperbarui';
$string['updatemymoodleoff'] = 'Setop ubah halaman ini';
$string['updatemymoodleon'] = 'Sesuaikan halaman ini';
$string['updatemyprofile'] = 'Perbarui profil';
$string['updatesevery'] = 'Perbarui  setiap {$a} detik';
$string['updatethis'] = 'Perbaharui {$a} ini';
$string['updatethiscourse'] = 'Perbarui kursus ini';
$string['upload'] = 'Unggah';
$string['uploadafile'] = 'Unggah berkas';
$string['uploadcantwrite'] = 'Gagal menulis berkas ke diska';
$string['uploadedfile'] = 'Berkas berhasil diunggah';
$string['uploadedfileto'] = '{$a->file} diunggah ke {$a->directory}';
$string['uploadedfiletoobig'] = 'Maaf, berkas terlalu besar (limitnya adalah {$a} byte)';
$string['uploadextension'] = 'Unggahan berkas dihentikan oleh ekstensi PHP';
$string['uploadfailednotrecovering'] = 'Unggahan berkas Anda gagal karena ada masalah dengan salah satu berkas, {$a->name}. <br /> Berikut adalah log masalah tersebut: <br /> {$a->problem} <br / > Tidak pulih.';
$string['uploadfilelog'] = 'Unggah log untuk berkas {$a}';
$string['uploadformlimit'] = 'Berkas {$a} yang diunggah melampaui batas ukuran yang diatur di dalam formulir';
$string['uploadlabel'] = 'Judul:';
$string['uploadlimitwithsize'] = 'Batas unggah {$a->contextname} ({$a->displaysize})';
$string['uploadnewfile'] = 'Unggah berkas baru';
$string['uploadnofilefound'] = 'Tidak ada berkas ditemukan - Anda yakin telah memilih berkas untuk diunggah?';
$string['uploadnotallowed'] = 'Unggahan tidak diizinkan.';
$string['uploadnotempdir'] = 'Kehilangan folder sementara';
$string['uploadoldfilesdeleted'] = 'Berkas lama di area unggahan telah dihapus';
$string['uploadpartialfile'] = 'Berkas hanya terunggah sebagian';
$string['uploadproblem'] = 'Masalah yang tidak diketahui ditemukan saat mengunggah berkas \'{$a}\' (mungkin ukurannya terlalu besar)';
$string['uploadrenamedchars'] = 'Berkas telah diubah namanya dari {$a->oldname} ke {$a->newname} karena adanya karakter yang tidak valid';
$string['uploadrenamedcollision'] = 'Berkas diganti namanya dari {$a->oldname} menjadi {$a->newname} karena ada konflik nama berkas yang sama.';
$string['uploadserverlimit'] = 'Berkas yang diunggah melebihi batas ukuran maksimum yang diatur oleh server';
$string['uploadthisfile'] = 'Unggah berkas ini';
$string['url'] = 'URL';
$string['used'] = 'Digunakan';
$string['usedinnplaces'] = 'Digunakan di {$a} tempat';
$string['user'] = 'Pengguna';
$string['useraccount'] = 'Akun pengguna';
$string['useractivity'] = 'Aktivitas';
$string['userconfirmed'] = 'Dikonfirmasi {$a}';
$string['userdata'] = 'Data pengguna';
$string['userdeleted'] = 'Akun pengguna ini telah dihapus';
$string['userdescription'] = 'Deskripsi';
$string['userdescription_help'] = 'Kotak ini memungkinkan Anda untuk menjelaskan tentang diri Anda yang kemudian akan ditampilkan pada halaman profil Anda untuk dilihat orang lain.';
$string['userdetails'] = 'Detail pengguna';
$string['userfiles'] = 'Berkas pengguna';
$string['userlist'] = 'Daftar pengguna';
$string['usermatchedon'] = 'Pengguna ini mencocokkan pencarian melalui ruas berikut';
$string['usermenu'] = 'Menu pengguna';
$string['usermenugoback'] = 'Kembali ke menu pengguna';
$string['username'] = 'Nama pengguna';
$string['usernameemail'] = 'Nama pengguna atau surel';
$string['usernameemailmatch'] = 'Nama pengguna dan alamat surel tidak berasal dari pengguna yang sama';
$string['usernameexists'] = 'Nama pengguna ini telah dipakai, pilih nama yang lain';
$string['usernamelowercase'] = 'Hanya boleh huruf kecil';
$string['usernamenotfound'] = 'Nama pengguna tidak ditemukan dalam basis data';
$string['usernameoremail'] = 'Masukkan nama pengguna atau alamat surel';
$string['usernotconfirmed'] = 'Tidak dapat konfirmasi {$a}';
$string['userpic'] = 'Gambar pengguna';
$string['userpreferences'] = 'Preferensi pengguna';
$string['users'] = 'Pengguna';
$string['userselectorautoselectunique'] = 'Jika hanya satu pengguna yang cocok dengan pencarian, pilih mereka secara otomatis';
$string['userselectorpreserveselected'] = 'Pertahankan pengguna yang dipilih, meskipun mereka tidak lagi cocok dengan pencarian';
$string['userselectorsearchanywhere'] = 'di mana saja';
$string['userselectorsearchexactmatchonly'] = 'Hanya pencocokan yang persis';
$string['userselectorsearchfromstart'] = 'dari awal';
$string['userselectorsearchmatching'] = 'Cocok:';
$string['usersnew'] = 'Pengguna baru';
$string['usersnoaccesssince'] = 'Tidak aktif selama lebih dari';
$string['userswithfiles'] = 'Pengguna dengan berkas';
$string['useruploadtype'] = 'Tipe unggahan pengguna: {$a}';
$string['userzones'] = 'Zona pengguna';
$string['usetheme'] = 'Gunakan tema';
$string['usingexistingcourse'] = 'Gunakan kursus yang ada';
$string['validatehtml'] = 'Validasi HTML';
$string['valuealreadyused'] = 'Nilai ini sudah pernah digunakan.';
$string['version'] = 'Versi';
$string['view'] = 'Lihat';
$string['viewallcourses'] = 'Tampilkan semua kursus';
$string['viewallcoursescategories'] = 'Tampilkan semua kursus dan kategori';
$string['viewallresults'] = 'Lihat semua hasil ({$a})';
$string['viewallsubcategories'] = 'Lihat semua subkategori';
$string['viewfileinpopup'] = 'Lihat berkas di jendela sembulan';
$string['viewing'] = 'Melihat:';
$string['viewmore'] = 'Lihat selengkapnya';
$string['viewprofile'] = 'Lihat profil';
$string['views'] = 'Tampilan';
$string['viewsolution'] = 'lihat solusi';
$string['visible'] = 'Terlihat';
$string['visible_help'] = 'Setelan ini menentukan apakah kursus ini muncul dalam daftar kursus. Selain pengajar dan administrator, pengguna tidak diperbolehkan untuk masuk kursus.';
$string['visibletostudents'] = 'Diperlihatkan pada {$a}';
$string['warning'] = 'Peringatan';
$string['warningdeleteresource'] = 'Peringatan: {$a} dirujuk di sumber. Apakah Anda ingin memperbarui sumber daya?';
$string['wcagcheck'] = 'Periksa Pedoman Aksesibilitas Konten Web (WCAG)';
$string['webpage'] = 'Halaman Web';
$string['week'] = 'Minggu';
$string['weeks'] = 'minggu';
$string['welcomeback'] = 'Jumpa lagi,  {$a->firstname}! 👋';
$string['welcometocourse'] = 'Selamat Datang di {$a}';
$string['welcometocoursetext'] = 'Selamat datang di {$a->coursename}!

Jika Anda belum melakukannya, Anda harus mengedit halaman profil Anda sehingga kami dapat mempelajari lebih lanjut tentang Anda:

<a href="{$a->profileurl}">{$a->profileurl<a>';
$string['welcometosite'] = 'Selamat datang,  {$a->firstname}! 👋';
$string['whatforlink'] = 'Apa yang Anda ingin lakukan dengan tautan?';
$string['whatforpage'] = 'Apa yang Anda ingin lakukan dengan teks?';
$string['whatisyourage'] = 'Berapa umur Anda?';
$string['whattocallzip'] = 'Apa yang ingin Anda sebutkan pada berkas zip?';
$string['whattodo'] = 'Daftar pekerjaan';
$string['wheredoyoulive'] = 'Di negara mana Anda tinggal?';
$string['whyisthisrequired'] = 'Mengapa ini diperlukan?';
$string['windowclosing'] = 'Jendela ini seharusnya otomatis tertutup. Jika tidak, silakan tutup sekarang.';
$string['withchosenfiles'] = 'dengan berkas terpilih';
$string['withdisablednote'] = '{$a} (dinonaktifkan)';
$string['withoutuserdata'] = 'tanpa data pengguna';
$string['withselectedusers'] = 'Pengguna terpilih...';
$string['withuserdata'] = 'dengan data pengguna';
$string['wontrunfuturescheduledtask'] = 'Tidak akan menjalankan tugas yang belum gagal dan dijadwalkan untuk dijalankan di masa mendatang';
$string['wordforstudent'] = 'Sebutan lain untuk Siswa';
$string['wordforstudenteg'] = 'mis. Siswa, Peserta, dll.';
$string['wordforstudents'] = 'Sebutan lain untuk Siswa';
$string['wordforstudentseg'] = 'mis. Siswa, Peserta, Pelajar dll.';
$string['wordforteacher'] = 'Sebutan lain untuk Pengajar';
$string['wordforteachereg'] = 'mis. guru, dosen, mentor, tutor, fasilitator, dll.';
$string['wordforteachers'] = 'Sebutan lain untuk Pengajar';
$string['wordforteacherseg'] = 'mis. guru, dosen, mentor, tutor, fasilitator, dll.';
$string['writingblogsinfo'] = 'Menulis informasi blog';
$string['writingcategoriesandquestions'] = 'Menuliskan kategori dan soal';
$string['writingcoursedata'] = 'Menuliskan data kursus';
$string['writingeventsinfo'] = 'Menuliskan info acara';
$string['writinggeneralinfo'] = 'Menuliskan info umum';
$string['writinggradebookinfo'] = 'Info penulisan buku nilai';
$string['writinggroupingsgroupsinfo'] = 'Menulis info pengelompokan-grup';
$string['writinggroupingsinfo'] = 'Menulis info pengelompokan';
$string['writinggroupsinfo'] = 'Menuliskan info grup';
$string['writingheader'] = 'Menuliskan tajuk';
$string['writingloginfo'] = 'Menuliskan info log';
$string['writingmessagesinfo'] = 'Menuliskan info pesan';
$string['writingmoduleinfo'] = 'Menuliskan info modul';
$string['writingscalesinfo'] = 'Menuliskan info skala';
$string['writinguserinfo'] = 'Menuliskan info pengguna';
$string['wrongpassword'] = 'Kata sandi yang salah untuk pengguna ini';
$string['year'] = 'tahun';
$string['years'] = 'tahun';
$string['yes'] = 'Ya';
$string['youareabouttocreatezip'] = 'Anda sedang membuat berkas zip yang berisi';
$string['youaregoingtorestorefrom'] = 'Anda sedang memulai proses pemulihan';
$string['youhaveupcomingactivitiesdue'] = 'Anda memiliki aktivitas mendatang yang jatuh temp';
$string['youhaveupcomingactivitiesdueinfo'] = 'Halo {$a}, <br/><br/>Anda memiliki aktivitas jatuh tempo:';
$string['youneedtoenrol'] = 'Anda harus terdaftar pada kursus untuk melakukan aksi tersebut.';
$string['yourlastlogin'] = 'Log masuk terakhir Anda adalah';
$string['yourself'] = 'Anda sendiri';
$string['yourteacher'] = '{$a} Anda';
$string['yourwordforx'] = 'Sebutan lain untuk \'{$a}\'';
$string['zippingbackup'] = 'Mengkompres zip percadangan';
