<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'hu', version '5.1'.
 *
 * @package     h5p
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a11yTitle:label'] = 'Támogató-segítő eszközök címke';
$string['acceptTerms'] = 'Elfogadom a <a href=":url" target="_blank">felhasználási feltételeket</a>';
$string['accountDetailsLinkText'] = 'itt';
$string['actions'] = 'Műveletek';
$string['add'] = 'Hozzáadás';
$string['addedandupdatedpp'] = '{$a->%new} új H5P-könyvtár hozzáadva és {$a->%old} régebbi frissítve.';
$string['addedandupdatedps'] = '{$a->%new} új H5P-könyvtár hozzáadva és {$a->%old} régebbi frissítve.';
$string['addedandupdatedsp'] = '{$a->%new} új H5P-könyvtár hozzáadva és {$a->%old} régebbi frissítve.';
$string['addedandupdatedss'] = '{$a->%new} új H5P-könyvtár hozzáadva és {$a->%old} régebbi frissítve.';
$string['addednewlibraries'] = '{$a->%new} új H5P-könyvtár hozzáadva.';
$string['addednewlibrary'] = '{$a->%new} új H5P-könyvtár hozzáadva.';
$string['additionallicenseinfo'] = 'Az engedélyre vonatkozó egyéb információk';
$string['address'] = 'Cím';
$string['age'] = 'Javasolt életkor';
$string['ageDescription'] = 'A tartalom célközönségének kora. Az értékeket vesszővel elválasztva lehet megadni: "1,34-45,-50,59-".';
$string['altText'] = 'Helyettesítő szöveg';
$string['atto_h5p'] = 'H5P-gomb beszúrása';
$string['atto_h5p_description'] = 'Az Atto szerkesztőben a H5P-gomb beszúrása esetén a felhasználók H5P-tartalmat szúrhatnak be webcím megadásával vagy kód beágyazásával, illetve H5P-állomány feltöltésével.';
$string['author'] = 'Szerző';
$string['authorcomments'] = 'Szerző megjegyzései';
$string['authorcommentsdescription'] = 'A tartalom szerkesztőjének szánt megjegyzések  (ez a szöveg nem kerül bele a szerzői jogi tájékoztatóba).';
$string['authorname'] = 'A szerző neve';
$string['authorrole'] = 'A szerző szerepe';
$string['back'] = 'Vissza';
$string['by'] = 'készítette';
$string['cancelCrop'] = 'Körülvágás elvetése';
$string['cancelPublishConfirmationDialogCancelButtonText'] = 'Nem';
$string['cancelPublishConfirmationDialogConfirmButtonText'] = 'Igen';
$string['cancelPublishConfirmationDialogDescription'] = 'Biztosan megszakítja a megosztási folyamatot?';
$string['cancelPublishConfirmationDialogTitle'] = 'Megosztás megszakítása';
$string['cancellabel'] = 'Törlés';
$string['ccattribution'] = 'Forrásmegjelölés (CC BY)';
$string['ccattributionnc'] = 'Forrásmegjelölés-NeAddEl (CC BY-NC)';
$string['ccattributionncnd'] = 'Forrásmegjelölés-NeAddEl-NeVáltoztasd (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Forrásmegjelölés-NeAddEl-ÍgyAddTovább (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Forrásmegjelölés-NeVáltoztasd (CC BY-ND)';
$string['ccattributionsa'] = 'Forrásmegjelölés-ÍgyAddTovább (CC BY-SA)';
$string['ccpdd'] = 'Közkincs  (CC0)';
$string['changeHasBeenSubmitted'] = 'Új módosítás érkezett az alábbihoz';
$string['changedby'] = 'Módosította';
$string['changedescription'] = 'Módosítás leírása';
$string['changelog'] = 'Módosítási napló';
$string['changeplaceholder'] = 'Fénykép körülvágva, szöveg módosítva stb.';
$string['city'] = 'Város';
$string['close'] = 'Bezárás';
$string['confirmCrop'] = 'Körülvágás elfogadása';
$string['confirmdialogbody'] = 'Erősítse meg, hogy folytatni kívánja. A lépés nem visszafordítható.';
$string['confirmdialogheader'] = 'Lépés megerősítése';
$string['confirmlabel'] = 'Megerősítés';
$string['connectionLost'] = 'A kapcsolat megszűnt. Az eredményeket tároljuk és akkor küldjük el, ha a kapcsolat helyreállt.';
$string['connectionReestablished'] = 'A kapcsolat helyreállt';
$string['contactPerson'] = 'Kapcsolattartó személy';
$string['contactPersonDescription'] = 'A H5P az itt megadott illetőt fogja keresni a készítő által megosztott tartalmakhoz kapcsolódó esetleges problémák esetén. A kapcsolattartó neve vagy bármilyen más adata nem lesz nyilvános, és nem lesz megosztva harmadik féllel sem';
$string['contentAvailable'] = 'A tartalom várhatóan egy munkanapon belül elérhető lesz a Hub-on.';
$string['contentCopied'] = 'A tartalom a vágólapra másolva';
$string['contentLicenseTitle'] = 'Tartalmi licenc adadtok';
$string['contentUpdateSoon'] = 'A tartalom hamarosan frissülni fog.';
$string['contentchanged'] = 'A tartalom az utolsó használat óta módosult.';
$string['contentinuse'] = 'A tartalom egyéb helyen lehet használatban.';
$string['contenttype'] = 'A tartalom típusa';
$string['copyright'] = 'Használati jogok';
$string['copyrightWarning'] = 'Jogvédett tartalmak megosztása nem lehetséges a H5P Content Hub-on. Amennyiben a tartalomra olyan OER licenc vonatkozik, mint például a Creative Commons, válassza az ennek megfelelő licencet. Ellenkező esetben ez a tartalom nem osztható meg.';
$string['copyrightinfo'] = 'Szerzői jogi információ';
$string['copyrightstring'] = 'Szerzői jog';
$string['copyrighttitle'] = 'A tartalomra vonatkozó szerzői jogi információ megtekintése';
$string['couldNotParseJSONFromZip'] = 'A(z) {$a->%fileName} csomagban lévő JSON feldolgozása sikertelen';
$string['couldNotReadFileFromZip'] = 'A(z) {$a->%fileName} csomagban lévő állomány beolvasása sikertelen';
$string['country'] = 'Ország';
$string['creativecommons'] = 'Creative Commons';
$string['cropImage'] = 'Kép körülvágása';
$string['currentStep'] = ':step. lépés a :total lépésből';
$string['date'] = 'Dátum';
$string['deletelibraryconfirm'] = '<p>Biztosan törli a(z) <em>\'{$a->version}\'</em> verziót a(z) <em>\'{$a->name}\'</em> könyvtárból? Ezzel törli a könyvtárat és annak minden használatát.</p><p>Ez a lépés nem vonható vissza!</p>';
$string['deletelibraryversion'] = 'Verzió törlése';
$string['deleting'] = 'Könyvtár törlése';
$string['description'] = 'Leírás';
$string['disablefullscreen'] = 'Teljes képernyő kikapcsolása';
$string['discipline:dropdownButton'] = 'Legördülőlista gomb';
$string['discipline:searchPlaceholder'] = 'Kezdjen gépelni a szakterületek kereséséhez';
$string['disciplineDescription'] = 'Több szakterület is kiválasztható';
$string['disciplineLabel'] = 'Szakterületek';
$string['disciplineLimitReachedMessage'] = 'Legfeljebb :numDisciplines szakterület választható ki';
$string['disciplines'] = 'Szakterületek';
$string['download'] = 'Letöltés';
$string['downloadtitle'] = 'A tartalom letöltése  H5P-állomány formájában';
$string['editInfoTitle'] = '<strong>:title</strong> adatainak szerkesztése';
$string['editcontent'] = 'H5P-tartalom szerkesztése';
$string['editingFailed'] = 'Szerkesztés sikertelen.';
$string['editor'] = 'Szerkesztő';
$string['emailAddress'] = 'Email cím';
$string['emailAddressDescription'] = 'A H5P az itt megadott email címen keresztül fog kapcsolatba lépni készítővel az esetleges tartalmi problémák esetén, vagy ha a készítő megpróbálja visszaállítani a fiókját. A cím nem lesz nyilvánosan elérhető, és nem lesz megosztva harmadik féllel sem';
$string['embed'] = 'Beágyazás';
$string['embedtitle'] = 'A tartalom beágyazási kódjának megtekintése';
$string['error:emptycontentid'] = 'Hibás a webcím vagy nem szerkesztheti az állományt.';
$string['eventh5pdeleted'] = 'H5P törölve';
$string['eventh5pviewed'] = 'H5P-tartalom megtekintve';
$string['feature'] = 'Jellemző';
$string['fetchtypesfailure'] = 'Nincs információ az elérhető H5P tartalomtípusokra vonatkozóan. Hiba a H5P-adattárhoz kapcsolódás során';
$string['fileExceedsMaxSize'] = 'A csomagban lévő egyik fájl mérete meghaladja a megengedettet. ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = 'H5P-szűrő megjelenítése';
$string['filter_displayh5p_description'] = 'A H5P-szűrő megjelenítése a webcímeket beágyazott H5P-tartalommá alakítja át.';
$string['fullscreen'] = 'Teljes képernyő';
$string['gpl'] = '3. általános licenc';
$string['h5p'] = 'H5P';
$string['h5pcustomcss'] = 'Egyéni CSS';
$string['h5pcustomcss_help'] = 'A H5P tartalomnál alkalmazott CSS.';
$string['h5peditor'] = 'H5P-szerkesztő';
$string['h5pfilenotfound'] = 'A H5P-állomány nem található';
$string['h5pinvalidurl'] = 'H5P-tartalom érvénytelen webcíme';
$string['h5plibraryhandler'] = 'H5P-keretkezelő';
$string['h5plibraryhandler_help'] = 'Tetszőleges H5P-tartalom megjelenítésére való H5P-keret. Ajánlott a legfrissebb verzió használata.';
$string['h5pmanage'] = 'H5P tartalomtípusok kezelése';
$string['h5poverview'] = 'H5P áttekintése';
$string['h5ppackage'] = 'H5P tartalomtípus';
$string['h5ppackage_help'] = 'A H5P tartalomtípus olyan H5P vagy ZIP kiterjesztésű állomány, amely a tartalom megjelenítéséhez szükséges összes könyvtárat tartalmazza.';
$string['h5pprivatefile'] = 'A H5P-tartalmat nem tekintheti meg, mert nem fér hozzá a h5p-állományhoz.';
$string['h5psettings'] = 'H5P-beállítások';
$string['h5ptitle'] = 'További tartalmakért látogasson el a h5p.org weboldalra.';
$string['height'] = 'magasság';
$string['helpChoosingLicense'] = 'Segíts licencet választani';
$string['hideadvanced'] = 'Részletes elrejtése';
$string['icon'] = 'Ikon';
$string['iconDescription'] = '640x480px. Amennyiben nincs megadva, a tartalom a kategória ikont használja';
$string['installedcontentlibraries'] = 'Telepített H5P-könyvtárak';
$string['installedcontenttypes'] = 'Telepített H5P tartalomtípusok';
$string['installedh5p'] = 'Telepített H5P';
$string['invalidAge'] = 'Érvénytelen bemeneti formátum a Javasolt életkorra. Az elfogadott bemeneti formátumok, vesszővel elválasztva: "1, 34-45, -50, -59-".';
$string['invalidcontextid'] = 'A H5P-állomány nem található (érvénytelen contextid)';
$string['invalidfile'] = '"{$a->%filename}" nevű fájl használata nem megengedett. Csak az alábbi kiterjesztésű fájlokat használhatja: {$a->%files-allowed}.';
$string['invalidlanguagefile'] = 'Érvénytelen nyelvű {$a->%file} állomány a(z) {$a->%library} könyvtárban';
$string['invalidlanguagefile2'] = 'Érvénytelen nyelvű  {$a->%languageFile} állomány került a(z) {$a->%name} könyvtárba';
$string['invalidlibrarydata'] = 'Érvénytelen {$a->%property} adat került a(z) {$a->%library} könyvtárba';
$string['invalidlibrarydataboolean'] = 'Érvénytelen {$a->%property} adat került a(z) {$a->%library} könyvtárba. Logikai érték szükséges.';
$string['invalidlibraryname'] = 'Érvénytelen könyvtárnév: {$a->%name}';
$string['invalidlibrarynamed'] = 'A tartalomban használt {$a->%library} H5P-könyvtár érvénytelen';
$string['invalidlibraryoption'] = 'Érvénytelen {$a->%option} lehetőség a(z) {$a->%library} könyvtárban';
$string['invalidlibraryproperty'] = 'A(z)  {$a->%property} tulajdonság a(z) {$a->%library} könyvtárban nem olvasható';
$string['invalidmainjson'] = 'Hiányzik egy érvényes fő h5p.json fájl';
$string['invalidmultiselectoption'] = 'Érvénytelen kiválasztott lehetőség a többszörös kijelölésben.';
$string['invalidpackage'] = 'Érvénytelen H5P tartalomtípus';
$string['invalidselectoption'] = 'Érvénytelen kiválasztott lehetőség a kijelölésben.';
$string['invalidsemanticsjson'] = 'Érvénytelen semantics.json állomány került a(z) {$a->%name} könyvtárba';
$string['invalidsemanticstype'] = 'Belső H5P-hiba: a szemantikában ismeretlen "{$a->@type}" típusú tartalom van. A tartalmat eltávolítjuk!';
$string['invalidstring'] = 'A megadott szöveg a szemantikában lévő reguláris kifejezés szerint érvénytelen. (érték: "{$a->%value}", regexp: "{$a->%regexp}")';
$string['isNowSubmitted'] = 'Leadva a H5P Hub-ba';
$string['keywordExists'] = 'A kulcsszó már létezik!';
$string['keywords'] = 'Kulcsszavak';
$string['keywordsDescription'] = 'Több kulcsszó is hozzáadható, vesszővel elválasztva azokat. Nyomjon "Enter"-t vagy "Hozzáadás"-t a kulcsszó elfogadásához.';
$string['keywordsExits'] = 'A kulcsszó már létezik!';
$string['keywordsPlaceholder'] = 'Kulcsszavak hozzáadása';
$string['language'] = 'Nyelv';
$string['level'] = 'Szint';
$string['librariesmanagerdescription'] = '<p>A H5P révén a felhasználók egy sor tartalomtípus megadásával interaktív tartalmakat hozhatnak létre.</p><p>Ahhoz, hogy portálján kizárólag megbízható H5P tartalomtípusok használatára kerüljön sor, <i>vagy</i></p><ul><li>a h5p.org portálról töltsön föl H5P tartalomtípusokat, <i>vagy</i></li><li>kapcsolja be az \'Elérhető H5P tartalomtípusok letöltése a h5p.org portálról\' ütemezett feladatot.</li></ul><p>Ne feledje, hogy a felhasználók csak a portálján telepített H5P tartalomtípusokat fogják tudni használni.</p>';
$string['librarydirectoryerror'] = 'A könyvtárnévnek egyeznie kell a library.json-ban megadott machineName vagy machineName-majorVersion.minorVersion értékével. (Könyvtár: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['license'] = 'Engedély';
$string['licenseCC010'] = 'CC0 1.0 Egyetemes (CC0 1.0) Közkincs';
$string['licenseCC010U'] = 'CC0 1.0 Egyetemes';
$string['licenseCC10'] = '1.0 Általános';
$string['licenseCC20'] = '2.0 Általános';
$string['licenseCC25'] = '2.5 Általános';
$string['licenseCC30'] = '3.0 Jogrendtől független';
$string['licenseCC40'] = '4.0 Nemzetközi';
$string['licenseDescription'] = 'Licenc választása a tartalomhoz';
$string['licenseDetails'] = 'Licenc részletek';
$string['licenseDialogDescription'] = 'Kattintson egy adott licencre további részletekért a megfelelő használatról';
$string['licenseGPL'] = 'Általános nyilvános licenc';
$string['licenseV1'] = '1. verzió';
$string['licenseV2'] = '2. verzió';
$string['licenseV3'] = '3. verzió';
$string['licenseVersionDescription'] = 'Licenc verzió kiválasztása';
$string['licensee'] = 'Licenc birtokos';
$string['licenseextras'] = 'Kiegészítő engedélyek';
$string['licenseversion'] = 'Engedély verziója';
$string['lockh5pdeploy'] = 'A H5P-tartalom telepítés miatt nem elérhető. Próbálkozzon később.';
$string['logoUploadText'] = 'Szervezeti logó vagy avatar';
$string['longDescription'] = 'Hosszú leírás';
$string['longDescriptionPlaceholder'] = 'A tartalom hosszú leírása';
$string['mainTitle'] = '<strong>:title</strong> megosztása';
$string['mainlibrarydisabled'] = 'Ez a fájl nem jeleníthető meg, mert a tartalom típusa nem támogatott. Forduljon a rendszergazdához, aki engedélyezheti az adott tartalomtípus használatát.';
$string['maxLength'] = 'A karakterek maximális száma :length';
$string['missingcontentfolder'] = 'Nincs érvényes tartalommappa';
$string['missingcoreversion'] = 'A rendszer a csomagból nem tudta telepíteni a(z) {$a->%component} összetevőt, ehhez a H5P-segédprogram újabb verziója szükséges. A portálon jelenleg a(z) {$a->%current} verzió fut a szükséges {$a->%required} vagy későbbi helyett. Frissítsen az újabb verzióra, majd próbálja meg újból.';
$string['missingdependency'] = 'Hiányzik a(z)  {$a->@lib} által előírt {$a->@dep} függőség.';
$string['missinglibrary'] = 'Hiányzik az előírt {$a->@library} könyvtár';
$string['missinglibraryfile'] = 'A(z) "{$a->%name}" könyvtárból hiányzik a(z) "{$a->%file}" állomány';
$string['missinglibraryjson'] = 'A(z) "{$a->%name}" könyvtárhoz nem található az érvényes json formájú  library.json állomány';
$string['missinglibraryproperty'] = 'A(z) {$a->%library} könyvtárból hiányzik az előírt {$a->%property} tulajdonság';
$string['missingmainlibrary'] = 'A {$a->@library} központi könyvtár hiányzik';
$string['missingmbstring'] = 'Nincs betöltve a H5P helyes működéséhez szükséges mbstring PHP-kiterjesztés.';
$string['missinguploadpermissions'] = 'A feltöltött állományban előfordulhatnak a könyvtárak, de újakat nem tölthet föl. Forduljon a rendszergazdához!';
$string['next'] = 'Tovább';
$string['nocopyright'] = 'A tartalomhoz nincs szerzői jogi tájékoztatás.';
$string['noextension'] = 'A feltöltött állomány érvénytelen HTML5 csomag (hiányzik a .h5p kiterjesztés)';
$string['noh5plibhandlerdefined'] = 'Nincs telepítve H5P-keretkezelő, ezért nem jeleníthető meg H5P-tartalom.';
$string['nojson'] = 'A fő h5p.json fájl érvénytelen';
$string['nopermissiontodeploy'] = 'Az állományt nem lehet megjeleníteni, mert a feltöltőjének nincs meg a H5P-tartalom használatához szükséges jogosultsága.';
$string['nopermissiontoedit'] = 'Nem jogosult H5P-tartalmat szerkeszteni.';
$string['notrustablefile'] = 'Az állomány nem jeleníthető meg, mert azt H5P tartalomtípusok frissítésére nem jogosult felhasználó töltötte föl. A tartalomtípus telepítése végett forduljon a rendszergazdához.';
$string['nounzip'] = 'A feltöltött állomány érvénytelen HTML5 csomag (nem lehet kicsomagolni).';
$string['offlineDialogBody'] = 'A feladat teljesítéséről nem tudunk tájékoztatást küldeni. Ellenőrizze internetes csatlakozását.';
$string['offlineDialogHeader'] = 'A szerverrel való kapcsolata megszakadt.';
$string['offlineDialogRetryButtonLabel'] = 'Újrapróbálkozás most';
$string['offlineDialogRetryMessage'] = 'Újrapróbálkozás ... múlva';
$string['offlineSuccessfulSubmit'] = 'Eredmények sikeresen leadva.';
$string['optionalInfo'] = 'Opcionális adatok';
$string['originator'] = 'Feladó';
$string['pd'] = 'Közkincs';
$string['pddl'] = 'Közkinccsé tétel és licenc';
$string['pdm'] = 'Közkincshez tartozó (PDM)';
$string['phone'] = 'Telefonszám';
$string['pleaseWait'] = 'Kérem, várjon...';
$string['pluginname'] = 'H5P-csomag';
$string['privacy:metadata'] = 'A H5P-alrendszer nem tárol személyes adatokat.';
$string['publisherDescription'] = 'Készítő leírása';
$string['publisherDescriptionText'] = 'A megosztott tartalomnál a "Készítő adatai" résznél megjelenő leírás';
$string['publisherFieldDescription'] = 'A megosztott tartalomnál a "Készítő neve" résznél megjelenő név';
$string['publisherFieldTitle'] = 'Készítő';
$string['registerOnHub'] = 'Regisztrálás a H5P Hub-on';
$string['registrationFailed'] = 'Hiba történt';
$string['registrationFailedDescription'] = 'A fiók létrehozása most nem sikerült. Valamilyen hiba történt. Probálkozzon később!';
$string['registrationTitle'] = 'H5P Hub regisztráció';
$string['remove'] = 'Eltávolítás';
$string['removeChip'] = ':chip eltávolítása a listából';
$string['removeImage'] = 'Kép eltávolítása';
$string['requiredInfo'] = 'Szükséges adat';
$string['resizescript'] = 'Ha portálján dinamikusan szeretné méretezni a beágyazott tartalmat, szúrja be az alábbi kódrészletet:';
$string['resubmitScores'] = 'Próbálkozás a tárolt eredmények leadásával';
$string['reuse'] = 'Újbóli használat';
$string['reuseContent'] = 'Tartalom újbóli használata';
$string['reuseDescription'] = 'A tartalom újbóli használata.';
$string['rotateLeft'] = 'Forgatás balra';
$string['rotateRight'] = 'Forgatás jobbra';
$string['saveChanges'] = 'Módosítások mentése';
$string['screenshots'] = 'Képernyőképek';
$string['screenshotsDescription'] = 'Legfeljebb 5 képernyőkép hozzáadása a tartalomhoz';
$string['share'] = 'Megosztás';
$string['shareFailed'] = 'Megosztás sikertelen.';
$string['shareTryAgain'] = 'Valamilyen hiba történt, kérjük, próbálja újra a megosztást!';
$string['shared'] = 'Megosztva';
$string['sharingNote'] = 'A tartalom minden részlete módosítható a megosztás után';
$string['shortDescription'] = 'Rövid leírás';
$string['shortDescriptionPlaceholder'] = 'A tartalom rövid leírása';
$string['showadvanced'] = 'Részletek megjelenítése';
$string['showless'] = 'Kevesebb megjelenítése';
$string['showmore'] = 'Több megjelenítése';
$string['size'] = 'Méret';
$string['someKeywordsExits'] = 'A kulcsszavak némelyike már létezik';
$string['source'] = 'Forrás';
$string['startingover'] = 'Újra fogja kezdeni.';
$string['status'] = 'Állapot';
$string['subContentWarning'] = 'A tartalmi elemek (képek, kérdések stb.) megosztása a :license szerint fog történni, hacsak a szerkesztő eszközben ez nincs másképp beállítva';
$string['sublevel'] = 'Alszint';
$string['submitted'] = 'Leadva!';
$string['successfullyRegistred'] = 'Sikeresen regisztrálta fiókját a H5P Hub-on';
$string['successfullyRegistredDescription'] = 'Módosíthatja a fiókja adatait';
$string['successfullyUpdated'] = 'A H5P Hub fiókjának beállításai sikeresen módosítva lettek';
$string['task_h5p'] = 'Ütemezett H5P-feladat';
$string['task_h5p_description'] = 'Az Ütemezett H5P-feladat segítségével meglévő H5P-tartalomtípusokat tölthet le a h5p.org portálról.feladat';
$string['thumbnail'] = 'Miniatűr';
$string['title'] = 'Cím';
$string['undisclosed'] = 'Rejtett';
$string['unpackedFilesExceedsMaxSize'] = 'A tömörítetlen állományok teljes mérete meghaladja az engedélyezettet.  ({$a->%used} > {$a->%max})';
$string['updateRegistrationOnHub'] = 'Fiókbeállítások mentése';
$string['updatedlibraries'] = '{$a->%old} H5P-könyvtár frissítve.';
$string['updatedlibrary'] = '{$a->%old} H5P-könyvtár frissítve.';
$string['uploadlibraries'] = 'H5P tartalomtípusok feltöltése';
$string['uploadsuccess'] = 'A H5P tartalomtípusok feltöltése sikerült';
$string['width'] = 'szélesség';
$string['wrongversion'] = 'A tartalomban használt {$a->%machineName} H5P-könyvtár verziója érvénytelen. A tartalomban {$a->%contentLibrary} könyvtár szerepel  {$a->%semanticsLibrary} helyett.';
$string['year'] = 'Év';
$string['years'] = 'Év(ek)';
$string['yearsfrom'] = 'Évek (ekkortól)';
$string['yearsto'] = 'Évek (eddig)';
$string['zip'] = 'Irányítószám';
