<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'role', language 'eu', version '5.1'.
 *
 * @package     role
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addinganewrole'] = 'Rol berria gehitzen';
$string['addrole'] = 'Gehitu rol berria';
$string['advancedoverride'] = 'Rol-baliogabetze aurreratua';
$string['ai:acceptpolicy'] = 'Onartu AA politika';
$string['ai:fetchanyuserpolicystatus'] = 'Lortu erabiltzaileen AA politiken onarpen bat';
$string['ai:fetchpolicy'] = 'Lortu erabiltzaileen AA politiken onarpen bat';
$string['ai:viewaipolicyacceptancereport'] = 'Ikusi AA politiken onarpenen txostena';
$string['ai:viewaiusagereport'] = 'Ikusi AA erabilera-txostena';
$string['allow'] = 'Baimendu';
$string['allowassign'] = 'Baimendu rolak esleitzea';
$string['allowed'] = 'Baimenduta';
$string['allowoverride'] = 'Baimendu rol-baliogabetzeak';
$string['allowroletoassign'] = 'Baimendu {$a->fromrole} rola duten erabiltzaileei {$a->targetrole} rola esleitzen';
$string['allowroletooverride'] = 'Baimendu {$a->fromrole} rola duten erabiltzaileei {$a->targetrole} rola kentzen';
$string['allowroletoswitch'] = 'Baimendu {$a->fromrole} rola duten erabiltzaileei {$a->targetrole} rola aukeratzen';
$string['allowroletoview'] = 'Baimendu {$a->fromrole} rola duten erabiltzaileei {$a->targetrole} rola ikustea';
$string['allowswitch'] = 'Baimendu rol-aldaketak';
$string['allowview'] = 'Baimendu rolari ikustea';
$string['allsiteusers'] = 'Guneko erabiltzaile guztiak';
$string['analytics:listinsights'] = 'Pertzepzioen zerrenda';
$string['analytics:listowninsights'] = 'Zerrendatu pertzepzio propioak';
$string['analytics:managemodels'] = 'Kudeatu modeloak';
$string['archetype'] = 'Rol arketipoa';
$string['archetype_help'] = 'Rol arketipoak rol bati modu lehenetsian ematen zaizkion baimenak zehazten ditu, baita gunea eguneratzen denean ematen diren baimen berriak ere.';
$string['archetypecoursecreator'] = 'ARKETIPOA: Ikastaro-sortzailea';
$string['archetypeeditingteacher'] = 'ARKETIPOA: Irakaslea (edizio-baimenekin)';
$string['archetypefrontpage'] = 'ARKETIPOA: Autentifikatutako erabiltzailea hasiera-orrian';
$string['archetypeguest'] = 'ARKETIPOA: Gonbidatua';
$string['archetypemanager'] = 'ARKETIPOA: Kudeatzailea';
$string['archetypestudent'] = 'ARKETIPOA: Ikaslea';
$string['archetypeteacher'] = 'ARKETIPOA: Irakaslea (edizio-baimenik gabe)';
$string['archetypeuser'] = 'ARKETIPOA: Autentifikatutako erabiltzailea';
$string['assignanotherrole'] = 'Esleitu beste rol bat';
$string['assignedroles'] = 'Esleitutako rolak';
$string['assignerror'] = 'Errorea {$a->user} erabiltzaileari {$a->role} rola ezartzean.';
$string['assignglobalroles'] = 'Esleitu sistemako rolak';
$string['assignmentcontext'] = 'Esleipenaren testuingurua';
$string['assignmentoptions'] = 'Esleipenaren aukerak';
$string['assignrole'] = 'Esleitu rola';
$string['assignrolenameincontext'] = 'Esleitu {$a->role} rola {$a->context} testuinguruan';
$string['assignroles'] = 'Esleitu rolak';
$string['assignroles_help'] = 'Erabiltzaile bati testuinguru batean rol bat esleituta rol horren baimenak ematen dizkiozu testuinguru horretarako eta hortik beherakoetarako. Adibidez, erabiltzaile bati ikastaroan ikaslea rola esleitzen badiozu, ikaslea rola izango du ikastaroko jarduera eta bloke guztietarako.';
$string['assignroles_link'] = 'admin/roles/assign';
$string['assignrolesin'] = 'Esleitu rolak hemen: {$a}';
$string['assignrolesrelativetothisuser'] = 'Esleitu rol erlatiboak erabiltzaile honi';
$string['backtoallroles'] = 'Itzuli rol guztien zerrendara';
$string['backup:anonymise'] = 'Segurtasun-kopian erabiltzaileen datuak anonimo bihurtu';
$string['backup:backupactivity'] = 'Egin jardueren segurtasun-kopia';
$string['backup:backupcourse'] = 'Egin ikastaroen segurtasun-kopia';
$string['backup:backupsection'] = 'Egin atalen segurtasun-kopia';
$string['backup:backuptargetimport'] = 'Egin inportatzeko segurtasun-kopia';
$string['backup:configure'] = 'Konfiguratu segurtasun-kopiaren aukerak';
$string['backup:downloadfile'] = 'Fitxategiak segurtasun-kopien eremutik jaitsi';
$string['backup:userinfo'] = 'Erabiltzaile-datuen segurtasun-kopia';
$string['badges:awardbadge'] = 'Erabiltzaileari domina eman';
$string['badges:configurecriteria'] = 'Dominaren irabazteko irizpideak konfiguratu/editatu';
$string['badges:configuredetails'] = 'Konfiguratu/editatu dominaren xehetasunak';
$string['badges:configuremessages'] = 'Konfiguratu dominaren mezuak';
$string['badges:createbadge'] = 'Sortu/bikoiztu dominak';
$string['badges:deletebadge'] = 'Ezabatu dominak';
$string['badges:earnbadge'] = 'Domina irabazi';
$string['badges:manageglobalsettings'] = 'Kudeatu dominen ezarpen orokorrak';
$string['badges:manageownbadges'] = 'Ikusi eta kudeatu norberak irabazitako dominak';
$string['badges:revokebadge'] = 'Baliogabetu erabiltzaile baten domina';
$string['badges:viewawarded'] = 'Ikusi domina zehatz bat eskuratu duten erabiltzaileak dominak esleitzeko baimenik izan gabe';
$string['badges:viewbadges'] = 'Ikusi irabazi gabeko dominak';
$string['badges:viewotherbadges'] = 'Ikusi Domina publikoak beste erabiltzaileen profiletan';
$string['block:edit'] = 'Editatu blokearen ezarpenak';
$string['block:view'] = 'Ikusi blokea';
$string['blog:create'] = 'Sortu blog-sarrera berriak';
$string['blog:manageentries'] = 'Editatu eta kudeatu sarrerak';
$string['blog:manageexternal'] = 'Editatu eta kudeatu kanpoko blogak';
$string['blog:search'] = 'Blog-sarrerak bilatu';
$string['blog:view'] = 'Ikusi blog-sarrerak';
$string['blog:viewdrafts'] = 'Ikusi blog-sarreren zirriborroa';
$string['calendar:manageentries'] = 'Kudeatu egutegiko edozein sarrera';
$string['calendar:managegroupentries'] = 'Kudeatu egutegian norberaren sarrerak';
$string['calendar:manageownentries'] = 'Kudeatu norberaren egutegiko sarrerak';
$string['capabilities'] = 'Gaitasunak';
$string['capability'] = 'Gaitasuna';
$string['category:create'] = 'Sortu kategoriak';
$string['category:delete'] = 'Ezabatu kategoriak';
$string['category:manage'] = 'Kudeatu kategoriak';
$string['category:update'] = 'Eguneratu kategoriak';
$string['category:viewcourselist'] = 'Ikusi ikastaro-kategoria eta horren baitan dauden ikastaroak';
$string['category:viewhiddencategories'] = 'Ikusi ezkutuko kategoriak';
$string['category:visibility'] = 'Ikusi ezkutuko kategoriak';
$string['checkglobalpermissions'] = 'Egiaztatu sistemako baimenak';
$string['checkpermissions'] = 'Egiaztatu baimenak';
$string['checkpermissionsin'] = 'Egiaztatu baimenak hemen: {$a}';
$string['checksystempermissionsfor'] = 'Egiaztatu baimenak honentzat: {$a->fullname}';
$string['checkuserspermissionshere'] = 'Egiaztatu baimenak {$a->fullname}(r)entzat {$a->contextlevel} testuinguruan';
$string['chooseroletoassign'] = 'Mesedez, aukeratu esleitu beharreko rola';
$string['cohort:assign'] = 'Gehitu eta kendu kohorteko partaideak';
$string['cohort:configurecustomfields'] = 'Konfiguratu kohorteetako eremu pertsonalizatuak';
$string['cohort:manage'] = 'Sortu, ezabatu eta mugitu kohorteak';
$string['cohort:view'] = 'Ikusi gune mailako kohorteak';
$string['comment:delete'] = 'Ezabatu iruzkinak';
$string['comment:post'] = 'Iruzkinak egin';
$string['comment:view'] = 'Ikusi iruzkinak';
$string['competency:competencygrade'] = 'Ezarri konpetentzien puntuazioa';
$string['competency:competencymanage'] = 'Kudeatu konpetentzia-markoak';
$string['competency:competencyview'] = 'Ikusi konpetentzia-markoak';
$string['competency:coursecompetencyconfigure'] = 'Konfiguratu ikastaroko konpetentzien ezarpenak';
$string['competency:coursecompetencygradable'] = 'Jaso konpetentzietako kalifikazioak';
$string['competency:coursecompetencymanage'] = 'Kudeatu ikastaroko konpetentziak';
$string['competency:coursecompetencyview'] = 'Ikusi ikastaroko konpetentziak';
$string['competency:evidencedelete'] = 'Ezabatu ebidentzia';
$string['competency:plancomment'] = 'Egin iruzkinak ikasketa-planari';
$string['competency:plancommentown'] = 'Egin iruzkinak norberaren ikasketa-planari';
$string['competency:planmanage'] = 'Kudeatu ikasketa-planak';
$string['competency:planmanagedraft'] = 'Kudeatu ikasketa-planen zirriborroak';
$string['competency:planmanageown'] = 'Kudeatu norberaren ikasketa-planak';
$string['competency:planmanageowndraft'] = 'Kudeatu norberaren ikasketa-planen zirriborroak';
$string['competency:planrequestreview'] = 'Eskatu ikasketa-plan baten berrikusketa';
$string['competency:planrequestreviewown'] = 'Eskatu norberaren ikasketa-planaren berrikusketa';
$string['competency:planreview'] = 'Berrikusi ikasketa-plana';
$string['competency:planview'] = 'Ikusi ikasketa-plan guztiak';
$string['competency:planviewdraft'] = 'Ikusi norberaren ikasketa-planen zirriborroak';
$string['competency:planviewown'] = 'Ikusi norberaren ikasketa-planak';
$string['competency:planviewowndraft'] = 'Ikusi norberaren ikasketa-planen zirriborroak';
$string['competency:templatemanage'] = 'Kudeatu ikasketa-planerako txantiloiak';
$string['competency:templateview'] = 'Ikusi ikasketa-planerako txantiloiak';
$string['competency:usercompetencycomment'] = 'Egin iruzkina erabiltzailearen konpetentzian';
$string['competency:usercompetencycommentown'] = 'Egin iruzkina nork bere erabiltzailearen konpetentzian';
$string['competency:usercompetencyrequestreview'] = 'Eskatu erabiltzaile baten konpetentzien berrikusketa';
$string['competency:usercompetencyrequestreviewown'] = 'Eskatu norbere konpetentzien berrikusketa';
$string['competency:usercompetencyreview'] = 'Berrikusi erabiltzailearen konpetentzia';
$string['competency:usercompetencyview'] = 'Ikusi erabiltzailearen konpetentzia';
$string['competency:userevidencemanage'] = 'Kudeatu aurretik ikasitakoaren ebidentziak';
$string['competency:userevidencemanageown'] = 'Kudeatu norberak aurretik ikasitakoaren ebidentziak';
$string['competency:userevidenceview'] = 'Ikusi erabiltzaile batek aurretik ikasitakoaren ebidentziak';
$string['confirmaddadmins'] = 'Ziur zaude hurrengo erabiltzaileak guneko kudeatzaileen zerrendara gehitu nahi dituzula?';
$string['confirmremoveadmins'] = 'Ziur zaude hurrengo erabiltzaileak guneko kudeatzaileen zerrendatik kendu nahi dituzula?';
$string['confirmroleprevent'] = 'Ziur zaude <strong>"{$a->role}"</strong> {$a->context} testuinguruan {$a->cap} gaitasuna baimenduta duten rolen zerrendatik kendu nahi duzula?';
$string['confirmroleunprohibit'] = 'Ziur zaude <strong>"{$a->role}"</strong> {$a->context} testuinguruan {$a->cap} gaitasuna debekatuta duten rolen zerrendatik kendu nahi duzula?';
$string['confirmunassign'] = 'Ziur zaude erabiltzaile honi rol hau kendu nahi diozula?';
$string['confirmunassignno'] = 'Utzi';
$string['confirmunassigntitle'] = 'Baieztatu rol-aldaketa';
$string['confirmunassignyes'] = 'Kendu';
$string['contentbank:access'] = 'Sarbidea eduki-bankura';
$string['contentbank:changelockedcustomfields'] = 'Aldatu blokeatutako eduki-bankuko eremu pertsonalizatuak';
$string['contentbank:configurecustomfields'] = 'Konfiguratu eduki-bankuko eremu pertsonalizatuak';
$string['contentbank:copyanycontent'] = 'Kopiatu edozein eduki eduki-bankuan';
$string['contentbank:copycontent'] = 'Kopiatu edukia eduki-bankuan';
$string['contentbank:deleteanycontent'] = 'Ezabatu eduki-bankuko eduki guztiak';
$string['contentbank:deleteowncontent'] = 'Ezabatu eduki-bankuko edukiak';
$string['contentbank:downloadcontent'] = 'Jaitsi edukia eduki-bankutik';
$string['contentbank:manageanycontent'] = 'Kudeatu eduki-bankuko edozein eduki';
$string['contentbank:manageowncontent'] = 'Kudeatu norbere eduki-bankuko edozein eduki';
$string['contentbank:upload'] = 'Igo eduki berria eduki-bankura';
$string['contentbank:useeditor'] = 'Sortu edo editatu edukia eduki-mota editore bat erabiliz';
$string['contentbank:viewunlistedcontent'] = 'Ikusi eduki-bankuko zerrendatik kanpoko edukiak';
$string['context'] = 'Testuingurua';
$string['contextrolenotallowed'] = '{$a} rola ez dago baimenduta testuinguru honetan.';
$string['course:activityvisibility'] = 'Ezkutatu/erakutsi jarduerak';
$string['course:bulkmessaging'] = 'Bidali mezu bat jende askori';
$string['course:changecategory'] = 'Aldatu ikastaro-kategoria';
$string['course:changefullname'] = 'Aldatu ikastaroaren izen osoa';
$string['course:changeidnumber'] = 'Aldatu ikastaroaren ID zenbakia';
$string['course:changelockedcustomfields'] = 'Aldatu blokeatutako ikastaroko eremu pertsonalizatuak';
$string['course:changeshortname'] = 'Aldatu ikastaroaren izen laburra';
$string['course:changesummary'] = 'Aldatu ikastaroaren laburpena';
$string['course:configurecoursecommunication'] = 'Konfiguratu ikastaroko komunikazio-ezarpenak';
$string['course:configurecustomfields'] = 'Konfiguratu ikastaroko eremu pertsonalizatuak';
$string['course:configuredownloadcontent'] = 'Konfiguratu ikastaroko edukiaren deskarga';
$string['course:create'] = 'Sortu ikastaroak';
$string['course:creategroupconversations'] = 'Sortu taldeko elkarrizkeak';
$string['course:delete'] = 'Ezabatu ikastaroak';
$string['course:downloadcoursecontent'] = 'Jaitsi ikastaroko edukia';
$string['course:editcoursewelcomemessage'] = 'Editatu ikastaroko ongi-etorri mezua';
$string['course:enrolconfig'] = 'Konfiguratu ikastaroetako matrikulazio-instantziak';
$string['course:enrolreview'] = 'Berrikusi ikastaroko matrikulazioak';
$string['course:ignoreavailabilityrestrictions'] = 'Ezikusi egin eskuragarritasun-murrizketei';
$string['course:ignorefilesizelimits'] = 'Erabili edozein fitxategi tamainaren murrizketak baino fitxategi handiagoak';
$string['course:isincompletionreports'] = 'Osaketa txostenetan erakutsia izan';
$string['course:manageactivities'] = 'Kudeatu jarduerak';
$string['course:managefiles'] = 'Kudeatu fitxategiak';
$string['course:managegrades'] = 'Kudeatu kalifikazioak';
$string['course:managegroups'] = 'Kudeatu taldeak';
$string['course:managescales'] = 'Kudeatu eskalak';
$string['course:markcomplete'] = 'Markatu erabiltzaileak osatu gisa ikastaroaren osaketan';
$string['course:movesections'] = 'Mugitu atalak';
$string['course:overridecompletion'] = 'Baliogabetu jardueraren osaketa-egoera';
$string['course:recommendactivity'] = 'Gomendatu jarduerak jarduera-hautatzailean';
$string['course:renameroles'] = 'Aldatu izena rolei';
$string['course:request'] = 'Eskatu ikastaro berriak';
$string['course:reset'] = 'Berrabiarazi ikastaroa';
$string['course:reviewotherusers'] = 'Berrikusi beste erabiltzaile batzuk';
$string['course:sectionvisibility'] = 'Atalaren ikusgarritasuna kontrolatu';
$string['course:setcurrentsection'] = 'Zehaztu oraingo atala';
$string['course:setforcedlanguage'] = 'Behartu ikastaroko edo jarduerako hizkuntza';
$string['course:tag'] = 'Aldatu ikastaroaren etiketak';
$string['course:togglecompletion'] = 'Eskuz markatu jarduerak osatutzat';
$string['course:update'] = 'Eguneratu ikastaroaren ezaugarriak';
$string['course:useremail'] = 'Gaitu/desgaitu helbide elektronikoa';
$string['course:view'] = 'Ikusi partaidetzarik ez duten ikastaroak';
$string['course:viewcoursegrades'] = 'Ikusi ikastaroaren kalifikazioak';
$string['course:viewhiddenactivities'] = 'Ikusi ezkutuko jarduerak';
$string['course:viewhiddencourses'] = 'Ikusi ezkutuko ikastaroak';
$string['course:viewhiddengroups'] = 'Ikusi talde ezkutuak';
$string['course:viewhiddensections'] = 'Ikusi ezkutuko atalak';
$string['course:viewhiddenuserfields'] = 'Ikusi ezkutuko erabiltzaile-eremuak';
$string['course:viewoverview'] = 'Ikusi jardueren aurrebista';
$string['course:viewparticipants'] = 'Ikusi partaideak';
$string['course:viewscales'] = 'Ikusi eskalak';
$string['course:viewsuspendedusers'] = 'Ikusi kontua etenda duten erabiltzaileak';
$string['course:visibility'] = 'Ezkutatu/erakutsi ikastaroak';
$string['createrolebycopying'] = 'Sortu rol berria {$a} kopiatuta';
$string['createthisrole'] = 'Sortu rol hau';
$string['currentcontext'] = 'Oraingo testuingurua';
$string['currentrole'] = 'Oraingo rola';
$string['customfield:configureshared'] = 'Konfiguratu partekatutako eremu pertsonalizatuak';
$string['customroledescription'] = 'Pertsonalizatu deskribapena';
$string['customroledescription_help'] = 'Rol estandarren deskribapenak automatikoki itzultzen dira deskribapen pertsonalizatua hutsik badago.';
$string['customrolename'] = 'Pertsonalizatu izen osoa';
$string['customrolename_help'] = 'Rol estandarren izenak automatikoki itzultzen dira izen pertsonalizatua hutsik badago.';
$string['defaultrole'] = 'Lehenetsitako rola';
$string['defaultx'] = 'Lehenetsitakoa: {$a}';
$string['defineroles'] = 'Zehaztu rolak';
$string['definitionofrolex'] = '\'{$a}\' rolaren definizioa';
$string['deletecourseoverrides'] = 'Ikastaroko baliogabetze guztiak';
$string['deletelocalroles'] = 'Rol-esleipen lokal guztiak';
$string['deleterolesure'] = '<p>Ziur zaude {"{$a->name}} ({$a->shortname})" rola ezabatu nahi duzula?</p><p> Une honetan {$a->count} erabiltzailek dute rol hori.</p>';
$string['deletexrole'] = 'Ezabatu {$a} rola';
$string['duplicaterole'] = 'Bikoiztu rola';
$string['duplicaterolesure'] = '<p>Ziur zaude "{$a->name} ({$a->shortname})" rola bikoiztu nahi duzula?</p>';
$string['editingrolex'] = '\'{$a}\' rola editatzen';
$string['editrole'] = 'Editatu rola';
$string['editxrole'] = 'Editatu {$a} rola';
$string['errorbadrolename'] = 'Rol-izen ezegokia';
$string['errorbadroleshortname'] = 'Rol-izen labur ezegokia';
$string['errorexistsrolename'] = 'Rol-izen hori dagoeneko badago';
$string['errorexistsroleshortname'] = 'Rol-izen hori dagoeneko badago';
$string['errorroleshortnametoolong'] = 'Izen laburrak ezin du 100 karaktere baino gehiago izan';
$string['eventcapabilityassigned'] = 'Gaitasuna esleitu da';
$string['eventcapabilityunassigned'] = 'Gaitasuna kendu da';
$string['eventroleallowassignupdated'] = 'Baimendu rol-esleipena';
$string['eventroleallowoverrideupdated'] = 'Baimendu rolak baliogabetzea';
$string['eventroleallowswitchupdated'] = 'Baimendu rol-aldaketa';
$string['eventroleallowviewupdated'] = 'Baimendu rola ikustea';
$string['eventroleassigned'] = 'Rola esleitu da';
$string['eventrolecapabilitiesupdated'] = 'Rolaren gaitasunak eguneratu dira';
$string['eventrolecreated'] = 'Rola sortuta';
$string['eventroledeleted'] = 'Rola ezabatu da';
$string['eventroleunassigned'] = 'Rola esleitu gabe geratu da';
$string['eventroleupdated'] = 'Rola eguneratu da';
$string['existingadmins'] = 'Oraingo guneko kudeatzaileak';
$string['existingusers'] = '{$a} erabiltzaile daude';
$string['explanation'] = 'Azalpena';
$string['export'] = 'Esportatu';
$string['extusers'] = 'Dagoeneko dauden erabiltzaileak';
$string['extusersmatching'] = '\'{$a}\'(r)ekin bat datozen erabiltzaileak';
$string['filter:manage'] = 'Kudeatu iragazki lokalen ezarpenak';
$string['frontpageuser'] = 'Autentifikatutako erabiltzailea hasiera-orrian';
$string['frontpageuserdescription'] = 'Hasiera-orriko ikastaroan saioa hasitako erabiltzaile guztiak';
$string['globalrole'] = 'Sistemako rola';
$string['globalroleswarning'] = 'Oharra: Orri honetatik esleitzen dituzun rol guztiak aukeratutako erabiltzaile guztiei sistema mailan emango zaizkie, ikastaro guztietan eta hasiera-orrian barne.';
$string['gotoassignroles'] = 'Joan rolak esleitzera testuinguru honetan: {$a->contextlevel}';
$string['gotoassignsystemroles'] = 'Joan sistemako rolak esleitzera';
$string['grade:edit'] = 'Editatu kalifikazioak';
$string['grade:export'] = 'Esportatu kalifikazioak';
$string['grade:hide'] = 'Ezkutatu/erakutsi elementuen kalifikazioak';
$string['grade:import'] = 'Inportatu kalifikazioak';
$string['grade:lock'] = 'Blokeatu kalifikazioak edo elementuak';
$string['grade:manage'] = 'Kudeatu kalifikazio-elementuak';
$string['grade:managegradingforms'] = 'Kudeatu kalifikazio-metodo aurreratuak';
$string['grade:manageletters'] = 'Kudeatu letra duten kalifikazioak';
$string['grade:manageoutcomes'] = 'Kudeatu ikaste-emaitzen kalifikazioak';
$string['grade:managesharedforms'] = 'Kudeatu kalifikazio aurreraturako formulario-txantiloiak';
$string['grade:override'] = 'Baliogabetu kalifikazioak';
$string['grade:sharegradingforms'] = 'Partekatu txantiloi gisa kalifikazio aurreraturako formularioa';
$string['grade:unlock'] = 'Kalifikazioak edo elementuak desblokeatu';
$string['grade:view'] = 'Ikusi norberaren kalifikazioak';
$string['grade:viewall'] = 'Ikusi beste erabiltzaile batzuen kalifikazioak';
$string['grade:viewhidden'] = 'Ikusi ezkutuko kalifikazioak';
$string['group:configurecustomfields'] = 'Konfiguratu talde/talde-multzoaren eremu pertsonalizatuak';
$string['h5p:deploy'] = 'Zabaldu H5P edukia';
$string['h5p:setdisplayoptions'] = 'Zehaztu H5P erakusteko aukerak';
$string['h5p:updatelibraries'] = 'Kudeatu H5P eduki-motak';
$string['highlightedcellsshowdefault'] = 'Beheko taulan nabarmendutako baimenak goian aukeratutako rol arketipoaren lehenetsitako balioak dira.';
$string['highlightedcellsshowinherit'] = 'Beheko taulan nabarmendutako gelaxkek heredatuko diren gaitasunak erakusten dituzte (egotekotan). Aldatu nahi dituzun gaitasunak kenduta, beste guztia Heredatu gisa utzi beharko zenuke.';
$string['inactiveformorethan'] = 'ez-aktibo {$a->timeperiod} baino gehiagoz';
$string['ingroup'] = 'talde honetan: "{$a->group}"';
$string['inherit'] = 'Heredatutakoa';
$string['invalidpresetfile'] = 'Rol-definiziozko fitxategi baliogabea';
$string['legacy:admin'] = 'HEREDATUTAKO ROLA: Kudeatzailea';
$string['legacy:coursecreator'] = 'HEREDATUTAKO ROLA: Ikastaro-sortzailea';
$string['legacy:editingteacher'] = 'HEREDATUTAKO ROLA: Irakaslea (edizio baimenduna)';
$string['legacy:guest'] = 'HEREDATUTAKO ROLA: Gonbidatua';
$string['legacy:student'] = 'HEREDATUTAKO ROLA: Ikaslea';
$string['legacy:teacher'] = 'HEREDATUTAKO ROLA: Irakaslea (editatzeko baimenik gabea)';
$string['legacy:user'] = 'HEREDATUTAKO ROLA: Autentifikatutako erabiltzailea';
$string['legacytype'] = 'Heredatutako rol mota';
$string['listallroles'] = 'Zerrendatu rol guztiak';
$string['localroles'] = 'Jarduera honi esleitutako rolak';
$string['mainadmin'] = 'Kudeatzaile nagusia';
$string['mainadminset'] = 'Ezarri kudeatzaile nagusia';
$string['manageadmins'] = 'Kudeatu guneko kudeatzaileak';
$string['manager'] = 'Kudeatzailea';
$string['managerdescription'] = 'Kudeatzaileak ikastaroetan sartu daitezke eta edukiak aldatu ditzakete, baina normalean ez du ikastaroetan parte hartzen.';
$string['manageroles'] = 'Kudeatu rolak';
$string['maybeassignedin'] = 'Rol hau eslei daitekeen testuinguru motak';
$string['moodlenet:shareactivity'] = 'Partekatu jarduerak MoodleNet-era';
$string['moodlenet:sharecourse'] = 'Partekatu ikastaroa MoodleNet-en';
$string['morethan'] = '{$a} baino gehiago';
$string['multipleroles'] = 'Hainbat rol';
$string['my:configsyspages'] = 'Konfiguratu Aginte-panelerako sistemaren txantiloiak';
$string['my:manageblocks'] = 'Kudeatu Aginte-panelaren blokeak';
$string['neededroles'] = 'Baimena duten rolak';
$string['nocapabilitiesincontext'] = 'Ez duzu horretarako gaitasunik testuinguru honetan';
$string['noneinthisx'] = 'Bat ere ez {$a} honetan';
$string['noneinthisxmatching'] = 'Ez dago \'{$a->search}\' erabiltzailerik {$a->contexttype} honetan';
$string['norole'] = 'Rolik ez';
$string['noroleassignments'] = 'Erabiltzaile honek ez du inongo rolik esleituta gune honetan.';
$string['noroles'] = 'Rolik ez';
$string['notabletoassignroleshere'] = 'Kudeatzaileak ez du testuinguru honetan rolak esleitzea gaitu.';
$string['notabletooverrideroleshere'] = 'Ez duzu baimenik hemen inongo rolen baimenak baliogabetzeko';
$string['notes:manage'] = 'Kudeatu oharrak';
$string['notes:view'] = 'Ikusi oharrak';
$string['notset'] = 'Ezarri gabea';
$string['novisibleroles'] = 'Rolik ez';
$string['overrideanotherrole'] = 'Baliogabetu beste rol bat';
$string['overridecontext'] = 'Baliogabetu testuingurua';
$string['overridepermissions'] = 'Baliogabetu baimenak';
$string['overridepermissions_help'] = 'Baimenen baliogabetzeak aukeratutako gaitasunak testuinguru zehatzetan baimendu edo ukatzen dituzte.';
$string['overridepermissions_link'] = 'admin/roles/override';
$string['overridepermissionsforrole'] = 'Baliogabetu baimenak \'{$a->role}\' rolarentzat {$a->context} testuinguruan';
$string['overridepermissionsin'] = 'Baliogabetu baimenak hemen: {$a}';
$string['overrideroles'] = 'Baliogabetu rolak';
$string['overriderolesin'] = 'Baliogabetu rolak hemen: {$a}';
$string['overrides'] = 'Baliogabetzeak';
$string['overridesbycontext'] = 'Baliogabetzeak (testuinguruaren arabera)';
$string['payment:manageaccounts'] = 'Kudeatu kontuak';
$string['payment:viewpayments'] = 'Ikusi ordainketak';
$string['permission'] = 'Baimena';
$string['permission_help'] = 'Baimenak gaitasun jakinetarako ezarpenak dira. 4 aukera daude:

* Ezarri gabea
* Baimendu - gaitasun horretarako baimena dago
* Ukatu - gaitasun honetarako baimena kendu da, baita goragoko testuinguru batean baimenduta badago ere
* Debekatu - baimena erabat ukatuta dago eta ezin da baliogabetu eta, beraz, baimendu beheragoko (zehatzagoko) inongo testuingurutan';
$string['permissions'] = 'Baimenak';
$string['permissionsforuser'] = 'Baimenak  {$a} erabiltzailearentzat';
$string['permissionsincontext'] = 'Baimenak hemen: {$a}';
$string['portfolio:export'] = 'Esportatu portfolioetara';
$string['potentialusers'] = '{$a} balizko erabiltzaile';
$string['potusers'] = 'Erabiltzaile potentzialak';
$string['potusersmatching'] = '{$a}\'(r)ekin bat datozen erabiltzaile potentzialak';
$string['prevent'] = 'Ukatu';
$string['privacy:metadata:preference:showadvanced'] = 'Kudeatu modu aurreratuko botoiaren erakustea/ezkutatzea.';
$string['privacy:metadata:role_assignments'] = 'Rol-esleipenak';
$string['privacy:metadata:role_assignments:component'] = 'Rol-esleipenen ardura duen plugina, hutsik eskuz esleitzen direnean.';
$string['privacy:metadata:role_assignments:itemid'] = 'Rol-esleipen honetaz arduratzen den matrikulazio/autentifikazio instantziaren IDa';
$string['privacy:metadata:role_assignments:modifierid'] = 'Rol-esleipen hau sortu edo aldatu zuen erabiltzailearen IDa';
$string['privacy:metadata:role_assignments:roleid'] = 'Rolaren IDa';
$string['privacy:metadata:role_assignments:tableexplanation'] = 'Taula honek testuinguru bakoitzean esleitutako rolak gordetzen du.';
$string['privacy:metadata:role_assignments:timemodified'] = 'Rol-esleipen hau sortu edo aldatu zeneko data.';
$string['privacy:metadata:role_assignments:userid'] = 'Erabiltzailearen IDa';
$string['privacy:metadata:role_capabilities'] = 'Rolaren gaitasunak';
$string['privacy:metadata:role_capabilities:capability'] = 'Gaitasunaren izena.';
$string['privacy:metadata:role_capabilities:modifierid'] = 'Gaitasuna sortu edo aldatu zuen erabiltzailearen IDa';
$string['privacy:metadata:role_capabilities:permission'] = 'Gaitasun batentzako baimena: heredatu, baimendu, ukatu edo debekatu.';
$string['privacy:metadata:role_capabilities:roleid'] = 'Rolaren IDa';
$string['privacy:metadata:role_capabilities:tableexplanation'] = 'Rol zehatz batek testuinguru zehatz batean dituen gaitasunak eta gaitasun-baliogabetzeak';
$string['privacy:metadata:role_capabilities:timemodified'] = 'Gaitasuna sortu edo aldatu zeneko data.';
$string['privacy:metadata:role_cohortroles'] = 'Kohortearen rolak';
$string['prohibit'] = 'Debekatu';
$string['prohibitedroles'] = 'Debekatuta';
$string['question:add'] = 'Gehitu beste galdera bat';
$string['question:commentall'] = 'Egin iruzkina galdera guztiei';
$string['question:commentmine'] = 'Egin iruzkina zure galderei';
$string['question:config'] = 'Konfiguratu galdera-motak';
$string['question:editall'] = 'Editatu galdera guztiak';
$string['question:editmine'] = 'Editatu norberaren galderak';
$string['question:flag'] = 'Markatu galderak saiatu bitartean';
$string['question:managecategory'] = 'Editatu galdera-kategoriak';
$string['question:moveall'] = 'Mugitu galdera guztiak';
$string['question:movemine'] = 'Mugitu zure galderak';
$string['question:tagall'] = 'Etiketatu galdera guztiak';
$string['question:tagmine'] = 'Etiketau zeure galderak';
$string['question:useall'] = 'Erabili galdera guztiak';
$string['question:usemine'] = 'Erabili zure galderak';
$string['question:viewall'] = 'Ikusi galdera guztiak';
$string['question:viewmine'] = 'Ikusi norberaren galderak';
$string['rating:rate'] = 'Gehitu puntuazioak elementuei';
$string['rating:view'] = 'Ikusi denera jasotako kalifikazioak';
$string['rating:viewall'] = 'Ikusi erabiltzaileek emandako kalifikazio guztiak';
$string['rating:viewany'] = 'Ikusi besteren batek denera jasotako kalifikazioak';
$string['reportbuilder:configurecustomfields'] = 'Konfiguratu txosten-eremu pertsonalizatuak';
$string['reportbuilder:edit'] = 'Editatu zure txosten pertsonalizatuak';
$string['reportbuilder:editall'] = 'Editatu txosten pertsonalizatu guztiak';
$string['reportbuilder:scheduleviewas'] = 'Programatu txostenak beste erabiltzaile gisa ikusteko';
$string['reportbuilder:view'] = 'Ikusi txosten pertsonalizatuak';
$string['reportbuilder:viewall'] = 'Ikusi txosten pertsonalizatu guztiak';
$string['resetrole'] = 'Berrabiarazi';
$string['resettingrole'] = '\'{$a}\' rola berrabiarazten';
$string['restore:configure'] = 'Konfiguratu berreskuratzeko aukerak';
$string['restore:createuser'] = 'Sortu erabiltzaileak berreskuratzean';
$string['restore:restoreactivity'] = 'Berreskuratu jarduerak';
$string['restore:restorecourse'] = 'Berreskuratu ikastaroak';
$string['restore:restoresection'] = 'Berreskuratu atalak';
$string['restore:restoretargetimport'] = 'Berreskuratu inportatzeko aukeratutako fitxategietatik';
$string['restore:rolldates'] = 'Baimenduta dago berreskuratzean jardueren ezarpenetako datak aldatzea';
$string['restore:uploadfile'] = 'Igo fitxategiak segurtasun-kopien eremura';
$string['restore:userinfo'] = 'Berreskuratu erabiltzailearen datuak';
$string['restore:viewautomatedfilearea'] = 'Berreskuratu ikastaroak segurtasun-kopia automatizatuetatik';
$string['risks'] = 'Arriskuak';
$string['role:assign'] = 'Esleitu rolak erabiltzaileei';
$string['role:manage'] = 'Sortu eta kudeatu rolak';
$string['role:override'] = 'Besteentzako baimenak baliogabetu';
$string['role:review'] = 'Berrikusi besteentzako baimenak';
$string['role:safeoverride'] = 'Besteentzako baimen seguruak baliogabetu';
$string['role:switchroles'] = 'Hartu beste rol bat';
$string['roleallowheader'] = 'Baimendu rola:';
$string['roleallowinfo'] = 'Aukeratu "{$a->context}" testuinguruan, "{$a->cap}" gaitasuna, baimendutako rolen zerrendan gehitzeko rol bat:';
$string['roleassignment'] = 'Rol-esleipena';
$string['roleassignments'] = 'Rol ezarpenak';
$string['roledefinitions'] = 'Rolaren definizioak';
$string['rolefullname'] = 'Izena';
$string['roleincontext'] = '{$a->role} hemen: {$a->context}';
$string['roleoriginalname'] = 'Jatorrizko izena';
$string['roleprohibitheader'] = 'Debekatu rola';
$string['roleprohibitinfo'] = 'Aukeratu rol bat debekatutako rol-zerrendara gehitzeko "{$a->context}" testuinguruan,  "{$a->cap}" gaitasunean:';
$string['rolerepreset'] = 'Erabili rolen aurretiko ezarpena';
$string['roleresetdefaults'] = 'Lehenetsitakoak';
$string['roleresetrole'] = 'Erabili rola edo arketipoa';
$string['rolerisks'] = 'Rolaren arriskuak';
$string['roles'] = 'Rolak';
$string['roles_help'] = 'Rola testuinguru jakinetan erabiltzaileei eslei dakiekeen sistemak definitutako baimen-multzoa da';
$string['roles_link'] = 'rolak';
$string['roleselect'] = 'Aukeratu rola';
$string['rolesforuser'] = '{$a} erabiltzailearen rolak';
$string['roleshortname'] = 'Izen laburra';
$string['roleshortname_help'] = 'Rolaren izen laburra maila baxuko rol-identifikatzailea da eta bertan ASCII karaktere alfanumerikoak baino ez dira onartzen.';
$string['roletoassign'] = 'Ezarri beharreko rola';
$string['roletooverride'] = 'Baliogabetu beharreko rola';
$string['safeoverridenotice'] = 'Oharra: Arrisku gehien dituzten gaitasunak blokeatuta daude zeuk baino ezin baitituzu gaitasun seguruak baliogabetu';
$string['search:query'] = 'Egin gune mailako bilaketak';
$string['selectanotheruser'] = 'Aukeratu beste erabilztaile bat';
$string['selectauser'] = 'Aukeratu erabiltzaile bat';
$string['selectrole'] = 'Aukeratu rol bat';
$string['showallroles'] = 'Erakutsi rol guztiak';
$string['showthisuserspermissions'] = 'Erakutsi erabiltzaile honen baimenak';
$string['site:accessallgroups'] = 'Talde guztietarako sarbidea';
$string['site:approvecourse'] = 'Ikastaroak sortzeko baimena eman';
$string['site:backup'] = 'Egin ikastaroen segurtasun-kopiak';
$string['site:config'] = 'Aldatu gunearen konfigurazioa';
$string['site:configview'] = 'Ikusi gunearen kudeaketa-zuhaitza (baina ez bertan dauden orri guztiak)';
$string['site:deleteanymessage'] = 'Ezabatu guneko edozein mezu';
$string['site:deleteownmessage'] = 'Ezabatu beste erabiltzaileek eta beste erabiltzaileei bidalitako mezuak';
$string['site:doanything'] = 'Edozertarako baimena';
$string['site:doclinks'] = 'Erakutsi gunetik kanpoko dokumentuetarako estekak';
$string['site:forcelanguage'] = 'Baliogabetu ikastaroko hizkuntza';
$string['site:import'] = 'Inportatu ikastarora beste ikastaro batzuk';
$string['site:maintenanceaccess'] = 'Sartu gunean mantenu-moduan dagoen bitartean';
$string['site:manageallmessaging'] = 'Gehitu, kendu, blokeatu eta desblokeatu edozein erabiltzaileren kontaktuak';
$string['site:manageblocks'] = 'Kudeatu blokeak orri batean';
$string['site:managecontextlocks'] = 'Kudeatu testuinguruen izoztea';
$string['site:messageanyuser'] = 'Saihestu mezuak bidaltzeko erabiltzailearen lehenespenak';
$string['site:mnetloginfromremote'] = 'Sartu urrutiko Moodle batetik';
$string['site:mnetlogintoremote'] = 'Joan urrutiko aplikazio batera MNet bitartez';
$string['site:readallmessages'] = 'Gune osoko mezuak irakurri';
$string['site:restore'] = 'Berreskuratu ikastaroak';
$string['site:senderrormessage'] = 'Bidali mezu bat laguntzarako erabiltzaileari errore-orritik';
$string['site:sendmessage'] = 'Bidali mezuak edozein erabiltzaileri';
$string['site:trustcontent'] = 'Bidalitako edukietan konfiantza izan';
$string['site:uploadusers'] = 'Igo erabiltzaile berriak fitxategi batetik';
$string['site:viewanonymousevents'] = 'Ikusi ekitaldi anonimoak txosenetan';
$string['site:viewfullnames'] = 'Erabiltzaileen izen osoak ikusi beti';
$string['site:viewparticipants'] = 'Ikusi partaideak';
$string['site:viewreports'] = 'Ikusi txostenak';
$string['site:viewuseridentity'] = 'Ikusi erabiltzailearen nortasun osoa zerrendetan';
$string['siteadministrators'] = 'Guneko kudeatzaileak';
$string['siteadministratorsconfigphp'] = 'Guneko kudeatzaileen zerrenda ezin da aldatu config.php fitxategian definituta dagoelako.';
$string['tag:edit'] = 'Editatu dauden etiketak';
$string['tag:editblocks'] = 'Editatu blokeak etiketa-orrietan';
$string['tag:flag'] = 'Markatu etiketak ezegoki gisa';
$string['tag:manage'] = 'Kudeatu etiketa guztiak';
$string['thisnewrole'] = 'Rol berri hau';
$string['thisusersroles'] = 'Erabiltzaile honen rol-esleipenak';
$string['unassignarole'] = 'Kendu {$a} rola';
$string['unassignconfirm'] = 'Ziur zaude "{$a->user}" erabiltzaileari "{$a->role}" rola kendu nahi diozula?';
$string['unassignerror'] = 'Errorea {$a->user} erabiltzaileari {$a->role} rola kentzean';
$string['user:changeownpassword'] = 'Aldatu norberaren pasahitza';
$string['user:create'] = 'Sortu erabiltzaileak';
$string['user:delete'] = 'Ezabatu erabiltzaileak';
$string['user:editmessageprofile'] = 'Editatu erabiltzailearen mezularitza-profila';
$string['user:editownmessageprofile'] = 'Editatu norberaren mezularitzarako erabiltzaile-profila';
$string['user:editownprofile'] = 'Editatu norberaren profila';
$string['user:editprofile'] = 'Editatu erabiltzaile-profila';
$string['user:ignoreuserquota'] = 'Ez hartu kontuan erabiltzailearen kuota-muga';
$string['user:loginas'] = 'Beste erabiltzaile bat bezala sartu';
$string['user:manageblocks'] = 'Kudeatu blokeak beste erabiltzaile batzuen erabiltzaile-profilean';
$string['user:manageownblocks'] = 'Kudeatu blokeak norberaren erabiltzaile-profil publikoan';
$string['user:manageownfiles'] = 'Kudeatu fitxategi pribatuan eremuan fitxategiak';
$string['user:managesyspages'] = 'Konfiguratu erabiltzaile-profil publikoetarako lehenetsitako orri-diseinua';
$string['user:readuserblogs'] = 'Ikusi erabiltzaileen blog guztiak';
$string['user:readuserposts'] = 'Ikusi erabiltzaileen foro-mezu guztiak';
$string['user:update'] = 'Eguneratu erabiltzaileen profilak';
$string['user:viewalldetails'] = 'Ikusi erabiltzaileen informazio osoa';
$string['user:viewdetails'] = 'Ikusi erabiltzailearen profila';
$string['user:viewhiddendetails'] = 'Ikusi erabiltzaileen ezkutuko xehetasunak';
$string['user:viewlastip'] = 'Ikusi erabiltzailearen azken IP helbidea';
$string['user:viewprofilepictures'] = 'Ikusi erabiltzaile-irudiak (sarbide behartua gaituta badago)';
$string['user:viewuseractivitiesreport'] = 'Ikusi erabiltzaileen jarduera-txostenak';
$string['user:viewusergrades'] = 'Ikusi erabiltzaileen kalifikazioak';
$string['usersfrom'] = 'Erabiltzaileak hemendik: {$a}';
$string['usersfrommatching'] = '{$a->search}\'(r)ekin bat datozen {$a->contextname}(e)ko erabiltzaileak';
$string['usersinthisx'] = 'Erabiltzaileak {$a} honetan';
$string['usersinthisxmatching'] = '{$a->contexttype} honetan {$a->search}\'(r)ekin bat datozen erabiltzaileak';
$string['userswithrole'] = 'Rol hau duten erabiltzaile guztiak';
$string['userswiththisrole'] = 'Rol hau duten erabiltzaileak';
$string['useshowadvancedtochange'] = 'Erabili \'Erakutsi aurreratuak\' aldatzeko';
$string['viewingdefinitionofrolex'] = '\'{$a}\' rolaren definizioa ikusten';
$string['viewrole'] = 'Ikusi rolaren xehetasunak';
$string['webservice:createmobiletoken'] = 'Sortu mobile sarbiderako web-zerbitzu tokena';
$string['webservice:createtoken'] = 'Sortu web-zerbitzurako tokena';
$string['webservice:managealltokens'] = 'Kudeatu erabiltzaile guztien web-zerbitzu tokenak';
$string['whydoesuserhavecap'] = 'Zergatik du {$a->fullname}(e)k {$a->capability} gaitasuna {$a->context} testuinguruan?';
$string['whydoesusernothavecap'] = 'Zergatik ez du {$a->fullname}(e)k {$a->capability} gaitasuna {$a->context} testuinguruan?';
$string['xroleassignments'] = '{$a}(r)en rol-esleipenak';
$string['xuserswiththerole'] = '"{$a->role}" rola duten erabiltzaileak';
