<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'reader', language 'es_mx', version '5.1'.
 *
 * @package     reader
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Acción';
$string['actionblockquizzestext'] = 'Usted estará impedido para tomar más exámenes hasta que el profesor quite este bloqueo';
$string['actiondelayquizzestext'] = 'Usted será retrasado para tomar más exámenes hasta que haya pasado el tiempo de espera.';
$string['actionemailstudenttext'] = 'Se le enviará un Email a Usted.';
$string['actionemailteachertext'] = 'Se le enviará un Email al profesor(es) del curso.';
$string['activemessages'] = 'Mensajes activos';
$string['activityoverview'] = 'Haga clic aquí para ver información acerca de su actividad extensiva de lectura';
$string['add'] = 'Añadir';
$string['add_phpdoc'] = 'Añadir comentarios a documentos PHP';
$string['add_phpdoc_desc'] = 'Añadir comentarios PHP doc a archivos php, js y css.';
$string['addbookinstance'] = '<Añadir más libros a este curso';
$string['addmoregoals'] = 'Añadir {no} más metas';
$string['addmorerates'] = 'Añadir {no} valoraciones más';
$string['addonemorerate'] = 'Añadir {no} valoración más';
$string['addquiztoreader'] = 'Añadir exámenes de curso a los exámenes del lector';
$string['adjoiningcomputers'] = 'En computadoras vecinas';
$string['adjustscores'] = 'Ajustar puntajes';
$string['adminarea'] = 'Área administrativa';
$string['all'] = 'Todos';
$string['allbooks'] = 'Descargar/arreglar cubiertas para TODOS los libros disponibles al módulo Lector (Reader)';
$string['allcourses'] = 'Todos los cursos';
$string['alldone'] = 'Todo hecho';
$string['allgroups'] = 'Todos los Grupos';
$string['alllevels'] = 'Todos los niveles';
$string['allowpromotion'] = 'Permitir promocion';
$string['allparticipants'] = 'Todos los participantes';
$string['allterms'] = 'Todos los períodos';
$string['anytime'] = 'En cualquier momento';
$string['anywhere'] = 'En cualquier parte';
$string['arrange'] = 'Arreglar';
$string['assignpointsbookshavenoquizzes'] = 'Otorgar puntos para libros que no tengan exámenes';
$string['atlevel'] = 'en el Nivel';
$string['attemptedbooks'] = 'Descargar/arreglar solamente las cubiertas de libros que hayan sido INTENTADOS en este sitio';
$string['attempts'] = 'Intentos';
$string['attemptsallowedn'] = 'Intentos permitidos: {$a}';
$string['attemptscoremanagement'] = 'Gestión de intento y puntaje';
$string['attemptsupdated'] = '{$a} intentos fueron actualizados';
$string['atttemptsgroupedbybook'] = 'Intentos agrupados por libro';
$string['atttemptsgroupedbyuser'] = 'Intentos agrupados por usuario';
$string['available'] = 'Disponible';
$string['availablefrom'] = 'Disponible desde';
$string['availablefrom_help'] = 'Los estudiantes solamente pueden acceder a esta actividad hasta después de la fecha y hora aquí especificadas. Antes de esta fecha y hora, no estará disponible.';
$string['availableitems'] = 'Ítems disponibles';
$string['availablenolonger'] = 'Lo siento, esta actividad ya no está más disponible.Se cerró en {$a}.';
$string['availablenotyet'] = 'Lo siento, esta actividad todavía no está disponible. Se abrirá en {$a}.';
$string['availableuntil'] = 'Disponible hasta';
$string['availableuntil_help'] = 'Los estudiantes solamente pueden acceder hasta la fecha y hora especificada aquí. Después de esta fecha y hora, ya no estará disponible.';
$string['averageduration'] = 'Duración promedio';
$string['averageduration_help'] = 'La duración promedia de intentos de exámenes en Reader';
$string['averagefailed'] = 'Promedio reprobado';
$string['averagefailed_help'] = 'El número promedio de exámenes de Reader reprobados por estudiante';
$string['averagegrade'] = 'Calificación promedio';
$string['averagegrade_help'] = 'La calificación promedio lograda en exámenes de Reader';
$string['averagepassed'] = 'Promedio aprobatorio';
$string['averagepassed_help'] = 'El número promedio de exámenes de Reader pasados (aprobados) por estudiante';
$string['averagepoints'] = 'Puntos promedio';
$string['averagepointsallterms'] = 'Promedio de puntos (de todos los períodos)';
$string['averagepointsallterms_help'] = 'El número promedio de puntos ganados por cada estudiante en este grupo considerando todos los puntos que cualquiera de ellos ha ganado alguna vez en cualquier actividad de Reader en este sitio Moodle.';
$string['averagepointsthisterm'] = 'Promedio de puntos (de este período)';
$string['averagepointsthisterm_help'] = 'El número promedio de puntos ganados por cada estudiante en este grupo considerando solamente puntos ganados en esta actividad de Reader durante el período actual.';
$string['averagerating'] = 'Valoración (rating) promedio';
$string['averagetaken'] = 'Promedio tomado';
$string['averagetaken_help'] = 'El número promedio de exámenes de Reader tomados por estudiante';
$string['averagewords'] = 'Promedio de palabras';
$string['averagewordsallterms'] = 'Promedio de palabras (de todos los períodos)';
$string['averagewordsallterms_help'] = 'El número promedio de palabras ganados por cada estudiante en este grupo considerando todas las palabras que cualquiera de ellos ha ganado alguna vez en cualquier actividad de Reader en este sitio Moodle.';
$string['averagewordsthisterm'] = 'Promedio de palabras (de este período)';
$string['averagewordsthisterm_help'] = 'El número promedio de palabras ganados por cada estudiante en este grupo considerando solamente palabras ganadas en esta actividad de Reader durante el período actual.';
$string['awardbookpoints'] = 'Dar créditos por libros a estudiantes seleccionados';
$string['awardextrapoints'] = 'Otorgar créditos extra a alumnos seleccionados';
$string['awardpointsmanually'] = 'No hay examen para este libro. En su lugar, por favor pídale a su profesorque otorgue los puntos/palabras manualmente.';
$string['best'] = 'El mejor';
$string['blockquizattempts'] = 'Bloquear sguientes intentos de examen';
$string['book'] = 'Libro';
$string['bookadded'] = 'Libro añadido: {$a}';
$string['bookcovers'] = 'Mostrar portadas de libro';
$string['bookcovers_help'] = '**Si**
: Si mostrar las portadas de los libros en la página principal de esta actividad de Lector.

**No**
: NO mostrar las portadas de los libros en la página principal de esta actividad de Lector.';
$string['bookdifficulty'] = 'Dificultad del libro';
$string['bookeditdetails'] = 'Editar detalles del libro';
$string['bookhasnoquiz'] = 'Este libro no tiene examen';
$string['bookinstances'] = 'Usar subconjunto de exámenes';
$string['bookinstances_help'] = '**Si**
: Esta actividad de Lector usará un subconjunto de los exámenes disponibles en los exámenes de Lectura del curso. Adicionalmente, pueden especificarse valores personalizados para conteo de palabras y dificultad del libro. Tenga en cuenta que habilitar esta opción causará una carga extra mayor en su servidor web.

**No**
: Esta actividad de Lector usará yodos los exámenes en el curso de Lector, y solamente usará los datos estándares del libro de Lector para el conteo de palabras y nivel de lectura.';
$string['bookinstancesdisabled'] = 'Esta actividad de Lector (Reader) no está usando un sub-conjunto de exámenes, por lo que no requiere entradas en la tabla de book_instances';
$string['booklevelmanagement'] = 'Gestión del Libro y Nivel';
$string['booknotadded'] = 'Libro NO añadido: {$a}';
$string['booknotfound'] = 'Libro no encontrado {$a}';
$string['booknotupdated'] = 'Libro no actualizado {$a}';
$string['bookquiznumber'] = 'Número de examen de libro';
$string['bookrating'] = 'Valoración (rating) de libro';
$string['bookrating0'] = 'No me gustó nadita';
$string['bookrating1'] = 'Estuvo más o menos';
$string['bookrating2'] = 'Estuvo bueno';
$string['bookrating3'] = 'Estuvo muy bueno';
$string['bookratingslevel'] = 'Mostrar valuaciones (ratings) de libro por estudiantes para cada nivel de libro';
$string['books'] = 'Libros';
$string['booksaddbook'] = 'Añadir libro nuevo';
$string['booksallwith'] = 'cualquier libro que haya sido leído al menos una vez';
$string['booksavailable'] = '{$a}libro(s) disponible(s)';
$string['booksavailableall'] = 'todos los libros disponibles';
$string['booksavailablewith'] = 'libros disponibles que hayan sido leídos al menos una vez';
$string['booksavailablewithout'] = 'libros disponibles que todavía no hayan sido leídos';
$string['bookseditcourse'] = 'Editar ibros (Curso)';
$string['bookseditcourse_help'] = 'En esta página, Usted puede espeecificar cuales libros de Reader van a hacerse disponibles en este curso. Adicionalmente Usted especifica el nivel y el número de palabras para esos libros. Si un nivel o un número de palabras no es especificado aquí, entonces será usado el valor por defecto para ese libro en este sitio Moodle.';
$string['bookseditsite'] = 'Editar libros (Sitio)';
$string['bookseditsite_help'] = 'En esta página Usted puede configurar añadir, editar y eliminar información acerca de libros Reader en este sitio Moodle. Tenga en cuenta que los valores aquí configurados para cualquier libro serán remplazados si se vuelven a descargar los datos para ese libro desde el sitio web principal de Moodle Reader. También, los valores pueden ser anulados localente en cursos individuales.';
$string['booksreadinpreviousterms'] = 'Libros leidos en períodos anteriores';
$string['booksreadsincedate'] = 'Libros leídos desde {$a}';
$string['booksreadsincepromotion'] = 'Libros leídos desde su promoción en {$a}';
$string['booksreadthisterm'] = 'Libros leidos en este período';
$string['booksviaapi'] = 'Datos del libro (vía API)';
$string['bookswithoutquizzes'] = 'Libros sin exámenes';
$string['bookswithquizzes'] = 'Libros con exámenes';
$string['booktitle'] = 'Título del libro';
$string['booktype'] = 'Libros a incluir';
$string['bookupdated'] = 'Libro actualizado: {$a}';
$string['cannotaccesscourse'] = 'Lo sentimos, Usted no tiene permiso para gestionar actividades en el "{$a}" curso.';
$string['cannotcreatecourse'] = 'Lo siento, no puede realizarse la descarga porque Usted no tiene los permisos para crear un nuevo curso o para editar el curso actual.';
$string['cannotdownloadata'] = 'Lo siento, hubo un problema al descargar datos desde el módulo de Lector';
$string['changeallstoplevelto'] = 'Cambiar todos los niveles máximos a';
$string['changeallto'] = 'Cambiar todo a';
$string['changecurrentlevel'] = 'Cambiar todos losniveles actuales a';
$string['changedifficultyfrom'] = 'Cambiar los niveles de dificultad de';
$string['changelevelfrom'] = 'Cambiar nombre del nivel de';
$string['changenumberofsectionsinquiz'] = 'Reiniciar número de secciones en el curso de repositorio de libros';
$string['changepointsfrom'] = 'Cambiar puntos de';
$string['changepublisherfrom'] = 'Cambiar el nombre de la editorial de';
$string['changequiz'] = 'Cambiar examen';
$string['changereaderlevel'] = 'Cambiar Nivel de Lectura, Longitud o Número de Palabras';
$string['changestartlevel'] = 'Cambiar todos los niveles de inicio a';
$string['cheated'] = 'Hizo trampa';
$string['cheatedmessage'] = 'Mensaje de trampa';
$string['cheatedmessage_help'] = 'Este mensaje se les enviará a los estudiantes que el módulo Lector juzgue que han hecho trampa.';
$string['cheatedmessagedefault'] = 'Lamentamos decirle que el programa Lector_de_Moodle ha descubierto que Usted probablemente hizo trampa cuando tomó el examen de arriba. "Trampa" significa que, o Usted le ayudó a otra persona para que hiciera el examen, o Usted recibió ayuda de alguien más al tomar el examen. Ambas personas han sido marcadas como "tramposas".

A veces la computadora comete errores. Si Usted honestamente no recibió ayuda ni ayudó a alguien más, por favor infórmelo a su profesor y se le restaurarán sus puntos.

-El Mánager del Módulo del Lector_de_Moodle';
$string['cheatedshort'] = 'Tra';
$string['cheatsheet'] = 'Hoja de trampa';
$string['check_email'] = 'Revisar Email';
$string['check_email_desc'] = 'Enviar dos Emails de prueba al usuario gueststudent, uno vía Moodle mail y otro vía PHP mail.';
$string['checkbox'] = 'Mostrar casillas de selección';
$string['checkbox_help'] = '**Si**
: Si mostrar casillas de selección en las páginas de reportes del profesor en el área de Administración.

**No**
: NO mostrar casillas de selección en las páginas de reportes del profesor en el área de Administración..

Esta configuración será removida en el futuro, cuando el área de Administración se haya descontinuado.';
$string['checkcheating'] = 'Revisar si hizo trampa';
$string['checkcheating_help'] = 'Esta configuración especifica si deberán revisarse o no las direcciones IP cuando los estudiantes intenten contestar exámenes del Lector.

**Desativado**
: no se revisarán las direcciones IP

**En_cualquier_sitio**
: Si dos estudiantes inician el mismo examen en una hora similar y ambos pasan, serán juzgados por el módulo Lector como que hicieron trampa.

**En computadoras vecinas**
: Si dos estudiantes inician el examen en una hora similar desde una dirección IP similar y ambos pasan, serán juzgados por el módulo Lector como que hicieron trampa.';
$string['checkonlythiscourse'] = 'Revisar solamente este curso';
$string['checksuspiciousactivity'] = 'Revisar bitácoras para buscar actividad sospechosa';
$string['chooseaction'] = 'Elegir una acción y hacer clic en "Ir"';
$string['choosedifficulty'] = 'Por favor elija el nivel de lectura';
$string['chooselevel'] = 'Por favor elija nivel';
$string['choosepublisher'] = 'Por favor elija editorial';
$string['clearedmessage'] = 'Mensaje exonerado';
$string['clearedmessage_help'] = 'Este mensaje es enviado a los estudiantes que fueron juzgados por el módulo Lector como que hicieron trampa, pero después fueron exonerados por el profesor.';
$string['clearedmessagedefault'] = 'Estamos contentos de informarle que sus puntos para el examen superior han sido restaurados. ¡Le pedimos disculpas por el error!

-El Mánager del Módulo Lector_de_Moodle';
$string['clicktocontinue'] = 'Elija aquí para continuar';
$string['complete'] = 'Completo';
$string['completequizattempt'] = 'Antes de que Usted pueda tomar más exámenes nuevos, Usted debe terminar este examen para "{$a}". Haga clic en el enlace inferior para continuar su intento anterior de este examen.';
$string['completionpass'] = 'Requerir calificación aprobatoria';
$string['completiontotalwords'] = 'Requerir total de lectura';
$string['completiontotalwords_help'] = 'El total de lectura que un estudiante debe lograr dentro de esta actividad para que sea marcada como completa.';
$string['configbookcovers'] = '';
$string['configcheatedmessage'] = '';
$string['configcheckbox'] = '';
$string['configcheckcheating'] = '';
$string['configclearedmessage'] = '';
$string['configgoal'] = '';
$string['configintro'] = 'Los valores que Usted configure aquí definen los valores por defecto que son usados en el formato de configuraciones cuando Usted crea una nueva actividad de Lector.

Usted también puede configurar cuales configuraciones del Lector son consideradas como avanzadas.';
$string['configkeeplocalbookdifficulty'] = '';
$string['configkeepoldquizzes'] = '';
$string['configlevelcheck'] = '';
$string['configmaxgrade'] = '';
$string['configminpassgrade'] = '';
$string['configmreaderenable'] = 'Habilitar o deshabilitar las configuraciones para mReader.org';
$string['configmreadersettings'] = 'Estas configuraciones le permiten a los estudiantes de este sitio Moodle acceder a los exámenes en mReader.org

Para obtener una Clave y una ID del Sitio, Usted necesita estar inscrito en el curso siguiente:
: https://www.moodlereader.com/moodle4reader/course/view.php?id=2';
$string['configmreadersiteid'] = 'La ID numérica debajo de la cual está registrado este sitio Moodle en mReader.org';
$string['configmreadersitekey'] = 'La clave secreta que le permite a los estudiantes de este sitio Moodle acceder a exámenes en mReader.org';
$string['configmreaderurl'] = 'La URL en donde los estudiantes pueden acceder a los exámenes en mReader.org';
$string['confignextlevel'] = '';
$string['confignotifycheating'] = '';
$string['configprevlevel'] = '';
$string['configquestionscores'] = '';
$string['configserverpassword'] = 'La contraseña necesaria para descargar exámenes de Moodle Reader para este sitio Moodle.';
$string['configserversettings'] = 'Estas configuraciones le permiten a un profesor o administrador el descargar exámenes Moodle Reader para este sitio Moodle.
El nombre_de_usuario y la contraseña son que Usted emplea para ingresar a  MoodleReader.org.
El nombre_de_usuario debe de haber sido autorizado por el staff en MoodleReader.org.';
$string['configserverurl'] = 'La URL desde donde Usted puede descargar exámenes Moodle Reader para este sitio Moodle.';
$string['configserverusername'] = 'El nombre_de_usuario necesario para descargar exámenes Moodle Reader para este sitio Moodle.';
$string['configshowpercentgrades'] = '';
$string['configshowprogressbar'] = '';
$string['configshowreviewlinks'] = '';
$string['configstoplevel'] = '';
$string['configthislevel'] = '';
$string['configupdate'] = '';
$string['configusecourse'] = '';
$string['configwordsorpoints'] = '';
$string['confirmdeleteattempts'] = '¿Realmente quiere eliminar estos intentos?';
$string['confirmstartattemptlimit'] = 'Número permitido de intentos: {$a}. Usted está a punto de iniciar un nuevo intento. ¿Desea continuar?';
$string['confirmstartattempttimelimit'] = 'Este examen tiene un límite de tiempo y está limitado a {$a} intento(s). Usted está a punto de iniciar un nuevo intento. ¿Desea continuar?';
$string['confirmstarttimelimit'] = 'Este examen tiene un límite de tiempo . ¿Está Usted seguro de desear continuar?';
$string['countactive'] = 'Estudiantes activos';
$string['countactive_help'] = 'El número de estudiantes que han tomado al menos un examen de Reader';
$string['countfailed'] = 'Exámenes reprobados';
$string['countinactive'] = 'Estudiantes inactivos';
$string['countinactive_help'] = 'El número de estudiantes que no han tomado ningún examen de Reader';
$string['countpassed'] = 'Exámenes aprobados';
$string['countrating'] = 'Número de valuaciones (ratings)';
$string['courseid'] = 'ID del Curso';
$string['coursespecificquizselection'] = 'Selección de examen específica-del-curso a "Si" en la pantalla de configuración del módulo.';
$string['createcoversets_l'] = 'Crear Conjuntos de Forros por  Nivel y Editorial';
$string['createcoversets_t'] = 'Crear Conjuntos de Forros por Editorial &amp; Nivel';
$string['credit'] = 'Crédito extra';
$string['creditshort'] = 'X';
$string['curlerror'] = 'Error CURL: {$a}';
$string['current'] = 'Actual';
$string['currentcourse'] = 'Curso actual';
$string['currentlevel'] = 'Nivel actual';
$string['dataallavailable'] = 'datos para todos {$a} libro(s) está disponible';
$string['dataalldownloaded'] = 'datos para todos {$a} libro(s) han sido descargados';
$string['datasomeavailable'] = 'datos para  {$a->new} del total de {$a->all} libro(s) está disponible';
$string['defaultcategoryname'] = 'Exámenes de Reader';
$string['defaultcoursename'] = 'Exámenes de Reader';
$string['defaultgoal'] = 'Meta por defecto';
$string['defaultgoals'] = 'Metas por defecto';
$string['defaultquestioncategoryinfo'] = '{$a->category} preguntas para {$a->quiz}';
$string['defaultrates'] = 'Valoraciones por defecto';
$string['definelogindetails'] = 'Por favor, defina los detalles para ingreso: {$a}';
$string['delayineffect'] = 'Actualmente está en efecto un retraso del examen';
$string['delayquizattempts'] = 'Retrasar intentos de exámenes siguientes';
$string['delete'] = 'Eliminar';
$string['deleteallattempts'] = 'Eliminar todos los intentos en exámenes de Reader';
$string['deleteallattempts_help'] = 'Como regla, Usted NO DEBERÍA de eliminar intentos de exámenes en Reader

Usted solamente debería de eliminar intentos si Usted está absolutamente seguro que los estudiantes en este curso nunca volverán a tomar exámenes otra vez en este sitio Moodle nunca jamás.

Esto es debido a que al eliminar intentos de exámenes en Reader, Usted le permite a los estudiantes el volver a tomar cualquier examen en Reader que hayan tomado previamente. Esto NO es lo que se supone que deba hacer el módulo de Reader. Los estudiantes solamente deberían de tener UN INTENTO para tomar un examen en Reader.

Eliminar intentos en exámenes en Reader también re-iniciará a cero los puntajes de lectura para todos los estudiantes, lo que probabemente no es lo que Usted ni los estudiantes quisieran.';
$string['deleteattempts'] = 'Eliminar intentos seleccionados';
$string['deletecategories'] = 'Eliminar categorías';
$string['deletecourses'] = 'Eliminar cursos';
$string['deleted'] = 'Eliminado';
$string['deletedshort'] = 'Eli';
$string['deletegoals'] = 'Eliminar metas para grupos y niveles';
$string['deletegoals_help'] = 'Las metas de lectura por defecto para grupos o niveles de lectura particulares serán eliminadas.';
$string['deletemessages'] = 'Eliminar mensajes de Reader';
$string['deletemessages_help'] = 'Todos los mensajes que aparecen en la página principal del estudiante para actividades Reader en este curso serán eliminadas.';
$string['deleterates'] = 'Eliminar valoraciones para grupos y niveles';
$string['deleterates_help'] = 'Las tasas entre exámenes de Reader para grupos particulares o niveles de lectura serán eliminados.';
$string['detect_cheating'] = 'Se detectó trampa';
$string['detect_cheating_desc'] = 'Revisar las bitácoras de intentos y reportar actividad sospechosa que podría indicar que hicieron trampa.';
$string['difficulty'] = 'Dificultad';
$string['difficultyshort'] = 'De_Derecha_a_Izquierda';
$string['disallowpromotion'] = 'NO permitir promoción';
$string['displayoptions'] = 'Opciones de visualización';
$string['downloadbooksviaapi'] = 'Descargar datos del libro (vía API)';
$string['downloadbookswithoutquizzes'] = 'Descargar datos de libros (sin exámenes)';
$string['downloadbookswithquizzes'] = 'Descargar datos de libros y exámenes';
$string['downloadedbooks'] = 'Se descargaron datos para los libros siguientes:';
$string['downloadexcel'] = 'Descargar Excel';
$string['downloadextrapoints'] = 'Por favor descargar exámenes de "Puntos extra"';
$string['downloadmode'] = 'Modo';
$string['downloadmode_help'] = 'Esta página puede tener los siguientes dos modos:

**Normal**
: En el modo normal, solamente los libros cuyos datos no se hubieran descargado, o los libros cuyos datos se hubieran actualizado, estarán disponibles. Los libros para los cuales ya se hayan descargado los datos más recientes no estarán disponibles

**Reparar**
: En el modo de reparar, todos los libros están disponibles para descargarse. Si se hubieran descargado datos previamente, serán sobrescritos por los nuevos datos descargados. Use este modo si Usted quiere reparar exámenes defectuosos o datos incorrectos. Tenga en cuenta que aun y cuando se sobrescriban los exámenes, los datos acerca de los intentos de los estudiantes para contestar estos exámenes serán conservados.';
$string['downloads'] = 'Descargas';
$string['downloadsettings'] = 'Configuraciones de Descargas';
$string['duration'] = 'Duración';
$string['edit'] = 'Editar';
$string['editquiztoreader'] = 'Eliminar exámenes';
$string['err_regex_float'] = 'Esta configuración debe de ser un número decimal entre 0.0 y 10.0';
$string['err_regex_integer'] = 'Esta configuración debe de ser un número entero entre 0 y 100,000';
$string['error'] = 'Error: {$a}';
$string['errorsfound'] = 'Errores encontrados';
$string['event_attempt_added'] = 'Intento de examen de Reader añadido';
$string['event_attempt_added_description'] = 'El usuario con id "{$a->userid}" inició un intento de examen para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_attempt_added_explanation'] = 'Un usuario recientemente empezó un intento de examen de Reader';
$string['event_attempt_deleted'] = 'Intento de examen de Lector eliminado';
$string['event_attempt_deleted_description'] = 'El usuario con id "{$a->userid}" eliminó un intento de examen para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_attempt_deleted_explanation'] = 'Un usuario recientemente eliminó un intento de un examen de Lector';
$string['event_attempt_edited'] = 'Intento de examen de Lector eliminado';
$string['event_attempt_edited_description'] = 'El usuario con id "{$a->userid}" editó un intento de examen para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_attempt_edited_explanation'] = 'Un usuario recientemente ha editado un intento de un examen de Lector';
$string['event_attempt_submitted'] = 'Intento de examen de Lector enviado';
$string['event_attempt_submitted_description'] = 'El usuario con id "{$a->userid}" envió un intento de examen para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_attempt_submitted_explanation'] = 'Un usuario recientemente envió un intento de un examen de Lector';
$string['event_base'] = 'Evento de Lector detectado';
$string['event_base_description'] = 'El usuario con id "{$a->userid}" inició un evento en la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_base_explanation'] = 'Un evento fue detectadopor el módulo de Lector';
$string['event_book_added'] = 'Libro de Lector añadido';
$string['event_book_added_description'] = 'El usuario con id "{$a->userid}" añadió un libro para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_book_added_explanation'] = 'Un usuario recientemente añadió datos acerca de un libro de Reader';
$string['event_book_deleted'] = 'Libro de Lector eliminado';
$string['event_book_deleted_description'] = 'El usuario con id "{$a->userid}" eleminó un libro para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_book_deleted_explanation'] = 'Un usuario recientemente eliminó datos de un libro de Reader';
$string['event_book_edited'] = 'Libro de lector editado';
$string['event_book_edited_description'] = 'El usuario con id "{$a->userid}" editó un libro para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_book_edited_explanation'] = 'Un usuario recientemente editó datos de un libro de Reader';
$string['event_books_downloaded'] = 'Libros de Lector descargados';
$string['event_books_downloaded_description'] = 'El usuario con id "{$a->userid}" descargó libros para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_books_downloaded_explanation'] = 'Un usuario recientemente descargó datos de libros de Reader';
$string['event_cron_run'] = 'Cron de Lector ejecutado';
$string['event_cron_run_description'] = 'El trabajo del CRON del Lector ha corrido';
$string['event_cron_run_explanation'] = 'El trabajo del CRON del Lector recientemente ha sido corrido';
$string['event_downloads_viewed'] = 'Descargas de Lector vistas';
$string['event_downloads_viewed_description'] = 'El usuario con id "{$a->userid}" avió datos acerca de las descargas para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_downloads_viewed_explanation'] = 'Un usuario recientemente vió datos de descargas de Reader';
$string['event_message_added'] = 'Mensaje de Reader añadido';
$string['event_message_added_description'] = 'El usuario con id "{$a->userid}" añadió un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_message_added_explanation'] = 'Un usuario recientemente añadió un mensaje a una actividad de Reader';
$string['event_message_deleted'] = 'Mensaje de Reader eliminado';
$string['event_message_deleted_description'] = 'El usuario con id "{$a->userid}" eliminó un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_message_deleted_explanation'] = 'Un usuario recientemente eliminó un mensaje de una actividad de Reader';
$string['event_message_edited'] = 'Mensaje de Reader editado';
$string['event_message_edited_description'] = 'El usuario con id "{$a->userid}" editó un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_message_edited_explanation'] = 'Un usuario recientemente editó un mensaje de una actividad de Reader';
$string['event_quiz_added'] = 'Examen de Reader añadido';
$string['event_quiz_added_description'] = 'El usuario con id "{$a->userid}" añadió un examen para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_added_explanation'] = 'Un usuario recientemente añadió un examen a una actividad de Reader';
$string['event_quiz_delay_set'] = 'Retraso de examen de Reader configurado';
$string['event_quiz_delay_set_description'] = 'El usuario con id "{$a->userid}" configuró un retraso de examen para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_delay_set_explanation'] = 'Un usuario recientemente configuró un retraso en un examen de Reader';
$string['event_quiz_deleted'] = 'Examen de Reader eliminado';
$string['event_quiz_deleted_description'] = 'El usuario con id "{$a->userid}" eliminó un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_deleted_explanation'] = 'Un usuario recientemente eliminó un examen de Reader';
$string['event_quiz_edited'] = 'Examen de Reader editado';
$string['event_quiz_edited_description'] = 'El usuario con id "{$a->userid}" editó un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_edited_explanation'] = 'Un usuario recientemente editó un examen de Reader';
$string['event_quiz_finished'] = 'Examen de lector terminado';
$string['event_quiz_finished_description'] = 'El usuario con id "{$a->userid}" terminó un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_finished_explanation'] = 'Un usuario recientemente terminó un examen de Reader';
$string['event_quiz_selected'] = 'Examen de lector seleccionado';
$string['event_quiz_selected_description'] = 'El usuario con id "{$a->userid}" seleccionó un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_selected_explanation'] = 'Un usuario recientemente seleccionó un examen de Reader';
$string['event_quiz_started'] = 'Examen de Lector iniciado';
$string['event_quiz_started_description'] = 'El usuario con id "{$a->userid}" inició un mensaje para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_quiz_started_explanation'] = 'Un usuario recientemente inició un examen de Reader';
$string['event_report_bookdetailed_viewed'] = 'Reporte de Reader visto: Libros (detallado)';
$string['event_report_bookdetailed_viewed_description'] = 'El usuario con id "{$a->userid}" vió el reporte "Libros" (detallado) para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_report_bookdetailed_viewed_explanation'] = 'Un usuario recientemente vió un Reporte de Reader: Libros (detallado)';
$string['event_report_booksummary_viewed'] = 'Reporte de Reader visto: Libros (resumen)';
$string['event_report_booksummary_viewed_description'] = 'El usuario con id "{$a->userid}" vió el reporte "Libros" (resumen) para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_report_booksummary_viewed_explanation'] = 'Un usuario recientemente vió un reporte de Reader: Libros (resumen)';
$string['event_report_groups_viewed'] = 'Reporte de Reader visto: Grupos (resumen)';
$string['event_report_groups_viewed_description'] = 'El usuario con id "{$a->userid}" vió el reporte "Grupos" (resumen) para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_report_groups_viewed_explanation'] = 'Un usuario recientemente vió un reporte de Reader: Grupos (resumen)';
$string['event_report_userdetailed_viewed'] = 'Reporte de Reader visto: Usuarios (detallado)';
$string['event_report_userdetailed_viewed_description'] = 'El usuario con id "{$a->userid}" vió el reporte "Usuarios" (detallado) para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_report_userdetailed_viewed_explanation'] = 'Un usuario recientemente vió un reporte de Reader: Usuarios (detallado)';
$string['event_report_usersummary_viewed'] = 'Reporte de Reader visto: Usuarios (resumen)';
$string['event_report_usersummary_viewed_description'] = 'El usuario con id "{$a->userid}" vió el reporte "Usuarios" (resumen) para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_report_usersummary_viewed_explanation'] = 'Un usuario recientemente vió un reporte de Reader: Usuarios (resumen)';
$string['event_tool_run'] = 'Herramienta administrativa del Lector corrida';
$string['event_tool_run_description'] = 'El usuario con id "{$a->userid}" corrió una herramienta administrativa para la actividad "reader" con Id del módulo de curso "{$a->cmid}"';
$string['event_tool_run_explanation'] = 'Un usuario recientemente corrió una herramienta de Reader: {$a}';
$string['event_user_goal_set'] = 'Meta de usuario Lector configurada';
$string['event_user_goal_set_description'] = 'El usuario con id "{$a->userid}" configuró una meta de lectura de estudiante para la actividad de "Lector" con la ID del módulo de curso "{$a->cmid}"';
$string['event_user_goal_set_explanation'] = 'Un usuario acaba de configurar una meta de lectura en una actividad de Lector';
$string['event_user_level_set'] = 'Nivel de usuario Lector configurado';
$string['event_user_level_set_description'] = 'El usuario con id "{$a->userid}" configuró un nivel de lectura de estudiante para la actividad "reader" con ID de módulo de curso  "{$a->cmid}"';
$string['event_user_level_set_explanation'] = 'Un usuario recientemente configuró el nivel de lectura para un estudiante en una actividad de Reader';
$string['event_users_exported'] = 'Usuarios de Reader exportados';
$string['event_users_exported_description'] = 'El usuario con id "{$a->userid}" exportó datos de estudiante para la actividad "reader" con ID del módulo de curso  "{$a->cmid}"';
$string['event_users_exported_explanation'] = 'Un usuario recientemente exportó datos de estudiantes desde una actividad de Reader';
$string['event_users_imported'] = 'Usuarios de Reader importados';
$string['event_users_imported_description'] = 'El usuario con id "{$a->userid}" importó datos de estudiante para la actividad "reader" con ID del módulo de curso  "{$a->cmid}"';
$string['event_users_imported_explanation'] = 'Un usuario recientemente importó datos de estudiantes hacia una actividad de Reader';
$string['export'] = 'Exportar';
$string['export_reader_tables'] = 'Exportar tablas de Lector';
$string['export_reader_tables_desc'] = 'Exportar tablas de base de datos de Reader. Tenga en cuenta que los datos exportados no contienen nombres de usuario ni de curso, solamente IDs.';
$string['exportstudentrecords'] = 'Exportar registros de estudiante';
$string['extrapoints'] = 'Puntos Extra';
$string['extrapoints0'] = '0.5 Puntos';
$string['extrapoints1'] = '1 Punto';
$string['extrapoints2'] = '2 Puntos';
$string['extrapoints3'] = '3 Puntos';
$string['extrapoints4'] = '4 Puntos';
$string['extrapoints5'] = '5 Puntos';
$string['extrapoints6'] = '6 Puntos';
$string['extrawords'] = '{$a} palabras';
$string['failed'] = 'Reprobó';
$string['failedshort'] = 'NA';
$string['filename'] = 'Nombre del archivo';
$string['fileuploaded'] = 'El archivo fue subido';
$string['find_faultyquizzes'] = 'Encontrar exámenes defectuosos';
$string['find_faultyquizzes_desc'] = 'Encontrar exámenes que tengan preguntas que no tengan respuesta correcta, o preguntas que se hayan vuelto huérfanas.';
$string['finishreview'] = 'Terminar Revisión';
$string['fix_bookcovers'] = 'Reparar Portadas de libros';
$string['fix_bookcovers_desc'] = 'Detectar libros a los que les falta una imagen de cubierta-de-libro, e intentar descargar la imagen de cubierta del libro.';
$string['fix_bookinstances'] = 'Reparar instancias de libros';
$string['fix_bookinstances_desc'] = 'Asegurarse de que todos los libros tengan un registro asociado en la tabla reader_book_instances.';
$string['fix_coursesections'] = 'Reparar secciones de curso';
$string['fix_coursesections_desc'] = 'Arreglar la página principal de cursos que contengan exámenes de Reader.

* ordenar secciones por nombre del publicador (casa editorial) y nivel de dificultad.
* asegurarse de que cada sección solamente contenga libros de un solo publicador (una sola casa editorial)
* unir secciones múltiples del mismo publicador (casa editorial)
* quitar secciones vacías
* reiniciar número de secciones de curso';
$string['fix_installxml'] = 'Reparar db/install.xml';
$string['fix_installxml_desc'] = 'Hacer las marcas XML en db/install.xml compatibles con Moodle <= 2.5

* añadir atributos NEXT y PREVIOUS a las marcas TABLE, FIELD, KEY e INDEX
* añadir atributos SEQUENCE a marcas FIELD con TYPE="int"';
$string['fix_missingquizzes'] = 'Reparar exámenes faltantes';
$string['fix_missingquizzes_desc'] = 'Unificar libros y exámenes Reader duplicados.

* juntar libros duplicados
* corregir libros que compartan el mismo examen
* juntar exámenes duplicados
* corregir libros e intentos para los cuales falta el examen';
$string['fix_questioncategories'] = 'Reparar categorías de preguntas';
$string['fix_questioncategories_desc'] = 'Arreglar categorías y preguntas Reader

* desconfigurar todas las IDs de preguntas con  padre inválido
* eliminar preguntas Reader no usadas en ningún examen Reader
* mover categorías de preguntas de curso Reader al examen Reader apropiado
* quitar diagonales de nombres de categorías y descripciones
* estandarizar nombres de Categorías para Ordenar';
$string['fix_slashesinnames'] = 'Reparar diagonales en nombres';
$string['fix_slashesinnames_desc'] = 'Quitar las diagonales en los nombres de libros Reader y categorías de preguntas.';
$string['fix_wrongattempts'] = 'Reparar intentos equivocados';
$string['fix_wrongattempts_desc'] = 'Detectar y corregir cualquier intento en exámenes Reader en donde el nombre del examen no coincida con el nombre del libro en la bitácora de Reader.';
$string['fixattempts'] = 'Corrigiendo intentos de lectura duplicados';
$string['fixcontexts'] = 'Corrigiendo los contextos defectuosos en categorías de pregunta del Examen';
$string['fixingsumgrades'] = 'Reparando calificaciones en intentos de exámenes de Reader...';
$string['fixinstances'] = 'Revisando instancias de preguntas de Lectura';
$string['fixmissingquizzes'] = 'Reparar exámenes faltantes';
$string['fixmissingquizzesinfo'] = 'La actualización ha sido pausada, para que Usted pueda decidir si es que quiere o no descargar e instalar exámenes del módulo Reader que faltan en este sitio Moodle.

Si Usted selecciona "Si", los exámenes faltantes serán descargados e instalados.

Si Usted selecciona "No", cualquir libro Reader al cual le falten exámenes será marcado como que no tiene datos de examen.

Tenga en cuenta que si Usted elige "No", el conteo de palabras para cada estudiante en actividades Reader no será afectado por esta operación.

¿ Quiere Usted descargar e instalar los exámenes faltantes en este sitio Moodle del módulo Reader ?';
$string['fixmultichoice'] = 'Corrigiendo preguntas de opción múltple de Lectura';
$string['fixordering'] = 'Actualizando ordenamiento de preguntas para módulo Lectura';
$string['fixquestiontext'] = 'Corregir marcas en preguntas de Lector';
$string['fixquizslots'] = 'Corrigiendo casos de pregunta defectuosa en intentos de Examen';
$string['fixslashesinnames'] = 'Remover diagonales en títulos de libros';
$string['fixwrongquizid'] = '"{$a->name}" (book id={$a->id}) tiene una ID de examen inesperada';
$string['fixwrongquizidinfo'] = 'La actualización ha sido pausada, por lo que Usted puede decidir cual examen debería de asociarse con este libro.

Por favor, revise la información inferior y seleccione el examen que Usted desea asociar con este libro.';
$string['forcedownload'] = 'Forzar descarga';
$string['forcedtimedelay'] = 'Configurar retraso de hora forzada';
$string['forcedtimerate'] = 'Configurar tasa forzada de lectura';
$string['fromthistime'] = 'Desde esta hora';
$string['fullreportbybooktitle'] = 'Reporte completo por Título del Libro';
$string['fullreportquiztoreader'] = 'Reporte completo por Estudiante';
$string['genre'] = 'Género';
$string['getstarted'] = '**Comenzando**

* El objetivo de esta actividad es leer muchos libros y construir su total de lectura.
* Su total de lectura es el número total de palabras en todos los libros que Usted ha leído.

**Elija un libro**

* Usted debería de elegir libros que pueda leer fácilmente sin usar un diccionario.
* También, elija libros que le interesen, porque son los más divertidos de leer.

**Tome un examen en-línea**

* Después de que haya leído un libro, tome un examen en-línea.
* Use las cajas para búsqueda en esta página para encontrar el examen que quiere. Cuando Usted haya encontrado su examen, haga clic en el botón para comenzar el examen.
* Cada examen tiene diferentes preguntas acerca del libro. Las preguntas son diferentes para cada estudiante.
* Si Usted pasa el examen, el número de palabras en el libro será añadido a su total de lectura. Si Usted reprueba el examen, su total de lectura no cambia.
* ***Usted no puede re-tomar exámenes***; por eso, haga los exámenes con cuidado';
$string['goal'] = 'Objetivo';
$string['groupgoals'] = 'Metas para grupos específicos';
$string['grouprates'] = 'Valoraciones para grupos espeíficos';
$string['hidden'] = 'Oculto';
$string['ifimagealreadyexists'] = 'Ya existe una imagen en la carpeta de imágenes (nombre)';
$string['ignoredate'] = 'Fecha de inicio del período (semestre)';
$string['ignoredate_help'] = 'La fecha del inicio del período actual.

Cualquier intento de hacer exámenes Reader antes de esta fecha no será incluido en los totales del reporte para esto en el período actual.

Sin embargo, los intentos en períodos anteriores no son ignorados completamente. Serán incluidos en los totales del reporte para "Todos los períodos".

También, por favor tenga en cuenta que los estudiantes nunca pueden volver a tomar exámenes Reader, incluyendo aquellos tomados en períodos anteriores, a menos de que el profesor elimine el intento anterior.';
$string['image'] = 'Imagen';
$string['imageadded'] = 'Imagen añadida: {$a}';
$string['import'] = 'Importar';
$string['import_reader_tables'] = 'Importar tablas de reader';
$string['import_reader_tables_desc'] = 'Recrear un sitio Moodle completo solamente a partir de la base de datos Reader. Esta herramienta creará cursos, usuarios, grupos, actividades Reader y exámenes.';
$string['importreadertables'] = 'Importar tablas de Reader';
$string['importstudentrecord'] = 'Importar registro de estudiante';
$string['in1000sofwords'] = 'en 1000s de palabras';
$string['includepublishers'] = '¿Buscar también nombres de casas editoriales?';
$string['incorrect'] = '- incorrecto';
$string['incorrect2'] = '- Lo sentimos, por favor obtenga la contraseña correcta del/los editor(es). Haga clic en "Instalar Exámenes" para descargar sus otras selecciones.';
$string['incorrectbooksreadinpreviousterms'] = 'Ver examenes reprobados';
$string['induration'] = 'en';
$string['install_quizzes'] = 'Instala Exámenes';
$string['installedbooks'] = 'Descargar/corregir solamente cubiertas para libros que ya están INSTALADOS en este sitio';
$string['ipaddress'] = 'Dirección IP';
$string['isgreaterthan'] = 'es mayor que';
$string['islessthan'] = 'es menor que';
$string['itemsdownloaded'] = '{$a} items descargados';
$string['keeplocalbookdifficulty'] = 'Conservar configuracines de dificultad de libro local';
$string['keepoldquizzes'] = 'Conservar exámenes antiguos';
$string['lastupdatedtime'] = 'Los exámenes en este sitio fueron actualizadas por última ocasión en {$a}. ¿Desea Usted actualizar este sitio ahora?';
$string['level'] = 'Nivel';
$string['levelcheck'] = 'Restringir Nivel de lectura';
$string['levelcheck_help'] = '**Sí**
: Los estudiantes solamente tendrán permitido tomar exámenes Reader para libros que estén al nivel o cerca del nivel actual. El número de exámenes que los estudiantes tienen permitidos tomar está especificado en las configuraciones de esta página para "Exámenes en el nivel actual/anterior/siguiente"

**No**
: A los estudiantes siempre les será permitido tomar exámenes Reader para libros en cualquier nivel de lectura.';
$string['levelgoal'] = 'Meta del Nivel {$a}';
$string['levelgoals'] = 'Metas para niveles específicos';
$string['leveli'] = 'Nivel {$a}';
$string['levelrate'] = 'Nivel {$a} tasa';
$string['levelrates'] = 'Valoraciones para niveles específicos';
$string['levels'] = 'Niveles';
$string['likebook'] = '¿Que tanto te gustó este libro?';
$string['logoutrequired'] = 'Usted no puede continuar debido a que actualmente Usted está ingresado como {$a}.

Para continuar, haga clic en el botón inferior para "Salir del sitio" y después vuelva a ingresar como Usted mismo.';
$string['mainpagesettings'] = 'Configuraciones de la página principal';
$string['makebookavailable'] = 'Hacer disponibles los libros';
$string['makebookavailableproblem'] = 'Ups, no se pudo hacer libro disponible en este curso: {$a}';
$string['makebookavailablesuccess'] = 'Libro está ahora disponible en este curso: {$a}';
$string['makenewquizzesavailable'] = 'Hacer los nuevos exámenes disponibles solamente en este curso';
$string['makenewquizzesavailable2'] = 'Hacer los nuevos exámenes disponibles en todos los cursos en este sitio [configuración por defecto]';
$string['massrename'] = 'Cambios en masa';
$string['max'] = 'Menor que o igual a';
$string['maxgrade'] = 'Calificación máxima';
$string['maxgrade_help'] = 'La calificación máxima para esta actividad de Lector.

El número de palabras leídas, como una fracción de la meta de lectura, será escalado a esta calificación máxima y pasada al Libro de calificaciones.

Usualmente la calificación máxima será 100, pero si todos los estudiantes tienen la misma meta de lectura, podría ayudarles a los estudiantes a comprender su calificación si esta configuración fuese la misma que la meta de lectura.';
$string['maxquizattemptrate'] = 'Tasa máxima de intento de examen';
$string['maxquizattemptrate_help'] = 'La tasa máxima a la que los estudiantes pueden intentar exámenes Reader. Si un estudiante intenta más que el número de examenes dentro de la duración especificada, entonces se tomará la acción especificada.';
$string['maxquizattemptratetext'] = 'Por favor no tome más de {$a}. Si Usted excede esta tasa, se tomará a siguiente acción:';
$string['maxquizfailurerate'] = 'Tasa de falla máxima de examen';
$string['maxquizfailurerate_help'] = 'La tasa máxima a la que los estudiantes pueden reprobar exámenes Reader. Si un estudiante reprueba más que el número de examenes dentro de la duración especificada, entonces se tomará la acción especificada.';
$string['maxquizfailureratetext'] = 'Si Usted falla en más de {$a}, se tomará la siguiente acción:';
$string['maxtimebetweenquizzes'] = 'Tiempo máximo entre exámenes';
$string['menu'] = 'Menú';
$string['mergingtables'] = 'Uniendo tablas: {$a->old} dentro de {$a->new}';
$string['messagefromyourteacher'] = 'Mensaje de su profesor';
$string['migratinglogs'] = 'Migrando bitácoras de Reader';
$string['min'] = 'Mayor que o igual a';
$string['minimumdelay'] = 'Retraso máximo';
$string['minpassgrade'] = 'Calificación mínima aprobatoria del examen';
$string['minpassgrade_help'] = 'La calificación mínima aprobatoria, como un porcentaje, para los exámenes en esta actividad de Lector.

Los intentos con un porcentaje de calificación menores a este valor se considerarán como reprobados.';
$string['minquizattemptrate'] = 'Tasa mínima d intento de examen';
$string['minquizattemptrate_help'] = 'La tasa mínima a la que los estudiantes pueden intentar exámenes Reader. Si un estudiante no continúa intentando al menos el número especificado de exámenes dentro de la duración especificada, entonces se tomará la acción especificada.';
$string['minquizattemptratetext'] = 'Por favor tome al menos {$a}. Si Usted baja de esta tasa, se tomará la siguiente acción:';
$string['modulename'] = 'Lector';
$string['modulename_help'] = 'El módulo de Lector le permite a los profesores configurar objetivos de lectura para estudiantes, y les permite a los estudiantes demostrar que han cubierto los objetivos de lectura especificados.';
$string['modulename_link'] = 'mod/reader/view';
$string['modulenameplural'] = 'Lector';
$string['morenewattempts'] = '{$a} intentos nuevos más ...';
$string['move_quizzes'] = 'Mover exámenes';
$string['move_quizzes_desc'] = 'Mover exámenes de Reader del curso actual hacia el curso principal para exámenes Reader.';
$string['movedquizzes'] = '{$a} exámenes movidos exitosamente';
$string['mreaderenable'] = 'Habilitar configuraciones mReader';
$string['mreadersettings'] = 'Acceder a exámenes mReader';
$string['mreadersiteid'] = 'ID del sitio para exámenes mReader';
$string['mreadersitekey'] = 'Clave para exámenes mReader';
$string['mreaderurl'] = 'URL para exámenes mReader';
$string['needdeletethisattemptstoo'] = 'Necesita eliminar también estos Intentos';
$string['needtocheckupdates'] = 'Este sitio no ha sido revisado para actualizaciones de exámenes en ({$a} días. ¿Revisar ahorita?';
$string['newdate'] = 'Nueva fecha';
$string['newreaderattempts'] = 'Nuevos intentos de Reader';
$string['newreadinggoal'] = 'Nuevo objetivo';
$string['newreadinglevel'] = '¡Nuevo nivel!';
$string['newsetting'] = 'Nuevo valor para esta configuración';
$string['newtime'] = 'Nueva hora';
$string['nextlevel'] = 'Exámenes al nivel siguiente';
$string['nextlevel_help'] = 'El número de exámenes que un estudiante puede tomar del siguiente nivel de lectura. Por ejemplo, el nivel de lectura que está justamente arriba del nivel de lectura actual. Tenga en cuenta que estos exámenes NO CUENTAN hacia la promoción.';
$string['no_password'] = 'No se requiere contraseña';
$string['noaction'] = 'No tomar ninguna acción';
$string['nobooksfound'] = 'No se encontraron libros';
$string['nobooksinlist'] = 'No se encontraron libros para su ivel de lectura';
$string['nodownloaditems'] = 'No hay ítems disponibles para descargar';
$string['noemailever'] = 'El enviar Email está deshabilitado debido a una configuración de  $CFG->noemailever.';
$string['noincorrectquizzes'] = 'Usted no ha reprobado ningún examen';
$string['nomoreattempts'] = 'No están permitidos más intentos';
$string['noquizzesfound'] = 'No se encontraron exámenes';
$string['noreaders'] = 'No se encontraron actividades de lectura en este curso';
$string['norecordsmatch'] = 'No fueron seleccionados registros usando los filtros actuales y opciones de visualización.';
$string['noreview'] = 'Usted no tiene permitido revisar este examen';
$string['noreviewshort'] = 'No permitido';
$string['normalmode'] = 'Normal';
$string['noscript'] = '¡JavaScript debe de estar habilitado para continuar!';
$string['nosearchresults'] = 'No están disponibles libros que coincidan con su búsqueda';
$string['notavailable'] = 'Este examen no está disponible actualmente';
$string['nothavepermissioncreateinstance'] = 'Lo sentimos, Usted no tiene permiso para hacer esto';
$string['notifycheating'] = 'Notificar trampas';
$string['notifycheating_help'] = 'Si se habilita esta configuración, entonces a los estudiantes que sean juzgados como  que hubieran hecho trampa en intentos en exámenes de Reader se les enviará el "Mensaje de Trampa" inferior.';
$string['numattempts'] = '{$a} intentos';
$string['numberofextrapoints'] = 'Número de puntos extra';
$string['off'] = 'Desactivado';
$string['oneattempt'] = '1 intento';
$string['onlybookswithmorethan'] = 'Solamente libros con más de';
$string['outputformat'] = 'Formato de salida';
$string['pagesettings'] = 'Configuraciones de página';
$string['passed'] = 'Pasado';
$string['passedshort'] = 'P';
$string['passworderror'] = 'La contraseña escrita era incorrecta';
$string['passwords_list'] = 'Lista de contraseñas';
$string['percentactive'] = 'Porcentaje activo';
$string['percentactive_help'] = 'El número de estudiantes que han tomado al menos un examen de Reader';
$string['percentinactive'] = 'Porcentaje inactivo';
$string['percentinactive_help'] = 'El porcentaje de estudiantes que no han tomado ningún examen de Reader';
$string['pleaseaskyourinstructor'] = 'Por favor, pídale a su instructor que lo suba de nivel, porque esto es demasiado fácil para Usted.';
$string['pleaseclose'] = 'Su solicitud ha sido procesada. Usted puede cerrar ahora esta ventana';
$string['pleaseselectpublisher'] = 'Por favor seleccione Casa editorial';
$string['pleasespecifyyourclassgroup'] = 'Por favor especifique su grupo de clase o busque a un estudiante específico.';
$string['pleasewait'] = 'Por favor espere';
$string['pluginadministration'] = 'Administración de Lector';
$string['pluginname'] = 'Lector';
$string['points'] = 'Puntos';
$string['pointsex11'] = 'Extensión(Ex. 1.1)';
$string['popup'] = 'Usar ventana "segura"';
$string['popup_help'] = 'Si se seleccionara "Sí",

* El examen solamente comenzará si el estudiante tiene una navegador web con JavaScript habilitado
* El examen aparece en una ventana emergente a pantalla completa que cubre todas las otras ventanas y no tiene controles de navegación
* Se les impide a los estudiantes, tanto como se puede, usar facilidades como copiar y pegar';
$string['prevlevel'] = 'Exámenes al nivel previo';
$string['prevlevel_help'] = 'El número de exámenes que un estudiante puede tomar del nivel de lectura anterior. Por ejemplo, el nivel de lectura que está justamente abajo del nivel de lectura actual. Tenga en cuenta que estos exámenes NO CUENTAN hacia la promoción.';
$string['print_cheatsheet'] = 'Imprimir hoja de respuestas';
$string['print_cheatsheet_desc'] = 'Mostrar las respuestas para cualquier examen Reader';
$string['process_addquestion'] = '<b>Añadirle preguntas al examen {$a}.</b><br />';
$string['process_courseadded'] = '<b>Curso añadido.</b><br />';
$string['promotionnotallowed'] = 'Su profesor ha suspendido la promoción automática para Usted.';
$string['promotionsettings'] = 'Configuraciones para promoción';
$string['publisher'] = 'Casa Editorial';
$string['publishers'] = 'Casas Editoriales';
$string['questionscores'] = 'Mostrar puntajes de pregunta';
$string['questionscores_help'] = '¿ Deberían de ser mostrados a los estudiantes los puntajes máximos para cada pregunta cuando ellos intenten un examen Reader ?

**Sí**
: Mostrar los puntajes máximos para preguntas en exámenes Reader.

**No**
: Ocultar los puntajes máximos para preguntas en exámenes Reader.';
$string['quizadd'] = 'Añadir exámenes de Reader';
$string['quizadded'] = 'Examen añadido: {$a}';
$string['quizarrange'] = 'Arreglar exámenes de Reader';
$string['quizattemptinprogress'] = 'Intento de examen de Reader en progreso ...';
$string['quizclosed'] = 'Este examen cerró en {$a}';
$string['quizcloseson'] = 'Este examen cerrará en {$a}';
$string['quizdelete'] = 'Eliminar exámenes de Reader';
$string['quizfordays'] = 'Restricción de frecencia (días)';
$string['quizhasnoquestions'] = 'El examen no tiene preguntas';
$string['quizmanagement'] = 'Gestión del examen';
$string['quizname'] = 'Nombre del examen';
$string['quiznotavailable'] = 'Lo sentimos, este examen actualmente no está disponible para Usted';
$string['quiznotavailableuntil'] = 'El examen no estará disponible hasta después de {$a}';
$string['quizonmreaderorg'] = '(Examen disponible en mreader.org)';
$string['quizopenedon'] = 'El examen abrió en {$a}';
$string['quizsetrate'] = 'Configurar tasa de exámenes de Lectura';
$string['quizshowhide'] = 'Mostrar / Ocultar exámenes de Reader';
$string['quiztimelimit'] = 'Límite de tiempo: {$a}';
$string['quizupdate'] = 'Actualizar exámenes de Reader';
$string['quizupdated'] = 'Examen actualizado: {$a}';
$string['quizupdateswillbeapplied'] = 'Las actualizaciones del examen serán aplicadas a todos los cursos que actualmente usan en examen.';
$string['quizzes'] = 'Exámenes';
$string['quizzesadd'] = 'Añadir exámenes';
$string['quizzesadded'] = 'Exámenes añadidos';
$string['quizzesarrange'] = 'Arreglar exámenes';
$string['quizzesdelete'] = 'Eliminar exámenes';
$string['quizzesmustbeinstalled'] = 'Los exámenes deben de ser instalados en un curso que está separado del curso en el cual los estudiantes ingresarán cuando tomen exámenes. El curso está oculto de los estudiantes y solamente es usado como área de almacenaje para los exámenes; y normalmente es llamado "All Quizzes"" (Todos Exámenes). El curso que Usted ha establecido para este propósito debería de estar mostrado debajo. Si Usted aun no ha establecido un curso, por favor haga clic en "Crear nuevo curso".';
$string['quizzespassedtable'] = 'Exámenes pasados en  Derecha_a_Izquierda-{$a}';
$string['quizzessetrate'] = 'Configurar tasa de lectura';
$string['quizzesshowhide'] = 'Mostrar/Ocultar exámenes';
$string['quizzesupdate'] = 'Actualizar exámenes';
$string['rate'] = 'Tasa';
$string['rate_help'] = 'La tasa de lectura es especificada como el máximo número de intentos permitidos en exámenes Reader, o el m´´inimo requerido de intentos, dentro de una duración especificada.';
$string['rateaction'] = 'Acción';
$string['rateaction_help'] = 'Esta es la acción que será tomada si la restricción de tasa de lectura es violada. Las acciones siguientes están disponibles:

**Retrasar más  intentos posteriores de exámenes**
: Al estudiante se le impedirá que intente otro examen de Reader hasta que haya caducado el período de  duración.

**Bloquear más intentos de examen**
: El estudiante estará bloqueado de presentar más intentos de examen hasta que el profesor retire el bloqueo.

**Enviar Email al estudiante**
: Será enviado un Email al estudiante informándole de la violación a la tasa.

**Enviar Email al profesor**
: Será enviado un Email al profesor informándole de la violación del estudiante a la tasa.';
$string['rategroup'] = 'Grupo';
$string['rategroup_help'] = 'el grupo al cual aplica esta restricción de tasa';
$string['ratelevel'] = 'Nivel';
$string['ratelevel_help'] = 'el nivel de lectura al cual aplica esta restricción de tasa';
$string['ratemanyconsecutively'] = '{$a->attempts} exámenes consecutivamente';
$string['ratemanyinduration'] = '{$a->attempts} exámenes en {$a->duration}';
$string['rateoneinduration'] = '{$a->attempts} examen en {$a->duration}';
$string['ratetype'] = 'Tipo';
$string['ratetype_help'] = 'Las siguientes tasas de lectura pueden ser especificadas:

**Tasa mínima de intento de examen**
: La tasa mínima a la que los estudiantes pueden intentar exámenes Reader. Si un estudiante no continúa a intentar al menos el número especificado de xámenes dentro de la duración especificada, entonces será tomada la acción especificada.

**Tasa máxima de intento de examen **
: La tasa máxima la que los estudiantes pueden intentar exámenes Reader.  Si un estudiante intenta más que el número de exámenes especificados dentro de la duración eespecificada, entonces será tomada la acción especificada.

**Tasa máxima de reprobación de exámenese**
: La tasa máxima a la que los estudiantes pueden reprobar exámenes Reader. Si un estudiante reprueba más que el número especificado de exámenes dentro de la duración especificada, entonces será tomada la acción especificada.';
$string['ratings'] = 'valuaciones (ratings)';
$string['reader:addinstance'] = 'Añadir una nueva actividad de Lector';
$string['reader:manageattempts'] = 'Gestionar intentos';
$string['reader:managebooks'] = 'Gestionar libros';
$string['reader:manageremotesites'] = 'Gestionar sitios remotos';
$string['reader:managetools'] = 'Gestionar herramientas';
$string['reader:manageusers'] = 'Gestionar usuarios';
$string['reader:viewallbooks'] = 'Ver todos los libros';
$string['reader:viewbooks'] = 'Ver libros';
$string['reader:viewreports'] = 'Ver reportes';
$string['reader:viewversion'] = 'Ver versión';
$string['readerdownload'] = 'Descargar libros (y exámenes) de Lector';
$string['readerid'] = 'ID Reader';
$string['readerquizsettings'] = 'Configuraciones del examen de Lector';
$string['readerreports'] = 'Reportes del módulo Lector (\'\'Reader\'\')';
$string['readinglevel'] = 'Nivel de Lectura';
$string['readinglevelshort'] = 'Derecha_a_Izquierda {$a}';
$string['readingreportfor'] = 'Reporte de Lectura para {$a}';
$string['readonlyfrom'] = 'Solamente-lectura desde';
$string['readonlyfrom_help'] = 'Deespués de esta fecha y hora, los estudiantes pueden ver su página principal de Reader, pero no pueden tomar más exámenes vía esta actividad Reader.';
$string['readonlymode'] = 'Modo lectura-solamente';
$string['readonlymode_desc'] = 'Esta actividad actualmente está en modo de solo-lectura. Usted puede ver la información en la primera página de esta actividad Reader, pero actualmente Usted no puede tomar ningún examen Reader.';
$string['readonlysincedate'] = 'Esta actividad ha estado en modo solamente-lectura desde {$a}.';
$string['readonlyuntil'] = 'Solamente-lectura hasta';
$string['readonlyuntil_help'] = 'Antes de esta fecha y hora, los estudiantes pueden ver sus páginas principales de Reader, pero no pueden tomar ningún examen vía esta actividad reader.';
$string['readonlyuntildate'] = 'Esta actividad permanecerá en modo solamente-lectura hasta {$a}.';
$string['recommendedreadingrates'] = 'Tasas de lectura recomendadas';
$string['redo_upgrade'] = 'Rehacer actualización';
$string['redo_upgrade_desc'] = 'Rehacer una actualización al módulo Reader.';
$string['remotesitenotaccessible'] = 'El sitio de descarga remota no es accesible';
$string['removebook'] = 'Quitar libros';
$string['removebook_help'] = 'Los libros que tienen intentos "vivos" no pueden ser eliminados. Para eeliminar esos libros, Usted primeramente necesita eliminarles sus intentos "vivos".';
$string['removebookerror'] = 'Libro NO fue quitado: {$a}';
$string['removebookinstance'] = 'Quitar libros seleccionados de este curso';
$string['removebooksuccess'] = 'Libro fue quitado: {$a}';
$string['repairmode'] = 'Reparar';
$string['reportbookdetailed'] = 'Libros (completo)';
$string['reportbookratings'] = 'Valuaciones (ratings) de libro';
$string['reportbooksummary'] = 'Libros (resumen)';
$string['reporteditsite'] = 'Libros (todos los datos del libro)';
$string['reportgroupsummary'] = 'Grupos';
$string['reportquiztoreader'] = 'Reporte de Resumen por Estudiante';
$string['reports'] = 'Reportes';
$string['reportsettings'] = 'Configuraciones de Reporte';
$string['reportuserdetailed'] = 'Estudiantes (completo)';
$string['reportusersummary'] = 'Estudiantes (resumen)';
$string['requirepasswordmessage'] = 'Para intentar este examen Usted necesita conocer la contraseña del examen';
$string['requireqtypeordering'] = 'El módulo de actividad Reader no puede ser instalado o actualizado porque falta el tipo de pregunta Ordering (Ordenar). Por favor descargue el tipo de pregunta Ordering, póngalo en {$a}/question/type/ordering, y recargue la página';
$string['restoreattempts'] = 'Restaurar intentos seleccionados';
$string['restoredeletedattempt'] = 'Restaurar intento seleccionado';
$string['restrictlocalhost'] = 'Lo sentimos,; Usted no puede tomar exámenes en mreader.org desde su URL de localhost actual. Por favor cámbiese s una L. Please switch to a <a href="{$a}">URL accesible globalmente</a>.';
$string['returntocoursepage'] = 'Regresar a Página del Curso';
$string['returntoreports'] = 'Regresar a Reportes';
$string['returntostudentlist'] = 'Regresar a Lista de Estudiantes';
$string['review'] = 'Revisar';
$string['reviewthisattempt'] = 'Revisar sus respuestas para este intento';
$string['rowsperpage'] = 'Filas por página';
$string['run_readercron'] = 'Correr cron del Reader';
$string['run_readercron_desc'] = 'Correr el trabajo del cron para el módulo Reader.';
$string['safebrowsererror'] = 'Este examen ha sido configurado de forma tal que los estudiantes solamente pueden intentarlo usando el Navegador de Examen Seguro. Usted no puede intentarlo desde este navegador de Internet.';
$string['safebrowsernotice'] = 'Este examen ha sido configurado de forma tal que los estudiantes solamente pueden intentarlo usando el Navegador de Examen Seguro.';
$string['scanningattempts'] = 'Revisando intentos de exámenes Reader';
$string['search'] = 'Buscar';
$string['search_help'] = 'Para buscar un libro en particular, escriba un poco de texto contenido dentro del título del libro y elija el botón para \'Ir\'';
$string['searchforabook'] = 'Buscar un libro';
$string['sectionname'] = 'Nombre de sección';
$string['sectiontoseparate'] = 'añadir exámenes a secciones separadas por editor y nivel, añadiendo exámenes a las secciones existentes cuando estén disponibles';
$string['sectiontothebottom'] = 'añadir todos los exámenes al final del curso oculto en una nueva sección';
$string['sectiontothissection'] = 'añadir exámenes seleccionados a esta sección';
$string['sectiontypedefault'] = 'La sección(es) por defecto';
$string['sectiontypehidden'] = 'Una sección oculta';
$string['sectiontypelast'] = 'La última sección';
$string['sectiontypenew'] = 'Una nueva sección';
$string['sectiontypevisible'] = 'Una sección visible';
$string['seedetailsbelow'] = 'ver detalles debajo';
$string['select'] = 'Seleccionar';
$string['select_course'] = 'Seleccionar Curso';
$string['select_help'] = 'Elija los tipos de ítems que desea que sean seleccionados en la lista inferior';
$string['selectabook'] = 'Seleccionar un libro';
$string['selectalreadyexist'] = 'Selecionado ya existe';
$string['selectedbookname'] = 'Nombre del libro seleccionado';
$string['selectipmask'] = 'Seleccionar máscara IP';
$string['selectlevel'] = 'Seleccionar nivel';
$string['selectpublisher'] = 'Seleccionar Casa Editorial';
$string['selectseries'] = 'Seleccionar Series';
$string['selectsomeattempts'] = 'Seleccionar uno o más intentos';
$string['selectsomebooks'] = 'Seleccionar uno o más libros';
$string['selectsomerows'] = 'Por favor revise algunas de las cajas en la columna seleccionada.';
$string['selectsomeusers'] = 'Seleccionar uno o más usuarios';
$string['selectthisquiz'] = 'Seleccionar este examen';
$string['sendemailtostudent'] = 'Mandar Email al estudiante';
$string['sendemailtoteacher'] = 'Mandar Email al profesor';
$string['sendmessage'] = 'Enviar mensaje a estudiantes afectados';
$string['sentemailmoodle'] = 'Se ha enviado un Email via Moodle a: {$a->email}';
$string['sentemailphp'] = 'Se ha enviado un Email via PHP mail a: {$a->email}';
$string['sentmessage'] = 'El mensaje se envió exitosamente a {$a} usuario(s)';
$string['separategroups'] = 'Grupos separados';
$string['separatelevels'] = 'Niveles separados';
$string['servererror'] = 'Mensaje del servidor: {$a}';
$string['serverpassword'] = 'Contraseña para exámenes Reader';
$string['serversettings'] = 'Descargar exámenes de Moodle Reader';
$string['serverurl'] = 'URL para exámenes de reader';
$string['serverusername'] = 'Nombre_de_usuario para exámenes Reader';
$string['setallowpromotion'] = 'Cambiar la configuración de la promoción para estudiantes seleccionados';
$string['setbookinstances'] = 'Seleccionar exámenes para hacerlos accesibles a estudiantes';
$string['setcurrentlevel'] = 'Cambiar nivel actual para estudiantes seleccionados';
$string['setdifficulty'] = 'Configurar dificultad del libro';
$string['setgenre'] = 'Configurar género';
$string['setgoal'] = 'Configurar objetivo';
$string['setgoals'] = 'Configurar objetivos';
$string['setgoals_description'] = 'En esta página Usted puede configurar las metas de lectura para estudiantes en niveles específicos de lectura, o en grupos específicos. Tenga en cuenta que las configuraciones para estudiantes individuales en las páginas de reporte anularán las configuraciones de esta página.';
$string['setlevel'] = 'Configurar nivel';
$string['setlevels'] = 'Configurar niveles';
$string['setlevels_description'] = 'En esta página Usted puede configurar los niveles de lectura para grupos de estudiantes. Tenga en cuenta que estas configuraciones sobrescribirán las configuraciones para estudiantes individuales en las páginas de reportes.';
$string['setmessage'] = 'Configurar Mensaje';
$string['setmessagetext'] = 'Texto del mensaje';
$string['setmessagetime'] = 'Mostrar hasta';
$string['setname'] = 'Configurar título de libro';
$string['setpoints'] = 'Configurar valor en puntos';
$string['setpromotiontime'] = 'Cambiar fecha y hora d promoción';
$string['setpublisher'] = 'Configurar casa editorial';
$string['setrates'] = 'Configurar tasas';
$string['setrates_description'] = 'En esta página Usted puede configurar las tasas de lectura para estudiantes en niveles de lectura específicos, o en grupos específicos.';
$string['setreadinggoal'] = 'Configurar objetivo de lectura';
$string['setreadinglevel'] = 'Configurar el nivel de lectura';
$string['setstartlevel'] = 'Cambiar el nivel inicial para estudiantes seleccionados';
$string['setstoplevel'] = 'Cambiar nivel máximo para los estudiantes seleccionados';
$string['settings'] = 'Configuraciones';
$string['setuniformgoalinpoints'] = 'Configurar meta uniforme en puntos';
$string['setuniformgoalinwords'] = 'Configurar meta uniforme en palabras';
$string['setwords'] = 'Configurar número de palabras';
$string['show'] = 'Mostrar';
$string['show_help'] = 'Elija los tipos de ítems que desea que sean mostrados en la lista inferior';
$string['showall'] = 'Mostrar Todo';
$string['showattempts'] = 'Mostrar intentos que coincidan con estas condiciones';
$string['showdeleted'] = 'Mostrar intentos eliminados';
$string['showhidden'] = 'Mostrar libros ocultos';
$string['showhide'] = 'Mostrar/Ocultar';
$string['showhidebook'] = 'Ocultar o mostrar';
$string['showhidebooks'] = 'Actualizar la configuración mostrar/ocultar para libros seleccionados';
$string['showlevel'] = 'Mostrar Nivel';
$string['showpercentgrades'] = 'Mostrar calificaciones en porcentaje';
$string['showpercentgrades_help'] = '**Sí**
: Mostrar la calificación (como un porcentaje) para cada intento de un examen Reader

**No**
: NO mostrar las calificaciones para intentos individales de exámenes Reader';
$string['showpoints'] = 'Mostrar solamente puntos';
$string['showpointsandwordcount'] = 'Mostrar tanto puntaje como número de palabras';
$string['showprogressbar'] = 'Mostrar barra de progreso';
$string['showprogressbar_help'] = '**Sí**
: Mostrar la barra de progreso del número de palabras en la página principal para esta actividad reader

**No**
: NO MOSTRAR la barra de progreso del número de palabras en la página principal para esta actividad reader';
$string['showreviewlinks'] = 'Mostrar enlaces para revisión';
$string['showreviewlinks_help'] = '**Si**
: Añadir enlaces de valores en las páginas de reporte de Reader hacia las páginas de revisión mostrando exactamente como fue contestada cada pregunta en un intento de contestar un examen de Reader.

**No**
: NO añadir enlaces de los valores en las páginas de reporte de Reader a páginas de revisión del examen de Reader.

Esta configuración solamente afecta a profesores. No afecta a estudiantes porque ellos no tieenen acceso a las páginas de reporte de Reader.';
$string['showwordcount'] = 'Mostrar solamente conteo de palabras';
$string['skipline'] = 'Saltar línea: {$a}';
$string['skipped'] = 'Saltada';
$string['skipquizdownload'] = 'El examen "{$a->quizname}" ya existe en la sección {$a->sectionnum}, "{$a->sectionname}", de "{$a->coursename}", y ha sido saltado';
$string['sofar'] = 'hasta aquí';
$string['sort_strings'] = 'Ordenar cadenas de caracteres';
$string['sort_strings_desc'] = 'Ordenar las cadenas de texto usadas por el módulo Reader.';
$string['sortfields'] = 'Ordenar campos';
$string['startbookdetailed'] = 'Actualmente no hay datos disponibles para este reporte.';
$string['startbooksummary'] = 'Actualmente no hay datos disponibles para este reporte.';
$string['startdate'] = 'Fecha de inicio';
$string['starteditcourse'] = '** Comenzar **

En esta página Usted puede editar y quitar libros Reader  que están disponibles en este curso. Usted también puede hacer disponibles nuevos libros en este curso, siempre y cuando ellos ya  hayan sido descargados a este sitio Moodle usando las páginas para descargar.';
$string['starteditsite'] = '** Comenzar **

En esta página Usted puede editar y quitar libros Reader en este sitio Moodle. Para añadir nuevos libros Reader a este sitio, por favor use las páginas para descargar.';
$string['startgroupsummary'] = 'Actualmente no hay datos disponibles para este reporte.';
$string['startlevel'] = 'Iniciar nivel';
$string['startscan'] = 'Iniciar revisión';
$string['startuserdetailed'] = 'Actualmente no hay datos disponibles para este reporte.';
$string['startusersummary'] = 'Actualmente no hay datos disponibles para este reporte.';
$string['stoplevel'] = 'Nivel máximo';
$string['stoplevel_help'] = 'Los estudiantes no pueden ser promovidos automáticamente más allá de este nivel.';
$string['stoplevelforce'] = 'Aplicar este valor a TODOS los usuarios actuales';
$string['strfattempttime'] = '%Y %b %d (%a) %H:%M';
$string['strfattempttimeshort'] = '%Y/%m/%d %H:%M';
$string['strfdateshort'] = '%Y %b %d (%a)';
$string['strfdatetimeshort'] = '%Y %b %d (%a) %H:%M';
$string['strftimeshort'] = '%H:%M';
$string['studentmanagement'] = 'Gestión de Estudiantes';
$string['studentslevels'] = 'Cambiar niveles de Estudiante, Política para Promoción y Metas';
$string['studentuserid'] = 'ID del usuario estudiante';
$string['studentusername'] = 'Nombre_de_usuario del Estudiante';
$string['studentview'] = 'Vista del estudiante';
$string['subnetlength'] = 'Máscara IP';
$string['subnetwrong'] = 'Este examen solamente es accesible desde ciertos lugares, y esta computadora no está en la lista permitida.';
$string['summaryreportbybooktitle'] = 'Reporte Resumido por Título del Libro';
$string['summaryreportbyclassgroup'] = 'Reporte Resumido por Grupo de Clase';
$string['takequizfor'] = 'Tomar el examen para "{$a}"';
$string['takethisquiz'] = 'Tomar este examen';
$string['targetcategory'] = 'Categoría destino';
$string['targetcategory_help'] = 'La categoría del curso que contiene el curso dentro del cual Usted desea descargar los exámenes para los libros seleccionados.';
$string['targetcourse'] = 'Curso destino';
$string['targetcourse_help'] = 'Seleccionar el curso adentro del cual desea descargar los exámenes para los libros seleccionados. Usualmente Usted debería descargarlos a un curso oculto, que solamente se usa para almacenar exámenes usados por el módulo Reader..

Seleccione el tipo de curso de una de las siguientes opciones:

**Todos**
: Elegir de una lista de todos los cursos en este sitio Moodle.

**Oculto**
: Elegir de una lista de cursos que son visibles para Usted pero ocultos para los estudiantes. Usualmente Usted debería de elegir esta opción.

**Visible**
:Elegir de una lista de cursos que son visibles a Usted y a los estudiantes inscritos.

**Actual**
: Los exámenes de Reader serán descargados dentro del curso actual.

**Nuevo**
: Los exámenes de Reader serán descargados dentro de un nuevo curso. Ingrese un nombre para el nuevo curso en la caja de texto.';
$string['targetsection'] = 'Sección destino';
$string['targetsection_help'] = 'Especificar la sección del curso; por ejemplo, la semana o tópico, dentro de la cual Usted desea descargar los exámenes. Los siguientes tipos de sección están disponibles:

**La(s) sección(es) por defecto**
: Los exámenes serán agrupados y colocados en secciones de acuerdo al "Nivel del Publicador (Editor)" de sus libros respectivos.

**Una sección oculta**
: Los exámenes serán puestos dentro de la sección oculta seleccionada del curso.

**Una sección visible**
: Los exámenes serán puestos dentro de la sección visible seleccionada del curso.

**La última sección**
: Los exámenes serán añadidos a la última sección del curso.

**Una sección nueva**
: Los exámenes serán añadidos a una sección nueva. Ingrese un nombre para la sección nueva en la caja de texto.';
$string['termtype'] = 'Período/Semestre';
$string['therehavebeennonewquizzesorupdates'] = 'No se han añadido exámenes nuevos ni actualizaciones al banco de preguntas de MoodleReader desde la vez anterior que lo revisó.';
$string['thisattempt'] = 'este intento';
$string['thisblockunavailable'] = 'Este bloque actualmente no está disponible para este estudiante';
$string['thislevel'] = 'Exámenes al nivel actual';
$string['thislevel_help'] = 'El número de exámenes al nivel de lectura actual que un estudiante debe de pasar para que sea promovido al siguiente nivel de lectura. Tenga en cuenta que solamente los exámenes pasados desde la promoción más reciente cuentan para la siguiente promoción.';
$string['thisterm'] = 'este período (semestre)';
$string['timefinish'] = 'Tiempo terminado';
$string['timeleft'] = 'Tiempo restante';
$string['timestart'] = 'Tiempo iniciado';
$string['to'] = 'hasta';
$string['tools'] = 'Herramientas';
$string['totalpoints'] = 'Total de puntos';
$string['totalpointsallterms'] = 'Puntaje total (todos los períodos)';
$string['totalpointsgoal'] = 'Meta de palabras/puntos';
$string['totalpointsgoal_help'] = 'El número total de palabras/puntos que se espera que acumulen los estudiantes en el período actual.';
$string['totalpointsthisterm'] = 'Puntaje total (este período)';
$string['totalwords'] = 'Total de palabras';
$string['totalwordsallterms'] = 'Total de palabras (todos los períodos)';
$string['totalwordsthisterm'] = 'Total de palabras (este período)';
$string['transferfromcourse'] = 'Transferir desde curso';
$string['type'] = 'Tipo';
$string['type_help'] = 'Seleccione el tipo de libros que quiere que se muestren de la lista inferior:

**Libros con exámenes**
: La página mostrará una lista de libros con exámene sque están disponible spara descargar.

**Libros sin exámenes**
: La página mostrará una lista de libros para los que existen datos como dificultad y número de palabras, pero para los que todavía no se han creado exámenes.';
$string['uniqueip'] = 'Requirir IP única';
$string['update'] = 'Actualizar';
$string['updatecheated'] = 'Actualizar la configuración de trampa para intentos seleccionados';
$string['updatedon'] = 'Actualizado en {$a}';
$string['updatepassed'] = 'Actualizar la configuración aprobado/reprobado para intentos seleccionados';
$string['updatequizzes'] = 'Actualizar exámenes';
$string['updates'] = 'Actualizaciones';
$string['updatesavailable'] = '{$a} actualización(es) disponible(s)';
$string['updatinggrades'] = 'Actualizando calificacioens de Lector';
$string['upgradeoldquizzesinfo'] = 'La actualización ha sido pausada, para que Usted pueda decidir si es que desea o no conservar las versiones antiguas de los exámenes del módulo Reader en este sitio Moodle.

Si Usted selecciona "Si", todos los exámenes Reader antiguos serán conservados. Elija esta opción si desea conservar todas las estadísticas acerca de respuestas a preguntas individuales en exámenes Reader antiguos.

Si Usted selecciona"No", las versiones antiguas duplicadas de exámenes Reader serán eliminadas, dejando solamente la versión más reciente de cada examen. Elija esta opción si Usted no está interesado en las estadísticas respecto a las respuestas a preguntas individuales en exámenes Reader antiguos y si Usted desea arreglar la página de curso de los exámenes Reader.

Tenga en cuenta que si Usted elige "No", los conteos de palabras en las Actividades reader no serán afectados por esta operación.

¿Desea Usted conservar versiones antiguas de exámenes del módulo Reader?';
$string['upgradestalefiles'] = 'Se han detectado versiones mezcladas del módulo Lector, la actualización no puede continuar';
$string['upgradestalefilesinfo'] = 'El proceso de actualización de Reader ha sido pausado porque se han detectado archivos de versiones anteriores del módulo Reader en el directorio "mod/reader".

Esto podría causar problemas más adelante; así es que, para continuar, Usted debe de asegurarse de que el directorio "mod/reader" solamente contenga archivos para una sola versión del módulo Reader.

La forma recomendada para limpiar su directorio "mod/reader" es como sigue:

* quite el  "mod/reader" actual, o al menos muévalo afuera del directorio "mod"
* cree un nuevo directorio "mod/reader" que solamente contenga archivos de, ya sea un ZIP descargado del módulo Reader estándar, o del repositorio Git

Alternativamente, si Usted le da acceso recursivo a la siguiente carpeta "mod/reader", los archivos pueden ser eliminados automáticamente cuando Usted continúe con la actualización:

* {$a->dirpath}

Los archivos de "mod/reader" que actualmente están bloqueando la actualización son:
{$a->filelist}

Si Usted lo prefiere, también puede eliminar los archivos de arriba personalmente.

Haga clic en el botón inferior para continuar con el proceso de actualización de Moodle.';
$string['uploaddatanoquizzes'] = 'Descargar datos para libros que no tienen exámenes';
$string['uploadquiztoreader'] = 'Descargar exámenes desde la BAsedeDatos de Examen de Lector';
$string['use_this_course'] = 'Usar este curso';
$string['usecourse'] = 'Curso de exámenes de Lector';
$string['usecourse_help'] = 'Un curso en este sitio Moodle que contiene los exámenes de Lector para la actividad de Lector. Este curso debería de estar oculto para los estudiantes. Generalmente contiene exámenes que han sido descargados por el módulo de Lector desde un repositorio de exámen de Lector, como por ejemplo moodlereader.net.';
$string['usedefaultquizid'] = 'Siempre usar examen por defecto';
$string['userexport'] = 'Exportar datos de usuario';
$string['userimport'] = 'Importar datos de usuario';
$string['userlevel'] = 'Nivel del usuario';
$string['usernamenotfound'] = 'Nombre_de_usuario no encontrado: {$a}';
$string['users'] = 'Usuarios';
$string['usersallwith'] = 'todoslos usuarios que han intentado al menos un examen';
$string['usersenrolledall'] = 'todos los usuarios inscritos';
$string['usersenrolledwith'] = 'usuarios inscritos que han intentado al menos un examen';
$string['usersenrolledwithout'] = 'usuarios inscritos que no han intentado ni siquiera un examen';
$string['usersetgoals'] = 'Configurar objetivos del usuario';
$string['usersetlevels'] = 'Configurar niveles del usuario';
$string['usersetmessage'] = 'Configurar mensaje para usuarios';
$string['usersexport'] = 'Exportar datos';
$string['usersimport'] = 'Importar datos';
$string['userssetgoals'] = 'Configurar objetivos';
$string['userssetlevels'] = 'Configurar niveles';
$string['userssetmessage'] = 'Configurar mensaje';
$string['usertype'] = 'Usuarios a incluir';
$string['valueoutofrange'] = 'Este valor debería de estar entre {$a->min} y {$a->max}';
$string['viewattempts'] = 'Ver y Eliminar Intentos';
$string['viewlogsuspiciousactivity'] = 'Ver bitácora de actividad sospechosa';
$string['windowclosing'] = 'Esta ventana cerrará prontamente';
$string['withoutdayfilter'] = 'Ssin filtro de día';
$string['words'] = 'Palabras';
$string['wordscount'] = 'Número de palabras';
$string['wordsorpoints'] = 'Mostrar palabras o puntos';
$string['wordsorpoints_help'] = '**Mostrar solamente conteo de palabras**
: En páginas de Reportes, mostrar solamente el número de palabras por intentos.

**Mostrar solamente puntos**
: En páginas de Reportes, mostrar solamente los puntos ganados por intentos.

**Mostrar ambas palabras y puntos**
: En páginas de Reportes, mostrar tanto el número de palabras como los puntos ganados por intentos.';
$string['youcannottake'] = 'Usted NO PUEDE tomar más exámenes al nivel de lectura {$a}';
$string['youcannotwait'] = 'Este examen termina antes de uqe Uted tenga permitido iniciar otro intento.';
$string['youcantakeaquizafter'] = 'Usted puede tomar otro examen después de  {$a}';
$string['youcantakeaquiznow'] = 'Usted puede tomar otro examen ahora';
$string['youcantakeasmanyquizzesasyouwant'] = 'Usted puede tomar cuantos exámenes quiera al Nivel {$a}.';
$string['youcantakeplural'] = 'Usted puede tomar {$a->count} exámenes más al nivel de lectura {$a->level}. Estos libros contarán para su total de lectura, pero no contarán para su promoción.';
$string['youcantakesingle'] = 'Usted puede tomar UN examenmás al nivel de lectura {$a->level}. Este libro contará para su total de lectura, pero no contará para su promoción.';
$string['youcantakeunlimited'] = 'Usted puede tomar cuantos exámenes quiera del nivel de lectura {$a}';
$string['youhavebeenpromoted'] = '¡Felicitaciones!! Usted ha sido promovido al nivel {$a}';
$string['youmustpassplural'] = 'Para ser promovido, Usted necesita pasar {$a->count} exámenes más al nivel de lectura {$a->level}.';
$string['youmustpasssingle'] = 'Para ser promovido, Usted necesita pasar UN examen más al nivel de lectura {$a->level}.';
$string['youmustwait'] = 'Usted necesita esperar antes de que pueda re-intentar este examen. Usted tendrá permitido iniciar otro intento después de {$a}.';
$string['yourcurrentlevel'] = 'Su nivel actual de lectura está configurado a {$a}';
$string['youwerepromoted'] = 'Usted fue promovido al nivel de lectura {$a->level} en {$a->date} a la hora {$a->time}';
