<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_catquiz', language 'es_mx', version '5.1'.
 *
 * @package     local_catquiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abilityinglobalscale'] = 'Capacidad a escala global';
$string['abilityintestedscale'] = 'Puntuación de capacidad en la escala de padres más alta';
$string['abilityintestedscale_before'] = 'Puntuación de capacidad en la escala de padres más alta - antes';
$string['abilityprofile'] = 'Perfil de puntuación de habilidad en “{$a}”';
$string['abilityprofile_title'] = 'Puntaje de habilidad en la prueba';
$string['abortpersonabilitynotchanged'] = 'El parámetro persona no cambió';
$string['acceptedstandarderror'] = 'Error estándar aceptado';
$string['acceptedstandarderror_help'] = 'Si el error estándar de una escala está fuera de este rango, la escala ya no se probará.';
$string['action'] = 'Acción';
$string['activemodel'] = 'Modelo activo';
$string['activitystatussetactive'] = 'Elemento en prueba está ahora activo';
$string['activitystatussetinactive'] = 'Elemento en prueba está ahora inactivo';
$string['add_testitem_to_scale'] = '{$a->testitemlink} añadido a {$a->catscalelink}';
$string['addcategory'] = 'Agregar categoría';
$string['addcontext'] = 'Añadir contexto CAT';
$string['addedrecords'] = 'Se agregaron {$a} registros.';
$string['addoredittemplate'] = 'Agregar o editar plantilla';
$string['addquestion'] = 'Añadir pregunta desde el catálogo';
$string['addtest'] = 'Agregar prueba existente';
$string['addtestitem'] = 'Agregar elementos de prueba';
$string['addtestitembody'] = '¿Desea agregar los siguientes elementos de prueba a la escala CAT actual?';
$string['addtestitemsubmit'] = 'Añadir';
$string['addtestitemtitle'] = 'Añadir elementos de prueba a las escalas CAT';
$string['allquestionscorrect'] = 'No disponible-todas las preguntas fueron respondidas correctamente';
$string['allquestionsincorrect'] = 'No disponible - todas las preguntas fueron respondidas incorrectamente';
$string['applychanges'] = 'Aplicar cambios';
$string['aria:catscaleimage'] = 'Patrón de fondo para esta escala CAT';
$string['assign'] = 'Asignar';
$string['assigntestitemstocatscales'] = 'Asignar elemento de prueba a la escala CAT';
$string['attempt_completed'] = 'Intento completado';
$string['attemptchartstitle'] = 'Número y resultados de intentos en la escala “{$a}”';
$string['attemptclosedbytimelimit'] = 'Intento cerrado automáticamente debido a que se excedió el límite de tiempo';
$string['attemptfeedbacknotavailable'] = 'No hay retroalimentación disponibles';
$string['attemptfeedbacknotyetavailable'] = 'La retroalimentación  sobre los intentos se mostrarán cuando estén disponibles.';
$string['attempts'] = 'Intentos';
$string['attemptscollapsableheading'] = 'Retroalimentación para sus intentos:';
$string['attemptstatus_-1'] = 'Intento aún no completado';
$string['attemptstatus_0'] = 'OK';
$string['attemptstatus_1'] = 'Se ha excedido el stock de artículos';
$string['attemptstatus_2'] = 'ERROR_ELEMENTO_DE_PRUEBA_YA_ESTÁ_EN_ESCALA_RELACIONADA';
$string['attemptstatus_3'] = 'ERROR_AL_OBTENER_SIGUIENTE_PREGUNTA';
$string['attemptstatus_4'] = 'Número máximo de preguntas alcanzado';
$string['attemptstatus_5'] = 'ABORTAR_PERSONABILIDAD_NO_CAMBIADA';
$string['attemptstatus_6'] = 'ERROR_LISTA_DE_PRIMERA_PREGUNTAS_VACÍA';
$string['attemptstatus_7'] = 'ERROR_NO_HAY_ELEMENTOS';
$string['attemptstatus_8'] = 'Tiempo excedido';
$string['autocontextdescription'] = 'Generado automáticamente a través de la importación para la escala CAT {$a}.';
$string['automatic_reload_on_scale_selection'] = 'Recarga de formato en la selección de escala';
$string['automatic_reload_on_scale_selection_description'] = 'Recargar automáticamente el formato de configuración de la prueba en la selección de (sub)escala';
$string['automaticallygeneratedbycron'] = 'Trabajo cron (ejecutado automáticamente)';
$string['averageofallanswers'] = 'Promedio';
$string['backtotable'] = 'Volver a la tabla de descripción general';
$string['breakinfo_backtotest'] = 'Volver a la prueba';
$string['breakinfo_continue'] = 'Puedes continuar la prueba en {$a}';
$string['breakinfo_description'] = 'La prueba fue pausada';
$string['breakinfo_title'] = 'Prueba pausada';
$string['cachedef_adaptivequizattempt'] = 'Intento de prueba adaptativa';
$string['cachedef_catcontexts'] = 'Contextos de catquiz';
$string['cachedef_catscales'] = 'Almacena en caché las escalas CAT de catquiz';
$string['cachedef_eventlogtable'] = 'Bitácoras de eventos';
$string['cachedef_quizattempts'] = 'Intento de examen';
$string['cachedef_studentstatstable'] = 'Datos de los estudiantes en la tabla';
$string['cachedef_testenvironments'] = 'Entornos de prueba';
$string['cachedef_testitemstable'] = 'Datos del elemento de prueba en la tabla';
$string['cachedef_teststrategies'] = 'Estrategias de prueba';
$string['calculate'] = 'Calcular';
$string['calculation_executed'] = 'Cálculo ejecutado.';
$string['calculation_skipped'] = 'El cálculo fue saltado.';
$string['calculations'] = 'Cálculos';
$string['callbackfunctionnotapplied'] = 'No se pudo aplicar la función de devolución de llamada.';
$string['callbackfunctionnotdefined'] = 'La función de devolución de llamada no está definida.';
$string['canbesetto0iflabelgiven'] = 'Puede ser 0 si la coincidencia del elemento de prueba es mediante etiqueta.';
$string['cancelexpiredattempts'] = 'Cancelar intentos que excedan el tiempo máximo';
$string['cannotdeletescalewithchildren'] = 'No se puede eliminar la escala CAT con niños';
$string['catcatscaleprime'] = 'Contenido/Escala';
$string['catcatscaleprime_help'] = 'Seleccione el área de contenido que sea relevante para usted. Las áreas de contenido son creadas y administradas como una escala por un administrador de CAT. Si desea tener su propio contenido y subáreas, comuníquese con el administrador de CAT o con el administrador de su instancia de Moodle.';
$string['catcatscales'] = 'Subescalas de selección';
$string['catcatscales_help'] = 'Seleccione y desmarque las subescalas que sean relevantes para usted. Una subescala incluye preguntas de una parte del área de contenido seleccionada. En un experimento de prueba, solo se utilizan preguntas de las subescalas seleccionadas.';
$string['catcatscales_selectall'] = 'Seleccionar todas las subescalas';
$string['catcontext'] = 'Contexto CAT';
$string['catmanager'] = 'Gestor de CAT';
$string['catmanagernumberofquestions'] = 'Number of questions';
$string['catmanagernumberofsubscales'] = 'Número de subescalas';
$string['catquiz'] = 'Catquiz';
$string['catquiz:canmanage'] = 'Está permitido administrar el plugin Catquiz';
$string['catquiz:manage_catcontexts'] = 'Administrar contextos de Cat';
$string['catquiz:manage_catscales'] = 'Está permitido gestionar las escalas CAT de Catquiz';
$string['catquiz:manage_testenvironments'] = 'Gestionar entornos de prueba';
$string['catquiz:subscribecatscales'] = 'Se permite suscribirse a las escalas CAT de Catquiz';
$string['catquiz:view_teacher_feedback'] = 'Acceder a retroalimentación del profesor';
$string['catquiz:view_users_feedback'] = 'Acceder a retroalimentación de todos los usuarios,no solo del actual.';
$string['catquiz_feedbackheader'] = 'Retroalimentación';
$string['catquiz_left_quote'] = '“';
$string['catquiz_right_quote'] = '”';
$string['catquiz_selectfirstquestion'] = 'En caso contrario iniciar';
$string['catquiz_selectfirstquestion_help'] = 'Durante un intento de prueba, el algoritmo decide, en función de esta configuración, qué criterio se utilizará para seleccionar la primera pregunta que se reproducirá.';
$string['catquiz_selectteststrategy'] = 'Propósito de la prueba';
$string['catquiz_teststrategyheader'] = 'Configuraciones CAT';
$string['catquizfeedback'] = 'Devuelve una descripción general de los últimos intentos de la prueba.';
$string['catquizfeedbackheader'] = 'Retroalimentación sobre “{$a}”';
$string['catquizroledescription'] = 'Gestor de Catquiz';
$string['catquizsettings'] = 'Contenido y contexto de la prueba';
$string['catquizstatistics_askforparams'] = 'Por favor proporcione un parámetro “globalscale” o “courseid”';
$string['catquizstatistics_exportcsv_description'] = 'Como usuario con permiso para descargar exportaciones, aquí puede exportar los resultados de todos los intentos como un archivo CSV';
$string['catquizstatistics_exportcsv_heading'] = 'Exportar datos de intentos seleccionados como CSV';
$string['catquizstatistics_h1_global'] = 'Estadísticas de escala {$a} en la instancia de Moodle';
$string['catquizstatistics_h1_scale'] = 'Estadísticas para la escala {$a->scalename} en el curso {$a->coursename}.';
$string['catquizstatistics_h1_single'] = 'Estadísticas para la prueba {$a}';
$string['catquizstatistics_h2_global'] = 'Los siguientes datos son de todos los usuarios que participaron en pruebas en esta instancia de Moodle usando la escala {$a} como escala principal.';
$string['catquizstatistics_h2_scale'] = 'Los siguientes datos son de las pruebas {$a->linkedcourses} del curso {$a->coursename}. Utilizan la escala {$a->scale}.';
$string['catquizstatistics_h2_single'] = 'Los siguientes datos son de la prueba {$a->link} que utiliza la escala {$a->scale}.';
$string['catquizstatistics_nodataforcourse'] = 'No hay pruebas CAT para el curso dado';
$string['catquizstatistics_numattempts_title'] = 'Número de intentos';
$string['catquizstatistics_numattemptsperperson_title'] = 'Intentos por persona';
$string['catquizstatistics_numberofresponses'] = 'Número de respuestas';
$string['catquizstatistics_overview'] = 'Descripción general';
$string['catquizstatistics_progress_peers_title'] = 'Resultado promedio de sus pares en la escala “{$a}”';
$string['catquizstatistics_progress_personal_title'] = 'Your personal results for that scale';
$string['catquizstatistics_scale_course_conflict'] = 'El testid dado no es parte del curso dado';
$string['catquizstatistics_scale_testid_conflict'] = 'La prueba para el testid dado no utiliza la escala proporcionada';
$string['catquizstatistics_testusage'] = 'Uso de la prueba';
$string['catquizstatistics_timerange_both'] = 'Sólo se utilizan los datos entre {$a->starttime} y {$a->endtime}.';
$string['catquizstatistics_timerange_end'] = 'Sólo se utilizan los datos anteriores a {$a->endtime}.';
$string['catquizstatistics_timerange_start'] = 'Sólo se utilizan los datos posteriores a {$a->starttime}.';
$string['catquizstatisticsnodata'] = 'No hay datos de intentos disponibles para la configuración dada';
$string['catscale'] = 'Escala CAT';
$string['catscale_created'] = 'Escala CAT creada';
$string['catscale_updated'] = 'Escala CAT actualizada';
$string['catscaleid'] = 'ID de Escala CAT';
$string['catscaleidnotmatching'] = 'No se encontró la escala con id {$a->catscaleid} en la base de datos. No se importó el elemento correspondiente.';
$string['catscales'] = 'Definir las escalas CAT de Catquiz';
$string['catscales:information'] = 'Definir escalas CAT: {$a->link}';
$string['catscalesheading'] = 'Escalas CAT';
$string['catscalesname_exists'] = 'El nombre ya está siendo utilizado';
$string['catscaleupdatedtitle'] = 'A CAT scale was updated';
$string['cattags'] = 'Administrar etiquetas de cursos';
$string['cattags:information'] = 'Estas etiquetas identifican los cursos en los que los profesores pueden inscribir a los estudiantes, independientemente de si son parte del curso.';
$string['chart_detectedscales_title'] = 'Escalas detectadas ({$a} superiores)';
$string['chartlegendabilityrelative'] = '{$a->difference} (en comparación con la escala paterna); {$a->ability} (puntuación de capacidad de la escala)';
$string['checkdelimiter'] = 'Activar si los datos están separados mediante el símbolo seleccionado.';
$string['checkdelimiteroremptycontent'] = 'Activar si los datos se proporcionan y se separan mediante el símbolo seleccionado.';
$string['checklinking'] = 'Comprobar enlazado';
$string['choosecontextid'] = 'Elegir contexto CAT';
$string['chooseparent'] = 'Elegir escala paterna';
$string['choosesubscaleforfeedback'] = 'Seleccionar una subescala';
$string['choosesubscaleforfeedback_help'] = 'Ahora puede almacenar <número de opciones> de información de retroalimentación para las subescalas mostradas. Seleccione una (sub)escala para ingresar su retroalimentación. Los símbolos de colores indican el estado actual del procesamiento, medido por la cantidad de opciones de retroalimentación que ingresó:
   gris: aún no se ha almacenado ninguna retroalimentación en la subescala
   amarillo: todavía no se han completado algunas opciones de retroalimentación
   verde: retroalimentación depositada completamente';
$string['choosesubscaleforfeedback_text'] = '';
$string['choosetags'] = 'Seleccionar etiqueta(s)';
$string['choosetags:disclaimer'] = 'Selección múltiple con la tecla “⌘ command” (apple) o “Ctrl” (windows, linux)';
$string['choosetemplate'] = 'Elija un entorno de prueba';
$string['classicalcat'] = 'Prueba clásica';
$string['close'] = 'Cerrar';
$string['cogwheeltitle'] = 'Mostrar detalles';
$string['color_1_code'] = '#ff0000';
$string['color_1_name'] = 'Rojo';
$string['color_2_code'] = '#000000';
$string['color_2_name'] = 'Negro';
$string['color_3_code'] = '#8b0000';
$string['color_3_name'] = 'Rojo oscuro';
$string['color_4_code'] = '#ffa500';
$string['color_4_name'] = 'Naranja';
$string['color_5_code'] = '#ffff00';
$string['color_5_name'] = 'Amarillo';
$string['color_6_code'] = '#90ee90';
$string['color_6_name'] = 'Verde claro';
$string['color_7_code'] = '#006400';
$string['color_7_name'] = 'Verde oscuro';
$string['color_8_code'] = '#e8e9eb';
$string['color_8_name'] = 'Blanco';
$string['comparetotestaverage'] = 'Descripción general';
$string['complete_attempt_description'] = 'Intento con id {$a->attemptid} en la escala CAT {$a->catscalelink} completado por el usuario {$a->userid}.';
$string['component'] = 'Plugin';
$string['confirmactivitychange'] = 'Estás a punto de cambiar el estado de actividad del siguiente elemento: <br> “{$a->data}”';
$string['confirmdeletion'] = 'Estás a punto de eliminar el siguiente elemento: <br> “{$a->data}”';
$string['context_created'] = 'Contexto CAT creado.';
$string['context_updated'] = 'Contexto CAT actualizado';
$string['contextidselect'] = 'Contexto CAT - sin selección se crea el contexto predeterminado';
$string['copysettingsforallsubscales'] = 'Aplicar valores a subescalas dadas';
$string['courseenrolementstring'] = 'Gracias a los resultados de su examen, ahora usted está inscrito en curso(s) {$a}. Buena suerte con sus estudios.';
$string['courseselection'] = 'Curso seleccionado';
$string['create_catscale_description'] = 'Se creó la escala CAT {$a->catscalelink} con id {$a->objectid}


88888888880';
$string['create_context_description'] = 'Contexto CAT {$a} creado.';
$string['createcatscale'] = 'Crear una escala CAT';
$string['createnewcatscale'] = 'Crear nueva escala CAT';
$string['csvexportheader:attemptduration'] = 'Duración';
$string['csvexportheader:attemptend'] = 'FIn del Tiempo';
$string['csvexportheader:attemptid'] = 'ID-intento';
$string['csvexportheader:attemptquestionno'] = 'Núm. de Preguntas';
$string['csvexportheader:attemptstart'] = 'Hora de Inicio';
$string['csvexportheader:attemptstatus'] = 'Estado';
$string['csvexportheader:resultppdetail'] = 'Capacidad en Capacidad en Escala de Detalle';
$string['csvexportheader:resultppglobal'] = 'Capacidad en Escala Global';
$string['csvexportheader:resultscaledetail'] = 'Escala de Detalle [según Estrategia]';
$string['csvexportheader:resultscaleglobal'] = 'Escala Global';
$string['csvexportheader:resultsedetail'] = 'SE en Escala de Detalle';
$string['csvexportheader:resultseglobal'] = 'SE en Escala Global';
$string['csvexportheader:testid'] = 'ID-Prueba';
$string['csvexportheader:teststrategy'] = 'Estrategia de Prueba';
$string['csvexportheader:useremail'] = 'E-mail del usuario';
$string['csvexportheader:userid'] = 'ID del usuario';
$string['csvexportheader:username'] = 'Nombre del Usuario';
$string['currentability'] = 'Tu puntaje de habilidad';
$string['currentabilityfellowstudents'] = 'Promedio';
$string['dataincomplete'] = 'El registro con el id de componente {$a->id} está incompleto y no se pudo procesar en su totalidad. Verifique el campo “{$a->field}”.';
$string['dateparseformat'] = 'Date parse format';
$string['dateparseformat_help'] = 'Utilice el formato de fecha especificado en su archivo CSV (j.n.Y H:i:s). Más información en <a href="http://php.net/manual/en/function.date.php">ese recurso</a>.';
$string['daysago'] = 'Hace {$a} días';
$string['debuginfo_desc'] = 'Como usuario con permiso para exportar intentos, puede descargar el intento como archivo CSV aquí';
$string['debuginfo_desc_title'] = 'Exportar intento # {$a}';
$string['defaultcontext'] = 'Nuevo contexto predeterminado para la escala';
$string['defaultcontextdescription'] = 'Incluye todos los elementos de prueba.';
$string['defaultcontextname'] = 'Contexto CAT predeterminado';
$string['deletedatatitle'] = 'Eliminar';
$string['deletedcatscale'] = 'catscale que ya no existe';
$string['detected_scales_ability'] = 'Puntaje de habilidad';
$string['detected_scales_chart_description'] = 'El siguiente gráfico muestra los valores en comparación con su puntaje de habilidad en {$a}. Haga clic en la barra para ver el nombre y el valor de la escala';
$string['detected_scales_number_questions'] = 'Preguntas jugadas';
$string['detected_scales_reference'] = 'Escala de referencia';
$string['detected_scales_scalename'] = 'Escala';
$string['difficulties'] = 'Dificultades';
$string['difficulty'] = 'Dificultad';
$string['difficulty_next_easier'] = 'Siguiente pregunta más difícil';
$string['difficulty_next_more_difficult'] = 'Siguiente pregunta más fácil';
$string['disclaimer:numberoffeedbackchange'] = 'Los cambios pueden requerir un ajuste del contenido de la retroalimentación.';
$string['discrimination'] = 'Discriminación';
$string['documentation'] = 'Documentación';
$string['downloaddemofile'] = 'Descargar archivo DEMO';
$string['edititemparams'] = 'Editar paráms del elemento';
$string['edittestenvironment'] = 'Editar entorno de prueba';
$string['emptyfirstquestionlist'] = 'No puedo seleccionar una pregunta de inicio porque la lista está vacía';
$string['endtime'] = 'Fin';
$string['endtimestamp'] = 'Hora de fin';
$string['enrol_only_to_reported_scales'] = 'Inscribir a los usuarios únicamente en cursos de la(s) escala(s) primaria(s) detectada(s).';
$string['enrol_only_to_reported_scales_help'] = 'El estándar sería inscribir a los usuarios según los resultados en las áreas detectadas según el propósito de la prueba.
Si desactiva esta opción, los usuarios también se inscribirán según todos los demás resultados válidos.';
$string['enrolementstringend'] = '¡Buena suerte con sus estudios!';
$string['enrolementstringstart'] = 'En base a sus resultados en la prueba {$a->testname} en el curso {$a->coursename}, ahora está...<br>';
$string['enrolementstringstartforfeedback'] = 'En base a sus resultados ahora está...<br>';
$string['enrolled_courses'] = 'Cursos inscritos';
$string['enrolmentmessagetitle'] = 'Notificación sobre nuevas inscripciones a cursos/grupos';
$string['error'] = 'Ocurrió un error';
$string['error:fraction0'] = 'Lamentablemente, no pudimos determinar un resultado válido en función de sus respuestas. Le agradeceríamos que lo intentara nuevamente.';
$string['error:fraction1'] = '¡Felicitaciones! ¡Ha respondido todas las preguntas correctamente! ¡Es realmente fantástico!
   Sin embargo, debido a este excelente desempeño, no pudimos determinar un resultado concluyente.';
$string['error:minmaxrangeequal'] = 'Hay un error en la entrada de la base de datos: Los límites mínimo y máximo de la escala son los mismos.
   Por favor, informe este problema al administrador de CAT, especificando la prueba que está utilizando y solicitándole que corrija la información sobre los límites de la escala.';
$string['error:nminscale'] = 'Lamentablemente, no pudimos determinar un resultado porque no se respondieron suficientes preguntas durante el intento de prueba. Asegúrese de responder todas las preguntas en su próximo intento para obtener un resultado correcto.';
$string['error:noscalestoreport'] = 'Lamentablemente, con la cantidad actual de preguntas realizadas en las áreas evaluadas, no pudimos determinar un resultado confiable. Le recomendamos que se comunique con los responsables de la prueba y les solicite que aumenten el número de preguntas a responder.';
$string['error:permissionforcsvdownload'] = 'Usted no tiene el permiso necesario ({$a}) para descargar la información solicitada.';
$string['error:rootonly'] = '';
$string['error:semax'] = 'Lamentablemente, no pudimos determinar un resultado con la precisión mínima especificada en las áreas evaluadas.
Le recomendamos que se comunique con los responsables de la prueba y les solicite que aumenten el número de preguntas a responder.';
$string['error:semin'] = '';
$string['errorfetchnextquestion'] = 'Hubo un error al seleccionar la siguiente pregunta';
$string['errorhastobefloat'] = 'Has to be a decimal';
$string['errorhastobeint'] = 'Tiene que ser un número entero';
$string['errorminscalevalue'] = 'El valor mínimo debe ser menor que el valor máximo';
$string['errornoitems'] = 'No se puede iniciar el examen con la configuración indicada. Comuníquese con el administrador de CAT.';
$string['errorrecordnotfound'] = 'Se produjo un error en la consulta de la base de datos. No se encontró el registro.';
$string['errorupperlimitvalue'] = 'El valor del límite superior debe ser mayor que el valor del límite inferior';
$string['estimatedbecause:allanswerscorrect'] = '¡Felicitaciones! ¡Respondió todas las preguntas correctamente! Lamentablemente, sus resultados no se pudieron calcular de manera confiable y fueron estimados.';
$string['estimatedbecause:allanswersincorrect'] = 'No se pudieron calcular de manera confiable sus resultados y fueron estimados porque usted respondió incorrectamente todas las preguntas.';
$string['estimatedbecause:default'] = 'No se pudieron calcular de manera confiable sus resultados y fueron estimados.';
$string['eventname'] = 'Nombre del evento';
$string['eventtime'] = 'Hora del evento';
$string['exceededmaxattempttime'] = 'Se ha excedido el tiempo máximo de intento.';
$string['executed_calculation_description'] = '{$a->user} ejecutó un cálculo de la escala CAT {$a->catscalename} con id {$a->catscaleid} en el contexto {$a->contextid}. En los siguientes modelos, se recalcularon los elementos: {$a->updatedmodels}';
$string['eyeicontitle'] = 'Activar/Deshabilitar';
$string['failedtoaddmultipleitems'] = '{$a->numadded} preguntas agregadas exitosamente, fallaron con {$a->numfailed} preguntas: {$a->failedids}';
$string['feedback_colorrange'] = 'Gama de colores de una escala de retroalimentación';
$string['feedback_customscale_nofeedback'] = 'No se proporcionó retroalimentación sobre los resultados de su prueba.';
$string['feedback_details_description'] = 'La siguiente tabla enumera todos los aspectos (escalas) de {$a} para los que se pudo calcular un resultado confiable.';
$string['feedback_details_heading'] = 'Detalles de su resultado';
$string['feedback_details_lowestskill'] = 'Se encontró que la escala {$a->name} con un puntaje de capacidad de {$a->value} (± {$a->se}) era la escala con el mayor déficit.';
$string['feedback_tab_clicked'] = 'Haga clic en la pestaña de retroalimentación';
$string['feedback_tab_clicked_description'] = 'El usuario {$a->userid} hizo clic en la pestaña “{$a->feedback_translated}” en {$a->attemptlink}';
$string['feedback_table_answercorrect'] = 'correcto';
$string['feedback_table_answerincorrect'] = 'incorrecto';
$string['feedback_table_answerpartlycorrect'] = 'parcialmente correcto';
$string['feedback_table_questionnumber'] = '#';
$string['feedbackbarlegend'] = 'Código de color';
$string['feedbackcomparetoaverage'] = '<p>La prueba mide ts habilidad en {$a->quotedscale} calculando una puntuación de habilidad en el rango entre {$a->scale_min} y {$a->scale_max}. Un valor más alto indica una mejor habilidad.</p>
<p>Usted ha alcanzado una puntuación de {$a->ability_global} (con un error estándar de ± {$a->se_global}). La puntuación media de todos los participantes es {$a->average_ability}. {$a->betterthan}</p>
<p>El siguiente gráfico muestra su puntuación personal (marca superior) y la puntuación media actual (marca inferior):</p>';
$string['feedbackcomparison_betterthan'] = 'Su puntaje es mejor que el {$a->quantile}% de todos los demás participantes.';
$string['feedbackcompletedentirely'] = 'Toda la retroalimentación completada para esta escala.';
$string['feedbackcompletedpartially'] = '{$a} retroalimentaciones de esta escala completadas.';
$string['feedbacklegend'] = 'LA retroalimentación  se mostrarán en la leyenda de la barra de color';
$string['feedbacknumber'] = 'Retroalimentación para rango {$a}';
$string['feedbackrange'] = 'Nivel de habilidad {$a}';
$string['feedbacksheader'] = 'Intento {$a}';
$string['fieldnamesdontmatch'] = 'Los nombres de campo importados no coinciden con los nombres de campo definidos.';
$string['firstquestion_startnewtest'] = 'Iniciar nueva prueba';
$string['firstquestionreuseexistingdata'] = 'utilizando resultados anteriores del usuario';
$string['firstquestionselectotherwise'] = '...en caso contrario:';
$string['fisherinformation'] = 'Información de Fisher';
$string['followingcourses'] = 'inscrito en el siguiente curso(s):<br>';
$string['followinggroups'] = 'Miembro de siguiente grupo(s):<br>';
$string['force'] = 'Forzar valores';
$string['format'] = 'formato';
$string['formelementbetweenzeroandone'] = 'Por favor introduzca valores entre 0 y 1.';
$string['formelementnegative'] = 'Ingrese un número positivo';
$string['formelementnegativefloat'] = 'Ingrese un número decimal negativo';
$string['formelementnegativefloatwithdefault'] = 'Ingrese un número decimal negativo. El valor predeterminado sería {$a}.';
$string['formelementpositivefloat'] = 'Ingrese un número decimal positivo';
$string['formelementpositivefloatwithdefault'] = 'Ingrese un número decimal positivo. El valor predeterminado sería {$a}.';
$string['formelementwrongpercent'] = 'Introduzca un número del 0 al 100';
$string['formetimelimitnotprovided'] = 'Introduzca al menos un valor de límite de tiempo';
$string['formminquestgreaterthan'] = 'El mínimo debe ser menor que el máximo';
$string['formmscalegreaterthantest'] = 'El mínimo por escala debe ser menor que el máximo por prueba';
$string['fraction'] = 'Fracción';
$string['genericsubmit'] = 'Confirmar';
$string['global_scale'] = 'Escala global';
$string['graphicalsummary_description'] = 'Durante un intento, su habilidad se vuelve a calcular después de cada respuesta. El siguiente gráfico muestra cómo cambió su habilidad estimada en “{$a}”';
$string['graphicalsummary_description_lowest'] = 'Además, el desarrollo de su puntuación de capacidad con respecto a la escala,
que se ha identificado como una deficiencia:';
$string['greateststrenght:tooltiptitle'] = 'su escala más fuerte {$a}';
$string['groupenrolementstring'] = '“{$a->groupname}” en el curso “<a href="{$a->courseurl}">{$a->coursename}</a>”';
$string['groupenrolmenthelptext'] = 'Ingrese el nombre exacto del grupo existente (es decir, “grupo1,grupo2” o “grupo3”).';
$string['groupenrolmenthelptext_help'] = 'Ingrese el nombre exacto del grupo existente (es decir, “grupo1,grupo2” o “grupo3”).';
$string['guessing'] = 'Adivinando';
$string['hasability'] = 'La capacidad fue calculada';
$string['healthstatus'] = 'Estado de salud';
$string['hoursago'] = 'Hace {$a} horas';
$string['id'] = 'ID';
$string['ifdefinedusedtomatch'] = 'Si se define, se utilizará para hacer coincidir.';
$string['importcolumnsinfos'] = 'Información sobre las columnas a importar:';
$string['importcontextinfo'] = 'El ID de contexto debe establecerse cuando se actualizan los elementos existentes para que coincidan de forma inequívoca con los elementos existentes. Al importar elementos nuevos, es recomendable dejar el campo de contexto vacío. A continuación, se genera automáticamente un nuevo contexto, que contiene los elementos del contexto predeterminado más los elementos recién importados. Si se define un contexto al importar elementos nuevos, se debe cambiar el contexto de la escala superior correspondiente (en el panel de control de CAT Manager, área Escalas) para poder utilizar estos elementos durante el cuestionario.';
$string['importcsv'] = 'Importar CSV';
$string['imported_testitem_description'] = '{$a} elementos de prueba fueron importados.';
$string['importfailed'] = 'Falló la importación';
$string['importsuccess'] = 'La importación fue exitosa. {$a} registro(s) tratados.';
$string['includepilotquestions'] = 'Activar modo piloto';
$string['includepilotquestions_help'] = 'En el modo piloto, se añaden a los tests preguntas cuyos parámetros (p. ej. dificultad, capacidad de adivinación) aún no se han determinado. Estos no influyen en el resultado del test. Los datos generados por el procesamiento pueden ser evaluados estadísticamente posteriormente por un gestor de CAT para determinar los parámetros de las preguntas.';
$string['includetimelimit'] = 'Tiempo límite para el intento';
$string['includetimelimit_help'] = 'Define una duración máxima para que un intento sea finalizado.';
$string['inferallsubscales'] = 'Inferir todas las subescalas';
$string['infergreateststrength'] = 'Inferir la mayor fortaleza';
$string['inferlowestskillgap'] = 'Inferir la brecha de habilidades más baja';
$string['instance'] = 'Prueba';
$string['integratequestions'] = 'Integrar preguntas de subescalas';
$string['intercepts'] = 'Intercepto';
$string['invisible'] = 'Invisible';
$string['itemassignedtoparentorsubscale'] = 'El registro con componentid {$a->componentid} ya está asignado a una escala principal o secundaria de {$a->newscalename} y no se importó.';
$string['itemassignedtosecondscale'] = 'El registro con componentid {$a->componentid} ya está asignado a la escala {$a->scalelink}, ahora también está asignado a {$a->newscalename}.';
$string['itemdifficulties'] = 'Dificultades del elemento';
$string['itemdifficultiesnodata'] = 'No se calcularon dificultades del elemento';
$string['itemdifficulty'] = 'Dificultad del elemento';
$string['itemsplayed'] = 'elementos evaluados';
$string['itemstatus_-5'] = 'Manualmente excluido';
$string['itemstatus_0'] = 'Aun no calculado';
$string['itemstatus_1'] = 'Calculado';
$string['itemstatus_4'] = 'Actualizado manualmente';
$string['itemstatus_5'] = 'Manualmente confirmado';
$string['jsoninformation'] = 'Información adicional para el modelo indicado';
$string['label'] = 'Etiqueta';
$string['labelforrelativepersonabilitychart'] = 'Habilidad relativa';
$string['labelidnotfound'] = 'Etiqueta “{$a}” no encontrada.';
$string['labelidnotunique'] = 'Etiqueta “{$a}” no es única.';
$string['lang'] = 'Idioma';
$string['lastattempttime'] = 'Último intento';
$string['learningprogress_description'] = '¿Cómo cambió su puntuación de habilidad con el tiempo? ¿Mejoraste?<br/>El siguiente gráfico muestra el progreso de su puntuación de habilidad (general) en “{$a}” en comparación con el promedio de todos los intentos de prueba:';
$string['learningprogresstitle'] = 'Su Progreso';
$string['likelihood'] = 'Probabilidad';
$string['local_catquiz_toggle_testitemstatus_message'] = 'El estado del elemento de prueba fue actualizado';
$string['logsafter'] = 'Bitácoras posteriores';
$string['logsbefore'] = 'Bitácoras anteriores';
$string['lowerlimit'] = 'Límite inferior';
$string['lowestskill:tooltiptitle'] = 'su escala más baja “{$a}”';
$string['manage_catcontexts'] = 'Administrar contextos CAT';
$string['managecatcontexts'] = 'Administrar contextos CAT';
$string['managecatscale'] = 'Administrar escala CAT';
$string['managecatscales'] = 'Administrar escalas CAT';
$string['managetestenvironments'] = 'Gestionar entornos de prueba';
$string['mandatory'] = 'obligatorio';
$string['max'] = 'máx:';
$string['max_iterations'] = 'Número máximo de iteraciones';
$string['maxabilityscalevalue'] = 'Capacidad máxima de la persona:';
$string['maxabilityscalevalue_help'] = 'Introduzca la capacidad personal más alta posible de esta escala como valor decimal positivo. La media es cero.';
$string['maxattemptduration'] = 'La duración máxima de los intentos';
$string['maxattemptduration_desc'] = 'Los intentos más antiguos que esto se marcarán como completados. Un valor de 0 significa que no hay límite. Este valor se puede sobrescribir con la configuración del examen.';
$string['maxquestionspersubscale'] = 'Número máximo de preguntas devueltas por subescala';
$string['maxquestionspersubscale_help'] = 'Cuando se devuelve esta cantidad de preguntas para cualquier subescala, no se mostrarán más preguntas de esta escala. Un valor de 0 significa que no hay límite.';
$string['maxscalevalue'] = 'Valor máximo';
$string['maxscalevalueinformation'] = 'Introduzca la capacidad personal más alta posible de esta escala como un valor decimal positivo. La media es cero. Solo se establecerá al crear una nueva escala raíz y luego se aplicará a todas las subescalas. Para ello, defina los valores (al menos) en el primer conjunto de datos. Los valores de las escalas existentes no se pueden cambiar mediante la importación. Si desea cambiar los valores de una escala existente, cambie a la pestaña "Escalas".';
$string['maxtime'] = 'Tiempo máximo para la prueba';
$string['maxtimeperitem'] = 'Tiempo máximo por pregunta en segundos';
$string['maxtimeperquestion'] = 'Tiempo máximo';
$string['maxtimeperquestion_help'] = 'Si el usuario tarda más tiempo en responder una pregunta, se forzará una pausa.';
$string['messageprovider:catscaleupdate'] = 'Notificación de actualización de la escala CAT';
$string['messageprovider:enrolmentfeedback'] = 'Inscripción automática a cursos y grupos.';
$string['messageprovider:updatecatscale'] = 'Recibir notificación sobre la suscripción de la escala CAT';
$string['min'] = 'mín:';
$string['minabilityscalevalue'] = 'Capacidad mínima de la persona:';
$string['minabilityscalevalue_help'] = 'Introduzca la capacidad personal más baja posible de esta escala como valor decimal negativo. La media es cero.';
$string['minquestions_default_desc'] = 'Este valor se establecerá de forma predeterminada, pero se puede sobrescribir en la configuración de la prueba.';
$string['minquestions_default_name'] = 'Mínimo predeterminado de preguntas por intento de prueba';
$string['minquestionsnotreached'] = 'No se puede calcular el resultado de la prueba porque no se alcanzó el número mínimo de preguntas';
$string['minquestionspersubscale'] = 'Número mínimo de preguntas devueltas por subescala';
$string['minquestionspersubscale_help'] = 'Las preguntas de una subescala se excluirán solo si se muestra al menos el número mínimo de preguntas.';
$string['minscalevalue'] = 'Valor mínimo';
$string['minscalevalueinformation'] = 'Introduzca la capacidad personal más baja posible de esta escala como un valor decimal negativo. La media es cero. Solo se establecerá al crear una nueva escala raíz y luego se aplicará a todas las subescalas. Para ello, defina los valores (al menos) en el primer conjunto de datos. Los valores de las escalas existentes no se pueden cambiar mediante la importación. Si desea cambiar los valores de una escala existente, cambie a la pestaña "Escalas".';
$string['mintimeperitem'] = 'Tiempo mínimo por pregunta en segundos';
$string['missinglabel'] = 'El CSV importado no contiene la columna obligatoria {$a}. No se pueden importar los datos.';
$string['model'] = 'Modelo';
$string['model_override'] = 'Usar  únicamente este modelo';
$string['modeldeactivated'] = 'Desactivar motor CAT';
$string['modelinformation'] = 'Este campo es necesario para el tratamiento completo del registro. Si está vacío, el ítem solo podrá asignarse a la escala CAT.';
$string['models'] = 'Modelos';
$string['moreinformation'] = 'Más información';
$string['moveitemtootherscale'] = 'Los elementos de prueba {$a} ya están asignados a otra (sub)escala del mismo árbol. ¿Modificar la asignación?';
$string['name'] = 'Nombre';
$string['nameexists'] = 'El nombre de la escala CAT ya existe';
$string['newcustomtest'] = 'Prueba personalizada';
$string['noaccessyet'] = 'Sin acceso todavía';
$string['noedit'] = 'Finalizar edición';
$string['nofeedback'] = 'Sin retroalimentación definida';
$string['nogapallowed'] = 'No se permite ningún espacio en el rango de retroalimentación. Asegúrese de que el límite superior del rango anterior sea equivalente al límite inferior del siguiente rango.';
$string['noint'] = 'Por favor, introduzca un número entero';
$string['nolabels'] = 'No hay etiquetas de columna definidas en el objeto de configuración.';
$string['noparentsgiven'] = 'Los elementos para la escala {$a->catscalename} no se pueden localizar porque no hay escalas paternas proporcionadas.';
$string['norecordsfound'] = 'No hay preguntas en esta escala.';
$string['noremainingquestions'] = 'Se quedó sin preguntas';
$string['noresponsestoestimate'] = 'No hay suficientes respuestas para actualizar los parámetros.';
$string['noresponsestoestimatedesc'] = '{$a->reason} Escala: {$a->scalename}, Contexto: {$a->contextname}.';
$string['noresult'] = 'No se calculó ninguna habilidad';
$string['noscaleselected'] = 'No se ha seleccionado ninguna escala';
$string['noscalesfound'] = 'No se pudo generar ninguna retroalimentación válida.';
$string['noselection'] = 'Sin selección';
$string['nothingtocompare'] = 'No hay suficientes resultados válidos disponibles para una comparación.';
$string['notificationcatscalechange'] = 'Hola {$a->firstname} {$a->lastname},
Las escalas CAT han cambiado en la plataforma Moodle {$a->instancename}.
Este correo electrónico le informa a usted, como administrador CAT* responsable de esas escalas CAT, sobre estos cambios. {$a->editorname} realizó los siguientes cambios en la escala CAT “{$a->catscalename}”:
{$a->changedescription}
Puede revisar el estado actual aquí: {$a->linkonscale}';
$string['notifyallteachers'] = 'Notificar a todos los maestros';
$string['notifyteachersofselectedcourses'] = 'Notificar a los profesores sobre los cursos seleccionados';
$string['notimelimit'] = 'Sin límite de tiempo';
$string['notpositive'] = 'Por favor, introduzca un número positivo';
$string['notyetattempted'] = 'Sin intentos';
$string['notyetcalculated'] = 'Aún no calculado';
$string['numberofanswers'] = 'Respuestas totales';
$string['numberofanswerscorrect'] = 'Correcto';
$string['numberofanswersincorrect'] = 'Incorrecto';
$string['numberofanswerspartlycorrect'] = 'Parcialmente correcto';
$string['numberofattempts'] = 'Número de intentos';
$string['numberoffeedbackoptionpersubscale'] = 'Número de rangos de habilidad';
$string['numberoffeedbackoptionpersubscale_help'] = 'Seleccione cuántas opciones de retroalimentación necesita por subescala. Con las opciones de retroalimentación, puede proporcionar retroalimentación escrita calificada según la puntuación de capacidad identificada e inscribirse en diferentes cursos o grupos.';
$string['numberofpersonsanswered'] = 'Por diferentes personas';
$string['numberofquestions'] = '# preguntas';
$string['numberofquestionsperscale'] = 'Número de preguntas por escala';
$string['numberofquestionsperscale_help'] = 'Establezca el valor máximo en 0 para reproducir el intento de prueba sin límite.';
$string['numberofquestionspertest'] = 'Número de preguntas por prueba';
$string['numberofquestionspertest_help'] = 'Establezca el valor máximo en 0 para reproducir el intento de prueba sin límite.';
$string['numberoftestitemsused'] = 'Number of displayed questions';
$string['numberofusagesintests'] = 'En pruebas';
$string['numberofusers'] = '# usuarios';
$string['onecourseenroled'] = 'Debido a los resultados de su prueba en “{$a->catscalename}”, ahora está inscrito en el curso “<a href="{$a->courseurl}">{$a->coursename}</a>”.';
$string['onegroupenroled'] = 'Debido a los resultados de su prueba en “{$a->catscalename}”, ahora está inscrito en el grupo “{$a->groupname}” en el curso “<a href="{$a->courseurl}">{$a->coursename}</a>”.';
$string['openformat'] = 'formato abierto';
$string['optional'] = 'opcional';
$string['ownfeedbacksheader'] = 'Mi intento de {$a}';
$string['parent'] = 'Escala CAT paterna: ninguna si la escala CAT es de nivel superior';
$string['parentid'] = 'ID paterna';
$string['parentscale'] = 'Escala paterna';
$string['parentscalenamesinformation'] = 'Para hacer coincidir un elemento a través del nombre de la escala, asegúrese de nombrar todas las escalas paternas, incluida la escala raíz. Para las escalas nuevas (aún por crear), puede ingresar escalas paternas para la escala definida. Comience con la principal más alta y separe todas las secundarias con “|” (línea vertical Unicode U+007C; no confunda con una barra “/”). Para habilitar la importación a las escalas principales, configure “0” aquí.';
$string['passinglevel'] = 'Nivel aprobatorio en %';
$string['passinglevel_help'] = 'Hay un nivel de competencia personal que se puede establecer para la prueba.';
$string['perattempt'] = 'por intento';
$string['peritem'] = 'por elemento';
$string['personabilities'] = 'Puntajes de habilidad';
$string['personabilitiesnodata'] = 'No se calcularon puntajes de habilidad';
$string['personability'] = 'Puntaje de habilidad';
$string['personabilityafterattempt'] = 'Puntaje de habilidad después del intento';
$string['personabilitybeforeattempt'] = 'Puntaje de habilidad antes del intento';
$string['personabilitycharttitle'] = 'Puntaje de habilidad relativa en subescalas en comparación con “{$a}”';
$string['personabilityfeedbacktitle'] = 'Perfil de personalidad';
$string['personabilityinscale'] = 'Puntaje de habilidad en la escala “{$a}”';
$string['personabilityrangestring'] = '{$a->rangestart} - {$a->rangeend}';
$string['personabilitytitletab'] = 'Detalles del resultado';
$string['picturesavewarning'] = 'Por el momento, las imágenes en la retroalimentación  solo se guarda cuando se edita un examen existente.';
$string['pilot_questions'] = 'Pilotear preguntas';
$string['pilotratio'] = 'Porcentaje de preguntas que se pilotearán en %';
$string['pilotratio_help'] = 'Proporción de preguntas que aún deben pilotear en el número total de preguntas en un intento de prueba. Por ejemplo, especificar el 20 % significa que una de cada cinco preguntas en un experimento de prueba será una pregunta que se piloteará';
$string['pleasecheckorcancel'] = 'Por favor confirmar o cancelar';
$string['pleasechoose'] = 'Por favor elija';
$string['pluginname'] = 'Examen adaptativo: módulo CAT avanzado';
$string['previewquestion'] = 'Previsualizar pregunta';
$string['privacy:metadata:local_catquiz_attempts'] = 'Información sobre los intentos del usuario en exámenes adaptativos.';
$string['privacy:metadata:local_catquiz_personparams'] = 'Datos de parámetros de usuario en diferentes contextos.';
$string['privacy:metadata:local_catquiz_subscriptions'] = 'Información sobre las suscripciones de usuarios en el plugin Catquiz.';
$string['privacy:metadata:local_catquiz_subscriptions:area'] = 'El área del elemento suscrito.';
$string['privacy:metadata:local_catquiz_subscriptions:itemid'] = 'La ID del elemento suscrito.';
$string['privacy:metadata:local_catquiz_subscriptions:status'] = 'El estado de la suscripción.';
$string['privacy:metadata:local_catquiz_subscriptions:timecreated'] = 'La hora en que la suscripción fue creada.';
$string['privacy:metadata:local_catquiz_subscriptions:timemodified'] = 'La hora en que la suscripción fue modificada.';
$string['privacy:metadata:local_catquiz_subscriptions:userid'] = 'La ID del usuario.';
$string['progress'] = 'Progreso de su puntaje de habilidad en “{$a}”';
$string['questioncategories'] = 'Categoría de pregunta';
$string['questioncontextattempts'] = '# Intentos en el contexto seleccionado';
$string['questionfeedbackdisabled'] = 'La retroalimentación  sobre las respuestas proporcionadas está deshabilitada';
$string['questionfeedbacksettings'] = 'Configuración de retroalimentación para respuestas dadas';
$string['questionfeedbackshow'] = 'Mostrar retroalimentación sobre las respuestas dadas';
$string['questionfeedbackshowcorrectresponse'] = 'Mostrar respuesta correcta';
$string['questionfeedbackshowfeedback'] = 'Mostrar retroalimentación sobre la pregunta';
$string['questionfeedbackshowresponse'] = 'Indicar la exactitud de la respuesta dada';
$string['questionpreview'] = 'Previsualización de pregunta';
$string['questionresults'] = 'Resultados de pregunta';
$string['questions'] = 'Preguntas';
$string['questionssummary'] = 'Resumen';
$string['questiontext'] = 'Texto de pregunta';
$string['questiontype'] = 'Tipo de pregunta';
$string['quizattempts'] = 'Intentos de pregunta';
$string['quizgraphicalsummary'] = 'Resumen de progreso del examen';
$string['reachedmaximumquestions'] = 'Se alcanzó el número máximo de preguntas';
$string['recalculationscheduled'] = 'Se ha programado el recálculo de los parámetros de contexto.<br>Los parámetros actualizados se guardarán en un nuevo contexto.';
$string['recentevents'] = 'Eventos Recientes';
$string['relevantscales'] = 'Infer relevant subscales';
$string['removetestitem'] = 'Eliminar elementos de prueba';
$string['removetestitembody'] = '¿Desea eliminar los siguientes elementos de prueba de la escala CAT actual? <br> {$a->data}';
$string['removetestitemsubmit'] = 'Quitar';
$string['removetestitemtitle'] = 'Retirar el elemento de prueba de la escala CAT';
$string['reportscale'] = 'Incluir escala para el informe';
$string['requesttimeout'] = 'La solicitud de conexión se agotó antes de poder completarse';
$string['response'] = 'Respuesta';
$string['responsesbyusercharttitle'] = 'Número total de respuestas por persona';
$string['rootscale:tooltiptitle'] = 'escala raíz {$a}';
$string['scaledetailviewheading'] = 'Vista detallada de la escala CAT {$a}';
$string['scaleiddisplay'] = '(ID: {$a})';
$string['scaleinformation'] = 'El ID de la escala CAT a la que debe asignarse el elemento.';
$string['scalenameinformation'] = 'El nombre de la escala CAT a la que se debe asignar el elemento. Si no se proporciona ningún identificador de escala CAT, la coincidencia se realiza mediante el nombre.';
$string['scalescorechartlabel'] = '{$a}-Puntaje';
$string['scaleselected'] = 'escala definida {$a}';
$string['score'] = 'Puntaje ponderado';
$string['scoreofpeers'] = 'Promedio de sus pares';
$string['searchcatcontext'] = 'Buscar contextos CAT';
$string['seeitemsplayed'] = 'Mostrar elementos jugados';
$string['selectcatcontext'] = 'Seleccionar un contexto CAT';
$string['selectcatcontext_help'] = 'Los contextos diferencian los datos en términos de grupo objetivo, propósito o tiempo/cohorte. El contexto de implementación lo administra el administrador de CAT. Si desea tener su propio contexto de uso para su propósito, comuníquese con el administrador de CAT o con el administrador de su instancia de Moodle.';
$string['selectcatscale'] = 'Escala:';
$string['selected_scales_all_ranges_label'] = 'Número de participantes';
$string['selectitem'] = 'Sin elementos seleccionados';
$string['selectmodel'] = 'Elegir un modelo';
$string['selectparentscale'] = 'Seleccionar escala CAT';
$string['selectsubscale'] = 'Seleccionar una subescala';
$string['setautonitificationonenrolmentforscale'] = 'Informar a los participantes sobre la inscripción al grupo o curso utilizando el texto estándar.';
$string['setautonitificationonenrolmentforscale_help'] = 'Además de su retroalimentación por escrito, los participantes recibirán la siguiente anotación: “Usted ha sido inscrito automáticamente en el grupo <nombre del grupo> / curso <nombre del curso como enlace>”.';
$string['setcourseenrolmentforscale'] = 'Suscripción a un curso';
$string['setcourseenrolmentforscale_help'] = 'Los participantes de la prueba se inscriben en este curso (externo) después de completar la prueba, siempre que el resultado se encuentre dentro del rango de capacidad establecido. Solo puede seleccionar cursos en los que usted tenga derecho a inscribirse o que hayan sido aprobados para la inscripción por un administrador de CAT. Si no desea inscribirse en un curso externo, deje este campo en blanco.';
$string['setcoursesforscaletext'] = 'Para la escala CAT {$a}, determine el puntaje de capacidad para la retroalimentación individual, la retroalimentación escrita y las respectivas inscripciones en cursos o grupos.';
$string['setfeedbackforscale'] = 'retroalimentación escrita';
$string['setfeedbackforscale_help'] = 'Este texto se mostrará a los participantes de la prueba una vez finalizada la prueba, siempre que el resultado de la subescala <nombre de la subescala> esté dentro del rango de capacidad definido.';
$string['setgrouprenrolmentforscale'] = 'Inscribir en un grupo';
$string['setgrouprenrolmentforscale_help'] = 'Los participantes de la prueba son inscritos en este grupo del curso después de completar la prueba, siempre que el resultado se encuentre dentro del rango de capacidad establecido. Si no desea ser inscrito en un grupo, deje este campo en blanco.';
$string['setsevalue'] = 'Por favor, defina los valores. Estándar: min={$a->min} max={$a->max}';
$string['shortcodescatquizfeedback'] = 'Mostrar retroalimentación sobre los intentos de realizar la prueba';
$string['shortcodescatquizstatistics'] = 'Mostrar estadísticas para una prueba CAT';
$string['shortcodescatscalesoverview'] = 'Mostrar descripción general de las escalas CAT';
$string['shortcodeslistofquizattempts'] = 'Devuelve una tabla de intentos de prueba.';
$string['showlistofcatscalemanagers'] = 'Mostrar lista de administradores de escala CAT';
$string['showquestion'] = 'Mostrar pregunta';
$string['somethingwentwrong'] = 'Algo salió mal. Por favor, póngase en contacto con su administrador.';
$string['standarderror'] = 'Error estándar';
$string['starttime'] = 'Iniciar';
$string['starttimestamp'] = 'Hora de inicio';
$string['startwithdifficultquestion'] = 'con una pregunta difícil';
$string['startwitheasyquestion'] = 'con una pregunta fácil';
$string['startwithmediumquestion'] = 'con una pregunta medianamente difícil';
$string['startwithverydifficultquestion'] = 'con una pregunta muy difícil';
$string['startwithveryeasyquestion'] = 'con una pregunta muy fácil';
$string['statistics'] = 'Estadísticas';
$string['statistics_month_01'] = 'Enero {$a->y}';
$string['statistics_month_02'] = 'Febrero {$a->y}';
$string['statistics_month_03'] = 'Marzo {$a->y}';
$string['statistics_month_04'] = 'Abril {$a->y}';
$string['statistics_month_05'] = 'Mayo {$a->y}';
$string['statistics_month_06'] = 'Junio {$a->y}';
$string['statistics_month_07'] = 'Julio {$a->y}';
$string['statistics_month_08'] = 'Agosto {$a->y}';
$string['statistics_month_09'] = 'Septiembre {$a->y}';
$string['statistics_month_10'] = 'Octubre {$a->y}';
$string['statistics_month_11'] = 'Noviembre {$a->y}';
$string['statistics_month_12'] = 'Deciembre {$a->y}';
$string['statusactiveorinactive'] = 'Estado de actividad del elemento. Establezca en “1” para asegurarse de que el elemento no se utilice. Déjelo en blanco o establezca en “0” para “activo”.';
$string['statusok'] = 'Ok';
$string['statusundefined'] = 'Estado indefinido';
$string['store_debug_info_desc'] = 'Cuando se configura, se guardan datos adicionales para cada intento de prueba y se proporcionan como descarga CSV. Esto puede ocupar mucho espacio.';
$string['store_debug_info_name'] = 'Crear retroalimentación de examen con información de depuración';
$string['strategy'] = 'Estrategia';
$string['stringdate:day'] = '{$a}';
$string['stringdate:week'] = 'semana {$a}';
$string['studentdetails'] = 'Detalles del estudiante';
$string['studentstats'] = 'Estudiantes';
$string['subfeedbackrange'] = '({$a->lowerlimit} a {$a->upperlimit})';
$string['subplugintype_catmodel'] = 'modelo CAT';
$string['subplugintype_catmodel_plural'] = 'modelos CAT';
$string['subscribe'] = 'Suscribirse';
$string['subscribed'] = 'Suscrito';
$string['subscribedcatscalesheading'] = 'Escalas CAT suscritas';
$string['summary'] = 'Resumen';
$string['summarygeneral'] = 'General';
$string['summarylastcalculation'] = 'Último cálculo completo';
$string['summarynumberofassignedcatscales'] = 'Número de escalas CAT asignadas';
$string['summarynumberoftests'] = 'Número de pruebas asignadas';
$string['summarytotalnumberofquestions'] = 'Número de preguntas (total)';
$string['target'] = 'Objetivo';
$string['task_recalculate_cat_model_params'] = 'Recalcular parámetros CAT';
$string['teacherfeedback'] = 'Retroalimentación para profesores';
$string['templatetype'] = 'Plantilla';
$string['test'] = 'Suscripción de Prueba';
$string['testinfolabel'] = 'Información de Prueba';
$string['testitem'] = 'Elemento de prueba con id {$a}';
$string['testitem_deleted'] = 'Elemento de prueba eliminado';
$string['testitem_deleted_description'] = 'Elemento de prueba con ID {$a->testitemid} eliminado.';
$string['testitem_imported'] = 'Elemento de prueba importado';
$string['testitem_status_updated_description'] = 'Estado de {$a->testitemlink} establecido en: {$a->statusstring}';
$string['testitemactivitystatus_updated'] = 'Estado de actividad del elemento de prueba actualizado.';
$string['testitemdashboard'] = 'Tablero de elemento de prueba';
$string['testiteminrelatedscale'] = 'Elemento de prueba ya está asignado a un padre o una subescala';
$string['testiteminscale_added'] = 'Elemento de prueba añadido a escala CAT';
$string['testiteminscale_updated'] = 'Elemento de prueba actualizado en escala CAT';
$string['testitems'] = 'Elementos de prueba';
$string['testitemstatus_updated'] = 'Estado de elemento de prueba actualizado';
$string['testsandtemplates'] = 'Pruebas y plantillas';
$string['teststrategy'] = 'Estrategia de prueba';
$string['teststrategy_balanced'] = 'Moderar CAT';
$string['teststrategy_base'] = 'Clase base para estrategias de prueba';
$string['teststrategy_fastest'] = 'CAT';
$string['teststrategy_info'] = 'Clase de información para estrategias de prueba';
$string['testtype'] = 'Prueba';
$string['time_penalty_threshold_desc'] = 'Una pregunta que ya ha sido respondida por un usuario en un intento de prueba anterior solo se vuelve a formular con una probabilidad reducida. La probabilidad depende del tiempo transcurrido entre el intento anterior y el actual. Cuanto mayor sea el retraso de recurrencia dado, más eficaz será esta protección contra preguntas repetidas.';
$string['time_penalty_threshold_name'] = 'Retraso de recurrencia en días';
$string['timemodified'] = 'Hora de modificado';
$string['timeoutabortnoresult'] = 'Prueba abortada sin resultado.';
$string['timeoutabortresult'] = 'Prueba abortada con resultado.';
$string['timeoutfinishwithresult'] = 'Prueba abortada después de finalizar la pregunta actual.';
$string['timepacedtest'] = 'Prueba con ritmo de tiempo';
$string['toggleactivity'] = 'Activity status';
$string['togglestatus'] = 'Cambiar estado';
$string['totalnumberoftestitems'] = 'Número total de preguntas';
$string['tr_sd_ratio_desc'] = 'El multiplicador del intervalo de confianza es el múltiplo de la desviación estándar en torno al valor medio por el que se espera una estimación de parámetro de la dificultad de una persona o un elemento. Si el multiplicador del intervalo de confianza se establece demasiado alto, existe el riesgo de que el algoritmo numérico se vuelva inestable y proporcione valores poco fiables cuando la situación de los datos sea difícil. El valor predeterminado es un multiplicador de 3,0, que  estadísticamente incluye el 99,9 por ciento de todos los casos esperados.';
$string['tr_sd_ratio_name'] = 'Factor de región de confianza';
$string['trashbintitle'] = 'Eliminar elemento';
$string['type'] = 'Tipo';
$string['undefined'] = 'indefinido';
$string['update_context_description'] = 'Contexto CAT {$a} actualizado.';
$string['update_testitem_activity_status'] = 'El estado de actividad de {$a->testitemlink} cambió.';
$string['update_testitem_in_scale'] = '{$a->testitemlink} actualizado en {$a->catscalelink}';
$string['updatedparamscontext'] = 'parámetros actualizados_{$a->scalename}_{$a->usertime}';
$string['updatedparamscontextdesc'] = 'Generado automáticamente a través de la actualización de parámetros para la escala CAT {$a}.';
$string['updatedrecords'] = '{$a} registro(s) actualizado(s).';
$string['uploadcontext'] = 'autocontexto_{$a->scalename}_{$a->usertime}';
$string['upperlimit'] = 'Límite superior';
$string['usage'] = 'USo';
$string['usecatquiz'] = 'Utilice el motor Catquiz para esta instancia de prueba.';
$string['userfeedbacksheader'] = 'Intento {$a->attemptid} desde {$a->time}, por {$a->firstname} {$a->lastname} (id de usuario: {$a->userid})';
$string['usertocourse_enroled'] = 'Usuario inscrito en el curso';
$string['usertocourse_enroled_description'] = 'El usuario con ID {$a->userid} fue inscrito en el curso “<a href="{$a->course url}">{$a->course name}</a>”';
$string['usertogroup_enroled'] = 'Usuario inscrito a grupo';
$string['usertogroup_enroled_description'] = 'El usuario con ID {$a->userid} fue inscrito en el grupo “{$a->groupname}” en el curso “<a href="{$a->courseurl}">{$a->coursename}</a>”';
$string['userupdatedcatscale'] = 'El usuario con ID {$a->userid} actualizó {$a->catscalelink}';
$string['validateform:changevaluesorstatus'] = 'Por favor ingrese valores o cambie el estado.';
$string['validateform:onlyoneconfirmedstatusallowed'] = 'Este estado solo está permitido para una estrategia.';
$string['valuemustbegreaterzero'] = 'El valor debe ser mayor que cero.';
$string['versionchosen'] = 'Versión elegida:';
$string['versioning'] = 'Control de versiones';
$string['wronglabels'] = 'El archivo CSV importado no contiene las etiquetas correctas. No se puede importar la columna {$a}.';
$string['yourscorein'] = 'Sus puntajes promedios en “{$a}”';
