<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'ai', language 'de', version '5.1'.
 *
 * @package     ai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptai'] = 'Annehmen und weiter';
$string['action'] = 'Aktion';
$string['action_explain_text'] = 'Text erklären';
$string['action_explain_text_desc'] = 'Erklärt den Textinhalt auf der Kursseite';
$string['action_explain_text_help'] = 'Dies bietet eine Erklärung, die auf Schlüsselideen eingeht, komplexe Konzepte vereinfacht und Kontext hinzufügt, um das Verständnis des Textes zu erleichtern.';
$string['action_explain_text_instruction'] = 'Sie erhalten eine Texteingabe von einer Person. Ihre Aufgabe ist es, den bereitgestellten Text zu erklären. Befolgen Sie diese Richtlinien:
1. Ausarbeiten: Erläutern Sie wichtige Ideen und Konzepte, und stellen Sie sicher, dass die Erklärung sinnvolle Tiefe hinzufügt und es vermeidet, den Text wörtlich zu wiederholen.
2. Vereinfachen: Zerlegen Sie komplexe Begriffe oder Ideen in einfachere Komponenten, damit sie für ein breites Publikum, einschließlich Lernender, leicht verständlich sind.
3. Kontext bereitstellen: Erklären Sie, warum etwas passiert, wie es funktioniert oder was sein Zweck ist. Fügen Sie relevante Beispiele oder Analogien ein, um das Verständnis zu verbessern, wo dies angebracht ist.
4. Logisch organisieren: Strukturieren Sie Ihre Erklärung so, dass sie natürlich fließt, beginnend mit grundlegenden Ideen, bevor Sie zu feineren Details übergehen.

Wichtige Anweisungen:
1. Geben Sie die Zusammenfassung nur im Klartext zurück.
2. Fügen Sie keine Markdown-Formatierung, Begrüßungen oder Plattitüden ein.
3. Konzentrieren Sie sich auf Klarheit, Prägnanz und Zugänglichkeit.

Stellen Sie sicher, dass die Erklärung leicht zu lesen ist und die wichtigsten Punkte des Originaltexts effektiv vermittelt.';
$string['action_generate_image'] = 'Bild generieren';
$string['action_generate_image_desc'] = 'Generiert ein Bild basierend auf einem Textprompt';
$string['action_generate_image_help'] = 'Ein Bild auf Basis eines Prompts erzeugen';
$string['action_generate_text'] = 'Text generieren';
$string['action_generate_text_desc'] = 'Generiert Text basierend auf einem Textprompt';
$string['action_generate_text_help'] = 'Einen Text auf Basis eines Prompts erzeugen';
$string['action_generate_text_instruction'] = 'Sie erhalten eine Texteingabe vom Benutzer. Ihre Aufgabe ist es, auf der Grundlage seiner Anfrage Text zu generieren. Befolgen Sie diese wichtigen Anweisungen:
1. Geben Sie die Zusammenfassung nur im Klartext zurück.
2. Fügen Sie keine Markdown-Formatierung, Grüße oder Plattitüden ein.';
$string['action_summarise_text'] = 'Text zusammenfassen';
$string['action_summarise_text_desc'] = 'Fasst den Textinhalt einer Kursseite zusammen.';
$string['action_summarise_text_help'] = 'Zusammenfassung des Seiteninhalts erzeugen';
$string['action_summarise_text_instruction'] = 'Sie erhalten eine Texteingabe vom Benutzer. Ihre Aufgabe ist es, den bereitgestellten Text zusammenzufassen. Befolgen Sie diese Richtlinien:
1. Verdichten: Kürzen Sie lange Passagen auf die wichtigsten Punkte.
2. Vereinfachen: Machen Sie komplexe Informationen verständlicher, insbesondere für Lernende.

Wichtige Anweisungen:
1. Geben Sie die Zusammenfassung nur im Klartext zurück.
2. Fügen Sie keine Markdown-Formatierung, Grüße oder Plattitüden ein.
3. Konzentrieren Sie sich auf Klarheit, Prägnanz und Zugänglichkeit.

Stellen Sie sicher, dass die Zusammenfassung leicht zu lesen ist und die wichtigsten Punkte des Originaltexts effektiv vermittelt.';
$string['action_translate_text'] = 'Text übersetzen';
$string['action_translate_text_desc'] = 'Übersetzt einen Bereitgestellten Text von einer Sprache in eine andere';
$string['actionsettingprovider'] = 'Einstellungen für {$a} Aktion';
$string['actionsettingprovider_desc'] = 'Diese Einstellungen steuern, wie {$a->providername} die Aktion {$a->actionname} ausführt.';
$string['actionsettings'] = 'Aktionseinstellungen';
$string['actionsettings_desc'] = 'Diese Einstellungen steuern, wie die KI-Aktionen für diese Provider-Instanz ausgeführt werden.';
$string['ai'] = 'KI';
$string['aiactionregister'] = 'KI-Aktionsregister';
$string['aiactionshdr'] = 'KI-Optionen für diese Aktuvität auswählen';
$string['aiplacements'] = 'KI-Platzierung';
$string['aipolicyacceptance'] = 'Akzeptanz der KI-Richtlinie';
$string['aipolicyregister'] = 'Registrierung der KI-Richtlinie';
$string['aiproviders'] = 'KI-Provider';
$string['aireports'] = 'KI-Berichte';
$string['aitools'] = 'KI-Tools';
$string['aitoolsincourseactivitydesc'] = 'Wenn diese Option auf "ja" gesetzt ist, können Sie angeben, welche KI-Funktionen verfügbar sein sollen.';
$string['aitoolsincoursedesc'] = 'Wenn diese Option auf „Ja“ gesetzt ist, stehen KI-Tools für Aktivitäten in diesem Kurs zur Verfügung. KI-Tools können in den Einstellungen jeder Aktivität konfiguriert werden.';
$string['aitoolsnotenabled'] = 'Um anzugeben, welche KI-Funktionen in dieser Aktivität verfügbar sein sollen, gehen Sie zu den Kurseinstellungen und lassen Sie KI-Tools zu.';
$string['aiusage'] = 'KI-Nutzung';
$string['aiusagepolicy'] = 'KI-Nutzungsregeln';
$string['availableplacements'] = 'Auswählen, wo KI-Aktionen verfügbar sind';
$string['availableplacements_desc'] = 'Platzierungen legen fest, wie und wo KI-Aktionen auf Ihrer Website verwendet werden können. Über die Einstellungen können Sie auswählen, welche Aktionen in den einzelnen Platzierungen verfügbar sind.';
$string['availableproviders'] = 'KI-Provider verwalten, die mit Ihrem LMS verbunden sind';
$string['availableproviders_desc'] = 'KI-Provider fügen Ihrer Website eine KI-Funktionalität durch "Aktionen" wie Textzusammenfassung oder Bildgenerierung hinzu.<br/>
Sie können die Aktionen für jeden Provider in seinen Einstellungen verwalten.';
$string['btninstancecreate'] = 'Instanz erstellen';
$string['btninstanceupdate'] = 'Instanz updaten';
$string['completiontokens'] = 'Abschluss-Token';
$string['completiontokens_help'] = 'Vervollständigungstoken sind Texteinheiten, die vom KI-Modell als Antwort auf Ihre Eingabe generiert werden. Längere Antworten verbrauchen mehr Token, was wahrscheinlich höhere Kosten verursacht.';
$string['configureprovider'] = 'Provider-Instanz konfigurieren';
$string['contentwatermark'] = 'Generiert von KI';
$string['createnewprovider'] = 'Neue Provider-Instanz anlegen';
$string['dateaccepted'] = 'Daten akzeptiert';
$string['declineaipolicy'] = 'Ablehnen';
$string['enableaitoolsincourse'] = 'KI-Tools für diesen Kurs erlauben';
$string['enableaitoolsincourseactivity'] = 'KI-Tools für diese Aktivität erlauben';
$string['enableglobalratelimit'] = 'Systemweite Obergrenze für Anfragen festlegen';
$string['enableglobalratelimit_help'] = 'Anzahl der Anfragen begrenzen, die der KI-Provider von dieser Website in jeder Stunde empfangen kann.';
$string['enableuserratelimit'] = 'Obergrenze für Nutzer/innen festlegen';
$string['enableuserratelimit_help'] = 'Anzahl der Anfragen begrenzen, die jede Person in jeder Stunde an den KI-Provider stellen kann.';
$string['error:400'] = 'Ungültige Anfrage';
$string['error:401'] = 'Nicht autorisiert';
$string['error:401:upstreamless'] = 'Verbindung zum KI-Dienst nicht möglich. Versuchen Sie es später nochmal.';
$string['error:404'] = 'Nicht gefunden';
$string['error:404:upstreamless'] = 'Der KI-Dienst ist vorübergehend nicht verfügbar. Versuchen Sie es später nochmal.';
$string['error:429'] = 'Zu viele Anfragen';
$string['error:429:internalsitewide'] = 'Der KI-Dienst hat die maximale Anzahl systemweiter Anfragen pro Stunde erreicht. Versuchen Sie es später nochmal.';
$string['error:429:internaluser'] = 'Sie haben die maximale Anzahl an KI-Anfragen erreicht, die Sie pro Stunde stellen können. Versuchen Sie es später nochmal.';
$string['error:429:upstreamless'] = 'Dieser KI-Dienst hat sein Anfragelimit erreicht. Versuchen Sie es später nochmal.';
$string['error:500'] = 'Interner Serverfehler';
$string['error:503'] = 'Dienst nicht verfügbar';
$string['error:actionnotfound'] = 'Aktion \'{$a}\' wird nicht unterstützt';
$string['error:defaultmessage'] = 'Bei der Bearbeitung Ihrer Anfrage ist ein Fehler aufgetreten. Versuchen Sie es später nochmal.';
$string['error:defaultmessageshort'] = 'Versuchen Sie es später nochmal.';
$string['error:defaultname'] = 'Etwas ist falsch gelaufen.';
$string['error:noproviders'] = 'Keine Anbieter zur Verarbeitung der Aktion verfügbar.';
$string['error:providernotfound'] = 'Die KI-Provider-Instanz wurde nicht gefunden';
$string['error:unknown'] = 'Unbekannter Fehler';
$string['globalratelimit'] = 'Systemweite maximale Anzahl von Anfragen';
$string['globalratelimit_help'] = 'Systemweit erlaubte Anzahl von Anfragen pro Stunde.';
$string['manageaiplacements'] = 'KI-Platzierungen verwalten';
$string['manageaiproviders'] = 'KI-Provider verwalten';
$string['noproviders'] = 'Diese Aktion ist nicht verfügbar. Für diese Aktion sind keine <a href="{$a}"> Provider </a> konfiguriert.';
$string['off'] = 'Aus';
$string['on'] = 'An';
$string['placement'] = 'Platzierung';
$string['placementactionsettings'] = 'Aktionen';
$string['placementactionsettings_desc'] = 'Das sind die für diese Platzierung verfügbaren KI-Aktionen.';
$string['placementsettings'] = 'Platzierungsspezifische Einstellungen';
$string['placementsettings_desc'] = 'Diese Einstellungen steuern, wie die KI-Platzierung eine Verbindung zum KI-Dienst herstellt, außerdem zugehörige Vorgänge.';
$string['privacy:metadata:ai_action_explain_text'] = 'Eine Tabelle, in der die von Nutzer/innen gestellten Erläuterungstextanforderungen gespeichert werden.';
$string['privacy:metadata:ai_action_explain_text:completiontoken'] = 'Die Vervollständigungstoken dienen zur Erläuterung des Textes.';
$string['privacy:metadata:ai_action_explain_text:fingerprint'] = 'Der eindeutige Hash, der den Status bzw. die Version des Modells und Inhalts darstellt.';
$string['privacy:metadata:ai_action_explain_text:generatedcontent'] = 'Der eigentliche Text, der vom KI-Modell basierend auf der Prompt-Eingabe generiert wird.';
$string['privacy:metadata:ai_action_explain_text:prompt'] = 'Der Prompt für die Texterklärungsanforderung.';
$string['privacy:metadata:ai_action_explain_text:prompttokens'] = 'Die Prompt-Token, die zur Erläuterung des Textes verwendet werden.';
$string['privacy:metadata:ai_action_explain_text:responseid'] = 'Die ID der Antwort.';
$string['privacy:metadata:ai_action_generate_image'] = 'Tabelle, in der die Nutzeranfragen zur Bildgenerierung gespeichert werden.';
$string['privacy:metadata:ai_action_generate_image:aspectratio'] = 'Seitenverhältnis der generierten Bilder';
$string['privacy:metadata:ai_action_generate_image:numberimages'] = 'Anzahl der generierten Bilder';
$string['privacy:metadata:ai_action_generate_image:prompt'] = 'Prompt für die Anfrage zur Bildgenerierung';
$string['privacy:metadata:ai_action_generate_image:quality'] = 'Qualität der generierten Bilder';
$string['privacy:metadata:ai_action_generate_image:revisedprompt'] = 'Überarbeiteter Prompt für die generierten Bilder';
$string['privacy:metadata:ai_action_generate_image:sourceurl'] = 'Quell-URL der generierten Bilder';
$string['privacy:metadata:ai_action_generate_image:style'] = 'Style der generierten Bilder';
$string['privacy:metadata:ai_action_generate_text'] = 'Tabelle, in der die Nutzeranfragen zur Textgenerierung gespeichert werden.';
$string['privacy:metadata:ai_action_generate_text:completiontoken'] = 'Vervollständigungstoken, die zur Textgenerierung verwendet wurden.';
$string['privacy:metadata:ai_action_generate_text:fingerprint'] = 'Eindeutiger Hash, der den Status bzw. die Version von Modell und Inhalt darstellt.';
$string['privacy:metadata:ai_action_generate_text:generatedcontent'] = 'Tatsächlicher Text, der vom KI-Modell basierend auf dem Prompt generiert wird.';
$string['privacy:metadata:ai_action_generate_text:prompt'] = 'Prompt für die Anfrage zur Textgenerierung';
$string['privacy:metadata:ai_action_generate_text:prompttokens'] = 'Prompttoken, die zur Textgenerierung verwendet wurden';
$string['privacy:metadata:ai_action_generate_text:responseid'] = 'ID der Antwort';
$string['privacy:metadata:ai_action_register'] = 'Tabelle, in der die von Nutzer/innen gestellten Aktionsanfragen gespeichert werden.';
$string['privacy:metadata:ai_action_register:actionid'] = 'ID der Aktionsanfrage';
$string['privacy:metadata:ai_action_register:actionname'] = 'Aktionsname der Anfrage';
$string['privacy:metadata:ai_action_register:model'] = 'Das Modell, das zum Erzeugen der Antwort verwendet wird.';
$string['privacy:metadata:ai_action_register:provider'] = 'Name des Providers, der die Anfrage bearbeitet hat';
$string['privacy:metadata:ai_action_register:success'] = 'Status der Aktionsanfrage';
$string['privacy:metadata:ai_action_register:timecompleted'] = 'Ausführungszeit der Anfrage';
$string['privacy:metadata:ai_action_register:timecreated'] = 'Erstellungszeit der Anfrage';
$string['privacy:metadata:ai_action_register:userid'] = 'ID der Person, die die Anfrage gestellt hat';
$string['privacy:metadata:ai_action_summarise_text'] = 'Tabelle, in der die Nutzeranfragen zur Textzusammenfassung gespeichert werden.';
$string['privacy:metadata:ai_action_summarise_text:completiontoken'] = 'Vervollständigungstoken, die zur Textzusammenfassung verwendet wurden.';
$string['privacy:metadata:ai_action_summarise_text:fingerprint'] = 'Eindeutiger Hash, der den Status bzw. die Version von Modell und Inhalt darstellt';
$string['privacy:metadata:ai_action_summarise_text:generatedcontent'] = 'Tatsächlicher Text, der vom KI-Modell basierend auf dem Prompt generiert wird.';
$string['privacy:metadata:ai_action_summarise_text:prompt'] = 'Prompt der Anfrage zur Textzusammenfassung';
$string['privacy:metadata:ai_action_summarise_text:prompttokens'] = 'Prompttoken, das zur Textzusammenfassung verwendet wurde.';
$string['privacy:metadata:ai_action_summarise_text:responseid'] = 'ID der Anfrage';
$string['privacy:metadata:ai_policy_register'] = 'Tabelle, in der der Status der Zustimmung zu den KI-Bedingungen für jede einzelne Person gespeichert werden.';
$string['privacy:metadata:ai_policy_register:contextid'] = 'ID des Kontextes, dessen Daten gespeichert wurden';
$string['privacy:metadata:ai_policy_register:timeaccepted'] = 'Zeit, zu der die Person die KI-Bedingungen akzeptiert hat';
$string['privacy:metadata:ai_policy_register:userid'] = 'ID der Person, deren Daten gespeichert wurden';
$string['prompttokens'] = 'Prompt-Token';
$string['prompttokens_help'] = 'Prompt-Token sind Texteinheiten, die die Eingabe bilden, die Sie an das KI-Modell senden. Längere Eingaben verwenden mehr Token, was wahrscheinlich höhere Kosten verursacht.';
$string['provider'] = 'Provider';
$string['provideractionsettings'] = 'Aktionen';
$string['provideractionsettings_desc'] = 'Wählen und konfigurieren Sie die Aktionen, die {$a} auf Ihrer Website ausführen kann.';
$string['providerinstanceactionupdated'] = 'Aktionseinstellungen {$a} aktualisiert';
$string['providerinstancecreated'] = 'KI-Provider-Instanz {$a} angelegt';
$string['providerinstancedelete'] = 'KI-Provider-Instanz löschen';
$string['providerinstancedeleteconfirm'] = 'Möchten Sie die KI-Provider-Instanz "{$a->name} ({$a->provider})" wirklich löschen?';
$string['providerinstancedeleted'] = 'KI-Provider-Instanz {$a} gelöscht';
$string['providerinstancedeletefailed'] = 'Die KI-Provider-Instanz {$a} kann nicht gelöscht werden. Der Provider wird entweder verwendet oder es gibt ein Datenbankproblem. Prüfen Sie, ob der Provider aktiv ist, oder wenden Sie sich an die Administrator/innen der Datenbank.';
$string['providerinstancedisablefailed'] = 'Die KI-Provider-Instanz kann nicht deaktiviert werden. Der Provider wird entweder verwendet oder es gibt ein Datenbankproblem. Prüfen Sie, ob der Provider aktiv ist, oder wenden Sie sich an die Administrator/innen der Datenbank.';
$string['providerinstanceupdated'] = 'KI-Provider-Instanz {$a} aktualisiert';
$string['providermoveddown'] = '{$a} nach unten verschoben.';
$string['providermovedup'] = '{$a} nach oben verschoben.';
$string['providername'] = 'Name der Instanz';
$string['providers'] = 'Provider';
$string['providersettings'] = 'Einstellungen';
$string['providertype'] = 'KI-Provider-Plugin auswählen';
$string['timegenerated'] = 'Time generated';
$string['unknownvalue'] = 'Zeit generiert';
$string['userpolicy'] = '<h4>Willkommen bei der neuen KI-Funktion!</h4>
<p>Diese Funktion für künstliche Intelligenz (KI) basiert ausschließlich auf externen Large Language Models (LLM), um Ihr Lern- und Lehrerlebnis zu verbessern. Bevor Sie diese KI-Dienste nutzen, lesen Sie bitte diese Nutzungsrichtlinie.</p>
<h4>Genauigkeit von KI-generierten Inhalten</h4>
<p>KI kann nützliche Vorschläge und Informationen liefern, ihre Genauigkeit kann jedoch variieren. Sie sollten die bereitgestellten Infos immer überprüfen und sicherstellen, dass sie korrekt, vollständig und für Ihre spezifische Situation geeignet sind.</p>
<h4>Wie Ihre Daten verarbeitet werden</h4>
<p>Diese KI-Funktion verwendet externe "Large Language Models" (LLM). Wenn Sie diese Funktion benutzen, werden alle von Ihnen übermittelten Eingaben oder personenbezogenen Daten gemäß der Datenschutzrichtlinie dieser LLMs verarbeitet. Wir empfehlen Ihnen, die Datenschutzrichtlinie des LLMs zu lesen, um zu verstehen, wie mit Ihren personenbezogenen Daten umgegangen wird.
Darüber hinaus können Ihre Interaktionen mit den KI-Funktionen auf dieser Website aufgezeichnet und gespeichert werden. Wenn Sie Fragen hierzu haben, wenden Sie sich bitte an Ihre Trainer/innen oder die Lernorganisation.</p>
<p>Wenn Sie fortfahren, erkennen Sie an, dass Sie diese Richtlinie verstehen und ihr zustimmen.</p>';
$string['userratelimit'] = 'Maximale Anzahl von Anfragen pro Nutzer/in';
$string['userratelimit_help'] = 'Maximale Anzahl von Anfragen pro Stunde und pro Nutzer/in';
