<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_dataprivacy', language 'da', version '5.1'.
 *
 * @package     tool_dataprivacy
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitiesandresources'] = 'Aktiviteter og ressourcer';
$string['addcategory'] = 'Tilføj kategori';
$string['addnewdefaults'] = 'Tilføj en ny modulstandard';
$string['addpurpose'] = 'Tilføj formål';
$string['addroleoverride'] = 'Tilføj rolleoverstyring';
$string['allowfiltering'] = 'Tillad eksportfiltrering efter kursus';
$string['allowfiltering_desc'] = 'Hvis aktiveret, kan den databeskyttelsesansvarlige vælge at eksportere brugerdata fra udvalgte kurser i stedet for alle kurser. Når denne funktion er aktiveret, starter eksportanmodninger fra \'Afventer\' og kan kun godkendes efter en baggrundsopgave er afsluttet.';
$string['approve'] = 'Godkend';
$string['approvedrequestsubmitted'] = 'Din anmodning er indsendt og vil snart blive behandlet.';
$string['approverequest'] = 'Godkend anmodning';
$string['approverequestall'] = 'Godkend anmodning (alle data)';
$string['approveselectedcourses'] = 'Godkend udvalgte kurser';
$string['automaticdatadeletionapproval'] = 'Automatisk godkendelse af data sletningsanmodning';
$string['automaticdatadeletionapproval_desc'] = 'Hvis aktiveret, godkendes datasletningsanmodninger automatisk.<br/>Bemærk, at den automatiske godkendelse kun vil gælde for nye datasletningsanmodninger med denne indstilling aktiveret. Eksisterende datasletningsanmodninger, der afventer godkendelse, skal stadig manuelt godkendes af databeskyttelsesansvarlig.';
$string['automaticdataexportapproval'] = 'Automatisk godkendelse af dataeksportanmodning';
$string['automaticdataexportapproval_desc'] = 'Hvis aktiveret, godkendes dataeksportanmodninger automatisk.<br/>Bemærk, at den automatiske godkendelse kun vil gælde for nye dataeksportanmodninger med denne indstilling aktiveret. Eksisterende dataeksportanmodninger, der afventer godkendelse, skal stadig manuelt godkendes af den databeskyttelsesansvarlige.';
$string['automaticdeletionrequests'] = 'Opret automatisk datasletningsanmodninger';
$string['automaticdeletionrequests_desc'] = 'Hvis aktiveret, oprettes en datasletningsanmodning automatisk for enhver brugerkonto, der slettes manuelt.';
$string['bulkapproverequests'] = 'Godkend anmodninger';
$string['bulkdenyrequests'] = 'Afvis anmodninger';
$string['cachedef_contextlevel'] = 'Kontekstniveau formål og kategori';
$string['cachedef_purpose'] = 'Dataformål';
$string['cachedef_purpose_overrides'] = 'Formåls-overstyringer i databeskyttelsesværktøjet';
$string['cancelrequest'] = 'Annullér anmodning';
$string['cancelrequestconfirmation'] = 'Vil du annullere denne dataanmodning?';
$string['cannotreset'] = 'Kan ikke nulstille denne anmodning. Kun afviste anmodninger kan nulstilles.';
$string['categories'] = 'Kategorier';
$string['categorieslist'] = 'Liste over datakategorier';
$string['category'] = 'Kategori';
$string['category_help'] = 'En kategori i dataregistret beskriver en databasetype. En ny kategori kan tilføjes, eller hvis Arv er valgt, anvendes datakategorien fra en højere kontekst. Kontekster er (fra lav til høj): Blokke > Aktivitetsmoduler > Kurser > Kursuskategorier > Site.';
$string['categorycreated'] = 'Kategori oprettet';
$string['categorydefault'] = 'Standardkategori';
$string['categorydefault_help'] = 'Standardkategorien er den datakategori, der anvendes på nye forekomster. Hvis Arv er valgt, anvendes datakategorien fra en højere kontekst. Kontekster er (fra lav til høj): Blokke > Aktivitetsmoduler > Kurser > Kursuskategorier > Bruger > Site.';
$string['categoryupdated'] = 'Kategori opdateret';
$string['close'] = 'Luk';
$string['compliant'] = 'I overensstemmelse';
$string['confirmapproval'] = 'Vil du virkelig godkende denne dataanmodning?';
$string['confirmbulkapproval'] = 'Vil du virkelig godkende de valgte dataanmodninger i bulk?';
$string['confirmbulkdenial'] = 'Vil du virkelig afvise de valgte dataanmodninger i bulk?';
$string['confirmcompletion'] = 'Vil du virkelig markere denne brugers henvendelse som fuldført?';
$string['confirmcontextdeletion'] = 'Vil du virkelig bekræfte sletning af de valgte kontekster? Dette vil også slette alle brugerdataene for deres respektive underkontekster.';
$string['confirmdenial'] = 'Vil du virkelig afvise denne dataanmodning?';
$string['confirmrequestresubmit'] = 'Er du sikker på, at du vil annullere den nuværende {$a->type} anmodning for {$a->username} og indsende den igen?';
$string['contactdataprotectionofficer'] = 'Kontakt den databeskyttelsesansvarlige';
$string['contactdataprotectionofficer_desc'] = 'Hvis aktiveret, vil brugere kunne kontakte den databeskyttelsesansvarlige og lave en dataanmodning via et link på deres profilside.';
$string['contactdpoviaprivacypolicy'] = 'Kontakt den databeskyttelsesansvarlige som beskrevet i privatlivspolitikken.';
$string['contextlevelname10'] = 'Site';
$string['contextlevelname30'] = 'Brugere';
$string['contextlevelname40'] = 'Kursuskategorier';
$string['contextlevelname50'] = 'Kurser';
$string['contextlevelname70'] = 'Aktivitetsmoduler';
$string['contextlevelname80'] = 'Blokke';
$string['contextpurposecategorysaved'] = 'Formål og kategori gemt.';
$string['createcategory'] = 'Opret datakategori';
$string['createdeletedatarequest'] = 'Opret datasletningsanmodning';
$string['createnewdatarequest'] = 'Opret en ny dataanmodning';
$string['createpurpose'] = 'Opret dataformål';
$string['creationauto'] = 'Automatisk';
$string['creationmanual'] = 'Manuel';
$string['datadeletion'] = 'Datasletning';
$string['datadeletionpagehelp'] = 'Data hvis opbevaringsperiode er udløbet, er anført her. Gennemgå og bekræft datasletning, som derefter vil blive udført af den planlagte opgave "Slet udløbne kontekster".';
$string['dataprivacy:downloadallrequests'] = 'Download eksporterede data for alle';
$string['dataprivacy:downloadownrequest'] = 'Download dine egne eksporterede data';
$string['dataprivacy:makedatadeletionrequestsforchildren'] = 'Anmod om datasletning for mindreårige';
$string['dataprivacy:makedatarequestsforchildren'] = 'Lav dataanmodninger for mindreårige';
$string['dataprivacy:managedataregistry'] = 'Administrer dataregistret';
$string['dataprivacy:managedatarequests'] = 'Administrer dataanmodninger';
$string['dataprivacy:requestdelete'] = 'Anmod om datasletning for dig selv';
$string['dataprivacy:requestdeleteforotheruser'] = 'Anmod om datasletning på vegne af en anden bruger';
$string['dataregistry'] = 'Dataregister';
$string['dataregistryinfo'] = 'Dataregistret gør det muligt at sætte kategorier (datatyper) og formål (årsager til databehandling) for alt indhold på siden - fra brugere og kurser til aktiviteter og blokke. For hvert formål kan der sættes en opbevaringsperiode. Når en opbevaringsperiode udløber, markeres dataene og står på listen til sletning, og venter på adminbekræftelse.';
$string['datarequestcreatedforuser'] = 'Dataanmodning oprettet for {$a}';
$string['datarequestcreatedfromscheduledtask'] = 'Automatisk oprettet fra en planlagt opgave (allerede eksisterende slettet bruger).';
$string['datarequestcreatedupondelete'] = 'Automatisk oprettet ved brugersletning.';
$string['datarequestemailsubject'] = 'Dataanmodning: {$a}';
$string['datarequests'] = 'Dataanmodninger';
$string['dataretentionexplanation'] = 'Dette resumé viser de standardkategorier og formål for opbevaring af brugerdata. Visse områder kan have mere specifikke kategorier og formål end dem, der er anført her.';
$string['dataretentionsummary'] = 'Dataopbevaringsresumé';
$string['datecomment'] = '[{$a->date}]:
 {$a->comment}';
$string['daterequested'] = 'Dato anmodet';
$string['daterequesteddetail'] = 'Dato anmodet:';
$string['defaultexpired'] = 'Data for alle brugere';
$string['defaultexpiredexcept'] = 'Data for alle brugere, undtagen dem, der besidder nogen af følgende roller:<br>
{$a->unexpired}';
$string['defaultsinfo'] = 'Standardkategorier og -formål anvendes på alle nye og eksisterende forekomster, hvor der ikke er sat en værdi.';
$string['defaultssaved'] = 'Standarder gemt';
$string['defaultswarninginfo'] = 'Advarsel: Ændringer af disse standarder kan påvirke opbevaringsperioden for eksisterende forekomster.';
$string['defaultunexpired'] = 'Kun data for brugere, der besidder nogen af følgende roller:<br>
{$a->expired}';
$string['defaultunexpiredwithexceptions'] = 'Kun data for brugere, der besidder nogen af følgende roller:<br>
{$a->expired}
Medmindre de også besidder nogen af følgende roller:<br>
{$a->unexpired}';
$string['deletecategory'] = 'Slet kategori';
$string['deletecategorytext'] = 'Er du sikker på, at du vil slette kategorien \'{$a}\'?';
$string['deletedefaults'] = 'Slet standarder: {$a}';
$string['deletedefaultsconfirmation'] = 'Er du sikker på, at du vil slette standardkategorien og -formålet for {$a} moduler?';
$string['deleteexistingdeleteduserstask'] = 'Opret sletningsdataanmodning for allerede eksisterende slettede brugere';
$string['deleteexpiredcontextstask'] = 'Slet udløbne kontekster';
$string['deleteexpireddatarequeststask'] = 'Slet udløbne dataanmodning-eksportfiler';
$string['deletemyaccount'] = 'Slet min konto';
$string['deletepurpose'] = 'Slet formål';
$string['deletepurposetext'] = 'Er du sikker på, at du vil slette formålet \'{$a}\'?';
$string['deny'] = 'Afvis';
$string['denyrequest'] = 'Afvis anmodning';
$string['deprecated'] = 'Forældet';
$string['deprecatedexplanation'] = 'Dette plugin bruger en gammel version af en af privatlivsgrænsefladerne og skal opdateres.';
$string['download'] = 'Download';
$string['downloadexpireduser'] = 'Download er udløbet. Indsend en ny anmodning, hvis du vil eksportere dine personlige data.';
$string['dporolemapping'] = 'Rollefordeling for databeskyttelsesansvarlig';
$string['dporolemapping_desc'] = 'Den databeskyttelsesansvarlige kan administrere dataanmodninger. Rettigheden tool/dataprivacy:managedatarequests skal være tilladt for en rolle for at blive listet som en mulighed for rollefordeling for databeskyttelsesansvarlig';
$string['duplicaterole'] = 'Rolle allerede specificeret';
$string['editcategories'] = 'Redigér kategorier';
$string['editcategory'] = 'Redigér kategori';
$string['editdefaults'] = 'Redigér standarder: {$a}';
$string['editmoduledefaults'] = 'Redigér modulstandarder';
$string['editpurpose'] = 'Redigér formål';
$string['editpurposes'] = 'Redigér formål';
$string['effectiveretentionperiodcourse'] = '{$a} (efter kursets slutdato)';
$string['effectiveretentionperioduser'] = '{$a} (siden sidste gang brugeren tilgik sitet)';
$string['emailsalutation'] = 'Kære {$a},';
$string['errorcannotrequestdeleteforother'] = 'Du har ikke tilladelse til at oprette en slettningsanmodning for denne bruger.';
$string['errorcannotrequestdeleteforself'] = 'Du har ikke tilladelse til at oprette en slettningsanmodning for dig selv.';
$string['errorcannotrequestexportforself'] = 'Du har ikke tilladelse til at oprette en eksportanmodning for dig selv.';
$string['errorcontactdpodisabled'] = 'Muligheden for at kontakte den databeskyttelsesansvarlige er deaktiveret.';
$string['errorcontexthasunexpiredchildren'] = 'Konteksten "{$a}" har stadig underkontekster, der endnu ikke er udløbet. Ingen kontekster er blevet markeret til sletning.';
$string['errorinvalidrequestcomments'] = 'Kommentarfeltet kan kun indeholde almindelig tekst.';
$string['errorinvalidrequestcreationmethod'] = 'Ugyldig metode til oprettelse af anmodning!';
$string['errorinvalidrequeststatus'] = 'Ugyldig anmodningsstatus!';
$string['errorinvalidrequesttype'] = 'Ugyldig anmodningstype!';
$string['errornocapabilitytorequestforothers'] = 'Bruger {$a->requestedby} har ikke rettigheden til at fremsætte en dataanmodning på vegne af bruger {$a->userid}';
$string['errornoexpiredcontexts'] = 'Der er ingen udløbne kontekster at behandle';
$string['errornoselectedcourse'] = 'Du skal vælge mindst ét kursus';
$string['errorrequestalreadyexists'] = 'Du har allerede en igangværende anmodning.';
$string['errorrequestnotfound'] = 'Anmodning ikke fundet';
$string['errorrequestnotwaitingforapproval'] = 'Anmodningen venter ikke på godkendelse. Enten er den ikke klar endnu, eller den er allerede blevet behandlet.';
$string['errorsendingmessagetodpo'] = 'Der opstod en fejl under forsøg på at sende en besked til {$a}.';
$string['exceptionnotificationbody'] = '<p>En undtagelse opstod under kald af <b>{$a->fullmethodname}</b>.<br>Dette betyder, at plugin <b>{$a->component}</b> ikke fuldførte behandlingen af data. Følgende undtagelsesinformation kan gives videre til pluginudvikleren:</p><pre>{$a->message}<br>

{$a->backtrace}</pre>';
$string['exceptionnotificationsubject'] = 'Undtagelse opstod under behandling af privatdata';
$string['expandplugin'] = 'Udvid og skjul plugin.';
$string['expandplugintype'] = 'Udvid og skjul plugintype.';
$string['expiredretentionperiodtask'] = 'Udløbet opbevaringsperiode';
$string['expiredrolewithretention'] = '{$a->retention} (Udløbet)';
$string['expiry'] = 'Udløb';
$string['explanationtitle'] = 'Ikoner brugt på denne side og deres betydninger.';
$string['external'] = 'Ekstra';
$string['externalexplanation'] = 'Et ekstra plugin installeret på denne side.';
$string['filterexportdata'] = 'Godkend anmodning (data fra udvalgte kurser)';
$string['filteroption'] = '{$a->category}: {$a->name}';
$string['frontpagecourse'] = 'Kursushjem';
$string['gdpr_art_6_1_a_description'] = 'Den registrerede har givet samtykke til behandlingen af sine eller hendes personoplysninger til et eller flere specifikke formål';
$string['gdpr_art_6_1_a_name'] = 'Samtykke (GDPR Art. 6.1(a))';
$string['gdpr_art_6_1_b_description'] = 'Behandling er nødvendig for udførelsen af en kontrakt, som den registrerede er part i, eller for at tage skridt på den registreredes anmodning inden indgåelse af en kontrakt';
$string['gdpr_art_6_1_b_name'] = 'Kontrakt (GDPR Art. 6.1(b))';
$string['gdpr_art_6_1_c_description'] = 'Behandling er nødvendig for at overholde en juridisk forpligtelse, som den dataansvarlige er underlagt';
$string['gdpr_art_6_1_c_name'] = 'Juridisk forpligtelse (GDPR Art 6.1(c))';
$string['gdpr_art_6_1_d_description'] = 'Behandling er nødvendig for at beskytte den registreredes eller en anden fysisk persons vitale interesser';
$string['gdpr_art_6_1_d_name'] = 'Vitale interesser (GDPR Art. 6.1(d))';
$string['gdpr_art_6_1_e_description'] = 'Behandling er nødvendig for udførelsen af en opgave udført i offentlighedens interesse eller i forbindelse med udøvelsen af en officiel myndighed, der er tillagt den dataansvarlige';
$string['gdpr_art_6_1_e_name'] = 'Offentlig opgave (GDPR Art. 6.1(e))';
$string['gdpr_art_6_1_f_description'] = 'Behandling er nødvendig for at forfølge den dataansvarliges eller en tredjeparts legitime interesser, medmindre sådanne interesser tilsidesættes af den registreredes interesser eller grundlæggende rettigheder og friheder, der kræver beskyttelse af personoplysninger, især hvis den registrerede er et barn';
$string['gdpr_art_6_1_f_name'] = 'Legitime interesser (GDPR Art. 6.1(f))';
$string['gdpr_art_9_2_a_description'] = 'Den registrerede har givet udtrykkeligt samtykke til behandlingen af disse personoplysninger til et eller flere specificerede formål, undtagen hvor EU- eller medlemsstatslovgivning fastsætter, at forbuddet nævnt i GDPR artikel 9, stk. 1, ikke kan frafaldes af den registrerede';
$string['gdpr_art_9_2_a_name'] = 'Udtrykkeligt samtykke (GDPR Art. 9.2(a))';
$string['gdpr_art_9_2_b_description'] = 'Behandling er nødvendig for at opfylde forpligtelser og udøve specifikke rettigheder for den dataansvarlige eller den registrerede inden for beskæftigelse og social sikring og social beskyttelseslovgivning, for så vidt det er godkendt af EU- eller medlemsstatslovgivning eller en kollektiv aftale i henhold til medlemsstatslovgivning, der fastsætter passende garantier for den registreredes grundlæggende rettigheder og interesser';
$string['gdpr_art_9_2_b_name'] = 'Arbejds- og socialsikrings-/beskyttelseslov (GDPR Art. 9.2(b))';
$string['gdpr_art_9_2_c_description'] = 'Behandling er nødvendig for at beskytte den registreredes eller en anden fysisk persons vitale interesser, hvor den registrerede fysisk eller juridisk er ude af stand til at give samtykke';
$string['gdpr_art_9_2_c_name'] = 'Beskyttelse af vitale interesser (GDPR Art. 9.2(c))';
$string['gdpr_art_9_2_d_description'] = 'Behandling udføres som led i dets legitime aktiviteter med passende sikkerhedsforanstaltninger af en fond, forening eller en anden non-profit organisation med et politisk, filosofisk, religiøst eller fagforeningsmæssigt formål, og under forudsætning af at behandlingen udelukkende vedrører medlemmerne eller tidligere medlemmer af organisationen eller personer, der har regelmæssig kontakt med den i forbindelse med dens formål, og at personoplysningerne ikke videregives uden for denne organisation uden de registreredes samtykke';
$string['gdpr_art_9_2_d_name'] = 'Legitime aktiviteter vedrørende medlemmer/nær kontakter af en fond, forening eller anden non-profit organisation (GDPR Art. 9.2(d))';
$string['gdpr_art_9_2_e_description'] = 'Behandlingen vedrører personoplysninger, som åbenlyst er offentliggjort af den registrerede';
$string['gdpr_art_9_2_e_name'] = 'Data offentliggjort af den registrerede (GDPR Art. 9.2(e))';
$string['gdpr_art_9_2_f_description'] = 'Behandling er nødvendig for etablering, udøvelse eller forsvar af juridiske krav eller når domstole handler i deres domstolsfunktion';
$string['gdpr_art_9_2_f_name'] = 'Juridiske krav og retlige handlinger (GDPR Art. 9.2(f))';
$string['gdpr_art_9_2_g_description'] = 'Behandling er nødvendig af hensyn til betydelige samfundsinteresser på grundlag af EU- eller medlemsstatslovgivning, der skal stå i rimeligt forhold til det mål, der forfølges, respektere retten til databeskyttelses væsentlige indhold og fastsætte passende og specifikke foranstaltninger for at beskytte den registreredes grundlæggende rettigheder og interesser';
$string['gdpr_art_9_2_g_name'] = 'Betydelige samfundsinteresser (GDPR Art. 9.2(g))';
$string['gdpr_art_9_2_h_description'] = 'Behandling er nødvendig af hensyn til forebyggende eller arbejdsmæssig medicin, for vurdering af medarbejderens arbejdsevne, medicinsk diagnose, levering af sundheds- eller socialpleje eller behandling eller forvaltning af sundheds- eller socialplejesystemer og -tjenester på grundlag af EU- eller medlemsstatslovgivning eller i henhold til kontrakt med en sundhedsprofessionel og underlagt de betingelser og sikkerhedsforanstaltninger, der er nævnt i GDPR artikel 9, stk. 3';
$string['gdpr_art_9_2_h_name'] = 'Medicinske formål (GDPR Art. 9.2(h))';
$string['gdpr_art_9_2_i_description'] = 'Behandling er nødvendig af hensyn til samfundets interesser inden for folkesundhedsområdet, såsom beskyttelse mod alvorlige grænseoverskridende trusler mod sundheden eller sikring af høje standarder for kvalitet og sikkerhed af sundhedspleje og medicinske produkter eller medicinsk udstyr på grundlag af EU- eller medlemsstatslovgivning, der fastsætter passende og specifikke foranstaltninger for at beskytte den registreredes rettigheder og friheder, herunder faglig hemmeligholdelse';
$string['gdpr_art_9_2_i_name'] = 'Folkesundhed (GDPR Art. 9.2(i))';
$string['gdpr_art_9_2_j_description'] = 'Behandling er nødvendig af hensyn til arkivering i samfundets interesse, til videnskabelige eller historiske forskningsformål eller statistiske formål i overensstemmelse med artikel 89, stk. 1, baseret på EU- eller medlemsstatslovgivning, der skal stå i rimeligt forhold til det mål, der forfølges, respektere retten til databeskyttelses væsentlige indhold og fastsætte passende og specifikke sikkerhedsforanstaltninger for at beskytte den registreredes grundlæggende rettigheder og interesser';
$string['gdpr_art_9_2_j_name'] = 'Samfundsinteresse eller videnskabelig/historisk/statistisk forskning (GDPR Art. 9.2(j))';
$string['hide'] = 'Skjul alt';
$string['httpwarning'] = 'Enhver data, der downloades fra dette site, kan være ukrypteret. Kontakt din systemadministrator og anmod om at installere SSL på dette site.';
$string['inherit'] = 'Arv';
$string['lawfulbases'] = 'Lovlige grundlag';
$string['lawfulbases_help'] = 'Vælg mindst en mulighed, der vil fungere som det lovlige grundlag for behandling af personoplysninger. For detaljer om disse lovlige grundlag se <a href="https://gdpr-info.eu/art-6-gdpr/" target="_blank">GDPR Art. 6.1</a>';
$string['markcomplete'] = 'Markér som fuldført';
$string['markedcomplete'] = 'Din henvendelse er markeret som fuldført af den databeskyttelsesansvarlige.';
$string['message'] = 'Besked';
$string['messagelabel'] = 'Besked:';
$string['messageprovider:contactdataprotectionofficer'] = 'Dataanmodninger';
$string['messageprovider:datarequestprocessingresults'] = 'Resultater af behandlingen af dataanmodninger';
$string['messageprovider:notifyexceptions'] = 'Underretninger om undtagelser ved dataanmodninger';
$string['moduleinstancename'] = '{$a->instancename} ({$a->modulename})';
$string['mypersonaldatarequests'] = 'Mine personlige dataanmodninger';
$string['nameandparent'] = '{$a->parent} / {$a->name}';
$string['nameemail'] = '{$a->name} ({$a->email})';
$string['nchildren'] = '{$a} børn';
$string['newrequest'] = 'Ny anmodning';
$string['noactivitiestoload'] = 'Ingen aktiviteter';
$string['noassignedroles'] = 'Ingen tildelte roller i denne kontekst';
$string['noblockstoload'] = 'Ingen blokke';
$string['nocategories'] = 'Der er endnu ingen kategorier';
$string['nocoursestoload'] = 'Ingen aktiviteter';
$string['nocoursetofilter'] = 'Brugeren er ikke tilmeldt nogen kurser, der kan vælges';
$string['nodatarequests'] = 'Der er ingen dataanmodninger';
$string['nodatarequestsmatchingfilter'] = 'Der er ingen dataanmodninger, der matcher det givne filter';
$string['noexpiredcontexts'] = 'Dette kontekstniveau har ingen data, hvor opbevaringsperioden er udløbet.';
$string['nopersonaldatarequests'] = 'Du har ingen personlige dataanmodninger';
$string['nopurposes'] = 'Der er endnu ingen formål';
$string['nosubjectaccessrequests'] = 'Der er ingen dataanmodninger, som du behøver at handle på';
$string['nosystemdefaults'] = 'Formål og kategori for sitet er endnu ikke defineret.';
$string['notset'] = 'Ikke sat (brug standardværdien)';
$string['notyetexpired'] = '{$a} (ikke endnu udløbet)';
$string['overrideinstances'] = 'Nulstil forekomster med brugerdefinerede værdier';
$string['pluginname'] = 'Databeskyttelse';
$string['pluginname_help'] = 'Databeskyttelses-plugin';
$string['pluginregistry'] = 'Plugindatabeskyttelsesregister';
$string['pluginregistrytitle'] = 'Plugindatabeskyttelsesregister';
$string['privacy'] = 'Privatliv';
$string['privacy:metadata:preference:tool_dataprivacy_request-filters'] = 'De filtre, der aktuelt er anvendt på dataanmodningssiden.';
$string['privacy:metadata:preference:tool_dataprivacy_request-perpage'] = 'Antallet af dataanmodninger, som brugeren foretrækker at se på én side';
$string['privacy:metadata:purpose'] = 'Information fra dataformål lavet for dette site.';
$string['privacy:metadata:purpose:usermodified'] = 'ID’et på brugeren, der ændrede formålet';
$string['privacy:metadata:request'] = 'Information fra persondataanmodninger (adgangs- og sletteanmodninger) lavet for dette site.';
$string['privacy:metadata:request:comments'] = 'Eventuelle brugerkommentarer, der følger med anmodningen.';
$string['privacy:metadata:request:dpocomment'] = 'Eventuelle kommentarer fra sidens databeskyttelsesansvarlige vedrørende anmodningen.';
$string['privacy:metadata:request:requestedby'] = 'ID’et på brugeren, der lavede anmodningen, hvis lavet på vegne af en anden bruger.';
$string['privacy:metadata:request:timecreated'] = 'Tidsstemplet, der angiver hvornår anmodningen blev lavet af brugeren.';
$string['privacy:metadata:request:userid'] = 'ID’et på brugeren, som anmodningen tilhører';
$string['privacyofficeronly'] = 'Kun brugere, der er tildelt en rolle som databeskyttelsesansvarlig ({$a}), har adgang til dette indhold';
$string['privacyrequestexpiry'] = 'Udløb for dataanmodning';
$string['privacyrequestexpiry_desc'] = 'Tidspunktet hvor godkendte dataanmodninger vil være tilgængelige for download, før de udløber. Hvis sat til nul, er der ingen tidsbegrænsning.';
$string['protected'] = 'Beskyttet';
$string['protectedlabel'] = 'Opbevaringen af disse data har en højere juridisk prioritet end en brugers anmodning om at blive glemt. Disse data vil kun blive slettet efter opbevaringsperiodens udløb.';
$string['purpose'] = 'Formål';
$string['purpose_help'] = 'Formålet beskriver årsagen til behandling af data. Et nyt formål kan tilføjes, eller hvis Arv er valgt, anvendes formålet fra en højere kontekst. Kontekster er (fra lav til høj): Blokke > Aktivitetsmoduler > Kurser > Kursuskategorier > Bruger > Site.';
$string['purposecreated'] = 'Formål oprettet';
$string['purposedefault'] = 'Standardformål';
$string['purposedefault_help'] = 'Standardformålet er det formål, der anvendes på nye forekomster. Hvis Arv er valgt, anvendes formålet fra en højere kontekst. Kontekster er (fra lav til høj): Blokke > Aktivitetsmoduler > Kurser > Kursuskategorier > Bruger > Site.';
$string['purposeoverview'] = 'Et formål beskriver den tilsigtede brug og opbevaringspolitik for lagrede data. Grundlaget for opbevaring og opbevaring af disse data beskrives også i formålet.';
$string['purposes'] = 'Formål';
$string['purposeslist'] = 'Liste over dataformål';
$string['purposeupdated'] = 'Formål opdateret';
$string['replyto'] = 'Svar til';
$string['requestactions'] = 'Handlinger';
$string['requestapproved'] = 'Anmodningen er godkendt';
$string['requestby'] = 'Anmodet af';
$string['requestbydetail'] = 'Anmodet af:';
$string['requestcomments'] = 'Kommentarer';
$string['requestcomments_help'] = 'Denne boks gør det muligt at indtaste yderligere detaljer om din dataanmodning.';
$string['requestcreation'] = 'Oprettelse';
$string['requestdenied'] = 'Anmodningen er afvist';
$string['requestemailintro'] = 'Du har modtaget en dataanmodning:';
$string['requestfor'] = 'Bruger';
$string['requestmarkedcomplete'] = 'Anmodningen er markeret som fuldført';
$string['requestorigin'] = 'Site';
$string['requestsapproved'] = 'Anmodningerne er godkendt';
$string['requestsdenied'] = 'Anmodningerne er afvist';
$string['requeststatus'] = 'Status';
$string['requestsubmitted'] = 'Din anmodning er indsendt til den databeskyttelsesansvarlige';
$string['requesttype'] = 'Type';
$string['requesttype_help'] = 'Vælg årsagen til at kontakte den databeskyttelsesansvarlige. Vær opmærksom på, at sletning af al personlig data vil resultere i, at du ikke længere kan logge ind på sitet.';
$string['requesttypedelete'] = 'Slet alle mine persondata';
$string['requesttypedeleteshort'] = 'Slet';
$string['requesttypeexport'] = 'Eksporter alle mine persondata';
$string['requesttypeexportallowfiltering'] = 'Eksporter mine persondata';
$string['requesttypeexportshort'] = 'Eksport';
$string['requesttypeothers'] = 'Generel forespørgsel';
$string['requesttypeothersshort'] = 'Besked';
$string['requesttypeuser'] = '{$a->typename} ({$a->user})';
$string['requireallenddatesforuserdeletion'] = 'Anse kurser uden slutdato som aktive';
$string['requireallenddatesforuserdeletion_desc'] = 'Ved beregning af brugerens udløb overvejes flere faktorer:

* brugerens seneste logintid sammenlignes med opbevaringsperioden for brugere; og
* om brugeren er aktivt indskrevet i nogen kurser.

Når man undersøger den aktive tilmelding i et kursus, hvis kurset ikke har nogen slutdato, bruges denne indstilling til at bestemme, om kurset anses for at være aktivt eller ej.

Hvis kurset ikke har nogen slutdato, og denne indstilling er aktiveret, kan brugeren ikke slettes.';
$string['requiresattention'] = 'Kræver opmærksomhed.';
$string['requiresattentionexplanation'] = 'Dette plugin implementerer ikke Moodles privat livs-API. Hvis dette plugin lagrer nogen persondata, vil de ikke kunne eksporteres eller slettes gennem Moodles privatlivssystem.';
$string['resubmitrequest'] = 'Genindsend {$a->type} anmodning for {$a->username}';
$string['resubmitrequestasnew'] = 'Indsend som ny anmodning';
$string['resubmittedrequest'] = 'Den eksisterende {$a->type} anmodning for {$a->username} blev annulleret og genindsendt';
$string['resultdeleted'] = 'Du har for nylig anmodet om at få din konto og persondata i {$a} slettet. Denne proces er afsluttet, og du vil ikke længere kunne logge ind.';
$string['resultdownloadready'] = 'Din kopi af dine persondata fra {$a}, som du for nylig anmodede om, er nu tilgængelig for download fra følgende link.';
$string['retentionperiod'] = 'Opbevaringsperiode';
$string['retentionperiod_help'] = 'Opbevaringsperioden angiver længden af tid, som dataene skal bevares. Når opbevaringsperioden er udløbet, markeres dataene og står på listen til sletning og venter på adminbekræftelse.';
$string['retentionperiodnotdefined'] = 'Ingen opbevaringsperiode defineret';
$string['retentionperiodzero'] = 'Ingen opbevaringsperiode';
$string['reviewdata'] = 'Gennemgå data';
$string['role'] = 'Rolle';
$string['role_help'] = 'Den rolle, som overstyringen skal gælde for.';
$string['roleoverride'] = 'Rolleoverstyring';
$string['roleoverrideoverview'] = 'Standardopbevaringspolitikken kan overstyres for specifikke brugerroller, hvilket giver dig mulighed for at angive en længere eller kortere opbevaringspolitik. En bruger udløber kun, når alle deres roller er udløbet.';
$string['roleoverrides'] = 'Rolleoverstyringer';
$string['selectbulkaction'] = 'Vælg en bulkhandling.';
$string['selectcourses'] = 'Vælg kurser til eksport';
$string['selectdatarequests'] = 'Vælg dataanmodninger.';
$string['selectuserdatarequest'] = 'Vælg {$a->username}\'s {$a->requesttype} dataanmodning.';
$string['send'] = 'Send';
$string['sensitivedatareasons'] = 'Årsager til behandling af følsomme persondata';
$string['sensitivedatareasons_help'] = 'Vælg en eller flere gældende årsager, der undtager forbuddet mod behandling af følsomme persondata knyttet til dette formål. For mere information, se venligst <a href="https://gdpr-info.eu/art-9-gdpr/" target="_blank">GDPR Art. 9.2</a>';
$string['setdefaults'] = 'Sæt standarder';
$string['showdataretentionsummary'] = 'Vis dataopbevaringsresumé';
$string['showdataretentionsummary_desc'] = 'Hvis aktiveret, vises et link til dataopbevaringsresumé i sidefoden og i brugernes profiler.';
$string['statusapproved'] = 'Godkendt';
$string['statusawaitingapproval'] = 'Afventer godkendelse';
$string['statuscancelled'] = 'Annulleret';
$string['statuscomplete'] = 'Fuldført';
$string['statusdeleted'] = 'Slettet';
$string['statusdetail'] = 'Status:';
$string['statusexpired'] = 'Udløbet';
$string['statuspending'] = 'Afventer';
$string['statuspreprocessing'] = 'Forbehandling';
$string['statusprocessing'] = 'Behandler';
$string['statusready'] = 'Klar til download';
$string['statusrejected'] = 'Afvist';
$string['subjectscope'] = 'Emneområde';
$string['subjectscope_help'] = 'Emneområdet viser de roller, der kan tildeles i denne kontekst.';
$string['summary'] = 'Oversigt over registerkonfiguration';
$string['systemconfignotsetwarning'] = 'Et siteformål og -kategori er ikke defineret. Når disse ikke er defineret, fjernes al data ved behandling af sletningsanmodninger.';
$string['tobedeleted'] = 'Data til sletning';
$string['unexpiredrolewithretention'] = '{$a->retention} (Udløbet)';
$string['user'] = 'Bruger';
$string['userlistexplanation'] = 'Dette plugin har basisleverandøren, men bør også implementere brugerlisteleverandøren for fuld understøttelse af privatlivsfunktionalitet.';
$string['userlistnoncompliant'] = 'Brugerliste leverandør mangler';
$string['viewrequest'] = 'Vis anmodningen';
$string['visible'] = 'Udvid alt';
