<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'da', version '5.1'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Du kan forhåndsvise denne quiz, men hvis dette var et reelt forsøg, ville du blive blokeret fordi:';
$string['action'] = 'Handling';
$string['activityoverview'] = 'Du har quizzer, der skal afleveres';
$string['adaptive'] = 'Adaptiv tilstand';
$string['adaptive_help'] = 'Hvis aktiveret, er det tilladt med multiple svar på et spørgsmål inden for det samme forsøg på quizzen. Så for eksempel, hvis et svar er markeret som forkert, vil studenten blive tilladt at prøve igen med det samme. Dog, afhængigt af indstillingen \'Anvend straffe\', vil der normalt blive trukket en straf for hvert forkert forsøg.';
$string['add'] = 'Tilføj';
$string['addaquestion'] = 'et nyt spørgsmål';
$string['addarandomquestion'] = 'et tilfældigt spørgsmål';
$string['addarandomquestion_help'] = 'Når et tilfældigt spørgsmål tilføjes, resulterer det i, at et tilfældigt valgt spørgsmål fra kategorien indsættes i quizzen. Dette betyder, at forskellige studerende sandsynligvis vil få en forskellig udvælgelse af spørgsmål, og når en quiz tillader flere forsøg, vil hvert forsøg sandsynligvis indeholde en ny udvælgelse af spørgsmål.';
$string['addarandomquestion_success'] = 'Tilfældige spørgsmål er blevet tilføjet';
$string['addarandomselectedquestion'] = 'Tilføj et tilfældigt udvalgt spørgsmål ...';
$string['addasection'] = 'en ny sektion overskrift';
$string['adddescriptionlabel'] = 'Tilføj et beskrivelsespunkt';
$string['addingquestion'] = 'Tilføjelse af et spørgsmål';
$string['addingquestions'] = '<p>This side of the page is where you manage your database of questions. Questions are stored in categories to help you keep them organised, and can be used by any quiz in your course or even other courses if you choose to \'publish\' them.</p>
<p>After you select or create a question category you will be able to create or edit questions. You can select any of these questions to add to your quiz over on the other side of this page.</p>';
$string['addmoreoverallfeedbacks'] = 'Tilføj {no} flere feedbackfelter';
$string['addnewgroupoverride'] = 'Tilføj brugergruppeundtagelse';
$string['addnewpagesafterselected'] = 'Tilføj nye sider efter de valgte spørgsmål';
$string['addnewquestionsqbank'] = 'Tilføj spørgsmål til kategorien {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Tilføj brugerundtagelse';
$string['addpagebreak'] = 'Tilføj sideskift';
$string['addpagehere'] = 'Tilføj side her';
$string['addquestion'] = 'Tilføj spørgsmål';
$string['addquestionfrombankatend'] = 'Tilføj fra spørgsmålsbanken til sidst';
$string['addquestionfrombanktopage'] = 'Tilføj fra spørgsmålbanken til side {$a}';
$string['addquestions'] = 'Tilføj spørgsmål';
$string['addquestionstoquiz'] = 'Tilføj spørgsmål til den nuværende quiz';
$string['addrandom'] = 'Tilføj {$a} tilfældige spørgsmål';
$string['addrandom1'] = '<< Tilføj';
$string['addrandom2'] = 'tilfældige spørgsmål';
$string['addrandomfromcategory'] = 'Tilføj tilfældige spørgsmål fra kategori:';
$string['addrandomquestion'] = 'Tilføj tilfældig spørgsmål';
$string['addrandomquestionatend'] = 'Tilføj et tilfældigt spørgsmål til sidst';
$string['addrandomquestiontopage'] = 'Tilføj et tilfældigt spørgsmål til siden {$a}';
$string['addrandomquestiontoquiz'] = 'Tilføj et tilfældigt spørgsmål til quiz {$a}';
$string['addselectedquestionstoquiz'] = 'Tilføj valgte spørgsmål til quizzen';
$string['addselectedtoquiz'] = 'Tilføj valgte til quiz';
$string['addtoquiz'] = 'Tilføj til quiz';
$string['affectedstudents'] = 'Berørt {$a}';
$string['aftereachquestion'] = 'Efter at have tilføjet hvert spørgsmål';
$string['afternquestions'] = 'Efter at have tilføjet {$a} spørgsmål';
$string['age'] = 'alder';
$string['allattempts'] = 'Alle forsøg';
$string['allinone'] = 'Ubegrænset';
$string['allowedattemptsperstudent'] = 'Tilladte forsøg pr. studerende';
$string['allowreview'] = 'Tillad gennemgang';
$string['alreadysubmitted'] = 'Det er sandsynligt, at du allerede har indsendt denne aflevering';
$string['alternativeunits'] = 'Alternative enheder';
$string['alwaysavailable'] = 'Altid tilgængelig';
$string['alwayslatest'] = 'Altid den nyeste';
$string['analysisoptions'] = 'Analysemuligheder';
$string['analysistitle'] = 'Tabel for vareanalyse';
$string['answer'] = 'Svar';
$string['answered'] = 'Besvaret';
$string['answerhowmany'] = 'Én eller flere svar?';
$string['answers'] = 'Svar';
$string['answersingleno'] = 'Flere svar tilladt';
$string['answersingleyes'] = 'Kun ét svar';
$string['answertoolong'] = 'Svar for langt efter linje {$a} (maks. 255 tegn)';
$string['anytags'] = 'Eventuelle tags';
$string['aon'] = 'AON format';
$string['areyousureremoveselected'] = 'Er du sikker på, at du vil fjerne alle de valgte spørgsmål?';
$string['asshownoneditscreen'] = 'Som vist på redigeringsskærmen';
$string['attempt'] = 'Forsøg {$a}';
$string['attemptalreadyclosed'] = 'Dette forsøg er allerede afsluttet.';
$string['attemptclosed'] = 'Forsøget er endnu ikke afsluttet';
$string['attemptduration'] = 'Varighed';
$string['attemptedon'] = 'Forsøgt den';
$string['attempterror'] = 'Du har ikke tilladelse til at forsøge denne quiz på nuværende tidspunkt, fordi: {$a}';
$string['attempterrorcontentchange'] = 'Denne quizforhåndsvisning eksisterer ikke længere. (Når en quiz redigeres, slettes alle igangværende forhåndsvisninger automatisk.)';
$string['attempterrorcontentchangeforuser'] = 'Dette quizforsøg eksisterer ikke længere.';
$string['attempterrorinvalid'] = 'Ugyldig quizforsøg ID';
$string['attemptfirst'] = 'Første forsøg';
$string['attemptgradeddelay'] = 'Forsinkelse af meddelelse om vurdering af aflevering';
$string['attemptgradeddelay_desc'] = 'Der anvendes en forsinkelse, før der sendes meddelelser om bedømte forsøg for at give læreren tid til at redigere karakteren.';
$string['attemptincomplete'] = 'Den pågældende forsøg (af {$a}) er endnu ikke afsluttet.';
$string['attemptlast'] = 'Sidste forsøg';
$string['attemptnumber'] = 'Forsøg';
$string['attemptquiz'] = 'Forsøg quiz';
$string['attemptquiznow'] = 'Forsøg quiz nu';
$string['attemptreviewtitle'] = '{$a}: Gennemgang af forsøg';
$string['attemptreviewtitlepaged'] = '{$a->name}: Gennemgang af forsøg (side {$a->currentpage} af {$a->totalpages})';
$string['attempts'] = 'Forsøg';
$string['attempts_help'] = 'Det samlede antal tilladte forsøg (ikke antallet af ekstra forsøg).';
$string['attemptsallowed'] = 'Tilladte forsøg';
$string['attemptsdeleted'] = 'Quizforsøg slettet';
$string['attemptselection'] = 'Vælg hvilke forsøg der skal analyseres pr. bruger:';
$string['attemptsexist'] = 'Du kan ikke længere tilføje eller fjerne spørgsmål.';
$string['attemptsnum'] = 'Forsøg: {$a}';
$string['attemptsnumthisgroup'] = 'Forsøg: {$a->total} ({$a->group} fra denne brugergruppe)';
$string['attemptsnumyourgroups'] = 'Forsøg: {$a->total} ({$a->group} fra dine brugergrupper)';
$string['attemptsonly'] = 'Vis kun studerende med forsøg';
$string['attemptstate'] = 'Status';
$string['attemptstillinprogress'] = 'Forsøg er stadig i gang';
$string['attemptsummarytitle'] = '{$a}: Forsøgsoversigt';
$string['attemptsunlimited'] = 'Ubegrænsede forsøg';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (side {$a->currentpage} af {$a->totalpages})';
$string['autosaveperiod'] = 'Forsinkelse ved automatisk gemning';
$string['autosaveperiod_desc'] = 'Svar kan gemmes automatisk under quizforsøg. Svarene gemmes, hver gang et ændres, og derefter efter denne forsinkelse. Der er en afvejning: en kortere forsinkelse øger serverbelastningen, men reducerer chancen for, at studerende mister deres arbejde. Hvis du vil gøre denne forsinkelse meget kortere, bør du ændre værdien gradvist og overvåge serverbelastningen. Hvis belastningen bliver for høj, skal du gøre forsinkelsen længere igen. At indstille forsinkelsen til 0 slår automatisk gemning fra.';
$string['averageattemptsperstudent'] = 'Gennemsnitlige forsøg pr. studerende';
$string['back'] = 'Tilbage til forhåndsvisning af spørgsmål';
$string['backtocourse'] = 'Tilbage til kurset';
$string['backtoquestionlist'] = 'Tilbage til spørgsmålslisten';
$string['backtoquiz'] = 'Tilbage til redigering af quiz';
$string['banknotfound'] = 'Spørgsmålsbanken blev ikke fundet, venligst søg igen';
$string['bestgrade'] = 'Bedste karakter';
$string['bothattempts'] = 'Vis studerende med og uden forsøg';
$string['browsersecurity'] = 'Browsersikkerhed';
$string['browsersecurity_help'] = 'If "Full screen pop-up with some JavaScript security" is selected,

* The quiz will only start if the student has a JavaScript-enabled web-browser
* The quiz appears in a full screen popup window that covers all the other windows and has no navigation controls
* Students are prevented, as far as is possible, from using facilities like copy and paste';
$string['cachedef_overrides'] = 'Information om bruger- og gruppeoverstyring';
$string['calculated'] = 'Beregnet';
$string['calculatedquestion'] = 'Beregnet spørgsmål understøttes ikke på linje {$a}. Spørgsmålet vil blive ignoreret';
$string['cannotcreatepath'] = 'Stien kan ikke oprettes ({$a})';
$string['cannoteditafterattempts'] = 'Du kan ikke tilføje eller fjerne spørgsmål, fordi denne quiz har forsøg. ({$a})';
$string['cannotfindprevattempt'] = 'Kan ikke finde tidligere forsøg at bygge videre på.';
$string['cannotfindquestionregard'] = 'Det lykkedes ikke at hente spørgsmål til genvurdering!';
$string['cannotinsert'] = 'Kan ikke indsætte spørgsmål';
$string['cannotinsertrandomquestion'] = 'Kunne ikke indsætte nyt tilfældigt spørgsmål!';
$string['cannotloadquestion'] = 'Kunne ikke indlæse spørgsmålsmuligheder';
$string['cannotloadtypeinfo'] = 'Det er ikke muligt at indlæse spørgsmålstype specifik spørgsmål information';
$string['cannotopen'] = 'Kan ikke åbne eksportfil ({$a})';
$string['cannotremoveallsectionslots'] = 'Du har valgt alle spørgsmål under sektionen \'{$a}\'. Det er ikke tilladt at fjerne alle spørgsmål under en sektion.';
$string['cannotremoveslots'] = 'Kan ikke fjerne spørgsmål';
$string['cannotrestore'] = 'Kunne ikke gendanne spørgsmålssessioner';
$string['cannotreviewopen'] = 'Du kan ikke gennemgå dette forsøg, det er stadig åbent.';
$string['cannotsavelayout'] = 'Kunne ikke gemme layout';
$string['cannotsavenumberofquestion'] = 'Kunne ikke gemme antallet af spørgsmål pr. side';
$string['cannotsavequestion'] = 'Kan ikke gemme spørgelisten';
$string['cannotsetgrade'] = 'Kunne ikke indstille en ny maksimal karakter for quizzen';
$string['cannotsetsumgrades'] = 'Det lykkedes ikke at indstille sumgrades';
$string['cannotstartgradesmismatch'] = 'Kan ikke starte et forsøg på denne quiz. Quizzen er indstillet til at blive bedømt ud fra {$a->grade}, men ingen af spørgsmålene i quizzen har en bedømmelse. Dette kan rettes på siden \'Rediger quiz\'.';
$string['cannotstartmissingquestion'] = 'Kan ikke starte et forsøg på denne quiz. Quizdefinitionen inkluderer et spørgsmål, der ikke eksisterer.';
$string['cannotstartnoquestions'] = 'Kan ikke starte et forsøg på denne quiz. Quizzen er endnu ikke blevet oprettet. Ingen spørgsmål er blevet tilføjet.';
$string['cannotwrite'] = 'Kan ikke skrive til eksportfil ({$a})';
$string['canredoquestions'] = 'Tillad genaflevering inden for et forsøg';
$string['canredoquestions_desc'] = 'If enabled, after finishing attempting a question, a \'Try another question like this one\' button is displayed. This allows for a similar question (selected randomly) to be attempted, or the same question again, without the entire quiz attempt having to be submitted and another attempt started. This option is useful for practice quizzes.

This setting only affects questions and behaviours (such as immediate feedback or interactive with multiple tries) where it is possible to finish a question before the attempt is submitted.';
$string['canredoquestions_help'] = 'If enabled, after finishing attempting a question, a \'Try another question like this one\' button is displayed. This allows for a similar question (selected randomly) to be attempted, or the same question again, without the entire quiz attempt having to be submitted and another attempt started. This option is useful for practice quizzes.

This setting only affects questions and behaviours (such as immediate feedback or interactive with multiple tries) where it is possible to finish a question before the attempt is submitted.';
$string['canredoquestionsyes'] = 'Ja, giv muligheden for at prøve et andet spørgsmål';
$string['caseno'] = 'Nej, store og små bogstaver er uden betydning';
$string['casesensitive'] = 'Store og små bogstaver';
$string['caseyes'] = 'Ja, store og små bogstaver skal matche';
$string['categoryadded'] = 'Kategorien \'{$a}\' blev tilføjet';
$string['categorydeleted'] = 'Kategorien \'{$a}\' blev slettet';
$string['categorynoedit'] = 'Du har ikke redigeringsrettigheder i kategorien \'{$a}\'.';
$string['categoryupdated'] = 'Kategorien blev opdateret med succes';
$string['close'] = 'Luk vindue';
$string['closebeforeopen'] = 'Lukningsdatoen skal være efter åbningsdatoen.';
$string['closed'] = 'Lukket';
$string['closepreview'] = 'Luk forhåndsvisning';
$string['closereview'] = 'Nærmere gennemgang';
$string['comment'] = 'Kommentar';
$string['commentorgrade'] = 'Lav kommentar eller overskriv karakter';
$string['comments'] = 'Kommentarer';
$string['completedon'] = 'Fuldført';
$string['completionattemptsexhausted'] = 'Bestået karakter eller alle tilgængelige forsøg gennemført';
$string['completionattemptsexhausted_help'] = 'Marker quiz som fuldført, når eleven har udtømt det maksimale antal forsøg.';
$string['completiondetail:minattempts'] = 'Foretag forsøg: {$a}';
$string['completiondetail:passorexhaust'] = 'Modtag en bestået karakter eller gennemfør alle tilgængelige forsøg';
$string['completionminattempts'] = 'Minimum antal forsøg';
$string['completionminattemptsdesc'] = 'Minimum antal forsøg der kræves: {$a}';
$string['completionminattemptserror'] = 'Det minimale antal forsøg skal være lig med eller lavere end det tilladte antal forsøg.';
$string['completionpassorattemptsexhausteddesc'] = 'Studerende skal opnå en bestået karakter, eller udtømme alle tilgængelige forsøg for at gennemføre denne aktivitet';
$string['configadaptive'] = 'Hvis du vælger Ja for denne mulighed, vil eleven blive tilladt flere svar på et spørgsmål, selv inden for det samme forsøg på quizzen.';
$string['configattemptsallowed'] = 'Begrænsning af antallet af forsøg, som studerende har tilladelse til ved quizzen.';
$string['configdecimaldigits'] = 'Antal cifre der skal vises efter decimalpunktet når karakterer vises.';
$string['configdecimalplaces'] = 'Antal decimaler, der skal vises efter kommaet, når karakterer for quizzen vises.';
$string['configdecimalplacesquestion'] = 'Antal decimaler der skal vises efter kommaet, når karakteren for individuelle spørgsmål præsenteres.';
$string['configdelay1'] = 'Hvis du indstiller en tidsforsinkelse, skal en studerende vente i den tid, før de kan forsøge en quiz efter det første forsøg.';
$string['configdelay1st2nd'] = 'Hvis du sætter en tidsforsinkelse her, kan studenten ikke starte deres anden aflevering, før der er gået så lang tid siden slutningen af deres første aflevering.';
$string['configdelay2'] = 'Hvis du sætter en tidsforsinkelse her, skal en studerende vente i den tid, før de kan forsøge deres tredje eller senere forsøg.';
$string['configdelaylater'] = 'Hvis du indstiller en tidsforsinkelse her, kan studenten ikke starte deres tredje, fjerde, ... forsøg, før der er gået så meget tid siden afslutningen af deres tidligere forsøg.';
$string['configeachattemptbuildsonthelast'] = 'Hvis flere forsøg er tilladt, indeholder hvert nyt forsøg resultaterne fra det foregående forsøg.';
$string['configgrademethod'] = 'Når flere forsøg er tilladt, hvilken metode skal anvendes til at beregne studentens endelige karakter for quizzen.';
$string['configintro'] = 'De værdier, du angiver her, definerer de standardværdier, der anvendes i indstillingsformularen, når du opretter en ny quiz. Du kan også konfigurere, hvilke quizindstillinger der betragtes som avancerede.';
$string['configintroglobal'] = 'Disse indstillinger styrer den systemdækkende opførsel af Quiz-aktiviteten';
$string['configmaximumgrade'] = 'Den standardkarakter, som quizkarakteren skaleres til.';
$string['confignavmethod'] = 'I fri navigation kan spørgsmål besvares i vilkårlig rækkefølge ved hjælp af navigation. I sekventiel navigation skal spørgsmål besvares i strengt rækkefølge.';
$string['confignewpageevery'] = 'Når du tilføjer spørgsmål til quizsiden, vil sideskift automatisk blive indsat i henhold til den indstilling, du vælger her.';
$string['configoutcomesadvanced'] = 'Hvis denne mulighed er aktiveret, så er resultaterne på quizredigeringsformularen avancerede indstillinger.';
$string['configpenaltyscheme'] = 'Der trækkes en straf fra for hvert forkert svar i adaptiv tilstand.';
$string['configpopup'] = 'Tving forsøget til at åbne i et popup-vindue, og brug JavaScript-tricks til at forsøge at begrænse kopiering og indsættelse mv. under quizforsøg.';
$string['configrequirepassword'] = 'Studerende skal indtaste denne adgangskode, før de kan forsøge quizzen.';
$string['configrequiresubnet'] = 'Studerende kan kun forsøge quizzen fra disse computere.';
$string['configreviewoptions'] = 'Disse muligheder styrer, hvilke oplysninger brugerne kan se, når de gennemgår et quizforsøg eller ser på quizrapporterne.';
$string['configshowblocks'] = 'Vis blokke under quizforsøg.';
$string['configshowuserpicture'] = 'Vis brugerens billede på skærmen under forsøg.';
$string['configshufflewithin'] = 'Hvis du aktiverer denne mulighed, vil delene, der udgør de enkelte spørgsmål, blive tilfældigt blandet hver gang en studerende påbegynder et forsøg på denne quiz, forudsat at muligheden også er aktiveret i spørgsmålindstillingerne.';
$string['configtimelimit'] = 'Standard tidsgrænse for quizzer i minutter. 0 betyder ingen tidsgrænse.';
$string['configtimelimitsec'] = 'Standard tidsgrænse for quizzer i sekunder. 0 betyder ingen tidsgrænse.';
$string['configurerandomquestion'] = 'Konfigurer spørgsmål';
$string['confirmclose'] = 'Når du har indsendt dine svar, vil du ikke kunne ændre dem.';
$string['confirmremovequestion'] = 'Er du sikker på, at du vil fjerne dette {$a} spørgsmål?';
$string['confirmremovesectionheading'] = 'Er du sikker på, at du vil fjerne overskriften \'{$a}\'?';
$string['confirmserverdelete'] = 'Er du sikker på, at du vil fjerne serveren <b>{$a}</b> fra listen?';
$string['connectionerror'] = 'Network connection lost. (Autosave failed).

Make a note of any responses entered on this page in the last few minutes, then try to re-connect.

Once connection has been re-established, your responses should be saved and this message will disappear.';
$string['connectionok'] = 'Netværksforbindelsen er genoprettet. Du kan fortsætte sikkert.';
$string['containercategorycreated'] = 'Denne kategori er oprettet for at gemme alle de oprindelige kategorier, der er flyttet til sites niveau på grund af de angivne årsager nedenfor.';
$string['continueattemptquiz'] = 'Fortsæt dit forsøg';
$string['continuepreview'] = 'Fortsæt den sidste forhåndsvisning';
$string['copyingfrom'] = 'Oprettelse af en kopi af spørgsmålet \'{$a}\'';
$string['copyingquestion'] = 'Kopiere et spørgsmål';
$string['correct'] = 'Korrekt';
$string['correctanswer'] = 'Korrekt svar';
$string['correctanswerformula'] = 'Formel for korrekt svar';
$string['correctansweris'] = 'Korrekt svar: {$a}';
$string['correctanswerlength'] = 'Signifikante cifre';
$string['correctanswers'] = 'Korrekte svar';
$string['correctanswershows'] = 'Korrekt svar vises';
$string['corrresp'] = 'Korrekt svar';
$string['countdown'] = 'Nedtælling';
$string['countdownfinished'] = 'Quizzen lukker, du bør aflevere dine svar nu.';
$string['countdowntenminutes'] = 'Quizzen vil blive lukket om ti minutter.';
$string['coursetestmanager'] = 'Format for kursustestadministrator';
$string['createcategoryandaddrandomquestion'] = 'Opret kategori og tilføj tilfældig spørgsmål';
$string['createfirst'] = 'Du skal først oprette nogle kortsvars spørgsmål.';
$string['createmultiple'] = 'Tilføj flere tilfældige spørgsmål til quizzen';
$string['createnewquestion'] = 'Opret ny spørgsmål';
$string['createquestionandadd'] = 'Opret et nyt spørgsmål og tilføj det til quizzen.';
$string['currentbank'] = 'Nuværende bank: {$a}';
$string['custom'] = 'Brugerdefineret format';
$string['dataitemneed'] = 'Du skal tilføje mindst ét sæt af dataelementer for at få et gyldigt spørgsmål';
$string['datasetdefinitions'] = 'Genanvendelige datasætdefinitioner for kategori {$a}';
$string['datasetnumber'] = 'Nummer';
$string['daysavailable'] = 'Tilgængelige dage';
$string['decimaldigits'] = 'Decimaler i karakterer';
$string['decimalplaces'] = 'Decimaler i karakterer';
$string['decimalplaces_help'] = 'Denne indstilling angiver antallet af decimaler, der vises efter kommaet, når karakterer vises. Den påvirker kun visningen af karakterer, ikke de karakterer, der er gemt i databasen, eller de interne beregninger, som udføres med fuld nøjagtighed.';
$string['decimalplacesquestion'] = 'Decimaler i karakterer for spørgsmål';
$string['decimalplacesquestion_help'] = 'Antallet af decimaler, der vises efter decimaltegnet, når karaktererne for individuelle spørgsmål vises.';
$string['decimalpoints'] = 'Decimaler';
$string['default'] = 'Standard';
$string['defaultgrade'] = 'Standard spørgsmålskarakter';
$string['defaultinfo'] = 'Den standardkategori for spørgsmål.';
$string['defaultsettings'] = 'Standard quizindstillinger';
$string['delay1'] = 'Tidsforsinkelse mellem første og anden forsøg';
$string['delay1st2nd'] = 'Tvangsdelay mellem 1. og 2. forsøg';
$string['delay1st2nd_help'] = 'Hvis aktiveret, skal en studerende vente på, at den angivne tid forløber, før de kan forsøge quizzen en anden gang.';
$string['delay2'] = 'Tidsforsinkelse mellem senere forsøg';
$string['delaylater'] = 'Tvangsdelay mellem senere forsøg';
$string['delaylater_help'] = 'Hvis aktiveret, skal en studerende vente på, at den angivne tid forløber, før der forsøges på quizzen en tredje gang og ved eventuelle efterfølgende gange.';
$string['deleteattemptcheck'] = 'Er du helt sikker på, at du vil slette disse forsøg fuldstændigt?';
$string['deleteselected'] = 'Slet valgte';
$string['deletingquestionattempts'] = 'Sletning af spørgsmålforsøg';
$string['description'] = 'Beskrivelse';
$string['disabled'] = 'Deaktiveret';
$string['displayoptions'] = 'Visningsmuligheder';
$string['donotuseautosave'] = 'Brug ikke auto-save';
$string['download'] = 'Klik for at downloade den eksporterede kategori fil';
$string['downloadextra'] = '(filen er også gemt i kursusfilerne i /backupdata/quiz mappen)';
$string['dragtoafter'] = 'Efter {$a}';
$string['dragtostart'] = 'Til starten';
$string['duedate'] = 'Afleveringsfrist';
$string['duplicateresponse'] = 'Denne aflevering er blevet ignoreret, fordi du tidligere har givet et tilsvarende svar.';
$string['eachattemptbuildsonthelast'] = 'Hver forsøg bygger videre på det sidste';
$string['eachattemptbuildsonthelast_help'] = 'Hvis flere forsøg er tilladt, og denne indstilling er aktiveret, vil hvert nyt quizforsøg indeholde resultaterne fra det tidligere forsøg. Dette gør det muligt at gennemføre en quiz over flere forsøg.';
$string['edit_slotdisplaynumber_hint'] = 'Rediger spørgsmålsnummer (maksimum 16 tegn)';
$string['edit_slotdisplaynumber_label'] = 'Ny værdi for {$a}';
$string['editcategories'] = 'Rediger kategorier';
$string['editcategory'] = 'Rediger kategori';
$string['editcatquestions'] = 'Rediger kategori spørgsmål';
$string['editingquestion'] = 'Redigering af et spørgsmål';
$string['editingquiz'] = 'Redigering af quiz';
$string['editingquiz_help'] = 'Når man opretter en quiz, er de vigtigste begreber:

* Quizzen, som indeholder spørgsmål fordelt over en eller flere sider
* Spørgsmålsbanken, som gemmer kopier af alle spørgsmål organiseret i kategorier
* Tilfældige spørgsmål – en studerende får forskellige spørgsmål, hver gang de prøver quizzen, og forskellige studerende kan få forskellige spørgsmål';
$string['editingquiz_link'] = 'mod/quiz/rediger';
$string['editingquizx'] = 'Redigering af quiz: {$a}';
$string['editmaxmark'] = 'Rediger maksimumskarakter';
$string['editoverride'] = 'Rediger undtagelse';
$string['editqcats'] = 'Rediger spørgsmålskategorier';
$string['editquestion'] = 'Rediger spørgsmål';
$string['editquestions'] = 'Rediger spørgsmål';
$string['editquiz'] = 'Rediger quiz';
$string['editquizquestions'] = 'Rediger quizspørgsmål';
$string['emailconfirmautosubmitsmall'] = 'Tak for at du har indsendt dine svar til \'{$a->quizname}\'';
$string['emailconfirmbody'] = 'Hi {$a->username},

Thank you for submitting your answers to \'{$a->quizname}\' in course \'{$a->coursename}\' at {$a->submissiontime}.

This message confirms that your answers have been saved.

You can access this quiz at {$a->quizurl}.';
$string['emailconfirmbodyautosubmit'] = 'Hi {$a->username},

The time for the quiz \'{$a->quizname}\' in the course \'{$a->coursename}\' expired. Your answers were submitted automatically at {$a->submissiontime}.

This message confirms that your answers have been saved.

You can access this quiz at {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Tak for at du har indsendt dine svar til \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Bekræftelse af aflevering: {$a->quizname}';
$string['emailmanualgradedbody'] = 'Hi {$a->studentname},

Your answers to \'{$a->quizname}\' in course \'{$a->coursename}\' at {$a->attempttimefinish} have now been graded.

You will be able to view your score and feedback by visiting \'{$a->quizurl}\' and reviewing your attempt.';
$string['emailmanualgradedsubject'] = 'Din forsøg på {$a->quizname} er blevet bedømt';
$string['emailnotifybody'] = 'Hi {$a->username},

{$a->studentname} has completed \'{$a->quizname}\' ({$a->quizurl}) in course \'{$a->coursename}\'.

You can review this attempt at {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} har gennemført {$a->quizname}. Se {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} har gennemført {$a->quizname}';
$string['emailoverduebody'] = 'Hi {$a->studentname},

You started an attempt at \'{$a->quizname}\' in course \'{$a->coursename}\', but you never submitted it. It should have been submitted by {$a->attemptduedate}.

If you would still like to submit this attempt, please go to {$a->attemptsummaryurl} and click the submit button. You must do this before {$a->attemptgraceend} otherwise your attempt will not be counted.';
$string['emailoverduesmall'] = 'Du har ikke indsendt din aflevering til {$a->quizname}. Gå venligst til {$a->attemptsummaryurl} inden {$a->attemptgraceend}, hvis du stadig ønsker at indsende.';
$string['emailoverduesubject'] = 'Forsøg nu forfaldet: {$a->quizname}';
$string['empty'] = 'Tom';
$string['enabled'] = 'Aktiveret';
$string['endtest'] = 'Afslut forsøg ...';
$string['erroraccessingreport'] = 'Du kan ikke få adgang til denne rapport';
$string['errorinquestion'] = 'Fejl i spørgsmålet';
$string['errormissingquestion'] = 'Fejl: Systemet mangler spørgsmålet med id {$a}';
$string['errornotnumbers'] = 'Fejl - svarene skal være numeriske';
$string['errorunexpectedevent'] = 'Uventet begivenhedskode {$a->event} fundet for spørgsmål {$a->questionid} i forsøg {$a->attemptid}.';
$string['essay'] = 'Essay';
$string['essayquestions'] = 'Spørgsmål';
$string['eventattemptautosaved'] = 'Quizforsøg er automatisk gemt';
$string['eventattemptdeleted'] = 'Quizforsøg slettet';
$string['eventattemptmanualgradingcomplete'] = 'Manuel bedømmelse af quizforsøg er fuldført';
$string['eventattemptpreviewstarted'] = 'Forhåndsvisning af quizforsøg er startet';
$string['eventattemptquestionrestarted'] = 'Quizforsøg spørgsmål genstartet';
$string['eventattemptreviewed'] = 'Quizforsøg gennemgået';
$string['eventattemptsummaryviewed'] = 'Oversigt over quizforsøg set';
$string['eventattemptupdated'] = 'Forsøg på quiz opdateret';
$string['eventattemptviewed'] = 'Quizforsøg set';
$string['eventeditpageviewed'] = 'Quiz redigeringsside vist';
$string['eventoverridecreated'] = 'Quiz-undtagelse oprettet';
$string['eventoverridedeleted'] = 'Quiz-undtagelse slettet';
$string['eventoverrideupdated'] = 'Quiz-undtagelse opdateret';
$string['eventpagebreakcreated'] = 'Sideskift oprettet';
$string['eventpagebreakdeleted'] = 'Sideskift slettet';
$string['eventquestionmanuallygraded'] = 'Spørgsmål manuelt bedømt';
$string['eventquizattemptabandoned'] = 'Quizforsøg opgivet';
$string['eventquizattemptgraded'] = 'Quizforsøg bedømt';
$string['eventquizattemptregraded'] = 'Quizforsøg er genbedømt';
$string['eventquizattemptreopened'] = 'Quizforsøg genåbnet';
$string['eventquizattemptstarted'] = 'Quizforsøg påbegyndt';
$string['eventquizattemptsubmitted'] = 'Quizforsøg indsendt';
$string['eventquizattempttimelimitexceeded'] = 'Tidsgrænsen for quizforsøg er overskredet';
$string['eventquizgradeitemcreated'] = 'Quiz karakterelement oprettet';
$string['eventquizgradeitemdeleted'] = 'Quiz karakterelement slettet';
$string['eventquizgradeitemorderchanged'] = 'Rækkefølgen af quiz bedømmelsesgenstande er ændret';
$string['eventquizgradeitemupdated'] = 'Quiz karakterelement opdateret';
$string['eventquizgradeupdated'] = 'Quizkarakter opdateret';
$string['eventquizrepaginated'] = 'Quiz er genopdelt på sider';
$string['eventreportviewed'] = 'Quizrapporten er blevet set';
$string['eventsectionbreakcreated'] = 'Afsnitsopdeling oprettet';
$string['eventsectionbreakdeleted'] = 'Afsnitsopdeling slettet';
$string['eventsectionshuffleupdated'] = 'Sektionens blanding opdateret';
$string['eventsectiontitleupdated'] = 'Afsnitstitel opdateret';
$string['eventslotcreated'] = 'Slot oprettet';
$string['eventslotdeleted'] = 'Slot slettet';
$string['eventslotdisplayedquestionnumberupdated'] = 'Slot viste spørgsmål nummer opdateret';
$string['eventslotgradeitemupdated'] = 'Slot karakterelement opdateret';
$string['eventslotmarkupdated'] = 'Slotmærket er opdateret';
$string['eventslotmoved'] = 'Slot flyttet';
$string['eventslotrequirepreviousupdated'] = 'Slot kræver tidligere opdatering';
$string['eventslotversionupdated'] = 'Slotversionen er opdateret';
$string['everynquestions'] = 'Hver {$a} spørgsmål';
$string['everyquestion'] = 'Hvert spørgsmål';
$string['everythingon'] = 'Alt på';
$string['existingcategory'] = 'Eksisterende kategori';
$string['exportcategory'] = 'eksportér kategori';
$string['exporterror'] = 'Der opstod en fejl under eksportbehandlingen';
$string['exportingquestions'] = 'Spørgsmålene eksporteres til fil';
$string['exportname'] = 'Filnavn';
$string['exportquestions'] = 'Eksporter spørgsmål til fil';
$string['extraattemptrestrictions'] = 'Ekstra restriktioner på forsøg';
$string['false'] = 'Falsk';
$string['feedback'] = 'Feedback';
$string['feedbackerrorboundaryformat'] = 'Feedback karaktergrænser skal enten være en procentdel eller et tal. Den værdi, du indtastede i grænse {$a}, er ikke genkendt.';
$string['feedbackerrorboundaryoutofrange'] = 'Feedback karaktergrænser skal være mellem 0% og 100%. Den værdi, du indtastede i grænsen {$a}, er uden for intervallet.';
$string['feedbackerrorjunkinboundary'] = 'Du skal udfylde feedback karaktergrænsefelterne uden at efterlade nogen huller.';
$string['feedbackerrorjunkinfeedback'] = 'Du skal udfylde feedbackfelterne uden at efterlade nogen huller.';
$string['feedbackerrororder'] = 'Feedback karaktergrænserne skal være i rækkefølge, højeste først. Den værdi, du indtastede i grænsen {$a}, er ude af rækkefølge.';
$string['file'] = 'Fil';
$string['fileformat'] = 'Filformat';
$string['fillcorrect'] = 'Udfyld med korrekt';
$string['filloutnumericalanswer'] = 'Du angiver mindst ét muligt svar og tolerance. Det første matchende svar vil blive brugt til at bestemme karakteren og feedbacken. Hvis du giver noget feedback uden svar til sidst, vil det blive vist til studerende, hvis svar ikke matcher nogen af de andre svar.';
$string['filloutoneanswer'] = 'Du skal angive mindst ét muligt svar. Svar, der efterlades tomme, vil ikke blive brugt. \'*\' kan anvendes som et wildcard til at matche enhver karakter. Det første matchende svar vil blive brugt til at bestemme karakteren og feedbacken.';
$string['filloutthreequestions'] = 'Du skal angive mindst tre spørgsmål med matchende svar. Du kan give ekstra forkerte svar ved at angive et svar med et tomt spørgsmål. Indtastninger, hvor både spørgsmålet og svaret er tomme, vil blive ignoreret.';
$string['fillouttwochoices'] = 'Du skal udfylde mindst to valgmuligheder. Valgmuligheder, der efterlades tomme, vil ikke blive brugt.';
$string['finishattemptdots'] = 'Afslut forsøg...';
$string['finishreview'] = 'Afslut gennemgang';
$string['forceregeneration'] = 'tvinge regenerering';
$string['formatnotfound'] = 'Import/eksportformat {$a} blev ikke fundet';
$string['formulaerror'] = 'Formelfejl!';
$string['fractionsaddwrong'] = 'De positive karakterer, du har valgt, summerer ikke til 100%<br />I stedet summerer de til {$a}%<br />Ønsker du at gå tilbage og rette dette spørgsmål?';
$string['fractionsnomax'] = 'En af svarene skal være 100%, så det er<br />muligt at få en fuld karakter for dette spørgsmål.<br />Ønsker du at gå tilbage og rette dette spørgsmål?';
$string['fromfile'] = 'fra fil:';
$string['functiondisabledbysecuremode'] = 'Den funktionalitet er i øjeblikket deaktiveret';
$string['generalfeedback'] = 'Generel feedback';
$string['generalfeedback_help'] = 'Generel feedback er tekst, der vises, efter at et spørgsmål er blevet forsøgt. I modsætning til feedback for et specifikt spørgsmål, som afhænger af det givne svar, vises den samme generelle feedback altid.';
$string['gobacktoquiz'] = 'Gå tilbage';
$string['graceperiod'] = 'Afleverings grace periode';
$string['graceperiod_desc'] = 'Hvis hvad der skal gøres, når tiden udløber, er indstillet til \'Der er en graceperiode...\', så er dette den standardmængde ekstra tid, der er tilladt.';
$string['graceperiod_help'] = 'Hvis hvad der skal gøres, når tiden udløber, er indstillet til \'Der er en graceperiode...\', så er dette den mængde ekstra tid, der er tilladt.';
$string['graceperiodmin'] = 'Sidste afleverings grace-periode';
$string['graceperiodmin_desc'] = 'Der er et potentielt problem lige ved slutningen af quizzen. På den ene side ønsker vi at lade studerende fortsætte med at arbejde helt indtil det sidste sekund - med hjælp fra timeren, der automatisk afleverer quizzen, når tiden er gået. På den anden side kan serveren så blive overbelastet og tage noget tid at behandle svarene. Derfor vil vi acceptere svar i op til denne tid efter, at tiden er udløbet, så de ikke straffes for, at serveren er langsom. Dog kan den studerende snyde og få så mange sekunder til at besvare quizzen. Du skal lave en afvejning baseret på, hvor meget du stoler på din servers ydeevne under quizzer.';
$string['graceperiodtoosmall'] = 'Nåleperioden skal være mere end {$a}.';
$string['gradeall'] = 'Bedøm alle';
$string['gradeaverage'] = 'Gennemsnitlig karakter';
$string['gradeboundary'] = 'Karaktergrænse';
$string['gradeessays'] = 'Bedøm opgaver';
$string['gradehighest'] = 'Højeste karakter';
$string['gradeitemdefaultname'] = 'Nyt karakterelement {$a}';
$string['gradeitemdelete'] = 'Slet karakterelement {$a}';
$string['gradeitemedit'] = 'Rediger navn på karakterelement {$a}';
$string['gradeitemmarkscheme'] = 'Tildel karakterelementer';
$string['gradeitemnewname'] = 'Nyt navn til karakterelement {$a}';
$string['gradeitemnoneselected'] = '[ingen]';
$string['gradeitemnoslots'] = 'Denne quiz har endnu ingen spørgsmål. Venligst tilføj spørgsmål først, og vend derefter tilbage hertil for at oprette bedømmelsesposter.';
$string['gradeitems'] = 'Karakterelementer';
$string['gradeitemsautosetup'] = 'Opret en karakter for hver sektion';
$string['gradeitemsetup'] = 'Opsætning af karakterelementer';
$string['gradeitemsnoneyet'] = 'Opret karakterelementer inden for dit quiz. Tildel spørgsmål eller quizsektioner til disse karakterelementer for at opdele karakterresultaterne i forskellige områder.';
$string['gradeitemsremoveall'] = 'Nulstil opsætning';
$string['gradeitemsremoveallconfirm'] = 'Nulstil opsætning af karakterelementer?';
$string['gradeitemsremoveallmessage'] = 'Dette vil slette alle karakterelementer og fjerne tildelingen af spørgsmål og sektioner fra dem.<br><br>Denne handling vil ikke påvirke spørgsmålene og sektionerne selv, ej heller eksisterende forsøg inden for quizzen.';
$string['gradeitemsremovealltitle'] = 'Nulstil opsætning af karakterelementer';
$string['grademethod'] = 'Bedømmelsesmetode';
$string['grademethod_help'] = 'When multiple attempts are allowed, the following methods are available for calculating the final quiz grade:

* Highest grade of all attempts
* Average (mean) grade of all attempts
* First attempt (all other attempts are ignored)
* Last attempt (all other attempts are ignored)';
$string['gradesdeleted'] = 'Quizkarakterer slettet';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Beståelsesgraden kan ikke være nul, da denne quiz har sin gennemførelsesmetode indstillet til at kræve en beståelsesgrad. Venligst indstil en værdi, der ikke er nul.';
$string['gradetopassoutof'] = 'Beståelseskarakter: {$a->grade} ud af {$a->maxgrade}';
$string['gradingdetails'] = 'Karakterer for denne aflevering: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Med tidligere sanktioner giver dette <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Denne aflevering medførte en straf på {$a}.';
$string['gradingdetailszeropenalty'] = 'Du blev ikke straffet for denne aflevering.';
$string['gradingmethod'] = 'Bedømmelsesmetode: {$a}';
$string['groupoverrides'] = 'Brugergruppeundtagelser';
$string['groupoverridesdeleted'] = 'Brugergruppeundtagelser slettet';
$string['groupsnone'] = 'Ingen brugergrupper du kan få adgang til.';
$string['guestsno'] = 'Beklager, gæster kan ikke se eller forsøge at tage quizzer';
$string['hidebreaks'] = 'Skjul sideskift';
$string['hidereordertool'] = 'Skjul værktøjet til omarrangering';
$string['history'] = 'Historik over svar:';
$string['howquestionsbehave_desc'] = 'Standardindstilling for, hvordan spørgsmål opfører sig i en quiz.';
$string['imagedisplay'] = 'Billede til visning';
$string['import_help'] = 'This function allows you to import questions from external text files.

If your file contains non-ascii characters then it must use UTF-8 encoding. Be particularly cautious with files generated by Microsoft Office applications, as these commonly use special encoding which will not be handled correctly.

Import and Export formats are a pluggable resource. Other optional formats may be available in the Modules and Plugins database.';
$string['import_link'] = 'spørgsmål/import';
$string['importcategory'] = 'importer kategori';
$string['importerror'] = 'Der opstod en fejl under importbehandlingen';
$string['importfilearea'] = 'Importer fra fil, der allerede er i kursusfilerne...';
$string['importfileupload'] = 'Importér fra filupload...';
$string['importfromthisfile'] = 'Importer fra denne fil';
$string['importingquestions'] = 'Importer {$a} spørgsmål fra fil';
$string['importmax10error'] = 'Der er en fejl i spørgsmålet. Du må ikke have mere end ti svar';
$string['importmaxerror'] = 'Der er en fejl i spørgsmålet. Der er for mange svar.';
$string['importquestions'] = 'Importer spørgsmål fra fil';
$string['inactiveoverridehelp'] = '* Denne undtagelse er inaktiv, fordi brugerens adgang til aktiviteten er begrænset. Dette kan skyldes brugergrupper eller rollefordelinger, andre adgangsbegrænsninger, eller at aktiviteten er skjult.';
$string['incorrect'] = 'Forkert';
$string['indicator:cognitivedepth'] = 'Kognitiv quiz';
$string['indicator:cognitivedepth_help'] = 'Denne indikator er baseret på den kognitive dybde, som eleven har nået i en Quiz-aktivitet.';
$string['indicator:cognitivedepthdef'] = 'Kognitiv quiz';
$string['indicator:cognitivedepthdef_help'] = 'Deltageren har nået denne procentdel af den kognitive engagement, der tilbydes af Quiz-aktiviteterne i løbet af dette analyseinterval (Niveauer = Ingen visning, Visning, Aflevering, Vis feedback, Kommenter på feedback, Genaflevering efter visning af feedback)';
$string['indicator:cognitivedepthdef_link'] = 'Læringsanalyseindikatorer#Kognitiv_dybde';
$string['indicator:socialbreadth'] = 'Quiz social';
$string['indicator:socialbreadth_help'] = 'Denne indikator er baseret på den sociale bredde, som eleven har opnået i en Quiz-aktivitet.';
$string['indicator:socialbreadthdef'] = 'Quiz social';
$string['indicator:socialbreadthdef_help'] = 'Deltageren har nået denne procentdel af den sociale engagement, der tilbydes af Quiz-aktiviteterne i denne analyseperiode (Niveauer = Ingen deltagelse, Deltager alene, Deltager med andre)';
$string['indicator:socialbreadthdef_link'] = 'Læringsanalyseindikatorer#Social_bredde';
$string['indivresp'] = 'Svar fra enkeltpersoner på hvert enkelt punkt';
$string['info'] = 'Info';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Initialt antal af samlede feedbackfelter';
$string['initialnumfeedbacks_desc'] = 'Når du opretter en ny quiz, skal du angive dette antal tomme overordnede feedbackbokse. Når quizzen er oprettet, viser formularen antallet af felter, der kræves for antallet af feedbacks i quizzen. Indstillingen skal være mindst 1.';
$string['inprogress'] = 'I gang';
$string['introduction'] = 'Beskrivelse';
$string['invalidattemptid'] = 'Der findes ikke et sådant forsøg ID';
$string['invalidcategory'] = 'Kategori-ID er ugyldigt';
$string['invalidoverrideid'] = 'Ugyldigt undtagelses ID.';
$string['invalidquestionid'] = 'Ugyldigt spørgsmål id';
$string['invalidquizid'] = 'Ugyldigt quiz-ID';
$string['invalidrandomslot'] = 'Ugyldigt id for tilfældig spørgsmålsslot.';
$string['invalidsource'] = 'Kilden accepteres ikke som gyldig.';
$string['invalidsourcetype'] = 'Ugyldig kilde type.';
$string['invalidstateid'] = 'Ugyldig tilstands-id';
$string['lastanswer'] = 'Dit sidste svar var';
$string['lastautosave'] = 'Sidst gemt: {$a}';
$string['layout'] = 'Layout';
$string['layoutasshown'] = 'Sidelayout som vist.';
$string['layoutasshownwithpages'] = 'Sideopstilling som vist. <small>(Automatisk ny side hver {$a} spørgsmål.)</small>';
$string['layoutshuffledandpaged'] = 'Spørgsmålene er tilfældigt blandet med {$a} spørgsmål pr. side.';
$string['layoutshuffledsinglepage'] = 'Spørgsmålene er tilfældigt blandet, alle på én side.';
$string['link'] = 'Link';
$string['listitems'] = 'Liste over elementer i quiz';
$string['literal'] = 'Bogstavelig';
$string['loadingquestionsfailed'] = 'Indlæsning af spørgsmål mislykkedes: {$a}';
$string['makecopy'] = 'Gem som ny spørgsmål';
$string['managetypes'] = 'Administrer spørgsmåls typer og servere';
$string['manualgradequestion'] = 'Manuelt bedømme spørgsmål {$a->question} i {$a->quiz} af {$a->user}';
$string['manualgrading'] = 'Bedømmelse';
$string['mark'] = 'Aflever';
$string['markall'] = 'Afleveringsside';
$string['marks'] = 'Karakterer';
$string['marks_help'] = 'Den opnåede karakter for hver spørgsmål og den samlede forsøgs score. Du kan kun vælge karakterer, hvis Maksimale karakterer er valgt.';
$string['match'] = 'Matchende';
$string['matchanswer'] = 'Matchende svar';
$string['matchanswerno'] = 'Matchende svar {$a}';
$string['max'] = 'Max';
$string['maxmark'] = 'Maksimal karakter';
$string['maxmarks'] = 'Maksimale point';
$string['maxmarks_help'] = 'Den maksimale karakter, der er tilgængelig for hvert spørgsmål.';
$string['messageprovider:attempt_grading_complete'] = 'Underretning om at din aflevering er blevet bedømt';
$string['messageprovider:attempt_overdue'] = 'Advarsel når dit quizforsøg bliver forfaldent';
$string['messageprovider:confirmation'] = 'Bekræftelse af dine egne quizafleveringer';
$string['messageprovider:quiz_open_soon'] = 'Quizzen åbner snart';
$string['messageprovider:submission'] = 'Underretning om dine studerendes aflevering af quizzer';
$string['min'] = 'Min';
$string['minutes'] = 'Referater';
$string['missingcategory'] = 'manglende spørgsmålskategori';
$string['missingcorrectanswer'] = 'Det korrekte svar skal angives';
$string['missingitemtypename'] = 'Manglende navn';
$string['missingquestion'] = 'Dette spørgsmål ser ikke længere ud til at eksistere';
$string['modulename'] = 'Quiz';
$string['modulename_help'] = 'Quiz-aktiviteten gør det muligt for en lærer at oprette quizzer bestående af spørgsmål af forskellige typer, herunder multiple choice, matchning, kortsvar og numeriske spørgsmål.

Læreren kan tillade, at quizzen besvares flere gange, med spørgsmål, der blandes, eller som udvælges tilfældigt fra spørgebanken. Der kan angives en tidsgrænse.

Hver besvarelse bedømmes automatisk, med undtagelse af essay-spørgsmål, og karakteren registreres i karakterbogen.

Læreren kan vælge, hvornår og om tips, feedback og korrekte svar vises for de studerende.

Quizzer kan bruges

* Som eksamener i et kursus
* Som små tests for læseopgaver eller ved afslutningen af et emne
* Som eksamenstræning med spørgsmål fra tidligere eksamener
* Til at give øjeblikkelig feedback om præstation
* Til selvevaluering';
$string['modulename_link'] = 'mod/quiz/vis';
$string['modulenameplural'] = 'Quizzer';
$string['moveselectedonpage'] = 'Flyt de valgte spørgsmål til side: {$a}';
$string['multichoice'] = 'Multiple choice';
$string['multipleanswers'] = 'Vælg mindst ét svar.';
$string['mustbesubmittedby'] = 'Denne aflevering skal indsendes inden {$a}.';
$string['name'] = 'Navn';
$string['navigatenext'] = 'Næste side';
$string['navigateprevious'] = 'Forrige side';
$string['navmethod'] = 'Navigationsmetode';
$string['navmethod_free'] = 'Gratis';
$string['navmethod_help'] = 'Når sekventiel navigation er aktiveret, skal en studerende forløbe gennem quizzen i rækkefølge og må ikke returnere til tidligere sider eller springe fremad.';
$string['navmethod_seq'] = 'Sekventiel';
$string['navnojswarning'] = 'Advarsel: disse links vil ikke gemme dine svar. Brug næste knap nederst på siden.';
$string['neverallononepage'] = 'Aldrig, alle spørgsmål på én side';
$string['newattemptfail'] = 'Fejl: Det var ikke muligt at starte et nyt forsøg på quizzen';
$string['newcategory'] = 'Ny kategori';
$string['newpage'] = 'Ny side';
$string['newpage_help'] = 'For længere quizzer giver det mening at strække quizzen over flere sider ved at begrænse antallet af spørgsmål pr. side. Når der tilføjes spørgsmål til quizzen, vil sideskift automatisk blive indsat i henhold til denne indstilling. Dog kan sideskift senere flyttes manuelt på redigeringssiden.';
$string['newpageevery'] = 'Start automatisk en ny side';
$string['newsectionheading'] = 'Ny overskrift';
$string['noanswers'] = 'Der blev ikke valgt nogen svar!';
$string['noattempts'] = 'Der er ikke foretaget nogen forsøg på denne quiz';
$string['noattemptsfound'] = 'Ingen forsøg fundet.';
$string['noattemptstoshow'] = 'Der er ingen forsøg at vise';
$string['nocategory'] = 'Forkert eller ingen kategori angivet';
$string['noclose'] = 'Ingen slutdato';
$string['nocommentsyet'] = 'Ingen kommentarer endnu.';
$string['noconnection'] = 'Der er i øjeblikket ingen forbindelse til en webservice, der kan behandle dette spørgsmål. Venligst kontakt din administrator';
$string['nodataset'] = 'intet - det er ikke et wildcard';
$string['nodatasubmitted'] = 'Ingen data blev afleveret.';
$string['noessayquestionsfound'] = 'Ingen manuelt bedømte spørgsmål fundet';
$string['nogradewarning'] = 'Denne quiz er ikke bedømt, så du kan ikke angive overordnet feedback, der adskiller sig efter karakter.';
$string['nomoreattempts'] = 'Ingen flere forsøg er tilladt';
$string['none'] = 'Ingen';
$string['noopen'] = 'Ingen åbningsdato';
$string['nooverridedata'] = 'Du skal indstille undtagelser for mindst én af quizindstillingerne.';
$string['nopossibledatasets'] = 'Ingen mulige datasæt';
$string['noquestionintext'] = 'Spørgsmålsteksten indeholder ikke nogen indlejrede spørgsmål';
$string['noquestions'] = 'Der er endnu ikke tilføjet nogen spørgsmål';
$string['noquestionsfound'] = 'Ingen spørgsmål fundet';
$string['noquestionsinquiz'] = 'Der er ingen spørgsmål i denne quiz.';
$string['noquestionsnotinuse'] = 'Dette tilfældige spørgsmål er ikke i brug, da dets kategori er tom.';
$string['noquestionsonpage'] = 'Tom side';
$string['noresponse'] = 'Ingen respons';
$string['noreview'] = 'Du har ikke tilladelse til at gennemgå denne quiz';
$string['noreviewattempt'] = 'Du har ikke tilladelse til at gennemgå dette forsøg.';
$string['noreviewshort'] = 'Gennemgang ikke tilladt';
$string['noreviewuntil'] = 'Du har ikke tilladelse til at gennemgå denne quiz før {$a}';
$string['noreviewuntilshort'] = 'Tilgængelig {$a}';
$string['noscript'] = 'JavaScript skal være aktiveret for at fortsætte!';
$string['notavailabletostudents'] = 'Bemærk: Denne quiz er i øjeblikket ikke tilgængelig for dine studerende.';
$string['notenoughrandomquestions'] = 'Der er ikke nok spørgsmål i kategorien {$a->category} til at oprette spørgsmålet {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Der er ikke defineret nok under-spørgsmål!<br />Ønsker du at gå tilbage og rette dette spørgsmål?';
$string['notifyattemptsgradedtask'] = 'Send notifikationer om bedømte quizforsøg';
$string['notimedependentitems'] = 'Tidsafhængige elementer understøttes i øjeblikket ikke af quizmodulet. Som en løsning kan du sætte en tidsgrænse for hele quizzen. Ønsker du at vælge et andet element (eller bruge det nuværende element uanset hvad)?';
$string['notyetgraded'] = 'Ikke bedømt endnu';
$string['notyetviewed'] = 'Ikke set endnu';
$string['notyourattempt'] = 'Dette er ikke dit forsøg!';
$string['noview'] = 'Den indloggede bruger har ikke tilladelse til at se denne quiz';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} har lavet {$a->attemptnum} forsøg';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numerisk';
$string['numquestionsx'] = 'Spørgsmål: {$a}';
$string['oneminute'] = '1 minut';
$string['onlyteachersexport'] = 'Kun undervisere kan eksportere spørgsmål';
$string['onlyteachersimport'] = 'Kun lærere med redigeringsrettigheder kan importere spørgsmål';
$string['onthispage'] = 'Denne side';
$string['open'] = 'Ikke besvaret';
$string['openafterclose'] = 'Kunne ikke opdatere quizzen. Du har angivet en åbningsdato efter lukningsdatoen.';
$string['openclosedatesupdated'] = 'Åbnings- og lukningsdatoer';
$string['optional'] = 'valgfri';
$string['orderandpaging'] = 'Rækkefølge og paging';
$string['orderandpaging_help'] = 'The numbers 10, 20, 30, ... opposite each question indicate the order of the questions. The numbers increase in steps of 10 to leave space for additional questions to be inserted. To reorder the questions, change the numbers then click the "Reorder questions" button.

To add page breaks after particular questions, tick the checkboxes next to the questions then click the "Add new pages after selected questions" button.

To arrange the questions over a number of pages, click the Repaginate button and select the desired number of questions per page.';
$string['orderingquiz'] = 'Rækkefølge og paging';
$string['orderingquizx'] = 'Sortering og paging: {$a}';
$string['outcomesadvanced'] = 'Resultater er avancerede indstillinger';
$string['outof'] = '{$a->grade} ud af {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} ud af {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Overordnet feedback';
$string['overallfeedback_help'] = 'Overordnet feedback er tekst, der vises efter en quiz er forsøgt. Ved at angive yderligere karaktergrænser (som en procentdel eller som et tal) kan den viste tekst afhænge af den opnåede karakter.';
$string['overdue'] = 'Forsinket';
$string['overduehandling'] = 'Når tiden udløber';
$string['overduehandling_desc'] = 'Hvad skal der ske som standard, hvis en studerende ikke afleverer quizzen, før tiden udløber.';
$string['overduehandling_help'] = 'Denne indstilling styrer, hvad der sker, hvis en studerende ikke får afleveret deres quizforsøg, inden tiden udløber. Hvis den studerende aktivt arbejder på quizzen på det tidspunkt, vil nedtællingstimeren altid automatisk indsende forsøget for dem, men hvis de er logget ud, styrer denne indstilling, hvad der sker.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'Afleveringer skal indsendes, før tiden udløber, ellers tælles de ikke med';
$string['overduehandlingautosubmit'] = 'Åbne forsøg afleveres automatisk';
$string['overduehandlinggraceperiod'] = 'Der er en graceperiode, hvor åbne forsøg kan afleveres, men der kan ikke besvares flere spørgsmål.';
$string['overduemustbesubmittedby'] = 'Denne aflevering er nu forfalden. Den burde allerede være indsendt. Hvis du ønsker, at denne quiz skal bedømmes, skal du indsende den inden {$a}. Hvis du ikke indsender den inden da, vil der ikke blive talt nogen point fra denne aflevering.';
$string['override'] = 'Overskriv';
$string['overridecannotchange'] = 'Brugeren eller brugergruppen kan ikke ændres, efter at en undtagelse er oprettet.';
$string['overridecannotsetbothgroupanduser'] = 'Både brugergruppe og bruger kan ikke indstilles på samme tid.';
$string['overridedeletegroupsure'] = 'Er du sikker på, at du vil slette undtagelser for brugergruppen {$a}?';
$string['overridedeleteusersure'] = 'Er du sikker på, at du vil slette undtagelser for brugeren {$a}?';
$string['overridegroup'] = 'Undtagelses-brugergruppe';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->gruppe}';
$string['overrideinvalidattempts'] = 'Værdien for forsøg skal være større end nul.';
$string['overrideinvalidexistingid'] = 'Den eksisterende undtagelse findes ikke.';
$string['overrideinvalidgroup'] = 'Den angivne brugergruppe eksisterer ikke.';
$string['overrideinvalidquiz'] = 'Quiz ID-sættet eksisterer ikke.';
$string['overrideinvalidtimelimit'] = 'Tidsgrænsen skal være større end nul.';
$string['overrideinvaliduser'] = 'Den angivne bruger eksisterer ikke.';
$string['overridemissingdelete'] = 'Undtagelses ID(er) {$a} kunne ikke slettes, fordi de ikke eksisterer eller ikke er en del af den angivne quiz.';
$string['overridemultiplerecordsexist'] = 'Der kan ikke laves flere undtagelser for den samme bruger/grupper.';
$string['overridemustsetuserorgroup'] = 'En bruger eller brugergruppe skal være indstillet.';
$string['overrides'] = 'Undtagelser';
$string['overridesforquiz'] = 'Indstillinger for undtagelser: {$a}';
$string['overridesnoneforgroups'] = 'Der er ikke oprettet nogen undtagelser for gruppeindstillinger for denne quiz';
$string['overridesnoneforusers'] = 'Der er ikke oprettet nogen brugerundtagelser for denne quiz.';
$string['overridessummary'] = 'Eksisterende indstillinger for undtagelser ({$a})';
$string['overridessummarygroup'] = 'Brugergrupper: {$a}';
$string['overridessummarythisgroup'] = 'Der findes  indstillinger for undtagelser ({$a}) for denne brugergruppe';
$string['overridessummaryuser'] = 'Brugere: {$a}';
$string['overridessummaryyourgroups'] = 'Der findes indstillinger for undtagelser ({$a}) for dine brugergrupper';
$string['overrideuser'] = 'Tilføj undtagelser for bruger';
$string['overrideusereventname'] = '{$a->quiz} - Undtagelse';
$string['page-mod-quiz-attempt'] = 'Forsøg quizside';
$string['page-mod-quiz-edit'] = 'Rediger quizside';
$string['page-mod-quiz-report'] = 'Enhver quizrapportside';
$string['page-mod-quiz-review'] = 'Gennemgå quizforsøgssiden';
$string['page-mod-quiz-summary'] = 'Oversigt over quizforsøg';
$string['page-mod-quiz-view'] = 'Quiz informationsside';
$string['page-mod-quiz-x'] = 'Enhver quizmodulside';
$string['pageshort'] = 'P';
$string['pagesize'] = 'Sidelængde';
$string['parent'] = 'Forælder';
$string['parentcategory'] = 'Overordnet kategori';
$string['parsingquestions'] = 'Parsing af spørgsmål fra importfil.';
$string['partiallycorrect'] = 'Delvist korrekt';
$string['penalty'] = 'Straffe';
$string['penaltyscheme'] = 'Anvend sanktioner';
$string['penaltyscheme_help'] = 'Hvis det er aktiveret, trækkes der en straf fra den endelige karakter for et spørgsmål for et forkert svar. Beløbet for straffen er angivet i spørgsmålindstillingerne. Denne indstilling gælder kun, hvis den adaptive tilstand er aktiveret.';
$string['percentcorrect'] = 'Procent korrekt';
$string['pleaseclose'] = 'Din anmodning er blevet behandlet. Du kan nu lukke dette vindue';
$string['pluginadministration'] = 'Quizadministration';
$string['pluginname'] = 'Quiz';
$string['popup'] = 'Vis quiz i et \'sikkert\' vindue';
$string['popupblockerwarning'] = 'Denne sektion af testen er i sikker tilstand, hvilket betyder, at du skal tage quizzen i et sikkert vindue. Venligst deaktiver din popup-blokker. Tak.';
$string['popupnotice'] = 'Studerende vil se denne quiz i et sikkert vindue';
$string['precreateattempts'] = 'Opret forsøg på forhånd.';
$string['precreateattempts_desc'] = 'Forudoprettelse af forsøg hjælper med at optimere site-ydeevnen. Ud over at aktivere denne indstilling skal du angive en periode for forudoprettelse af forsøg. Bemærk: Indstillingen gælder kun for quizzer med et åbningstidspunkt';
$string['precreateattempts_help'] = 'Oprettelse af forsøg på forhånd hjælper med at optimere webstedets ydeevne. Quizspørgsmål kan ikke ændres, når en quiz har forsøg.';
$string['precreateoff'] = 'Opret ikke forsøg på forhånd';
$string['precreateperiod'] = 'Periode for forudoprettelse af forsøg';
$string['precreateperiod_desc'] = 'Hvis dit site har quizzer med et åbningstidspunkt og mange studerende, der starter samtidig, kan du forbedre ydeevnen ved at forudoprette forsøg. Vælg en tidsperiode før quizzen åbner for at forudoprette forsøg. En kortere periode anbefales, da quizspørgsmål ikke kan ændres, når en quiz allerede har forsøg. Forsøg genereres af en planlagt opgave, der som standard kører hver time. For at forudoprette forsøg, når systemet er mindre belastet, såsom om natten, skal du sætte perioden til 12 timer og justere den planlagte opgave til at køre i de mere stille timer';
$string['precreatetask'] = 'Opret forsøg på forhånd';
$string['precreateusedefault'] = 'Brug standard for hele webstedet ({$a})';
$string['precreateyes'] = 'Ja, {$a} timer før quiz\'ens åbningstidspunkt';
$string['preprocesserror'] = 'Der opstod en fejl under forbehandling!';
$string['preview'] = 'Forhåndsvisning';
$string['previewquestion'] = 'Forhåndsvisning af spørgsmål';
$string['previewquiz'] = 'Forhåndsvisning {$a}';
$string['previewquiznow'] = 'Forhåndsvis quiz nu';
$string['previewquizstart'] = 'Forhåndsvis quiz';
$string['previous'] = 'Tidligere tilstand';
$string['privacy:metadata:core_question'] = 'Quizaktiviteten gemmer oplysninger om brugen af spørgsmål i core_question subsystemet.';
$string['privacy:metadata:quiz'] = 'Quizaktiviteten gør brug af quizrapporter.';
$string['privacy:metadata:quiz_attempts'] = 'Detaljer om hver forsøg på en quiz.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Forsøgsnummeret.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Den aktuelle side, som brugeren er på.';
$string['privacy:metadata:quiz_attempts:gradednotificationsenttime'] = 'Tidspunktet hvor brugeren blev underrettet om, at den manuelle bedømmelse af deres forsøg var fuldført';
$string['privacy:metadata:quiz_attempts:preview'] = 'Om dette er en forhåndsvisning af quizzen.';
$string['privacy:metadata:quiz_attempts:state'] = 'Den nuværende tilstand af forsøget.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Summen af karakterer i forsøget.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Tidspunktet hvor tilstanden blev kontrolleret.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Tidspunktet for, hvornår forsøget blev afsluttet.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Tidspunktet for, hvornår forsøget blev opdateret.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Tidspunktet for, hvornår forsøget blev opdateret via en offline opdatering.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Tidspunktet for, hvornår forsøget blev startet.';
$string['privacy:metadata:quiz_grades'] = 'Detaljer om den samlede karakter for denne quiz.';
$string['privacy:metadata:quiz_grades:grade'] = 'Den samlede karakter for denne quiz.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Quizzen der blev bedømt.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Tidspunktet hvor karakteren blev ændret.';
$string['privacy:metadata:quiz_grades:userid'] = 'Brugeren som blev bedømt.';
$string['privacy:metadata:quiz_overrides'] = 'Detaljer om undtagelser for denne quiz';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Quizzen med undtagelsesinformation';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Den nye lukketid for quizzen.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Den nye tidsgrænse for quizzen.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Den nye åbningstid for quizzen.';
$string['privacy:metadata:quiz_overrides:userid'] = 'Brugeren der bliver overskrevet';
$string['privacy:metadata:quizaccess'] = 'Quizaktiviteten gør brug af quizadgangsregler.';
$string['publish'] = 'Offentliggør';
$string['publishedit'] = 'Du skal have tilladelse i udgivelseskurset for at kunne tilføje eller redigere spørgsmål i denne kategori';
$string['qbrief'] = 'Q. {$a}';
$string['qname'] = 'navn';
$string['qti'] = 'IMS QTI format';
$string['qtypename'] = 'type, navn';
$string['question'] = 'Spørgsmål';
$string['questionbank'] = 'fra spørgsmålsbanken';
$string['questionbankmanagement'] = 'Administration af spørgsmålsbank';
$string['questionbehaviour'] = 'Spørgsmål adfærd';
$string['questioncats'] = 'Spørgsmålskategorier';
$string['questiondeleted'] = 'Dette spørgsmål er blevet slettet. Venligst kontakt din lærer.';
$string['questiondependencyadd'] = 'Ingen begrænsning for hvornår spørgsmålet {$a->thisq} kan besvares • Klik for at ændre';
$string['questiondependencyfree'] = 'Ingen begrænsning på dette spørgsmål';
$string['questiondependencyremove'] = 'Spørgsmål {$a->thisq} kan ikke besvares, før det foregående spørgsmål {$a->previousq} er blevet afsluttet • Klik for at ændre';
$string['questiondependsonprevious'] = 'Dette spørgsmål kan ikke besvares, før det foregående spørgsmål er blevet afsluttet.';
$string['questiondraftonly'] = 'Spørgsmålet {$a} er i kladde-status. For at bruge det i quizzen, gå til spørgsmålsbanken og ændre status til klar.';
$string['questiondraftwillnotwork'] = 'Dette spørgsmål er i udkaststatus. For at bruge det i quizzen, gå til spørgsmålsbanken og ændre status til klar.';
$string['questioninuse'] = 'Spørgsmålet \'{$a->questionname}\' anvendes i øjeblikket i: <br />{$a->quiznames}<br />Spørgsmålet vil ikke blive slettet fra disse quizzer, men kun fra kategorilisten.';
$string['questionmissing'] = 'Spørgsmålet for denne session mangler';
$string['questionname'] = 'Spørgsmålets navn';
$string['questionnonav'] = '<span class="accesshide">Spørgsmål </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Information </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Spørgsmål {$a} er ikke blevet indlæst fra databasen';
$string['questionorder'] = 'Spørgsmål rækkefølge';
$string['questionposition'] = 'Ny position i rækkefølge for spørgsmål {$a}';
$string['questions'] = 'Spørgsmål';
$string['questionsetpreview'] = 'Forhåndsvisning af spørgsmålssæt';
$string['questionsinclhidden'] = 'Spørgsmål (inklusive skjulte)';
$string['questionsinthisquiz'] = 'Spørgsmål i denne quiz';
$string['questionsmatchingfilter'] = 'Spørgsmål der matcher dette filter: {$a}';
$string['questionsperpage'] = 'Spørgsmål pr. side';
$string['questionsperpageselected'] = 'Antallet af spørgsmål pr. side er blevet indstillet, så pagineringen i øjeblikket er fast. Som et resultat heraf er pagineringskontrollerne blevet deaktiveret. Du kan ændre dette i {$a}.';
$string['questionsperpagex'] = 'Spørgsmål pr. side: {$a}';
$string['questiontext'] = 'Spørgsmålstekst';
$string['questiontextisempty'] = '[Tomt spørgsmålstekst]';
$string['questiontype'] = 'Spørgsmålstype {$a}';
$string['questiontypesetupoptions'] = 'Indstillingsmuligheder for spørgsmålstyper:';
$string['questionversion'] = 'v{$a}';
$string['questionversionlatest'] = 'v{$a} (seneste)';
$string['quiz:addinstance'] = 'Tilføj en ny quiz';
$string['quiz:attempt'] = 'Forsøg quizzer';
$string['quiz:deleteattempts'] = 'Slet quizforsøg';
$string['quiz:emailconfirmsubmission'] = 'Modtag bekræftelse på dine egne quizafleveringer';
$string['quiz:emailnotifyattemptgraded'] = 'Modtag meddelelse når din aflevering er blevet bedømt';
$string['quiz:emailnotifysubmission'] = 'Modtag meddelelse om dine studerendes quizafleveringer';
$string['quiz:emailwarnoverdue'] = 'Modtag advarsel når dit quizforsøg bliver forfaldent';
$string['quiz:grade'] = 'Vurder quizzer manuelt';
$string['quiz:ignoretimelimits'] = 'Ignorer tidsgrænsen for quizzen';
$string['quiz:manage'] = 'Administrer quizzer';
$string['quiz:manageoverrides'] = 'Administrer undtagelse af quizindstillinger';
$string['quiz:preview'] = 'Forhåndsvis quizzer';
$string['quiz:regrade'] = 'Genvurder quizforsøg';
$string['quiz:reopenattempts'] = 'Genåbn aldrig indsendte quizforsøg';
$string['quiz:reviewmyattempts'] = 'Gennemgå dine egne forsøg';
$string['quiz:view'] = 'Se quizinformation';
$string['quiz:viewoverrides'] = 'Vis undtagelser for quizindstillinger';
$string['quiz:viewreports'] = 'Vis quizrapporter';
$string['quizavailable'] = 'Quizzen er tilgængelig indtil: {$a}';
$string['quizclose'] = 'Luk quizzen';
$string['quizclosed'] = 'Denne quiz lukkede den {$a}';
$string['quizcloses'] = 'Quizzen lukker';
$string['quizcloseson'] = 'Denne quiz vil lukke den {$a}.';
$string['quizeventcloses'] = '{$a} lukker';
$string['quizeventopens'] = '{$a} åbner';
$string['quizinvalidquestions'] = 'Denne quiz har spørgsmål med ugyldige typer. Den manglende spørgsmålstype skal geninstalleres, eller de berørte spørgsmål skal fjernes, før quizzen kan bruges.';
$string['quizisclosed'] = 'Denne quiz er lukket';
$string['quizisclosedwillopen'] = 'Quiz lukket (åbner {$a})';
$string['quizisopen'] = 'Denne quiz er åben';
$string['quizisopenwillclose'] = 'Quiz åben (lukker {$a})';
$string['quiznavigation'] = 'Quiz navigation';
$string['quizopen'] = 'Åbn quizzen';
$string['quizopenclose'] = 'Åbnings- og lukningsdatoer';
$string['quizopenclose_help'] = 'Studerende kan kun starte deres forsøg efter åbningstiden, og de skal afslutte deres forsøg før lukketid.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopendatesoonhtml'] = '<p>Hi {$a->firstname},</p>
<p>The quiz <strong>{$a->quizname}</strong> in course {$a->coursename} is opening soon.
<p><strong>Opens: {$a->timeopen}</strong></p>
<p><strong>Closes: {$a->timeclose}</strong></p>
<p><a href="{$a->url}">Go to quiz</a></p>';
$string['quizopendatesoonsubject'] = 'Åbner den {$a->timeopen}: {$a->quizname}';
$string['quizopened'] = 'Denne quiz er åben.';
$string['quizopenedon'] = 'Denne quiz åbnede den {$a}';
$string['quizopens'] = 'Quiz åbner';
$string['quizopenwillclose'] = 'Denne quiz er åben, og vil lukke den {$a} kl';
$string['quizordernotrandom'] = 'Rækkefølgen af quizzen er ikke blandet';
$string['quizorderrandom'] = '* Rækkefølgen af quizzen er blandet';
$string['quizreport'] = 'Quizrapport';
$string['quizsettings'] = 'Quizindstillinger';
$string['quizsetupnavigation'] = 'Navigation til quizopsætning';
$string['quiztimer'] = 'Quiz Timer';
$string['quizwillopen'] = 'Denne quiz vil åbne {$a}';
$string['random'] = 'Tilfældig spørgsmål';
$string['randomcatwithsubcat'] = '{$a} og underkategorier';
$string['randomcoursecatwithsubcat'] = 'Enhver kategori inden for kursuskategorien {$a}';
$string['randomcoursewithsubcat'] = 'Enhver kategori i dette kursus';
$string['randomcreate'] = 'Opret tilfældige spørgsmål';
$string['randomediting'] = 'Redigering af et tilfældigt spørgsmål';
$string['randomfaultynosubcat'] = 'Fejlagtigt spørgsmål';
$string['randomfromcategory'] = 'Tilfældig spørgsmål fra kategori:';
$string['randomfromexistingcategory'] = 'Tilfældig spørgsmål fra en eksisterende kategori';
$string['randomfromunavailabletag'] = '{$a} (utilgængelig)';
$string['randommodulewithsubcat'] = 'Enhver kategori af denne quiz';
$string['randomnosubcat'] = 'Spørgsmål fra denne kategori kun, ikke dens underkategorier.';
$string['randomnumber'] = 'Antal tilfældige spørgsmål';
$string['randomqname'] = 'Tilfældig spørgsmål baseret på filterbetingelse';
$string['randomqnamecat'] = 'Tilfældig ({$a->category}) baseret på filterbetingelse';
$string['randomqnamecattags'] = 'Tilfældig ({$a->category}) baseret på filterbetingelse med tags: {$a->tags}';
$string['randomqnametags'] = 'Tilfældig spørgsmål baseret på filterbetingelse med tags: {$a}';
$string['randomquestion'] = 'Tilfældig spørgsmål';
$string['randomquestion_help'] = 'Et tilfældigt spørgsmål er en måde at indsætte et tilfældigt valgt spørgsmål fra en specificeret kategori eller ved en specificeret tag i en aktivitet.';
$string['randomquestiontags'] = 'Tags';
$string['randomquestiontags_help'] = 'You can restrict the selection criteria further by specifying some question tags here.

The "random" questions will be selected from the questions that have all these tags.';
$string['randomquestionusinganewcategory'] = 'Tilfældig spørgsmål ved brug af en ny kategori';
$string['randomsystemwithsubcat'] = 'Enhver systemniveau kategori';
$string['randomwithsubcat'] = 'Spørgsmål fra denne kategori og dens underkategorier.';
$string['readytosend'] = 'Du er ved at sende hele dit quiz til bedømmelse. Er du sikker på, at du vil fortsætte?';
$string['reattemptquiz'] = 'Forsøg quizzen igen';
$string['recentlyaddedquestion'] = 'Nyligt tilføjet spørgsmål!';
$string['recurse'] = 'Inkluder også spørgsmål fra underkategorier';
$string['redoesofthisquestion'] = 'Andre spørgsmål forsøgt her: {$a}';
$string['redoquestion'] = 'Prøv et andet spørgsmål som dette';
$string['regrade'] = 'Vurder alle forsøg igen';
$string['regradecomplete'] = 'Alle forsøg er blevet genbedømt';
$string['regradecount'] = '{$a->changed} ud af {$a->attempt} karakterer blev ændret';
$string['regradedisplayexplanation'] = 'Forsøg, der ændrer sig under genvurdering, vises som hyperlinks til spørgsmålsgennemgangsvinduet';
$string['regradenotallowed'] = 'Du har ikke tilladelse til at vurdere denne quiz igen';
$string['regradingquestion'] = 'Genvurdering af "{$a}".';
$string['regradingquiz'] = 'Genvurdering af quiz "{$a}"';
$string['remove'] = 'Fjern';
$string['removeallgroupoverrides'] = 'Alle brugergruppeundtagelser';
$string['removeallquizattempts'] = 'Alle quizforsøg';
$string['removealluseroverrides'] = 'Alle brugerundtagelser';
$string['removeemptypage'] = 'Fjern tom side';
$string['removepagebreak'] = 'Fjern sideskift';
$string['removeselected'] = 'Fjern valgte';
$string['rename'] = 'Omdøb';
$string['renderingserverconnectfailed'] = 'Serveren {$a} kunne ikke behandle en RQP request. Tjek at URL\'en er korrekt.';
$string['reopenattempt'] = 'Genåbn';
$string['reopenattemptareyousuremessage'] = 'Dette vil genåbne aflevering {$a->attemptnumber} af {$a->attemptuser}.';
$string['reopenattemptareyousuretitle'] = 'Genåbn forsøg?';
$string['reopenattemptwrongstate'] = 'Forsøg {$a->attemptid} er i den forkerte tilstand ({$a->state}) til at blive genåbnet.';
$string['reopenedattemptwillbeinprogress'] = 'Forsøget vil forblive åbent og kan fortsættes.';
$string['reopenedattemptwillbeinprogressuntil'] = 'Forsøget vil forblive åbent og kan fortsættes indtil quizzen lukker den {$a}.';
$string['reopenedattemptwillbesubmitted'] = 'Forsøget vil straks blive sendt til bedømmelse.';
$string['reorderquestions'] = 'Omarranger spørgsmål';
$string['reordertool'] = 'Vis værktøjet til omrokering';
$string['repaginate'] = 'Repaginer med {$a} spørgsmål pr. side';
$string['repaginatecommand'] = 'Genopdel';
$string['repaginatenow'] = 'Genopdel nu';
$string['replace'] = 'Erstat';
$string['replacementoptions'] = 'Erstatningsmuligheder';
$string['report'] = 'Rapporter';
$string['reportanalysis'] = 'Vareanalyse';
$string['reportattemptsfrom'] = 'Forsøg fra';
$string['reportattemptsthatare'] = 'Forsøg der er';
$string['reportdisplayoptions'] = 'Visningsmuligheder';
$string['reportfullstat'] = 'Detaljeret statistik';
$string['reportmulti_percent'] = 'Multi-procent';
$string['reportmulti_q_x_student'] = 'Valg for flere studerende';
$string['reportmulti_resp'] = 'Individuelle svar';
$string['reportmustselectstate'] = 'Du skal vælge mindst én tilstand.';
$string['reportnotfound'] = 'Rapporten er ikke kendt ({$a})';
$string['reportoverview'] = 'Oversigt';
$string['reportregrade'] = 'Genvurdering af forsøg';
$string['reportresponses'] = 'Uddybende svar';
$string['reports'] = 'Rapporter';
$string['reportshowonly'] = 'Vis kun forsøg';
$string['reportshowonlyfinished'] = 'Vis højst et afsluttet forsøg pr. bruger ({$a})';
$string['reportsimplestat'] = 'Enkle statistikker';
$string['reportusersall'] = 'alle brugere, der har et quizforsøg';
$string['reportuserswith'] = '';
$string['reportuserswithorwithout'] = 'tilmeldte brugere, der har eller ikke har et quizforsøg';
$string['reportuserswithout'] = 'tilmeldte brugere, der ikke har et quizforsøg';
$string['reportwhattoinclude'] = 'Hvad der skal inkluderes i rapporten';
$string['requirepassword'] = 'Krav om adgangskode';
$string['requirepassword_help'] = 'Hvis der er angivet et kodeord, skal en studerende indtaste det for at kunne forsøge quizzen.';
$string['requiresubnet'] = 'Krav om netværksadresse';
$string['requiresubnet_help'] = 'Adgangen til quizzen kan være begrænset til bestemte subnets på LAN eller Internettet ved at angive en kommasepareret liste over delvise eller fulde IP-adresser. Dette kan være nyttigt for en overvåget (proctored) quiz, for at sikre at kun personer på en bestemt placering kan få adgang til quizzen.';
$string['response'] = 'Svar';
$string['responses'] = 'Svar';
$string['results'] = 'Resultater';
$string['returnattempt'] = 'Returner til forsøg';
$string['reuseifpossible'] = 'genbrug tidligere fjernet';
$string['reverttodefaults'] = 'Gendan quizstandarder';
$string['review'] = 'Gennemgang';
$string['reviewafter'] = 'Tillad gennemgang efter quizzen er lukket';
$string['reviewalways'] = 'Tillad gennemgang når som helst';
$string['reviewattempt'] = 'Gennemgå forsøg';
$string['reviewbefore'] = 'Tillad gennemgang mens quizzen er åben';
$string['reviewclosed'] = 'Efter quizzen er lukket';
$string['reviewduring'] = 'Under forsøget';
$string['reviewimmediately'] = 'Umiddelbart efter forsøget';
$string['reviewnever'] = 'Tillad aldrig gennemgang';
$string['reviewofquestion'] = 'Gennemgang af spørgsmål {$a->question} i {$a->quiz} af {$a->user}';
$string['reviewopen'] = 'Senere, mens quizzen stadig er åben';
$string['reviewoptions'] = 'Studerende kan gennemgå';
$string['reviewoptionsheading'] = 'Gennemgå muligheder';
$string['reviewoptionsheading_help'] = 'These options control what information students can see when they review a quiz attempt or look at the quiz reports.

**During the attempt** settings are only relevant for some behaviours, like \'interactive with multiple tries\', which may display feedback during the attempt.

**Immediately after the attempt** settings apply for the first two minutes after \'Submit all and finish\' is clicked.

**Later, while the quiz is still open** settings apply after this, and before the quiz close date.

**After the quiz is closed** settings apply after the quiz close date has passed. If the quiz does not have a close date, this state is never reached.';
$string['reviewoverallfeedback'] = 'Overordnet feedback';
$string['reviewoverallfeedback_help'] = 'Den feedback, der gives ved slutningen af forsøget, afhængigt af den studerendes samlede karakter.';
$string['reviewresponse'] = 'Gennemgå svar';
$string['reviewresponsetoq'] = 'Gennemgå svar (spørgsmål {$a})';
$string['reviewthisattempt'] = 'Gennemgå dine svar på dette forsøg';
$string['rqp'] = 'Fjernspørgsmål';
$string['rqps'] = 'Fjernspørgsmål';
$string['sameasoverall'] = 'Det samme som for samlede karakterer';
$string['save'] = 'Gem';
$string['saveandedit'] = 'Gem ændringer og rediger spørgsmål';
$string['saveattemptfailed'] = 'Det lykkedes ikke at gemme det aktuelle quizforsøg.';
$string['savedfromdeletedcourse'] = 'Gemt fra slettet kursus "{$a}"';
$string['savegrades'] = 'Gem karakterer';
$string['savemanualgradingfailed'] = 'Ændring ikke gemt. Kontroller venligst beskeden nedenfor og prøv igen.';
$string['savemyanswers'] = 'Gem mine svar';
$string['savenosubmit'] = 'Gem uden aflevering';
$string['saveoverrideandstay'] = 'Gem og indtast en anden undtagelse';
$string['savequiz'] = 'Gem hele denne quiz';
$string['saving'] = 'Gemmer';
$string['savingnewgradeforquestion'] = 'Gemmer ny karakter for spørgsmål id {$a}.';
$string['savingnewmaximumgrade'] = 'Gemmer ny maksimal karakter.';
$string['score'] = 'Rå score';
$string['scores'] = 'Pointtal';
$string['search:activity'] = 'Quiz - aktivitetsinformation';
$string['searchbyname'] = 'Søg efter navn...';
$string['sectionheadingedit'] = 'Rediger overskrift \'{$a}\'';
$string['sectionheadingremove'] = 'Fjern overskrift \'{$a}\'';
$string['sectionnoname'] = 'Uden titel sektion';
$string['seequestions'] = '(Se spørgsmål)';
$string['select'] = 'Vælg';
$string['selectall'] = 'Vælg alle';
$string['selectattempt'] = 'Vælg forsøg';
$string['selectcategory'] = 'Vælg kategori';
$string['selectedattempts'] = 'Valgte forsøg...';
$string['selectmultipleitems'] = 'Vælg flere elementer';
$string['selectmultipletoolbar'] = 'Vælg flere værktøjslinjer';
$string['selectnone'] = 'Fravælg alle';
$string['selectquestionbank'] = 'Vælg spørgsmålsbank';
$string['selectquestionslot'] = 'Vælg spørgsmål {$a}';
$string['selectquestiontype'] = '-- Vælg spørgsmålstype --';
$string['sendnotificationopendatesoon'] = 'Underret brugeren om en kommende åbningsdato for quizzen';
$string['serveradded'] = 'Server tilføjet';
$string['serveridentifier'] = 'Identifikator';
$string['serverinfo'] = 'Serverinformation';
$string['servers'] = 'Servere';
$string['serverurl'] = 'Server URL';
$string['shortanswer'] = 'Kort svar';
$string['show'] = 'Vis';
$string['showall'] = 'Vis alle spørgsmål på én side';
$string['showblocks'] = 'Vis blokke under quizforsøg';
$string['showblocks_help'] = 'Hvis det er indstillet til ja, vil normale blokke blive vist under quizforsøg';
$string['showbreaks'] = 'Vis sideskift';
$string['showcategorycontents'] = 'Vis indholdet i kategorien {$a->arrow}';
$string['showcorrectanswer'] = 'Vis korrekte svar i feedback?';
$string['showdetailedmarks'] = 'Vis karakterdetaljer';
$string['showeachpage'] = 'Vis én side ad gangen';
$string['showfeedback'] = 'Vis feedback efter besvarelse?';
$string['showinsecurepopup'] = 'Brug et \'sikkert\' popup-vindue til forsøg';
$string['showlargeimage'] = 'Stor billede';
$string['shownoattempts'] = 'Vis studerende uden forsøg';
$string['shownoattemptsonly'] = 'Vis kun studerende uden forsøg';
$string['shownoimage'] = 'Ingen billede';
$string['showreport'] = 'Vis rapport';
$string['showsmallimage'] = 'Lille billede';
$string['showteacherattempts'] = 'Vis lærerens forsøg';
$string['showuserpicture'] = 'Vis brugerens billede';
$string['showuserpicture_help'] = 'Hvis det er aktiveret, vil en studerendes navn og billede blive vist på skærmen under forsøget og på gennemgangsskærmen, hvilket gør det lettere at kontrollere, at den studerende er logget ind som sig selv i en overvåget (proctored) eksamen.';
$string['shuffle'] = 'Bland';
$string['shuffleanswers'] = 'Bland svarene';
$string['shuffledrandomly'] = 'Blandet tilfældigt';
$string['shufflequestions'] = 'Bland';
$string['shufflequestions_help'] = 'If enabled, every time the quiz is attempted, the order of the questions in this section will be shuffled into a different random order.

This can make it harder for students to share answers, but it also makes it harder for students to discuss a particular question with the teacher.';
$string['shufflewithin'] = 'Bland inden for spørgsmål';
$string['shufflewithin_help'] = 'Hvis aktiveret, vil delene, der udgør hvert spørgsmål, blive tilfældigt blandet hver gang en studerende forsøger quizzen, forudsat at muligheden også er aktiveret i spørgsmålindstillingerne. Denne indstilling gælder kun for spørgsmål, der har flere dele, såsom multiple choice eller matchende spørgsmål.';
$string['singleanswer'] = 'Vælg et svar.';
$string['sortage'] = 'Sorter efter alder';
$string['sortalpha'] = 'Sorter efter navn';
$string['sortquestionsbyx'] = 'Sorter spørgsmål efter: {$a}';
$string['sortsubmit'] = 'Sorter spørgsmål';
$string['sorttypealpha'] = 'Sorter efter type, navn';
$string['specificapathnotonquestion'] = 'Den angivne filsti er ikke på det angivne spørgsmål';
$string['specificquestionnotonquiz'] = 'Den angivne spørgsmål er ikke på den angivne quiz';
$string['startagain'] = 'Start forfra';
$string['startattempt'] = 'Start forsøg';
$string['startedon'] = 'Startet';
$string['startnewpreview'] = 'Start en ny forhåndsvisning';
$string['stateabandoned'] = 'Aldrig afleveret';
$string['statefinished'] = 'Færdig';
$string['statefinisheddetails'] = 'Afleveret {$a}';
$string['stateinprogress'] = 'I gang';
$string['statenotloaded'] = 'Tilstanden for spørgsmålet {$a} er ikke blevet indlæst fra databasen';
$string['statenotstarted'] = 'Ikke startet';
$string['stateoptions'] = 'Forsøgsstatustilvalg';
$string['stateoptions_help'] = '> * Ikke startet: Forsøget blev automatisk oprettet, før quizzen åbnede. Den studerende har endnu ikke startet forsøget.
> * I gang: Den studerende er begyndt på forsøget. De har stadig tid til at indsende det.
> * Overskredet: Forsøget har været åbent i længere tid end den tilladte tidsbegrænsning. Den studerende kan stadig indsende det inden for respitperioden.
> * Indsendt: Den studerende har gennemført forsøget og indsendt deres svar. Det er sat i kø til automatisk bedømmelse.
> * Færdig: Forsøget er indsendt, og al automatisk bedømmelse er fuldført.
> * Aldrig indsendt: Den studerende startede forsøget, men indsendte det ikke inden for tidsbegrænsningen eller respitperioden.';
$string['stateoverdue'] = 'Forsinket';
$string['stateoverduedetails'] = 'Skal afleveres inden {$a}';
$string['statesubmitted'] = 'Indsendt';
$string['status'] = 'Status';
$string['stoponerror'] = 'Stop ved fejl';
$string['studentswhoattempted'] = 'Studerende der har forsøgt';
$string['submission_confirmation'] = 'Afgiv alle dine svar og afslut?';
$string['submission_confirmation_unanswered'] = 'Spørgsmål uden svar: {$a}';
$string['submitallandfinish'] = 'Aflever alt og afslut';
$string['subneterror'] = 'Beklager, denne quiz er blevet låst, så den kun kan tilgås fra bestemte steder. I øjeblikket er din computer ikke en af dem, der har tilladelse til at bruge denne quiz.';
$string['subnetnotice'] = 'Denne quiz er blevet låst, så den kun er tilgængelig fra bestemte steder. Din computer er ikke på et tilladt subnet. Som underviser har du dog lov til at forhåndsvise.';
$string['subplugintype_quiz'] = 'Rapport';
$string['subplugintype_quiz_plural'] = 'Rapporter';
$string['subplugintype_quizaccess'] = 'Adgangsregel';
$string['subplugintype_quizaccess_plural'] = 'Adgangsregler';
$string['substitutedby'] = 'vil blive erstattet af';
$string['summaryofattempt'] = 'Oversigt over forsøg';
$string['summaryofattempts'] = 'Dine forsøg';
$string['summaryofattemptscaption'] = 'Opsummering af forsøg {$a}';
$string['temporaryblocked'] = 'Du har midlertidigt ikke lov til at forsøge quizzen igen.<br /> Du vil kunne tage et nyt forsøg den:';
$string['theattempt'] = 'Forsøget';
$string['theattempt_help'] = 'Om studenten overhovedet kan gennemgå forsøget.';
$string['time'] = 'Tid';
$string['timecompleted'] = 'Fuldført';
$string['timedelay'] = 'Du har ikke tilladelse til at deltage i quizzen, da du ikke har overholdt tidsforsinkelsen før du forsøger en anden quiz';
$string['timeleft'] = 'Tid tilbage';
$string['timelimit'] = 'Tidsgrænse';
$string['timelimit_help'] = 'Hvis aktiveret, angives tidsgrænsen på den indledende quizside, og en nedtællingsur vises i quiznavigationen.';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Beklager! Tidsgrænsen for quizzen er overskredet!';
$string['timestr'] = '%H:%M:%S den %d/%m/%y';
$string['timesup'] = 'Tiden er ud!';
$string['timing'] = 'Timing';
$string['tofile'] = 'at arkivere';
$string['tolerance'] = 'Tolerance';
$string['toomanyrandom'] = 'Antallet af tilfældige spørgsmål, der kræves, er større end det, der stadig er tilgængeligt i kategorien!';
$string['top'] = 'Top';
$string['totalattempts'] = 'Samlede forsøg';
$string['totalmarks'] = 'Samlet antal point';
$string['totalmarksx'] = 'Samlet antal point: {$a}';
$string['totalquestionsinrandomqcategory'] = 'I alt {$a} spørgsmål i kategorien.';
$string['true'] = 'Sandt';
$string['truefalse'] = 'Sandt/falsk';
$string['type'] = 'Type';
$string['unfinished'] = 'åben';
$string['ungraded'] = 'Ubedømt';
$string['unit'] = 'Enhed';
$string['unknowntype'] = 'Spørgsmålstypen understøttes ikke på linje {$a}. Spørgsmålet vil blive ignoreret';
$string['updatefilterconditon'] = 'Opdater filterbetingelser';
$string['updatefilterconditon_success'] = 'Filterbetingelserne blev opdateret med succes';
$string['updateoverdueattemptstask'] = 'Opdatering af forsinkede quizforsøg';
$string['updatequizslotswithrandomxofy'] = 'Opdaterer quizpladser med "tilfældige" spørgsmål data ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Opdater quizindstillinger';
$string['updatingatttemptgrades'] = 'Opdatering af forsøgskarakterer.';
$string['updatingfinalgrades'] = 'Opdatering af slutkarakterer.';
$string['updatingthegradebook'] = 'Opdaterer karakterbogen.';
$string['upgradesure'] = '<div>Specifikt vil quizmodulet udføre en omfattende ændring af quiztabellerne, og denne opgradering er endnu ikke blevet tilstrækkeligt testet. Du opfordres kraftigt til at sikkerhedskopiere dine databasetabeller, før du fortsætter.</div>';
$string['upgradingquizattempts'] = 'Opgradering af quizforsøg: quiz {$a->done}/{$a->outof} (Quiz id {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Opgradering af meget gamle quizforsøg: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Denne kategori er blevet bevaret og flyttet til sites niveau, fordi det er en offentliggjort kategori, der stadig er i brug af andre kurser.';
$string['useroverrides'] = 'Brugerundtagelser';
$string['useroverridesdeleted'] = 'Brugerundtagelser er slettet';
$string['usersnone'] = 'Ingen studerende har adgang til denne quiz';
$string['validate'] = 'Valider';
$string['viewallanswers'] = 'Vis {$a} quizforsøg';
$string['viewallreports'] = 'Se rapporter for {$a} forsøg';
$string['viewed'] = 'Set';
$string['warningmissingtype'] = '<b>Dette spørgsmål er af en type, der endnu ikke er installeret på din Moodle.<br />Venligst informér din Moodle-administrator.</b>';
$string['wheregrade'] = 'Hvor er min karakter?';
$string['wildcard'] = 'Wildcard';
$string['windowclosing'] = 'Dette vindue vil lukke snart.';
$string['withsummary'] = 'med opsummerende statistikker';
$string['wronguse'] = 'Du kan ikke bruge denne side på den måde';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Du skal tilmelde dig dette kursus, før du kan forsøge denne quiz';
$string['yourfinalgradeis'] = 'Din endelige karakter for denne quiz er {$a}.';
