<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'completion', language 'da', version '5.1'.
 *
 * @package     completion
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['achievinggrade'] = 'Opnå karakter';
$string['achievingpassinggrade'] = 'Opnåelse af bestået karakter';
$string['activities'] = 'Aktiviteter';
$string['activitiescompleted'] = 'Gennemførte aktiviteter';
$string['activitiescompletednote'] = 'Bemærk: Aktivitetsgennemførelse skal være sat til for at en aktivitet vil vises i listen ovenfor.';
$string['activitieslabel'] = 'Aktiviteter/materialer';
$string['activityaggregation'] = 'Betingelse kræver';
$string['activityaggregation_all'] = 'ALLE valgte aktiviteter skal gennemføres';
$string['activityaggregation_any'] = 'MINDST EN valgt aktivitet skal gennemføres';
$string['activitycompletion'] = 'Betingelser for gennemførelse';
$string['activitycompletionupdated'] = 'Ændringer gemt';
$string['activitygradetopassnotset'] = 'Der er ikke fastsat en gyldig karakter for at bestå denne aktivitet. Den kan angives i afsnittet Karakter i aktivitetsindstillingerne.';
$string['addconditions'] = 'Tilføj betingelser';
$string['affectedactivities'] = 'Ændringerne vil påvirke følgende <b>{$a}</b> aktiviteter eller materialer:';
$string['aggregationmethod'] = 'Sammenlægningsmetode';
$string['all'] = 'Alle';
$string['allconditions'] = 'Aktiviteten er færdig når den studerende har gjort følgende:';
$string['any'] = 'Hvilken som helst';
$string['approval'] = 'Godkendelse';
$string['areyousureoverridecompletion'] = 'Er du sikker på at du vil overskrive den aktuelle gennemførelsesstatus på denne aktivitet for denne bruger og markere den som "{$a}"?';
$string['badautocompletion'] = 'Du skal vælge mindst en betingelse';
$string['badcompletiongradeitemnumber'] = 'Krævet karakter kan ikke aktiveres for <b>{$a}</b> da karaktergivning af {$a} ikke er aktiveret.';
$string['bulkactivitycompletion'] = 'Rediger flere aktiviteter ad gangen';
$string['bulkactivitydetail'] = 'Vælg de aktiviteter du vil redigere.';
$string['bulkcompletiontracking'] = 'Sporing af gennemførelse';
$string['bulkcompletiontracking_help'] = '<strong>Ingen:</strong> Vis ikke aktivitetsgennemførelse

<strong>Manuel:</strong> Studerende kan selv markere aktiviteten som gennemført

<strong>Med betingelse(r):</strong> Vis aktiviteten som gennemført når kriterierne er opfyldt';
$string['checkactivity'] = 'Markeringsfelt for aktivitet/materiale: {$a}';
$string['checkall'] = 'Marker eller fjern markering af alle aktiviteter og materialer';
$string['checkallsection'] = 'Marker eller fjern markering af alle aktiviteter og materialer i følgende sektion: {$a}';
$string['completeactivity'] = 'Gennemfør aktiviteten';
$string['completed'] = 'Gennemført';
$string['completedunlocked'] = 'Gennemførelsesmuligheder er låst op';
$string['completedunlockedtext'] = 'Når du gemmer denne formular, vil udfyldningsdata blive slettet og derefter genberegnet, hvor det er muligt. Vil du undgå det, kan du navigere væk uden at gemme.';
$string['completedwarning'] = 'Gennemførelsesmuligheder er låst.';
$string['completedwarningtext'] = 'Denne aktivitet er markeret som gennemført for en eller flere studerende. Hvis du låser op for indstillingerne for at foretage en ændring og derefter gemmer formularen, vil fuldførelsesdata blive slettet og derefter genberegnet, hvor det er muligt. Manuel færdiggørelse kan ikke genberegnes, så i dette tilfælde skal den studerende markere den som gennemført igen.';
$string['completion'] = 'Registrering af gennemførelse';
$string['completion-alt-auto-enabled'] = 'Dette element bedømmes som gennemført af systemet efter betingelserne: {$a}';
$string['completion-alt-auto-fail'] = 'Gennemført: {$a} (opnåede ikke beståelseskarakter)';
$string['completion-alt-auto-n'] = 'Ikke gennemført: {$a}';
$string['completion-alt-auto-n-override'] = 'Ikke fuldført: {$a->modname} (registeret af {$a->overrideuser})';
$string['completion-alt-auto-pass'] = 'Gennemført: {$a} (opnåede beståelseskarakter)';
$string['completion-alt-auto-y'] = 'Gennemført: {$a}';
$string['completion-alt-auto-y-override'] = 'Fuldført: {$a->modname} (registeret af {$a->overrideuser})';
$string['completion-alt-manual-enabled'] = 'Studerende kan manuelt markere dette element som gennemført: {$a}';
$string['completion-alt-manual-n'] = 'Ikke gennemført: {$a}. Vælg for at markere som gennemført.';
$string['completion-alt-manual-n-override'] = 'Ikke fuldført: {$a->modname} (registeret af {$a->overrideuser}). Vælg til markering som fuldført.';
$string['completion-alt-manual-y'] = 'Gennemført: {$a}. Vælg for at markere som ikke gennemført.';
$string['completion-alt-manual-y-override'] = 'registeret af Fuldført: {$a->modname} (set by {$a->overrideuser}). Vælg til markering som ikke fuldført.';
$string['completion-fail'] = 'Gennemført (opnåede ikke beståelseskarakter)';
$string['completion-n'] = 'Ikke gennemført';
$string['completion-n-override'] = 'registeret af Ikke fuldført (set by {$a})';
$string['completion-pass'] = 'Gennemført (opnåede beståelseskarakter)';
$string['completion-y'] = 'Gennemført';
$string['completion-y-override'] = 'Fuldført (registeret af {$a})';
$string['completion_automatic'] = 'Tilføj betingelser';
$string['completion_help'] = 'Er indstillingen aktiveret, spores aktivitetens gennemførelse enten manuelt eller automatisk baseret på visse betingelser. Der kan om ønsket indstilles flere betingelser. I så fald vil aktiviteten kun blive betragtet som afsluttet, når ALLE betingelser er opfyldt.';
$string['completion_link'] = 'activity/completion';
$string['completion_manual'] = 'Studerende skal manuelt markere aktiviteten som gennemført';
$string['completion_none'] = 'Ingen';
$string['completion_status'] = 'Status';
$string['completionactivitydefault'] = 'Brug som standard';
$string['completionanygrade_desc'] = 'En vilkårlig karakter';
$string['completiondisabled'] = 'Slået fra, vises ikke i aktivitetsindstillinger';
$string['completionduration'] = 'Tilmelding';
$string['completionenabled'] = 'Slået til, styres via gennemførelses- og aktivitetsindstillinger';
$string['completionexpected'] = 'Indstil påmindelse i tidslinjen';
$string['completionexpected_help'] = 'Dette giver dig mulighed for at sætte en påmindelse til studerende om at arbejde på denne aktivitet. Det vil fremgå i tidslinjeblokken på deres dashboard som "{$a} kræver handling".';
$string['completionexpecteddesc'] = 'Forventet gennemført {$a}';
$string['completionexpectedfor'] = '"{$a->instancename}" forventes gennemført';
$string['completionicons'] = 'Markeringsfelt til gennemførelse';
$string['completionicons_help'] = 'En markering ved siden af aktivitetens navn vil vise om den er gennemført.

Vises der et markeringsfelt med en stiplet ramme, markeres det automatisk når du har gennemført aktiviteten i overensstemmelse med de kriterier læreren har opsat.

Vises der et markeringsfelt med fuldt optrukket ramme, skal du selv markere når du mener at du har gennemført aktiviteten. (Tryk på markeringen igen, hvis du ombestemmer dig).';
$string['completionmenuitem'] = 'Gennemførelse';
$string['completionnotenabled'] = 'Gennemførelse er ikke slået til';
$string['completionnotenabledforcourse'] = 'Gennemførelse er ikke slået til på dette kursus';
$string['completionnotenabledforsite'] = 'Gennemførelse er ikke slået til på denne hjemmeside';
$string['completionondate'] = 'Dato';
$string['completionondatevalue'] = 'Dato for hvornår kurset markeres som gennemført';
$string['completionpassgrade'] = 'Kræver beståelseskarakter';
$string['completionpassgrade_desc'] = 'Beståelseskarakter';
$string['completionsettingslocked'] = 'Gennemførelsesindstillinger låst';
$string['completionupdated'] = 'Opdateret gennemførelse for aktiviteten <b>{$a}</b>';
$string['completionusegrade'] = 'Kræv bedømmelse.';
$string['completionusegrade_desc'] = 'Få en karakter';
$string['completionview_desc'] = 'Se aktiviteten';
$string['configenablecompletion'] = 'Er indstillingen aktiveret, kan der oprettes betingelser for kursus- og aktivitetsgennemførelse. Det anbefales at sætte gennemførelsesbetingelser for aktiviteter således at meningsfulde data vises til brugerne i deres kursusoversigt på betjeningspanelet.';
$string['confirmselfcompletion'] = 'Bekræft selvregistrering af gennemførelse';
$string['courseaggregation'] = 'Betingelse kræver';
$string['courseaggregation_all'] = 'ALLE valgte kurser skal gennemføres';
$string['courseaggregation_any'] = 'ET af de valgte kurser skal gennemføres';
$string['coursealreadycompleted'] = 'Du har allerede gennemført dette kursus';
$string['coursecomplete'] = 'Kursus gennemført';
$string['coursecompleted'] = 'Kursus gennemført';
$string['coursecompletedmessage'] = '<p>Tillykke!</p><p>Du har gennemført kurset <a href="{$a->courselink}">{$a->coursename}</a>.</p>';
$string['coursecompletion'] = 'Kursusgennemførelse';
$string['coursecompletioncondition'] = 'Betingelse: {$a}';
$string['coursecompletionnavigation'] = 'Kursusfærdiggørelse tertiær navigation';
$string['coursecompletionsettings'] = 'Indstillinger for kursusfærdiggørelse';
$string['coursegrade'] = 'Kursuskarakter';
$string['coursesavailable'] = 'Tilgængelige kurser';
$string['coursesavailableexplaination'] = 'Bemærk: Betingelser for gennemførelse af kurset skal være klar, før kurset vises på ovenstående liste.';
$string['criteria'] = 'Kriterie';
$string['criteriagroup'] = 'Kriteriegruppe';
$string['criteriarequiredall'] = 'Alle kriterier herunder er påkrævet';
$string['criteriarequiredany'] = 'Et af kriterierne herunder er påkrævet';
$string['criteriasummary'] = '{$a->type}: {$a->summary}';
$string['csvdownload'] = 'Download i regnearksformat (UTF-8 .csv)';
$string['datepassed'] = 'Dato bestået';
$string['days'] = 'Dage';
$string['daysoftotal'] = '{$a->days} af {$a->total}';
$string['daystakingcourse'] = 'Dage på kursus';
$string['daysuntilcompletion'] = 'Tid indtil færdiggjort';
$string['defaultactivitycompletioncourse'] = 'Dette er standard-færdiggørelsesbetingelserne for aktiviteter i dette kursus.';
$string['defaultactivitycompletionsite'] = 'Dette er standard-færdiggørelsesbetingelserne for aktiviteter i alle kurser.';
$string['defaultcompletion'] = 'Standard aktivitetsgennemførelse';
$string['defaultcompletionupdated'] = 'Ændringer gemt';
$string['deletecompletiondata'] = 'Data om gennemførelse';
$string['dependencies'] = 'Afhængigheder';
$string['dependenciescompleted'] = 'Gennemførelse af andre kurser';
$string['detail_desc:receivegrade'] = 'Få en karakter';
$string['detail_desc:receivepassgrade'] = 'Få en bestået karakter';
$string['detail_desc:view'] = 'Se';
$string['done'] = 'Udført';
$string['editconditions'] = 'Rediger betingelser';
$string['emptyconditionsinfo'] = 'Der er ikke nogen færdiggørelsesbetingelser for denne aktivitet';
$string['emptyconditionswarning'] = 'Du skal tilføje mindst en færdiggørelsbetingelse.';
$string['enablecompletion'] = 'Aktiver registrering af gennemførelse';
$string['enablecompletion_help'] = 'Er indstillingen aktiveret, kan du stille betingelser for aktivitets- eller kursusgennemførelse.';
$string['enrolmentduration'] = 'Tilmeldingens varighed';
$string['enrolmentdurationlength'] = 'Brugeren skal forblive tilmeldt i';
$string['err_noactivities'] = 'Information om gennemførelse er ikke aktiveret på nogen af aktiviteterne, så der er intet at vise. Du kan slå information om gennemførelse til ved at redigere indstillingerne for en aktivitet.';
$string['err_nocourses'] = 'Kursusgennemførelse er ikke aktiveret på andre kurser, så der kan ikke vises noget. Du kan slå gennemførelse af kurser til i kursusindstillingerne.';
$string['err_nograde'] = 'Der er ikke sat nogen beståelseskarakter på dette kursus. Du skal oprette en hvis du vil aktivere denne type kriterie.';
$string['err_noroles'] = 'Der er ingen roller med rettigheden \'moodle/course:markcomplete\' på dette kursus';
$string['err_nousers'] = 'Der er ingen studerende på dette kursus eller i denne gruppe for hvem information om gennemførelse vises. (Information om gennemførelse vises kun for brugere med rettigheden "Be shown on completion reports". Rettigheden er kun tilladt for standardrollen studerende, så er der ingen studerende, vises denne besked.)';
$string['err_settingslocked'] = 'En eller flere studerende har allerede gennemført et kriterium, så indstillingerne er blevet låst. Hvis du låser indstillingerne op, slettes brugerens afslutningsdata, og det kan skabe forvirring.';
$string['err_system'] = 'Der opstod en intern fejl i gennemførelsessystemet. (Systemadministratorerne kan slå fejlretningsinformation til for at se flere oplysninger.)';
$string['eventcoursecompleted'] = 'Kursus gennemført';
$string['eventcoursecompletionupdated'] = 'Kursusgennemførelse opdateret';
$string['eventcoursemodulecompletionupdated'] = 'Gennemførelse af kursusaktivitet er opdateret';
$string['eventdefaultcompletionupdated'] = 'Standard for gennemførelse af kursusaktivitet opdateret';
$string['excelcsvdownload'] = 'Download i Excel-kompatibelt format (.csv)';
$string['failed'] = 'Mislykkedes';
$string['fraction'] = 'Brøkdel';
$string['graderequired'] = 'Påkrævet kursuskarakter';
$string['gradexrequired'] = '{$a} påkrævet';
$string['hiddenrules'] = 'Visse indstillinger specielt til <b>{$a}</b> er skjulte. Fravælg andre aktiviteter for at se dem.';
$string['incompatibleplugin'] = 'Denne aktivitet understøtter ikke standard færddiggørelsesindstillinger. Færdiggørelseskriteries skal sættes manuelt hvor agang aktiviteten anvendens.';
$string['inprogress'] = 'Igangværende';
$string['manual'] = 'Manuelt';
$string['manualcompletionby'] = 'Manuel gennemførelse af andre';
$string['manualcompletionbynote'] = 'Bemærk: Rettigheden \'moodle/course:markcomplete\' skal være tilladt, for at en rolle kan blive vist på listen';
$string['manualselfcompletion'] = 'Manuel selvregistrering af gennemførelse';
$string['manualselfcompletionnote'] = 'Bemærk: Blokken selvgennemførelse skal føjes til kurset, hvis manuel selvgennemførelse er slået til.';
$string['markcomplete'] = 'Marker som gennemført';
$string['markedcompleteby'] = 'Markeret som gennemført af {$a}';
$string['markingyourselfcomplete'] = 'Marker dig selv som gennemført';
$string['modifybulkactions'] = 'Rediger de handlinger du samlet vil ændre';
$string['moredetails'] = 'Flere oplysninger';
$string['nocriteriaset'] = 'Der er ingen kriterier for gennemførelse på dette kursus.';
$string['nogradeitem'] = 'Kræv karakter kan ikke aktiveres for <b>{$a}</b> da aktiviteten ikke er vurderet.';
$string['notcompleted'] = 'Ikke gennemført';
$string['notenroled'] = 'Du er ikke tilmeldt dette kursus';
$string['nottracked'] = 'For øjeblikket registreres din progression ikke på dette kursus';
$string['notyetstarted'] = 'Ikke begyndt endnu';
$string['overallaggregation'] = 'Krav for gennemførelse';
$string['overallaggregation_all'] = 'Kurset er gennemført, når ALLE betingelser er opfyldt';
$string['overallaggregation_any'] = 'Kurset er gennemført når en af betingelserne er opfyldt';
$string['pending'] = 'Behandles';
$string['periodpostenrolment'] = 'Indskrivningsperiode';
$string['privacy:metadata:completionstate'] = 'Aktiviteten er gennemført';
$string['privacy:metadata:course'] = 'En kursusidentifikator';
$string['privacy:metadata:coursecompletedsummary'] = 'Gemmer oplysninger om brugere, der har opfyldt kriterier i et kursus.';
$string['privacy:metadata:coursemoduleid'] = 'Aktivitets-ID\'et';
$string['privacy:metadata:coursemodulesummary'] = 'Gemmer aktivitetsfærdiggørelsesdata for en bruger';
$string['privacy:metadata:coursesummary'] = 'Gemmer data om kursusgennemførelse for en bruger.';
$string['privacy:metadata:gradefinal'] = 'Endelig karakter modtaget for kursusgennemførelse.';
$string['privacy:metadata:overrideby'] = 'Bruger-ID\'et på den person, der tilsidesatte aktivitetsgennemførelsen.';
$string['privacy:metadata:reaggregate'] = 'Hvis kursusgennemførelsen blev reaggreegeret.';
$string['privacy:metadata:timecompleted'] = 'Tidspunktet, hvor kurset blev gennemført.';
$string['privacy:metadata:timecreated'] = 'Tidspunktet, hvor aktivitetsgennemførelsen blev oprettet.';
$string['privacy:metadata:timeenrolled'] = 'Tidspunktet, hvor brugeren blev tilmeldt kurset.';
$string['privacy:metadata:timemodified'] = 'Tidspunktet, hvor aktivitetsgennemførelsen blev ændret.';
$string['privacy:metadata:timestarted'] = 'Tidspunktet, hvor kurset blev påbegyndt.';
$string['privacy:metadata:unenroled'] = 'Hvis brugeren er blevet afmeldt fra kurset.';
$string['privacy:metadata:userid'] = 'Bruger-ID\'et på den person med data om kursus- og aktivitetsgennemførelse.';
$string['privacy:metadata:viewed'] = 'Hvis aktiviteten blev set';
$string['progress'] = 'Studerendes fremskridt';
$string['progress-title'] = '{$a->user}, {$a->activity}: {$a->state} {$a->date}';
$string['progresstotal'] = 'Progression: {$a->complete} / {$a->total}';
$string['recognitionofpriorlearning'] = 'Meritoverførsel';
$string['remainingenroledfortime'] = 'Vedbliv med at være tilmeldt i et specifikt tidsrum';
$string['remainingenroleduntildate'] = 'Vedbliv med at være tilmeldt indtil en bestemt dato';
$string['reportpage'] = 'Viser brugere {$a->from} til {$a->to} af {$a->total}.';
$string['requiredcriteria'] = 'Påkrævede kriterier';
$string['resetactivities'] = 'Fravælg alle aktiviteter og materialer';
$string['restoringcompletiondata'] = 'Skriver gennemførelsesdata';
$string['roleaggregation'] = 'Betingelse kræver';
$string['roleaggregation_all'] = 'ALLE valgte roller at bedømme når betingelsen er opfyldt';
$string['roleaggregation_any'] = 'En hvilken som helst rolle at bedømme, når betingelsen er opfyldt';
$string['roleidnotfound'] = 'Rolle-id {$a} ikke fundet';
$string['saved'] = 'Gemt';
$string['seedetails'] = 'Se detaljer';
$string['select'] = 'Vælg';
$string['self'] = 'Selv';
$string['selfcompletion'] = 'Selvregistrering af gennemførelse';
$string['showcompletionconditions'] = 'Vis betingelser for afslutning af aktiviteter';
$string['showcompletionconditions_help'] = 'Vis betingelser for aktivitetens gennemførelse på kursussiden.';
$string['showinguser'] = 'Viser bruger';
$string['studentsmust'] = 'Studerende skal';
$string['timecompleted'] = 'Tiden er gennemført';
$string['todo'] = 'To do';
$string['unenrolingfromcourse'] = 'Udmeldes af kurset';
$string['unenrolment'] = 'Framelding';
$string['unit'] = 'Enhed';
$string['unlockcompletion'] = 'Lås op for indstillinger for gennemførelse';
$string['unlockcompletiondelete'] = 'Lås op for indstillinger for gennemførelse og slet brugerens gennemførselsdata';
$string['updateactivities'] = 'Opdater gennemførelsesstatus for de valgte aktiviteter';
$string['usealternateselector'] = 'Brug den alternative kursusvælger';
$string['usernotenroled'] = 'Brugeren er ikke tilmeldt dette kursus';
$string['viewcoursereport'] = 'Vis kursusrapport';
$string['viewingactivity'] = 'Viser {$a}';
$string['withconditions'] = 'Med betingelser';
$string['writingcompletiondata'] = 'Skriver gennemførelsesdata';
$string['xdays'] = '{$a} dage';
$string['youmust'] = 'Du skal';
