<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_oauth2', language 'da', version '5.1'.
 *
 * @package     auth_oauth2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accountexists'] = 'En bruger eksisterer allerede på dette websted med dette brugernavn. Hvis det er din konto skal du logge ind og tilføje det som et linket login via din indstillingsside.';
$string['alreadylinked'] = 'Denne eksterne konto er allerede linket til en konto på dette websted';
$string['auth_oauth2description'] = 'OAuth 2-standardbaseret godkendelse';
$string['auth_oauth2settings'] = 'Godkendelsesindstillinger for OAuth 2';
$string['confirmaccountemail'] = 'Hej {$a->firstname},

En ny konto er blevet anmodet om på \'{$a->sitename}\'
ved brug af din e-mailadresse.

For at bekræfte din nye konto, skal du gå til denne webadresse:

{$a->link}

I de fleste mailprogrammer bør dette fremstå som et blåt link,
som du blot kan klikke på. Hvis det ikke virker,
så kopier og indsæt adressen i adressefeltet
øverst i din webbrowser.

Hvis du har brug for hjælp, bedes du kontakte sidens administrator,
{$a->admin}

Hvis det ikke var dig, der anmodede om dette, kan nogen have forsøgt at kompromittere din konto.
Kontakt venligst websitetsadministrator med det samme.';
$string['confirmaccountemailsubject'] = '{$a}: kontobekræftelse';
$string['confirmationinvalid'] = 'Bekræftelseslinket er enten ugyldigt eller udløbet. Start loginprocessen igen for at få en ny bekræftelsesmail.';
$string['confirmationpending'] = 'Denne konto afventer e-mailbekræftelse.';
$string['confirmlinkedloginemail'] = 'Hej {$a->firstname},

Der er blevet anmodet om at linke {$a->issuername} login
{$a->linkedemail} til din konto på \'{$a->sitename}\'
ved brug af din e-mailadresse.

For at bekræfte denne anmodning og linke disse logins, skal du gå til denne webadresse:

{$a->link}

I de fleste mailprogrammer bør dette fremstå som et blåt link,
som du blot kan klikke på. Hvis det ikke virker,
så kopier og indsæt adressen i adressefeltet
øverst i din webbrowser.

Hvis du har brug for hjælp, bedes du kontakte sidens administrator,
{$a->admin}

Hvis det ikke var dig, der anmodede om dette, kan nogen have forsøgt at kompromittere din konto.
Kontakt venligst websitets administrator med det samme.';
$string['confirmlinkedloginemailsubject'] = '{$a}: bekræftelse af sammenkædet login';
$string['createaccountswarning'] = 'Dette godkendelsesplugin tillader brugere at oprette konti på dit websted. Du vil måske aktivere indstillingen "Undgå kontooprettelse under godkendelse" (authpreventaccountcreation) hvis du bruger plugin\'et.';
$string['createnewlinkedlogin'] = 'Link en ny konto ({$a})';
$string['emailconfirmlink'] = 'Link til dine konti';
$string['emailconfirmlinksent'] = '<p>Der er fundet en konto med denne e-mailadresse, men den er endnu ikke linket.</p>
<p>Kontiene skal linkes inden du kan logge ind.</p>
<p>En e-mail skulle være sendt til din adresse på <b>{$a}</b>.</p>
<p>Den indeholder anvisninger på, hvordan du linker dine konti.</p>
<p>Hvis du har problemer kan du kontakte webadministratoren.</p>';
$string['emailpasswordchangeinfo'] = 'Hej {$a->firstname}

Nogen (sikkert dig selv) har spurgt efter en ny adgangskode for din konto på siden "{$a->sitename}".

Din adgangskode kan imidlertid ikke ændres da du bruger din konto på et andet site til login.

Log ind som før ved brug af linket på login-siden.
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Skift adgangskode';
$string['info'] = 'Ekstern konto';
$string['issuer'] = 'OAuth 2-service';
$string['issuernologin'] = 'Denne issuer kan ikke bruges til at logge ind';
$string['key'] = 'Key';
$string['linkedlogins'] = 'Linkede logins';
$string['linkedloginshelp'] = 'Hjælp til linkede logins';
$string['loggedin'] = 'Bruger blev godkendt med udbyderen.';
$string['loginerror_authenticationfailed'] = 'Godkendelsesprocessen fejlede.';
$string['loginerror_cannotcreateaccounts'] = 'Der blev ikke fundet en konto med din e-mailadresse.';
$string['loginerror_invaliddomain'] = 'E-mailadressen tillades ikke på dette websted.';
$string['loginerror_nouserinfo'] = 'Ingen brugerinformation blev returneret. OAuth 2-servicen kan være konfigureret forkert.';
$string['loginerror_userincomplete'] = 'Den returnerede brugerinformation indeholder ikke brugernavn og e-mailadresse. OAuth 2-servicen kan være konfigureret forkert.';
$string['noconfiguredidps'] = 'Der er ingen konfigurerede OAuth2-udbydere.';
$string['noissuersavailable'] = 'Ingen af de konfigurerede OAuth 2-tjenester giver dig mulighed for at sammenkoble login-konti.';
$string['notenabled'] = 'Beklager, OAuth 2-godkendelse er ikke aktiveret';
$string['notloggedindebug'] = 'Loginforsøget fejlede. Årsag: {$a}';
$string['notwhileloggedinas'] = 'Linkede login kan ikke håndteres mens man er logget ind som en anden bruger.';
$string['oauth2:managelinkedlogins'] = 'Håndter egne linkede loginkonti';
$string['plugindescription'] = 'Dette godkendelsesplugin viser en liste over opsatte identitetsleverandører på loginsiden. Valg af identitetsleverandør tillader brugere at logge ind med deres brugeroplysninger fra en OAuth 2-leverandør.';
$string['pluginname'] = 'OAuth 2';
$string['privacy:metadata:auth_oauth2'] = 'OAuth 2-godkendelse';
$string['privacy:metadata:auth_oauth2:authsubsystem'] = 'Dette plugin er forbundet til godkendelsessubsystemet.';
$string['privacy:metadata:auth_oauth2:confirmtoken'] = 'Confirmation-token';
$string['privacy:metadata:auth_oauth2:confirmtokenexpires'] = 'Tidspunktet hvor confirmation-token udløber';
$string['privacy:metadata:auth_oauth2:email'] = 'Den eksterne e-mail, der er knyttet til denne konto.';
$string['privacy:metadata:auth_oauth2:issuerid'] = 'ID\'et på OAuth 2-udstederen for dette OAuth 2-login';
$string['privacy:metadata:auth_oauth2:tableexplanation'] = 'OAuth 2-konti knyttet til en brugers Moodle-konto.';
$string['privacy:metadata:auth_oauth2:timecreated'] = 'Tidsstempel for, hvornår brugerkontoen blev knyttet til OAuth 2-loginet.';
$string['privacy:metadata:auth_oauth2:timemodified'] = 'Tidsstempel for, hvornår denne post blev ændret.';
$string['privacy:metadata:auth_oauth2:userid'] = 'ID\'et på brugerkontoen, som OAuth 2-loginet er knyttet til.';
$string['privacy:metadata:auth_oauth2:usermodified'] = 'ID\'et på brugeren, der ændrede denne konto.';
$string['privacy:metadata:auth_oauth2:username'] = 'Det eksterne brugernavn, der er knyttet til denne konto.';
$string['testidplogin'] = 'Test login med:';
$string['userinfo'] = 'Brugerdata fra udbyder';
$string['value'] = 'Værdi';
